/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/mdc/p13n/subcontroller/FilterController','sap/ui/core/library','sap/ui/mdc/p13n/FlexUtil','sap/ui/Device','sap/ui/mdc/Control','sap/base/Log','sap/base/util/merge','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/ui/mdc/condition/ConditionModel','sap/ui/mdc/condition/Condition','sap/ui/mdc/util/IdentifierUtil','sap/ui/mdc/condition/ConditionConverter',"sap/ui/mdc/p13n/StateUtil","sap/ui/mdc/condition/FilterConverter","sap/ui/mdc/util/FilterUtil","sap/ui/mdc/filterbar/PropertyHelper","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/m/library","sap/m/Button",'sap/m/MessageBox',"sap/ui/core/ShortcutHintsMixin"],function(F,c,a,D,C,L,m,M,b,d,e,I,f,S,g,h,P,j,l,B,k,n){"use strict";var V=c.ValueState;var o=C.extend("sap.ui.mdc.filterbar.FilterBarBase",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/filterbar/FilterBarBase.designtime",defaultAggregation:"filterItems",interfaces:["sap.ui.mdc.IFilter","sap.ui.mdc.IxState"],properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/FilterBarDelegate",payload:{modelName:undefined,collectionName:""}}},liveMode:{type:"boolean",defaultValue:false},showMessages:{type:"boolean",group:"Misc",defaultValue:true},showGoButton:{type:"boolean",defaultValue:true},filterConditions:{type:"object",defaultValue:{}},suspendSelection:{type:"boolean",defaultValue:false},_filterCount:{type:"string",visibility:"hidden"}},aggregations:{filterItems:{type:"sap.ui.mdc.FilterField",multiple:true},basicSearchField:{type:"sap.ui.mdc.FilterField",multiple:false},layout:{type:"sap.ui.mdc.filterbar.IFilterContainer",multiple:false,visibility:"hidden"}},associations:{variantBackreference:{type:"sap.ui.fl.variants.VariantManagement",multiple:false}},events:{search:{conditions:{type:"object"}},filtersChanged:{conditionsBased:{type:"boolean"},filtersText:{type:"string"},filtersTextExpanded:{type:"string"}}}}});var p=l.ButtonType;o.INNER_MODEL_NAME="$sap.ui.filterbar.mdc.FilterBarBase";o.CONDITION_MODEL_NAME="$filters";var E={NoError:-1,RequiredHasNoValue:0,FieldInErrorState:1,AsyncValidation:2};o.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._createInnerModel();this._oObserver=new b(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["filterItems","basicSearchField"]});this._createInnerLayout();this._bPersistValues=false;this._fResolveInitialFiltersApplied=undefined;this._oInitialFiltersAppliedPromise=new Promise(function(r){this._fResolveInitialFiltersApplied=r;}.bind(this));this._bIgnoreChanges=false;this._bSearchTriggered=false;this._bIgnoreQueuing=false;};o.prototype._createInnerLayout=function(){this._cLayoutItem=null;this._oFilterBarLayout=null;this._bPersistValues=false;this._btnAdapt=null;this.setAggregation("layout",this._oFilterBarLayout,true);};o.prototype._isPhone=function(){return(D.system.phone)?true:false;};o.prototype._isLiveMode=function(){if(this._isPhone()){return false;}return this.getLiveMode();};o.prototype._getConditionModel=function(){return this._oConditionModel;};o.prototype._getSearchButton=function(){if(!this._btnSearch){this._btnSearch=new B(this.getId()+"-btnSearch",{text:this._oRb.getText("filterbar.GO"),press:this.onSearch.bind(this),type:p.Emphasized});n.addConfig(this._btnSearch,{addAccessibilityLabel:true,message:this._oRb.getText("filterbar.GoBtnShortCutHint")},this);}return this._btnSearch;};o.prototype.getConditionModelName=function(){return this._getConditionModelName();};o.prototype._getConditionModelName=function(){return o.CONDITION_MODEL_NAME;};o.prototype._createConditionModel=function(){this._oConditionModel=new d();this.setModel(this._oConditionModel,this._getConditionModelName());};o.prototype.applySettings=function(s,i){C.prototype.applySettings.apply(this,arguments);this._createConditionModel();this._oConditionModel.attachPropertyChange(this._handleConditionModelPropertyChange,this);this._retrieveMetadata().then(function(){this._applyInitialFilterConditions();}.bind(this));};o.prototype.setIgnoreQueuing=function(v){this._bIgnoreQueuing=v;};o.prototype.getIgnoreQueuing=function(){return this._bIgnoreQueuing;};o.prototype.setSuspendSelection=function(v){this.setProperty("suspendSelection",v);if(!v){if(this._bSearchTriggered&&!this.getIgnoreQueuing()){this.triggerSearch();}this._bSearchTriggered=false;this.setIgnoreQueuing(false);}return this;};o.prototype._createInnerModel=function(){this._oModel=new M(this);this.setModel(this._oModel,o.INNER_MODEL_NAME);return this;};o.prototype.getCurrentState=function(){var s={};if(this._bPersistValues){var i=[];var q=m({},this.getFilterConditions());for(var K in q){if(!this._getPropertyByName(K)){i.push(K);}}i.forEach(function(K){delete q[K];});s.filter=q;}var r=this.getFilterItems();var t=[];r.forEach(function(u,v){t.push({name:u.getFieldPath()});});s.items=t;return s;};o.prototype.getAssignedFilterNames=function(){var N,i=null,q=this._getConditionModel();if(q){i=[];var r=q.getConditions("$search");if(r&&r.length>0){i.push(this._oRb.getText("filterbar.ADAPT_SEARCHTERM"));}this._getNonHiddenPropertyInfoSet().forEach(function(s){N=I.getPropertyKey(s);var r=q.getConditions(N);if(r&&r.length>0){i.push(s.label||N);}});}return i;};o.prototype._getAssignedFiltersText=function(){var t={};t.filtersText=this._getAssignedFiltersCollapsedText(this.getAssignedFilterNames());t.filtersTextExpanded=this._getAssignedFiltersExpandedText();return t;};o.prototype._getAssignedFiltersExpandedText=function(){var i=0,q=0,r=this._getConditionModel();if(r){var A=r.getAllConditions();for(var s in A){var t=this._getPropertyByName(s);if(t&&!t.hiddenFilter&&(A[s].length>0)){++i;if(!(((s==="$search")&&this.getAggregation("basicSearchField"))||this._getFilterField(s))){++q;}}}}if(!i&&!q){return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");}if(!q){if(i===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_NON_HIDDEN",[i]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_NON_HIDDEN",[i]);}if((i===1)){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_HIDDEN",[i,q]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_HIDDEN",[i,q]);};o.prototype._getAssignedFiltersCollapsedText=function(q){var A;q=q||[];if(q.length){A=Object.keys(q).map(function(i){return q[i];}).join(", ");if(q.length===1){return this._oRb.getText("filterbar.ADAPT_FILTER_COLLAPSED",[q.length,A]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_COLLAPSED",[q.length,A]);}return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");};o.prototype.getAssignedFiltersText=function(){return this._getAssignedFiltersText();};o.prototype._reportModelChange=function(t,i){this._handleAssignedFilterNames(false,i);if(this.getLiveMode()||t){this.triggerSearch();}};o.prototype._isPersistenceSupported=function(i){return this.getEngine().isModificationSupported(this);};o.prototype._handleConditionModelPropertyChange=function(i){if(!this._bIgnoreChanges){var s=i.getParameter("path");if(s.indexOf("/conditions/")===0){var q=s.substring("/conditions/".length);if(this._bPersistValues&&this._isPersistenceSupported()){var O={};O[q]=this._stringifyConditions(q,m([],i.getParameter("value")));this._cleanupConditions(O[q]);var r=this.getEngine().createChanges({control:this,key:"Filter",state:O});if(!this._aCollectedChangePromises){this._aCollectedChangePromises=[];}this._aCollectedChangePromises.push(r);}else{this._reportModelChange(false);}}}};o.prototype._toExternal=function(i,q){var r=m({},q);r=f.toString(r,i.typeConfig,this.getTypeUtil());this._cleanupCondition(r);this._convertInOutParameters(q,r,"inParameters",f.toString);this._convertInOutParameters(q,r,"outParameters",f.toString);return r;};o.prototype._toInternal=function(i,q){var r=m({},q);r=f.toType(r,i.typeConfig,this.getTypeUtil());this._convertInOutParameters(q,r,"inParameters",f.toType);this._convertInOutParameters(q,r,"outParameters",f.toType);return r;};o.prototype._convertInOutParameters=function(i,q,s,r){if(i[s]&&(Object.keys(i[s]).length>0)){Object.keys(i[s]).forEach(function(K){var N=K.startsWith("conditions/")?K.slice(11):K;var t=this._getPropertyByName(N);if(t){var O=e.createCondition("EQ",[i[s][K]]);var v=r(O,t.typeConfig,this.getTypeUtil());if(!q[s]){q[s]={};}if(!K.startsWith("conditions/")){delete q[s][K];K="conditions/"+N;}q[s][K]=v.values[0];}else{L.error("mdc.FilterBar._convertInOutParameters: could not find property info for "+N);}}.bind(this));}};o.prototype._cleanupCondition=function(i){if(i){if(i.hasOwnProperty("isEmpty")){delete i.isEmpty;}}};o.prototype._cleanupConditions=function(i){if(i){i.forEach(function(q){this._cleanupCondition(q);},this);}};o.prototype._stringifyCondition=function(i,q){var r=q;if(q&&q.values){if(q.values.length>0){r=this._toExternal(i,q);}else{r=m({},q);this._cleanupCondition(r);}}return r;};o.prototype._stringifyConditions=function(s,i){var q=this._getPropertyByName(s);var r=i;if(q&&i){r=[];i.forEach(function(t){r.push(this._stringifyCondition(q,t));},this);}return r;};o.prototype._handleAssignedFilterNames=function(i,q){if(!this._oMetadataAppliedPromise){return;}this._oMetadataAppliedPromise.then(function(){if(this._bIsBeingDestroyed){return;}if(!i){if(this._btnAdapt){var r=this.getAssignedFilterNames();this.setProperty("_filterCount",this._oRb.getText(r.length?"filterbar.ADAPT_NONZERO":"filterbar.ADAPT",r.length),false);}}var t=this._getAssignedFiltersText();var O={conditionsBased:(!i&&!q),filtersText:t.filtersText,filtersTextExpanded:t.filtersTextExpanded};this.fireFiltersChanged(O);}.bind(this));};o.prototype.onReset=function(i){this._getConditionModel().oConditionModel.removeAllConditions();};o.prototype.onSearch=function(i){if(!this._bSearchPressed){this._bSearchPressed=true;this.triggerSearch().then(function(){this._bSearchPressed=false;}.bind(this),function(){this._bSearchPressed=false;}.bind(this));}};o.prototype.triggerSearch=function(){if(this.getSuspendSelection()){this._bSearchTriggered=true;return Promise.resolve();}return this.validate().then(function(){this.fireSearch();}.bind(this));};o.prototype.validate=function(){return this.initialized().then(function(){if(!this._oValidationPromise){this._oValidationPromise=new Promise(function(r,q){this._fResolvedSearchPromise=r;this._fRejectedSearchPromise=q;}.bind(this));var i=function(){this._validate();this._oValidationPromise=null;};setTimeout(i.bind(this),0);}return this._oValidationPromise;}.bind(this));};o.prototype._clearDelayedSearch=function(){if(this._iDelayedSearchId){clearTimeout(this._iDelayedSearchId);this._iDelayedSearchId=null;}};o.prototype._getRequiredFieldsWithoutValues=function(){var r=[];this._getRequiredPropertyNames().forEach(function(N){var i=this._getConditionModel().getConditions(N);if(!i||i.length===0){r.push(N);}}.bind(this));return r;};o.prototype._checkAsyncValidation=function(){var r=E.NoError;if(this._aFIChanges&&this._aFIChanges.length>0){r=E.AsyncValidation;}return r;};o.prototype._checkRequiredFields=function(){var r=E.NoError;var R=this._getRequiredFieldsWithoutValues();R.forEach(function(N){var i=this._getFilterField(N);if(i){if(i.getValueState()===V.None){i.setValueState(V.Error);i.setValueStateText(this._oRb.getText("filterbar.REQUIRED_FILTER_VALUE_MISSING"));}}else{L.error("Mandatory filter field '"+N+"' not visible on FilterBarBase has no value.");}r=E.RequiredHasNoValue;}.bind(this));return r;};o.prototype._checkFieldsInErrorState=function(){var r=E.NoError;this._getNonRequiredPropertyNames().some(function(N){var i=this._getFilterField(N);if(i&&(i.getValueState()!==V.None)){r=E.FieldInErrorState;}return r!==E.NoError;}.bind(this));return r;};o.prototype._handleFilterItemSubmit=function(i){var q=i.getParameter("promise");if(q){q.then(function(){if(this._aCollectedChangePromises&&this._aCollectedChangePromises.length>0){var r=this._aCollectedChangePromises.slice();Promise.all(r).then(function(){this.triggerSearch();}.bind(this));}else{this.triggerSearch();}}.bind(this)).catch(function(r){L.error(r);});}};o.prototype._handleFilterItemChanges=function(i){if(this._bIgnoreChanges){return;}var q=i.oSource;if(q.getRequired()&&(q.getValueState()===V.Error)&&i.getParameter("valid")){q.setValueState(V.None);return;}if(!this._aFIChanges){this._aFIChanges=[];}this._aFIChanges.push({name:q.getFieldPath(),promise:i.getParameter("promise")});};o.prototype._checkFilters=function(){var r=this._checkAsyncValidation();if(r!==E.NoError){return r;}r=this._checkRequiredFields();if(r!==E.NoError){return r;}r=this._checkFieldsInErrorState();if(r!==E.NoError){return r;}return r;};o.prototype._setFocusOnFirstErroneousField=function(){var i=null;this.getFilterItems().some(function(q){if(q.getValueState()!==V.None){i=q;setTimeout(q["focus"].bind(q),0);}return i!=null;});return i;};o.prototype._handleAsyncValidation=function(){if(this._aFIChanges&&(this._aFIChanges.length>0)){var N=this._aFIChanges.slice();this._aFIChanges=null;var i=[];N.forEach(function(q){i.push(q.promise);});Promise.all(i).then(function(q){q.forEach(function(r,s){var t=this._getFilterField(N[s].name);if(t&&t.getRequired()&&(t.getValueState()===V.Error)){t.setValueState(V.None);}},this);this._validate();}.bind(this),function(q){this._validate();}.bind(this));}};o.prototype._waitForChangeAppliance=function(){var i=this._aCollectedChangePromises.slice();this._aCollectedChangePromises=null;Promise.all(i).then(function(q){this._validate();}.bind(this),function(q){this._validate();}.bind(this));};o.prototype._validate=function(){var s,r;var i=function(){this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null;}.bind(this);if(this.bIsDestroyed){i();return;}r=this._checkFilters();if(r===E.AsyncValidation){this._handleAsyncValidation();return;}if(this._aCollectedChangePromises&&(this._aCollectedChangePromises.length>0)){this._waitForChangeAppliance();return;}if(r===E.NoError){if(this._isChangeApplying()){this._oFlexPromise.then(function(){this._fResolvedSearchPromise();i();}.bind(this));}else{this._fResolvedSearchPromise();i();}}else{if(r===E.RequiredHasNoValue){s=this._oRb.getText("filterbar.REQUIRED_CONDITION_MISSING");}else{s=this._oRb.getText("filterbar.VALIDATION_ERROR");}if(this.getShowMessages()&&!this._isLiveMode()){try{k.error(s,{styleClass:(this.$()&&this.$().closest(".sapUiSizeCompact").length)?"sapUiSizeCompact":"",onClose:this._setFocusOnFirstErroneousField.bind(this)});}catch(x){L.error(x.message);}}else{L.warning("search was not triggered. "+s);}this._fRejectedSearchPromise();i();}};o.prototype.setInternalConditions=function(i){var q=this._getConditionModel();if(q){q.setConditions(i);}};o.prototype.getInternalConditions=function(){return this._getModelConditions(this._getConditionModel(),true);};o.prototype.hasProperty=function(N){return this._getPropertyByName(N);};o.prototype.waitForInitialization=function(){return Promise.all([this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise]);};o.prototype.initialized=function(){return this.waitForInitialization();};o.prototype._getModelConditions=function(i,q,K){var r={};if(i){var A=m({},i.getAllConditions());for(var s in A){if(A[s]&&(K||A[s].length>0)){r[s]=A[s];if(!q){this._cleanupConditions(r[s]);var t=this._stringifyConditions(s,r[s]);r[s]=t;}}}}return r;};var _=function(i){var t=i.typeConfig.typeInstance;var q=t.getConstraints();return t.getMetadata().getName()==="sap.ui.model.odata.type.String"&&q&&q.isDigitSequence&&q.maxLength?function(r){return this._toExternal(i,r,this.getTypeUtil());}.bind(this):undefined;};o.prototype.removeCondition=function(s,x){return this.initialized().then(function(){var i=this._getConditionModel();if(i){var q=this._getPropertyByName(s);if(q){var r=this._toInternal(q,x);if(i.indexOf(s,r,_.call(this,q))>=0){i.removeCondition(s,r);}}}}.bind(this));};o.prototype.addCondition=function(s,x){return this.initialized().then(function(){var i=this._getConditionModel();if(i){var q=this._getPropertyByName(s);if(q){var r=this._toInternal(q,x);if(i.indexOf(s,r,_.call(this,q))<0){var t={};t[s]=[r];F.checkConditionOperatorSanity(t);var u=t[s];if(u&&u.length>0){this._cleanUpFilterFieldInErrorStateByName(s);i.addCondition(s,r);}}}}}.bind(this));};o.prototype._setXConditions=function(i,r){var q,s,t=this._getConditionModel();if(r){t.removeAllConditions();}if(i){for(var u in i){s=i[u];q=this._getPropertyByName(u);if(q){if(s.length===0){t.removeAllConditions(u);}else{s.forEach(function(v){if(q.maxConditions!==-1){t.removeAllConditions(u);}var N=this._toInternal(q,v);t.addCondition(u,N);}.bind(this));}}}}};o.prototype._getXConditions=function(){return this._getModelConditions(this._getConditionModel(),false);};o.prototype._getRequiredPropertyNames=function(){var r=[];this._getNonHiddenPropertyInfoSet().forEach(function(i){if(i.required){r.push(I.getPropertyKey(i));}});return r;};o.prototype._getNonRequiredPropertyNames=function(){var N=[];this._getNonHiddenPropertyInfoSet().forEach(function(i){if(!i.required){N.push(I.getPropertyKey(i));}});return N;};o.prototype._insertFilterFieldtoContent=function(i,q){if(!this._cLayoutItem){return;}var r=this._cLayoutItem;var s=new r();s.setFilterField(i);this._oFilterBarLayout.insertFilterField(s,q);};o.prototype._filterItemInserted=function(i){if(!i.getVisible()){return;}if(i.setWidth){i.setWidth("");}this._applyFilterItemInserted(i);this._handleAssignedFilterNames(true);};o.prototype._applyFilterItemInserted=function(q){var r,s;s=this.indexOfAggregation("filterItems",q);if(this.getAggregation("basicSearchField")){s++;}r=s;var t=this.getFilterItems();for(var i=0;i<r;i++){if(!t[i].getVisible()){s--;}}this._insertFilterFieldtoContent(q,s);if(!this._oObserver.isObserved(q,{properties:["visible"]})){this._oObserver.observe(q,{properties:["visible"]});}};o.prototype._filterItemRemoved=function(i){this._applyFilterItemRemoved(i.getFieldPath());this._handleAssignedFilterNames(true);};o.prototype._applyFilterItemRemoved=function(s){this._removeFilterFieldFromContentByName(s);};o.prototype._removeFilterFieldFromContent=function(i){this._removeFilterFieldFromContentByName(i.getFieldPath());};o.prototype._removeFilterFieldFromContentByName=function(s){var i=this._getFilterItemLayoutByName(s);if(i){this._oFilterBarLayout.removeFilterField(i);i.destroy();}};o.prototype._observeChanges=function(i){if(i.type==="aggregation"){if(i.name==="filterItems"){switch(i.mutation){case"insert":i.child.attachChange(this._handleFilterItemChanges,this);i.child.attachSubmit(this._handleFilterItemSubmit,this);this._filterItemInserted(i.child);break;case"remove":i.child.detachChange(this._handleFilterItemChanges,this);i.child.detachSubmit(this._handleFilterItemSubmit,this);this._filterItemRemoved(i.child);break;default:L.error("operation "+i.mutation+" not yet implemented");}}else if(i.name==="basicSearchField"){switch(i.mutation){case"insert":i.child.attachSubmit(this._handleFilterItemSubmit,this);this._insertFilterFieldtoContent(i.child,0);break;case"remove":i.child.detachSubmit(this._handleFilterItemSubmit,this);this._removeFilterFieldFromContent(i.child);break;default:L.error("operation "+i.mutation+" not yet implemented");}}}else if(i.type==="property"){var q;if(i.object.isA&&i.object.isA("sap.ui.mdc.FilterField")){q=i.object;if(q){if(i.current){this._filterItemInserted(q);}else{this._filterItemRemoved(q);}this._oFilterBarLayout.rerender();}}}};o.prototype._getFilterItemLayout=function(i){return this._getFilterItemLayoutByName(i.getFieldPath());};o.prototype._getFilterItemLayoutByName=function(s){var i=null;if(this._oFilterBarLayout){this._oFilterBarLayout.getFilterFields().some(function(q){if(q._getFieldPath()===s){i=q;}return i!==null;});}return i;};o.prototype._getFilterField=function(N){var i=null;this.getFilterItems().some(function(q){if(q&&q.getFieldPath&&(q.getFieldPath()===N)){i=q;}return i!==null;});return i;};o.prototype._retrieveMetadata=function(){if(this._oMetadataAppliedPromise){return this._oMetadataAppliedPromise;}this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=new Promise(function(r){this._fResolveMetadataApplied=r;}.bind(this));this.initControlDelegate().then(function(){if(!this._bIsBeingDestroyed){var r=function(){this._fResolveMetadataApplied();this._fResolveMetadataApplied=null;}.bind(this);if(this.bDelegateInitialized&&this.getControlDelegate().fetchProperties){this.initPropertyHelper(P).then(function(i){r();});}else{L.error("Provided delegate '"+this.getDelegate().path+"' not valid.");r();}}}.bind(this));return this._oMetadataAppliedPromise;};o.prototype.setBasicSearchField=function(i){var O=this.getAggregation("basicSearchField");if(O){this.removeAggregation("basicSearchField",O);}this.setAggregation("basicSearchField",i);if(i){if(!this._oObserver.isObserved(i,{properties:["visible"]})){this._oObserver.observe(i,{properties:["visible"]});}}return this;};o.prototype.getPropertyInfoSet=function(){try{var i=this.getPropertyHelper();return i?i.getProperties():[];}catch(q){return[];}};o.prototype._getNonHiddenPropertyInfoSet=function(){var v=[];this.getPropertyInfoSet().every(function(i){if(!i.hiddenFilter){if(I.getPropertyKey(i)!=="$search"){v.push(i);}}return true;});return v;};o.prototype._getNonHiddenPropertyByName=function(N){var i=null;this._getNonHiddenPropertyInfoSet().some(function(q){if(I.getPropertyKey(q)===N){i=q;}return i!=null;});return i;};o.prototype._getPropertyByName=function(N){return h.getPropertyByKey(this.getPropertyInfoSet(),N);};o.prototype._cleanUpFilterFieldInErrorStateByName=function(s){var i=null;var q=this.getFilterItems();q.some(function(r){if(r.getFieldPath()===s){i=r;}return i!=null;});if(i){this._cleanUpFilterFieldInErrorState(i);}};o.prototype._cleanUpAllFilterFieldsInErrorState=function(){var i=this.getFilterItems();i.forEach(function(q){this._cleanUpFilterFieldInErrorState(q);}.bind(this));};o.prototype._cleanUpFilterFieldInErrorState=function(i){if(i&&(i.getValueState()!==V.None)){i.setValueState(V.None);}};o.prototype.applyConditionsAfterChangesApplied=function(){if(this._isChangeApplying()){return;}this._bIgnoreChanges=true;this._oFlexPromise=this._getWaitForChangesPromise();Promise.all([this._oFlexPromise,this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise]).then(function(A){this._oFlexPromise=null;this._changesApplied();}.bind(this));};o.prototype._getWaitForChangesPromise=function(){return this.getEngine().waitForChanges(this);};o.prototype._suspendBinding=function(i){if(i){var q=i.getBinding("conditions");if(q){if(!this._aBindings){this._aBindings=[];}q.suspend();this._aBindings.push(i);}}};o.prototype._resumeBindings=function(){if(this._aBindings){this._aBindings.forEach(function(i){if(!i.bIsDestroyed){var q=i.getBinding("conditions");if(q){q.resume();}}});this._aBindings=null;}};o.prototype._isChangeApplying=function(){return!!this._oFlexPromise;};o.prototype._applyInitialFilterConditions=function(){this._bIgnoreChanges=true;this._applyFilterConditionsChanges();this._changesApplied();this._bInitialFiltersApplied=true;this._fResolveInitialFiltersApplied();this._fResolveInitialFiltersApplied=null;};o.prototype._applyFilterConditionsChanges=function(){var i;var s=this.getProperty("filterConditions");if(Object.keys(s).length>0){i=m([],s);this._setXConditions(i,true,true);}};o.prototype.setVariantBackreference=function(v){if(!this._hasAssignedVariantManagement()){this.setAssociation("variantBackreference",v);j.attachVariantApplied({selector:this,vmControlId:this.getVariantBackreference(),callback:this._handleVariantSwitch.bind(this),callAfterInitialVariant:true});}else{L.error("the association 'variant' may only be assigned once and may not change afterwards.");}};o.prototype._handleVariantSwitch=function(v){this._cleanUpAllFilterFieldsInErrorState();this._bExecuteOnSelect=this._getExecuteOnSelectionOnVariant(v);this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=undefined;if(v.hasOwnProperty("createScenario")&&(v.createScenario==="saveAs")){this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=true;}if(!this._isChangeApplying()&&this._bInitialFiltersApplied){this._changesApplied();}};o.prototype._getExecuteOnSelectionOnVariant=function(v){var i=false,q=this._getAssignedVariantManagement();if(q){i=q.getApplyAutomaticallyOnVariant(v);}return i;};o.prototype._hasAssignedVariantManagement=function(){return this._getAssignedVariantManagement()?true:false;};o.prototype._getAssignedVariantManagement=function(){var v=this.getVariantBackreference();if(v){var i=sap.ui.getCore().byId(v);if(i&&i.isA("sap.ui.fl.variants.VariantManagement")){return i;}}return null;};o.prototype._changesApplied=function(){if(!this._isChangeApplying()){this._bIgnoreChanges=false;}this._reportModelChange(this._bExecuteOnSelect,this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch);this._bExecuteOnSelect=undefined;this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=undefined;};o.prototype._getView=function(){return I.getView(this);};o.prototype.getConditions=function(){var i=this._bPersistValues?this.getCurrentState().filter:this._getXConditions();if(i&&i["$search"]){delete i["$search"];}return i;};o.prototype.getSearch=function(){var s=this._getConditionModel()?this._getConditionModel().getConditions("$search"):[];return s[0]?s[0].values[0]:"";};o.prototype.exit=function(){if(this._hasAssignedVariantManagement()){j.detachVariantApplied({selector:this,vmControlId:this.getVariantBackreference()});}if(this.bDelegateInitialized&&this.getControlDelegate().cleanup){this.getControlDelegate().cleanup(this);}C.prototype.exit.apply(this,arguments);this._clearDelayedSearch();this._oFilterBarLayout=null;this._cLayoutItem=null;this._btnAdapt=undefined;this._btnSearch=undefined;this._oRb=null;if(this._oModel){this._oModel.destroy();this._oModel=null;}if(this._oConditionModel){this._oConditionModel.detachPropertyChange(this._handleConditionModelPropertyChange,this);this._oConditionModel.destroy();this._oConditionModel=null;}this._oObserver.disconnect();this._oObserver=undefined;this._bPersistValues=null;this._oDelegate=null;this._oFlexPromise=null;this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=null;this._oInitialFiltersAppliedPromise=null;this._oValidationPromise=null;this._aBindings=null;this._aFIChanges=null;this._aCollectedChangePromises=null;};return o;});
