/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../ChartDelegateNew","../../../util/loadModules","sap/ui/core/Core","sap/m/Text","sap/ui/mdc/library","sap/ui/mdc/odata/v4/ODataMetaModelUtil","sap/base/Log",'sap/ui/mdc/util/FilterUtil','sap/ui/mdc/odata/v4/util/DelegateUtil',"sap/ui/mdc/chartNew/ChartTypeButtonNew","sap/ui/mdc/chartNew/ItemNew","sap/ui/model/Sorter","sap/m/VBox","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/mdc/p13n/panels/ChartItemPanelNew"],function(V,l,C,T,M,O,L,F,D,c,d,S,f,g,R,h){"use strict";var m=Object.assign({},V);var s=new window.WeakMap();var n;var o;var p;var q;m._getState=function(a){if(s.has(a)){return s.get(a);}L.info("Couldn't get state for "+a.getId());};m._setState=function(a,b){s.set(a,b);};m._deleteState=function(a){if(this._getState(a).vizTooltip){this._getState(a).vizTooltip.destroy();}if(this._getState(a).observer){this._getState(a).observer.disconnect();this._getState(a).observer=null;}return s.delete(a);};m._getChart=function(a){if(s.has(a)){return s.get(a).innerChart;}L.info("Couldn't get state for "+a.getId());return undefined;};m._setChart=function(a,i){if(s.has(a)){s.get(a).innerChart=i;}else{s.set(a,{innerChart:i});}};m._getInnerStructure=function(a){if(s.has(a)){return s.get(a).innerStructure;}L.info("Couldn't get state for "+a.getId());return undefined;};m._setInnerStructure=function(a,i){if(s.has(a)){s.get(a).innerStructure=i;}else{s.set(a,{innerStructure:i});}};m._getBindingInfoFromState=function(a){if(s.has(a)){return s.get(a).bindingInfo;}L.info("Couldn't get state for "+a.getId());return undefined;};m._setBindingInfoForState=function(a,b){if(s.has(a)){s.get(a).bindingInfo=b;}else{s.set(a,{bindingInfo:b});}};m._setUpChartObserver=function(a){var b=this._getState(a);if(!b.observer){b.observer=new g(function(e){if(e.type==="destroy"){this.exit(e.object);}}.bind(this));}b.observer.observe(a,{destroy:true});};m.getFilterDelegate=function(){return{addItem:function(P,a){return Promise.resolve(null);}};};m.exit=function(a){if(this._getInnerStructure(a)){this._getInnerStructure(a).destroy();}this._deleteState(a);};m.zoomIn=function(a,v){this._getChart(a).zoom({direction:"in"});};m.zoomOut=function(a,v){this._getChart(a).zoom({direction:"out"});};m.getZoomState=function(a){if(this._getChart(a)){return this._getChart(a).getZoomInfo(this);}};m.getInnerChartSelectionHandler=function(a){return{eventId:"_selectionDetails",listener:this._getChart(a)};};m.getChartTypeLayoutConfig=function(){if(this._aChartTypeLayout){return this._aChartTypeLayout;}var a=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.category,M.ChartItemRoleType.series];var A=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.axis2,M.ChartItemRoleType.category,M.ChartItemRoleType.series];var b=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.category,M.ChartItemRoleType.category2];var e=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.axis2,M.ChartItemRoleType.axis3,M.ChartItemRoleType.category,M.ChartItemRoleType.series];this._aChartTypeLayout=[{key:"column",allowedLayoutOptions:a},{key:"bar",allowedLayoutOptions:a},{key:"line",allowedLayoutOptions:a},{key:"combination",allowedLayoutOptions:a},{key:"pie",allowedLayoutOptions:a},{key:"donut",allowedLayoutOptions:a},{key:"dual_column",allowedLayoutOptions:A},{key:"dual_bar",allowedLayoutOptions:A},{key:"dual_line",allowedLayoutOptions:A},{key:"stacked_bar",allowedLayoutOptions:a},{key:"scatter",allowedLayoutOptions:A},{key:"bubble",allowedLayoutOptions:e},{key:"heatmap",allowedLayoutOptions:b},{key:"bullet",allowedLayoutOptions:a},{key:"vertical_bullet",allowedLayoutOptions:a},{key:"dual_stacked_bar",allowedLayoutOptions:A},{key:"100_stacked_bar",allowedLayoutOptions:a},{key:"stacked_column",allowedLayoutOptions:a},{key:"dual_stacked_column",allowedLayoutOptions:A},{key:"100_stacked_column",allowedLayoutOptions:a},{key:"dual_combination",allowedLayoutOptions:A},{key:"dual_horizontal_combination",allowedLayoutOptions:A},{key:"dual_horizontal_combination",allowedLayoutOptions:A},{key:"dual_stacked_combination",allowedLayoutOptions:A},{key:"dual_horizontal_stacked_combination",allowedLayoutOptions:A},{key:"stacked_combination",allowedLayoutOptions:a},{key:"100_dual_stacked_bar",allowedLayoutOptions:a},{key:"100_dual_stacked_column",allowedLayoutOptions:a},{key:"horizontal_stacked_combination",allowedLayoutOptions:a},{key:"waterfall",allowedLayoutOptions:b},{key:"horizontal_waterfall",allowedLayoutOptions:b}];return this._aChartTypeLayout;};m.getAdaptionUI=function(a){var b=this.getChartTypeLayoutConfig().find(function(j){return j.key===a.getChartType();});if(!b){var e=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.axis2,M.ChartItemRoleType.axis3,M.ChartItemRoleType.category,M.ChartItemRoleType.category2,M.ChartItemRoleType.series];b={key:a.getChartType(),allowedLayoutOptions:e};}var i=[{kind:"Groupable"},{kind:"Aggregatable"}];b.templateConfig=i;var A={panelConfig:b};return Promise.resolve(new h(A));};m.setLegendVisible=function(a,v){if(this._getChart(a)){this._getChart(a).setVizProperties({'legend':{'visible':v},'sizeLegend':{'visible':v}});}else{L.error("Could not set legend visibility since inner chart is not yet initialized!");}};m.getSorterForItem=function(a,b){if(a.getType()==="aggregatable"){return new S(this._getAggregatedMeasureNameForMDCItem(a),b.descending);}else if(a.getType()==="groupable"){return new S(b.name,b.descending);}};m.insertItemToInnerChart=function(a,b,i){if(b.getType()==="groupable"){var e=this._getChart(a).getDimensionByName(b.getName());if(!e){this.createInnerDimension(a,b);}else{e.setLabel(b.getLabel());e.setRole(b.getRole()?b.getRole():"category");}var v=this._getChart(a).getVisibleDimensions();v.splice(i,0,b.getName());this._getChart(a).setVisibleDimensions(v);}else if(b.getType()==="aggregatable"){this.createInnerMeasure(a,b);var j=this._getChart(a).getVisibleMeasures();j.splice(i,0,this._getAggregatedMeasureNameForMDCItem(b));this._getChart(a).setVisibleMeasures(j);}this._prepareColoringForItem(b).then(function(){this._updateColoring(a,this._getChart(a).getVisibleDimensions(),this._getChart(a).getVisibleMeasures());}.bind(this));this.fetchProperties(b.getParent()).then(function(P){this._updateSemanticalPattern(a,P);}.bind(this));};m.removeItemFromInnerChart=function(a,b){if(b.getType()==="groupable"&&this._getChart(a).getVisibleDimensions().includes(b.getName())){var N=this._getChart(a).getVisibleDimensions().filter(function(e){return e!==b.getName();});if(a.getDelegate().inResultDimensions&&a.getDelegate().inResultDimensions instanceof Array){this._getChart(a).setInResultDimensions(a.getDelegate().inResultDimensions);}this._getChart(a).setVisibleDimensions(N);}else if(b.getType()==="aggregatable"&&this._getChart(a).getVisibleMeasures().includes(this._getAggregatedMeasureNameForMDCItem(b))){var i=this._getChart(a).getVisibleMeasures().filter(function(e){return e!==this._getAggregatedMeasureNameForMDCItem(b);}.bind(this));this._getChart(a).setVisibleMeasures(i);this._getChart(a).removeMeasure(this._getChart(a).getMeasureByName(this._getAggregatedMeasureNameForMDCItem(b)));}this._updateColoring(a,this._getChart(a).getVisibleDimensions(),this._getChart(a).getVisibleMeasures());this.fetchProperties(b.getParent()).then(function(P){this._updateSemanticalPattern(a,P);}.bind(this));};m.addItem=function(P,a,b,e){if(a.getModel){return Promise.resolve(this._createMDCChartItem(P,a,e));}return Promise.resolve(null);};m.removeItem=function(P,a){return Promise.resolve(true);};m._createMDCChartItem=function(P,a,b){return this.fetchProperties(a).then(function(e){var i=e.find(function(j){return j.name===P;});if(!i){return null;}if(i.groupable){return new d(a.getId()+"--GroupableItem--"+i.name,{name:i.name,label:i.label,type:"groupable",role:b?b:"category"});}if(i.aggregatable){return new d(a.getId()+"--AggregatableItem--"+i.name,{name:i.name,label:i.label,type:"aggregatable",role:b?b:"axis1"});}});};m.initializeInnerChart=function(a){return new Promise(function(b,e){this._loadChart().then(function(i){this._setInnerStructure(a,new f({justifyContent:"Center",alignItems:"Center",height:"100%",width:"100%"}));var t=new T();t.setText(a.getNoDataText());this._getInnerStructure(a).addItem(t);this._setUpChartObserver(a);b(this._getInnerStructure(a));}.bind(this));}.bind(this));};m.createInitialChartContent=function(a){};m._createContentFromItems=function(a){this.fetchProperties(a).then(function(P){var b=[];var v=[];var e=[];a.getItems().forEach(function(i,I){var j=P.find(function(k){return k.name===i.getName();});if(!j){L.error("sap.ui.mdc.Chart: Item "+i.getName()+" has no property info representing it in the metadata. Make sure the name is correct and the metadata is defined correctly. Skipping the item!");return;}switch(i.getType()){case"groupable":v.push(i.getName());this._addInnerDimension(a,i,j);break;case"aggregatable":e.push(this._getAggregatedMeasureNameForMDCItem(i));this._addInnerMeasure(a,i,j);break;default:L.error("MDC Chart Item "+i.getId()+" with label "+i.getLabel()+" has no known type. Supported typed are: \"groupable\" & \"aggregatable\"");}b.push(this._prepareColoringForItem(i));}.bind(this));this._getState(a).aColMeasures.forEach(function(k){if(this._getState(a).aInSettings.indexOf(k)==-1){var i=P.find(function(x){return x.name===k;});var j=i.aggregationMethod;var t=i.propertyPath;var u={name:k,label:i.label,role:"axis1"};if(j&&t){u.analyticalInfo={propertyPath:t,"with":j};}var w=new p(u);e.push(w);this._getChart(a).addMeasure(w);}}.bind(this));Promise.all(b).then(function(){this._getChart(a).setVisibleDimensions(v);this._getChart(a).setVisibleMeasures(e);var i=a.getDelegate().inResultDimensions;if(i&&i instanceof Array&&i.length!=0){var I=[];i.forEach(function(j){I.push(this._getPropertyInfosByName(j,a).then(function(k){var t=new o({name:k.name,label:k.label});this._getChart(a).addDimension(t);}.bind(this)));}.bind(this));Promise.all(I).then(function(){this._getChart(a).setInResultDimensions(a.getDelegate().inResultDimensions);}.bind(this));}this._updateColoring(a,v,e);this._updateSemanticalPattern(a,P);}.bind(this));}.bind(this));};m.getInnerChart=function(a){return this._getChart(a);};m._prepareColoringForItem=function(i){return this._addCriticality(i).then(function(){this._getState(i.getParent()).aInSettings.push(i.getName());if(i.getType==="aggregatable"){this._getPropertyInfosByName(i.getName(),i.getParent()).then(function(P){for(var j=0;j<this._getAdditionalColoringMeasuresForItem(P);j++){if(this._getState(i.getParent()).aColMeasures.indexOf(this._getAdditionalColoringMeasuresForItem(P)[j])==-1){this._getState(i.getParent()).aColMeasures.push(this._getAdditionalColoringMeasuresForItem(P)[j]);}}}.bind(this));}}.bind(this));};m._getAdditionalColoringMeasuresForItem=function(P){var a=[];var b=P.datapoint?P.datapoint.criticality:null;if(b&&b.DynamicThresholds){a=b.DynamicThresholds.usedMeasures;}return a;};m._addCriticality=function(i){return this._getPropertyInfosByName(i.getName(),i.getParent()).then(function(P){if(P.criticality||(P.datapoint&&P.datapoint.criticality)){var a=this._getState(i.getParent()).oColorings||{Criticality:{DimensionValues:{},MeasureValues:{}}};var b={};if(i.getType()=="groupable"){var e=P.criticality?P.criticality:[];for(var k in e){b[k]={Values:e[k]};}a.Criticality.DimensionValues[i.getName()]=b;}else{var e=P.datapoint&&P.datapoint.criticality?P.datapoint.criticality:[];for(var k in e){b[k]=e[k];}a.Criticality.MeasureValues[i.getName()]=b;}var j=this._getState(i.getParent());j.oColorings=a;this._setState(i.getParent(),j);}}.bind(this));};m._updateColoring=function(a,v,b){var t=jQuery.extend(true,{},this._getState(a).oColorings),k;if(t&&t.Criticality){var A;for(k=0;k<v.length;k++){if(this._getState(a).oColorings.Criticality.DimensionValues[v[k]]){A={coloring:"Criticality",parameters:{dimension:v[k]}};delete t.Criticality.MeasureValues;break;}}if(!A){delete t.Criticality.DimensionValues;for(var e in t.Criticality.MeasureValues){if(b.indexOf(e)==-1){delete t.Criticality.MeasureValues[e];}}A={coloring:"Criticality",parameters:{measure:b}};}if(A){this._getChart(a).setColorings(t);this._getChart(a).setActiveColoring(A);}}};m._updateSemanticalPattern=function(a,P){var v=this._getChart(a).getVisibleMeasures();v.forEach(function(b){var e=P.find(function(t){return t.name===b;});if(!e){return;}var i=e.datapoint;if(i){if(i.targetValue||i.foreCastValue){var A=this._getChart(a).getMeasureByName(b);A.setSemantics("actual");if(i.targetValue!=null){var j=this._getChart(a).getMeasureByName(i.targetValue);if(j){j.setSemantics("reference");}else{L.error("sap.ui.mdc.Chart: "+i.targetValue+" is not a valid measure");}}if(i.foreCastValue){var k=this._getChart(a).getMeasureByName(i.foreCastValue);if(k){k.setSemantics("projected");}else{L.error("sap.ui.comp.SmartChart: "+i.ForecastValue.Path+" is not a valid measure");}}A.setSemanticallyRelatedMeasures({referenceValueMeasure:i.targetValue,projectedValueMeasure:i.foreCastValue});}}}.bind(this));};m.getChartTypeInfo=function(a){if(!this._getChart(a)){throw'inner chart is not bound';}var t=a.getChartType(),b=C.getLibraryResourceBundle("sap.ui.mdc");var i={icon:c.mMatchingIcon[t],text:b.getText("chart.CHART_TYPE_TOOLTIP",[t])};return i;};m.getAvailableChartTypes=function(a){var b=[];if(this._getChart(a)){var A=this._getChart(a).getAvailableChartTypes().available;if(b){var e=C.getLibraryResourceBundle("sap.chart.messages");for(var i=0;i<A.length;i++){var t=A[i].chart;b.push({key:t,icon:c.mMatchingIcon[t],text:e.getText("info/"+t),selected:(t==a.getChartType())});}}}return b;};m.getDrillStackInfo=function(){};m.getDrillStack=function(a){return this._getChart(a).getDrillStack();};m.getSortedDimensions=function(e){return new Promise(function(i,j){this.fetchProperties(e).then(function(P){var k=P.filter(function(I){return I.groupable;});if(k){k.sort(function(a,b){if(a.label&&b.label){return a.label.localeCompare(b.label);}});}i(k);});}.bind(this));};m.getDrillableItems=function(a){var b=a.getItems().filter(function(i){return i.getType()==="groupable";});return b;};m.setChartType=function(a,b){this._getChart(a).setChartType(b);};m.createInnerChartContent=function(a,b){this._setChart(a,new n({id:a.getId()+"--innerChart",chartType:"column",width:"100%",isAnalytical:true}));if(a.getHeight()){this._getChart(a).setHeight(this._calculateInnerChartHeight(a));}R.register(a,function(){this.adjustChartHeight(a);}.bind(this));var e=this._getState(a);e.aColMeasures=[];e.aInSettings=[];this._setState(a,e);this._createContentFromItems(a);this._getChart(a).attachRenderComplete(function(){if(this._getState(a).toolbarUpdateRequested){a._updateToolbar();this._getState(a).toolbarUpdateRequested=false;}}.bind(this));this._getInnerStructure(a).removeAllItems();this._getInnerStructure(a).setJustifyContent(sap.m.FlexJustifyContent.Start);this._getInnerStructure(a).setAlignItems(sap.m.FlexAlignItems.Stretch);this._getInnerStructure(a).addItem(this._getChart(a));e.dataLoadedCallback=b;this._setState(a,e);var B=this._getBindingInfo(a);this.updateBindingInfo(a,B);this.rebindChart(a,B);};m._calculateInnerChartHeight=function(a){var t=jQuery(a.getDomRef()).height();var i=0;var b=a.getAggregation("_toolbar");var B=0;var e=a.getAggregation("_breadcrumbs");if(b){i=jQuery(b.getDomRef()).outerHeight(true);}if(e){B=jQuery(e.getDomRef()).outerHeight(true);}var j=B+i;if(!t){return"480px";}return t-j+"px";};m.adjustChartHeight=function(a){if(a.getHeight()&&this._getChart(a)){this._getChart(a).setHeight(this._calculateInnerChartHeight(a));}};m.requestToolbarUpdate=function(a){this._getState(a).toolbarUpdateRequested=true;};m.createInnerDimension=function(a,b){this.fetchProperties(b.getParent()).then(function(P){var e=P.find(function(i){return i.name===b.getName();});this._addInnerDimension(a,b,e);}.bind(this));};m.createInnerMeasure=function(a,b){this.fetchProperties(b.getParent()).then(function(P){var e=P.find(function(i){return i.name===b.getName();});this._addInnerMeasure(a,b,e);}.bind(this));};m._addInnerDimension=function(a,b,P){var e=new o({name:b.getName(),role:b.getRole()?b.getRole():"category",label:b.getLabel()});if(P.textProperty){e.setTextProperty(P.textProperty);if(P.textFormatter){e.setTextFormatter(P.textFormatter);}e.setDisplayText(true);}this._getChart(a).addDimension(e);};m._addInnerMeasure=function(a,b,P){var e=P.aggregationMethod;var i=P.propertyPath;var j={name:this._getAggregatedMeasureNameForMDCItem(b),label:b.getLabel(),role:b.getRole()?b.getRole():"axis1"};if(e&&i){j.analyticalInfo={propertyPath:i,"with":e};}var k=new p(j);this._getChart(a).addMeasure(k);};m._getAggregatedMeasureNameForProperty=function(P){return P.aggregationMethod+P.name;};m.rebindChart=function(a,b){if(a&&b&&this._getChart(a)){this._addBindingListener(b,"dataReceived",this._getState(a).dataLoadedCallback.bind(a));if(b.binding){b.binding.bHasAnalyticalInfo=true;}this._getChart(a).bindData(b);this._setBindingInfoForState(a,b);var e=this._getState(a);e.innerChartBound=true;}};m._getBindingInfo=function(a){if(this._getBindingInfoFromState(a)){return this._getBindingInfoFromState(a);}var b=a.getDelegate().payload;var e="/"+b.collectionName;var B={path:e};return B;};m.getInnerChartBound=function(a){var b=this._getState(a);if(!b){return false;}return b.innerChartBound?true:false;};m.updateBindingInfo=function(a,b){var e=C.byId(a.getFilter());if(e){var i=e.getConditions();if(i){if(!b){b={};}var P=e.getPropertyInfoSet?e.getPropertyInfoSet():null;var j=D.getParameterNames(e);var k=F.getFilterInfo(m.getTypeUtil(),i,P,j);if(k){b.filters=k.filters;}var t=D.getParametersInfo(e);if(t){b.path=t;}}var u=e.getSearch instanceof Function?e.getSearch():"";if(u){if(!b){b={};}if(!b.parameters){b.parameters={};}b.parameters.$search=u;}else if(b.parameters&&b.parameters.$search){delete b.parameters.$search;}}};m._getAggregatedMeasureNameForMDCItem=function(a){return a.getName();};m._getLayoutOptionsForType=function(t){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var A={groupable:[{key:M.ChartItemRoleType.category,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY')},{key:M.ChartItemRoleType.category2,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY2')},{key:M.ChartItemRoleType.series,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_SERIES')}],aggregatable:[{key:M.ChartItemRoleType.axis1,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS1')},{key:M.ChartItemRoleType.axis2,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS2')},{key:M.ChartItemRoleType.axis3,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS3')}]};return A[t];};m.addInnerItem=function(P,a,b){return Promise.resolve(null);};m.insertInnerItem=function(P,a,b){};m.removeInnerItem=function(P,a,b){return Promise.resolve(true);};m.setChartTooltipVisibility=function(a,b){if(this._getChart(a)){if(b){if(!this._getState(a).vizTooltip){var e=this._getState(a);e.vizTooltip=new q();this._setState(a,e);}this._getState(a).vizTooltip.connect(this._getChart(a).getVizUid());}else if(this._getState(a).vizTooltip){this._getState(a).vizTooltip.destroy();}}else{L.error("Trying to set chart tooltip while inner chart was not yet initialized");}};m._loadChart=function(){return new Promise(function(a){var N=['sap/chart/library','sap/chart/Chart','sap/chart/data/Dimension','sap/chart/data/HierarchyDimension','sap/chart/data/TimeDimension','sap/chart/data/Measure','sap/viz/ui5/controls/VizTooltip'];function b(e,i,j,H,t,k,v){n=i;o=j;p=k;q=v;a();}sap.ui.require(N,b);});};m.initPropertyHelper=function(a){return Promise.all([this.fetchProperties(a),l("sap/ui/mdc/odata/v4/ChartPropertyHelperNew")]).then(function(b){return Promise.all(b.concat(this.fetchPropertyExtensions(a,b[0])));}.bind(this)).then(function(b){var P=b[0];var e=b[1][0];var E=b[2];var j=0;var k=[];for(var i=0;i<P.length;i++){k.push(Object.assign({},P[i],{extension:E[P[i].name]||{}}));if(P[i].name in E){j++;}}if(j!==Object.keys(E).length){throw new Error("At least one property extension does not point to an existing property");}return new e(k,a);});};m.fetchProperties=function(a){var b=this._getModel(a);var e;if(!b){e=new Promise(function(i){a.attachModelContextChange({resolver:i},r,this);}.bind(this)).then(function(b){return this._createPropertyInfos(a,b);}.bind(this));}else{e=this._createPropertyInfos(a,b);}return e.then(function(P){if(a.data){a.data("$mdcChartPropertyInfo",P);}return P;});};function r(e,a){var b=e.getSource();var i=this._getModel(b);if(i){b.detachModelContextChange(r);a.resolver(i);}}m._createPropertyInfos=function(a,b){var e=a.getDelegate().payload;var P=[];var E="/"+e.collectionName;var i=b.getMetaModel();return Promise.all([i.requestObject(E+"/"),i.requestObject(E+"@")]).then(function(j){var k=j[0],t=j[1];var u=t["@Org.OData.Capabilities.V1.SortRestrictions"]||{};var v=O.getSortRestrictionsInfo(u);var w=t["@Org.OData.Capabilities.V1.FilterRestrictions"];var x=O.getFilterRestrictionsInfo(w);for(var K in k){var y=k[K];if(y&&y.$kind==="Property"){if(y.$isCollection){continue;}var z=i.getObject(E+"/"+K+"@");if(!z["@Org.OData.Aggregation.V1.Aggregatable"]&&!z["@Org.OData.Aggregation.V1.Groupable"]){continue;}if(z["@Org.OData.Aggregation.V1.Aggregatable"]){P=P.concat(this._createPropertyInfosForAggregatable(K,z,x,v));}if(z["@Org.OData.Aggregation.V1.Groupable"]){P.push({name:K,propertyPath:K,label:z["@com.sap.vocabularies.Common.v1.Label"]||K,sortable:v[K]?v[K].sortable:true,filterable:x[K]?x[K].filterable:true,groupable:true,aggregatable:false,maxConditions:O.isMultiValueFilterExpression(x.propertyInfo[K])?-1:1,sortKey:K,kind:"Groupable",availableRoles:this._getLayoutOptionsForType("groupable"),role:M.ChartItemRoleType.category,criticality:null,textProperty:z["@com.sap.vocabularies.Common.v1.Text"]?z["@com.sap.vocabularies.Common.v1.Text"].$Path:null});}}}return P;}.bind(this));};m._createPropertyInfosForAggregatable=function(k,P,a,b){var e=[];if(P["@Org.OData.Aggregation.V1.SupportedAggregationMethods"]){P["@Org.OData.Aggregation.V1.SupportedAggregationMethods"].forEach(function(A){e.push({name:A+k,propertyPath:k,label:P["@com.sap.vocabularies.Common.v1.Label"]+" ("+A+")"||k+" ("+A+")",sortable:b[k]?b[k].sortable:true,filterable:a[k]?a[k].filterable:true,groupable:false,aggregatable:P["@Org.OData.Aggregation.V1.Aggregatable"],aggregationMethod:A,maxConditions:O.isMultiValueFilterExpression(a.propertyInfo[k])?-1:1,sortKey:P["@Org.OData.Aggregation.V1.RecommendedAggregationMethod"]+k,kind:"Aggregatable",availableRoles:this._getLayoutOptionsForType("aggregatable"),role:M.ChartItemRoleType.axis1,datapoint:null});}.bind(this));}return e;};m._getPropertyInfosByName=function(N,a){return new Promise(function(b){this.fetchProperties(a).then(function(P){var e=P.find(function(i){return i.name===N;});b(e);});}.bind(this));};m._getModel=function(t){var a=t.getDelegate().payload;return t.getModel(a.model);};m._addBindingListener=function(b,e,H){if(!b.events){b.events={};}if(!b.events[e]){b.events[e]=H;}else{var a=b.events[e];b.events[e]=function(){H.apply(this,arguments);a.apply(this,arguments);};}};return m;});
