/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/mdc/util/loadModules','sap/ui/mdc/valuehelp/base/ListContent','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterConverter','sap/ui/mdc/enum/ConditionValidated','sap/base/util/deepEqual','sap/ui/mdc/util/Common','sap/ui/model/base/ManagedObjectModel','sap/m/MessageToast'],function(l,L,C,F,a,d,b,M,c){"use strict";var e=L.extend("sap.ui.mdc.valuehelp.base.FilterableListContent",{metadata:{library:"sap.ui.mdc",properties:{filterFields:{type:"string",defaultValue:""},keyPath:{type:"string",defaultValue:""},descriptionPath:{type:"string",defaultValue:""},inConditions:{type:"object",defaultValue:{},byValue:true},outParameterNames:{type:"string[]",defaultValue:[],byValue:true}},aggregations:{collectiveSearchItems:{type:"sap.ui.core.Item",multiple:true,singularName:"collectiveSearchItem"},filterBar:{type:"sap.ui.mdc.filterbar.FilterBarBase",multiple:false},_defaultFilterBar:{type:"sap.ui.mdc.filterbar.FilterBarBase",multiple:false,visibility:"hidden"}},events:{}}});e.prototype.init=function(){L.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oObserver.observe(this,{aggregations:["_defaultFilterBar","filterBar"],properties:["inConditions"]});this.bindProperty("inConditions",{path:"/_inConditions",model:"$valueHelp"});this.bindProperty("outParameterNames",{path:"/_outParameters",model:"$valueHelp"});};e.prototype._handleFilterValueUpdate=function(o){k.call(this,this._getPriorityFilterBar(),o.current);this.applyFilters(o.current);};e.prototype.applyFilters=function(s){};e.prototype._prettyPrintFilters=function(o){var r;if(!o){return"";}if(Array.isArray(o)){r="";o.forEach(function(o,i,m){r+=this._prettyPrintFilters(o);if(m.length-1!=i){r+=" or ";}},this);return"("+r+")";}else if(o._bMultiFilter){r="";var A=o.bAnd;o.aFilters.forEach(function(o,i,m){r+=this._prettyPrintFilters(o);if(m.length-1!=i){r+=A?" and ":" or ";}},this);return"("+r+")";}else{r=o.sPath+" "+o.sOperator+" '"+o.oValue1+"'";if(o.sOperator==="BT"){r+="...'"+o.oValue2+"'";}return r;}};e.prototype._getItemFromContext=function(B,o){var K=(o&&o.keyPath)||this.getKeyPath();var D=(o&&o.descriptionPath)||this.getDescriptionPath();var v;var s;var p;if(!K){throw new Error("KeyPath missing");}var I=o&&o.inParameters||[];if(I.length===0){for(p in this.getProperty("inConditions")){I.push(p);}}var O=o&&o.outParameters||this.getProperty("outParameterNames");var m=I.length>0?{}:null;var n=O.length>0?{}:null;if(B){v=K?B.getProperty(K):undefined;s=D?B.getProperty(D):undefined;var i=0;for(i=0;i<I.length;i++){p=I[i];m[p]=B.getProperty(p);}for(i=0;i<O.length;i++){p=O[i];n[p]=B.getProperty(p);}}if(v===null||v===undefined){return false;}return{key:v,description:s,inParameters:m,outParameters:n};};e.prototype._isItemSelected=function(I,m){var o=I&&I.getBindingContext();var n=this._getItemFromContext(o);for(var i=0;i<m.length;i++){var p=m[i];if(p.validated===a.Validated&&n.key===p.values[0]){if(p.inParameters&&n.inParameters&&!d(p.inParameters,n.inParameters)){continue;}if(p.outParameters&&n.outParameters&&!d(p.outParameters,n.outParameters)){continue;}return true;}}return false;};e.prototype._createDefaultFilterBar=function(){return l(["sap/ui/mdc/filterbar/vh/FilterBar"]).then(function(m){var i=m[0];var o=new i(this.getId()+"-FB",{liveMode:false,showGoButton:false});this.setAggregation("_defaultFilterBar",o,true);return o;}.bind(this));};e.prototype._assignCollectiveSearch=function(i){i=typeof i!=="undefined"?i:!this._oCollectiveSearchSelect;_.call(this,i).then(function(o){var m=this._getPriorityFilterBar();if(m.setCollectiveSearch){m.setCollectiveSearch(o);}}.bind(this));};function _(i){return l(["sap/ui/mdc/filterbar/vh/CollectiveSearchSelect","sap/ui/core/Item"]).then(function(m){var n=m[0];var I=m[1];g.call(this,n,I);var o=this.getCollectiveSearchItems();if(o.length<=1){return null;}else{if(i){this._oCollectiveSearchSelect.setSelectedItemKey(o[0].getKey());}return this._oCollectiveSearchSelect;}}.bind(this));}function f(E){var K=E.getParameter("key");c.show("ColSearch: "+K);this.fireRequestDelegateContent();}function g(i,I){if(!this._oCollectiveSearchSelect){this._oObserver.observe(this,{properties:["filterFields"],aggregations:["collectiveSearchItems"]});this._oManagedObjectModel=new M(this);this.setModel(this._oManagedObjectModel,"$contenthelp");var o=new I(this.getId()+"-collSearchItem",{key:"{$contenthelp>key}",text:"{$contenthelp>text}",enabled:"{$contenthelp>enabled}",textDirection:"{$contenthelp>textDirection}"});this._oCollectiveSearchSelect=new i(this.getId()+"-collSearch",{title:"{$i18n>COL_SEARCH_SEL_TITLE}",items:{path:"$contenthelp>/collectiveSearchItems",template:o},select:f.bind(this)});}return this._oCollectiveSearchSelect;}e.prototype.onShow=function(){L.prototype.onShow.apply(this,arguments);var o=this._getListBinding();var i=this._getListBindingInfo();var B=o&&o.isSuspended();var m=!o&&i&&i.suspended;if((B||m)&&!this.isTypeahead()){return;}this.applyFilters(this.getFilterValue());};e.prototype._formatConditions=function(m){var I=this.getModel("$valueHelp").getProperty("/inParameters");var o=this.getModel("$valueHelp").getProperty("/outParameters");for(var i=0;i<m.length;i++){var n=m[i];if(n.inParameters){n.inParameters=h.call(this,n.inParameters,I);}if(n.outParameters){n.outParameters=h.call(this,n.outParameters,o);}}return m;};function h(p,P){var H;if(P.length>0){for(var m in p){for(var i=0;i<P.length;i++){var o=P[i];var s=o.getHelpPath();var n=o.getFieldPath();if(n&&(n===m||n==="conditions/"+m)&&s){if(!H){H={};}H[s]=p[m];}}}}return H;}e.prototype._getPriorityFilterBar=function(){return this.getFilterBar()||this.getAggregation("_defaultFilterBar");};e.prototype._observeChanges=function(o){if(o.object==this){if(o.name==="collectiveSearchItems"){this._assignCollectiveSearch(true);}if(o.name==="inConditions"){j.call(this,this._getPriorityFilterBar(),o.current);}if(["_defaultFilterBar","filterBar"].indexOf(o.name)!==-1){var i=o.child;if(o.mutation==="insert"){var s=this.getFilterFields();var E=i.getBasicSearchField();if(!E&&s){return l(["sap/ui/mdc/FilterField"]).then(function(m){var n=m[0];i.setBasicSearchField(new n(this.getId()+"-search",{conditions:"{$filters>/conditions/"+s+"}",placeholder:"{$i18n>filterbar.SEARCH}",label:"{$i18n>filterbar.SEARCH}",maxConditions:1,width:"50%"}));}.bind(this));}else if(E){E.setConditions([]);}this._assignCollectiveSearch();j.call(this,i,this.getProperty("inConditions"));k.call(this,i,this.getFilterValue());}}}L.prototype._observeChanges.apply(this,arguments);};e.prototype.exit=function(){b.cleanup(this,["_oCollectiveSearchSelect","_oManagedObjectModel"]);L.prototype.exit.apply(this,arguments);};e.prototype.getCollectiveSearchKey=function(){return this._oCollectiveSearchSelect&&this._oCollectiveSearchSelect.getSelectedItemKey();};e.prototype._getFiltersForFilterBar=function(){var o=this._getPriorityFilterBar();var i=o.getConditions();var m=this._getTypesForConditions(i);var n=i&&m&&F.createFilters(i,m,undefined,this.getCaseSensitive());return n?[].concat(n):[];};e.prototype._getListBinding=function(){throw new Error("FilterableListContent: Every filterable listcontent must implement this method.");};e.prototype._getListBindingInfo=function(){throw new Error("FilterableListContent: Every filterable listcontent must implement this method.");};e.prototype._getTypesForConditions=function(o){var m=this._getPriorityFilterBar();var I=this.getInParameters();var n;var s;if(m){n=F.createConditionTypesMapFromFilterBar(o,m);}else{n={};for(s in o){n[s]={type:null};}}for(s in n){if(!n[s].type){for(var i=0;i<I.length;i++){var p=I[i];if(p.getHelpPath()===s){n[s].type=p.getDataType();break;}}}}return n;};function j(o,i){if(o){var m=o.getInternalConditions();for(var s in i){m[s]=i[s];}o.setInternalConditions(m);}}function k(o,s){var i=this.getFilterFields();if(o&&i){var m=o.getInternalConditions();var n=C.createCondition("StartsWith",[s],undefined,undefined,a.NotValidated);m[i]=[n];o.setInternalConditions(m);}}e.prototype.getFormattedTitle=function(i){var t=L.prototype.getFormattedTitle.apply(this,arguments);if(!t){t=this._oResourceBundle.getText(i?"valuehelp.SELECTFROMLIST":"valuehelp.SELECTFROMLISTNONUMBER",i);}return t;};e.prototype.getFormattedShortTitle=function(){var s=this.getShortTitle();if(!s){s=this._oResourceBundle.getText("valuehelp.SELECTFROMLIST.Shorttitle");}return s;};return e;});
