/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/odata/ODataMetadata","sap/ui/model/odata/ODataUtils","sap/ui/core/library","sap/ui/thirdparty/URI","sap/ui/core/message/MessageParser","sap/ui/core/message/Message","sap/base/Log"],function(O,a,c,U,M,b,L){"use strict";var C="sap.ui.model.odata.ODataMessageParser",r=/^\/+|\/$/g,d=c.MessageType,s={"error":d.Error,"info":d.Information,"success":d.Success,"warning":d.Warning};var e=M.extend("sap.ui.model.odata.ODataMessageParser",{metadata:{publicMethods:["parse","setProcessor","getHeaderField","setHeaderField"]},constructor:function(S,m,p){M.apply(this);this._serviceUrl=f(this._parseUrl(S).url);this._metadata=m;this._headerField="sap-message";this._lastMessages=[];this._bPersistTechnicalMessages=p;}});e.prototype.getHeaderField=function(){return this._headerField;};e.prototype.setHeaderField=function(F){this._headerField=F;return this;};e.prototype.parse=function(R,o,G,m,i){var j,k,S=String(R.statusCode);if(o.method==="GET"&&S==="204"){return;}k={request:o,response:R,url:o.requestUri};if(R.statusCode>=200&&R.statusCode<300){j=this._parseHeader(R,k);}else if(R.statusCode>=400&&R.statusCode<600){try{j=this._parseBody(R,k);this._logErrorMessages(j,o,S);}catch(n){j=this._createGenericError(k);L.error("Request failed with status code "+S+": "+o.method+" "+o.requestUri,n,C);}}else{j=this._createGenericError(k);L.error("Request failed with unsupported status code "+S+": "+o.method+" "+o.requestUri,undefined,C);}if(o.method==="GET"&&S==="424"){return;}this._propagateMessages(j,k,G,m,!i);};e.prototype._getAffectedTargets=function(m,R,G,i){var A=Object.assign({"":true},G,i),E,j=this._parseUrl(R.url).url;if(R.request.key&&R.request.created){A[R.request.key]=true;}if(j.startsWith(this._serviceUrl)){j=j.slice(this._serviceUrl.length+1);}E=this._metadata._getEntitySetByPath(j);if(E){A[E.name]=true;}m.forEach(function(o){o.getTargets().forEach(function(t){var p,S,T;if(!t){return;}T=t.replace(r,"");A[T]=true;S=T.lastIndexOf("/");if(S>0){p=T.slice(0,S);A[p]=true;}});});return A;};e.prototype._propagateMessages=function(m,R,G,i,S){var A,D=R.request.deepPath,k=[],j,p=D&&R.request.updateAggregatedMessages,t=R.request.headers&&R.request.headers["sap-messages"]==="transientOnly",n=[],o=O._returnsCollection(R.request.functionMetadata),q,u,v;function w(x,T){return T.some(function(y){return A[y];})||p&&x.aFullTargets.some(function(F){if(o){return j.some(function(K){var y=K.slice(K.indexOf("("));return F.startsWith(D+y);});}else{return F.startsWith(D);}});}G=G||{};if(t){k=this._lastMessages;q=m.some(function(x){return!x.getPersistent()&&!x.getTechnical();});if(q){L.error("Unexpected non-persistent message in response, but requested only "+"transition messages",undefined,C);}}else{A=this._getAffectedTargets(m,R,G,i);j=Object.keys(G);u=R.response.statusCode;v=(u>=200&&u<300);this._lastMessages.forEach(function(x){var T=x.getTargets().map(function(y){y=y.replace(r,"");var P=y.lastIndexOf(")/");if(P>0){y=y.substr(0,P+1);}return y;});if(v||S){if(!x.getPersistent()&&w(x,T)){n.push(x);}else{k.push(x);}}else if(!x.getPersistent()&&x.getTechnical()&&w(x,T)){n.push(x);}else{k.push(x);}});}this.getProcessor().fireMessageChange({oldMessages:n,newMessages:m});this._lastMessages=k.concat(m);};e.prototype._createMessage=function(m,R,i){var p=m.target&&m.target.indexOf("/#TRANSIENT#")===0||m.transient||m.transition||i&&this._bPersistTechnicalMessages,t,T=typeof m.message==="object"?m.message.value:m.message,j=m["@sap.severity"]||m.severity;m.transition=!!p;t=this._createTargets(m,R,i);return new b({code:m.code||"",description:m.description,descriptionUrl:m.longtext_url||"",fullTarget:t.aDeepPaths,message:T,persistent:!!p,processor:this._processor,target:t.aTargets,technical:i,technicalDetails:{headers:R.response.headers,statusCode:R.response.statusCode},type:s[j]||j});};e._isResponseForCreate=function(R){var o=R.request,i=R.response;if(o.method==="POST"&&i.statusCode==201&&i.headers["location"]){return true;}if(o.key&&o.created&&i.statusCode>=400){return false;}};e.prototype._createTarget=function(o,R,i,j){var k,m,D,p,P,n,u,q,t,v=R.request,w=R.response;if(o===undefined&&(!i&&v.headers["sap-message-scope"]==="BusinessObject"||i&&j)){return{deepPath:"",target:""};}o=o||"";o=o.startsWith("/#TRANSIENT#")?o.slice(12):o;if(o[0]!=="/"){m=e._isResponseForCreate(R);D=v.deepPath||"";if(m===true){t=w.headers["location"];}else if(m===false){t=v.key;}else{t=R.url;}q=this._parseUrl(t);u=q.url;p=u.indexOf(this._serviceUrl);if(p>-1){n=u.slice(p+this._serviceUrl.length);}else{n="/"+u;}if(!m&&v.functionMetadata){n=v.functionTarget;}if(n.slice(n.lastIndexOf("/")).indexOf("(")>-1||!this._metadata._isCollection(n)){D=o?D+"/"+o:D;o=o?n+"/"+o:n;}else{D=D+o;o=n+o;}}k=this._processor.resolve(o,undefined,true);while(k&&k.lastIndexOf("/")>0&&k!==P){P=k;k=this._processor.resolve(k,undefined,true)||P;}o=k||o;return{deepPath:this._metadata._getReducedPath(D||o),target:a._normalizeKey(o)};};e.prototype._createTargets=function(m,R,i){var D=[],j=Array.isArray(m.additionalTargets)?[m.target].concat(m.additionalTargets):[m.target],t,T=[],k=this;if(m.propertyref!==undefined&&j[0]!==undefined){L.warning("Used the message's 'target' property for target calculation; the property"+" 'propertyref' is deprecated and must not be used together with 'target'",R.url,C);}else if(j[0]===undefined){j[0]=m.propertyref;}j.forEach(function(A){t=k._createTarget(A,R,i,m.transition);D.push(t.deepPath);T.push(t.target);});return{aDeepPaths:D,aTargets:T};};e.prototype._parseHeader=function(R,m){var i,k,j,S,F=this.getHeaderField(),n=[];if(!R.headers){return n;}for(k in R.headers){if(k.toLowerCase()===F.toLowerCase()){F=k;}}if(!R.headers[F]){return n;}j=R.headers[F];try{S=JSON.parse(j);n.push(this._createMessage(S,m));if(Array.isArray(S.details)){for(i=0;i<S.details.length;i+=1){n.push(this._createMessage(S.details[i],m));}}}catch(o){L.error("The message string returned by the back-end could not be parsed: '"+o.message+"'");return n;}return n;};e.prototype._parseBody=function(R,m){var i=g(R);return(i&&i.indexOf("xml")>-1)?this._parseBodyXML(R,m,i):this._parseBodyJSON(R,m);};e.prototype._createGenericError=function(R){return[this._createMessage({description:R.response.body,message:sap.ui.getCore().getLibraryResourceBundle().getText("CommunicationError"),severity:d.Error,transition:true},R,true)];};e.prototype._getBodyMessages=function(o,i,R){var j=R.request.headers["Content-ID"],m=[],k=this._createMessage(o,R,true),t=this;i.forEach(function(I){var n=t._createMessage(I,R,true);if(k&&k.getCode()===n.getCode()&&k.getMessage()===n.getMessage()){k=undefined;}if(!j||!I.ContentID||j===I.ContentID){m.push(n);}});if(k){m.unshift(k);}return m;};e.prototype._logErrorMessages=function(m,R,S){var E=m.length?JSON.stringify(m.map(function(o){return{code:o.getCode(),message:o.getMessage(),persistent:o.getPersistent(),targets:o.getTargets(),type:o.getType()};})):"Another request in the same change set failed";L.error("Request failed with status code "+S+": "+R.method+" "+R.requestUri,E,C);};e.prototype._parseBodyXML=function(R,j,k){var o,p,E,i,m,n,N,D=new DOMParser().parseFromString(R.body,k),q=h(D,["error","errordetail"]),t=[];if(!q.length){return this._createGenericError(j);}for(i=0;i<q.length;i+=1){N=q[i];E={};E.severity=d.Error;for(n=0;n<N.childNodes.length;n+=1){o=N.childNodes[n];p=o.nodeName;if(p==="errordetails"||p==="details"||p==="innererror"||p==="#text"){continue;}if(p==="message"&&o.hasChildNodes()&&o.firstChild.nodeType!==window.Node.TEXT_NODE){for(m=0;m<o.childNodes.length;m+=1){if(o.childNodes[m].nodeName==="value"){E.message=o.childNodes[m].text||o.childNodes[m].textContent;}}}else{E[o.nodeName]=o.text||o.textContent;}}t.push(E);}return this._getBodyMessages(t[0],t.slice(1),j);};e.prototype._parseBodyJSON=function(R,m){var i,o,E=JSON.parse(R.body);if(E.error){o=E.error;}else{o=E["odata.error"];}if(!o){L.error("Error message returned by server did not contain error-field");return this._createGenericError(m);}o.severity=d.Error;if(Array.isArray(o.details)){i=o.details;}else if(o.innererror&&Array.isArray(o.innererror.errordetails)){i=o.innererror.errordetails;}else{i=[];}return this._getBodyMessages(o,i,m);};e.prototype._parseUrl=function(u){var m={url:u,parameters:{},hash:""};var p=-1;p=u.indexOf("#");if(p>-1){m.hash=m.url.substr(p+1);m.url=m.url.substr(0,p);}p=u.indexOf("?");if(p>-1){var P=m.url.substr(p+1);m.parameters=U.parseQuery(P);m.url=m.url.substr(0,p);}return m;};e.prototype._setPersistTechnicalMessages=function(p){this._bPersistTechnicalMessages=p;};function g(R){if(R&&R.headers){for(var H in R.headers){if(H.toLowerCase()==="content-type"){return R.headers[H].replace(/([^;]*);.*/,"$1");}}}return false;}var l=document.createElement("a");function f(u){l.href=u;return U.parse(l.href).path;}function h(D,E){var j=[];var m={};for(var i=0;i<E.length;i+=1){m[E[i]]=true;}var o=D;while(o){if(m[o.tagName]){j.push(o);}if(o.hasChildNodes()){o=o.firstChild;}else{while(!o.nextSibling){o=o.parentNode;if(!o||o===D){o=null;break;}}if(o){o=o.nextSibling;}}}return j;}return e;});
