/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_AnnotationHelperBasics","sap/base/Log","sap/base/util/deepExtend","sap/base/util/extend"],function(_,L,d,e){"use strict";var b={"Bool":"false"},B={"Bool":"true"},D={"fiscalyear":"IsFiscalYear","fiscalyearperiod":"IsFiscalYearPeriod","year":"IsCalendarYear","yearmonth":"IsCalendarYearMonth","yearmonthday":"IsCalendarDate","yearquarter":"IsCalendarYearQuarter","yearweek":"IsCalendarYearWeek"},f={"interval":"SingleInterval","multi-value":"MultiValue","single-value":"SingleValue"},l="sap.ui.model.odata.ODataMetaModel",s={"bday":"Contact","city":"Contact/adr","country":"Contact/adr","email":"Contact/email","familyname":"Contact/n","givenname":"Contact/n","honorific":"Contact/n","middlename":"Contact/n","name":"Contact","nickname":"Contact","note":"Contact","org":"Contact","org-role":"Contact","org-unit":"Contact","photo":"Contact","pobox":"Contact/adr","region":"Contact/adr","street":"Contact/adr","suffix":"Contact/n","tel":"Contact/tel","title":"Contact","zip":"Contact/adr","class":"Event","dtend":"Event","dtstart":"Event","duration":"Event","fbtype":"Event","location":"Event","status":"Event","transp":"Event","wholeday":"Event","body":"Message","from":"Message","received":"Message","sender":"Message","subject":"Message","completed":"Task","due":"Task","percent-complete":"Task","priority":"Task"},r=/(\w+)(?:;type=([\w,]+))?/,v={"email":{typeMapping:{"home":"home","pref":"preferred","work":"work"},v4EnumType:"com.sap.vocabularies.Communication.v1.ContactInformationType",v4PropertyAnnotation:"com.sap.vocabularies.Communication.v1.IsEmailAddress"},"tel":{typeMapping:{"cell":"cell","fax":"fax","home":"home","pref":"preferred","video":"video","voice":"voice","work":"work"},v4EnumType:"com.sap.vocabularies.Communication.v1.PhoneType",v4PropertyAnnotation:"com.sap.vocabularies.Communication.v1.IsPhoneNumber"}},V={creatable:{"Org.OData.Capabilities.V1.InsertRestrictions":{"Insertable":b}},pageable:{"Org.OData.Capabilities.V1.SkipSupported":b,"Org.OData.Capabilities.V1.TopSupported":b},"requires-filter":{"Org.OData.Capabilities.V1.FilterRestrictions":{"RequiresFilter":B}},topable:{"Org.OData.Capabilities.V1.TopSupported":b}},m={"city":"locality","email":"address","familyname":"surname","givenname":"given","honorific":"prefix","middlename":"additional","name":"fn","org-role":"role","org-unit":"orgunit","percent-complete":"percentcomplete","tel":"uri","zip":"code"},a={"sap:filterable":["Org.OData.Capabilities.V1.FilterRestrictions","NonFilterableProperties"],"sap:required-in-filter":["Org.OData.Capabilities.V1.FilterRestrictions","RequiredProperties"],"sap:sortable":["Org.OData.Capabilities.V1.SortRestrictions","NonSortableProperties"]},c=/^com\.sap\.vocabularies\.Common\.v1\.ValueList(#.*)?$/,w=L.Level.WARNING,U;U={addEntitySetAnnotation:function(o,E,t,n,g){if(t==="EntitySet"&&E.value===n){if(g){d(o,V[E.name]);}else{e(o,V[E.name]);}}},addFilterRestriction:function(p,E){var F,g=f[p["sap:filter-restriction"]];if(!g){if(L.isLoggable(w,l)){L.warning("Unsupported sap:filter-restriction: "+p["sap:filter-restriction"],E.entityType+"."+p.name,l);}return;}F=E["com.sap.vocabularies.Common.v1.FilterExpressionRestrictions"]||[];F.push({"Property":{"PropertyPath":p.name},"AllowedExpressions":{"EnumMember":"com.sap.vocabularies.Common.v1.FilterExpressionType/"+g}});E["com.sap.vocabularies.Common.v1.FilterExpressionRestrictions"]=F;},addNavigationFilterRestriction:function(n,E){var N=E["Org.OData.Capabilities.V1.NavigationRestrictions"]||{};N.RestrictedProperties=N.RestrictedProperties||[];N.RestrictedProperties.push({"FilterRestrictions":{"Filterable":b},"NavigationProperty":{"NavigationPropertyPath":n.name}});E["Org.OData.Capabilities.V1.NavigationRestrictions"]=N;},addPropertyToAnnotation:function(g,E,p){var n=a[g],t=n[0],C=n[1],A=E[t]||{},h=A[C]||[];h.push({"PropertyPath":p.name});A[C]=h;E[t]=A;},addSapSemantics:function(t){if(t.property){t.property.forEach(function(p){var A,i,M,S,T,g=p["sap:semantics"],h,j,o,k,n;if(!g){return;}if(g==="url"){p["Org.OData.Core.V1.IsURL"]=B;return;}if(g in D){h="com.sap.vocabularies.Common.v1."+D[g];p[h]=B;return;}M=r.exec(g);if(!M){if(L.isLoggable(w,l)){L.warning("Unsupported sap:semantics: "+g,t.name+"."+p.name,l);}return;}if(M[2]){g=M[1];n=U.getV4TypesForV2Semantics(g,M[2],p,t);}k=v[g];i=g==="tel"||g==="email";j=s[g];if(j){A=j.split("/");h="com.sap.vocabularies.Communication.v1."+A[0];t[h]=t[h]||{};o=t[h];S=A[1];if(S){o[S]=o[S]||(i?[]:{});if(i){T={};o[S].push(T);o=T;}else{o=o[S];}}o[m[g]||g]={"Path":p.name};if(n){o.type={"EnumMember":n};}}if(k){p[k.v4PropertyAnnotation]=p[k.v4PropertyAnnotation]||B;}});}},addUnitAnnotations:function(S,M){function p(t){(t||[]).forEach(function(T){(T.property||[]).forEach(function(P){var A,i,g,o,u,h=P["sap:unit"],j;if(h){i={getModel:function(){return M;},getPath:function(){return T.$path;}};u={"Path":h};o=_.followPath(i,u);if(o&&o.resolvedPath){j=M.getProperty(o.resolvedPath);g=j["sap:semantics"];if(g==="unit-of-measure"){A="Org.OData.Measures.V1.Unit";}else if(g==="currency-code"){A="Org.OData.Measures.V1.ISOCurrency";}else if(L.isLoggable(w,l)){L.warning("Unsupported sap:semantics='"+g+"' at sap:unit='"+h+"'; "+"expected 'currency-code' or 'unit-of-measure'",T.namespace+"."+T.name+"/"+P.name,l);}if(A&&!(A in P)){P[A]=u;}}else if(L.isLoggable(w,l)){L.warning("Path '"+h+"' for sap:unit cannot be resolved",T.namespace+"."+T.name+"/"+P.name,l);}}});});}S.forEach(function(o){p(o.complexType);p(o.entityType);});},addV4Annotation:function(o,E,t){switch(E.name){case"aggregation-role":if(E.value==="dimension"){o["com.sap.vocabularies.Analytics.v1.Dimension"]=B;}else if(E.value==="measure"){o["com.sap.vocabularies.Analytics.v1.Measure"]=B;}break;case"display-format":if(E.value==="NonNegative"){o["com.sap.vocabularies.Common.v1.IsDigitSequence"]=B;}else if(E.value==="UpperCase"){o["com.sap.vocabularies.Common.v1.IsUpperCase"]=B;}break;case"pageable":case"topable":U.addEntitySetAnnotation(o,E,t,"false",false);break;case"creatable":U.addEntitySetAnnotation(o,E,t,"false",true);break;case"deletable":case"deletable-path":U.handleXableAndXablePath(o,E,t,"Org.OData.Capabilities.V1.DeleteRestrictions","Deletable");break;case"updatable":case"updatable-path":U.handleXableAndXablePath(o,E,t,"Org.OData.Capabilities.V1.UpdateRestrictions","Updatable");break;case"requires-filter":U.addEntitySetAnnotation(o,E,t,"true",true);break;case"field-control":o["com.sap.vocabularies.Common.v1.FieldControl"]={"Path":E.value};break;case"heading":o["com.sap.vocabularies.Common.v1.Heading"]={"String":E.value};break;case"label":o["com.sap.vocabularies.Common.v1.Label"]={"String":E.value};break;case"precision":o["Org.OData.Measures.V1.Scale"]={"Path":E.value};break;case"quickinfo":o["com.sap.vocabularies.Common.v1.QuickInfo"]={"String":E.value};break;case"text":o["com.sap.vocabularies.Common.v1.Text"]={"Path":E.value};break;case"visible":if(E.value==="false"){o["com.sap.vocabularies.Common.v1.FieldControl"]={"EnumMember":"com.sap.vocabularies.Common.v1.FieldControlType/Hidden"};o["com.sap.vocabularies.UI.v1.Hidden"]=B;}break;default:}},calculateEntitySetAnnotations:function(E,o){if(o.property){o.property.forEach(function(p){if(p["sap:filterable"]==="false"){U.addPropertyToAnnotation("sap:filterable",E,p);}if(p["sap:required-in-filter"]==="true"){U.addPropertyToAnnotation("sap:required-in-filter",E,p);}if(p["sap:sortable"]==="false"){U.addPropertyToAnnotation("sap:sortable",E,p);}if(p["sap:filter-restriction"]){U.addFilterRestriction(p,E);}});}if(o.navigationProperty){o.navigationProperty.forEach(function(n){if(n["sap:filterable"]==="false"){U.addNavigationFilterRestriction(n,E);U.addPropertyToAnnotation("sap:filterable",E,n);}U.handleCreatableNavigationProperty(E,n);});}},findIndex:function(A,E,p){var i,n;p=p||"name";if(A){for(i=0,n=A.length;i<n;i+=1){if(A[i][p]===E){return i;}}}return-1;},findObject:function(A,E,p){var i=U.findIndex(A,E,p);return i<0?null:A[i];},getChildAnnotations:function(A,q,i){var o=i?A.EntityContainer:A.propertyAnnotations;return o&&o[q]||{};},getFromContainer:function(E,A,n,g){var k,R=g?undefined:null;if(E){k=U.findIndex(E[A],n);if(k>=0){R=g?E.$path+"/"+A+"/"+k:E[A][k];}}return R;},getObject:function(M,A,q,g){var h,R=g?undefined:null,S,i,n,N;q=q||"";i=q.lastIndexOf(".");n=q.slice(0,i);N=q.slice(i+1);S=U.getSchema(M,n);if(S){h=S[A];if(h){h.forEach(function(t){if(t.name===N){R=g?t.$path:t;return false;}});}}return R;},getSchema:function(M,n){var S=null,g=Array.isArray(M)?M:M.getObject("/dataServices/schema");if(g){g.forEach(function(o){if(o.namespace===n){S=o;return false;}});}return S;},getV4TypesForV2Semantics:function(S,t,p,T){var R=[],o=v[S];if(o){t.split(",").forEach(function(g){var h=o.typeMapping[g];if(h){R.push(o.v4EnumType+"/"+h);}else if(L.isLoggable(w,l)){L.warning("Unsupported type for sap:semantics: "+g,T.name+"."+p.name,l);}});}return R.join(" ");},getValueLists:function(p){var M,n,q,g={};for(n in p){M=c.exec(n);if(M){q=(M[1]||"").slice(1);g[q]=p[n];}}return g;},handleCreatableNavigationProperty:function(E,n){var C=n["sap:creatable"],g=n["sap:creatable-path"],i,N={"NavigationPropertyPath":n.name},h;if(C&&g){L.warning("Inconsistent service","Use either 'sap:creatable' or 'sap:creatable-path' at navigation property "+"'"+E.entityType+"/"+n.name+"'",l);C="false";g=undefined;}if(C==="false"||g){i=E["Org.OData.Capabilities.V1.InsertRestrictions"]=E["Org.OData.Capabilities.V1.InsertRestrictions"]||{};h=i["NonInsertableNavigationProperties"]=i["NonInsertableNavigationProperties"]||[];if(g){N={"If":[{"Not":{"Path":g}},N]};}h.push(N);}},handleXableAndXablePath:function(o,E,t,T,p){var g=p.toLowerCase(),h;if(t!=="EntitySet"){return;}if(o["sap:"+g]&&o["sap:"+g+"-path"]){L.warning("Inconsistent service","Use either 'sap:"+g+"' or 'sap:"+g+"-path'"+" at entity set '"+o.name+"'",l);h=b;}else if(g!==E.name){h={"Path":E.value};}else if(E.value==="false"){h=b;}if(h){o[T]=o[T]||{};o[T][p]=h;}},liftSAPData:function(o,t){if(!o.extensions){return;}o.extensions.forEach(function(E){if(E.namespace==="http://www.sap.com/Protocols/SAPData"){o["sap:"+E.name]=E.value;U.addV4Annotation(o,E,t);}});switch(t){case"Property":if(o["sap:updatable"]==="false"){if(o["sap:creatable"]==="false"){o["Org.OData.Core.V1.Computed"]=B;}else{o["Org.OData.Core.V1.Immutable"]=B;}}break;case"EntitySet":if(o["sap:searchable"]!=="true"){o["Org.OData.Capabilities.V1.SearchRestrictions"]={"Searchable":b};}break;default:}},merge:function(A,o,M){var S=o.dataServices.schema;if(!S){return;}S.forEach(function(g,i){var h;delete g.annotations;U.liftSAPData(g);g.$path="/dataServices/schema/"+i;h=g["sap:schema-version"];if(h){g["Org.Odata.Core.V1.SchemaVersion"]={String:h};}e(g,A[g.namespace]);U.visitParents(g,A,"association",function(j,C){U.visitChildren(j.end,C);});U.visitParents(g,A,"complexType",function(C,j){U.visitChildren(C.property,j,"Property");U.addSapSemantics(C);});U.visitParents(g,A,"entityType",U.visitEntityType);});S.forEach(function(g){U.visitParents(g,A,"entityContainer",function(E,C){U.visitChildren(E.associationSet,C);U.visitChildren(E.entitySet,C,"EntitySet",S);U.visitChildren(E.functionImport,C,"",null,U.visitParameters.bind(this,A,g,E));});});U.addUnitAnnotations(S,M);},visitChildren:function(C,g,t,S,h,i){if(!C){return;}if(i){C=C.slice(i);}C.forEach(function(o){U.liftSAPData(o,t);});C.forEach(function(o){var E;if(t==="EntitySet"){E=U.getObject(S,"entityType",o.entityType);U.calculateEntitySetAnnotations(o,E);}if(h){h(o);}e(o,g[o.name||o.role]);});},visitEntityType:function(E,C){U.visitChildren(E.property,C,"Property");U.visitChildren(E.navigationProperty,C);U.addSapSemantics(E);},visitParameters:function(A,S,E,F){var g;if(!F.parameter){return;}g=U.getChildAnnotations(A,S.namespace+"."+E.name,true);F.parameter.forEach(function(p){U.liftSAPData(p);e(p,g[F.name+"/"+p.name]);});},visitParents:function(S,A,g,C,i){var p=S[g];function h(P,j){var q=S.namespace+"."+P.name,k=U.getChildAnnotations(A,q,g==="entityContainer");U.liftSAPData(P);P.namespace=S.namespace;P.$path=S.$path+"/"+g+"/"+j;C(P,k);e(P,A[q]);}if(!p){return;}if(i!==undefined){h(p[i],i);}else{p.forEach(h);}}};return U;},false);
