/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_CreatedContextsCache","./Context","./ODataAnnotations","./ODataContextBinding","./ODataListBinding","./ODataTreeBinding","sap/base/assert","sap/base/Log","sap/base/security/encodeURL","sap/base/util/deepEqual","sap/base/util/deepExtend","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/uid","sap/base/util/UriParameters","sap/ui/base/SyncPromise","sap/ui/core/library","sap/ui/core/message/Message","sap/ui/core/message/MessageParser","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/FilterProcessor","sap/ui/model/Model","sap/ui/model/odata/CountMode","sap/ui/model/odata/MessageScope","sap/ui/model/odata/ODataMetadata","sap/ui/model/odata/ODataMetaModel","sap/ui/model/odata/ODataMessageParser","sap/ui/model/odata/ODataPropertyBinding","sap/ui/model/odata/ODataUtils","sap/ui/model/odata/OperationMode","sap/ui/model/odata/UpdateMethod","sap/ui/thirdparty/datajs","sap/ui/thirdparty/URI","sap/ui/util/isCrossOriginURL"],function(_,C,O,a,b,c,d,L,e,f,g,h,l,m,o,p,u,U,S,q,M,r,B,s,F,t,v,w,x,y,z,A,D,E,G,H,I,J){"use strict";var K="sap.ui.model.odata.v2.ODataModel",N=q.MessageType,P={};P[N.Error]=0;P[N.Warning]=1;P[N.Success]=2;P[N.Information]=3;P[N.None]=4;var Q=t.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(i,j){t.apply(this,arguments);var k,n,R,T,W,V,X,Y,Z,$,a1,b1,c1,d1,e1,f1,g1,h1,i1,j1,k1,l1,m1,n1,o1,p1,q1,r1,s1,t1,u1=this;if(typeof(i)==="object"){j=i;this.sServiceUrl=j.serviceUrl;}else{this.sServiceUrl=i;}this.mCodeListModelParams=this.createCodeListModelParameters(j);if(j){k=j.user;n=j.password;R=j.headers;T=j.tokenHandling;W=j.withCredentials;V=j.maxDataServiceVersion;X=j.useBatch;Y=j.refreshAfterChange;Z=j.annotationURI;$=j.loadAnnotationsJoined;c1=j.defaultBindingMode;a1=j.defaultCountMode;b1=j.preliminaryContext;d1=j.defaultOperationMode;e1=j.metadataNamespaces;f1=j.serviceUrlParams;g1=j.metadataUrlParams;h1=j.json;i1=j.messageParser;j1=j.skipMetadataAnnotationParsing;k1=j.defaultUpdateMethod;l1=j.disableHeadRequestForToken;m1=j.sequentializeRequests;n1=j.disableSoftStateHeader;o1=j.bindableResponseHeaders;p1=j.warmupUrl;q1=j.canonicalRequests;r1=j.tokenHandlingForGet;s1=j.earlyTokenRequest;t1=j.persistTechnicalMessages;}this.mPathCache={};this.mInvalidatedPaths={};this.bCanonicalRequests=!!q1;this.bTokenHandlingForGet=!!r1;this.sMessageScope=w.RequestedObjects;this.sWarmupUrl=p1;this.bWarmup=!!p1;this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.mUnsupportedFilterOperators={"Any":true,"All":true};this.sDefaultBindingMode=c1||B.OneWay;this.bIsMessageScopeSupported=false;this.iPendingDeferredRequests=0;this.bJSON=h1!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredGroups={};this.mLaunderingState={};this.sDefaultUpdateMethod=k1||G.Merge;this.bTokenHandling=T!==false;this.bWithCredentials=W===true;this.bUseBatch=X!==false;this.bRefreshAfterChange=Y!==false;this.sMaxDataServiceVersion=V;this.bLoadAnnotationsJoined=$!==false;this.sAnnotationURI=Z;this.sDefaultCountMode=a1||v.Request;this.sDefaultOperationMode=d1||E.Default;this.sMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=!!j1;this.bDisableHeadRequestForToken=!!l1;this.bSequentializeRequests=!!m1;this.bDisableSoftStateHeader=!!n1;this.aBindableResponseHeaders=o1?o1:null;this.bPreliminaryContext=b1||false;this.mMetadataUrlParams=g1||{};this.mChangedEntities4checkUpdate={};this.bPersistTechnicalMessages=t1===undefined?undefined:!!t1;this.oCreatedContextsCache=new _();if(i1){i1.setProcessor(this);}this.oMessageParser=i1;this.sDefaultChangeGroup="changes";this.setDeferredGroups([this.sDefaultChangeGroup]);this.setChangeGroups({"*":{groupId:this.sDefaultChangeGroup}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.pSequentialRequestCompleted=Promise.resolve();this.pReadyForRequest=Promise.resolve();var v1=this.sServiceUrl.split("?");if(v1.length>1){this.sServiceUrl=v1[0];if(v1[1]){this.aUrlParams.push(v1[1]);}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=k;this.sPassword=n;if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.oHeaders={};this.setHeaders(R);if(!this.bDisableSoftStateHeader){this.oHeaders["sap-contextid-accept"]="header";this.mCustomHeaders["sap-contextid-accept"]="header";}var w1=this._getServerUrl();this.sMetadataUrl=this.sWarmupUrl||this._createMetadataUrl("/$metadata");this.oSharedServerData=Q._getSharedData("server",w1);this.oSharedServiceData=Q._getSharedData("service",this.sServiceUrl);this.oSharedMetaData=Q._getSharedData("meta",this.sMetadataUrl);this.bUseCache=this._cacheSupported(this.sMetadataUrl);if(!this.oSharedMetaData.oMetadata||this.oSharedMetaData.oMetadata.bFailed){this.oMetadata=new x(this.sMetadataUrl,{async:true,cacheKey:this.bUseCache?this.sMetadataUrl:undefined,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:e1,withCredentials:this.bWithCredentials});if(!this.bWarmup){this.oSharedMetaData.oMetadata=this.oMetadata;}}else{this.oMetadata=this.oSharedMetaData.oMetadata;}this.oAnnotations=new O(this.oMetadata,{source:this.sAnnotationURI,skipMetadata:this.bSkipMetadataAnnotationParsing,headers:this.mCustomHeaders,combineEvents:true,cacheKey:this._getAnnotationCacheKey(this.sMetadataUrl),useCache:this.bUseCache});if(!this.bDisableSoftStateHeader){delete this.mCustomHeaders["sap-contextid-accept"];}this.oAnnotations.attachAllFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachSomeLoaded(this.onAnnotationsLoaded,this);this.pAnnotationsLoaded=this.oAnnotations.loaded();if(f1){this.aUrlParams=this.aUrlParams.concat(D._createUrlParamsArray(f1));}this.onMetadataFailed=function(x1){u1.fireMetadataFailed(x1.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachFailed(this.onMetadataFailed);}this.oMetadata.loaded().then(function(){u1._initializeMetadata();});if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";}if(this.bTokenHandling){if(this.oSharedServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}else if(this.oSharedServerData.securityToken){this.oSharedServiceData.securityToken=this.oSharedServerData.securityToken;this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}if(s1){this.securityTokenAvailable();}}this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}if(!this.mCustomHeaders["X-Requested-With"]&&!J(this.sServiceUrl)){this.oHeaders["X-Requested-With"]="XMLHttpRequest";}},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","getPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}});Q.M_EVENTS={MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};Q.prototype.attachBatchRequestFailed=function(i,j,k){this.attachEvent("batchRequestFailed",i,j,k);return this;};Q.prototype.detachBatchRequestFailed=function(i,j){this.detachEvent("batchRequestFailed",i,j);return this;};Q.prototype.fireBatchRequestFailed=function(i){this.fireEvent("batchRequestFailed",i);return this;};Q.prototype.attachBatchRequestSent=function(i,j,k){this.attachEvent("batchRequestSent",i,j,k);return this;};Q.prototype.detachBatchRequestSent=function(i,j){this.detachEvent("batchRequestSent",i,j);return this;};Q.prototype.fireBatchRequestSent=function(i){this.fireEvent("batchRequestSent",i);return this;};Q.prototype.attachBatchRequestCompleted=function(i,j,k){this.attachEvent("batchRequestCompleted",i,j,k);return this;};Q.prototype.detachBatchRequestCompleted=function(i,j){this.detachEvent("batchRequestCompleted",i,j);return this;};Q.prototype.fireBatchRequestCompleted=function(i){this.fireEvent("batchRequestCompleted",i);return this;};Q.mSharedData={server:{},service:{},meta:{}};Q._getSharedData=function(i,k){var j=this.mSharedData[i][k];if(!j){j={};this.mSharedData[i][k]=j;}return j;};Q.prototype._initializeMetadata=function(){if(this.bDestroyed){return;}this.bIsMessageScopeSupported=this.oMetadata._isMessageScopeSupported();var i=function(){this.fireMetadataLoaded({metadata:this.oMetadata});L.debug(this+" - metadataloaded fired");}.bind(this);this.initialize();if(this.bLoadAnnotationsJoined){this.oAnnotations.loaded().then(i,this.fireMetadataFailed.bind(this));}else{i();}};Q.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh();}};Q.prototype.fireAnnotationsLoaded=function(i){this.fireEvent("annotationsLoaded",i);return this;};Q.prototype.attachAnnotationsLoaded=function(i,j,k){this.attachEvent("annotationsLoaded",i,j,k);return this;};Q.prototype.detachAnnotationsLoaded=function(i,j){this.detachEvent("annotationsLoaded",i,j);return this;};Q.prototype.fireAnnotationsFailed=function(i){this.fireEvent("annotationsFailed",i);L.debug(this+" - annotationsfailed fired");return this;};Q.prototype.attachAnnotationsFailed=function(i,j,k){this.attachEvent("annotationsFailed",i,j,k);return this;};Q.prototype.detachAnnotationsFailed=function(i,j){this.detachEvent("annotationsFailed",i,j);return this;};Q.prototype.fireMetadataLoaded=function(i){this.fireEvent("metadataLoaded",i);return this;};Q.prototype.attachMetadataLoaded=function(i,j,k){this.attachEvent("metadataLoaded",i,j,k);return this;};Q.prototype.detachMetadataLoaded=function(i,j){this.detachEvent("metadataLoaded",i,j);return this;};Q.prototype.fireMetadataFailed=function(i){this.fireEvent("metadataFailed",i);return this;};Q.prototype.attachMetadataFailed=function(i,j,k){this.attachEvent("metadataFailed",i,j,k);return this;};Q.prototype.detachMetadataFailed=function(i,j){this.detachEvent("metadataFailed",i,j);return this;};Q.prototype._createEventInfo=function(R,k,n){var T={};T.url=R.requestUri;T.method=R.method;T.async=R.async;T.headers=R.headers;if(n){T.requests=[];for(var i=0;i<n.length;i++){var V={};if(Array.isArray(n[i])){var W=n[i];for(var j=0;j<W.length;j++){var R=W[j].request;var X=n[i][j].response;V={};V.url=R.requestUri;V.method=R.method;V.headers=R.headers;if(X){V.response={};if(R._aborted){V.success=false;V.response.statusCode=0;V.response.statusText="abort";}else{V.success=true;if(X.message){V.response.message=X.message;X=X.response;V.response.responseText=X.body;V.success=false;}V.response.headers=X.headers;V.response.statusCode=X.statusCode;V.response.statusText=X.statusText;}}T.requests.push(V);}}else{var R=n[i].request;var X=n[i].response;V.url=R.requestUri;V.method=R.method;V.headers=R.headers;if(X){V.response={};if(R._aborted){V.success=false;V.response.statusCode=0;V.response.statusText="abort";}else{V.success=true;if(X.message){V.response.message=X.message;X=X.response;V.response.responseText=X.body;V.success=false;}V.response.headers=X.headers;V.response.statusCode=X.statusCode;V.response.statusText=X.statusText;}}T.requests.push(V);}}}if(k){T.response={};T.success=true;if(k.message){T.response.message=k.message;T.success=false;}if(k.response){k=k.response;}if(k&&k.statusCode!=undefined){T.response.headers=k.headers;T.response.statusCode=k.statusCode;T.response.statusText=k.statusText;T.response.responseText=k.body!==undefined?k.body:k.responseText;if(k.expandAfterCreateFailed){T.response.expandAfterCreateFailed=true;}if(k.expandAfterFunctionCallFailed){T.response.expandAfterFunctionCallFailed=true;}}}T.ID=R.requestID;return T;};Q.prototype._createRequestID=function(){var R;R=u();return R;};Q.prototype._getServerUrl=function(){var i,j;i=new I(this.sServiceUrl).absoluteTo(document.baseURI);j=new I("/").absoluteTo(i).toString();return j;};Q.prototype._createMetadataUrl=function(i){if(i.indexOf(this.sServiceUrl)==-1){if(!i.startsWith("/")){i="/"+i;}i=this.sServiceUrl+i;}var j=U.fromURL(i||window.location.href);var k=Object.assign({},this.mMetadataUrlParams);Array.from(j.keys()).forEach(function(T){k[T]=j.get(T);});var n=D._createUrlParamsArray(k);var R=i.split("?");if(R.length>1){i=R[0];}return this._addUrlParams(i,n);};Q.prototype._addUrlParams=function(i,j){var k=[];if(this.aUrlParams){k=k.concat(this.aUrlParams);}if(j){k=k.concat(j);}if(k.length>0){i+="?"+k.join("&");}return i;};Q.prototype._createRequestUrl=function(i,j,k,n){return this._createRequestUrlWithNormalizedPath(this._normalizePath(i,j),k,n);};Q.prototype._createRequestUrlWithNormalizedPath=function(n,i,j){var k="";if(!j){k=this.sServiceUrl+n;}else{k=n.substr(n.indexOf('/')+1);}return this._addUrlParams(k,i);};Q.prototype._importData=function(j,k,R,n,T,V,W,X){var Y=this,Z,$,a1,b1;n=n||"";V=V||"";if(j.results&&Array.isArray(j.results)){Z=[];h(j.results,function(i,i1){var V=Y._getKey(i1);V=Y._importData(i1,k,R,n.substr(0,n.lastIndexOf("/")),T,V);if(V){Z.push(V);}});return Z;}else{if(V){n="/"+V;T+=V.substr(V.indexOf("("));}else{V=this._getKey(j);}if(!V){return V;}a1=this._getEntity(V);b1=a1;if(!a1||(a1.__metadata&&a1.__metadata.invalid)){if(!b1){b1=j;}a1=j;V=this._addEntity(a1);}if(this.aBindableResponseHeaders){var c1={};for(var d1 in R.headers){var e1=d1.toLowerCase();if(this.aBindableResponseHeaders.indexOf(e1)>-1){c1[e1]=R.headers[d1];}}if(!m(c1)){if(!j.__metadata){j.__metadata={};}j.__metadata.headers=c1;}}h(j,function(i,i1){if(i1&&(i1.__metadata&&i1.__metadata.uri||i1.results)&&!i1.__deferred){var j1=n+"/"+i;var k1=T+"/"+i;$=Y._importData(i1,k,R,j1,k1,undefined,false,"/"+V+"/"+i);if(Array.isArray($)){a1[i]={__list:$};}else{if(b1[i]&&b1[i].__ref){if(b1[i].__ref!==$){Y.mInvalidatedPaths[n.substr(n.lastIndexOf("("))+"/"+i]="/"+$;}}a1[i]={__ref:$};}}else if(!i1||!i1.__deferred){if(b1[i]&&i1===null){Y.mInvalidatedPaths[n.substr(n.lastIndexOf("("))+"/"+i]=null;}a1[i]=i1;}});var f1={};f1[V]=a1;if(this.hasContext("/"+V)&&this.getContext("/"+V).isPreliminary()){var g1=this.getContext("/"+V);g1.setUpdated(true);g1.setPreliminary(false);}this._updateChangedEntities(f1);k[V]=true;n=n||'/'+V;T=T||n;var h1=this.resolveFromCache(T);if(h1==="/"+V||(h1&&h1.split("/").length>2)){this._writePathCache(h1,"/"+V,W);}this._writePathCache(n,"/"+V,W);this._writePathCache(T,"/"+V,W,true);if(X){this._writePathCache(X,"/"+V,W);}return V;}};Q.prototype._writePathCache=function(i,j,k,n){var R,T,V,W,X,Y;if(i&&j){if(!this.mPathCache[i]){this.mPathCache[i]={};}if(!k&&i.lastIndexOf("/")===0){j=i;}this.mPathCache[i].canonicalPath=j;if(n){X=i.split("/");for(Y=3;Y<X.length;Y+=1){V=X.slice(0,Y).join("/");W=this.mPathCache[V];if(W){R=W.canonicalPath+i.slice(V.length);T=this.mPathCache[R];if(T){T.canonicalPath=j;}}}}}};Q.prototype._removeReferences=function(j){var k=this,n;if(!j){return j;}if(j.results){n=[];h(j.results,function(i,R){n.push(k._removeReferences(R));});return n;}else{h(j,function(i,R){if(R){if(R["__ref"]||R["__list"]){delete j[i];}}});return j;}};Q.prototype._restoreReferences=function(j,V){var k=this,n,R,T;function W(n){var R=V[n];if(!R){R=k._getObject("/"+n);d(R,"ODataModel inconsistent: "+n+" not found!");if(R){R=p({},R);V[n]=R;k._restoreReferences(R,V);}}return R;}if(!V){V={};}h(j,function(X,Y){if(Y){if(Y.__ref){n=Y.__ref;R=W(n);if(R){j[X]=R;}delete Y.__ref;}else if(Y.__list){T=[];h(Y.__list,function(i,n){R=W(n);if(R){T.push(R);}});delete Y.__list;Y.results=T;}}});return j;};Q.prototype.removeData=function(){this.oData={};};Q.prototype.initialize=function(){var i=this.getBindings();i.forEach(function(j){j.initialize();});};Q.prototype.invalidate=function(i){var j;for(var k in this.oData){j=this.oData[k];if(!i||i(k,j)){j.__metadata.invalid=true;}}};Q.prototype.invalidateEntry=function(i){var j;if(typeof i==="string"){if(i.indexOf("/")===0){j=this._getObject(i);}else{j=this.oData[i];}}else if(i instanceof s){j=this._getObject(i.getPath());}if(j&&j.__metadata){j.__metadata.invalid=true;}};Q.prototype.invalidateEntityType=function(i){var j;for(var k in this.oData){j=this.oData[k];if(j.__metadata.type===i){j.__metadata.invalid=true;}}};Q.prototype.refresh=function(i,R,j){if(typeof i==="string"){j=i;i=false;R=false;}if(R){this.removeData();}this._refresh(i,j);};Q.prototype._refresh=function(i,j,k,n){var R=this.getBindings();this.sRefreshGroupId=j;R.forEach(function(T){T._refresh(i,k,n);});this.sRefreshGroupId=undefined;};Q.prototype.checkUpdate=function(i,j,k,n){if(j){this.bForceUpdate=this.bForceUpdate||i;Object.assign(this.mChangedEntities4checkUpdate,k);if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.checkUpdate(this.bForceUpdate,false,this.mChangedEntities4checkUpdate);}.bind(this),0);}return;}i=this.bForceUpdate||i;if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;this.bForceUpdate=undefined;this.mChangedEntities4checkUpdate={};}var R=this.getBindings();R.forEach(function(T){if(!n||this.isMetaModelPath(T.getPath())){T.checkUpdate(i,k);}}.bind(this));this._processAfterUpdate();};Q.prototype.checkDataState=function(i){var j=this.getBindings();j.forEach(function(k){if(k.checkDataState){k.checkDataState(i);}});};Q.prototype.bindProperty=function(i,j,k){var n=new A(this,i,j,k);return n;};Q.prototype.bindList=function(i,j,k,n,R){var T=new b(this,i,j,k,n,R);return T;};Q.prototype.bindTree=function(i,j,k,n,R){var T=new c(this,i,j,k,n,R);return T;};Q.prototype.createBindingContext=function(i,j,k,n,R){var T,V,W,X,Y,Z=this,$;if(j!==null&&typeof j==="object"&&!(j instanceof s)){R=n;n=k;k=j;j=undefined;}if(typeof j=="function"){R=k;n=j;k=undefined;j=undefined;}if(typeof j=="boolean"){R=j;n=undefined;k=undefined;j=undefined;}if(typeof k=="function"){R=n;n=k;k=undefined;}if(typeof k=="boolean"){R=k;n=undefined;k=undefined;}if(typeof n=="boolean"){R=n;n=undefined;}if(k){$=k.canonicalRequest;}$=this._isCanonicalRequestNeeded($);T=this.resolve(i,j,$);if(!T&&$){T=this.resolve(i,j);}Y=this.resolveDeep(i,j);if(!T){if(n){n(null);}return null;}if(R===undefined){R=this._isReloadNeeded(T,k);}if(!R){V=this.resolve(i,j,true);if(V){W=this.getContext(V,Y);}else{W=null;}if(n){n(W);}return W;}function a1(f1){var g1=f1?Z._getKey(f1):null,h1=!(i===""||i.indexOf("/")>0),i1=null,j1,k1;W=null;if(g1){W=Z.getContext('/'+g1,Y);i1={__ref:g1};}if(j&&c1&&h1){j1=j.getPath();j1=j1.substr(1);k1=Z._getEntity(j1);if(k1){k1[i]=i1;}}n(W);}function b1(f1){var g1;if(f1.statusCode=='404'&&j&&c1){var h1=j.getPath();h1=h1.substr(1);g1=Z._getEntity(h1);if(g1){g1[i]={__ref:null};}}n(null);}if(n){var c1=!i.startsWith("/");var d1=[],e1=this.createCustomParams(k);if(e1){d1.push(e1);}if(k&&(k.batchGroupId||k.groupId)){X=k.groupId||k.batchGroupId;}this.read(i,{canonicalRequest:$,context:j,error:b1,groupId:X,success:a1,updateAggregatedMessages:true,urlParameters:d1});}if(k&&k.createPreliminaryContext){T=this.resolve(i,j,$);if(!T&&$){T=this.resolve(i,j);}W=this.getContext(T,Y);return W;}};Q.prototype._updateContext=function(i,j,k){i.sPath=j;if(k!==undefined){i.sDeepPath=k;}this.mContexts[j]=i;};Q.prototype._splitEntries=function(i){return i.replace(/\s/g,"").split(',').map(function(j){return j.split("/");});};Q.prototype._filterOwnSelect=function(i,j){var k,n;if(!j){return[];}n=j.map(function(R){return R.name;});k=i.filter(function(R){return R.length===1;}).map(function(R){return R[0];});if(i.length===0||k.indexOf("*")!==-1||k.indexOf("**")!==-1){return n;}else{return k.filter(function(R){return n.indexOf(R)!==-1;});}};Q.prototype._filterOwnExpand=function(i,j){return i.map(function(k){return k[0];}).filter(function(V,k,n){return n.indexOf(V)===k;}).filter(function(V){return j.length===0||j.some(function(k){return k.indexOf(V)===0||k.indexOf("**")===0;});});};Q.prototype._filterSelectByNavProp=function(i,n){return i.filter(function(j){return j[0]===n;}).map(function(j){return j.length>1?j.slice(1):["**"];});};Q.prototype._filterExpandByNavProp=function(i,n){return i.filter(function(j){return j.length>1&&j[0]===n;}).map(function(j){return j.slice(1);});};Q.prototype._isReloadNeeded=function(k,n){var R=this,T=this.oMetadata,V,W=this._getObject(k),X=[],Y=[];if(!this.oMetadata.isLoaded()){return true;}V=this.oMetadata._getEntityTypeByPath(k);if(this._isCreatedEntity(W)){return false;}function Z(V,W,Y,X){var $,a1,b1,c1,d1,e1,f1,g1,h1;if(!V){return false;}if(W===null){return false;}if(!W){return true;}if(W.__metadata&&W.__metadata.invalid){return true;}$=R._filterOwnSelect(Y,V.property);for(var i=0;i<$.length;i++){h1=$[i];if(W[h1]===undefined){return true;}}a1=R._filterOwnExpand(X,Y);for(var i=0;i<a1.length;i++){g1=a1[i];b1=W[g1];if(b1===null){continue;}if(b1===undefined||b1.__deferred){return true;}c1=T._getEntityTypeByNavProperty(V,g1);e1=R._filterSelectByNavProp(Y,g1);f1=R._filterExpandByNavProp(X,g1);if(b1.__ref){d1=R._getEntity(b1.__ref);if(Z(c1,d1,e1,f1)){return true;}}if(b1.__list){for(var j=0;j<b1.__list.length;j++){d1=R._getEntity(b1.__list[j]);if(Z(c1,d1,e1,f1)){return true;}}}}return false;}if(n){if(n.select){Y=this._splitEntries(n.select);}if(n.expand){X=this._splitEntries(n.expand);}}return Z(V,W,Y,X);};Q.prototype.createCustomParams=function(i){var j=[],k,n={expand:true,select:true};for(var R in i){if(R in n){j.push("$"+R+"="+e(i[R]));}if(R==="custom"){k=i[R];for(R in k){if(R.indexOf("$")===0){L.warning(this+" - Trying to set OData parameter '"+R+"' as custom query option!");}else if(typeof k[R]==='string'){j.push(R+"="+e(k[R]));}else{j.push(R);}}}}return j.join("&");};Q.prototype.bindContext=function(i,j,k){var n=new a(this,i,j,k);return n;};Q.prototype.setDefaultCountMode=function(i){this.sDefaultCountMode=i;};Q.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};Q.prototype._addEntity=function(i){var k=this._getKey(i);this.oData[k]=i;return k;};Q.prototype._removeEntity=function(k){k=k&&D._normalizeKey(k);delete this.oData[k];delete this.mChangedEntities[k];delete this.mContexts["/"+k];};Q.prototype._getEntity=function(k){var i=this.oData[k];if(!i){k=k&&D._normalizeKey(k);i=this.oData[k];}return i;};Q.prototype._getKey=function(V){var k,i;if(V instanceof s){k=V.getPath().substr(1);}else if(V&&V.__metadata&&V.__metadata.uri){i=V.__metadata.uri;k=i.substr(i.lastIndexOf("/")+1);}else if(typeof V==='string'){k=V.substr(V.lastIndexOf("/")+1);}if(!this.oData[k]){k=k&&D._normalizeKey(k);}return k;};Q.prototype.getKey=function(V){return this._getKey(V);};Q.prototype.createKey=function(j,k){var n=this.oMetadata._getEntityTypeByPath(j),R=j,T=this,V,W;d(n,"Could not find entity type of collection \""+j+"\" in service metadata!");R+="(";if(n.key.propertyRef.length===1){V=n.key.propertyRef[0].name;d(V in k,"Key property \""+V+"\" is missing in object!");W=this.oMetadata._getPropertyMetadata(n,V);R+=encodeURIComponent(D.formatValue(k[V],W.type));}else{h(n.key.propertyRef,function(i,X){if(i>0){R+=",";}V=X.name;d(V in k,"Key property \""+V+"\" is missing in object!");W=T.oMetadata._getPropertyMetadata(n,V);R+=V;R+="=";R+=encodeURIComponent(D.formatValue(k[V],W.type));});}R+=")";return R;};Q.prototype.getProperty=function(i,j,k){var V=this._getObject(i,j);if(!k){return V;}if(!o(V)){return V;}V=p({},V);if(k===true){return this._restoreReferences(V);}else{return this._removeReferences(V);}};Q.prototype.getObject=function(n,R,T){if(o(R)){T=R;R=undefined;}var V=this,W=this.resolve(n,R),X=this._getObject(W),Y=this.oMetadata._getEntityTypeByPath(W),Z=[],$=[];if(!Y||!o(X)||!X.__metadata||!X.__metadata.uri){return X;}if(!T||!(T.select||T.expand)){return p({},X);}function a1(Y,X,$,Z){var b1,c1,d1,e1,f1,g1,h1,i1,j1,k1,l1,m1,n1;if(!X){return undefined;}if(!Y){return undefined;}d1=V._filterOwnSelect($,Y.property);c1={};for(var i=0;i<d1.length;i++){m1=d1[i];if(X[m1]!==undefined){c1[m1]=X[m1];}else{L.fatal("No data loaded for select property: "+m1+" of entry: "+V.getKey(X));return undefined;}}if(X.__metadata){c1.__metadata=X.__metadata;}b1=V._filterOwnExpand(Z,$);for(var i=0;i<b1.length;i++){l1=b1[i];f1=X[l1];g1=V.oMetadata._getEntityTypeByNavProperty(Y,l1);j1=V._filterSelectByNavProp($,l1);k1=V._filterExpandByNavProp(Z,l1);if(f1&&f1.__ref){i1=V._getObject("/"+f1.__ref);h1=a1(g1,i1,j1,k1);if(h1!==undefined){c1[l1]=h1;}else{L.fatal("No data loaded for expand property: "+l1+" of entry: "+V.getKey(h1));return undefined;}}if(f1&&f1.__list){n1=[];for(var j=0;j<f1.__list.length;j++){i1=V._getObject("/"+f1.__list[j]);h1=a1(g1,i1,j1,k1);if(h1!==undefined){n1.push(h1);}else{L.fatal("No data loaded for expand property: "+l1+" of entry: "+V.getKey(h1));return undefined;}}c1[l1]=n1;}}e1=V._filterOwnSelect($,Y.navigationProperty);for(var k=0;k<e1.length;k++){l1=e1[k];if(b1.indexOf(l1)===-1){var o1=c1.__metadata.uri+"/"+l1;c1[l1]={__deferred:{uri:o1}};}}return c1;}if(T.select){$=this._splitEntries(T.select);}if(T.expand){Z=this._splitEntries(T.expand);}X=a1(Y,X,$,Z);return X;};Q.prototype._getObject=function(i,j,k){var n,R,T,V,W,X,Y,Z,$,a1,b1,c1=this.isLegacySyntax()?this.oData:null;a1=this.resolve(i,j,this.bCanonicalRequests);if(!a1&&this.bCanonicalRequests){a1=this.resolve(i,j);}if(!a1){return c1;}if(this._isMetadataPath(a1)){if(this.oMetadata&&this.oMetadata.isLoaded()){if(this.isMetaModelPath(a1)){Y=this.getMetaModel();T=y.getCodeListTerm(a1);if(T){R=Y.fetchCodeList(T);if(R.isFulfilled()){return R.getResult();}if(R.isRejected()){R.caught();}return undefined;}if(!this.bMetaModelLoaded){return null;}b1=a1.indexOf('/##');V=a1.substr(0,b1);Z=a1.substr(b1+3);X=Y.getMetaContext(V);c1=Y.getProperty(Z,X);}else{c1=this.oMetadata._getAnnotation(a1);}}else if(y.getCodeListTerm(a1)){return undefined;}}else{if(a1==="/"){return this.oData;}var d1=a1.split("/"),e1=0;W=d1[1];d1.splice(0,2);n=this.mChangedEntities[W];$=this._getEntity(W);c1=k?$:n||$;while(c1&&d1[e1]){var f1=n&&n.hasOwnProperty(d1[e1]);n=n&&n[d1[e1]];$=$&&$[d1[e1]];c1=k||!f1?$:n;if(c1){if(c1.__ref){n=this.mChangedEntities[c1.__ref];$=this._getEntity(c1.__ref);c1=k?$:n||$;}else if(c1.__list){c1=c1.__list;}else if(c1.__deferred){c1=undefined;}}e1++;}}if(o(n)){c1=k?$:p({},$,n);}return c1;};Q.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oSharedServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}}};Q.prototype.resetSecurityToken=function(){delete this.oSharedServiceData.securityToken;delete this.oHeaders["x-csrf-token"];delete this.pSecurityToken;};Q.prototype.getSecurityToken=function(){var T=this.oSharedServiceData.securityToken;if(!T){this.refreshSecurityToken();T=this.oSharedServiceData.securityToken;}return T;};Q.prototype.securityTokenAvailable=function(){if(!this.pSecurityToken){if(this.oSharedServiceData.securityToken){this.pSecurityToken=Promise.resolve(this.oSharedServiceData.securityToken);}else{this.pSecurityToken=new Promise(function(i,j){this.refreshSecurityToken(function(){i(this.oSharedServiceData.securityToken);}.bind(this),function(){j();},true);}.bind(this));}}return this.pSecurityToken;};Q.prototype.refreshSecurityToken=function(i,j,k){var R,T,n={abort:function(){this.request.abort();}},V=this._createRequestUrlWithNormalizedPath("/"),W=this;function X(a1,b1){if(b1){T=W._getHeader("x-csrf-token",b1.headers);W._setSessionContextIdHeader(W._getHeader("sap-contextid",b1.headers));if(T){W.oSharedServerData.securityToken=T;W.oSharedServiceData.securityToken=T;W.pSecurityToken=Promise.resolve(T);W.oHeaders["x-csrf-token"]=T;}else{W.resetSecurityToken();W.bTokenHandling=false;}}if(i){i(a1,b1);}}function Y(a1){W.resetSecurityToken();W.bTokenHandling=false;W._handleError(a1,R);if(j){j(a1);}}function Z(a1){n.request=$("GET",Y);}function $(a1,j){R=W._createRequest(V,"",a1,W._getHeaders(undefined,true),null,null,!!k);R.headers["x-csrf-token"]="Fetch";return W._request(R,X,j,undefined,undefined,W.getServiceMetadata());}if(this.bDisableHeadRequestForToken){n.request=$("GET",Y);}else{n.request=$("HEAD",Z);}return n;};Q.prototype._submitRequest=function(R,j,k){var n=this,T,V,W,X,Y;X=new Promise(function(i,e1){Y=i;});function Z(i,e1){if(j){j(i,e1);}Y();}function $(i){if(n.bTokenHandling&&i.response){var e1=n._getHeader("x-csrf-token",i.response.headers);if(!R.bTokenReset&&i.response.statusCode=='403'&&e1&&e1.toLowerCase()==="required"){n.resetSecurityToken();R.bTokenReset=true;b1();return;}}if(k){k(i);}Y();}function a1(R){if(n.bTokenHandling&&(R.method!=="GET"||n.bTokenHandlingForGet)){n.pReadyForRequest=n.securityTokenAvailable();}return n.pReadyForRequest;}function b1(){if(n.bTokenHandling){delete R.headers["x-csrf-token"];}a1(R).then(function(i){if(n.bTokenHandling&&(R.method!=="GET"||n.bTokenHandlingForGet)){R.headers["x-csrf-token"]=i;}d1();},function(){d1();});}function c1(e1,R,f1){var g1,h1=R.eventInfo.requests;if(h1){h(h1,function(i,R){if(Array.isArray(R)){R.forEach(function(R){h(R.parts,function(i,i1){g1=n._createEventInfo(R.request,i1.fnError);n["fireRequest"+e1](g1);});});}else{if(R.parts){h(R.parts,function(i,i1){g1=n._createEventInfo(R.request,i1.fnError);n["fireRequest"+e1](g1);});}else{g1=n._createEventInfo(R.request,R.fnError);n["fireRequest"+e1](g1);}}});if(R.eventInfo.batch){g1=n._createEventInfo(R,f1,h1);n["fireBatchRequest"+e1](g1);}}}function d1(){if(n.sSessionContextId){R.headers["sap-contextid"]=n.sSessionContextId;}V=n._request(R,Z,$,T,undefined,n.getServiceMetadata());if(R.eventInfo){c1("Sent",R,null);delete R.eventInfo;}if(W&&V){V.abort();}}T=n._getODataHandler(R.requestUri);if(this.bSequentializeRequests){this.pSequentialRequestCompleted.then(function(){b1();});this.pSequentialRequestCompleted=X;}else{b1();}return{abort:function(){if(V){V.abort();}W=true;}};};Q.prototype._setSessionContextIdHeader=function(i){if(i){this.sSessionContextId=i;}};Q.prototype._submitSingleRequest=function(R){var j=this,k,n={},T={},V={};function W(Y,Z){if(Y===undefined&&Z.statusCode===200){X({message:"Response did not contain a valid OData result",response:Z});return;}function $(Y,Z){for(var i=0;i<R.parts.length;i++){if(R.parts[i].request._aborted){j._processAborted(R.parts[i].request,Z);}else if(R.parts[i].fnSuccess){R.parts[i].fnSuccess(Y,Z);}}if(R.request.requestUri.indexOf("$count")===-1){j.checkUpdate(false,false,T);if(R.bRefreshAfterChange){j._refresh(false,undefined,n,V);}}}j._processSuccess(R.request,Z,$,T,n,V);j._invalidatePathCache();j._setSessionContextIdHeader(j._getHeader("sap-contextid",Z.headers));}function X(Y){if(Y.message=="Request aborted"){for(var i=0;i<R.parts.length;i++){j._processAborted(R.parts[i].request,Y);}}else{for(var i=0;i<R.parts.length;i++){j._processError(R.parts[i].request,Y,R.parts[i].fnError);}}j._processAfterUpdate();}R.request.eventInfo={requests:R.parts,batch:false};k=this._submitRequest(R.request,W,X);return k;};Q.prototype._submitBatchRequest=function(k,R,n,T){var V=this,W={},X={},Y={},Z={};function $(j,f1,g1){var h1,i1,i;for(i=0;i<j.parts.length;i++){if(g1||j.parts[i].request._aborted){V._processAborted(j.parts[i].request,f1);}else if(f1.message){V._processError(j.parts[i].request,f1,j.parts[i].fnError);}else{if(j.request.contentID){h1=j.request.contentID;if(j.request.created||j.request.functionMetadata){i1=V._getKey(f1.data);X[h1]={key:i1,deepPath:j.request.deepPath.replace("('"+h1+"')",i1.slice(i1.indexOf("(")))};}else{i1=X[h1].key;j.request.requestUri=j.request.requestUri.replace("$"+h1,i1);j.request.deepPath=X[h1].deepPath;}}V._processSuccess(j.parts[i].request,f1,j.parts[i].fnSuccess,Y,W,Z,false,undefined,X);}}}function a1(f1,g1){if(f1===undefined&&g1.statusCode===200){b1({message:"Response did not contain a valid OData batch result",response:g1});return;}var h1,i1,j1,k1=f1.__batchResponses;if(k1){var i,j;for(i=0;i<k1.length;i++){h1=k1[i];if(Array.isArray(R[i])){if(h1.message){for(j=0;j<R[i].length;j++){h1.$reported=false;i1=R[i][j];$(i1,h1);i1.response=h1;}}else{j1=h1.__changeResponses;for(j=0;j<j1.length;j++){var l1=j1[j];i1=R[i][j];$(i1,l1);i1.response=l1;}}}else{i1=R[i];$(i1,h1);i1.response=h1;}}V._invalidatePathCache();V.checkUpdate(false,false,Y);}V._processSuccess(k,g1,n,Y,W,Z,true,R);V._setSessionContextIdHeader(V._getHeader("sap-contextid",g1.headers));}function b1(j){var f1=j.message=="Request aborted";j.$reported=true;h(R,function(i,g1){if(Array.isArray(g1)){g1.forEach(function(g1){$(g1,j,f1);});}else{$(g1,j,f1);}});V._processAfterUpdate();if(f1){V._processAborted(k,j,true);}else{j.$reported=false;V._processError(k,j,T,true,R);}}k.eventInfo={requests:R,batch:true};var c1=this._submitRequest(k,a1,b1);function d1(j){var T;for(var i=0;i<j.parts.length;i++){T=j.parts[i].fnError;if(!j.parts[i].request._aborted&&T){T(Q._createAbortedError());}}}var e1={abort:function(j){h(R,function(i,f1){if(Array.isArray(f1)){f1.forEach(function(f1){d1(f1);});}else{d1(f1);}});if(T&&!j){T(Q._createAbortedError());}c1.abort();}};return e1;};Q.prototype._invalidatePathCache=function(){var i=this,j;if(Object.keys(this.mInvalidatedPaths).length>0){Object.keys(this.mPathCache).forEach(function(k){for(var n in i.mInvalidatedPaths){j=k.indexOf(n);if(j>-1){if(j+n.length!==k.length){var R=k.substr(j+n.length);i.mPathCache[k].canonicalPath=i.mInvalidatedPaths[n]===null?null:i.mInvalidatedPaths[n]+R;}else{i.mPathCache[k].canonicalPath=i.mInvalidatedPaths[n];}}}});}this.mInvalidatedPaths={};};Q.prototype._createBatchRequest=function(i){var j,R,k={},n={},T=true;n.__batchRequests=i;for(var V in i){if(i[V]&&i[V].__changeRequests||i[V]&&i[V].headers&&!i[V].headers['sap-cancel-on-close']){T=false;break;}}j=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){j+="?"+this.aUrlParams.join("&");}l(k,this.mCustomHeaders,this.oHeaders);k["Accept"]="multipart/mixed";delete k["Content-Type"];k['sap-cancel-on-close']=T;R={headers:k,requestUri:j,method:"POST",data:n,user:this.sUser,password:this.sPassword,async:true};R.withCredentials=this.bWithCredentials;return R;};Q.prototype.abortInternalRequest=function(j,k){var R=this.mRequests;var n,T;if(k){n=k.requestKey;T=k.path;}if(j in this.mDeferredGroups){R=this.mDeferredRequests;}var V=function(X){for(var i=0;i<X.parts.length;i++){X.parts[i].requestHandle.abort();}};var W=R[j];if(W){if(n in W.map){V(W.map[n]);}else if(T){h(W.map,function(n,i){if(n.indexOf(T)>=0){V(i);}});}else if(j&&!k){h(W.map,function(i,X){V(X);});}}};Q.prototype._pushToRequestQueue=function(R,i,j,k,n,T,V,W){var X=R[i],Y=k.key?k.key:k.method+":"+k.requestUri;if(this.bWarmup){return;}if(!X){X={};X.map={};X.requests=[];R[i]=X;}if(Y in X.map&&(k.key||k.method==='GET')){var Z=X.map[Y];var $=Z.request;k.deepPath=$.deepPath;if(this.sMessageScope===w.BusinessObject){k.headers["sap-message-scope"]=$.headers["sap-message-scope"];}if(Z.bRefreshAfterChange===undefined){Z.bRefreshAfterChange=W;}if(!k.key){Z.parts.push({request:k,fnSuccess:n,fnError:T,requestHandle:V});}if(k.method==="GET"){delete $.data;}else{$.method=k.method;$.headers=k.headers;$.data=k.data;if(k.method==="PUT"){delete $.headers["x-http-method"];}if($._aborted){delete $._aborted;}}if($.functionMetadata){$.requestUri=k.requestUri;$.functionTarget=k.functionTarget;}}else{var Z={request:k,bRefreshAfterChange:W,parts:[{request:k,fnSuccess:n,fnError:T,requestHandle:V}]};if(k.method==="GET"){X.requests.push(Z);}else{if(!X.changes){X.changes={};}var a1=X.changes[j];if(!a1){a1=[];X.changes[j]=a1;}Z.changeSetId=j;a1.push(Z);}X.map[Y]=Z;}};Q.prototype._collectChangedEntities=function(j,k,n){var R=this;if(j.changes){h(j.changes,function(T,V){for(var i=0;i<V.length;i++){if(V[i].bRefreshAfterChange){var W=V[i].request,X="/"+W.requestUri.split("?")[0],Y,Z;if(W.method==="POST"||W.method==="DELETE"){var $=R.oMetadata._getEntityTypeByPath(X);if($){n[$.entityType]=true;}}else{Y=R._getObject(X);if(Y){Z=R._getKey(Y);}else if(X.lastIndexOf("/")===0){Z=R._getKey(X);}if(Z){k[Z]=true;}}}}});}};Q.prototype._processRequestQueue=function(R,j,k,n){var T=this,V,W=[];function X(Z,$){for(var i=0;i<Z.parts.length;i++){var a1=Z.parts[i];if(a1.request._aborted){T._processAborted(Z.request,null);Z.parts.splice(i,1);i--;}else if($){a1.request._handle=$;$.iRelevantRequests++;}}}function Y(){return{iRelevantRequests:0,oRequestHandle:{},abort:function(){this.iRelevantRequests--;if(this.iRelevantRequests===0&&this.oRequestHandle){this.oRequestHandle.abort(true);if(k){k({},undefined);}}}};}if(this.bUseBatch){h(R,function(i,Z){if(i===j||!j){var $={},a1={};T._collectChangedEntities(Z,$,a1);if(Object.keys($).length||Object.keys(a1).length){T.bIncludeInCurrentBatch=true;T._refresh(false,i,$,a1);T.bIncludeInCurrentBatch=false;}}});h(R,function(Z,$){if(Z===j||!j){var a1=[],b1=[],c1,d1;var e1=Y();if($.changes){h($.changes,function(h1,i1){var j1,i,k1;c1={__changeRequests:[]};d1=[];for(i=0;i<i1.length;i++){j1=i1[i].request;V='/'+T.getKey(j1.data);T.increaseLaundering(V,j1.data);X(i1[i],e1);if(i1[i].parts.length>0){T.removeInternalMetadata(j1.data);c1.__changeRequests.push(j1);if(j1.expandRequest){k1=i1[i].parts[0];T._pushToRequestQueue(R,Z,undefined,j1.expandRequest,k1.fnSuccess,k1.fnError,k1.requestHandle,false);}d1.push(i1[i]);}}if(c1.__changeRequests&&c1.__changeRequests.length>0){a1.push(c1);b1.push(d1);}});}if($.requests){var f1=$.requests;for(var i=0;i<f1.length;i++){X(f1[i],e1);if(f1[i].parts.length>0){a1.push(f1[i].request);b1.push(f1[i]);}}}if(a1.length>0){var g1=T._createBatchRequest(a1);e1.oRequestHandle=T._submitBatchRequest(g1,b1,k,n);W.push(e1.oRequestHandle);}delete R[Z];}});}else{h(R,function(Z,$){if(Z===j||!j){if($.changes){h($.changes,function(c1,d1){for(var i=0;i<d1.length;i++){var b1=Y();V='/'+T.getKey(d1[i].request.data);T.increaseLaundering(V,d1[i].request.data);X(d1[i],b1);if(d1[i].parts.length>0){T.removeInternalMetadata(d1[i].request.data);b1.oRequestHandle=T._submitSingleRequest(d1[i]);W.push(b1.oRequestHandle);}}});}if($.requests){var a1=$.requests;for(var i=0;i<a1.length;i++){var b1=Y();X(a1[i],b1);if(a1[i].parts.length>0){b1.oRequestHandle=T._submitSingleRequest(a1[i]);W.push(b1.oRequestHandle);}}}delete R[Z];}});}this.checkDataState(this.mLaunderingState);return W.length==1?W[0]:W;};Q.prototype._processRequestQueueAsync=function(R){var i=this;if(!this.pCallAsync){this.pCallAsync=this.oMetadata.loaded().then(function(){return Promise.resolve().then(function(){i._processRequestQueue(R);i.pCallAsync=undefined;});});}};Q.prototype._processSuccess=function(R,i,j,k,n,T,V,W,X){var Y,Z,$,a1,b1,c1,d1,e1,f1,g1,h1,i1,j1,k1={},l1={},m1=i.data,n1=this;if(!V){Z=!(i.statusCode===204||i.statusCode==='204');j1=R.requestUri;h1=j1.replace(this.sServiceUrl,"");if(!h1.startsWith('/')){h1='/'+h1;}f1=this._normalizePath(h1);b1=this.oMetadata._getEntityTypeByPath(f1);e1=b1&&b1.isFunction;h1=this._normalizePath(h1,undefined,!e1);this.decreaseLaundering(h1,R.data);this._decreaseDeferredRequestCount(R);if(R.functionMetadata){if(i.headers&&i.headers.location){c1=i.headers.location;i1=c1.lastIndexOf(this.sServiceUrl);if(i1>-1){Y=c1.slice(i1+this.sServiceUrl.length);if(R.functionTarget===Y){$=this.getDeepPathForCanonicalPath(Y);if($){R.deepPath=$;}}R.functionTarget=Y;}}if(R.adjustDeepPath){R.deepPath=R.adjustDeepPath({deepPath:$||R.functionTarget,response:p({},i)});}else if(!$){R.deepPath=R.functionTarget;}if(X&&R.contentID){X[R.contentID].deepPath=R.deepPath;}}if(Z&&m1===undefined&&i){this._parseResponse(i,R);L.fatal(this+" - No data was retrieved by service: '"+i.requestUri+"'");n1.fireRequestCompleted({url:i.requestUri,type:"GET",async:i.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false;}if(m1&&!m1.__metadata&&m1.results&&!Array.isArray(m1.results)){m1=m1.results;}if(!i._imported&&m1&&(Array.isArray(m1)||typeof m1=='object')){d1=p({},m1);if(R.key||R.created){n1._importData(d1,l1,i,undefined,undefined,undefined,e1);}else{n1._importData(d1,l1,i,h1,R.deepPath,undefined,e1);}i._imported=true;}a1=this._getEntity(R.key);if(l1&&a1&&a1.__metadata.created&&a1.__metadata.created.functionImport){var o1=[];var p1=a1["$result"];if(p1&&p1.__list){h(l1,function(r1){o1.push(r1);});p1.__list=o1;}else if(p1&&p1.__ref){h(l1,function(r1){p1.__ref=r1;});}}if(!Z){g1=h1.split("/");if(g1[1]){k1[g1[1]]=R;var q1={};q1[g1[1]]=R.data;this._updateChangedEntities(q1);}if(R.method==="DELETE"&&g1[2]!=="$links"){this._removeEntity(g1[1]);}}if(Z&&R.method==="POST"||R.functionMetadata){if(b1){T[b1.entityType]=true;}if(R.key){if(R.created){var r1=this._getKey(m1);var s1=this.getContext("/"+R.key);$=R.deepPath;if(s1.isTransient()&&$.endsWith(")")){R.deepPath=$.slice(0,$.lastIndexOf("("))+r1.slice(r1.indexOf("("));}this._updateContext(s1,'/'+r1,R.deepPath);s1.setUpdated(true);this.callAfterUpdate(function(){s1.setUpdated(false);});a1=this._getEntity(r1);if(a1){delete a1.__metadata.created;}this._removeEntity(R.key);}else{delete this.mChangedEntities[R.key];}}}this._parseResponse(i,R,l1,k1);l(k,l1);l(n,k1);this._updateETag(R,i);}if(j){j(m1,i);}var t1=this._createEventInfo(R,i,W);if(V){this.fireBatchRequestCompleted(t1);}else{this.fireRequestCompleted(t1);}return true;};Q.prototype._processError=function(R,i,j,k,n){var T,V;if(R.functionMetadata){R.deepPath=R.functionTarget;}T=this._handleError(i,R);if(!k){V='/'+this.getKey(R.data);this.decreaseLaundering(V,R.data);this._decreaseDeferredRequestCount(R);}if(j){j(T);}var W=this._createEventInfo(R,T,n);if(k){this.fireBatchRequestCompleted(W);this.fireBatchRequestFailed(W);}else{this.fireRequestCompleted(W);this.fireRequestFailed(W);}};Q.prototype._processAborted=function(R,i,j){var k,n;if(!j){n='/'+this.getKey(R.data);this.decreaseLaundering(n,R.data);this._decreaseDeferredRequestCount(R);}if(i){k=this._createEventInfo(R,Q._createAbortedError());k.success=false;if(j){this.fireBatchRequestCompleted(k);}else{this.fireRequestCompleted(k);}}};Q.prototype._processAfterUpdate=function(){var j=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var i=0;i<j.length;i++){j[i]();}};Q.prototype._processChange=function(k,i,j,R){var T,V,W,X,Y,Z,$,a1,b1,c1,d1,e1,f1,g1=this;if(R&&this.mChangedEntities[k]&&this.mChangedEntities[k].__metadata){this.mChangedEntities[k].__metadata.deepPath=R;}else if(!R&&this.mChangedEntities[k]&&this.mChangedEntities[k].__metadata&&this.mChangedEntities[k].__metadata.deepPath){R=this.mChangedEntities[k].__metadata.deepPath;}W=this.oMetadata._getEntityTypeByPath(k);if(!j){j="MERGE";}b1=p({},this._getObject('/'+k,true),i);if(i.__metadata&&i.__metadata.created){$=i.__metadata.created.method?i.__metadata.created.method:"POST";k=i.__metadata.created.key;V=true;a1=i.__metadata.created;Y=i.__metadata.created.expandRequest;T=i.__metadata.created.contentID;if(i.__metadata.created.functionImport){a1.urlParameters=this._createFunctionImportParameters(i.__metadata.created.key,$,b1);b1=undefined;}else{delete b1.__metadata['uri'];}}else if(j==="MERGE"){$="MERGE";d1=this._getEntity(k);}else{$="PUT";}if(b1&&b1.__metadata){for(var n in b1.__metadata){if(n!=='type'&&n!=='uri'&&n!=='etag'&&n!=='content_type'&&n!=='media_src'){delete b1.__metadata[n];}}}if(b1&&W){var h1=this.oMetadata._getNavigationPropertyNames(W);h1.forEach(function(k1){delete b1[k1];});}if($==="MERGE"&&W&&d1){h(b1,function(k1,l1){if(k1!=='__metadata'){if(f(d1[k1],l1)&&!g1.isLaundering('/'+k+'/'+k1)){delete b1[k1];}}});var i1="/"+k,j1;h(b1,function(k1,l1){if(k1!=='__metadata'){j1=g1.getProperty(i1+"/"+k1+"/#@sap:unit");if(j1){if(b1[j1]===undefined){b1[j1]=d1[j1];}}}});if(d1.__metadata.etag){b1.__metadata.etag=d1.__metadata.etag;}}b1=this._removeReferences(b1);f1=a1&&a1.urlParameters?D._createUrlParamsArray(a1.urlParameters):undefined;Z=a1?this._getHeaders(a1.headers):this._getHeaders();X=a1&&a1.eTag?a1.eTag:this.getETag(b1);e1=this._createRequestUrl('/'+k,null,f1,this.bUseBatch);c1=this._createRequest(e1,R,$,Z,b1,X,undefined,true);if(V){c1.created=true;if(Y){c1.expandRequest=Y;c1.contentID=T;}if(i.__metadata.created.functionMetadata){c1.functionTarget=this.oMetadata._getCanonicalPathOfFunctionImport(i.__metadata.created.functionMetadata,a1.urlParameters);}}if(this.bUseBatch){c1.requestUri=c1.requestUri.replace(this.sServiceUrl+'/','');}return c1;};Q.prototype._resolveGroup=function(k){var i,j,n,R,T,V;j=this.oMetadata._getEntityTypeByPath(k);V=this._getObject('/'+k);if(V){n=V.__metadata.created;if(n){return{groupId:n.groupId,changeSetId:n.changeSetId};}}if(this.mChangeGroups[j.name]){i=this.mChangeGroups[j.name];R=i.groupId;T=i.single?u():i.changeSetId;}else if(this.mChangeGroups['*']){i=this.mChangeGroups['*'];R=i.groupId;T=i.single?u():i.changeSetId;}return{groupId:R,changeSetId:T};};Q.prototype._updateETag=function(R,i){var j,k,n;j=R.requestUri.replace(this.sServiceUrl+'/','');if(!j.startsWith("/")){j="/"+j;}k=this._getObject(j.split("?")[0],undefined,true);n=this._getHeader("etag",i.headers);if(k&&k.__metadata&&n){k.__metadata.etag=n;}};Q.prototype._handleError=function(i,R){var T,j={message:i.message};if(i.response){if(!i.$reported){this._parseResponse(i.response,R);if(this.bTokenHandling){T=this._getHeader("x-csrf-token",i.response.headers);if(i.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){this.resetSecurityToken();}}}j.statusCode=i.response.statusCode;j.statusText=i.response.statusText;j.headers=i.response.headers;j.responseText=i.response.body;}else if(!i.$reported){L.error("The following problem occurred: "+i.message,undefined,K);}i.$reported=true;return j;};Q.prototype.getData=function(i,j,k){return this.getProperty(i,j,k);};Q.prototype._getODataHandler=function(i){if(i.indexOf("$batch")>-1){return H.batchHandler;}else if(i.indexOf("$count")>-1){return undefined;}else if(this.bJSON){return H.jsonHandler;}else{return H.atomHandler;}};Q.prototype.getETag=function(i,j,k){if(typeof i=="object"){k=i;i="";}return this._getETag(i,j,k);};Q.prototype._getETag=function(i,j,k){if(!k||!k.__metadata){k=this._getObject(i,j);}if(k&&k.__metadata){return k.__metadata.etag;}return null;};Q.prototype.forceEntityUpdate=function(k){var i=this.mChangedEntities[k];if(i&&i.__metadata){i.__metadata.etag='*';}else{L.error(this+" - Entity with key "+k+" does not exist or has no change");}};Q.prototype._createRequest=function(i,j,k,n,R,T,V,W){var X;V=V!==false;if(T&&k!=="GET"){n["If-Match"]=T;}if(!n["Content-Type"]&&k!=="DELETE"&&k!=="GET"){if(this.bJSON){n["Content-Type"]="application/json";}else{n["Content-Type"]="application/atom+xml";}}if(i.indexOf("$count")>-1){n["Accept"]="text/plain, */*;q=0.5";}if(k==="MERGE"&&!this.bUseBatch){n["x-http-method"]="MERGE";k="POST";}if(this.sMessageScope===w.BusinessObject){if(this.bIsMessageScopeSupported){n["sap-message-scope"]=this.sMessageScope;}else{L.error("Message scope 'sap.ui.model.odata.MessageScope.BusinessObject' is not"+" supported by the service: "+this.sServiceUrl,undefined,K);}}W=W&&this.sMessageScope===w.BusinessObject&&this.bIsMessageScopeSupported;if(this.bUseBatch&&k!=="GET"&&k!=="HEAD"&&!n["Content-ID"]){n["Content-ID"]=u();}X={headers:n,requestUri:i,method:k,user:this.sUser,password:this.sPassword,async:V,deepPath:j,updateAggregatedMessages:W};if(R){X.data=R;}if(this.bWithCredentials){X.withCredentials=this.bWithCredentials;}X.requestID=this._createRequestID();return X;};Q.prototype._processRequest=function(i,j,k){var R,n,T=false,V=this;if(this.bWarmup){return{abort:function(){}};}if(k){this.iPendingDeferredRequests+=1;}n={abort:function(){if(k&&!T){V.iPendingDeferredRequests-=1;}if(!T&&j){j(Q._createAbortedError());}if(R){R._aborted=true;if(R._handle){R._handle.abort();}}T=true;}};this.oMetadata.loaded().then(function(){R=i(n);if(R){R.deferred=!!k;}V._processRequestQueueAsync(V.mRequests);if(T){n.abort();}});return n;};Q.prototype.update=function(i,j,k){var n,R,T,V,W,X,Y,Z,$,a1,b1,c1,d1,e1,f1,g1=this,h1,i1,j1;if(k){Z=k.groupId||k.batchGroupId;$=k.changeSetId;W=k.context;n=k.success;R=k.error;X=k.eTag;b1=k.headers;a1=k.urlParameters;e1=k.refreshAfterChange;j1=k.canonicalRequest;if(k.merge!==undefined){c1=k.merge?"MERGE":"PUT";}}j1=this._isCanonicalRequestNeeded(j1);f1=Z in g1.mDeferredGroups;e1=this._getRefreshAfterChange(e1,Z);Y=D._createUrlParamsArray(a1);b1=this._getHeaders(b1);c1=c1?c1:this.sDefaultUpdateMethod;X=X||this._getETag(i,W,j);h1=this._normalizePath(i,W,j1);i1=this.resolveDeep(i,W);return this._processRequest(function(k1){V=g1._createRequestUrlWithNormalizedPath(h1,Y,g1.bUseBatch);T=g1._createRequest(V,i1,c1,b1,j,X);d1=g1.mRequests;if(f1){d1=g1.mDeferredRequests;}g1._pushToRequestQueue(d1,Z,$,T,n,R,k1,e1);return T;},R,f1);};Q.prototype.create=function(i,j,k){var R,n,T,V,W,X,Y,Z,$,a1,b1,c1,d1,e1,f1,g1,h1=this,i1,j1,k1;if(k){V=k.context;Y=k.urlParameters;W=k.success;X=k.error;c1=k.groupId||k.batchGroupId;e1=k.changeSetId;b1=k.eTag;$=k.headers;f1=k.refreshAfterChange;k1=k.canonicalRequest;}k1=this._isCanonicalRequestNeeded(k1);f1=this._getRefreshAfterChange(f1,c1);a1=D._createUrlParamsArray(Y);$=this._getHeaders($);d1="POST";g1=c1 in h1.mDeferredGroups;i1=h1._normalizePath(i,V,k1);j1=this.resolveDeep(i,V);return this._processRequest(function(l1){n=h1._createRequestUrlWithNormalizedPath(i1,a1,h1.bUseBatch);R=h1._createRequest(n,j1,d1,$,j,b1);R.created=true;T=h1.oMetadata._getEntityTypeByPath(i1);R.entityTypes={};if(T){R.entityTypes[T.entityType]=true;}Z=h1.mRequests;if(g1){Z=h1.mDeferredRequests;}h1._pushToRequestQueue(Z,c1,e1,R,W,X,l1,f1);return R;},X,g1);};Q.prototype.remove=function(i,j){var k,n,R,T,V,W,X,Y,Z,$,a1,b1,c1,d1,e1,f1,g1,h1,i1,j1=this.bCanonicalRequests,k1=this;if(j){Y=j.groupId||j.batchGroupId;k=j.changeSetId;n=j.context;f1=j.success;W=j.error;X=j.eTag;Z=j.headers;i1=j.urlParameters;c1=j.refreshAfterChange;j1=j.canonicalRequest;}j1=this._isCanonicalRequestNeeded(j1);c1=this._getRefreshAfterChange(c1,Y);h1=D._createUrlParamsArray(i1);Z=this._getHeaders(Z);a1="DELETE";X=X||this._getETag(i,n);V=Y in k1.mDeferredGroups;b1=this._normalizePath(i,n,j1);T=this.resolveDeep(i,n);function l1(m1,n1){k1._removeEntity($);if(R&&R.isTransient()===false){k1.oCreatedContextsCache.findAndRemoveContext(R);}if(f1){f1(m1,n1);}}return this._processRequest(function(m1){g1=k1._createRequestUrlWithNormalizedPath(b1,h1,k1.bUseBatch);$=g1.substr(g1.lastIndexOf('/')+1);$=$.split("?")[0];R=k1.mContexts["/"+$];d1=k1._createRequest(g1,T,a1,Z,undefined,X,undefined,true);e1=k1.mRequests;if(V){e1=k1.mDeferredRequests;}k1._pushToRequestQueue(e1,Y,k,d1,l1,W,m1,c1);return d1;},W,V);};Q.prototype.callFunction=function(i,j){var k,n,R,T,V,W,X,Y,Z,$,a1,b1,c1,d1,e1=this;if(!i.startsWith("/")){L.fatal("callFunction: sFunctionName has to be absolute, but the given '"+i+"' is not absolute",this,K);return undefined;}j=j||{};k=j.changeSetId;R=j.error;T=j.eTag;V=j.expand;W=j.groupId||j.batchGroupId;X=j.headers;Y=j.method||"GET";Z=j.refreshAfterChange;c1=j.success;d1=Object.assign({},j.urlParameters);if(V){if(!this.bUseBatch){throw new Error("Use 'expand' parameter only with 'useBatch' set to 'true'");}if(Y!=="POST"){throw new Error("Use 'expand' parameter only with HTTP method 'POST'");}}Z=this._getRefreshAfterChange(Z,W);n=new Promise(function(f1,g1){b1=f1;$=g1;});a1=this._processRequest(function(f1){var g1,h1,i1,j1,k1,l1,m1,n1,o1,p1,q1,r1={},s1=R,t1=false,u1=c1;i1=e1.oMetadata._getFunctionImportMetadata(i,Y);if(!i1){L.error("Function '"+i+"' not found in the metadata",e1,K);$();return undefined;}if(i1.entitySet||i1.entitySetPath){r1.$result={__list:[]};if(i1.returnType&&!i1.returnType.startsWith("Collection")){r1.$result={__ref:{}};}}if(V&&(!r1.$result||!r1.$result.__ref)){$(new Error("Use 'expand' parameter only for functions returning a single"+" entity"));return undefined;}if(i1.parameter!=null){i1.parameter.forEach(function(v1){r1[v1.name]=e1._createPropertyValue(v1.type);if(d1[v1.name]!==undefined){r1[v1.name]=d1[v1.name];d1[v1.name]=D.formatValue(d1[v1.name],v1.type);}else{L.warning("No value given for parameter '"+v1.name+"' of function import '"+i+"'",e1,K);}});}o1=u();if(V){X=Object.assign({},X,{"Content-ID":o1,"sap-messages":"transientOnly"});c1=function(r1,v1){if(!k1){k1=r1;j1=v1;return;}if(u1){r1=Object.assign({},k1,r1);u1(r1,j1);}};R=function(v1){if(k1){j1.expandAfterFunctionCallFailed=true;v1.expandAfterFunctionCallFailed=true;L.error("Function '"+i+"' was called successfully, but"+" expansion of navigation properties ("+V+") failed",v1,K);if(u1){u1(k1,j1);}return;}if(!t1){t1=true;if(s1){s1(v1);}}else{v1.expandAfterFunctionCallFailed=true;}};}r1.__metadata={uri:e1.sServiceUrl+i+"('"+o1+"')",created:{changeSetId:k,error:R,eTag:T,functionImport:true,groupId:W,headers:Object.assign({},X),key:i.substring(1),method:Y,success:c1}};l1=e1._addEntity(r1);g1=e1.getContext("/"+l1);e1._writePathCache("/"+l1,"/"+l1);b1(g1);q1=D._createUrlParamsArray(d1);p1=e1._createRequestUrlWithNormalizedPath(i,q1,e1.bUseBatch);m1=e1._createRequest(p1,i,Y,e1._getHeaders(X),undefined,T,undefined,true);m1.adjustDeepPath=j.adjustDeepPath;m1.functionMetadata=i1;r1.__metadata.created.functionMetadata=i1;m1.functionTarget=e1.oMetadata._getCanonicalPathOfFunctionImport(i1,d1);m1.key=l1;if(V){h1=e1._createRequest("$"+o1+"?"+D._encodeURLParameters({$expand:V,$select:V}),"/$"+o1,"GET",e1._getHeaders(undefined,true),undefined,undefined,undefined,true);h1.contentID=o1;m1.expandRequest=h1;m1.contentID=o1;}n1=e1.mRequests;if(W in e1.mDeferredGroups){n1=e1.mDeferredRequests;}e1._pushToRequestQueue(n1,W,k,m1,c1,R,f1,Z);return m1;},R);a1.contextCreated=function(){return n;};return a1;};Q.prototype._createFunctionImportParameters=function(i,j,k){var n=g({},k);delete n.__metadata;delete n["$result"];var R=this.oMetadata._getFunctionImportMetadata(i,j);d(R,this+": Function "+i+" not found in the metadata !");if(!R){return;}if(R.parameter!=null){h(R.parameter,function(T,V){if(n&&n[V.name]!==undefined){n[V.name]=D.formatValue(n[V.name],V.type);}});}return n;};Q.prototype._getResourcePath=function(i,j,k,n){var R,T,V,W;if(!i){return this.resolve(k,n);}V=this.oMetadata._splitByLastNavigationProperty(j);T=V.pathBeforeLastNavigationProperty;R=V.lastNavigationProperty;if(R.includes("(")&&V.addressable){W=this.resolve(T+R,undefined,true);if(W){return W+V.pathAfterLastNavigationProperty;}}W=this.resolve(T,undefined,true)||T;return W+R+V.pathAfterLastNavigationProperty;};Q.prototype.read=function(i,j){var k,n,R,T,V,W,X,Y,Z,$,a1,b1,c1,d1,e1=this;if(j){k=j.canonicalRequest;n=j.context;R=j.error;V=j.filters;W=j.groupId||j.batchGroupId;X=j.headers;$=j.sorters;a1=j.success;b1=j.updateAggregatedMessages;d1=j.urlParameters;}k=this._isCanonicalRequestNeeded(k);if(i&&i.indexOf('?')!==-1){i=i.slice(0,i.indexOf('?'));}if(this.sRefreshGroupId){W=this.sRefreshGroupId;}c1=D._createUrlParamsArray(d1);X=this._getHeaders(X,true);Y="GET";T=this._getETag(i,n);var f1={abort:function(){if(Z){Z._aborted=true;}}};function g1(h1){var i1,j1,k1,l1,m1,n1,o1=e1.resolveDeep(i,n),p1=e1._getResourcePath(k,o1,i,n);m1=D.createSortParams($);if(m1){c1.push(m1);}i1=e1.oMetadata._getEntityTypeByPath(p1);j1=F.groupFilters(V);k1=D.createFilterParams(j1,e1.oMetadata,i1);if(k1){c1.push(k1);}n1=e1._createRequestUrlWithNormalizedPath(p1,c1,e1.bUseBatch);Z=e1._createRequest(n1,o1,Y,X,null,T,undefined,b1);l1=e1.mRequests;if(W in e1.mDeferredGroups){l1=e1.mDeferredRequests;}e1._pushToRequestQueue(l1,W,null,Z,a1,R,h1,false);return Z;}if(this.bUseBatch&&this.bIncludeInCurrentBatch){Z=g1(f1);return f1;}else{return this._processRequest(g1,R);}};Q.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};Q.prototype.metadataLoaded=function(R){var i=this.oMetadata.loaded(R);if(this.bLoadAnnotationsJoined){if(R){return Promise.all([i,this.pAnnotationsLoaded]);}var j=function(){return i;};return this.pAnnotationsLoaded.then(j,j);}else{return i;}};Q.prototype.annotationsLoaded=function(){return this.pAnnotationsLoaded;};Q.prototype.isMetadataLoadingFailed=function(){return this.oMetadata.isFailed();};Q.prototype.getServiceAnnotations=function(){var i=this.oAnnotations.getData();return m(i)?null:i;};Q.prototype.onAnnotationsFailed=function(i){this.fireAnnotationsFailed(i.getParameters());};Q.prototype.onAnnotationsLoaded=function(i){this.fireAnnotationsLoaded(i.getParameters());};Q.prototype.addAnnotationUrl=function(i){var j=[].concat(i),k=[],n=[],R=[],T=this;j.forEach(function(V){var W=V.indexOf("$metadata");if(W>=0){V=T._createMetadataUrl(V);k.push(V);}else{n.push(V);}});return this.oMetadata._addUrl(k).then(function(V){return Promise.all(V.map(function(W){R=R.concat(W.entitySets);return T.oAnnotations.addSource({type:"xml",data:W["metadataString"]});}));}).then(function(){return T.oAnnotations.addSource(n);}).then(function(V){return{annotations:T.oAnnotations.getData(),entitySets:R};});};Q.prototype.addAnnotationXML=function(X,i){return this.oAnnotations.addSource({type:"xml",data:X});};Q.prototype.submitChanges=function(j){var R,k,n,T,V,W,X,Y=false,Z,$,a1=this.bRefreshAfterChange,b1,c1=this;if(j){k=j.groupId||j.batchGroupId;T=j.success;V=j.error;if(j.merge!==undefined){Z=j.merge?"MERGE":"PUT";}}if(k&&!this.mDeferredGroups[k]){L.fatal(this+" submitChanges: \""+k+"\" is not a deferred group!");}$=p({},c1.mChangedEntities);this.oMetadata.loaded().then(function(){h($,function(i1,j1){n=c1._resolveGroup(i1);if(n.groupId===k||!k){R=c1._processChange(i1,j1,Z||c1.sDefaultUpdateMethod);R.key=i1;b1=j1.__metadata&&j1.__metadata.created?j1.__metadata.created:{};var W={abort:function(){R._aborted=true;}};if(n.groupId in c1.mDeferredGroups){c1._pushToRequestQueue(c1.mDeferredRequests,n.groupId,n.changeSetId,R,b1.success,b1.error,W,a1);}}});var d1,e1,f1,g1,h1,i;for(d1 in c1.mDeferredRequests){f1=c1.mDeferredRequests[d1];for(e1 in f1.changes){g1=f1.changes[e1];for(i=g1.length-1;i>=0;i--){h1=g1[i];if(h1.bRefreshAfterChange===undefined){h1.bRefreshAfterChange=a1;}}}}X=c1._processRequestQueue(c1.mDeferredRequests,k,T,V);if(Y){W.abort();}if(Array.isArray(X)&&X.length==0&&T){T({},undefined);}});W={abort:function(){if(X){if(Array.isArray(X)){X.forEach(function(W){W.abort();});}else{X.abort();}}else{Y=true;}}};return W;};Q.prototype._updateChangedEntities=function(i){var j=this,R,k,n;function T(V,W,X){h(W,function(Y){var Z=X+'/'+Y;if(o(W[Y])&&o(V[Y])){T(V[Y],W[Y],Z);if(m(W[Y])){delete W[Y];}}else if(X.endsWith("__metadata")||f(W[Y],V[Y])&&!j.isLaundering(Z)){delete W[Y];if(X===R){k=j.oMetadata._getEntityTypeByPath(R);n=k&&j.oMetadata._getNavPropertyRefInfo(k,Y);if(n&&W[n.name]){V[n.name]=W[n.name];delete W[n.name];}}}});}h(i,function(V,W){if(V in j.mChangedEntities){var X=j._getObject('/'+V,null,true);var Y=j._getObject('/'+V);p(X,W);R='/'+V;var Z=j.removeInternalMetadata(Y).deepPath;T(X,Y,R);if(m(Y)){delete j.mChangedEntities[V];j.abortInternalRequest(j._resolveGroup(V).groupId,{requestKey:V});}else{j.mChangedEntities[V]=Y;Y.__metadata={deepPath:Z};l(Y.__metadata,X.__metadata);}}});};Q.prototype._discardEntityChanges=function(k,i,j){var n=j&&j.created,R=true,T=this._resolveGroup(k).groupId,V=this.oMetadata.loaded(),W=this;V.then(function(){W.abortInternalRequest(T,{requestKey:k});});if(i&&n){this._removeEntity(k);if(n.abort){n.abort(Q._createAbortedError());}R=false;}else{delete this.mChangedEntities[k];}sap.ui.getCore().getMessageManager().removeMessages(this.getMessagesByEntity(k,R));return V;};Q.prototype.resetChanges=function(j,k,n){var R=this.oMetadata.loaded(),T=this;if(k){R.then(function(){h(T.mDeferredGroups,function(i){if(j){j.forEach(function(V){T.abortInternalRequest(i,{path:V.substring(1)});});}else{T.abortInternalRequest(i);}});});}if(j){h(j,function(V,W){var X,Y,i,Z,$,a1,b1={};if(T.getEntityByPath(W,null,b1)){a1=b1.propertyPath.split("/");$=a1[a1.length-1];Z=b1.key;X=T.mChangedEntities[Z];if(X){for(i=0;i<a1.length-1;i+=1){if(X&&X.hasOwnProperty(a1[i])){X=X[a1[i]];}else{X=undefined;break;}}if(X&&X.hasOwnProperty($)){delete X[$];}Y=T.mChangedEntities[Z].__metadata;delete T.mChangedEntities[Z].__metadata;if(m(T.mChangedEntities[Z])||!b1.propertyPath){T._discardEntityChanges(Z,n,Y);}else{T.mChangedEntities[Z].__metadata=Y;}}}});}else{h(this.mChangedEntities,function(i,V){T._discardEntityChanges(i,n,V.__metadata);});}this.checkUpdate(true);return R;};Q.prototype.setProperty=function(j,V,k,n){var R,T,W,X,Y,Z,$,a1,b1,c1,d1,e1,f1={},g1={},h1,i1,j1,k1=false,l1=this,m1,n1,o1,p1,q1,r1,s1;function t1(v1,w1){h(w1,function(b1){if(o(w1[b1])&&o(v1[b1])){t1(v1[b1],w1[b1]);if(m(w1[b1])){delete w1[b1];}}else if(f(w1[b1],v1[b1])){delete w1[b1];}});}$=this.resolve(j,k);s1=this.resolveDeep(j,k);Z=this.getEntityByPath($,null,g1);if(!Z){return false;}T=$.substring($.lastIndexOf("/")+1);b1=g1.key;Y=this._getObject('/'+b1,null,true);R=this._getObject(j,k,true);if(!this.mChangedEntities[b1]){e1=Z.__metadata;Z={};Z.__metadata=Object.assign({},e1);if(g1.propertyPath.length>0){var u1=s1.lastIndexOf(g1.propertyPath);Z.__metadata.deepPath=s1.substring(0,u1-1);}this.mChangedEntities[b1]=Z;}i1=this.mChangedEntities[b1];a1=g1.propertyPath.split("/");for(var i=0;i<a1.length-1;i++){if(!i1.hasOwnProperty(a1[i])){i1[a1[i]]={};}i1=i1[a1[i]];}k1=Y.__metadata.created&&Y.__metadata.created.functionImport;i1[T]=V;n1=this.oMetadata._getEntityTypeByPath(g1.key);o1=n1&&this.oMetadata._getNavPropertyRefInfo(n1,T);p1=o1&&Y[o1.name]&&Y[o1.name].__ref;if(p1&&o1.keys.length===1){if(V===null){r1=null;}else{q1={};o1.keys.forEach(function(v1){q1[v1]=Z[v1]!==undefined?Z[v1]:Y[v1];});q1[o1.keys[0]]=V;r1=this.createKey(o1.entitySet,q1);}i1[o1.name]={__ref:r1};}if(f(V,R)&&!this.isLaundering('/'+b1)&&!k1){e1=this.mChangedEntities[b1].__metadata;m1=e1&&e1.created;delete this.mChangedEntities[b1].__metadata;if(!m1){t1(Y,this.mChangedEntities[b1]);}if(m(this.mChangedEntities[b1])){delete this.mChangedEntities[b1];f1[b1]=true;this.checkUpdate(false,n,f1);l1.oMetadata.loaded().then(function(){l1.abortInternalRequest(l1._resolveGroup(b1).groupId,{requestKey:b1});});return true;}this.mChangedEntities[b1].__metadata=e1;}c1=this._resolveGroup(b1);W=this.mRequests;if(c1.groupId in this.mDeferredGroups){W=this.mDeferredRequests;X=this._processChange(b1,{__metadata:Z.__metadata},this.sDefaultUpdateMethod);}else{X=this._processChange(b1,this._getObject('/'+b1),this.sDefaultUpdateMethod);}X.key=b1;h1=i1.__metadata&&i1.__metadata.created?i1.__metadata.created:{};j1=this._getRefreshAfterChange(undefined,c1.groupId);this.oMetadata.loaded().then(function(){d1={abort:function(){X._aborted=true;}};l1._pushToRequestQueue(W,c1.groupId,c1.changeSetId,X,h1.success,h1.error,d1,j1);l1._processRequestQueueAsync(l1.mRequests);});f1[b1]=true;this.checkUpdate(false,n,f1);return true;};Q.prototype._isHeaderPrivate=function(i){switch(i.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;case"sap-contextid-accept":case"sap-contextid":return!this.bDisableSoftStateHeader;default:return false;}};Q.prototype.setHeaders=function(i){var j={},k=this;this.mCustomHeaders={};if(i){h(i,function(n,R){if(k._isHeaderPrivate(n)){L.warning(this+" - modifying private header: '"+n+"' not allowed!");}else{j[n]=R;}});this.mCustomHeaders=j;}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};Q.prototype._getHeaders=function(i,j){var k={},n=this;if(i){h(i,function(R,T){if(n._isHeaderPrivate(R)){L.warning(this+" - modifying private header: '"+R+"' not allowed!");}else{k[R]=T;}});}return l({'sap-cancel-on-close':!!j},this.mCustomHeaders,k,this.oHeaders);};Q.prototype.getHeaders=function(){return l({},this.mCustomHeaders,this.oHeaders);};Q.prototype._getHeader=function(i,j){var k;for(k in j){if(k.toLowerCase()===i.toLowerCase()){return j[k];}}return null;};Q.prototype.hasPendingChanges=function(i){var j=!m(this.mChangedEntities);if(i){j=j||this.iPendingDeferredRequests>0;}return j;};Q.prototype.hasPendingRequests=function(){return this.aPendingRequestHandles.length>0;};Q.prototype.getPendingChanges=function(){return p({},this.mChangedEntities);};Q.prototype.updateBindings=function(i){this.checkUpdate(i);};Q.prototype.setTokenHandlingEnabled=function(T){this.bTokenHandling=T;};Q.prototype.setUseBatch=function(i){this.bUseBatch=i;};Q.prototype.formatValue=function(V,T){return D.formatValue(V,T);};Q.prototype.deleteCreatedEntry=function(i){var j=this,k,n;if(i){var k=i.getPath().substr(1);n=this._resolveGroup(k).groupId;j.oMetadata.loaded().then(function(){j.abortInternalRequest(n,{requestKey:k});});j._removeEntity(k);sap.ui.getCore().getMessageManager().removeMessages(this.getMessagesByEntity(i.getPath(),true));}};Q.prototype.createEntry=function(j,k){var n,R,T,V,W,X,Y,Z,$,a1,b1,c1,d1,e1,f1,g1,h1,i1,j1,k1,l1,m1,n1={},o1="POST",p1=this;if(k){f1=k.properties;b1=k.groupId||k.batchGroupId;R=k.changeSetId;T=k.context;j1=k.success;Z=k.error;V=k.created;$=k.eTag;c1=k.headers;m1=k.urlParameters;g1=k.refreshAfterChange;n=k.canonicalRequest;a1=k.expand;}if(a1&&!this.bUseBatch){throw new Error("The 'expand' parameter is only supported if batch mode is used");}n=this._isCanonicalRequestNeeded(n);c1=c1||{};g1=this._getRefreshAfterChange(g1,b1);b1=b1?b1:this.sDefaultChangeGroup;l1=D._createUrlParamsArray(m1);var q1={abort:function(){if(h1){h1._aborted=true;if(h1.expandRequest){h1.expandRequest._aborted=true;}}}};if(!j.startsWith("/")&&!T){j="/"+j;}e1=p1._normalizePath(j,T,n);Y=p1.resolveDeep(j,T);function r1(){var s1,t1,u1,v1,w1,x1,y1=false,z1=Z,A1=j1;var B1=p1.oMetadata._getEntityTypeByPath(e1);if(!B1){d(B1,"No Metadata for collection "+e1+" found");return undefined;}if(typeof f1==="object"&&!Array.isArray(f1)){n1=p({},f1);}else{for(var i=0;i<B1.property.length;i++){var C1=B1.property[i];var D1=(f1?f1.indexOf(C1.name):-1)>-1;if(!f1||D1){n1[C1.name]=p1._createPropertyValue(C1.type);if(D1){f1.splice(f1.indexOf(C1.name),1);}}}if(f1){d(f1.length===0,"No metadata for the following properties found: "+f1.join(","));}}v1=p1.oMetadata._getEntitySetByType(B1);x1=u();d1=v1.name+"('"+x1+"')";if(Y&&p1.oMetadata._isCollection(Y)){Y=Y+"('"+x1+"')";}if(a1){c1=Object.assign({},c1,{"Content-ID":x1,"sap-messages":"transientOnly"});j1=function(E1,F1){if(!s1){s1=E1;u1=F1;return;}if(A1){E1=Object.assign({},s1,E1);A1(E1,u1);}X();};Z=function(E1){if(s1){u1.expandAfterCreateFailed=true;E1.expandAfterCreateFailed=true;L.error("Entity creation was successful but expansion of navigation"+" properties failed",E1,K);if(A1){A1(s1,u1);}X();return;}if(!y1){y1=true;if(z1){z1(E1);}}else{E1.expandAfterCreateFailed=true;y1=false;}};}else{j1=function(E1,u1){if(A1){A1(E1,u1);}X();};}n1.__metadata={type:""+B1.entityType,uri:p1.sServiceUrl+'/'+d1,created:{key:e1.substring(1),success:j1,error:Z,headers:c1,urlParameters:m1,groupId:b1,changeSetId:R,eTag:$},deepPath:Y};W=new S(function(E1,F1){X=E1;n1.__metadata.created.abort=F1;});W.catch(function(){});d1=p1._addEntity(p({},n1));p1.mChangedEntities[d1]=n1;k1=p1._createRequestUrlWithNormalizedPath(e1,l1,p1.bUseBatch);h1=p1._createRequest(k1,Y,o1,c1,n1,$);if(a1){w1=p1._createRequest("$"+x1+"?"+D._encodeURLParameters({$expand:a1,$select:a1}),"/$"+x1,"GET",p1._getHeaders(undefined,true),null,undefined,undefined,true);w1.contentID=x1;h1.expandRequest=w1;h1.contentID=x1;n1.__metadata.created.expandRequest=w1;n1.__metadata.created.contentID=x1;}t1=p1.getContext("/"+d1,Y,W);h1.key=d1;h1.created=true;i1=p1.mRequests;if(b1 in p1.mDeferredGroups){i1=p1.mDeferredRequests;}p1.oMetadata.loaded().then(function(){p1._pushToRequestQueue(i1,b1,R,h1,j1,Z,q1,g1);p1._processRequestQueueAsync(p1.mRequests);});return t1;}if(V){this.oMetadata.loaded().then(function(){V(r1());});}else if(this.oMetadata.isLoaded()){return r1();}else{L.error("Tried to use createEntry without created-callback, before metadata is available!");}};Q.prototype._isCreatedEntity=function(i){return!!(i&&i.__metadata&&i.__metadata.created);};Q.prototype._createPropertyValue=function(T){var j=this.oMetadata._splitName(T);var n=j.namespace;var k=j.name;if(n.toUpperCase()!=='EDM'){var R={};var V=this.oMetadata._getObjectMetadata("complexType",k,n);d(V,"Complex type "+T+" not found in the metadata !");for(var i=0;i<V.property.length;i++){var W=V.property[i];R[W.name]=this._createPropertyValue(W.type);}return R;}else{return this._getDefaultPropertyValue(k,n);}};Q.prototype._getDefaultPropertyValue=function(T,n){return undefined;};Q.prototype._normalizePath=function(i,j,k){if(i&&i.indexOf('?')!==-1){i=i.substr(0,i.indexOf('?'));}if(!j&&!i.startsWith("/")){L.fatal(this+" path "+i+" must be absolute if no Context is set");}return this.resolve(i,j,k)||this.resolve(i,j);};Q.prototype.getRefreshAfterChange=function(){return this.bRefreshAfterChange;};Q.prototype.setRefreshAfterChange=function(R){this.bRefreshAfterChange=R;};Q.prototype.isList=function(i,j){i=this.resolve(i,j);return i&&i.substr(i.lastIndexOf("/")).indexOf("(")===-1;};Q.prototype._isMetadataPath=function(i){var j=false;if(i&&i.indexOf('/#')>-1){j=true;}return j;};Q.prototype.isMetaModelPath=function(i){return i.indexOf("##")==0||i.indexOf("/##")>-1;};Q.prototype._request=function(R,i,j,k,n,T){var V;if(this.bDestroyed){return{abort:function(){}};}var W=this;function X(Y){return function(){if(W.aPendingRequestHandles){var Z=W.aPendingRequestHandles.indexOf(V);if(Z>-1){W.aPendingRequestHandles.splice(Z,1);}}if(!(V&&V.bSuppressErrorHandlerCall)){Y.apply(this,arguments);}};}V=H.request(R,X(i||H.defaultSuccess),X(j||H.defaultError),k,n,T);if(R.async!==false){this.aPendingRequestHandles.push(V);}return V;};Q.prototype.destroy=function(){this.bDestroyed=true;t.prototype.destroy.apply(this,arguments);if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var R=this.aPendingRequestHandles[i];if(R&&R.abort){R.bSuppressErrorHandlerCall=true;R.abort();}}delete this.aPendingRequestHandles;}if(this.sMetadataLoadEvent){clearTimeout(this.sMetadataLoadEvent);}if(this.oMetadataFailedEvent){clearTimeout(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oSharedMetaData.oMetadata;}delete this.oMetadata;delete this.pMetadataLoaded;}if(this.oMetaModel){this.oMetaModel.destroy();delete this.oMetaModel;}if(this.oAnnotations){this.oAnnotations.detachSomeLoaded(this.onAnnotationsLoaded);this.oAnnotations.detachAllFailed(this.onAnnotationsFailed);this.oAnnotations.destroy();delete this.oAnnotations;delete this.pAnnotationsLoaded;}};Q.prototype.setDeferredBatchGroups=function(i){this.setDeferredGroups(i);};Q.prototype.setDeferredGroups=function(i){var j=this;this.mDeferredGroups={};h(i,function(k,n){j.mDeferredGroups[n]=n;});};Q.prototype.getDeferredBatchGroups=function(){return this.getDeferredGroups();};Q.prototype.getDeferredGroups=function(){return Object.keys(this.mDeferredGroups);};Q.prototype.setChangeBatchGroups=function(i){h(i,function(j,k){k.groupId=k.batchGroupId;});this.setChangeGroups(i);};Q.prototype.setChangeGroups=function(i){this.mChangeGroups=i;};Q.prototype.getChangeBatchGroups=function(){return this.getChangeGroups();};Q.prototype.getChangeGroups=function(){return this.mChangeGroups;};Q.prototype.setMessageParser=function(i){if(!(i instanceof r)){L.error("Given MessageParser is not of type sap.ui.core.message.MessageParser");return this;}i.setProcessor(this);this.oMessageParser=i;return this;};Q.prototype._parseResponse=function(R,i,j,k){try{if(!this.oMessageParser){this.oMessageParser=new z(this.sServiceUrl,this.oMetadata,!!this.bPersistTechnicalMessages);this.oMessageParser.setProcessor(this);}this.oMessageParser.parse(R,i,j,k,this.bIsMessageScopeSupported);}catch(n){L.error("Error parsing OData messages: "+n);}};Q.prototype.callAfterUpdate=function(i){this.aCallAfterUpdate.push(i);};Q.prototype.getMetaModel=function(){var i=this;if(!this.oMetaModel){this.oMetaModel=new y(this.oMetadata,this.oAnnotations,this);this.oMetaModel.loaded().then(function(){i.bMetaModelLoaded=true;i.checkUpdate(false,false,null,true);},function(j){var k=j.message,n;if(!k&&j.xmlDoc&&j.xmlDoc.parseError){k=j.xmlDoc.parseError.reason;n=j.xmlDoc.parseError.srcText;}L.error("error in ODataMetaModel.loaded(): "+k,n,K);});}return this.oMetaModel;};Q.prototype.getOriginalProperty=function(i,j){return this._getObject(i,j,true);};Q.prototype.getEntityByPath=function(i,j,k){var R=t.prototype.resolve.call(this,i,j);if(!R){return null;}var n=R.split("/"),T=null,V=[];while(n.length>0){var W=n.join("/"),X=this._getObject(W);if(o(X)){var Y=this._getKey(X);if(Y){T=X;break;}}V.unshift(n.pop());}if(T){k.propertyPath=V.join("/");k.key=Y;return T;}return null;};Q.prototype.resolveFromCache=function(i){if(!this.mPathCache){return undefined;}var j,k="",n,R,T;n=this.mPathCache[i]?this.mPathCache[i].canonicalPath:undefined;if(i&&n!==i){j=n||i;if(!n){T=j.lastIndexOf("/");k=j.substr(T);j=j.substr(0,T);}R=this.resolveFromCache(j);if(R&&R!==j){n=R+k;}}return n;};Q.prototype.resolve=function(i,j,k){var R=t.prototype.resolve.call(this,i,j);if(R&&!this._isMetadataPath(R)&&k){var n=this.resolveFromCache(R);if(!n){n=this.oMetadata._calculateCanonicalPath(R);n=this.resolveFromCache(n)||n;}this._writePathCache(R,n);return n;}return R;};Q.prototype.resolveDeep=function(i,j){var R=t.prototype.resolve.call(this,i,j);if(i&&!i.startsWith("/")){R=j?j.sDeepPath+'/'+i:R;}if(i===""){R=j?j.sDeepPath:R;}return R;};Q.prototype.isLaundering=function(i,j){var R=this.resolve(i,j);return(R in this.mLaunderingState)&&this.mLaunderingState[R]>0;};Q.prototype.increaseLaundering=function(i,j){if(!o(j)){return;}for(var n in j){if(n==="__metadata"){continue;}var k=j[n];if(o(k)){this.increaseLaundering(i+"/"+n,k);}else{var T=i+"/"+n;if(!(T in this.mLaunderingState)){this.mLaunderingState[T]=0;}this.mLaunderingState[T]++;}}if(!(i in this.mLaunderingState)){this.mLaunderingState[i]=0;}this.mLaunderingState[i]++;};Q.prototype.decreaseLaundering=function(i,j){if(!o(j)){return;}for(var n in j){if(n==="__metadata"){continue;}var k=j[n],T=i+"/"+n;if(o(k)){this.decreaseLaundering(T,k);}else{if(T in this.mLaunderingState){this.mLaunderingState[T]--;if(this.mLaunderingState[T]===0){delete this.mLaunderingState[T];}}}}this.mLaunderingState[i]--;if(this.mLaunderingState[i]===0){delete this.mLaunderingState[i];}};Q.prototype._getRefreshAfterChange=function(R,i){if(R===undefined&&!(i in this.mDeferredGroups)){return this.bRefreshAfterChange;}return R;};Q.prototype.getMessagesByEntity=function(j,k){var n=j,R=[],T;function V(R){var W=[];for(var i=0;i<R.length;i++){if(!k||(k&&!R[i].persistent)){W.push(R[i]);}}return W;}if(!n.startsWith('/')){n='/'+n;}if(this.mMessages){for(T in this.mMessages){if(typeof n=="string"&&n.length>0&&T.startsWith(n)){R=R.concat(V(this.mMessages[T]));}}return R;}return null;};Q.prototype._cacheSupported=function(i){var j=/\/~[\w\-]+~[A-Z0-9]?/;var k=[i];if(this.sAnnotationURI){if(!Array.isArray(this.sAnnotationURI)){this.sAnnotationURI=[this.sAnnotationURI];}k=k.concat(this.sAnnotationURI);}k=k.filter(function(n){return n.indexOf("sap-context-token")===-1;});k=k.filter(function(n){return!j.test(n);});return k.length===0?true:false;};Q.prototype._getAnnotationCacheKey=function(i){var j;if(this.bUseCache){if(!this.bSkipMetadataAnnotationParsing){j=i+"#annotations";}if(this.sAnnotationURI){if(!Array.isArray(this.sAnnotationURI)){this.sAnnotationURI=[this.sAnnotationURI];}this.sAnnotationURI=this.sAnnotationURI.map(function(k){return k+"#annotations";});j=this.bSkipMetadataAnnotationParsing?this.sAnnotationURI.join("_"):j+"_"+this.sAnnotationURI.join("_");}}return j;};Q.prototype.canonicalRequestsEnabled=function(){return this.bCanonicalRequests;};Q.prototype._decreaseDeferredRequestCount=function(R){if(R.deferred){this.iPendingDeferredRequests--;}};Q.prototype.enableCanonicalRequests=function(i){this.bCanonicalRequests=!!i;};Q.prototype.getMessageScope=function(){return this.sMessageScope;};Q.prototype.setMessageScope=function(i){if(i!==w.RequestedObjects&&i!==w.BusinessObject){throw new Error("Unsupported message scope: "+i);}this.sMessageScope=i;};Q.prototype.messageScopeSupported=function(){var i=this;return this.metadataLoaded().then(function(){return i.bIsMessageScopeSupported;});};Q.prototype.getContext=function(i,j,k){var n=this.mContexts[i];if(!n){n=this.mContexts[i]=new C(this,i,j,k);}else{n.setDeepPath(j||n.getDeepPath()||i);}return n;};Q.prototype.hasContext=function(i){return this.mContexts[i];};Q.prototype.removeInternalMetadata=function(i){var j,k,n,R,V;if(i&&i.__metadata){j=i.__metadata.created;k=i.__metadata.deepPath;n=i.__metadata.invalid;delete i.__metadata.created;delete i.__metadata.deepPath;delete i.__metadata.invalid;}for(R in i){V=i[R];if(Array.isArray(V)){V.forEach(Q.prototype.removeInternalMetadata);}else if(typeof V==="object"){Q.prototype.removeInternalMetadata(V);}}return{created:j,deepPath:k,invalid:n};};Q.prototype._isCanonicalRequestNeeded=function(i){if(i!==undefined){return!!i;}else{return!!this.bCanonicalRequests;}};Q.prototype.filterMatchingMessages=function(i,j){var k=this;return this.mMessages[i].filter(function(n){return k.isMessageMatching(n,j);});};Q.prototype.isMessageMatching=function(i,j){var k=j.length;return i.aFullTargets.some(function(n){return n===j||n.startsWith(j)&&(j==="/"||n[k]==="/"||n[k]==="(");});};Q.prototype.getMessages=function(i){return this.getMessagesByPath(i.sDeepPath,true).sort(M.compare);};Q.prototype.getDeepPathForCanonicalPath=function(j){var k,R,T,V,W,i,n,X=j.slice(j.indexOf("("));W=this.aBindings.filter(function(Y){return(Y instanceof a||Y instanceof b)&&Y.isResolved();});for(i=0,n=W.length;i<n;i+=1){k=W[i];T=this.resolveDeep(k instanceof b?k.sPath+X:k.sPath,k.oContext);R=this.resolveFromCache(T);if(R===j){if(V&&V!==T){return undefined;}V=T;}}return V;};Q.prototype.getPersistTechnicalMessages=function(){return this.bPersistTechnicalMessages;};Q.prototype.setPersistTechnicalMessages=function(i){i=!!i;if(this.bPersistTechnicalMessages===i){return;}if(this.bPersistTechnicalMessages!==undefined){L.warning("The flag whether technical messages should always be treated as persistent"+" has been overwritten to "+i,undefined,K);}this.bPersistTechnicalMessages=i;if(this.oMessageParser){this.oMessageParser._setPersistTechnicalMessages(i);}};Q.prototype.createCodeListModelParameters=function(i){i=i||{};return{defaultCountMode:v.None,disableSoftStateHeader:true,headers:i.headers&&Object.assign({},i.headers),json:i.json,metadataUrlParams:i.metadataUrlParams&&Object.assign({},i.metadataUrlParams),persistTechnicalMessages:i.persistTechnicalMessages,serviceUrl:this.sServiceUrl,serviceUrlParams:i.serviceUrlParams&&Object.assign({},i.serviceUrlParams),tokenHandling:false,useBatch:false,warmupUrl:i.warmupUrl};};Q.prototype.getCodeListModelParameters=function(){return this.mCodeListModelParams;};Q.prototype.getMetadataUrl=function(){return this.sMetadataUrl;};Q._createAbortedError=function(){return{aborted:true,headers:{},message:"Request aborted",responseText:"",statusCode:0,statusText:"abort"};};Q.prototype._getCreatedContextsCache=function(){return this.oCreatedContextsCache;};return Q;});
