/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/uid","sap/ui/thirdparty/URI"],function(L,d,a,m,u,U){"use strict";var r=/&/g,c="sap.ui.model.odata.v4.lib._Helper",b=/\=/g,f=/%29/g,g=/%28/g,h=/%27/g,j=/#/g,k=/\([^/]*|\/-?\d+/g,l=/\+/g,n=/'/g,o=/''/g,p=/\s+/g,_;_={addByPath:function(M,P,i){if(i){if(!M[P]){M[P]=[i];}else if(M[P].indexOf(i)<0){M[P].push(i);}}},addChildrenWithAncestor:function(C,A,e){if(A.length){C.forEach(function(P){var s;if(A.indexOf(P)>=0){e[P]=true;return;}s=P.split("/");s.pop();while(s.length){if(A.indexOf(s.join("/"))>=0){e[P]=true;break;}s.pop();}});}},addToSelect:function(q,s){q.$select=q.$select||[];s.forEach(function(P){if(q.$select.indexOf(P)<0){q.$select.push(P);}});},adjustTargets:function(M,O,P,C){var A=_.getAnnotationKey(M,".additionalTargets"),t;t=[M.target].concat(M[A]).map(function(T){return T&&_.getAdjustedTarget(T,O,P,C);}).filter(function(T){return T;});M.target=t[0];if(A){M[A]=t.slice(1);}},adjustTargetsInError:function(e,O,P,C){if(!e.error){return;}_.adjustTargets(e.error,O,P,C);if(e.error.details){e.error.details.forEach(function(M){_.adjustTargets(M,O,P,C);});}},aggregateExpandSelect:function(A,q){if(q.$select){_.addToSelect(A,q.$select);}if(q.$expand){A.$expand=A.$expand||{};Object.keys(q.$expand).forEach(function(P){if(A.$expand[P]){_.aggregateExpandSelect(A.$expand[P],q.$expand[P]);}else{A.$expand[P]=q.$expand[P];}});}},buildPath:function(){var P="",s,i;for(i=0;i<arguments.length;i+=1){s=arguments[i];if(s||s===0){if(P&&P!=="/"&&s[0]!=="("){P+="/";}P+=s;}}return P;},buildQuery:function(P){var K,q;if(!P){return"";}K=Object.keys(P);if(K.length===0){return"";}q=[];K.forEach(function(s){var v=P[s];if(Array.isArray(v)){v.forEach(function(i){q.push(_.encodePair(s,i));});}else{q.push(_.encodePair(s,v));}});return"?"+q.join("&");},clone:function e(v,R){return v===undefined||v===Infinity||v===-Infinity||v!==v?v:JSON.parse(JSON.stringify(v,R));},createError:function(i,M,R,s){var B=i.responseText,C=i.getResponseHeader("Content-Type"),P,q=new Error(M+": "+i.status+" "+i.statusText),t=i.getResponseHeader("Retry-After"),v;q.status=i.status;q.statusText=i.statusText;q.requestUrl=R;q.resourcePath=s;if(i.status===0){q.message="Network error";return q;}if(C){C=C.split(";")[0];}if(i.status===412){P=i.getResponseHeader("Preference-Applied");if(P&&P.replace(p,'')==="handling=strict"){q.strictHandlingFailed=true;}else{q.isConcurrentModification=true;}}if(t){v=parseInt(t);q.retryAfter=new Date(Number.isNaN(v)?t:Date.now()+v*1000);}if(C==="application/json"){try{q.error=JSON.parse(B).error;q.message=q.error.message;if(typeof q.message==="object"){q.message=q.error.message.value;}}catch(e){L.warning(e.toString(),B,c);}}else if(C==="text/plain"){q.message=B;}return q;},createGetMethod:function(F,t){return function(){var s=this[F].apply(this,arguments);if(s.isFulfilled()){return s.getResult();}else if(t){if(s.isRejected()){s.caught();throw s.getResult();}else{throw new Error("Result pending");}}};},createMissing:function(O,s){s.reduce(function(C,S,i){if(!(S in C)){C[S]=i+1<s.length?{}:null;}return C[S];},O);},createRequestMethod:function(F){return function(){return Promise.resolve(this[F].apply(this,arguments));};},createTechnicalDetails:function(M){var C,e=M["@$ui5.error"],O=M["@$ui5.originalMessage"]||M,t={};if(e&&(e.status||e.cause)){e=e.cause||e;t.httpStatus=e.status;if(e.isConcurrentModification){t.isConcurrentModification=true;}if(e.retryAfter){t.retryAfter=e.retryAfter;}}if(!(O instanceof Error)){Object.defineProperty(t,"originalMessage",{enumerable:true,get:function(){if(!C){C=_.publicClone(O);}return C;}});}return t;},decomposeError:function(e,R,s){var D=e.error.details&&e.error.details.map(function(i){return _.getContentID(i);}),t=_.getContentID(e.error);return R.map(function(q,i){var C=new Error(e.message);function v(M,w){if(i===0&&!w){if(M.target){M.message=M.target+": "+M.message;}delete M.target;return true;}return w===q.$ContentID;}C.error=_.clone(e.error);C.requestUrl=s+q.url;C.resourcePath=q.$resourcePath;C.status=e.status;C.statusText=e.statusText;if(!v(C.error,t)){C.error.$ignoreTopLevel=true;}if(C.error.details){C.error.details=C.error.details.filter(function(w,i){return v(w,D[i]);});}return C;});},deepEqual:d,deletePrivateAnnotation:function(O,A){var P=O["@$ui5._"];if(P){delete P[A];}},drillDown:function(O,s){return s.reduce(function(C,S){return(C&&S in C)?C[S]:undefined;},O);},encode:function(P,e){var E=encodeURI(P).replace(r,"%26").replace(j,"%23").replace(l,"%2B");if(e){E=E.replace(b,"%3D");}return E;},encodePair:function(K,v){return _.encode(K,true)+"="+_.encode(v,false);},extractMessages:function(e){var M=[];function i(q,N,t){var R={additionalTargets:_.getAdditionalTargets(q),code:q.code,message:q.message,numericSeverity:N,technical:t||q.technical,"@$ui5.error":e,"@$ui5.originalMessage":q};Object.keys(q).forEach(function(P){if(P[0]==='@'){if(P.endsWith(".numericSeverity")){R.numericSeverity=q[P];}else if(P.endsWith(".longtextUrl")&&e.requestUrl&&q[P]){R.longtextUrl=_.makeAbsolute(q[P],e.requestUrl);}}});if(typeof q.target==="string"){if(q.target[0]==="$"||!e.resourcePath){R.message=q.target+": "+q.message;}else{R.target=q.target;}}R.transition=true;M.push(R);}if(e.error){if(!e.error.$ignoreTopLevel){i(e.error,4,true);}if(e.error.details){e.error.details.forEach(function(q){i(q);});}}else{i(e,4,true);}return M;},extractMergeableQueryOptions:function(q){var e={};if("$expand"in q){e.$expand=q.$expand;q.$expand="~";}if("$select"in q){e.$select=q.$select;q.$select="~";}return e;},fetchPropertyAndType:function(F,M){return F(M).then(function(P){if(P&&P.$kind==="NavigationProperty"){return F(M+"/").then(function(){return P;});}return P;});},filterPaths:function(M,P){return P.filter(function(s){var e=_.getMetaPath(s);return M.every(function(i){return!_.hasPathPrefix(e,i);});});},fireChange:function(C,P,v){var e=C[P],i;if(e){for(i=0;i<e.length;i+=1){e[i].onChange(v);}}},fireChanges:function(C,P,v,R){Object.keys(v).forEach(function(s){var e=_.buildPath(P,s),V=v[s];if(V&&typeof V==="object"){_.fireChanges(C,e,V,R);}else{_.fireChange(C,e,R?undefined:V);}});_.fireChange(C,P,R?undefined:v);},formatLiteral:function(v,t){if(v===undefined){throw new Error("Illegal value: undefined");}if(v===null){return"null";}switch(t){case"Edm.Binary":return"binary'"+v+"'";case"Edm.Boolean":case"Edm.Byte":case"Edm.Double":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":case"Edm.Single":return String(v);case"Edm.Date":case"Edm.DateTimeOffset":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int64":case"Edm.TimeOfDay":return v;case"Edm.Duration":return"duration'"+v+"'";case"Edm.String":return"'"+v.replace(n,"''")+"'";default:throw new Error("Unsupported type: "+t);}},getAdditionalTargets:function(M){return _.getAnnotation(M,".additionalTargets");},getAdjustedTarget:function(t,O,P,C){var i,s,S;S=t.split("/");s=S.shift();if(s==="$Parameter"){t=S.join("/");s=S.shift();}if(O.$IsBound&&s===O.$Parameter[0].$Name){t=_.buildPath(C,S.join("/"));return t;}i=O.$Parameter.some(function(e){return s===e.$Name;});if(i){t=P+"/"+t;return t;}},getAnnotation:function(M,N){var A=_.getAnnotationKey(M,N);return A&&M[A];},getAnnotationKey:function(O,N,P){var A,D,s=(P||"")+"@";Object.keys(O).forEach(function(K){if(K.startsWith(s)&&K.endsWith(N)){if(A){L.warning("Cannot distinguish "+A+" from "+K,undefined,c);D=true;}A=K;}});return D?undefined:A;},getContentID:function(M){return _.getAnnotation(M,".ContentID");},getKeyFilter:function(i,M,t,K){var F=[],s,e=_.getKeyProperties(i,M,t,K);if(!e){return undefined;}for(s in e){F.push(s+" eq "+e[s]);}return F.join(" and ");},getKeyPredicate:function(i,M,t,K,e){var q=_.getKeyProperties(i,M,t,K,true);if(!q){return undefined;}K=Object.keys(q).map(function(A,s,v){var V=encodeURIComponent(q[A]);return e||v.length>1?encodeURIComponent(A)+"="+V:V;});return"("+K.join(",")+")";},getKeyProperties:function(i,M,t,K,R){var F,e={};K=K||t[M].$Key;F=K.some(function(v){var s,q,P,S,T,V;if(typeof v==="string"){s=q=v;}else{s=Object.keys(v)[0];q=v[s];if(!R){s=q;}}S=q.split("/");V=_.drillDown(i,S);if(V===undefined){return true;}P=S.pop();T=t[_.buildPath(M,S.join("/"))];V=_.formatLiteral(V,T[P].$Type);e[s]=V;});return F?undefined:e;},getMetaPath:function(P){if(P[0]==="/"){return P.replace(k,"");}if(P[0]!=="("){P="/"+P;}return P.replace(k,"").slice(1);},getPrivateAnnotation:function(O,A){var P=O["@$ui5._"];return P&&P[A];},getQueryOptionsForPath:function(q,P){P=_.getMetaPath(P);if(P){P.split("/").some(function(s){q=q&&q.$expand&&q.$expand[s];if(!q||q===true){q={};return true;}});}return q||{};},getRelativePath:function(P,B){if(B.length){if(!P.startsWith(B)){return undefined;}P=P.slice(B.length);if(P){if(P[0]==="/"){return P.slice(1);}if(P[0]!=="("){return undefined;}}}return P;},hasPrivateAnnotation:function(O,A){var P=O["@$ui5._"];return P?A in P:false;},informAll:function(C,P,O,N){if(N===O){return;}if(N&&typeof N==="object"){Object.keys(N).forEach(function(s){_.informAll(C,_.buildPath(P,s),O&&O[s],N[s]);});}else{_.fireChange(C,P,N===undefined?null:N);N={};}if(O&&typeof O==="object"){Object.keys(O).forEach(function(s){if(!N.hasOwnProperty(s)){_.informAll(C,_.buildPath(P,s),O[s],undefined);}});}},inheritPathValue:function(s,S,t){s.forEach(function(e,i){var M=!(e in t);if(i+1<s.length){if(M){t[e]={};}S=S[e];t=t[e];}else if(M){t[e]=S[e];}});},intersectQueryOptions:function(C,P,F,R,N,s,A){var e=[],E={},q,t,S,v={};function w(x,M){var y=M.split("/");return y.every(function(z,i){return i===0&&x||z==="$count"||F(R+"/"+y.slice(0,i+1).join("/")).getResult().$kind==="Property";});}if(P.indexOf("")>=0){throw new Error("Unsupported empty navigation property path");}if(P.indexOf("*")>=0){S=C&&C.$select||[];}else if(C&&C.$select&&C.$select.indexOf("*")<0){_.addChildrenWithAncestor(P,C.$select,v);_.addChildrenWithAncestor(C.$select,P,v);S=Object.keys(v).filter(w.bind(null,true));}else{S=P.filter(w.bind(null,false));}if(C&&C.$expand){e=Object.keys(C.$expand);e.forEach(function(i){var x,M=R+"/"+i,y=_.buildPath(s,i),z={},B;_.addChildrenWithAncestor([i],P,z);if(!a(z)){if(F(M).getResult().$isCollection){N[y]=true;}E[i]=C.$expand[i];return;}B=_.stripPathPrefix(i,P);if(B.length){if(F(M).getResult().$isCollection){throw new Error("Unsupported collection-valued navigation property "+M);}x=_.intersectQueryOptions(C.$expand[i]||{},B,F,M,N,y);if(x){E[i]=x;}}});}if(!S.length&&a(E)){return null;}q=Object.assign({},C,{$select:S});t=F(R).getResult();if(t.$kind==="NavigationProperty"&&!t.$isCollection){_.selectKeyProperties(q,F(R+"/").getResult());}else if(!S.length&&!A){q.$select=Object.keys(E).slice(0,1);}if(a(E)){delete q.$expand;}else{q.$expand=E;}return q;},hasPathPrefix:function(P,B){return _.getRelativePath(P,B)!==undefined;},isSafeInteger:function(N){if(typeof N!=="number"||!isFinite(N)){return false;}N=Math.abs(N);return N<=9007199254740991&&Math.floor(N)===N;},makeAbsolute:function(s,B){return new U(s).absoluteTo(B).toString().replace(h,"'").replace(g,"(").replace(f,")");},merge:m,mergeQueryOptions:function(q,O,F){var R;function s(P,v){if(v&&(!q||q[P]!==v)){if(!R){R=q?_.clone(q):{};}R[P]=v;}}s("$orderby",O);if(F){s("$filter",F[0]);s("$$filterBeforeAggregate",F[1]);}return R||q;},namespace:function(N){var i;N=N.split("/")[0].split("(")[0];i=N.lastIndexOf(".");return i<0?"":N.slice(0,i);},parseLiteral:function(s,t,P){function e(i){if(!isFinite(i)){throw new Error(P+": Not a valid "+t+" literal: "+s);}return i;}if(s==="null"){return null;}switch(t){case"Edm.Boolean":return s==="true";case"Edm.Byte":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":return e(parseInt(s));case"Edm.Date":case"Edm.DateTimeOffset":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int64":case"Edm.TimeOfDay":return s;case"Edm.Double":case"Edm.Single":return s==="INF"||s==="-INF"||s==="NaN"?s:e(parseFloat(s));case"Edm.String":return s.slice(1,-1).replace(o,"'");default:throw new Error(P+": Unsupported type: "+t);}},publicClone:function(v,R){return _.clone(v,function(K,v){if(R?!K.startsWith("@$ui5."):K!=="@$ui5._"){return v;}});},removeByPath:function(M,P,i){var I=M[P],e;if(I){e=I.indexOf(i);if(e>=0){if(I.length===1){delete M[P];}else{I.splice(e,1);}}}},resolveIfMatchHeader:function(H){var i=H&&H["If-Match"];if(i&&typeof i==="object"){i=i["@odata.etag"];H=Object.assign({},H);if(i===undefined){delete H["If-Match"];}else{H["If-Match"]=i;}}return H;},selectKeyProperties:function(q,t){if(t&&t.$Key){_.addToSelect(q,t.$Key.map(function(K){if(typeof K==="object"){return K[Object.keys(K)[0]];}return K;}));}},setPrivateAnnotation:function(O,A,v){var P=O["@$ui5._"];if(!P){P=O["@$ui5._"]={};}P[A]=v;},stripPathPrefix:function(P,e){var s=P+"/";if(P===""){return e;}return e.filter(function(i){return i===P||i.startsWith(s);}).map(function(i){return i.slice(s.length);});},toArray:function(e){if(e===undefined||e===null){return[];}if(Array.isArray(e)){return e.slice();}return[e];},uid:u,updateAll:function(C,P,t,s,e){Object.keys(s).forEach(function(i){var q=_.buildPath(P,i),S,v=s[i],T,w=t[i];if(i==="@$ui5._"){S=_.getPrivateAnnotation(s,"predicate");if(e&&e(P)){T=_.getPrivateAnnotation(t,"predicate");if(S!==T){throw new Error("Key predicate of '"+P+"' changed from "+T+" to "+S);}}else{_.setPrivateAnnotation(t,"predicate",S);}}else if(Array.isArray(v)){t[i]=v;}else if(v&&typeof v==="object"){t[i]=_.updateAll(C,q,w||{},v,e);}else if(w!==v){t[i]=v;if(w&&typeof w==="object"){_.fireChanges(C,q,w,true);}else{_.fireChange(C,q,v);}}});return t;},updateExisting:function(C,P,O,N){if(!N){return;}Object.keys(O).forEach(function(s){var e=_.buildPath(P,s),v=O[s],i=N[s];if(s in N||s[0]==="#"){if(Array.isArray(i)){O[s]=i;}else if(i&&typeof i==="object"){if(v){_.updateExisting(C,e,v,i);}else{O[s]=i;_.fireChanges(C,e,i,false);}}else if(v!==i){O[s]=i;if(v&&typeof v==="object"){_.fireChanges(C,e,v,true);}else{_.fireChange(C,e,i);}}}});Object.keys(N).filter(function(s){return s[0]==="#";}).filter(function(A){return!(A in O);}).forEach(function(s){var v=N[s],e=_.buildPath(P,s);O[s]=v;_.fireChanges(C,e,v,false);});},updateSelected:function(C,P,O,N,s){function e(i,S,t){var q=i.split("/");q.every(function(v,I){var w=S[v],T=t[v];if(Array.isArray(w)){t[v]=w;}else if(w&&typeof w==="object"){t=t[v]=T||{};S=w;return true;}else if(T!==w){t[v]=w;if(T&&typeof T==="object"){_.fireChanges(C,_.buildPath(P,q.slice(0,I+1).join("/")),T,true);}else if(I===q.length-1){_.fireChange(C,_.buildPath(P,i),w);}}return false;});}if(!s||s.indexOf("*")>=0){_.updateAll(C,P,O,N);return;}s.forEach(function(i){e(i,N,O);});},updateTransientPaths:function(M,t,P){var s;for(s in M){if(s.includes(t)){M[s.replace(t,P)]=M[s];delete M[s];}}},wrapChildQueryOptions:function(B,C,e,F){var E="",M=C.split("/"),P,s=B,q={},Q=q,i;if(C===""){return e;}for(i=0;i<M.length;i+=1){s=_.buildPath(s,M[i]);E=_.buildPath(E,M[i]);P=F(s).getResult();if(P.$kind==="NavigationProperty"){Q.$expand={};Q=Q.$expand[E]=(i===M.length-1)?e:{};_.selectKeyProperties(Q,F(s+"/").getResult());E="";}else if(P.$kind!=="Property"){return undefined;}}if(P.$kind==="Property"){if(Object.keys(e).length>0){L.error("Failed to enhance query options for auto-$expand/$select as the"+" child binding has query options, but its path '"+C+"' points to a structural property",JSON.stringify(e),c);return undefined;}_.addToSelect(Q,[E]);}if("$apply"in e){L.debug("Cannot wrap $apply into $expand: "+C,JSON.stringify(e),c);return undefined;}return q;}};return _;},false);
