/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/each","sap/base/util/isEmptyObject","sap/ui/core/format/NumberFormat","sap/ui/model/CompositeType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(L,e,i,N,C,F,P,V){"use strict";var a=C.extend("sap.ui.model.type.Currency",{constructor:function(f){C.apply(this,arguments);this.sName="Currency";this.bShowMeasure=!f||!("showMeasure"in f)||f.showMeasure;this.bShowNumber=!f||!("showNumber"in f)||f.showNumber;this.bUseRawValues=true;}});a.prototype.formatValue=function(v,t){var b=v;if(v==undefined||v==null){return null;}if(this.oInputFormat){b=this.oInputFormat.parse(v);}if(!Array.isArray(b)){throw new F("Cannot format currency: "+v+" has the wrong format");}if((b[0]==undefined||b[0]==null)&&this.bShowNumber){return null;}switch(this.getPrimitiveType(t)){case"string":return this.oOutputFormat.format(b);default:throw new F("Don't know how to format currency to "+t);}};a.prototype.parseValue=function(v,s){var r;switch(this.getPrimitiveType(s)){case"string":r=this.oOutputFormat.parse(v);if(!Array.isArray(r)||this.bShowNumber&&isNaN(r[0])){throw this.getParseException();}break;default:throw new P("Don't know how to parse Currency from "+s);}if(this.oInputFormat){r=this.oInputFormat.format(r);}return r;};a.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),c=[],m=[],d=v,f;if(this.oInputFormat){d=this.oInputFormat.parse(v);}f=d[0];e(this.oConstraints,function(n,o){switch(n){case"minimum":if(f<o){c.push("minimum");m.push(b.getText("Currency.Minimum",[o]));}break;case"maximum":if(f>o){c.push("maximum");m.push(b.getText("Currency.Maximum",[o]));}break;default:L.warning("Unknown constraint '"+n+"': Value is not validated.",null,"sap.ui.model.type.Currency");}});if(c.length>0){throw new V(this.combineMessages(m),c);}}};a.prototype.setFormatOptions=function(f){this.oFormatOptions=Object.assign(f.style!=="short"&&f.style!=="long"?{preserveDecimals:true}:{},f);this._createFormats();};a.prototype._handleLocalizationChange=function(){this._createFormats();};a.prototype._createFormats=function(){var s=this.oFormatOptions.source;this.oOutputFormat=N.getCurrencyInstance(this.oFormatOptions);if(s){if(i(s)){s={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."};}this.oInputFormat=N.getCurrencyInstance(s);}};a.prototype.getParseException=function(){var b=sap.ui.getCore().getLibraryResourceBundle(),t;if(!this.bShowNumber){t=b.getText("Currency.InvalidMeasure");}else if(!this.bShowMeasure){t=b.getText("EnterNumber");}else{t=b.getText("Currency.Invalid");}return new P(t);};a.prototype.getPartsIgnoringMessages=function(){if(!this.bShowMeasure){return[1];}else if(!this.bShowNumber){return[0];}return[];};return a;});
