/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/fl/write/api/FieldExtensibility","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/resource/ResourceModel","sap/ui/model/Sorter","sap/ui/rta/Utils"],function(M,F,a,J,b,c,R,S,U){"use strict";var A=M.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog",{metadata:{library:"sap.ui.rta",properties:{customFieldEnabled:{type:"boolean",defaultValue:false},businessContextVisible:{type:"boolean",defaultValue:false},title:{type:"string"}},events:{opened:{},openCustomField:{}}}});var r;A.prototype.init=function(){this._oDialogPromise=F.load({id:this.getId(),name:"sap.ui.rta.plugin.additionalElements.AddElementsDialog",controller:this});this._oDialogModel=new J({elements:[],customFieldEnabled:false,customFieldVisible:false,businessContextVisible:false,customFieldButtonTooltip:"",businessContextTexts:[{text:""}]});this._oDialogPromise.then(function(d){d.setModel(this._oDialogModel);if(!r){r=new R({bundleName:"sap.ui.rta.messagebundle"});}d.setModel(r,"i18n");d.addStyleClass(U.getRtaStyleClassName());this._oDialogModel.setProperty("/listNoDataText",r.getProperty("MSG_NO_FIELDS").toLowerCase());this._oList=sap.ui.getCore().byId(this.getId()+"--rta_addElementsDialogList");this._bDescendingSortOrder=false;}.bind(this));};A.prototype.exit=function(){this._oDialogPromise.then(function(d){d.destroy();});if(M.prototype.exit){M.prototype.exit.apply(this,arguments);}};A.prototype.setCustomFieldButtonVisible=function(v){this._oDialogModel.setProperty("/customFieldVisible",v);};A.prototype._submitDialog=function(){return this._oDialogPromise.then(function(d){d.close();this._fnResolveOnDialogConfirm();}.bind(this));};A.prototype._cancelDialog=function(){this._oDialogModel.getObject("/elements").forEach(function(e){e.selected=false;});this._oDialogPromise.then(function(d){d.close();});this._fnRejectOnDialogCancel();};A.prototype.setElements=function(e){this._oDialogModel.setProperty("/elements",e);};A.prototype.getElements=function(){return this._oDialogModel.getProperty("/elements");};A.prototype.getSelectedElements=function(){return this._oDialogModel.getObject("/elements").filter(function(e){return e.selected;});};A.prototype.open=function(){return new Promise(function(d,e){this._fnResolveOnDialogConfirm=d;this._fnRejectOnDialogCancel=e;this._oDialogPromise.then(function(D){D.attachAfterOpen(function(){this.fireOpened();}.bind(this));D.open();}.bind(this));}.bind(this));};A.prototype._resortList=function(){this._bDescendingSortOrder=!this._bDescendingSortOrder;var B=this._oList.getBinding("items");var s=[];s.push(new S("label",this._bDescendingSortOrder));B.sort(s);};A.prototype._updateModelFilter=function(e){var v=e.getParameter("newValue");var B=this._oList.getBinding("items");if((typeof v)==="string"){var f=new b("label",c.Contains,v);var o=new b("originalLabel",c.Contains,v);var p=new b("parentPropertyName",c.Contains,v);var d=new b("duplicateName",c.EQ,true);var P=new b({filters:[p,d],and:true});var g=new b({filters:[f,o,P],and:false});B.filter([g]);}else{B.filter([]);}};A.prototype._redirectToCustomFieldCreation=function(){this.fireOpenCustomField();this._oDialogPromise.then(function(d){d.close();});};A.prototype.setTitle=function(t){M.prototype.setProperty.call(this,"title",t,true);this._oDialogPromise.then(function(d){d.setTitle(t);});};A.prototype.setCustomFieldEnabled=function(C){this.setProperty("customFieldEnabled",C,true);this._oDialogModel.setProperty("/customFieldEnabled",this.getProperty("customFieldEnabled"));};A.prototype._setBusinessContextVisible=function(B){this.setProperty("businessContextVisible",B,true);this._oDialogModel.setProperty("/businessContextVisible",B);};A.prototype.addExtensionData=function(e){this._removeExtensionDataTexts();var B=this._oDialogModel.getObject("/businessContextTexts");if(e&&e.length>0){e.forEach(function(C){B.push({text:C.description});},this);}else{B.push({text:r.getProperty("MSG_NO_BUSINESS_CONTEXTS")});}this._setBusinessContextVisible(true);return a.getTexts().then(function(f){if(f){this._oDialogModel.setProperty("/customFieldButtonTooltip",f.tooltip);this._oDialogModel.setProperty("/businessContextTexts/0/text",f.headerText);}}.bind(this));};A.prototype._removeExtensionDataTexts=function(){var B=this._oDialogModel.getObject("/businessContextTexts");B.splice(1);};return A;});
