/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/format/DateFormat","sap/ui/core/Fragment","sap/ui/core/library","sap/ui/fl/library","sap/ui/rta/Utils","sap/ui/rta/toolbar/translation/Translation","sap/ui/rta/appVariant/Feature","sap/ui/rta/toolbar/Base","sap/ui/Device"],function(D,F,c,f,U,T,A,B,a){"use strict";var M=c.MessageType;var V=f.Versions;var b=B.extend("sap.ui.rta.toolbar.Adaptation",{renderer:"sap.ui.rta.toolbar.AdaptationRenderer",animation:true,metadata:{library:"sap.ui.rta",events:{undo:{},redo:{},exit:{},restore:{},transport:{},modeChange:{},activate:{},discardDraft:{},switchVersion:{},onCommandCategorySelection:{}}}});b.modes={MOBILE:"sapUiRtaToolbarMobile",TABLET:"sapUiRtaToolbarTablet",DESKTOP:"sapUiRtaToolbarDesktop"};var d="sapUiRtaToolbar";var e="sapUiRtaDraftVersionAccent";var g="sapUiRtaActiveVersionAccent";b.prototype.init=function(){a.media.attachHandler(this._onSizeChanged,this,d);this._pFragmentLoaded=B.prototype.init.apply(this,arguments);};b.prototype.onBeforeRendering=function(){if(!a.media.hasRangeSet(d)){a.media.initRangeSet(d,[900,1200],"px",[b.modes.MOBILE,b.modes.TABLET,b.modes.DESKTOP]);}this._onSizeChanged(a.media.getCurrentRange(d));B.prototype.onBeforeRendering.apply(this,arguments);};b.prototype.onFragmentLoaded=function(){return this._pFragmentLoaded;};b.prototype.exit=function(){a.media.detachHandler(this._onSizeChanged,this,d);B.prototype.exit.apply(this,arguments);};function s(l,I,t,m){var n=this.getControl(l);var p=t?this.getTextResources().getText(t):"";var q=m?this.getTextResources().getText(m):"";n.setText(p||"");n.setTooltip(q||"");n.setIcon(I||"");}b.prototype.formatDiscardDraftVisible=function(n,v){return n===sap.ui.fl.Versions.Draft&&v;};b.prototype.formatVersionButtonText=function(v,n){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var l="";var m="Active";v=v||[];if(n===undefined||n===V.Original){l=t.getText("TIT_ORIGINAL_APP");m="inactive";if(v.length===0||(v.length===1&&v[0].type==="draft")){m="active";}}else{var p=v.find(function(q){return q.version===n;});if(p){m=p.type;if(n===V.Draft){l=t.getText("TIT_DRAFT");}else{l=p.title||t.getText("TIT_VERSION_1");}}}this.setVersionButtonAccentColor(m);return l;};b.prototype.formatVersionTableVisibility=function(n){return n>0;};b.prototype.formatVersionTitle=function(t,l){var m=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(l==="draft"){return m.getText("TIT_DRAFT");}return t||m.getText("TIT_VERSION_1");};b.prototype.formatVersionTimeStamp=function(t){if(!t){return"";}return D.getInstance({format:"yMMMdjm"}).format(new Date(t));};b.prototype.formatHighlight=function(t){switch(t){case"draft":return M.Warning;case"active":return M.Success;default:return M.None;}};b.prototype.formatHighlightText=function(t){var l=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");switch(t){case"draft":return l.getText("TIT_DRAFT");case"active":return l.getText("LBL_ACTIVE");default:return l.getText("LBL_INACTIVE");}};function h(v){return v.some(function(l){return l.type==="active";});}b.prototype.formatOriginalAppHighlight=function(v){return h(v)?M.None:M.Success;};b.prototype.formatOriginalAppHighlightText=function(v){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return h(v)?t.getText("LBL_INACTIVE"):t.getText("LBL_ACTIVE");};b.prototype.versionSelected=function(E){var v=E.getSource().getBindingContext("versions");var n=V.Original;if(v){n=v.getProperty("version");}this.fireEvent("switchVersion",{version:n});};b.prototype.showVersionHistory=function(E){var v=E.getSource();if(!this.oVersionDialogPromise){this.oVersionDialogPromise=F.load({name:"sap.ui.rta.toolbar.VersionHistory",id:this.getId()+"_versionHistoryDialog",controller:{formatVersionTitle:this.formatVersionTitle.bind(this),formatVersionTimeStamp:this.formatVersionTimeStamp.bind(this),formatVersionTableVisibility:this.formatVersionTableVisibility.bind(this),formatHighlight:this.formatHighlight.bind(this),formatHighlightText:this.formatHighlightText.bind(this),formatOriginalAppHighlight:this.formatOriginalAppHighlight.bind(this),formatOriginalAppHighlightText:this.formatOriginalAppHighlightText.bind(this),versionSelected:this.versionSelected.bind(this)}}).then(function(l){v.addDependent(l);return l;});}return this.oVersionDialogPromise.then(function(l){if(!l.isOpen()){l.openBy(v);}else{l.close();}});};b.prototype.showTranslationPopover=function(E){var t=this.addExtension("translation",T);return t.showTranslationPopover(E,this);};b.prototype.showRestore=function(v){return!v;};b.prototype._showButtonIcon=function(l,I,t){s.call(this,l,I,"",t);};b.prototype._showButtonText=function(l,t){s.call(this,l,"",t,"");};b.prototype._switchToIcons=function(){var I=this.getControl("iconBox");var l=this.getControl("iconSpacer");I.setVisible(false);l.setVisible(false);this._showButtonIcon("adaptationSwitcherButton","sap-icon://wrench","BTN_ADAPTATION");this._showButtonIcon("navigationSwitcherButton","sap-icon://explorer","BTN_NAVIGATION");this._showButtonIcon("visualizationSwitcherButton","sap-icon://show","BTN_VISUALIZATION");this._showButtonIcon("exit","sap-icon://decline","BTN_EXIT");};b.prototype._switchToTexts=function(){var I=this.getControl("iconBox");var l=this.getControl("iconSpacer");I.setVisible(true);l.setVisible(true);this._showButtonText("adaptationSwitcherButton","BTN_ADAPTATION");this._showButtonText("navigationSwitcherButton","BTN_NAVIGATION");this._showButtonText("visualizationSwitcherButton","BTN_VISUALIZATION");this._showButtonText("exit","BTN_EXIT");};b.prototype._onSizeChanged=function(p){if(!p){return Promise.resolve();}return this.onFragmentLoaded().then(function(){var m=p.name;this.sMode=m;switch(m){case b.modes.MOBILE:this._switchToIcons();break;case b.modes.TABLET:case b.modes.DESKTOP:this._switchToTexts();break;default:}}.bind(this));};b.prototype.buildControls=function(){return F.load({name:"sap.ui.rta.toolbar.Adaptation",id:this.getId()+"_fragment",controller:{activate:this._openVersionTitleDialog.bind(this),discardDraft:this.eventHandler.bind(this,"DiscardDraft"),formatDiscardDraftVisible:this.formatDiscardDraftVisible.bind(this),modeChange:this.eventHandler.bind(this,"ModeChange"),showTranslationPopover:this.showTranslationPopover.bind(this),undo:this.eventHandler.bind(this,"Undo"),redo:this.eventHandler.bind(this,"Redo"),onCommandCategorySelection:this.eventHandler.bind(this,"OnCommandCategorySelection"),manageApps:j.bind(this),appVariantOverview:i.bind(this),saveAs:o.bind(this),restore:this.eventHandler.bind(this,"Restore"),publish:this.eventHandler.bind(this,"Transport"),exit:this.eventHandler.bind(this,"Exit"),formatVersionButtonText:this.formatVersionButtonText.bind(this),showVersionHistory:this.showVersionHistory.bind(this),showRestore:this.showRestore.bind(this)}});};function o(){A.onSaveAs(true,true,this.getRtaInformation().flexSettings.layer,null);}function i(E){var I=E.getParameter("item");var t=I.getId().endsWith("keyUser");return A.onGetOverview(t,this.getRtaInformation().flexSettings.layer);}function j(){A.onGetOverview(true,this.getRtaInformation().flexSettings.layer);}function r(){this.getControl("versionTitleInput").setValue("");this.getControl("confirmVersionTitleButton").setEnabled(false);return Promise.resolve(this._oDialog);}function k(){return F.load({name:"sap.ui.rta.toolbar.VersionTitleDialog",id:this.getId()+"_fragment",controller:{onConfirmVersioningDialog:function(){var v=this.getControl("versionTitleInput").getValue();this.fireEvent("activate",{versionTitle:v});this._oDialog.close();}.bind(this),onCancelVersioningDialog:function(){this._oDialog.close();}.bind(this),onVersionTitleLiveChange:function(E){var v=E.getParameter("value");this.getControl("confirmVersionTitleButton").setEnabled(!!v);}.bind(this)}}).then(function(l){this._oDialog=l;l.addStyleClass(U.getRtaStyleClassName());this.addDependent(this._oDialog);}.bind(this));}b.prototype.getControl=function(n){return sap.ui.getCore().byId(this.getId()+"_fragment--sapUiRta_"+n);};b.prototype._openVersionTitleDialog=function(n){var l;if(this._oDialog){l=r.call(this);}else{l=k.call(this);}return l.then(function(){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var m=t.getText("TIT_VERSION_TITLE_DIALOG");if(n!==V.Draft){m=t.getText("TIT_REACTIVATE_VERSION_TITLE_DIALOG");}this._oDialog.setTitle(m);return this._oDialog.open();}.bind(this));};b.prototype.setVersionButtonAccentColor=function(t){var v=this.getControl("versionButton");switch(t){case"draft":v.addStyleClass(e);v.removeStyleClass(g);break;case"active":v.addStyleClass(g);v.removeStyleClass(e);break;default:v.removeStyleClass(g);v.removeStyleClass(e);}};return b;});
