/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/core/Control","sap/m/Text","sap/ui/core/format/DateFormat","sap/ui/core/Icon","sap/ui/events/KeyCodes","sap/base/strings/capitalize","sap/ui/rta/util/changeVisualization/categories/getVisualizationCategory","sap/ui/fl/Utils","sap/ui/fl/util/resolveBinding"],function(F,J,C,T,D,I,K,c,g,a,r){"use strict";var b=C.extend("sap.ui.rta.util.changeVisualization.ChangeIndicator",{metadata:{library:"sap.ui.rta",properties:{changes:{type:"array",defaultValue:[]},mode:{type:"string",defaultValue:"change"},posX:{type:"int"},posY:{type:"int"},overlayId:{type:"string"},selectorId:{type:"string"}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{selectChange:{parameters:{changeId:{type:"string"}}},keyPress:{parameters:{originalEvent:{type:"object"}}}}},renderer:{apiVersion:2,render:function(R,o){R.openStart("div",o);R.class("sapUiRtaChangeIndicator");R.class("sapUiRtaChangeIndicator"+c(o.getMode()));if(o.getMode()==="change"&&o.getModel()&&o.getModel().getData().selectedChange){R.class("sapUiRtaChangeIndicatorChangeSolid");}R.style("width",o._getSize()+"px");R.style("height",o._getSize()+"px");R.openEnd();R.openStart("div");R.openEnd();R.renderControl(o.getAggregation("_icon"));R.renderControl(o.getAggregation("_text"));R.close("div");R.close("div");}},constructor:function(){this._oDetailModel=new J();this._oDetailModel.setDefaultBindingMode("OneWay");C.prototype.constructor.apply(this,arguments);}});b.prototype.init=function(){this.setAggregation("_text",new T({text:"{= (${changes} || []).length}",visible:"{= (${changes} || []).length > 1}"}).addStyleClass("sapUiRtaChangeIndicatorText"));this.setAggregation("_icon",new I({src:"sap-icon://display",visible:{path:"/selectedChange",formatter:function(s){return!!(s&&this.getChanges().some(function(o){return(o.id===s&&o.dependent===false);}));}.bind(this)}}).addStyleClass("sapUiRtaChangeIndicatorIcon"));this.attachBrowserEvent("click",this._onSelect,this);this.attachBrowserEvent("keydown",this._onKeyDown,this);this.attachBrowserEvent("mouseleave",function(){this._toggleHoverStyleClasses(false);},this);this.attachBrowserEvent("focusout",function(){this._toggleHoverStyleClasses(false);},this);this.attachBrowserEvent("mouseover",function(){this._toggleHoverStyleClasses(true);},this);this.attachBrowserEvent("focusin",function(){this._toggleHoverStyleClasses(true);},this);};b.prototype.focus=function(){if(this.getDomRef()){C.prototype.focus.apply(this,arguments);this._bScheduledForFocus=false;}this._bScheduledForFocus=true;};b.prototype._getSize=function(){var o=document.getElementById(this.getOverlayId());var s=o.offsetHeight;return(s>50?50:s)-2;};b.prototype.onAfterRendering=function(){var o=document.getElementById(this.getOverlayId());o.appendChild(this.getDomRef());this.getDomRef().tabIndex=0;if(this._bScheduledForFocus){this.focus();this._toggleHoverStyleClasses(true);}};b.prototype.exit=function(){var d=this.getDomRef();if(d){d.parentNode.removeChild(d);}this.detachBrowserEvent("click",this._onSelect,this);this.detachBrowserEvent("keydown",this._onKeyDown,this);};b.prototype.setChanges=function(d){this.setProperty("changes",d);this._oDetailModel.setData((d||[]).map(this._formatChangesModelItem.bind(this)));};b.prototype.setMode=function(m){this.setProperty("mode",m);this._oDetailModel.setData((this.getChanges()||[]).map(this._formatChangesModelItem.bind(this)));};b.prototype._onSelect=function(e){this.focus();e.stopPropagation();if(this.getModel().getData().selectedChange&&!this.getChanges().some(function(o){return o.dependent;})){this.fireSelectChange({changeId:undefined});}else{this._openDetailPopover();}};b.prototype._onKeyDown=function(e){if(e.keyCode===K.ENTER){this._onSelect(e);}this.fireKeyPress({originalEvent:e});};b.prototype._toggleHoverStyleClasses=function(A){var o=sap.ui.getCore().byId(this.getOverlayId());if(o.getMetadata().getName()!=="sap.ui.dt.ElementOverlay"){return;}var f=A?"addStyleClass":"removeStyleClass";o[f]("sapUiRtaOverlayHover");o[f]("sapUiRtaChangeIndicatorHovered");};b.prototype._formatChangesModelItem=function(m){var A=sap.ui.getCore().byId(m.affectedElementId);var p=Object.keys(m.payload||{}).reduce(function(p,k){var O=m.payload[k];var j=a.isBinding(O);var V=j?r(O,A):O;p[k]=V;return p;},{});var o=sap.ui.getCore().byId(this.getOverlayId());var e=o.getDesignTimeMetadata().getLabel(A);var v=g(m.commandCategory);var d=v&&v.getDescription(p,e);var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var M=this.getMode();var s=m.commandName.charAt(0).toUpperCase()+m.commandName.slice(1);e=e&&"'"+e+"'";var f=("TXT_CHANGEVISUALIZATION_"+M.toUpperCase()+"_"+m.commandName.toUpperCase());var h=d||R.getText(f,e);var i=D.getDateTimeInstance().format(new Date(m.change.getCreation()));var E=(M==="change"&&(m.commandName==="move"||m.commandName==="split"));return{id:m.id,change:m,changeTitle:s,description:h,date:i,enableDetailButton:E};};b.prototype._openDetailPopover=function(){if(!this.getAggregation("_popover")){F.load({name:"sap.ui.rta.util.changeVisualization.ChangeIndicatorPopover",controller:this}).then(function(p){p._bOpenedByChangeIndicator=true;this.setAggregation("_popover",p);p.setModel(this._oDetailModel,"details");p.openBy(this);}.bind(this));}else{if(this.getAggregation("_popover").isOpen()){return this.getAggregation("_popover").close();}this.getAggregation("_popover").openBy(this);}};b.prototype._showDependentElements=function(e){this.getAggregation("_popover").close();var s=this.getChanges().length>1?e.getSource().getBindingContext("details").getObject().id:this.getChanges()[0].id;this.fireSelectChange({changeId:s});};return b;});
