/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseController","../models/SharedModel","../models/Documentation","../models/SelectionUtils","../models/PresetsUtils","sap/ui/core/Fragment","sap/ui/core/mvc/XMLView","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/util/EvalUtils","sap/ui/thirdparty/URI","sap/ui/VersionInfo","sap/m/library"],function(B,S,D,a,P,F,X,C,c,b,d,E,U,V,m){"use strict";var e=m.ButtonType;return B.extend("sap.ui.support.supportRules.ui.controllers.Main",{onInit:function(){this.model=S;this.getView().setModel(this.model);this.resizeDown();this.setCommunicationSubscriptions();this.initSettingsPopoverModel();this.hidden=false;this.model.setProperty("/hasNoOpener",window.opener?false:true);this.model.setProperty("/constants",b);this.updateShowButton();this._setContextSettings();this._zoomUI();this.bAdditionalViewLoaded=false;C.subscribe(c.UPDATE_SUPPORT_RULES,function(){if(!this.bAdditionalViewLoaded){this.bAdditionalViewLoaded=true;this.loadAdditionalUI();}},this);},_zoomUI:function(){try{var z=window.localStorage.getItem("support-assistant-zoom-ui");var f="100%";switch(z){case"S":f="90%";break;default:}document.querySelector("html").style.fontSize=f;}catch(o){}},loadAdditionalUI:function(){X.create({id:this.getView().getId()+"--issues",viewName:"sap.ui.support.supportRules.ui.views.Issues"}).then(function(i){this.byId("navCon").insertPage(i);}.bind(this));},onAfterRendering:function(){V.load({library:"sap.ui.core"}).then(function(o){C.publish(c.POST_UI_INFORMATION,{version:o,location:new U(jQuery.sap.getModulePath("sap.ui.support"),window.location.origin+window.location.pathname).toString()});});this._checkTempRules();},initSettingsPopoverModel:function(){var s=new U(sap.ui.resource('sap.ui.support',''),window.location.origin+window.location.pathname)._string,f=sap.ui.version;this.model.setProperty("/supportAssistantOrigin",s);this.model.setProperty("/supportAssistantVersion",f);},copySupportAssistantOriginToClipboard:function(o){var s=this.model.getProperty("/supportAssistantOrigin"),f=function(o){if(o.clipboardData){o.clipboardData.setData('text/plain',s);}else{o.originalEvent.clipboardData.setData('text/plain',s);}o.preventDefault();};if(window.clipboardData){window.clipboardData.setData("text",s);}else{document.addEventListener('copy',f);document.execCommand('copy');document.removeEventListener('copy',f);}},setCommunicationSubscriptions:function(){var p;C.subscribe(c.CURRENT_LOADING_PROGRESS,function(f){var i=f.value,o=this.byId("progressIndicator");if(f.value<100){this.model.setProperty("/showProgressIndicator",true);clearTimeout(p);p=setTimeout(function(){this.model.setProperty("/showProgressIndicator",false);}.bind(this),2500);}else{setTimeout(function(){this.model.setProperty("/showProgressIndicator",false);}.bind(this),2000);}o.setDisplayValue(b.RULESET_LOADING+" "+i+"%");this.model.setProperty("/progress",i);},this);C.subscribe(c.ON_ANALYZE_FINISH,function(f){this._clearProcessIndicator();this.ensureOpened();this.model.setProperty("/showProgressIndicator",false);this.model.setProperty("/coreStateChanged",false);this.model.setProperty("/lastAnalysisElapsedTime",f.elapsedTime);this.goToIssues();this.model.setProperty("/analyzedFinish",true);},this);C.subscribe(c.ON_PROGRESS_UPDATE,function(f){var g=f.currentProgress,h=this.byId("progressIndicator");h.setDisplayValue(g+"/"+100);this.model.setProperty("/progress",g);},this);C.subscribe(c.ON_CORE_STATE_CHANGE,function(){this.model.setProperty("/coreStateChanged",true);},this);},resizeUp:function(){C.publish(c.RESIZE_FRAME,{bigger:true});},ensureOpened:function(){C.publish(c.ENSURE_FRAME_OPENED);},resizeDown:function(){C.publish(c.RESIZE_FRAME,{bigger:false});},onSettings:function(o){C.publish(c.ENSURE_FRAME_OPENED);this._openSettingsPopover(o.getSource());},onPersistedSettingSelect:function(){if(this.model.getProperty("/persistingSettings")){d.createPersistenceCookie(b.COOKIE_NAME,true);this.model.getProperty("/libraries").forEach(function(l){if(l.title===b.TEMP_RULESETS_NAME){d.setRules(l.rules);}});this.persistExecutionScope();this.persistVisibleColumns();a.persistSelection();P.persistSelectionPresets();P.persistCustomPresets();}else{d.deletePersistenceCookie(b.COOKIE_NAME);this.deletePersistedData();}},onSettingsPopoverClose:function(){if(this.model.getProperty("/persistingSettings")&&!this.model.getProperty("/tempRulesDisabledWarned")){this.model.setProperty("/tempRulesDisabledWarned",true);d.markTempRulesDisabledWarned();}},goToAnalysis:function(o){this._setActiveView("analysis");},goToIssues:function(o){this._setActiveView("issues");},goToWiki:function(){D.openTopic("57ccd7d7103640e3a187ed55e1d2c163");},updateShowButton:function(){this.byId("sapSTShowButtonBar").setVisible(this.hidden);},toggleHide:function(){this.hidden=!this.hidden;this.updateShowButton();C.publish(c.TOGGLE_FRAME_HIDDEN,this.hidden);},_clearProcessIndicator:function(){var p=this.byId("progressIndicator");p.setDisplayValue("None");this.model.setProperty("/progress",0.1);},_setContextSettings:function(){var f=d.readPersistenceCookie(b.COOKIE_NAME);if(f){this.model.setProperty("/persistingSettings",true);var g=d.getSelectedContext();if(g){this.model.setProperty("/analyzeContext",g.analyzeContext);this.model.setProperty("/subtreeExecutionContextId",g.subtreeExecutionContextId);}else{this.model.setProperty("/analyzeContext",this.model.getProperty("/analyzeContext"));this.model.setProperty("/subtreeExecutionContextId","");}}},_setActiveView:function(i){this.byId("issuesBtn").setType(e.Default);this.byId("analysisBtn").setType(e.Default);this.byId(i+"Btn").setType(e.Emphasized);this.byId("navCon").to(this.byId(i),"show");this.ensureOpened();},_checkTempRules:function(){if(!E.isEvalAllowed()&&!this.model.getProperty("/tempRulesDisabledWarned")){this._openSettingsPopover();}},_openSettingsPopover:function(){if(!this._settingsPopover){this._settingsPopover=F.load({name:"sap.ui.support.supportRules.ui.views.StorageSettings",controller:this}).then(function(s){this.getView().addDependent(s);return s;}.bind(this));}this._settingsPopover.then(function(s){s.openBy(this.byId("settingsIcon"));}.bind(this));},_isSettingsPopoverOpen:function(){return this._settingsPopover&&this._settingsPopover.isOpen();}});});
