/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./CreationRowRenderer","./Column","./utils/TableUtils","sap/ui/core/Control","sap/m/library","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button"],function(R,C,T,a,M,O,b,B){"use strict";var c=a.extend("sap.ui.table.CreationRow",{metadata:{library:"sap.ui.table",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},_defaultToolbar:{type:"sap.ui.core.Toolbar",multiple:false,visibility:"hidden"}},events:{apply:{allowPreventDefault:true}}}});c.prototype.setApplyEnabled=function(e){this.setProperty("applyEnabled",e,true);this._updateDefaultToolbar();return this;};c.prototype.setVisible=function(v){var V=this.getVisible();var t=this.getTable();this.setProperty("visible",v);if(V!==v&&t){t.invalidate();}return this;};c.prototype.setParent=function(p){a.prototype.setParent.apply(this,arguments);this._update();return this;};c.prototype.resetFocus=function(){var i=T.getFirstInteractiveElement(this);if(i){i.focus();T.selectElementText(i);return true;}return false;};c.prototype.getFocusDomRef=function(){var i=T.getFirstInteractiveElement(this);if(i){return i;}return a.prototype.getFocusDomRef.apply(this,arguments);};c.prototype._fireApply=function(){var f=false;if(this.fireApply()){f=this.resetFocus();}return f;};function s(o,e){var f=document.activeElement;o.getTable().getDomRef("focusDummy").focus();e.setMarked();window.setTimeout(function(){if(!o._fireApply()){f.focus();}},0);}c.prototype.onsapenter=function(e){if(this.getApplyEnabled()&&!e.isMarked()){s(this,e);}};c.prototype.onsapentermodifiers=function(e){if(this.getApplyEnabled()&&(e.metaKey||e.ctrlKey)){s(this,e);}};function d(o){return new O(o.getId()+"-tb",{content:[new b(),new B(o.getId()+"-applyBtn",{text:T.getResourceText("TBL_CREATIONROW_APPLY"),enabled:o.getApplyEnabled(),press:function(){o._fireApply();}})],style:M.ToolbarStyle.Clear,ariaLabelledBy:[o.getId()+"-label"]});}c.prototype._getToolbar=function(){var t=this.getToolbar();if(!t){var D=this.getAggregation("_defaultToolbar");if(!D){D=d(this);this.setAggregation("_defaultToolbar",D,true);}t=D;if(t.data("sap-ui-table-invalid")){this._updateDefaultToolbar();}}return t;};c.prototype._updateDefaultToolbar=function(){var D=this.getAggregation("_defaultToolbar");var A;if(this.getToolbar()){if(D){D.data("sap-ui-table-invalid",true);}return;}if(!D){return;}A=D.getContent()[1];A.setEnabled(this.getApplyEnabled());D.data("sap-ui-table-invalid",null);};c.prototype._getCell=function(i){var e=this.getCells();var o=e.filter(function(o){return C.ofCell(o).getIndex()===i;})[0];if(!o){return null;}return o;};c.prototype._getCellDomRef=function(i){var o=this._getCell(i);var e=o?o.getDomRef():null;var $=T.getCell(this.getTable(),e,true);if(!$){return null;}return $;};c.prototype._focusCell=function(i){var o=this._getCellDomRef(i);var I=T.getInteractiveElements(o);if(I){I[0].focus();T.selectElementText(I[0]);return true;}return false;};c.prototype._takeOverKeyboardHandling=function(e){var t=this.getTable();var o=t?t.getDomRef():null;if(!o||!o.contains(document.activeElement)){return false;}var f=T.getCell(this.getTable(),document.activeElement);var g=T.getCellInfo(f);var F=false;if(g.columnIndex!=null&&g.columnIndex>=0){F=this._focusCell(g.columnIndex);}else{F=this.resetFocus();}if(F&&e){e.preventDefault();}return F;};c.prototype._update=function(){var t=this.getTable();if(!t){this.removeAllCells();return;}var e=t.getColumns();this.removeAllCells();for(var i=0,l=e.length;i<l;i++){if(e[i].getVisible()){this.addCell(e[i].getTemplateClone(i,"Creation"));}}};c.prototype.getTable=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Table")?p:null;};return c;});
