/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/Object','sap/ui/test/actions/Press','sap/ui/test/actions/EnterText','sap/ui/test/autowaiter/_autoWaiterAsync','sap/ui/test/_ControlFinder','sap/ui/test/selectors/_ControlSelectorGenerator','sap/ui/test/_OpaLogger'],function(U,P,E,_,a,b,c){"use strict";var R=U.extend("sap.ui.test.RecordReplay",{});var l=c.getLogger("sap.ui.test.RecordReplay");R.InteractionType={Press:"PRESS",EnterText:"ENTER_TEXT"};R.findControlSelectorByDOMElement=function(o){return new Promise(function(r,d){var C=a._getControlForElement(o.domElement);if(!C){d(new Error("Could not find control for DOM element "+o.domElement.id));}var O=Object.assign({control:C},o);b._generate(O).then(function(s){var i=a._getDomElementIDSuffix(o.domElement,C);if(i){l.debug("DOM element ID suffix is "+i);s.interaction={idSuffix:i};}r(s);}).catch(function(e){d(new Error("No control selector found for DOM element "+o.domElement.id+". Error: "+e));});});};R.findDOMElementByControlSelector=function(o){return R.findAllDOMElementsByControlSelector(o).then(function(e){if(e.length){return e[0];}else{throw new Error("No DOM element found using the control selector "+JSON.stringify(o.selector));}});};R.findAllDOMElementsByControlSelector=function(o){return new Promise(function(r,d){try{var e=a._findElements(o.selector);r(e);}catch(f){d(new Error("No DOM element found using the control selector "+JSON.stringify(o.selector)+". Error: "+f));}});};R.interactWithControl=function(o){var C=JSON.stringify(o.selector);return new Promise(function(r,d){var A;switch(o.interactionType){case R.InteractionType.Press:A=new P();break;case R.InteractionType.EnterText:A=new E({text:o.enterText});break;default:d(new Error("Could not interact with control "+C+". Unsupported interaction type: "+o.interactionType+" . Supported interaction types are: "+Object.keys(R.InteractionType).join(", ")));}try{var e=a._findControls(o.selector)[0];if(!e){throw new Error("No controls found using selector "+C);}A.executeOn(e);l.debug("Executed action "+o.interactionType+" on control "+C);r();}catch(f){d(new Error("Could not execute interaction "+o.interactionType+" on control "+C+". Error: "+f));}});};R.waitForUI5=function(o){o=o||{};_.extendConfig(o);return new Promise(function(r,d){_.waitAsync(function(e){if(e){d(new Error(e));}else{r();}});});};return R;});
