/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','sap/ui/unified/DateTypeRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/YearRangePicker','./calendar/CalendarDate',"sap/ui/core/date/UniversalDate",'./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale','sap/ui/events/KeyCodes',"./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log"],function(C,L,a,D,b,H,M,c,Y,d,e,U,l,f,g,R,h,K,j,k,m,n){"use strict";var o=sap.ui.getCore(),p=sap.ui.core.CalendarType;var q=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true},showCurrentDateButton:{type:"boolean",group:"Behavior",defaultValue:false},_currentPicker:{type:"string",group:"Appearance",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},yearRangePicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});var r={MONTH:"month",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker",YEAR_RANGE_PICKER:"yearRangePicker"};q.prototype.init=function(){this._iBreakPointTablet=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iColumns=1;this.setProperty("_currentPicker",r.MONTH_PICKER);this._oYearFormat=g.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var F=this._createMonth(this.getId()+"--Month0");F.attachEvent("focus",this._handleFocus,this);F.attachEvent("select",y,this);F.attachEvent("_renderMonth",x,this);F.attachEvent("_bindMousemove",z,this);F.attachEvent("_unbindMousemove",A,this);F._bNoThemeChange=true;this.addAggregation("month",F);this._initializeMonthPicker();this._initializeYearPicker();this._initializeYearRangePicker();this._resizeProxy=s.bind(this);this._oSelectedMonth;this._bSkipCancelButtonRendering=false;this._bActionTriggeredFromSecondHeader=false;};q.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}if(this._afterHeaderRenderAdjustCSS){this.removeDelegate(this._afterHeaderRenderAdjustCSS);this._afterHeaderRenderAdjustCSS=null;}if(this._afterSecondHeaderRenderAdjustCSS){this.removeDelegate(this._afterSecondHeaderRenderAdjustCSS);this._afterSecondHeaderRenderAdjustCSS=null;}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};q.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressCurrentDate",this._handleCurrentDate,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(i);i.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",i);};q.prototype._createOnAfterRenderingDelegate=function(i){return{onAfterRendering:function(){if(i.getVisible()&&!i.getVisibleButton1()){i.$().find(".sapUiCalHeadB2").addClass("sapUiCalSingleYearButton");}if(i.getVisible()&&!i._getVisibleButton3()){this._isTwoMonthsInTwoColumns()&&i.$().find(".sapUiCalHeadB4").addClass("sapUiCalSingleYearButton");}}.bind(this)};};q.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead",{visible:false});S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this._afterSecondHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(S);S.addDelegate(this._afterSecondHeaderRenderAdjustCSS);this.setAggregation("secondMonthHeader",S);};q.prototype._initializeMonthPicker=function(){var i=new c(this.getId()+"--MP");i._bCalendar=true;i.attachEvent("select",this._selectMonth,this);i.attachEvent("pageChange",B,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);i._setSelectedDatesControlOrigin(this);};q.prototype._initializeYearPicker=function(){var i=new Y(this.getId()+"--YP");i._bCalendar=true;i.attachEvent("select",this._selectYear,this);i.attachEvent("pageChange",E,this);this.setAggregation("yearPicker",i);i._setSelectedDatesControlOrigin(this);};q.prototype._initializeYearRangePicker=function(){var i=new d(this.getId()+"--YRP");i.attachEvent("select",this._selectYearRange,this);i.setPrimaryCalendarType(this.getPrimaryCalendarType());this.setAggregation("yearRangePicker",i);};q.prototype._createMonth=function(i){var F=new M(i,{width:"100%"});F._bCalendar=true;F.attachEvent("datehovered",this._handleDateHovered,this);F.attachEvent("weekNumberSelect",this._handleWeekNumberSelect,this);return F;};q.prototype._handleWeekNumberSelect=function(i){var W=i.getParameter("weekDays"),F=this.fireWeekNumberSelect({weekNumber:i.getParameter("weekNumber"),weekDays:W});this._focusDate(e.fromLocalJSDate(W.getStartDate(),this.getPrimaryCalendarType()),true,false,false);if(!F){i.preventDefault();}return this;};q.prototype._handleDateHovered=function(F){var G=this.getAggregation("month"),I=F.getParameter("date1"),J=F.getParameter("date2"),i;for(i=0;i<G.length;i++){G[i]._markDatesBetweenStartAndHoveredDate(I,J);}};q.prototype.onBeforeRendering=function(){var F=this.getAggregation("month"),G,I=F[0].getDate(),J=this._getFocusedDate();if(F.length>1&&I){G=e.fromLocalJSDate(I,this.getPrimaryCalendarType());}else if(F.length>1){G=t.call(this,this._getFocusedDate());}else{G=J;}for(var i=0;i<F.length;i++){I=new e(G);if(i>0){I.setMonth(I.getMonth()+i,1);}var N=I;if(J.getYear()===I.getYear()&&J.getMonth()===I.getMonth()){N=J;}F[i].displayDate(N.toLocalJSDate());F[i].setShowWeekNumbers(this.getShowWeekNumbers());}if(this._getMonthPicker()){this._setDisabledMonths(J.getYear(),this._getMonthPicker());}this._updateHeader(G);this._updateHeadersButtons();};q.prototype.onAfterRendering=function(i){if(!this._getSucessorsPickerPopup()){u.call(this);}if(w.call(this)>1||this._bInitMonth){i.size={width:this.getDomRef().offsetWidth};s.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};q.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};q.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};q.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};q.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};q.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};q.prototype._setSpecialDatesControlOrigin=function(i){this._oSpecialDatesControlOrigin=i;};q.prototype.getSpecialDates=function(){var P=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin.getSpecialDates();}if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};q.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};q.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};q.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();this._toggleTwoMonthsInTwoColumnsCSS();}return this;};q.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};q.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};q.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new e(i,this.getPrimaryCalendarType());};q.prototype.focusDate=function(i){v.call(this,i,false);this._addMonthFocusDelegate();return this;};q.prototype.displayDate=function(i){v.call(this,i,true);return this;};q.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=e.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new e(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};q.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};q.prototype.setMonths=function(F){this._bDateRangeChanged=undefined;this.setProperty("months",F,false);F=w.call(this);var G=this.getAggregation("month");var i=0;var I;if(G.length<F){for(i=G.length;i<F;i++){I=this._createMonth(this.getId()+"--Month"+i);I.attachEvent("focus",this._handleFocus,this);I.attachEvent("select",y,this);I.attachEvent("_renderMonth",x,this);I.attachEvent("_bindMousemove",z,this);I.attachEvent("_unbindMousemove",A,this);I._bNoThemeChange=true;this.addAggregation("month",I);}}else if(G.length>F){for(i=G.length;i>F;i--){I=this.removeAggregation("month",i-1);I.destroy();}if(F==1){this._bInitMonth=true;}}if(F>1&&G[0].getDate()){G[0].setProperty("date",null,true);}return this;};q.prototype.setPrimaryCalendarType=function(F){var G=this.getAggregation("month"),I,J,N,O,i;this.setProperty("primaryCalendarType",F);this._adjustYearRangeDisplay();this._oYearFormat=g.getDateInstance({format:"y",calendarType:F});if(this._oFocusedDate){this._oFocusedDate=new e(this._oFocusedDate,F);}this._oMinDate=new e(this._oMinDate,F);this._oMaxDate=new e(this._oMaxDate,F);for(i=0;i<G.length;i++){I=G[i];I.setPrimaryCalendarType(F);}if(!this._getSucessorsPickerPopup()){J=this._getMonthPicker();J.setPrimaryCalendarType(F);N=this._getYearPicker();N.setPrimaryCalendarType(F);O=this.getAggregation("yearRangePicker");O.setPrimaryCalendarType(F);}return this;};q.prototype.setSecondaryCalendarType=function(F){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",F);this._oYearFormatSecondary=g.getDateInstance({format:"y",calendarType:F});var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];I.setSecondaryCalendarType(F);}return this;};q.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};q.prototype._getActiveHeaderAggregation=function(){if(this._bActionTriggeredFromSecondHeader&&this._isTwoMonthsInOneColumn()){return this.getAggregation("secondMonthHeader");}else{return this.getAggregation("header");}};q.prototype._saveTriggeredHeader=function(i){if(i.getSource().sParentAggregationName==="secondMonthHeader"||i.sId==="pressButton3"||i.sId==="pressButton4"){this._bActionTriggeredFromSecondHeader=true;}else{this._bActionTriggeredFromSecondHeader=false;}};q.prototype.setMinDate=function(i){var P=this.getPrimaryCalendarType(),F;if(m(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(P);}else{a._checkJSDateObject(i);this._oMinDate=e.fromLocalJSDate(i,P);var G=this._oMinDate.getYear();a._checkYearInValidRange(G);if(this._oMaxDate.isBefore(this._oMinDate)){n.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=e.fromLocalJSDate(i,P);this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(e.fromLocalJSDate(i,P));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){F=this._oMinDate.getYear();this._getYearPicker()._oMinDate.setYear(F);this.getAggregation("yearRangePicker")._oMinDate.setYear(F);}return this;};q.prototype.setMaxDate=function(i){var P,F;if(m(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(P);}else{a._checkJSDateObject(i);this._oMaxDate=e.fromLocalJSDate(i,P);var G=this._oMaxDate.getYear();a._checkYearInValidRange(G);if(this._oMinDate.isAfter(this._oMaxDate)){n.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=e.fromLocalJSDate(i,P);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(e.fromLocalJSDate(i,P));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){F=this._oMaxDate.getYear();this._getYearPicker()._oMaxDate.setYear(F);this.getAggregation("yearRangePicker")._oMaxDate.setYear(F);}return this;};q.prototype.setShowCurrentDateButton=function(S){this.getAggregation("header").setVisibleCurrentDateButton(S);return this.setProperty("showCurrentDateButton",S);};q.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){n.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};q.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var F=new h(i);this._oLocaleData=L.getInstance(F);}return this._oLocaleData;};q.prototype._getShowMonthHeader=function(){var i=w.call(this);if(i>2){return true;}else{return false;}};q.prototype._getMonthPicker=function(){return this.getAggregation("monthPicker");};q.prototype._getYearPicker=function(){return this.getAggregation("yearPicker");};q.prototype._getYearRangePicker=function(){return this.getAggregation("yearRangePicker");};q.prototype.onclick=function(i){var F=i.target;if(i.isMarked("delayedMouseEvent")){return;}if(F.id==this.getId()+"-cancel"){this.onsapescape(i);}};q.prototype.onmousedown=function(i){if(i.cancelable){i.preventDefault();}i.setMark("cancelAutoClose");};q.prototype.onsapescape=function(i){this.fireCancel();this._closePickers();this._addMonthFocusDelegate();if(!this._getSucessorsPickerPopup()){this._setHeaderText(this._getFocusedDate());}};q.prototype.onsapshow=function(i){var F=i.which||i.keyCode;if(this._bPoupupMode&&F!==K.F4){this._closePickers();this._addMonthFocusDelegate();this.fireCancel();i.preventDefault();}};q.prototype.onkeydown=function(i){var F=i.which||i.keyCode,S=i.shiftKey;if(F!==K.F4){return;}i.preventDefault();switch(this._iMode){case 0:if(S){this._showYearPicker();}else{this._showMonthPicker();}break;case 1:if(S){this._showYearPicker();}break;case 2:if(S){this._showYearRangePicker();}break;default:}};q.prototype.onsaphide=q.prototype.onsapshow;q.prototype.onsaptabnext=function(i){var F=this.getAggregation("header");if(k(this.getDomRef("content"),i.target)){if(F.getVisibleButton1()){F.getDomRef("B1").focus();i.preventDefault();}else if(F.getVisibleButton2()){F.getDomRef("B2").focus();i.preventDefault();}else if(!this._bPoupupMode){this._clearTabindex0();}else{this._clearTabindex0();i.preventDefault();}}else if(i.target.id===F.getId()+"-B1"){F.getVisibleButton2()&&F.getDomRef("B2").focus();i.preventDefault();}else if(i.target.id===F.getId()+"-B2"){if(this._bPoupupMode){this._moveFocusToCalContent();i.preventDefault();}else{this._clearTabindex0();}}};q.prototype.onsaptabprevious=function(i){var F=this.getAggregation("header");if(k(this.getDomRef("content"),i.target)){if(this._bPoupupMode){if(F.getVisibleButton2()){F.getDomRef("B2").focus();}else{F.getVisibleButton1()&&F.getDomRef("B1").focus();}i.preventDefault();}else{this._clearTabindex0();}}else if(i.target.id===F.getId()+"-B1"){this._moveFocusToCalContent();i.preventDefault();}else if(i.target.id===F.getId()+"-B2"){if(F.getVisibleButton1()){F.getDomRef("B1").focus();}else{this._moveFocusToCalContent();}i.preventDefault();}};q.prototype._clearTabindex0=function(){var F=this.getAggregation("month"),G=this._getMonthPicker(),I=this.getAggregation("yearPicker"),J=this.getAggregation("yearRangePicker"),N,i;for(i=0;i<F.length;i++){N=F[i];N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","-1");}if(!this._getSucessorsPickerPopup()){if(G.getDomRef()){G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","-1");}if(I.getDomRef()){I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","-1");}if(J.getDomRef()){J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","-1");}}};q.prototype._moveFocusToCalContent=function(){var F=this.getAggregation("yearPicker"),G=this._getMonthPicker(),I=this.getAggregation("month"),J,N,O,i;switch(this._iMode){case 0:O=this._getFocusedDate();for(i=0;i<I.length;i++){J=I[i];N=e.fromLocalJSDate(J.getDate(),this.getPrimaryCalendarType());if(O.isSame(N)){J._oItemNavigation.focusItem(J._oItemNavigation.getFocusedIndex());}else{J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){G._oItemNavigation.focusItem(G._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){F._oItemNavigation.focusItem(F._oItemNavigation.getFocusedIndex());}break;}};q.prototype.onfocusin=function(i){if(i.target.id==this.getId()+"-end"){this._focusOnShiftTab();if(!this._bPoupupMode){this._clearTabindex0();}}this.$("end").attr("tabindex","-1");};q.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header"),F=i.getDomRef("B2");if(F){F.focus();}else{this.focus();}};q.prototype.onsapfocusleave=function(F){var G,I,J,N;if(!F.relatedControlId||!k(this.getDomRef(),sap.ui.getCore().byId(F.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){G=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<G.length;i++){I=G[i];if(I._oItemNavigation){I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){J=this._getMonthPicker();J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){N=this._getYearPicker();N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","0");}break;}}}};q.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0],F=this._getMonthPicker(),G=this._getYearPicker(),I=this._getYearRangePicker();switch(this._iMode){case 0:return i.getFocusDomRef();case 1:return F.getFocusDomRef();case 2:return G.getFocusDomRef();case 3:return I.getFocusDomRef();default:return;}};q.prototype.onThemeChanged=function(){var F,G=arguments;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){var I={onAfterRendering:function(){F.onThemeChanged(G);F._bNoThemeChange=true;u.call(this);this._bLongMonth=F._bLongMonth;this._closePickers();F.removeEventDelegate(I);}};F=this._getMonthPicker();this._showMonthPicker(true);F._bNoThemeChange=false;F.addEventDelegate(I,this);}var J=this.getAggregation("month");for(var i=0;i<J.length;i++){var N=J[i];N._bNoThemeChange=false;N.onThemeChanged(arguments);N._bNoThemeChange=true;}var O;if(J.length>1){O=e.fromLocalJSDate(J[0].getDate(),this.getPrimaryCalendarType());}else{O=this._getFocusedDate();}this._setHeaderText(O);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();};q.prototype._updateHeader=function(i){this._setHeaderText(i);switch(this._iMode){case 0:this._togglePrevNext(i,true);break;case 1:this._togglePrevNext(i,false);break;case 2:case 3:this._togglePrevNexYearPicker();break;}};q.prototype._togglePrevNext=function(i,F){var G=this._oMaxDate.getYear();var I=this._oMinDate.getYear();var J=this._oMaxDate.getMonth();var N=this._oMinDate.getMonth();var O=this.getAggregation("header");var P=w.call(this);var Q=new e(i,this.getPrimaryCalendarType());if(this._iMode===1&&P>1){Q=t.call(this,i);Q.setMonth(Q.getMonth()+P-1);Q.setDate(a._daysInMonth(Q));}else{Q.setDate(a._daysInMonth(Q));}var S=Q.getYear();var T=Q.getMonth();if((this._iMode===0||this._iMode===1)&&P>1){T+=P-1;}if(S>G||(S===G&&(!F||T>=J))||((this._iMode===0||this._iMode===1)&&this._getSucessorsPickerPopup())){O.setEnabledNext(false);}else{O.setEnabledNext(true);}if(this._iMode===1&&P>1){Q.setMonth(Q.getMonth()-P+1,1);}else{Q.setDate(1);}S=Q.getYear();T=Q.getMonth();if(S<I||(S==I&&(!F||T<=N))||(this._iMode==1&&this._getSucessorsPickerPopup())){O.setEnabledPrevious(false);}else{O.setEnabledPrevious(true);}};q.prototype._togglePrevNexYearPicker=function(){var i=this.getAggregation("yearRangePicker"),F=this._getYearPicker(),P=this.getPrimaryCalendarType(),G=new e(this._oMinDate,P),I=new e(this._oMaxDate,P),J=this.getAggregation("header"),N=1,O,Q,S,T;if(this._iMode===3){S=i.getYears();N=i.getRangeSize();O=new e(i.getProperty("_middleDate"));Q=new e(O);O.setYear(O.getYear()-(N*S)/2);Q.setYear(Q.getYear()+(N*S)/2-1);}else{S=F.getYears();T=F.getProperty("_middleDate")?F.getProperty("_middleDate"):e.fromLocalJSDate(new Date());O=new e(T);Q=new e(T);O.setYear(O.getYear()-(S/2));Q.setYear(Q.getYear()+(S/2)-1);}J.setEnabledNext(Q.getYear()<I.getYear());J.setEnabledPrevious(O.getYear()>G.getYear());};q.prototype._handlePrevious=function(i){var F=this._getFocusedDate(),G=w.call(this),I,J,S=false;switch(this._iMode){case 0:if(G>1){I=e.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());I.setDate(1);this._setFocusedDate(I);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,false);this._addMonthFocusDelegate();break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var N=this._getSecondaryCalendarType();if(N){J=new e(F,N);J.setMonth(0,1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(J.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());var O=this._getMonthPicker();O._setYear(F.getYear());O.invalidate();this.setProperty("_currentPicker",r.MONTH_PICKER);break;case 2:this._getYearPicker().previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;case 3:this.getAggregation("yearRangePicker").previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;}};q.prototype._handleNext=function(i){var F=this._getFocusedDate(),G=w.call(this),I,J;switch(this._iMode){case 0:if(G>1){I=e.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());I.setMonth(I.getMonth(),1);this._setFocusedDate(I);F=this._getFocusedDate();}F.setMonth(F.getMonth()+1,1);this._renderMonth(false,false);this._addMonthFocusDelegate();break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){J=new e(F,S);J.setMonth(0,1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(J.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());var N=this._getMonthPicker();N._setYear(F.getYear());N.invalidate();this.setProperty("_currentPicker",r.MONTH_PICKER);break;case 2:this._getYearPicker().nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;case 3:this.getAggregation("yearRangePicker").nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;}};q.prototype._handleCurrentDate=function(){this.setProperty("_currentPicker",r.MONTH);this.focusDate(new Date());};q.prototype._getYearString=function(){var i=this._getYearPicker(),F=i.getDomRef(),G=this._getFocusedDate();if(i&&F&&F.style.display===""){G=i.getProperty("_middleDate");G.setDate(1);}return this._oYearFormat.format(U.getInstance(G.toUTCJSDate(),G.getCalendarType()),true);};q.prototype._getDisplayedMonths=function(F){var G=[];var I=F.getMonth();var J=w.call(this);if(J>1){for(var i=0;i<J;i++){G.push((I+i)%12);}}else{G.push(I);}return G;};q.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=e.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new e(F,S);var G=F.getMonth();var I=e.fromLocalJSDate(i[i.length-1].getDate(),P);I.setDate(a._daysInMonth(I));I=new e(I,S);var J=I.getMonth();return{start:G,end:J};};q.prototype._closePickers=function(){this.setProperty("_currentPicker",r.MONTH);this._togglePrevNext(this._getFocusedDate(),true);};q.prototype._setDisabledMonths=function(i,F){var G=0;var I=11;if(i===this._oMinDate.getYear()){G=this._oMinDate.getMonth();}if(i===this._oMaxDate.getYear()){I=this._oMaxDate.getMonth();}if(!F){F=this._getMonthPicker();}F.setMinMax(G,I);};q.prototype._handleFocus=function(i){var F=e.fromLocalJSDate(i.getParameter("date"),this.getPrimaryCalendarType()),O=i.getParameter("otherMonth"),G=i.getParameter("restoreOldDate");if(this.getIntervalSelection()){this.getAggregation("month").forEach(function(I){I.setProperty("_focusedDate",F);});}if(G){if(!m(this._getFocusedDate(),F)){this._renderMonth(false,true);}}else{this._focusDate(F,O,false,true);}};q.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};q.prototype._renderMonth=function(S,N){var F=this._getFocusedDate(),G=this.getAggregation("month"),I,J,O=t.call(this,new e(F,this.getPrimaryCalendarType())),i=0,P=G[0].checkDateFocusable(F.toLocalJSDate()),Q=!N&&!P;for(i=0;i<G.length;i++){I=G[i];J=new e(O,this.getPrimaryCalendarType());J.setMonth(O.getMonth()+i);if(!S&&a._isSameMonthAndYear(J,F)){I.setDate(F.toLocalJSDate());}else{I.displayDate(J.toLocalJSDate());}}this._updateHeader(O);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(Q){this.fireStartDateChange();}};q.prototype._updateMonthButtonVisibility=function(){var i=this._getActiveHeaderAggregation();if(this._bActionTriggeredFromSecondHeader){this._isTwoMonthsInOneColumn()?i.setVisibleButton1(!i.getVisibleButton1()):i._setVisibleButton3(!i._getVisibleButton3());}else{i.setVisibleButton1(false);}return this;};q.prototype._showMonthPicker=function(S){var i=this._getFocusedDate(),F=this._getMonthPicker(),G=new e(this._getFocusedDate());this._updateActiveHeaderYearButtonVisibility();this._updateMonthButtonVisibility();this.setProperty("_currentPicker",r.MONTH_PICKER);if(this._bActionTriggeredFromSecondHeader){G.setDate(1);G.setMonth(G.getMonth()+1);F._setYear(G.getYear());}else{F._setYear(i.getYear());}if(!S&&this._bActionTriggeredFromSecondHeader){F.setMonth(G.getMonth());this._setDisabledMonths(G.getYear(),F);}else if(!S){F.setMonth(i.getMonth());this._setDisabledMonths(i.getYear(),F);}this._togglePrevNext(i,true);this._setHeaderText(this._getFocusedDate());};q.prototype._showYearPicker=function(){var i=this._getFocusedDate(),F=this._getYearPicker();this.setProperty("_currentPicker",r.YEAR_PICKER);F.setDate(i.toLocalJSDate());this._togglePrevNexYearPicker();if(this._isTwoMonthsInOneColumn()){this._updateActiveHeaderYearButtonVisibility();}else{this._updateActiveHeaderYearButtonVisibility();}if(this._bActionTriggeredFromSecondHeader&&this.getAggregation("month")[1].getDate().getFullYear()>this._getFocusedDate().getYear()){var S=i.toLocalJSDate();S.setFullYear(S.getFullYear()+1);F.setDate(S);this._updateHeadersYearPrimaryText(this._getYearString());}else{F.setDate(i.toLocalJSDate());this._updateHeadersYearPrimaryText(this._getYearString());}};q.prototype._focusDate=function(F,O,N,G){var I,J=false,P=false,Q=this.getAggregation("month"),i;if(F.isBefore(this._oMinDate)){I=this._oMinDate;J=true;}else if(F.isAfter(this._oMaxDate)){I=this._oMaxDate;J=true;}else{I=F;}if(this._focusDateExtend){P=this._focusDateExtend(F,O,N);}this._setFocusedDate(I);if(G&&!this._focusDateExtend){for(i=0;i<Q.length;++i){if(Q[i].checkDateFocusable(I.toLocalJSDate())){Q[i].setDate(I.toLocalJSDate());return;}}}if(J||O){this._renderMonth(false,N);this._addMonthFocusDelegate();}if(P){this.fireStartDateChange();}};q.prototype._setHeaderText=function(i){var F=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var G=this._getLocaleData();var I=[];var J=[];var N=[];var O=[];var P;var Q=false;var T;var V;var W;var X;var Z;var $=this.getPrimaryCalendarType();var a1=this._getSecondaryCalendarType();var b1="";if(this._bLongMonth||!this._bNamesLengthChecked){I=G.getMonthsStandAlone("wide",$);}else{Q=true;I=G.getMonthsStandAlone("abbreviated",$);J=G.getMonthsStandAlone("wide",$);}if(a1){N=G.getMonthsStandAlone("abbreviated",a1);O=G.getMonthsStandAlone("wide",a1);var c1=this._getDisplayedSecondaryMonths($,a1);if(c1.start==c1.end){W=N[c1.start];b1=O[c1.start];}else{Z=G.getIntervalPattern();W=Z.replace(/\{0\}/,N[c1.start]).replace(/\{1\}/,N[c1.end]);b1=Z.replace(/\{0\}/,O[c1.start]).replace(/\{1\}/,O[c1.end]);}}F.setAdditionalTextButton1(W);F._setAdditionalTextButton3(W);S.setAdditionalTextButton1(W);var d1=this._getDisplayedMonths(i);this._sFirstMonthName=T=I[d1[0]];V=I[d1[d1.length-1]];if(d1.length>1&&!this._bShowOneMonth){if(!Z){Z=G.getIntervalPattern();}W=Z.replace(/\{0\}/,T).replace(/\{1\}/,V);P=J.length?Z.replace(/\{0\}/,J[d1[0]]).replace(/\{1\}/,J[d1[d1.length-1]]):W;if(this._isTwoMonthsInTwoColumns()||this._isTwoMonthsInOneColumn()){W=T;}}else{W=T;P=J[d1[0]]||W;}if(!this._getSucessorsPickerPopup()&&b1){P+=", "+b1;}F.setTextButton1(W);F.setAriaLabelButton1(P);F._setTextButton3(V);F._setAriaLabelButton3(V);S.setTextButton1(V);S.setAriaLabelButton1(V);var e1=new e(i,$);e1.setDate(1);X=this._oYearFormat.format(e1.toUTCJSDate(),true);if(e1.getMonth()===11){this._updateHeadersYearPrimaryText(X,(parseInt(X)+1).toString());}else{this._updateHeadersYearPrimaryText(X,X);}if(a1){e1=new e(e1,a1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(e1.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:W,sYear:X,sAriaLabel:P,bShort:Q};};q.prototype._handleButton1=function(i){if(this._iMode!=1){this._saveTriggeredHeader(i);this._showMonthPicker();}else{this.setProperty("_currentPicker",r.MONTH);this._addMonthFocusDelegate();}};q.prototype._addMonthFocusDelegate=function(){var F=this.getAggregation("month"),G=F[0].getDate(),I=this._getFocusedDate(),J={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(J);}},N,O;if(F.length>1&&N){G=e.fromLocalJSDate(N,this.getPrimaryCalendarType());}else if(F.length>1){G=t.call(this,this._getFocusedDate());}else{G=I;}for(var i=0;i<F.length;i++){N=new e(G);if(i>0){N.setMonth(N.getMonth()+i,1);}if(I.getYear()===N.getYear()&&I.getMonth()===N.getMonth()){O=this.getAggregation("month")[i];O.addDelegate(J,O);}}};q.prototype._handleButton2=function(i){if(this._iMode<=1){this._saveTriggeredHeader(i);this._showYearPicker();}else{this._showYearRangePicker();}};q.prototype._selectMonth=function(){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this._getMonthPicker(),G=i.getProperty("_focusedMonth"),I=(G||G===0)?G:i.getMonth(),S=i._iYear?new e(i._iYear,I-1,1):new e(this._getFocusedDate().getYear(),I-1,1);if(w.call(this)>1){if(this._bActionTriggeredFromSecondHeader&&S.getYear()>=a._minDate().getYear()){F.setYear(S.getYear());I=S.getMonth();}else if(F.getYear()===a._maxDate().getYear()&&I===11){I-=1;}}F.setMonth(I);if(I!=F.getMonth()){F.setDate(0);}this._focusDate(F,true,false,false);this._closePickers();this._addMonthFocusDelegate();};q.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};q.prototype._selectYear=function(){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType()),i=F.getMonth(),G=this._getYearPicker(),I=e.fromLocalJSDate(G.getDate(),this.getPrimaryCalendarType());if(!this._bActionTriggeredFromSecondHeader){I.setMonth(i,F.getDate());}else{I.setYear(i===11?I.getYear()-1:I.getYear());I.setMonth(i,F.getDate());}F=I;this._focusDate(F,true,false,false);this._togglePrevNext(this._getFocusedDate(),true);this.setProperty("_currentPicker",r.MONTH);this._addMonthFocusDelegate();this._setHeaderText(this._getFocusedDate());};q.prototype.setProperty=function(){var P=arguments[0],i=arguments[1];C.prototype.setProperty.apply(this,arguments);if(P==="_currentPicker"){switch(i){case"month":this._iMode=0;break;case"monthPicker":this._iMode=1;break;case"yearPicker":this._iMode=2;break;case"yearRangePicker":this._iMode=3;break;default:return;}}return this;};q.prototype._selectYearRange=function(){var i=this.getAggregation("yearRangePicker"),F=this.getAggregation("header"),G=i.getRangeSize(),P=this.getPrimaryCalendarType(),S=e.fromLocalJSDate(i.getDate(),P),I=new e(S.getYear()+G-1,0,1,P),J=this._getFocusedDate(),N,O;J.setYear(S.getYear()+G/2);S.setMonth(0,1);this._setFocusedDate(J);this._showYearPicker();N=this._oYearFormat.format(U.getInstance(S.toUTCJSDate(),S.getCalendarType()),true);O=this._oYearFormat.format(U.getInstance(I.toUTCJSDate(),I.getCalendarType()),true);F.setTextButton2(N+" - "+O);F._setTextButton4(N+" - "+O);};q.prototype._showYearRangePicker=function(){var i=this.getAggregation("yearRangePicker"),F=this._getYearPicker(),G=e.fromLocalJSDate(F.getFirstRenderedDate(),this.getPrimaryCalendarType());this.setProperty("_currentPicker",r.YEAR_RANGE_PICKER);G.setYear(G.getYear()+Math.floor(i.getRangeSize()/2));i.setDate(G.toLocalJSDate());this._togglePrevNexYearPicker();};q.prototype._setColumns=function(i){this._iColumns=i;return this;};q.prototype._getColumns=function(){return this._iColumns;};q.prototype._updateActiveHeaderYearButtonVisibility=function(){var i=this._getActiveHeaderAggregation();if(this._bActionTriggeredFromSecondHeader){this._isTwoMonthsInOneColumn()?i.setVisibleButton1(!i.getVisibleButton1()):i._setVisibleButton3(!i._getVisibleButton3());}else{i.setVisibleButton1(!i.getVisibleButton1());}return this;};q.prototype._updateHeadersButtonsHelper=function(i,F,G,I){var J=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");J.setVisibleButton1(i);J.setVisibleButton2(F);J._setVisibleButton3(G);J._setVisibleButton4(I);if(S.getVisible()){S.setVisibleButton1(i);S.setVisibleButton2(F);S._setVisibleButton3(G);S._setVisibleButton4(I);}};q.prototype._updateHeadersButtons=function(){var S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else{this._updateHeadersButtonsHelper(true,true,false,false);}}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);if(this._iMode===2){this._bActionTriggeredFromSecondHeader?this._updateHeadersButtonsHelper(true,true,false,true):this._updateHeadersButtonsHelper(false,true,true,true);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else if(this._iMode===1){this._bActionTriggeredFromSecondHeader?this._updateHeadersButtonsHelper(true,true,false,true):this._updateHeadersButtonsHelper(false,true,true,true);}else{this._updateHeadersButtonsHelper(true,true,true,true);}}else{S.setVisible(false);if(this._iMode===1){this._updateHeadersButtonsHelper(false,true,false,false);}else if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else{this._updateHeadersButtonsHelper(true,true,false,false);}}if(this._getSucessorsPickerPopup()){this.getAggregation("header").setVisibleButton2(false);}};q.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};q.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){if(o.getConfiguration().getLocale().getLanguage().toLowerCase()==="ja"||o.getConfiguration().getLocale().getLanguage().toLowerCase()==="zh"){this.addStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}else{this.addStyleClass("sapUiCalTwoMonthsTwoColumns");this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}};q.prototype._isTwoMonthsInOneColumn=function(){var i=w.call(this);return this._getColumns()===1&&i===2;};q.prototype._isTwoMonthsInTwoColumns=function(){var i=w.call(this);return this._getColumns()===2&&i===2;};q.prototype._updateHeadersYearPrimaryText=function(F,S){var i=this._getYearPicker(),G=this.getAggregation("header"),I=this.getAggregation("secondMonthHeader"),J=F,N=S||F,P=this.getPrimaryCalendarType();if(this._iMode===2&&i){var O=i.getProperty("_middleDate")?i.getProperty("_middleDate"):i._getDate(),Q=new e(O,P),T,V,W;Q.setDate(1);Q.setYear(Q.getYear()-Math.floor(i.getYears()/2));Q=i._checkFirstDate(Q);T=new e(Q,P);T.setYear(T.getYear()+i.getYears()-1);V=this._oYearFormat.format(U.getInstance(Q.toUTCJSDate(),Q.getCalendarType()),true);W=this._oYearFormat.format(U.getInstance(T.toUTCJSDate(),T.getCalendarType()),true);if(this._bActionTriggeredFromSecondHeader){N=V+" - "+W;}else{J=V+" - "+W;}}G._setTextButton4(N);G._setAriaLabelButton4(N);I.setTextButton2(N);G.setTextButton2(J);};q.prototype._updateHeadersYearAdditionalText=function(i){var F=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");F.setAdditionalTextButton2(i);F._setAdditionalTextButton4(i);S.setAdditionalTextButton2(i);};q.prototype._adjustYearRangeDisplay=function(){var i=this.getAggregation("yearRangePicker");if(!this._getSucessorsPickerPopup()){switch(this.getPrimaryCalendarType()){case p.Japanese:i.setColumns(1);i.setYears(4);break;case p.Gregorian:i.setColumns(3);i.setYears(9);break;default:i.setColumns(2);i.setYears(8);}}};q.prototype._getSpecialDates=function(){var P=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin._getSpecialDates();}if(P&&P._getSpecialDates){return P._getSpecialDates();}else{var F=this.getSpecialDates();for(var i=0;i<F.length;i++){var N=F[i].getSecondaryType()===l.CalendarDayType.NonWorking&&F[i].getType()!==l.CalendarDayType.NonWorking;if(N){var G=new b();G.setType(F[i].getSecondaryType());G.setStartDate(F[i].getStartDate());if(F[i].getEndDate()){G.setEndDate(F[i].getEndDate());}F.push(G);}}return F;}};function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=e.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=e.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new e(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new e(this._oMaxDate,i);}}function s(F){var W=F.size.width;if(W<=0){return;}if(W===this._iPrevWidth){return;}this._iPrevWidth=W;var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var G=w.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(G<this._getColumns()){this._setColumns(G);}if(this._getColumns()>2&&G>this._getColumns()){var I=this._getColumns();var J=0.0;var N=this._getColumns();while(I>=2){var P=G%I;if(P==0){N=I;break;}else{var Q=P/I;if(Q>J){J=Q;N=I;}}I--;}this._setColumns(N);}var S;var T=this.getAggregation("month");if(this._getColumns()>1){S=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{S="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<T.length;i++){var V=T[i];V.setWidth(S);}this.invalidate();}this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}function t(i){var F=new e(i,this.getPrimaryCalendarType());F.setDate(1);var G=w.call(this);if(G<=12){var I=i.getMonth();if(12%G>0&&I+G>11){I=12-G;}F.setMonth(I);}return F;}function u(){var i,F,G;if(!this._bNamesLengthChecked){i=this._getMonthPicker();this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;this.setProperty("_currentPicker",r.MONTH);if(!this._bLongMonth){F=this.getAggregation("month");G;if(F.length>1){G=e.fromLocalJSDate(F[0].getDate(),this.getPrimaryCalendarType());}else{G=this._getFocusedDate();}this._setHeaderText(G);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}}function v(i,S){var F,G;if(!i){return;}F=e.fromLocalJSDate(i,this.getPrimaryCalendarType());G=F.getYear();a._checkYearInValidRange(G);if(a._isOutside(F,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(F);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,true);}}function w(){if(f.system.phone){return 1;}else{return this.getMonths();}}function x(i){this.fireEvent("_renderMonth",{days:i.getParameter("days")});}function y(i){this._oSelectedMonth=i.oSource;this.fireSelect();}function z(F){var G,I,i;if(w.call(this)>1){G=this.getAggregation("month");for(i=0;i<G.length;i++){I=G[i];if(I.getId()!=F.oSource.getId()){I._bindMousemove();}}}}function A(F){var G,I,i;if(w.call(this)>1){G=this.getAggregation("month");for(i=0;i<G.length;i++){I=G[i];if(I.getId()!=F.oSource.getId()){I._unbindMousemove();}}}}function B(i){var O=i.getParameter("offset");if(O>0){this._handleNext(i);}if(O<0){this._handlePrevious(i);}}function E(){this._updateHeadersYearPrimaryText(this._getYearString());}return q;});
