/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/checkMouseEnterOrLeave","sap/ui/thirdparty/jquery","sap/ui/unified/CalendarAppointment"],function(C,D,L,a,U,l,I,b,R,c,d,e,f,q,g){"use strict";var h=l.CalendarDayType;var m=l.CalendarAppointmentVisualization;var G=l.GroupAppointmentsMode;var n=l.CalendarIntervalType;var o=l.CalendarAppointmentHeight;var r=l.CalendarAppointmentRoundWidth;var s=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalSize:{type:"int",group:"Appearance",defaultValue:1},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:n.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:m.Standard},appointmentHeight:{type:"sap.ui.unified.CalendarAppointmentHeight",group:"Appearance",defaultValue:o.Regular},appointmentRoundWidth:{type:"sap.ui.unified.CalendarAppointmentRoundWidth",group:"Appearance",defaultValue:r.None}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});s.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAria=b.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+u.call(this).getTimePattern("medium")});this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined;};s.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._fnCustomSortedAppointments=undefined;};s.prototype.onBeforeRendering=function(){this._aVisibleAppointments=[];v.call(this);y.call(this);E.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(!this.getAppointments().length){this.aSelectedAppointments=[];}else{this.getAppointments().forEach(function(i){this._updateSelectedAppointmentsArray(i);}.bind(this));}};s.prototype.onAfterRendering=function(){F.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}};s.prototype.onThemeChanged=function(j){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var k=this._aVisibleAppointments[i];k.level=-1;}this.handleResize(j);}};s.prototype.invalidate=function(j){if(j&&j instanceof g){var k=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==j){k=true;break;}}if(k){this._aVisibleAppointments=[];}this._updateSelectedAppointmentsArray(j);}C.prototype.invalidate.apply(this,arguments);};s.prototype.setStartDate=function(i){if(!i){i=new Date();}a._checkJSDateObject(i);var Y=i.getFullYear();a._checkYearInValidRange(Y);this._oUTCStartDate=a._createUniversalUTCDate(i,undefined,true);this.setProperty("startDate",i);return this;};s.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};s.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};s.prototype._getAppointmentReducedHeight=function(i){var j=!D.system.phone&&this.getAppointmentsReducedHeight()&&i.size===o.Regular;return j;};s.prototype.onfocusin=function(j){if(q(j.target).hasClass("sapUiCalendarApp")){N.call(this,j.target.id);}else{var V=this._getVisibleAppointments();var k=false;var p;for(var i=0;i<V.length;i++){p=V[i].appointment;if(e(p.getDomRef(),j.target)){k=true;p.focus();break;}}if(!k){p=this.getFocusedAppointment();if(p){p.focus();}}}};s.prototype.applyFocusInfo=function(i){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};s.prototype.onsapleft=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){O.call(this,this._bRTL,1);}i.preventDefault();i.stopPropagation();};s.prototype.onsapright=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){O.call(this,!this._bRTL,1);}i.preventDefault();i.stopPropagation();};s.prototype.onsapup=function(i){this.fireLeaveRow({type:i.type});};s.prototype.onsapdown=function(i){this.fireLeaveRow({type:i.type});};s.prototype.onsaphome=function(i){P.call(this,i);i.preventDefault();i.stopPropagation();};s.prototype.onsapend=function(i){P.call(this,i);i.preventDefault();i.stopPropagation();};s.prototype.onsapselect=function(j){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var k=V[i].appointment;if(e(k.getDomRef(),j.target)){H.call(this,k,!(j.ctrlKey||j.metaKey));break;}}j.stopPropagation();j.preventDefault();};s.prototype.ontap=function(i){var j=this.$("Apps").children(".sapUiCalendarRowAppsInt");var k=0;var p=false;for(k=0;k<j.length;k++){var T=j[k];if(!this._isOneMonthsRowOnSmallSizes()&&e(T,i.target)){p=true;break;}}if(p){Q.call(this,k,i.target);}else{this.onsapselect(i);}};s.prototype.onsapselectmodifiers=function(i){this.onsapselect(i);};s.prototype.handleResize=function(i){if(i&&i.size&&i.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");F.call(this);return this;};s.prototype.updateCurrentTimeVisualization=function(){var $=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var j=this.getIntervals();var k=this.getIntervalType();var p=this._getStartDate();var T=p.getTime();var V=this._oUTCEndDate;var W=V.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=W&&i.getTime()>=T){var X=A.call(this,k,j,p,V,T,i);var Y=0;if(this._bRTL){$.css("right",X+"%");}else{$.css("left",X+"%");}$.css("display","");if(this.getUpdateCurrentTime()){switch(k){case n.Hour:Y=60000;break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":Y=1800000;break;default:Y=-1;break;}if(Y>0){this._sUpdateCurrentTime=setTimeout(this.updateCurrentTimeVisualization.bind(this),Y);}}}else{$.css("display","none");}return this;};s.prototype.getFocusedAppointment=function(){var j=this._getAppointmentsSorted();var k=this.getAggregation("groupAppointments",[]);var p;var i=0;for(i=0;i<k.length;i++){if(k[i].getId()==this._sFocusedAppointmentId){p=k[i];break;}}if(!p){for(i=0;i<j.length;i++){if(j[i].getId()==this._sFocusedAppointmentId){p=j[i];break;}}}return p;};s.prototype.focusAppointment=function(i){if(!i||!(i instanceof g)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var j=i.getId();if(this._sFocusedAppointmentId!=j){N.call(this,j);}else{i.focus();}return this;};s.prototype.focusNearestAppointment=function(j){a._checkJSDateObject(j);var k=this._getAppointmentsSorted();var p;var T;var V;for(var i=0;i<k.length;i++){p=k[i];if(p.getStartDate()>j){if(i>0){T=k[i-1];}else{T=p;}break;}}if(p){if(T&&Math.abs(p.getStartDate()-j)>=Math.abs(T.getStartDate()-j)){V=T;}else{V=p;}this.focusAppointment(V);}return this;};s.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};s.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};s.prototype._getNonWorkingDays=function(){if(this.getIntervalSize()!==1){return[];}var j=this.getNonWorkingDays();if(!j){var k=u.call(this);var W=k.getWeekendStart();var p=k.getWeekendEnd();j=[];for(var i=0;i<=6;i++){if((W<=p&&i>=W&&i<=p)||(W>p&&(i>=W||i<=p))){j.push(i);}}}else if(!Array.isArray(j)){j=[];}return j;};s.prototype._isOneMonthsRowOnSmallSizes=function(){return(this.getIntervalType()===n.OneMonth||this.getIntervalType()==="OneMonth")&&this.getIntervals()===1;};s.prototype._getAppointmentsSorted=function(){var i=this.getAppointments(),j=S;i.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:j);return i;};s.prototype._setCustomAppointmentsSorterCallback=function(i){this._fnCustomSortedAppointments=i;this.invalidate();};s.prototype._calculateAppoitnmentVisualCue=function(i){if(_(this,i)){return{appTimeUnitsDifRowStart:0,appTimeUnitsDifRowEnd:0};}var j=i.getStartDate(),k=i.getEndDate(),p=new U(j.getFullYear(),j.getMonth(),j.getDate(),j.getHours(),j.getMinutes()),T=new U(k.getFullYear(),k.getMonth(),k.getDate(),k.getHours(),k.getMinutes()),V=this.getIntervalType(),W=this.getStartDate(),X=V==="Hour"?new U(W.getFullYear(),W.getMonth(),W.getDate(),W.getHours()):new U(W.getFullYear(),W.getMonth(),W.getDate()),Y=this.getIntervals(),Z;switch(V){case"Hour":Z=new U(W.getFullYear(),W.getMonth(),W.getDate(),W.getHours()+Y);break;case"Day":case"Week":case"One Month":Z=new U(W.getFullYear(),W.getMonth(),W.getDate()+Y);break;case"Month":Z=new U(W.getFullYear(),W.getMonth()+Y,W.getDate());break;default:break;}return{appTimeUnitsDifRowStart:X.getTime()-p.getTime(),appTimeUnitsDifRowEnd:T.getTime()-Z.getTime()};};s.prototype._updateSelectedAppointmentsArray=function(i){if(i.getSelected()){if(this.aSelectedAppointments.indexOf(i.getId())===-1){this.aSelectedAppointments.push(i.getId());}}else{this.aSelectedAppointments=this.aSelectedAppointments.filter(function(j){return j!==i.getId();});}};function _(j,k){var p=j.getAggregation("groupAppointments",[]);var i;for(i=0;i<p.length;++i){if(k===p[i]){return true;}}return false;}function t(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}function u(){if(!this._oLocaleData){var i=t.call(this);var j=new c(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}function v(){var i=this.getStartDate();var j;var k=this.getIntervals();var p=this.getIntervalType();this._oUTCStartDate=w.call(this,i);switch(p){case n.Hour:j=new U(this._oUTCStartDate.getTime());j.setUTCHours(j.getUTCHours()+k);break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":j=new U(this._oUTCStartDate.getTime());j.setUTCDate(j.getUTCDate()+k*this.getIntervalSize());break;case n.Month:j=new U(this._oUTCStartDate.getTime());j.setUTCMonth(j.getUTCMonth()+k);break;default:throw new Error("Unknown IntervalType: "+p+"; "+this);}j.setUTCMilliseconds(-1);this._iRowSize=j.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/k);this._oUTCEndDate=j;}function w(i){var j=this.getIntervalType();var k=a._createUniversalUTCDate(i,undefined,true);switch(j){case n.Hour:k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case n.Month:k.setUTCDate(1);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+j+"; "+this);}return k;}function x(){return D.system.phone||(this.getGroupAppointmentsMode()===G.Collapsed);}function y(){var p=this._getAppointmentsSorted();var T;var V;var W;var X=this.getIntervals();var Y=this.getIntervalType();var Z=this._getStartDate();var $=Z.getTime();var a1=this._oUTCEndDate;var b1=a1.getTime();var c1=[];var d1=false;var i=0;var j=0;var e1=x.call(this);var f1=this._needAppointmentHorizontalFit();this.destroyAggregation("groupAppointments",true);for(i=0;i<p.length;i++){T=p[i];var g1=a._createUniversalUTCDate(T.getStartDate(),undefined,true);var h1=g1.getTime();g1.setUTCSeconds(0);g1.setUTCMilliseconds(0);var i1=T.getEndDate()?a._createUniversalUTCDate(T.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);var j1=i1.getTime();i1.setUTCSeconds(0);i1.setUTCMilliseconds(0);var k1=false;if(g1.getTime()<$&&i1.getTime()>=$){g1=new U($);k1=true;}if(i1.getTime()>b1&&g1.getTime()<=b1){i1=new U(b1);k1=true;}var l1=(i1.getTime()-g1.getTime())/60000;if(k1&&l1==0){continue;}var m1=0;var n1=0;var o1=-1;V=undefined;W=undefined;if(g1&&g1.getTime()<=b1&&i1&&i1.getTime()>=$&&h1<=j1){if(e1&&(Y==n.Month)&&((i1.getTime()-g1.getTime())<604800000)){V=z.call(this,g1,T,Y,X,Z,a1,$,c1);var p1=a._createUniversalUTCDate(V.getEndDate(),undefined,true);if(i1.getTime()>p1.getTime()){W=z.call(this,i1,T,Y,X,Z,a1,$,c1);}}if(f1){this._setHorizontalRoundingWidth(T,g1,i1);}m1=A.call(this,Y,X,Z,a1,$,g1);n1=B.call(this,Y,X,Z,a1,$,i1);if(V){V._iBegin=m1;V._iEnd=n1;V._iLevel=o1;if(W){W._iBegin=m1;W._iEnd=n1;W._iLevel=o1;}continue;}c1.push({appointment:T,begin:m1,end:n1,calculatedEnd:n1,level:o1,size:this.getProperty("appointmentHeight")});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==T.getId()){d1=true;}}}var q1=this.getAggregation("groupAppointments",[]);if(q1.length>0){for(i=0;i<c1.length;i++){T=c1[i];if(T.appointment._aAppointments&&T.appointment._aAppointments.length<=1){V=T.appointment;var r1=false;if(V._aAppointments.length==0){r1=true;}else{for(j=0;j<c1.length;j++){if(c1[j].appointment==V._aAppointments[0]){r1=true;break;}}}if(!r1){for(j=0;j<q1.length;j++){W=q1[j];if(V!=W){for(var k=0;k<W._aAppointments.length;k++){if(V._aAppointments[0]==W._aAppointments[k]){W._aAppointments.splice(k,1);if(W._aAppointments.length==1){this.removeAggregation("groupAppointments",W);W.destroy();q1=this.getAggregation("groupAppointments",[]);}else{W.setProperty("title",W._aAppointments.length,true);}break;}}}}T.begin=V._iBegin;T.end=V._iEnd;T.calculatedEnd=V._iEnd;T.level=V._iLevel;T.appointment=V._aAppointments[0];}else{c1.splice(i,1);i--;}this.removeAggregation("groupAppointments",V);V.destroy();q1=this.getAggregation("groupAppointments",[]);}}}if(!d1){if(c1.length>0){this._sFocusedAppointmentId=c1[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=c1;return this._aVisibleAppointments;}function z(i,k,p,T,V,W,X,Y){var Z=this.getAggregation("groupAppointments",[]);var $;var a1=u.call(this);var b1=a1.getFirstDayOfWeek();var c1=i.getUTCDay();var d1=new U(i.getTime());d1.setUTCHours(0);d1.setUTCMinutes(0);d1.setUTCSeconds(0);d1.setUTCMilliseconds(0);if(b1<=c1){d1.setDate(d1.getDate()-(c1-b1));}else{d1.setDate(d1.getDate()-(7-c1-b1));}for(var j=0;j<Z.length;j++){$=Z[j];var e1=a._createUniversalUTCDate($.getStartDate(),undefined,true);if(e1.getTime()==d1.getTime()){break;}$=undefined;}if(!$){var f1=new U(d1.getTime());f1.setDate(f1.getDate()+7);f1.setMilliseconds(-1);$=new g(this.getId()+"-Group"+Z.length,{type:k.getType(),startDate:a._createLocalDate(new Date(d1.getTime()),true),endDate:a._createLocalDate(new Date(f1.getTime()),true)});$._aAppointments=[];this.addAggregation("groupAppointments",$,true);var g1=A.call(this,p,T,V,W,X,d1);var h1=B.call(this,p,T,V,W,X,f1);Y.push({appointment:$,begin:g1,end:h1,calculatedEnd:h1,level:-1,size:this.getProperty("appointmentHeight")});}$._aAppointments.push(k);if($.getType()!=h.None&&$.getType()!=k.getType()){$.setType(h.None);}$.setProperty("title",$._aAppointments.length,true);return $;}function A(i,j,k,p,T,V){var W=0;if(i!=n.Month){W=100*(V.getTime()-T)/this._iRowSize;}else{var X=new U(V.getTime());X.setUTCDate(1);X.setUTCHours(0);X.setUTCMinutes(0);X.setUTCSeconds(0);X.setUTCMilliseconds(0);var Y=new U(X.getTime());Y.setUTCMonth(Y.getUTCMonth()+1);Y.setMilliseconds(-1);var Z=Y.getTime()-X.getTime();var $=(X.getUTCFullYear()-k.getUTCFullYear())*12+X.getUTCMonth()-k.getUTCMonth();W=(100*$/j)+(100*(V.getTime()-X.getTime())/Z)/j;}if(W<0){W=0;}W=Math.round(W*100000)/100000;return W;}function B(i,j,k,p,T,V){var W=0;if(i!=n.Month){W=100-(100*(V.getTime()-T)/this._iRowSize);}else{var X=new U(V.getTime());X.setUTCDate(1);X.setUTCHours(0);X.setUTCMinutes(0);X.setUTCSeconds(0);X.setUTCMilliseconds(0);var Y=new U(X.getTime());Y.setUTCMonth(Y.getUTCMonth()+1);Y.setMilliseconds(-1);var Z=Y.getTime()-X.getTime();var $=(X.getUTCFullYear()-k.getUTCFullYear())*12+X.getUTCMonth()-k.getUTCMonth();W=100-((100*$/j)+(100*(V.getTime()-X.getTime())/Z)/j);}if(W<0){W=0;}W=Math.round(W*100000)/100000;return W;}function E(){var V=[];if(this.getShowIntervalHeaders()){var k=this.getIntervalHeaders();var p;var T=this.getIntervals();var W=this.getIntervalType();var X=this._getStartDate();var Y=X.getTime();var Z=this._oUTCEndDate;var $=Z.getTime();var i=0;var j=0;for(i=0;i<k.length;i++){p=k[i];var a1=a._createUniversalUTCDate(p.getStartDate(),undefined,true);a1.setUTCSeconds(0);a1.setUTCMilliseconds(0);var b1=p.getEndDate()?a._createUniversalUTCDate(p.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);b1.setUTCSeconds(0);b1.setUTCMilliseconds(0);if(a1&&a1.getTime()<=$&&b1&&b1.getTime()>=Y){var c1=new U(X.getTime());var d1=new U(X.getTime());d1.setUTCMinutes(d1.getUTCMinutes()-1);var e1=-1;var f1=-1;for(j=0;j<T;j++){switch(W){case n.Hour:d1.setUTCHours(d1.getUTCHours()+1);if(j>0){c1.setUTCHours(c1.getUTCHours()+1);}break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":d1.setUTCDate(d1.getUTCDate()+1);if(j>0){c1.setUTCDate(c1.getUTCDate()+1);}break;case n.Month:d1.setUTCDate(1);d1.setUTCMonth(d1.getUTCMonth()+2);d1.setUTCDate(0);if(j>0){c1.setUTCMonth(c1.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+W+"; "+this);}if(a1&&a1.getTime()<=c1.getTime()&&b1&&b1.getTime()>=d1.getTime()){if(e1<0){e1=j;}f1=j;}}if(e1>=0){V.push({interval:e1,appointment:p,last:f1});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}function F(){if(this._isOneMonthsRowOnSmallSizes()){return;}var $=this.$("Apps");var k=$.innerWidth();if(k<=0){return;}var p=this.$("DummyApp");var T=p.outerHeight(true);if(T<=0){return;}var V=4;var W=p.outerWidth();var X=W/k*100;var Y=Math.ceil(1000*X)/1000;var Z;var a1;var b1=0;var c1=0;var i=0;var d1=false;var e1;var f1=this._needAppointmentHorizontalFit();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){b1=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);d1=true;}for(i=0;i<this._aVisibleAppointments.length;i++){Z=this._aVisibleAppointments[i];a1=Z.appointment.$();var g1=Math.floor(1000*(100-Z.calculatedEnd-Z.begin))/1000;var h1=false;if(g1<Y){Z.end=100-Z.begin-X;if(Z.end<0){Z.end=0;}h1=true;a1.addClass("sapUiCalendarAppSmall");}else if(a1.hasClass("sapUiCalendarAppSmall")){Z.end=Z.calculatedEnd;h1=true;a1.removeClass("sapUiCalendarAppSmall");}if(h1){Z.level=-1;}if(h1&&!f1){if(this._bRTL){a1.css("left",Z.end+"%");}else{a1.css("right",Z.end+"%");}}if(f1){Z.end=Z.calculatedEnd;}}for(i=0;i<this._aVisibleAppointments.length;i++){Z=this._aVisibleAppointments[i];a1=Z.appointment.$();var i1={};if(Z.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var j1=this._aVisibleAppointments[j];if(Z!=j1&&Z.begin<(Math.floor(1000*(100-j1.end))/1000)&&(Math.floor(1000*(100-Z.end))/1000)>j1.begin&&j1.level>=0){this._setBlockedLevelsForAppointment(j1,i1);}}Z.level=this._getAppointmetLevel(i1,Z);a1.attr("data-sap-level",Z.level);}e1=T*Z.level+b1;if(!d1){e1+=V;}a1.css("top",e1+"px");var k1=Z.level;k1+=this._getAppointmentRowCount(Z)-1;if(c1<k1){c1=k1;}}c1++;T=T*c1+b1;if(!d1){T+=V;}if(!this.getHeight()){$.outerHeight(T);}else{var l1=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<l1.length;i++){var m1=q(l1[i]);m1.outerHeight(T);}}p.css("display","none");}function H(j,k){var i=0;var p;var T;var V;var W;var X=I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");var Y=!j.getSelected();if(k){var Z=this.getAppointments();var $=this.getAggregation("groupAppointments",[]);q.merge(Z,$);for(i=0;i<Z.length;i++){p=Z[i];if(p.getId()!==j.getId()&&p.getSelected()){p.setProperty("selected",false,true);p.$().removeClass("sapUiCalendarAppSel");for(var i=0;i<this.aSelectedAppointments.length;i++){if(this.aSelectedAppointments[i]!==p.getId()){this.aSelectedAppointments.splice(i);}}T=p.$().attr("aria-labelledby");V=T?T.replace(X,""):"";p.$().attr("aria-labelledby",V);}}}W=j.$().attr("aria-labelledby")+" "+X;V=j.$().attr("aria-labelledby").replace(X,"").trim();if(j.getSelected()){j.setProperty("selected",false,true);j.$().removeClass("sapUiCalendarAppSel");j.$().attr("aria-labelledby",V);K(this,k);}else{j.setProperty("selected",true,true);j.$().addClass("sapUiCalendarAppSel");j.$().attr("aria-labelledby",W);K(this,k);}this._updateSelectedAppointmentsArray(j);if(j._aAppointments){for(i=0;i<j._aAppointments.length;i++){p=j._aAppointments[i];p.setProperty("selected",Y,true);W=p.$().attr("aria-labelledby")+" "+X;p.$().attr("aria-labelledby",W);}this.fireSelect({appointments:j._aAppointments,multiSelect:!k,domRefId:j.getId()});}else{this.fireSelect({appointment:j,multiSelect:!k,domRefId:j.getId()});}}function J(i){var p=this._getPlanningCalendar();if(p){p["_onRow"+i]();}}s.prototype._needAppointmentHorizontalFit=function(){var p=this._getPlanningCalendar(),k,V,i;if(!p||this.getAppointmentRoundWidth()===r.None){return false;}k=p.getViewKey();V=p._getView(k);i=p._getIntervals(V);return i>=20;};s.prototype._setHorizontalRoundingWidth=function(i,j,k){var p;switch(this.getAppointmentRoundWidth()){case r.HalfColumn:p=12;break;}this._roundAppointment(i,j,k,p);};s.prototype._roundAppointment=function(i,j,k,p){var T,V;T=i.getStartDate().getHours()-i.getStartDate().getHours()%p;j.setUTCHours(T);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);V=i.getEndDate().getHours()-i.getEndDate().getHours()%p+p;k.setUTCHours(V);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);};s.prototype._setBlockedLevelsForAppointment=function(V,i){var j=this._getAppointmentRowCount(V);for(var k=0;k<j;k++){i[V.level+k]=true;}return i;};s.prototype._getAppointmentRowCount=function(V){var i,j=this._getAppointmentReducedHeight(V);switch(V.size){case o.HalfSize:i=1;break;case o.Regular:i=2;if(j&&!V.appointment.getText()&&!V.appointment.getDescription()){i=1;}break;case o.Large:i=3;break;case o.Automatic:i=1;if(V.appointment.getText()){i+=1;}if(V.appointment.getDescription()){i+=1;}break;}return i;};s.prototype._getAppointmetLevel=function(i,j){var k=0;var p=this._getAppointmentRowCount(j);var T=true;while(T){T=this._isPosibleToPositionAppointment(k,i,p);if(!T){T=true;k+=1;}else{T=false;}}return k;};s.prototype._isPosibleToPositionAppointment=function(i,j,k){for(var p=i;p<k+i;p++){if(j[p]){return false;}}return true;};s.prototype._getPlanningCalendar=function(){var p=this;while(p.getParent()!==null){if(p.isA("sap.m.PlanningCalendar")){return p;}p=p.getParent();}};function K(i,j){if(j){J.call(i,"DeselectAppointment");}}function M(k){var p=this.getAggregation("groupAppointments",[]);var T;var V=false;for(var i=0;i<p.length;i++){var W=p[i]._aAppointments;for(var j=0;j<W.length;j++){if(W[j].getId()==k){T=p[i];V=true;break;}}if(V){break;}}return T;}function N(j){if(this._sFocusedAppointmentId!=j){var k=this._getAppointmentsSorted();var V=this._aVisibleAppointments;var p;var i=0;p=M.call(this,j);if(p){j=p.getId();p=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==j){p=V[i].appointment;break;}}if(p){var $=this.getFocusedAppointment().$();var T=p.$();this._sFocusedAppointmentId=p.getId();$.attr("tabindex","-1");T.attr("tabindex","0");T.trigger("focus");}else{for(i=0;i<k.length;i++){if(k[i].getId()==j){p=k[i];break;}}if(p){this._sFocusedAppointmentId=p.getId();var W=w.call(this,p.getStartDate());this.setStartDate(a._createLocalDate(W,true));if(!e(this.getDomRef(),document.activeElement)){setTimeout(function(){this.getFocusedAppointment().focus();}.bind(this),0);}this.fireStartDateChange();}}}}function O(j,k){var p=this._sFocusedAppointmentId;var T=this._getAppointmentsSorted();var V=this.getAggregation("groupAppointments",[]);var W;var X=0;var i=0;for(i=0;i<V.length;i++){if(V[i].getId()==p){var Y=V[i]._aAppointments;if(j){p=Y[Y.length-1].getId();}else{p=Y[0].getId();}break;}}for(i=0;i<T.length;i++){if(T[i].getId()==p){X=i;break;}}if(j){X=X+k;}else{X=X-k;}if(X<0){X=0;}else if(X>=T.length){X=T.length-1;}W=T[X];N.call(this,W.getId());}function P(j){var k=this._getAppointmentsSorted();var p;var T=new U(this._getStartDate());var V=new U(this._oUTCEndDate);var W=this.getIntervalType();var X;var Y;T.setUTCHours(0);V.setUTCHours(0);V.setUTCMinutes(0);V.setUTCSeconds(0);switch(W){case n.Hour:V.setUTCDate(V.getUTCDate()+1);V.setUTCMilliseconds(-1);break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":T.setUTCDate(1);V.setUTCMonth(V.getUTCMonth()+1);V.setUTCDate(1);V.setUTCMilliseconds(-1);break;case n.Month:T.setUTCMonth(0);T.setUTCDate(1);V.setUTCFullYear(V.getUTCFullYear()+1);V.setUTCMonth(1);V.setUTCDate(1);V.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+W+"; "+this);}var Z=a._createLocalDate(T,true);var $=a._createLocalDate(V,true);for(var i=0;i<k.length;i++){if(k[i].getStartDate()>=Z&&k[i].getStartDate()<=$){p=k[i];X=p.getId();if(j.type=="saphome"){break;}}else if(k[i].getStartDate()>$){break;}}Y=M.call(this,X);if(Y){p=Y;X=p.getId();}if(X&&X!=this._sFocusedAppointmentId){N.call(this,X);}else if(j._bPlanningCalendar&&p){p.focus();}else{this.fireLeaveRow({type:j.type});}}function Q(i,j){var k=this.getIntervalType();var p=this._getStartDate();var T=new U(p.getTime());var V;var W=false;var X=0;var Y=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){W=true;var Z=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");Y=Z.length;for(X=0;X<Y;X++){var $=Z[X];if($==j){break;}}}switch(k){case n.Hour:T.setUTCHours(T.getUTCHours()+i);if(W){T.setUTCMinutes(T.getUTCMinutes()+X*60/Y);V=new U(T.getTime());V.setUTCMinutes(V.getUTCMinutes()+60/Y);}else{V=new U(T.getTime());V.setUTCHours(V.getUTCHours()+1);}break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":T.setUTCDate(T.getUTCDate()+i);if(W){T.setUTCHours(T.getUTCHours()+X*24/Y);V=new U(T.getTime());V.setUTCHours(V.getUTCHours()+24/Y);}else{V=new U(T.getTime());V.setUTCDate(V.getUTCDate()+1);}break;case n.Month:T.setUTCMonth(T.getUTCMonth()+i);if(W){T.setUTCDate(T.getUTCDate()+X);V=new U(T.getTime());V.setUTCDate(V.getUTCDate()+1);}else{V=new U(T.getTime());V.setUTCMonth(V.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}V.setUTCMilliseconds(V.getUTCMilliseconds()-1);T=a._createLocalDate(T,true);V=a._createLocalDate(V,true);this.fireIntervalSelect({startDate:T,endDate:V,subInterval:W});}function S(i,j){var k=i.getStartDate()-j.getStartDate();if(k==0){k=j.getEndDate()-i.getEndDate();}return k;}return s;});
