/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/unified/calendar/Header","sap/ui/unified/calendar/IndexPickerRenderer",'sap/ui/core/delegate/ItemNavigation',"sap/ui/events/KeyCodes"],function(C,H,I,a,K){"use strict";var b=C.extend("sap.ui.unified.calendar.IndexPicker",{metadata:{library:"sap.ui.unified",properties:{startIndex:{type:"int",group:"Data",defaultValue:0},selectedIndex:{type:"int",group:"Data",defaultValue:0},formatter:{type:"object",group:"Data"},rows:{type:"int",group:"Data",defaultValue:4},columns:{type:"int",group:"Data",defaultValue:3},periodSize:{type:"int",group:"Data",defaultValue:1}},aggregations:{header:{type:"sap.ui.unified.calendar.Header",multiple:false}},events:{select:{},focus:{}}}});b.prototype.init=function(){this._initializeHeader();this.iCurrentIndex=0;};b.prototype.onBeforeRendering=function(){this.getHeader().setEnabledPrevious(this.getStartIndex()>0);};b.prototype.onAfterRendering=function(){_.call(this);};b.prototype._initializeHeader=function(){var h=new H(this.getId()+"--Head",{visibleButton1:false,visibleButton2:false});h.attachEvent("pressPrevious",this._handlePrevious,this);h.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",h);};b.prototype._handlePrevious=function(){this.goToPreviousPage();};b.prototype.goToPreviousPage=function(){var n=this.getStartIndex()-this.getRows()*this.getColumns();n=Math.max(0,n);this.setStartIndex(n);};b.prototype._handleNext=function(){this.goToNextPage();};b.prototype.goToNextPage=function(){var n=this.getStartIndex()+this.getRows()*this.getColumns();this.setStartIndex(n);};b.prototype.onmouseup=function(e){var i=e.target.getAttribute("data-sap-ui-index");if(!i){return;}this._selectIndex(parseInt(i));};b.prototype.onkeydown=function(e){if(e.keyCode===K.ENTER){var i=e.target.getAttribute("data-sap-ui-index");if(!i){return;}this._selectIndex(parseInt(i));}};b.prototype.onkeyup=function(e){if(e.keyCode===K.SPACE){e.preventDefault();var i=e.target.getAttribute("data-sap-ui-index");if(!i){return;}this._selectIndex(parseInt(i));}};b.prototype._selectIndex=function(i){this.setSelectedIndex(i);this.iCurrentIndex=0;this.fireSelect({index:i});};b.prototype._getFormatter=function(){return this.getFormatter()||d;};function d(i){return(i+1).toString();}function _(){var e=0,s=false,r=this.getDomRef(),D=r.querySelectorAll(".sapMIPItem"),f=this.getColumns();for(var i=0;i<D.length;i++){if(D[i].getAttribute("data-sap-ui-index")===this.getSelectedIndex()){e=i;s=true;break;}}if(!this._oItemNavigation){this._oItemNavigation=new a();this._oItemNavigation.attachEvent(a.Events.AfterFocus,c,this);this._oItemNavigation.attachEvent(a.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(f>1){this._oItemNavigation.setHomeEndColumnMode(true,true);}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(f,true);}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(D);if(!s){e=this.iCurrentIndex%D.length;}this._oItemNavigation.setFocusedIndex(e);this._oItemNavigation.focusItem(e);this._oItemNavigation.setPageSize(D.length);}function c(o){var i=o.getParameter("index");var e=o.getParameter("event");if(!e){return;}var f=o.getParameter("index");var D=this._oItemNavigation.getItemDomRefs();var $=jQuery(D[i]);this.iCurrentIndex=f;f=$.attr("data-sap-ui-index");this.fireFocus({index:f});}b.prototype._handleBorderReached=function(o){var e=o.getParameter("event");var f=parseInt(e.target.getAttribute("data-sap-ui-index"));var i=o.getParameter("index");if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":if(e.keyCode===K.ARROW_DOWN){f+=this.getColumns();i+=this.getColumns();}else{f+=1;i+=1;}this.goToNextPage();break;case"sapprevious":case"sappreviousmodifiers":if(e.keyCode===K.ARROW_UP){f-=this.getColumns();i-=this.getColumns();}else{f-=1;i-=1;}this.goToPreviousPage();break;default:break;}var D=this._oItemNavigation.getItemDomRefs();i=Math.abs(D.length-Math.abs(i));this.iCurrentIndex=i;this._oItemNavigation.focusItem(D[i]);this.fireFocus({index:f});}};return b;});
