/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./TimesRowRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange"],function(C,L,I,a,U,l,D,c,b,T,d,e,q,f){"use strict";var g=c.CalendarType;var h=C.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});h.prototype.init=function(){this._oFormatYyyyMMddHHmm=D.getInstance({pattern:"yyyyMMddHHmm",calendarType:g.Gregorian});this._oFormatLong=D.getDateTimeInstance({style:"long/short"});this._oFormatDate=D.getDateInstance({style:"medium"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};h.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};h.prototype.onAfterRendering=function(){_.call(this);};h.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!d(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){u.call(this,true);r.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;s.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;s.call(this);}}};h.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};h.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};h.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};h.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};h.prototype.setIntervalMinutes=function(M){if(M>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%M>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",M,false);this._oFormatTime=undefined;return this;};h.prototype.setDate=function(i){o.call(this,i,false);return this.setProperty("date",i);};h.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date(),undefined,true);}return this._oUTCDate;};h.prototype.setStartDate=function(S){a._checkJSDateObject(S);var y=S.getFullYear();a._checkYearInValidRange(y);var i=a._createUniversalUTCDate(S,undefined,true);this.setProperty("startDate",S);this._oUTCStartDate=this._getIntervalStart(i);if(this.getDomRef()){var O=a._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.displayDate(O);}}return this;};h.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(new Date(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate);}return this._oUTCStartDate;};h.prototype.displayDate=function(i){o.call(this,i,true);return this;};h.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};h.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var w=new b(i);this._oLocaleData=L.getInstance(w);}return this._oLocaleData;};h.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var w=new b(i);this._oFormatLong=D.getInstance({style:"long/short"},w);}return this._oFormatLong;};h.prototype._getFormatTime=function(){var i=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=i){var w=new b(i);var x=this.getIntervalMinutes();var y=this._getLocaleData();var P;var z=y.getTimePattern("short");this._oFormatTimeAmPm=undefined;if(x%60==0){P=v(z);if(z.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},w);}}else{P=z;P=P.replace("HH","H");P=P.replace("hh","h");if(P.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},w);P=P.replace("a","").trim();}}this._oFormatTime=D.getTimeInstance({pattern:P},w);}return this._oFormatTime;};h.prototype._getFormatDate=function(){var i=this._getLocale();if(this._oFormatDate.oLocale.toString()!=i){var w=new b(i);this._oFormatDate=D.getDateInstance({style:"medium"},w);}return this._oFormatDate;};h.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};h.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};h.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};h.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};h.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};h.prototype.getIntervalMinutes=function(){var P=this.getParent();if(P&&P.getIntervalMinutes){return P.getIntervalMinutes();}else{return this.getProperty("intervalMinutes");}};h.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};h.prototype._setLegendControlOrigin=function(i){this._oLegendControlOrigin=i;};h.prototype.getLegend=function(){var P=this.getParent();if(this._oLegendControlOrigin){return this._oLegendControlOrigin.getLegend();}if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};h.prototype._checkDateSelected=function(w){if(!(w instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var S=0;var x=this.getSelectedDates();var M=new U(w.getTime());M=this._getIntervalStart(M);var y=M.getTime();for(var i=0;i<x.length;i++){var R=x[i];var z=R.getStartDate();var A=0;if(z){z=a._createUniversalUTCDate(z,undefined,true);z=this._getIntervalStart(z);A=z.getTime();}var E=R.getEndDate();var B=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);B=E.getTime();}if(y==A&&!E){S=1;break;}else if(y==A&&E){S=2;if(E&&y==B){S=5;}break;}else if(E&&y==B){S=3;break;}else if(E&&y>A&&y<B){S=4;break;}if(this.getSingleSelection()){break;}}return S;};h.prototype._getDateType=function(w){if(!(w instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var x;var S=this.getSpecialDates();var M=new U(w.getTime());M=this._getIntervalStart(M);var y=M.getTime();for(var i=0;i<S.length;i++){var R=S[i];var z=R.getStartDate();var A=0;if(z){z=a._createUniversalUTCDate(z,undefined,true);z=this._getIntervalStart(z);A=z.getTime();}var E=R.getEndDate();var B=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);E.setUTCMinutes(E.getUTCMinutes()+this.getIntervalMinutes()-1);B=E.getTime();}else if(z.getUTCHours()==0&&z.getUTCMinutes()==0&&z.getUTCSeconds()==0&&z.getUTCMilliseconds()==0){E=new U(z.getTime());E.setUTCDate(E.getUTCDate()+1);B=E.getTime();}if((y==A&&!E)||(y>=A&&y<=B)){x={type:R.getType(),tooltip:R.getTooltip_AsString(),color:R.getColor()};break;}}return x;};h.prototype._checkTimeEnabled=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var w=i.getTime();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(w<P._oMinDate.getTime()||w>P._oMaxDate.getTime()){return false;}}return true;};h.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){u.call(this,true);}var $=q(E.target);if($.hasClass("sapUiCalItemText")){$=$.parent();}if($.hasClass("sapUiCalItem")){var O=this._getDate();var F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()!=O.getTime()){this._oUTCDate=F;r.call(this,F,true);this._bMoveChange=true;}}};h.prototype.onmouseup=function(E){if(this._bMouseMove){u.call(this,true);var F=this._getDate();var w=this._oItemNavigation.getItemDomRefs();for(var i=0;i<w.length;i++){var $=q(w[i]);if($.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(F.getJSDate(),true)){$.trigger("focus");break;}}if(this._bMoveChange){var x=q(E.target);if(x.hasClass("sapUiCalItemText")){x=x.parent();}if(x.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyyMMddHHmm.parse(x.attr("data-sap-time"),true).getTime());}r.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;s.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;s.call(this);}};h.prototype.onsapselect=function(E){var S=r.call(this,this._getDate());if(S){s.call(this);}E.stopPropagation();E.preventDefault();};h.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};h.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i-7);}else{F.setUTCDate(i-1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};h.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i+7);}else{F.setUTCDate(i+1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};h.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var w=a._createUniversalUTCDate(i,undefined,true);if(w.getTime()>=S.getTime()&&w.getTime()<E.getTime()){return true;}else{return false;}};h.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};h.prototype._getIntervalStart=function(i){var w=i.getTime();var S=new U(i.getTime());S.setUTCHours(0);S.setUTCMinutes(0);S.setUTCSeconds(0);S.setUTCMilliseconds(0);var M=this.getIntervalMinutes();while(S.getTime()<=w){S.setUTCMinutes(S.getUTCMinutes()+M);}var x=new U(S.getTime());x.setUTCMinutes(x.getUTCMinutes()-M);return x;};h.prototype._setAriaRole=function(R){this._ariaRole=R;return this;};h.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell";};h.prototype._updateItemARIASelected=function($,S){var R=this._getAriaRole();if(R==="gridcell"){$.attr("aria-selected",S);}return this;};function _(){var w=this._getDate();var y=this._oFormatYyyyMMddHHmm.format(w.getJSDate(),true);var x=0;var R=this.$("times").get(0);var z=this.$("times").children(".sapUiCalItem");for(var i=0;i<z.length;i++){var $=q(z[i]);if($.attr("data-sap-time")===y){x=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,j,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,k,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,m,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(z);this._oItemNavigation.setFocusedIndex(x);this._oItemNavigation.setPageSize(z.length);}function j(i){var w=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}var O=this._getDate();var F=new U(O.getTime());var x=this._oItemNavigation.getItemDomRefs();var $=q(x[w]);F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());this._oUTCDate=F;this.fireFocus({date:a._createLocalDate(F,true),notVisible:false});if(E.type=="mousedown"){n.call(this,E,F,w);}}function k(i){var w=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();n.call(this,E,F,w);}}function m(i){var E=i.getParameter("event");var w=this.getItems();var M=this.getIntervalMinutes();var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setUTCMinutes(F.getUTCMinutes()+M);break;case"sapprevious":case"sappreviousmodifiers":F.setUTCMinutes(F.getUTCMinutes()-M);break;case"sappagedown":F.setUTCMinutes(F.getUTCMinutes()+M*w);break;case"sappageup":F.setUTCMinutes(F.getUTCMinutes()-M*w);break;default:break;}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});}}function n(E,F,i){if(E.button){return;}var S=r.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){u.call(this,true);this._bMoveChange=false;}else if(this.getIntervalSelection()&&this.$().is(":visible")){t.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}function o(i,N){a._checkJSDateObject(i);var y=i.getFullYear();a._checkYearInValidRange(y);var F=true;if(!e(this.getDate(),i)){var w=a._createUniversalUTCDate(i,undefined,true);w=this._getIntervalStart(w);F=this.checkDateFocusable(i);if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",i);this._oUTCDate=w;}if(this.getDomRef()){if(F){p.call(this,this._oUTCDate,N);}else{this.setDate(i);}}}function p(w,N){var y=this._oFormatYyyyMMddHHmm.format(w.getJSDate(),true);var x=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<x.length;i++){$=q(x[i]);if($.attr("data-sap-time")==y){if(document.activeElement!=x[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}function r(w,M){if(!this._checkTimeEnabled(w)){return false;}var S=this.getSelectedDates();var x;var i=0;var P=this.getParent();var A=this;var y;if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){x=S[0];y=x.getStartDate();if(y){y=a._createUniversalUTCDate(y,undefined,true);y=this._getIntervalStart(y);}}else{x=new f();A.addAggregation("selectedDates",x);}if(this.getIntervalSelection()&&(!x.getEndDate()||M)&&y){var E;if(w.getTime()<y.getTime()){E=y;y=w;if(!M){x.setProperty("startDate",a._createLocalDate(new Date(y.getTime()),true));x.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true));}}else if(w.getTime()>=y.getTime()){E=w;if(!M){x.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true));}}}else{x.setProperty("startDate",a._createLocalDate(new Date(w.getTime()),true));x.setProperty("endDate",undefined);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var z=this._checkDateSelected(w);if(z>0){for(i=0;i<S.length;i++){y=S[i].getStartDate();if(y){y=a._createUniversalUTCDate(y,undefined,true);y=this._getIntervalStart(y);if(w.getTime()==y.getTime()){A.removeAggregation("selectedDates",i);break;}}}}else{x=new f({startDate:a._createLocalDate(new Date(w.getTime()),true)});A.addAggregation("selectedDates",x);}}}return true;}function s(){if(this._bMouseMove){u.call(this,true);}this.fireSelect();}function t(){q(window.document).on('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}function u(){q(window.document).off('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}function v(i){var P;if(i.toUpperCase().indexOf("K")>-1){P=i.indexOf("k")>-1?"k":"K";}else{P=i.indexOf("h")>-1?"h":"H";}return P;}return h;});
