sap.ui.define(["sap/ui/webc/common/thirdparty/base/types/Integer","sap/ui/webc/common/thirdparty/base/delegate/ResizeHandler","sap/ui/webc/common/thirdparty/base/util/PopupUtils","sap/ui/webc/common/thirdparty/base/util/clamp","./Popup","./types/PopoverPlacementType","./types/PopoverVerticalAlign","./types/PopoverHorizontalAlign","./popup-utils/PopoverRegistry","./generated/templates/PopoverTemplate.lit","./generated/themes/BrowserScrollbar.css","./generated/themes/PopupsCommon.css","./generated/themes/Popover.css"],function(t,e,i,o,s,h,r,n,a,l,p,c,d){"use strict";function u(t){return t&&typeof t==="object"&&"default"in t?t["default"]:t}var g=u(t);var f=u(e);var m=u(o);const w=8;const _={tag:"ui5-popover",properties:{headerText:{type:String},placementType:{type:h,defaultValue:h.Right},horizontalAlign:{type:n,defaultValue:n.Center},verticalAlign:{type:r,defaultValue:r.Center},modal:{type:Boolean},hideBackdrop:{type:Boolean},hideArrow:{type:Boolean},allowTargetOverlap:{type:Boolean},disableScrolling:{type:Boolean},arrowTranslateX:{type:g,defaultValue:0,noAttribute:true},arrowTranslateY:{type:g,defaultValue:0,noAttribute:true},actualPlacementType:{type:h,defaultValue:h.Right},_maxContentHeight:{type:g}},managedSlots:true,slots:{header:{type:HTMLElement},footer:{type:HTMLElement}},events:{}};class y extends s{constructor(){super();this._handleResize=this.handleResize.bind(this)}static get metadata(){return _}static get styles(){return[p,c,d]}static get template(){return l}static get MIN_OFFSET(){return 10}onEnterDOM(){f.register(this,this._handleResize)}onExitDOM(){f.deregister(this,this._handleResize)}isOpenerClicked(t){const e=t.target;return e===this._opener||e.getFocusDomRef&&e.getFocusDomRef()===this._opener||t.composedPath().indexOf(this._opener)>-1}async showAt(t,e=false){if(!t||this.opened){return}this._opener=t;this._openerRect=t.getBoundingClientRect();await super._open(e)}_addOpenedPopup(){a.addOpenedPopover(this)}_removeOpenedPopup(){a.removeOpenedPopover(this)}shouldCloseDueToOverflow(t,e){const o=32;const s={Right:e.right,Left:e.left,Top:e.top,Bottom:e.bottom};const h=i.getClosedPopupParent(this._opener);let r=false;let n=false;if(h.showAt){const t=h.contentDOM.getBoundingClientRect();r=e.top>t.top+t.height;n=e.top+e.height<t.top}return s[t]<0||s[t]+o>h.innerHeight||r||n}shouldCloseDueToNoOpener(t){return t.top===0&&t.bottom===0&&t.left===0&&t.right===0}handleResize(){if(this.opened){this.reposition()}}reposition(){this._show()}_show(){let t;const e=this.getPopoverSize();if(e.width===0||e.height===0){return}if(this.isOpen()){this._openerRect=this._opener.getBoundingClientRect()}if(this.shouldCloseDueToNoOpener(this._openerRect)&&this.isFocusWithin()){t=this._oldPlacement}else{t=this.calcPlacement(this._openerRect,e)}const i=this.horizontalAlign===n.Stretch;if(this._preventRepositionAndClose){return this.close()}if(this._oldPlacement&&this._oldPlacement.left===t.left&&this._oldPlacement.top===t.top&&i){super._show();this.style.width=this._width;return}this._oldPlacement=t;const o=m(this._left,y.MIN_OFFSET,document.documentElement.clientWidth-e.width-y.MIN_OFFSET);const s=m(this._top,y.MIN_OFFSET,document.documentElement.clientHeight-e.height-y.MIN_OFFSET);let{arrowX:h,arrowY:r}=t;const a=this._left===0;const l=this._left+e.width>=document.documentElement.clientWidth;if(a){h-=y.MIN_OFFSET}else if(l){h+=y.MIN_OFFSET}this.arrowTranslateX=h;const p=this._top===0;const c=this._top+e.height>=document.documentElement.clientHeight;if(p){r-=y.MIN_OFFSET}else if(c){r+=y.MIN_OFFSET}this.arrowTranslateY=r;this.actualPlacementType=t.placementType;Object.assign(this.style,{top:`${s}px`,left:`${o}px`});super._show();if(i&&this._width){this.style.width=this._width}}getPopoverSize(){if(!this.opened){Object.assign(this.style,{display:"block",top:"-10000px",left:"-10000px"})}const t=this.getBoundingClientRect(),e=t.width,i=t.height;return{width:e,height:i}}get contentDOM(){return this.shadowRoot.querySelector(".ui5-popup-content")}get arrowDOM(){return this.shadowRoot.querySelector(".ui5-popover-arrow")}calcPlacement(t,e){let i=0;let o=0;const s=this.allowTargetOverlap;const a=document.documentElement.clientWidth;const l=document.documentElement.clientHeight;let p=l;let c="";let d="";const u=this.getActualPlacementType(t,e);this._preventRepositionAndClose=this.shouldCloseDueToNoOpener(t)||this.shouldCloseDueToOverflow(u,t);const g=u===h.Top||u===h.Bottom;if(this.horizontalAlign===n.Stretch&&g){e.width=t.width;c=`${t.width}px`}else if(this.verticalAlign===r.Stretch&&!g){e.height=t.height;d=`${t.height}px`}this._width=c;this._height=d;const f=this.hideArrow?0:w;switch(u){case h.Top:i=this.getVerticalLeft(t,e);o=Math.max(t.top-e.height-f,0);if(!s){p=t.top-f}break;case h.Bottom:i=this.getVerticalLeft(t,e);if(s){o=Math.max(Math.min(t.bottom+f,l-e.height),0)}else{o=t.bottom+f;p=l-t.bottom-f}break;case h.Left:i=Math.max(t.left-e.width-f,0);o=this.getHorizontalTop(t,e);break;case h.Right:if(s){i=Math.max(Math.min(t.left+t.width+f,a-e.width),0)}else{i=t.left+t.width+f}o=this.getHorizontalTop(t,e);break}if(g){if(e.width>a||i<0){i=0}else if(i+e.width>a){i-=i+e.width-a}}else{if(e.height>l||o<0){o=0}else if(o+e.height>l){o-=o+e.height-l}}let m=Math.round(p);if(this._displayHeader){const t=this.shadowRoot.querySelector(".ui5-popup-header-root")||this.shadowRoot.querySelector(".ui5-popup-header-text");if(t){m=Math.round(p-t.offsetHeight)}}this._maxContentHeight=m-y.MIN_OFFSET;const _=this.getArrowPosition(t,e,i,o,g);if(this._left===undefined||Math.abs(this._left-i)>1.5){this._left=Math.round(i)}if(this._top===undefined||Math.abs(this._top-o)>1.5){this._top=Math.round(o)}return{arrowX:_.x,arrowY:_.y,top:this._top,left:this._left,placementType:u}}getArrowPosition(t,e,i,o,s){let h=this.horizontalAlign===n.Center||this.horizontalAlign===n.Stretch;if(this.horizontalAlign===n.Right&&i<=t.left){h=true}if(this.horizontalAlign===n.Left&&i+e.width>=t.left+t.width){h=true}let r=0;if(s&&h){r=t.left+t.width/2-i-e.width/2}let a=0;if(!s){a=t.top+t.height/2-o-e.height/2}return{x:Math.round(r),y:Math.round(a)}}fallbackPlacement(t,e,i,o){if(i.left>o.width){return h.Left}if(t-i.right>i.left){return h.Right}if(e-i.bottom>o.height){return h.Bottom}if(e-i.bottom<i.top){return h.Top}}getActualPlacementType(t,e){const i=this.placementType;let o=i;const s=document.documentElement.clientWidth;const r=document.documentElement.clientHeight;switch(i){case h.Top:if(t.top<e.height&&t.top<r-t.bottom){o=h.Bottom}break;case h.Bottom:if(r-t.bottom<e.height&&r-t.bottom<t.top){o=h.Top}break;case h.Left:if(t.left<e.width){o=this.fallbackPlacement(s,r,t,e)||i}break;case h.Right:if(s-t.right<e.width){o=this.fallbackPlacement(s,r,t,e)||i}break}return o}getVerticalLeft(t,e){let i;switch(this.horizontalAlign){case n.Center:case n.Stretch:i=t.left-(e.width-t.width)/2;break;case n.Left:i=t.left;break;case n.Right:i=t.right-e.width;break}return i}getHorizontalTop(t,e){let i;switch(this.verticalAlign){case r.Center:case r.Stretch:i=t.top-(e.height-t.height)/2;break;case r.Top:i=t.top;break;case r.Bottom:i=t.bottom-e.height;break}return i}get isModal(){return this.modal}get shouldHideBackdrop(){return this.hideBackdrop}get _ariaLabelledBy(){return this.accessibleName?undefined:"ui5-popup-header"}get _ariaModal(){return true}get styles(){return{...super.styles,content:{"max-height":`${this._maxContentHeight}px`},arrow:{transform:`translate(${this.arrowTranslateX}px, ${this.arrowTranslateY}px)`}}}get _displayHeader(){return this.header.length||this.headerText}get _displayFooter(){return true}}y.define();return y});