sap.ui.define(["sap/ui/webc/common/thirdparty/base/UI5Element","sap/ui/webc/common/thirdparty/base/renderer/LitRenderer","sap/ui/webc/common/thirdparty/base/delegate/ResizeHandler","sap/ui/webc/common/thirdparty/base/types/Integer","sap/ui/webc/common/thirdparty/base/util/AriaLabelHelper","sap/ui/webc/common/thirdparty/base/i18nBundle","sap/ui/webc/common/thirdparty/base/FeaturesRegistry","sap/ui/webc/common/thirdparty/base/Device","sap/ui/webc/common/thirdparty/base/Keys","sap/ui/webc/common/thirdparty/base/types/ValueState","./Popover","./generated/templates/TextAreaTemplate.lit","./generated/templates/TextAreaPopoverTemplate.lit","./generated/i18n/i18n-defaults","./generated/themes/TextArea.css","./generated/themes/ValueStateMessage.css"],function(e,t,a,s,i,r,n,o,u,h,l,p,g,c,d,m){"use strict";function v(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var x=v(e);var f=v(t);var S=v(a);var T=v(s);var y=v(h);const _={tag:"ui5-textarea",languageAware:true,managedSlots:true,properties:{value:{type:String},disabled:{type:Boolean},readonly:{type:Boolean},required:{type:Boolean},placeholder:{type:String},valueState:{type:y,defaultValue:y.None},rows:{type:T,defaultValue:0},maxlength:{type:T,defaultValue:null},showExceededText:{type:Boolean},growing:{type:Boolean},growingMaxLines:{type:T,defaultValue:0},name:{type:String},accessibleName:{type:String},accessibleNameRef:{type:String},focused:{type:Boolean},exceeding:{type:Boolean},_mirrorText:{type:Object,multiple:true,defaultValue:""},_maxHeight:{type:String,noAttribute:true},_width:{type:T}},slots:{valueStateMessage:{type:HTMLElement},formSupport:{type:HTMLElement}},events:{change:{},input:{}}};class w extends x{static get metadata(){return _}static get styles(){return d}static get render(){return f}static get template(){return p}static get staticAreaTemplate(){return g}static get staticAreaStyles(){return m}constructor(){super();this._firstRendering=true;this._openValueStateMsgPopover=false;this._fnOnResize=this._onResize.bind(this);this.i18nBundle=r.getI18nBundle("@ui5/webcomponents")}onEnterDOM(){S.register(this,this._fnOnResize)}onExitDOM(){S.deregister(this,this._fnOnResize)}onBeforeRendering(){this._exceededTextProps=this._calcExceededText();this._mirrorText=this._tokenizeText(this.value);this.exceeding=this._exceededTextProps.leftCharactersCount<0;if(this.growingMaxLines){this._maxHeight=`${this.growingMaxLines*1.4*14+9}px`}const e=n.getFeature("FormSupport");if(e){e.syncNativeHiddenInput(this)}else if(this.name){console.warn(`In order for the "name" property to have effect, you should also: import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";`)}}onAfterRendering(){this.toggleValueStateMessage(this.openValueStateMsgPopover);this._firstRendering=false}getInputDomRef(){return this.getDomRef().querySelector("textarea")}_onkeydown(e){this._keyDown=true;if(u.isEscape(e)){const e=this.getInputDomRef();this.value=this.previousValue;e.value=this.value;this.fireEvent("input")}}_onkeyup(){this._keyDown=false}_onfocusin(){this.focused=true;this._openValueStateMsgPopover=true;this.previousValue=this.getInputDomRef().value}_onfocusout(){this.focused=false;this._openValueStateMsgPopover=false}_onchange(){this.fireEvent("change",{})}_oninput(e){const t=this.getInputDomRef();const a=t.value===this.value&&o.isIE()&&!this._keyDown&&!!this.placeholder;if(e.target===t){e.stopImmediatePropagation()}if(a){return}this.value=t.value;this.fireEvent("input",{});this.fireEvent("value-changed")}_onResize(){if(this.displayValueStateMessagePopover){this._width=this.offsetWidth}}toggleValueStateMessage(e){if(e){this.openPopover()}else{this.closePopover()}}async openPopover(){this.popover=await this._getPopover();this.popover&&this.popover.showAt(this.shadowRoot.querySelector(".ui5-textarea-inner"))}async closePopover(){this.popover=await this._getPopover();this.popover&&this.popover.close()}async _getPopover(){const e=await this.getStaticAreaItemDomRef();return e.querySelector("[ui5-popover]")}_tokenizeText(e){const t=e.replace(/&/gm,"&amp;").replace(/"/gm,"&quot;").replace(/'/gm,"&apos;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").split("\n");if(t.length<this.rows){return this._mapTokenizedTextToObject([...t,...Array(this.rows-t.length).fill("")])}return this._mapTokenizedTextToObject(t)}_mapTokenizedTextToObject(e){return e.map((t,a)=>({text:t,last:a===e.length-1}))}_calcExceededText(){let e,t,a;if(this.showExceededText){const e=this.maxlength||0;if(e){a=e-this.value.length;if(a>=0){t=this.i18nBundle.getText(c.TEXTAREA_CHARACTERS_LEFT,[a])}else{t=this.i18nBundle.getText(c.TEXTAREA_CHARACTERS_EXCEEDED,[Math.abs(a)])}}}else{e=this.maxlength}return{exceededText:t,leftCharactersCount:a,calcedMaxLength:e}}get classes(){return{valueStateMsg:{"ui5-valuestatemessage--error":this.valueState===y.Error,"ui5-valuestatemessage--warning":this.valueState===y.Warning||this.exceeding,"ui5-valuestatemessage--information":this.valueState===y.Information}}}get styles(){const e=1.4*16;return{mirror:{"max-height":this._maxHeight},main:{width:"100%",height:this.rows&&!this.growing?`${this.rows*e}px`:"100%"},focusDiv:{height:this.showExceededText?"calc(100% - 26px)":"100%","max-height":this._maxHeight},valueStateMsgPopover:{"max-width":`${this._width}px`}}}get tabIndex(){return this.disabled?undefined:"0"}get ariaLabelText(){const e=i.getEffectiveAriaLabelText(this);if(this.showExceededText){if(e){return`${e} ${this._exceededTextProps.exceededText}`}return this._exceededTextProps.exceededText}return e}get ariaDescribedBy(){return this.hasValueState?`${this._id}-valueStateDesc`:undefined}get ariaValueStateHiddenText(){if(!this.hasValueState){return}if(this.hasCustomValueState){return this.valueStateMessageText.map(e=>e.textContent).join(" ")}return this.valueStateText}get ariaInvalid(){return this.valueState==="Error"?"true":undefined}get openValueStateMsgPopover(){return!this._firstRendering&&this._openValueStateMsgPopover&&this.displayValueStateMessagePopover}get displayValueStateMessagePopover(){return this.hasCustomValueState||this.hasValueState||this.exceeding}get hasCustomValueState(){return!!this.valueStateMessage.length&&this.hasValueState}get hasValueState(){return this.valueState===y.Error||this.valueState===y.Warning||this.valueState===y.Information}get valueStateMessageText(){return this.valueStateMessage.map(e=>e.cloneNode(true))}get valueStateText(){if(this.valueState!==y.Error&&this.exceeding){return this.valueStateTextMappings()[y.Warning]}return this.valueStateTextMappings()[this.valueState]}valueStateTextMappings(){const e=this.i18nBundle;return{Information:e.getText(c.VALUE_STATE_INFORMATION),Error:e.getText(c.VALUE_STATE_ERROR),Warning:e.getText(c.VALUE_STATE_WARNING)}}static get dependencies(){return[l]}static async onDefine(){await r.fetchI18nBundle("@ui5/webcomponents")}}w.define();return w});