/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Gui.Dialog
 * 
 * oscar.Gui.Dialog is the base class for dialogs in Oscar Framework.
 * 
 * Inherits from: - <oscar.Gui>
 * 
 * @deprecated
 * 
 */

oscar.Gui.Dialog = oscar.BaseClass(oscar.Gui, {
    /**
     * Properties:
     */
    name : "Dialog",
    dialog : null,
    container : null,
    header : null,
    body : null,
    icon : null,
    dialogButtons : null,

    /**
     * Constructor: oscar.Gui.Dialog
     * 
     * Parameters: name - name of the dialog. options - {Object} An optional
     * object whose properties will be set on this instance.
     */
    initialize : function(name, options) {
        this._setDlgDefaults();
        this.dialogButtons = [];
        if (!options)
            options = {};
        this.dialogProperties.icon = options.icon;
        this.name = name;
        OpenLayers.Util.extend(this.dialogProperties, options);
        if (!this.dialogProperties.effect) {
            this.dialogProperties.effect = {
                effect : YAHOO.widget.ContainerEffect.FADE,
                duration : 0.2
            };
        }
        this.dialog = new YAHOO.widget.SimpleDialog(this.name, this.dialogProperties);

    },
    /**
     * APIMethod: setHeader
     * 
     * Sets the header for the dialog panel
     * 
     * Parameters: header - header for the dialog panel.
     */
    setHeader : function(header) {
        this.header = header;
    },
    /**
     * APIMethod: setContent
     * 
     * Sets the content for the dialog panel, can either be text or an HTML
     * element like a div.
     * 
     * Parameters: content - the content object to be set.
     */
    setContent : function(content) {

        this.body = document.createElement("div");
        this.body.className = "oscarGuiDialog";
        if (typeof content == "object")
            this.body.appendChild(content);
        else
            this.body.innerHTML = oscar.i18n(content);
    },
    /**
     * Method: addButton
     * 
     * This function will add a button to the panel.
     * 
     * Parameters: button - a button object.
     */
    addButton : function(button) {
        this.dialogButtons.push(button);
    },

    /**
     * APIMethod: render
     * 
     * This function will "draw" the dialog panel.
     */
    render : function() {
        if (!this.container) {
            this._createDialogContainer();
        }
        this.dialog.cfg.queueProperty("buttons", this.dialogButtons);
        this.dialog.setHeader(oscar.i18n(this.header));
        this.dialog.setBody(this.body);
        document.body.appendChild(this.container);
        this.dialog.render(this.container);

    },
    /**
     * APIMethod: hide
     * 
     * This function will hide and destroy the dialog.
     */
    hide : function() {
        if (this.dialog)
            this.dialog.hide();
        this.destroy();
    },
    /**
     * APIMethod: show
     * 
     * This function will show the dialog panel.
     */
    show : function() {
        if (this.dialog) {
            this.render();
            this.dialog.show();
        }
    },

    /**
     * APIMethod: addOkButton
     * 
     * This is a convenience method for adding an OK button to the dialog.
     * 
     * Parameters: callback - the callback function.
     * 
     */
    addOkButton : function(callback) {
        this.createButton("okayButtonLabel", callback)
    },
    /**
     * APIMethod: addCancelButton
     * 
     * This is a convenience method for adding a Cancel button to the dialog.
     * 
     * Parameters: callback - the callback function.
     */
    addCancelButton : function(callback) {
        this.createButton("cancelButtonLabel", callback);
    },
    /**
     * Method: createButton
     * 
     * Use this method to add a button to the dialog, include the text or
     * language key, include a callback method if required.
     * 
     * Parameters: txt - text of the button. callback - the callback function.
     */
    createButton : function(txt, callback) {
        var ctx = this;
        var handler;
        if (!callback) {
            handler = function() {
                this.hide();

            };
        } else {
            handler = function() {
                if (ctx.autoclose)
                    this.hide();
                callback();
            };
        }
        this.addButton({
            text : oscar.i18n(txt),
            handler : handler
        });
    },

    /**
     * Method: destroy Destroys this widget.
     */
    destroy : function() {
        try {
            if (this.container != null) {
                document.body.removeChild(this.container);
            }
            this.dialog = null;
        } catch (err) {
        }
    },

    /**
     * Method: _createDialogContainer This method will create a container for
     * the dialog. (YUI specific)
     */
    _createDialogContainer : function() {
        this.container = document.createElement("div");
        this.container.className = "yui-skin-sam";
        this.container.id = OpenLayers.Util.createUniqueID("oscarGuiDialog");
    },

    /**
     * Method: _setDlgDefaults This method sets the dialog's properties with the
     * default values.
     */
    _setDlgDefaults : function() {
        this.dialogProperties = {
            fixedcenter : true,
            visible : false,
            draggable : false,
            close : false,
            modal : true,
            constraintoviewport : true,
            zIndex : 999
        };
    },

    /**
     * Constant: CLASS_NAME - oscar.Gui.Dialog
     */
    CLASS_NAME : "oscar.Gui.Dialog"

});
/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * @requires oscar.Gui.Dialog
 */

/**
 * Class: oscar.Gui.AlertDialog
 * 
 * A GUI dialog widget that displays an alert.
 * 
 * Inherits from: - <oscar.Gui.Dialog>
 */

oscar.Gui.AlertDialog = oscar.BaseClass(oscar.Gui.Dialog, {
    /**
     * Constructor: oscar.Gui.AlertDialog
     * 
     * Parameters:
     * 
     * header - header for this alert dialog. content - alert content. options -
     * {Object} An optional object whose properties will be set on this
     * instance.
     * 
     * @deprecated
     */

    initialize : function(header, content, options) {
        if (!header)
            header = oscar.i18n("alertBoxHeader");
        if (!content)
            content = oscar.i18n("oneChecked");
        if (!options)
            options = [];
        options.icon = YAHOO.widget.SimpleDialog.ICON_WARN;
        oscar.Gui.Dialog.prototype.initialize.apply(this, [ "AlertDialog", options ]);
        this.addOkButton();
        this.setHeader(header);
        this.setContent(content);
        this.show();
    },

    /**
     * Constant: CLASS_NAME - oscar.Gui.AlertDialog
     */
    CLASS_NAME : "oscar.Gui.AlertDialog"
});

/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * @requires oscar.Gui.Dialog
 */

/**
 * Class: oscar.Gui.ConfirmDialog
 * 
 * A GUI dialog widget that confirms user's choices of "yes" or "no".
 * 
 * Inherits from: - <oscar.Gui.Dialog>
 * 
 * @deprecated
 */

oscar.Gui.ConfirmDialog = oscar.BaseClass(oscar.Gui.Dialog, {
    /**
     * Property: yesCallback
     */
    yesCallback : null,
    /**
     * Property: noCallback
     * 
     */
    noCallback : null,
    /**
     * Constructor: oscar.Gui.ConfirmDialog
     * 
     * Parameters: header - header for this confirm dialog. content - content
     * for this confirm dialog. options - {Object} An optional object whose
     * properties will be set on this instance.
     */
    initialize : function(header, content, options) {
        options.icon = YAHOO.widget.SimpleDialog.ICON_HELP;
        oscar.Gui.Dialog.prototype.initialize.apply(this, [ "ConfirmDialog", options ]);
        OpenLayers.Util.extend(this, options);
        this.createButton("yesButtonLabel", this.yesCallback);
        this.createButton("cancelButtonLabel", this.noCallback);
        this.setHeader(header);
        this.setContent(content);
        this.show();
    },

    /**
     * Constant: CLASS_NAME - oscar.Gui.ConfirmDialog
     */
    CLASS_NAME : "oscar.Gui.ConfirmDialog"
});

/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Gui.MultiItemChooserTable
 * 
 * The multiple item chooser allows the user to choose multiple items at the
 * same time. It lists all the available items in a paginated table and uses a
 * CheckBox to show the selected/unselected state for each. The chooser also has
 * an AutoComplete input field that can narrow down the list by searching the
 * items. A reset button is provided to restore the pre-selected items when
 * constructing the chooser.
 * 
 * @deprecated
 */
oscar.Gui.MultiItemChooserTable = oscar.BaseClass({
    /**
     * Constant: EVENT_TYPES {Array(String)} supported events.
     * 
     * clicked - Triggered by checkbox clicked. resetClicked - Triggered by
     * reset button clicked.
     */
    EVENT_TYPES : [ "clicked", "resetClicked" ],
    /**
     * Property: events
     */
    events : null,
    /**
     * Property: DataSource The YUI data source.
     */
    DataSource : null,

    /**
     * Property: DataTable The YUI data table.
     */
    DataTable : null,

    /**
     * Property: autoComplete The YUI auto complete widget.
     */
    autoComplete : null,

    /**
     * Property: ItemsSelection Array for selected objects.
     */
    ItemsSelections : null,

    /**
     * Property: preSelectedItems Array of pre-selected items when the chooser
     * is created.
     */
    preSelectedItems : null,

    /**
     * Property: sortOnCheck {Boolean) - Automatically sorts the table when the
     * checkbox is clicked.
     */
    sortOnCheck : true,

    /**
     * Property: paginator Object - the paginator object.
     */
    paginator : null,

    /**
     * Property: rowsPerPage {Number} Number of items to show for the paginator.
     * 
     */
    rowsPerPage : 8,

    /**
     * Prperty: rowsPerPage {Number} - Number of page links to show in the
     * paginator.
     */
    numPageLinks : 5,

    /**
     * Property: columnDefs {Array} Array of column definitions.
     */
    columnDefs : null,

    /**
     * Property: dataTableConfig {Array} Table Configuration.
     */
    dataTableConfig : null,

    /**
     * Property: paginatorPanel {HTMLDivElement} The Paginator Panel.
     */
    paginatorPanel : null,

    /**
     * Property: container {String} The main div element where we append all the
     * sub elements.
     */
    container : null,

    /**
     * Property: requestParameter
     * 
     * {String} We don't want to force the user to use our parameter, lets give
     * him the option.
     */
    requestParameter : "filter",

    /**
     * Property: checkAllDisplay
     * 
     * {Boolean} Flag to indicate whether or not to display the check all
     * checkbox.
     */
    checkAllDisplay : true,

    /**
     * Property: resetButtonDisplay
     * 
     * {Boolean} Flag to indicate whether or not to display the reset button.
     */
    resetButtonDisplay : true,

    /**
     * Property: autoCompletePanel
     * 
     * {HTMLDivElement} The autocomplete panel consists of the inputbox,
     * clearFilter and reset buttons.
     */
    autoCompletePanel : null,

    /**
     * Method: getDefaultTableConfiguration
     * 
     * Returns: {Object} the object containing default settings for the data
     * table.
     */
    getDefaultTableConfiguration : function() {
        return {
            MSG_EMPTY : oscar.i18n("MICT_MSG_EMPTY"),
            MSG_ERROR : oscar.i18n("MICT_MSG_ERROR"),
            MSG_LOADING : oscar.i18n("MICT_MSG_LOADING"),
            MSG_SORTASC : oscar.i18n("MICT_MSG_SORTASC"),
            MSG_SORTDESC : oscar.i18n("MICT_MSG_SORTDESC")
        };
    },

    /**
     * Constructor: oscar.Gui.MultiItemChooserTable
     * 
     * Parameters: container - The tag id that the multiItemChooserTable will be
     * attached to. preSelectedItemsIn - The items that will be selected by
     * default. DataSourceIn - The data source the SRSs come from.
     * dataTableConfig - The datatable's configuration parameters. columnDefs -
     * The column definition configuration. requestParameterIn - The request
     * parameter used in the getItems method. options - {Object} An optional
     * object whose properties will be set on this instance.
     */
    initialize : function(container, preSelectedItemsIn, DataSourceIn, dataTableConfig, columnDefs, requestParameterIn, options) {
        if (options)
            OpenLayers.Util.extend(this, options);

        this.dataTableConfig = this.getDefaultTableConfiguration();
        OpenLayers.Util.extend(this.dataTableConfig, dataTableConfig);
        this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES, false, {
            includeXY : true
        });
        this.container = container;
        this.preSelectedItems = preSelectedItemsIn;
        this.ItemsSelections = preSelectedItemsIn.slice(0); // copy the array
        this.DataSource = DataSourceIn;
        this.columnDefs = columnDefs;
        this.requestParameter = requestParameterIn;
        this.inputBoxElement = null;
        this.checkAllLabel = null;

        this.buildAutoComplete();
        if (this.checkAllDisplay)
            this.buildCheckAll();
        this.buildPaginator();
        this.buildTableChooser();

    },

    /**
     * Method: buildAutoComplete
     * 
     * Builds the AutoComplete widget and the reset button.
     */
    buildAutoComplete : function() {
        // Create the div container for the autocomplete
        this.autoCompletePanel = document.createElement('div');
        this.autoCompletePanel.setAttribute("class", "oscar_Gui_MultiItemChooserTable_autoComplete");
        this.autoCompletePanel.setAttribute("id", OpenLayers.Util.createUniqueID("mict_autoComplete"));

        // Create div for autocomplete input
        var inputPanel = document.createElement('span');
        inputPanel.setAttribute("class", "oscar_Gui_MultiItemChooserTable_inputPanel");
        inputPanel.setAttribute("id", OpenLayers.Util.createUniqueID("mict_inputPanel"));
        // Create div for the autocomplete container.
        var filterContainerPanel = document.createElement('div');
        filterContainerPanel.setAttribute("class", "oscar_Gui_MultiItemChooserTable_filterContainer");
        filterContainerPanel.setAttribute("id", OpenLayers.Util.createUniqueID("filterContainer"));
        // Create label element
        var inputBoxLabel = document.createElement("label");
        inputBoxLabel.setAttribute("class", "oscar_Gui_MultiItemChooserTable_autocomplete_label");
        inputBoxLabel.setAttribute("id", OpenLayers.Util.createUniqueID("mict_autocomplete_label"));
        inputBoxLabel.setAttribute("for", "autoCompleteInputBox");
        inputBoxLabel.innerHTML = oscar.i18n("mict_autocomplete_label");
        // Create input element
        this.inputBoxElement = document.createElement("input");
        this.inputBoxElement.setAttribute("class", "oscar_Gui_MultiItemChooserTable_autocomplete_input");
        this.inputBoxElement.setAttribute("id", OpenLayers.Util.createUniqueID("mict_autocomplete_input"));
        this.inputBoxElement.value = oscar.i18n("mict_autocomplete_label");
        oscar.jQuery(this.inputBoxElement).addClass("mict_input_default");
        oscar.jQuery(this.inputBoxElement).addClass("mict_input_inactive");
        var onFocus = function() {
            return function(e) {
                if (this.value == oscar.i18n("mict_autocomplete_label")) {
                    this.value = "";
                    oscar.jQuery(this).removeClass("mict_input_inactive");
                }
            };
        }
        var onBlur = function(obj) {
            return function(e) {
                if (obj.inputBoxElement.value.length == 0) {
                    obj.inputBoxElement.value = oscar.i18n("mict_autocomplete_label");
                    oscar.jQuery(obj.inputBoxElement).addClass("mict_input_inactive");
                    if (obj.clearFilterElement) {
                        // return the icon to the 'disabled' grey
                        obj.clearFilterElement.removeClass("oscar_Gui_MultiItemChooserTable_clearFilter");
                        obj.clearFilterElement.applyClass("oscar_Gui_MultiItemChooserTable_clearFilter_disabled");
                    }
                }
            }
        }
        this.inputBoxElement.onfocus = onFocus();
        this.inputBoxElement.onblur = onBlur(this);

        // Append element to the panel
        inputPanel.appendChild(this.inputBoxElement);
        this.autoCompletePanel.appendChild(inputPanel);

        // Create the 'Reset' button
        if (this.resetButtonDisplay)
            this.createResetClickableLabel();
        // Create the 'Clear Filter' button
        this.createClearFilterClickableLabel();

        var breaker = document.createElement("div");
        breaker.setAttribute("style", "clear:both");
        this.autoCompletePanel.appendChild(breaker);

        // Append the objects to the this.container main div object.
        $(this.container).appendChild(this.autoCompletePanel);

        // Create the query listing and include in an autoComplete widget.
        var acFunction = function(obj) {
            return function(e) {
                if (this.value != "") {
                    obj.clearFilterElement.removeClass("oscar_Gui_MultiItemChooserTable_clearFilter_disabled");
                    obj.clearFilterElement.applyClass("oscar_Gui_MultiItemChooserTable_clearFilter");
                }
                obj.getItems(this.value)
            };
        }
        this.inputBoxElement.onkeyup = acFunction(this);
    },

    /**
     * Method: createClearFilterClickableLabel
     * 
     * Creates a clear filter clickableLabel.
     */
    createClearFilterClickableLabel : function() {
        // Create div for Clear Filter image (Clickable label).
        var clearFilterPanel = document.createElement('span');
        clearFilterPanel.setAttribute("class", "oscar_Gui_MultiItemChooserTable_clearFilterPanel");
        clearFilterPanel.setAttribute("id", OpenLayers.Util.createUniqueID("mict_clearFilterPanel"));

        var lbl = "";
        var id = OpenLayers.Util.createUniqueID("mict_clearFilter_icon");
        this.clearFilterElement = new oscar.Gui.ClickableLabel(lbl, {
            style : "block",
            ref : id
        });
        this.clearFilterElement.events.on({
            "labelClicked" : this.clearFilter,
            scope : this
        });
        this.clearFilterElement.applyClass("oscar_Gui_MultiItemChooserTable_clearFilter_disabled");
        var tooltipValue = oscar.i18n("mict_clearFilter_icon");
        this.clearFilterElement.setTooltip(tooltipValue);

        // Append element to the panel
        this.clearFilterElement.appendTo(clearFilterPanel);
        this.autoCompletePanel.appendChild(clearFilterPanel);
    },

    /**
     * Method: createResetClickableLabel
     * 
     * Creates a reset clickableLabel.
     */
    createResetClickableLabel : function() {
        // Create div for reset image (Clickable label).
        var resetPanel = document.createElement('span');
        resetPanel.setAttribute("class", "oscar_Gui_MultiItemChooserTable_resetPanel");
        resetPanel.setAttribute("id", OpenLayers.Util.createUniqueID("mict_resetPanel"));

        var lbl = "";
        var id = OpenLayers.Util.createUniqueID("mict_reset_icon");
        this.resetElement = new oscar.Gui.ClickableLabel(lbl, {
            style : "block",
            ref : id
        });
        this.resetElement.events.on({
            "labelClicked" : this.resetTable,
            scope : this
        });
        this.resetElement.applyClass("oscar_Gui_MultiItemChooserTable_resetTable_disabled");
        var tooltipValue = oscar.i18n("mict_reset_icon");
        this.resetElement.setTooltip(tooltipValue);

        // Append element to the panel
        this.resetElement.appendTo(resetPanel);
        this.autoCompletePanel.appendChild(resetPanel);
    },

    /**
     * Method: buildCheckAll
     * 
     * Builds a checkbox and a label that will check all the elements.
     */
    buildCheckAll : function() {

        // Create the div container for the checkAll checkbox
        var checkAllPanel = document.createElement('div');
        checkAllPanel.setAttribute("class", "oscar_Gui_MultiItemChooserTable_checkAll_Panel");
        checkAllPanel.setAttribute("id", OpenLayers.Util.createUniqueID("mict_checkAll_Panel"));

        var lbl = "";
        var id = OpenLayers.Util.createUniqueID("mict_checkAll_checkbox");
        this.checkAllElement = new oscar.Gui.ClickableLabel(lbl, {
            style : "block",
            ref : id
        });
        this.checkAllElement.events.on({
            "labelClicked" : this.toggleAllCheckBoxes,
            scope : this
        });
        this.checkAllElement.appendTo(checkAllPanel);

        // Create label element
        var checkAllLabel = document.createElement("label");
        checkAllLabel.setAttribute("class", "oscar_Gui_MultiItemChooserTable_checkAll_label");
        checkAllLabel.setAttribute("id", OpenLayers.Util.createUniqueID("mict_checkAll_label"));
        checkAllLabel.setAttribute("for", "autoCompleteInputBox"); // assign to
        // checkbox.
        checkAllLabel.innerHTML = oscar.i18n("mict_checkAll_label");

        // Append element to the panel
        checkAllPanel.appendChild(checkAllLabel);

        // Append the objects to the this.container main div object.
        $(this.container).appendChild(checkAllPanel);
    },

    /**
     * Method: toggleAllCheckBoxes Checks or unchecks all the elements inside
     * the data table.
     * 
     * Parameters: obj - {<oscar.Gui.ClickableLabel>}
     */
    toggleAllCheckBoxes : function(obj) {

        // Verify if the checkbox is checked or not, then set the image
        // accordingly.
        var boolChecked = this.checkAllElement.count % 2;

        // Loop through the records and add them to an array to set the selected
        // items.
        var selectedItems = new Array();
        records = this.DataTable.getRecordSet().getRecords();
        for (i = 0; i < records.length; i++) {
            this.DataTable.getRecordSet().updateKey(records[i], "check", boolChecked);
            selectedItems.push(records[i].getData(this.getCheckboxCol()));
        }

        // This sets the selected items on the MultiItemChooserTable
        if (boolChecked) {
            this.setCheckAllImage("All");
            this.setItemsSelections(selectedItems);

        } else {
            this.setCheckAllImage("None");
            this.setItemsSelections([]);
        }

        this.DataTable.refreshView();
        this.events.triggerEvent("clicked", this.ItemsSelections);
        return false;
    },

    /**
     * APIMethod: setCheckAllImage Sets the CSS (Class) on the 'Select All'
     * Image Checkbox.
     * 
     * Parameters: {className} - the state of the "Checkbox" ['All', 'None',
     * 'Partial'] if left blank, the method will determine the state from the
     * DataTable.
     */
    setCheckAllImage : function(className) {

        if (className == null) {
            var className = "";
            var state = this.isAllCheckboxesSelected()
            if (state == 0) {
                className = "None";
            } else if (state == 1) {
                className = "All";
            } else {
                className = "Partial";
            }
            ;
        }

        // If the state is set to None, reset the counter in the ClickableLabel
        // object.
        if (className.toLowerCase() == "none") {
            this.checkAllElement.reset();
        }

        this.checkAllElement.removeClass("oscar_Gui_MultiItemChooserTable_checkAll" + " oscar_Gui_MultiItemChooserTable_checkAll_none" + " oscar_Gui_MultiItemChooserTable_checkAll_partial oscar_Gui_MultiItemChooserTable_checkAll_all");
        this.checkAllElement.applyClass("oscar_Gui_MultiItemChooserTable_checkAll " + "oscar_Gui_MultiItemChooserTable_checkAll_" + className.toLowerCase());
    },

    /**
     * APIMethod: isAllCheckboxesSelected
     * 
     * Verifies that all the checkboxes are selected so that we can set the
     * 'CheckAll' checkbox to a partial selection.
     * 
     * Returns: 0 - {Number} No items are selected. 1 - {Number} All items are
     * selected. -1 - {Number} Some items are selected.
     */
    isAllCheckboxesSelected : function() {

        var countSelected = 0;
        var records = this.DataTable.getRecordSet().getRecords();

        for (i = 0; i < records.length; i++) {
            // verify each individual input check box for selection
            if (records[i].getData().check) {
                countSelected++;
            }
        }

        if (countSelected == 0) {
            // no items selected.
            return 0;
        } else if (countSelected == records.length) {
            // all items selected
            return 1;
        } else {
            // some of the items are selected
            return -1;
        }
        ;
    },

    /**
     * Method: buildPaginator
     * 
     * Builds the paginator at the bottom of the data table. Needs to be created
     * and passed into the data table constructor.
     */
    buildPaginator : function() {
        // Create the div container for the paginator
        this.paginatorPanel = document.createElement('div');
        this.paginatorPanel.id = OpenLayers.Util.createUniqueID("mict_paginatorPanel");
        this.paginatorPanel.setAttribute("class", "oscar_Gui_MultiItemChooserTable_paginatorPanel");

        // paginator
        this.paginator = new YAHOO.widget.Paginator({
            rowsPerPage : this.rowsPerPage,
            pageLinks : this.numPageLinks,
            containers : this.paginatorPanel,
            firstPageLinkLabel : oscar.i18n("first"),
            lastPageLinkLabel : oscar.i18n("last"),
            previousPageLinkLabel : oscar.i18n("previous"),
            nextPageLinkLabel : oscar.i18n("next"),
            alwaysVisible : false
        });
    },

    /**
     * Method: buildTableChooser
     * 
     * Constructs the data table.
     */
    buildTableChooser : function() {
        // Create the div container for the table chooser
        var tableChooserPanel = document.createElement('div');
        tableChooserPanel.id = OpenLayers.Util.createUniqueID("tableChooser");
        tableChooserPanel.setAttribute("class", "oscar_Gui_MultiItemChooserTable_multiItemChooserTable");

        this.dataTableConfig.paginator = this.paginator;

        // Create the SRSs data table.
        var ctx = this;
        this.DataTable = new YAHOO.widget.DataTable(tableChooserPanel, this.columnDefs, this.DataSource, this.dataTableConfig);
        this.DataTable.subscribe("rowMouseoverEvent", this.DataTable.onEventHighlightRow);
        this.DataTable.subscribe("rowMouseoutEvent", this.DataTable.onEventUnhighlightRow);
        this.DataTable.subscribe("rowClickEvent", this.DataTable.onEventSelectRow);

        // Append this object to the this.container main div object.
        $(this.container).appendChild(tableChooserPanel);

        // Append this object to the this.container main div object.
        $(this.container).appendChild(this.paginatorPanel);

        // Catch checkbox event, add checked row to array, remove unchecked row
        // from array
        this.DataTable.subscribe('checkboxClickEvent', function(e) {
            var recordSet = this.getRecordSet();
            var checkboxClicked = e.target;
            var currentRow = this.getRecord(checkboxClicked);
            currentRow.setData("check", checkboxClicked.checked);
            var currColumn = this.getColumn(checkboxClicked);
            var newItem = currentRow.getData(ctx.getCheckboxCol())
            if (checkboxClicked.checked) {
                ctx.ItemsSelections.push(newItem);
            } else {
                for (var k = ctx.ItemsSelections.length - 1; k > -1; k--) {
                    if (ctx.compareObj(ctx.ItemsSelections[k], newItem)) {
                        ctx.ItemsSelections.splice(k, 1);
                    }
                }
                ;
            }
            ;

            ctx.events.triggerEvent("clicked", ctx.ItemsSelections);

            // if the user modified the table selections, enable the resetTable
            // button.
            if (ctx.resetButtonDisplay) {
                ctx.enableResetButton();
            }

            if (ctx.checkAllDisplay) {
                ctx.setCheckAllImage();
            }

            if (ctx.sortOnCheck) {
                this.sortColumn(currColumn, "yui-dt-desc");
            }
        });

        this.DataTable.subscribe('radioClickEvent', function(e) {
            var recordSet = this.getRecordSet();
            var checkboxClicked = e.target;
            var currentRow = this.getRecord(checkboxClicked);
            currentRow.setData("check", checkboxClicked.checked);
            var currColumn = this.getColumn(checkboxClicked);
            var newItem = currentRow.getData(ctx.getCheckboxCol())
            if (checkboxClicked.checked) {
                ctx.ItemsSelections = [ newItem ];
            }
            ctx.events.triggerEvent("clicked", ctx.ItemsSelections);
        });
    },

    /**
     * Method: setCheckboxes
     * 
     * Set the checkboxes in the data table. If a Item is in the
     * ItemsSelections, set its checkbox to true. Otherwise, set its checkbox to
     * false.
     */
    setCheckboxes : function() {
        var records = this.DataTable.getRecordSet().getRecords();
        // initialize the checkboxes
        for (var k = 0; k < records.length; k++) {
            records[k].setData("check", false);
        }
        // set the selected checkboxes
        var selectedItem;
        var curItem;
        for (var i = 0; i < this.ItemsSelections.length; i++) {
            selectedItem = this.ItemsSelections[i];
            for (var k = 0; k < records.length; k++) {
                curItem = records[k].getData(this.getCheckboxCol());
                if (this.compareObj(selectedItem, curItem)) {
                    records[k].setData("check", true);
                    continue;
                }
            }
        }
        this.DataTable.render();
    },

    /**
     * Method: compareObj
     * 
     * Does a strict compare on two objects. Returns true if objects are
     * identical.
     * 
     * Parameters: obj1 - {Object} obj2 - {Object}
     */
    compareObj : function(obj1, obj2) {
        if (obj1 === obj2.toString()) {
            return true
        }
        return false;

    },

    /**
     * Method: getCheckboxCol
     * 
     * Get the check box column name in the data table.
     */
    getCheckboxCol : function() {
        var cols = this.columnDefs;
        for (var i = 0; i < cols.length; i++) {
            if (cols[i].isCheckboxCol) {
                return cols[i].key;
            }
        }
    },

    /**
     * Method: checkboxSortFunction Custom sorting function for comparing two
     * SRS checkboxes.
     * 
     * Parameters: a - {Object} First sort argument. b - {Object} Second sort
     * argument. desc - {Boolean} True if sort direction is descending, false if
     * sort direction is ascending. field - the field to compare.
     * 
     * Returns: {Number}
     */
    checkboxSortFunction : function(a, b, desc, field) {
        var checkboxCompare = YAHOO.util.Sort.compare;

        var sorted = checkboxCompare(a.getData(field), b.getData(field), desc);
        if (sorted === 0) {
            // overided here by reversing a and b so that two SRSs are in the
            // correct order
            // if they are both selected or unselected.
            return checkboxCompare(b.getCount(), a.getCount(), desc);
        } else {
            return sorted;
        }
    },

    /**
     * Method: getItems Queries the server for the Items and populates the
     * table.
     * 
     * Parameters: query - {String} the request parameter.
     * 
     */
    getItems : function(query) {
        var ctx = this;
        var filterCallBack = function(sRequest, oResponse, oPayload) {
            ctx.DataTable.onDataReturnReplaceRows(sRequest, oResponse, oPayload);
            ctx.setCheckboxes();
            var col = ctx.DataTable.getColumn("check");
            ctx.DataTable.sortColumn(col, "yui-dt-desc");
            ctx.paginator.set("totalRecords", ctx.DataTable.getRecordSet().getRecords().length);
            if (ctx.checkAllDisplay) {
                ctx.setCheckAllImage();
            }

        };

        var source = "";
        var parameters = {};
        parameters[this.requestParameter] = query;

        var paramString = OpenLayers.Util.getParameterString(parameters);

        if (paramString.length > 0) {
            var separator = (this.DataSource.liveData.indexOf('?') > -1) ? '&' : '?';
            source = separator + paramString;
        }

        this.DataSource.sendRequest(source, filterCallBack, this.DataTable);
    },

    /**
     * Method: clearFilter
     * 
     * clears the autocompare inputbox
     */
    clearFilter : function(e) {
        if (this.clearFilterElement.container.className == "oscar_Gui_MultiItemChooserTable_clearFilter") {
            this.inputBoxElement.value = oscar.i18n("mict_autocomplete_label");
            oscar.jQuery(this.inputBoxElement).addClass("mict_input_inactive");
            this.getItems("");
            // return the icon to the 'disabled' grey
            this.clearFilterElement.removeClass("oscar_Gui_MultiItemChooserTable_clearFilter");
            this.clearFilterElement.applyClass("oscar_Gui_MultiItemChooserTable_clearFilter_disabled");
        }
    },

    /**
     * Method: resetTable
     * 
     * resets the table to its original selections.
     */
    resetTable : function(e) {
        if (this.resetElement.container.className == "oscar_Gui_MultiItemChooserTable_resetTable") {
            this.ItemsSelections = this.preSelectedItems.slice(0);
            this.getItems("");
            this.events.triggerEvent("resetClicked");
            // return the icon to the 'disabled' grey
            this.resetElement.removeClass("oscar_Gui_MultiItemChooserTable_resetTable");
            this.resetElement.applyClass("oscar_Gui_MultiItemChooserTable_resetTable_disabled");
        }
    },

    /**
     * APIMethod: getItemsSelections Gets the selected Items.
     * 
     * Returns: ItemsSelections - the array of the selected Items.
     */
    getItemsSelections : function() {
        return this.ItemsSelections;
    },

    /**
     * APIMethod: setItemsSelections
     * 
     * sets the items selections, could be used to clear the selections if you
     * pass in null.
     * 
     * Parameters: selections - {Array} Array of the selected items.
     */
    setItemsSelections : function(selections) {
        this.ItemsSelections = selections;
    },

    /**
     * APIMethod: destroy Destroys the DataTable and clears the innerHTML of the
     * container.
     */
    destroy : function() {
        this.DataTable.destroy();
        $(this.container).innerHTML = "";
    },

    /**
     * APIMethod: enableResetButton Enables the reset button, changes the style.
     */
    enableResetButton : function() {
        this.resetElement.removeClass("oscar_Gui_MultiItemChooserTable_resetTable_disabled");
        this.resetElement.applyClass("oscar_Gui_MultiItemChooserTable_resetTable");
    },

    /**
     * Constant: CLASS_NAME - oscar.Gui.MultiItemChooserTable
     */
    CLASS_NAME : "oscar.Gui.MultiItemChooserTable"
});
/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Gui.MultiCoordinateSystemsChooser
 * 
 * The multiple coordinate systems chooser allows the user to choose more than
 * one coordinate systems at a time. It lists all the available coordinate
 * systems in a paginated table and use a checkbox to show the
 * selected/unselected state for each coordinate system. The selected coordinate
 * systems will move to the top of the table automatically. The chooser also has
 * an autocomplete input field that can narrow down the list by searching the
 * coordinate systems against their code and description. A reset button is
 * provided to restore the pre-selected coordinate systems when constructing the
 * chooser.
 * 
 * Inherits from: - <oscar.Gui.MultiItemChooserTable>
 * 
 * @deprecated
 * 
 */
oscar.Gui.MultiCoordinateSystemsChooser = oscar.BaseClass(oscar.Gui.MultiItemChooserTable, {

    /**
     * Constructor: oscar.Gui.MultiCoordinateSystemChooser
     * 
     * Parameters: div - {String} The tag id that the multiItemChooserTable will
     * be attached to. preSelectedItemsIn - {Array(String)} The items that will
     * be selected by default. DataSourceIn - {YAHOO.util.XHRDataSource} The
     * data source the SRSs come from. codeFieldKeyIn - {String} the key of the
     * code field in resultList returned by the data source.
     * descriptionFieldKeyIn - {String} the key of the description field in
     * resultList returned by the data source. requestParameter - {String}
     * parameters of the request.
     */
    initialize : function(div, preSelectedItemsIn, DataSourceIn, codeFieldKeyIn, descriptionFieldKeyIn, requestParameter) {
        oscar.Gui.MultiItemChooserTable.prototype.initialize.apply(this, [ div, preSelectedItemsIn, DataSourceIn, {
            scrollable : false,
            width : "700px",
            height : "200px",
            initialRequest : '?' + requestParameter + '' + '&IECachePatch' + new Date().getTime(),
            paginator : null,
            selectionMode : "standard"
        }, [ {
            key : "check",
            label : " ",
            sortable : true,
            sortOptions : {
                sortFunction : this.checkboxSortFunction
            },
            formatter : "checkbox",
            width : 30
        }, {
            key : codeFieldKeyIn,
            label : oscar.i18n("srsCodeColumnLabel"),
            sortable : false,
            isCheckboxCol : true,
            width : 150
        }, {
            key : descriptionFieldKeyIn,
            label : oscar.i18n("srsDescriptionColumnLabel"),
            sortable : false,
            width : 480
        } ], requestParameter, {
            checkAllDisplay : false,
            numPageLinks : 10
        }, ]);
        // load the selected SRSs
        this.getItems("");
    },

    /**
     * Method: getSRSsSelections Returns the items selected.
     * 
     * returns: {Array} Array for selected coordinate systems.
     * 
     */
    getSRSsSelections : function() {
        return this.getItemsSelections();
    },

    /**
     * Constant: CLASS_NAME - oscar.Gui.MultiCoordinateSystemsChooser
     */
    CLASS_NAME : "oscar.Gui.MultiCoordinateSystemsChooser"
});
/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Gui.MultiDataExtractionChooser
 * 
 * The Oscar MultiDataExtractionChooser widget.
 * 
 * Inherits from: - <oscar.Gui.MultiItemChooserTable>
 * 
 * @deprecated
 */
oscar.Gui.MultiDataExtractionChooser = oscar.BaseClass({

    /**
     * Property: clearSelections {Boolean} flag to reset the checkboxes when
     * user selects another data connection.
     */
    clearSelections : true,

    /**
     * Constructor: oscar.Gui.MultiDataExtractionChooser
     * 
     * Parameters: div - {String} The tag id that the multiItemChooserTable
     * filter is attached to. mdec_type - {String} whether it's a WCS or a WFS,
     * helps in determining what to put in the header of the data table.
     * preSelectedItemsIn - {Array(String)} The items that will be selected by
     * default. extractionConnections - {Array(Object)} The data connections
     * that will be used to create the radio button list. DataSourceIn -
     * {YAHOO.util.XHRDataSource} The data source the SRSs come from.
     * idFieldKeyIn - {String} the key of the id field in resultList returned by
     * the data source. titleFieldKeyIn - {String} the key of the description
     * field in resultList returned by the data source. requestParameter -
     * {String} The request parameter used in the getItems method.
     */
    initialize : function(div, mdec_type, preSelectedItemsIn, extractionConnections, DataSourceIn, idFieldKeyIn, titleFieldKeyIn, requestParameter) {

        this.preSelectedItemsIn = preSelectedItemsIn;
        this.DataSourceIn = DataSourceIn;
        this.requestParameter = requestParameter;

        if (div) {
            this.container = div;
        } else {
            var globalDiv = document.createElement("div");
            globalDiv.setAttribute("id", OpenLayers.Util.createUniqueID("MultiDataExtractionChooser"));
            this.container = globalDiv;
        }

        if (mdec_type.toLowerCase() == "wcs") {
            titleHeaderText = oscar.i18n("mdec_coverage_type");
        } else {
            titleHeaderText = oscar.i18n("mdec_feature_type");
        }

        this.columnDefs = [ {
            key : "check",
            label : "",
            sortable : true,
            sortOptions : {
                sortFunction : this.checkboxSortFunction
            },
            formatter : "checkbox",
            width : 30
        }, {
            key : idFieldKeyIn,
            label : "Id",
            sortable : false,
            hidden : true,
            isCheckboxCol : true,
            width : 50
        }, {
            key : titleFieldKeyIn,
            label : titleHeaderText,
            sortable : false,
            width : 300
        } ];

        if (extractionConnections.length > 0) {
            this.buildDataConnList(extractionConnections);
            this.buildMultiItemChooserTable();
        } else {
            return null;
        }

    },

    /**
     * Method : setDatasource Sets the data source of the data table. Used when
     * querying to populate it.
     * 
     * Parameters: datasource - {YAHOO.util.XHRDataSource} the data source
     * object.
     */
    setDatasource : function(datasource) {
        this.mict.DataSource = datasource;
    },

    /**
     * Method: buildDataConnList
     * 
     * Build a list of data connections with radio buttons. This method builds
     * the left hand side of the data extraction widget.
     * 
     * Parameters: extractionConnections - {Array(Object)} Array of objects.
     * Each object contains a pair of id and name of an extraction connection.
     */
    buildDataConnList : function(extractionConnections) {

        var ctx = this;
        var selectedRadioButton = null;

        // Create the div container for the radio button group
        var radioButtonPanel = document.createElement('div');
        oscar.jQuery(radioButtonPanel).addClass(this.CLASS_NAME.replace(/\./g, "_") + "_radioPanel");
        radioButtonPanel.setAttribute("id", OpenLayers.Util.createUniqueID("mdec_radioPanel"));

        // Create the div container for the data connection element
        var dataConnectionItem = document.createElement('div');
        oscar.jQuery(dataConnectionItem).addClass(this.CLASS_NAME.replace(/\./g, "_") + "_dataConnItem");
        dataConnectionItem.setAttribute("id", OpenLayers.Util.createUniqueID("mdec_dataConnItem"));

        // Create a name for the radio button group. The name must be different
        // between the WFS and WCS
        // radio button groupings, but the same for the 'None' and data
        // connection options.
        radioButtonGroupName = OpenLayers.Util.createUniqueID("extractionConnections");

        // Build a radio button for the none option.
        var noneLabel = document.createElement("label");
        noneLabel.innerHTML = oscar.i18n("mdec_data_connection_none");
        noneLabel.setAttribute("class", "oscar_Gui_MultiDataExtractionTable_dataConnection_label");

        // IE7 Hack, must do a try catch and create the radio with the name
        // attribute intact.
        try {
            radioDataConnection = document.createElement('<input type="radio" name="' + radioButtonGroupName + '" />');
        } catch (err) {
            radioDataConnection = document.createElement('input');
            radioDataConnection.setAttribute("type", "radio");
            radioDataConnection.setAttribute("name", radioButtonGroupName);
        }
        radioDataConnection.setAttribute("id", OpenLayers.Util.createUniqueID("mdec_dataextraction_radiobuttton"));
        radioDataConnection.setAttribute("class", "oscar_Gui_MultiDataExtractionTable_dataConnection_radio");
        radioDataConnection.setAttribute("value", "None");
        radioDataConnection.setAttribute("dataConnName", "None"); // replace
        // with
        // translated
        // text.
        dataConnectionItem.appendChild(radioDataConnection);
        dataConnectionItem.appendChild(noneLabel);
        radioButtonPanel.appendChild(dataConnectionItem);

        // Bind events to radio button
        var context = {
            radioButtonElements : radioDataConnection,
            ctx : this
        }

        // The Mouse click events for the radio buttons.
        var e = null;
        if (document.createEvent) {
            e = document.createEvent("MouseEvents"); // Good Browsers
            e.initMouseEvent("click", true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
            radioDataConnection.dispatchEvent(e);
        } else if (document.createEventObject) {
            e = document.createEventObject("MouseEvents"); // IE Hack
            e.button = 1; // left button is down
            radioDataConnection.fireEvent('onclick', e);
        } else {
            return // Other browsers do nothing
        }

        var click = function(obj) {
            return function(e) {
                ctx.changeExtractionContents(obj);
            };
        }

        radioDataConnection.onclick = click({
            radioButtonElements : radioDataConnection,
            ctx : this
        });

        // build list of radio buttons with arrayList of data connections from
        // viewer config.
        for (var i = 0; i < extractionConnections.length; i++) {

            // Create Div and Label for the data connection panel
            var dataConnectionLabel = document.createElement('label');
            dataConnectionLabel.innerHTML = oscar.i18n("mdec_data_connections");
            oscar.jQuery(dataConnectionLabel).addClass(this.CLASS_NAME.replace(/\./g, "_") + "_dataConnLabel");
            dataConnectionItem.setAttribute("id", OpenLayers.Util.createUniqueID("mdec_dataConnLabel"));

            // Create the div container for the data connection element
            var dataConnectionItem = document.createElement('div');
            oscar.jQuery(dataConnectionItem).addClass(this.CLASS_NAME.replace(/\./g, "_") + "_dataConnItem");
            dataConnectionItem.setAttribute("id", OpenLayers.Util.createUniqueID("mdec_dataConnItem"));

            // IE7 Hack, must do a try catch and create the radio with the name
            // attribute intact.
            try {
                radioDataConnection = document.createElement('<input type="radio" name="' + radioButtonGroupName + '" />');
            } catch (err) {
                radioDataConnection = document.createElement('input');
                radioDataConnection.setAttribute("type", "radio");
                radioDataConnection.setAttribute("name", radioButtonGroupName);
            }
            radioDataConnection.setAttribute("id", OpenLayers.Util.createUniqueID("mdec_dataextraction_radiobuttton"));
            radioDataConnection.setAttribute("class", "oscar_Gui_MultiDataExtractionTable_dataConnection_radio");
            radioDataConnection.setAttribute("value", extractionConnections[i].id);
            radioDataConnection.setAttribute("dataConnName", extractionConnections[i].name);
            var newLabel = document.createElement("label");
            newLabel.innerHTML = extractionConnections[i].name;
            newLabel.setAttribute("class", "oscar_Gui_MultiDataExtractionTable_dataConnection_label");
            dataConnectionItem.appendChild(radioDataConnection);
            dataConnectionItem.appendChild(newLabel);
            radioButtonPanel.appendChild(dataConnectionItem);

            // Bind events to radio button
            var context = {
                radioButtonElements : radioDataConnection,
                ctx : ctx
            }

            // The Mouse click events for the radio buttons.
            var e = null;
            if (document.createEvent) {
                e = document.createEvent("MouseEvents"); // Good Browsers
                e.initMouseEvent("click", true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
                radioDataConnection.dispatchEvent(e);
            } else if (document.createEventObject) {
                e = document.createEventObject("MouseEvents"); // IE Hack
                e.button = 1; // left button is down
                radioDataConnection.fireEvent('onclick', e);
            } else {
                return // Other browsers do nothing
            }

            var click = function(obj) {
                return function(e) {
                    ctx.changeExtractionContents(obj);
                };
            }

            radioDataConnection.onclick = click({
                radioButtonElements : radioDataConnection,
                ctx : this
            });
        }

        // append the div to the page container
        $(this.container).appendChild(dataConnectionLabel);
        $(this.container).appendChild(radioButtonPanel);
    },

    /**
     * Method: buildMultiItemChooserTable
     * 
     * Created the DataTable part of the MultiDataExtractionChooser.
     */
    buildMultiItemChooserTable : function() {

        // Create Div and Label for the data connection panel
        var mictPanel = document.createElement('div');
        mictPanel.setAttribute("id", OpenLayers.Util.createUniqueID("mdec_multiDataItemChooser"));
        mictPanel.setAttribute("class", "oscar_Gui_MultiDataExtractionTable__MultiDataItemChooser");

        // append the container to the tab before we attach the
        // multiitemchoosertable to it.
        $(this.container).appendChild(mictPanel);

        this.mict = new oscar.Gui.MultiItemChooserTable(mictPanel.id, this.preSelectedItemsIn, this.DataSourceIn, {
            scrollable : false,
            width : "100%",
            height : "200px",
            initialRequest : '?' + this.requestParameter + '' + '&IECachePatch' + new Date().getTime(),
            paginator : null,
            selectionMode : "standard"
        }, this.columnDefs, this.requestParameter);

        // Event listener for the reset button click of the
        // MultiItemChooserTable
        this.mict.events.on({
            "resetClicked" : this.resetDataConnection,
            scope : this
        });
    },

    /**
     * APIMethod: setDefaultDataConnection Sets the default data connection.
     * This method is to be called after the DataExtraction widget is rendered.
     * 
     * Parameters: dataConnName - {String} name of a data connection.
     * radioElementName - {String} name of an radio button element to be
     * accessed.
     */
    setDefaultDataConnection : function(dataConnName, radioElementName) {
        // retrieve the array of radio buttons. IE7 Hack, when we don't support
        // IE7 anymore,
        // use getElementsbyName.
        var tag = "input";
        var dataConnRdoBtn = this.getElementsByName_iefix(tag, radioElementName);
        // Cycle through the array to find out which one is the selected
        for (var i = 0; i < dataConnRdoBtn.length; i++) {
            var dataConnectionNameAttribute = dataConnRdoBtn[i].getAttribute("dataConnName");
            if (dataConnectionNameAttribute == dataConnName) {
                // Retrieve the ID of the default radio button for the reset
                // method.
                this.defaultDataConnectionId = dataConnRdoBtn[i].getAttribute("Id");
                // IE 7 Hack
                dataConnRdoBtn[i].setAttribute("checked", true);
                dataConnRdoBtn[i].checked = "checked";
                dataConnRdoBtn[i].defaultChecked = true;
                this.clearSelections = false;
                dataConnRdoBtn[i].onclick();
            }
        }
    },

    /**
     * Method: getElementsByName_iefix Need this method because IE7 doesn't
     * support
     * 
     * @param tag
     * @param name
     * @returns {Array}
     */
    getElementsByName_iefix : function(tag, name) {

        var elem = document.getElementsByTagName(tag);
        var arr = new Array();
        for (i = 0, iarr = 0; i < elem.length; i++) {
            att = elem[i].getAttribute("name");
            if (att == name) {
                arr[iarr] = elem[i];
                iarr++;
            }
        }
        return arr;
    },

    /**
     * Method: getContainer Returns the div container of the extraction widget.
     * 
     * Returns: {Object} the div container.
     */
    getContainer : function() {
        return this.container;
    },

    /**
     * Method : changeExtractionContents Change the extraction contents for the
     * currently selected extraction connection. Removes any contents that were
     * selected using the previously selected connection (extraction contents
     * are limited to one connection per theme).
     * 
     * Parameters: context - {Object}
     */
    changeExtractionContents : function(context) {

        // loop though all the radio buttons to see which one is checked.
        var dataConnRdoBtn = document.getElementsByName(context.radioButtonElements.name);
        for (var i = 0; i < dataConnRdoBtn.length; i++) {
            if (dataConnRdoBtn[i].checked) {
                context.ctx.loadExtractionContents(context.radioButtonElements);
                break;
            }
        }
    },

    /**
     * Method: loadExtractionContents Loads the extraction contents for the
     * current WFS/WCS.
     * 
     * Parameters: selectedRadioButton - {Object} the selected radio button.
     */
    loadExtractionContents : function(selectedRadioButton) {

        try {
            this.contentsRequest(selectedRadioButton.value, selectedRadioButton.getAttribute("dataconnname"), this.mict.DataTable);
        } catch (err) {
        }
    },

    /**
     * Method: contentsRequest This method sends an AJAX request to the server
     * to get a data connection's contents.
     * 
     * Parameters: dataConnectionId - the id of the data connection.
     * dataConnectionName - The name of the data connection. YUIDataTable -
     * {YAHOO.widget.DataTable}
     */
    contentsRequest : function(dataConnectionId, dataConnectionName, YUIDataTable) {

        var fieldsDef = [];
        // Cycle through the column definitions and retrieve the keys.
        for (i = 0; i < this.columnDefs.length; i++) {
            fieldsDef.push("{key : \"" + this.columnDefs[i].key + "\"}");
        }

        var contentsDataSource = new YAHOO.util.XHRDataSource('themeAction_findDataConnContents.action?dataConnectionId=' + dataConnectionId);
        contentsDataSource.responseType = YAHOO.util.XHRDataSource.TYPE_JSON;
        contentsDataSource.connXhrMode = "queueRequests";
        contentsDataSource.responseSchema = {
            resultsList : "Response.Results",
            fields : [ {
                key : "check"
            }, {
                key : "id"
            }, {
                key : "title"
            } ]
        };

        // Added this flag check since we want to clear the selections when
        // somebody clicks on a different data connection.
        if (this.clearSelections != false) {
            this.setExtractionSelections([]);
            // Since we cleared the selections, change the checkAll image to
            // None Selected.
            this.mict.setCheckAllImage("None");
        } else {
            this.clearSelections = true;
        }

        // clear the layers from the YUI data table. *** replace with
        // onDataReturnReplaceRows
        YUIDataTable.getRecordSet().reset();
        YUIDataTable.render();
        var msg = this.mict.getDefaultTableConfiguration()["MSG_LOADING"];
        YUIDataTable.showTableMessage(msg);

        if (this != null) {
            this.setDatasource(contentsDataSource);
            this.mict.getItems("");
        }
    },

    /**
     * Method: getExtractionSelections Returns the items selected.
     * 
     * Returns: {Array} the items selected.
     */
    getExtractionSelections : function() {
        return this.mict.getItemsSelections();
    },

    /**
     * Method: setExtractionSelections
     * 
     * Parameters: selections - {Array} extraction selections.
     */
    setExtractionSelections : function(selections) {
        this.mict.setItemsSelections(selections);
    },

    /**
     * Method: getRadioButtonsArrayName Returns the radio button group name.
     * 
     * Returns: {String} name attribute of HTML input element.
     */
    getRadioButtonsNameAttribute : function() {
        return radioDataConnection.getAttribute("name");
    },

    /**
     * Method: resetDataConnection resets the data connection to its original
     * selection.
     */
    resetDataConnection : function(e) {
        var defaultDataConnection = document.getElementById(this.defaultDataConnectionId);
        defaultDataConnection.checked = true;
        this.clearSelections = false;
        defaultDataConnection.onclick();
    },

    /**
     * Constant: CLASS_NAME - oscar.Gui.MultiDataExtractionChooser
     */
    CLASS_NAME : "oscar.Gui.MultiDataExtractionChooser"
});
/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Gui.Grid
 * 
 * This *oscar.Gui.Grid* widget is designed to hold a tabView display which has
 * the information of selected features as its content.
 * 
 * @deprecated
 * 
 */
oscar.Gui.Grid = oscar.BaseClass({
    /**
     * APIProperty: processor {<oscar.Handler>} The handler object which
     * executes the action and returns the requested information. The value of
     * this object can be set via the constructor's *options* argument.
     */
    processor : null,
    /**
     * APIProperty: doDialog
     * 
     * {Boolean} Indicates whether or not to display the grid in a dialog.
     */
    doDialog : false,
    /**
     * APIProperty: div
     * 
     * {String} The id of the div tag to display the grid in.
     */
    div : "selResults",
    /**
     * Property: tab
     */
    tab : null,
    /**
     * APIProperty: features
     * 
     * {Array(Array(<OpenLayers.Feature>))} The two dimensional array of
     * feature objects passed in either by the processor or user manually.
     */
    features : null,
    /**
     * APIProperty: tabView
     * 
     * {YAHOO.widget.TabView} The YUI TabView control element.
     */
    tabView : null,
    /**
     * APIProperty: map
     * 
     * {oscar.Map} The reference to the map object.
     */
    map : null,
    /**
     * APIProperty: tables
     * 
     * {Object} An object referencing the tables for features
     */
    tables : null,
    /**
     * APIProperty: featureCtrl {<OpenLayers.Control.SelectFeature>} Reference
     * to an OpenLayers.Control.SelectFeature control.
     */
    featureCtrl : null,
    /**
     * APIProperty: featureLayer {<OpenLayers.Layer.Vector>} Reference to an
     * OpenLayers.Layer.Vector layer for displaying features.
     */
    featureLayer : null,
    /**
     * Constructor: oscar.Gui.Grid
     * 
     * Parameters: options - {Object} An optional object whose properties will
     * be set on this instance.
     */
    initialize : function(options) {
        this.tables = {};
        OpenLayers.Util.extend(this, options);
        this.EVENT_TYPES = [ 'gridready', 'clean' ];
        this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES, false, {
            includeXY : true
        });
        if (this.processor) {
            this.processor.events.on({
                'complete' : this.processResults,
                scope : this
            });
            this.processor.events.on({
                'clean' : this.clean,
                scope : this
            });
        }

        if (!document.getElementById(this.div)) {
            var t = document.createElement('div');
            t.id = this.div;
            document.body.appendChild(t);
        }
        this.buildTabLayout();

    },
    /**
     * APIMethod: processResults
     * 
     * This method is used to process the results returned by the processor
     * object.
     * 
     * Parameters: results - {Object} An object that contains the information to
     * be processed. It may have the following format: (start code) results = {
     * map : oscar.Map, // A reference to an oscar.Map object; features :
     * this.features, // A reference to an {Array(Array(<OpenLayers.Feature>))}
     * object; object : this.processor // A reference to handler object; } (end
     * code) This *results* parameter can be passed in by user or returned by
     * the processor object.
     */
    processResults : function(layer) {
        this.map = layer.map;
        this.layer = layer;
        var feats = layer.features;
        this.features = {};

        for (var i = 0; i < feats.length; i++) {
            var feature = feats[i];
            if (this.features[feature.type] == null) {
                this.features[feature.type] = [];
            }
            this.features[feature.type].push(feature);
        }
        this.showGrid();

    },

    /**
     * APIMethod: showGrid
     * 
     * Displays the features in a TabView grid.
     */
    showGrid : function() {
        this.tabView = new YAHOO.widget.TabView(this.tab.id);
        for ( var prop in this.features) {
            var obj = this.features[prop];
            if (obj.length == 0)
                continue;
            var tab = this._addTab(prop);
            this._buildTable(tab, prop, obj);
        }
        oscar.jQuery('#' + this.div).addClass("yui-skin-sam");
        if (this.doDialog) {
            this.dlg = oscar.jQuery("#" + this.div).dialog({
                title : oscar.i18n('Features'),
                width : 640,
                height : 480,
                resizable : true,
                position : [ 'left', 'bottom' ]
            });
        }
        this.tabView.selectTab(0);
        this.events.triggerEvent("gridready", this.layer);
    },
    /**
     * APIMethod: buildTabLayout
     * 
     * Creates the elements to contain the tabs and places them in the DOM.
     * 
     */
    buildTabLayout : function() {
        this.tab = document.createElement("div");
        this.tab.id = "tabs";
        $(this.div).appendChild(this.tab);
    },
    /**
     * APIMethod: buildTable Builds the tables to show the feature information.
     * 
     * Parameters: div - {HTMLElement} a div HTMLElement. key - {String} The
     * *key* String of a feature object. features - {Array({<OpenLayers.Feature.Vector>})}
     * an Array of OpenLayers.Feature.Vector objects.
     */
    buildTable : function(div, key, features) {
        oscar.jQuery(div).addClass("wfsGrid");
        var headers = this._getFeatureHeaders(features[0]);
        var colDefs = [];
        for (var i = 0; i < headers.length; i++) {
            colDefs.push({
                key : headers[i],
                sortable : true
            });
        }
        var dsArray = [];
        for (var i = 0; i < features.length; i++) {
            var obj = features[i].attributes;
            obj.fid = features[i].fid;
            obj.key = key;
            dsArray.push(obj);
        }
        var ds = new YAHOO.util.DataSource(dsArray);
        ds.responseType = YAHOO.util.DataSource.TYPE_JSARRAY;
        ds.responseSchema = {
            fields : headers
        };
        var dt = new YAHOO.widget.DataTable(div, colDefs, ds);
        var fn = function(event) {
            features = this.features;
            var getGrid = function(key) {
                for (var i = 0; i < features.length; i++) {
                    var grid = features[i];
                    if (grid.key == key)
                        return grid.features;
                }
            };
            var getFeat = function(fid, grid) {
                for (var i = 0; i < grid.length; i++) {
                    if (fid == grid[i].fid)
                        return grid[i];
                }
            }
            var activeTab = this.tabView._configs.activeTab.value._configs.label.value;
            var fid = dt.getRecord(event.target).getData('fid');
            var feat = getFeat(fid, this.features[activeTab]);
            var selectFeature = this.map.getControlsByClass("oscar.Control.SelectFeature")[0];
            selectFeature.ctrl.unselectAll();
            selectFeature.ctrl.select(feat);

        }
        dt.hideColumn("fid");

        dt.subscribe('rowMouseoverEvent', dt.onEventHighlightRow);
        dt.subscribe('rowMouseoutEvent', dt.onEventUnhighlightRow);
        dt.subscribe('rowClickEvent', dt.onEventSelectRow);
        dt.subscribe('rowClickEvent', fn, this, this);
        this.tables[key] = {
            dt : dt
        };

    },
    /**
     * APIMethod: clean
     * 
     * Clears the selection result features on the map and the grid.
     */
    clean : function() {
        if (!this.tabView)
            return;
        while (this.tabView._configs.tabs.value.length != 0) {
            this.tabView.removeTab(this.tabView.getTab(0));
        }
        if (this.map != null) {
            this.map.removeLayer(this.layer);
            this.layer = null;
            this.map = null;
        }
        if (this.dlg) {
            oscar.jQuery(this.dlg).dialog("destroy");
        }
        this.events.triggerEvent("clean");
    },
    /**
     * APIMethod: selectFeature
     * 
     * Called when a feature is selected. Creates the pop-up which is displayed
     * on screen.
     * 
     * Parameters: feature - {<OpenLayers.Feature.Vector>} an
     * OpenLayers.Feature.Vector object.
     */
    selectFeature : function(feature) {
        this._selectRow(feature);
        var returnHTML = "";
        returnHTML += "<TABLE>";
        for (attributeName in feature.attributes) {
            // fid is an OpenLayers attribute, key is an Oscar display attribute
            // don't bother showing them in the popup
            if (!(attributeName == "fid" || attributeName == "key")) {
                returnHTML += "<TR>";
                returnHTML += "<TD valign='top'>";
                returnHTML += "<span style='font-size:.75pc' class='entTitle'>" + attributeName + " : " + feature.attributes[attributeName] + "</span>";
                returnHTML += "</TD>";
                returnHTML += "</TR>";
            }
        }
        returnHTML += "</TABLE>";
        var popup = new oscar.FramedCloud("id", feature.geometry.getBounds().getCenterLonLat(), null, returnHTML, null, true);
        popup.autoSize = false;
        feature.popup = popup;
        this.map.addPopup(popup);
        var lonLat = feature.geometry.getBounds().getCenterLonLat();
        this.map.panTo(lonLat);

    },
    /**
     * APIMethod: unSelectFeature
     * 
     * Called when a feature is unselected. Removes the pop-up from the map.
     * 
     * Parameters: feature - {<OpenLayers.Feature.Vector>} an
     * OpenLayers.Feature.Vector object.
     */
    unSelectFeature : function(feature) {

        if (feature.popup == null)
            return;
        this.map.removePopup(feature.popup);
        feature.popup.destroy();
        feature.popup = null;
    },
    /**
     * APIMethod: _selectRow
     * 
     * Called when a row in a table is selected. Will attempt to select a
     * feature on the map.
     * 
     * Parameters: feature - {<OpenLayers.Feature.Vector>} an
     * OpenLayers.Feature.Vector object.
     * 
     */
    _selectRow : function(feature) {
        var name = feature.key;
        if (!name) {
            name = feature.attributes["key"];
        }
        if (feature.gml) {
            if (feature.gml.featureNSPrefix && feature.gml.featureType) {
                name = feature.gml.featureNSPrefix + ":" + feature.gml.featureType;
            }
        }
        var featureList = null;
        var tab = null;
        if (name.length > 1) {
            tab = this._findTab(name);
        }
        var dt = this.tables[name].dt;
        dt.unselectAllRows();
        var recordSet = dt.getRecordSet();
        var numRecords = recordSet.getLength();
        for (var i = 0; i < numRecords; i++) {
            var record = recordSet.getRecord(i);
            var fid = record.getData("fid");
            if (fid == feature.fid) {
                dt.selectRow(record);
                break;
            }

        }
    },
    /**
     * APIMethod: _getListByName
     * 
     * Retrieves the array of features contained in the features array by name
     * 
     * Parameters: name - name of the feature array.
     */
    _getListByName : function(name) {
        for (var i = 0; i < this.features.length; i++) {
            var list = this.features[i];
            if (list.key == name)
                return list;
        }
    },
    /**
     * APIMethod: _findTab
     * 
     * Retrieves the currently activated tab.
     * 
     * Parameters: name - {String} the label String of the tab.
     */
    _findTab : function(name) {
        for (var i = 0; i < this.features.length; i++) {
            var tab = this.tabView.getTab(i);
            if (tab._getLabel() == name) {
                this.tabView.selectTab(i);
                return tab;
            }

        }
    },
    /**
     * APIMethod: _addTab
     * 
     * Creates a tab in the TabView.
     * 
     * Parameters: lbl - {String} The *key* String of a feature object, and it
     * will be used as the label of a tab.
     * 
     * Returns: newTab - {<YAHOO.widget.Tab>} a new tab object.
     * 
     */
    _addTab : function(lbl) {
        var newTab = new YAHOO.widget.Tab({
            label : lbl
        });
        this.tabView.addTab(newTab);
        return newTab;

    },
    /**
     * APIMethod: _buildTable
     * 
     * Calls the buildTable method with the correct parameters.
     * 
     * Parameters: tab - {<YAHOO.widget.Tab>} a reference to a tab object. key -
     * {String} The *key* String of a feature object. features - {<OpenLayers.Feature.Vector>}
     * an Array of OpenLayers.Feature.Vector objects.
     */
    _buildTable : function(tab, key, features) {
        this.buildTable(tab._configs.contentEl.value, key, features);
    },
    /**
     * APIMethod:getFeatureHeaders
     * 
     * Loops through the feature to create an array of header names based off of
     * the attributes object.
     * 
     * Parameters: feature - {<OpenLayers.Feature.Vector>} an
     * OpenLayers.Feature.Vector object.
     */
    _getFeatureHeaders : function(feature) {
        var headers = [];
        for ( var attr in feature.attributes) {
            headers.push(attr);
        }
        headers.push("fid");
        return headers;

    },
    /**
     * Constant: CLASS_NAME - oscar.Gui.Grid
     */
    CLASS_NAME : 'oscar.Gui.Grid'
});

/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Gui.Metadata A panel to display metadata about a service.
 */
oscar.Gui.Metadata = oscar.BaseClass({
    /**
     * Property: div
     * 
     * Reference to the div container.
     */
    div : null,
    /**
     * APIProperty: servicePanel
     * 
     * {HTMLDivElement} Container for the service panel.
     */
    servicePanel : null,
    /**
     * APIProperty: metadataPanel
     * 
     * {HTMLDivElement} Container for the metadata panel.
     */
    metadataPanel : null,
    /**
     * Property: showUsed
     * 
     * {Boolean} Show only service contents in use, or all.
     */
    showUsed : true,
    /**
     * APIProperty: requestList
     * 
     * {Array} A list of requests that have been made.
     */
    requestList : null,
    /**
     * Property: theme {<oscar.ox.Theme>} A reference to a theme object.
     */
    theme : null,
    /**
     * Constructor: oscar.Gui.Metadata
     * 
     * Parameters: div - {HTMLDivElement} a HTMLDivElement object. theme - {<oscar.ox.Theme>}
     * an Oscar Theme object. options - {Object} An optional object whose
     * properties will be set on this instance.
     */
    initialize : function(div, theme, options) {
        this.requestList = [];
        if (options)
            OpenLayers.Util.extend(this, options);

        this.div = document.createElement('div');
        oscar.jQuery(this.div).addClass("metadataConstraint");
        this.servicePanel = document.createElement('div');
        this.metadataPanel = document.createElement('div');
        oscar.jQuery(this.servicePanel).addClass("Metadata_ServicePanel");
        oscar.jQuery(this.metadataPanel).addClass("Metadata_MetadataPanel");
        oscar.jQuery(this.metadataPanel).addClass("yui-skin-sam");
        this.div.appendChild(this.servicePanel);
        this.div.appendChild(this.metadataPanel);
        this.theme = theme;
        this.loadCapabilities();
    },
    /**
     * Method: getContainer
     * 
     * returns: {HTMLDivElement} the div container.
     */
    getContainer : function() {
        return this.div;
    },
    /**
     * Method: loadCapabilities Loads the capabilities of OGC services.
     * 
     */
    loadCapabilities : function() {
        this.requestList = [];

        for (var i = 0; i < this.theme.layers.length; i++) {
            var layer = this.theme.layers[i];
            if (layer.layerType == "WMS") {
                if (!this.isLoaded(layer.urls[0])) {
                    this.loadWMSCapabilities(layer.urls[0]);
                }
            }
            if (layer.layerType == "WMTS") {
                var url = layer.urls[0];
                url = url.split("/1.0.0")[0];
                if (!this.isLoaded(url)) {
                    this.loadWMTSCapabilities(url);
                }
            }
        }
        var service = null;
        var services = new Array();
        if ((service = this.theme.getSelectionService())) {
            services = services.concat(service);
        }
        if ((service = this.theme.getExtractionService())) {
            services = services.concat(service);
        }

        for (var i = 0; i < services.length; i++) {
            var serviceEntry = services[i];
            if (this.isLoaded(serviceEntry.url)) {
                continue
            }

            switch (serviceEntry.serviceType) {
            case "WCS":
                this.loadWCSCapabilities(serviceEntry.url);
                break;
            case "WFS":
                this.loadWFSCapabilities(serviceEntry.url, serviceEntry.version);
                break;

            }
        }
    },
    /**
     * APIMethod: isLoaded Checks to see if a URL has previously been loaded.
     * 
     * Parameters: url - {String} a URL String.
     * 
     * Returns: {Boolean} whether the URL is loaded.
     */
    isLoaded : function(url) {
        for (var i = 0; i < this.requestList.length; i++) {
            if (this.requestList[i] == url) {
                return true;
            }
        }
        this.requestList.push(url);
        return false;
    },
    /**
     * APIMethod: getLoadingDiv Builds a div element place holder to show
     * loading status
     * 
     * returns: {HTMLDivElement} a HTMLDivElement element.
     * 
     */
    getLoadingDiv : function() {
        var loadingDiv = document.createElement("div");
        oscar.jQuery(loadingDiv).addClass("md_loadingActive");
        this.servicePanel.appendChild(loadingDiv);
        return loadingDiv;
    },
    /**
     * APIMethod: loadWCSCapabilities Loads a WCS Capabilities document.
     * 
     * Parameters: url - {String} URL String of the WCS service.
     */
    loadWCSCapabilities : function(url) {
        var container = this.getLoadingDiv();
        var success = function(resp) {
            try {
                var reader = new oscar.Format.WCSCapabilities();
                var doc = resp.responseXML;
                var capabilities = reader.read(doc);
                oscar.jQuery(container).removeClass("md_loadingActive");
                this.renderService(container, capabilities);
            } catch (err) {
                fail();
            }
        };
        var fail = function(resp) {
            oscar.jQuery(container).removeClass("md_loadingActive");
            oscar.jQuery(container).addClass("md_loadingFailed");
            container.innerHTML = oscar.i18n("md_request_failed");
            container.innerHTML += "<br>Url: " + url;
        }
        var params = {
            service : "WCS",
            request : "GetCapabilities"
        };
        OpenLayers.Request.GET({
            url : url,
            params : params,
            success : success,
            fail : fail,
            scope : this
        });
    },
    /**
     * APIMethod: loadWMSCapabilities Loads a WMS Capabilities document
     * 
     * Parameters: url - {String} URL String of the WMS service.
     */
    loadWMSCapabilities : function(url) {
        var container = this.getLoadingDiv();
        var success = function(resp) {
            try {
                var reader = new OpenLayers.Format.WMSCapabilities();
                var doc = resp.responseXML;
                var capabilities = reader.read(doc);
                oscar.jQuery(container).removeClass("md_loadingActive");
                this.renderService(container, capabilities);
            } catch (err) {
                fail();
            }

        };
        var fail = function(resp) {
            oscar.jQuery(container).removeClass("md_loadingActive");
            oscar.jQuery(container).addClass("md_loadingFailed");
            container.innerHTML = oscar.i18n("md_request_failed");
            container.innerHTML += "<br>Url: " + url;
        }
        var params = {
            service : "WMS",
            request : "GetCapabilities"
        };
        OpenLayers.Request.GET({
            url : url,
            params : params,
            success : success,
            fail : fail,
            scope : this
        });
    },
    /**
     * APIMethod: loadWMTSCapabilities Loads a WMTS Capabilities document.
     * 
     * Parameters: url - {String} URL String of the WMTS service.
     */
    loadWMTSCapabilities : function(url) {
        var container = this.getLoadingDiv();
        var success = function(resp) {
            try {
                var reader = new oscar.Format.WMTSCapabilities();
                var doc = resp.responseXML;
                var capabilities = reader.read(doc);
                oscar.jQuery(container).removeClass("md_loadingActive");
                this.renderService(container, capabilities);
            } catch (err) {
                fail();
            }

        };
        var fail = function(resp) {
            oscar.jQuery(container).removeClass("md_loadingActive");
            oscar.jQuery(container).addClass("md_loadingFailed");
            container.innerHTML = oscar.i18n("md_request_failed");
            container.innerHTML += "<br>Url: " + url;
        }
        var params = {
            service : "WMTS",
            request : "GetCapabilities"
        };
        OpenLayers.Request.GET({
            url : url,
            params : params,
            success : success,
            fail : fail,
            scope : this
        });
    },
    /**
     * APIMethod: loadWFSCapabilities Loads a WFS Capabilities document.
     * 
     * Parameters: url - {String} URL String of the WFS service.
     */
    loadWFSCapabilities : function(url, version) {
        var container = this.getLoadingDiv();
        var success = function(resp) {
            try {
                var reader = new OpenLayers.Format.WFSCapabilities();
                var doc = resp.responseXML;
                var capabilities = reader.read(doc);
                oscar.jQuery(container).removeClass("md_loadingActive");
                this.renderService(container, capabilities);
            } catch (err) {
                console.log(err);
                fail();
            }

        };
        var fail = function(resp) {
            oscar.jQuery(container).removeClass("md_loadingActive");
            oscar.jQuery(container).addClass("md_loadingFailed");
            container.innerHTML = oscar.i18n("md_request_failed");
            container.innerHTML += "<br>Url: " + url;
        }
        var params = {
            service : "WFS",
            version : version,
            request : "GetCapabilities"
        };
        OpenLayers.Request.GET({
            url : url,
            params : params,
            success : success,
            fail : fail,
            scope : this
        });
    },
    /**
     * APIMethod: renderService Creates the panels to display service
     * information.
     * 
     * Parameters: panel - a HTMLDivElement container. capabilities - an Oscar
     * formatted capabilities document.
     */
    renderService : function(panel, capabilities) {
        var servicePanel = new oscar.Gui.ServicePanel(panel);
        servicePanel.setTitle(oscar.Util.Metadata.getServiceTitle(capabilities));
        servicePanel.appendServiceContents(this.buildServiceContent(capabilities));
        servicePanel.appendMetadataContent(this.buildServiceMetadata(capabilities));
    },
    /**
     * APIMethod: buildServiceMetadata Builds the panel for the service
     * metadata.
     * 
     * Parameters: capabilities - an Oscar formatted capabilities document.
     * 
     * Returns: serviceMetadata - {HTMLDivElement} a panel contains service
     * metadata.
     */
    buildServiceMetadata : function(capabilities) {
        var serviceMetadata = document.createElement("div");
        var serviceInfoPanel = this.buildServiceInformationPanel(capabilities);
        serviceMetadata.appendChild(serviceInfoPanel);
        var serviceContactPanel = this.buildServiceContactPanel(capabilities);
        serviceMetadata.appendChild(serviceContactPanel);
        return serviceMetadata;
    },
    /**
     * APIMethod: buildServiceInformationPanel
     * 
     * Builds the service information panel.
     * 
     * Parameters: capabilities - {Object} an Oscar formatted capabilities
     * document.
     * 
     * Returns: serviceInformationPanel - {HTMLDivElement} a panel containing
     * service information.
     */
    buildServiceInformationPanel : function(capabilities) {
        var serviceInformationPanel = document.createElement("div");
        var serviceInformationLabel = document.createElement('label');
        serviceInformationLabel.innerHTML = oscar.i18n("md_service_info");
        oscar.jQuery(serviceInformationLabel).addClass("identifier");
        serviceInformationPanel.appendChild(serviceInformationLabel);
        var serviceInfo = {
            serviceAbstract : oscar.Util.Metadata.getServiceAbstract(capabilities)
        };
        var context = this;
        oscar.jQuery(serviceInformationLabel).click(function(e, ui) {
            var panel = context.metadataPanel;
            panel.innerHTML = "";
            if (serviceInfo.serviceAbstract) {
                var abstractPanel = context.buildAbstractPanel(serviceInfo.serviceAbstract);
                panel.appendChild(abstractPanel);
            }
            if (serviceInfo.serviceKeywords) {
                var keywordsPanel = context.buildKeywordsPanel(serviceInfo.serviceKeywords);
                panel.appendChild(keywordsPanel);
            }
        });
        return serviceInformationPanel;

    },
    /**
     * APIMethod: buildServiceContactPanel Builds the panel to display service
     * contact information.
     * 
     * Parameters: capabilities - {Object} an Oscar formatted capabilities
     * document.
     * 
     * Returns: serviceContactPanel - {HTMLDivElement} a panel containing
     * service contact information.
     */
    buildServiceContactPanel : function(capabilities) {
        var serviceContactPanel = document.createElement("div");
        var serviceContactLabel = document.createElement('label');
        serviceContactLabel.innerHTML = oscar.i18n("md_service_contactInfo");
        oscar.jQuery(serviceContactLabel).addClass("identifier");
        serviceContactPanel.appendChild(serviceContactLabel);
        var serviceContactInfo = oscar.Util.Metadata.getContactInformation(capabilities);
        var context = this;
        oscar.jQuery(serviceContactLabel).click(function(e, ui) {
            var fn1 = function(obj, node) {
                for ( var prop in obj) {
                    var row = document.createElement('div');
                    oscar.jQuery(row).css("width", "100%");
                    var item = obj[prop];
                    if (typeof item == 'object') {
                        fn1(item, node);
                        continue;
                    } else {
                        var cell1 = document.createElement('div');
                        oscar.jQuery(cell1).css("width", "45%");
                        oscar.jQuery(cell1).css("float", "left");
                        cell1.innerHTML = oscar.i18n("md_contact_" + prop) + ":";
                        var cell2 = document.createElement('div');
                        if (item.length == 0) {
                            item = oscar.i18n("NotAvailable");
                        }
                        cell2.innerHTML = item;
                        oscar.jQuery(cell2).css("width", "45%");
                        oscar.jQuery(cell2).css("float", "left");
                        row.appendChild(cell1);
                        row.appendChild(cell2)
                    }
                    node.appendChild(row);
                }

            };
            var panel = context.metadataPanel;
            panel.innerHTML = "";
            if (serviceContactInfo) {
                var caption = document.createElement("div");
                caption.innerHTML = oscar.i18n("md_contact_caption");
                oscar.jQuery(caption).css("text-align", "center");
                oscar.jQuery(caption).css("background-color", "#B7AB83");
                oscar.jQuery(caption).css("font-weight", "bold");
                oscar.jQuery(caption).css("font-size", "14px");
                panel.appendChild(caption);
                fn1(serviceContactInfo, panel);
            } else {
                panel.innerHTML = oscar.i18n("md_contact_info_unavailable");
            }
        });
        return serviceContactPanel;
    },
    /**
     * APIMethod: buildServiceContent Builds the panel to display service
     * content.
     * 
     * Parameters: capabilities - {Object} an Oscar formatted capabilities
     * document.
     * 
     * Returns: panel - {HTMLDivElement} a panel containing service content
     * information.
     */
    buildServiceContent : function(capabilities) {
        var panel = document.createElement("div");
        var serviceType = oscar.Util.Metadata.getServiceType(capabilities);
        var ids = null;
        var serviceHref = null;
        var dataLayers = [];
        switch (serviceType) {
        case oscar.Util.Metadata.WCS:
            ids = oscar.Util.Metadata.getCoverages(capabilities);
            href = oscar.Util.Metadata.getOperationHref(capabilities, "GetCoverage");
            var extractionService = this.theme.getExtractionService();
            for (var i = 0; i < extractionService.length; i++) {
                var serviceUrl = extractionService[i].url
                if (this.checkUrls(href, serviceUrl)) {
                    dataLayers.concat(ids);
                }
            }

            break;
        case oscar.Util.Metadata.WFS:
            ids = oscar.Util.Metadata.getFeatureTypes(capabilities);
            var href = oscar.Util.Metadata.getOperationHref(capabilities, "GetFeature");
            var service = null;
            var services = new Array();
            if ((service = this.theme.getSelectionService())) {
                services = services.concat(service);
            }
            if ((service = this.theme.getExtractionService())) {
                services = services.concat(service);
            }

            for (var i = 0; i < services.length; i++) {
                var serviceUrl = services[i].url
                if (this.checkUrls(href, serviceUrl)) {
                    dataLayers.push(ids);
                }
            }

            break;
        case oscar.Util.Metadata.WMS:
            ids = oscar.Util.Metadata.getLayers(capabilities);
            var href = oscar.Util.Metadata.getOperationHref(capabilities, "GetMap");
            for (var i = 0; i < this.theme.layers.length; i++) {
                var layerUrl = this.theme.layers[i].urls[0];
                if (this.checkUrls(href, layerUrl)) {
                    for ( var layer in this.theme.layers[i].dataLayers) {
                        dataLayers.push(this.theme.layers[i].dataLayers[layer].layerName);
                    }

                }
            }
            break;
        case oscar.Util.Metadata.WMTS:
            ids = oscar.Util.Metadata.getContent(capabilities);
            var href = oscar.Util.Metadata.getOperationHref(capabilities, "GetTile");

            for (var i = 0; i < this.theme.layers.length; i++) {
                var url = this.theme.layers[i].urls[0];
                url = url.split("/1.0.0")[0];
                if (this.checkUrls(href, url)) {
                    for ( var layer in this.theme.layers[i].dataLayers) {
                        dataLayers.push(this.theme.layers[i].dataLayers[layer].layerName);
                    }
                }
            }
            break;
        }
        ;
        var idTable = document.createElement("div");
        oscar.jQuery(idTable).addClass("idContainer");
        for (var i = 0; i < ids.length; i++) {
            var row = document.createElement("div");
            oscar.jQuery(row).css("height", "30px");
            var id = ids[i];

            var title = null;
            if (typeof id.title == 'object') {
                title = id.title[OpenLayers.Lang.getCode()];
                if (title == null) {
                    for ( var key in id.title) {
                        title = id.title[key];
                        break;
                    }
                }
            }
            var lbl = title || id.title || id.name || id.Title;
            var clLabel = new oscar.Gui.ClickableLabel(lbl, {
                style : "block",
                ref : id
            });
            clLabel.applyClass("identifier");
            clLabel.events.on({
                "labelClicked" : this.identifierClicked,
                scope : this
            });
            clLabel.appendTo(idTable);
        }
        panel.appendChild(idTable);
        return panel;
    },
    /**
     * APIMethod: buildAbstractPanel Builds the panel to display service
     * abstracts.
     * 
     * Parameters: content - content of Abstract section.
     * 
     * Returns: abstractPanel - {HTMLDivElement} a panel containing abstract
     * information.
     */
    buildAbstractPanel : function(content) {
        var abstractPanel = document.createElement("div");
        abstractPanel.id = "md_abstract_panel";
        var abstractLabel = document.createElement("label");
        abstractLabel.innerHTML = oscar.i18n("md_abstract_label");
        oscar.jQuery(abstractLabel).addClass("md_label");
        abstractPanel.appendChild(abstractLabel);
        var div = document.createElement("div");
        div.id = "md_abstractPanel";
        if (content.length == 0) {
            content = oscar.i18n("NotAvailable");
        }
        div.innerHTML = content;
        abstractPanel.appendChild(div);
        return abstractPanel;
    },
    /**
     * APIMethod: buildKeywordsPanel Builds the panel to display service
     * keywords.
     * 
     * Parameters: keywords - content of the Keywords section in capabilities
     * file.
     * 
     * Returns: keywordsPanel - {HTMLDivElement} a panel containing keywords
     * information.
     */
    buildKeywordsPanel : function(keywords) {
        var tKeywords = [];
        for (var i = 0; i < keywords.length; i++) {
            if (typeof keywords[i] == "object") {
                tKeywords.push(keywords[i].value);
            } else {
                tKeywords.push(keywords[i]);
            }
        }
        keywords = tKeywords;
        var keywordsPanel = document.createElement("div");
        keywordsPanel.id = "md_keywords_panel";
        var keywordsLabel = document.createElement("label");
        keywordsLabel.innerHTML = oscar.i18n("md_keywords_label");
        oscar.jQuery(keywordsLabel).addClass("md_label");
        var keywordsContainer = document.createElement("div");
        keywordsContainer.innerHTML = keywords;
        keywordsPanel.appendChild(keywordsLabel);
        keywordsPanel.appendChild(keywordsContainer);
        oscar.jQuery(keywordsPanel).css("display", "none");
        return keywordsPanel;
    },

    /**
     * Method: checkUrls
     * 
     * Parameters: param1 - the operation href. param2 - a service URL provided
     * by an extraction service or a layer URL from a wms service.
     */
    checkUrls : function(param1, param2) {
        try {
            return param1.toLowerCase().indexOf(param2.toLowerCase() > -1);
        } catch (err) {
            return false;
        }
    },

    /**
     * Method: identifierClicked
     * 
     * Called when one of the identifiers / features in the service contents
     * panel is clicked. So we know when to call the method.
     * 
     * Parameters: obj - {<oscar.Gui.ClickableLabel>} the identifier has been
     * clicked.
     */
    identifierClicked : function(obj) {
        var metadataContainer = this.metadataPanel;
        metadataContainer.innerHTML = "";
        var id = obj.ref;
        var title = id.title || id.name || id.Title;
        var abstractVal = id['abstract'] || "";
        var keywordsVal = id.keywords || id.Keywords || "";
        var abstractPanel = this.buildAbstractPanel(abstractVal);
        var keywordsPanel = this.buildKeywordsPanel(keywordsVal);
        metadataContainer.appendChild(abstractPanel);
        metadataContainer.appendChild(keywordsPanel);
        var resources = document.createElement('div');
        resources.id = "md_resource_panel";
        var resourcesLabel = document.createElement("label");
        oscar.jQuery(resourcesLabel).addClass("md_label");
        resourcesLabel.innerHTML = oscar.i18n("md_resources_label");
        resources.appendChild(resourcesLabel);
        var resourcesTable = document.createElement("div");
        resources.appendChild(resourcesTable);
        metadataContainer.appendChild(resources);
        var metadataUrls = oscar.Util.Metadata.getIdentifierMetadataUrls(id);
        if (metadataUrls.length == 0) {
            oscar.jQuery(resources).css("display", "none");
        }
        if (metadataUrls.length > 0) {
            var metadataHeaders = [];
            var resource = metadataUrls[0];
            if (typeof resource == 'object') {
                for ( var prop in resource) {
                    metadataHeaders.push(prop);
                }
            } else {
                metadataHeaders.push("type");
                metadataHeaders.push("format");
                metadataHeaders.push("url");

                var tempArray = [];
                for ( var url in metadataUrls) {
                    var uri = new String(metadataUrls[url]);
                    var obj = {
                        "type" : "",
                        "format" : "",
                        "url" : uri
                    };
                    tempArray.push(obj);
                }
                metadataUrls = tempArray;
            }

            var olrFormatter = function(elCell, oRecord, oColumn, oData) {
                if (!oData) {
                    oData = oRecord.getData("href") || oRecord.getData("url");
                }
                ;
                var link = document.createElement("a");
                link.href = oData;
                link.innerHTML = "View";
                link.target = "_new";
                elCell.appendChild(link);
            };

            var typeFormatter = function(elCell, oRecord, oColumn, oData) {
                if (oData.length == 0) {
                    oData = oscar.i18n("NotAvailable");
                }
                elCell.innerHTML = oData;
            };

            var formatFormatter = function(elCell, oRecord, oColumn, oData) {
                if (oData.length == 0) {
                    oData = oscar.i18n("NotAvailable");
                }
                elCell.innerHTML = oData;
            };

            var getHeaderFn = function(name) {
                for (var i = 0; i < metadataHeaders.length; i++) {
                    if (name == metadataHeaders[i])
                        return metadataHeaders[i];
                }
                return null;
            };
            var typeHeader = getHeaderFn("type");
            var formatHeader = getHeaderFn("format");
            var urlHeader = getHeaderFn("url") || getHeaderFn("href");

            var myColumnDefs = [ {
                key : typeHeader,
                label : oscar.i18n("map.information.url.column.type"),
                formatter : typeFormatter,
                sortable : true,
                resizeable : true
            }, {
                key : formatHeader,
                label : oscar.i18n("map.information.url.column.format"),
                formatter : formatFormatter,
                resizeable : true
            }, {
                key : urlHeader,
                formatter : olrFormatter,
                label : oscar.i18n("map.information.url.column.onlineresource"),
                resizeable : true
            } ];
            var myDataSource = new YAHOO.util.DataSource(metadataUrls);
            myDataSource.responseType = YAHOO.util.DataSource.TYPE_JSARRAY;
            myDataSource.responseSchema = {
                fields : metadataHeaders
            };

            var oConfigs = {
                MSG_EMPTY : oscar.i18n("map.information.no.records.found")
            };
            var myDataTable = new YAHOO.widget.DataTable(resourcesTable, myColumnDefs, myDataSource, oConfigs);
            myDataTable.render();
        }

        if (id.styles && id.styles.length > 0) {
            var legendDiv = document.createElement("div");
            var legendLabel = document.createElement("label");
            oscar.jQuery(legendLabel).addClass("md_label");
            legendLabel.innerHTML = oscar.i18n("md_legend_graphic");
            legendDiv.appendChild(legendLabel);
            var style = id.styles[0].legend;
            var img = document.createElement("img");
            img.src = style.href;

            legendDiv.appendChild(img);
            metadataContainer.appendChild(legendDiv);
        }
    },
    /**
     * Constant: CLASS_NAME - oscar.Gui.Metadata
     */
    CLASS_NAME : "oscar.Gui.Metadata"
});
/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Gui.KeywordVocabularyTable
 * 
 * The Keyword-Vocabulary table for INSPIRE services.
 * 
 * @deprecated
 * 
 */

oscar.Gui.KeywordVocabularyTable = oscar.BaseClass({
    /**
     * Property: tableDisplayTag
     * 
     * The div tag for the Keyword-Vocabulary table
     */
    tableDisplayTag : null,

    /**
     * Property: preSavedKeywords
     * 
     * {Array} - pre-saved keywords
     */
    preSavedKeywords : null,

    /**
     * Property: preSavedVocabularies
     * 
     * {Array} - pre-saved vocabularies
     */
    preSavedVocabularies : null,

    /**
     * Property: kwDataTable
     * 
     * {Object} - the keyword table object.
     */
    kwDataTable : null,

    /**
     * Property: tableContent
     * 
     * {Object} - the content of the keyword table. It contains an array of
     * keywords and an array of vocabularies.
     */
    tableContent : null,

    /**
     * Constructor: oscar.Gui.KeywordVocabularyTable
     * 
     * tableDisplayTag - the Div tag which the KeywordVocabularyTable will be
     * attached to. preSavedKeywords - pre-saved keywords for an existing
     * service. preSavedVocabularies - pre-saved vocabularies for an existing
     * service.
     */
    initialize : function(tableDisplayTag, preSavedKeywords, preSavedVocabularies) {
        this.tableDisplayTag = tableDisplayTag;
        this.preSavedKeywords = preSavedKeywords;
        this.preSavedVocabularies = preSavedVocabularies;
        this.tableContent = {
            keywords : {},
            vocabularies : {}
        };
        YAHOO.widget.DataTable.Formatter.customBtnFormatter = this.customBtnFormatter;
        this.buildKeywordVocabularyTable(this.preSavedKeywords, this.preSavedVocabularies);
    },

    /**
     * Method: customBtnFormatter
     * 
     * The custom button formatter tailored for this widget.
     */
    customBtnFormatter : function(elLiner, oRecord, oColumn, oData) {
        if (oRecord._oData.Keyword) {
            elLiner.innerHTML = '<div class="KeywordVocabularyTableDeleteRow"></div>';
        } else {
            elLiner.innerHTML = '<div class="KeywordVocabularyTableAddRow"></div>';
        }
    },

    /**
     * Method: buildKeywordVocabularyTable
     * 
     * Build the keyword-vocabulary table.
     * 
     * Parameters: keywords - pre-saved keywords for an existing service.
     * vocabularies - pre-saved vocabularies for a existing service.
     */
    buildKeywordVocabularyTable : function(keywords, vocabularies) {
        var kwDataSource;
        if ((keywords.length < 1) || (keywords.length == 1 && keywords[0] == "")) {
            kwDataSource = new YAHOO.util.DataSource([ {
                Keyword : "",
                Vocabulary : ""
            } ]);
        } else {
            var data = []
            for (var i = 0; i < keywords.length; i++) {
                data[i] = {
                    Keyword : keywords[i],
                    Vocabulary : vocabularies[i]
                };
            }
            data.push({
                Keyword : "",
                Vocabulary : ""
            });
            kwDataSource = new YAHOO.util.DataSource(data);
        }
        kwDataSource.responseType = YAHOO.util.DataSource.TYPE_JSARRAY;
        kwDataSource.responseSchema = {
            fields : [ "Keyword", "Vocabulary", "button" ]
        };

        var kwColumnDefs = [ {
            key : "Keyword",
            label : oscar.i18n("metadataKeywordLabel"),
            sortable : false,
            width : 240,
            editor : new YAHOO.widget.TextboxCellEditor()
        }, {
            key : "Vocabulary",
            label : oscar.i18n("metadataVocabularyLabel"),
            sortable : false,
            width : 390,
            editor : new YAHOO.widget.TextboxCellEditor()
        }, {
            key : "button",
            label : "",
            formatter : "customBtnFormatter",
            width : 16
        } ];

        var ctx = this;
        kwDataTable = new YAHOO.widget.DataTable(this.tableDisplayTag, kwColumnDefs, kwDataSource, {});
        kwDataTable.subscribe("cellMouseoverEvent", function(e) {
            ctx.highlightEditableCell(e)
        });
        kwDataTable.subscribe("cellMouseoutEvent", kwDataTable.onEventUnhighlightCell);
        kwDataTable.subscribe("cellClickEvent", kwDataTable.onEventShowCellEditor);
        kwDataTable.subscribe("cellClickEvent", function(e) {
            ctx.cellClicked(e)
        });
    },

    /**
     * Method: highlightEditableCell
     * 
     * Highlight editable cell when mouse moves over.
     */

    highlightEditableCell : function(oArgs) {
        var elCell = oArgs.target;
        if (YAHOO.util.Dom.hasClass(elCell, "yui-dt-editable")) {
            kwDataTable.highlightCell(elCell);
        }
    },

    /**
     * Method: cellClicked
     * 
     * Will be invoked when a table cell is clicked.
     */
    cellClicked : function(oArgs) {
        var target = oArgs.target;
        var record = kwDataTable.getRecord(target);
        var column = kwDataTable.getColumn(target);
        var index = kwDataTable.getRecordIndex(record);
        if (column.key == 'button') {
            var innerHtml = target.innerHTML;
            if (innerHtml.indexOf("KeywordVocabularyTableAddRow") != -1) {
                // plus button clicked
                target.innerHTML = '<div class="KeywordVocabularyTableDeleteRow"></div>';
                this.addRow(index + 1);
            } else {
                // remove button clicked
                this.deleteRow(index);
                if (kwDataTable.getRecordSet().getLength() == 0) {
                    // all rows have been removed, add an empty row;
                    this.addRow(0);
                }

            }
        }
    },

    /**
     * Method: addRow
     * 
     * Added an empty row.
     * 
     * Parameters: index - the index for the row to be added.
     */
    addRow : function(index) {
        var oData = {
            Keyword : "",
            Vocabulary : "",
            button : null
        };
        kwDataTable.addRow(oData, index);
    },

    /**
     * Method: deleteRow
     * 
     * Delete a row.
     * 
     * Parameters: index - the index for the row to be added.
     */
    deleteRow : function(index) {
        kwDataTable.deleteRow(index);
    },

    /**
     * Method: getTableContent
     * 
     * Returns: {Object} - content of the table.
     */
    getTableContent : function() {
        var recordSet = kwDataTable.getRecordSet();
        var keyword, keywords = [], vocabularies = [];
        for (var index = 0; index < recordSet.getLength(); index++) {
            keyword = recordSet.getRecord(index).getData("Keyword")
            if (keyword != "") {
                // save the record only when keyword is not empty
                keywords.push(recordSet.getRecord(index).getData("Keyword"));
                vocabularies.push(recordSet.getRecord(index).getData("Vocabulary"));
            }
        }
        this.tableContent.keywords = keywords;
        this.tableContent.vocabularies = vocabularies;

        return this.tableContent;
    },

    /**
     * Constant: CLASS_NAME - oscar.Gui.KeywordVocabularyTable
     */
    CLASS_NAME : "oscar.Gui.KeywordVocabularyTable"
});

/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Control.Permalink
 * 
 * The Oscar Permalink control handles the URL of the map object.
 * 
 * Inherits from: - <OpenLayers.Control.Permalink>
 * 
 */
oscar.Control.Permalink = oscar.BaseClass(OpenLayers.Control.Permalink, {
    /**
     * APIProperty: argParserClass {Class} The ArgParser control class (not
     * instance) to use with this control.
     */
    argParserClass : oscar.Control.ArgParser,

    /**
     * Property: panel
     */
    panel : null,

    /**
     * Property: permalinkPanel
     */
    permalinkPanel : null,

    /**
     * Constructor: oscar.Control.Permalink
     * 
     * Parameters: element - {DOMElement} base - {String} options - {Object} An
     * optional object whose properties will be set on this instance.
     */
    initialize : function(element, base, options) {
        var newArgs = [];
        newArgs.push(element);
        newArgs.push(base);
        newArgs.push(options);
        OpenLayers.Control.Permalink.prototype.initialize.apply(this, newArgs);
    },
    /**
     * Method: createParams Creates the parameters(the current map center, zoom
     * level and theme name) that need to be encoded into the permalink URL.
     * 
     * Returns: params - {Object} Hash of parameters that will be URL-encoded
     * into the permalink.
     */
    createParams : function() {
        var themeManager = this.map.getControlsByClass('oscar.Control.ThemeManager')[0];
        var params = OpenLayers.Control.Permalink.prototype.createParams.apply(this, arguments);
        if (themeManager && themeManager.activeTheme) {
            params.theme = themeManager.activeTheme.name;

        }
        return params;
    },
    /**
     * Method: updateLink
     */
    updateLink : function() {
        OpenLayers.Control.Permalink.prototype.updateLink.apply(this);
        if (this.$panel) {
            this.$panel.hide();
        }
    },
    /**
     * APIMethod: draw
     * 
     * Returns: {DOMElement}
     */
    draw : function() {
        OpenLayers.Control.Permalink.prototype.draw.apply(this);
        var ctx = this;
        var showPermalink = function() {
            ctx._showPermalink();
        }
        this.element.onclick = function() {
            return false;
        }
        OpenLayers.Event.observe(this.element, "mouseup", OpenLayers.Function.bindAsEventListener(showPermalink));
        return this.div;
    },
    /**
     * Method: _showPermalink Creates a popup panel to display the permalink
     * url.
     * 
     */
    _showPermalink : function() {
        // element is the anchor
        var parent = $$(this.element).parent();
        if (this.$panel == null) {
            this.$panel = $$("<div></div>");
            this.$closePanel = $$("<div></div>");
            this.$closePanel.addClass("closeBox");
            var scope = this;
            this.$closePanel.click(function() {
                scope.$panel.hide();
            });
            this.$panel.append(this.$closePanel);
            this.$panel.attr("id", "permalinkPanel");
            var $title = $$("<div></div>").html(this.panelTitle);
            $title.css("text-align", "left");
            this.$panel.append($title);
            this.$input = $$("<input type='text'>");
            this.$input.css("width", "98%");
            this.$panel.append(this.$input);
            $$("body").append(this.$panel);
            this.$panel.css({
                "position" : "absolute",
                "zIndex" : 1500,
                "width" : 600,
                "height" : 80,
                "backgroundColor" : "#bbb"
            });
            this.$panel.position({
                of : $$(this.element),
                at : "right bottom",
                my : "right top"
            });
        }
        this.$input.val(this.element.href);
        this.$panel.show();

    },
    /**
     * Method: _selectAll Returns a closure to capture the onclick event.
     */
    _selectAll : function(field) {
        return function(e) {
            var end = field.value.length;
            if (field.createTextRange) {
                var selRange = field.createTextRange();
                selRange.select();
            } else if (field.setSelectionRange) {
                field.setSelectionRange(0, end);
            } else if (field.selectionStart) {

                field.selectionStart = 0;
                field.selectionEnd = end;
            }
            field.focus();

        }
    },
    /**
     * Method: _createSelection Set the content of the input field to be
     * selected
     * 
     */
    _createSelection : function(field) {
        var end = field.value.length;
        if (field.createTextRange) {
            var selRange = field.createTextRange();
            selRange.select();
        } else if (field.setSelectionRange) {
            field.setSelectionRange(0, end);
        } else if (field.selectionStart) {

            field.selectionStart = 0;
            field.selectionEnd = end;
        }
        field.focus();
    },

    /**
     * Constant: CLASS_NAME - oscar.Control.Permalink
     */
    CLASS_NAME : "oscar.Control.Permalink"
});
/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Util.SettingsAutoCompleteTable
 * 
 * @deprecated
 */
oscar.Util.SettingsAutoCompleteTable = oscar.BaseClass({

    filterTag : null,
    displayTag : null,
    tableDisplayTag : null,

    /*
     * The YUI data source.
     */
    settingsDataSource : null,

    /*
     * The YUI data table.
     */
    settingsDataTable : null,

    /*
     * The YUI auto complete widget.
     */
    autoComplete : null,

    /**
     * Property: dataTableConfig {Array} Table Configuration.
     */
    dataTableConfig : null,

    /**
     * Method: getDefaultTableConfiguration
     * 
     * Returns: {Object} the object containing default settings for the data
     * table.
     */
    getDefaultTableConfiguration : function() {
        return {
            MSG_EMPTY : oscar.i18n("MICT_MSG_EMPTY"),
            MSG_ERROR : oscar.i18n("MICT_MSG_ERROR"),
            MSG_LOADING : oscar.i18n("MICT_MSG_LOADING"),
            MSG_SORTASC : oscar.i18n("MICT_MSG_SORTASC"),
            MSG_SORTDESC : oscar.i18n("MICT_MSG_SORTDESC"),
            scrollable : true,
            width : "700px",
            height : "300px",
            initialRequest : '?filter=' + YAHOO.util.Dom.get(filterTag).value + '&IECachePatch' + new Date().getTime()
        };
    },

    initialize : function(filterTagIn, displayTagIn, tableDisplayTagIn) {

        filterTag = filterTagIn;
        displayTag = displayTagIn;
        tableDisplayTag = tableDisplayTagIn;

        /*
         * Add the custom formatter to the shortcuts.
         */
        YAHOO.widget.DataTable.Formatter.statusFormatter = this.statusFormatter;
        YAHOO.widget.DataTable.Formatter.resetFormatter = this.resetFormatter;

        // Create a data source for the autoComplete to use.

        settingsDataSource = new YAHOO.util.XHRDataSource('getSettings');
        settingsDataSource.responseType = YAHOO.util.XHRDataSource.TYPE_JSON;
        settingsDataSource.connXhrMode = "queueRequests";
        settingsDataSource.responseSchema = {
            resultsList : "Response.Results",
            fields : [ {
                key : "id"
            }, {
                key : "name"
            }, {
                key : "value"
            }, {
                key : "defaultValue"
            }, {
                key : "type"
            } ]
        };
        var autoCompleteDataSource = new YAHOO.util.FunctionDataSource(this.getSettings);
        autoCompleteDataSource.queryMatchContains = true;

        // Initialize the autocomplete widget, must have min length
        // set to 0 to manually clear the list.
        autoComplete = new YAHOO.widget.AutoComplete(filterTag, displayTag, autoCompleteDataSource);
        autoComplete.minQueryLength = 0;

        // These external objects are used to pass the table data between
        // the ajaxUpdateValue and ajaxResetValue handlers.
        var tableUpdateCallback = null;
        var tableUpdateNewValue = null;
        var tableUpdateRecord = null;
        var tableResetRecord = null;

        /*
         * This object wraps the request and callback logic for updating a
         * value.
         */
        var ajaxUpdateValue = {
            handleSuccess : function(o) {
                settingsDataSource.sendRequest('?filter=' + document.getElementById(filterTag).value, settingsDataTable.onDataReturnInitializeTable, settingsDataTable);
                tcb = o.argument.tblCallback;
                tnv = o.argument.tblNewValue;
                var record = o.argument.tblRecord;
                var recordIdx = settingsDataTable.getRecordIndex(record)
                var data = record.getData(recordIdx);

                var r = YAHOO.lang.JSON.parse(o.responseText);

                if (r.Response.Results.status == true) {
                    settingsDataTable.updateRow(record, data);
                    displayMessage("info", r.Response.Results.message);
                    tcb(true, tnv);
                    settingsDataTable.render();
                } else {
                    displayMessage("error", r.Response.Results.message);
                    tcb(false);
                }
            },
            handleFailure : function(o) {
                YAHOO.log("Failed to process XHR transaction.", "error");
            },
            startRequest : function(tableCallback, tableNewValue) {
                ajaxUpdateCallback.argument.tblCallback = tableCallback;
                ajaxUpdateCallback.argument.tblNewValue = tableNewValue;
                ajaxUpdateCallback.argument.tblRecord = this.getRecord();

                var id = this.getRecord().getData('id');
                YAHOO.util.Connect.asyncRequest('GET', 'updateSetting?settingId=' + id + '&settingValue=' + tableNewValue, ajaxUpdateCallback);
            }
        }

        /*
         * This object wraps the request and callback logic for resetting a
         * value.
         */
        var ajaxResetValue = {
            handleSuccess : function(o) {
                var record = o.argument.tblRecord;
                var recordIdx = settingsDataTable.getRecordIndex(record)
                var data = record.getData(recordIdx);

                var r = YAHOO.lang.JSON.parse(o.responseText);

                if (r.Response.Results.status == true) {
                    data['value'] = data['defaultValue'];
                    settingsDataTable.updateRow(record, data);
                    displayMessage("info", r.Response.Results.message);
                    settingsDataTable.render();
                } else {
                    displayMessage("error", r.Response.Results.message);
                }
            },
            handleFailure : function(o) {
                YAHOO.log("Failed to process XHR transaction.", "error");
            },
            startRequest : function(record) {
                ajaxResetCallback.argument.tblRecord = record;

                YAHOO.util.Connect.asyncRequest('GET', 'resetSetting?settingId=' + record.getData('id'), ajaxResetCallback);
            }
        }

        // This will handle the response for the update action.
        var ajaxUpdateCallback = {
            success : ajaxUpdateValue.handleSuccess,
            failure : ajaxUpdateValue.handleFailure,
            scope : ajaxUpdateValue,
            argument : {
                tblCallback : tableUpdateCallback,
                tblNewValue : tableUpdateNewValue,
                tblRecord : tableUpdateRecord
            }
        };

        // This will handle the response for the reset action.
        var ajaxResetCallback = {
            success : ajaxResetValue.handleSuccess,
            failure : ajaxResetValue.handleFailure,
            scope : ajaxResetValue,
            argument : {
                tblRecord : tableResetRecord
            }
        };

        // Define the columns for the settings table.
        var settingColumnDefs = [ {
            key : "name",
            label : oscar.i18n("nameColumnLabel"),
            sortable : true,
            width : 200
        }, {
            key : "status",
            label : oscar.i18n("statusColumnLabel"),
            formatter : "statusFormatter",
            sortable : false,
            width : 80
        }, {
            key : "type",
            label : oscar.i18n("typeColumnLabel"),
            sortable : false,
            width : 140
        }, {
            key : "value",
            label : oscar.i18n("valueColumnLabel"),
            sortable : true,
            editor : new YAHOO.widget.TextboxCellEditor({
                asyncSubmitter : ajaxUpdateValue.startRequest,
                LABEL_SAVE : oscar.i18n("saveButtonLabel"),
                LABEL_CANCEL : oscar.i18n("cancelButtonLabel")
            }),
            width : 170
        }, {
            key : "reset",
            label : oscar.i18n("resetColumnLabel"),
            formatter : "resetFormatter",
            sortable : false,
            width : 50
        } ];

        // Create an instance of the settings table wrapper.
        // Initialize the data source for the settings table.
        settingsDataSource = new YAHOO.util.XHRDataSource('getSettings');
        settingsDataSource.responseType = YAHOO.util.XHRDataSource.TYPE_JSON;
        settingsDataSource.connXhrMode = "queueRequests";
        settingsDataSource.responseSchema = {
            resultsList : "Response.Results",
            fields : [ {
                key : "id"
            }, {
                key : "name"
            }, {
                key : "value"
            }, {
                key : "defaultValue"
            }, {
                key : "type"
            } ]
        };

        this.dataTableConfig = this.getDefaultTableConfiguration();
        // Create the settings table.
        settingsDataTable = new YAHOO.widget.DataTable(tableDisplayTag, settingColumnDefs, settingsDataSource, this.dataTableConfig);

        /*
         * Custom listener that highlights the editable cell.
         */
        var highlightEditableCell = function(oArgs) {
            var elCell = oArgs.target;
            if (YAHOO.util.Dom.hasClass(elCell, "yui-dt-editable")) {
                this.highlightCell(elCell);
            }
        };

        /*
         * Custom listener that detects if the reset button was clicked. If so,
         * open a confirmation dialog.
         */

        var resetValue = function(oArgs) {

            var target = oArgs.target;
            var column = this.getColumn(target);

            // Limit the check to events on the reset column.
            if (column.key == 'reset') {
                var record = this.getRecord(target);
                // Has the value been modified?
                if (record.getData('value') != record.getData('defaultValue')) {
                    var confirmBox = new oscar.Gui.ConfirmDialog(oscar.i18n("confirmBoxHeader"), oscar.i18n("confirmReset"), {
                        yesCallback : function() {
                            ajaxResetValue.startRequest(record);
                            confirmBox.hide();
                        },
                        noCallback : function() {
                            confirmBox.hide();
                        }
                    });
                }
            }
        }

        // Register the listeners to the events.
        settingsDataTable.subscribe("cellMouseoverEvent", highlightEditableCell);
        settingsDataTable.subscribe("cellMouseoutEvent", settingsDataTable.onEventUnhighlightCell);
        settingsDataTable.subscribe("cellClickEvent", settingsDataTable.onEventShowCellEditor);
        settingsDataTable.subscribe("cellClickEvent", resetValue);

        /*
         * Display a given message in either the jsMessage or jsError div tags.
         */
        var displayMessage = function(level, message) {
            if (level == "error") {
                YAHOO.util.Dom.get('jsMessage').innerHTML = '';
                YAHOO.util.Dom.get('jsError').innerHTML = '<ul><li><span>' + message + '</span></li></ul>';
            } else {
                YAHOO.util.Dom.get('jsError').innerHTML = '';
                YAHOO.util.Dom.get('jsMessage').innerHTML = '<ul><li><span>' + message + '</span></li></ul>';
            }
        };

        return {
            oDS : settingsDataSource,
            oDT : settingsDataTable
        };
    },

    /*
     * Method that queries the server for the settings. Bound to the settings
     * data table.
     */
    getSettings : function(query) {
        settingsDataSource.sendRequest('?filter=' + query, settingsDataTable.onDataReturnInitializeTable, settingsDataTable);
    },

    /*
     * Method that creates a formatter used to indicate whether the default
     * value has been changed.
     */
    statusFormatter : function(elCell, oRecord, oColumn, oData) {
        if (oRecord.getData("value") == oRecord.getData("defaultValue")) {
            YAHOO.util.Dom.replaceClass(elCell.parentNode, "default", "modified");
            elCell.innerHTML = oscar.i18n("default");
        } else {
            YAHOO.util.Dom.replaceClass(elCell.parentNode, "modified", "default");
            elCell.innerHTML = oscar.i18n("modified");
        }
    },

    /*
     * Method that resets formatter used to indicate whether the default value
     * has been changed.
     */
    resetFormatter : function(elCell, oRecord, oColumn, oData) {
        if (oRecord.getData("value") == oRecord.getData("defaultValue")) {
            YAHOO.util.Dom.replaceClass(elCell.parentNode, "default", "modified");
            elCell.innerHTML = '';
        } else {
            YAHOO.util.Dom.replaceClass(elCell.parentNode, "modified", "default");
            elCell.innerHTML = '<div align="center"><a href="#"><img src="../images/configmanager/content_reset.png"/></a></div>';
        }
    },

    resetTable : function() {
        settingsDataSource.sendRequest('?filter=', settingsDataTable.onDataReturnInitializeTable, settingsDataTable);
    },

    CLASS_NAME : "oscar.Util.SettingsAutoCompleteTable"
});
/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Util.StatusChecker Class for checking the status of a
 * connection.
 * 
 * @deprecated
 */
oscar.Util.StatusChecker = oscar.BaseClass({
    idParamName : null,
    baseUrl : null,
    goodMsgTxt : null,
    badMsgTxt : null,
    goodImgUrl : null,
    badImgUrl : null,
    goodStatus : null,
    badStatus : null,

    /**
     * Constructor.
     * 
     * @param idParamName
     *                The name of the id parameter to be used when making status
     *                check requests.
     * @param baseUrl
     *                The base url for status requests.
     * @param goodMsgTxt
     *                The text element to display for a good status.
     * @param badMsgTxt
     *                The text element to display for a bad status.
     * @param goodImgUrl
     *                The url to the img to display for a good status.
     * @param badImgUrl
     *                The url to the img to display for a bad status.
     * @param goodStatus
     *                The value expected from the AJAX status request if the
     *                connection is good.
     * @param badStatus
     *                The value expected from the AJAX status request if the
     *                connection is bad.
     */
    initialize : function(idParamName, baseUrl, goodMsgTxt, badMsgTxt, goodImgUrl, badImgUrl, goodStatus, badStatus) {
        this.idParamName = idParamName;
        this.baseUrl = baseUrl;
        this.goodMsgTxt = goodMsgTxt;
        this.badMsgTxt = badMsgTxt;
        this.goodImgUrl = goodImgUrl;
        this.badImgUrl = badImgUrl;
        this.goodStatus = goodStatus;
        this.badStatus = badStatus;
    },

    /**
     * Function that returns a callback object used by the YUI asyncRequest when
     * calling checkStatus to handle displaying the returned status.
     * 
     * @param idParam
     *                The id of the connection whose status was retrieved.
     * @param statusElem
     *                The DOM element to display the status result in.
     * @param statusChecker
     *                The StatusChecker object that made the request (need to
     *                pass in so it keeps a reference to it in a closure when
     *                the actual callback function is executed.).
     */
    callback : function(idParam, statusElem, statusChecker) {
        return {
            success : function(o) {
                var result = YAHOO.lang.JSON.parse(o.responseText);
                var status = result.Response.Results;
                var colData = "";

                if (status === statusChecker.goodStatus) {
                    colData += '<img src="' + statusChecker.goodImgUrl + '"/>';
                    colData += statusChecker.goodMsgTxt;
                    statusElem.innerHTML = colData;
                } else if (status === statusChecker.badStatus) {
                    colData += '<img src="' + statusChecker.badImgUrl + '"/>';
                    colData += statusChecker.badMsgTxt;
                    statusElem.innerHTML = colData;
                } else {
                    statusElem.innerHTML = 'Invalid status returned: ' + status;
                }
            },
            failure : function(o) {
            }
        }
    },

    /**
     * Checks the status of the connection with the given id.
     * 
     * @param idParam
     *                The id of the object/connection whose status is being
     *                checked
     * @param statusElem
     *                The DOM element to display the status result in.
     */
    checkStatus : function(id, statusElem) {
        var url = this.baseUrl + "?" + this.idParamName + "=" + id;
        return YAHOO.util.Connect.asyncRequest("GET", url, this.callback(id, statusElem, this));
    },

    CLASS_NAME : "oscar.Util.StatusChecker"
});
/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Util.DivSelect
 * 
 * @deprecated
 */
oscar.Util.DivSelect = oscar.BaseClass({

    initialize : function(div, dragableIn) {
        // the div container
        this.selectDiv = div;
        // disable selection by dragging the mouse because it selects the texts
        // instead of options
        if (typeof document.onselectstart != "undefined") {
            this.selectDiv.onselectstart = new Function("return false");
        } else {
            this.selectDiv.onmousedown = new Function("return false");
            this.selectDiv.onmouseup = new Function("return true");
        }

        // the options
        this.options = new Array();

        // drag&dropable
        this.dragable = dragableIn;
        if (this.dragable) {
            new YAHOO.util.DDTarget(this.selectDiv, this.selectDiv.id);
        }

    },

    /*
     * This method selects(highlight) an option if the option is not selected.
     * Otherwise, it unselect the option.
     */
    clickOptionDiv : function() {
        if (this.className == 'highlighted') {
            this.className = 'unhighlighted';
        } else if (this.className == 'unhighlighted') {
            this.className = 'highlighted';
        }
    },

    /*
     * This method adds an option to the DivSelect control @param option an
     * object implements the createHTMLDiv method. @param comparator a function
     * to compare two options. If it is not null, the option will be inserted to
     * the options array according to its value. Otherwise, the option will be
     * added to the end of the array.
     * 
     */
    addOption : function(option, comparator) {
        var optionDiv = option.createHTMLDiv();
        option.optionDiv = optionDiv;

        if (optionDiv != null) {
            if (!comparator || this.options.length == 0) {
                this.selectDiv.appendChild(optionDiv);
                this.options[this.options.length] = option;
            } else {
                var optionDivs = this.selectDiv.childNodes;
                var foundPosition = false;
                for (i = 0; i < this.options.length; i++) {
                    if (comparator(option, this.options[i]) < 0) {
                        this.options.splice(i, 0, option);
                        this.selectDiv.insertBefore(optionDiv, optionDivs[i]);
                        foundPosition = true;
                        break;
                    }
                }
                if (!foundPosition) {
                    this.selectDiv.appendChild(optionDiv);
                    this.options[this.options.length] = option;
                }
            }

            optionDiv.onclick = this.clickOptionDiv;
            optionDiv.className = "unhighlighted";
        }

        if (this.dragable) {
            new oscar.Util.DivSelect.DD(this, optionDiv.id, this.selectDiv.id);
        }
    },

    /*
     * This method removes an option from the DivSelect control param index the
     * index of the option to be removed
     */
    removeOption : function(index) {
        if (index > this.options.length - 1)
            return false;
        this.options.splice(index, 1);
        var optionDivs = this.selectDiv.childNodes;
        if (optionDivs != null) {
            this.selectDiv.removeChild(optionDivs[index]);
        }
    },

    /*
     * This method returns the option in request param index the index of the
     * option to be returned
     */
    getOption : function(index) {
        return this.options[index];
    },

    /**
     * This method selects an option.
     * 
     * @param index
     *                the index of the option
     */
    selectOption : function(index) {
        if (index > this.options.length - 1)
            return false;
        var optionDiv = this.selectDiv.childNodes[index];
        if (optionDiv.className == 'unhighlighted') {
            optionDiv.className = 'highlighted';
        }
    },

    /**
     * This method unselects an option.
     * 
     * @param index
     *                the index of the option
     */
    unselectOption : function(index) {
        if (index > this.options.length - 1)
            return false;
        var optionDiv = this.selectDiv.childNodes[index];
        if (optionDiv.className == 'highlighted') {
            optionDiv.className = 'unhighlighted';
        }
    },

    /**
     * This method enables an option.
     * 
     * @param index
     *                the index of the option
     */
    enableOption : function(index) {
        if (index > this.options.length - 1)
            return false;
        this.selectDiv.childNodes[index].className = 'unhighlighted';
    },

    /**
     * This method disables an option.
     * 
     * @param index
     *                the index of the option
     */
    disableOption : function(index) {
        if (index > this.options.length - 1)
            return false;
        this.selectDiv.childNodes[index].className = 'isDisabled';
    },

    /*
     * This method removes the current selected options
     */
    removeSelectedOptions : function() {
        var optionDivs = this.selectDiv.childNodes;
        if (optionDivs != null) {
            for (i = optionDivs.length - 1; i >= 0; i--) {
                var optionDiv = optionDivs[i];
                if (optionDiv.className == 'highlighted') {
                    this.selectDiv.removeChild(optionDiv);
                    this.options.splice(i, 1);
                }
            }
        }
    },

    /*
     * This method removes the current enabled options
     */
    removeEnabledOptions : function() {
        var optionDivs = this.selectDiv.childNodes;
        if (optionDivs != null) {
            for (i = optionDivs.length - 1; i >= 0; i--) {
                var optionDiv = optionDivs[i];
                if (optionDiv.className != 'isDisabled') {
                    this.selectDiv.removeChild(optionDiv);
                    this.options.splice(i, 1);
                }
            }
        }
    },

    /*
     * This method removes all options
     */
    removeAllOptions : function() {
        var optionDivs = this.selectDiv.childNodes;
        if (optionDivs != null) {
            for (i = optionDivs.length - 1; i >= 0; i--) {
                var optionDiv = optionDivs[i];
                this.selectDiv.removeChild(optionDiv);
                this.options.splice(i, 1);
            }
        }
    },

    /*
     * This method returns all options
     */
    getAllOptions : function() {
        return this.options;
    },

    /*
     * This method returns the current selected options
     */
    getSelectedOptions : function() {
        var ret = new Array();
        var optionDivs = this.selectDiv.childNodes;
        if (optionDivs != null) {
            for (i = 0; i < optionDivs.length; i++) {
                var optionDiv = optionDivs[i];
                if (optionDiv.className == 'highlighted') {
                    ret.push(this.options[i]);
                }
            }
        }
        return ret;
    },

    /*
     * This method returns the current enabled options
     */
    getEnabledOptions : function() {
        var ret = new Array();
        var optionDivs = this.selectDiv.childNodes;
        if (optionDivs != null) {
            for (i = 0; i < optionDivs.length; i++) {
                var optionDiv = optionDivs[i];
                if (optionDiv.className != 'isDisabled') {
                    ret.push(this.options[i]);
                }
            }
        }
        return ret;
    },

    CLASS_NAME : "oscar.Util.DivSelect"
});

/**
 * The customized dragable YUI object
 * 
 * @param divSelect
 *                the divSelect
 * @param id
 *                the id of this dragable
 * @param sGroup
 *                the drag & drop group this dragable belongs to
 * @param config
 *                YUI DD config
 */
oscar.Util.DivSelect.DD = function(divSelect, id, sGroup, config) {
    oscar.Util.DivSelect.DD.superclass.constructor.call(this, id, sGroup, config);
    this.divSelect = divSelect;
    this.Dom = YAHOO.util.Dom;
    this.Event = YAHOO.util.Event;
    this.DDM = YAHOO.util.DragDropMgr;
    this.logger = this.logger || YAHOO;
    this.Dom.setStyle(this.getDragEl(), "opacity", 0.67); // The proxy is
    // slightly
    // transparent
    this.goingUp = false;
    this.lastY = 0;
}

/**
 * oscar.Util.DivSelect.DD extends YAHOO.util.DDProxy
 */
YAHOO.extend(oscar.Util.DivSelect.DD, YAHOO.util.DDProxy, {

    startDrag : function(x, y) {
        this.logger.log(this.id + " startDrag");

        // make the proxy look like the source element
        var dragEl = this.getDragEl();
        var clickEl = this.getEl();
        this.Dom.setStyle(clickEl, "visibility", "hidden");

        dragEl.innerHTML = clickEl.innerHTML;

        this.Dom.setStyle(dragEl, "text-align", this.Dom.getStyle(clickEl, "text-align"));
        this.Dom.setStyle(dragEl, "color", this.Dom.getStyle(clickEl, "color"));
        this.Dom.setStyle(dragEl, "backgroundColor", this.Dom.getStyle(clickEl, "backgroundColor"));
    },

    endDrag : function(e) {

        var srcEl = this.getEl();
        var proxy = this.getDragEl();

        // Show the proxy element and animate it to the src element's location
        this.Dom.setStyle(proxy, "visibility", "");
        var a = new YAHOO.util.Motion(proxy, {
            points : {
                to : this.Dom.getXY(srcEl)
            }
        }, 0.2, YAHOO.util.Easing.easeOut)
        var proxyid = proxy.id;
        var thisid = this.id;

        // Hide the proxy and show the source element when finished with the
        // animation
        a.onComplete.subscribe(function() {
            YAHOO.util.Dom.setStyle(proxyid, "visibility", "hidden");
            YAHOO.util.Dom.setStyle(thisid, "visibility", "");
        });
        a.animate();
    },

    onDragDrop : function(e, id) {

        // If there is one drop interaction, the div was dropped either on the
        // list,
        // or it was dropped on the current location of the source element.
        if (this.DDM.interactionInfo.drop.length === 1) {

            // The position of the cursor at the time of the drop
            // (YAHOO.util.Point)
            var pt = this.DDM.interactionInfo.point;

            // The region occupied by the source element at the time of the drop
            var region = this.DDM.interactionInfo.sourceRegion;

            // Check to see if we are over the source element's location. We
            // will
            // append to the bottom of the list once we are sure it was a drop
            // in
            // the negative space (the area of the list without any list items)
            if (!region.intersect(pt)) {
                var destEl = this.Dom.get(id);
                var destDD = this.DDM.getDDById(id);
                destEl.appendChild(this.getEl());
                destDD.isEmpty = false;
                this.DDM.refreshCache();
            }

        }
    },

    onDrag : function(e) {

        // Keep track of the direction of the drag for use during onDragOver
        var y = this.Event.getPageY(e);

        if (y < this.lastY) {
            this.goingUp = true;
        } else if (y > this.lastY) {
            this.goingUp = false;
        }

        this.lastY = y;
    },

    onDragOver : function(e, id) {

        var srcEl = this.getEl();
        var destEl = this.Dom.get(id);

        // We are only concerned with list items, we ignore the dragover
        // notifications for the list.
        if (destEl.className == 'highlighted' || destEl.className == 'unhighlighted' || destEl.className == 'isDisabled') {
            var orig_p = srcEl.parentNode;
            var p = destEl.parentNode;

            if (this.goingUp) {
                p.insertBefore(srcEl, destEl); // insert above
            } else {
                p.insertBefore(srcEl, destEl.nextSibling); // insert below
            }
            this.DDM.refreshCache();

            // Re-order the options in divSelect
            var options = this.divSelect.getAllOptions();
            var newOptions = new Array();
            var tempOptions = new Array();
            var srcOption = null;
            for (i = 0; i < options.length; i++) {
                if (options[i].optionDiv == srcEl)
                    srcOption = options[i];
                else
                    tempOptions[tempOptions.length] = options[i];
            }
            for (i = 0; i < tempOptions.length; i++) {
                if (tempOptions[i].optionDiv == destEl) {
                    if (this.goingUp) {
                        newOptions[newOptions.length] = srcOption;
                        newOptions[newOptions.length] = tempOptions[i];
                    } else {
                        newOptions[newOptions.length] = tempOptions[i];
                        newOptions[newOptions.length] = srcOption;
                    }
                } else
                    newOptions[newOptions.length] = tempOptions[i];
            }
            this.divSelect.options = newOptions;
        }
    }

});

/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Util.DivSelectOption Class representing a basic option for an
 * oscar.DivSelect.
 * 
 * @deprecated
 */
oscar.Util.DivSelectOption = oscar.BaseClass({
    listName : null,
    showListName : null,
    separator : "::",

    /**
     * Constructor.
     * 
     * @param optionId
     *                The id of the option.
     * @param optionName
     *                The name of the option.
     * @param optionInputTagName
     *                The tag name for the options div tag.
     * @param optionListName
     *                The listName of the option.
     * @param optionShowListName
     *                true if the listName should be displayed in the DivSelect
     *                as part of the option name, false otherwise.
     */
    initialize : function(optionId, optionName, optionInputTagName, optionListName, optionShowListName) {
        this.id = optionId;
        this.name = optionName;
        this.inputTagName = optionInputTagName;
        this.listName = optionListName;
        this.showListName = optionShowListName;
    },

    /**
     * Creates the div element inside the DivSelect that contains this option.
     */
    createHTMLDiv : function() {
        var ret = document.createElement('div');
        if (this.showListName) {
            ret.id = "selectedLayer" + this.id + "Option";
        } else {
            ret.id = "availableLayer" + this.id + "Option";
        }

        var content = "<input type='hidden' name='" + this.inputTagName + "' value='" + this.id + "'/>";

        if (this.showListName) {
            content += this.listName + this.separator + this.name;
        } else {
            content += this.name;
        }

        ret.innerHTML = content;
        return ret;
    },

    CLASS_NAME : "oscar.Util.DivSelectOption"
});

/*
 * CARIS oscar - Open Spatial Component ARchitecture
 *
 * Copyright 2014 CARIS <http://www.caris.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * Class: oscar.Util.CoordinateSystemAutoComplete
 * 
 * @deprecated
 */
oscar.Util.CoordinateSystemAutoComplete = oscar.BaseClass({
    /**
     * Property: filterTag
     */
    filterTag : null,
    /**
     * Property: containerTag
     */
    containerTag : null,
    /**
     * Property: context
     */
    context : null,
    /**
     * Property: coorDataSource
     */
    coorDataSource : null,
    /**
     * Property: autoComplete
     */
    autoComplete : null,
    /**
     * Constructor: oscar.Util.CoordinateSystemAutoComplete
     * 
     * Parameters: filterTagIn - DOM element reference of an input field.
     * containerTagIn - DOM element reference of an existing DIV. contextIn -
     * {Object} a reference to SFE ThemePageControls.
     */
    initialize : function(filterTagIn, containerTagIn, contextIn) {
        this.filterTag = filterTagIn;
        this.containerTag = containerTagIn;
        this.context = contextIn;
        this.coorDataSource = new YAHOO.util.XHRDataSource('getEpsgs');
        this.coorDataSource.responseType = YAHOO.util.XHRDataSource.TYPE_JSON;
        this.coorDataSource.responseSchema = {
            resultsList : "Response.Results",
            fields : [ "code", "name" ]
        };
        this.autoComplete = new YAHOO.widget.AutoComplete(this.filterTag, this.containerTag, this.coorDataSource);
        this.autoComplete.minQueryLength = 3;
        this.autoComplete.queryDelay = 0.3;
        this.autoComplete.maxResultsDisplayed = 20;
        this.autoComplete.forceSelection = true;
        this.autoComplete.autoSnapContainer = true;
        this.autoComplete.applyLocalFilter = false;
        this.autoComplete.resultTypeList = false;
        this.autoComplete.generateRequest = function(sQuery) {
            return "?filter=" + sQuery;
        };
        this.autoComplete.formatResult = function(oResultData, sQuery, sResultMatch) {
            return oResultData.code + " (" + oResultData.name + ")";
        };
        var ctx = this.context;
        this.autoComplete.itemSelectEvent.subscribe(function(sType, aArgs) {
            var ac = aArgs[0];
            var srsValue = aArgs[2];
            ac._elTextbox.value = srsValue.code + "(" + srsValue.name + ")";
            var srs = srsValue.code;
            ctx.changeSrs(srs);
        });

    },
    /**
     * Constant: CLASS_NAME - oscar.Util.CoordinateSystemAutoComplete
     */
    CLASS_NAME : "oscar.Util.CoordinateSystemAutoComplete"
});
