/*!
 * Paper.js v0.9.22 - The Swiss Army Knife of Vector Graphics Scripting.
 * http://paperjs.org/
 *
 * Copyright (c) 2011 - 2014, Juerg Lehni & Jonathan Puckey
 * http://scratchdisk.com/ & http://jonathanpuckey.com/
 *
 * Distributed under the MIT license. See LICENSE file for details.
 *
 * All rights reserved.
 *
 * Date: Sat Feb 28 19:20:48 2015 +0100
 *
 ***
 *
 * Straps.js - Class inheritance library with support for bean-style accessors
 *
 * Copyright (c) 2006 - 2013 Juerg Lehni
 * http://scratchdisk.com/
 *
 * Distributed under the MIT license.
 *
 ***
 *
 * Acorn.js
 * http://marijnhaverbeke.nl/acorn/
 *
 * Acorn is a tiny, fast JavaScript parser written in JavaScript,
 * created by Marijn Haverbeke and released under an MIT license.
 *
 */
var paper=new function(t){var e=new function(){function i(t,i,n,r,a){function o(s,o){o=o||(o=u(i,s))&&(o.get?o:o.value),"string"==typeof o&&"#"===o[0]&&(o=t[o.substring(1)]||o);var l,d="function"==typeof o,_=o,f=a||d?o&&o.get?s in t:t[s]:null;a&&f||(d&&f&&(o.base=f),d&&r!==!1&&(l=s.match(/^([gs]et|is)(([A-Z])(.*))$/))&&(h[l[3].toLowerCase()+l[4]]=l[2]),_&&!d&&_.get&&"function"==typeof _.get&&e.isPlainObject(_)||(_={value:_,writable:!0}),(u(t,s)||{configurable:!0}).configurable&&(_.configurable=!0,_.enumerable=n),c(t,s,_))}var h={};if(i){for(var l in i)i.hasOwnProperty(l)&&!s.test(l)&&o(l);for(var l in h){var d=h[l],_=t["set"+d],f=t["get"+d]||_&&t["is"+d];!f||r!==!0&&0!==f.length||o(l,{get:f,set:_})}}return t}function n(t,e,i){return t&&("length"in t&&!t.getLength&&"number"==typeof t.length?a:o).call(t,e,i=i||t),i}function r(t,e,i){for(var n in e)!e.hasOwnProperty(n)||i&&i[n]||(t[n]=e[n]);return t}var s=/^(statics|enumerable|beans|preserve)$/,a=[].forEach||function(t,e){for(var i=0,n=this.length;n>i;i++)t.call(e,this[i],i,this)},o=function(t,e){for(var i in this)this.hasOwnProperty(i)&&t.call(e,this[i],i,this)},h=Object.create||function(t){return{__proto__:t}},u=Object.getOwnPropertyDescriptor||function(t,e){var i=t.__lookupGetter__&&t.__lookupGetter__(e);return i?{get:i,set:t.__lookupSetter__(e),enumerable:!0,configurable:!0}:t.hasOwnProperty(e)?{value:t[e],enumerable:!0,configurable:!0,writable:!0}:null},l=Object.defineProperty||function(t,e,i){return(i.get||i.set)&&t.__defineGetter__?(i.get&&t.__defineGetter__(e,i.get),i.set&&t.__defineSetter__(e,i.set)):t[e]=i.value,t},c=function(t,e,i){return delete t[e],l(t,e,i)};return i(function(){for(var t=0,e=arguments.length;e>t;t++)r(this,arguments[t])},{inject:function(t){if(t){var e=t.statics===!0?t:t.statics,n=t.beans,r=t.preserve;e!==t&&i(this.prototype,t,t.enumerable,n,r),i(this,e,!0,n,r)}for(var s=1,a=arguments.length;a>s;s++)this.inject(arguments[s]);return this},extend:function(){for(var t,e=this,n=0,r=arguments.length;r>n&&!(t=arguments[n].initialize);n++);return t=t||function(){e.apply(this,arguments)},t.prototype=h(this.prototype),t.base=e,c(t.prototype,"constructor",{value:t,writable:!0,configurable:!0}),i(t,this,!0),arguments.length?this.inject.apply(t,arguments):t}},!0).inject({inject:function(){for(var t=0,e=arguments.length;e>t;t++){var n=arguments[t];n&&i(this,n,n.enumerable,n.beans,n.preserve)}return this},extend:function(){var t=h(this);return t.inject.apply(t,arguments)},each:function(t,e){return n(this,t,e)},set:function(t){return r(this,t)},clone:function(){return new this.constructor(this)},statics:{each:n,create:h,define:c,describe:u,set:r,clone:function(t){return r(new t.constructor,t)},isPlainObject:function(t){var i=null!=t&&t.constructor;return i&&(i===Object||i===e||"Object"===i.name)},pick:function(e,i){return e!==t?e:i}}})};"undefined"!=typeof module&&(module.exports=e),e.inject({toString:function(){return null!=this._id?(this._class||"Object")+(this._name?" '"+this._name+"'":" @"+this._id):"{ "+e.each(this,function(t,e){if(!/^_/.test(e)){var i=typeof t;this.push(e+": "+("number"===i?a.instance.number(t):"string"===i?"'"+t+"'":t))}},[]).join(", ")+" }"},getClassName:function(){return this._class||""},exportJSON:function(t){return e.exportJSON(this,t)},toJSON:function(){return e.serialize(this)},_set:function(i,n,r){if(i&&(r||e.isPlainObject(i))){var s=i._filtering||i;for(var a in s)if(s.hasOwnProperty(a)&&(!n||!n[a])){var o=i[a];o!==t&&(this[a]=o)}return!0}},statics:{exports:{enumerable:!0},extend:function ne(){var t=ne.base.apply(this,arguments),i=t.prototype._class;return i&&!e.exports[i]&&(e.exports[i]=t),t},equals:function(t,i){function n(t,e){for(var i in t)if(t.hasOwnProperty(i)&&!e.hasOwnProperty(i))return!1;return!0}if(t===i)return!0;if(t&&t.equals)return t.equals(i);if(i&&i.equals)return i.equals(t);if(Array.isArray(t)&&Array.isArray(i)){if(t.length!==i.length)return!1;for(var r=0,s=t.length;s>r;r++)if(!e.equals(t[r],i[r]))return!1;return!0}if(t&&"object"==typeof t&&i&&"object"==typeof i){if(!n(t,i)||!n(i,t))return!1;for(var r in t)if(t.hasOwnProperty(r)&&!e.equals(t[r],i[r]))return!1;return!0}return!1},read:function(i,n,r,s){if(this===e){var a=this.peek(i,n);return i.__index++,a}var o=this.prototype,h=o._readIndex,u=n||h&&i.__index||0;s||(s=i.length-u);var l=i[u];return l instanceof this||r&&r.readNull&&null==l&&1>=s?(h&&(i.__index=u+1),l&&r&&r.clone?l.clone():l):(l=e.create(this.prototype),h&&(l.__read=!0),l=l.initialize.apply(l,u>0||s<i.length?Array.prototype.slice.call(i,u,u+s):i)||l,h&&(i.__index=u+l.__read,l.__read=t),l)},peek:function(t,e){return t[t.__index=e||t.__index||0]},remain:function(t){return t.length-(t.__index||0)},readAll:function(t,e,i){for(var n,r=[],s=e||0,a=t.length;a>s;s++)r.push(Array.isArray(n=t[s])?this.read(n,0,i):this.read(t,s,i,1));return r},readNamed:function(i,n,r,s,a){var o=this.getNamed(i,n),h=o!==t;if(h){var u=i._filtered;u||(u=i._filtered=e.create(i[0]),u._filtering=i[0]),u[n]=t}return this.read(h?[o]:i,r,s,a)},getNamed:function(i,n){var r=i[0];return i._hasObject===t&&(i._hasObject=1===i.length&&e.isPlainObject(r)),i._hasObject?n?r[n]:i._filtered||r:t},hasNamed:function(t,e){return!!this.getNamed(t,e)},isPlainValue:function(t,e){return this.isPlainObject(t)||Array.isArray(t)||e&&"string"==typeof t},serialize:function(t,i,n,r){i=i||{};var s,o=!r;if(o&&(i.formatter=new a(i.precision),r={length:0,definitions:{},references:{},add:function(t,e){var i="#"+t._id,n=this.references[i];if(!n){this.length++;var r=e.call(t),s=t._class;s&&r[0]!==s&&r.unshift(s),this.definitions[i]=r,n=this.references[i]=[i]}return n}}),t&&t._serialize){s=t._serialize(i,r);var h=t._class;!h||n||s._compact||s[0]===h||s.unshift(h)}else if(Array.isArray(t)){s=[];for(var u=0,l=t.length;l>u;u++)s[u]=e.serialize(t[u],i,n,r);n&&(s._compact=!0)}else if(e.isPlainObject(t)){s={};for(var u in t)t.hasOwnProperty(u)&&(s[u]=e.serialize(t[u],i,n,r))}else s="number"==typeof t?i.formatter.number(t,i.precision):t;return o&&r.length>0?[["dictionary",r.definitions],s]:s},deserialize:function(t,i,n){var r=t,s=!n;if(n=n||{},Array.isArray(t)){var a=t[0],o="dictionary"===a;if(!o){if(n.dictionary&&1==t.length&&/^#/.test(a))return n.dictionary[a];a=e.exports[a]}r=[];for(var h=a?1:0,u=t.length;u>h;h++)r.push(e.deserialize(t[h],i,n));if(o)n.dictionary=r[0];else if(a){var l=r;i?r=i(a,l):(r=e.create(a.prototype),a.apply(r,l))}}else if(e.isPlainObject(t)){r={};for(var c in t)r[c]=e.deserialize(t[c],i,n)}return s&&t&&t.length&&"dictionary"===t[0][0]?r[1]:r},exportJSON:function(t,i){var n=e.serialize(t,i);return i&&i.asString===!1?n:JSON.stringify(n)},importJSON:function(t,i){return e.deserialize("string"==typeof t?JSON.parse(t):t,function(t,n){var r=i&&i.constructor===t?i:e.create(t.prototype),s=r===i;if(1===n.length&&r instanceof w&&(s||!(r instanceof b))){var a=n[0];e.isPlainObject(a)&&(a.insert=!1)}return t.apply(r,n),s&&(i=null),r})},splice:function(e,i,n,r){var s=i&&i.length,a=n===t;n=a?e.length:n,n>e.length&&(n=e.length);for(var o=0;s>o;o++)i[o]._index=n+o;if(a)return e.push.apply(e,i),[];var h=[n,r];i&&h.push.apply(h,i);for(var u=e.splice.apply(e,h),o=0,l=u.length;l>o;o++)u[o]._index=t;for(var o=n+s,l=e.length;l>o;o++)e[o]._index=o;return u},capitalize:function(t){return t.replace(/\b[a-z]/g,function(t){return t.toUpperCase()})},camelize:function(t){return t.replace(/-(.)/g,function(t,e){return e.toUpperCase()})},hyphenate:function(t){return t.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase()}}});var n={on:function(t,i){if("string"!=typeof t)e.each(t,function(t,e){this.on(e,t)},this);else{var n=this._eventTypes[t];if(n){var r=this._callbacks=this._callbacks||{};r=r[t]=r[t]||[],-1===r.indexOf(i)&&(r.push(i),n.install&&1==r.length&&n.install.call(this,t))}}return this},off:function(i,n){if("string"!=typeof i)return e.each(i,function(t,e){this.off(e,t)},this),t;var r,s=this._eventTypes[i],a=this._callbacks&&this._callbacks[i];return s&&a&&(!n||-1!==(r=a.indexOf(n))&&1===a.length?(s.uninstall&&s.uninstall.call(this,i),delete this._callbacks[i]):-1!==r&&a.splice(r,1)),this},once:function(t,e){return this.on(t,function(){e.apply(this,arguments),this.off(t,e)})},emit:function(t,e){var i=this._callbacks&&this._callbacks[t];if(!i)return!1;for(var n=[].slice.call(arguments,1),r=0,s=i.length;s>r;r++)if(i[r].apply(this,n)===!1&&e&&e.stop){e.stop();break}return!0},responds:function(t){return!(!this._callbacks||!this._callbacks[t])},attach:"#on",detach:"#off",fire:"#emit",_installEvents:function(t){var e=this._callbacks,i=t?"install":"uninstall";for(var n in e)if(e[n].length>0){var r=this._eventTypes[n],s=r[i];s&&s.call(this,n)}},statics:{inject:function re(t){var i=t._events;if(i){var n={};e.each(i,function(i,r){var s="string"==typeof i,a=s?i:r,o=e.capitalize(a),h=a.substring(2).toLowerCase();n[h]=s?{}:i,a="_"+a,t["get"+o]=function(){return this[a]},t["set"+o]=function(t){var e=this[a];e&&this.off(h,e),t&&this.on(h,t),this[a]=t}}),t._eventTypes=n}return re.base.apply(this,arguments)}}},r=e.extend({_class:"PaperScope",initialize:function se(){paper=this,this.settings=new e({applyMatrix:!0,handleSize:4,hitTolerance:0}),this.project=null,this.projects=[],this.tools=[],this.palettes=[],this._id=se._id++,se._scopes[this._id]=this;var t=se.prototype;if(!this.support){var i=Q.getContext(1,1);t.support={nativeDash:"setLineDash"in i||"mozDash"in i,nativeBlendModes:te.nativeModes},Q.release(i)}if(!this.browser){var n=t.browser={};navigator.userAgent.toLowerCase().replace(/(opera|chrome|safari|webkit|firefox|msie|trident|atom)\/?\s*([.\d]+)(?:.*version\/([.\d]+))?(?:.*rv\:([.\d]+))?/g,function(t,e,i,r,s){if(!n.chrome){var a="opera"===e?r:i;"trident"===e&&(a=s,e="msie"),n.version=a,n.versionNumber=parseFloat(a),n.name=e,n[e]=!0}}),n.chrome&&delete n.webkit,n.atom&&delete n.chrome}},version:"0.9.22",getView:function(){return this.project&&this.project.getView()},getPaper:function(){return this},execute:function(t,e,i){paper.PaperScript.execute(t,this,e,i),W.updateFocus()},install:function(t){var i=this;e.each(["project","view","tool"],function(n){e.define(t,n,{configurable:!0,get:function(){return i[n]}})});for(var n in this)!/^_/.test(n)&&this[n]&&(t[n]=this[n])},setup:function(t){return paper=this,this.project=new p(t),this},activate:function(){paper=this},clear:function(){for(var t=this.projects.length-1;t>=0;t--)this.projects[t].remove();for(var t=this.tools.length-1;t>=0;t--)this.tools[t].remove();for(var t=this.palettes.length-1;t>=0;t--)this.palettes[t].remove()},remove:function(){this.clear(),delete r._scopes[this._id]},statics:new function(){function t(t){return t+="Attribute",function(e,i){return e[t](i)||e[t]("data-paper-"+i)}}return{_scopes:{},_id:0,get:function(t){return this._scopes[t]||null},getAttribute:t("get"),hasAttribute:t("has")}}}),s=e.extend(n,{initialize:function(t){this._scope=paper,this._index=this._scope[this._list].push(this)-1,(t||!this._scope[this._reference])&&this.activate()},activate:function(){if(!this._scope)return!1;var t=this._scope[this._reference];return t&&t!==this&&t.emit("deactivate"),this._scope[this._reference]=this,this.emit("activate",t),!0},isActive:function(){return this._scope[this._reference]===this},remove:function(){return null==this._index?!1:(e.splice(this._scope[this._list],null,this._index,1),this._scope[this._reference]==this&&(this._scope[this._reference]=null),this._scope=null,!0)}}),a=e.extend({initialize:function(t){this.precision=t||5,this.multiplier=Math.pow(10,this.precision)},number:function(t){return Math.round(t*this.multiplier)/this.multiplier},pair:function(t,e,i){return this.number(t)+(i||",")+this.number(e)},point:function(t,e){return this.number(t.x)+(e||",")+this.number(t.y)},size:function(t,e){return this.number(t.width)+(e||",")+this.number(t.height)},rectangle:function(t,e){return this.point(t,e)+(e||",")+this.size(t,e)}});a.instance=new a;var o=new function(){var t=[[.5773502691896257],[0,.7745966692414834],[.33998104358485626,.8611363115940526],[0,.5384693101056831,.906179845938664],[.2386191860831969,.6612093864662645,.932469514203152],[0,.4058451513773972,.7415311855993945,.9491079123427585],[.1834346424956498,.525532409916329,.7966664774136267,.9602898564975363],[0,.3242534234038089,.6133714327005904,.8360311073266358,.9681602395076261],[.14887433898163122,.4333953941292472,.6794095682990244,.8650633666889845,.9739065285171717],[0,.26954315595234496,.5190961292068118,.7301520055740494,.8870625997680953,.978228658146057],[.1252334085114689,.3678314989981802,.5873179542866175,.7699026741943047,.9041172563704749,.9815606342467192],[0,.2304583159551348,.44849275103644687,.6423493394403402,.8015780907333099,.9175983992229779,.9841830547185881],[.10805494870734367,.31911236892788974,.5152486363581541,.6872929048116855,.827201315069765,.9284348836635735,.9862838086968123],[0,.20119409399743451,.3941513470775634,.5709721726085388,.7244177313601701,.8482065834104272,.937273392400706,.9879925180204854],[.09501250983763744,.2816035507792589,.45801677765722737,.6178762444026438,.755404408355003,.8656312023878318,.9445750230732326,.9894009349916499]],e=[[1],[.8888888888888888,.5555555555555556],[.6521451548625461,.34785484513745385],[.5688888888888889,.47862867049936647,.23692688505618908],[.46791393457269104,.3607615730481386,.17132449237917036],[.4179591836734694,.3818300505051189,.27970539148927664,.1294849661688697],[.362683783378362,.31370664587788727,.22238103445337448,.10122853629037626],[.3302393550012598,.31234707704000286,.26061069640293544,.1806481606948574,.08127438836157441],[.29552422471475287,.26926671930999635,.21908636251598204,.1494513491505806,.06667134430868814],[.2729250867779006,.26280454451024665,.23319376459199048,.18629021092773426,.1255803694649046,.05566856711617366],[.24914704581340277,.2334925365383548,.20316742672306592,.16007832854334622,.10693932599531843,.04717533638651183],[.2325515532308739,.22628318026289723,.2078160475368885,.17814598076194574,.13887351021978725,.09212149983772845,.04048400476531588],[.2152638534631578,.2051984637212956,.18553839747793782,.15720316715819355,.12151857068790319,.08015808715976021,.03511946033175186],[.2025782419255613,.19843148532711158,.1861610000155622,.16626920581699392,.13957067792615432,.10715922046717194,.07036604748810812,.03075324199611727],[.1894506104550685,.18260341504492358,.16915651939500254,.14959598881657674,.12462897125553388,.09515851168249279,.062253523938647894,.027152459411754096]],i=Math.abs,n=Math.sqrt,r=Math.pow,s=1e-6,a=1e-12,h=1.12e-16;return{TOLERANCE:s,EPSILON:a,MACHINE_EPSILON:h,KAPPA:4*(n(2)-1)/3,isZero:function(t){return i(t)<=a},integrate:function(i,n,r,s){for(var a=t[s-2],o=e[s-2],h=.5*(r-n),u=h+n,l=0,c=s+1>>1,d=1&s?o[l++]*i(u):0;c>l;){var _=h*a[l];d+=o[l++]*(i(u+_)+i(u-_))}return h*d},findRoot:function(t,e,n,r,s,a,o){for(var h=0;a>h;h++){var u=t(n),l=u/e(n),c=n-l;if(i(l)<o)return c;u>0?(s=n,n=r>=c?.5*(r+s):c):(r=n,n=c>=s?.5*(r+s):c)}return n},solveQuadratic:function(t,e,r,s,a,o){var u,l,c=0,d=1/0,_=e;if(e/=2,l=e*e-t*r,i(l)<h){var f=Math.pow,g=f(i(t*e*r),1/3);if(1e-8>g){var v=f(10,i(Math.floor(Math.log(g)*Math.LOG10E)));isFinite(v)||(v=0),t*=v,e*=v,r*=v,l=e*e-t*r}}if(i(t)<h){if(i(_)<h)return i(r)<h?-1:0;u=-r/_}else if(l>=-h){l=0>l?0:l;var m=n(l);if(e>=h&&h>=e)u=i(t)>=i(r)?m/t:-r/m,d=-u;else{var p=-(e+(0>e?-1:1)*m);u=p/t,d=r/p}}return isFinite(u)&&(null==a||u>=a&&o>=u)&&(s[c++]=u),d!==u&&isFinite(d)&&(null==a||d>=a&&o>=d)&&(s[c++]=d),c},solveCubic:function(t,e,s,a,u,l,c){var d,_,f,g=0;if(0===t)t=e,_=s,f=a,d=1/0;else if(0===a)_=e,f=s,d=0;else{var v,m,p,y,w,x,b,C=1+h;if(d=-(e/t)/3,b=t*d,_=b+e,f=_*d+s,p=(b+_)*d+f,m=f*d+a,y=m/t,w=r(i(y),1/3),x=0>y?-1:1,y=-p/t,w=y>0?1.3247179572*Math.max(w,n(y)):w,v=d-x*w,v!==d){do if(d=v,b=t*d,_=b+e,f=_*d+s,p=(b+_)*d+f,m=f*d+a,v=0===p?d:d-m/p/C,v===d){d=v;break}while(x*v>x*d);i(t)*d*d>i(a/d)&&(f=-a/d,_=(f-s)/d)}}var g=o.solveQuadratic(t,_,f,u,l,c);return isFinite(d)&&(0===g||d!==u[g-1])&&(null==l||d>=l&&c>=d)&&(u[g++]=d),g}}},h=e.extend({_class:"Point",_readIndex:!0,initialize:function(t,e){var i=typeof t;if("number"===i){var n="number"==typeof e;this.x=t,this.y=n?e:t,this.__read&&(this.__read=n?2:1)}else"undefined"===i||null===t?(this.x=this.y=0,this.__read&&(this.__read=null===t?1:0)):(Array.isArray(t)?(this.x=t[0],this.y=t.length>1?t[1]:t[0]):null!=t.x?(this.x=t.x,this.y=t.y):null!=t.width?(this.x=t.width,this.y=t.height):null!=t.angle?(this.x=t.length,this.y=0,this.setAngle(t.angle)):(this.x=this.y=0,this.__read&&(this.__read=0)),this.__read&&(this.__read=1))},set:function(t,e){return this.x=t,this.y=e,this},equals:function(t){return this===t||t&&(this.x===t.x&&this.y===t.y||Array.isArray(t)&&this.x===t[0]&&this.y===t[1])||!1},clone:function(){return new h(this.x,this.y)},toString:function(){var t=a.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.x),e.number(this.y)]},getLength:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},setLength:function(t){if(this.isZero()){var e=this._angle||0;this.set(Math.cos(e)*t,Math.sin(e)*t)}else{var i=t/this.getLength();o.isZero(i)&&this.getAngle(),this.set(this.x*i,this.y*i)}},getAngle:function(){return 180*this.getAngleInRadians.apply(this,arguments)/Math.PI},setAngle:function(t){this.setAngleInRadians.call(this,t*Math.PI/180)},getAngleInDegrees:"#getAngle",setAngleInDegrees:"#setAngle",getAngleInRadians:function(){if(arguments.length){var t=h.read(arguments),e=this.getLength()*t.getLength();if(o.isZero(e))return 0/0;var i=this.dot(t)/e;return Math.acos(-1>i?-1:i>1?1:i)}return this.isZero()?this._angle||0:this._angle=Math.atan2(this.y,this.x)},setAngleInRadians:function(t){if(this._angle=t,!this.isZero()){var e=this.getLength();this.set(Math.cos(t)*e,Math.sin(t)*e)}},getQuadrant:function(){return this.x>=0?this.y>=0?1:4:this.y>=0?2:3}},{beans:!1,getDirectedAngle:function(){var t=h.read(arguments);return 180*Math.atan2(this.cross(t),this.dot(t))/Math.PI},getDistance:function(){var t=h.read(arguments),i=t.x-this.x,n=t.y-this.y,r=i*i+n*n,s=e.read(arguments);return s?r:Math.sqrt(r)},normalize:function(e){e===t&&(e=1);var i=this.getLength(),n=0!==i?e/i:0,r=new h(this.x*n,this.y*n);return n>=0&&(r._angle=this._angle),r},rotate:function(t,e){if(0===t)return this.clone();t=t*Math.PI/180;var i=e?this.subtract(e):this,n=Math.sin(t),r=Math.cos(t);return i=new h(i.x*r-i.y*n,i.x*n+i.y*r),e?i.add(e):i},transform:function(t){return t?t._transformPoint(this):this},add:function(){var t=h.read(arguments);return new h(this.x+t.x,this.y+t.y)},subtract:function(){var t=h.read(arguments);return new h(this.x-t.x,this.y-t.y)},multiply:function(){var t=h.read(arguments);return new h(this.x*t.x,this.y*t.y)},divide:function(){var t=h.read(arguments);return new h(this.x/t.x,this.y/t.y)},modulo:function(){var t=h.read(arguments);return new h(this.x%t.x,this.y%t.y)},negate:function(){return new h(-this.x,-this.y)},isInside:function(){return _.read(arguments).contains(this)},isClose:function(t,e){return this.getDistance(t)<e},isColinear:function(t){return Math.abs(this.cross(t))<1e-12},isOrthogonal:function(t){return Math.abs(this.dot(t))<1e-12},isZero:function(){return o.isZero(this.x)&&o.isZero(this.y)},isNaN:function(){return isNaN(this.x)||isNaN(this.y)},dot:function(){var t=h.read(arguments);return this.x*t.x+this.y*t.y},cross:function(){var t=h.read(arguments);return this.x*t.y-this.y*t.x},project:function(){var t=h.read(arguments);if(t.isZero())return new h(0,0);var e=this.dot(t)/t.dot(t);return new h(t.x*e,t.y*e)},statics:{min:function(){var t=h.read(arguments),e=h.read(arguments);return new h(Math.min(t.x,e.x),Math.min(t.y,e.y))},max:function(){var t=h.read(arguments),e=h.read(arguments);return new h(Math.max(t.x,e.x),Math.max(t.y,e.y))},random:function(){return new h(Math.random(),Math.random())}}},e.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new h(e(this.x),e(this.y))}},{})),u=h.extend({initialize:function(t,e,i,n){this._x=t,this._y=e,this._owner=i,this._setter=n},set:function(t,e,i){return this._x=t,this._y=e,i||this._owner[this._setter](this),this},getX:function(){return this._x},setX:function(t){this._x=t,this._owner[this._setter](this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner[this._setter](this)}}),c=e.extend({_class:"Size",_readIndex:!0,initialize:function(t,e){var i=typeof t;if("number"===i){var n="number"==typeof e;this.width=t,this.height=n?e:t,this.__read&&(this.__read=n?2:1)}else"undefined"===i||null===t?(this.width=this.height=0,this.__read&&(this.__read=null===t?1:0)):(Array.isArray(t)?(this.width=t[0],this.height=t.length>1?t[1]:t[0]):null!=t.width?(this.width=t.width,this.height=t.height):null!=t.x?(this.width=t.x,this.height=t.y):(this.width=this.height=0,this.__read&&(this.__read=0)),this.__read&&(this.__read=1))},set:function(t,e){return this.width=t,this.height=e,this},equals:function(t){return t===this||t&&(this.width===t.width&&this.height===t.height||Array.isArray(t)&&this.width===t[0]&&this.height===t[1])||!1},clone:function(){return new c(this.width,this.height)},toString:function(){var t=a.instance;return"{ width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.width),e.number(this.height)]},add:function(){var t=c.read(arguments);return new c(this.width+t.width,this.height+t.height)},subtract:function(){var t=c.read(arguments);return new c(this.width-t.width,this.height-t.height)},multiply:function(){var t=c.read(arguments);return new c(this.width*t.width,this.height*t.height)},divide:function(){var t=c.read(arguments);return new c(this.width/t.width,this.height/t.height)},modulo:function(){var t=c.read(arguments);return new c(this.width%t.width,this.height%t.height)},negate:function(){return new c(-this.width,-this.height)},isZero:function(){return o.isZero(this.width)&&o.isZero(this.height)},isNaN:function(){return isNaN(this.width)||isNaN(this.height)},statics:{min:function(t,e){return new c(Math.min(t.width,e.width),Math.min(t.height,e.height))},max:function(t,e){return new c(Math.max(t.width,e.width),Math.max(t.height,e.height))},random:function(){return new c(Math.random(),Math.random())}}},e.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new c(e(this.width),e(this.height))}},{})),d=c.extend({initialize:function(t,e,i,n){this._width=t,this._height=e,this._owner=i,this._setter=n},set:function(t,e,i){return this._width=t,this._height=e,i||this._owner[this._setter](this),this},getWidth:function(){return this._width},setWidth:function(t){this._width=t,this._owner[this._setter](this)},getHeight:function(){return this._height},setHeight:function(t){this._height=t,this._owner[this._setter](this)}}),_=e.extend({_class:"Rectangle",_readIndex:!0,beans:!0,initialize:function(i,n,r,s){var a=typeof i,o=0;if("number"===a?(this.x=i,this.y=n,this.width=r,this.height=s,o=4):"undefined"===a||null===i?(this.x=this.y=this.width=this.height=0,o=null===i?1:0):1===arguments.length&&(Array.isArray(i)?(this.x=i[0],this.y=i[1],this.width=i[2],this.height=i[3],o=1):i.x!==t||i.width!==t?(this.x=i.x||0,this.y=i.y||0,this.width=i.width||0,this.height=i.height||0,o=1):i.from===t&&i.to===t&&(this.x=this.y=this.width=this.height=0,this._set(i),o=1)),!o){var u=h.readNamed(arguments,"from"),l=e.peek(arguments);if(this.x=u.x,this.y=u.y,l&&l.x!==t||e.hasNamed(arguments,"to")){var d=h.readNamed(arguments,"to");this.width=d.x-u.x,this.height=d.y-u.y,this.width<0&&(this.x=d.x,this.width=-this.width),this.height<0&&(this.y=d.y,this.height=-this.height)}else{var _=c.read(arguments);this.width=_.width,this.height=_.height}o=arguments.__index}this.__read&&(this.__read=o)},set:function(t,e,i,n){return this.x=t,this.y=e,this.width=i,this.height=n,this},clone:function(){return new _(this.x,this.y,this.width,this.height)},equals:function(t){var i=e.isPlainValue(t)?_.read(arguments):t;return i===this||i&&this.x===i.x&&this.y===i.y&&this.width===i.width&&this.height===i.height||!1},toString:function(){var t=a.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+", width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.x),e.number(this.y),e.number(this.width),e.number(this.height)]},getPoint:function(t){var e=t?h:u;return new e(this.x,this.y,this,"setPoint")},setPoint:function(){var t=h.read(arguments);this.x=t.x,this.y=t.y},getSize:function(t){var e=t?c:d;return new e(this.width,this.height,this,"setSize")},setSize:function(){var t=c.read(arguments);this._fixX&&(this.x+=(this.width-t.width)*this._fixX),this._fixY&&(this.y+=(this.height-t.height)*this._fixY),this.width=t.width,this.height=t.height,this._fixW=1,this._fixH=1},getLeft:function(){return this.x},setLeft:function(t){this._fixW||(this.width-=t-this.x),this.x=t,this._fixX=0},getTop:function(){return this.y},setTop:function(t){this._fixH||(this.height-=t-this.y),this.y=t,this._fixY=0},getRight:function(){return this.x+this.width},setRight:function(e){this._fixX!==t&&1!==this._fixX&&(this._fixW=0),this._fixW?this.x=e-this.width:this.width=e-this.x,this._fixX=1},getBottom:function(){return this.y+this.height},setBottom:function(e){this._fixY!==t&&1!==this._fixY&&(this._fixH=0),this._fixH?this.y=e-this.height:this.height=e-this.y,this._fixY=1},getCenterX:function(){return this.x+.5*this.width},setCenterX:function(t){this.x=t-.5*this.width,this._fixX=.5},getCenterY:function(){return this.y+.5*this.height},setCenterY:function(t){this.y=t-.5*this.height,this._fixY=.5},getCenter:function(t){var e=t?h:u;return new e(this.getCenterX(),this.getCenterY(),this,"setCenter")},setCenter:function(){var t=h.read(arguments);return this.setCenterX(t.x),this.setCenterY(t.y),this},getArea:function(){return this.width*this.height},isEmpty:function(){return 0===this.width||0===this.height},contains:function(e){return e&&e.width!==t||4==(Array.isArray(e)?e:arguments).length?this._containsRectangle(_.read(arguments)):this._containsPoint(h.read(arguments))},_containsPoint:function(t){var e=t.x,i=t.y;return e>=this.x&&i>=this.y&&e<=this.x+this.width&&i<=this.y+this.height},_containsRectangle:function(t){var e=t.x,i=t.y;return e>=this.x&&i>=this.y&&e+t.width<=this.x+this.width&&i+t.height<=this.y+this.height},intersects:function(){var t=_.read(arguments);return t.x+t.width>this.x&&t.y+t.height>this.y&&t.x<this.x+this.width&&t.y<this.y+this.height},touches:function(){var t=_.read(arguments);return t.x+t.width>=this.x&&t.y+t.height>=this.y&&t.x<=this.x+this.width&&t.y<=this.y+this.height},intersect:function(){var t=_.read(arguments),e=Math.max(this.x,t.x),i=Math.max(this.y,t.y),n=Math.min(this.x+this.width,t.x+t.width),r=Math.min(this.y+this.height,t.y+t.height);return new _(e,i,n-e,r-i)},unite:function(){var t=_.read(arguments),e=Math.min(this.x,t.x),i=Math.min(this.y,t.y),n=Math.max(this.x+this.width,t.x+t.width),r=Math.max(this.y+this.height,t.y+t.height);return new _(e,i,n-e,r-i)},include:function(){var t=h.read(arguments),e=Math.min(this.x,t.x),i=Math.min(this.y,t.y),n=Math.max(this.x+this.width,t.x),r=Math.max(this.y+this.height,t.y);return new _(e,i,n-e,r-i)},expand:function(){var t=c.read(arguments),e=t.width,i=t.height;return new _(this.x-e/2,this.y-i/2,this.width+e,this.height+i)},scale:function(e,i){return this.expand(this.width*e-this.width,this.height*(i===t?e:i)-this.height)}},e.each([["Top","Left"],["Top","Right"],["Bottom","Left"],["Bottom","Right"],["Left","Center"],["Top","Center"],["Right","Center"],["Bottom","Center"]],function(t,e){var i=t.join(""),n=/^[RL]/.test(i);e>=4&&(t[1]+=n?"Y":"X");var r=t[n?0:1],s=t[n?1:0],a="get"+r,o="get"+s,l="set"+r,c="set"+s,d="get"+i,_="set"+i;this[d]=function(t){var e=t?h:u;return new e(this[a](),this[o](),this,_)},this[_]=function(){var t=h.read(arguments);this[l](t.x),this[c](t.y)}},{beans:!0})),f=_.extend({initialize:function(t,e,i,n,r,s){this.set(t,e,i,n,!0),this._owner=r,this._setter=s},set:function(t,e,i,n,r){return this._x=t,this._y=e,this._width=i,this._height=n,r||this._owner[this._setter](this),this}},new function(){var t=_.prototype;return e.each(["x","y","width","height"],function(t){var i=e.capitalize(t),n="_"+t;this["get"+i]=function(){return this[n]},this["set"+i]=function(t){this[n]=t,this._dontNotify||this._owner[this._setter](this)}},e.each(["Point","Size","Center","Left","Top","Right","Bottom","CenterX","CenterY","TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],function(e){var i="set"+e;this[i]=function(){this._dontNotify=!0,t[i].apply(this,arguments),this._dontNotify=!1,this._owner[this._setter](this)}},{isSelected:function(){return this._owner._boundsSelected},setSelected:function(t){var e=this._owner;e.setSelected&&(e._boundsSelected=t,e.setSelected(t||e._selectedSegmentState>0))}}))}),g=e.extend({_class:"Matrix",initialize:function ae(t){var e=arguments.length,i=!0;if(6===e?this.set.apply(this,arguments):1===e?t instanceof ae?this.set(t._a,t._c,t._b,t._d,t._tx,t._ty):Array.isArray(t)?this.set.apply(this,t):i=!1:0===e?this.reset():i=!1,!i)throw Error("Unsupported matrix parameters")},set:function(t,e,i,n,r,s,a){return this._a=t,this._c=e,this._b=i,this._d=n,this._tx=r,this._ty=s,a||this._changed(),this},_serialize:function(t){return e.serialize(this.getValues(),t)},_changed:function(){var t=this._owner;t&&(t._applyMatrix?t.transform(null,!0):t._changed(9))},clone:function(){return new g(this._a,this._c,this._b,this._d,this._tx,this._ty)},equals:function(t){return t===this||t&&this._a===t._a&&this._b===t._b&&this._c===t._c&&this._d===t._d&&this._tx===t._tx&&this._ty===t._ty||!1},toString:function(){var t=a.instance;return"[["+[t.number(this._a),t.number(this._b),t.number(this._tx)].join(", ")+"], ["+[t.number(this._c),t.number(this._d),t.number(this._ty)].join(", ")+"]]"},reset:function(t){return this._a=this._d=1,this._c=this._b=this._tx=this._ty=0,t||this._changed(),this},apply:function(t,i){var n=this._owner;return n?(n.transform(null,!0,e.pick(t,!0),i),this.isIdentity()):!1},translate:function(){var t=h.read(arguments),e=t.x,i=t.y;return this._tx+=e*this._a+i*this._b,this._ty+=e*this._c+i*this._d,this._changed(),this},scale:function(){var t=h.read(arguments),e=h.read(arguments,0,{readNull:!0});return e&&this.translate(e),this._a*=t.x,this._c*=t.x,this._b*=t.y,this._d*=t.y,e&&this.translate(e.negate()),this._changed(),this},rotate:function(t){t*=Math.PI/180;var e=h.read(arguments,1),i=e.x,n=e.y,r=Math.cos(t),s=Math.sin(t),a=i-i*r+n*s,o=n-i*s-n*r,u=this._a,l=this._b,c=this._c,d=this._d;return this._a=r*u+s*l,this._b=-s*u+r*l,this._c=r*c+s*d,this._d=-s*c+r*d,this._tx+=a*u+o*l,this._ty+=a*c+o*d,this._changed(),this},shear:function(){var t=h.read(arguments),e=h.read(arguments,0,{readNull:!0});e&&this.translate(e);var i=this._a,n=this._c;return this._a+=t.y*this._b,this._c+=t.y*this._d,this._b+=t.x*i,this._d+=t.x*n,e&&this.translate(e.negate()),this._changed(),this},skew:function(){var t=h.read(arguments),e=h.read(arguments,0,{readNull:!0}),i=Math.PI/180,n=new h(Math.tan(t.x*i),Math.tan(t.y*i));return this.shear(n,e)},concatenate:function(t){var e=this._a,i=this._b,n=this._c,r=this._d,s=t._a,a=t._b,o=t._c,h=t._d,u=t._tx,l=t._ty;return this._a=s*e+o*i,this._b=a*e+h*i,this._c=s*n+o*r,this._d=a*n+h*r,this._tx+=u*e+l*i,this._ty+=u*n+l*r,this._changed(),this},preConcatenate:function(t){var e=this._a,i=this._b,n=this._c,r=this._d,s=this._tx,a=this._ty,o=t._a,h=t._b,u=t._c,l=t._d,c=t._tx,d=t._ty;return this._a=o*e+h*n,this._b=o*i+h*r,this._c=u*e+l*n,this._d=u*i+l*r,this._tx=o*s+h*a+c,this._ty=u*s+l*a+d,this._changed(),this},chain:function(t){var e=this._a,i=this._b,n=this._c,r=this._d,s=this._tx,a=this._ty,o=t._a,h=t._b,u=t._c,l=t._d,c=t._tx,d=t._ty;return new g(o*e+u*i,o*n+u*r,h*e+l*i,h*n+l*r,s+c*e+d*i,a+c*n+d*r)},isIdentity:function(){return 1===this._a&&0===this._c&&0===this._b&&1===this._d&&0===this._tx&&0===this._ty},orNullIfIdentity:function(){return this.isIdentity()?null:this
},isInvertible:function(){return!!this._getDeterminant()},isSingular:function(){return!this._getDeterminant()},transform:function(t,e,i){return arguments.length<3?this._transformPoint(h.read(arguments)):this._transformCoordinates(t,e,i)},_transformPoint:function(t,e,i){var n=t.x,r=t.y;return e||(e=new h),e.set(n*this._a+r*this._b+this._tx,n*this._c+r*this._d+this._ty,i)},_transformCoordinates:function(t,e,i){for(var n=0,r=0,s=2*i;s>n;){var a=t[n++],o=t[n++];e[r++]=a*this._a+o*this._b+this._tx,e[r++]=a*this._c+o*this._d+this._ty}return e},_transformCorners:function(t){var e=t.x,i=t.y,n=e+t.width,r=i+t.height,s=[e,i,n,i,n,r,e,r];return this._transformCoordinates(s,s,4)},_transformBounds:function(t,e,i){for(var n=this._transformCorners(t),r=n.slice(0,2),s=n.slice(),a=2;8>a;a++){var o=n[a],h=1&a;o<r[h]?r[h]=o:o>s[h]&&(s[h]=o)}return e||(e=new _),e.set(r[0],r[1],s[0]-r[0],s[1]-r[1],i)},inverseTransform:function(){return this._inverseTransform(h.read(arguments))},_getDeterminant:function(){var t=this._a*this._d-this._b*this._c;return isFinite(t)&&!o.isZero(t)&&isFinite(this._tx)&&isFinite(this._ty)?t:null},_inverseTransform:function(t,e,i){var n=this._getDeterminant();if(!n)return null;var r=t.x-this._tx,s=t.y-this._ty;return e||(e=new h),e.set((r*this._d-s*this._b)/n,(s*this._a-r*this._c)/n,i)},decompose:function(){var t=this._a,e=this._b,i=this._c,n=this._d;if(o.isZero(t*n-e*i))return null;var r=Math.sqrt(t*t+e*e);t/=r,e/=r;var s=t*i+e*n;i-=t*s,n-=e*s;var a=Math.sqrt(i*i+n*n);return i/=a,n/=a,s/=a,e*i>t*n&&(t=-t,e=-e,s=-s,r=-r),{scaling:new h(r,a),rotation:180*-Math.atan2(e,t)/Math.PI,shearing:s}},getValues:function(){return[this._a,this._c,this._b,this._d,this._tx,this._ty]},getTranslation:function(){return new h(this._tx,this._ty)},getScaling:function(){return(this.decompose()||{}).scaling},getRotation:function(){return(this.decompose()||{}).rotation},inverted:function(){var t=this._getDeterminant();return t&&new g(this._d/t,-this._c/t,-this._b/t,this._a/t,(this._b*this._ty-this._d*this._tx)/t,(this._c*this._tx-this._a*this._ty)/t)},shiftless:function(){return new g(this._a,this._c,this._b,this._d,0,0)},applyToContext:function(t){t.transform(this._a,this._c,this._b,this._d,this._tx,this._ty)}},e.each(["a","c","b","d","tx","ty"],function(t){var i=e.capitalize(t),n="_"+t;this["get"+i]=function(){return this[n]},this["set"+i]=function(t){this[n]=t,this._changed()}},{})),v=e.extend({_class:"Line",initialize:function(t,e,i,n,r){var s=!1;arguments.length>=4?(this._px=t,this._py=e,this._vx=i,this._vy=n,s=r):(this._px=t.x,this._py=t.y,this._vx=e.x,this._vy=e.y,s=i),s||(this._vx-=this._px,this._vy-=this._py)},getPoint:function(){return new h(this._px,this._py)},getVector:function(){return new h(this._vx,this._vy)},getLength:function(){return this.getVector().getLength()},intersect:function(t,e){return v.intersect(this._px,this._py,this._vx,this._vy,t._px,t._py,t._vx,t._vy,!0,e)},getSide:function(t){return v.getSide(this._px,this._py,this._vx,this._vy,t.x,t.y,!0)},getDistance:function(t){return Math.abs(v.getSignedDistance(this._px,this._py,this._vx,this._vy,t.x,t.y,!0))},statics:{intersect:function(t,e,i,n,r,s,a,u,l,c){l||(i-=t,n-=e,a-=r,u-=s);var d=i*u-n*a;if(!o.isZero(d)){var _=t-r,f=e-s,g=(a*f-u*_)/d,v=(i*f-n*_)/d;if(c||g>=0&&1>=g&&v>=0&&1>=v)return new h(t+g*i,e+g*n)}},getSide:function(t,e,i,n,r,s,a){a||(i-=t,n-=e);var o=r-t,h=s-e,u=o*n-h*i;return 0===u&&(u=o*i+h*n,u>0&&(o-=i,h-=n,u=o*i+h*n,0>u&&(u=0))),0>u?-1:u>0?1:0},getSignedDistance:function(t,e,i,n,r,s,a){return a||(i-=t,n-=e),o.isZero(i)?n>=0?t-r:r-t:o.isZero(n)?i>=0?s-e:e-s:(i*(s-e)-n*(r-t))/Math.sqrt(i*i+n*n)}}}),p=s.extend({_class:"Project",_list:"projects",_reference:"project",initialize:function(t){s.call(this,!0),this.layers=[],this._activeLayer=null,this.symbols=[],this._currentStyle=new V(null,null,this),this._view=W.create(this,t||Q.getCanvas(1,1)),this._selectedItems={},this._selectedItemCount=0,this._updateVersion=0},_serialize:function(t,i){return e.serialize(this.layers,t,!0,i)},clear:function(){for(var t=this.layers.length-1;t>=0;t--)this.layers[t].remove();this.symbols=[]},isEmpty:function(){return 0===this.layers.length},remove:function oe(){return oe.base.call(this)?(this._view&&this._view.remove(),!0):!1},getView:function(){return this._view},getCurrentStyle:function(){return this._currentStyle},setCurrentStyle:function(t){this._currentStyle.initialize(t)},getIndex:function(){return this._index},getOptions:function(){return this._scope.settings},getActiveLayer:function(){return this._activeLayer||new b({project:this})},getSelectedItems:function(){var t=[];for(var e in this._selectedItems){var i=this._selectedItems[e];i.isInserted()&&t.push(i)}return t},insertChild:function(t,i,n){return i instanceof b?(i._remove(!1,!0),e.splice(this.layers,[i],t,0),i._setProject(this,!0),this._changes&&i._changed(5),this._activeLayer||(this._activeLayer=i)):i instanceof w?(this._activeLayer||this.insertChild(t,new b(w.NO_INSERT))).insertChild(t,i,n):i=null,i},addChild:function(e,i){return this.insertChild(t,e,i)},_updateSelection:function(t){var e=t._id,i=this._selectedItems;t._selected?i[e]!==t&&(this._selectedItemCount++,i[e]=t):i[e]===t&&(this._selectedItemCount--,delete i[e])},selectAll:function(){for(var t=this.layers,e=0,i=t.length;i>e;e++)t[e].setFullySelected(!0)},deselectAll:function(){var t=this._selectedItems;for(var e in t)t[e].setFullySelected(!1)},hitTest:function(){for(var t=h.read(arguments),i=M.getOptions(e.read(arguments)),n=this.layers.length-1;n>=0;n--){var r=this.layers[n]._hitTest(t,i);if(r)return r}return null},getItems:function(t){return w._getItems(this.layers,t)},getItem:function(t){return w._getItems(this.layers,t,null,null,!0)[0]||null},importJSON:function(t){this.activate();var i=this._activeLayer;return e.importJSON(t,i&&i.isEmpty()&&i)},draw:function(t,i,n){this._updateVersion++,t.save(),i.applyToContext(t);for(var r=new e({offset:new h(0,0),pixelRatio:n,viewMatrix:i.isIdentity()?null:i,matrices:[new g],updateMatrix:!0}),s=0,a=this.layers,o=a.length;o>s;s++)a[s].draw(t,r);if(t.restore(),this._selectedItemCount>0){t.save(),t.strokeWidth=1;var u=this._selectedItems,l=this._scope.settings.handleSize,c=this._updateVersion;for(var d in u)u[d]._drawSelection(t,i,l,u,c);t.restore()}}}),y=e.extend({_class:"Symbol",initialize:function he(t,e){this._id=he._id=(he._id||0)+1,this.project=paper.project,this.project.symbols.push(this),t&&this.setDefinition(t,e)},_serialize:function(t,i){return i.add(this,function(){return e.serialize([this._class,this._definition],t,!1,i)})},_changed:function(t){8&t&&w._clearBoundsCache(this),1&t&&(this.project._needsUpdate=!0)},getDefinition:function(){return this._definition},setDefinition:function(t,e){t._parentSymbol&&(t=t.clone()),this._definition&&(this._definition._parentSymbol=null),this._definition=t,t.remove(),t.setSelected(!1),e||t.setPosition(new h),t._parentSymbol=this,this._changed(9)},place:function(t){return new P(this,t)},clone:function(){return new y(this._definition.clone(!1))},equals:function(t){return t===this||t&&this.definition.equals(t.definition)||!1}}),w=e.extend(n,{statics:{extend:function ue(t){return t._serializeFields&&(t._serializeFields=new e(this.prototype._serializeFields,t._serializeFields)),ue.base.apply(this,arguments)},NO_INSERT:{insert:!1}},_class:"Item",_applyMatrix:!0,_canApplyMatrix:!0,_boundsSelected:!1,_selectChildren:!1,_serializeFields:{name:null,applyMatrix:null,matrix:new g,pivot:null,locked:!1,visible:!0,blendMode:"normal",opacity:1,guide:!1,selected:!1,clipMask:!1,data:{}},initialize:function(){},_initialize:function(t,i){var n=t&&e.isPlainObject(t),r=n&&t.internal===!0,s=this._matrix=new g,a=n&&t.project||paper.project;return r||(this._id=w._id=(w._id||0)+1),this._applyMatrix=this._canApplyMatrix&&paper.settings.applyMatrix,i&&s.translate(i),s._owner=this,this._style=new V(a._currentStyle,this,a),this._project||(r||n&&t.insert===!1?this._setProject(a):n&&t.parent?this.setParent(t.parent):(a._activeLayer||new b).addChild(this)),n&&t!==w.NO_INSERT&&this._set(t,{insert:!0,parent:!0},!0),n},_events:new function(){var t={mousedown:{mousedown:1,mousedrag:1,click:1,doubleclick:1},mouseup:{mouseup:1,mousedrag:1,click:1,doubleclick:1},mousemove:{mousedrag:1,mousemove:1,mouseenter:1,mouseleave:1}},i={install:function(e){var i=this.getView()._eventCounters;if(i)for(var n in t)i[n]=(i[n]||0)+(t[n][e]||0)},uninstall:function(e){var i=this.getView()._eventCounters;if(i)for(var n in t)i[n]-=t[n][e]||0}};return e.each(["onMouseDown","onMouseUp","onMouseDrag","onClick","onDoubleClick","onMouseMove","onMouseEnter","onMouseLeave"],function(t){this[t]=i},{onFrame:{install:function(){this._animateItem(!0)},uninstall:function(){this._animateItem(!1)}},onLoad:{}})},_animateItem:function(t){this.getView()._animateItem(this,t)},_serialize:function(t,i){function n(n){for(var a in n){var o=s[a];e.equals(o,"leading"===a?1.2*n.fontSize:n[a])||(r[a]=e.serialize(o,t,"data"!==a,i))}}var r={},s=this;return n(this._serializeFields),this instanceof x||n(this._style._defaults),[this._class,r]},_changed:function(e){var i=this._parentSymbol,n=this._parent||i,r=this._project;if(8&e&&(this._bounds=this._position=this._decomposed=this._globalMatrix=this._currentPath=t),n&&40&e&&w._clearBoundsCache(n),2&e&&w._clearBoundsCache(this),r&&(1&e&&(r._needsUpdate=!0),r._changes)){var s=r._changesById[this._id];s?s.flags|=e:(s={item:this,flags:e},r._changesById[this._id]=s,r._changes.push(s))}i&&i._changed(e)},set:function(t){return t&&this._set(t),this},getId:function(){return this._id},getName:function(){return this._name},setName:function(e,i){if(this._name&&this._removeNamed(),e===+e+"")throw Error("Names consisting only of numbers are not supported.");var n=this._parent;if(e&&n){for(var r=n._children,s=n._namedChildren,a=e,o=1;i&&r[e];)e=a+" "+o++;(s[e]=s[e]||[]).push(this),r[e]=this}this._name=e||t,this._changed(128)},getStyle:function(){return this._style},setStyle:function(t){this.getStyle().set(t)}},e.each(["locked","visible","blendMode","opacity","guide"],function(t){var i=e.capitalize(t),t="_"+t;this["get"+i]=function(){return this[t]},this["set"+i]=function(e){e!=this[t]&&(this[t]=e,this._changed("_locked"===t?128:129))}},{}),{beans:!0,_locked:!1,_visible:!0,_blendMode:"normal",_opacity:1,_guide:!1,isSelected:function(){if(this._selectChildren)for(var t=this._children,e=0,i=t.length;i>e;e++)if(t[e].isSelected())return!0;return this._selected},setSelected:function(t,e){if(!e&&this._selectChildren)for(var i=this._children,n=0,r=i.length;r>n;n++)i[n].setSelected(t);(t=!!t)^this._selected&&(this._selected=t,this._project._updateSelection(this),this._changed(129))},_selected:!1,isFullySelected:function(){var t=this._children;if(t&&this._selected){for(var e=0,i=t.length;i>e;e++)if(!t[e].isFullySelected())return!1;return!0}return this._selected},setFullySelected:function(t){var e=this._children;if(e)for(var i=0,n=e.length;n>i;i++)e[i].setFullySelected(t);this.setSelected(t,!0)},isClipMask:function(){return this._clipMask},setClipMask:function(t){this._clipMask!=(t=!!t)&&(this._clipMask=t,t&&(this.setFillColor(null),this.setStrokeColor(null)),this._changed(129),this._parent&&this._parent._changed(1024))},_clipMask:!1,getData:function(){return this._data||(this._data={}),this._data},setData:function(t){this._data=t},getPosition:function(t){var e=this._position,i=t?h:u;if(!e){var n=this._pivot;e=this._position=n?this._matrix._transformPoint(n):this.getBounds().getCenter(!0)}return new i(e.x,e.y,this,"setPosition")},setPosition:function(){this.translate(h.read(arguments).subtract(this.getPosition(!0)))},getPivot:function(t){var e=this._pivot;if(e){var i=t?h:u;e=new i(e.x,e.y,this,"setPivot")}return e},setPivot:function(){this._pivot=h.read(arguments),this._position=t},_pivot:null,getRegistration:"#getPivot",setRegistration:"#setPivot"},e.each(["bounds","strokeBounds","handleBounds","roughBounds","internalBounds","internalRoughBounds"],function(t){var i="get"+e.capitalize(t),n=t.match(/^internal(.*)$/),r=n?"get"+n[1]:null;this[i]=function(e){var n=this._boundsGetter,s=!r&&("string"==typeof n?n:n&&n[i])||i,a=this._getCachedBounds(s,e,this,r);return"bounds"===t?new f(a.x,a.y,a.width,a.height,this,"setBounds"):a}},{beans:!0,_getBounds:function(t,e,i){var n=this._children;if(!n||0==n.length)return new _;for(var r=1/0,s=-r,a=r,o=s,h=0,u=n.length;u>h;h++){var l=n[h];if(l._visible&&!l.isEmpty()){var c=l._getCachedBounds(t,e&&e.chain(l._matrix),i);r=Math.min(c.x,r),a=Math.min(c.y,a),s=Math.max(c.x+c.width,s),o=Math.max(c.y+c.height,o)}}return isFinite(r)?new _(r,a,s-r,o-a):new _},setBounds:function(){var t=_.read(arguments),e=this.getBounds(),i=new g,n=t.getCenter();i.translate(n),(t.width!=e.width||t.height!=e.height)&&i.scale(0!=e.width?t.width/e.width:1,0!=e.height?t.height/e.height:1),n=e.getCenter(),i.translate(-n.x,-n.y),this.transform(i)},_getCachedBounds:function(t,e,i,n){e=e&&e.orNullIfIdentity();var r=n?null:this._matrix.orNullIfIdentity(),s=(!e||e.equals(r))&&t,a=this._parent||this._parentSymbol;if(a){var o=i._id,h=a._boundsCache=a._boundsCache||{ids:{},list:[]};h.ids[o]||(h.list.push(i),h.ids[o]=i)}if(s&&this._bounds&&this._bounds[s])return this._bounds[s].clone();var u=this._getBounds(n||t,e||r,i);if(s){this._bounds||(this._bounds={});var l=this._bounds[s]=u.clone();l._internal=!!n}return u},statics:{_clearBoundsCache:function(e){var i=e._boundsCache;if(i){e._bounds=e._position=e._boundsCache=t;for(var n=0,r=i.list,s=r.length;s>n;n++){var a=r[n];a!==e&&(a._bounds=a._position=t,a._boundsCache&&w._clearBoundsCache(a))}}}}}),{beans:!0,_decompose:function(){return this._decomposed=this._matrix.decompose()},getRotation:function(){var t=this._decomposed||this._decompose();return t&&t.rotation},setRotation:function(t){var e=this.getRotation();if(null!=e&&null!=t){var i=this._decomposed;this.rotate(t-e),i.rotation=t,this._decomposed=i}},getScaling:function(t){var e=this._decomposed||this._decompose(),i=e&&e.scaling,n=t?h:u;return i&&new n(i.x,i.y,this,"setScaling")},setScaling:function(){var t=this.getScaling();if(t){var e=h.read(arguments,0,{clone:!0}),i=this._decomposed;this.scale(e.x/t.x,e.y/t.y),i.scaling=e,this._decomposed=i}},getMatrix:function(){return this._matrix},setMatrix:function(t){this._matrix.initialize(t),this._applyMatrix?this.transform(null,!0):this._changed(9)},getGlobalMatrix:function(t){var e=this._globalMatrix,i=this._project._updateVersion;if(e&&e._updateVersion!==i&&(e=null),!e){e=this._globalMatrix=this._matrix.clone();var n=this._parent;n&&e.preConcatenate(n.getGlobalMatrix(!0)),e._updateVersion=i}return t?e:e.clone()},getApplyMatrix:function(){return this._applyMatrix},setApplyMatrix:function(t){(this._applyMatrix=this._canApplyMatrix&&!!t)&&this.transform(null,!0)},getTransformContent:"#getApplyMatrix",setTransformContent:"#setApplyMatrix"},{getProject:function(){return this._project},_setProject:function(t,e){if(this._project!==t){this._project&&this._installEvents(!1),this._project=t;for(var i=this._children,n=0,r=i&&i.length;r>n;n++)i[n]._setProject(t);e=!0}e&&this._installEvents(!0)},getView:function(){return this._project.getView()},_installEvents:function le(t){le.base.call(this,t);for(var e=this._children,i=0,n=e&&e.length;n>i;i++)e[i]._installEvents(t)},getLayer:function(){for(var t=this;t=t._parent;)if(t instanceof b)return t;return null},getParent:function(){return this._parent},setParent:function(t){return t.addChild(this)},getChildren:function(){return this._children},setChildren:function(t){this.removeChildren(),this.addChildren(t)},getFirstChild:function(){return this._children&&this._children[0]||null},getLastChild:function(){return this._children&&this._children[this._children.length-1]||null},getNextSibling:function(){return this._parent&&this._parent._children[this._index+1]||null},getPreviousSibling:function(){return this._parent&&this._parent._children[this._index-1]||null},getIndex:function(){return this._index},equals:function(t){return t===this||t&&this._class===t._class&&this._style.equals(t._style)&&this._matrix.equals(t._matrix)&&this._locked===t._locked&&this._visible===t._visible&&this._blendMode===t._blendMode&&this._opacity===t._opacity&&this._clipMask===t._clipMask&&this._guide===t._guide&&this._equals(t)||!1},_equals:function(t){return e.equals(this._children,t._children)},clone:function(t){return this._clone(new this.constructor(w.NO_INSERT),t)},_clone:function(i,n){if(i.setStyle(this._style),this._children)for(var r=0,s=this._children.length;s>r;r++)i.addChild(this._children[r].clone(!1),!0);(n||n===t)&&i.insertAbove(this);for(var a=["_locked","_visible","_blendMode","_opacity","_clipMask","_guide","_applyMatrix"],r=0,s=a.length;s>r;r++){var o=a[r];this.hasOwnProperty(o)&&(i[o]=this[o])}return i._matrix.initialize(this._matrix),i._data=this._data?e.clone(this._data):null,i.setSelected(this._selected),this._name&&i.setName(this._name,!0),i},copyTo:function(t){return t.addChild(this.clone(!1))},rasterize:function(t){var i=this.getStrokeBounds(),n=(t||this.getView().getResolution())/72,r=i.getTopLeft().floor(),s=i.getBottomRight().ceil(),a=new c(s.subtract(r)),o=Q.getCanvas(a.multiply(n)),h=o.getContext("2d"),u=(new g).scale(n).translate(r.negate());h.save(),u.applyToContext(h),this.draw(h,new e({matrices:[u]})),h.restore();var l=new S(w.NO_INSERT);return l.setCanvas(o),l.transform((new g).translate(r.add(a.divide(2))).scale(1/n)),l.insertAbove(this),l},contains:function(){return!!this._contains(this._matrix._inverseTransform(h.read(arguments)))},_contains:function(t){if(this._children){for(var e=this._children.length-1;e>=0;e--)if(this._children[e].contains(t))return!0;return!1}return t.isInside(this.getInternalBounds())},isInside:function(){return _.read(arguments).contains(this.getBounds())},_asPathItem:function(){return new L.Rectangle({rectangle:this.getInternalBounds(),matrix:this._matrix,insert:!1})},intersects:function(t,e){return t instanceof w?this._asPathItem().getIntersections(t._asPathItem(),e||t._matrix).length>0:!1},hitTest:function(){return this._hitTest(h.read(arguments),M.getOptions(e.read(arguments)))},_hitTest:function(i,n){function r(n,r){var s=f["get"+r]();return i.subtract(s).divide(u).length<=1?new M(n,_,{name:e.hyphenate(r),point:s}):t}if(this._locked||!this._visible||this._guide&&!n.guides||this.isEmpty())return null;var s=this._matrix,a=n._totalMatrix,o=this.getView(),h=n._totalMatrix=a?a.chain(s):this.getGlobalMatrix().preConcatenate(o._matrix),u=n._tolerancePadding=new c(L._getPenPadding(1,h.inverted())).multiply(Math.max(n.tolerance,1e-6));if(i=s._inverseTransform(i),!this._children&&!this.getInternalRoughBounds().expand(u.multiply(2))._containsPoint(i))return null;var l,d=!(n.guides&&!this._guide||n.selected&&!this._selected||n.type&&n.type!==e.hyphenate(this._class)||n.class&&!(this instanceof n.class)),_=this;if(d&&(n.center||n.bounds)&&this._parent){var f=this.getInternalBounds();if(n.center&&(l=r("center","Center")),!l&&n.bounds)for(var g=["TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],v=0;8>v&&!l;v++)l=r("bounds",g[v])}var m=!l&&this._children;if(m)for(var p=this._getChildHitTestOptions(n),v=m.length-1;v>=0&&!l;v--)l=m[v]._hitTest(i,p);return!l&&d&&(l=this._hitTestSelf(i,n)),l&&l.point&&(l.point=s.transform(l.point)),n._totalMatrix=a,l},_getChildHitTestOptions:function(t){return t},_hitTestSelf:function(e,i){return i.fill&&this.hasFill()&&this._contains(e)?new M("fill",this):t},matches:function(t,i){function n(t,i){for(var r in t)if(t.hasOwnProperty(r)){var s=t[r],a=i[r];if(e.isPlainObject(s)&&e.isPlainObject(a)){if(!n(s,a))return!1}else if(!e.equals(s,a))return!1}return!0}if("object"==typeof t){for(var r in t)if(t.hasOwnProperty(r)&&!this.matches(r,t[r]))return!1}else{var s=/^(empty|editable)$/.test(t)?this["is"+e.capitalize(t)]():"type"===t?e.hyphenate(this._class):this[t];if(/^(constructor|class)$/.test(t)){if(!(this instanceof i))return!1}else if(i instanceof RegExp){if(!i.test(s))return!1}else if("function"==typeof i){if(!i(s))return!1}else if(e.isPlainObject(i)){if(!n(i,s))return!1}else if(!e.equals(s,i))return!1}return!0},getItems:function(t){return w._getItems(this._children,t,this._matrix)},getItem:function(t){return w._getItems(this._children,t,this._matrix,null,!0)[0]||null},statics:{_getItems:function ce(t,i,n,r,s){if(!r){var a=i.overlapping,o=i.inside,h=a||o,u=h&&_.read([h]);r={items:[],inside:u,overlapping:a&&new L.Rectangle({rectangle:u,insert:!1})},h&&(i=e.set({},i,{inside:!0,overlapping:!0}))}var l=r.items,o=r.inside,a=r.overlapping;n=o&&(n||new g);for(var c=0,d=t&&t.length;d>c;c++){var f=t[c],v=n&&n.chain(f._matrix),m=!0;if(o){var h=f.getBounds(v);if(!o.intersects(h))continue;o&&o.contains(h)||a&&a.intersects(f,v)||(m=!1)}if(m&&f.matches(i)&&(l.push(f),s))break;if(ce(f._children,i,v,r,s),s&&l.length>0)break}return l}}},{importJSON:function(t){var i=e.importJSON(t,this);return i!==this?this.addChild(i):i},addChild:function(e,i){return this.insertChild(t,e,i)},insertChild:function(t,e,i){var n=e?this.insertChildren(t,[e],i):null;return n&&n[0]},addChildren:function(t,e){return this.insertChildren(this._children.length,t,e)},insertChildren:function(t,i,n,r){var s=this._children;if(s&&i&&i.length>0){i=Array.prototype.slice.apply(i);for(var a=i.length-1;a>=0;a--){var o=i[a];if(!r||o instanceof r){var h=o._parent===this&&o._index<t;o._remove(!1,!0)&&h&&t--}else i.splice(a,1)}e.splice(s,i,t,0);for(var u=this._project,l=u&&u._changes,a=0,c=i.length;c>a;a++){var o=i[a];o._parent=this,o._setProject(this._project,!0),o._name&&o.setName(o._name),l&&this._changed(5)}this._changed(11)}else i=null;return i},_insertSibling:function(t,e,i){return this._parent?this._parent.insertChild(t,e,i):null},insertAbove:function(t,e){return t._insertSibling(t._index+1,this,e)},insertBelow:function(t,e){return t._insertSibling(t._index,this,e)},sendToBack:function(){return(this._parent||this instanceof b&&this._project).insertChild(0,this)},bringToFront:function(){return(this._parent||this instanceof b&&this._project).addChild(this)},appendTop:"#addChild",appendBottom:function(t){return this.insertChild(0,t)},moveAbove:"#insertAbove",moveBelow:"#insertBelow",reduce:function(){if(this._children&&1===this._children.length){var t=this._children[0].reduce();return t.insertAbove(this),t.setStyle(this._style),this.remove(),t}return this},_removeNamed:function(){var t=this._parent;if(t){var e=t._children,i=t._namedChildren,n=this._name,r=i[n],s=r?r.indexOf(this):-1;-1!==s&&(e[n]==this&&delete e[n],r.splice(s,1),r.length?e[n]=r[r.length-1]:delete i[n])}},_remove:function(t,i){var n=this._parent;if(n){if(this._name&&this._removeNamed(),null!=this._index&&e.splice(n._children,null,this._index,1),this._installEvents(!1),t){var r=this._project;r&&r._changes&&this._changed(5)}return i&&n._changed(11),this._parent=null,!0}return!1},remove:function(){return this._remove(!0,!0)},replaceWith:function(t){var e=t&&t.insertBelow(this);return e&&this.remove(),e},removeChildren:function(t,i){if(!this._children)return null;t=t||0,i=e.pick(i,this._children.length);for(var n=e.splice(this._children,null,t,i-t),r=n.length-1;r>=0;r--)n[r]._remove(!0,!1);return n.length>0&&this._changed(11),n},clear:"#removeChildren",reverseChildren:function(){if(this._children){this._children.reverse();for(var t=0,e=this._children.length;e>t;t++)this._children[t]._index=t;this._changed(11)}},isEmpty:function(){return!this._children||0===this._children.length},isEditable:function(){for(var t=this;t;){if(!t._visible||t._locked)return!1;t=t._parent}return!0},hasFill:function(){return this.getStyle().hasFill()},hasStroke:function(){return this.getStyle().hasStroke()},hasShadow:function(){return this.getStyle().hasShadow()},_getOrder:function(t){function e(t){var e=[];do e.unshift(t);while(t=t._parent);return e}for(var i=e(this),n=e(t),r=0,s=Math.min(i.length,n.length);s>r;r++)if(i[r]!=n[r])return i[r]._index<n[r]._index?1:-1;return 0},hasChildren:function(){return this._children&&this._children.length>0},isInserted:function(){return this._parent?this._parent.isInserted():!1},isAbove:function(t){return-1===this._getOrder(t)},isBelow:function(t){return 1===this._getOrder(t)},isParent:function(t){return this._parent===t},isChild:function(t){return t&&t._parent===this},isDescendant:function(t){for(var e=this;e=e._parent;)if(e==t)return!0;return!1},isAncestor:function(t){return t?t.isDescendant(this):!1},isGroupedWith:function(t){for(var e=this._parent;e;){if(e._parent&&/^(Group|Layer|CompoundPath)$/.test(e._class)&&t.isDescendant(e))return!0;e=e._parent}return!1},translate:function(){var t=new g;return this.transform(t.translate.apply(t,arguments))},rotate:function(t){return this.transform((new g).rotate(t,h.read(arguments,1,{readNull:!0})||this.getPosition(!0)))}},e.each(["scale","shear","skew"],function(t){this[t]=function(){var e=h.read(arguments),i=h.read(arguments,0,{readNull:!0});return this.transform((new g)[t](e,i||this.getPosition(!0)))}},{}),{transform:function(t,e,i,n){t&&t.isIdentity()&&(t=null);var r=this._matrix,s=(e||this._applyMatrix)&&(!r.isIdentity()||t||e&&i&&this._children);if(!t&&!s)return this;if(t&&r.preConcatenate(t),s=s&&this._transformContent(r,i,n)){var a=this._pivot,o=this._style,h=o.getFillColor(!0),u=o.getStrokeColor(!0);a&&r._transformPoint(a,a,!0),h&&h.transform(r),u&&u.transform(r),r.reset(!0),n&&this._canApplyMatrix&&(this._applyMatrix=!0)}var l=this._bounds,c=this._position;this._changed(9);var d=l&&t&&t.decompose();if(d&&!d.shearing&&0===d.rotation%90){for(var _ in l){var f=l[_];(s||!f._internal)&&t._transformBounds(f,f)}var g=this._boundsGetter,f=l[g&&g.getBounds||g||"getBounds"];f&&(this._position=f.getCenter(!0)),this._bounds=l}else t&&c&&(this._position=t._transformPoint(c,c));return this},_transformContent:function(t,e,i){var n=this._children;if(n){for(var r=0,s=n.length;s>r;r++)n[r].transform(t,!0,e,i);return!0}},globalToLocal:function(){return this.getGlobalMatrix(!0)._inverseTransform(h.read(arguments))},localToGlobal:function(){return this.getGlobalMatrix(!0)._transformPoint(h.read(arguments))},parentToLocal:function(){return this._matrix._inverseTransform(h.read(arguments))},localToParent:function(){return this._matrix._transformPoint(h.read(arguments))},fitBounds:function(t,e){t=_.read(arguments);var i=this.getBounds(),n=i.height/i.width,r=t.height/t.width,s=(e?n>r:r>n)?t.width/i.width:t.height/i.height,a=new _(new h,new c(i.width*s,i.height*s));a.setCenter(t.getCenter()),this.setBounds(a)},_setStyles:function(t){var e=this._style,i=e.getFillColor(),n=e.getStrokeColor(),r=e.getShadowColor();if(i&&(t.fillStyle=i.toCanvasStyle(t)),n){var s=e.getStrokeWidth();if(s>0){t.strokeStyle=n.toCanvasStyle(t),t.lineWidth=s;var a=e.getStrokeJoin(),o=e.getStrokeCap(),h=e.getMiterLimit();if(a&&(t.lineJoin=a),o&&(t.lineCap=o),h&&(t.miterLimit=h),paper.support.nativeDash){var u=e.getDashArray(),l=e.getDashOffset();u&&u.length&&("setLineDash"in t?(t.setLineDash(u),t.lineDashOffset=l):(t.mozDash=u,t.mozDashOffset=l))}}}if(r){var c=e.getShadowBlur();if(c>0){t.shadowColor=r.toCanvasStyle(t),t.shadowBlur=c;var d=this.getShadowOffset();t.shadowOffsetX=d.x,t.shadowOffsetY=d.y}}},draw:function(t,e,i){function n(t){return a?a.chain(t):t}var r=this._updateVersion=this._project._updateVersion;if(this._visible&&0!==this._opacity){var s=e.matrices,a=e.viewMatrix,o=this._matrix,h=s[s.length-1].chain(o);if(h.isInvertible()){s.push(h),e.updateMatrix&&(h._updateVersion=r,this._globalMatrix=h);var u,l,c,d=this._blendMode,_=this._opacity,f="normal"===d,g=te.nativeModes[d],v=f&&1===_||e.dontStart||e.clip||(g||f&&1>_)&&this._canComposite(),m=e.pixelRatio;if(!v){var p=this.getStrokeBounds(n(h));if(!p.width||!p.height)return;c=e.offset,l=e.offset=p.getTopLeft().floor(),u=t,t=Q.getContext(p.getSize().ceil().add(1).multiply(m)),1!==m&&t.scale(m,m)}t.save();var y=i?i.chain(o):!this.getStrokeScaling(!0)&&n(h),w=!v&&e.clipItem,x=!y||w;if(v?(t.globalAlpha=_,g&&(t.globalCompositeOperation=d)):x&&t.translate(-l.x,-l.y),x&&(v?o:n(h)).applyToContext(t),w&&e.clipItem.draw(t,e.extend({clip:!0})),y){t.setTransform(m,0,0,m,0,0);var b=e.offset;b&&t.translate(-b.x,-b.y)}this._draw(t,e,y),t.restore(),s.pop(),e.clip&&!e.dontFinish&&t.clip(),v||(te.process(d,t,u,_,l.subtract(c).multiply(m)),Q.release(t),e.offset=c)}}},_isUpdated:function(t){var e=this._parent;if(e instanceof N)return e._isUpdated(t);var i=this._updateVersion===t;return!i&&e&&e._visible&&e._isUpdated(t)&&(this._updateVersion=t,i=!0),i},_drawSelection:function(t,e,i,n,r){if((this._drawSelected||this._boundsSelected)&&this._isUpdated(r)){var s=this.getSelectedColor(!0)||this.getLayer().getSelectedColor(!0),a=e.chain(this.getGlobalMatrix(!0));if(t.strokeStyle=t.fillStyle=s?s.toCanvasStyle(t):"#009dec",this._drawSelected&&this._drawSelected(t,a,n),this._boundsSelected){var o=i/2;coords=a._transformCorners(this.getInternalBounds()),t.beginPath();for(var h=0;8>h;h++)t[0===h?"moveTo":"lineTo"](coords[h],coords[++h]);t.closePath(),t.stroke();for(var h=0;8>h;h++)t.fillRect(coords[h]-o,coords[++h]-o,i,i)}}},_canComposite:function(){return!1}},e.each(["down","drag","up","move"],function(t){this["removeOn"+e.capitalize(t)]=function(){var e={};return e[t]=!0,this.removeOn(e)}},{removeOn:function(t){for(var e in t)if(t[e]){var i="mouse"+e,n=this._project,r=n._removeSets=n._removeSets||{};r[i]=r[i]||{},r[i][this._id]=this}return this}})),x=w.extend({_class:"Group",_selectChildren:!0,_serializeFields:{children:[]},initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||this.addChildren(Array.isArray(t)?t:arguments)},_changed:function de(e){de.base.call(this,e),1026&e&&(this._clipItem=t)},_getClipItem:function(){var e=this._clipItem;if(e===t){e=null;for(var i=0,n=this._children.length;n>i;i++){var r=this._children[i];if(r._clipMask){e=r;break}}this._clipItem=e}return e},isClipped:function(){return!!this._getClipItem()},setClipped:function(t){var e=this.getFirstChild();e&&e.setClipMask(t)},_draw:function(t,e){var i=e.clip,n=!i&&this._getClipItem(),r=!0;if(e=e.extend({clipItem:n,clip:!1}),i?this._currentPath?(t.currentPath=this._currentPath,r=!1):(t.beginPath(),e.dontStart=e.dontFinish=!0):n&&n.draw(t,e.extend({clip:!0})),r)for(var s=0,a=this._children.length;a>s;s++){var o=this._children[s];o!==n&&o.draw(t,e)}i&&(this._currentPath=t.currentPath)}}),b=x.extend({_class:"Layer",initialize:function(i){var n=e.isPlainObject(i)?new e(i):{children:Array.isArray(i)?i:arguments},r=n.insert;n.insert=!1,x.call(this,n),(r||r===t)&&(this._project.addChild(this),this.activate())},_remove:function _e(t,i){if(this._parent)return _e.base.call(this,t,i);if(null!=this._index){var n=this._project;return n._activeLayer===this&&(n._activeLayer=this.getNextSibling()||this.getPreviousSibling()),e.splice(n.layers,null,this._index,1),this._installEvents(!1),t&&n._changes&&this._changed(5),i&&(n._needsUpdate=!0),!0}return!1},getNextSibling:function fe(){return this._parent?fe.base.call(this):this._project.layers[this._index+1]||null},getPreviousSibling:function ge(){return this._parent?ge.base.call(this):this._project.layers[this._index-1]||null},isInserted:function ve(){return this._parent?ve.base.call(this):null!=this._index},activate:function(){this._project._activeLayer=this},_insertSibling:function me(t,e,i){return this._parent?me.base.call(this,t,e,i):this._project.insertChild(t,e,i)}}),C=w.extend({_class:"Shape",_applyMatrix:!1,_canApplyMatrix:!1,_boundsSelected:!0,_serializeFields:{type:null,size:null,radius:null},initialize:function(t){this._initialize(t)},_equals:function(t){return this._type===t._type&&this._size.equals(t._size)&&e.equals(this._radius,t._radius)},clone:function(t){var e=new C(w.NO_INSERT);return e.setType(this._type),e.setSize(this._size),e.setRadius(this._radius),this._clone(e,t)},getType:function(){return this._type},setType:function(t){this._type=t},getShape:"#getType",setShape:"#setType",getSize:function(){var t=this._size;return new d(t.width,t.height,this,"setSize")
},setSize:function(){var t=c.read(arguments);if(this._size){if(!this._size.equals(t)){var e=this._type,i=t.width,n=t.height;if("rectangle"===e){var r=c.min(this._radius,t.divide(2));this._radius.set(r.width,r.height)}else"circle"===e?(i=n=(i+n)/2,this._radius=i/2):"ellipse"===e&&this._radius.set(i/2,n/2);this._size.set(i,n),this._changed(9)}}else this._size=t.clone()},getRadius:function(){var t=this._radius;return"circle"===this._type?t:new d(t.width,t.height,this,"setRadius")},setRadius:function(t){var e=this._type;if("circle"===e){if(t===this._radius)return;var i=2*t;this._radius=t,this._size.set(i,i)}else if(t=c.read(arguments),this._radius){if(this._radius.equals(t))return;if(this._radius.set(t.width,t.height),"rectangle"===e){var i=c.max(this._size,t.multiply(2));this._size.set(i.width,i.height)}else"ellipse"===e&&this._size.set(2*t.width,2*t.height)}else this._radius=t.clone();this._changed(9)},isEmpty:function(){return!1},toPath:function(i){var n=new(L[e.capitalize(this._type)])({center:new h,size:this._size,radius:this._radius,insert:!1});return n.setStyle(this._style),n.transform(this._matrix),(i||i===t)&&n.insertAbove(this),n},_draw:function(t,e,i){var n=this._style,r=n.hasFill(),s=n.hasStroke(),a=e.dontFinish||e.clip,o=!i;if(r||s||a){var h=this._type,u=this._radius,l="circle"===h;if(e.dontStart||t.beginPath(),o&&l)t.arc(0,0,u,0,2*Math.PI,!0);else{var c=l?u:u.width,d=l?u:u.height,_=this._size,f=_.width,g=_.height;if(o&&"rect"===h&&0===c&&0===d)t.rect(-f/2,-g/2,f,g);else{var v=f/2,m=g/2,p=.44771525016920644,y=c*p,w=d*p,x=[-v,-m+d,-v,-m+w,-v+y,-m,-v+c,-m,v-c,-m,v-y,-m,v,-m+w,v,-m+d,v,m-d,v,m-w,v-y,m,v-c,m,-v+c,m,-v+y,m,-v,m-w,-v,m-d];i&&i.transform(x,x,32),t.moveTo(x[0],x[1]),t.bezierCurveTo(x[2],x[3],x[4],x[5],x[6],x[7]),v!==c&&t.lineTo(x[8],x[9]),t.bezierCurveTo(x[10],x[11],x[12],x[13],x[14],x[15]),m!==d&&t.lineTo(x[16],x[17]),t.bezierCurveTo(x[18],x[19],x[20],x[21],x[22],x[23]),v!==c&&t.lineTo(x[24],x[25]),t.bezierCurveTo(x[26],x[27],x[28],x[29],x[30],x[31])}}t.closePath()}a||!r&&!s||(this._setStyles(t),r&&(t.fill(n.getWindingRule()),t.shadowColor="rgba(0,0,0,0)"),s&&t.stroke())},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_getBounds:function(t,e){var i=new _(this._size).setCenter(0,0);return"getBounds"!==t&&this.hasStroke()&&(i=i.expand(this.getStrokeWidth())),e?e._transformBounds(i):i}},new function(){function t(t,e,i){var n=t._radius;if(!n.isZero())for(var r=t._size.divide(2),s=0;4>s;s++){var a=new h(1&s?1:-1,s>1?1:-1),o=a.multiply(r),u=o.subtract(a.multiply(n)),l=new _(o,u);if((i?l.expand(i):l).contains(e))return u}}function e(t,e){var i=t.getAngleInRadians(),n=2*e.width,r=2*e.height,s=n*Math.sin(i),a=r*Math.cos(i);return n*r/(2*Math.sqrt(s*s+a*a))}return{_contains:function i(e){if("rectangle"===this._type){var n=t(this,e);return n?e.subtract(n).divide(this._radius).getLength()<=1:i.base.call(this,e)}return e.divide(this.size).getLength()<=.5},_hitTestSelf:function n(i,r){var s=!1;if(this.hasStroke()){var a=this._type,o=this._radius,h=this.getStrokeWidth()+2*r.tolerance;if("rectangle"===a){var u=t(this,i,h);if(u){var l=i.subtract(u);s=2*Math.abs(l.getLength()-e(l,o))<=h}else{var c=new _(this._size).setCenter(0,0),d=c.expand(h),f=c.expand(-h);s=d._containsPoint(i)&&!f._containsPoint(i)}}else"ellipse"===a&&(o=e(i,o)),s=2*Math.abs(i.getLength()-o)<=h}return s?new M("stroke",this):n.base.apply(this,arguments)}}},{statics:new function(){function t(t,i,n,r,s){var a=new C(e.getNamed(s));return a._type=t,a._size=n,a._radius=r,a.translate(i)}return{Circle:function(){var i=h.readNamed(arguments,"center"),n=e.readNamed(arguments,"radius");return t("circle",i,new c(2*n),n,arguments)},Rectangle:function(){var e=_.readNamed(arguments,"rectangle"),i=c.min(c.readNamed(arguments,"radius"),e.getSize(!0).divide(2));return t("rectangle",e.getCenter(!0),e.getSize(!0),i,arguments)},Ellipse:function(){var e=C._readEllipse(arguments),i=e.radius;return t("ellipse",e.center,i.multiply(2),i,arguments)},_readEllipse:function(t){var i,n;if(e.hasNamed(t,"radius"))i=h.readNamed(t,"center"),n=c.readNamed(t,"radius");else{var r=_.readNamed(t,"rectangle");i=r.getCenter(!0),n=r.getSize(!0).divide(2)}return{center:i,radius:n}}}}}),S=w.extend({_class:"Raster",_applyMatrix:!1,_canApplyMatrix:!1,_boundsGetter:"getBounds",_boundsSelected:!0,_serializeFields:{source:null},initialize:function(e,i){this._initialize(e,i!==t&&h.read(arguments,1))||("string"==typeof e?this.setSource(e):this.setImage(e)),this._size||(this._size=new c,this._loaded=!1)},_equals:function(t){return this.getSource()===t.getSource()},clone:function(t){var e=new S(w.NO_INSERT),i=this._image,n=this._canvas;if(i)e.setImage(i);else if(n){var r=Q.getCanvas(this._size);r.getContext("2d").drawImage(n,0,0),e.setImage(r)}return this._clone(e,t)},getSize:function(){var t=this._size;return new d(t?t.width:0,t?t.height:0,this,"setSize")},setSize:function(){var t=c.read(arguments);if(!t.equals(this._size))if(t.width>0&&t.height>0){var e=this.getElement();this.setImage(Q.getCanvas(t)),e&&this.getContext(!0).drawImage(e,0,0,t.width,t.height)}else this._canvas&&Q.release(this._canvas),this._size=t.clone()},getWidth:function(){return this._size?this._size.width:0},setWidth:function(t){this.setSize(t,this.getHeight())},getHeight:function(){return this._size?this._size.height:0},setHeight:function(t){this.setSize(this.getWidth(),t)},isEmpty:function(){var t=this._size;return!t||0===t.width&&0===t.height},getResolution:function(){var t=this._matrix,e=new h(0,0).transform(t),i=new h(1,0).transform(t).subtract(e),n=new h(0,1).transform(t).subtract(e);return new c(72/i.getLength(),72/n.getLength())},getPpi:"#getResolution",getImage:function(){return this._image},setImage:function(t){this._canvas&&Q.release(this._canvas),t&&t.getContext?(this._image=null,this._canvas=t,this._loaded=!0):(this._image=t,this._canvas=null,this._loaded=t&&t.complete),this._size=new c(t?t.naturalWidth||t.width:0,t?t.naturalHeight||t.height:0),this._context=null,this._changed(521)},getCanvas:function(){if(!this._canvas){var t=Q.getContext(this._size);try{this._image&&t.drawImage(this._image,0,0),this._canvas=t.canvas}catch(e){Q.release(t)}}return this._canvas},setCanvas:"#setImage",getContext:function(t){return this._context||(this._context=this.getCanvas().getContext("2d")),t&&(this._image=null,this._changed(513)),this._context},setContext:function(t){this._context=t},getSource:function(){return this._image&&this._image.src||this.toDataURL()},setSource:function(t){function e(){var t=n.getView();t&&(paper=t._scope,n.setImage(i),n.emit("load"),t.update())}var i,n=this;i=document.getElementById(t)||new Image,i.naturalWidth&&i.naturalHeight?setTimeout(e,0):(H.add(i,{load:e}),i.src||(i.src=t)),this.setImage(i)},getElement:function(){return this._canvas||this._loaded&&this._image}},{beans:!1,getSubCanvas:function(){var t=_.read(arguments),e=Q.getContext(t.getSize());return e.drawImage(this.getCanvas(),t.x,t.y,t.width,t.height,0,0,t.width,t.height),e.canvas},getSubRaster:function(){var t=_.read(arguments),e=new S(w.NO_INSERT);return e.setImage(this.getSubCanvas(t)),e.translate(t.getCenter().subtract(this.getSize().divide(2))),e._matrix.preConcatenate(this._matrix),e.insertAbove(this),e},toDataURL:function(){var t=this._image&&this._image.src;if(/^data:/.test(t))return t;var e=this.getCanvas();return e?e.toDataURL():null},drawImage:function(t){var e=h.read(arguments,1);this.getContext(!0).drawImage(t,e.x,e.y)},getAverageColor:function(t){var i,n;t?t instanceof T?(n=t,i=t.getBounds()):t.width?i=new _(t):t.x&&(i=new _(t.x-.5,t.y-.5,1,1)):i=this.getBounds();var r=32,s=Math.min(i.width,r),a=Math.min(i.height,r),o=S._sampleContext;o?o.clearRect(0,0,r+1,r+1):o=S._sampleContext=Q.getContext(new c(r)),o.save();var h=(new g).scale(s/i.width,a/i.height).translate(-i.x,-i.y);h.applyToContext(o),n&&n.draw(o,new e({clip:!0,matrices:[h]})),this._matrix.applyToContext(o);var u=this.getElement(),l=this._size;u&&o.drawImage(u,-l.width/2,-l.height/2),o.restore();for(var d=o.getImageData(.5,.5,Math.ceil(s),Math.ceil(a)).data,f=[0,0,0],v=0,m=0,p=d.length;p>m;m+=4){var y=d[m+3];v+=y,y/=255,f[0]+=d[m]*y,f[1]+=d[m+1]*y,f[2]+=d[m+2]*y}for(var m=0;3>m;m++)f[m]/=v;return v?R.read(f):null},getPixel:function(){var t=h.read(arguments),e=this.getContext().getImageData(t.x,t.y,1,1).data;return new R("rgb",[e[0]/255,e[1]/255,e[2]/255],e[3]/255)},setPixel:function(){var t=h.read(arguments),e=R.read(arguments),i=e._convert("rgb"),n=e._alpha,r=this.getContext(!0),s=r.createImageData(1,1),a=s.data;a[0]=255*i[0],a[1]=255*i[1],a[2]=255*i[2],a[3]=null!=n?255*n:255,r.putImageData(s,t.x,t.y)},createImageData:function(){var t=c.read(arguments);return this.getContext().createImageData(t.width,t.height)},getImageData:function(){var t=_.read(arguments);return t.isEmpty()&&(t=new _(this._size)),this.getContext().getImageData(t.x,t.y,t.width,t.height)},setImageData:function(t){var e=h.read(arguments,1);this.getContext(!0).putImageData(t,e.x,e.y)},_getBounds:function(t,e){var i=new _(this._size).setCenter(0,0);return e?e._transformBounds(i):i},_hitTestSelf:function(t){if(this._contains(t)){var e=this;return new M("pixel",e,{offset:t.add(e._size.divide(2)).round(),color:{get:function(){return e.getPixel(this.offset)}}})}},_draw:function(t){var e=this.getElement();e&&(t.globalAlpha=this._opacity,t.drawImage(e,-this._size.width/2,-this._size.height/2))},_canComposite:function(){return!0}}),P=w.extend({_class:"PlacedSymbol",_applyMatrix:!1,_canApplyMatrix:!1,_boundsGetter:{getBounds:"getStrokeBounds"},_boundsSelected:!0,_serializeFields:{symbol:null},initialize:function(e,i){this._initialize(e,i!==t&&h.read(arguments,1))||this.setSymbol(e instanceof y?e:new y(e))},_equals:function(t){return this._symbol===t._symbol},getSymbol:function(){return this._symbol},setSymbol:function(t){this._symbol=t,this._changed(9)},clone:function(t){var e=new P(w.NO_INSERT);return e.setSymbol(this._symbol),this._clone(e,t)},isEmpty:function(){return this._symbol._definition.isEmpty()},_getBounds:function(t,e,i){var n=this.symbol._definition;return n._getCachedBounds(t,e&&e.chain(n._matrix),i)},_hitTestSelf:function(t,e){var i=this._symbol._definition._hitTest(t,e);return i&&(i.item=this),i},_draw:function(t,e){this.symbol._definition.draw(t,e)}}),M=e.extend({_class:"HitResult",initialize:function(t,e,i){this.type=t,this.item=e,i&&(i.enumerable=!0,this.inject(i))},statics:{getOptions:function(t){return new e({type:null,tolerance:paper.settings.hitTolerance,fill:!t,stroke:!t,segments:!t,handles:!1,ends:!1,center:!1,bounds:!1,guides:!1,selected:!1},t)}}}),z=e.extend({_class:"Segment",beans:!0,initialize:function(e,i,n,r,s,a){var o,h,u,l=arguments.length;0===l||(1===l?e.point?(o=e.point,h=e.handleIn,u=e.handleOut):o=e:2===l&&"number"==typeof e?o=arguments:3>=l?(o=e,h=i,u=n):(o=e!==t?[e,i]:null,h=n!==t?[n,r]:null,u=s!==t?[s,a]:null)),new I(o,this,"_point"),new I(h,this,"_handleIn"),new I(u,this,"_handleOut")},_serialize:function(t){return e.serialize(this.isLinear()?this._point:[this._point,this._handleIn,this._handleOut],t,!0)},_changed:function(t){var e=this._path;if(e){var i,n=e._curves,r=this._index;n&&(t&&t!==this._point&&t!==this._handleIn||!(i=r>0?n[r-1]:e._closed?n[n.length-1]:null)||i._changed(),t&&t!==this._point&&t!==this._handleOut||!(i=n[r])||i._changed()),e._changed(25)}},getPoint:function(){return this._point},setPoint:function(){var t=h.read(arguments);this._point.set(t.x,t.y)},getHandleIn:function(){return this._handleIn},setHandleIn:function(){var t=h.read(arguments);this._handleIn.set(t.x,t.y)},getHandleOut:function(){return this._handleOut},setHandleOut:function(){var t=h.read(arguments);this._handleOut.set(t.x,t.y)},isLinear:function(){return this._handleIn.isZero()&&this._handleOut.isZero()},setLinear:function(t){t&&(this._handleIn.set(0,0),this._handleOut.set(0,0))},isColinear:function(t){var e=this.getNext(),i=t.getNext();return this._handleOut.isZero()&&e._handleIn.isZero()&&t._handleOut.isZero()&&i._handleIn.isZero()&&e._point.subtract(this._point).isColinear(i._point.subtract(t._point))},isOrthogonal:function(){var t=this.getPrevious(),e=this.getNext();return t._handleOut.isZero()&&this._handleIn.isZero()&&this._handleOut.isZero()&&e._handleIn.isZero()&&this._point.subtract(t._point).isOrthogonal(e._point.subtract(this._point))},isArc:function(){var t=this.getNext(),e=this._handleOut,i=t._handleIn,n=.5522847498307936;if(e.isOrthogonal(i)){var r=this._point,s=t._point,a=new v(r,e,!0).intersect(new v(s,i,!0),!0);return a&&o.isZero(e.getLength()/a.subtract(r).getLength()-n)&&o.isZero(i.getLength()/a.subtract(s).getLength()-n)}return!1},_selectionState:0,isSelected:function(t){var e=this._selectionState;return t?t===this._point?!!(4&e):t===this._handleIn?!!(1&e):t===this._handleOut?!!(2&e):!1:!!(7&e)},setSelected:function(t,e){var i=this._path,t=!!t,n=this._selectionState,r=n,s=e?e===this._point?4:e===this._handleIn?1:e===this._handleOut?2:0:7;t?n|=s:n&=~s,this._selectionState=n,i&&n!==r&&(i._updateSelection(this,r,n),i._changed(129))},getIndex:function(){return this._index!==t?this._index:null},getPath:function(){return this._path||null},getCurve:function(){var t=this._path,e=this._index;return t?(e>0&&!t._closed&&e===t._segments.length-1&&e--,t.getCurves()[e]||null):null},getLocation:function(){var t=this.getCurve();return t?new O(t,this===t._segment1?0:1):null},getNext:function(){var t=this._path&&this._path._segments;return t&&(t[this._index+1]||this._path._closed&&t[0])||null},getPrevious:function(){var t=this._path&&this._path._segments;return t&&(t[this._index-1]||this._path._closed&&t[t.length-1])||null},reverse:function(){return new z(this._point,this._handleOut,this._handleIn)},remove:function(){return this._path?!!this._path.removeSegment(this._index):!1},clone:function(){return new z(this._point,this._handleIn,this._handleOut)},equals:function(t){return t===this||t&&this._class===t._class&&this._point.equals(t._point)&&this._handleIn.equals(t._handleIn)&&this._handleOut.equals(t._handleOut)||!1},toString:function(){var t=["point: "+this._point];return this._handleIn.isZero()||t.push("handleIn: "+this._handleIn),this._handleOut.isZero()||t.push("handleOut: "+this._handleOut),"{ "+t.join(", ")+" }"},transform:function(t){this._transformCoordinates(t,Array(6),!0),this._changed()},_transformCoordinates:function(t,e,i){var n=this._point,r=i&&this._handleIn.isZero()?null:this._handleIn,s=i&&this._handleOut.isZero()?null:this._handleOut,a=n._x,o=n._y,h=2;return e[0]=a,e[1]=o,r&&(e[h++]=r._x+a,e[h++]=r._y+o),s&&(e[h++]=s._x+a,e[h++]=s._y+o),t&&(t._transformCoordinates(e,e,h/2),a=e[0],o=e[1],i?(n._x=a,n._y=o,h=2,r&&(r._x=e[h++]-a,r._y=e[h++]-o),s&&(s._x=e[h++]-a,s._y=e[h++]-o)):(r||(e[h++]=a,e[h++]=o),s||(e[h++]=a,e[h++]=o))),e}}),I=h.extend({initialize:function(e,i,n){var r,s,a;if(e)if((r=e[0])!==t)s=e[1];else{var o=e;(r=o.x)===t&&(o=h.read(arguments),r=o.x),s=o.y,a=o.selected}else r=s=0;this._x=r,this._y=s,this._owner=i,i[n]=this,a&&this.setSelected(!0)},set:function(t,e){return this._x=t,this._y=e,this._owner._changed(this),this},_serialize:function(t){var e=t.formatter,i=e.number(this._x),n=e.number(this._y);return this.isSelected()?{x:i,y:n,selected:!0}:[i,n]},getX:function(){return this._x},setX:function(t){this._x=t,this._owner._changed(this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner._changed(this)},isZero:function(){return o.isZero(this._x)&&o.isZero(this._y)},setSelected:function(t){this._owner.setSelected(t,this)},isSelected:function(){return this._owner.isSelected(this)}}),A=e.extend({_class:"Curve",initialize:function(t,e,i,n,r,s,a,o){var h=arguments.length;if(3===h)this._path=t,this._segment1=e,this._segment2=i;else if(0===h)this._segment1=new z,this._segment2=new z;else if(1===h)this._segment1=new z(t.segment1),this._segment2=new z(t.segment2);else if(2===h)this._segment1=new z(t),this._segment2=new z(e);else{var u,l,c,d;4===h?(u=t,l=e,c=i,d=n):8===h&&(u=[t,e],d=[a,o],l=[i-t,n-e],c=[r-a,s-o]),this._segment1=new z(u,null,l),this._segment2=new z(d,c,null)}},_changed:function(){this._length=this._bounds=t},getPoint1:function(){return this._segment1._point},setPoint1:function(){var t=h.read(arguments);this._segment1._point.set(t.x,t.y)},getPoint2:function(){return this._segment2._point},setPoint2:function(){var t=h.read(arguments);this._segment2._point.set(t.x,t.y)},getHandle1:function(){return this._segment1._handleOut},setHandle1:function(){var t=h.read(arguments);this._segment1._handleOut.set(t.x,t.y)},getHandle2:function(){return this._segment2._handleIn},setHandle2:function(){var t=h.read(arguments);this._segment2._handleIn.set(t.x,t.y)},getSegment1:function(){return this._segment1},getSegment2:function(){return this._segment2},getPath:function(){return this._path},getIndex:function(){return this._segment1._index},getNext:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index+1]||this._path._closed&&t[0])||null},getPrevious:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index-1]||this._path._closed&&t[t.length-1])||null},isSelected:function(){return this.getPoint1().isSelected()&&this.getHandle2().isSelected()&&this.getHandle2().isSelected()&&this.getPoint2().isSelected()},setSelected:function(t){this.getPoint1().setSelected(t),this.getHandle1().setSelected(t),this.getHandle2().setSelected(t),this.getPoint2().setSelected(t)},getValues:function(t){return A.getValues(this._segment1,this._segment2,t)},getPoints:function(){for(var t=this.getValues(),e=[],i=0;8>i;i+=2)e.push(new h(t[i],t[i+1]));return e},getLength:function(){return null==this._length&&(this._length=this.isLinear()?this._segment2._point.getDistance(this._segment1._point):A.getLength(this.getValues(),0,1)),this._length},getArea:function(){return A.getArea(this.getValues())},getPart:function(t,e){return new A(A.getPart(this.getValues(),t,e))},getPartLength:function(t,e){return A.getLength(this.getValues(),t,e)},isLinear:function(){return this._segment1._handleOut.isZero()&&this._segment2._handleIn.isZero()},getIntersections:function(t){return A.filterIntersections(A.getIntersections(this.getValues(),t.getValues(),this,t,[]))},_getParameter:function(e,i){return i?e:e&&e.curve===this?e.parameter:e===t&&i===t?.5:this.getParameterAt(e,0)},divide:function(t,e,i){var n=this._getParameter(t,e),r=1e-6,s=null;if(n>r&&1-r>n){var a=A.subdivide(this.getValues(),n),o=i?!1:this.isLinear(),u=a[0],l=a[1];o||(this._segment1._handleOut.set(u[2]-u[0],u[3]-u[1]),this._segment2._handleIn.set(l[4]-l[6],l[5]-l[7]));var c=u[6],d=u[7],_=new z(new h(c,d),!o&&new h(u[4]-c,u[5]-d),!o&&new h(l[2]-c,l[3]-d));if(this._path)this._segment1._index>0&&0===this._segment2._index?this._path.add(_):this._path.insert(this._segment2._index,_),s=this;else{var f=this._segment2;this._segment2=_,s=new A(_,f)}}return s},split:function(t,e){return this._path?this._path.split(this._segment1._index,this._getParameter(t,e)):null},reverse:function(){return new A(this._segment2.reverse(),this._segment1.reverse())},remove:function(){var t=!1;if(this._path){var e=this._segment2,i=e._handleOut;t=e.remove(),t&&this._segment1._handleOut.set(i.x,i.y)}return t},clone:function(){return new A(this._segment1,this._segment2)},toString:function(){var t=["point1: "+this._segment1._point];return this._segment1._handleOut.isZero()||t.push("handle1: "+this._segment1._handleOut),this._segment2._handleIn.isZero()||t.push("handle2: "+this._segment2._handleIn),t.push("point2: "+this._segment2._point),"{ "+t.join(", ")+" }"},statics:{getValues:function(t,e,i){var n=t._point,r=t._handleOut,s=e._handleIn,a=e._point,o=[n._x,n._y,n._x+r._x,n._y+r._y,a._x+s._x,a._y+s._y,a._x,a._y];return i&&i._transformCoordinates(o,o,4),o},evaluate:function(t,e,i){var n,r,s=t[0],a=t[1],o=t[2],u=t[3],l=t[4],c=t[5],d=t[6],_=t[7],f=1e-6;if(0===i&&(f>e||e>1-f)){var g=f>e;n=g?s:d,r=g?a:_}else{var v=3*(o-s),m=3*(l-o)-v,p=d-s-v-m,y=3*(u-a),w=3*(c-u)-y,x=_-a-y-w;if(0===i)n=((p*e+m)*e+v)*e+s,r=((x*e+w)*e+y)*e+a;else if(f>e&&o===s&&u===a||e>1-f&&l===d&&c===_?(n=l-o,r=c-u):f>e?(n=v,r=y):e>1-f?(n=3*(d-l),r=3*(_-c)):(n=(3*p*e+2*m)*e+v,r=(3*x*e+2*w)*e+y),3===i){var b=6*p*e+2*m,C=6*x*e+2*w;return(n*C-r*b)/Math.pow(n*n+r*r,1.5)}}return 2===i?new h(r,-n):new h(n,r)},subdivide:function(e,i){var n=e[0],r=e[1],s=e[2],a=e[3],o=e[4],h=e[5],u=e[6],l=e[7];i===t&&(i=.5);var c=1-i,d=c*n+i*s,_=c*r+i*a,f=c*s+i*o,g=c*a+i*h,v=c*o+i*u,m=c*h+i*l,p=c*d+i*f,y=c*_+i*g,w=c*f+i*v,x=c*g+i*m,b=c*p+i*w,C=c*y+i*x;return[[n,r,d,_,p,y,b,C],[b,C,w,x,v,m,u,l]]},solveCubic:function(t,e,i,n,r,s){var a=t[e],h=t[e+2],u=t[e+4],l=t[e+6],c=3*(h-a),d=3*(u-h)-c,_=l-a-c-d,f=o.isZero;return f(_)&&f(d)&&(_=d=0),o.solveCubic(_,d,c,a-i,n,r,s)},getParameterOf:function(t,e,i){var n=1e-6;if(Math.abs(t[0]-e)<n&&Math.abs(t[1]-i)<n)return 0;if(Math.abs(t[6]-e)<n&&Math.abs(t[7]-i)<n)return 1;for(var r,s,a=[],o=[],h=A.solveCubic(t,0,e,a,0,1),u=A.solveCubic(t,1,i,o,0,1),l=0;-1==h||h>l;)if(-1==h||(r=a[l++])>=0&&1>=r){for(var c=0;-1==u||u>c;)if((-1==u||(s=o[c++])>=0&&1>=s)&&(-1==h?r=s:-1==u&&(s=r),Math.abs(r-s)<n))return.5*(r+s);if(-1==h)break}return null},getPart:function(t,e,i){return e>0&&(t=A.subdivide(t,e)[1]),1>i&&(t=A.subdivide(t,(i-e)/(1-e))[0]),t},isLinear:function(t){var e=o.isZero;return e(t[0]-t[2])&&e(t[1]-t[3])&&e(t[4]-t[6])&&e(t[5]-t[7])},isFlatEnough:function(t,e){var i=t[0],n=t[1],r=t[2],s=t[3],a=t[4],o=t[5],h=t[6],u=t[7],l=3*r-2*i-h,c=3*s-2*n-u,d=3*a-2*h-i,_=3*o-2*u-n;return Math.max(l*l,d*d)+Math.max(c*c,_*_)<10*e*e},getArea:function(t){var e=t[0],i=t[1],n=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7];return(3*r*e-1.5*r*s-1.5*r*o-3*i*n-1.5*i*s-.5*i*o+1.5*a*e+1.5*a*n-3*a*o+.5*h*e+1.5*h*n+3*h*s)/10},getEdgeSum:function(t){return(t[0]-t[2])*(t[3]+t[1])+(t[2]-t[4])*(t[5]+t[3])+(t[4]-t[6])*(t[7]+t[5])},getBounds:function(t){for(var e=t.slice(0,2),i=e.slice(),n=[0,0],r=0;2>r;r++)A._addBounds(t[r],t[r+2],t[r+4],t[r+6],r,0,e,i,n);return new _(e[0],e[1],i[0]-e[0],i[1]-e[1])},_addBounds:function(t,e,i,n,r,s,a,h,u){function l(t,e){var i=t-e,n=t+e;i<a[r]&&(a[r]=i),n>h[r]&&(h[r]=n)}var c=3*(e-i)-t+n,d=2*(t+i)-4*e,_=e-t,f=o.solveQuadratic(c,d,_,u),g=1e-6,v=1-g;l(n,0);for(var m=0;f>m;m++){var p=u[m],y=1-p;p>g&&v>p&&l(y*y*y*t+3*y*y*p*e+3*y*p*p*i+p*p*p*n,s)}}}},e.each(["getBounds","getStrokeBounds","getHandleBounds","getRoughBounds"],function(t){this[t]=function(){this._bounds||(this._bounds={});var e=this._bounds[t];return e||(e=this._bounds[t]=L[t]([this._segment1,this._segment2],!1,this._path.getStyle())),e.clone()}},{}),e.each(["getPoint","getTangent","getNormal","getCurvature"],function(t,e){this[t+"At"]=function(t,i){var n=this.getValues();return A.evaluate(n,i?t:A.getParameterAt(n,t,0),e)},this[t]=function(t){return A.evaluate(this.getValues(),t,e)}},{beans:!1,getParameterAt:function(t,e){return A.getParameterAt(this.getValues(),t,e)},getParameterOf:function(){var t=h.read(arguments);return A.getParameterOf(this.getValues(),t.x,t.y)},getLocationAt:function(t,e){return e||(t=this.getParameterAt(t)),t>=0&&1>=t&&new O(this,t)},getLocationOf:function(){return this.getLocationAt(this.getParameterOf(h.read(arguments)),!0)},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getNearestLocation:function(){function t(t){if(t>=0&&1>=t){var n=e.getDistance(A.evaluate(i,t,0),!0);if(r>n)return r=n,s=t,!0}}for(var e=h.read(arguments),i=this.getValues(),n=100,r=1/0,s=0,a=0;n>=a;a++)t(a/n);for(var o=1/(2*n);o>1e-6;)t(s-o)||t(s+o)||(o/=2);var u=A.evaluate(i,s,0);return new O(this,s,u,null,null,null,e.getDistance(u))},getNearestPoint:function(){return this.getNearestLocation.apply(this,arguments).getPoint()}}),new function(){function e(t){var e=t[0],i=t[1],n=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7],u=9*(n-s)+3*(o-e),l=6*(e+s)-12*n,c=3*(n-e),d=9*(r-a)+3*(h-i),_=6*(i+a)-12*r,f=3*(r-i);return function(t){var e=(u*t+l)*t+c,i=(d*t+_)*t+f;return Math.sqrt(e*e+i*i)}}function i(t,e){return Math.max(2,Math.min(16,Math.ceil(32*Math.abs(e-t))))}return{statics:!0,getLength:function(n,r,s){r===t&&(r=0),s===t&&(s=1);var a=o.isZero;if(0===r&&1===s&&a(n[0]-n[2])&&a(n[1]-n[3])&&a(n[6]-n[4])&&a(n[7]-n[5])){var h=n[6]-n[0],u=n[7]-n[1];return Math.sqrt(h*h+u*u)}var l=e(n);return o.integrate(l,r,s,i(r,s))},getParameterAt:function(n,r,s){function a(t){return f+=o.integrate(c,s,t,i(s,t)),s=t,f-r}if(s===t&&(s=0>r?1:0),0===r)return s;var h=r>0,u=h?s:0,l=h?1:s,c=e(n),d=o.integrate(c,u,l,i(u,l));if(Math.abs(r)>=d)return h?l:u;var _=r/d,f=0;return o.findRoot(a,c,s+_,u,l,16,1e-6)}}},new function(){function t(t,e,i,n,r,s,a,o){var h=new O(i,n,r,s,a,o);(!e||e(h))&&t.push(h)}function e(r,s,a,o,h,u,l,c,d,_,f,g,m){if(!(m>32)){var p,y,w,x=s[0],b=s[1],C=s[6],S=s[7],P=1e-6,M=v.getSignedDistance,z=M(x,b,C,S,s[2],s[3])||0,I=M(x,b,C,S,s[4],s[5])||0,k=z*I>0?.75:4/9,O=k*Math.min(0,z,I),T=k*Math.max(0,z,I),L=M(x,b,C,S,r[0],r[1]),N=M(x,b,C,S,r[2],r[3]),B=M(x,b,C,S,r[4],r[5]),D=M(x,b,C,S,r[6],r[7]);if(x===C&&P>=_-d&&m>3)y=p=(c+l)/2,w=0;else{var j,E,R=i(L,N,B,D),F=R[0],q=R[1];if(j=n(F,q,O,T),F.reverse(),q.reverse(),E=n(F,q,O,T),null==j||null==E)return;r=A.getPart(r,j,E),w=E-j,p=c*j+l*(1-j),y=c*E+l*(1-E)}if(f>.5&&w>.5)if(y-p>_-d){var V=A.subdivide(r,.5),Z=p+(y-p)/2;e(s,V[0],o,a,h,u,d,_,p,Z,w,!g,++m),e(s,V[1],o,a,h,u,d,_,Z,y,w,!g,m)}else{var V=A.subdivide(s,.5),Z=d+(_-d)/2;e(V[0],r,o,a,h,u,d,Z,p,y,w,!g,++m),e(V[1],r,o,a,h,u,Z,_,p,y,w,!g,m)}else if(Math.max(_-d,y-p)<P){var H=p+(y-p)/2,W=d+(_-d)/2;g?t(h,u,o,W,A.evaluate(s,W,0),a,H,A.evaluate(r,H,0)):t(h,u,a,H,A.evaluate(r,H,0),o,W,A.evaluate(s,W,0))}else w>0&&e(s,r,o,a,h,u,d,_,p,y,w,!g,++m)}}function i(t,e,i,n){var r,s=[0,t],a=[1/3,e],o=[2/3,i],h=[1,n],u=v.getSignedDistance,l=u(0,t,1,n,1/3,e),c=u(0,t,1,n,2/3,i),d=!1;if(0>l*c)r=[[s,a,h],[s,o,h]],d=0>l;else{var _,f=0,g=0===l||0===c;Math.abs(l)>Math.abs(c)?(_=a,f=(n-i-(n-t)/3)*(2*(n-i)-n+e)/3):(_=o,f=(e-t+(t-n)/3)*(-2*(t-e)+t-i)/3),r=0>f||g?[[s,_,h],[s,h]]:[[s,a,o,h],[s,h]],d=l?0>l:0>c}return d?r.reverse():r}function n(t,e,i,n){return t[0][1]<i?r(t,!0,i):e[0][1]>n?r(e,!1,n):t[0][0]}function r(t,e,i){for(var n=t[0][0],r=t[0][1],s=1,a=t.length;a>s;s++){var o=t[s][0],h=t[s][1];if(e?h>=i:i>=h)return n+(i-r)*(o-n)/(h-r);n=o,r=h}return null}function s(e,i,n,r,s,a){for(var o=A.isLinear(e),h=o?i:e,u=o?e:i,l=u[0],c=u[1],d=u[6],_=u[7],f=d-l,g=_-c,v=Math.atan2(-g,f),m=Math.sin(v),p=Math.cos(v),y=f*p-g*m,w=[0,0,0,0,y,0,y,0],x=[],b=0;8>b;b+=2){var C=h[b]-l,S=h[b+1]-c;x.push(C*p-S*m,S*p+C*m)}for(var P=[],M=A.solveCubic(x,1,0,P,0,1),b=0;M>b;b++){var z=P[b],C=A.evaluate(x,z,0).x;if(C>=0&&y>=C){var I=A.getParameterOf(w,C,0),k=o?I:z,O=o?z:I;t(s,a,n,k,A.evaluate(e,k,0),r,O,A.evaluate(i,O,0))}}}function a(e,i,n,r,s,a){var o=v.intersect(e[0],e[1],e[6],e[7],i[0],i[1],i[6],i[7]);if(o){var h=o.x,u=o.y;t(s,a,n,A.getParameterOf(e,h,u),o,r,A.getParameterOf(i,h,u),o)}}return{statics:{getIntersections:function(i,n,r,o,h,u){var l=A.isLinear(i),c=A.isLinear(n),d=r.getPoint1(),_=r.getPoint2(),f=o.getPoint1(),g=o.getPoint2(),v=1e-6;return d.isClose(f,v)&&t(h,u,r,0,d,o,0,d),d.isClose(g,v)&&t(h,u,r,0,d,o,1,d),(l&&c?a:l||c?s:e)(i,n,r,o,h,u,0,1,0,1,0,!1,0),_.isClose(f,v)&&t(h,u,r,1,_,o,0,_),_.isClose(g,v)&&t(h,u,r,1,_,o,1,_),h},filterIntersections:function(t,e){function i(t,e){var i=t.getPath(),n=e.getPath();return i===n?t.getIndex()+t.getParameter()-(e.getIndex()+e.getParameter()):i._id-n._id}for(var n=t.length-1,r=1-1e-6,s=n;s>=0;s--){var a=t[s],o=a._curve.getNext(),h=a._curve2.getNext();o&&a._parameter>=r&&(a._parameter=0,a._curve=o),h&&a._parameter2>=r&&(a._parameter2=0,a._curve2=h)}if(n>0){t.sort(i);for(var s=n;s>0;s--)t[s].equals(t[s-1])&&(t.splice(s,1),n--)}if(e){for(var s=n;s>=0;s--)t.push(t[s].getIntersection());t.sort(i)}return t}}}}),O=e.extend({_class:"CurveLocation",beans:!0,initialize:function pe(t,e,i,n,r,s,a){this._id=pe._id=(pe._id||0)+1,this._curve=t,this._segment1=t._segment1,this._segment2=t._segment2,this._parameter=e,this._point=i,this._curve2=n,this._parameter2=r,this._point2=s,this._distance=a},getSegment:function(t){if(!this._segment){var e=this.getCurve(),i=this.getParameter();if(1===i)this._segment=e._segment2;else if(0===i||t)this._segment=e._segment1;else{if(null==i)return null;this._segment=e.getPartLength(0,i)<e.getPartLength(i,1)?e._segment1:e._segment2}}return this._segment},getCurve:function(t){return(!this._curve||t)&&(this._curve=this._segment1.getCurve(),null==this._curve.getParameterOf(this._point)&&(this._curve=this._segment2.getPrevious().getCurve())),this._curve},getIntersection:function(){var t=this._intersection;if(!t&&this._curve2){var e=this._parameter2;this._intersection=t=new O(this._curve2,e,this._point2||this._point,this),t._intersection=this}return t},getPath:function(){var t=this.getCurve();return t&&t._path},getIndex:function(){var t=this.getCurve();return t&&t.getIndex()},getOffset:function(){var t=this.getPath();return t?t._getOffset(this):this.getCurveOffset()},getCurveOffset:function(){var t=this.getCurve(),e=this.getParameter();return null!=e&&t&&t.getPartLength(0,e)},getParameter:function(t){if((null==this._parameter||t)&&this._point){var e=this.getCurve(t);this._parameter=e&&e.getParameterOf(this._point)}return this._parameter},getPoint:function(t){if((!this._point||t)&&null!=this._parameter){var e=this.getCurve(t);this._point=e&&e.getPointAt(this._parameter,!0)}return this._point},getDistance:function(){return this._distance},divide:function(){var t=this.getCurve(!0);return t&&t.divide(this.getParameter(!0),!0)},split:function(){var t=this.getCurve(!0);return t&&t.split(this.getParameter(!0),!0)},equals:function(t){var e=Math.abs,i=1e-6;return this===t||t&&this._curve===t._curve&&this._curve2===t._curve2&&e(this._parameter-t._parameter)<=i&&e(this._parameter2-t._parameter2)<=i||!1},toString:function(){var t=[],e=this.getPoint(),i=a.instance;e&&t.push("point: "+e);var n=this.getIndex();null!=n&&t.push("index: "+n);var r=this.getParameter();return null!=r&&t.push("parameter: "+i.number(r)),null!=this._distance&&t.push("distance: "+i.number(this._distance)),"{ "+t.join(", ")+" }"}},e.each(["getTangent","getNormal","getCurvature"],function(t){var e=t+"At";this[t]=function(){var t=this.getParameter(),i=this.getCurve();return null!=t&&i&&i[e](t,!0)}},{})),T=w.extend({_class:"PathItem",initialize:function(){},getIntersections:function(e,i,n){this===e&&(e=null);var r=[],s=this.getCurves(),a=e?e.getCurves():s,o=this._matrix.orNullIfIdentity(),h=e?(i||e._matrix).orNullIfIdentity():o,u=s.length,l=e?a.length:u,c=[],d=1e-6,_=1-d;if(e&&!this.getBounds(o).touches(e.getBounds(h)))return[];for(var f=0;l>f;f++)c[f]=a[f].getValues(h);for(var f=0;u>f;f++){var g=s[f],m=e?g.getValues(o):c[f];if(!e){var p=g.getSegment1(),y=g.getSegment2(),w=p._handleOut,x=y._handleIn;if(new v(p._point.subtract(w),w.multiply(2),!0).intersect(new v(y._point.subtract(x),x.multiply(2),!0),!1)){var b=A.subdivide(m);A.getIntersections(b[0],b[1],g,g,r,function(e){return e._parameter<=_?(e._parameter/=2,e._parameter2=.5+e._parameter2/2,!0):t})}}for(var C=e?0:f+1;l>C;C++)A.getIntersections(m,c[C],g,a[C],r,!e&&(C===f+1||C===l-1&&0===f)&&function(t){var e=t._parameter;return e>=d&&_>=e})}return A.filterIntersections(r,n)},_asPathItem:function(){return this},setPathData:function(t){function e(t,e){var i=+n[t];return o&&(i+=u[e]),i}function i(t){return new h(e(t,"x"),e(t+1,"y"))}var n,r,s,a=t.match(/[mlhvcsqtaz][^mlhvcsqtaz]*/gi),o=!1,u=new h,l=new h;this.clear();for(var d=0,_=a&&a.length;_>d;d++){var f=a[d],g=f[0],v=g.toLowerCase();n=f.match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g);var m=n&&n.length;switch(o=g===v,"z"!==r||/[mz]/.test(v)||this.moveTo(u=l),v){case"m":case"l":var p="m"===v;p&&r&&"z"!==r&&this.closePath(!0);for(var y=0;m>y;y+=2)this[0===y&&p?"moveTo":"lineTo"](u=i(y));s=u,p&&(l=u);break;case"h":case"v":for(var w="h"===v?"x":"y",y=0;m>y;y++)u[w]=e(y,w),this.lineTo(u);s=u;break;case"c":for(var y=0;m>y;y+=6)this.cubicCurveTo(i(y),s=i(y+2),u=i(y+4));break;case"s":for(var y=0;m>y;y+=4)this.cubicCurveTo(/[cs]/.test(r)?u.multiply(2).subtract(s):u,s=i(y),u=i(y+2)),r=v;
break;case"q":for(var y=0;m>y;y+=4)this.quadraticCurveTo(s=i(y),u=i(y+2));break;case"t":for(var y=0;m>y;y+=2)this.quadraticCurveTo(s=/[qt]/.test(r)?u.multiply(2).subtract(s):u,u=i(y)),r=v;break;case"a":for(var y=0;m>y;y+=7)this.arcTo(u=i(y+5),new c(+n[y],+n[y+1]),+n[y+2],+n[y+4],+n[y+3]);break;case"z":this.closePath(!0)}r=v}},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_contains:function(t){var e=this._getWinding(t,!1,!0);return!!("evenodd"===this.getWindingRule()?1&e:e)}}),L=T.extend({_class:"Path",_serializeFields:{segments:[],closed:!1},initialize:function(e){this._closed=!1,this._segments=[];var i=Array.isArray(e)?"object"==typeof e[0]?e:arguments:!e||e.size!==t||e.x===t&&e.point===t?null:arguments;i&&i.length>0?this.setSegments(i):(this._curves=t,this._selectedSegmentState=0,i||"string"!=typeof e||(this.setPathData(e),e=null)),this._initialize(!i&&e)},_equals:function(t){return this._closed===t._closed&&e.equals(this._segments,t._segments)},clone:function(e){var i=new L(w.NO_INSERT);return i.setSegments(this._segments),i._closed=this._closed,this._clockwise!==t&&(i._clockwise=this._clockwise),this._clone(i,e)},_changed:function ye(e){if(ye.base.call(this,e),8&e){var i=this._parent;if(i&&(i._currentPath=t),this._length=this._clockwise=t,this._curves&&!(16&e))for(var n=0,r=this._curves.length;r>n;n++)this._curves[n]._changed();this._monoCurves=t}else 32&e&&(this._bounds=t)},getStyle:function(){var t=this._parent;return(t instanceof N?t:this)._style},getSegments:function(){return this._segments},setSegments:function(e){var i=this.isFullySelected();this._segments.length=0,this._selectedSegmentState=0,this._curves=t,e&&e.length>0&&this._add(z.readAll(e)),i&&this.setFullySelected(!0)},getFirstSegment:function(){return this._segments[0]},getLastSegment:function(){return this._segments[this._segments.length-1]},getCurves:function(){var t=this._curves,e=this._segments;if(!t){var i=this._countCurves();t=this._curves=Array(i);for(var n=0;i>n;n++)t[n]=new A(this,e[n],e[n+1]||e[0])}return t},getFirstCurve:function(){return this.getCurves()[0]},getLastCurve:function(){var t=this.getCurves();return t[t.length-1]},isClosed:function(){return this._closed},setClosed:function(t){if(this._closed!=(t=!!t)){if(this._closed=t,this._curves){var e=this._curves.length=this._countCurves();t&&(this._curves[e-1]=new A(this,this._segments[e-1],this._segments[0]))}this._changed(25)}}},{beans:!0,getPathData:function(t,e){function i(e,i){e._transformCoordinates(t,g,!1),n=g[0],r=g[1],v?(m.push("M"+f.pair(n,r)),v=!1):(h=g[2],u=g[3],h===n&&u===r&&l===s&&c===o?i||m.push("l"+f.pair(n-s,r-o)):m.push("c"+f.pair(l-s,c-o)+" "+f.pair(h-s,u-o)+" "+f.pair(n-s,r-o))),s=n,o=r,l=g[4],c=g[5]}var n,r,s,o,h,u,l,c,d=this._segments,_=d.length,f=new a(e),g=Array(6),v=!0,m=[];if(0===_)return"";for(var p=0;_>p;p++)i(d[p]);return this._closed&&_>0&&(i(d[0],!0),m.push("z")),m.join("")}},{isEmpty:function(){return 0===this._segments.length},isPolygon:function(){for(var t=0,e=this._segments.length;e>t;t++)if(!this._segments[t].isLinear())return!1;return!0},_transformContent:function(t){for(var e=Array(6),i=0,n=this._segments.length;n>i;i++)this._segments[i]._transformCoordinates(t,e,!0);return!0},_add:function(t,e){for(var i=this._segments,n=this._curves,r=t.length,s=null==e,e=s?i.length:e,a=0;r>a;a++){var o=t[a];o._path&&(o=t[a]=o.clone()),o._path=this,o._index=e+a,o._selectionState&&this._updateSelection(o,0,o._selectionState)}if(s)i.push.apply(i,t);else{i.splice.apply(i,[e,0].concat(t));for(var a=e+r,h=i.length;h>a;a++)i[a]._index=a}if(n||t._curves){n||(n=this._curves=[]);var u=e>0?e-1:e,l=u,c=Math.min(u+r,this._countCurves());t._curves&&(n.splice.apply(n,[u,0].concat(t._curves)),l+=t._curves.length);for(var a=l;c>a;a++)n.splice(a,0,new A(this,null,null));this._adjustCurves(u,c)}return this._changed(25),t},_adjustCurves:function(t,e){for(var i,n=this._segments,r=this._curves,s=t;e>s;s++)i=r[s],i._path=this,i._segment1=n[s],i._segment2=n[s+1]||n[0],i._changed();(i=r[this._closed&&0===t?n.length-1:t-1])&&(i._segment2=n[t]||n[0],i._changed()),(i=r[e])&&(i._segment1=n[e],i._changed())},_countCurves:function(){var t=this._segments.length;return!this._closed&&t>0?t-1:t},add:function(t){return arguments.length>1&&"number"!=typeof t?this._add(z.readAll(arguments)):this._add([z.read(arguments)])[0]},insert:function(t,e){return arguments.length>2&&"number"!=typeof e?this._add(z.readAll(arguments,1),t):this._add([z.read(arguments,1)],t)[0]},addSegment:function(){return this._add([z.read(arguments)])[0]},insertSegment:function(t){return this._add([z.read(arguments,1)],t)[0]},addSegments:function(t){return this._add(z.readAll(t))},insertSegments:function(t,e){return this._add(z.readAll(e),t)},removeSegment:function(t){return this.removeSegments(t,t+1)[0]||null},removeSegments:function(t,i,n){t=t||0,i=e.pick(i,this._segments.length);var r=this._segments,s=this._curves,a=r.length,o=r.splice(t,i-t),h=o.length;if(!h)return o;for(var u=0;h>u;u++){var l=o[u];l._selectionState&&this._updateSelection(l,l._selectionState,0),l._index=l._path=null}for(var u=t,c=r.length;c>u;u++)r[u]._index=u;if(s){var d=t>0&&i===a+(this._closed?1:0)?t-1:t,s=s.splice(d,h);n&&(o._curves=s.slice(1)),this._adjustCurves(d,d)}return this._changed(25),o},clear:"#removeSegments",getLength:function(){if(null==this._length){var t=this.getCurves();this._length=0;for(var e=0,i=t.length;i>e;e++)this._length+=t[e].getLength()}return this._length},getArea:function(){for(var t=this.getCurves(),e=0,i=0,n=t.length;n>i;i++)e+=t[i].getArea();return e},isFullySelected:function(){var t=this._segments.length;return this._selected&&t>0&&this._selectedSegmentState===7*t},setFullySelected:function(t){t&&this._selectSegments(!0),this.setSelected(t)},setSelected:function we(t){t||this._selectSegments(!1),we.base.call(this,t)},_selectSegments:function(t){var e=this._segments.length;this._selectedSegmentState=t?7*e:0;for(var i=0;e>i;i++)this._segments[i]._selectionState=t?7:0},_updateSelection:function(t,e,i){t._selectionState=i;var n=this._selectedSegmentState+=i-e;n>0&&this.setSelected(!0)},flatten:function(t){for(var e=new B(this,64,.1),i=0,n=e.length/Math.ceil(e.length/t),r=e.length+(this._closed?-n:n)/2,s=[];r>=i;)s.push(new z(e.evaluate(i,0))),i+=n;this.setSegments(s)},reduce:function(){for(var t=this.getCurves(),e=t.length-1;e>=0;e--){var i=t[e];i.isLinear()&&0===i.getLength()&&i.remove()}return this},simplify:function(t){if(this._segments.length>2){var e=new D(this,t||2.5);this.setSegments(e.fit())}},split:function(t,e){if(null===e)return null;if(1===arguments.length){var i=t;if("number"==typeof i&&(i=this.getLocationAt(i)),!i)return null;t=i.index,e=i.parameter}var n=1e-6;e>=1-n&&(t++,e--);var r=this.getCurves();if(t>=0&&t<r.length){e>n&&r[t++].divide(e,!0);var s,a=this.removeSegments(t,this._segments.length,!0);return this._closed?(this.setClosed(!1),s=this):s=this._clone((new L).insertAbove(this,!0)),s._add(a,0),this.addSegment(a[0]),s}return null},isClockwise:function(){return this._clockwise!==t?this._clockwise:L.isClockwise(this._segments)},setClockwise:function(t){this.isClockwise()!=(t=!!t)&&this.reverse(),this._clockwise=t},reverse:function(){this._segments.reverse();for(var e=0,i=this._segments.length;i>e;e++){var n=this._segments[e],r=n._handleIn;n._handleIn=n._handleOut,n._handleOut=r,n._index=e}this._curves=null,this._clockwise!==t&&(this._clockwise=!this._clockwise),this._changed(9)},join:function(t){if(t){var e=t._segments,i=this.getLastSegment(),n=t.getLastSegment();if(!n)return this;i&&i._point.equals(n._point)&&t.reverse();var r=t.getFirstSegment();if(i&&i._point.equals(r._point))i.setHandleOut(r._handleOut),this._add(e.slice(1));else{var s=this.getFirstSegment();s&&s._point.equals(r._point)&&t.reverse(),n=t.getLastSegment(),s&&s._point.equals(n._point)?(s.setHandleIn(n._handleIn),this._add(e.slice(0,e.length-1),0)):this._add(e.slice())}t.closed&&this._add([e[0]]),t.remove()}var a=this.getFirstSegment(),o=this.getLastSegment();return a!==o&&a._point.equals(o._point)&&(a.setHandleIn(o._handleIn),o.remove(),this.setClosed(!0)),this},toShape:function(e){function i(t,e){return d[t].isColinear(d[e])}function n(t){return d[t].isOrthogonal()}function r(t){return d[t].isArc()}function s(t,e){return d[t]._point.getDistance(d[e]._point)}if(!this._closed)return null;var a,h,u,l,d=this._segments;if(this.isPolygon()&&4===d.length&&i(0,2)&&i(1,3)&&n(1)?(a=C.Rectangle,h=new c(s(0,3),s(0,1)),l=d[1]._point.add(d[2]._point).divide(2)):8===d.length&&r(0)&&r(2)&&r(4)&&r(6)&&i(1,5)&&i(3,7)?(a=C.Rectangle,h=new c(s(1,6),s(0,3)),u=h.subtract(new c(s(0,7),s(1,2))).divide(2),l=d[3]._point.add(d[4]._point).divide(2)):4===d.length&&r(0)&&r(1)&&r(2)&&r(3)&&(o.isZero(s(0,2)-s(1,3))?(a=C.Circle,u=s(0,2)/2):(a=C.Ellipse,u=new c(s(2,0)/2,s(3,1)/2)),l=d[1]._point),a){var _=this.getPosition(!0),f=new a({center:_,size:h,radius:u,insert:!1});return f.rotate(l.subtract(_).getAngle()+90),f.setStyle(this._style),(e||e===t)&&f.insertAbove(this),f}return null},_hitTestSelf:function(t,e){function i(e,i){return t.subtract(e).divide(i).length<=1}function n(t,n,r){if(!e.selected||n.isSelected()){var s=t._point;if(n!==s&&(n=n.add(s)),i(n,w))return new M(r,f,{segment:t,point:n})}}function r(t,i){return(i||e.segments)&&n(t,t._point,"segment")||!i&&e.handles&&(n(t,t._handleIn,"handle-in")||n(t,t._handleOut,"handle-out"))}function s(t){c.add(t)}function a(e){if(("round"!==o||"round"!==u)&&(c=new L({internal:!0,closed:!0}),p||e._index>0&&e._index<m-1?"round"!==o&&(e._handleIn.isZero()||e._handleOut.isZero())&&L._addBevelJoin(e,o,S,l,s,!0):"round"!==u&&L._addSquareCap(e,u,S,s,!0),!c.isEmpty())){var n;return c.contains(t)||(n=c.getNearestLocation(t))&&i(n.getPoint(),y)}return i(e._point,w)}var o,u,l,c,d,_,f=this,g=this.getStyle(),v=this._segments,m=v.length,p=this._closed,y=e._tolerancePadding,w=y,x=e.stroke&&g.hasStroke(),b=e.fill&&g.hasFill(),C=e.curves,S=x?g.getStrokeWidth()/2:b&&e.tolerance>0||C?0:null;if(null!==S&&(S>0?(o=g.getStrokeJoin(),u=g.getStrokeCap(),l=S*g.getMiterLimit(),w=y.add(new h(S,S))):o=u="round"),!e.ends||e.segments||p){if(e.segments||e.handles)for(var P=0;m>P;P++)if(_=r(v[P]))return _}else if(_=r(v[0],!0)||r(v[m-1],!0))return _;if(null!==S){if(d=this.getNearestLocation(t)){var z=d.getParameter();0===z||1===z&&m>1?a(d.getSegment())||(d=null):i(d.getPoint(),w)||(d=null)}if(!d&&"miter"===o&&m>1)for(var P=0;m>P;P++){var I=v[P];if(t.getDistance(I._point)<=l&&a(I)){d=I.getLocation();break}}}return!d&&b&&this._contains(t)||d&&!x&&!C?new M("fill",this):d?new M(x?"stroke":"curve",this,{location:d,point:d.getPoint()}):null}},e.each(["getPoint","getTangent","getNormal","getCurvature"],function(t){this[t+"At"]=function(e,i){var n=this.getLocationAt(e,i);return n&&n[t]()}},{beans:!1,_getOffset:function(t){var e=t&&t.getIndex();if(null!=e){for(var i=this.getCurves(),n=0,r=0;e>r;r++)n+=i[r].getLength();var s=i[e],a=t.getParameter();return a>0&&(n+=s.getPartLength(0,a)),n}return null},getLocationOf:function(){for(var t=h.read(arguments),e=this.getCurves(),i=0,n=e.length;n>i;i++){var r=e[i].getLocationOf(t);if(r)return r}return null},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getLocationAt:function(t,e){var i=this.getCurves(),n=0;if(e){var r=~~t;return i[r].getLocationAt(t-r,!0)}for(var s=0,a=i.length;a>s;s++){var o=n,h=i[s];if(n+=h.getLength(),n>t)return h.getLocationAt(t-o)}return t<=this.getLength()?new O(i[i.length-1],1):null},getNearestLocation:function(){for(var t=h.read(arguments),e=this.getCurves(),i=1/0,n=null,r=0,s=e.length;s>r;r++){var a=e[r].getNearestLocation(t);a._distance<i&&(i=a._distance,n=a)}return n},getNearestPoint:function(){return this.getNearestLocation.apply(this,arguments).getPoint()}}),new function(){function t(t,e,i,n){function r(e){var i=a[e],n=a[e+1];(c!=i||d!=n)&&(t.beginPath(),t.moveTo(c,d),t.lineTo(i,n),t.stroke(),t.beginPath(),t.arc(i,n,s,0,2*Math.PI,!0),t.fill())}for(var s=n/2,a=Array(6),o=0,h=e.length;h>o;o++){var u=e[o];u._transformCoordinates(i,a,!1);var l=u._selectionState,c=a[0],d=a[1];if(1&l&&r(2),2&l&&r(4),t.fillRect(c-s,d-s,n,n),!(4&l)){var _=t.fillStyle;t.fillStyle="#ffffff",t.fillRect(c-s+1,d-s+1,n-2,n-2),t.fillStyle=_}}}function e(t,e,i){function n(e){if(i)e._transformCoordinates(i,f,!1),r=f[0],s=f[1];else{var n=e._point;r=n._x,s=n._y}if(g)t.moveTo(r,s),g=!1;else{if(i)h=f[2],u=f[3];else{var d=e._handleIn;h=r+d._x,u=s+d._y}h===r&&u===s&&l===a&&c===o?t.lineTo(r,s):t.bezierCurveTo(l,c,h,u,r,s)}if(a=r,o=s,i)l=f[4],c=f[5];else{var d=e._handleOut;l=a+d._x,c=o+d._y}}for(var r,s,a,o,h,u,l,c,d=e._segments,_=d.length,f=Array(6),g=!0,v=0;_>v;v++)n(d[v]);e._closed&&_>0&&n(d[0])}return{_draw:function(t,i,n){function r(t){return l[(t%c+c)%c]}var s=i.dontStart,a=i.dontFinish||i.clip,o=this.getStyle(),h=o.hasFill(),u=o.hasStroke(),l=o.getDashArray(),c=!paper.support.nativeDash&&u&&l&&l.length;if(s||t.beginPath(),!s&&this._currentPath?t.currentPath=this._currentPath:(h||u&&!c||a)&&(e(t,this,n),this._closed&&t.closePath(),s||(this._currentPath=t.currentPath)),!a&&(h||u)&&(this._setStyles(t),h&&(t.fill(o.getWindingRule()),t.shadowColor="rgba(0,0,0,0)"),u)){if(c){s||t.beginPath();var d,_=new B(this,32,.25,n),f=_.length,g=-o.getDashOffset(),v=0;for(g%=f;g>0;)g-=r(v--)+r(v--);for(;f>g;)d=g+r(v++),(g>0||d>0)&&_.drawPart(t,Math.max(g,0),Math.max(d,0)),g=d+r(v++)}t.stroke()}},_drawSelected:function(i,n){i.beginPath(),e(i,this,n),i.stroke(),t(i,this._segments,n,paper.settings.handleSize)}}},new function(){function t(t){var e=t.length,i=[],n=[],r=2;i[0]=t[0]/r;for(var s=1;e>s;s++)n[s]=1/r,r=(e-1>s?4:2)-n[s],i[s]=(t[s]-i[s-1])/r;for(var s=1;e>s;s++)i[e-s-1]-=n[e-s]*i[e-s];return i}return{smooth:function(){var e=this._segments,i=e.length,n=this._closed,r=i,s=0;if(!(2>=i)){n&&(s=Math.min(i,4),r+=2*Math.min(i,s));for(var a=[],o=0;i>o;o++)a[o+s]=e[o]._point;if(n)for(var o=0;s>o;o++)a[o]=e[o+i-s]._point,a[o+i+s]=e[o]._point;else r--;for(var u=[],o=1;r-1>o;o++)u[o]=4*a[o]._x+2*a[o+1]._x;u[0]=a[0]._x+2*a[1]._x,u[r-1]=3*a[r-1]._x;for(var l=t(u),o=1;r-1>o;o++)u[o]=4*a[o]._y+2*a[o+1]._y;u[0]=a[0]._y+2*a[1]._y,u[r-1]=3*a[r-1]._y;var c=t(u);if(n){for(var o=0,d=i;s>o;o++,d++){var _=o/s,f=1-_,g=o+s,v=d+s;l[d]=l[o]*_+l[d]*f,c[d]=c[o]*_+c[d]*f,l[v]=l[g]*f+l[v]*_,c[v]=c[g]*f+c[v]*_}r--}for(var m=null,o=s;r-s>=o;o++){var p=e[o-s];m&&p.setHandleIn(m.subtract(p._point)),r>o&&(p.setHandleOut(new h(l[o],c[o]).subtract(p._point)),m=r-1>o?new h(2*a[o+1]._x-l[o+1],2*a[o+1]._y-c[o+1]):new h((a[r]._x+l[r-1])/2,(a[r]._y+c[r-1])/2))}if(n&&m){var p=this._segments[0];p.setHandleIn(m.subtract(p._point))}}}}},new function(){function t(t){var e=t._segments;if(0===e.length)throw Error("Use a moveTo() command first");return e[e.length-1]}return{moveTo:function(){var t=this._segments;1===t.length&&this.removeSegment(0),t.length||this._add([new z(h.read(arguments))])},moveBy:function(){throw Error("moveBy() is unsupported on Path items.")},lineTo:function(){this._add([new z(h.read(arguments))])},cubicCurveTo:function(){var e=h.read(arguments),i=h.read(arguments),n=h.read(arguments),r=t(this);r.setHandleOut(e.subtract(r._point)),this._add([new z(n,i.subtract(n))])},quadraticCurveTo:function(){var e=h.read(arguments),i=h.read(arguments),n=t(this)._point;this.cubicCurveTo(e.add(n.subtract(e).multiply(1/3)),e.add(i.subtract(e).multiply(1/3)),i)},curveTo:function(){var i=h.read(arguments),n=h.read(arguments),r=e.pick(e.read(arguments),.5),s=1-r,a=t(this)._point,o=i.subtract(a.multiply(s*s)).subtract(n.multiply(r*r)).divide(2*r*s);if(o.isNaN())throw Error("Cannot put a curve through points with parameter = "+r);this.quadraticCurveTo(o,n)},arcTo:function(){var i,n,r,s,a,o=t(this),u=o._point,l=h.read(arguments),d=e.peek(arguments),_=e.pick(d,!0);if("boolean"==typeof _)var f=u.add(l).divide(2),i=f.add(f.subtract(u).rotate(_?-90:90));else if(e.remain(arguments)<=2)i=l,l=h.read(arguments);else{var m=c.read(arguments);if(m.isZero())return this.lineTo(l);var p=e.read(arguments),_=!!e.read(arguments),y=!!e.read(arguments),f=u.add(l).divide(2),w=u.subtract(f).rotate(-p),x=w.x,b=w.y,C=Math.abs,S=1e-12,P=C(m.width),M=C(m.height),I=P*P,k=M*M,A=x*x,O=b*b,T=Math.sqrt(A/I+O/k);if(T>1&&(P*=T,M*=T,I=P*P,k=M*M),T=(I*k-I*O-k*A)/(I*O+k*A),C(T)<S&&(T=0),0>T)throw Error("Cannot create an arc with the given arguments");n=new h(P*b/M,-M*x/P).multiply((y===_?-1:1)*Math.sqrt(T)).rotate(p).add(f),a=(new g).translate(n).rotate(p).scale(P,M),s=a._inverseTransform(u),r=s.getDirectedAngle(a._inverseTransform(l)),!_&&r>0?r-=360:_&&0>r&&(r+=360)}if(i){var L=new v(u.add(i).divide(2),i.subtract(u).rotate(90),!0),N=new v(i.add(l).divide(2),l.subtract(i).rotate(90),!0),B=new v(u,l),D=B.getSide(i);if(n=L.intersect(N,!0),!n){if(!D)return this.lineTo(l);throw Error("Cannot create an arc with the given arguments")}s=u.subtract(n),r=s.getDirectedAngle(l.subtract(n));var j=B.getSide(n);0===j?r=D*Math.abs(r):D===j&&(r+=0>r?360:-360)}for(var E=Math.abs(r),R=E>=360?4:Math.ceil(E/90),F=r/R,q=F*Math.PI/360,V=4/3*Math.sin(q)/(1+Math.cos(q)),Z=[],H=0;R>=H;H++){var w=l,W=null;if(R>H&&(W=s.rotate(90).multiply(V),a?(w=a._transformPoint(s),W=a._transformPoint(s.add(W)).subtract(w)):w=n.add(s)),0===H)o.setHandleOut(W);else{var G=s.rotate(-90).multiply(V);a&&(G=a._transformPoint(s.add(G)).subtract(w)),Z.push(new z(w,G,W))}s=s.rotate(F)}this._add(Z)},lineBy:function(){var e=h.read(arguments),i=t(this)._point;this.lineTo(i.add(e))},curveBy:function(){var i=h.read(arguments),n=h.read(arguments),r=e.read(arguments),s=t(this)._point;this.curveTo(s.add(i),s.add(n),r)},cubicCurveBy:function(){var e=h.read(arguments),i=h.read(arguments),n=h.read(arguments),r=t(this)._point;this.cubicCurveTo(r.add(e),r.add(i),r.add(n))},quadraticCurveBy:function(){var e=h.read(arguments),i=h.read(arguments),n=t(this)._point;this.quadraticCurveTo(n.add(e),n.add(i))},arcBy:function(){var i=t(this)._point,n=i.add(h.read(arguments)),r=e.pick(e.peek(arguments),!0);"boolean"==typeof r?this.arcTo(n,r):this.arcTo(n,i.add(h.read(arguments)))},closePath:function(t){this.setClosed(!0),t&&this.join()}}},{_getBounds:function(t,e){return L[t](this._segments,this._closed,this.getStyle(),e)},statics:{isClockwise:function(t){for(var e=0,i=0,n=t.length;n>i;i++)e+=A.getEdgeSum(A.getValues(t[i],t[n>i+1?i+1:0]));return e>0},getBounds:function(t,e,i,n,r){function s(t){t._transformCoordinates(n,o,!1);for(var e=0;2>e;e++)A._addBounds(h[e],h[e+4],o[e+2],o[e],e,r?r[e]:0,u,l,c);var i=h;h=o,o=i}var a=t[0];if(!a)return new _;for(var o=Array(6),h=a._transformCoordinates(n,Array(6),!1),u=h.slice(0,2),l=u.slice(),c=Array(2),d=1,f=t.length;f>d;d++)s(t[d]);return e&&s(a),new _(u[0],u[1],l[0]-u[0],l[1]-u[1])},getStrokeBounds:function(t,e,i,n){function r(t){d=d.include(n?n._transformPoint(t,t):t)}function s(t){d=d.unite(m.setCenter(n?n._transformPoint(t._point):t._point))}function a(t,e){var i=t._handleIn,n=t._handleOut;"round"===e||!i.isZero()&&!n.isZero()&&i.isColinear(n)?s(t):L._addBevelJoin(t,e,u,v,r)}function o(t,e){"round"===e?s(t):L._addSquareCap(t,e,u,r)}if(!i.hasStroke())return L.getBounds(t,e,i,n);for(var h=t.length-(e?0:1),u=i.getStrokeWidth()/2,l=L._getPenPadding(u,n),d=L.getBounds(t,e,i,n,l),f=i.getStrokeJoin(),g=i.getStrokeCap(),v=u*i.getMiterLimit(),m=new _(new c(l).multiply(2)),p=1;h>p;p++)a(t[p],f);return e?a(t[0],f):h>0&&(o(t[0],g),o(t[t.length-1],g)),d},_getPenPadding:function(t,e){if(!e)return[t,t];var i=e.shiftless(),n=i.transform(new h(t,0)),r=i.transform(new h(0,t)),s=n.getAngleInRadians(),a=n.getLength(),o=r.getLength(),u=Math.sin(s),l=Math.cos(s),c=Math.tan(s),d=-Math.atan(o*c/a),_=Math.atan(o/(c*a));return[Math.abs(a*Math.cos(d)*l-o*Math.sin(d)*u),Math.abs(o*Math.sin(_)*l+a*Math.cos(_)*u)]},_addBevelJoin:function(t,e,i,n,r,s){var a=t.getCurve(),o=a.getPrevious(),u=a.getPointAt(0,!0),l=o.getNormalAt(1,!0),c=a.getNormalAt(0,!0),d=l.getDirectedAngle(c)<0?-i:i;if(l.setLength(d),c.setLength(d),s&&(r(u),r(u.add(l))),"miter"===e){var _=new v(u.add(l),new h(-l.y,l.x),!0).intersect(new v(u.add(c),new h(-c.y,c.x),!0),!0);if(_&&u.getDistance(_)<=n&&(r(_),!s))return}s||r(u.add(l)),r(u.add(c))},_addSquareCap:function(t,e,i,n,r){var s=t._point,a=t.getLocation(),o=a.getNormal().normalize(i);r&&(n(s.subtract(o)),n(s.add(o))),"square"===e&&(s=s.add(o.rotate(0===a.getParameter()?-90:90))),n(s.add(o)),n(s.subtract(o))},getHandleBounds:function(t,e,i,n,r,s){for(var a=Array(6),o=1/0,h=-o,u=o,l=h,c=0,d=t.length;d>c;c++){var f=t[c];f._transformCoordinates(n,a,!1);for(var g=0;6>g;g+=2){var v=0===g?s:r,m=v?v[0]:0,p=v?v[1]:0,y=a[g],w=a[g+1],x=y-m,b=y+m,C=w-p,S=w+p;o>x&&(o=x),b>h&&(h=b),u>C&&(u=C),S>l&&(l=S)}}return new _(o,u,h-o,l-u)},getRoughBounds:function(t,e,i,n){var r=i.hasStroke()?i.getStrokeWidth()/2:0,s=r;return r>0&&("miter"===i.getStrokeJoin()&&(s=r*i.getMiterLimit()),"square"===i.getStrokeCap()&&(s=Math.max(s,r*Math.sqrt(2)))),L.getHandleBounds(t,e,i,n,L._getPenPadding(r,n),L._getPenPadding(s,n))}}});L.inject({statics:new function(){function t(t,i,n){var r=e.getNamed(n),s=new L(r&&r.insert===!1&&w.NO_INSERT);return s._add(t),s._closed=i,s.set(r)}function i(e,i,n){for(var s=Array(4),a=0;4>a;a++){var o=r[a];s[a]=new z(o._point.multiply(i).add(e),o._handleIn.multiply(i),o._handleOut.multiply(i))}return t(s,!0,n)}var n=.5522847498307936,r=[new z([-1,0],[0,n],[0,-n]),new z([0,-1],[-n,0],[n,0]),new z([1,0],[0,-n],[0,n]),new z([0,1],[n,0],[-n,0])];return{Line:function(){return t([new z(h.readNamed(arguments,"from")),new z(h.readNamed(arguments,"to"))],!1,arguments)},Circle:function(){var t=h.readNamed(arguments,"center"),n=e.readNamed(arguments,"radius");return i(t,new c(n),arguments)},Rectangle:function(){var e,i=_.readNamed(arguments,"rectangle"),r=c.readNamed(arguments,"radius",0,{readNull:!0}),s=i.getBottomLeft(!0),a=i.getTopLeft(!0),o=i.getTopRight(!0),h=i.getBottomRight(!0);if(!r||r.isZero())e=[new z(s),new z(a),new z(o),new z(h)];else{r=c.min(r,i.getSize(!0).divide(2));var u=r.width,l=r.height,d=u*n,f=l*n;e=[new z(s.add(u,0),null,[-d,0]),new z(s.subtract(0,l),[0,f]),new z(a.add(0,l),null,[0,-f]),new z(a.add(u,0),[-d,0],null),new z(o.subtract(u,0),null,[d,0]),new z(o.add(0,l),[0,-f],null),new z(h.subtract(0,l),null,[0,f]),new z(h.subtract(u,0),[d,0])]}return t(e,!0,arguments)},RoundRectangle:"#Rectangle",Ellipse:function(){var t=C._readEllipse(arguments);return i(t.center,t.radius,arguments)},Oval:"#Ellipse",Arc:function(){var t=h.readNamed(arguments,"from"),i=h.readNamed(arguments,"through"),n=h.readNamed(arguments,"to"),r=e.getNamed(arguments),s=new L(r&&r.insert===!1&&w.NO_INSERT);return s.moveTo(t),s.arcTo(i,n),s.set(r)},RegularPolygon:function(){for(var i=h.readNamed(arguments,"center"),n=e.readNamed(arguments,"sides"),r=e.readNamed(arguments,"radius"),s=360/n,a=!(n%3),o=new h(0,a?-r:r),u=a?-1:.5,l=Array(n),c=0;n>c;c++)l[c]=new z(i.add(o.rotate((c+u)*s)));return t(l,!0,arguments)},Star:function(){for(var i=h.readNamed(arguments,"center"),n=2*e.readNamed(arguments,"points"),r=e.readNamed(arguments,"radius1"),s=e.readNamed(arguments,"radius2"),a=360/n,o=new h(0,-1),u=Array(n),l=0;n>l;l++)u[l]=new z(i.add(o.rotate(a*l).multiply(l%2?s:r)));return t(u,!0,arguments)}}}});var N=T.extend({_class:"CompoundPath",_serializeFields:{children:[]},initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||("string"==typeof t?this.setPathData(t):this.addChildren(Array.isArray(t)?t:arguments))},insertChildren:function xe(e,i,n){i=xe.base.call(this,e,i,n,L);for(var r=0,s=!n&&i&&i.length;s>r;r++){var a=i[r];a._clockwise===t&&a.setClockwise(0===a._index)}return i},reverse:function(){for(var t=this._children,e=0,i=t.length;i>e;e++)t[e].reverse()},smooth:function(){for(var t=0,e=this._children.length;e>t;t++)this._children[t].smooth()},reduce:function be(){if(0===this._children.length){var t=new L(w.NO_INSERT);return t.insertAbove(this),t.setStyle(this._style),this.remove(),t}return be.base.call(this)},isClockwise:function(){var t=this.getFirstChild();return t&&t.isClockwise()},setClockwise:function(t){this.isClockwise()!==!!t&&this.reverse()},getFirstSegment:function(){var t=this.getFirstChild();return t&&t.getFirstSegment()},getLastSegment:function(){var t=this.getLastChild();return t&&t.getLastSegment()},getCurves:function(){for(var t=this._children,e=[],i=0,n=t.length;n>i;i++)e.push.apply(e,t[i].getCurves());return e},getFirstCurve:function(){var t=this.getFirstChild();return t&&t.getFirstCurve()},getLastCurve:function(){var t=this.getLastChild();return t&&t.getFirstCurve()},getArea:function(){for(var t=this._children,e=0,i=0,n=t.length;n>i;i++)e+=t[i].getArea();return e}},{beans:!0,getPathData:function(t,e){for(var i=this._children,n=[],r=0,s=i.length;s>r;r++){var a=i[r],o=a._matrix;n.push(a.getPathData(t&&!o.isIdentity()?t.chain(o):o,e))}return n.join(" ")}},{_getChildHitTestOptions:function(t){return t.class===L||"path"===t.type?t:new e(t,{fill:!1})},_draw:function(t,e,i){var n=this._children;if(0!==n.length){if(this._currentPath)t.currentPath=this._currentPath;else{e=e.extend({dontStart:!0,dontFinish:!0}),t.beginPath();for(var r=0,s=n.length;s>r;r++)n[r].draw(t,e,i);this._currentPath=t.currentPath}if(!e.clip){this._setStyles(t);var a=this._style;a.hasFill()&&(t.fill(a.getWindingRule()),t.shadowColor="rgba(0,0,0,0)"),a.hasStroke()&&t.stroke()}}},_drawSelected:function(t,e,i){for(var n=this._children,r=0,s=n.length;s>r;r++){var a=n[r],o=a._matrix;i[a._id]||a._drawSelected(t,o.isIdentity()?e:e.chain(o))}}},new function(){function t(t,e){var i=t._children;if(e&&0===i.length)throw Error("Use a moveTo() command first");return i[i.length-1]}var i={moveTo:function(){var e=t(this),i=e&&e.isEmpty()?e:new L;i!==e&&this.addChild(i),i.moveTo.apply(i,arguments)},moveBy:function(){var e=t(this,!0),i=e&&e.getLastSegment(),n=h.read(arguments);this.moveTo(i?n.add(i._point):n)},closePath:function(e){t(this,!0).closePath(e)}};return e.each(["lineTo","cubicCurveTo","quadraticCurveTo","curveTo","arcTo","lineBy","cubicCurveBy","quadraticCurveBy","curveBy","arcBy"],function(e){i[e]=function(){var i=t(this,!0);i[e].apply(i,arguments)}}),i});T.inject(new function(){function t(t,s,a){function o(t){return t.clone(!1).reduce().reorient().transform(null,!0,!0)}function h(t){for(var e=0,i=t.length;i>e;e++){var n=t[e];_.push.apply(_,n._segments),f.push.apply(f,n._getMonoCurves())}}var u=r[a],l=o(t),c=s&&t!==s&&o(s);c&&/^(subtract|exclude)$/.test(a)^c.isClockwise()!==l.isClockwise()&&c.reverse(),e(l.getIntersections(c,null,!0));var d=[],_=[],f=[],g=1e-6;h(l._children||[l]),c&&h(c._children||[c]),_.sort(function(t,e){var i=t._intersection,n=e._intersection;return!i&&!n||i&&n?0:i?-1:1});for(var v=0,p=_.length;p>v;v++){var y=_[v];if(null==y._winding){d.length=0;var x=y,b=0,C=0;do{var S=y.getCurve().getLength();d.push({segment:y,length:S}),b+=S,y=y.getNext()}while(y&&!y._intersection&&y!==x);for(var P=0;3>P;P++){var S=b*(P+1)/4;for(k=0,m=d.length;m>k;k++){var M=d[k],z=M.length;if(z>=S){(g>=S||g>=z-S)&&(S=z/2);var I=M.segment.getCurve(),A=I.getPointAt(S),O=I.isLinear()&&Math.abs(I.getTangentAt(.5,!0).y)<=g,T=I._path;T._parent instanceof N&&(T=T._parent),C+="subtract"===a&&c&&(T===l&&c._getWinding(A,O)||T===c&&!l._getWinding(A,O))?0:i(A,f,O);break}S-=z}}for(var L=Math.round(C/3),P=d.length-1;P>=0;P--)d[P].segment._winding=L}}var B=new N(w.NO_INSERT);return B.insertAbove(t),B.addChildren(n(_,u),!0),B=B.reduce(),B.setStyle(t._style),B}function e(t){function e(){for(var t=0,e=i.length;e>t;t++)i[t].set(0,0)}for(var i,n,r,s=1e-6,a=1-s,o=t.length-1;o>=0;o--){var h=t[o],u=h._parameter;r&&r._curve===h._curve&&r._parameter>0?u/=r._parameter:(n=h._curve,i&&e(),i=n.isLinear()?[n._segment1._handleOut,n._segment2._handleIn]:null);var l,c;(l=n.divide(u,!0,!0))?(c=l._segment1,n=l.getPrevious(),i&&i.push(c._handleOut,c._handleIn)):c=s>u?n._segment1:u>a?n._segment2:n.getPartLength(0,u)<n.getPartLength(u,1)?n._segment1:n._segment2,c._intersection=h.getIntersection(),h._segment=c,r=h}i&&e()}function i(t,e,n,r){var s=1e-6,a=s,u=1-a,l=t.x,c=t.y,d=0,_=0,f=[],g=Math.abs;if(n){for(var v=-1/0,m=1/0,p=c-s,y=c+s,w=0,x=e.length;x>w;w++){var b=e[w].values;if(A.solveCubic(b,0,l,f,0,1)>0)for(var C=f.length-1;C>=0;C--){var S=A.evaluate(b,f[C],0).y;p>S&&S>v?v=S:S>y&&m>S&&(m=S)}}v=(v+c)/2,m=(m+c)/2,v>-1/0&&(d=i(new h(l,v),e)),1/0>m&&(_=i(new h(l,m),e))}else for(var P=l-s,M=l+s,w=0,x=e.length;x>w;w++){var z,I,k=e[w],b=k.values,O=k.winding;if(O&&(1===O&&c>=b[1]&&c<=b[7]||c>=b[7]&&c<=b[1])&&1===A.solveCubic(b,1,c,f,0,1)){var T=f[0],L=A.evaluate(b,T,0).x,N=A.evaluate(b,T,1).y;T>u&&(w===x-1||k.next!==e[w+1])&&g(A.evaluate(k.next.values,0,0).x-L)<=s||w>0&&k.previous===e[w-1]&&g(I-L)<s&&z>u&&a>T||(o.isZero(N)&&!A.isLinear(b)||a>T&&N*A.evaluate(k.previous.values,1,1).y<0||T>u&&N*A.evaluate(k.next.values,0,1).y<0?r&&L>=P&&M>=L&&(++d,++_):P>=L?d+=O:L>=M&&(_+=O)),z=T,I=L}}return Math.max(g(d),g(_))}function n(t,e,i){for(var n,r,s=[],a=1e-6,o=1-a,h=0,u=t.length;u>h;h++)if(n=r=t[h],!n._visited&&e(n._winding)){var l=new L(w.NO_INSERT),c=n._intersection,d=c&&c._segment,_=!1,f=1;do{var g,v=f>0?n._handleIn:n._handleOut,m=f>0?n._handleOut:n._handleIn;if(_&&(!e(n._winding)||i)&&(c=n._intersection)&&(g=c._segment)&&g!==r){if(i)n._visited=g._visited,n=g,f=1;else{var p=n.getCurve();f>0&&(p=p.getPrevious());var y=p.getTangentAt(1>f?a:o,!0),x=g.getCurve(),b=x.getPrevious(),C=b.getTangentAt(o,!0),S=x.getTangentAt(a,!0),P=y.cross(C),M=y.cross(S);if(0!==P*M){var I=M>P?b:x,k=e(I._segment1._winding)?I:M>P?x:b,A=k._segment1;f=k===b?-1:1,A._visited&&n._path!==A._path||!e(A._winding)?f=1:(n._visited=g._visited,n=g,A._visited&&(f=1))}else f=1}m=f>0?n._handleOut:n._handleIn}l.add(new z(n._point,_&&v,m)),_=!0,n._visited=!0,n=f>0?n.getNext():n.getPrevious()}while(n&&!n._visited&&n!==r&&n!==d&&(n._intersection||e(n._winding)));!n||n!==r&&n!==d?l.lastSegment._handleOut.set(0,0):(l.firstSegment.setHandleIn((n===d?d:n)._handleIn),l.setClosed(!0)),l._segments.length>(l._closed?l.isPolygon()?2:0:1)&&s.push(l)}return s}var r={unite:function(t){return 1===t||0===t},intersect:function(t){return 2===t},subtract:function(t){return 1===t},exclude:function(t){return 1===t}};return{_getWinding:function(t,e,n){return i(t,this._getMonoCurves(),e,n)},unite:function(e){return t(this,e,"unite")},intersect:function(e){return t(this,e,"intersect")},subtract:function(e){return t(this,e,"subtract")},exclude:function(e){return t(this,e,"exclude")},divide:function(t){return new x([this.subtract(t),this.intersect(t)])}}}),L.inject({_getMonoCurves:function(){function t(t){var e=t[1],r=t[7],s={values:t,winding:e===r?0:e>r?-1:1,previous:i,next:null};i&&(i.next=s),n.push(s),i=s}function e(e){if(0!==A.getLength(e)){var i=e[1],n=e[3],r=e[5],s=e[7];if(A.isLinear(e))t(e);else{var a=3*(n-r)-i+s,h=2*(i+r)-4*n,u=n-i,l=1e-6,c=[],d=o.solveQuadratic(a,h,u,c,l,1-l);if(0===d)t(e);else{c.sort();var _=c[0],f=A.subdivide(e,_);t(f[0]),d>1&&(_=(c[1]-_)/(1-_),f=A.subdivide(f[1],_),t(f[0])),t(f[1])}}}}var i,n=this._monoCurves;if(!n){n=this._monoCurves=[];for(var r=this.getCurves(),s=this._segments,a=0,h=r.length;h>a;a++)e(r[a].getValues());if(!this._closed&&s.length>1){var u=s[s.length-1]._point,l=s[0]._point,c=u._x,d=u._y,_=l._x,f=l._y;e([c,d,c,d,_,f,_,f])}if(n.length>0){var g=n[0],v=n[n.length-1];g.previous=v,v.next=g}}return n},getInteriorPoint:function(){var t=this.getBounds(),e=t.getCenter(!0);if(!this.contains(e)){for(var i=this._getMonoCurves(),n=[],r=e.y,s=[],a=0,o=i.length;o>a;a++){var h=i[a].values;if((1===i[a].winding&&r>=h[1]&&r<=h[7]||r>=h[7]&&r<=h[1])&&A.solveCubic(h,1,r,n,0,1)>0)for(var u=n.length-1;u>=0;u--)s.push(A.evaluate(h,n[u],0).x);if(s.length>1)break}e.x=(s[0]+s[1])/2}return e},reorient:function(){return this.setClockwise(!0),this}}),N.inject({_getMonoCurves:function(){for(var t=this._children,e=[],i=0,n=t.length;n>i;i++)e.push.apply(e,t[i]._getMonoCurves());return e},reorient:function(){var t=this.removeChildren().sort(function(t,e){return e.getBounds().getArea()-t.getBounds().getArea()});if(t.length>0){this.addChildren(t);for(var e=t[0].isClockwise(),i=1,n=t.length;n>i;i++){for(var r=t[i].getInteriorPoint(),s=0,a=i-1;a>=0;a--)t[a].contains(r)&&s++;
t[i].setClockwise(0===s%2&&e)}}return this}});var B=e.extend({_class:"PathIterator",initialize:function(t,e,i,n){function r(t,e){var i=A.getValues(t,e,n);o.push(i),s(i,t._index,0,1)}function s(t,e,n,r){if(r-n>l&&!A.isFlatEnough(t,i||.25)){var a=A.subdivide(t),o=(n+r)/2;s(a[0],e,n,o),s(a[1],e,o,r)}else{var c=t[6]-t[0],d=t[7]-t[1],_=Math.sqrt(c*c+d*d);_>1e-6&&(u+=_,h.push({offset:u,value:r,index:e}))}}for(var a,o=[],h=[],u=0,l=1/(e||32),c=t._segments,d=c[0],_=1,f=c.length;f>_;_++)a=c[_],r(d,a),d=a;t._closed&&r(a,c[0]),this.curves=o,this.parts=h,this.length=u,this.index=0},getParameterAt:function(t){for(var e,i=this.index;e=i,!(0==i||this.parts[--i].offset<t););for(var n=this.parts.length;n>e;e++){var r=this.parts[e];if(r.offset>=t){this.index=e;var s=this.parts[e-1],a=s&&s.index==r.index?s.value:0,o=s?s.offset:0;return{value:a+(r.value-a)*(t-o)/(r.offset-o),index:r.index}}}var r=this.parts[this.parts.length-1];return{value:1,index:r.index}},evaluate:function(t,e){var i=this.getParameterAt(t);return A.evaluate(this.curves[i.index],i.value,e)},drawPart:function(t,e,i){e=this.getParameterAt(e),i=this.getParameterAt(i);for(var n=e.index;n<=i.index;n++){var r=A.getPart(this.curves[n],n==e.index?e.value:0,n==i.index?i.value:1);n==e.index&&t.moveTo(r[0],r[1]),t.bezierCurveTo.apply(t,r.slice(2))}}},e.each(["getPoint","getTangent","getNormal","getCurvature"],function(t,e){this[t+"At"]=function(t){return this.evaluate(t,e)}},{})),D=e.extend({initialize:function(t,e){for(var i,n=this.points=[],r=t._segments,s=0,a=r.length;a>s;s++){var o=r[s].point.clone();i&&i.equals(o)||(n.push(o),i=o)}t._closed&&(this.closed=!0,n.unshift(n[n.length-1]),n.push(n[1])),this.error=e},fit:function(){var t=this.points,e=t.length,i=this.segments=e>0?[new z(t[0])]:[];return e>1&&this.fitCubic(0,e-1,t[1].subtract(t[0]).normalize(),t[e-2].subtract(t[e-1]).normalize()),this.closed&&(i.shift(),i.pop()),i},fitCubic:function(e,i,n,r){if(1==i-e){var s=this.points[e],a=this.points[i],o=s.getDistance(a)/3;return this.addCurve([s,s.add(n.normalize(o)),a.add(r.normalize(o)),a]),t}for(var h,u=this.chordLengthParameterize(e,i),l=Math.max(this.error,this.error*this.error),c=0;4>=c;c++){var d=this.generateBezier(e,i,u,n,r),_=this.findMaxError(e,i,d,u);if(_.error<this.error)return this.addCurve(d),t;if(h=_.index,_.error>=l)break;this.reparameterize(e,i,u,d),l=_.error}var f=this.points[h-1].subtract(this.points[h]),g=this.points[h].subtract(this.points[h+1]),v=f.add(g).divide(2).normalize();this.fitCubic(e,h,n,v),this.fitCubic(h,i,v.negate(),r)},addCurve:function(t){var e=this.segments[this.segments.length-1];e.setHandleOut(t[1].subtract(t[0])),this.segments.push(new z(t[3],t[2].subtract(t[3])))},generateBezier:function(t,e,i,n,r){for(var s=1e-12,a=this.points[t],o=this.points[e],h=[[0,0],[0,0]],u=[0,0],l=0,c=e-t+1;c>l;l++){var d=i[l],_=1-d,f=3*d*_,g=_*_*_,v=f*_,m=f*d,p=d*d*d,y=n.normalize(v),w=r.normalize(m),x=this.points[t+l].subtract(a.multiply(g+v)).subtract(o.multiply(m+p));h[0][0]+=y.dot(y),h[0][1]+=y.dot(w),h[1][0]=h[0][1],h[1][1]+=w.dot(w),u[0]+=y.dot(x),u[1]+=w.dot(x)}var b,C,S=h[0][0]*h[1][1]-h[1][0]*h[0][1];if(Math.abs(S)>s){var P=h[0][0]*u[1]-h[1][0]*u[0],M=u[0]*h[1][1]-u[1]*h[0][1];b=M/S,C=P/S}else{var z=h[0][0]+h[0][1],I=h[1][0]+h[1][1];b=C=Math.abs(z)>s?u[0]/z:Math.abs(I)>s?u[1]/I:0}var k=o.getDistance(a);return s*=k,(s>b||s>C)&&(b=C=k/3),[a,a.add(n.normalize(b)),o.add(r.normalize(C)),o]},reparameterize:function(t,e,i,n){for(var r=t;e>=r;r++)i[r-t]=this.findRoot(n,this.points[r],i[r-t])},findRoot:function(t,e,i){for(var n=[],r=[],s=0;2>=s;s++)n[s]=t[s+1].subtract(t[s]).multiply(3);for(var s=0;1>=s;s++)r[s]=n[s+1].subtract(n[s]).multiply(2);var a=this.evaluate(3,t,i),o=this.evaluate(2,n,i),h=this.evaluate(1,r,i),u=a.subtract(e),l=o.dot(o)+u.dot(h);return Math.abs(l)<1e-6?i:i-u.dot(o)/l},evaluate:function(t,e,i){for(var n=e.slice(),r=1;t>=r;r++)for(var s=0;t-r>=s;s++)n[s]=n[s].multiply(1-i).add(n[s+1].multiply(i));return n[0]},chordLengthParameterize:function(t,e){for(var i=[0],n=t+1;e>=n;n++)i[n-t]=i[n-t-1]+this.points[n].getDistance(this.points[n-1]);for(var n=1,r=e-t;r>=n;n++)i[n]/=i[r];return i},findMaxError:function(t,e,i,n){for(var r=Math.floor((e-t+1)/2),s=0,a=t+1;e>a;a++){var o=this.evaluate(3,i,n[a-t]),h=o.subtract(this.points[a]),u=h.x*h.x+h.y*h.y;u>=s&&(s=u,r=a)}return{error:s,index:r}}}),j=w.extend({_class:"TextItem",_boundsSelected:!0,_applyMatrix:!1,_canApplyMatrix:!1,_serializeFields:{content:null},_boundsGetter:"getBounds",initialize:function(i){this._content="",this._lines=[];var n=i&&e.isPlainObject(i)&&i.x===t&&i.y===t;this._initialize(n&&i,!n&&h.read(arguments))},_equals:function(t){return this._content===t._content},_clone:function Ce(t,e){return t.setContent(this._content),Ce.base.call(this,t,e)},getContent:function(){return this._content},setContent:function(t){this._content=""+t,this._lines=this._content.split(/\r\n|\n|\r/gm),this._changed(265)},isEmpty:function(){return!this._content},getCharacterStyle:"#getStyle",setCharacterStyle:"#setStyle",getParagraphStyle:"#getStyle",setParagraphStyle:"#setStyle"}),E=j.extend({_class:"PointText",initialize:function(){j.apply(this,arguments)},clone:function(t){return this._clone(new E(w.NO_INSERT),t)},getPoint:function(){var t=this._matrix.getTranslation();return new u(t.x,t.y,this,"setPoint")},setPoint:function(){var t=h.read(arguments);this.translate(t.subtract(this._matrix.getTranslation()))},_draw:function(t){if(this._content){this._setStyles(t);var e=this._style,i=this._lines,n=e.getLeading(),r=t.shadowColor;t.font=e.getFontStyle(),t.textAlign=e.getJustification();for(var s=0,a=i.length;a>s;s++){t.shadowColor=r;var o=i[s];e.hasFill()&&(t.fillText(o,0,0),t.shadowColor="rgba(0,0,0,0)"),e.hasStroke()&&t.strokeText(o,0,0),t.translate(0,n)}}},_getBounds:function(t,e){var i=this._style,n=this._lines,r=n.length,s=i.getJustification(),a=i.getLeading(),o=this.getView().getTextWidth(i.getFontStyle(),n),h=0;"left"!==s&&(h-=o/("center"===s?2:1));var u=new _(h,r?-.75*a:0,o,r*a);return e?e._transformBounds(u,u):u}}),R=e.extend(new function(){function t(t){var e,n=t.match(/^#(\w{1,2})(\w{1,2})(\w{1,2})$/);if(n){e=[0,0,0];for(var r=0;3>r;r++){var a=n[r+1];e[r]=parseInt(1==a.length?a+a:a,16)/255}}else if(n=t.match(/^rgba?\((.*)\)$/)){e=n[1].split(",");for(var r=0,o=e.length;o>r;r++){var a=+e[r];e[r]=3>r?a/255:a}}else{var h=s[t];if(!h){i||(i=Q.getContext(1,1),i.globalCompositeOperation="copy"),i.fillStyle="rgba(0,0,0,0)",i.fillStyle=t,i.fillRect(0,0,1,1);var u=i.getImageData(0,0,1,1).data;h=s[t]=[u[0]/255,u[1]/255,u[2]/255]}e=h.slice()}return e}var i,n={gray:["gray"],rgb:["red","green","blue"],hsb:["hue","saturation","brightness"],hsl:["hue","saturation","lightness"],gradient:["gradient","origin","destination","highlight"]},r={},s={},o=[[0,3,1],[2,0,1],[1,0,3],[1,2,0],[3,1,0],[0,1,2]],u={"rgb-hsb":function(t,e,i){var n=Math.max(t,e,i),r=Math.min(t,e,i),s=n-r,a=0===s?0:60*(n==t?(e-i)/s+(i>e?6:0):n==e?(i-t)/s+2:(t-e)/s+4);return[a,0===n?0:s/n,n]},"hsb-rgb":function(t,e,i){t=(t/60%6+6)%6;var n=Math.floor(t),r=t-n,n=o[n],s=[i,i*(1-e),i*(1-e*r),i*(1-e*(1-r))];return[s[n[0]],s[n[1]],s[n[2]]]},"rgb-hsl":function(t,e,i){var n=Math.max(t,e,i),r=Math.min(t,e,i),s=n-r,a=0===s,o=a?0:60*(n==t?(e-i)/s+(i>e?6:0):n==e?(i-t)/s+2:(t-e)/s+4),h=(n+r)/2,u=a?0:.5>h?s/(n+r):s/(2-n-r);return[o,u,h]},"hsl-rgb":function(t,e,i){if(t=(t/360%1+1)%1,0===e)return[i,i,i];for(var n=[t+1/3,t,t-1/3],r=.5>i?i*(1+e):i+e-i*e,s=2*i-r,a=[],o=0;3>o;o++){var h=n[o];0>h&&(h+=1),h>1&&(h-=1),a[o]=1>6*h?s+6*(r-s)*h:1>2*h?r:2>3*h?s+6*(r-s)*(2/3-h):s}return a},"rgb-gray":function(t,e,i){return[.2989*t+.587*e+.114*i]},"gray-rgb":function(t){return[t,t,t]},"gray-hsb":function(t){return[0,0,t]},"gray-hsl":function(t){return[0,0,t]},"gradient-rgb":function(){return[]},"rgb-gradient":function(){return[]}};return e.each(n,function(t,i){r[i]=[],e.each(t,function(t,s){var a=e.capitalize(t),o=/^(hue|saturation)$/.test(t),u=r[i][s]="gradient"===t?function(t){var e=this._components[0];return t=F.read(Array.isArray(t)?t:arguments,0,{readNull:!0}),e!==t&&(e&&e._removeOwner(this),t&&t._addOwner(this)),t}:"gradient"===i?function(){return h.read(arguments,0,{readNull:"highlight"===t,clone:!0})}:function(t){return null==t||isNaN(t)?0:t};this["get"+a]=function(){return this._type===i||o&&/^hs[bl]$/.test(this._type)?this._components[s]:this._convert(i)[s]},this["set"+a]=function(t){this._type===i||o&&/^hs[bl]$/.test(this._type)||(this._components=this._convert(i),this._properties=n[i],this._type=i),t=u.call(this,t),null!=t&&(this._components[s]=t,this._changed())}},this)},{_class:"Color",_readIndex:!0,initialize:function l(e){var i,s,a,o,h=Array.prototype.slice,u=arguments,c=0;Array.isArray(e)&&(u=e,e=u[0]);var d=null!=e&&typeof e;if("string"===d&&e in n&&(i=e,e=u[1],Array.isArray(e)?(s=e,a=u[2]):(this.__read&&(c=1),u=h.call(u,1),d=typeof e)),!s){if(o="number"===d?u:"object"===d&&null!=e.length?e:null){i||(i=o.length>=3?"rgb":"gray");var _=n[i].length;a=o[_],this.__read&&(c+=o===arguments?_+(null!=a?1:0):1),o.length>_&&(o=h.call(o,0,_))}else if("string"===d)i="rgb",s=t(e),4===s.length&&(a=s[3],s.length--);else if("object"===d)if(e.constructor===l){if(i=e._type,s=e._components.slice(),a=e._alpha,"gradient"===i)for(var f=1,g=s.length;g>f;f++){var v=s[f];v&&(s[f]=v.clone())}}else if(e.constructor===F)i="gradient",o=u;else{i="hue"in e?"lightness"in e?"hsl":"hsb":"gradient"in e||"stops"in e||"radial"in e?"gradient":"gray"in e?"gray":"rgb";var m=n[i];y=r[i],this._components=s=[];for(var f=0,g=m.length;g>f;f++){var p=e[m[f]];null==p&&0===f&&"gradient"===i&&"stops"in e&&(p={stops:e.stops,radial:e.radial}),p=y[f].call(this,p),null!=p&&(s[f]=p)}a=e.alpha}this.__read&&i&&(c=1)}if(this._type=i||"rgb","gradient"===i&&(this._id=l._id=(l._id||0)+1),!s){this._components=s=[];for(var y=r[this._type],f=0,g=y.length;g>f;f++){var p=y[f].call(this,o&&o[f]);null!=p&&(s[f]=p)}}this._components=s,this._properties=n[this._type],this._alpha=a,this.__read&&(this.__read=c)},_serialize:function(t,i){var n=this.getComponents();return e.serialize(/^(gray|rgb)$/.test(this._type)?n:[this._type].concat(n),t,!0,i)},_changed:function(){this._canvasStyle=null,this._owner&&this._owner._changed(65)},_convert:function(t){var e;return this._type===t?this._components.slice():(e=u[this._type+"-"+t])?e.apply(this,this._components):u["rgb-"+t].apply(this,u[this._type+"-rgb"].apply(this,this._components))},convert:function(t){return new R(t,this._convert(t),this._alpha)},getType:function(){return this._type},setType:function(t){this._components=this._convert(t),this._properties=n[t],this._type=t},getComponents:function(){var t=this._components.slice();return null!=this._alpha&&t.push(this._alpha),t},getAlpha:function(){return null!=this._alpha?this._alpha:1},setAlpha:function(t){this._alpha=null==t?null:Math.min(Math.max(t,0),1),this._changed()},hasAlpha:function(){return null!=this._alpha},equals:function(t){var i=e.isPlainValue(t,!0)?R.read(arguments):t;return i===this||i&&this._class===i._class&&this._type===i._type&&this._alpha===i._alpha&&e.equals(this._components,i._components)||!1},toString:function(){for(var t=this._properties,e=[],i="gradient"===this._type,n=a.instance,r=0,s=t.length;s>r;r++){var o=this._components[r];null!=o&&e.push(t[r]+": "+(i?o:n.number(o)))}return null!=this._alpha&&e.push("alpha: "+n.number(this._alpha)),"{ "+e.join(", ")+" }"},toCSS:function(t){function e(t){return Math.round(255*(0>t?0:t>1?1:t))}var i=this._convert("rgb"),n=t||null==this._alpha?1:this._alpha;return i=[e(i[0]),e(i[1]),e(i[2])],1>n&&i.push(0>n?0:n),t?"#"+((1<<24)+(i[0]<<16)+(i[1]<<8)+i[2]).toString(16).slice(1):(4==i.length?"rgba(":"rgb(")+i.join(",")+")"},toCanvasStyle:function(t){if(this._canvasStyle)return this._canvasStyle;if("gradient"!==this._type)return this._canvasStyle=this.toCSS();var e,i=this._components,n=i[0],r=n._stops,s=i[1],a=i[2];if(n._radial){var o=a.getDistance(s),h=i[3];if(h){var u=h.subtract(s);u.getLength()>o&&(h=s.add(u.normalize(o-.1)))}var l=h||s;e=t.createRadialGradient(l.x,l.y,0,s.x,s.y,o)}else e=t.createLinearGradient(s.x,s.y,a.x,a.y);for(var c=0,d=r.length;d>c;c++){var _=r[c];e.addColorStop(_._rampPoint,_._color.toCanvasStyle())}return this._canvasStyle=e},transform:function(t){if("gradient"===this._type){for(var e=this._components,i=1,n=e.length;n>i;i++){var r=e[i];t._transformPoint(r,r,!0)}this._changed()}},statics:{_types:n,random:function(){var t=Math.random;return new R(t(),t(),t())}}})},new function(){var t={add:function(t,e){return t+e},subtract:function(t,e){return t-e},multiply:function(t,e){return t*e},divide:function(t,e){return t/e}};return e.each(t,function(t,e){this[e]=function(e){e=R.read(arguments);for(var i=this._type,n=this._components,r=e._convert(i),s=0,a=n.length;a>s;s++)r[s]=t(n[s],r[s]);return new R(i,r,null!=this._alpha?t(this._alpha,e.getAlpha()):null)}},{})});e.each(R._types,function(t,i){var n=this[e.capitalize(i)+"Color"]=function(t){var e=null!=t&&typeof t,n="object"===e&&null!=t.length?t:"string"===e?null:arguments;return n?new R(i,n):new R(t)};if(3==i.length){var r=i.toUpperCase();R[r]=this[r+"Color"]=n}},e.exports);var F=e.extend({_class:"Gradient",initialize:function Se(t,e){this._id=Se._id=(Se._id||0)+1,t&&this._set(t)&&(t=e=null),this._stops||this.setStops(t||["white","black"]),null==this._radial&&this.setRadial("string"==typeof e&&"radial"===e||e||!1)},_serialize:function(t,i){return i.add(this,function(){return e.serialize([this._stops,this._radial],t,!0,i)})},_changed:function(){for(var t=0,e=this._owners&&this._owners.length;e>t;t++)this._owners[t]._changed()},_addOwner:function(t){this._owners||(this._owners=[]),this._owners.push(t)},_removeOwner:function(e){var i=this._owners?this._owners.indexOf(e):-1;-1!=i&&(this._owners.splice(i,1),0===this._owners.length&&(this._owners=t))},clone:function(){for(var t=[],e=0,i=this._stops.length;i>e;e++)t[e]=this._stops[e].clone();return new F(t)},getStops:function(){return this._stops},setStops:function(e){if(this.stops)for(var i=0,n=this._stops.length;n>i;i++)this._stops[i]._owner=t;if(e.length<2)throw Error("Gradient stop list needs to contain at least two stops.");this._stops=q.readAll(e,0,{clone:!0});for(var i=0,n=this._stops.length;n>i;i++){var r=this._stops[i];r._owner=this,r._defaultRamp&&r.setRampPoint(i/(n-1))}this._changed()},getRadial:function(){return this._radial},setRadial:function(t){this._radial=t,this._changed()},equals:function(t){if(t===this)return!0;if(t&&this._class===t._class&&this._stops.length===t._stops.length){for(var e=0,i=this._stops.length;i>e;e++)if(!this._stops[e].equals(t._stops[e]))return!1;return!0}return!1}}),q=e.extend({_class:"GradientStop",initialize:function(e,i){if(e){var n,r;i===t&&Array.isArray(e)?(n=e[0],r=e[1]):e.color?(n=e.color,r=e.rampPoint):(n=e,r=i),this.setColor(n),this.setRampPoint(r)}},clone:function(){return new q(this._color.clone(),this._rampPoint)},_serialize:function(t,i){return e.serialize([this._color,this._rampPoint],t,!0,i)},_changed:function(){this._owner&&this._owner._changed(65)},getRampPoint:function(){return this._rampPoint},setRampPoint:function(t){this._defaultRamp=null==t,this._rampPoint=t||0,this._changed()},getColor:function(){return this._color},setColor:function(t){this._color=R.read(arguments),this._color===t&&(this._color=t.clone()),this._color._owner=this,this._changed()},equals:function(t){return t===this||t&&this._class===t._class&&this._color.equals(t._color)&&this._rampPoint==t._rampPoint||!1}}),V=e.extend(new function(){var i={fillColor:t,strokeColor:t,strokeWidth:1,strokeCap:"butt",strokeJoin:"miter",strokeScaling:!0,miterLimit:10,dashOffset:0,dashArray:[],windingRule:"nonzero",shadowColor:t,shadowBlur:0,shadowOffset:new h,selectedColor:t,fontFamily:"sans-serif",fontWeight:"normal",fontSize:12,font:"sans-serif",leading:null,justification:"left"},n={strokeWidth:97,strokeCap:97,strokeJoin:97,strokeScaling:105,miterLimit:97,fontFamily:9,fontWeight:9,fontSize:9,font:9,leading:9,justification:9},r={beans:!0},s={_defaults:i,_textDefaults:new e(i,{fillColor:new R}),beans:!0};return e.each(i,function(i,a){var o=/Color$/.test(a),u="shadowOffset"===a,l=e.capitalize(a),c=n[a],d="set"+l,_="get"+l;s[d]=function(e){var i=this._owner,n=i&&i._children;if(n&&n.length>0&&!(i instanceof N))for(var r=0,s=n.length;s>r;r++)n[r]._style[d](e);else{var h=this._values[a];h!==e&&(o&&(h&&(h._owner=t),e&&e.constructor===R&&(e._owner&&(e=e.clone()),e._owner=i)),this._values[a]=e,i&&i._changed(c||65))}},s[_]=function(i){var n,r=this._owner,s=r&&r._children;if(!s||0===s.length||i||r instanceof N){var n=this._values[a];if(n===t)n=this._defaults[a],n&&n.clone&&(n=n.clone());else{var l=o?R:u?h:null;!l||n&&n.constructor===l||(this._values[a]=n=l.read([n],0,{readNull:!0,clone:!0}),n&&o&&(n._owner=r))}return n}for(var c=0,d=s.length;d>c;c++){var f=s[c]._style[_]();if(0===c)n=f;else if(!e.equals(n,f))return t}return n},r[_]=function(t){return this._style[_](t)},r[d]=function(t){this._style[d](t)}}),w.inject(r),s},{_class:"Style",initialize:function(t,e,i){this._values={},this._owner=e,this._project=e&&e._project||i||paper.project,e instanceof j&&(this._defaults=this._textDefaults),t&&this.set(t)},set:function(t){var e=t instanceof V,i=e?t._values:t;if(i)for(var n in i)if(n in this._defaults){var r=i[n];this[n]=r&&e&&r.clone?r.clone():r}},equals:function(t){return t===this||t&&this._class===t._class&&e.equals(this._values,t._values)||!1},hasFill:function(){return!!this.getFillColor()},hasStroke:function(){return!!this.getStrokeColor()&&this.getStrokeWidth()>0},hasShadow:function(){return!!this.getShadowColor()&&this.getShadowBlur()>0},getView:function(){return this._project.getView()},getFontStyle:function(){var t=this.getFontSize();return this.getFontWeight()+" "+t+(/[a-z]/i.test(t+"")?" ":"px ")+this.getFontFamily()},getFont:"#getFontFamily",setFont:"#setFontFamily",getLeading:function Pe(){var t=Pe.base.call(this),e=this.getFontSize();return/pt|em|%|px/.test(e)&&(e=this.getView().getPixelSize(e)),null!=t?t:1.2*e}}),Z=new function(){function t(t,e,i,n){for(var r=["","webkit","moz","Moz","ms","o"],s=e[0].toUpperCase()+e.substring(1),a=0;6>a;a++){var o=r[a],h=o?o+s:e;if(h in t){if(!i)return t[h];t[h]=n;break}}}return{getStyles:function(t){var e=t&&9!==t.nodeType?t.ownerDocument:t,i=e&&e.defaultView;return i&&i.getComputedStyle(t,"")},getBounds:function(t,e){var i,n=t.ownerDocument,r=n.body,s=n.documentElement;try{i=t.getBoundingClientRect()}catch(a){i={left:0,top:0,width:0,height:0}}var o=i.left-(s.clientLeft||r.clientLeft||0),h=i.top-(s.clientTop||r.clientTop||0);if(!e){var u=n.defaultView;o+=u.pageXOffset||s.scrollLeft||r.scrollLeft,h+=u.pageYOffset||s.scrollTop||r.scrollTop}return new _(o,h,i.width,i.height)},getViewportBounds:function(t){var e=t.ownerDocument,i=e.defaultView,n=e.documentElement;return new _(0,0,i.innerWidth||n.clientWidth,i.innerHeight||n.clientHeight)},getOffset:function(t,e){return Z.getBounds(t,e).getPoint()},getSize:function(t){return Z.getBounds(t,!0).getSize()},isInvisible:function(t){return Z.getSize(t).equals(new c(0,0))},isInView:function(t){return!Z.isInvisible(t)&&Z.getViewportBounds(t).intersects(Z.getBounds(t,!0))},getPrefixed:function(e,i){return t(e,i)},setPrefixed:function(e,i,n){if("object"==typeof i)for(var r in i)t(e,r,!0,i[r]);else t(e,i,!0,n)}}},H={add:function(t,e){for(var i in e)for(var n=e[i],r=i.split(/[\s,]+/g),s=0,a=r.length;a>s;s++)t.addEventListener(r[s],n,!1)},remove:function(t,e){for(var i in e)for(var n=e[i],r=i.split(/[\s,]+/g),s=0,a=r.length;a>s;s++)t.removeEventListener(r[s],n,!1)},getPoint:function(t){var e=t.targetTouches?t.targetTouches.length?t.targetTouches[0]:t.changedTouches[0]:t;return new h(e.pageX||e.clientX+document.documentElement.scrollLeft,e.pageY||e.clientY+document.documentElement.scrollTop)},getTarget:function(t){return t.target||t.srcElement},getRelatedTarget:function(t){return t.relatedTarget||t.toElement},getOffset:function(t,e){return H.getPoint(t).subtract(Z.getOffset(e||H.getTarget(t)))},stop:function(t){t.stopPropagation(),t.preventDefault()}};H.requestAnimationFrame=new function(){function t(){for(var e=s.length-1;e>=0;e--){var o=s[e],h=o[0],u=o[1];(!u||("true"==r.getAttribute(u,"keepalive")||a)&&Z.isInView(u))&&(s.splice(e,1),h())}i&&(s.length?i(t):n=!1)}var e,i=Z.getPrefixed(window,"requestAnimationFrame"),n=!1,s=[],a=!0;return H.add(window,{focus:function(){a=!0},blur:function(){a=!1}}),function(r,a){s.push([r,a]),i?n||(i(t),n=!0):e||(e=setInterval(t,1e3/60))}};var W=e.extend(n,{_class:"View",initialize:function Me(t,e){function i(t){return e[t]||parseInt(e.getAttribute(t),10)}function n(){var t=Z.getSize(e);return t.isNaN()||t.isZero()?new c(i("width"),i("height")):t}this._project=t,this._scope=t._scope,this._element=e;var s;this._pixelRatio||(this._pixelRatio=window.devicePixelRatio||1),this._id=e.getAttribute("id"),null==this._id&&e.setAttribute("id",this._id="view-"+Me._id++),H.add(e,this._viewEvents);var a="none";if(Z.setPrefixed(e.style,{userSelect:a,touchAction:a,touchCallout:a,contentZooming:a,userDrag:a,tapHighlightColor:"rgba(0,0,0,0)"}),r.hasAttribute(e,"resize")){var o=this;H.add(window,this._windowEvents={resize:function(){o.setViewSize(n())}})}if(this._setViewSize(s=n()),r.hasAttribute(e,"stats")&&"undefined"!=typeof Stats){this._stats=new Stats;var h=this._stats.domElement,u=h.style,l=Z.getOffset(e);u.position="absolute",u.left=l.x+"px",u.top=l.y+"px",document.body.appendChild(h)}Me._views.push(this),Me._viewsById[this._id]=this,this._viewSize=s,(this._matrix=new g)._owner=this,this._zoom=1,Me._focused||(Me._focused=this),this._frameItems={},this._frameItemCount=0},remove:function(){return this._project?(W._focused===this&&(W._focused=null),W._views.splice(W._views.indexOf(this),1),delete W._viewsById[this._id],this._project._view===this&&(this._project._view=null),H.remove(this._element,this._viewEvents),H.remove(window,this._windowEvents),this._element=this._project=null,this.off("frame"),this._animate=!1,this._frameItems={},!0):!1},_events:{onFrame:{install:function(){this.play()},uninstall:function(){this.pause()}},onResize:{}},_animate:!1,_time:0,_count:0,_requestFrame:function(){var t=this;H.requestAnimationFrame(function(){t._requested=!1,t._animate&&(t._requestFrame(),t._handleFrame())},this._element),this._requested=!0},_handleFrame:function(){paper=this._scope;var t=Date.now()/1e3,i=this._before?t-this._before:0;this._before=t,this._handlingFrame=!0,this.emit("frame",new e({delta:i,time:this._time+=i,count:this._count++})),this._stats&&this._stats.update(),this._handlingFrame=!1,this.update()},_animateItem:function(t,e){var i=this._frameItems;e?(i[t._id]={item:t,time:0,count:0},1===++this._frameItemCount&&this.on("frame",this._handleFrameItems)):(delete i[t._id],0===--this._frameItemCount&&this.off("frame",this._handleFrameItems))},_handleFrameItems:function(t){for(var i in this._frameItems){var n=this._frameItems[i];n.item.emit("frame",new e(t,{time:n.time+=t.delta,count:n.count++}))}},_update:function(){this._project._needsUpdate=!0,this._handlingFrame||(this._animate?this._handleFrame():this.update())},_changed:function(t){1&t&&(this._project._needsUpdate=!0)},_transform:function(t){this._matrix.concatenate(t),this._bounds=null,this._update()},getElement:function(){return this._element},getPixelRatio:function(){return this._pixelRatio},getResolution:function(){return 72*this._pixelRatio},getViewSize:function(){var t=this._viewSize;return new d(t.width,t.height,this,"setViewSize")},setViewSize:function(){var t=c.read(arguments),e=t.subtract(this._viewSize);e.isZero()||(this._viewSize.set(t.width,t.height),this._setViewSize(t),this._bounds=null,this.emit("resize",{size:t,delta:e}),this._update())},_setViewSize:function(t){var e=this._element;e.width=t.width,e.height=t.height},getBounds:function(){return this._bounds||(this._bounds=this._matrix.inverted()._transformBounds(new _(new h,this._viewSize))),this._bounds},getSize:function(){return this.getBounds().getSize()},getCenter:function(){return this.getBounds().getCenter()},setCenter:function(){var t=h.read(arguments);this.scrollBy(t.subtract(this.getCenter()))},getZoom:function(){return this._zoom},setZoom:function(t){this._transform((new g).scale(t/this._zoom,this.getCenter())),this._zoom=t},isVisible:function(){return Z.isInView(this._element)},scrollBy:function(){this._transform((new g).translate(h.read(arguments).negate()))},play:function(){this._animate=!0,this._requested||this._requestFrame()},pause:function(){this._animate=!1},draw:function(){this.update()},projectToView:function(){return this._matrix._transformPoint(h.read(arguments))},viewToProject:function(){return this._matrix._inverseTransform(h.read(arguments))}},{statics:{_views:[],_viewsById:{},_id:0,create:function(t,e){return"string"==typeof e&&(e=document.getElementById(e)),new G(t,e)}}},new function(){function t(t){var e=H.getTarget(t);return e.getAttribute&&W._viewsById[e.getAttribute("id")]}function e(t,e){return t.viewToProject(H.getOffset(e,t._element))}function i(){if(!W._focused||!W._focused.isVisible())for(var t=0,e=W._views.length;e>t;t++){var i=W._views[t];if(i&&i.isVisible()){W._focused=a=i;break}}}function n(t,e,i){t._handleEvent("mousemove",e,i);var n=t._scope.tool;return n&&n._handleEvent(l&&n.responds("mousedrag")?"mousedrag":"mousemove",e,i),t.update(),n}var r,s,a,o,h,u,l=!1,c=window.navigator;c.pointerEnabled||c.msPointerEnabled?(o="pointerdown MSPointerDown",h="pointermove MSPointerMove",u="pointerup pointercancel MSPointerUp MSPointerCancel"):(o="touchstart",h="touchmove",u="touchend touchcancel","ontouchstart"in window&&c.userAgent.match(/mobile|tablet|ip(ad|hone|od)|android|silk/i)||(o+=" mousedown",h+=" mousemove",u+=" mouseup"));var d={"selectstart dragstart":function(t){l&&t.preventDefault()}},_={mouseout:function(t){var i=W._focused,r=H.getRelatedTarget(t);!i||r&&"HTML"!==r.nodeName||n(i,e(i,t),t)},scroll:i};return d[o]=function(i){var n=W._focused=t(i),s=e(n,i);l=!0,n._handleEvent("mousedown",s,i),(r=n._scope.tool)&&r._handleEvent("mousedown",s,i),n.update()},_[h]=function(o){var h=W._focused;if(!l){var u=t(o);u?(h!==u&&n(h,e(h,o),o),s=h,h=W._focused=a=u):a&&a===h&&(h=W._focused=s,i())}if(h){var c=e(h,o);(l||h.getBounds().contains(c))&&(r=n(h,c,o))}},_[u]=function(t){var i=W._focused;if(i&&l){var n=e(i,t);l=!1,i._handleEvent("mouseup",n,t),r&&r._handleEvent("mouseup",n,t),i.update()}},H.add(document,_),H.add(window,{load:i}),{_viewEvents:d,_handleEvent:function(){},statics:{updateFocus:i}}}),G=W.extend({_class:"CanvasView",initialize:function(t,e){if(!(e instanceof HTMLCanvasElement)){var i=c.read(arguments,1);if(i.isZero())throw Error("Cannot create CanvasView with the provided argument: "+[].slice.call(arguments,1));e=Q.getCanvas(i)}if(this._context=e.getContext("2d"),this._eventCounters={},this._pixelRatio=1,!/^off|false$/.test(r.getAttribute(e,"hidpi"))){var n=window.devicePixelRatio||1,s=Z.getPrefixed(this._context,"backingStorePixelRatio")||1;this._pixelRatio=n/s}W.call(this,t,e)},_setViewSize:function(t){var e=this._element,i=this._pixelRatio,n=t.width,s=t.height;if(e.width=n*i,e.height=s*i,1!==i){if(!r.hasAttribute(e,"resize")){var a=e.style;a.width=n+"px",a.height=s+"px"}this._context.scale(i,i)}},getPixelSize:function(t){var e=this._context,i=e.font;return e.font=t+" serif",t=parseFloat(e.font),e.font=i,t},getTextWidth:function(t,e){var i=this._context,n=i.font,r=0;i.font=t;for(var s=0,a=e.length;a>s;s++)r=Math.max(r,i.measureText(e[s]).width);return i.font=n,r},update:function(){var t=this._project;if(!t||!t._needsUpdate)return!1;var e=this._context,i=this._viewSize;return e.clearRect(0,0,i.width+1,i.height+1),t.draw(e,this._matrix,this._pixelRatio),t._needsUpdate=!1,!0}},new function(){function e(e,i,n,r,s,a){function o(e){return e.responds(i)&&(h||(h=new Y(i,n,r,s,a?r.subtract(a):null)),e.emit(i,h)&&h.isStopped)?(n.preventDefault(),!0):t}for(var h,u=s;u;){if(o(u))return!0;u=u.getParent()}return o(e)?!0:!1}var i,n,r,s,a,o,h,u,l;return{_handleEvent:function(t,c,d){if(this._eventCounters[t]){var _=this._project,f=_.hitTest(c,{tolerance:0,fill:!0,stroke:!0}),g=f&&f.item,v=!1;switch(t){case"mousedown":for(v=e(this,t,d,c,g),u=a==g&&Date.now()-l<300,s=a=g,i=n=r=c,h=!v&&g;h&&!h.responds("mousedrag");)h=h._parent;break;case"mouseup":v=e(this,t,d,c,g,i),h&&(n&&!n.equals(c)&&e(this,"mousedrag",d,c,h,n),g!==h&&(r=c,e(this,"mousemove",d,c,g,r))),!v&&g&&g===s&&(l=Date.now(),e(this,u&&s.responds("doubleclick")?"doubleclick":"click",d,i,g),u=!1),s=h=null;break;case"mousemove":h&&(v=e(this,"mousedrag",d,c,h,n)),v||(g!==o&&(r=c),v=e(this,t,d,c,g,r)),n=r=c,g!==o&&(e(this,"mouseleave",d,c,o),o=g,e(this,"mouseenter",d,c,g))}return v}}}}),U=e.extend({_class:"Event",initialize:function(t){this.event=t},isPrevented:!1,isStopped:!1,preventDefault:function(){this.isPrevented=!0,this.event.preventDefault()},stopPropagation:function(){this.isStopped=!0,this.event.stopPropagation()},stop:function(){this.stopPropagation(),this.preventDefault()},getModifiers:function(){return X.modifiers}}),J=U.extend({_class:"KeyEvent",initialize:function(t,e,i,n){U.call(this,n),this.type=t?"keydown":"keyup",this.key=e,this.character=i},toString:function(){return"{ type: '"+this.type+"', key: '"+this.key+"', character: '"+this.character+"', modifiers: "+this.getModifiers()+" }"}}),X=new function(){function t(t,i,r,h){var u,l=r?String.fromCharCode(r):"",c=n[i],d=c||l.toLowerCase(),_=t?"keydown":"keyup",f=W._focused,g=f&&f.isVisible()&&f._scope,v=g&&g.tool;o[d]=t,c&&(u=e.camelize(c))in s&&(s[u]=t),t?a[i]=r:delete a[i],v&&v.responds(_)&&(paper=g,v.emit(_,new J(t,d,l,h)),f&&f.update())}var i,n={8:"backspace",9:"tab",13:"enter",16:"shift",17:"control",18:"option",19:"pause",20:"caps-lock",27:"escape",32:"space",35:"end",36:"home",37:"left",38:"up",39:"right",40:"down",46:"delete",91:"command",93:"command",224:"command"},r={9:!0,13:!0,32:!0},s=new e({shift:!1,control:!1,option:!1,command:!1,capsLock:!1,space:!1}),a={},o={};return H.add(document,{keydown:function(e){var a=e.which||e.keyCode;a in n||s.command?t(!0,a,a in r||s.command?a:0,e):i=a},keypress:function(e){null!=i&&(t(!0,i,e.which||e.keyCode,e),i=null)},keyup:function(e){var i=e.which||e.keyCode;i in a&&t(!1,i,a[i],e)}}),H.add(window,{blur:function(e){for(var i in a)t(!1,i,a[i],e)}}),{modifiers:s,isDown:function(t){return!!o[t]}}},Y=U.extend({_class:"MouseEvent",initialize:function(t,e,i,n,r){U.call(this,e),this.type=t,this.point=i,this.target=n,this.delta=r},toString:function(){return"{ type: '"+this.type+"', point: "+this.point+", target: "+this.target+(this.delta?", delta: "+this.delta:"")+", modifiers: "+this.getModifiers()+" }"}}),$=U.extend({_class:"ToolEvent",_item:null,initialize:function(t,e,i){this.tool=t,this.type=e,this.event=i},_choosePoint:function(t,e){return t?t:e?e.clone():null},getPoint:function(){return this._choosePoint(this._point,this.tool._point)},setPoint:function(t){this._point=t},getLastPoint:function(){return this._choosePoint(this._lastPoint,this.tool._lastPoint)},setLastPoint:function(t){this._lastPoint=t},getDownPoint:function(){return this._choosePoint(this._downPoint,this.tool._downPoint)},setDownPoint:function(t){this._downPoint=t},getMiddlePoint:function(){return!this._middlePoint&&this.tool._lastPoint?this.tool._point.add(this.tool._lastPoint).divide(2):this._middlePoint},setMiddlePoint:function(t){this._middlePoint=t},getDelta:function(){return!this._delta&&this.tool._lastPoint?this.tool._point.subtract(this.tool._lastPoint):this._delta},setDelta:function(t){this._delta=t},getCount:function(){return/^mouse(down|up)$/.test(this.type)?this.tool._downCount:this.tool._count},setCount:function(t){this.tool[/^mouse(down|up)$/.test(this.type)?"downCount":"count"]=t},getItem:function(){if(!this._item){var t=this.tool._scope.project.hitTest(this.getPoint());if(t){for(var e=t.item,i=e._parent;/^(Group|CompoundPath)$/.test(i._class);)e=i,i=i._parent;this._item=e}}return this._item},setItem:function(t){this._item=t},toString:function(){return"{ type: "+this.type+", point: "+this.getPoint()+", count: "+this.getCount()+", modifiers: "+this.getModifiers()+" }"
}});s.extend({_class:"Tool",_list:"tools",_reference:"tool",_events:["onActivate","onDeactivate","onEditOptions","onMouseDown","onMouseUp","onMouseDrag","onMouseMove","onKeyDown","onKeyUp"],initialize:function(t){s.call(this),this._firstMove=!0,this._count=0,this._downCount=0,this._set(t)},getMinDistance:function(){return this._minDistance},setMinDistance:function(t){this._minDistance=t,null!=this._minDistance&&null!=this._maxDistance&&this._minDistance>this._maxDistance&&(this._maxDistance=this._minDistance)},getMaxDistance:function(){return this._maxDistance},setMaxDistance:function(t){this._maxDistance=t,null!=this._minDistance&&null!=this._maxDistance&&this._maxDistance<this._minDistance&&(this._minDistance=t)},getFixedDistance:function(){return this._minDistance==this._maxDistance?this._minDistance:null},setFixedDistance:function(t){this._minDistance=t,this._maxDistance=t},_updateEvent:function(t,e,i,n,r,s,a){if(!r){if(null!=i||null!=n){var o=null!=i?i:0,h=e.subtract(this._point),u=h.getLength();if(o>u)return!1;var l=null!=n?n:0;if(0!=l)if(u>l)e=this._point.add(h.normalize(l));else if(a)return!1}if(s&&e.equals(this._point))return!1}switch(this._lastPoint=r&&"mousemove"==t?e:this._point,this._point=e,t){case"mousedown":this._lastPoint=this._downPoint,this._downPoint=this._point,this._downCount++;break;case"mouseup":this._lastPoint=this._downPoint}return this._count=r?0:this._count+1,!0},_fireEvent:function(t,e){var i=paper.project._removeSets;if(i){"mouseup"===t&&(i.mousedrag=null);var n=i[t];if(n){for(var r in n){var s=n[r];for(var a in i){var o=i[a];o&&o!=n&&delete o[s._id]}s.remove()}i[t]=null}}return this.responds(t)&&this.emit(t,new $(this,t,e))},_handleEvent:function(t,e,i){paper=this._scope;var n=!1;switch(t){case"mousedown":this._updateEvent(t,e,null,null,!0,!1,!1),n=this._fireEvent(t,i);break;case"mousedrag":for(var r=!1,s=!1;this._updateEvent(t,e,this.minDistance,this.maxDistance,!1,r,s);)n=this._fireEvent(t,i)||n,r=!0,s=!0;break;case"mouseup":!e.equals(this._point)&&this._updateEvent("mousedrag",e,this.minDistance,this.maxDistance,!1,!1,!1)&&(n=this._fireEvent("mousedrag",i)),this._updateEvent(t,e,null,this.maxDistance,!1,!1,!1),n=this._fireEvent(t,i)||n,this._updateEvent(t,e,null,null,!0,!1,!1),this._firstMove=!0;break;case"mousemove":for(;this._updateEvent(t,e,this.minDistance,this.maxDistance,this._firstMove,!0,!1);)n=this._fireEvent(t,i)||n,this._firstMove=!1}return n&&i.preventDefault(),n}});var K={request:function(t,e,i){var n=new(window.ActiveXObject||XMLHttpRequest)("Microsoft.XMLHTTP");return n.open(t.toUpperCase(),e,!0),"overrideMimeType"in n&&n.overrideMimeType("text/plain"),n.onreadystatechange=function(){if(4===n.readyState){var t=n.status;if(0!==t&&200!==t)throw Error("Could not load "+e+" (Error "+t+")");i.call(n,n.responseText)}},n.send(null)}},Q={canvases:[],getCanvas:function(t,e){var i,n=!0;"object"==typeof t&&(e=t.height,t=t.width),i=this.canvases.length?this.canvases.pop():document.createElement("canvas");var r=i.getContext("2d");return i.width===t&&i.height===e?n&&r.clearRect(0,0,t+1,e+1):(i.width=t,i.height=e),r.save(),i},getContext:function(t,e){return this.getCanvas(t,e).getContext("2d")},release:function(t){var e=t.canvas?t.canvas:t;e.getContext("2d").restore(),this.canvases.push(e)}},te=new function(){function t(t,e,i){return.2989*t+.587*e+.114*i}function i(e,i,n,r){var s=r-t(e,i,n);_=e+s,f=i+s,g=n+s;var r=t(_,f,g),a=v(_,f,g),o=m(_,f,g);if(0>a){var h=r-a;_=r+(_-r)*r/h,f=r+(f-r)*r/h,g=r+(g-r)*r/h}if(o>255){var u=255-r,l=o-r;_=r+(_-r)*u/l,f=r+(f-r)*u/l,g=r+(g-r)*u/l}}function n(t,e,i){return m(t,e,i)-v(t,e,i)}function r(t,e,i,n){var r,s=[t,e,i],a=m(t,e,i),o=v(t,e,i);o=o===t?0:o===e?1:2,a=a===t?0:a===e?1:2,r=0===v(o,a)?1===m(o,a)?2:1:0,s[a]>s[o]?(s[r]=(s[r]-s[o])*n/(s[a]-s[o]),s[a]=n):s[r]=s[a]=0,s[o]=0,_=s[0],f=s[1],g=s[2]}var s,a,o,h,u,l,c,d,_,f,g,v=Math.min,m=Math.max,p=Math.abs,y={multiply:function(){_=u*s/255,f=l*a/255,g=c*o/255},screen:function(){_=u+s-u*s/255,f=l+a-l*a/255,g=c+o-c*o/255},overlay:function(){_=128>u?2*u*s/255:255-2*(255-u)*(255-s)/255,f=128>l?2*l*a/255:255-2*(255-l)*(255-a)/255,g=128>c?2*c*o/255:255-2*(255-c)*(255-o)/255},"soft-light":function(){var t=s*u/255;_=t+u*(255-(255-u)*(255-s)/255-t)/255,t=a*l/255,f=t+l*(255-(255-l)*(255-a)/255-t)/255,t=o*c/255,g=t+c*(255-(255-c)*(255-o)/255-t)/255},"hard-light":function(){_=128>s?2*s*u/255:255-2*(255-s)*(255-u)/255,f=128>a?2*a*l/255:255-2*(255-a)*(255-l)/255,g=128>o?2*o*c/255:255-2*(255-o)*(255-c)/255},"color-dodge":function(){_=0===u?0:255===s?255:v(255,255*u/(255-s)),f=0===l?0:255===a?255:v(255,255*l/(255-a)),g=0===c?0:255===o?255:v(255,255*c/(255-o))},"color-burn":function(){_=255===u?255:0===s?0:m(0,255-255*(255-u)/s),f=255===l?255:0===a?0:m(0,255-255*(255-l)/a),g=255===c?255:0===o?0:m(0,255-255*(255-c)/o)},darken:function(){_=s>u?u:s,f=a>l?l:a,g=o>c?c:o},lighten:function(){_=u>s?u:s,f=l>a?l:a,g=c>o?c:o},difference:function(){_=u-s,0>_&&(_=-_),f=l-a,0>f&&(f=-f),g=c-o,0>g&&(g=-g)},exclusion:function(){_=u+s*(255-u-u)/255,f=l+a*(255-l-l)/255,g=c+o*(255-c-c)/255},hue:function(){r(s,a,o,n(u,l,c)),i(_,f,g,t(u,l,c))},saturation:function(){r(u,l,c,n(s,a,o)),i(_,f,g,t(u,l,c))},luminosity:function(){i(u,l,c,t(s,a,o))},color:function(){i(s,a,o,t(u,l,c))},add:function(){_=v(u+s,255),f=v(l+a,255),g=v(c+o,255)},subtract:function(){_=m(u-s,0),f=m(l-a,0),g=m(c-o,0)},average:function(){_=(u+s)/2,f=(l+a)/2,g=(c+o)/2},negation:function(){_=255-p(255-s-u),f=255-p(255-a-l),g=255-p(255-o-c)}},w=this.nativeModes=e.each(["source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","lighter","darker","copy","xor"],function(t){this[t]=!0},{}),x=Q.getContext(1,1);e.each(y,function(t,e){var i="darken"===e,n=!1;x.save();try{x.fillStyle=i?"#300":"#a00",x.fillRect(0,0,1,1),x.globalCompositeOperation=e,x.globalCompositeOperation===e&&(x.fillStyle=i?"#a00":"#300",x.fillRect(0,0,1,1),n=x.getImageData(0,0,1,1).data[0]!==i?170:51)}catch(r){}x.restore(),w[e]=n}),Q.release(x),this.process=function(t,e,i,n,r){var v=e.canvas,m="normal"===t;if(m||w[t])i.save(),i.setTransform(1,0,0,1,0,0),i.globalAlpha=n,m||(i.globalCompositeOperation=t),i.drawImage(v,r.x,r.y),i.restore();else{var p=y[t];if(!p)return;for(var x=i.getImageData(r.x,r.y,v.width,v.height),b=x.data,C=e.getImageData(0,0,v.width,v.height).data,S=0,P=b.length;P>S;S+=4){s=C[S],u=b[S],a=C[S+1],l=b[S+1],o=C[S+2],c=b[S+2],h=C[S+3],d=b[S+3],p();var M=h*n/255,z=1-M;b[S]=M*_+z*u,b[S+1]=M*f+z*l,b[S+2]=M*g+z*c,b[S+3]=h*n+z*d}i.putImageData(x,r.x,r.y)}}},ee=e.each({fillColor:["fill","color"],strokeColor:["stroke","color"],strokeWidth:["stroke-width","number"],strokeCap:["stroke-linecap","string"],strokeJoin:["stroke-linejoin","string"],strokeScaling:["vector-effect","lookup",{"true":"none","false":"non-scaling-stroke"},function(t,e){return!e&&(t instanceof T||t instanceof C||t instanceof j)}],miterLimit:["stroke-miterlimit","number"],dashArray:["stroke-dasharray","array"],dashOffset:["stroke-dashoffset","number"],fontFamily:["font-family","string"],fontWeight:["font-weight","string"],fontSize:["font-size","number"],justification:["text-anchor","lookup",{left:"start",center:"middle",right:"end"}],opacity:["opacity","number"],blendMode:["mix-blend-mode","string"]},function(t,i){var n=e.capitalize(i),r=t[2];this[i]={type:t[1],property:i,attribute:t[0],toSVG:r,fromSVG:r&&e.each(r,function(t,e){this[t]=e},{}),exportFilter:t[3],get:"get"+n,set:"set"+n}},{}),ie={href:"http://www.w3.org/1999/xlink",xlink:"http://www.w3.org/2000/xmlns"};return new function(){function t(t,e){for(var i in e){var n=e[i],r=ie[i];"number"==typeof n&&(n=S.number(n)),r?t.setAttributeNS(r,i,n):t.setAttribute(i,n)}return t}function n(e,i){return t(document.createElementNS("http://www.w3.org/2000/svg",e),i)}function r(t,i,n){var r=new e,s=t.getTranslation();if(i){t=t.shiftless();var a=t._inverseTransform(s);r[n?"cx":"x"]=a.x,r[n?"cy":"y"]=a.y,s=null}if(!t.isIdentity()){var h=t.decompose();if(h&&!h.shearing){var u=[],l=h.rotation,c=h.scaling;s&&!s.isZero()&&u.push("translate("+S.point(s)+")"),o.isZero(c.x-1)&&o.isZero(c.y-1)||u.push("scale("+S.point(c)+")"),l&&u.push("rotate("+S.number(l)+")"),r.transform=u.join(" ")}else r.transform="matrix("+t.getValues().join(",")+")"}return r}function s(e,i){for(var s=r(e._matrix),a=e._children,o=n("g",s),h=0,u=a.length;u>h;h++){var l=a[h],c=b(l,i);if(c)if(l.isClipMask()){var d=n("clipPath");d.appendChild(c),y(l,d,"clip"),t(o,{"clip-path":"url(#"+d.id+")"})}else o.appendChild(c)}return o}function h(t){var e=r(t._matrix,!0),i=t.getSize();return e.x-=i.width/2,e.y-=i.height/2,e.width=i.width,e.height=i.height,e.href=t.toDataURL(),n("image",e)}function u(t,e){if(e.matchShapes){var s=t.toShape(!1);if(s)return c(s,e)}var a,o=t._segments,h=r(t._matrix);if(0===o.length)return null;if(t.isPolygon())if(o.length>=3){a=t._closed?"polygon":"polyline";var u=[];for(i=0,l=o.length;l>i;i++)u.push(S.point(o[i]._point));h.points=u.join(" ")}else{a="line";var d=o[0]._point,_=o[o.length-1]._point;h.set({x1:d.x,y1:d.y,x2:_.x,y2:_.y})}else a="path",h.d=t.getPathData(null,e.precision);return n(a,h)}function c(t){var e=t._type,i=t._radius,s=r(t._matrix,!0,"rectangle"!==e);if("rectangle"===e){e="rect";var a=t._size,o=a.width,h=a.height;s.x-=o/2,s.y-=h/2,s.width=o,s.height=h,i.isZero()&&(i=null)}return i&&("circle"===e?s.r=i:(s.rx=i.width,s.ry=i.height)),n(e,s)}function d(t,e){var i=r(t._matrix),s=t.getPathData(null,e.precision);return s&&(i.d=s),n("path",i)}function _(t,e){var i=r(t._matrix,!0),s=t.getSymbol(),a=m(s,"symbol"),o=s.getDefinition(),h=o.getBounds();return a||(a=n("symbol",{viewBox:S.rectangle(h)}),a.appendChild(b(o,e)),y(s,a,"symbol")),i.href="#"+a.id,i.x+=h.x,i.y+=h.y,i.width=S.number(h.width),i.height=S.number(h.height),i.overflow="visible",n("use",i)}function f(t){var e=m(t,"color");if(!e){var i,r=t.getGradient(),s=r._radial,a=t.getOrigin().transform(),o=t.getDestination().transform();if(s){i={cx:a.x,cy:a.y,r:a.getDistance(o)};var h=t.getHighlight();h&&(h=h.transform(),i.fx=h.x,i.fy=h.y)}else i={x1:a.x,y1:a.y,x2:o.x,y2:o.y};i.gradientUnits="userSpaceOnUse",e=n((s?"radial":"linear")+"Gradient",i);for(var u=r._stops,l=0,c=u.length;c>l;l++){var d=u[l],_=d._color,f=_.getAlpha();i={offset:d._rampPoint,"stop-color":_.toCSS(!0)},1>f&&(i["stop-opacity"]=f),e.appendChild(n("stop",i))}y(t,e,"color")}return"url(#"+e.id+")"}function g(t){var e=n("text",r(t._matrix,!0));return e.textContent=t._content,e}function v(i,n,r){var s={},a=!r&&i.getParent();return null!=i._name&&(s.id=i._name),e.each(ee,function(t){var n=t.get,r=t.type,o=i[n]();if(t.exportFilter?t.exportFilter(i,o):!a||!e.equals(a[n](),o)){if("color"===r&&null!=o){var h=o.getAlpha();1>h&&(s[t.attribute+"-opacity"]=h)}s[t.attribute]=null==o?"none":"number"===r?S.number(o):"color"===r?o.gradient?f(o,i):o.toCSS(!0):"array"===r?o.join(","):"lookup"===r?t.toSVG[o]:o}}),1===s.opacity&&delete s.opacity,i._visible||(s.visibility="hidden"),t(n,s)}function m(t,e){return P||(P={ids:{},svgs:{}}),t&&P.svgs[e+"-"+t._id]}function y(t,e,i){P||m();var n=P.ids[i]=(P.ids[i]||0)+1;e.id=i+"-"+n,P.svgs[i+"-"+t._id]=e}function x(t,e){var i=t,r=null;if(P){i="svg"===t.nodeName.toLowerCase()&&t;for(var s in P.svgs)r||(i||(i=n("svg"),i.appendChild(t)),r=i.insertBefore(n("defs"),i.firstChild)),r.appendChild(P.svgs[s]);P=null}return e.asString?(new XMLSerializer).serializeToString(i):i}function b(t,e,i){var n=M[t._class],r=n&&n(t,e);if(r){var s=e.onExport;s&&(r=s(t,r,e)||r);var a=JSON.stringify(t._data);a&&"{}"!==a&&"null"!==a&&r.setAttribute("data-paper-data",a)}return r&&v(t,r,i)}function C(t){return t||(t={}),S=new a(t.precision),t}var S,P,M={Group:s,Layer:s,Raster:h,Path:u,Shape:c,CompoundPath:d,PlacedSymbol:_,PointText:g};w.inject({exportSVG:function(t){return t=C(t),x(b(this,t,!0),t)}}),p.inject({exportSVG:function(t){t=C(t);var e=this.layers,i=this.getView(),s=i.getViewSize(),a=n("svg",{x:0,y:0,width:s.width,height:s.height,version:"1.1",xmlns:"http://www.w3.org/2000/svg","xmlns:xlink":"http://www.w3.org/1999/xlink"}),o=a,h=i._matrix;h.isIdentity()||(o=a.appendChild(n("g",r(h))));for(var u=0,l=e.length;l>u;u++)o.appendChild(b(e[u],t,!0));return x(a,t)}})},new function(){function i(t,e,i,n){var r=ie[e],s=r?t.getAttributeNS(r,e):t.getAttribute(e);return"null"===s&&(s=null),null==s?n?null:i?"":0:i?s:parseFloat(s)}function n(t,e,n,r){return e=i(t,e,!1,r),n=i(t,n,!1,r),!r||null!=e&&null!=n?new h(e,n):null}function r(t,e,n,r){return e=i(t,e,!1,r),n=i(t,n,!1,r),!r||null!=e&&null!=n?new c(e,n):null}function s(t,e,i){return"none"===t?null:"number"===e?parseFloat(t):"array"===e?t?t.split(/[\s,]+/g).map(parseFloat):[]:"color"===e?b(t)||t:"lookup"===e?i[t]:t}function a(t,e,i,n){var r=t.childNodes,s="clippath"===e,a=new x,o=a._project,h=o._currentStyle,u=[];s||(a=m(a,t,n),o._currentStyle=a._style.clone());for(var l=0,c=r.length;c>l;l++){var d,_=r[l];1!==_.nodeType||!(d=P(_,i,!1))||d instanceof y||u.push(d)}return a.addChildren(u),s&&(a=m(a.reduce(),t,n)),o._currentStyle=h,(s||"defs"===e)&&(a.remove(),a=null),a}function o(t,e){for(var i=t.getAttribute("points").match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g),n=[],r=0,s=i.length;s>r;r+=2)n.push(new h(parseFloat(i[r]),parseFloat(i[r+1])));var a=new L(n);return"polygon"===e&&a.closePath(),a}function u(t){var e=t.getAttribute("d"),i={pathData:e};return(e.match(/m/gi)||[]).length>1||/z\S+/i.test(e)?new N(i):new L(i)}function l(t,e){var r,s=(i(t,"href",!0)||"").substring(1),a="radialgradient"===e;if(s)r=I[s].getGradient();else{for(var o=t.childNodes,h=[],u=0,l=o.length;l>u;u++){var c=o[u];1===c.nodeType&&h.push(m(new q,c))}r=new F(h,a)}var d,_,f;return a?(d=n(t,"cx","cy"),_=d.add(i(t,"r"),0),f=n(t,"fx","fy",!0)):(d=n(t,"x1","y1"),_=n(t,"x2","y2")),m(new R(r,d,_,f),t),null}function d(t,e,i,n){for(var r=(n.getAttribute(i)||"").split(/\)\s*/g),s=new g,a=0,o=r.length;o>a;a++){var h=r[a];if(!h)break;for(var u=h.split(/\(\s*/),l=u[0],c=u[1].split(/[\s,]+/g),d=0,_=c.length;_>d;d++)c[d]=parseFloat(c[d]);switch(l){case"matrix":s.concatenate(new g(c[0],c[1],c[2],c[3],c[4],c[5]));break;case"rotate":s.rotate(c[0],c[1],c[2]);break;case"translate":s.translate(c[0],c[1]);break;case"scale":s.scale(c);break;case"skewX":s.skew(c[0],0);break;case"skewY":s.skew(0,c[0])}}t.transform(s)}function f(t,e,i){var n=t["fill-opacity"===i?"getFillColor":"getStrokeColor"]();n&&n.setAlpha(parseFloat(e))}function v(i,n,r){var s=i.attributes[n],a=s&&s.value;if(!a){var o=e.camelize(n);a=i.style[o],a||r.node[o]===r.parent[o]||(a=r.node[o])}return a?"none"===a?null:a:t}function m(i,n,r){var s={node:Z.getStyles(n)||{},parent:!r&&Z.getStyles(n.parentNode)||{}};return e.each(z,function(r,a){var o=v(n,a,s);o!==t&&(i=e.pick(r(i,o,a,n,s),i))}),i}function b(t){var e=t&&t.match(/\((?:#|)([^)']+)/);return e&&I[e[1]]}function P(t,e,i){function n(t){paper=s;var n=P(t,e,i),r=e.onLoad,a=s.project&&s.getView();r&&r.call(this,n),a.update()}if(!t)return null;e?"function"==typeof e&&(e={onLoad:e}):e={};var r=t,s=paper;if(i)if("string"!=typeof t||/^.*</.test(t)){if("undefined"!=typeof File&&t instanceof File){var a=new FileReader;return a.onload=function(){n(a.result)},a.readAsText(t)}}else{if(r=document.getElementById(t),!r)return K.request("get",t,n);t=null}if("string"==typeof t&&(r=(new DOMParser).parseFromString(t,"image/svg+xml")),!r.nodeName)throw Error("Unsupported SVG source: "+t);var o,h=r.nodeName.toLowerCase(),u=M[h],l=r.getAttribute&&r.getAttribute("data-paper-data"),c=s.settings,d=c.applyMatrix;if(c.applyMatrix=!1,o=u&&u(r,h,e,i)||null,c.applyMatrix=d,o){"#document"===h||o instanceof x||(o=m(o,r,i));var _=e.onImport;_&&(o=_(r,o,e)||o),e.expandShapes&&o instanceof C&&(o.remove(),o=o.toPath()),l&&(o._data=JSON.parse(l))}return i&&(I={},d&&o&&o.matrix.apply(!0,!0)),o}var M={"#document":function(t,e,i,n){for(var r=t.childNodes,s=0,a=r.length;a>s;s++){var o=r[s];if(1===o.nodeType){var h=o.nextSibling;document.body.appendChild(o);var u=P(o,i,n);return h?t.insertBefore(o,h):t.appendChild(o),u}}},g:a,svg:a,clippath:a,polygon:o,polyline:o,path:u,lineargradient:l,radialgradient:l,image:function(t){var e=new S(i(t,"href",!0));return e.on("load",function(){var e=r(t,"width","height");this.setSize(e);var i=this._matrix._transformPoint(n(t,"x","y").add(e.divide(2)));this.translate(i)}),e},symbol:function(t,e,i,n){return new y(a(t,e,i,n),!0)},defs:a,use:function(t){var e=(i(t,"href",!0)||"").substring(1),r=I[e],s=n(t,"x","y");return r?r instanceof y?r.place(s):r.clone().translate(s):null},circle:function(t){return new C.Circle(n(t,"cx","cy"),i(t,"r"))},ellipse:function(t){return new C.Ellipse({center:n(t,"cx","cy"),radius:r(t,"rx","ry")})},rect:function(t){var e=n(t,"x","y"),i=r(t,"width","height"),s=r(t,"rx","ry");return new C.Rectangle(new _(e,i),s)},line:function(t){return new L.Line(n(t,"x1","y1"),n(t,"x2","y2"))},text:function(t){var e=new E(n(t,"x","y").add(n(t,"dx","dy")));return e.setContent(t.textContent.trim()||""),e}},z=e.each(ee,function(t){this[t.attribute]=function(e,i){if(e[t.set](s(i,t.type,t.fromSVG)),"color"===t.type&&e instanceof C){var n=e[t.get]();n&&n.transform((new g).translate(e.getPosition(!0).negate()))}}},{id:function(t,e){I[e]=t,t.setName&&t.setName(e)},"clip-path":function(t,e){var i=b(e);if(i){if(i=i.clone(),i.setClipMask(!0),!(t instanceof x))return new x(i,t);t.insertChild(0,i)}},gradientTransform:d,transform:d,"fill-opacity":f,"stroke-opacity":f,visibility:function(t,e){t.setVisible("visible"===e)},display:function(t,e){t.setVisible(null!==e)},"stop-color":function(t,e){t.setColor&&t.setColor(e)},"stop-opacity":function(t,e){t._color&&t._color.setAlpha(parseFloat(e))},offset:function(t,e){var i=e.match(/(.*)%$/);t.setRampPoint(i?i[1]/100:parseFloat(e))},viewBox:function(t,e,i,n,a){var o=new _(s(e,"array")),h=r(n,"width","height",!0);if(t instanceof x){var u=h?o.getSize().divide(h):1,l=(new g).translate(o.getPoint()).scale(u);t.transform(l.inverted())}else if(t instanceof y){h&&o.setSize(h);var c="visible"!=v(n,"overflow",a),d=t._definition;c&&!o.contains(d.getBounds())&&(c=new C.Rectangle(o).transform(d._matrix),c.setClipMask(!0),d.addChild(c))}}}),I={};w.inject({importSVG:function(t,e){return this.addChild(P(t,e,!0))}}),p.inject({importSVG:function(t,e){return this.activate(),P(t,e,!0)}})},paper=new(r.inject(e.exports,{enumerable:!0,Base:e,Numerical:o,Key:X})),"function"==typeof define&&define.amd?define("paper",paper):"object"==typeof module&&module&&(module.exports=paper),paper};