import getScrollParent from "./getScrollParent.js";
import getParentNode from "./getParentNode.js";
import getNodeName from "./getNodeName.js";
import getWindow from "./getWindow.js";
export default function listScrollParents(element, list) {
  if (list === void 0) {
    list = [];
  }

  var scrollParent = getScrollParent(element);
  var isBody = getNodeName(scrollParent) === 'body';
  var target = isBody ? getWindow(scrollParent) : scrollParent;
  var updatedList = list.concat(target);
  return isBody ? updatedList : updatedList.concat(listScrollParents(getParentNode(target)));
}