define(
  ["./react-es6","./react-es6/lib/cx","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    /** @jsx React.DOM */

    var React = __dependency1__["default"];
    var classSet = __dependency2__["default"];

    var Input = React.createClass({displayName: 'Input',
      propTypes: {
        type: React.PropTypes.string,
        label: React.PropTypes.renderable,
        help: React.PropTypes.renderable,
        addonBefore: React.PropTypes.string,
        addonAfter: React.PropTypes.string,
        bsStyle: React.PropTypes.oneOf(['success', 'warning', 'error']),
        hasFeedback: React.PropTypes.bool,
        groupClassName: React.PropTypes.string,
        wrapperClassName: React.PropTypes.string,
        labelClassName: React.PropTypes.string,
      },

      getInputDOMNode: function () {
        return this.refs.input.getDOMNode();
      },

      getValue: function () {
        if (this.props.type === 'static') {
          return this.props.value;
        }
        else if (this.props.type) {
          return this.getInputDOMNode().value;
        }
        else {
          throw Error('Cannot use getValue without specifying input type.');
        }
      },

      getChecked: function () {
        return this.getInputDOMNode().checked;
      },

      isCheckboxOrRadio: function () {
        return this.props.type === 'radio' || this.props.type === 'checkbox';
      },

      renderInput: function () {
        var input = null;

        if (!this.props.type) {
          return this.props.children
        }

        switch (this.props.type) {
          case 'select':
            input = (
              React.DOM.select( {className:"form-control", ref:"input", key:"input"}, 
                this.props.children
              )
            );
            break;
          case 'textarea':
            input = React.DOM.textarea( {className:"form-control", ref:"input", key:"input"} );
            break;
          case 'static':
            input = (
              React.DOM.p( {className:"form-control-static", ref:"input",  key:"input"}, 
                this.props.value
              )
            );
            break;
          default:
            var className = this.isCheckboxOrRadio() ? '' : 'form-control';
            input = React.DOM.input( {className:className, ref:"input", key:"input"} );
        }

        return this.transferPropsTo(input);
      },

      renderInputGroup: function (children) {
        var addonBefore = this.props.addonBefore ? (
          React.DOM.span( {className:"input-group-addon", key:"addonBefore"}, 
            this.props.addonBefore
          )
        ) : null;

        var addonAfter = this.props.addonAfter ? (
          React.DOM.span( {className:"input-group-addon", key:"addonAfter"}, 
            this.props.addonAfter
          )
        ) : null;

        return addonBefore || addonAfter ? (
          React.DOM.div( {className:"input-group", key:"input-group"}, 
            addonBefore,
            children,
            addonAfter
          )
        ) : children;
      },

      renderIcon: function () {
        var classes = {
          'glyphicon': true,
          'form-control-feedback': true,
          'glyphicon-ok': this.props.bsStyle === 'success',
          'glyphicon-warning-sign': this.props.bsStyle === 'warning',
          'glyphicon-remove': this.props.bsStyle === 'error',
        };

        return this.props.hasFeedback ? (
          React.DOM.span( {className:classSet(classes), key:"icon"} )
        ) : null;
      },

      renderHelp: function () {
        return this.props.help ? (
          React.DOM.span( {className:"help-block", key:"help"}, 
            this.props.help
          )
        ) : null;
      },

      renderCheckboxandRadioWrapper: function (children) {
        var classes = {
          'checkbox': this.props.type === 'checkbox',
          'radio': this.props.type === 'radio',
        };

        return (
          React.DOM.div( {className:classSet(classes), key:"checkboxRadioWrapper"}, 
            children
          )
        );
      },

      renderWrapper: function (children) {
        return this.props.wrapperClassName ? (
          React.DOM.div( {className:this.props.wrapperClassName, key:"wrapper"}, 
            children
          )
        ) : children;
      },

      renderLabel: function (children) {
        var classes = {
          'control-label': !this.isCheckboxOrRadio(),
        };
        classes[this.props.labelClassName] = this.props.labelClassName;

        return this.props.label ? (
          React.DOM.label( {htmlFor:this.props.id, className:classSet(classes), key:"label"}, 
            children,
            this.props.label
          )
        ) : children;
      },

      renderFormGroup: function (children) {
        var classes = {
          'form-group': true,
          'has-feedback': this.props.hasFeedback,
          'has-success': this.props.bsStyle === 'success',
          'has-warning': this.props.bsStyle === 'warning',
          'has-error': this.props.bsStyle === 'error',
        };
        classes[this.props.groupClassName] = this.props.groupClassName;

        return (
          React.DOM.div( {className:classSet(classes)}, 
            children
          )
        );
      },

      render: function () {
        if (this.isCheckboxOrRadio()) {
          return this.renderFormGroup(
            this.renderWrapper([
              this.renderCheckboxandRadioWrapper(
                this.renderLabel(
                  this.renderInput()
                )
              ),
              this.renderHelp()
            ])
          );
        }
        else {
          return this.renderFormGroup([
            this.renderLabel(),
            this.renderWrapper([
              this.renderInputGroup(
                this.renderInput()
              ),
              this.renderIcon(),
              this.renderHelp()
            ])
          ]);
        }
      }
    });

    __exports__["default"] = Input;
  });