define(
  ["./react-es6","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var React = __dependency1__["default"];

    __exports__["default"] = {
      propTypes: {
        container: React.PropTypes.object.isRequired
      },

      getDefaultProps: function () {
        return {
          container: typeof document !== 'undefined' ? document.body : null
        };
      },

      componentWillUnmount: function () {
        this._unrenderOverlay();
        if (this._overlayTarget) {
          this.getContainerDOMNode()
            .removeChild(this._overlayTarget);
          this._overlayTarget = null;
        }
      },

      componentDidUpdate: function () {
        this._renderOverlay();
      },

      componentDidMount: function () {
        this._renderOverlay();
      },

      _mountOverlayTarget: function () {
        this._overlayTarget = document.createElement('div');
        this.getContainerDOMNode()
          .appendChild(this._overlayTarget);
      },

      _renderOverlay: function () {
        if (!this._overlayTarget) {
          this._mountOverlayTarget();
        }

        // Save reference to help testing
        this._overlayInstance = React.renderComponent(this.renderOverlay(), this._overlayTarget);
      },

      _unrenderOverlay: function () {
        React.unmountComponentAtNode(this._overlayTarget);
        this._overlayInstance = null;
      },

      getOverlayDOMNode: function() {
        if (!this.isMounted()) {
          throw new Error('getOverlayDOMNode(): A component must be mounted to have a DOM node.');
        }

        return this._overlayInstance.getDOMNode();
      },

      getContainerDOMNode: function() {
        return React.isValidComponent(this.props.container) ?
          this.props.container.getDOMNode() : this.props.container;
      }
    };
  });