define(['exports', 'module', './domUtils'], function (exports, module, _domUtils) {
  'use strict';

  var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var _domUtils2 = _interopRequireDefault(_domUtils);

  console.warn('This file is deprecated, and will be removed in v0.24.0. Use react-bootstrap.js or react-bootstrap.min.js instead.');
  console.warn('You can read more about it at https://github.com/react-bootstrap/react-bootstrap/issues/693');

  var utils = {

    getContainerDimensions: function getContainerDimensions(containerNode) {
      var width = undefined,
          height = undefined,
          scroll = undefined;

      if (containerNode.tagName === 'BODY') {
        width = window.innerWidth;
        height = window.innerHeight;
        scroll = _domUtils2['default'].ownerDocument(containerNode).documentElement.scrollTop || containerNode.scrollTop;
      } else {
        width = containerNode.offsetWidth;
        height = containerNode.offsetHeight;
        scroll = containerNode.scrollTop;
      }

      return { width: width, height: height, scroll: scroll };
    },

    getPosition: function getPosition(target, container) {
      var offset = container.tagName === 'BODY' ? _domUtils2['default'].getOffset(target) : _domUtils2['default'].getPosition(target, container);

      return _extends({}, offset, { // eslint-disable-line object-shorthand
        height: target.offsetHeight,
        width: target.offsetWidth
      });
    },

    calcOverlayPosition: function calcOverlayPosition(placement, overlayNode, target, container, padding) {
      var childOffset = utils.getPosition(target, container);

      var overlayHeight = overlayNode.offsetHeight;
      var overlayWidth = overlayNode.offsetWidth;

      var positionLeft = undefined,
          positionTop = undefined,
          arrowOffsetLeft = undefined,
          arrowOffsetTop = undefined;

      if (placement === 'left' || placement === 'right') {
        positionTop = childOffset.top + (childOffset.height - overlayHeight) / 2;

        if (placement === 'left') {
          positionLeft = childOffset.left - overlayWidth;
        } else {
          positionLeft = childOffset.left + childOffset.width;
        }

        var topDelta = getTopDelta(positionTop, overlayHeight, container, padding);

        positionTop += topDelta;
        arrowOffsetTop = 50 * (1 - 2 * topDelta / overlayHeight) + '%';
        arrowOffsetLeft = null;
      } else if (placement === 'top' || placement === 'bottom') {
        positionLeft = childOffset.left + (childOffset.width - overlayWidth) / 2;

        if (placement === 'top') {
          positionTop = childOffset.top - overlayHeight;
        } else {
          positionTop = childOffset.top + childOffset.height;
        }

        var leftDelta = getLeftDelta(positionLeft, overlayWidth, container, padding);
        positionLeft += leftDelta;
        arrowOffsetLeft = 50 * (1 - 2 * leftDelta / overlayWidth) + '%';
        arrowOffsetTop = null;
      } else {
        throw new Error('calcOverlayPosition(): No such placement of "' + placement + '" found.');
      }

      return { positionLeft: positionLeft, positionTop: positionTop, arrowOffsetLeft: arrowOffsetLeft, arrowOffsetTop: arrowOffsetTop };
    }
  };

  function getTopDelta(top, overlayHeight, container, padding) {
    var containerDimensions = utils.getContainerDimensions(container);
    var containerScroll = containerDimensions.scroll;
    var containerHeight = containerDimensions.height;

    var topEdgeOffset = top - padding - containerScroll;
    var bottomEdgeOffset = top + padding - containerScroll + overlayHeight;

    if (topEdgeOffset < 0) {
      return -topEdgeOffset;
    } else if (bottomEdgeOffset > containerHeight) {
      return containerHeight - bottomEdgeOffset;
    } else {
      return 0;
    }
  }

  function getLeftDelta(left, overlayWidth, container, padding) {
    var containerDimensions = utils.getContainerDimensions(container);
    var containerWidth = containerDimensions.width;

    var leftEdgeOffset = left - padding;
    var rightEdgeOffset = left + padding + overlayWidth;

    if (leftEdgeOffset < 0) {
      return -leftEdgeOffset;
    } else if (rightEdgeOffset > containerWidth) {
      return containerWidth - rightEdgeOffset;
    } else {
      return 0;
    }
  }
  module.exports = utils;
});