var doc = window.document,
    promise,
    ready


function GET(url, fn) {
  var req = new XMLHttpRequest()

  req.onreadystatechange = function() {
    if (req.readyState == 4 && (req.status == 200 || (!req.status && req.responseText.length)))
      fn(req.responseText)
  }
  req.open('GET', url, true)
  req.send('')
}

function unindent(src) {
  var ident = /[ \t]+/.exec(src)
  if (ident) src = src.replace(new RegExp('^' + ident[0], 'gm'), '')
  return src
}

function globalEval(js) {
  var node = doc.createElement('script'),
      root = doc.documentElement

  node.text = compile(js)
  root.appendChild(node)
  root.removeChild(node)
}

function compileScripts(fn) {
  var scripts = doc.querySelectorAll('script[type="riot/tag"]'),
      scriptsAmount = scripts.length

  function done() {
    promise.trigger('ready')
    ready = true
    if (fn) fn()
  }

  if (!scriptsAmount) {
    done()
  } else {
    [].map.call(scripts, function(script) {
      var url = script.getAttribute('src')

      function compileTag(source) {
        globalEval(source)
        scriptsAmount--
        if (!scriptsAmount) {
          done()
        }
      }

      return url ? GET(url, compileTag) : compileTag(unindent(script.innerHTML))
    })
  }
}


riot.compile = function(arg, fn) {

  // string
  if (typeof arg === T_STRING) {

    // compile & return
    if (arg.trim()[0] == '<') {
      var js = unindent(compile(arg))
      if (!fn) globalEval(js)
      return js

    // URL
    } else {
      return GET(arg, function(str) {
        var js = unindent(compile(str))
        globalEval(js)
        if (fn) fn(js, str)
      })
    }
  }

  // must be a function
  if (typeof arg !== 'function') arg = undefined

  // all compiled
  if (ready) return arg && arg()

  // add to queue
  if (promise) {
    if (arg) promise.on('ready', arg)

  // grab riot/tag elements + load & execute them
  } else {
    promise = riot.observable()
    compileScripts(arg)
  }

}

// reassign mount methods
var mount = riot.mount

riot.mount = function(a, b, c) {
  var ret
  riot.compile(function() { ret = mount(a, b, c) })
  return ret
}

// @deprecated
riot.mountTo = riot.mount