(function(global) {
  'use strict';
  if (global.$traceurRuntime) {
    return;
  }
  var $Object = Object;
  var $TypeError = TypeError;
  var $create = $Object.create;
  var $defineProperties = $Object.defineProperties;
  var $defineProperty = $Object.defineProperty;
  var $freeze = $Object.freeze;
  var $getOwnPropertyDescriptor = $Object.getOwnPropertyDescriptor;
  var $getOwnPropertyNames = $Object.getOwnPropertyNames;
  var $keys = $Object.keys;
  var $hasOwnProperty = $Object.prototype.hasOwnProperty;
  var $toString = $Object.prototype.toString;
  var $preventExtensions = Object.preventExtensions;
  var $seal = Object.seal;
  var $isExtensible = Object.isExtensible;
  function nonEnum(value) {
    return {
      configurable: true,
      enumerable: false,
      value: value,
      writable: true
    };
  }
  var method = nonEnum;
  var counter = 0;
  function newUniqueString() {
    return '__$' + Math.floor(Math.random() * 1e9) + '$' + ++counter + '$__';
  }
  var symbolInternalProperty = newUniqueString();
  var symbolDescriptionProperty = newUniqueString();
  var symbolDataProperty = newUniqueString();
  var symbolValues = $create(null);
  var privateNames = $create(null);
  function isPrivateName(s) {
    return privateNames[s];
  }
  function createPrivateName() {
    var s = newUniqueString();
    privateNames[s] = true;
    return s;
  }
  function isShimSymbol(symbol) {
    return typeof symbol === 'object' && symbol instanceof SymbolValue;
  }
  function typeOf(v) {
    if (isShimSymbol(v))
      return 'symbol';
    return typeof v;
  }
  function Symbol(description) {
    var value = new SymbolValue(description);
    if (!(this instanceof Symbol))
      return value;
    throw new TypeError('Symbol cannot be new\'ed');
  }
  $defineProperty(Symbol.prototype, 'constructor', nonEnum(Symbol));
  $defineProperty(Symbol.prototype, 'toString', method(function() {
    var symbolValue = this[symbolDataProperty];
    if (!getOption('symbols'))
      return symbolValue[symbolInternalProperty];
    if (!symbolValue)
      throw TypeError('Conversion from symbol to string');
    var desc = symbolValue[symbolDescriptionProperty];
    if (desc === undefined)
      desc = '';
    return 'Symbol(' + desc + ')';
  }));
  $defineProperty(Symbol.prototype, 'valueOf', method(function() {
    var symbolValue = this[symbolDataProperty];
    if (!symbolValue)
      throw TypeError('Conversion from symbol to string');
    if (!getOption('symbols'))
      return symbolValue[symbolInternalProperty];
    return symbolValue;
  }));
  function SymbolValue(description) {
    var key = newUniqueString();
    $defineProperty(this, symbolDataProperty, {value: this});
    $defineProperty(this, symbolInternalProperty, {value: key});
    $defineProperty(this, symbolDescriptionProperty, {value: description});
    freeze(this);
    symbolValues[key] = this;
  }
  $defineProperty(SymbolValue.prototype, 'constructor', nonEnum(Symbol));
  $defineProperty(SymbolValue.prototype, 'toString', {
    value: Symbol.prototype.toString,
    enumerable: false
  });
  $defineProperty(SymbolValue.prototype, 'valueOf', {
    value: Symbol.prototype.valueOf,
    enumerable: false
  });
  var hashProperty = createPrivateName();
  var hashPropertyDescriptor = {value: undefined};
  var hashObjectProperties = {
    hash: {value: undefined},
    self: {value: undefined}
  };
  var hashCounter = 0;
  function getOwnHashObject(object) {
    var hashObject = object[hashProperty];
    if (hashObject && hashObject.self === object)
      return hashObject;
    if ($isExtensible(object)) {
      hashObjectProperties.hash.value = hashCounter++;
      hashObjectProperties.self.value = object;
      hashPropertyDescriptor.value = $create(null, hashObjectProperties);
      $defineProperty(object, hashProperty, hashPropertyDescriptor);
      return hashPropertyDescriptor.value;
    }
    return undefined;
  }
  function freeze(object) {
    getOwnHashObject(object);
    return $freeze.apply(this, arguments);
  }
  function preventExtensions(object) {
    getOwnHashObject(object);
    return $preventExtensions.apply(this, arguments);
  }
  function seal(object) {
    getOwnHashObject(object);
    return $seal.apply(this, arguments);
  }
  freeze(SymbolValue.prototype);
  function isSymbolString(s) {
    return symbolValues[s] || privateNames[s];
  }
  function toProperty(name) {
    if (isShimSymbol(name))
      return name[symbolInternalProperty];
    return name;
  }
  function removeSymbolKeys(array) {
    var rv = [];
    for (var i = 0; i < array.length; i++) {
      if (!isSymbolString(array[i])) {
        rv.push(array[i]);
      }
    }
    return rv;
  }
  function getOwnPropertyNames(object) {
    return removeSymbolKeys($getOwnPropertyNames(object));
  }
  function keys(object) {
    return removeSymbolKeys($keys(object));
  }
  function getOwnPropertySymbols(object) {
    var rv = [];
    var names = $getOwnPropertyNames(object);
    for (var i = 0; i < names.length; i++) {
      var symbol = symbolValues[names[i]];
      if (symbol) {
        rv.push(symbol);
      }
    }
    return rv;
  }
  function getOwnPropertyDescriptor(object, name) {
    return $getOwnPropertyDescriptor(object, toProperty(name));
  }
  function hasOwnProperty(name) {
    return $hasOwnProperty.call(this, toProperty(name));
  }
  function getOption(name) {
    return global.traceur && global.traceur.options[name];
  }
  function defineProperty(object, name, descriptor) {
    if (isShimSymbol(name)) {
      name = name[symbolInternalProperty];
    }
    $defineProperty(object, name, descriptor);
    return object;
  }
  function polyfillObject(Object) {
    $defineProperty(Object, 'defineProperty', {value: defineProperty});
    $defineProperty(Object, 'getOwnPropertyNames', {value: getOwnPropertyNames});
    $defineProperty(Object, 'getOwnPropertyDescriptor', {value: getOwnPropertyDescriptor});
    $defineProperty(Object.prototype, 'hasOwnProperty', {value: hasOwnProperty});
    $defineProperty(Object, 'freeze', {value: freeze});
    $defineProperty(Object, 'preventExtensions', {value: preventExtensions});
    $defineProperty(Object, 'seal', {value: seal});
    $defineProperty(Object, 'keys', {value: keys});
  }
  function exportStar(object) {
    for (var i = 1; i < arguments.length; i++) {
      var names = $getOwnPropertyNames(arguments[i]);
      for (var j = 0; j < names.length; j++) {
        var name = names[j];
        if (isSymbolString(name))
          continue;
        (function(mod, name) {
          $defineProperty(object, name, {
            get: function() {
              return mod[name];
            },
            enumerable: true
          });
        })(arguments[i], names[j]);
      }
    }
    return object;
  }
  function isObject(x) {
    return x != null && (typeof x === 'object' || typeof x === 'function');
  }
  function toObject(x) {
    if (x == null)
      throw $TypeError();
    return $Object(x);
  }
  function checkObjectCoercible(argument) {
    if (argument == null) {
      throw new TypeError('Value cannot be converted to an Object');
    }
    return argument;
  }
  function polyfillSymbol(global, Symbol) {
    if (!global.Symbol) {
      global.Symbol = Symbol;
      Object.getOwnPropertySymbols = getOwnPropertySymbols;
    }
    if (!global.Symbol.iterator) {
      global.Symbol.iterator = Symbol('Symbol.iterator');
    }
  }
  function setupGlobals(global) {
    polyfillSymbol(global, Symbol);
    global.Reflect = global.Reflect || {};
    global.Reflect.global = global.Reflect.global || global;
    polyfillObject(global.Object);
  }
  setupGlobals(global);
  global.$traceurRuntime = {
    checkObjectCoercible: checkObjectCoercible,
    createPrivateName: createPrivateName,
    defineProperties: $defineProperties,
    defineProperty: $defineProperty,
    exportStar: exportStar,
    getOwnHashObject: getOwnHashObject,
    getOwnPropertyDescriptor: $getOwnPropertyDescriptor,
    getOwnPropertyNames: $getOwnPropertyNames,
    isObject: isObject,
    isPrivateName: isPrivateName,
    isSymbolString: isSymbolString,
    keys: $keys,
    setupGlobals: setupGlobals,
    toObject: toObject,
    toProperty: toProperty,
    typeof: typeOf
  };
})(typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : this);
(function() {
  'use strict';
  var path;
  function relativeRequire(callerPath, requiredPath) {
    path = path || typeof require !== 'undefined' && require('path');
    function isDirectory(path) {
      return path.slice(-1) === '/';
    }
    function isAbsolute(path) {
      return path[0] === '/';
    }
    function isRelative(path) {
      return path[0] === '.';
    }
    if (isDirectory(requiredPath) || isAbsolute(requiredPath))
      return;
    return isRelative(requiredPath) ? require(path.resolve(path.dirname(callerPath), requiredPath)) : require(requiredPath);
  }
  $traceurRuntime.require = relativeRequire;
})();
(function() {
  'use strict';
  function spread() {
    var rv = [],
        j = 0,
        iterResult;
    for (var i = 0; i < arguments.length; i++) {
      var valueToSpread = $traceurRuntime.checkObjectCoercible(arguments[i]);
      if (typeof valueToSpread[$traceurRuntime.toProperty(Symbol.iterator)] !== 'function') {
        throw new TypeError('Cannot spread non-iterable object.');
      }
      var iter = valueToSpread[$traceurRuntime.toProperty(Symbol.iterator)]();
      while (!(iterResult = iter.next()).done) {
        rv[j++] = iterResult.value;
      }
    }
    return rv;
  }
  $traceurRuntime.spread = spread;
})();
(function() {
  'use strict';
  var $Object = Object;
  var $TypeError = TypeError;
  var $create = $Object.create;
  var $defineProperties = $traceurRuntime.defineProperties;
  var $defineProperty = $traceurRuntime.defineProperty;
  var $getOwnPropertyDescriptor = $traceurRuntime.getOwnPropertyDescriptor;
  var $getOwnPropertyNames = $traceurRuntime.getOwnPropertyNames;
  var $getPrototypeOf = Object.getPrototypeOf;
  var $__0 = Object,
      getOwnPropertyNames = $__0.getOwnPropertyNames,
      getOwnPropertySymbols = $__0.getOwnPropertySymbols;
  function superDescriptor(homeObject, name) {
    var proto = $getPrototypeOf(homeObject);
    do {
      var result = $getOwnPropertyDescriptor(proto, name);
      if (result)
        return result;
      proto = $getPrototypeOf(proto);
    } while (proto);
    return undefined;
  }
  function superConstructor(ctor) {
    return ctor.__proto__;
  }
  function superCall(self, homeObject, name, args) {
    return superGet(self, homeObject, name).apply(self, args);
  }
  function superGet(self, homeObject, name) {
    var descriptor = superDescriptor(homeObject, name);
    if (descriptor) {
      if (!descriptor.get)
        return descriptor.value;
      return descriptor.get.call(self);
    }
    return undefined;
  }
  function superSet(self, homeObject, name, value) {
    var descriptor = superDescriptor(homeObject, name);
    if (descriptor && descriptor.set) {
      descriptor.set.call(self, value);
      return value;
    }
    throw $TypeError(("super has no setter '" + name + "'."));
  }
  function getDescriptors(object) {
    var descriptors = {};
    var names = getOwnPropertyNames(object);
    for (var i = 0; i < names.length; i++) {
      var name = names[i];
      descriptors[name] = $getOwnPropertyDescriptor(object, name);
    }
    var symbols = getOwnPropertySymbols(object);
    for (var i = 0; i < symbols.length; i++) {
      var symbol = symbols[i];
      descriptors[$traceurRuntime.toProperty(symbol)] = $getOwnPropertyDescriptor(object, $traceurRuntime.toProperty(symbol));
    }
    return descriptors;
  }
  function createClass(ctor, object, staticObject, superClass) {
    $defineProperty(object, 'constructor', {
      value: ctor,
      configurable: true,
      enumerable: false,
      writable: true
    });
    if (arguments.length > 3) {
      if (typeof superClass === 'function')
        ctor.__proto__ = superClass;
      ctor.prototype = $create(getProtoParent(superClass), getDescriptors(object));
    } else {
      ctor.prototype = object;
    }
    $defineProperty(ctor, 'prototype', {
      configurable: false,
      writable: false
    });
    return $defineProperties(ctor, getDescriptors(staticObject));
  }
  function getProtoParent(superClass) {
    if (typeof superClass === 'function') {
      var prototype = superClass.prototype;
      if ($Object(prototype) === prototype || prototype === null)
        return superClass.prototype;
      throw new $TypeError('super prototype must be an Object or null');
    }
    if (superClass === null)
      return null;
    throw new $TypeError(("Super expression must either be null or a function, not " + typeof superClass + "."));
  }
  function defaultSuperCall(self, homeObject, args) {
    if ($getPrototypeOf(homeObject) !== null)
      superCall(self, homeObject, 'constructor', args);
  }
  $traceurRuntime.createClass = createClass;
  $traceurRuntime.defaultSuperCall = defaultSuperCall;
  $traceurRuntime.superCall = superCall;
  $traceurRuntime.superConstructor = superConstructor;
  $traceurRuntime.superGet = superGet;
  $traceurRuntime.superSet = superSet;
})();
(function() {
  'use strict';
  if (typeof $traceurRuntime !== 'object') {
    throw new Error('traceur runtime not found.');
  }
  var createPrivateName = $traceurRuntime.createPrivateName;
  var $defineProperties = $traceurRuntime.defineProperties;
  var $defineProperty = $traceurRuntime.defineProperty;
  var $create = Object.create;
  var $TypeError = TypeError;
  function nonEnum(value) {
    return {
      configurable: true,
      enumerable: false,
      value: value,
      writable: true
    };
  }
  var ST_NEWBORN = 0;
  var ST_EXECUTING = 1;
  var ST_SUSPENDED = 2;
  var ST_CLOSED = 3;
  var END_STATE = -2;
  var RETHROW_STATE = -3;
  function getInternalError(state) {
    return new Error('Traceur compiler bug: invalid state in state machine: ' + state);
  }
  function GeneratorContext() {
    this.state = 0;
    this.GState = ST_NEWBORN;
    this.storedException = undefined;
    this.finallyFallThrough = undefined;
    this.sent_ = undefined;
    this.returnValue = undefined;
    this.tryStack_ = [];
  }
  GeneratorContext.prototype = {
    pushTry: function(catchState, finallyState) {
      if (finallyState !== null) {
        var finallyFallThrough = null;
        for (var i = this.tryStack_.length - 1; i >= 0; i--) {
          if (this.tryStack_[i].catch !== undefined) {
            finallyFallThrough = this.tryStack_[i].catch;
            break;
          }
        }
        if (finallyFallThrough === null)
          finallyFallThrough = RETHROW_STATE;
        this.tryStack_.push({
          finally: finallyState,
          finallyFallThrough: finallyFallThrough
        });
      }
      if (catchState !== null) {
        this.tryStack_.push({catch: catchState});
      }
    },
    popTry: function() {
      this.tryStack_.pop();
    },
    get sent() {
      this.maybeThrow();
      return this.sent_;
    },
    set sent(v) {
      this.sent_ = v;
    },
    get sentIgnoreThrow() {
      return this.sent_;
    },
    maybeThrow: function() {
      if (this.action === 'throw') {
        this.action = 'next';
        throw this.sent_;
      }
    },
    end: function() {
      switch (this.state) {
        case END_STATE:
          return this;
        case RETHROW_STATE:
          throw this.storedException;
        default:
          throw getInternalError(this.state);
      }
    },
    handleException: function(ex) {
      this.GState = ST_CLOSED;
      this.state = END_STATE;
      throw ex;
    }
  };
  function nextOrThrow(ctx, moveNext, action, x) {
    switch (ctx.GState) {
      case ST_EXECUTING:
        throw new Error(("\"" + action + "\" on executing generator"));
      case ST_CLOSED:
        if (action == 'next') {
          return {
            value: undefined,
            done: true
          };
        }
        throw x;
      case ST_NEWBORN:
        if (action === 'throw') {
          ctx.GState = ST_CLOSED;
          throw x;
        }
        if (x !== undefined)
          throw $TypeError('Sent value to newborn generator');
      case ST_SUSPENDED:
        ctx.GState = ST_EXECUTING;
        ctx.action = action;
        ctx.sent = x;
        var value = moveNext(ctx);
        var done = value === ctx;
        if (done)
          value = ctx.returnValue;
        ctx.GState = done ? ST_CLOSED : ST_SUSPENDED;
        return {
          value: value,
          done: done
        };
    }
  }
  var ctxName = createPrivateName();
  var moveNextName = createPrivateName();
  function GeneratorFunction() {}
  function GeneratorFunctionPrototype() {}
  GeneratorFunction.prototype = GeneratorFunctionPrototype;
  $defineProperty(GeneratorFunctionPrototype, 'constructor', nonEnum(GeneratorFunction));
  GeneratorFunctionPrototype.prototype = {
    constructor: GeneratorFunctionPrototype,
    next: function(v) {
      return nextOrThrow(this[ctxName], this[moveNextName], 'next', v);
    },
    throw: function(v) {
      return nextOrThrow(this[ctxName], this[moveNextName], 'throw', v);
    }
  };
  $defineProperties(GeneratorFunctionPrototype.prototype, {
    constructor: {enumerable: false},
    next: {enumerable: false},
    throw: {enumerable: false}
  });
  Object.defineProperty(GeneratorFunctionPrototype.prototype, Symbol.iterator, nonEnum(function() {
    return this;
  }));
  function createGeneratorInstance(innerFunction, functionObject, self) {
    var moveNext = getMoveNext(innerFunction, self);
    var ctx = new GeneratorContext();
    var object = $create(functionObject.prototype);
    object[ctxName] = ctx;
    object[moveNextName] = moveNext;
    return object;
  }
  function initGeneratorFunction(functionObject) {
    functionObject.prototype = $create(GeneratorFunctionPrototype.prototype);
    functionObject.__proto__ = GeneratorFunctionPrototype;
    return functionObject;
  }
  function AsyncFunctionContext() {
    GeneratorContext.call(this);
    this.err = undefined;
    var ctx = this;
    ctx.result = new Promise(function(resolve, reject) {
      ctx.resolve = resolve;
      ctx.reject = reject;
    });
  }
  AsyncFunctionContext.prototype = $create(GeneratorContext.prototype);
  AsyncFunctionContext.prototype.end = function() {
    switch (this.state) {
      case END_STATE:
        this.resolve(this.returnValue);
        break;
      case RETHROW_STATE:
        this.reject(this.storedException);
        break;
      default:
        this.reject(getInternalError(this.state));
    }
  };
  AsyncFunctionContext.prototype.handleException = function() {
    this.state = RETHROW_STATE;
  };
  function asyncWrap(innerFunction, self) {
    var moveNext = getMoveNext(innerFunction, self);
    var ctx = new AsyncFunctionContext();
    ctx.createCallback = function(newState) {
      return function(value) {
        ctx.state = newState;
        ctx.value = value;
        moveNext(ctx);
      };
    };
    ctx.errback = function(err) {
      handleCatch(ctx, err);
      moveNext(ctx);
    };
    moveNext(ctx);
    return ctx.result;
  }
  function getMoveNext(innerFunction, self) {
    return function(ctx) {
      while (true) {
        try {
          return innerFunction.call(self, ctx);
        } catch (ex) {
          handleCatch(ctx, ex);
        }
      }
    };
  }
  function handleCatch(ctx, ex) {
    ctx.storedException = ex;
    var last = ctx.tryStack_[ctx.tryStack_.length - 1];
    if (!last) {
      ctx.handleException(ex);
      return;
    }
    ctx.state = last.catch !== undefined ? last.catch : last.finally;
    if (last.finallyFallThrough !== undefined)
      ctx.finallyFallThrough = last.finallyFallThrough;
  }
  $traceurRuntime.asyncWrap = asyncWrap;
  $traceurRuntime.initGeneratorFunction = initGeneratorFunction;
  $traceurRuntime.createGeneratorInstance = createGeneratorInstance;
})();
(function() {
  function buildFromEncodedParts(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_queryData, opt_fragment) {
    var out = [];
    if (opt_scheme) {
      out.push(opt_scheme, ':');
    }
    if (opt_domain) {
      out.push('//');
      if (opt_userInfo) {
        out.push(opt_userInfo, '@');
      }
      out.push(opt_domain);
      if (opt_port) {
        out.push(':', opt_port);
      }
    }
    if (opt_path) {
      out.push(opt_path);
    }
    if (opt_queryData) {
      out.push('?', opt_queryData);
    }
    if (opt_fragment) {
      out.push('#', opt_fragment);
    }
    return out.join('');
  }
  ;
  var splitRe = new RegExp('^' + '(?:' + '([^:/?#.]+)' + ':)?' + '(?://' + '(?:([^/?#]*)@)?' + '([\\w\\d\\-\\u0100-\\uffff.%]*)' + '(?::([0-9]+))?' + ')?' + '([^?#]+)?' + '(?:\\?([^#]*))?' + '(?:#(.*))?' + '$');
  var ComponentIndex = {
    SCHEME: 1,
    USER_INFO: 2,
    DOMAIN: 3,
    PORT: 4,
    PATH: 5,
    QUERY_DATA: 6,
    FRAGMENT: 7
  };
  function split(uri) {
    return (uri.match(splitRe));
  }
  function removeDotSegments(path) {
    if (path === '/')
      return '/';
    var leadingSlash = path[0] === '/' ? '/' : '';
    var trailingSlash = path.slice(-1) === '/' ? '/' : '';
    var segments = path.split('/');
    var out = [];
    var up = 0;
    for (var pos = 0; pos < segments.length; pos++) {
      var segment = segments[pos];
      switch (segment) {
        case '':
        case '.':
          break;
        case '..':
          if (out.length)
            out.pop();
          else
            up++;
          break;
        default:
          out.push(segment);
      }
    }
    if (!leadingSlash) {
      while (up-- > 0) {
        out.unshift('..');
      }
      if (out.length === 0)
        out.push('.');
    }
    return leadingSlash + out.join('/') + trailingSlash;
  }
  function joinAndCanonicalizePath(parts) {
    var path = parts[ComponentIndex.PATH] || '';
    path = removeDotSegments(path);
    parts[ComponentIndex.PATH] = path;
    return buildFromEncodedParts(parts[ComponentIndex.SCHEME], parts[ComponentIndex.USER_INFO], parts[ComponentIndex.DOMAIN], parts[ComponentIndex.PORT], parts[ComponentIndex.PATH], parts[ComponentIndex.QUERY_DATA], parts[ComponentIndex.FRAGMENT]);
  }
  function canonicalizeUrl(url) {
    var parts = split(url);
    return joinAndCanonicalizePath(parts);
  }
  function resolveUrl(base, url) {
    var parts = split(url);
    var baseParts = split(base);
    if (parts[ComponentIndex.SCHEME]) {
      return joinAndCanonicalizePath(parts);
    } else {
      parts[ComponentIndex.SCHEME] = baseParts[ComponentIndex.SCHEME];
    }
    for (var i = ComponentIndex.SCHEME; i <= ComponentIndex.PORT; i++) {
      if (!parts[i]) {
        parts[i] = baseParts[i];
      }
    }
    if (parts[ComponentIndex.PATH][0] == '/') {
      return joinAndCanonicalizePath(parts);
    }
    var path = baseParts[ComponentIndex.PATH];
    var index = path.lastIndexOf('/');
    path = path.slice(0, index + 1) + parts[ComponentIndex.PATH];
    parts[ComponentIndex.PATH] = path;
    return joinAndCanonicalizePath(parts);
  }
  function isAbsolute(name) {
    if (!name)
      return false;
    if (name[0] === '/')
      return true;
    var parts = split(name);
    if (parts[ComponentIndex.SCHEME])
      return true;
    return false;
  }
  $traceurRuntime.canonicalizeUrl = canonicalizeUrl;
  $traceurRuntime.isAbsolute = isAbsolute;
  $traceurRuntime.removeDotSegments = removeDotSegments;
  $traceurRuntime.resolveUrl = resolveUrl;
})();
(function() {
  'use strict';
  var types = {
    any: {name: 'any'},
    boolean: {name: 'boolean'},
    number: {name: 'number'},
    string: {name: 'string'},
    symbol: {name: 'symbol'},
    void: {name: 'void'}
  };
  var GenericType = function GenericType(type, argumentTypes) {
    this.type = type;
    this.argumentTypes = argumentTypes;
  };
  ($traceurRuntime.createClass)(GenericType, {}, {});
  var typeRegister = Object.create(null);
  function genericType(type) {
    for (var argumentTypes = [],
        $__1 = 1; $__1 < arguments.length; $__1++)
      argumentTypes[$__1 - 1] = arguments[$__1];
    var typeMap = typeRegister;
    var key = $traceurRuntime.getOwnHashObject(type).hash;
    if (!typeMap[key]) {
      typeMap[key] = Object.create(null);
    }
    typeMap = typeMap[key];
    for (var i = 0; i < argumentTypes.length - 1; i++) {
      key = $traceurRuntime.getOwnHashObject(argumentTypes[i]).hash;
      if (!typeMap[key]) {
        typeMap[key] = Object.create(null);
      }
      typeMap = typeMap[key];
    }
    var tail = argumentTypes[argumentTypes.length - 1];
    key = $traceurRuntime.getOwnHashObject(tail).hash;
    if (!typeMap[key]) {
      typeMap[key] = new GenericType(type, argumentTypes);
    }
    return typeMap[key];
  }
  $traceurRuntime.GenericType = GenericType;
  $traceurRuntime.genericType = genericType;
  $traceurRuntime.type = types;
})();
(function(global) {
  'use strict';
  var $__2 = $traceurRuntime,
      canonicalizeUrl = $__2.canonicalizeUrl,
      resolveUrl = $__2.resolveUrl,
      isAbsolute = $__2.isAbsolute;
  var moduleInstantiators = Object.create(null);
  var baseURL;
  if (global.location && global.location.href)
    baseURL = resolveUrl(global.location.href, './');
  else
    baseURL = '';
  var UncoatedModuleEntry = function UncoatedModuleEntry(url, uncoatedModule) {
    this.url = url;
    this.value_ = uncoatedModule;
  };
  ($traceurRuntime.createClass)(UncoatedModuleEntry, {}, {});
  var ModuleEvaluationError = function ModuleEvaluationError(erroneousModuleName, cause) {
    this.message = this.constructor.name + ': ' + this.stripCause(cause) + ' in ' + erroneousModuleName;
    if (!(cause instanceof $ModuleEvaluationError) && cause.stack)
      this.stack = this.stripStack(cause.stack);
    else
      this.stack = '';
  };
  var $ModuleEvaluationError = ModuleEvaluationError;
  ($traceurRuntime.createClass)(ModuleEvaluationError, {
    stripError: function(message) {
      return message.replace(/.*Error:/, this.constructor.name + ':');
    },
    stripCause: function(cause) {
      if (!cause)
        return '';
      if (!cause.message)
        return cause + '';
      return this.stripError(cause.message);
    },
    loadedBy: function(moduleName) {
      this.stack += '\n loaded by ' + moduleName;
    },
    stripStack: function(causeStack) {
      var stack = [];
      causeStack.split('\n').some((function(frame) {
        if (/UncoatedModuleInstantiator/.test(frame))
          return true;
        stack.push(frame);
      }));
      stack[0] = this.stripError(stack[0]);
      return stack.join('\n');
    }
  }, {}, Error);
  function beforeLines(lines, number) {
    var result = [];
    var first = number - 3;
    if (first < 0)
      first = 0;
    for (var i = first; i < number; i++) {
      result.push(lines[i]);
    }
    return result;
  }
  function afterLines(lines, number) {
    var last = number + 1;
    if (last > lines.length - 1)
      last = lines.length - 1;
    var result = [];
    for (var i = number; i <= last; i++) {
      result.push(lines[i]);
    }
    return result;
  }
  function columnSpacing(columns) {
    var result = '';
    for (var i = 0; i < columns - 1; i++) {
      result += '-';
    }
    return result;
  }
  var UncoatedModuleInstantiator = function UncoatedModuleInstantiator(url, func) {
    $traceurRuntime.superConstructor($UncoatedModuleInstantiator).call(this, url, null);
    this.func = func;
  };
  var $UncoatedModuleInstantiator = UncoatedModuleInstantiator;
  ($traceurRuntime.createClass)(UncoatedModuleInstantiator, {getUncoatedModule: function() {
      if (this.value_)
        return this.value_;
      try {
        var relativeRequire;
        if (typeof $traceurRuntime !== undefined) {
          relativeRequire = $traceurRuntime.require.bind(null, this.url);
        }
        return this.value_ = this.func.call(global, relativeRequire);
      } catch (ex) {
        if (ex instanceof ModuleEvaluationError) {
          ex.loadedBy(this.url);
          throw ex;
        }
        if (ex.stack) {
          var lines = this.func.toString().split('\n');
          var evaled = [];
          ex.stack.split('\n').some(function(frame) {
            if (frame.indexOf('UncoatedModuleInstantiator.getUncoatedModule') > 0)
              return true;
            var m = /(at\s[^\s]*\s).*>:(\d*):(\d*)\)/.exec(frame);
            if (m) {
              var line = parseInt(m[2], 10);
              evaled = evaled.concat(beforeLines(lines, line));
              evaled.push(columnSpacing(m[3]) + '^');
              evaled = evaled.concat(afterLines(lines, line));
              evaled.push('= = = = = = = = =');
            } else {
              evaled.push(frame);
            }
          });
          ex.stack = evaled.join('\n');
        }
        throw new ModuleEvaluationError(this.url, ex);
      }
    }}, {}, UncoatedModuleEntry);
  function getUncoatedModuleInstantiator(name) {
    if (!name)
      return;
    var url = ModuleStore.normalize(name);
    return moduleInstantiators[url];
  }
  ;
  var moduleInstances = Object.create(null);
  var liveModuleSentinel = {};
  function Module(uncoatedModule) {
    var isLive = arguments[1];
    var coatedModule = Object.create(null);
    Object.getOwnPropertyNames(uncoatedModule).forEach((function(name) {
      var getter,
          value;
      if (isLive === liveModuleSentinel) {
        var descr = Object.getOwnPropertyDescriptor(uncoatedModule, name);
        if (descr.get)
          getter = descr.get;
      }
      if (!getter) {
        value = uncoatedModule[name];
        getter = function() {
          return value;
        };
      }
      Object.defineProperty(coatedModule, name, {
        get: getter,
        enumerable: true
      });
    }));
    Object.preventExtensions(coatedModule);
    return coatedModule;
  }
  var ModuleStore = {
    normalize: function(name, refererName, refererAddress) {
      if (typeof name !== 'string')
        throw new TypeError('module name must be a string, not ' + typeof name);
      if (isAbsolute(name))
        return canonicalizeUrl(name);
      if (/[^\.]\/\.\.\//.test(name)) {
        throw new Error('module name embeds /../: ' + name);
      }
      if (name[0] === '.' && refererName)
        return resolveUrl(refererName, name);
      return canonicalizeUrl(name);
    },
    get: function(normalizedName) {
      var m = getUncoatedModuleInstantiator(normalizedName);
      if (!m)
        return undefined;
      var moduleInstance = moduleInstances[m.url];
      if (moduleInstance)
        return moduleInstance;
      moduleInstance = Module(m.getUncoatedModule(), liveModuleSentinel);
      return moduleInstances[m.url] = moduleInstance;
    },
    set: function(normalizedName, module) {
      normalizedName = String(normalizedName);
      moduleInstantiators[normalizedName] = new UncoatedModuleInstantiator(normalizedName, (function() {
        return module;
      }));
      moduleInstances[normalizedName] = module;
    },
    get baseURL() {
      return baseURL;
    },
    set baseURL(v) {
      baseURL = String(v);
    },
    registerModule: function(name, deps, func) {
      var normalizedName = ModuleStore.normalize(name);
      if (moduleInstantiators[normalizedName])
        throw new Error('duplicate module named ' + normalizedName);
      moduleInstantiators[normalizedName] = new UncoatedModuleInstantiator(normalizedName, func);
    },
    bundleStore: Object.create(null),
    register: function(name, deps, func) {
      if (!deps || !deps.length && !func.length) {
        this.registerModule(name, deps, func);
      } else {
        this.bundleStore[name] = {
          deps: deps,
          execute: function() {
            var $__0 = arguments;
            var depMap = {};
            deps.forEach((function(dep, index) {
              return depMap[dep] = $__0[index];
            }));
            var registryEntry = func.call(this, depMap);
            registryEntry.execute.call(this);
            return registryEntry.exports;
          }
        };
      }
    },
    getAnonymousModule: function(func) {
      return new Module(func.call(global), liveModuleSentinel);
    },
    getForTesting: function(name) {
      var $__0 = this;
      if (!this.testingPrefix_) {
        Object.keys(moduleInstances).some((function(key) {
          var m = /(traceur@[^\/]*\/)/.exec(key);
          if (m) {
            $__0.testingPrefix_ = m[1];
            return true;
          }
        }));
      }
      return this.get(this.testingPrefix_ + name);
    }
  };
  var moduleStoreModule = new Module({ModuleStore: ModuleStore});
  ModuleStore.set('@traceur/src/runtime/ModuleStore', moduleStoreModule);
  ModuleStore.set('@traceur/src/runtime/ModuleStore.js', moduleStoreModule);
  var setupGlobals = $traceurRuntime.setupGlobals;
  $traceurRuntime.setupGlobals = function(global) {
    setupGlobals(global);
  };
  $traceurRuntime.ModuleStore = ModuleStore;
  global.System = {
    register: ModuleStore.register.bind(ModuleStore),
    registerModule: ModuleStore.registerModule.bind(ModuleStore),
    get: ModuleStore.get,
    set: ModuleStore.set,
    normalize: ModuleStore.normalize
  };
  $traceurRuntime.getModuleImpl = function(name) {
    var instantiator = getUncoatedModuleInstantiator(name);
    return instantiator && instantiator.getUncoatedModule();
  };
})(typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : this);
System.registerModule("traceur@0.0.80/src/runtime/polyfills/utils.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/utils.js";
  var $ceil = Math.ceil;
  var $floor = Math.floor;
  var $isFinite = isFinite;
  var $isNaN = isNaN;
  var $pow = Math.pow;
  var $min = Math.min;
  var toObject = $traceurRuntime.toObject;
  function toUint32(x) {
    return x >>> 0;
  }
  function isObject(x) {
    return x && (typeof x === 'object' || typeof x === 'function');
  }
  function isCallable(x) {
    return typeof x === 'function';
  }
  function isNumber(x) {
    return typeof x === 'number';
  }
  function toInteger(x) {
    x = +x;
    if ($isNaN(x))
      return 0;
    if (x === 0 || !$isFinite(x))
      return x;
    return x > 0 ? $floor(x) : $ceil(x);
  }
  var MAX_SAFE_LENGTH = $pow(2, 53) - 1;
  function toLength(x) {
    var len = toInteger(x);
    return len < 0 ? 0 : $min(len, MAX_SAFE_LENGTH);
  }
  function checkIterable(x) {
    return !isObject(x) ? undefined : x[Symbol.iterator];
  }
  function isConstructor(x) {
    return isCallable(x);
  }
  function createIteratorResultObject(value, done) {
    return {
      value: value,
      done: done
    };
  }
  function maybeDefine(object, name, descr) {
    if (!(name in object)) {
      Object.defineProperty(object, name, descr);
    }
  }
  function maybeDefineMethod(object, name, value) {
    maybeDefine(object, name, {
      value: value,
      configurable: true,
      enumerable: false,
      writable: true
    });
  }
  function maybeDefineConst(object, name, value) {
    maybeDefine(object, name, {
      value: value,
      configurable: false,
      enumerable: false,
      writable: false
    });
  }
  function maybeAddFunctions(object, functions) {
    for (var i = 0; i < functions.length; i += 2) {
      var name = functions[i];
      var value = functions[i + 1];
      maybeDefineMethod(object, name, value);
    }
  }
  function maybeAddConsts(object, consts) {
    for (var i = 0; i < consts.length; i += 2) {
      var name = consts[i];
      var value = consts[i + 1];
      maybeDefineConst(object, name, value);
    }
  }
  function maybeAddIterator(object, func, Symbol) {
    if (!Symbol || !Symbol.iterator || object[Symbol.iterator])
      return;
    if (object['@@iterator'])
      func = object['@@iterator'];
    Object.defineProperty(object, Symbol.iterator, {
      value: func,
      configurable: true,
      enumerable: false,
      writable: true
    });
  }
  var polyfills = [];
  function registerPolyfill(func) {
    polyfills.push(func);
  }
  function polyfillAll(global) {
    polyfills.forEach((function(f) {
      return f(global);
    }));
  }
  return {
    get toObject() {
      return toObject;
    },
    get toUint32() {
      return toUint32;
    },
    get isObject() {
      return isObject;
    },
    get isCallable() {
      return isCallable;
    },
    get isNumber() {
      return isNumber;
    },
    get toInteger() {
      return toInteger;
    },
    get toLength() {
      return toLength;
    },
    get checkIterable() {
      return checkIterable;
    },
    get isConstructor() {
      return isConstructor;
    },
    get createIteratorResultObject() {
      return createIteratorResultObject;
    },
    get maybeDefine() {
      return maybeDefine;
    },
    get maybeDefineMethod() {
      return maybeDefineMethod;
    },
    get maybeDefineConst() {
      return maybeDefineConst;
    },
    get maybeAddFunctions() {
      return maybeAddFunctions;
    },
    get maybeAddConsts() {
      return maybeAddConsts;
    },
    get maybeAddIterator() {
      return maybeAddIterator;
    },
    get registerPolyfill() {
      return registerPolyfill;
    },
    get polyfillAll() {
      return polyfillAll;
    }
  };
});
System.registerModule("traceur@0.0.80/src/runtime/polyfills/Map.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/Map.js";
  var $__0 = System.get("traceur@0.0.80/src/runtime/polyfills/utils.js"),
      isObject = $__0.isObject,
      maybeAddIterator = $__0.maybeAddIterator,
      registerPolyfill = $__0.registerPolyfill;
  var getOwnHashObject = $traceurRuntime.getOwnHashObject;
  var $hasOwnProperty = Object.prototype.hasOwnProperty;
  var deletedSentinel = {};
  function lookupIndex(map, key) {
    if (isObject(key)) {
      var hashObject = getOwnHashObject(key);
      return hashObject && map.objectIndex_[hashObject.hash];
    }
    if (typeof key === 'string')
      return map.stringIndex_[key];
    return map.primitiveIndex_[key];
  }
  function initMap(map) {
    map.entries_ = [];
    map.objectIndex_ = Object.create(null);
    map.stringIndex_ = Object.create(null);
    map.primitiveIndex_ = Object.create(null);
    map.deletedCount_ = 0;
  }
  var Map = function Map() {
    var iterable = arguments[0];
    if (!isObject(this))
      throw new TypeError('Map called on incompatible type');
    if ($hasOwnProperty.call(this, 'entries_')) {
      throw new TypeError('Map can not be reentrantly initialised');
    }
    initMap(this);
    if (iterable !== null && iterable !== undefined) {
      for (var $__2 = iterable[$traceurRuntime.toProperty(Symbol.iterator)](),
          $__3; !($__3 = $__2.next()).done; ) {
        var $__4 = $__3.value,
            key = $__4[0],
            value = $__4[1];
        {
          this.set(key, value);
        }
      }
    }
  };
  ($traceurRuntime.createClass)(Map, {
    get size() {
      return this.entries_.length / 2 - this.deletedCount_;
    },
    get: function(key) {
      var index = lookupIndex(this, key);
      if (index !== undefined)
        return this.entries_[index + 1];
    },
    set: function(key, value) {
      var objectMode = isObject(key);
      var stringMode = typeof key === 'string';
      var index = lookupIndex(this, key);
      if (index !== undefined) {
        this.entries_[index + 1] = value;
      } else {
        index = this.entries_.length;
        this.entries_[index] = key;
        this.entries_[index + 1] = value;
        if (objectMode) {
          var hashObject = getOwnHashObject(key);
          var hash = hashObject.hash;
          this.objectIndex_[hash] = index;
        } else if (stringMode) {
          this.stringIndex_[key] = index;
        } else {
          this.primitiveIndex_[key] = index;
        }
      }
      return this;
    },
    has: function(key) {
      return lookupIndex(this, key) !== undefined;
    },
    delete: function(key) {
      var objectMode = isObject(key);
      var stringMode = typeof key === 'string';
      var index;
      var hash;
      if (objectMode) {
        var hashObject = getOwnHashObject(key);
        if (hashObject) {
          index = this.objectIndex_[hash = hashObject.hash];
          delete this.objectIndex_[hash];
        }
      } else if (stringMode) {
        index = this.stringIndex_[key];
        delete this.stringIndex_[key];
      } else {
        index = this.primitiveIndex_[key];
        delete this.primitiveIndex_[key];
      }
      if (index !== undefined) {
        this.entries_[index] = deletedSentinel;
        this.entries_[index + 1] = undefined;
        this.deletedCount_++;
        return true;
      }
      return false;
    },
    clear: function() {
      initMap(this);
    },
    forEach: function(callbackFn) {
      var thisArg = arguments[1];
      for (var i = 0; i < this.entries_.length; i += 2) {
        var key = this.entries_[i];
        var value = this.entries_[i + 1];
        if (key === deletedSentinel)
          continue;
        callbackFn.call(thisArg, value, key, this);
      }
    },
    entries: $traceurRuntime.initGeneratorFunction(function $__5() {
      var i,
          key,
          value;
      return $traceurRuntime.createGeneratorInstance(function($ctx) {
        while (true)
          switch ($ctx.state) {
            case 0:
              i = 0;
              $ctx.state = 12;
              break;
            case 12:
              $ctx.state = (i < this.entries_.length) ? 8 : -2;
              break;
            case 4:
              i += 2;
              $ctx.state = 12;
              break;
            case 8:
              key = this.entries_[i];
              value = this.entries_[i + 1];
              $ctx.state = 9;
              break;
            case 9:
              $ctx.state = (key === deletedSentinel) ? 4 : 6;
              break;
            case 6:
              $ctx.state = 2;
              return [key, value];
            case 2:
              $ctx.maybeThrow();
              $ctx.state = 4;
              break;
            default:
              return $ctx.end();
          }
      }, $__5, this);
    }),
    keys: $traceurRuntime.initGeneratorFunction(function $__6() {
      var i,
          key,
          value;
      return $traceurRuntime.createGeneratorInstance(function($ctx) {
        while (true)
          switch ($ctx.state) {
            case 0:
              i = 0;
              $ctx.state = 12;
              break;
            case 12:
              $ctx.state = (i < this.entries_.length) ? 8 : -2;
              break;
            case 4:
              i += 2;
              $ctx.state = 12;
              break;
            case 8:
              key = this.entries_[i];
              value = this.entries_[i + 1];
              $ctx.state = 9;
              break;
            case 9:
              $ctx.state = (key === deletedSentinel) ? 4 : 6;
              break;
            case 6:
              $ctx.state = 2;
              return key;
            case 2:
              $ctx.maybeThrow();
              $ctx.state = 4;
              break;
            default:
              return $ctx.end();
          }
      }, $__6, this);
    }),
    values: $traceurRuntime.initGeneratorFunction(function $__7() {
      var i,
          key,
          value;
      return $traceurRuntime.createGeneratorInstance(function($ctx) {
        while (true)
          switch ($ctx.state) {
            case 0:
              i = 0;
              $ctx.state = 12;
              break;
            case 12:
              $ctx.state = (i < this.entries_.length) ? 8 : -2;
              break;
            case 4:
              i += 2;
              $ctx.state = 12;
              break;
            case 8:
              key = this.entries_[i];
              value = this.entries_[i + 1];
              $ctx.state = 9;
              break;
            case 9:
              $ctx.state = (key === deletedSentinel) ? 4 : 6;
              break;
            case 6:
              $ctx.state = 2;
              return value;
            case 2:
              $ctx.maybeThrow();
              $ctx.state = 4;
              break;
            default:
              return $ctx.end();
          }
      }, $__7, this);
    })
  }, {});
  Object.defineProperty(Map.prototype, Symbol.iterator, {
    configurable: true,
    writable: true,
    value: Map.prototype.entries
  });
  function polyfillMap(global) {
    var $__4 = global,
        Object = $__4.Object,
        Symbol = $__4.Symbol;
    if (!global.Map)
      global.Map = Map;
    var mapPrototype = global.Map.prototype;
    if (mapPrototype.entries === undefined)
      global.Map = Map;
    if (mapPrototype.entries) {
      maybeAddIterator(mapPrototype, mapPrototype.entries, Symbol);
      maybeAddIterator(Object.getPrototypeOf(new global.Map().entries()), function() {
        return this;
      }, Symbol);
    }
  }
  registerPolyfill(polyfillMap);
  return {
    get Map() {
      return Map;
    },
    get polyfillMap() {
      return polyfillMap;
    }
  };
});
System.get("traceur@0.0.80/src/runtime/polyfills/Map.js" + '');
System.registerModule("traceur@0.0.80/src/runtime/polyfills/Set.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/Set.js";
  var $__0 = System.get("traceur@0.0.80/src/runtime/polyfills/utils.js"),
      isObject = $__0.isObject,
      maybeAddIterator = $__0.maybeAddIterator,
      registerPolyfill = $__0.registerPolyfill;
  var Map = System.get("traceur@0.0.80/src/runtime/polyfills/Map.js").Map;
  var getOwnHashObject = $traceurRuntime.getOwnHashObject;
  var $hasOwnProperty = Object.prototype.hasOwnProperty;
  function initSet(set) {
    set.map_ = new Map();
  }
  var Set = function Set() {
    var iterable = arguments[0];
    if (!isObject(this))
      throw new TypeError('Set called on incompatible type');
    if ($hasOwnProperty.call(this, 'map_')) {
      throw new TypeError('Set can not be reentrantly initialised');
    }
    initSet(this);
    if (iterable !== null && iterable !== undefined) {
      for (var $__4 = iterable[$traceurRuntime.toProperty(Symbol.iterator)](),
          $__5; !($__5 = $__4.next()).done; ) {
        var item = $__5.value;
        {
          this.add(item);
        }
      }
    }
  };
  ($traceurRuntime.createClass)(Set, {
    get size() {
      return this.map_.size;
    },
    has: function(key) {
      return this.map_.has(key);
    },
    add: function(key) {
      this.map_.set(key, key);
      return this;
    },
    delete: function(key) {
      return this.map_.delete(key);
    },
    clear: function() {
      return this.map_.clear();
    },
    forEach: function(callbackFn) {
      var thisArg = arguments[1];
      var $__2 = this;
      return this.map_.forEach((function(value, key) {
        callbackFn.call(thisArg, key, key, $__2);
      }));
    },
    values: $traceurRuntime.initGeneratorFunction(function $__7() {
      var $__8,
          $__9;
      return $traceurRuntime.createGeneratorInstance(function($ctx) {
        while (true)
          switch ($ctx.state) {
            case 0:
              $__8 = this.map_.keys()[Symbol.iterator]();
              $ctx.sent = void 0;
              $ctx.action = 'next';
              $ctx.state = 12;
              break;
            case 12:
              $__9 = $__8[$ctx.action]($ctx.sentIgnoreThrow);
              $ctx.state = 9;
              break;
            case 9:
              $ctx.state = ($__9.done) ? 3 : 2;
              break;
            case 3:
              $ctx.sent = $__9.value;
              $ctx.state = -2;
              break;
            case 2:
              $ctx.state = 12;
              return $__9.value;
            default:
              return $ctx.end();
          }
      }, $__7, this);
    }),
    entries: $traceurRuntime.initGeneratorFunction(function $__10() {
      var $__11,
          $__12;
      return $traceurRuntime.createGeneratorInstance(function($ctx) {
        while (true)
          switch ($ctx.state) {
            case 0:
              $__11 = this.map_.entries()[Symbol.iterator]();
              $ctx.sent = void 0;
              $ctx.action = 'next';
              $ctx.state = 12;
              break;
            case 12:
              $__12 = $__11[$ctx.action]($ctx.sentIgnoreThrow);
              $ctx.state = 9;
              break;
            case 9:
              $ctx.state = ($__12.done) ? 3 : 2;
              break;
            case 3:
              $ctx.sent = $__12.value;
              $ctx.state = -2;
              break;
            case 2:
              $ctx.state = 12;
              return $__12.value;
            default:
              return $ctx.end();
          }
      }, $__10, this);
    })
  }, {});
  Object.defineProperty(Set.prototype, Symbol.iterator, {
    configurable: true,
    writable: true,
    value: Set.prototype.values
  });
  Object.defineProperty(Set.prototype, 'keys', {
    configurable: true,
    writable: true,
    value: Set.prototype.values
  });
  function polyfillSet(global) {
    var $__6 = global,
        Object = $__6.Object,
        Symbol = $__6.Symbol;
    if (!global.Set)
      global.Set = Set;
    var setPrototype = global.Set.prototype;
    if (setPrototype.values) {
      maybeAddIterator(setPrototype, setPrototype.values, Symbol);
      maybeAddIterator(Object.getPrototypeOf(new global.Set().values()), function() {
        return this;
      }, Symbol);
    }
  }
  registerPolyfill(polyfillSet);
  return {
    get Set() {
      return Set;
    },
    get polyfillSet() {
      return polyfillSet;
    }
  };
});
System.get("traceur@0.0.80/src/runtime/polyfills/Set.js" + '');
System.registerModule("traceur@0.0.80/node_modules/rsvp/lib/rsvp/asap.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/node_modules/rsvp/lib/rsvp/asap.js";
  var len = 0;
  function asap(callback, arg) {
    queue[len] = callback;
    queue[len + 1] = arg;
    len += 2;
    if (len === 2) {
      scheduleFlush();
    }
  }
  var $__default = asap;
  var browserWindow = (typeof window !== 'undefined') ? window : undefined;
  var browserGlobal = browserWindow || {};
  var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
  var isNode = typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
  var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';
  function useNextTick() {
    var nextTick = process.nextTick;
    var version = process.versions.node.match(/^(?:(\d+)\.)?(?:(\d+)\.)?(\*|\d+)$/);
    if (Array.isArray(version) && version[1] === '0' && version[2] === '10') {
      nextTick = setImmediate;
    }
    return function() {
      nextTick(flush);
    };
  }
  function useVertxTimer() {
    return function() {
      vertxNext(flush);
    };
  }
  function useMutationObserver() {
    var iterations = 0;
    var observer = new BrowserMutationObserver(flush);
    var node = document.createTextNode('');
    observer.observe(node, {characterData: true});
    return function() {
      node.data = (iterations = ++iterations % 2);
    };
  }
  function useMessageChannel() {
    var channel = new MessageChannel();
    channel.port1.onmessage = flush;
    return function() {
      channel.port2.postMessage(0);
    };
  }
  function useSetTimeout() {
    return function() {
      setTimeout(flush, 1);
    };
  }
  var queue = new Array(1000);
  function flush() {
    for (var i = 0; i < len; i += 2) {
      var callback = queue[i];
      var arg = queue[i + 1];
      callback(arg);
      queue[i] = undefined;
      queue[i + 1] = undefined;
    }
    len = 0;
  }
  function attemptVertex() {
    try {
      var vertx = require('vertx');
      var vertxNext = vertx.runOnLoop || vertx.runOnContext;
      return useVertxTimer();
    } catch (e) {
      return useSetTimeout();
    }
  }
  var scheduleFlush;
  if (isNode) {
    scheduleFlush = useNextTick();
  } else if (BrowserMutationObserver) {
    scheduleFlush = useMutationObserver();
  } else if (isWorker) {
    scheduleFlush = useMessageChannel();
  } else if (browserWindow === undefined && typeof require === 'function') {
    scheduleFlush = attemptVertex();
  } else {
    scheduleFlush = useSetTimeout();
  }
  return {get default() {
      return $__default;
    }};
});
System.registerModule("traceur@0.0.80/src/runtime/polyfills/Promise.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/Promise.js";
  var async = System.get("traceur@0.0.80/node_modules/rsvp/lib/rsvp/asap.js").default;
  var registerPolyfill = System.get("traceur@0.0.80/src/runtime/polyfills/utils.js").registerPolyfill;
  var promiseRaw = {};
  function isPromise(x) {
    return x && typeof x === 'object' && x.status_ !== undefined;
  }
  function idResolveHandler(x) {
    return x;
  }
  function idRejectHandler(x) {
    throw x;
  }
  function chain(promise) {
    var onResolve = arguments[1] !== (void 0) ? arguments[1] : idResolveHandler;
    var onReject = arguments[2] !== (void 0) ? arguments[2] : idRejectHandler;
    var deferred = getDeferred(promise.constructor);
    switch (promise.status_) {
      case undefined:
        throw TypeError;
      case 0:
        promise.onResolve_.push(onResolve, deferred);
        promise.onReject_.push(onReject, deferred);
        break;
      case +1:
        promiseEnqueue(promise.value_, [onResolve, deferred]);
        break;
      case -1:
        promiseEnqueue(promise.value_, [onReject, deferred]);
        break;
    }
    return deferred.promise;
  }
  function getDeferred(C) {
    if (this === $Promise) {
      var promise = promiseInit(new $Promise(promiseRaw));
      return {
        promise: promise,
        resolve: (function(x) {
          promiseResolve(promise, x);
        }),
        reject: (function(r) {
          promiseReject(promise, r);
        })
      };
    } else {
      var result = {};
      result.promise = new C((function(resolve, reject) {
        result.resolve = resolve;
        result.reject = reject;
      }));
      return result;
    }
  }
  function promiseSet(promise, status, value, onResolve, onReject) {
    promise.status_ = status;
    promise.value_ = value;
    promise.onResolve_ = onResolve;
    promise.onReject_ = onReject;
    return promise;
  }
  function promiseInit(promise) {
    return promiseSet(promise, 0, undefined, [], []);
  }
  var Promise = function Promise(resolver) {
    if (resolver === promiseRaw)
      return;
    if (typeof resolver !== 'function')
      throw new TypeError;
    var promise = promiseInit(this);
    try {
      resolver((function(x) {
        promiseResolve(promise, x);
      }), (function(r) {
        promiseReject(promise, r);
      }));
    } catch (e) {
      promiseReject(promise, e);
    }
  };
  ($traceurRuntime.createClass)(Promise, {
    catch: function(onReject) {
      return this.then(undefined, onReject);
    },
    then: function(onResolve, onReject) {
      if (typeof onResolve !== 'function')
        onResolve = idResolveHandler;
      if (typeof onReject !== 'function')
        onReject = idRejectHandler;
      var that = this;
      var constructor = this.constructor;
      return chain(this, function(x) {
        x = promiseCoerce(constructor, x);
        return x === that ? onReject(new TypeError) : isPromise(x) ? x.then(onResolve, onReject) : onResolve(x);
      }, onReject);
    }
  }, {
    resolve: function(x) {
      if (this === $Promise) {
        if (isPromise(x)) {
          return x;
        }
        return promiseSet(new $Promise(promiseRaw), +1, x);
      } else {
        return new this(function(resolve, reject) {
          resolve(x);
        });
      }
    },
    reject: function(r) {
      if (this === $Promise) {
        return promiseSet(new $Promise(promiseRaw), -1, r);
      } else {
        return new this((function(resolve, reject) {
          reject(r);
        }));
      }
    },
    all: function(values) {
      var deferred = getDeferred(this);
      var resolutions = [];
      try {
        var count = values.length;
        if (count === 0) {
          deferred.resolve(resolutions);
        } else {
          for (var i = 0; i < values.length; i++) {
            this.resolve(values[i]).then(function(i, x) {
              resolutions[i] = x;
              if (--count === 0)
                deferred.resolve(resolutions);
            }.bind(undefined, i), (function(r) {
              deferred.reject(r);
            }));
          }
        }
      } catch (e) {
        deferred.reject(e);
      }
      return deferred.promise;
    },
    race: function(values) {
      var deferred = getDeferred(this);
      try {
        for (var i = 0; i < values.length; i++) {
          this.resolve(values[i]).then((function(x) {
            deferred.resolve(x);
          }), (function(r) {
            deferred.reject(r);
          }));
        }
      } catch (e) {
        deferred.reject(e);
      }
      return deferred.promise;
    }
  });
  var $Promise = Promise;
  var $PromiseReject = $Promise.reject;
  function promiseResolve(promise, x) {
    promiseDone(promise, +1, x, promise.onResolve_);
  }
  function promiseReject(promise, r) {
    promiseDone(promise, -1, r, promise.onReject_);
  }
  function promiseDone(promise, status, value, reactions) {
    if (promise.status_ !== 0)
      return;
    promiseEnqueue(value, reactions);
    promiseSet(promise, status, value);
  }
  function promiseEnqueue(value, tasks) {
    async((function() {
      for (var i = 0; i < tasks.length; i += 2) {
        promiseHandle(value, tasks[i], tasks[i + 1]);
      }
    }));
  }
  function promiseHandle(value, handler, deferred) {
    try {
      var result = handler(value);
      if (result === deferred.promise)
        throw new TypeError;
      else if (isPromise(result))
        chain(result, deferred.resolve, deferred.reject);
      else
        deferred.resolve(result);
    } catch (e) {
      try {
        deferred.reject(e);
      } catch (e) {}
    }
  }
  var thenableSymbol = '@@thenable';
  function isObject(x) {
    return x && (typeof x === 'object' || typeof x === 'function');
  }
  function promiseCoerce(constructor, x) {
    if (!isPromise(x) && isObject(x)) {
      var then;
      try {
        then = x.then;
      } catch (r) {
        var promise = $PromiseReject.call(constructor, r);
        x[thenableSymbol] = promise;
        return promise;
      }
      if (typeof then === 'function') {
        var p = x[thenableSymbol];
        if (p) {
          return p;
        } else {
          var deferred = getDeferred(constructor);
          x[thenableSymbol] = deferred.promise;
          try {
            then.call(x, deferred.resolve, deferred.reject);
          } catch (r) {
            deferred.reject(r);
          }
          return deferred.promise;
        }
      }
    }
    return x;
  }
  function polyfillPromise(global) {
    if (!global.Promise)
      global.Promise = Promise;
  }
  registerPolyfill(polyfillPromise);
  return {
    get Promise() {
      return Promise;
    },
    get polyfillPromise() {
      return polyfillPromise;
    }
  };
});
System.get("traceur@0.0.80/src/runtime/polyfills/Promise.js" + '');
System.registerModule("traceur@0.0.80/src/runtime/polyfills/StringIterator.js", [], function() {
  "use strict";
  var $__2;
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/StringIterator.js";
  var $__0 = System.get("traceur@0.0.80/src/runtime/polyfills/utils.js"),
      createIteratorResultObject = $__0.createIteratorResultObject,
      isObject = $__0.isObject;
  var toProperty = $traceurRuntime.toProperty;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var iteratedString = Symbol('iteratedString');
  var stringIteratorNextIndex = Symbol('stringIteratorNextIndex');
  var StringIterator = function StringIterator() {};
  ($traceurRuntime.createClass)(StringIterator, ($__2 = {}, Object.defineProperty($__2, "next", {
    value: function() {
      var o = this;
      if (!isObject(o) || !hasOwnProperty.call(o, iteratedString)) {
        throw new TypeError('this must be a StringIterator object');
      }
      var s = o[toProperty(iteratedString)];
      if (s === undefined) {
        return createIteratorResultObject(undefined, true);
      }
      var position = o[toProperty(stringIteratorNextIndex)];
      var len = s.length;
      if (position >= len) {
        o[toProperty(iteratedString)] = undefined;
        return createIteratorResultObject(undefined, true);
      }
      var first = s.charCodeAt(position);
      var resultString;
      if (first < 0xD800 || first > 0xDBFF || position + 1 === len) {
        resultString = String.fromCharCode(first);
      } else {
        var second = s.charCodeAt(position + 1);
        if (second < 0xDC00 || second > 0xDFFF) {
          resultString = String.fromCharCode(first);
        } else {
          resultString = String.fromCharCode(first) + String.fromCharCode(second);
        }
      }
      o[toProperty(stringIteratorNextIndex)] = position + resultString.length;
      return createIteratorResultObject(resultString, false);
    },
    configurable: true,
    enumerable: true,
    writable: true
  }), Object.defineProperty($__2, Symbol.iterator, {
    value: function() {
      return this;
    },
    configurable: true,
    enumerable: true,
    writable: true
  }), $__2), {});
  function createStringIterator(string) {
    var s = String(string);
    var iterator = Object.create(StringIterator.prototype);
    iterator[toProperty(iteratedString)] = s;
    iterator[toProperty(stringIteratorNextIndex)] = 0;
    return iterator;
  }
  return {get createStringIterator() {
      return createStringIterator;
    }};
});
System.registerModule("traceur@0.0.80/src/runtime/polyfills/String.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/String.js";
  var createStringIterator = System.get("traceur@0.0.80/src/runtime/polyfills/StringIterator.js").createStringIterator;
  var $__1 = System.get("traceur@0.0.80/src/runtime/polyfills/utils.js"),
      maybeAddFunctions = $__1.maybeAddFunctions,
      maybeAddIterator = $__1.maybeAddIterator,
      registerPolyfill = $__1.registerPolyfill;
  var $toString = Object.prototype.toString;
  var $indexOf = String.prototype.indexOf;
  var $lastIndexOf = String.prototype.lastIndexOf;
  function startsWith(search) {
    var string = String(this);
    if (this == null || $toString.call(search) == '[object RegExp]') {
      throw TypeError();
    }
    var stringLength = string.length;
    var searchString = String(search);
    var searchLength = searchString.length;
    var position = arguments.length > 1 ? arguments[1] : undefined;
    var pos = position ? Number(position) : 0;
    if (isNaN(pos)) {
      pos = 0;
    }
    var start = Math.min(Math.max(pos, 0), stringLength);
    return $indexOf.call(string, searchString, pos) == start;
  }
  function endsWith(search) {
    var string = String(this);
    if (this == null || $toString.call(search) == '[object RegExp]') {
      throw TypeError();
    }
    var stringLength = string.length;
    var searchString = String(search);
    var searchLength = searchString.length;
    var pos = stringLength;
    if (arguments.length > 1) {
      var position = arguments[1];
      if (position !== undefined) {
        pos = position ? Number(position) : 0;
        if (isNaN(pos)) {
          pos = 0;
        }
      }
    }
    var end = Math.min(Math.max(pos, 0), stringLength);
    var start = end - searchLength;
    if (start < 0) {
      return false;
    }
    return $lastIndexOf.call(string, searchString, start) == start;
  }
  function includes(search) {
    if (this == null) {
      throw TypeError();
    }
    var string = String(this);
    if (search && $toString.call(search) == '[object RegExp]') {
      throw TypeError();
    }
    var stringLength = string.length;
    var searchString = String(search);
    var searchLength = searchString.length;
    var position = arguments.length > 1 ? arguments[1] : undefined;
    var pos = position ? Number(position) : 0;
    if (pos != pos) {
      pos = 0;
    }
    var start = Math.min(Math.max(pos, 0), stringLength);
    if (searchLength + start > stringLength) {
      return false;
    }
    return $indexOf.call(string, searchString, pos) != -1;
  }
  function repeat(count) {
    if (this == null) {
      throw TypeError();
    }
    var string = String(this);
    var n = count ? Number(count) : 0;
    if (isNaN(n)) {
      n = 0;
    }
    if (n < 0 || n == Infinity) {
      throw RangeError();
    }
    if (n == 0) {
      return '';
    }
    var result = '';
    while (n--) {
      result += string;
    }
    return result;
  }
  function codePointAt(position) {
    if (this == null) {
      throw TypeError();
    }
    var string = String(this);
    var size = string.length;
    var index = position ? Number(position) : 0;
    if (isNaN(index)) {
      index = 0;
    }
    if (index < 0 || index >= size) {
      return undefined;
    }
    var first = string.charCodeAt(index);
    var second;
    if (first >= 0xD800 && first <= 0xDBFF && size > index + 1) {
      second = string.charCodeAt(index + 1);
      if (second >= 0xDC00 && second <= 0xDFFF) {
        return (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;
      }
    }
    return first;
  }
  function raw(callsite) {
    var raw = callsite.raw;
    var len = raw.length >>> 0;
    if (len === 0)
      return '';
    var s = '';
    var i = 0;
    while (true) {
      s += raw[i];
      if (i + 1 === len)
        return s;
      s += arguments[++i];
    }
  }
  function fromCodePoint() {
    var codeUnits = [];
    var floor = Math.floor;
    var highSurrogate;
    var lowSurrogate;
    var index = -1;
    var length = arguments.length;
    if (!length) {
      return '';
    }
    while (++index < length) {
      var codePoint = Number(arguments[index]);
      if (!isFinite(codePoint) || codePoint < 0 || codePoint > 0x10FFFF || floor(codePoint) != codePoint) {
        throw RangeError('Invalid code point: ' + codePoint);
      }
      if (codePoint <= 0xFFFF) {
        codeUnits.push(codePoint);
      } else {
        codePoint -= 0x10000;
        highSurrogate = (codePoint >> 10) + 0xD800;
        lowSurrogate = (codePoint % 0x400) + 0xDC00;
        codeUnits.push(highSurrogate, lowSurrogate);
      }
    }
    return String.fromCharCode.apply(null, codeUnits);
  }
  function stringPrototypeIterator() {
    var o = $traceurRuntime.checkObjectCoercible(this);
    var s = String(o);
    return createStringIterator(s);
  }
  function polyfillString(global) {
    var String = global.String;
    maybeAddFunctions(String.prototype, ['codePointAt', codePointAt, 'endsWith', endsWith, 'includes', includes, 'repeat', repeat, 'startsWith', startsWith]);
    maybeAddFunctions(String, ['fromCodePoint', fromCodePoint, 'raw', raw]);
    maybeAddIterator(String.prototype, stringPrototypeIterator, Symbol);
  }
  registerPolyfill(polyfillString);
  return {
    get startsWith() {
      return startsWith;
    },
    get endsWith() {
      return endsWith;
    },
    get includes() {
      return includes;
    },
    get repeat() {
      return repeat;
    },
    get codePointAt() {
      return codePointAt;
    },
    get raw() {
      return raw;
    },
    get fromCodePoint() {
      return fromCodePoint;
    },
    get stringPrototypeIterator() {
      return stringPrototypeIterator;
    },
    get polyfillString() {
      return polyfillString;
    }
  };
});
System.get("traceur@0.0.80/src/runtime/polyfills/String.js" + '');
System.registerModule("traceur@0.0.80/src/runtime/polyfills/ArrayIterator.js", [], function() {
  "use strict";
  var $__2;
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/ArrayIterator.js";
  var $__0 = System.get("traceur@0.0.80/src/runtime/polyfills/utils.js"),
      toObject = $__0.toObject,
      toUint32 = $__0.toUint32,
      createIteratorResultObject = $__0.createIteratorResultObject;
  var ARRAY_ITERATOR_KIND_KEYS = 1;
  var ARRAY_ITERATOR_KIND_VALUES = 2;
  var ARRAY_ITERATOR_KIND_ENTRIES = 3;
  var ArrayIterator = function ArrayIterator() {};
  ($traceurRuntime.createClass)(ArrayIterator, ($__2 = {}, Object.defineProperty($__2, "next", {
    value: function() {
      var iterator = toObject(this);
      var array = iterator.iteratorObject_;
      if (!array) {
        throw new TypeError('Object is not an ArrayIterator');
      }
      var index = iterator.arrayIteratorNextIndex_;
      var itemKind = iterator.arrayIterationKind_;
      var length = toUint32(array.length);
      if (index >= length) {
        iterator.arrayIteratorNextIndex_ = Infinity;
        return createIteratorResultObject(undefined, true);
      }
      iterator.arrayIteratorNextIndex_ = index + 1;
      if (itemKind == ARRAY_ITERATOR_KIND_VALUES)
        return createIteratorResultObject(array[index], false);
      if (itemKind == ARRAY_ITERATOR_KIND_ENTRIES)
        return createIteratorResultObject([index, array[index]], false);
      return createIteratorResultObject(index, false);
    },
    configurable: true,
    enumerable: true,
    writable: true
  }), Object.defineProperty($__2, Symbol.iterator, {
    value: function() {
      return this;
    },
    configurable: true,
    enumerable: true,
    writable: true
  }), $__2), {});
  function createArrayIterator(array, kind) {
    var object = toObject(array);
    var iterator = new ArrayIterator;
    iterator.iteratorObject_ = object;
    iterator.arrayIteratorNextIndex_ = 0;
    iterator.arrayIterationKind_ = kind;
    return iterator;
  }
  function entries() {
    return createArrayIterator(this, ARRAY_ITERATOR_KIND_ENTRIES);
  }
  function keys() {
    return createArrayIterator(this, ARRAY_ITERATOR_KIND_KEYS);
  }
  function values() {
    return createArrayIterator(this, ARRAY_ITERATOR_KIND_VALUES);
  }
  return {
    get entries() {
      return entries;
    },
    get keys() {
      return keys;
    },
    get values() {
      return values;
    }
  };
});
System.registerModule("traceur@0.0.80/src/runtime/polyfills/Array.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/Array.js";
  var $__0 = System.get("traceur@0.0.80/src/runtime/polyfills/ArrayIterator.js"),
      entries = $__0.entries,
      keys = $__0.keys,
      values = $__0.values;
  var $__1 = System.get("traceur@0.0.80/src/runtime/polyfills/utils.js"),
      checkIterable = $__1.checkIterable,
      isCallable = $__1.isCallable,
      isConstructor = $__1.isConstructor,
      maybeAddFunctions = $__1.maybeAddFunctions,
      maybeAddIterator = $__1.maybeAddIterator,
      registerPolyfill = $__1.registerPolyfill,
      toInteger = $__1.toInteger,
      toLength = $__1.toLength,
      toObject = $__1.toObject;
  function from(arrLike) {
    var mapFn = arguments[1];
    var thisArg = arguments[2];
    var C = this;
    var items = toObject(arrLike);
    var mapping = mapFn !== undefined;
    var k = 0;
    var arr,
        len;
    if (mapping && !isCallable(mapFn)) {
      throw TypeError();
    }
    if (checkIterable(items)) {
      arr = isConstructor(C) ? new C() : [];
      for (var $__2 = items[$traceurRuntime.toProperty(Symbol.iterator)](),
          $__3; !($__3 = $__2.next()).done; ) {
        var item = $__3.value;
        {
          if (mapping) {
            arr[k] = mapFn.call(thisArg, item, k);
          } else {
            arr[k] = item;
          }
          k++;
        }
      }
      arr.length = k;
      return arr;
    }
    len = toLength(items.length);
    arr = isConstructor(C) ? new C(len) : new Array(len);
    for (; k < len; k++) {
      if (mapping) {
        arr[k] = typeof thisArg === 'undefined' ? mapFn(items[k], k) : mapFn.call(thisArg, items[k], k);
      } else {
        arr[k] = items[k];
      }
    }
    arr.length = len;
    return arr;
  }
  function of() {
    for (var items = [],
        $__4 = 0; $__4 < arguments.length; $__4++)
      items[$__4] = arguments[$__4];
    var C = this;
    var len = items.length;
    var arr = isConstructor(C) ? new C(len) : new Array(len);
    for (var k = 0; k < len; k++) {
      arr[k] = items[k];
    }
    arr.length = len;
    return arr;
  }
  function fill(value) {
    var start = arguments[1] !== (void 0) ? arguments[1] : 0;
    var end = arguments[2];
    var object = toObject(this);
    var len = toLength(object.length);
    var fillStart = toInteger(start);
    var fillEnd = end !== undefined ? toInteger(end) : len;
    fillStart = fillStart < 0 ? Math.max(len + fillStart, 0) : Math.min(fillStart, len);
    fillEnd = fillEnd < 0 ? Math.max(len + fillEnd, 0) : Math.min(fillEnd, len);
    while (fillStart < fillEnd) {
      object[fillStart] = value;
      fillStart++;
    }
    return object;
  }
  function find(predicate) {
    var thisArg = arguments[1];
    return findHelper(this, predicate, thisArg);
  }
  function findIndex(predicate) {
    var thisArg = arguments[1];
    return findHelper(this, predicate, thisArg, true);
  }
  function findHelper(self, predicate) {
    var thisArg = arguments[2];
    var returnIndex = arguments[3] !== (void 0) ? arguments[3] : false;
    var object = toObject(self);
    var len = toLength(object.length);
    if (!isCallable(predicate)) {
      throw TypeError();
    }
    for (var i = 0; i < len; i++) {
      var value = object[i];
      if (predicate.call(thisArg, value, i, object)) {
        return returnIndex ? i : value;
      }
    }
    return returnIndex ? -1 : undefined;
  }
  function polyfillArray(global) {
    var $__5 = global,
        Array = $__5.Array,
        Object = $__5.Object,
        Symbol = $__5.Symbol;
    maybeAddFunctions(Array.prototype, ['entries', entries, 'keys', keys, 'values', values, 'fill', fill, 'find', find, 'findIndex', findIndex]);
    maybeAddFunctions(Array, ['from', from, 'of', of]);
    maybeAddIterator(Array.prototype, values, Symbol);
    maybeAddIterator(Object.getPrototypeOf([].values()), function() {
      return this;
    }, Symbol);
  }
  registerPolyfill(polyfillArray);
  return {
    get from() {
      return from;
    },
    get of() {
      return of;
    },
    get fill() {
      return fill;
    },
    get find() {
      return find;
    },
    get findIndex() {
      return findIndex;
    },
    get polyfillArray() {
      return polyfillArray;
    }
  };
});
System.get("traceur@0.0.80/src/runtime/polyfills/Array.js" + '');
System.registerModule("traceur@0.0.80/src/runtime/polyfills/Object.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/Object.js";
  var $__0 = System.get("traceur@0.0.80/src/runtime/polyfills/utils.js"),
      maybeAddFunctions = $__0.maybeAddFunctions,
      registerPolyfill = $__0.registerPolyfill;
  var $__1 = $traceurRuntime,
      defineProperty = $__1.defineProperty,
      getOwnPropertyDescriptor = $__1.getOwnPropertyDescriptor,
      getOwnPropertyNames = $__1.getOwnPropertyNames,
      isPrivateName = $__1.isPrivateName,
      keys = $__1.keys;
  function is(left, right) {
    if (left === right)
      return left !== 0 || 1 / left === 1 / right;
    return left !== left && right !== right;
  }
  function assign(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      var props = source == null ? [] : keys(source);
      var p,
          length = props.length;
      for (p = 0; p < length; p++) {
        var name = props[p];
        if (isPrivateName(name))
          continue;
        target[name] = source[name];
      }
    }
    return target;
  }
  function mixin(target, source) {
    var props = getOwnPropertyNames(source);
    var p,
        descriptor,
        length = props.length;
    for (p = 0; p < length; p++) {
      var name = props[p];
      if (isPrivateName(name))
        continue;
      descriptor = getOwnPropertyDescriptor(source, props[p]);
      defineProperty(target, props[p], descriptor);
    }
    return target;
  }
  function polyfillObject(global) {
    var Object = global.Object;
    maybeAddFunctions(Object, ['assign', assign, 'is', is, 'mixin', mixin]);
  }
  registerPolyfill(polyfillObject);
  return {
    get is() {
      return is;
    },
    get assign() {
      return assign;
    },
    get mixin() {
      return mixin;
    },
    get polyfillObject() {
      return polyfillObject;
    }
  };
});
System.get("traceur@0.0.80/src/runtime/polyfills/Object.js" + '');
System.registerModule("traceur@0.0.80/src/runtime/polyfills/Number.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/Number.js";
  var $__0 = System.get("traceur@0.0.80/src/runtime/polyfills/utils.js"),
      isNumber = $__0.isNumber,
      maybeAddConsts = $__0.maybeAddConsts,
      maybeAddFunctions = $__0.maybeAddFunctions,
      registerPolyfill = $__0.registerPolyfill,
      toInteger = $__0.toInteger;
  var $abs = Math.abs;
  var $isFinite = isFinite;
  var $isNaN = isNaN;
  var MAX_SAFE_INTEGER = Math.pow(2, 53) - 1;
  var MIN_SAFE_INTEGER = -Math.pow(2, 53) + 1;
  var EPSILON = Math.pow(2, -52);
  function NumberIsFinite(number) {
    return isNumber(number) && $isFinite(number);
  }
  ;
  function isInteger(number) {
    return NumberIsFinite(number) && toInteger(number) === number;
  }
  function NumberIsNaN(number) {
    return isNumber(number) && $isNaN(number);
  }
  ;
  function isSafeInteger(number) {
    if (NumberIsFinite(number)) {
      var integral = toInteger(number);
      if (integral === number)
        return $abs(integral) <= MAX_SAFE_INTEGER;
    }
    return false;
  }
  function polyfillNumber(global) {
    var Number = global.Number;
    maybeAddConsts(Number, ['MAX_SAFE_INTEGER', MAX_SAFE_INTEGER, 'MIN_SAFE_INTEGER', MIN_SAFE_INTEGER, 'EPSILON', EPSILON]);
    maybeAddFunctions(Number, ['isFinite', NumberIsFinite, 'isInteger', isInteger, 'isNaN', NumberIsNaN, 'isSafeInteger', isSafeInteger]);
  }
  registerPolyfill(polyfillNumber);
  return {
    get MAX_SAFE_INTEGER() {
      return MAX_SAFE_INTEGER;
    },
    get MIN_SAFE_INTEGER() {
      return MIN_SAFE_INTEGER;
    },
    get EPSILON() {
      return EPSILON;
    },
    get isFinite() {
      return NumberIsFinite;
    },
    get isInteger() {
      return isInteger;
    },
    get isNaN() {
      return NumberIsNaN;
    },
    get isSafeInteger() {
      return isSafeInteger;
    },
    get polyfillNumber() {
      return polyfillNumber;
    }
  };
});
System.get("traceur@0.0.80/src/runtime/polyfills/Number.js" + '');
System.registerModule("traceur@0.0.80/src/runtime/polyfills/polyfills.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/runtime/polyfills/polyfills.js";
  var polyfillAll = System.get("traceur@0.0.80/src/runtime/polyfills/utils.js").polyfillAll;
  polyfillAll(Reflect.global);
  var setupGlobals = $traceurRuntime.setupGlobals;
  $traceurRuntime.setupGlobals = function(global) {
    setupGlobals(global);
    polyfillAll(global);
  };
  return {};
});
System.get("traceur@0.0.80/src/runtime/polyfills/polyfills.js" + '');
System.registerModule("traceur@0.0.80/src/Options.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/Options.js";
  function enumerableOnlyObject(obj) {
    var result = Object.create(null);
    Object.keys(obj).forEach(function(key) {
      Object.defineProperty(result, key, {
        enumerable: true,
        value: obj[key]
      });
    });
    return result;
  }
  var optionsV01 = enumerableOnlyObject({
    annotations: false,
    arrayComprehension: false,
    arrowFunctions: true,
    asyncFunctions: false,
    blockBinding: true,
    classes: true,
    commentCallback: false,
    computedPropertyNames: true,
    debug: false,
    defaultParameters: true,
    destructuring: true,
    exponentiation: false,
    forOf: true,
    freeVariableChecker: false,
    generatorComprehension: false,
    generators: true,
    memberVariables: false,
    moduleName: false,
    modules: 'register',
    numericLiterals: true,
    outputLanguage: 'es5',
    propertyMethods: true,
    propertyNameShorthand: true,
    referrer: '',
    require: false,
    restParameters: true,
    script: false,
    sourceMaps: false,
    spread: true,
    symbols: false,
    templateLiterals: true,
    typeAssertionModule: null,
    typeAssertions: false,
    types: false,
    unicodeEscapeSequences: true,
    unicodeExpressions: true,
    validate: false
  });
  var versionLockedOptions = optionsV01;
  var parseOptions = Object.create(null);
  var transformOptions = Object.create(null);
  var defaultValues = Object.create(null);
  var experimentalOptions = Object.create(null);
  var moduleOptions = ['amd', 'commonjs', 'instantiate', 'inline', 'register'];
  var Options = function Options() {
    var options = arguments[0] !== (void 0) ? arguments[0] : Object.create(null);
    this.reset();
    Object.defineProperties(this, {
      modules_: {
        value: versionLockedOptions.modules,
        writable: true,
        enumerable: false
      },
      sourceMaps_: {
        value: versionLockedOptions.sourceMaps,
        writable: true,
        enumerable: false
      }
    });
    this.setFromObject(options);
  };
  ($traceurRuntime.createClass)(Options, {
    set experimental(v) {
      var $__0 = this;
      v = coerceOptionValue(v);
      Object.keys(experimentalOptions).forEach((function(name) {
        $__0[name] = v;
      }));
    },
    get experimental() {
      var $__0 = this;
      var value;
      Object.keys(experimentalOptions).every((function(name) {
        var currentValue = $__0[name];
        if (value === undefined) {
          value = currentValue;
          return true;
        }
        if (currentValue !== value) {
          value = null;
          return false;
        }
        return true;
      }));
      return value;
    },
    get atscript() {
      return this.types && this.annotations && this.memberVariables;
    },
    set atscript(value) {
      this.types = value;
      this.annotations = value;
      this.memberVariables = value;
    },
    get modules() {
      return this.modules_;
    },
    set modules(value) {
      if (typeof value === 'boolean' && !value)
        value = 'register';
      if (moduleOptions.indexOf(value) === -1) {
        throw new Error('Invalid \'modules\' option \'' + value + '\', not in ' + moduleOptions.join(', '));
      }
      this.modules_ = value;
    },
    get sourceMaps() {
      return this.sourceMaps_;
    },
    set sourceMaps(value) {
      if (value === null || typeof value === 'boolean') {
        this.sourceMaps_ = value ? 'file' : false;
        return;
      }
      if (value === 'file' || value === 'inline' || value === 'memory') {
        this.sourceMaps_ = value;
      } else {
        throw new Error('Option sourceMaps should be ' + '[false|inline|file|memory], not ' + value);
      }
    },
    reset: function() {
      var allOff = arguments[0];
      var $__0 = this;
      var useDefault = allOff === undefined;
      Object.keys(defaultValues).forEach((function(name) {
        $__0[name] = useDefault && defaultValues[name];
      }));
      this.setDefaults();
    },
    setDefaults: function() {
      this.modules = 'register';
      this.moduleName = false;
      this.outputLanguage = 'es5';
      this.referrer = '';
      this.sourceMaps = false;
      this.typeAssertionModule = null;
    },
    setFromObject: function(object) {
      var $__0 = this;
      Object.keys(this).forEach((function(name) {
        if (name in object)
          $__0.setOption(name, object[name]);
      }));
      this.modules = object.modules || this.modules;
      if (typeof object.sourceMaps === 'boolean' || typeof object.sourceMaps === 'string') {
        this.sourceMaps = object.sourceMaps;
      }
      return this;
    },
    setOption: function(name, value) {
      name = toCamelCase(name);
      if (name in this) {
        this[name] = value;
      } else {
        throw Error('Unknown option: ' + name);
      }
    },
    diff: function(ref) {
      var $__0 = this;
      var mismatches = [];
      Object.keys(options).forEach((function(key) {
        if ($__0[key] !== ref[key]) {
          mismatches.push({
            key: key,
            now: traceur.options[key],
            v01: ref[key]
          });
        }
      }));
      return mismatches;
    }
  }, {});
  ;
  var options = new Options();
  var descriptions = {
    experimental: 'Turns on all experimental features',
    require: 'Generate require function argument for node when modules=register',
    sourceMaps: 'Generate source map and (\'file\') write to .map' + ' or (\'inline\') append data URL'
  };
  var CommandOptions = function CommandOptions() {
    $traceurRuntime.superConstructor($CommandOptions).apply(this, arguments);
  };
  var $CommandOptions = CommandOptions;
  ($traceurRuntime.createClass)(CommandOptions, {
    parseCommand: function(s) {
      var re = /--([^=]+)(?:=(.+))?/;
      var m = re.exec(s);
      if (m)
        this.setOptionCoerced(m[1], m[2]);
    },
    setOptionCoerced: function(name, value) {
      if (typeof value !== 'undefined' && value !== null)
        value = coerceOptionValue(value);
      else
        value = true;
      this.setOption(name, value);
    }
  }, {
    fromString: function(s) {
      return $CommandOptions.fromArgv(s.split(/\s+/));
    },
    fromArgv: function(args) {
      var options = new $CommandOptions();
      args.forEach((function(arg) {
        return options.parseCommand(arg);
      }));
      return options;
    }
  }, Options);
  function coerceOptionValue(v) {
    switch (v) {
      case 'false':
        return false;
      case 'true':
      case true:
        return true;
      default:
        return !!v && String(v);
    }
  }
  function addOptions(flags, commandOptions) {
    flags.option('--referrer <name>', 'Bracket output code with System.referrerName=<name>', (function(name) {
      commandOptions.setOption('referrer', name);
      System.map = System.semverMap(name);
      return name;
    }));
    flags.option('--type-assertion-module <path>', 'Absolute path to the type assertion module.', (function(path) {
      commandOptions.setOption('type-assertion-module', path);
      return path;
    }));
    flags.option('--modules <' + moduleOptions.join(', ') + '>', 'select the output format for modules', (function(moduleFormat) {
      commandOptions.modules = moduleFormat;
    }));
    flags.option('--moduleName <string>', '__moduleName value, + sign to use source name, or empty to omit', (function(moduleName) {
      if (moduleName === '+')
        moduleName = true;
      commandOptions.moduleName = moduleName;
    }));
    flags.option('--outputLanguage <es6|es5>', 'compilation target language', (function(outputLanguage) {
      if (outputLanguage === 'es6' || outputLanguage === 'es5')
        commandOptions.outputLanguage = outputLanguage;
      else
        throw new Error('outputLanguage must be one of es5, es6');
    }));
    flags.option('--source-maps [file|inline|memory]', 'sourceMaps generated to file or inline with data: URL', (function(to) {
      return commandOptions.sourceMaps = to;
    }));
    flags.option('--experimental', 'Turns on all experimental features', (function() {
      commandOptions.experimental = true;
    }));
    flags.option('--atscript', 'Turns on all AtScript features', (function() {
      commandOptions.atscript = true;
    }));
    Object.keys(commandOptions).forEach(function(name) {
      var dashedName = toDashCase(name);
      if (flags.optionFor('--' + name) || flags.optionFor('--' + dashedName)) {
        return;
      } else if ((name in parseOptions) && (name in transformOptions)) {
        flags.option('--' + dashedName + ' [true|false|parse]', descriptions[name]);
        flags.on(dashedName, (function(value) {
          return commandOptions.setOptionCoerced(dashedName, value);
        }));
      } else if (commandOptions[name] !== null) {
        flags.option('--' + dashedName, descriptions[name]);
        flags.on(dashedName, (function() {
          return commandOptions.setOption(dashedName, true);
        }));
      } else {
        throw new Error('Unexpected null commandOption ' + name);
      }
    });
    commandOptions.setDefaults();
  }
  function toCamelCase(s) {
    return s.replace(/-\w/g, function(ch) {
      return ch[1].toUpperCase();
    });
  }
  function toDashCase(s) {
    return s.replace(/[A-Z]/g, function(ch) {
      return '-' + ch.toLowerCase();
    });
  }
  var EXPERIMENTAL = 0;
  var ON_BY_DEFAULT = 1;
  function addFeatureOption(name, kind) {
    if (kind === EXPERIMENTAL)
      experimentalOptions[name] = true;
    Object.defineProperty(parseOptions, name, {
      get: function() {
        return !!options[name];
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(transformOptions, name, {
      get: function() {
        var v = options[name];
        if (v === 'parse')
          return false;
        return v;
      },
      enumerable: true,
      configurable: true
    });
    var defaultValue = options[name] || kind === ON_BY_DEFAULT;
    options[name] = defaultValue;
    defaultValues[name] = defaultValue;
  }
  function addBoolOption(name) {
    defaultValues[name] = false;
    options[name] = false;
  }
  addFeatureOption('arrowFunctions', ON_BY_DEFAULT);
  addFeatureOption('blockBinding', ON_BY_DEFAULT);
  addFeatureOption('classes', ON_BY_DEFAULT);
  addFeatureOption('computedPropertyNames', ON_BY_DEFAULT);
  addFeatureOption('defaultParameters', ON_BY_DEFAULT);
  addFeatureOption('destructuring', ON_BY_DEFAULT);
  addFeatureOption('forOf', ON_BY_DEFAULT);
  addFeatureOption('generators', ON_BY_DEFAULT);
  addFeatureOption('modules', 'SPECIAL');
  addFeatureOption('numericLiterals', ON_BY_DEFAULT);
  addFeatureOption('propertyMethods', ON_BY_DEFAULT);
  addFeatureOption('propertyNameShorthand', ON_BY_DEFAULT);
  addFeatureOption('restParameters', ON_BY_DEFAULT);
  addFeatureOption('sourceMaps', 'SPECIAL');
  addFeatureOption('spread', ON_BY_DEFAULT);
  addFeatureOption('templateLiterals', ON_BY_DEFAULT);
  addFeatureOption('unicodeEscapeSequences', ON_BY_DEFAULT);
  addFeatureOption('unicodeExpressions', ON_BY_DEFAULT);
  addFeatureOption('annotations', EXPERIMENTAL);
  addFeatureOption('arrayComprehension', EXPERIMENTAL);
  addFeatureOption('asyncFunctions', EXPERIMENTAL);
  addFeatureOption('exponentiation', EXPERIMENTAL);
  addFeatureOption('generatorComprehension', EXPERIMENTAL);
  addFeatureOption('require', EXPERIMENTAL);
  addFeatureOption('symbols', EXPERIMENTAL);
  addFeatureOption('types', EXPERIMENTAL);
  addFeatureOption('memberVariables', EXPERIMENTAL);
  addBoolOption('commentCallback');
  addBoolOption('debug');
  addBoolOption('freeVariableChecker');
  addBoolOption('script');
  addBoolOption('typeAssertions');
  addBoolOption('validate');
  return {
    get optionsV01() {
      return optionsV01;
    },
    get versionLockedOptions() {
      return versionLockedOptions;
    },
    get parseOptions() {
      return parseOptions;
    },
    get transformOptions() {
      return transformOptions;
    },
    get Options() {
      return Options;
    },
    get options() {
      return options;
    },
    get CommandOptions() {
      return CommandOptions;
    },
    get addOptions() {
      return addOptions;
    },
    get toDashCase() {
      return toDashCase;
    }
  };
});
System.registerModule("traceur@0.0.80/src/syntax/TokenType.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/TokenType.js";
  var AMPERSAND = '&';
  var AMPERSAND_EQUAL = '&=';
  var AND = '&&';
  var ARROW = '=>';
  var AT = '@';
  var BACK_QUOTE = '`';
  var BANG = '!';
  var BAR = '|';
  var BAR_EQUAL = '|=';
  var BREAK = 'break';
  var CARET = '^';
  var CARET_EQUAL = '^=';
  var CASE = 'case';
  var CATCH = 'catch';
  var CLASS = 'class';
  var CLOSE_ANGLE = '>';
  var CLOSE_CURLY = '}';
  var CLOSE_PAREN = ')';
  var CLOSE_SQUARE = ']';
  var COLON = ':';
  var COMMA = ',';
  var CONST = 'const';
  var CONTINUE = 'continue';
  var DEBUGGER = 'debugger';
  var DEFAULT = 'default';
  var DELETE = 'delete';
  var DO = 'do';
  var DOT_DOT_DOT = '...';
  var ELSE = 'else';
  var END_OF_FILE = 'End of File';
  var ENUM = 'enum';
  var EQUAL = '=';
  var EQUAL_EQUAL = '==';
  var EQUAL_EQUAL_EQUAL = '===';
  var ERROR = 'error';
  var EXPORT = 'export';
  var EXTENDS = 'extends';
  var FALSE = 'false';
  var FINALLY = 'finally';
  var FOR = 'for';
  var FUNCTION = 'function';
  var GREATER_EQUAL = '>=';
  var IDENTIFIER = 'identifier';
  var IF = 'if';
  var IMPLEMENTS = 'implements';
  var IMPORT = 'import';
  var IN = 'in';
  var INSTANCEOF = 'instanceof';
  var INTERFACE = 'interface';
  var LEFT_SHIFT = '<<';
  var LEFT_SHIFT_EQUAL = '<<=';
  var LESS_EQUAL = '<=';
  var LET = 'let';
  var MINUS = '-';
  var MINUS_EQUAL = '-=';
  var MINUS_MINUS = '--';
  var NEW = 'new';
  var NO_SUBSTITUTION_TEMPLATE = 'no substitution template';
  var NOT_EQUAL = '!=';
  var NOT_EQUAL_EQUAL = '!==';
  var NULL = 'null';
  var NUMBER = 'number literal';
  var OPEN_ANGLE = '<';
  var OPEN_CURLY = '{';
  var OPEN_PAREN = '(';
  var OPEN_SQUARE = '[';
  var OR = '||';
  var PACKAGE = 'package';
  var PERCENT = '%';
  var PERCENT_EQUAL = '%=';
  var PERIOD = '.';
  var PLUS = '+';
  var PLUS_EQUAL = '+=';
  var PLUS_PLUS = '++';
  var PRIVATE = 'private';
  var PROTECTED = 'protected';
  var PUBLIC = 'public';
  var QUESTION = '?';
  var REGULAR_EXPRESSION = 'regular expression literal';
  var RETURN = 'return';
  var RIGHT_SHIFT = '>>';
  var RIGHT_SHIFT_EQUAL = '>>=';
  var SEMI_COLON = ';';
  var SLASH = '/';
  var SLASH_EQUAL = '/=';
  var STAR = '*';
  var STAR_EQUAL = '*=';
  var STAR_STAR = '**';
  var STAR_STAR_EQUAL = '**=';
  var STATIC = 'static';
  var STRING = 'string literal';
  var SUPER = 'super';
  var SWITCH = 'switch';
  var TEMPLATE_HEAD = 'template head';
  var TEMPLATE_MIDDLE = 'template middle';
  var TEMPLATE_TAIL = 'template tail';
  var THIS = 'this';
  var THROW = 'throw';
  var TILDE = '~';
  var TRUE = 'true';
  var TRY = 'try';
  var TYPEOF = 'typeof';
  var UNSIGNED_RIGHT_SHIFT = '>>>';
  var UNSIGNED_RIGHT_SHIFT_EQUAL = '>>>=';
  var VAR = 'var';
  var VOID = 'void';
  var WHILE = 'while';
  var WITH = 'with';
  var YIELD = 'yield';
  return {
    get AMPERSAND() {
      return AMPERSAND;
    },
    get AMPERSAND_EQUAL() {
      return AMPERSAND_EQUAL;
    },
    get AND() {
      return AND;
    },
    get ARROW() {
      return ARROW;
    },
    get AT() {
      return AT;
    },
    get BACK_QUOTE() {
      return BACK_QUOTE;
    },
    get BANG() {
      return BANG;
    },
    get BAR() {
      return BAR;
    },
    get BAR_EQUAL() {
      return BAR_EQUAL;
    },
    get BREAK() {
      return BREAK;
    },
    get CARET() {
      return CARET;
    },
    get CARET_EQUAL() {
      return CARET_EQUAL;
    },
    get CASE() {
      return CASE;
    },
    get CATCH() {
      return CATCH;
    },
    get CLASS() {
      return CLASS;
    },
    get CLOSE_ANGLE() {
      return CLOSE_ANGLE;
    },
    get CLOSE_CURLY() {
      return CLOSE_CURLY;
    },
    get CLOSE_PAREN() {
      return CLOSE_PAREN;
    },
    get CLOSE_SQUARE() {
      return CLOSE_SQUARE;
    },
    get COLON() {
      return COLON;
    },
    get COMMA() {
      return COMMA;
    },
    get CONST() {
      return CONST;
    },
    get CONTINUE() {
      return CONTINUE;
    },
    get DEBUGGER() {
      return DEBUGGER;
    },
    get DEFAULT() {
      return DEFAULT;
    },
    get DELETE() {
      return DELETE;
    },
    get DO() {
      return DO;
    },
    get DOT_DOT_DOT() {
      return DOT_DOT_DOT;
    },
    get ELSE() {
      return ELSE;
    },
    get END_OF_FILE() {
      return END_OF_FILE;
    },
    get ENUM() {
      return ENUM;
    },
    get EQUAL() {
      return EQUAL;
    },
    get EQUAL_EQUAL() {
      return EQUAL_EQUAL;
    },
    get EQUAL_EQUAL_EQUAL() {
      return EQUAL_EQUAL_EQUAL;
    },
    get ERROR() {
      return ERROR;
    },
    get EXPORT() {
      return EXPORT;
    },
    get EXTENDS() {
      return EXTENDS;
    },
    get FALSE() {
      return FALSE;
    },
    get FINALLY() {
      return FINALLY;
    },
    get FOR() {
      return FOR;
    },
    get FUNCTION() {
      return FUNCTION;
    },
    get GREATER_EQUAL() {
      return GREATER_EQUAL;
    },
    get IDENTIFIER() {
      return IDENTIFIER;
    },
    get IF() {
      return IF;
    },
    get IMPLEMENTS() {
      return IMPLEMENTS;
    },
    get IMPORT() {
      return IMPORT;
    },
    get IN() {
      return IN;
    },
    get INSTANCEOF() {
      return INSTANCEOF;
    },
    get INTERFACE() {
      return INTERFACE;
    },
    get LEFT_SHIFT() {
      return LEFT_SHIFT;
    },
    get LEFT_SHIFT_EQUAL() {
      return LEFT_SHIFT_EQUAL;
    },
    get LESS_EQUAL() {
      return LESS_EQUAL;
    },
    get LET() {
      return LET;
    },
    get MINUS() {
      return MINUS;
    },
    get MINUS_EQUAL() {
      return MINUS_EQUAL;
    },
    get MINUS_MINUS() {
      return MINUS_MINUS;
    },
    get NEW() {
      return NEW;
    },
    get NO_SUBSTITUTION_TEMPLATE() {
      return NO_SUBSTITUTION_TEMPLATE;
    },
    get NOT_EQUAL() {
      return NOT_EQUAL;
    },
    get NOT_EQUAL_EQUAL() {
      return NOT_EQUAL_EQUAL;
    },
    get NULL() {
      return NULL;
    },
    get NUMBER() {
      return NUMBER;
    },
    get OPEN_ANGLE() {
      return OPEN_ANGLE;
    },
    get OPEN_CURLY() {
      return OPEN_CURLY;
    },
    get OPEN_PAREN() {
      return OPEN_PAREN;
    },
    get OPEN_SQUARE() {
      return OPEN_SQUARE;
    },
    get OR() {
      return OR;
    },
    get PACKAGE() {
      return PACKAGE;
    },
    get PERCENT() {
      return PERCENT;
    },
    get PERCENT_EQUAL() {
      return PERCENT_EQUAL;
    },
    get PERIOD() {
      return PERIOD;
    },
    get PLUS() {
      return PLUS;
    },
    get PLUS_EQUAL() {
      return PLUS_EQUAL;
    },
    get PLUS_PLUS() {
      return PLUS_PLUS;
    },
    get PRIVATE() {
      return PRIVATE;
    },
    get PROTECTED() {
      return PROTECTED;
    },
    get PUBLIC() {
      return PUBLIC;
    },
    get QUESTION() {
      return QUESTION;
    },
    get REGULAR_EXPRESSION() {
      return REGULAR_EXPRESSION;
    },
    get RETURN() {
      return RETURN;
    },
    get RIGHT_SHIFT() {
      return RIGHT_SHIFT;
    },
    get RIGHT_SHIFT_EQUAL() {
      return RIGHT_SHIFT_EQUAL;
    },
    get SEMI_COLON() {
      return SEMI_COLON;
    },
    get SLASH() {
      return SLASH;
    },
    get SLASH_EQUAL() {
      return SLASH_EQUAL;
    },
    get STAR() {
      return STAR;
    },
    get STAR_EQUAL() {
      return STAR_EQUAL;
    },
    get STAR_STAR() {
      return STAR_STAR;
    },
    get STAR_STAR_EQUAL() {
      return STAR_STAR_EQUAL;
    },
    get STATIC() {
      return STATIC;
    },
    get STRING() {
      return STRING;
    },
    get SUPER() {
      return SUPER;
    },
    get SWITCH() {
      return SWITCH;
    },
    get TEMPLATE_HEAD() {
      return TEMPLATE_HEAD;
    },
    get TEMPLATE_MIDDLE() {
      return TEMPLATE_MIDDLE;
    },
    get TEMPLATE_TAIL() {
      return TEMPLATE_TAIL;
    },
    get THIS() {
      return THIS;
    },
    get THROW() {
      return THROW;
    },
    get TILDE() {
      return TILDE;
    },
    get TRUE() {
      return TRUE;
    },
    get TRY() {
      return TRY;
    },
    get TYPEOF() {
      return TYPEOF;
    },
    get UNSIGNED_RIGHT_SHIFT() {
      return UNSIGNED_RIGHT_SHIFT;
    },
    get UNSIGNED_RIGHT_SHIFT_EQUAL() {
      return UNSIGNED_RIGHT_SHIFT_EQUAL;
    },
    get VAR() {
      return VAR;
    },
    get VOID() {
      return VOID;
    },
    get WHILE() {
      return WHILE;
    },
    get WITH() {
      return WITH;
    },
    get YIELD() {
      return YIELD;
    }
  };
});
System.registerModule("traceur@0.0.80/src/syntax/trees/ParseTreeType.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/trees/ParseTreeType.js";
  var ANNOTATION = 'ANNOTATION';
  var ANON_BLOCK = 'ANON_BLOCK';
  var ARGUMENT_LIST = 'ARGUMENT_LIST';
  var ARRAY_COMPREHENSION = 'ARRAY_COMPREHENSION';
  var ARRAY_LITERAL_EXPRESSION = 'ARRAY_LITERAL_EXPRESSION';
  var ARRAY_PATTERN = 'ARRAY_PATTERN';
  var ARRAY_TYPE = 'ARRAY_TYPE';
  var ARROW_FUNCTION_EXPRESSION = 'ARROW_FUNCTION_EXPRESSION';
  var ASSIGNMENT_ELEMENT = 'ASSIGNMENT_ELEMENT';
  var AWAIT_EXPRESSION = 'AWAIT_EXPRESSION';
  var BINARY_EXPRESSION = 'BINARY_EXPRESSION';
  var BINDING_ELEMENT = 'BINDING_ELEMENT';
  var BINDING_IDENTIFIER = 'BINDING_IDENTIFIER';
  var BLOCK = 'BLOCK';
  var BREAK_STATEMENT = 'BREAK_STATEMENT';
  var CALL_EXPRESSION = 'CALL_EXPRESSION';
  var CALL_SIGNATURE = 'CALL_SIGNATURE';
  var CASE_CLAUSE = 'CASE_CLAUSE';
  var CATCH = 'CATCH';
  var CLASS_DECLARATION = 'CLASS_DECLARATION';
  var CLASS_EXPRESSION = 'CLASS_EXPRESSION';
  var COMMA_EXPRESSION = 'COMMA_EXPRESSION';
  var COMPREHENSION_FOR = 'COMPREHENSION_FOR';
  var COMPREHENSION_IF = 'COMPREHENSION_IF';
  var COMPUTED_PROPERTY_NAME = 'COMPUTED_PROPERTY_NAME';
  var CONDITIONAL_EXPRESSION = 'CONDITIONAL_EXPRESSION';
  var CONSTRUCT_SIGNATURE = 'CONSTRUCT_SIGNATURE';
  var CONSTRUCTOR_TYPE = 'CONSTRUCTOR_TYPE';
  var CONTINUE_STATEMENT = 'CONTINUE_STATEMENT';
  var COVER_FORMALS = 'COVER_FORMALS';
  var COVER_INITIALIZED_NAME = 'COVER_INITIALIZED_NAME';
  var DEBUGGER_STATEMENT = 'DEBUGGER_STATEMENT';
  var DEFAULT_CLAUSE = 'DEFAULT_CLAUSE';
  var DO_WHILE_STATEMENT = 'DO_WHILE_STATEMENT';
  var EMPTY_STATEMENT = 'EMPTY_STATEMENT';
  var EXPORT_DECLARATION = 'EXPORT_DECLARATION';
  var EXPORT_DEFAULT = 'EXPORT_DEFAULT';
  var EXPORT_SPECIFIER = 'EXPORT_SPECIFIER';
  var EXPORT_SPECIFIER_SET = 'EXPORT_SPECIFIER_SET';
  var EXPORT_STAR = 'EXPORT_STAR';
  var EXPRESSION_STATEMENT = 'EXPRESSION_STATEMENT';
  var FINALLY = 'FINALLY';
  var FOR_IN_STATEMENT = 'FOR_IN_STATEMENT';
  var FOR_OF_STATEMENT = 'FOR_OF_STATEMENT';
  var FOR_STATEMENT = 'FOR_STATEMENT';
  var FORMAL_PARAMETER = 'FORMAL_PARAMETER';
  var FORMAL_PARAMETER_LIST = 'FORMAL_PARAMETER_LIST';
  var FUNCTION_BODY = 'FUNCTION_BODY';
  var FUNCTION_DECLARATION = 'FUNCTION_DECLARATION';
  var FUNCTION_EXPRESSION = 'FUNCTION_EXPRESSION';
  var FUNCTION_TYPE = 'FUNCTION_TYPE';
  var GENERATOR_COMPREHENSION = 'GENERATOR_COMPREHENSION';
  var GET_ACCESSOR = 'GET_ACCESSOR';
  var IDENTIFIER_EXPRESSION = 'IDENTIFIER_EXPRESSION';
  var IF_STATEMENT = 'IF_STATEMENT';
  var IMPORT_DECLARATION = 'IMPORT_DECLARATION';
  var IMPORT_SPECIFIER = 'IMPORT_SPECIFIER';
  var IMPORT_SPECIFIER_SET = 'IMPORT_SPECIFIER_SET';
  var IMPORTED_BINDING = 'IMPORTED_BINDING';
  var INDEX_SIGNATURE = 'INDEX_SIGNATURE';
  var INTERFACE_DECLARATION = 'INTERFACE_DECLARATION';
  var LABELLED_STATEMENT = 'LABELLED_STATEMENT';
  var LITERAL_EXPRESSION = 'LITERAL_EXPRESSION';
  var LITERAL_PROPERTY_NAME = 'LITERAL_PROPERTY_NAME';
  var MEMBER_EXPRESSION = 'MEMBER_EXPRESSION';
  var MEMBER_LOOKUP_EXPRESSION = 'MEMBER_LOOKUP_EXPRESSION';
  var METHOD_SIGNATURE = 'METHOD_SIGNATURE';
  var MODULE = 'MODULE';
  var MODULE_DECLARATION = 'MODULE_DECLARATION';
  var MODULE_SPECIFIER = 'MODULE_SPECIFIER';
  var NAMED_EXPORT = 'NAMED_EXPORT';
  var NEW_EXPRESSION = 'NEW_EXPRESSION';
  var OBJECT_LITERAL_EXPRESSION = 'OBJECT_LITERAL_EXPRESSION';
  var OBJECT_PATTERN = 'OBJECT_PATTERN';
  var OBJECT_PATTERN_FIELD = 'OBJECT_PATTERN_FIELD';
  var OBJECT_TYPE = 'OBJECT_TYPE';
  var PAREN_EXPRESSION = 'PAREN_EXPRESSION';
  var POSTFIX_EXPRESSION = 'POSTFIX_EXPRESSION';
  var PREDEFINED_TYPE = 'PREDEFINED_TYPE';
  var PROPERTY_METHOD_ASSIGNMENT = 'PROPERTY_METHOD_ASSIGNMENT';
  var PROPERTY_NAME_ASSIGNMENT = 'PROPERTY_NAME_ASSIGNMENT';
  var PROPERTY_NAME_SHORTHAND = 'PROPERTY_NAME_SHORTHAND';
  var PROPERTY_SIGNATURE = 'PROPERTY_SIGNATURE';
  var PROPERTY_VARIABLE_DECLARATION = 'PROPERTY_VARIABLE_DECLARATION';
  var REST_PARAMETER = 'REST_PARAMETER';
  var RETURN_STATEMENT = 'RETURN_STATEMENT';
  var SCRIPT = 'SCRIPT';
  var SET_ACCESSOR = 'SET_ACCESSOR';
  var SPREAD_EXPRESSION = 'SPREAD_EXPRESSION';
  var SPREAD_PATTERN_ELEMENT = 'SPREAD_PATTERN_ELEMENT';
  var STATE_MACHINE = 'STATE_MACHINE';
  var SUPER_EXPRESSION = 'SUPER_EXPRESSION';
  var SWITCH_STATEMENT = 'SWITCH_STATEMENT';
  var SYNTAX_ERROR_TREE = 'SYNTAX_ERROR_TREE';
  var TEMPLATE_LITERAL_EXPRESSION = 'TEMPLATE_LITERAL_EXPRESSION';
  var TEMPLATE_LITERAL_PORTION = 'TEMPLATE_LITERAL_PORTION';
  var TEMPLATE_SUBSTITUTION = 'TEMPLATE_SUBSTITUTION';
  var THIS_EXPRESSION = 'THIS_EXPRESSION';
  var THROW_STATEMENT = 'THROW_STATEMENT';
  var TRY_STATEMENT = 'TRY_STATEMENT';
  var TYPE_ARGUMENTS = 'TYPE_ARGUMENTS';
  var TYPE_NAME = 'TYPE_NAME';
  var TYPE_PARAMETER = 'TYPE_PARAMETER';
  var TYPE_PARAMETERS = 'TYPE_PARAMETERS';
  var TYPE_REFERENCE = 'TYPE_REFERENCE';
  var UNARY_EXPRESSION = 'UNARY_EXPRESSION';
  var UNION_TYPE = 'UNION_TYPE';
  var VARIABLE_DECLARATION = 'VARIABLE_DECLARATION';
  var VARIABLE_DECLARATION_LIST = 'VARIABLE_DECLARATION_LIST';
  var VARIABLE_STATEMENT = 'VARIABLE_STATEMENT';
  var WHILE_STATEMENT = 'WHILE_STATEMENT';
  var WITH_STATEMENT = 'WITH_STATEMENT';
  var YIELD_EXPRESSION = 'YIELD_EXPRESSION';
  return {
    get ANNOTATION() {
      return ANNOTATION;
    },
    get ANON_BLOCK() {
      return ANON_BLOCK;
    },
    get ARGUMENT_LIST() {
      return ARGUMENT_LIST;
    },
    get ARRAY_COMPREHENSION() {
      return ARRAY_COMPREHENSION;
    },
    get ARRAY_LITERAL_EXPRESSION() {
      return ARRAY_LITERAL_EXPRESSION;
    },
    get ARRAY_PATTERN() {
      return ARRAY_PATTERN;
    },
    get ARRAY_TYPE() {
      return ARRAY_TYPE;
    },
    get ARROW_FUNCTION_EXPRESSION() {
      return ARROW_FUNCTION_EXPRESSION;
    },
    get ASSIGNMENT_ELEMENT() {
      return ASSIGNMENT_ELEMENT;
    },
    get AWAIT_EXPRESSION() {
      return AWAIT_EXPRESSION;
    },
    get BINARY_EXPRESSION() {
      return BINARY_EXPRESSION;
    },
    get BINDING_ELEMENT() {
      return BINDING_ELEMENT;
    },
    get BINDING_IDENTIFIER() {
      return BINDING_IDENTIFIER;
    },
    get BLOCK() {
      return BLOCK;
    },
    get BREAK_STATEMENT() {
      return BREAK_STATEMENT;
    },
    get CALL_EXPRESSION() {
      return CALL_EXPRESSION;
    },
    get CALL_SIGNATURE() {
      return CALL_SIGNATURE;
    },
    get CASE_CLAUSE() {
      return CASE_CLAUSE;
    },
    get CATCH() {
      return CATCH;
    },
    get CLASS_DECLARATION() {
      return CLASS_DECLARATION;
    },
    get CLASS_EXPRESSION() {
      return CLASS_EXPRESSION;
    },
    get COMMA_EXPRESSION() {
      return COMMA_EXPRESSION;
    },
    get COMPREHENSION_FOR() {
      return COMPREHENSION_FOR;
    },
    get COMPREHENSION_IF() {
      return COMPREHENSION_IF;
    },
    get COMPUTED_PROPERTY_NAME() {
      return COMPUTED_PROPERTY_NAME;
    },
    get CONDITIONAL_EXPRESSION() {
      return CONDITIONAL_EXPRESSION;
    },
    get CONSTRUCT_SIGNATURE() {
      return CONSTRUCT_SIGNATURE;
    },
    get CONSTRUCTOR_TYPE() {
      return CONSTRUCTOR_TYPE;
    },
    get CONTINUE_STATEMENT() {
      return CONTINUE_STATEMENT;
    },
    get COVER_FORMALS() {
      return COVER_FORMALS;
    },
    get COVER_INITIALIZED_NAME() {
      return COVER_INITIALIZED_NAME;
    },
    get DEBUGGER_STATEMENT() {
      return DEBUGGER_STATEMENT;
    },
    get DEFAULT_CLAUSE() {
      return DEFAULT_CLAUSE;
    },
    get DO_WHILE_STATEMENT() {
      return DO_WHILE_STATEMENT;
    },
    get EMPTY_STATEMENT() {
      return EMPTY_STATEMENT;
    },
    get EXPORT_DECLARATION() {
      return EXPORT_DECLARATION;
    },
    get EXPORT_DEFAULT() {
      return EXPORT_DEFAULT;
    },
    get EXPORT_SPECIFIER() {
      return EXPORT_SPECIFIER;
    },
    get EXPORT_SPECIFIER_SET() {
      return EXPORT_SPECIFIER_SET;
    },
    get EXPORT_STAR() {
      return EXPORT_STAR;
    },
    get EXPRESSION_STATEMENT() {
      return EXPRESSION_STATEMENT;
    },
    get FINALLY() {
      return FINALLY;
    },
    get FOR_IN_STATEMENT() {
      return FOR_IN_STATEMENT;
    },
    get FOR_OF_STATEMENT() {
      return FOR_OF_STATEMENT;
    },
    get FOR_STATEMENT() {
      return FOR_STATEMENT;
    },
    get FORMAL_PARAMETER() {
      return FORMAL_PARAMETER;
    },
    get FORMAL_PARAMETER_LIST() {
      return FORMAL_PARAMETER_LIST;
    },
    get FUNCTION_BODY() {
      return FUNCTION_BODY;
    },
    get FUNCTION_DECLARATION() {
      return FUNCTION_DECLARATION;
    },
    get FUNCTION_EXPRESSION() {
      return FUNCTION_EXPRESSION;
    },
    get FUNCTION_TYPE() {
      return FUNCTION_TYPE;
    },
    get GENERATOR_COMPREHENSION() {
      return GENERATOR_COMPREHENSION;
    },
    get GET_ACCESSOR() {
      return GET_ACCESSOR;
    },
    get IDENTIFIER_EXPRESSION() {
      return IDENTIFIER_EXPRESSION;
    },
    get IF_STATEMENT() {
      return IF_STATEMENT;
    },
    get IMPORT_DECLARATION() {
      return IMPORT_DECLARATION;
    },
    get IMPORT_SPECIFIER() {
      return IMPORT_SPECIFIER;
    },
    get IMPORT_SPECIFIER_SET() {
      return IMPORT_SPECIFIER_SET;
    },
    get IMPORTED_BINDING() {
      return IMPORTED_BINDING;
    },
    get INDEX_SIGNATURE() {
      return INDEX_SIGNATURE;
    },
    get INTERFACE_DECLARATION() {
      return INTERFACE_DECLARATION;
    },
    get LABELLED_STATEMENT() {
      return LABELLED_STATEMENT;
    },
    get LITERAL_EXPRESSION() {
      return LITERAL_EXPRESSION;
    },
    get LITERAL_PROPERTY_NAME() {
      return LITERAL_PROPERTY_NAME;
    },
    get MEMBER_EXPRESSION() {
      return MEMBER_EXPRESSION;
    },
    get MEMBER_LOOKUP_EXPRESSION() {
      return MEMBER_LOOKUP_EXPRESSION;
    },
    get METHOD_SIGNATURE() {
      return METHOD_SIGNATURE;
    },
    get MODULE() {
      return MODULE;
    },
    get MODULE_DECLARATION() {
      return MODULE_DECLARATION;
    },
    get MODULE_SPECIFIER() {
      return MODULE_SPECIFIER;
    },
    get NAMED_EXPORT() {
      return NAMED_EXPORT;
    },
    get NEW_EXPRESSION() {
      return NEW_EXPRESSION;
    },
    get OBJECT_LITERAL_EXPRESSION() {
      return OBJECT_LITERAL_EXPRESSION;
    },
    get OBJECT_PATTERN() {
      return OBJECT_PATTERN;
    },
    get OBJECT_PATTERN_FIELD() {
      return OBJECT_PATTERN_FIELD;
    },
    get OBJECT_TYPE() {
      return OBJECT_TYPE;
    },
    get PAREN_EXPRESSION() {
      return PAREN_EXPRESSION;
    },
    get POSTFIX_EXPRESSION() {
      return POSTFIX_EXPRESSION;
    },
    get PREDEFINED_TYPE() {
      return PREDEFINED_TYPE;
    },
    get PROPERTY_METHOD_ASSIGNMENT() {
      return PROPERTY_METHOD_ASSIGNMENT;
    },
    get PROPERTY_NAME_ASSIGNMENT() {
      return PROPERTY_NAME_ASSIGNMENT;
    },
    get PROPERTY_NAME_SHORTHAND() {
      return PROPERTY_NAME_SHORTHAND;
    },
    get PROPERTY_SIGNATURE() {
      return PROPERTY_SIGNATURE;
    },
    get PROPERTY_VARIABLE_DECLARATION() {
      return PROPERTY_VARIABLE_DECLARATION;
    },
    get REST_PARAMETER() {
      return REST_PARAMETER;
    },
    get RETURN_STATEMENT() {
      return RETURN_STATEMENT;
    },
    get SCRIPT() {
      return SCRIPT;
    },
    get SET_ACCESSOR() {
      return SET_ACCESSOR;
    },
    get SPREAD_EXPRESSION() {
      return SPREAD_EXPRESSION;
    },
    get SPREAD_PATTERN_ELEMENT() {
      return SPREAD_PATTERN_ELEMENT;
    },
    get STATE_MACHINE() {
      return STATE_MACHINE;
    },
    get SUPER_EXPRESSION() {
      return SUPER_EXPRESSION;
    },
    get SWITCH_STATEMENT() {
      return SWITCH_STATEMENT;
    },
    get SYNTAX_ERROR_TREE() {
      return SYNTAX_ERROR_TREE;
    },
    get TEMPLATE_LITERAL_EXPRESSION() {
      return TEMPLATE_LITERAL_EXPRESSION;
    },
    get TEMPLATE_LITERAL_PORTION() {
      return TEMPLATE_LITERAL_PORTION;
    },
    get TEMPLATE_SUBSTITUTION() {
      return TEMPLATE_SUBSTITUTION;
    },
    get THIS_EXPRESSION() {
      return THIS_EXPRESSION;
    },
    get THROW_STATEMENT() {
      return THROW_STATEMENT;
    },
    get TRY_STATEMENT() {
      return TRY_STATEMENT;
    },
    get TYPE_ARGUMENTS() {
      return TYPE_ARGUMENTS;
    },
    get TYPE_NAME() {
      return TYPE_NAME;
    },
    get TYPE_PARAMETER() {
      return TYPE_PARAMETER;
    },
    get TYPE_PARAMETERS() {
      return TYPE_PARAMETERS;
    },
    get TYPE_REFERENCE() {
      return TYPE_REFERENCE;
    },
    get UNARY_EXPRESSION() {
      return UNARY_EXPRESSION;
    },
    get UNION_TYPE() {
      return UNION_TYPE;
    },
    get VARIABLE_DECLARATION() {
      return VARIABLE_DECLARATION;
    },
    get VARIABLE_DECLARATION_LIST() {
      return VARIABLE_DECLARATION_LIST;
    },
    get VARIABLE_STATEMENT() {
      return VARIABLE_STATEMENT;
    },
    get WHILE_STATEMENT() {
      return WHILE_STATEMENT;
    },
    get WITH_STATEMENT() {
      return WITH_STATEMENT;
    },
    get YIELD_EXPRESSION() {
      return YIELD_EXPRESSION;
    }
  };
});
System.registerModule("traceur@0.0.80/src/syntax/ParseTreeVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/ParseTreeVisitor.js";
  var ParseTreeVisitor = function ParseTreeVisitor() {};
  ($traceurRuntime.createClass)(ParseTreeVisitor, {
    visitAny: function(tree) {
      tree && tree.visit(this);
    },
    visit: function(tree) {
      this.visitAny(tree);
    },
    visitList: function(list) {
      if (list) {
        for (var i = 0; i < list.length; i++) {
          this.visitAny(list[i]);
        }
      }
    },
    visitStateMachine: function(tree) {
      throw Error('State machines should not live outside of the GeneratorTransformer.');
    },
    visitAnnotation: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.args);
    },
    visitAnonBlock: function(tree) {
      this.visitList(tree.statements);
    },
    visitArgumentList: function(tree) {
      this.visitList(tree.args);
    },
    visitArrayComprehension: function(tree) {
      this.visitList(tree.comprehensionList);
      this.visitAny(tree.expression);
    },
    visitArrayLiteralExpression: function(tree) {
      this.visitList(tree.elements);
    },
    visitArrayPattern: function(tree) {
      this.visitList(tree.elements);
    },
    visitArrayType: function(tree) {
      this.visitAny(tree.elementType);
    },
    visitArrowFunctionExpression: function(tree) {
      this.visitAny(tree.parameterList);
      this.visitAny(tree.body);
    },
    visitAssignmentElement: function(tree) {
      this.visitAny(tree.assignment);
      this.visitAny(tree.initializer);
    },
    visitAwaitExpression: function(tree) {
      this.visitAny(tree.expression);
    },
    visitBinaryExpression: function(tree) {
      this.visitAny(tree.left);
      this.visitAny(tree.right);
    },
    visitBindingElement: function(tree) {
      this.visitAny(tree.binding);
      this.visitAny(tree.initializer);
    },
    visitBindingIdentifier: function(tree) {},
    visitBlock: function(tree) {
      this.visitList(tree.statements);
    },
    visitBreakStatement: function(tree) {},
    visitCallExpression: function(tree) {
      this.visitAny(tree.operand);
      this.visitAny(tree.args);
    },
    visitCallSignature: function(tree) {
      this.visitAny(tree.typeParameters);
      this.visitAny(tree.parameterList);
      this.visitAny(tree.returnType);
    },
    visitCaseClause: function(tree) {
      this.visitAny(tree.expression);
      this.visitList(tree.statements);
    },
    visitCatch: function(tree) {
      this.visitAny(tree.binding);
      this.visitAny(tree.catchBody);
    },
    visitClassDeclaration: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.superClass);
      this.visitList(tree.elements);
      this.visitList(tree.annotations);
      this.visitAny(tree.typeParameters);
    },
    visitClassExpression: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.superClass);
      this.visitList(tree.elements);
      this.visitList(tree.annotations);
      this.visitAny(tree.typeParameters);
    },
    visitCommaExpression: function(tree) {
      this.visitList(tree.expressions);
    },
    visitComprehensionFor: function(tree) {
      this.visitAny(tree.left);
      this.visitAny(tree.iterator);
    },
    visitComprehensionIf: function(tree) {
      this.visitAny(tree.expression);
    },
    visitComputedPropertyName: function(tree) {
      this.visitAny(tree.expression);
    },
    visitConditionalExpression: function(tree) {
      this.visitAny(tree.condition);
      this.visitAny(tree.left);
      this.visitAny(tree.right);
    },
    visitConstructSignature: function(tree) {
      this.visitAny(tree.typeParameters);
      this.visitAny(tree.parameterList);
      this.visitAny(tree.returnType);
    },
    visitConstructorType: function(tree) {
      this.visitAny(tree.typeParameters);
      this.visitAny(tree.parameterList);
      this.visitAny(tree.returnType);
    },
    visitContinueStatement: function(tree) {},
    visitCoverFormals: function(tree) {
      this.visitList(tree.expressions);
    },
    visitCoverInitializedName: function(tree) {
      this.visitAny(tree.initializer);
    },
    visitDebuggerStatement: function(tree) {},
    visitDefaultClause: function(tree) {
      this.visitList(tree.statements);
    },
    visitDoWhileStatement: function(tree) {
      this.visitAny(tree.body);
      this.visitAny(tree.condition);
    },
    visitEmptyStatement: function(tree) {},
    visitExportDeclaration: function(tree) {
      this.visitAny(tree.declaration);
      this.visitList(tree.annotations);
    },
    visitExportDefault: function(tree) {
      this.visitAny(tree.expression);
    },
    visitExportSpecifier: function(tree) {},
    visitExportSpecifierSet: function(tree) {
      this.visitList(tree.specifiers);
    },
    visitExportStar: function(tree) {},
    visitExpressionStatement: function(tree) {
      this.visitAny(tree.expression);
    },
    visitFinally: function(tree) {
      this.visitAny(tree.block);
    },
    visitForInStatement: function(tree) {
      this.visitAny(tree.initializer);
      this.visitAny(tree.collection);
      this.visitAny(tree.body);
    },
    visitForOfStatement: function(tree) {
      this.visitAny(tree.initializer);
      this.visitAny(tree.collection);
      this.visitAny(tree.body);
    },
    visitForStatement: function(tree) {
      this.visitAny(tree.initializer);
      this.visitAny(tree.condition);
      this.visitAny(tree.increment);
      this.visitAny(tree.body);
    },
    visitFormalParameter: function(tree) {
      this.visitAny(tree.parameter);
      this.visitAny(tree.typeAnnotation);
      this.visitList(tree.annotations);
    },
    visitFormalParameterList: function(tree) {
      this.visitList(tree.parameters);
    },
    visitFunctionBody: function(tree) {
      this.visitList(tree.statements);
    },
    visitFunctionDeclaration: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.parameterList);
      this.visitAny(tree.typeAnnotation);
      this.visitList(tree.annotations);
      this.visitAny(tree.body);
    },
    visitFunctionExpression: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.parameterList);
      this.visitAny(tree.typeAnnotation);
      this.visitList(tree.annotations);
      this.visitAny(tree.body);
    },
    visitFunctionType: function(tree) {
      this.visitAny(tree.typeParameters);
      this.visitAny(tree.parameterList);
      this.visitAny(tree.returnType);
    },
    visitGeneratorComprehension: function(tree) {
      this.visitList(tree.comprehensionList);
      this.visitAny(tree.expression);
    },
    visitGetAccessor: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.typeAnnotation);
      this.visitList(tree.annotations);
      this.visitAny(tree.body);
    },
    visitIdentifierExpression: function(tree) {},
    visitIfStatement: function(tree) {
      this.visitAny(tree.condition);
      this.visitAny(tree.ifClause);
      this.visitAny(tree.elseClause);
    },
    visitImportedBinding: function(tree) {
      this.visitAny(tree.binding);
    },
    visitImportDeclaration: function(tree) {
      this.visitAny(tree.importClause);
      this.visitAny(tree.moduleSpecifier);
    },
    visitImportSpecifier: function(tree) {
      this.visitAny(tree.binding);
    },
    visitImportSpecifierSet: function(tree) {
      this.visitList(tree.specifiers);
    },
    visitIndexSignature: function(tree) {
      this.visitAny(tree.indexType);
      this.visitAny(tree.typeAnnotation);
    },
    visitInterfaceDeclaration: function(tree) {
      this.visitAny(tree.typeParameters);
      this.visitAny(tree.objectType);
    },
    visitLabelledStatement: function(tree) {
      this.visitAny(tree.statement);
    },
    visitLiteralExpression: function(tree) {},
    visitLiteralPropertyName: function(tree) {},
    visitMemberExpression: function(tree) {
      this.visitAny(tree.operand);
    },
    visitMemberLookupExpression: function(tree) {
      this.visitAny(tree.operand);
      this.visitAny(tree.memberExpression);
    },
    visitMethodSignature: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.callSignature);
    },
    visitModule: function(tree) {
      this.visitList(tree.scriptItemList);
    },
    visitModuleDeclaration: function(tree) {
      this.visitAny(tree.binding);
      this.visitAny(tree.expression);
    },
    visitModuleSpecifier: function(tree) {},
    visitNamedExport: function(tree) {
      this.visitAny(tree.moduleSpecifier);
      this.visitAny(tree.specifierSet);
    },
    visitNewExpression: function(tree) {
      this.visitAny(tree.operand);
      this.visitAny(tree.args);
    },
    visitObjectLiteralExpression: function(tree) {
      this.visitList(tree.propertyNameAndValues);
    },
    visitObjectPattern: function(tree) {
      this.visitList(tree.fields);
    },
    visitObjectPatternField: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.element);
    },
    visitObjectType: function(tree) {
      this.visitList(tree.typeMembers);
    },
    visitParenExpression: function(tree) {
      this.visitAny(tree.expression);
    },
    visitPostfixExpression: function(tree) {
      this.visitAny(tree.operand);
    },
    visitPredefinedType: function(tree) {},
    visitScript: function(tree) {
      this.visitList(tree.scriptItemList);
    },
    visitPropertyMethodAssignment: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.parameterList);
      this.visitAny(tree.typeAnnotation);
      this.visitList(tree.annotations);
      this.visitAny(tree.body);
    },
    visitPropertyNameAssignment: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.value);
    },
    visitPropertyNameShorthand: function(tree) {},
    visitPropertyVariableDeclaration: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.typeAnnotation);
      this.visitList(tree.annotations);
    },
    visitPropertySignature: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.typeAnnotation);
    },
    visitRestParameter: function(tree) {
      this.visitAny(tree.identifier);
      this.visitAny(tree.typeAnnotation);
    },
    visitReturnStatement: function(tree) {
      this.visitAny(tree.expression);
    },
    visitSetAccessor: function(tree) {
      this.visitAny(tree.name);
      this.visitAny(tree.parameterList);
      this.visitList(tree.annotations);
      this.visitAny(tree.body);
    },
    visitSpreadExpression: function(tree) {
      this.visitAny(tree.expression);
    },
    visitSpreadPatternElement: function(tree) {
      this.visitAny(tree.lvalue);
    },
    visitSuperExpression: function(tree) {},
    visitSwitchStatement: function(tree) {
      this.visitAny(tree.expression);
      this.visitList(tree.caseClauses);
    },
    visitSyntaxErrorTree: function(tree) {},
    visitTemplateLiteralExpression: function(tree) {
      this.visitAny(tree.operand);
      this.visitList(tree.elements);
    },
    visitTemplateLiteralPortion: function(tree) {},
    visitTemplateSubstitution: function(tree) {
      this.visitAny(tree.expression);
    },
    visitThisExpression: function(tree) {},
    visitThrowStatement: function(tree) {
      this.visitAny(tree.value);
    },
    visitTryStatement: function(tree) {
      this.visitAny(tree.body);
      this.visitAny(tree.catchBlock);
      this.visitAny(tree.finallyBlock);
    },
    visitTypeArguments: function(tree) {
      this.visitList(tree.args);
    },
    visitTypeName: function(tree) {
      this.visitAny(tree.moduleName);
    },
    visitTypeParameter: function(tree) {
      this.visitAny(tree.extendsType);
    },
    visitTypeParameters: function(tree) {
      this.visitList(tree.parameters);
    },
    visitTypeReference: function(tree) {
      this.visitAny(tree.typeName);
      this.visitAny(tree.args);
    },
    visitUnaryExpression: function(tree) {
      this.visitAny(tree.operand);
    },
    visitUnionType: function(tree) {
      this.visitList(tree.types);
    },
    visitVariableDeclaration: function(tree) {
      this.visitAny(tree.lvalue);
      this.visitAny(tree.typeAnnotation);
      this.visitAny(tree.initializer);
    },
    visitVariableDeclarationList: function(tree) {
      this.visitList(tree.declarations);
    },
    visitVariableStatement: function(tree) {
      this.visitAny(tree.declarations);
    },
    visitWhileStatement: function(tree) {
      this.visitAny(tree.condition);
      this.visitAny(tree.body);
    },
    visitWithStatement: function(tree) {
      this.visitAny(tree.expression);
      this.visitAny(tree.body);
    },
    visitYieldExpression: function(tree) {
      this.visitAny(tree.expression);
    }
  }, {});
  return {get ParseTreeVisitor() {
      return ParseTreeVisitor;
    }};
});
System.registerModule("traceur@0.0.80/src/syntax/PredefinedName.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/PredefinedName.js";
  var $ARGUMENTS = '$arguments';
  var ANY = 'any';
  var APPLY = 'apply';
  var ARGUMENTS = 'arguments';
  var ARRAY = 'Array';
  var AS = 'as';
  var ASYNC = 'async';
  var AWAIT = 'await';
  var BIND = 'bind';
  var CALL = 'call';
  var CONFIGURABLE = 'configurable';
  var CONSTRUCTOR = 'constructor';
  var CREATE = 'create';
  var CURRENT = 'current';
  var DEFINE_PROPERTY = 'defineProperty';
  var ENUMERABLE = 'enumerable';
  var FREEZE = 'freeze';
  var FROM = 'from';
  var FUNCTION = 'Function';
  var GET = 'get';
  var HAS = 'has';
  var LENGTH = 'length';
  var MODULE = 'module';
  var NEW = 'new';
  var OBJECT = 'Object';
  var OBJECT_NAME = 'Object';
  var OF = 'of';
  var PREVENT_EXTENSIONS = 'preventExtensions';
  var PROTOTYPE = 'prototype';
  var PUSH = 'push';
  var SET = 'set';
  var SLICE = 'slice';
  var THIS = 'this';
  var TRACEUR_RUNTIME = '$traceurRuntime';
  var UNDEFINED = 'undefined';
  var WRITABLE = 'writable';
  return {
    get $ARGUMENTS() {
      return $ARGUMENTS;
    },
    get ANY() {
      return ANY;
    },
    get APPLY() {
      return APPLY;
    },
    get ARGUMENTS() {
      return ARGUMENTS;
    },
    get ARRAY() {
      return ARRAY;
    },
    get AS() {
      return AS;
    },
    get ASYNC() {
      return ASYNC;
    },
    get AWAIT() {
      return AWAIT;
    },
    get BIND() {
      return BIND;
    },
    get CALL() {
      return CALL;
    },
    get CONFIGURABLE() {
      return CONFIGURABLE;
    },
    get CONSTRUCTOR() {
      return CONSTRUCTOR;
    },
    get CREATE() {
      return CREATE;
    },
    get CURRENT() {
      return CURRENT;
    },
    get DEFINE_PROPERTY() {
      return DEFINE_PROPERTY;
    },
    get ENUMERABLE() {
      return ENUMERABLE;
    },
    get FREEZE() {
      return FREEZE;
    },
    get FROM() {
      return FROM;
    },
    get FUNCTION() {
      return FUNCTION;
    },
    get GET() {
      return GET;
    },
    get HAS() {
      return HAS;
    },
    get LENGTH() {
      return LENGTH;
    },
    get MODULE() {
      return MODULE;
    },
    get NEW() {
      return NEW;
    },
    get OBJECT() {
      return OBJECT;
    },
    get OBJECT_NAME() {
      return OBJECT_NAME;
    },
    get OF() {
      return OF;
    },
    get PREVENT_EXTENSIONS() {
      return PREVENT_EXTENSIONS;
    },
    get PROTOTYPE() {
      return PROTOTYPE;
    },
    get PUSH() {
      return PUSH;
    },
    get SET() {
      return SET;
    },
    get SLICE() {
      return SLICE;
    },
    get THIS() {
      return THIS;
    },
    get TRACEUR_RUNTIME() {
      return TRACEUR_RUNTIME;
    },
    get UNDEFINED() {
      return UNDEFINED;
    },
    get WRITABLE() {
      return WRITABLE;
    }
  };
});
System.registerModule("traceur@0.0.80/src/semantics/util.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/util.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      IDENTIFIER_EXPRESSION = $__0.IDENTIFIER_EXPRESSION,
      LITERAL_EXPRESSION = $__0.LITERAL_EXPRESSION,
      PAREN_EXPRESSION = $__0.PAREN_EXPRESSION,
      UNARY_EXPRESSION = $__0.UNARY_EXPRESSION;
  var UNDEFINED = System.get("traceur@0.0.80/src/syntax/PredefinedName.js").UNDEFINED;
  var VOID = System.get("traceur@0.0.80/src/syntax/TokenType.js").VOID;
  function hasUseStrict(list) {
    for (var i = 0; i < list.length; i++) {
      if (!list[i].isDirectivePrologue())
        return false;
      if (list[i].isUseStrictDirective())
        return true;
    }
    return false;
  }
  function isUndefined(tree) {
    if (tree.type === PAREN_EXPRESSION)
      return isUndefined(tree.expression);
    return tree.type === IDENTIFIER_EXPRESSION && tree.identifierToken.value === UNDEFINED;
  }
  function isVoidExpression(tree) {
    if (tree.type === PAREN_EXPRESSION)
      return isVoidExpression(tree.expression);
    return tree.type === UNARY_EXPRESSION && tree.operator.type === VOID && isLiteralExpression(tree.operand);
  }
  function isLiteralExpression(tree) {
    if (tree.type === PAREN_EXPRESSION)
      return isLiteralExpression(tree.expression);
    return tree.type === LITERAL_EXPRESSION;
  }
  return {
    get hasUseStrict() {
      return hasUseStrict;
    },
    get isUndefined() {
      return isUndefined;
    },
    get isVoidExpression() {
      return isVoidExpression;
    },
    get isLiteralExpression() {
      return isLiteralExpression;
    }
  };
});
System.registerModule("traceur@0.0.80/src/semantics/isTreeStrict.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/isTreeStrict.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      ARROW_FUNCTION_EXPRESSION = $__0.ARROW_FUNCTION_EXPRESSION,
      CLASS_DECLARATION = $__0.CLASS_DECLARATION,
      CLASS_EXPRESSION = $__0.CLASS_EXPRESSION,
      FUNCTION_BODY = $__0.FUNCTION_BODY,
      FUNCTION_DECLARATION = $__0.FUNCTION_DECLARATION,
      FUNCTION_EXPRESSION = $__0.FUNCTION_EXPRESSION,
      GET_ACCESSOR = $__0.GET_ACCESSOR,
      MODULE = $__0.MODULE,
      PROPERTY_METHOD_ASSIGNMENT = $__0.PROPERTY_METHOD_ASSIGNMENT,
      SCRIPT = $__0.SCRIPT,
      SET_ACCESSOR = $__0.SET_ACCESSOR;
  var hasUseStrict = System.get("traceur@0.0.80/src/semantics/util.js").hasUseStrict;
  function isTreeStrict(tree) {
    switch (tree.type) {
      case CLASS_DECLARATION:
      case CLASS_EXPRESSION:
      case MODULE:
        return true;
      case FUNCTION_BODY:
        return hasUseStrict(tree.statements);
      case FUNCTION_EXPRESSION:
      case FUNCTION_DECLARATION:
      case PROPERTY_METHOD_ASSIGNMENT:
        return isTreeStrict(tree.body);
      case ARROW_FUNCTION_EXPRESSION:
        if (tree.body.type === FUNCTION_BODY) {
          return isTreeStrict(tree.body);
        }
        return false;
      case GET_ACCESSOR:
      case SET_ACCESSOR:
        return isTreeStrict(tree.body);
      case SCRIPT:
        return hasUseStrict(tree.scriptItemList);
      default:
        return false;
    }
  }
  return {get isTreeStrict() {
      return isTreeStrict;
    }};
});
System.registerModule("traceur@0.0.80/src/semantics/Scope.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/Scope.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      BLOCK = $__0.BLOCK,
      CATCH = $__0.CATCH;
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var isTreeStrict = System.get("traceur@0.0.80/src/semantics/isTreeStrict.js").isTreeStrict;
  function reportDuplicateVar(reporter, tree, name) {
    reporter.reportError(tree.location && tree.location.start, ("Duplicate declaration, " + name));
  }
  var Scope = function Scope(parent, tree) {
    this.parent = parent;
    this.tree = tree;
    this.variableDeclarations = Object.create(null);
    this.lexicalDeclarations = Object.create(null);
    this.strictMode = parent && parent.strictMode || isTreeStrict(tree);
  };
  ($traceurRuntime.createClass)(Scope, {
    addBinding: function(tree, type, reporter) {
      if (type === VAR) {
        this.addVar(tree, reporter);
      } else {
        this.addDeclaration(tree, type, reporter);
      }
    },
    addVar: function(tree, reporter) {
      var name = tree.getStringValue();
      if (this.lexicalDeclarations[name]) {
        reportDuplicateVar(reporter, tree, name);
        return;
      }
      this.variableDeclarations[name] = {
        type: VAR,
        tree: tree
      };
      if (!this.isVarScope && this.parent) {
        this.parent.addVar(tree, reporter);
      }
    },
    addDeclaration: function(tree, type, reporter) {
      var name = tree.getStringValue();
      if (this.lexicalDeclarations[name] || this.variableDeclarations[name]) {
        reportDuplicateVar(reporter, tree, name);
        return;
      }
      this.lexicalDeclarations[name] = {
        type: type,
        tree: tree
      };
    },
    renameBinding: function(oldName, newTree, newType, reporter) {
      var name = newTree.getStringValue();
      if (newType == VAR) {
        if (this.lexicalDeclarations[oldName]) {
          delete this.lexicalDeclarations[oldName];
          this.addVar(newTree, reporter);
        }
      } else if (this.variableDeclarations[oldName]) {
        delete this.variableDeclarations[oldName];
        this.addDeclaration(newTree, newType, reporter);
        if (!this.isVarScope && this.parent) {
          this.parent.renameBinding(oldName, newTree, newType);
        }
      }
    },
    get isVarScope() {
      switch (this.tree.type) {
        case BLOCK:
        case CATCH:
          return false;
      }
      return true;
    },
    getVarScope: function() {
      if (this.isVarScope) {
        return this;
      }
      if (this.parent) {
        return this.parent.getVarScope();
      }
      return null;
    },
    getBinding: function(tree) {
      var name = tree.getStringValue();
      return this.getBindingByName(name);
    },
    getBindingByName: function(name) {
      var b = this.lexicalDeclarations[name];
      if (b) {
        return b;
      }
      b = this.variableDeclarations[name];
      if (b && this.isVarScope) {
        return b;
      }
      if (this.parent) {
        return this.parent.getBindingByName(name);
      }
      return null;
    },
    getAllBindingNames: function() {
      var names = Object.create(null);
      var name;
      for (name in this.variableDeclarations) {
        names[name] = true;
      }
      for (name in this.lexicalDeclarations) {
        names[name] = true;
      }
      return names;
    },
    getVariableBindingNames: function() {
      var names = Object.create(null);
      for (var name in this.variableDeclarations) {
        names[name] = true;
      }
      return names;
    },
    getLexicalBindingNames: function() {
      var names = Object.create(null);
      for (var name in this.lexicalDeclarations) {
        names[name] = true;
      }
      return names;
    },
    hasBindingName: function(name) {
      return this.lexicalDeclarations[name] || this.variableDeclarations[name];
    },
    hasLexicalBindingName: function(name) {
      return this.lexicalDeclarations[name];
    },
    hasVariableBindingName: function(name) {
      return this.variableDeclarations[name];
    }
  }, {});
  return {get Scope() {
      return Scope;
    }};
});
System.registerModule("traceur@0.0.80/src/semantics/ScopeVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/ScopeVisitor.js";
  var Map = System.get("traceur@0.0.80/src/runtime/polyfills/Map.js").Map;
  var ParseTreeVisitor = System.get("traceur@0.0.80/src/syntax/ParseTreeVisitor.js").ParseTreeVisitor;
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var Scope = System.get("traceur@0.0.80/src/semantics/Scope.js").Scope;
  var $__4 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      COMPREHENSION_FOR = $__4.COMPREHENSION_FOR,
      VARIABLE_DECLARATION_LIST = $__4.VARIABLE_DECLARATION_LIST;
  var ScopeVisitor = function ScopeVisitor() {
    this.map_ = new Map();
    this.scope = null;
    this.withBlockCounter_ = 0;
  };
  var $ScopeVisitor = ScopeVisitor;
  ($traceurRuntime.createClass)(ScopeVisitor, {
    getScopeForTree: function(tree) {
      return this.map_.get(tree);
    },
    createScope: function(tree) {
      return new Scope(this.scope, tree);
    },
    pushScope: function(tree) {
      var scope = this.createScope(tree);
      this.map_.set(tree, scope);
      return this.scope = scope;
    },
    popScope: function(scope) {
      if (this.scope !== scope) {
        throw new Error('ScopeVisitor scope mismatch');
      }
      this.scope = scope.parent;
    },
    visitScript: function(tree) {
      var scope = this.pushScope(tree);
      $traceurRuntime.superGet(this, $ScopeVisitor.prototype, "visitScript").call(this, tree);
      this.popScope(scope);
    },
    visitModule: function(tree) {
      var scope = this.pushScope(tree);
      $traceurRuntime.superGet(this, $ScopeVisitor.prototype, "visitModule").call(this, tree);
      this.popScope(scope);
    },
    visitBlock: function(tree) {
      var scope = this.pushScope(tree);
      $traceurRuntime.superGet(this, $ScopeVisitor.prototype, "visitBlock").call(this, tree);
      this.popScope(scope);
    },
    visitCatch: function(tree) {
      var scope = this.pushScope(tree);
      this.visitAny(tree.binding);
      this.visitList(tree.catchBody.statements);
      this.popScope(scope);
    },
    visitFunctionBodyForScope: function(tree) {
      var parameterList = arguments[1] !== (void 0) ? arguments[1] : tree.parameterList;
      var scope = this.pushScope(tree);
      this.visitAny(parameterList);
      this.visitAny(tree.body);
      this.popScope(scope);
    },
    visitFunctionExpression: function(tree) {
      this.visitFunctionBodyForScope(tree);
    },
    visitFunctionDeclaration: function(tree) {
      this.visitAny(tree.name);
      this.visitFunctionBodyForScope(tree);
    },
    visitArrowFunctionExpression: function(tree) {
      this.visitFunctionBodyForScope(tree);
    },
    visitGetAccessor: function(tree) {
      this.visitFunctionBodyForScope(tree, null);
    },
    visitSetAccessor: function(tree) {
      this.visitFunctionBodyForScope(tree);
    },
    visitPropertyMethodAssignment: function(tree) {
      this.visitFunctionBodyForScope(tree);
    },
    visitClassDeclaration: function(tree) {
      this.visitAny(tree.superClass);
      var scope = this.pushScope(tree);
      this.visitAny(tree.name);
      this.visitList(tree.elements);
      this.popScope(scope);
    },
    visitClassExpression: function(tree) {
      this.visitAny(tree.superClass);
      var scope;
      if (tree.name) {
        scope = this.pushScope(tree);
        this.visitAny(tree.name);
      }
      this.visitList(tree.elements);
      if (tree.name) {
        this.popScope(scope);
      }
    },
    visitWithStatement: function(tree) {
      this.visitAny(tree.expression);
      this.withBlockCounter_++;
      this.visitAny(tree.body);
      this.withBlockCounter_--;
    },
    get inWithBlock() {
      return this.withBlockCounter_ > 0;
    },
    visitLoop_: function(tree, func) {
      if (tree.initializer.type !== VARIABLE_DECLARATION_LIST || tree.initializer.declarationType === VAR) {
        func();
        return;
      }
      var scope = this.pushScope(tree);
      func();
      this.popScope(scope);
    },
    visitForInStatement: function(tree) {
      var $__5 = this;
      this.visitLoop_(tree, (function() {
        return $traceurRuntime.superGet($__5, $ScopeVisitor.prototype, "visitForInStatement").call($__5, tree);
      }));
    },
    visitForOfStatement: function(tree) {
      var $__5 = this;
      this.visitLoop_(tree, (function() {
        return $traceurRuntime.superGet($__5, $ScopeVisitor.prototype, "visitForOfStatement").call($__5, tree);
      }));
    },
    visitForStatement: function(tree) {
      var $__5 = this;
      if (!tree.initializer) {
        $traceurRuntime.superGet(this, $ScopeVisitor.prototype, "visitForStatement").call(this, tree);
      } else {
        this.visitLoop_(tree, (function() {
          return $traceurRuntime.superGet($__5, $ScopeVisitor.prototype, "visitForStatement").call($__5, tree);
        }));
      }
    },
    visitComprehension_: function(tree) {
      var scopes = [];
      for (var i = 0; i < tree.comprehensionList.length; i++) {
        var scope = null;
        if (tree.comprehensionList[i].type === COMPREHENSION_FOR) {
          scope = this.pushScope(tree.comprehensionList[i]);
        }
        scopes.push(scope);
        this.visitAny(tree.comprehensionList[i]);
      }
      this.visitAny(tree.expression);
      for (var i = scopes.length - 1; i >= 0; i--) {
        if (scopes[i]) {
          this.popScope(scopes[i]);
        }
      }
    },
    visitArrayComprehension: function(tree) {
      this.visitComprehension_(tree);
    },
    visitGeneratorComprehension: function(tree) {
      this.visitComprehension_(tree);
    },
    visitPredefinedType: function(tree) {},
    visitTypeArguments: function(tree) {},
    visitFunctionType: function(tree) {}
  }, {}, ParseTreeVisitor);
  return {get ScopeVisitor() {
      return ScopeVisitor;
    }};
});
System.registerModule("traceur@0.0.80/src/semantics/ScopeChainBuilder.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/ScopeChainBuilder.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      CONST = $__0.CONST,
      LET = $__0.LET,
      VAR = $__0.VAR;
  var ScopeVisitor = System.get("traceur@0.0.80/src/semantics/ScopeVisitor.js").ScopeVisitor;
  var ScopeChainBuilder = function ScopeChainBuilder(reporter) {
    $traceurRuntime.superConstructor($ScopeChainBuilder).call(this);
    this.reporter = reporter;
    this.declarationType_ = null;
  };
  var $ScopeChainBuilder = ScopeChainBuilder;
  ($traceurRuntime.createClass)(ScopeChainBuilder, {
    visitCatch: function(tree) {
      var scope = this.pushScope(tree);
      this.declarationType_ = LET;
      this.visitAny(tree.binding);
      this.visitList(tree.catchBody.statements);
      this.popScope(scope);
    },
    visitImportedBinding: function(tree) {
      this.declarationType_ = CONST;
      $traceurRuntime.superGet(this, $ScopeChainBuilder.prototype, "visitImportedBinding").call(this, tree);
    },
    visitVariableDeclarationList: function(tree) {
      this.declarationType_ = tree.declarationType;
      $traceurRuntime.superGet(this, $ScopeChainBuilder.prototype, "visitVariableDeclarationList").call(this, tree);
    },
    visitBindingIdentifier: function(tree) {
      this.declareVariable(tree);
    },
    visitFunctionExpression: function(tree) {
      var scope = this.pushScope(tree);
      if (tree.name) {
        this.declarationType_ = CONST;
        this.visitAny(tree.name);
      }
      this.visitAny(tree.parameterList);
      this.visitAny(tree.body);
      this.popScope(scope);
    },
    visitFormalParameter: function(tree) {
      this.declarationType_ = VAR;
      $traceurRuntime.superGet(this, $ScopeChainBuilder.prototype, "visitFormalParameter").call(this, tree);
    },
    visitFunctionDeclaration: function(tree) {
      if (this.scope) {
        if (this.scope.isVarScope) {
          this.declarationType_ = VAR;
          this.visitAny(tree.name);
        } else {
          if (!this.scope.strictMode) {
            var varScope = this.scope.getVarScope();
            if (varScope) {
              varScope.addVar(tree.name, this.reporter);
            }
          }
          this.declarationType_ = LET;
          this.visitAny(tree.name);
        }
      }
      this.visitFunctionBodyForScope(tree, tree.parameterList, tree.body);
    },
    visitClassDeclaration: function(tree) {
      this.visitAny(tree.superClass);
      this.declarationType_ = LET;
      this.visitAny(tree.name);
      var scope = this.pushScope(tree);
      this.declarationType_ = CONST;
      this.visitAny(tree.name);
      this.visitList(tree.elements);
      this.popScope(scope);
    },
    visitClassExpression: function(tree) {
      this.visitAny(tree.superClass);
      var scope;
      if (tree.name) {
        scope = this.pushScope(tree);
        this.declarationType_ = CONST;
        this.visitAny(tree.name);
      }
      this.visitList(tree.elements);
      if (tree.name) {
        this.popScope(scope);
      }
    },
    visitComprehensionFor: function(tree) {
      this.declarationType_ = LET;
      $traceurRuntime.superGet(this, $ScopeChainBuilder.prototype, "visitComprehensionFor").call(this, tree);
    },
    declareVariable: function(tree) {
      this.scope.addBinding(tree, this.declarationType_, this.reporter);
    }
  }, {}, ScopeVisitor);
  return {get ScopeChainBuilder() {
      return ScopeChainBuilder;
    }};
});
System.registerModule("traceur@0.0.80/src/semantics/ConstChecker.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/ConstChecker.js";
  var IDENTIFIER_EXPRESSION = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js").IDENTIFIER_EXPRESSION;
  var $__1 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      CONST = $__1.CONST,
      MINUS_MINUS = $__1.MINUS_MINUS,
      PLUS_PLUS = $__1.PLUS_PLUS;
  var ScopeVisitor = System.get("traceur@0.0.80/src/semantics/ScopeVisitor.js").ScopeVisitor;
  var ScopeChainBuilder = System.get("traceur@0.0.80/src/semantics/ScopeChainBuilder.js").ScopeChainBuilder;
  var ConstChecker = function ConstChecker(scopeBuilder, reporter) {
    $traceurRuntime.superConstructor($ConstChecker).call(this);
    this.scopeBuilder_ = scopeBuilder;
    this.reporter_ = reporter;
  };
  var $ConstChecker = ConstChecker;
  ($traceurRuntime.createClass)(ConstChecker, {
    pushScope: function(tree) {
      return this.scope = this.scopeBuilder_.getScopeForTree(tree);
    },
    visitUnaryExpression: function(tree) {
      if (tree.operand.type === IDENTIFIER_EXPRESSION && (tree.operator.type === PLUS_PLUS || tree.operator.type === MINUS_MINUS)) {
        this.validateMutation_(tree.operand);
      }
      $traceurRuntime.superGet(this, $ConstChecker.prototype, "visitUnaryExpression").call(this, tree);
    },
    visitPostfixExpression: function(tree) {
      if (tree.operand.type === IDENTIFIER_EXPRESSION) {
        this.validateMutation_(tree.operand);
      }
      $traceurRuntime.superGet(this, $ConstChecker.prototype, "visitPostfixExpression").call(this, tree);
    },
    visitBinaryExpression: function(tree) {
      if (tree.left.type === IDENTIFIER_EXPRESSION && tree.operator.isAssignmentOperator()) {
        this.validateMutation_(tree.left);
      }
      $traceurRuntime.superGet(this, $ConstChecker.prototype, "visitBinaryExpression").call(this, tree);
    },
    validateMutation_: function(identifierExpression) {
      if (this.inWithBlock) {
        return;
      }
      var binding = this.scope.getBinding(identifierExpression);
      if (binding === null) {
        return;
      }
      var $__5 = binding,
          type = $__5.type,
          tree = $__5.tree;
      if (type === CONST) {
        this.reportError_(identifierExpression.location, (tree.getStringValue() + " is read-only"));
      }
    },
    reportError_: function(location, message) {
      this.reporter_.reportError(location.start, message);
    }
  }, {}, ScopeVisitor);
  function validate(tree, reporter) {
    var builder = new ScopeChainBuilder(reporter);
    builder.visitAny(tree);
    var checker = new ConstChecker(builder, reporter);
    checker.visitAny(tree);
  }
  return {
    get ConstChecker() {
      return ConstChecker;
    },
    get validate() {
      return validate;
    }
  };
});
System.registerModule("traceur@0.0.80/src/syntax/TokenType", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/TokenType";
  var AMPERSAND = '&';
  var AMPERSAND_EQUAL = '&=';
  var AND = '&&';
  var ARROW = '=>';
  var AT = '@';
  var BACK_QUOTE = '`';
  var BANG = '!';
  var BAR = '|';
  var BAR_EQUAL = '|=';
  var BREAK = 'break';
  var CARET = '^';
  var CARET_EQUAL = '^=';
  var CASE = 'case';
  var CATCH = 'catch';
  var CLASS = 'class';
  var CLOSE_ANGLE = '>';
  var CLOSE_CURLY = '}';
  var CLOSE_PAREN = ')';
  var CLOSE_SQUARE = ']';
  var COLON = ':';
  var COMMA = ',';
  var CONST = 'const';
  var CONTINUE = 'continue';
  var DEBUGGER = 'debugger';
  var DEFAULT = 'default';
  var DELETE = 'delete';
  var DO = 'do';
  var DOT_DOT_DOT = '...';
  var ELSE = 'else';
  var END_OF_FILE = 'End of File';
  var ENUM = 'enum';
  var EQUAL = '=';
  var EQUAL_EQUAL = '==';
  var EQUAL_EQUAL_EQUAL = '===';
  var ERROR = 'error';
  var EXPORT = 'export';
  var EXTENDS = 'extends';
  var FALSE = 'false';
  var FINALLY = 'finally';
  var FOR = 'for';
  var FUNCTION = 'function';
  var GREATER_EQUAL = '>=';
  var IDENTIFIER = 'identifier';
  var IF = 'if';
  var IMPLEMENTS = 'implements';
  var IMPORT = 'import';
  var IN = 'in';
  var INSTANCEOF = 'instanceof';
  var INTERFACE = 'interface';
  var LEFT_SHIFT = '<<';
  var LEFT_SHIFT_EQUAL = '<<=';
  var LESS_EQUAL = '<=';
  var LET = 'let';
  var MINUS = '-';
  var MINUS_EQUAL = '-=';
  var MINUS_MINUS = '--';
  var NEW = 'new';
  var NO_SUBSTITUTION_TEMPLATE = 'no substitution template';
  var NOT_EQUAL = '!=';
  var NOT_EQUAL_EQUAL = '!==';
  var NULL = 'null';
  var NUMBER = 'number literal';
  var OPEN_ANGLE = '<';
  var OPEN_CURLY = '{';
  var OPEN_PAREN = '(';
  var OPEN_SQUARE = '[';
  var OR = '||';
  var PACKAGE = 'package';
  var PERCENT = '%';
  var PERCENT_EQUAL = '%=';
  var PERIOD = '.';
  var PLUS = '+';
  var PLUS_EQUAL = '+=';
  var PLUS_PLUS = '++';
  var PRIVATE = 'private';
  var PROTECTED = 'protected';
  var PUBLIC = 'public';
  var QUESTION = '?';
  var REGULAR_EXPRESSION = 'regular expression literal';
  var RETURN = 'return';
  var RIGHT_SHIFT = '>>';
  var RIGHT_SHIFT_EQUAL = '>>=';
  var SEMI_COLON = ';';
  var SLASH = '/';
  var SLASH_EQUAL = '/=';
  var STAR = '*';
  var STAR_EQUAL = '*=';
  var STAR_STAR = '**';
  var STAR_STAR_EQUAL = '**=';
  var STATIC = 'static';
  var STRING = 'string literal';
  var SUPER = 'super';
  var SWITCH = 'switch';
  var TEMPLATE_HEAD = 'template head';
  var TEMPLATE_MIDDLE = 'template middle';
  var TEMPLATE_TAIL = 'template tail';
  var THIS = 'this';
  var THROW = 'throw';
  var TILDE = '~';
  var TRUE = 'true';
  var TRY = 'try';
  var TYPEOF = 'typeof';
  var UNSIGNED_RIGHT_SHIFT = '>>>';
  var UNSIGNED_RIGHT_SHIFT_EQUAL = '>>>=';
  var VAR = 'var';
  var VOID = 'void';
  var WHILE = 'while';
  var WITH = 'with';
  var YIELD = 'yield';
  return {
    get AMPERSAND() {
      return AMPERSAND;
    },
    get AMPERSAND_EQUAL() {
      return AMPERSAND_EQUAL;
    },
    get AND() {
      return AND;
    },
    get ARROW() {
      return ARROW;
    },
    get AT() {
      return AT;
    },
    get BACK_QUOTE() {
      return BACK_QUOTE;
    },
    get BANG() {
      return BANG;
    },
    get BAR() {
      return BAR;
    },
    get BAR_EQUAL() {
      return BAR_EQUAL;
    },
    get BREAK() {
      return BREAK;
    },
    get CARET() {
      return CARET;
    },
    get CARET_EQUAL() {
      return CARET_EQUAL;
    },
    get CASE() {
      return CASE;
    },
    get CATCH() {
      return CATCH;
    },
    get CLASS() {
      return CLASS;
    },
    get CLOSE_ANGLE() {
      return CLOSE_ANGLE;
    },
    get CLOSE_CURLY() {
      return CLOSE_CURLY;
    },
    get CLOSE_PAREN() {
      return CLOSE_PAREN;
    },
    get CLOSE_SQUARE() {
      return CLOSE_SQUARE;
    },
    get COLON() {
      return COLON;
    },
    get COMMA() {
      return COMMA;
    },
    get CONST() {
      return CONST;
    },
    get CONTINUE() {
      return CONTINUE;
    },
    get DEBUGGER() {
      return DEBUGGER;
    },
    get DEFAULT() {
      return DEFAULT;
    },
    get DELETE() {
      return DELETE;
    },
    get DO() {
      return DO;
    },
    get DOT_DOT_DOT() {
      return DOT_DOT_DOT;
    },
    get ELSE() {
      return ELSE;
    },
    get END_OF_FILE() {
      return END_OF_FILE;
    },
    get ENUM() {
      return ENUM;
    },
    get EQUAL() {
      return EQUAL;
    },
    get EQUAL_EQUAL() {
      return EQUAL_EQUAL;
    },
    get EQUAL_EQUAL_EQUAL() {
      return EQUAL_EQUAL_EQUAL;
    },
    get ERROR() {
      return ERROR;
    },
    get EXPORT() {
      return EXPORT;
    },
    get EXTENDS() {
      return EXTENDS;
    },
    get FALSE() {
      return FALSE;
    },
    get FINALLY() {
      return FINALLY;
    },
    get FOR() {
      return FOR;
    },
    get FUNCTION() {
      return FUNCTION;
    },
    get GREATER_EQUAL() {
      return GREATER_EQUAL;
    },
    get IDENTIFIER() {
      return IDENTIFIER;
    },
    get IF() {
      return IF;
    },
    get IMPLEMENTS() {
      return IMPLEMENTS;
    },
    get IMPORT() {
      return IMPORT;
    },
    get IN() {
      return IN;
    },
    get INSTANCEOF() {
      return INSTANCEOF;
    },
    get INTERFACE() {
      return INTERFACE;
    },
    get LEFT_SHIFT() {
      return LEFT_SHIFT;
    },
    get LEFT_SHIFT_EQUAL() {
      return LEFT_SHIFT_EQUAL;
    },
    get LESS_EQUAL() {
      return LESS_EQUAL;
    },
    get LET() {
      return LET;
    },
    get MINUS() {
      return MINUS;
    },
    get MINUS_EQUAL() {
      return MINUS_EQUAL;
    },
    get MINUS_MINUS() {
      return MINUS_MINUS;
    },
    get NEW() {
      return NEW;
    },
    get NO_SUBSTITUTION_TEMPLATE() {
      return NO_SUBSTITUTION_TEMPLATE;
    },
    get NOT_EQUAL() {
      return NOT_EQUAL;
    },
    get NOT_EQUAL_EQUAL() {
      return NOT_EQUAL_EQUAL;
    },
    get NULL() {
      return NULL;
    },
    get NUMBER() {
      return NUMBER;
    },
    get OPEN_ANGLE() {
      return OPEN_ANGLE;
    },
    get OPEN_CURLY() {
      return OPEN_CURLY;
    },
    get OPEN_PAREN() {
      return OPEN_PAREN;
    },
    get OPEN_SQUARE() {
      return OPEN_SQUARE;
    },
    get OR() {
      return OR;
    },
    get PACKAGE() {
      return PACKAGE;
    },
    get PERCENT() {
      return PERCENT;
    },
    get PERCENT_EQUAL() {
      return PERCENT_EQUAL;
    },
    get PERIOD() {
      return PERIOD;
    },
    get PLUS() {
      return PLUS;
    },
    get PLUS_EQUAL() {
      return PLUS_EQUAL;
    },
    get PLUS_PLUS() {
      return PLUS_PLUS;
    },
    get PRIVATE() {
      return PRIVATE;
    },
    get PROTECTED() {
      return PROTECTED;
    },
    get PUBLIC() {
      return PUBLIC;
    },
    get QUESTION() {
      return QUESTION;
    },
    get REGULAR_EXPRESSION() {
      return REGULAR_EXPRESSION;
    },
    get RETURN() {
      return RETURN;
    },
    get RIGHT_SHIFT() {
      return RIGHT_SHIFT;
    },
    get RIGHT_SHIFT_EQUAL() {
      return RIGHT_SHIFT_EQUAL;
    },
    get SEMI_COLON() {
      return SEMI_COLON;
    },
    get SLASH() {
      return SLASH;
    },
    get SLASH_EQUAL() {
      return SLASH_EQUAL;
    },
    get STAR() {
      return STAR;
    },
    get STAR_EQUAL() {
      return STAR_EQUAL;
    },
    get STAR_STAR() {
      return STAR_STAR;
    },
    get STAR_STAR_EQUAL() {
      return STAR_STAR_EQUAL;
    },
    get STATIC() {
      return STATIC;
    },
    get STRING() {
      return STRING;
    },
    get SUPER() {
      return SUPER;
    },
    get SWITCH() {
      return SWITCH;
    },
    get TEMPLATE_HEAD() {
      return TEMPLATE_HEAD;
    },
    get TEMPLATE_MIDDLE() {
      return TEMPLATE_MIDDLE;
    },
    get TEMPLATE_TAIL() {
      return TEMPLATE_TAIL;
    },
    get THIS() {
      return THIS;
    },
    get THROW() {
      return THROW;
    },
    get TILDE() {
      return TILDE;
    },
    get TRUE() {
      return TRUE;
    },
    get TRY() {
      return TRY;
    },
    get TYPEOF() {
      return TYPEOF;
    },
    get UNSIGNED_RIGHT_SHIFT() {
      return UNSIGNED_RIGHT_SHIFT;
    },
    get UNSIGNED_RIGHT_SHIFT_EQUAL() {
      return UNSIGNED_RIGHT_SHIFT_EQUAL;
    },
    get VAR() {
      return VAR;
    },
    get VOID() {
      return VOID;
    },
    get WHILE() {
      return WHILE;
    },
    get WITH() {
      return WITH;
    },
    get YIELD() {
      return YIELD;
    }
  };
});
System.registerModule("traceur@0.0.80/src/syntax/trees/ParseTreeType", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/trees/ParseTreeType";
  var ANNOTATION = 'ANNOTATION';
  var ANON_BLOCK = 'ANON_BLOCK';
  var ARGUMENT_LIST = 'ARGUMENT_LIST';
  var ARRAY_COMPREHENSION = 'ARRAY_COMPREHENSION';
  var ARRAY_LITERAL_EXPRESSION = 'ARRAY_LITERAL_EXPRESSION';
  var ARRAY_PATTERN = 'ARRAY_PATTERN';
  var ARRAY_TYPE = 'ARRAY_TYPE';
  var ARROW_FUNCTION_EXPRESSION = 'ARROW_FUNCTION_EXPRESSION';
  var ASSIGNMENT_ELEMENT = 'ASSIGNMENT_ELEMENT';
  var AWAIT_EXPRESSION = 'AWAIT_EXPRESSION';
  var BINARY_EXPRESSION = 'BINARY_EXPRESSION';
  var BINDING_ELEMENT = 'BINDING_ELEMENT';
  var BINDING_IDENTIFIER = 'BINDING_IDENTIFIER';
  var BLOCK = 'BLOCK';
  var BREAK_STATEMENT = 'BREAK_STATEMENT';
  var CALL_EXPRESSION = 'CALL_EXPRESSION';
  var CALL_SIGNATURE = 'CALL_SIGNATURE';
  var CASE_CLAUSE = 'CASE_CLAUSE';
  var CATCH = 'CATCH';
  var CLASS_DECLARATION = 'CLASS_DECLARATION';
  var CLASS_EXPRESSION = 'CLASS_EXPRESSION';
  var COMMA_EXPRESSION = 'COMMA_EXPRESSION';
  var COMPREHENSION_FOR = 'COMPREHENSION_FOR';
  var COMPREHENSION_IF = 'COMPREHENSION_IF';
  var COMPUTED_PROPERTY_NAME = 'COMPUTED_PROPERTY_NAME';
  var CONDITIONAL_EXPRESSION = 'CONDITIONAL_EXPRESSION';
  var CONSTRUCT_SIGNATURE = 'CONSTRUCT_SIGNATURE';
  var CONSTRUCTOR_TYPE = 'CONSTRUCTOR_TYPE';
  var CONTINUE_STATEMENT = 'CONTINUE_STATEMENT';
  var COVER_FORMALS = 'COVER_FORMALS';
  var COVER_INITIALIZED_NAME = 'COVER_INITIALIZED_NAME';
  var DEBUGGER_STATEMENT = 'DEBUGGER_STATEMENT';
  var DEFAULT_CLAUSE = 'DEFAULT_CLAUSE';
  var DO_WHILE_STATEMENT = 'DO_WHILE_STATEMENT';
  var EMPTY_STATEMENT = 'EMPTY_STATEMENT';
  var EXPORT_DECLARATION = 'EXPORT_DECLARATION';
  var EXPORT_DEFAULT = 'EXPORT_DEFAULT';
  var EXPORT_SPECIFIER = 'EXPORT_SPECIFIER';
  var EXPORT_SPECIFIER_SET = 'EXPORT_SPECIFIER_SET';
  var EXPORT_STAR = 'EXPORT_STAR';
  var EXPRESSION_STATEMENT = 'EXPRESSION_STATEMENT';
  var FINALLY = 'FINALLY';
  var FOR_IN_STATEMENT = 'FOR_IN_STATEMENT';
  var FOR_OF_STATEMENT = 'FOR_OF_STATEMENT';
  var FOR_STATEMENT = 'FOR_STATEMENT';
  var FORMAL_PARAMETER = 'FORMAL_PARAMETER';
  var FORMAL_PARAMETER_LIST = 'FORMAL_PARAMETER_LIST';
  var FUNCTION_BODY = 'FUNCTION_BODY';
  var FUNCTION_DECLARATION = 'FUNCTION_DECLARATION';
  var FUNCTION_EXPRESSION = 'FUNCTION_EXPRESSION';
  var FUNCTION_TYPE = 'FUNCTION_TYPE';
  var GENERATOR_COMPREHENSION = 'GENERATOR_COMPREHENSION';
  var GET_ACCESSOR = 'GET_ACCESSOR';
  var IDENTIFIER_EXPRESSION = 'IDENTIFIER_EXPRESSION';
  var IF_STATEMENT = 'IF_STATEMENT';
  var IMPORT_DECLARATION = 'IMPORT_DECLARATION';
  var IMPORT_SPECIFIER = 'IMPORT_SPECIFIER';
  var IMPORT_SPECIFIER_SET = 'IMPORT_SPECIFIER_SET';
  var IMPORTED_BINDING = 'IMPORTED_BINDING';
  var INDEX_SIGNATURE = 'INDEX_SIGNATURE';
  var INTERFACE_DECLARATION = 'INTERFACE_DECLARATION';
  var LABELLED_STATEMENT = 'LABELLED_STATEMENT';
  var LITERAL_EXPRESSION = 'LITERAL_EXPRESSION';
  var LITERAL_PROPERTY_NAME = 'LITERAL_PROPERTY_NAME';
  var MEMBER_EXPRESSION = 'MEMBER_EXPRESSION';
  var MEMBER_LOOKUP_EXPRESSION = 'MEMBER_LOOKUP_EXPRESSION';
  var METHOD_SIGNATURE = 'METHOD_SIGNATURE';
  var MODULE = 'MODULE';
  var MODULE_DECLARATION = 'MODULE_DECLARATION';
  var MODULE_SPECIFIER = 'MODULE_SPECIFIER';
  var NAMED_EXPORT = 'NAMED_EXPORT';
  var NEW_EXPRESSION = 'NEW_EXPRESSION';
  var OBJECT_LITERAL_EXPRESSION = 'OBJECT_LITERAL_EXPRESSION';
  var OBJECT_PATTERN = 'OBJECT_PATTERN';
  var OBJECT_PATTERN_FIELD = 'OBJECT_PATTERN_FIELD';
  var OBJECT_TYPE = 'OBJECT_TYPE';
  var PAREN_EXPRESSION = 'PAREN_EXPRESSION';
  var POSTFIX_EXPRESSION = 'POSTFIX_EXPRESSION';
  var PREDEFINED_TYPE = 'PREDEFINED_TYPE';
  var PROPERTY_METHOD_ASSIGNMENT = 'PROPERTY_METHOD_ASSIGNMENT';
  var PROPERTY_NAME_ASSIGNMENT = 'PROPERTY_NAME_ASSIGNMENT';
  var PROPERTY_NAME_SHORTHAND = 'PROPERTY_NAME_SHORTHAND';
  var PROPERTY_SIGNATURE = 'PROPERTY_SIGNATURE';
  var PROPERTY_VARIABLE_DECLARATION = 'PROPERTY_VARIABLE_DECLARATION';
  var REST_PARAMETER = 'REST_PARAMETER';
  var RETURN_STATEMENT = 'RETURN_STATEMENT';
  var SCRIPT = 'SCRIPT';
  var SET_ACCESSOR = 'SET_ACCESSOR';
  var SPREAD_EXPRESSION = 'SPREAD_EXPRESSION';
  var SPREAD_PATTERN_ELEMENT = 'SPREAD_PATTERN_ELEMENT';
  var STATE_MACHINE = 'STATE_MACHINE';
  var SUPER_EXPRESSION = 'SUPER_EXPRESSION';
  var SWITCH_STATEMENT = 'SWITCH_STATEMENT';
  var SYNTAX_ERROR_TREE = 'SYNTAX_ERROR_TREE';
  var TEMPLATE_LITERAL_EXPRESSION = 'TEMPLATE_LITERAL_EXPRESSION';
  var TEMPLATE_LITERAL_PORTION = 'TEMPLATE_LITERAL_PORTION';
  var TEMPLATE_SUBSTITUTION = 'TEMPLATE_SUBSTITUTION';
  var THIS_EXPRESSION = 'THIS_EXPRESSION';
  var THROW_STATEMENT = 'THROW_STATEMENT';
  var TRY_STATEMENT = 'TRY_STATEMENT';
  var TYPE_ARGUMENTS = 'TYPE_ARGUMENTS';
  var TYPE_NAME = 'TYPE_NAME';
  var TYPE_PARAMETER = 'TYPE_PARAMETER';
  var TYPE_PARAMETERS = 'TYPE_PARAMETERS';
  var TYPE_REFERENCE = 'TYPE_REFERENCE';
  var UNARY_EXPRESSION = 'UNARY_EXPRESSION';
  var UNION_TYPE = 'UNION_TYPE';
  var VARIABLE_DECLARATION = 'VARIABLE_DECLARATION';
  var VARIABLE_DECLARATION_LIST = 'VARIABLE_DECLARATION_LIST';
  var VARIABLE_STATEMENT = 'VARIABLE_STATEMENT';
  var WHILE_STATEMENT = 'WHILE_STATEMENT';
  var WITH_STATEMENT = 'WITH_STATEMENT';
  var YIELD_EXPRESSION = 'YIELD_EXPRESSION';
  return {
    get ANNOTATION() {
      return ANNOTATION;
    },
    get ANON_BLOCK() {
      return ANON_BLOCK;
    },
    get ARGUMENT_LIST() {
      return ARGUMENT_LIST;
    },
    get ARRAY_COMPREHENSION() {
      return ARRAY_COMPREHENSION;
    },
    get ARRAY_LITERAL_EXPRESSION() {
      return ARRAY_LITERAL_EXPRESSION;
    },
    get ARRAY_PATTERN() {
      return ARRAY_PATTERN;
    },
    get ARRAY_TYPE() {
      return ARRAY_TYPE;
    },
    get ARROW_FUNCTION_EXPRESSION() {
      return ARROW_FUNCTION_EXPRESSION;
    },
    get ASSIGNMENT_ELEMENT() {
      return ASSIGNMENT_ELEMENT;
    },
    get AWAIT_EXPRESSION() {
      return AWAIT_EXPRESSION;
    },
    get BINARY_EXPRESSION() {
      return BINARY_EXPRESSION;
    },
    get BINDING_ELEMENT() {
      return BINDING_ELEMENT;
    },
    get BINDING_IDENTIFIER() {
      return BINDING_IDENTIFIER;
    },
    get BLOCK() {
      return BLOCK;
    },
    get BREAK_STATEMENT() {
      return BREAK_STATEMENT;
    },
    get CALL_EXPRESSION() {
      return CALL_EXPRESSION;
    },
    get CALL_SIGNATURE() {
      return CALL_SIGNATURE;
    },
    get CASE_CLAUSE() {
      return CASE_CLAUSE;
    },
    get CATCH() {
      return CATCH;
    },
    get CLASS_DECLARATION() {
      return CLASS_DECLARATION;
    },
    get CLASS_EXPRESSION() {
      return CLASS_EXPRESSION;
    },
    get COMMA_EXPRESSION() {
      return COMMA_EXPRESSION;
    },
    get COMPREHENSION_FOR() {
      return COMPREHENSION_FOR;
    },
    get COMPREHENSION_IF() {
      return COMPREHENSION_IF;
    },
    get COMPUTED_PROPERTY_NAME() {
      return COMPUTED_PROPERTY_NAME;
    },
    get CONDITIONAL_EXPRESSION() {
      return CONDITIONAL_EXPRESSION;
    },
    get CONSTRUCT_SIGNATURE() {
      return CONSTRUCT_SIGNATURE;
    },
    get CONSTRUCTOR_TYPE() {
      return CONSTRUCTOR_TYPE;
    },
    get CONTINUE_STATEMENT() {
      return CONTINUE_STATEMENT;
    },
    get COVER_FORMALS() {
      return COVER_FORMALS;
    },
    get COVER_INITIALIZED_NAME() {
      return COVER_INITIALIZED_NAME;
    },
    get DEBUGGER_STATEMENT() {
      return DEBUGGER_STATEMENT;
    },
    get DEFAULT_CLAUSE() {
      return DEFAULT_CLAUSE;
    },
    get DO_WHILE_STATEMENT() {
      return DO_WHILE_STATEMENT;
    },
    get EMPTY_STATEMENT() {
      return EMPTY_STATEMENT;
    },
    get EXPORT_DECLARATION() {
      return EXPORT_DECLARATION;
    },
    get EXPORT_DEFAULT() {
      return EXPORT_DEFAULT;
    },
    get EXPORT_SPECIFIER() {
      return EXPORT_SPECIFIER;
    },
    get EXPORT_SPECIFIER_SET() {
      return EXPORT_SPECIFIER_SET;
    },
    get EXPORT_STAR() {
      return EXPORT_STAR;
    },
    get EXPRESSION_STATEMENT() {
      return EXPRESSION_STATEMENT;
    },
    get FINALLY() {
      return FINALLY;
    },
    get FOR_IN_STATEMENT() {
      return FOR_IN_STATEMENT;
    },
    get FOR_OF_STATEMENT() {
      return FOR_OF_STATEMENT;
    },
    get FOR_STATEMENT() {
      return FOR_STATEMENT;
    },
    get FORMAL_PARAMETER() {
      return FORMAL_PARAMETER;
    },
    get FORMAL_PARAMETER_LIST() {
      return FORMAL_PARAMETER_LIST;
    },
    get FUNCTION_BODY() {
      return FUNCTION_BODY;
    },
    get FUNCTION_DECLARATION() {
      return FUNCTION_DECLARATION;
    },
    get FUNCTION_EXPRESSION() {
      return FUNCTION_EXPRESSION;
    },
    get FUNCTION_TYPE() {
      return FUNCTION_TYPE;
    },
    get GENERATOR_COMPREHENSION() {
      return GENERATOR_COMPREHENSION;
    },
    get GET_ACCESSOR() {
      return GET_ACCESSOR;
    },
    get IDENTIFIER_EXPRESSION() {
      return IDENTIFIER_EXPRESSION;
    },
    get IF_STATEMENT() {
      return IF_STATEMENT;
    },
    get IMPORT_DECLARATION() {
      return IMPORT_DECLARATION;
    },
    get IMPORT_SPECIFIER() {
      return IMPORT_SPECIFIER;
    },
    get IMPORT_SPECIFIER_SET() {
      return IMPORT_SPECIFIER_SET;
    },
    get IMPORTED_BINDING() {
      return IMPORTED_BINDING;
    },
    get INDEX_SIGNATURE() {
      return INDEX_SIGNATURE;
    },
    get INTERFACE_DECLARATION() {
      return INTERFACE_DECLARATION;
    },
    get LABELLED_STATEMENT() {
      return LABELLED_STATEMENT;
    },
    get LITERAL_EXPRESSION() {
      return LITERAL_EXPRESSION;
    },
    get LITERAL_PROPERTY_NAME() {
      return LITERAL_PROPERTY_NAME;
    },
    get MEMBER_EXPRESSION() {
      return MEMBER_EXPRESSION;
    },
    get MEMBER_LOOKUP_EXPRESSION() {
      return MEMBER_LOOKUP_EXPRESSION;
    },
    get METHOD_SIGNATURE() {
      return METHOD_SIGNATURE;
    },
    get MODULE() {
      return MODULE;
    },
    get MODULE_DECLARATION() {
      return MODULE_DECLARATION;
    },
    get MODULE_SPECIFIER() {
      return MODULE_SPECIFIER;
    },
    get NAMED_EXPORT() {
      return NAMED_EXPORT;
    },
    get NEW_EXPRESSION() {
      return NEW_EXPRESSION;
    },
    get OBJECT_LITERAL_EXPRESSION() {
      return OBJECT_LITERAL_EXPRESSION;
    },
    get OBJECT_PATTERN() {
      return OBJECT_PATTERN;
    },
    get OBJECT_PATTERN_FIELD() {
      return OBJECT_PATTERN_FIELD;
    },
    get OBJECT_TYPE() {
      return OBJECT_TYPE;
    },
    get PAREN_EXPRESSION() {
      return PAREN_EXPRESSION;
    },
    get POSTFIX_EXPRESSION() {
      return POSTFIX_EXPRESSION;
    },
    get PREDEFINED_TYPE() {
      return PREDEFINED_TYPE;
    },
    get PROPERTY_METHOD_ASSIGNMENT() {
      return PROPERTY_METHOD_ASSIGNMENT;
    },
    get PROPERTY_NAME_ASSIGNMENT() {
      return PROPERTY_NAME_ASSIGNMENT;
    },
    get PROPERTY_NAME_SHORTHAND() {
      return PROPERTY_NAME_SHORTHAND;
    },
    get PROPERTY_SIGNATURE() {
      return PROPERTY_SIGNATURE;
    },
    get PROPERTY_VARIABLE_DECLARATION() {
      return PROPERTY_VARIABLE_DECLARATION;
    },
    get REST_PARAMETER() {
      return REST_PARAMETER;
    },
    get RETURN_STATEMENT() {
      return RETURN_STATEMENT;
    },
    get SCRIPT() {
      return SCRIPT;
    },
    get SET_ACCESSOR() {
      return SET_ACCESSOR;
    },
    get SPREAD_EXPRESSION() {
      return SPREAD_EXPRESSION;
    },
    get SPREAD_PATTERN_ELEMENT() {
      return SPREAD_PATTERN_ELEMENT;
    },
    get STATE_MACHINE() {
      return STATE_MACHINE;
    },
    get SUPER_EXPRESSION() {
      return SUPER_EXPRESSION;
    },
    get SWITCH_STATEMENT() {
      return SWITCH_STATEMENT;
    },
    get SYNTAX_ERROR_TREE() {
      return SYNTAX_ERROR_TREE;
    },
    get TEMPLATE_LITERAL_EXPRESSION() {
      return TEMPLATE_LITERAL_EXPRESSION;
    },
    get TEMPLATE_LITERAL_PORTION() {
      return TEMPLATE_LITERAL_PORTION;
    },
    get TEMPLATE_SUBSTITUTION() {
      return TEMPLATE_SUBSTITUTION;
    },
    get THIS_EXPRESSION() {
      return THIS_EXPRESSION;
    },
    get THROW_STATEMENT() {
      return THROW_STATEMENT;
    },
    get TRY_STATEMENT() {
      return TRY_STATEMENT;
    },
    get TYPE_ARGUMENTS() {
      return TYPE_ARGUMENTS;
    },
    get TYPE_NAME() {
      return TYPE_NAME;
    },
    get TYPE_PARAMETER() {
      return TYPE_PARAMETER;
    },
    get TYPE_PARAMETERS() {
      return TYPE_PARAMETERS;
    },
    get TYPE_REFERENCE() {
      return TYPE_REFERENCE;
    },
    get UNARY_EXPRESSION() {
      return UNARY_EXPRESSION;
    },
    get UNION_TYPE() {
      return UNION_TYPE;
    },
    get VARIABLE_DECLARATION() {
      return VARIABLE_DECLARATION;
    },
    get VARIABLE_DECLARATION_LIST() {
      return VARIABLE_DECLARATION_LIST;
    },
    get VARIABLE_STATEMENT() {
      return VARIABLE_STATEMENT;
    },
    get WHILE_STATEMENT() {
      return WHILE_STATEMENT;
    },
    get WITH_STATEMENT() {
      return WITH_STATEMENT;
    },
    get YIELD_EXPRESSION() {
      return YIELD_EXPRESSION;
    }
  };
});
System.registerModule("traceur@0.0.80/src/semantics/Scope", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/Scope";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      BLOCK = $__0.BLOCK,
      CATCH = $__0.CATCH;
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var isTreeStrict = System.get("traceur@0.0.80/src/semantics/isTreeStrict.js").isTreeStrict;
  function reportDuplicateVar(reporter, tree, name) {
    reporter.reportError(tree.location && tree.location.start, ("Duplicate declaration, " + name));
  }
  var Scope = function Scope(parent, tree) {
    this.parent = parent;
    this.tree = tree;
    this.variableDeclarations = Object.create(null);
    this.lexicalDeclarations = Object.create(null);
    this.strictMode = parent && parent.strictMode || isTreeStrict(tree);
  };
  ($traceurRuntime.createClass)(Scope, {
    addBinding: function(tree, type, reporter) {
      if (type === VAR) {
        this.addVar(tree, reporter);
      } else {
        this.addDeclaration(tree, type, reporter);
      }
    },
    addVar: function(tree, reporter) {
      var name = tree.getStringValue();
      if (this.lexicalDeclarations[name]) {
        reportDuplicateVar(reporter, tree, name);
        return;
      }
      this.variableDeclarations[name] = {
        type: VAR,
        tree: tree
      };
      if (!this.isVarScope && this.parent) {
        this.parent.addVar(tree, reporter);
      }
    },
    addDeclaration: function(tree, type, reporter) {
      var name = tree.getStringValue();
      if (this.lexicalDeclarations[name] || this.variableDeclarations[name]) {
        reportDuplicateVar(reporter, tree, name);
        return;
      }
      this.lexicalDeclarations[name] = {
        type: type,
        tree: tree
      };
    },
    renameBinding: function(oldName, newTree, newType, reporter) {
      var name = newTree.getStringValue();
      if (newType == VAR) {
        if (this.lexicalDeclarations[oldName]) {
          delete this.lexicalDeclarations[oldName];
          this.addVar(newTree, reporter);
        }
      } else if (this.variableDeclarations[oldName]) {
        delete this.variableDeclarations[oldName];
        this.addDeclaration(newTree, newType, reporter);
        if (!this.isVarScope && this.parent) {
          this.parent.renameBinding(oldName, newTree, newType);
        }
      }
    },
    get isVarScope() {
      switch (this.tree.type) {
        case BLOCK:
        case CATCH:
          return false;
      }
      return true;
    },
    getVarScope: function() {
      if (this.isVarScope) {
        return this;
      }
      if (this.parent) {
        return this.parent.getVarScope();
      }
      return null;
    },
    getBinding: function(tree) {
      var name = tree.getStringValue();
      return this.getBindingByName(name);
    },
    getBindingByName: function(name) {
      var b = this.lexicalDeclarations[name];
      if (b) {
        return b;
      }
      b = this.variableDeclarations[name];
      if (b && this.isVarScope) {
        return b;
      }
      if (this.parent) {
        return this.parent.getBindingByName(name);
      }
      return null;
    },
    getAllBindingNames: function() {
      var names = Object.create(null);
      var name;
      for (name in this.variableDeclarations) {
        names[name] = true;
      }
      for (name in this.lexicalDeclarations) {
        names[name] = true;
      }
      return names;
    },
    getVariableBindingNames: function() {
      var names = Object.create(null);
      for (var name in this.variableDeclarations) {
        names[name] = true;
      }
      return names;
    },
    getLexicalBindingNames: function() {
      var names = Object.create(null);
      for (var name in this.lexicalDeclarations) {
        names[name] = true;
      }
      return names;
    },
    hasBindingName: function(name) {
      return this.lexicalDeclarations[name] || this.variableDeclarations[name];
    },
    hasLexicalBindingName: function(name) {
      return this.lexicalDeclarations[name];
    },
    hasVariableBindingName: function(name) {
      return this.variableDeclarations[name];
    }
  }, {});
  return {get Scope() {
      return Scope;
    }};
});
System.registerModule("traceur@0.0.80/src/semantics/ScopeReferences.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/ScopeReferences.js";
  var Scope = System.get("traceur@0.0.80/src/semantics/Scope").Scope;
  var ScopeReferences = function ScopeReferences(parent, tree) {
    $traceurRuntime.superConstructor($ScopeReferences).call(this, parent, tree);
    this.freeVars_ = Object.create(null);
  };
  var $ScopeReferences = ScopeReferences;
  ($traceurRuntime.createClass)(ScopeReferences, {
    addReference: function(name, tree) {
      if (!this.freeVars_[name]) {
        this.freeVars_[name] = [];
      }
      this.freeVars_[name].push(tree);
    },
    hasFreeVariable: function(name) {
      return !!this.freeVars_[name];
    }
  }, {}, Scope);
  return {get ScopeReferences() {
      return ScopeReferences;
    }};
});
System.registerModule("traceur@0.0.80/src/semantics/ScopeChainBuilderWithReferences.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/ScopeChainBuilderWithReferences.js";
  var ScopeChainBuilder = System.get("traceur@0.0.80/src/semantics/ScopeChainBuilder.js").ScopeChainBuilder;
  var ScopeReferences = System.get("traceur@0.0.80/src/semantics/ScopeReferences.js").ScopeReferences;
  var $__2 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType"),
      FUNCTION_DECLARATION = $__2.FUNCTION_DECLARATION,
      FUNCTION_EXPRESSION = $__2.FUNCTION_EXPRESSION,
      GET_ACCESSOR = $__2.GET_ACCESSOR,
      IDENTIFIER_EXPRESSION = $__2.IDENTIFIER_EXPRESSION,
      MODULE = $__2.MODULE,
      PROPERTY_METHOD_ASSIGNMENT = $__2.PROPERTY_METHOD_ASSIGNMENT,
      SET_ACCESSOR = $__2.SET_ACCESSOR;
  var TYPEOF = System.get("traceur@0.0.80/src/syntax/TokenType").TYPEOF;
  function hasArgumentsInScope(scope) {
    for (; scope; scope = scope.parent) {
      switch (scope.tree.type) {
        case FUNCTION_DECLARATION:
        case FUNCTION_EXPRESSION:
        case GET_ACCESSOR:
        case PROPERTY_METHOD_ASSIGNMENT:
        case SET_ACCESSOR:
          return true;
      }
    }
    return false;
  }
  function inModuleScope(scope) {
    for (; scope; scope = scope.parent) {
      if (scope.tree.type === MODULE) {
        return true;
      }
    }
    return false;
  }
  var ScopeChainBuilderWithReferences = function ScopeChainBuilderWithReferences() {
    $traceurRuntime.superConstructor($ScopeChainBuilderWithReferences).apply(this, arguments);
  };
  var $ScopeChainBuilderWithReferences = ScopeChainBuilderWithReferences;
  ($traceurRuntime.createClass)(ScopeChainBuilderWithReferences, {
    createScope: function(tree) {
      return new ScopeReferences(this.scope, tree);
    },
    visitIdentifierExpression: function(tree) {
      if (this.inWithBlock) {
        return;
      }
      var scope = this.scope;
      var name = tree.getStringValue();
      if (name === 'arguments' && hasArgumentsInScope(scope)) {
        return;
      }
      if (name === '__moduleName' && inModuleScope(scope)) {
        return;
      }
      this.referenceFound(tree, name);
    },
    visitUnaryExpression: function(tree) {
      if (tree.operator.type === TYPEOF && tree.operand.type === IDENTIFIER_EXPRESSION) {
        var scope = this.scope;
        var binding = scope.getBinding(tree.operand);
        if (!binding) {
          scope.addVar(tree.operand, this.reporter);
        }
      } else {
        $traceurRuntime.superGet(this, $ScopeChainBuilderWithReferences.prototype, "visitUnaryExpression").call(this, tree);
      }
    },
    referenceFound: function(tree, name) {
      this.scope.addReference(name, tree);
    }
  }, {}, ScopeChainBuilder);
  return {get ScopeChainBuilderWithReferences() {
      return ScopeChainBuilderWithReferences;
    }};
});
System.registerModule("traceur@0.0.80/src/semantics/FreeVariableChecker.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/FreeVariableChecker.js";
  var ScopeChainBuilderWithReferences = System.get("traceur@0.0.80/src/semantics/ScopeChainBuilderWithReferences.js").ScopeChainBuilderWithReferences;
  var FreeVariableChecker = function FreeVariableChecker(reporter, global) {
    $traceurRuntime.superConstructor($FreeVariableChecker).call(this, reporter);
    this.global_ = global;
  };
  var $FreeVariableChecker = FreeVariableChecker;
  ($traceurRuntime.createClass)(FreeVariableChecker, {referenceFound: function(tree, name) {
      if (this.scope.getBinding(tree))
        return;
      if (!(name in this.global_)) {
        this.reporter.reportError(tree.location.start, (name + " is not defined"));
      }
    }}, {}, ScopeChainBuilderWithReferences);
  function validate(tree, reporter) {
    var global = arguments[2] !== (void 0) ? arguments[2] : Reflect.global;
    var checker = new FreeVariableChecker(reporter, global);
    checker.visitAny(tree);
  }
  return {get validate() {
      return validate;
    }};
});
System.registerModule("traceur@0.0.80/src/util/JSON.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/util/JSON.js";
  function transform(v) {
    var replacer = arguments[1] !== (void 0) ? arguments[1] : (function(k, v) {
      return v;
    });
    return transform_(replacer('', v), replacer);
  }
  function transform_(v, replacer) {
    var rv,
        tv;
    if (Array.isArray(v)) {
      var len = v.length;
      rv = Array(len);
      for (var i = 0; i < len; i++) {
        tv = transform_(replacer(String(i), v[i]), replacer);
        rv[i] = tv === undefined ? null : tv;
      }
      return rv;
    }
    if (v instanceof Object) {
      rv = {};
      Object.keys(v).forEach((function(k) {
        tv = transform_(replacer(k, v[k]), replacer);
        if (tv !== undefined) {
          rv[k] = tv;
        }
      }));
      return rv;
    }
    return v;
  }
  return {get transform() {
      return transform;
    }};
});
System.registerModule("traceur@0.0.80/src/syntax/Token.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/Token.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      AMPERSAND_EQUAL = $__0.AMPERSAND_EQUAL,
      BAR_EQUAL = $__0.BAR_EQUAL,
      CARET_EQUAL = $__0.CARET_EQUAL,
      EQUAL = $__0.EQUAL,
      LEFT_SHIFT_EQUAL = $__0.LEFT_SHIFT_EQUAL,
      MINUS_EQUAL = $__0.MINUS_EQUAL,
      PERCENT_EQUAL = $__0.PERCENT_EQUAL,
      PLUS_EQUAL = $__0.PLUS_EQUAL,
      RIGHT_SHIFT_EQUAL = $__0.RIGHT_SHIFT_EQUAL,
      SLASH_EQUAL = $__0.SLASH_EQUAL,
      STAR_EQUAL = $__0.STAR_EQUAL,
      STAR_STAR_EQUAL = $__0.STAR_STAR_EQUAL,
      UNSIGNED_RIGHT_SHIFT_EQUAL = $__0.UNSIGNED_RIGHT_SHIFT_EQUAL;
  var Token = function Token(type, location) {
    this.type = type;
    this.location = location;
  };
  ($traceurRuntime.createClass)(Token, {
    toString: function() {
      return this.type;
    },
    isAssignmentOperator: function() {
      return isAssignmentOperator(this.type);
    },
    isKeyword: function() {
      return false;
    },
    isStrictKeyword: function() {
      return false;
    }
  }, {});
  function isAssignmentOperator(type) {
    switch (type) {
      case AMPERSAND_EQUAL:
      case BAR_EQUAL:
      case CARET_EQUAL:
      case EQUAL:
      case LEFT_SHIFT_EQUAL:
      case MINUS_EQUAL:
      case PERCENT_EQUAL:
      case PLUS_EQUAL:
      case RIGHT_SHIFT_EQUAL:
      case SLASH_EQUAL:
      case STAR_EQUAL:
      case STAR_STAR_EQUAL:
      case UNSIGNED_RIGHT_SHIFT_EQUAL:
        return true;
    }
    return false;
  }
  return {
    get Token() {
      return Token;
    },
    get isAssignmentOperator() {
      return isAssignmentOperator;
    }
  };
});
System.registerModule("traceur@0.0.80/src/syntax/trees/ParseTree.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/trees/ParseTree.js";
  var ParseTreeType = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js");
  var $__0 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      IDENTIFIER = $__0.IDENTIFIER,
      STAR = $__0.STAR,
      STRING = $__0.STRING,
      VAR = $__0.VAR;
  var Token = System.get("traceur@0.0.80/src/syntax/Token.js").Token;
  var utilJSON = System.get("traceur@0.0.80/src/util/JSON.js");
  var ASYNC = System.get("traceur@0.0.80/src/syntax/PredefinedName.js").ASYNC;
  var $__3 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      ARRAY_COMPREHENSION = $__3.ARRAY_COMPREHENSION,
      ARRAY_LITERAL_EXPRESSION = $__3.ARRAY_LITERAL_EXPRESSION,
      ARRAY_PATTERN = $__3.ARRAY_PATTERN,
      ARROW_FUNCTION_EXPRESSION = $__3.ARROW_FUNCTION_EXPRESSION,
      AWAIT_EXPRESSION = $__3.AWAIT_EXPRESSION,
      BINARY_EXPRESSION = $__3.BINARY_EXPRESSION,
      BINDING_IDENTIFIER = $__3.BINDING_IDENTIFIER,
      BLOCK = $__3.BLOCK,
      BREAK_STATEMENT = $__3.BREAK_STATEMENT,
      CALL_EXPRESSION = $__3.CALL_EXPRESSION,
      CLASS_DECLARATION = $__3.CLASS_DECLARATION,
      CLASS_EXPRESSION = $__3.CLASS_EXPRESSION,
      COMMA_EXPRESSION = $__3.COMMA_EXPRESSION,
      CONDITIONAL_EXPRESSION = $__3.CONDITIONAL_EXPRESSION,
      CONTINUE_STATEMENT = $__3.CONTINUE_STATEMENT,
      DEBUGGER_STATEMENT = $__3.DEBUGGER_STATEMENT,
      DO_WHILE_STATEMENT = $__3.DO_WHILE_STATEMENT,
      EMPTY_STATEMENT = $__3.EMPTY_STATEMENT,
      EXPORT_DECLARATION = $__3.EXPORT_DECLARATION,
      EXPRESSION_STATEMENT = $__3.EXPRESSION_STATEMENT,
      FORMAL_PARAMETER = $__3.FORMAL_PARAMETER,
      FOR_IN_STATEMENT = $__3.FOR_IN_STATEMENT,
      FOR_OF_STATEMENT = $__3.FOR_OF_STATEMENT,
      FOR_STATEMENT = $__3.FOR_STATEMENT,
      FUNCTION_DECLARATION = $__3.FUNCTION_DECLARATION,
      FUNCTION_EXPRESSION = $__3.FUNCTION_EXPRESSION,
      GENERATOR_COMPREHENSION = $__3.GENERATOR_COMPREHENSION,
      IDENTIFIER_EXPRESSION = $__3.IDENTIFIER_EXPRESSION,
      IF_STATEMENT = $__3.IF_STATEMENT,
      IMPORTED_BINDING = $__3.IMPORTED_BINDING,
      IMPORT_DECLARATION = $__3.IMPORT_DECLARATION,
      INTERFACE_DECLARATION = $__3.INTERFACE_DECLARATION,
      LABELLED_STATEMENT = $__3.LABELLED_STATEMENT,
      LITERAL_EXPRESSION = $__3.LITERAL_EXPRESSION,
      MEMBER_EXPRESSION = $__3.MEMBER_EXPRESSION,
      MEMBER_LOOKUP_EXPRESSION = $__3.MEMBER_LOOKUP_EXPRESSION,
      MODULE_DECLARATION = $__3.MODULE_DECLARATION,
      NEW_EXPRESSION = $__3.NEW_EXPRESSION,
      OBJECT_LITERAL_EXPRESSION = $__3.OBJECT_LITERAL_EXPRESSION,
      OBJECT_PATTERN = $__3.OBJECT_PATTERN,
      PAREN_EXPRESSION = $__3.PAREN_EXPRESSION,
      POSTFIX_EXPRESSION = $__3.POSTFIX_EXPRESSION,
      PREDEFINED_TYPE = $__3.PREDEFINED_TYPE,
      PROPERTY_NAME_SHORTHAND = $__3.PROPERTY_NAME_SHORTHAND,
      REST_PARAMETER = $__3.REST_PARAMETER,
      RETURN_STATEMENT = $__3.RETURN_STATEMENT,
      SPREAD_EXPRESSION = $__3.SPREAD_EXPRESSION,
      SPREAD_PATTERN_ELEMENT = $__3.SPREAD_PATTERN_ELEMENT,
      SUPER_EXPRESSION = $__3.SUPER_EXPRESSION,
      SWITCH_STATEMENT = $__3.SWITCH_STATEMENT,
      TEMPLATE_LITERAL_EXPRESSION = $__3.TEMPLATE_LITERAL_EXPRESSION,
      THIS_EXPRESSION = $__3.THIS_EXPRESSION,
      THROW_STATEMENT = $__3.THROW_STATEMENT,
      TRY_STATEMENT = $__3.TRY_STATEMENT,
      TYPE_REFERENCE = $__3.TYPE_REFERENCE,
      UNARY_EXPRESSION = $__3.UNARY_EXPRESSION,
      VARIABLE_DECLARATION = $__3.VARIABLE_DECLARATION,
      VARIABLE_STATEMENT = $__3.VARIABLE_STATEMENT,
      WHILE_STATEMENT = $__3.WHILE_STATEMENT,
      WITH_STATEMENT = $__3.WITH_STATEMENT,
      YIELD_EXPRESSION = $__3.YIELD_EXPRESSION;
  ;
  var ParseTree = function ParseTree(type, location) {
    throw new Error("Don't use for now. 'super' is currently very slow.");
    this.type = type;
    this.location = location;
  };
  var $ParseTree = ParseTree;
  ($traceurRuntime.createClass)(ParseTree, {
    isPattern: function() {
      switch (this.type) {
        case ARRAY_PATTERN:
        case OBJECT_PATTERN:
          return true;
        default:
          return false;
      }
    },
    isLeftHandSideExpression: function() {
      switch (this.type) {
        case THIS_EXPRESSION:
        case CLASS_EXPRESSION:
        case SUPER_EXPRESSION:
        case IDENTIFIER_EXPRESSION:
        case LITERAL_EXPRESSION:
        case ARRAY_LITERAL_EXPRESSION:
        case OBJECT_LITERAL_EXPRESSION:
        case NEW_EXPRESSION:
        case MEMBER_EXPRESSION:
        case MEMBER_LOOKUP_EXPRESSION:
        case CALL_EXPRESSION:
        case FUNCTION_EXPRESSION:
        case TEMPLATE_LITERAL_EXPRESSION:
          return true;
        case PAREN_EXPRESSION:
          return this.expression.isLeftHandSideExpression();
        default:
          return false;
      }
    },
    isAssignmentExpression: function() {
      switch (this.type) {
        case ARRAY_COMPREHENSION:
        case ARRAY_LITERAL_EXPRESSION:
        case ARROW_FUNCTION_EXPRESSION:
        case AWAIT_EXPRESSION:
        case BINARY_EXPRESSION:
        case CALL_EXPRESSION:
        case CLASS_EXPRESSION:
        case CONDITIONAL_EXPRESSION:
        case FUNCTION_EXPRESSION:
        case GENERATOR_COMPREHENSION:
        case IDENTIFIER_EXPRESSION:
        case LITERAL_EXPRESSION:
        case MEMBER_EXPRESSION:
        case MEMBER_LOOKUP_EXPRESSION:
        case NEW_EXPRESSION:
        case OBJECT_LITERAL_EXPRESSION:
        case PAREN_EXPRESSION:
        case POSTFIX_EXPRESSION:
        case TEMPLATE_LITERAL_EXPRESSION:
        case SUPER_EXPRESSION:
        case THIS_EXPRESSION:
        case UNARY_EXPRESSION:
        case YIELD_EXPRESSION:
          return true;
        default:
          return false;
      }
    },
    isMemberExpression: function() {
      switch (this.type) {
        case THIS_EXPRESSION:
        case CLASS_EXPRESSION:
        case SUPER_EXPRESSION:
        case IDENTIFIER_EXPRESSION:
        case LITERAL_EXPRESSION:
        case ARRAY_LITERAL_EXPRESSION:
        case OBJECT_LITERAL_EXPRESSION:
        case PAREN_EXPRESSION:
        case TEMPLATE_LITERAL_EXPRESSION:
        case FUNCTION_EXPRESSION:
        case MEMBER_LOOKUP_EXPRESSION:
        case MEMBER_EXPRESSION:
        case CALL_EXPRESSION:
          return true;
        case NEW_EXPRESSION:
          return this.args != null;
      }
      return false;
    },
    isExpression: function() {
      return this.isAssignmentExpression() || this.type == COMMA_EXPRESSION;
    },
    isAssignmentOrSpread: function() {
      return this.isAssignmentExpression() || this.type == SPREAD_EXPRESSION;
    },
    isRestParameter: function() {
      return this.type == REST_PARAMETER || (this.type == FORMAL_PARAMETER && this.parameter.isRestParameter());
    },
    isSpreadPatternElement: function() {
      return this.type == SPREAD_PATTERN_ELEMENT;
    },
    isStatementListItem: function() {
      return this.isStatement() || this.isDeclaration();
    },
    isStatement: function() {
      switch (this.type) {
        case BLOCK:
        case VARIABLE_STATEMENT:
        case EMPTY_STATEMENT:
        case EXPRESSION_STATEMENT:
        case IF_STATEMENT:
        case CONTINUE_STATEMENT:
        case BREAK_STATEMENT:
        case RETURN_STATEMENT:
        case WITH_STATEMENT:
        case LABELLED_STATEMENT:
        case THROW_STATEMENT:
        case TRY_STATEMENT:
        case DEBUGGER_STATEMENT:
          return true;
      }
      return this.isBreakableStatement();
    },
    isDeclaration: function() {
      switch (this.type) {
        case FUNCTION_DECLARATION:
        case CLASS_DECLARATION:
          return true;
      }
      return this.isLexicalDeclaration();
    },
    isLexicalDeclaration: function() {
      switch (this.type) {
        case VARIABLE_STATEMENT:
          return this.declarations.declarationType !== VAR;
      }
      return false;
    },
    isBreakableStatement: function() {
      switch (this.type) {
        case SWITCH_STATEMENT:
          return true;
      }
      return this.isIterationStatement();
    },
    isIterationStatement: function() {
      switch (this.type) {
        case DO_WHILE_STATEMENT:
        case FOR_IN_STATEMENT:
        case FOR_OF_STATEMENT:
        case FOR_STATEMENT:
        case WHILE_STATEMENT:
          return true;
      }
      return false;
    },
    isScriptElement: function() {
      switch (this.type) {
        case CLASS_DECLARATION:
        case EXPORT_DECLARATION:
        case FUNCTION_DECLARATION:
        case IMPORT_DECLARATION:
        case INTERFACE_DECLARATION:
        case MODULE_DECLARATION:
        case VARIABLE_DECLARATION:
          return true;
      }
      return this.isStatement();
    },
    isGenerator: function() {
      return this.functionKind !== null && this.functionKind.type === STAR;
    },
    isAsyncFunction: function() {
      return this.functionKind !== null && this.functionKind.type === IDENTIFIER && this.functionKind.value === ASYNC;
    },
    isType: function() {
      switch (this.type) {
        case PREDEFINED_TYPE:
        case TYPE_REFERENCE:
          return true;
      }
      return false;
    },
    getDirectivePrologueStringToken_: function() {
      var tree = this;
      if (tree.type !== EXPRESSION_STATEMENT || !(tree = tree.expression))
        return null;
      if (tree.type !== LITERAL_EXPRESSION || !(tree = tree.literalToken))
        return null;
      if (tree.type !== STRING)
        return null;
      return tree;
    },
    isDirectivePrologue: function() {
      return this.getDirectivePrologueStringToken_() !== null;
    },
    isUseStrictDirective: function() {
      var token = this.getDirectivePrologueStringToken_();
      if (!token)
        return false;
      var v = token.value;
      return v === '"use strict"' || v === "'use strict'";
    },
    toJSON: function() {
      return utilJSON.transform(this, $ParseTree.replacer);
    },
    stringify: function() {
      var indent = arguments[0] !== (void 0) ? arguments[0] : 2;
      return JSON.stringify(this, $ParseTree.replacer, indent);
    },
    getStringValue: function() {
      switch (this.type) {
        case IDENTIFIER_EXPRESSION:
        case BINDING_IDENTIFIER:
          return this.identifierToken.toString();
        case IMPORTED_BINDING:
          return this.binding.getStringValue();
        case PROPERTY_NAME_SHORTHAND:
          return this.name.toString();
      }
      throw new Error('Not yet implemented');
    }
  }, {
    stripLocation: function(key, value) {
      if (key === 'location') {
        return undefined;
      }
      return value;
    },
    replacer: function(k, v) {
      if (v instanceof $ParseTree || v instanceof Token) {
        var rv = {type: v.type};
        Object.keys(v).forEach(function(name) {
          if (name !== 'location')
            rv[name] = v[name];
        });
        return rv;
      }
      return v;
    }
  });
  return {
    get ParseTreeType() {
      return ParseTreeType;
    },
    get ParseTree() {
      return ParseTree;
    }
  };
});
System.registerModule("traceur@0.0.80/src/syntax/trees/ParseTrees.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/trees/ParseTrees.js";
  var ParseTree = System.get("traceur@0.0.80/src/syntax/trees/ParseTree.js").ParseTree;
  var ParseTreeType = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js");
  var ANNOTATION = ParseTreeType.ANNOTATION;
  var Annotation = function Annotation(location, name, args) {
    this.location = location;
    this.name = name;
    this.args = args;
  };
  ($traceurRuntime.createClass)(Annotation, {
    transform: function(transformer) {
      return transformer.transformAnnotation(this);
    },
    visit: function(visitor) {
      visitor.visitAnnotation(this);
    },
    get type() {
      return ANNOTATION;
    }
  }, {}, ParseTree);
  var ANON_BLOCK = ParseTreeType.ANON_BLOCK;
  var AnonBlock = function AnonBlock(location, statements) {
    this.location = location;
    this.statements = statements;
  };
  ($traceurRuntime.createClass)(AnonBlock, {
    transform: function(transformer) {
      return transformer.transformAnonBlock(this);
    },
    visit: function(visitor) {
      visitor.visitAnonBlock(this);
    },
    get type() {
      return ANON_BLOCK;
    }
  }, {}, ParseTree);
  var ARGUMENT_LIST = ParseTreeType.ARGUMENT_LIST;
  var ArgumentList = function ArgumentList(location, args) {
    this.location = location;
    this.args = args;
  };
  ($traceurRuntime.createClass)(ArgumentList, {
    transform: function(transformer) {
      return transformer.transformArgumentList(this);
    },
    visit: function(visitor) {
      visitor.visitArgumentList(this);
    },
    get type() {
      return ARGUMENT_LIST;
    }
  }, {}, ParseTree);
  var ARRAY_COMPREHENSION = ParseTreeType.ARRAY_COMPREHENSION;
  var ArrayComprehension = function ArrayComprehension(location, comprehensionList, expression) {
    this.location = location;
    this.comprehensionList = comprehensionList;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(ArrayComprehension, {
    transform: function(transformer) {
      return transformer.transformArrayComprehension(this);
    },
    visit: function(visitor) {
      visitor.visitArrayComprehension(this);
    },
    get type() {
      return ARRAY_COMPREHENSION;
    }
  }, {}, ParseTree);
  var ARRAY_LITERAL_EXPRESSION = ParseTreeType.ARRAY_LITERAL_EXPRESSION;
  var ArrayLiteralExpression = function ArrayLiteralExpression(location, elements) {
    this.location = location;
    this.elements = elements;
  };
  ($traceurRuntime.createClass)(ArrayLiteralExpression, {
    transform: function(transformer) {
      return transformer.transformArrayLiteralExpression(this);
    },
    visit: function(visitor) {
      visitor.visitArrayLiteralExpression(this);
    },
    get type() {
      return ARRAY_LITERAL_EXPRESSION;
    }
  }, {}, ParseTree);
  var ARRAY_PATTERN = ParseTreeType.ARRAY_PATTERN;
  var ArrayPattern = function ArrayPattern(location, elements) {
    this.location = location;
    this.elements = elements;
  };
  ($traceurRuntime.createClass)(ArrayPattern, {
    transform: function(transformer) {
      return transformer.transformArrayPattern(this);
    },
    visit: function(visitor) {
      visitor.visitArrayPattern(this);
    },
    get type() {
      return ARRAY_PATTERN;
    }
  }, {}, ParseTree);
  var ARRAY_TYPE = ParseTreeType.ARRAY_TYPE;
  var ArrayType = function ArrayType(location, elementType) {
    this.location = location;
    this.elementType = elementType;
  };
  ($traceurRuntime.createClass)(ArrayType, {
    transform: function(transformer) {
      return transformer.transformArrayType(this);
    },
    visit: function(visitor) {
      visitor.visitArrayType(this);
    },
    get type() {
      return ARRAY_TYPE;
    }
  }, {}, ParseTree);
  var ARROW_FUNCTION_EXPRESSION = ParseTreeType.ARROW_FUNCTION_EXPRESSION;
  var ArrowFunctionExpression = function ArrowFunctionExpression(location, functionKind, parameterList, body) {
    this.location = location;
    this.functionKind = functionKind;
    this.parameterList = parameterList;
    this.body = body;
  };
  ($traceurRuntime.createClass)(ArrowFunctionExpression, {
    transform: function(transformer) {
      return transformer.transformArrowFunctionExpression(this);
    },
    visit: function(visitor) {
      visitor.visitArrowFunctionExpression(this);
    },
    get type() {
      return ARROW_FUNCTION_EXPRESSION;
    }
  }, {}, ParseTree);
  var ASSIGNMENT_ELEMENT = ParseTreeType.ASSIGNMENT_ELEMENT;
  var AssignmentElement = function AssignmentElement(location, assignment, initializer) {
    this.location = location;
    this.assignment = assignment;
    this.initializer = initializer;
  };
  ($traceurRuntime.createClass)(AssignmentElement, {
    transform: function(transformer) {
      return transformer.transformAssignmentElement(this);
    },
    visit: function(visitor) {
      visitor.visitAssignmentElement(this);
    },
    get type() {
      return ASSIGNMENT_ELEMENT;
    }
  }, {}, ParseTree);
  var AWAIT_EXPRESSION = ParseTreeType.AWAIT_EXPRESSION;
  var AwaitExpression = function AwaitExpression(location, expression) {
    this.location = location;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(AwaitExpression, {
    transform: function(transformer) {
      return transformer.transformAwaitExpression(this);
    },
    visit: function(visitor) {
      visitor.visitAwaitExpression(this);
    },
    get type() {
      return AWAIT_EXPRESSION;
    }
  }, {}, ParseTree);
  var BINARY_EXPRESSION = ParseTreeType.BINARY_EXPRESSION;
  var BinaryExpression = function BinaryExpression(location, left, operator, right) {
    this.location = location;
    this.left = left;
    this.operator = operator;
    this.right = right;
  };
  ($traceurRuntime.createClass)(BinaryExpression, {
    transform: function(transformer) {
      return transformer.transformBinaryExpression(this);
    },
    visit: function(visitor) {
      visitor.visitBinaryExpression(this);
    },
    get type() {
      return BINARY_EXPRESSION;
    }
  }, {}, ParseTree);
  var BINDING_ELEMENT = ParseTreeType.BINDING_ELEMENT;
  var BindingElement = function BindingElement(location, binding, initializer) {
    this.location = location;
    this.binding = binding;
    this.initializer = initializer;
  };
  ($traceurRuntime.createClass)(BindingElement, {
    transform: function(transformer) {
      return transformer.transformBindingElement(this);
    },
    visit: function(visitor) {
      visitor.visitBindingElement(this);
    },
    get type() {
      return BINDING_ELEMENT;
    }
  }, {}, ParseTree);
  var BINDING_IDENTIFIER = ParseTreeType.BINDING_IDENTIFIER;
  var BindingIdentifier = function BindingIdentifier(location, identifierToken) {
    this.location = location;
    this.identifierToken = identifierToken;
  };
  ($traceurRuntime.createClass)(BindingIdentifier, {
    transform: function(transformer) {
      return transformer.transformBindingIdentifier(this);
    },
    visit: function(visitor) {
      visitor.visitBindingIdentifier(this);
    },
    get type() {
      return BINDING_IDENTIFIER;
    }
  }, {}, ParseTree);
  var BLOCK = ParseTreeType.BLOCK;
  var Block = function Block(location, statements) {
    this.location = location;
    this.statements = statements;
  };
  ($traceurRuntime.createClass)(Block, {
    transform: function(transformer) {
      return transformer.transformBlock(this);
    },
    visit: function(visitor) {
      visitor.visitBlock(this);
    },
    get type() {
      return BLOCK;
    }
  }, {}, ParseTree);
  var BREAK_STATEMENT = ParseTreeType.BREAK_STATEMENT;
  var BreakStatement = function BreakStatement(location, name) {
    this.location = location;
    this.name = name;
  };
  ($traceurRuntime.createClass)(BreakStatement, {
    transform: function(transformer) {
      return transformer.transformBreakStatement(this);
    },
    visit: function(visitor) {
      visitor.visitBreakStatement(this);
    },
    get type() {
      return BREAK_STATEMENT;
    }
  }, {}, ParseTree);
  var CALL_EXPRESSION = ParseTreeType.CALL_EXPRESSION;
  var CallExpression = function CallExpression(location, operand, args) {
    this.location = location;
    this.operand = operand;
    this.args = args;
  };
  ($traceurRuntime.createClass)(CallExpression, {
    transform: function(transformer) {
      return transformer.transformCallExpression(this);
    },
    visit: function(visitor) {
      visitor.visitCallExpression(this);
    },
    get type() {
      return CALL_EXPRESSION;
    }
  }, {}, ParseTree);
  var CALL_SIGNATURE = ParseTreeType.CALL_SIGNATURE;
  var CallSignature = function CallSignature(location, typeParameters, parameterList, returnType) {
    this.location = location;
    this.typeParameters = typeParameters;
    this.parameterList = parameterList;
    this.returnType = returnType;
  };
  ($traceurRuntime.createClass)(CallSignature, {
    transform: function(transformer) {
      return transformer.transformCallSignature(this);
    },
    visit: function(visitor) {
      visitor.visitCallSignature(this);
    },
    get type() {
      return CALL_SIGNATURE;
    }
  }, {}, ParseTree);
  var CASE_CLAUSE = ParseTreeType.CASE_CLAUSE;
  var CaseClause = function CaseClause(location, expression, statements) {
    this.location = location;
    this.expression = expression;
    this.statements = statements;
  };
  ($traceurRuntime.createClass)(CaseClause, {
    transform: function(transformer) {
      return transformer.transformCaseClause(this);
    },
    visit: function(visitor) {
      visitor.visitCaseClause(this);
    },
    get type() {
      return CASE_CLAUSE;
    }
  }, {}, ParseTree);
  var CATCH = ParseTreeType.CATCH;
  var Catch = function Catch(location, binding, catchBody) {
    this.location = location;
    this.binding = binding;
    this.catchBody = catchBody;
  };
  ($traceurRuntime.createClass)(Catch, {
    transform: function(transformer) {
      return transformer.transformCatch(this);
    },
    visit: function(visitor) {
      visitor.visitCatch(this);
    },
    get type() {
      return CATCH;
    }
  }, {}, ParseTree);
  var CLASS_DECLARATION = ParseTreeType.CLASS_DECLARATION;
  var ClassDeclaration = function ClassDeclaration(location, name, superClass, elements, annotations, typeParameters) {
    this.location = location;
    this.name = name;
    this.superClass = superClass;
    this.elements = elements;
    this.annotations = annotations;
    this.typeParameters = typeParameters;
  };
  ($traceurRuntime.createClass)(ClassDeclaration, {
    transform: function(transformer) {
      return transformer.transformClassDeclaration(this);
    },
    visit: function(visitor) {
      visitor.visitClassDeclaration(this);
    },
    get type() {
      return CLASS_DECLARATION;
    }
  }, {}, ParseTree);
  var CLASS_EXPRESSION = ParseTreeType.CLASS_EXPRESSION;
  var ClassExpression = function ClassExpression(location, name, superClass, elements, annotations, typeParameters) {
    this.location = location;
    this.name = name;
    this.superClass = superClass;
    this.elements = elements;
    this.annotations = annotations;
    this.typeParameters = typeParameters;
  };
  ($traceurRuntime.createClass)(ClassExpression, {
    transform: function(transformer) {
      return transformer.transformClassExpression(this);
    },
    visit: function(visitor) {
      visitor.visitClassExpression(this);
    },
    get type() {
      return CLASS_EXPRESSION;
    }
  }, {}, ParseTree);
  var COMMA_EXPRESSION = ParseTreeType.COMMA_EXPRESSION;
  var CommaExpression = function CommaExpression(location, expressions) {
    this.location = location;
    this.expressions = expressions;
  };
  ($traceurRuntime.createClass)(CommaExpression, {
    transform: function(transformer) {
      return transformer.transformCommaExpression(this);
    },
    visit: function(visitor) {
      visitor.visitCommaExpression(this);
    },
    get type() {
      return COMMA_EXPRESSION;
    }
  }, {}, ParseTree);
  var COMPREHENSION_FOR = ParseTreeType.COMPREHENSION_FOR;
  var ComprehensionFor = function ComprehensionFor(location, left, iterator) {
    this.location = location;
    this.left = left;
    this.iterator = iterator;
  };
  ($traceurRuntime.createClass)(ComprehensionFor, {
    transform: function(transformer) {
      return transformer.transformComprehensionFor(this);
    },
    visit: function(visitor) {
      visitor.visitComprehensionFor(this);
    },
    get type() {
      return COMPREHENSION_FOR;
    }
  }, {}, ParseTree);
  var COMPREHENSION_IF = ParseTreeType.COMPREHENSION_IF;
  var ComprehensionIf = function ComprehensionIf(location, expression) {
    this.location = location;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(ComprehensionIf, {
    transform: function(transformer) {
      return transformer.transformComprehensionIf(this);
    },
    visit: function(visitor) {
      visitor.visitComprehensionIf(this);
    },
    get type() {
      return COMPREHENSION_IF;
    }
  }, {}, ParseTree);
  var COMPUTED_PROPERTY_NAME = ParseTreeType.COMPUTED_PROPERTY_NAME;
  var ComputedPropertyName = function ComputedPropertyName(location, expression) {
    this.location = location;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(ComputedPropertyName, {
    transform: function(transformer) {
      return transformer.transformComputedPropertyName(this);
    },
    visit: function(visitor) {
      visitor.visitComputedPropertyName(this);
    },
    get type() {
      return COMPUTED_PROPERTY_NAME;
    }
  }, {}, ParseTree);
  var CONDITIONAL_EXPRESSION = ParseTreeType.CONDITIONAL_EXPRESSION;
  var ConditionalExpression = function ConditionalExpression(location, condition, left, right) {
    this.location = location;
    this.condition = condition;
    this.left = left;
    this.right = right;
  };
  ($traceurRuntime.createClass)(ConditionalExpression, {
    transform: function(transformer) {
      return transformer.transformConditionalExpression(this);
    },
    visit: function(visitor) {
      visitor.visitConditionalExpression(this);
    },
    get type() {
      return CONDITIONAL_EXPRESSION;
    }
  }, {}, ParseTree);
  var CONSTRUCT_SIGNATURE = ParseTreeType.CONSTRUCT_SIGNATURE;
  var ConstructSignature = function ConstructSignature(location, typeParameters, parameterList, returnType) {
    this.location = location;
    this.typeParameters = typeParameters;
    this.parameterList = parameterList;
    this.returnType = returnType;
  };
  ($traceurRuntime.createClass)(ConstructSignature, {
    transform: function(transformer) {
      return transformer.transformConstructSignature(this);
    },
    visit: function(visitor) {
      visitor.visitConstructSignature(this);
    },
    get type() {
      return CONSTRUCT_SIGNATURE;
    }
  }, {}, ParseTree);
  var CONSTRUCTOR_TYPE = ParseTreeType.CONSTRUCTOR_TYPE;
  var ConstructorType = function ConstructorType(location, typeParameters, parameterList, returnType) {
    this.location = location;
    this.typeParameters = typeParameters;
    this.parameterList = parameterList;
    this.returnType = returnType;
  };
  ($traceurRuntime.createClass)(ConstructorType, {
    transform: function(transformer) {
      return transformer.transformConstructorType(this);
    },
    visit: function(visitor) {
      visitor.visitConstructorType(this);
    },
    get type() {
      return CONSTRUCTOR_TYPE;
    }
  }, {}, ParseTree);
  var CONTINUE_STATEMENT = ParseTreeType.CONTINUE_STATEMENT;
  var ContinueStatement = function ContinueStatement(location, name) {
    this.location = location;
    this.name = name;
  };
  ($traceurRuntime.createClass)(ContinueStatement, {
    transform: function(transformer) {
      return transformer.transformContinueStatement(this);
    },
    visit: function(visitor) {
      visitor.visitContinueStatement(this);
    },
    get type() {
      return CONTINUE_STATEMENT;
    }
  }, {}, ParseTree);
  var COVER_FORMALS = ParseTreeType.COVER_FORMALS;
  var CoverFormals = function CoverFormals(location, expressions) {
    this.location = location;
    this.expressions = expressions;
  };
  ($traceurRuntime.createClass)(CoverFormals, {
    transform: function(transformer) {
      return transformer.transformCoverFormals(this);
    },
    visit: function(visitor) {
      visitor.visitCoverFormals(this);
    },
    get type() {
      return COVER_FORMALS;
    }
  }, {}, ParseTree);
  var COVER_INITIALIZED_NAME = ParseTreeType.COVER_INITIALIZED_NAME;
  var CoverInitializedName = function CoverInitializedName(location, name, equalToken, initializer) {
    this.location = location;
    this.name = name;
    this.equalToken = equalToken;
    this.initializer = initializer;
  };
  ($traceurRuntime.createClass)(CoverInitializedName, {
    transform: function(transformer) {
      return transformer.transformCoverInitializedName(this);
    },
    visit: function(visitor) {
      visitor.visitCoverInitializedName(this);
    },
    get type() {
      return COVER_INITIALIZED_NAME;
    }
  }, {}, ParseTree);
  var DEBUGGER_STATEMENT = ParseTreeType.DEBUGGER_STATEMENT;
  var DebuggerStatement = function DebuggerStatement(location) {
    this.location = location;
  };
  ($traceurRuntime.createClass)(DebuggerStatement, {
    transform: function(transformer) {
      return transformer.transformDebuggerStatement(this);
    },
    visit: function(visitor) {
      visitor.visitDebuggerStatement(this);
    },
    get type() {
      return DEBUGGER_STATEMENT;
    }
  }, {}, ParseTree);
  var DEFAULT_CLAUSE = ParseTreeType.DEFAULT_CLAUSE;
  var DefaultClause = function DefaultClause(location, statements) {
    this.location = location;
    this.statements = statements;
  };
  ($traceurRuntime.createClass)(DefaultClause, {
    transform: function(transformer) {
      return transformer.transformDefaultClause(this);
    },
    visit: function(visitor) {
      visitor.visitDefaultClause(this);
    },
    get type() {
      return DEFAULT_CLAUSE;
    }
  }, {}, ParseTree);
  var DO_WHILE_STATEMENT = ParseTreeType.DO_WHILE_STATEMENT;
  var DoWhileStatement = function DoWhileStatement(location, body, condition) {
    this.location = location;
    this.body = body;
    this.condition = condition;
  };
  ($traceurRuntime.createClass)(DoWhileStatement, {
    transform: function(transformer) {
      return transformer.transformDoWhileStatement(this);
    },
    visit: function(visitor) {
      visitor.visitDoWhileStatement(this);
    },
    get type() {
      return DO_WHILE_STATEMENT;
    }
  }, {}, ParseTree);
  var EMPTY_STATEMENT = ParseTreeType.EMPTY_STATEMENT;
  var EmptyStatement = function EmptyStatement(location) {
    this.location = location;
  };
  ($traceurRuntime.createClass)(EmptyStatement, {
    transform: function(transformer) {
      return transformer.transformEmptyStatement(this);
    },
    visit: function(visitor) {
      visitor.visitEmptyStatement(this);
    },
    get type() {
      return EMPTY_STATEMENT;
    }
  }, {}, ParseTree);
  var EXPORT_DECLARATION = ParseTreeType.EXPORT_DECLARATION;
  var ExportDeclaration = function ExportDeclaration(location, declaration, annotations) {
    this.location = location;
    this.declaration = declaration;
    this.annotations = annotations;
  };
  ($traceurRuntime.createClass)(ExportDeclaration, {
    transform: function(transformer) {
      return transformer.transformExportDeclaration(this);
    },
    visit: function(visitor) {
      visitor.visitExportDeclaration(this);
    },
    get type() {
      return EXPORT_DECLARATION;
    }
  }, {}, ParseTree);
  var EXPORT_DEFAULT = ParseTreeType.EXPORT_DEFAULT;
  var ExportDefault = function ExportDefault(location, expression) {
    this.location = location;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(ExportDefault, {
    transform: function(transformer) {
      return transformer.transformExportDefault(this);
    },
    visit: function(visitor) {
      visitor.visitExportDefault(this);
    },
    get type() {
      return EXPORT_DEFAULT;
    }
  }, {}, ParseTree);
  var EXPORT_SPECIFIER = ParseTreeType.EXPORT_SPECIFIER;
  var ExportSpecifier = function ExportSpecifier(location, lhs, rhs) {
    this.location = location;
    this.lhs = lhs;
    this.rhs = rhs;
  };
  ($traceurRuntime.createClass)(ExportSpecifier, {
    transform: function(transformer) {
      return transformer.transformExportSpecifier(this);
    },
    visit: function(visitor) {
      visitor.visitExportSpecifier(this);
    },
    get type() {
      return EXPORT_SPECIFIER;
    }
  }, {}, ParseTree);
  var EXPORT_SPECIFIER_SET = ParseTreeType.EXPORT_SPECIFIER_SET;
  var ExportSpecifierSet = function ExportSpecifierSet(location, specifiers) {
    this.location = location;
    this.specifiers = specifiers;
  };
  ($traceurRuntime.createClass)(ExportSpecifierSet, {
    transform: function(transformer) {
      return transformer.transformExportSpecifierSet(this);
    },
    visit: function(visitor) {
      visitor.visitExportSpecifierSet(this);
    },
    get type() {
      return EXPORT_SPECIFIER_SET;
    }
  }, {}, ParseTree);
  var EXPORT_STAR = ParseTreeType.EXPORT_STAR;
  var ExportStar = function ExportStar(location) {
    this.location = location;
  };
  ($traceurRuntime.createClass)(ExportStar, {
    transform: function(transformer) {
      return transformer.transformExportStar(this);
    },
    visit: function(visitor) {
      visitor.visitExportStar(this);
    },
    get type() {
      return EXPORT_STAR;
    }
  }, {}, ParseTree);
  var EXPRESSION_STATEMENT = ParseTreeType.EXPRESSION_STATEMENT;
  var ExpressionStatement = function ExpressionStatement(location, expression) {
    this.location = location;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(ExpressionStatement, {
    transform: function(transformer) {
      return transformer.transformExpressionStatement(this);
    },
    visit: function(visitor) {
      visitor.visitExpressionStatement(this);
    },
    get type() {
      return EXPRESSION_STATEMENT;
    }
  }, {}, ParseTree);
  var FINALLY = ParseTreeType.FINALLY;
  var Finally = function Finally(location, block) {
    this.location = location;
    this.block = block;
  };
  ($traceurRuntime.createClass)(Finally, {
    transform: function(transformer) {
      return transformer.transformFinally(this);
    },
    visit: function(visitor) {
      visitor.visitFinally(this);
    },
    get type() {
      return FINALLY;
    }
  }, {}, ParseTree);
  var FOR_IN_STATEMENT = ParseTreeType.FOR_IN_STATEMENT;
  var ForInStatement = function ForInStatement(location, initializer, collection, body) {
    this.location = location;
    this.initializer = initializer;
    this.collection = collection;
    this.body = body;
  };
  ($traceurRuntime.createClass)(ForInStatement, {
    transform: function(transformer) {
      return transformer.transformForInStatement(this);
    },
    visit: function(visitor) {
      visitor.visitForInStatement(this);
    },
    get type() {
      return FOR_IN_STATEMENT;
    }
  }, {}, ParseTree);
  var FOR_OF_STATEMENT = ParseTreeType.FOR_OF_STATEMENT;
  var ForOfStatement = function ForOfStatement(location, initializer, collection, body) {
    this.location = location;
    this.initializer = initializer;
    this.collection = collection;
    this.body = body;
  };
  ($traceurRuntime.createClass)(ForOfStatement, {
    transform: function(transformer) {
      return transformer.transformForOfStatement(this);
    },
    visit: function(visitor) {
      visitor.visitForOfStatement(this);
    },
    get type() {
      return FOR_OF_STATEMENT;
    }
  }, {}, ParseTree);
  var FOR_STATEMENT = ParseTreeType.FOR_STATEMENT;
  var ForStatement = function ForStatement(location, initializer, condition, increment, body) {
    this.location = location;
    this.initializer = initializer;
    this.condition = condition;
    this.increment = increment;
    this.body = body;
  };
  ($traceurRuntime.createClass)(ForStatement, {
    transform: function(transformer) {
      return transformer.transformForStatement(this);
    },
    visit: function(visitor) {
      visitor.visitForStatement(this);
    },
    get type() {
      return FOR_STATEMENT;
    }
  }, {}, ParseTree);
  var FORMAL_PARAMETER = ParseTreeType.FORMAL_PARAMETER;
  var FormalParameter = function FormalParameter(location, parameter, typeAnnotation, annotations) {
    this.location = location;
    this.parameter = parameter;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
  };
  ($traceurRuntime.createClass)(FormalParameter, {
    transform: function(transformer) {
      return transformer.transformFormalParameter(this);
    },
    visit: function(visitor) {
      visitor.visitFormalParameter(this);
    },
    get type() {
      return FORMAL_PARAMETER;
    }
  }, {}, ParseTree);
  var FORMAL_PARAMETER_LIST = ParseTreeType.FORMAL_PARAMETER_LIST;
  var FormalParameterList = function FormalParameterList(location, parameters) {
    this.location = location;
    this.parameters = parameters;
  };
  ($traceurRuntime.createClass)(FormalParameterList, {
    transform: function(transformer) {
      return transformer.transformFormalParameterList(this);
    },
    visit: function(visitor) {
      visitor.visitFormalParameterList(this);
    },
    get type() {
      return FORMAL_PARAMETER_LIST;
    }
  }, {}, ParseTree);
  var FUNCTION_BODY = ParseTreeType.FUNCTION_BODY;
  var FunctionBody = function FunctionBody(location, statements) {
    this.location = location;
    this.statements = statements;
  };
  ($traceurRuntime.createClass)(FunctionBody, {
    transform: function(transformer) {
      return transformer.transformFunctionBody(this);
    },
    visit: function(visitor) {
      visitor.visitFunctionBody(this);
    },
    get type() {
      return FUNCTION_BODY;
    }
  }, {}, ParseTree);
  var FUNCTION_DECLARATION = ParseTreeType.FUNCTION_DECLARATION;
  var FunctionDeclaration = function FunctionDeclaration(location, name, functionKind, parameterList, typeAnnotation, annotations, body) {
    this.location = location;
    this.name = name;
    this.functionKind = functionKind;
    this.parameterList = parameterList;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
    this.body = body;
  };
  ($traceurRuntime.createClass)(FunctionDeclaration, {
    transform: function(transformer) {
      return transformer.transformFunctionDeclaration(this);
    },
    visit: function(visitor) {
      visitor.visitFunctionDeclaration(this);
    },
    get type() {
      return FUNCTION_DECLARATION;
    }
  }, {}, ParseTree);
  var FUNCTION_EXPRESSION = ParseTreeType.FUNCTION_EXPRESSION;
  var FunctionExpression = function FunctionExpression(location, name, functionKind, parameterList, typeAnnotation, annotations, body) {
    this.location = location;
    this.name = name;
    this.functionKind = functionKind;
    this.parameterList = parameterList;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
    this.body = body;
  };
  ($traceurRuntime.createClass)(FunctionExpression, {
    transform: function(transformer) {
      return transformer.transformFunctionExpression(this);
    },
    visit: function(visitor) {
      visitor.visitFunctionExpression(this);
    },
    get type() {
      return FUNCTION_EXPRESSION;
    }
  }, {}, ParseTree);
  var FUNCTION_TYPE = ParseTreeType.FUNCTION_TYPE;
  var FunctionType = function FunctionType(location, typeParameters, parameterList, returnType) {
    this.location = location;
    this.typeParameters = typeParameters;
    this.parameterList = parameterList;
    this.returnType = returnType;
  };
  ($traceurRuntime.createClass)(FunctionType, {
    transform: function(transformer) {
      return transformer.transformFunctionType(this);
    },
    visit: function(visitor) {
      visitor.visitFunctionType(this);
    },
    get type() {
      return FUNCTION_TYPE;
    }
  }, {}, ParseTree);
  var GENERATOR_COMPREHENSION = ParseTreeType.GENERATOR_COMPREHENSION;
  var GeneratorComprehension = function GeneratorComprehension(location, comprehensionList, expression) {
    this.location = location;
    this.comprehensionList = comprehensionList;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(GeneratorComprehension, {
    transform: function(transformer) {
      return transformer.transformGeneratorComprehension(this);
    },
    visit: function(visitor) {
      visitor.visitGeneratorComprehension(this);
    },
    get type() {
      return GENERATOR_COMPREHENSION;
    }
  }, {}, ParseTree);
  var GET_ACCESSOR = ParseTreeType.GET_ACCESSOR;
  var GetAccessor = function GetAccessor(location, isStatic, name, typeAnnotation, annotations, body) {
    this.location = location;
    this.isStatic = isStatic;
    this.name = name;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
    this.body = body;
  };
  ($traceurRuntime.createClass)(GetAccessor, {
    transform: function(transformer) {
      return transformer.transformGetAccessor(this);
    },
    visit: function(visitor) {
      visitor.visitGetAccessor(this);
    },
    get type() {
      return GET_ACCESSOR;
    }
  }, {}, ParseTree);
  var IDENTIFIER_EXPRESSION = ParseTreeType.IDENTIFIER_EXPRESSION;
  var IdentifierExpression = function IdentifierExpression(location, identifierToken) {
    this.location = location;
    this.identifierToken = identifierToken;
  };
  ($traceurRuntime.createClass)(IdentifierExpression, {
    transform: function(transformer) {
      return transformer.transformIdentifierExpression(this);
    },
    visit: function(visitor) {
      visitor.visitIdentifierExpression(this);
    },
    get type() {
      return IDENTIFIER_EXPRESSION;
    }
  }, {}, ParseTree);
  var IF_STATEMENT = ParseTreeType.IF_STATEMENT;
  var IfStatement = function IfStatement(location, condition, ifClause, elseClause) {
    this.location = location;
    this.condition = condition;
    this.ifClause = ifClause;
    this.elseClause = elseClause;
  };
  ($traceurRuntime.createClass)(IfStatement, {
    transform: function(transformer) {
      return transformer.transformIfStatement(this);
    },
    visit: function(visitor) {
      visitor.visitIfStatement(this);
    },
    get type() {
      return IF_STATEMENT;
    }
  }, {}, ParseTree);
  var IMPORTED_BINDING = ParseTreeType.IMPORTED_BINDING;
  var ImportedBinding = function ImportedBinding(location, binding) {
    this.location = location;
    this.binding = binding;
  };
  ($traceurRuntime.createClass)(ImportedBinding, {
    transform: function(transformer) {
      return transformer.transformImportedBinding(this);
    },
    visit: function(visitor) {
      visitor.visitImportedBinding(this);
    },
    get type() {
      return IMPORTED_BINDING;
    }
  }, {}, ParseTree);
  var IMPORT_DECLARATION = ParseTreeType.IMPORT_DECLARATION;
  var ImportDeclaration = function ImportDeclaration(location, importClause, moduleSpecifier) {
    this.location = location;
    this.importClause = importClause;
    this.moduleSpecifier = moduleSpecifier;
  };
  ($traceurRuntime.createClass)(ImportDeclaration, {
    transform: function(transformer) {
      return transformer.transformImportDeclaration(this);
    },
    visit: function(visitor) {
      visitor.visitImportDeclaration(this);
    },
    get type() {
      return IMPORT_DECLARATION;
    }
  }, {}, ParseTree);
  var IMPORT_SPECIFIER = ParseTreeType.IMPORT_SPECIFIER;
  var ImportSpecifier = function ImportSpecifier(location, binding, name) {
    this.location = location;
    this.binding = binding;
    this.name = name;
  };
  ($traceurRuntime.createClass)(ImportSpecifier, {
    transform: function(transformer) {
      return transformer.transformImportSpecifier(this);
    },
    visit: function(visitor) {
      visitor.visitImportSpecifier(this);
    },
    get type() {
      return IMPORT_SPECIFIER;
    }
  }, {}, ParseTree);
  var IMPORT_SPECIFIER_SET = ParseTreeType.IMPORT_SPECIFIER_SET;
  var ImportSpecifierSet = function ImportSpecifierSet(location, specifiers) {
    this.location = location;
    this.specifiers = specifiers;
  };
  ($traceurRuntime.createClass)(ImportSpecifierSet, {
    transform: function(transformer) {
      return transformer.transformImportSpecifierSet(this);
    },
    visit: function(visitor) {
      visitor.visitImportSpecifierSet(this);
    },
    get type() {
      return IMPORT_SPECIFIER_SET;
    }
  }, {}, ParseTree);
  var INDEX_SIGNATURE = ParseTreeType.INDEX_SIGNATURE;
  var IndexSignature = function IndexSignature(location, name, indexType, typeAnnotation) {
    this.location = location;
    this.name = name;
    this.indexType = indexType;
    this.typeAnnotation = typeAnnotation;
  };
  ($traceurRuntime.createClass)(IndexSignature, {
    transform: function(transformer) {
      return transformer.transformIndexSignature(this);
    },
    visit: function(visitor) {
      visitor.visitIndexSignature(this);
    },
    get type() {
      return INDEX_SIGNATURE;
    }
  }, {}, ParseTree);
  var INTERFACE_DECLARATION = ParseTreeType.INTERFACE_DECLARATION;
  var InterfaceDeclaration = function InterfaceDeclaration(location, name, typeParameters, extendsClause, objectType) {
    this.location = location;
    this.name = name;
    this.typeParameters = typeParameters;
    this.extendsClause = extendsClause;
    this.objectType = objectType;
  };
  ($traceurRuntime.createClass)(InterfaceDeclaration, {
    transform: function(transformer) {
      return transformer.transformInterfaceDeclaration(this);
    },
    visit: function(visitor) {
      visitor.visitInterfaceDeclaration(this);
    },
    get type() {
      return INTERFACE_DECLARATION;
    }
  }, {}, ParseTree);
  var LABELLED_STATEMENT = ParseTreeType.LABELLED_STATEMENT;
  var LabelledStatement = function LabelledStatement(location, name, statement) {
    this.location = location;
    this.name = name;
    this.statement = statement;
  };
  ($traceurRuntime.createClass)(LabelledStatement, {
    transform: function(transformer) {
      return transformer.transformLabelledStatement(this);
    },
    visit: function(visitor) {
      visitor.visitLabelledStatement(this);
    },
    get type() {
      return LABELLED_STATEMENT;
    }
  }, {}, ParseTree);
  var LITERAL_EXPRESSION = ParseTreeType.LITERAL_EXPRESSION;
  var LiteralExpression = function LiteralExpression(location, literalToken) {
    this.location = location;
    this.literalToken = literalToken;
  };
  ($traceurRuntime.createClass)(LiteralExpression, {
    transform: function(transformer) {
      return transformer.transformLiteralExpression(this);
    },
    visit: function(visitor) {
      visitor.visitLiteralExpression(this);
    },
    get type() {
      return LITERAL_EXPRESSION;
    }
  }, {}, ParseTree);
  var LITERAL_PROPERTY_NAME = ParseTreeType.LITERAL_PROPERTY_NAME;
  var LiteralPropertyName = function LiteralPropertyName(location, literalToken) {
    this.location = location;
    this.literalToken = literalToken;
  };
  ($traceurRuntime.createClass)(LiteralPropertyName, {
    transform: function(transformer) {
      return transformer.transformLiteralPropertyName(this);
    },
    visit: function(visitor) {
      visitor.visitLiteralPropertyName(this);
    },
    get type() {
      return LITERAL_PROPERTY_NAME;
    }
  }, {}, ParseTree);
  var MEMBER_EXPRESSION = ParseTreeType.MEMBER_EXPRESSION;
  var MemberExpression = function MemberExpression(location, operand, memberName) {
    this.location = location;
    this.operand = operand;
    this.memberName = memberName;
  };
  ($traceurRuntime.createClass)(MemberExpression, {
    transform: function(transformer) {
      return transformer.transformMemberExpression(this);
    },
    visit: function(visitor) {
      visitor.visitMemberExpression(this);
    },
    get type() {
      return MEMBER_EXPRESSION;
    }
  }, {}, ParseTree);
  var MEMBER_LOOKUP_EXPRESSION = ParseTreeType.MEMBER_LOOKUP_EXPRESSION;
  var MemberLookupExpression = function MemberLookupExpression(location, operand, memberExpression) {
    this.location = location;
    this.operand = operand;
    this.memberExpression = memberExpression;
  };
  ($traceurRuntime.createClass)(MemberLookupExpression, {
    transform: function(transformer) {
      return transformer.transformMemberLookupExpression(this);
    },
    visit: function(visitor) {
      visitor.visitMemberLookupExpression(this);
    },
    get type() {
      return MEMBER_LOOKUP_EXPRESSION;
    }
  }, {}, ParseTree);
  var METHOD_SIGNATURE = ParseTreeType.METHOD_SIGNATURE;
  var MethodSignature = function MethodSignature(location, name, optional, callSignature) {
    this.location = location;
    this.name = name;
    this.optional = optional;
    this.callSignature = callSignature;
  };
  ($traceurRuntime.createClass)(MethodSignature, {
    transform: function(transformer) {
      return transformer.transformMethodSignature(this);
    },
    visit: function(visitor) {
      visitor.visitMethodSignature(this);
    },
    get type() {
      return METHOD_SIGNATURE;
    }
  }, {}, ParseTree);
  var MODULE = ParseTreeType.MODULE;
  var Module = function Module(location, scriptItemList, moduleName) {
    this.location = location;
    this.scriptItemList = scriptItemList;
    this.moduleName = moduleName;
  };
  ($traceurRuntime.createClass)(Module, {
    transform: function(transformer) {
      return transformer.transformModule(this);
    },
    visit: function(visitor) {
      visitor.visitModule(this);
    },
    get type() {
      return MODULE;
    }
  }, {}, ParseTree);
  var MODULE_DECLARATION = ParseTreeType.MODULE_DECLARATION;
  var ModuleDeclaration = function ModuleDeclaration(location, binding, expression) {
    this.location = location;
    this.binding = binding;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(ModuleDeclaration, {
    transform: function(transformer) {
      return transformer.transformModuleDeclaration(this);
    },
    visit: function(visitor) {
      visitor.visitModuleDeclaration(this);
    },
    get type() {
      return MODULE_DECLARATION;
    }
  }, {}, ParseTree);
  var MODULE_SPECIFIER = ParseTreeType.MODULE_SPECIFIER;
  var ModuleSpecifier = function ModuleSpecifier(location, token) {
    this.location = location;
    this.token = token;
  };
  ($traceurRuntime.createClass)(ModuleSpecifier, {
    transform: function(transformer) {
      return transformer.transformModuleSpecifier(this);
    },
    visit: function(visitor) {
      visitor.visitModuleSpecifier(this);
    },
    get type() {
      return MODULE_SPECIFIER;
    }
  }, {}, ParseTree);
  var NAMED_EXPORT = ParseTreeType.NAMED_EXPORT;
  var NamedExport = function NamedExport(location, moduleSpecifier, specifierSet) {
    this.location = location;
    this.moduleSpecifier = moduleSpecifier;
    this.specifierSet = specifierSet;
  };
  ($traceurRuntime.createClass)(NamedExport, {
    transform: function(transformer) {
      return transformer.transformNamedExport(this);
    },
    visit: function(visitor) {
      visitor.visitNamedExport(this);
    },
    get type() {
      return NAMED_EXPORT;
    }
  }, {}, ParseTree);
  var NEW_EXPRESSION = ParseTreeType.NEW_EXPRESSION;
  var NewExpression = function NewExpression(location, operand, args) {
    this.location = location;
    this.operand = operand;
    this.args = args;
  };
  ($traceurRuntime.createClass)(NewExpression, {
    transform: function(transformer) {
      return transformer.transformNewExpression(this);
    },
    visit: function(visitor) {
      visitor.visitNewExpression(this);
    },
    get type() {
      return NEW_EXPRESSION;
    }
  }, {}, ParseTree);
  var OBJECT_LITERAL_EXPRESSION = ParseTreeType.OBJECT_LITERAL_EXPRESSION;
  var ObjectLiteralExpression = function ObjectLiteralExpression(location, propertyNameAndValues) {
    this.location = location;
    this.propertyNameAndValues = propertyNameAndValues;
  };
  ($traceurRuntime.createClass)(ObjectLiteralExpression, {
    transform: function(transformer) {
      return transformer.transformObjectLiteralExpression(this);
    },
    visit: function(visitor) {
      visitor.visitObjectLiteralExpression(this);
    },
    get type() {
      return OBJECT_LITERAL_EXPRESSION;
    }
  }, {}, ParseTree);
  var OBJECT_PATTERN = ParseTreeType.OBJECT_PATTERN;
  var ObjectPattern = function ObjectPattern(location, fields) {
    this.location = location;
    this.fields = fields;
  };
  ($traceurRuntime.createClass)(ObjectPattern, {
    transform: function(transformer) {
      return transformer.transformObjectPattern(this);
    },
    visit: function(visitor) {
      visitor.visitObjectPattern(this);
    },
    get type() {
      return OBJECT_PATTERN;
    }
  }, {}, ParseTree);
  var OBJECT_PATTERN_FIELD = ParseTreeType.OBJECT_PATTERN_FIELD;
  var ObjectPatternField = function ObjectPatternField(location, name, element) {
    this.location = location;
    this.name = name;
    this.element = element;
  };
  ($traceurRuntime.createClass)(ObjectPatternField, {
    transform: function(transformer) {
      return transformer.transformObjectPatternField(this);
    },
    visit: function(visitor) {
      visitor.visitObjectPatternField(this);
    },
    get type() {
      return OBJECT_PATTERN_FIELD;
    }
  }, {}, ParseTree);
  var OBJECT_TYPE = ParseTreeType.OBJECT_TYPE;
  var ObjectType = function ObjectType(location, typeMembers) {
    this.location = location;
    this.typeMembers = typeMembers;
  };
  ($traceurRuntime.createClass)(ObjectType, {
    transform: function(transformer) {
      return transformer.transformObjectType(this);
    },
    visit: function(visitor) {
      visitor.visitObjectType(this);
    },
    get type() {
      return OBJECT_TYPE;
    }
  }, {}, ParseTree);
  var PAREN_EXPRESSION = ParseTreeType.PAREN_EXPRESSION;
  var ParenExpression = function ParenExpression(location, expression) {
    this.location = location;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(ParenExpression, {
    transform: function(transformer) {
      return transformer.transformParenExpression(this);
    },
    visit: function(visitor) {
      visitor.visitParenExpression(this);
    },
    get type() {
      return PAREN_EXPRESSION;
    }
  }, {}, ParseTree);
  var POSTFIX_EXPRESSION = ParseTreeType.POSTFIX_EXPRESSION;
  var PostfixExpression = function PostfixExpression(location, operand, operator) {
    this.location = location;
    this.operand = operand;
    this.operator = operator;
  };
  ($traceurRuntime.createClass)(PostfixExpression, {
    transform: function(transformer) {
      return transformer.transformPostfixExpression(this);
    },
    visit: function(visitor) {
      visitor.visitPostfixExpression(this);
    },
    get type() {
      return POSTFIX_EXPRESSION;
    }
  }, {}, ParseTree);
  var PREDEFINED_TYPE = ParseTreeType.PREDEFINED_TYPE;
  var PredefinedType = function PredefinedType(location, typeToken) {
    this.location = location;
    this.typeToken = typeToken;
  };
  ($traceurRuntime.createClass)(PredefinedType, {
    transform: function(transformer) {
      return transformer.transformPredefinedType(this);
    },
    visit: function(visitor) {
      visitor.visitPredefinedType(this);
    },
    get type() {
      return PREDEFINED_TYPE;
    }
  }, {}, ParseTree);
  var SCRIPT = ParseTreeType.SCRIPT;
  var Script = function Script(location, scriptItemList, moduleName) {
    this.location = location;
    this.scriptItemList = scriptItemList;
    this.moduleName = moduleName;
  };
  ($traceurRuntime.createClass)(Script, {
    transform: function(transformer) {
      return transformer.transformScript(this);
    },
    visit: function(visitor) {
      visitor.visitScript(this);
    },
    get type() {
      return SCRIPT;
    }
  }, {}, ParseTree);
  var PROPERTY_METHOD_ASSIGNMENT = ParseTreeType.PROPERTY_METHOD_ASSIGNMENT;
  var PropertyMethodAssignment = function PropertyMethodAssignment(location, isStatic, functionKind, name, parameterList, typeAnnotation, annotations, body) {
    this.location = location;
    this.isStatic = isStatic;
    this.functionKind = functionKind;
    this.name = name;
    this.parameterList = parameterList;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
    this.body = body;
  };
  ($traceurRuntime.createClass)(PropertyMethodAssignment, {
    transform: function(transformer) {
      return transformer.transformPropertyMethodAssignment(this);
    },
    visit: function(visitor) {
      visitor.visitPropertyMethodAssignment(this);
    },
    get type() {
      return PROPERTY_METHOD_ASSIGNMENT;
    }
  }, {}, ParseTree);
  var PROPERTY_NAME_ASSIGNMENT = ParseTreeType.PROPERTY_NAME_ASSIGNMENT;
  var PropertyNameAssignment = function PropertyNameAssignment(location, name, value) {
    this.location = location;
    this.name = name;
    this.value = value;
  };
  ($traceurRuntime.createClass)(PropertyNameAssignment, {
    transform: function(transformer) {
      return transformer.transformPropertyNameAssignment(this);
    },
    visit: function(visitor) {
      visitor.visitPropertyNameAssignment(this);
    },
    get type() {
      return PROPERTY_NAME_ASSIGNMENT;
    }
  }, {}, ParseTree);
  var PROPERTY_NAME_SHORTHAND = ParseTreeType.PROPERTY_NAME_SHORTHAND;
  var PropertyNameShorthand = function PropertyNameShorthand(location, name) {
    this.location = location;
    this.name = name;
  };
  ($traceurRuntime.createClass)(PropertyNameShorthand, {
    transform: function(transformer) {
      return transformer.transformPropertyNameShorthand(this);
    },
    visit: function(visitor) {
      visitor.visitPropertyNameShorthand(this);
    },
    get type() {
      return PROPERTY_NAME_SHORTHAND;
    }
  }, {}, ParseTree);
  var PROPERTY_VARIABLE_DECLARATION = ParseTreeType.PROPERTY_VARIABLE_DECLARATION;
  var PropertyVariableDeclaration = function PropertyVariableDeclaration(location, isStatic, name, typeAnnotation, annotations) {
    this.location = location;
    this.isStatic = isStatic;
    this.name = name;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
  };
  ($traceurRuntime.createClass)(PropertyVariableDeclaration, {
    transform: function(transformer) {
      return transformer.transformPropertyVariableDeclaration(this);
    },
    visit: function(visitor) {
      visitor.visitPropertyVariableDeclaration(this);
    },
    get type() {
      return PROPERTY_VARIABLE_DECLARATION;
    }
  }, {}, ParseTree);
  var PROPERTY_SIGNATURE = ParseTreeType.PROPERTY_SIGNATURE;
  var PropertySignature = function PropertySignature(location, name, optional, typeAnnotation) {
    this.location = location;
    this.name = name;
    this.optional = optional;
    this.typeAnnotation = typeAnnotation;
  };
  ($traceurRuntime.createClass)(PropertySignature, {
    transform: function(transformer) {
      return transformer.transformPropertySignature(this);
    },
    visit: function(visitor) {
      visitor.visitPropertySignature(this);
    },
    get type() {
      return PROPERTY_SIGNATURE;
    }
  }, {}, ParseTree);
  var REST_PARAMETER = ParseTreeType.REST_PARAMETER;
  var RestParameter = function RestParameter(location, identifier, typeAnnotation) {
    this.location = location;
    this.identifier = identifier;
    this.typeAnnotation = typeAnnotation;
  };
  ($traceurRuntime.createClass)(RestParameter, {
    transform: function(transformer) {
      return transformer.transformRestParameter(this);
    },
    visit: function(visitor) {
      visitor.visitRestParameter(this);
    },
    get type() {
      return REST_PARAMETER;
    }
  }, {}, ParseTree);
  var RETURN_STATEMENT = ParseTreeType.RETURN_STATEMENT;
  var ReturnStatement = function ReturnStatement(location, expression) {
    this.location = location;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(ReturnStatement, {
    transform: function(transformer) {
      return transformer.transformReturnStatement(this);
    },
    visit: function(visitor) {
      visitor.visitReturnStatement(this);
    },
    get type() {
      return RETURN_STATEMENT;
    }
  }, {}, ParseTree);
  var SET_ACCESSOR = ParseTreeType.SET_ACCESSOR;
  var SetAccessor = function SetAccessor(location, isStatic, name, parameterList, annotations, body) {
    this.location = location;
    this.isStatic = isStatic;
    this.name = name;
    this.parameterList = parameterList;
    this.annotations = annotations;
    this.body = body;
  };
  ($traceurRuntime.createClass)(SetAccessor, {
    transform: function(transformer) {
      return transformer.transformSetAccessor(this);
    },
    visit: function(visitor) {
      visitor.visitSetAccessor(this);
    },
    get type() {
      return SET_ACCESSOR;
    }
  }, {}, ParseTree);
  var SPREAD_EXPRESSION = ParseTreeType.SPREAD_EXPRESSION;
  var SpreadExpression = function SpreadExpression(location, expression) {
    this.location = location;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(SpreadExpression, {
    transform: function(transformer) {
      return transformer.transformSpreadExpression(this);
    },
    visit: function(visitor) {
      visitor.visitSpreadExpression(this);
    },
    get type() {
      return SPREAD_EXPRESSION;
    }
  }, {}, ParseTree);
  var SPREAD_PATTERN_ELEMENT = ParseTreeType.SPREAD_PATTERN_ELEMENT;
  var SpreadPatternElement = function SpreadPatternElement(location, lvalue) {
    this.location = location;
    this.lvalue = lvalue;
  };
  ($traceurRuntime.createClass)(SpreadPatternElement, {
    transform: function(transformer) {
      return transformer.transformSpreadPatternElement(this);
    },
    visit: function(visitor) {
      visitor.visitSpreadPatternElement(this);
    },
    get type() {
      return SPREAD_PATTERN_ELEMENT;
    }
  }, {}, ParseTree);
  var SUPER_EXPRESSION = ParseTreeType.SUPER_EXPRESSION;
  var SuperExpression = function SuperExpression(location) {
    this.location = location;
  };
  ($traceurRuntime.createClass)(SuperExpression, {
    transform: function(transformer) {
      return transformer.transformSuperExpression(this);
    },
    visit: function(visitor) {
      visitor.visitSuperExpression(this);
    },
    get type() {
      return SUPER_EXPRESSION;
    }
  }, {}, ParseTree);
  var SWITCH_STATEMENT = ParseTreeType.SWITCH_STATEMENT;
  var SwitchStatement = function SwitchStatement(location, expression, caseClauses) {
    this.location = location;
    this.expression = expression;
    this.caseClauses = caseClauses;
  };
  ($traceurRuntime.createClass)(SwitchStatement, {
    transform: function(transformer) {
      return transformer.transformSwitchStatement(this);
    },
    visit: function(visitor) {
      visitor.visitSwitchStatement(this);
    },
    get type() {
      return SWITCH_STATEMENT;
    }
  }, {}, ParseTree);
  var SYNTAX_ERROR_TREE = ParseTreeType.SYNTAX_ERROR_TREE;
  var SyntaxErrorTree = function SyntaxErrorTree(location, nextToken, message) {
    this.location = location;
    this.nextToken = nextToken;
    this.message = message;
  };
  ($traceurRuntime.createClass)(SyntaxErrorTree, {
    transform: function(transformer) {
      return transformer.transformSyntaxErrorTree(this);
    },
    visit: function(visitor) {
      visitor.visitSyntaxErrorTree(this);
    },
    get type() {
      return SYNTAX_ERROR_TREE;
    }
  }, {}, ParseTree);
  var TEMPLATE_LITERAL_EXPRESSION = ParseTreeType.TEMPLATE_LITERAL_EXPRESSION;
  var TemplateLiteralExpression = function TemplateLiteralExpression(location, operand, elements) {
    this.location = location;
    this.operand = operand;
    this.elements = elements;
  };
  ($traceurRuntime.createClass)(TemplateLiteralExpression, {
    transform: function(transformer) {
      return transformer.transformTemplateLiteralExpression(this);
    },
    visit: function(visitor) {
      visitor.visitTemplateLiteralExpression(this);
    },
    get type() {
      return TEMPLATE_LITERAL_EXPRESSION;
    }
  }, {}, ParseTree);
  var TEMPLATE_LITERAL_PORTION = ParseTreeType.TEMPLATE_LITERAL_PORTION;
  var TemplateLiteralPortion = function TemplateLiteralPortion(location, value) {
    this.location = location;
    this.value = value;
  };
  ($traceurRuntime.createClass)(TemplateLiteralPortion, {
    transform: function(transformer) {
      return transformer.transformTemplateLiteralPortion(this);
    },
    visit: function(visitor) {
      visitor.visitTemplateLiteralPortion(this);
    },
    get type() {
      return TEMPLATE_LITERAL_PORTION;
    }
  }, {}, ParseTree);
  var TEMPLATE_SUBSTITUTION = ParseTreeType.TEMPLATE_SUBSTITUTION;
  var TemplateSubstitution = function TemplateSubstitution(location, expression) {
    this.location = location;
    this.expression = expression;
  };
  ($traceurRuntime.createClass)(TemplateSubstitution, {
    transform: function(transformer) {
      return transformer.transformTemplateSubstitution(this);
    },
    visit: function(visitor) {
      visitor.visitTemplateSubstitution(this);
    },
    get type() {
      return TEMPLATE_SUBSTITUTION;
    }
  }, {}, ParseTree);
  var THIS_EXPRESSION = ParseTreeType.THIS_EXPRESSION;
  var ThisExpression = function ThisExpression(location) {
    this.location = location;
  };
  ($traceurRuntime.createClass)(ThisExpression, {
    transform: function(transformer) {
      return transformer.transformThisExpression(this);
    },
    visit: function(visitor) {
      visitor.visitThisExpression(this);
    },
    get type() {
      return THIS_EXPRESSION;
    }
  }, {}, ParseTree);
  var THROW_STATEMENT = ParseTreeType.THROW_STATEMENT;
  var ThrowStatement = function ThrowStatement(location, value) {
    this.location = location;
    this.value = value;
  };
  ($traceurRuntime.createClass)(ThrowStatement, {
    transform: function(transformer) {
      return transformer.transformThrowStatement(this);
    },
    visit: function(visitor) {
      visitor.visitThrowStatement(this);
    },
    get type() {
      return THROW_STATEMENT;
    }
  }, {}, ParseTree);
  var TRY_STATEMENT = ParseTreeType.TRY_STATEMENT;
  var TryStatement = function TryStatement(location, body, catchBlock, finallyBlock) {
    this.location = location;
    this.body = body;
    this.catchBlock = catchBlock;
    this.finallyBlock = finallyBlock;
  };
  ($traceurRuntime.createClass)(TryStatement, {
    transform: function(transformer) {
      return transformer.transformTryStatement(this);
    },
    visit: function(visitor) {
      visitor.visitTryStatement(this);
    },
    get type() {
      return TRY_STATEMENT;
    }
  }, {}, ParseTree);
  var TYPE_ARGUMENTS = ParseTreeType.TYPE_ARGUMENTS;
  var TypeArguments = function TypeArguments(location, args) {
    this.location = location;
    this.args = args;
  };
  ($traceurRuntime.createClass)(TypeArguments, {
    transform: function(transformer) {
      return transformer.transformTypeArguments(this);
    },
    visit: function(visitor) {
      visitor.visitTypeArguments(this);
    },
    get type() {
      return TYPE_ARGUMENTS;
    }
  }, {}, ParseTree);
  var TYPE_NAME = ParseTreeType.TYPE_NAME;
  var TypeName = function TypeName(location, moduleName, name) {
    this.location = location;
    this.moduleName = moduleName;
    this.name = name;
  };
  ($traceurRuntime.createClass)(TypeName, {
    transform: function(transformer) {
      return transformer.transformTypeName(this);
    },
    visit: function(visitor) {
      visitor.visitTypeName(this);
    },
    get type() {
      return TYPE_NAME;
    }
  }, {}, ParseTree);
  var TYPE_PARAMETER = ParseTreeType.TYPE_PARAMETER;
  var TypeParameter = function TypeParameter(location, identifierToken, extendsType) {
    this.location = location;
    this.identifierToken = identifierToken;
    this.extendsType = extendsType;
  };
  ($traceurRuntime.createClass)(TypeParameter, {
    transform: function(transformer) {
      return transformer.transformTypeParameter(this);
    },
    visit: function(visitor) {
      visitor.visitTypeParameter(this);
    },
    get type() {
      return TYPE_PARAMETER;
    }
  }, {}, ParseTree);
  var TYPE_PARAMETERS = ParseTreeType.TYPE_PARAMETERS;
  var TypeParameters = function TypeParameters(location, parameters) {
    this.location = location;
    this.parameters = parameters;
  };
  ($traceurRuntime.createClass)(TypeParameters, {
    transform: function(transformer) {
      return transformer.transformTypeParameters(this);
    },
    visit: function(visitor) {
      visitor.visitTypeParameters(this);
    },
    get type() {
      return TYPE_PARAMETERS;
    }
  }, {}, ParseTree);
  var TYPE_REFERENCE = ParseTreeType.TYPE_REFERENCE;
  var TypeReference = function TypeReference(location, typeName, args) {
    this.location = location;
    this.typeName = typeName;
    this.args = args;
  };
  ($traceurRuntime.createClass)(TypeReference, {
    transform: function(transformer) {
      return transformer.transformTypeReference(this);
    },
    visit: function(visitor) {
      visitor.visitTypeReference(this);
    },
    get type() {
      return TYPE_REFERENCE;
    }
  }, {}, ParseTree);
  var UNARY_EXPRESSION = ParseTreeType.UNARY_EXPRESSION;
  var UnaryExpression = function UnaryExpression(location, operator, operand) {
    this.location = location;
    this.operator = operator;
    this.operand = operand;
  };
  ($traceurRuntime.createClass)(UnaryExpression, {
    transform: function(transformer) {
      return transformer.transformUnaryExpression(this);
    },
    visit: function(visitor) {
      visitor.visitUnaryExpression(this);
    },
    get type() {
      return UNARY_EXPRESSION;
    }
  }, {}, ParseTree);
  var UNION_TYPE = ParseTreeType.UNION_TYPE;
  var UnionType = function UnionType(location, types) {
    this.location = location;
    this.types = types;
  };
  ($traceurRuntime.createClass)(UnionType, {
    transform: function(transformer) {
      return transformer.transformUnionType(this);
    },
    visit: function(visitor) {
      visitor.visitUnionType(this);
    },
    get type() {
      return UNION_TYPE;
    }
  }, {}, ParseTree);
  var VARIABLE_DECLARATION = ParseTreeType.VARIABLE_DECLARATION;
  var VariableDeclaration = function VariableDeclaration(location, lvalue, typeAnnotation, initializer) {
    this.location = location;
    this.lvalue = lvalue;
    this.typeAnnotation = typeAnnotation;
    this.initializer = initializer;
  };
  ($traceurRuntime.createClass)(VariableDeclaration, {
    transform: function(transformer) {
      return transformer.transformVariableDeclaration(this);
    },
    visit: function(visitor) {
      visitor.visitVariableDeclaration(this);
    },
    get type() {
      return VARIABLE_DECLARATION;
    }
  }, {}, ParseTree);
  var VARIABLE_DECLARATION_LIST = ParseTreeType.VARIABLE_DECLARATION_LIST;
  var VariableDeclarationList = function VariableDeclarationList(location, declarationType, declarations) {
    this.location = location;
    this.declarationType = declarationType;
    this.declarations = declarations;
  };
  ($traceurRuntime.createClass)(VariableDeclarationList, {
    transform: function(transformer) {
      return transformer.transformVariableDeclarationList(this);
    },
    visit: function(visitor) {
      visitor.visitVariableDeclarationList(this);
    },
    get type() {
      return VARIABLE_DECLARATION_LIST;
    }
  }, {}, ParseTree);
  var VARIABLE_STATEMENT = ParseTreeType.VARIABLE_STATEMENT;
  var VariableStatement = function VariableStatement(location, declarations) {
    this.location = location;
    this.declarations = declarations;
  };
  ($traceurRuntime.createClass)(VariableStatement, {
    transform: function(transformer) {
      return transformer.transformVariableStatement(this);
    },
    visit: function(visitor) {
      visitor.visitVariableStatement(this);
    },
    get type() {
      return VARIABLE_STATEMENT;
    }
  }, {}, ParseTree);
  var WHILE_STATEMENT = ParseTreeType.WHILE_STATEMENT;
  var WhileStatement = function WhileStatement(location, condition, body) {
    this.location = location;
    this.condition = condition;
    this.body = body;
  };
  ($traceurRuntime.createClass)(WhileStatement, {
    transform: function(transformer) {
      return transformer.transformWhileStatement(this);
    },
    visit: function(visitor) {
      visitor.visitWhileStatement(this);
    },
    get type() {
      return WHILE_STATEMENT;
    }
  }, {}, ParseTree);
  var WITH_STATEMENT = ParseTreeType.WITH_STATEMENT;
  var WithStatement = function WithStatement(location, expression, body) {
    this.location = location;
    this.expression = expression;
    this.body = body;
  };
  ($traceurRuntime.createClass)(WithStatement, {
    transform: function(transformer) {
      return transformer.transformWithStatement(this);
    },
    visit: function(visitor) {
      visitor.visitWithStatement(this);
    },
    get type() {
      return WITH_STATEMENT;
    }
  }, {}, ParseTree);
  var YIELD_EXPRESSION = ParseTreeType.YIELD_EXPRESSION;
  var YieldExpression = function YieldExpression(location, expression, isYieldFor) {
    this.location = location;
    this.expression = expression;
    this.isYieldFor = isYieldFor;
  };
  ($traceurRuntime.createClass)(YieldExpression, {
    transform: function(transformer) {
      return transformer.transformYieldExpression(this);
    },
    visit: function(visitor) {
      visitor.visitYieldExpression(this);
    },
    get type() {
      return YIELD_EXPRESSION;
    }
  }, {}, ParseTree);
  return {
    get Annotation() {
      return Annotation;
    },
    get AnonBlock() {
      return AnonBlock;
    },
    get ArgumentList() {
      return ArgumentList;
    },
    get ArrayComprehension() {
      return ArrayComprehension;
    },
    get ArrayLiteralExpression() {
      return ArrayLiteralExpression;
    },
    get ArrayPattern() {
      return ArrayPattern;
    },
    get ArrayType() {
      return ArrayType;
    },
    get ArrowFunctionExpression() {
      return ArrowFunctionExpression;
    },
    get AssignmentElement() {
      return AssignmentElement;
    },
    get AwaitExpression() {
      return AwaitExpression;
    },
    get BinaryExpression() {
      return BinaryExpression;
    },
    get BindingElement() {
      return BindingElement;
    },
    get BindingIdentifier() {
      return BindingIdentifier;
    },
    get Block() {
      return Block;
    },
    get BreakStatement() {
      return BreakStatement;
    },
    get CallExpression() {
      return CallExpression;
    },
    get CallSignature() {
      return CallSignature;
    },
    get CaseClause() {
      return CaseClause;
    },
    get Catch() {
      return Catch;
    },
    get ClassDeclaration() {
      return ClassDeclaration;
    },
    get ClassExpression() {
      return ClassExpression;
    },
    get CommaExpression() {
      return CommaExpression;
    },
    get ComprehensionFor() {
      return ComprehensionFor;
    },
    get ComprehensionIf() {
      return ComprehensionIf;
    },
    get ComputedPropertyName() {
      return ComputedPropertyName;
    },
    get ConditionalExpression() {
      return ConditionalExpression;
    },
    get ConstructSignature() {
      return ConstructSignature;
    },
    get ConstructorType() {
      return ConstructorType;
    },
    get ContinueStatement() {
      return ContinueStatement;
    },
    get CoverFormals() {
      return CoverFormals;
    },
    get CoverInitializedName() {
      return CoverInitializedName;
    },
    get DebuggerStatement() {
      return DebuggerStatement;
    },
    get DefaultClause() {
      return DefaultClause;
    },
    get DoWhileStatement() {
      return DoWhileStatement;
    },
    get EmptyStatement() {
      return EmptyStatement;
    },
    get ExportDeclaration() {
      return ExportDeclaration;
    },
    get ExportDefault() {
      return ExportDefault;
    },
    get ExportSpecifier() {
      return ExportSpecifier;
    },
    get ExportSpecifierSet() {
      return ExportSpecifierSet;
    },
    get ExportStar() {
      return ExportStar;
    },
    get ExpressionStatement() {
      return ExpressionStatement;
    },
    get Finally() {
      return Finally;
    },
    get ForInStatement() {
      return ForInStatement;
    },
    get ForOfStatement() {
      return ForOfStatement;
    },
    get ForStatement() {
      return ForStatement;
    },
    get FormalParameter() {
      return FormalParameter;
    },
    get FormalParameterList() {
      return FormalParameterList;
    },
    get FunctionBody() {
      return FunctionBody;
    },
    get FunctionDeclaration() {
      return FunctionDeclaration;
    },
    get FunctionExpression() {
      return FunctionExpression;
    },
    get FunctionType() {
      return FunctionType;
    },
    get GeneratorComprehension() {
      return GeneratorComprehension;
    },
    get GetAccessor() {
      return GetAccessor;
    },
    get IdentifierExpression() {
      return IdentifierExpression;
    },
    get IfStatement() {
      return IfStatement;
    },
    get ImportedBinding() {
      return ImportedBinding;
    },
    get ImportDeclaration() {
      return ImportDeclaration;
    },
    get ImportSpecifier() {
      return ImportSpecifier;
    },
    get ImportSpecifierSet() {
      return ImportSpecifierSet;
    },
    get IndexSignature() {
      return IndexSignature;
    },
    get InterfaceDeclaration() {
      return InterfaceDeclaration;
    },
    get LabelledStatement() {
      return LabelledStatement;
    },
    get LiteralExpression() {
      return LiteralExpression;
    },
    get LiteralPropertyName() {
      return LiteralPropertyName;
    },
    get MemberExpression() {
      return MemberExpression;
    },
    get MemberLookupExpression() {
      return MemberLookupExpression;
    },
    get MethodSignature() {
      return MethodSignature;
    },
    get Module() {
      return Module;
    },
    get ModuleDeclaration() {
      return ModuleDeclaration;
    },
    get ModuleSpecifier() {
      return ModuleSpecifier;
    },
    get NamedExport() {
      return NamedExport;
    },
    get NewExpression() {
      return NewExpression;
    },
    get ObjectLiteralExpression() {
      return ObjectLiteralExpression;
    },
    get ObjectPattern() {
      return ObjectPattern;
    },
    get ObjectPatternField() {
      return ObjectPatternField;
    },
    get ObjectType() {
      return ObjectType;
    },
    get ParenExpression() {
      return ParenExpression;
    },
    get PostfixExpression() {
      return PostfixExpression;
    },
    get PredefinedType() {
      return PredefinedType;
    },
    get Script() {
      return Script;
    },
    get PropertyMethodAssignment() {
      return PropertyMethodAssignment;
    },
    get PropertyNameAssignment() {
      return PropertyNameAssignment;
    },
    get PropertyNameShorthand() {
      return PropertyNameShorthand;
    },
    get PropertyVariableDeclaration() {
      return PropertyVariableDeclaration;
    },
    get PropertySignature() {
      return PropertySignature;
    },
    get RestParameter() {
      return RestParameter;
    },
    get ReturnStatement() {
      return ReturnStatement;
    },
    get SetAccessor() {
      return SetAccessor;
    },
    get SpreadExpression() {
      return SpreadExpression;
    },
    get SpreadPatternElement() {
      return SpreadPatternElement;
    },
    get SuperExpression() {
      return SuperExpression;
    },
    get SwitchStatement() {
      return SwitchStatement;
    },
    get SyntaxErrorTree() {
      return SyntaxErrorTree;
    },
    get TemplateLiteralExpression() {
      return TemplateLiteralExpression;
    },
    get TemplateLiteralPortion() {
      return TemplateLiteralPortion;
    },
    get TemplateSubstitution() {
      return TemplateSubstitution;
    },
    get ThisExpression() {
      return ThisExpression;
    },
    get ThrowStatement() {
      return ThrowStatement;
    },
    get TryStatement() {
      return TryStatement;
    },
    get TypeArguments() {
      return TypeArguments;
    },
    get TypeName() {
      return TypeName;
    },
    get TypeParameter() {
      return TypeParameter;
    },
    get TypeParameters() {
      return TypeParameters;
    },
    get TypeReference() {
      return TypeReference;
    },
    get UnaryExpression() {
      return UnaryExpression;
    },
    get UnionType() {
      return UnionType;
    },
    get VariableDeclaration() {
      return VariableDeclaration;
    },
    get VariableDeclarationList() {
      return VariableDeclarationList;
    },
    get VariableStatement() {
      return VariableStatement;
    },
    get WhileStatement() {
      return WhileStatement;
    },
    get WithStatement() {
      return WithStatement;
    },
    get YieldExpression() {
      return YieldExpression;
    }
  };
});
System.registerModule("traceur@0.0.80/src/util/assert.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/util/assert.js";
  var options = System.get("traceur@0.0.80/src/Options.js").options;
  function assert(b) {
    if (!b && options.debug)
      throw Error('Assertion failed');
  }
  return {get assert() {
      return assert;
    }};
});
System.registerModule("traceur@0.0.80/src/syntax/IdentifierToken.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/IdentifierToken.js";
  var Token = System.get("traceur@0.0.80/src/syntax/Token.js").Token;
  var IDENTIFIER = System.get("traceur@0.0.80/src/syntax/TokenType.js").IDENTIFIER;
  var IdentifierToken = function IdentifierToken(location, value) {
    this.location = location;
    this.value = value;
  };
  ($traceurRuntime.createClass)(IdentifierToken, {
    toString: function() {
      return this.value;
    },
    get type() {
      return IDENTIFIER;
    }
  }, {}, Token);
  return {get IdentifierToken() {
      return IdentifierToken;
    }};
});
System.registerModule("traceur@0.0.80/src/syntax/LiteralToken.js", [], function() {
  "use strict";
  var $__3;
  var __moduleName = "traceur@0.0.80/src/syntax/LiteralToken.js";
  var Token = System.get("traceur@0.0.80/src/syntax/Token.js").Token;
  var $__1 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      NULL = $__1.NULL,
      NUMBER = $__1.NUMBER,
      STRING = $__1.STRING;
  var StringParser = function StringParser(value) {
    this.value = value;
    this.index = 0;
  };
  ($traceurRuntime.createClass)(StringParser, ($__3 = {}, Object.defineProperty($__3, Symbol.iterator, {
    value: function() {
      return this;
    },
    configurable: true,
    enumerable: true,
    writable: true
  }), Object.defineProperty($__3, "next", {
    value: function() {
      if (++this.index >= this.value.length - 1)
        return {
          value: undefined,
          done: true
        };
      return {
        value: this.value[this.index],
        done: false
      };
    },
    configurable: true,
    enumerable: true,
    writable: true
  }), Object.defineProperty($__3, "parse", {
    value: function() {
      if (this.value.indexOf('\\') === -1)
        return this.value.slice(1, -1);
      var result = '';
      for (var $__4 = this[$traceurRuntime.toProperty(Symbol.iterator)](),
          $__5; !($__5 = $__4.next()).done; ) {
        var ch = $__5.value;
        {
          result += ch === '\\' ? this.parseEscapeSequence() : ch;
        }
      }
      return result;
    },
    configurable: true,
    enumerable: true,
    writable: true
  }), Object.defineProperty($__3, "parseEscapeSequence", {
    value: function() {
      var ch = this.next().value;
      switch (ch) {
        case '\n':
        case '\r':
        case '\u2028':
        case '\u2029':
          return '';
        case '0':
          return '\0';
        case 'b':
          return '\b';
        case 'f':
          return '\f';
        case 'n':
          return '\n';
        case 'r':
          return '\r';
        case 't':
          return '\t';
        case 'v':
          return '\v';
        case 'x':
          return String.fromCharCode(parseInt(this.next().value + this.next().value, 16));
        case 'u':
          var nextValue = this.next().value;
          if (nextValue === '{') {
            var hexDigits = '';
            while ((nextValue = this.next().value) !== '}') {
              hexDigits += nextValue;
            }
            var codePoint = parseInt(hexDigits, 16);
            if (codePoint <= 0xFFFF) {
              return String.fromCharCode(codePoint);
            }
            var high = Math.floor((codePoint - 0x10000) / 0x400) + 0xD800;
            var low = (codePoint - 0x10000) % 0x400 + 0xDC00;
            return String.fromCharCode(high, low);
          }
          return String.fromCharCode(parseInt(nextValue + this.next().value + this.next().value + this.next().value, 16));
        default:
          if (Number(ch) < 8)
            throw new Error('Octal literals are not supported');
          return ch;
      }
    },
    configurable: true,
    enumerable: true,
    writable: true
  }), $__3), {});
  var LiteralToken = function LiteralToken(type, value, location) {
    this.type = type;
    this.location = location;
    this.value = value;
  };
  ($traceurRuntime.createClass)(LiteralToken, {
    toString: function() {
      return this.value;
    },
    get processedValue() {
      switch (this.type) {
        case NULL:
          return null;
        case NUMBER:
          var value = this.value;
          if (value.charCodeAt(0) === 48) {
            switch (value.charCodeAt(1)) {
              case 66:
              case 98:
                return parseInt(this.value.slice(2), 2);
              case 79:
              case 111:
                return parseInt(this.value.slice(2), 8);
            }
          }
          return Number(this.value);
        case STRING:
          var parser = new StringParser(this.value);
          return parser.parse();
        default:
          throw new Error('Not implemented');
      }
    }
  }, {}, Token);
  return {get LiteralToken() {
      return LiteralToken;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ParseTreeFactory.js";
  var IdentifierToken = System.get("traceur@0.0.80/src/syntax/IdentifierToken.js").IdentifierToken;
  var LiteralToken = System.get("traceur@0.0.80/src/syntax/LiteralToken.js").LiteralToken;
  var $__2 = System.get("traceur@0.0.80/src/syntax/trees/ParseTree.js"),
      ParseTree = $__2.ParseTree,
      ParseTreeType = $__2.ParseTreeType;
  var $__3 = System.get("traceur@0.0.80/src/syntax/PredefinedName.js"),
      CALL = $__3.CALL,
      CREATE = $__3.CREATE,
      DEFINE_PROPERTY = $__3.DEFINE_PROPERTY,
      FREEZE = $__3.FREEZE,
      OBJECT = $__3.OBJECT,
      UNDEFINED = $__3.UNDEFINED;
  var Token = System.get("traceur@0.0.80/src/syntax/Token.js").Token;
  var $__5 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      EQUAL = $__5.EQUAL,
      FALSE = $__5.FALSE,
      NULL = $__5.NULL,
      NUMBER = $__5.NUMBER,
      STRING = $__5.STRING,
      TRUE = $__5.TRUE,
      VOID = $__5.VOID;
  var assert = System.get("traceur@0.0.80/src/util/assert.js").assert;
  var $__7 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      ArgumentList = $__7.ArgumentList,
      ArrayLiteralExpression = $__7.ArrayLiteralExpression,
      BinaryExpression = $__7.BinaryExpression,
      BindingIdentifier = $__7.BindingIdentifier,
      Block = $__7.Block,
      BreakStatement = $__7.BreakStatement,
      CallExpression = $__7.CallExpression,
      CaseClause = $__7.CaseClause,
      Catch = $__7.Catch,
      ClassDeclaration = $__7.ClassDeclaration,
      CommaExpression = $__7.CommaExpression,
      ConditionalExpression = $__7.ConditionalExpression,
      ContinueStatement = $__7.ContinueStatement,
      DefaultClause = $__7.DefaultClause,
      DoWhileStatement = $__7.DoWhileStatement,
      EmptyStatement = $__7.EmptyStatement,
      ExpressionStatement = $__7.ExpressionStatement,
      Finally = $__7.Finally,
      ForInStatement = $__7.ForInStatement,
      ForOfStatement = $__7.ForOfStatement,
      ForStatement = $__7.ForStatement,
      FormalParameterList = $__7.FormalParameterList,
      FunctionBody = $__7.FunctionBody,
      FunctionExpression = $__7.FunctionExpression,
      IdentifierExpression = $__7.IdentifierExpression,
      IfStatement = $__7.IfStatement,
      ImportedBinding = $__7.ImportedBinding,
      LiteralExpression = $__7.LiteralExpression,
      LiteralPropertyName = $__7.LiteralPropertyName,
      MemberExpression = $__7.MemberExpression,
      MemberLookupExpression = $__7.MemberLookupExpression,
      NewExpression = $__7.NewExpression,
      ObjectLiteralExpression = $__7.ObjectLiteralExpression,
      ParenExpression = $__7.ParenExpression,
      PostfixExpression = $__7.PostfixExpression,
      Script = $__7.Script,
      PropertyNameAssignment = $__7.PropertyNameAssignment,
      RestParameter = $__7.RestParameter,
      ReturnStatement = $__7.ReturnStatement,
      SpreadExpression = $__7.SpreadExpression,
      SwitchStatement = $__7.SwitchStatement,
      ThisExpression = $__7.ThisExpression,
      ThrowStatement = $__7.ThrowStatement,
      TryStatement = $__7.TryStatement,
      UnaryExpression = $__7.UnaryExpression,
      VariableDeclaration = $__7.VariableDeclaration,
      VariableDeclarationList = $__7.VariableDeclarationList,
      VariableStatement = $__7.VariableStatement,
      WhileStatement = $__7.WhileStatement,
      WithStatement = $__7.WithStatement;
  var slice = Array.prototype.slice.call.bind(Array.prototype.slice);
  var map = Array.prototype.map.call.bind(Array.prototype.map);
  function createOperatorToken(operator) {
    return new Token(operator, null);
  }
  function createIdentifierToken(identifier) {
    return new IdentifierToken(null, identifier);
  }
  function createStringLiteralToken(value) {
    return new LiteralToken(STRING, JSON.stringify(value), null);
  }
  function createBooleanLiteralToken(value) {
    return new Token(value ? TRUE : FALSE, null);
  }
  function createNullLiteralToken() {
    return new LiteralToken(NULL, 'null', null);
  }
  function createNumberLiteralToken(value) {
    return new LiteralToken(NUMBER, String(value), null);
  }
  function createEmptyParameterList() {
    return new FormalParameterList(null, []);
  }
  function createArgumentList(list) {
    return new ArgumentList(null, list);
  }
  function createEmptyArgumentList() {
    return createArgumentList([]);
  }
  function createArrayLiteralExpression(list) {
    return new ArrayLiteralExpression(null, list);
  }
  function createEmptyArrayLiteralExpression() {
    return createArrayLiteralExpression([]);
  }
  function createAssignmentExpression(lhs, rhs) {
    return new BinaryExpression(null, lhs, createOperatorToken(EQUAL), rhs);
  }
  function createBinaryExpression(left, operator, right) {
    return new BinaryExpression(null, left, operator, right);
  }
  function createBindingIdentifier(identifier) {
    if (typeof identifier === 'string')
      identifier = createIdentifierToken(identifier);
    else if (identifier.type === ParseTreeType.BINDING_IDENTIFIER)
      return identifier;
    else if (identifier.type === ParseTreeType.IDENTIFIER_EXPRESSION)
      return new BindingIdentifier(identifier.location, identifier.identifierToken);
    return new BindingIdentifier(null, identifier);
  }
  function createImportedBinding(name) {
    var bindingIdentifier = createBindingIdentifier(name);
    return new ImportedBinding(bindingIdentifier.location, bindingIdentifier);
  }
  function createEmptyStatement() {
    return new EmptyStatement(null);
  }
  function createEmptyBlock() {
    return createBlock([]);
  }
  function createBlock(statements) {
    return new Block(null, statements);
  }
  function createFunctionBody(statements) {
    return new FunctionBody(null, statements);
  }
  function createScopedExpression(body, scope) {
    assert(body.type === 'FUNCTION_BODY');
    return createCallCall(createParenExpression(createFunctionExpression(createEmptyParameterList(), body)), scope);
  }
  function createImmediatelyInvokedFunctionExpression(body) {
    assert(body.type === 'FUNCTION_BODY');
    return createCallExpression(createParenExpression(createFunctionExpression(createEmptyParameterList(), body)));
  }
  function createCallExpression(operand) {
    var args = arguments[1] !== (void 0) ? arguments[1] : createEmptyArgumentList();
    return new CallExpression(null, operand, args);
  }
  function createBreakStatement() {
    var name = arguments[0] !== (void 0) ? arguments[0] : null;
    return new BreakStatement(null, name);
  }
  function createCallCall(func, thisExpression) {
    return createCallExpression(createMemberExpression(func, CALL), createArgumentList([thisExpression]));
  }
  function createCaseClause(expression, statements) {
    return new CaseClause(null, expression, statements);
  }
  function createCatch(identifier, catchBody) {
    identifier = createBindingIdentifier(identifier);
    return new Catch(null, identifier, catchBody);
  }
  function createClassDeclaration(name, superClass, elements) {
    return new ClassDeclaration(null, name, superClass, elements, []);
  }
  function createCommaExpression(expressions) {
    return new CommaExpression(null, expressions);
  }
  function createConditionalExpression(condition, left, right) {
    return new ConditionalExpression(null, condition, left, right);
  }
  function createContinueStatement() {
    var name = arguments[0] !== (void 0) ? arguments[0] : null;
    return new ContinueStatement(null, name);
  }
  function createDefaultClause(statements) {
    return new DefaultClause(null, statements);
  }
  function createDoWhileStatement(body, condition) {
    return new DoWhileStatement(null, body, condition);
  }
  function createAssignmentStatement(lhs, rhs) {
    return createExpressionStatement(createAssignmentExpression(lhs, rhs));
  }
  function createCallStatement(operand) {
    var args = arguments[1];
    return createExpressionStatement(createCallExpression(operand, args));
  }
  function createExpressionStatement(expression) {
    return new ExpressionStatement(null, expression);
  }
  function createFinally(block) {
    return new Finally(null, block);
  }
  function createForOfStatement(initializer, collection, body) {
    return new ForOfStatement(null, initializer, collection, body);
  }
  function createForInStatement(initializer, collection, body) {
    return new ForInStatement(null, initializer, collection, body);
  }
  function createForStatement(variables, condition, increment, body) {
    return new ForStatement(null, variables, condition, increment, body);
  }
  function createFunctionExpression(parameterList, body) {
    assert(body.type === 'FUNCTION_BODY');
    return new FunctionExpression(null, null, false, parameterList, null, [], body);
  }
  function createIdentifierExpression(identifier) {
    if (typeof identifier == 'string')
      identifier = createIdentifierToken(identifier);
    else if (identifier instanceof BindingIdentifier)
      identifier = identifier.identifierToken;
    return new IdentifierExpression(null, identifier);
  }
  function createUndefinedExpression() {
    return createIdentifierExpression(UNDEFINED);
  }
  function createIfStatement(condition, ifClause) {
    var elseClause = arguments[2] !== (void 0) ? arguments[2] : null;
    return new IfStatement(null, condition, ifClause, elseClause);
  }
  function createStringLiteral(value) {
    return new LiteralExpression(null, createStringLiteralToken(value));
  }
  function createBooleanLiteral(value) {
    return new LiteralExpression(null, createBooleanLiteralToken(value));
  }
  function createTrueLiteral() {
    return createBooleanLiteral(true);
  }
  function createFalseLiteral() {
    return createBooleanLiteral(false);
  }
  function createNullLiteral() {
    return new LiteralExpression(null, createNullLiteralToken());
  }
  function createNumberLiteral(value) {
    return new LiteralExpression(null, createNumberLiteralToken(value));
  }
  function createMemberExpression(operand, memberName, memberNames) {
    if (typeof operand == 'string' || operand instanceof IdentifierToken)
      operand = createIdentifierExpression(operand);
    if (typeof memberName == 'string')
      memberName = createIdentifierToken(memberName);
    if (memberName instanceof LiteralToken)
      memberName = new LiteralExpression(null, memberName);
    var tree = memberName instanceof LiteralExpression ? new MemberLookupExpression(null, operand, memberName) : new MemberExpression(null, operand, memberName);
    for (var i = 2; i < arguments.length; i++) {
      tree = createMemberExpression(tree, arguments[i]);
    }
    return tree;
  }
  function createMemberLookupExpression(operand, memberExpression) {
    return new MemberLookupExpression(null, operand, memberExpression);
  }
  function createThisExpression() {
    return new ThisExpression(null);
  }
  function createNewExpression(operand, args) {
    return new NewExpression(null, operand, args);
  }
  function createObjectFreeze(value) {
    return createCallExpression(createMemberExpression(OBJECT, FREEZE), createArgumentList([value]));
  }
  function createObjectCreate(protoExpression, descriptors) {
    var argumentList = [protoExpression];
    if (descriptors)
      argumentList.push(descriptors);
    return createCallExpression(createMemberExpression(OBJECT, CREATE), createArgumentList(argumentList));
  }
  function createObjectLiteral(descr) {
    var propertyNameAndValues = Object.keys(descr).map(function(name) {
      var value = descr[name];
      if (!(value instanceof ParseTree))
        value = createBooleanLiteral(!!value);
      return createPropertyNameAssignment(name, value);
    });
    return createObjectLiteralExpression(propertyNameAndValues);
  }
  function createDefineProperty(tree, name, descr) {
    if (typeof name === 'string')
      name = createStringLiteral(name);
    return createCallExpression(createMemberExpression(OBJECT, DEFINE_PROPERTY), createArgumentList([tree, name, createObjectLiteral(descr)]));
  }
  function createObjectLiteralExpression(propertyNameAndValues) {
    return new ObjectLiteralExpression(null, propertyNameAndValues);
  }
  function createParenExpression(expression) {
    return new ParenExpression(null, expression);
  }
  function createPostfixExpression(operand, operator) {
    return new PostfixExpression(null, operand, operator);
  }
  function createScript(scriptItemList) {
    return new Script(null, scriptItemList);
  }
  function createPropertyNameAssignment(identifier, value) {
    if (typeof identifier == 'string')
      identifier = createLiteralPropertyName(identifier);
    return new PropertyNameAssignment(null, identifier, value);
  }
  function createLiteralPropertyName(name) {
    return new LiteralPropertyName(null, createIdentifierToken(name));
  }
  function createRestParameter(identifier) {
    return new RestParameter(null, createBindingIdentifier(identifier), null);
  }
  function createReturnStatement(expression) {
    return new ReturnStatement(null, expression);
  }
  function createSpreadExpression(expression) {
    return new SpreadExpression(null, expression);
  }
  function createSwitchStatement(expression, caseClauses) {
    return new SwitchStatement(null, expression, caseClauses);
  }
  function createThrowStatement(value) {
    return new ThrowStatement(null, value);
  }
  function createTryStatement(body, catchBlock) {
    var finallyBlock = arguments[2] !== (void 0) ? arguments[2] : null;
    return new TryStatement(null, body, catchBlock, finallyBlock);
  }
  function createUnaryExpression(operator, operand) {
    return new UnaryExpression(null, operator, operand);
  }
  function createUseStrictDirective() {
    return createExpressionStatement(createStringLiteral('use strict'));
  }
  function createVariableDeclarationList(binding, identifierOrDeclarations, initializer) {
    if (identifierOrDeclarations instanceof Array) {
      var declarations = identifierOrDeclarations;
      return new VariableDeclarationList(null, binding, declarations);
    }
    var identifier = identifierOrDeclarations;
    return createVariableDeclarationList(binding, [createVariableDeclaration(identifier, initializer)]);
  }
  function createVariableDeclaration(identifier, initializer) {
    if (!(identifier instanceof ParseTree) || identifier.type !== ParseTreeType.BINDING_IDENTIFIER && identifier.type !== ParseTreeType.OBJECT_PATTERN && identifier.type !== ParseTreeType.ARRAY_PATTERN) {
      identifier = createBindingIdentifier(identifier);
    }
    return new VariableDeclaration(null, identifier, null, initializer);
  }
  function createVariableStatement(listOrBinding, identifier, initializer) {
    if (listOrBinding instanceof VariableDeclarationList)
      return new VariableStatement(null, listOrBinding);
    var binding = listOrBinding;
    var list = createVariableDeclarationList(binding, identifier, initializer);
    return createVariableStatement(list);
  }
  function createVoid0() {
    return createParenExpression(createUnaryExpression(createOperatorToken(VOID), createNumberLiteral(0)));
  }
  function createWhileStatement(condition, body) {
    return new WhileStatement(null, condition, body);
  }
  function createWithStatement(expression, body) {
    return new WithStatement(null, expression, body);
  }
  function createAssignStateStatement(state) {
    return createAssignmentStatement(createMemberExpression('$ctx', 'state'), createNumberLiteral(state));
  }
  return {
    get createOperatorToken() {
      return createOperatorToken;
    },
    get createIdentifierToken() {
      return createIdentifierToken;
    },
    get createStringLiteralToken() {
      return createStringLiteralToken;
    },
    get createBooleanLiteralToken() {
      return createBooleanLiteralToken;
    },
    get createNullLiteralToken() {
      return createNullLiteralToken;
    },
    get createNumberLiteralToken() {
      return createNumberLiteralToken;
    },
    get createEmptyParameterList() {
      return createEmptyParameterList;
    },
    get createArgumentList() {
      return createArgumentList;
    },
    get createEmptyArgumentList() {
      return createEmptyArgumentList;
    },
    get createArrayLiteralExpression() {
      return createArrayLiteralExpression;
    },
    get createEmptyArrayLiteralExpression() {
      return createEmptyArrayLiteralExpression;
    },
    get createAssignmentExpression() {
      return createAssignmentExpression;
    },
    get createBinaryExpression() {
      return createBinaryExpression;
    },
    get createBindingIdentifier() {
      return createBindingIdentifier;
    },
    get createImportedBinding() {
      return createImportedBinding;
    },
    get createEmptyStatement() {
      return createEmptyStatement;
    },
    get createEmptyBlock() {
      return createEmptyBlock;
    },
    get createBlock() {
      return createBlock;
    },
    get createFunctionBody() {
      return createFunctionBody;
    },
    get createScopedExpression() {
      return createScopedExpression;
    },
    get createImmediatelyInvokedFunctionExpression() {
      return createImmediatelyInvokedFunctionExpression;
    },
    get createCallExpression() {
      return createCallExpression;
    },
    get createBreakStatement() {
      return createBreakStatement;
    },
    get createCaseClause() {
      return createCaseClause;
    },
    get createCatch() {
      return createCatch;
    },
    get createClassDeclaration() {
      return createClassDeclaration;
    },
    get createCommaExpression() {
      return createCommaExpression;
    },
    get createConditionalExpression() {
      return createConditionalExpression;
    },
    get createContinueStatement() {
      return createContinueStatement;
    },
    get createDefaultClause() {
      return createDefaultClause;
    },
    get createDoWhileStatement() {
      return createDoWhileStatement;
    },
    get createAssignmentStatement() {
      return createAssignmentStatement;
    },
    get createCallStatement() {
      return createCallStatement;
    },
    get createExpressionStatement() {
      return createExpressionStatement;
    },
    get createFinally() {
      return createFinally;
    },
    get createForOfStatement() {
      return createForOfStatement;
    },
    get createForInStatement() {
      return createForInStatement;
    },
    get createForStatement() {
      return createForStatement;
    },
    get createFunctionExpression() {
      return createFunctionExpression;
    },
    get createIdentifierExpression() {
      return createIdentifierExpression;
    },
    get createUndefinedExpression() {
      return createUndefinedExpression;
    },
    get createIfStatement() {
      return createIfStatement;
    },
    get createStringLiteral() {
      return createStringLiteral;
    },
    get createBooleanLiteral() {
      return createBooleanLiteral;
    },
    get createTrueLiteral() {
      return createTrueLiteral;
    },
    get createFalseLiteral() {
      return createFalseLiteral;
    },
    get createNullLiteral() {
      return createNullLiteral;
    },
    get createNumberLiteral() {
      return createNumberLiteral;
    },
    get createMemberExpression() {
      return createMemberExpression;
    },
    get createMemberLookupExpression() {
      return createMemberLookupExpression;
    },
    get createThisExpression() {
      return createThisExpression;
    },
    get createNewExpression() {
      return createNewExpression;
    },
    get createObjectFreeze() {
      return createObjectFreeze;
    },
    get createObjectCreate() {
      return createObjectCreate;
    },
    get createObjectLiteral() {
      return createObjectLiteral;
    },
    get createDefineProperty() {
      return createDefineProperty;
    },
    get createObjectLiteralExpression() {
      return createObjectLiteralExpression;
    },
    get createParenExpression() {
      return createParenExpression;
    },
    get createPostfixExpression() {
      return createPostfixExpression;
    },
    get createScript() {
      return createScript;
    },
    get createPropertyNameAssignment() {
      return createPropertyNameAssignment;
    },
    get createReturnStatement() {
      return createReturnStatement;
    },
    get createSwitchStatement() {
      return createSwitchStatement;
    },
    get createThrowStatement() {
      return createThrowStatement;
    },
    get createTryStatement() {
      return createTryStatement;
    },
    get createUnaryExpression() {
      return createUnaryExpression;
    },
    get createUseStrictDirective() {
      return createUseStrictDirective;
    },
    get createVariableDeclarationList() {
      return createVariableDeclarationList;
    },
    get createVariableDeclaration() {
      return createVariableDeclaration;
    },
    get createVariableStatement() {
      return createVariableStatement;
    },
    get createVoid0() {
      return createVoid0;
    },
    get createWhileStatement() {
      return createWhileStatement;
    },
    get createWithStatement() {
      return createWithStatement;
    },
    get createAssignStateStatement() {
      return createAssignStateStatement;
    }
  };
});
System.registerModule("traceur@0.0.80/src/codegeneration/FindVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/FindVisitor.js";
  var ParseTreeVisitor = System.get("traceur@0.0.80/src/syntax/ParseTreeVisitor.js").ParseTreeVisitor;
  var FindVisitor = function FindVisitor() {
    var keepOnGoing = arguments[0];
    this.found_ = false;
    this.shouldContinue_ = true;
    this.keepOnGoing_ = keepOnGoing;
  };
  ($traceurRuntime.createClass)(FindVisitor, {
    get found() {
      return this.found_;
    },
    set found(v) {
      if (v) {
        this.found_ = true;
        if (!this.keepOnGoing_)
          this.shouldContinue_ = false;
      }
    },
    visitAny: function(tree) {
      this.shouldContinue_ && tree && tree.visit(this);
    },
    visitList: function(list) {
      if (list) {
        for (var i = 0; this.shouldContinue_ && i < list.length; i++) {
          this.visitAny(list[i]);
        }
      }
    }
  }, {}, ParseTreeVisitor);
  return {get FindVisitor() {
      return FindVisitor;
    }};
});
System.registerModule("traceur@0.0.80/src/syntax/Keywords.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/Keywords.js";
  var keywords = ['break', 'case', 'catch', 'class', 'const', 'continue', 'debugger', 'default', 'delete', 'do', 'else', 'export', 'finally', 'for', 'function', 'if', 'import', 'in', 'instanceof', 'let', 'new', 'return', 'super', 'switch', 'this', 'throw', 'try', 'typeof', 'var', 'void', 'while', 'with', 'enum', 'extends', 'null', 'true', 'false'];
  var strictKeywords = ['implements', 'interface', 'package', 'private', 'protected', 'public', 'static', 'yield'];
  var keywordsByName = Object.create(null);
  var NORMAL_KEYWORD = 1;
  var STRICT_KEYWORD = 2;
  keywords.forEach((function(value) {
    keywordsByName[value] = NORMAL_KEYWORD;
  }));
  strictKeywords.forEach((function(value) {
    keywordsByName[value] = STRICT_KEYWORD;
  }));
  function getKeywordType(value) {
    return keywordsByName[value];
  }
  function isStrictKeyword(value) {
    return getKeywordType(value) === STRICT_KEYWORD;
  }
  return {
    get NORMAL_KEYWORD() {
      return NORMAL_KEYWORD;
    },
    get STRICT_KEYWORD() {
      return STRICT_KEYWORD;
    },
    get getKeywordType() {
      return getKeywordType;
    },
    get isStrictKeyword() {
      return isStrictKeyword;
    }
  };
});
System.registerModule("traceur@0.0.80/src/staticsemantics/StrictParams.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/staticsemantics/StrictParams.js";
  var ParseTreeVisitor = System.get("traceur@0.0.80/src/syntax/ParseTreeVisitor.js").ParseTreeVisitor;
  var isStrictKeyword = System.get("traceur@0.0.80/src/syntax/Keywords.js").isStrictKeyword;
  var StrictParams = function StrictParams(errorReporter) {
    $traceurRuntime.superConstructor($StrictParams).call(this);
    this.errorReporter = errorReporter;
  };
  var $StrictParams = StrictParams;
  ($traceurRuntime.createClass)(StrictParams, {visitBindingIdentifier: function(tree) {
      var name = tree.identifierToken.toString();
      if (isStrictKeyword(name)) {
        this.errorReporter.reportError(tree.location.start, (name + " is a reserved identifier"));
      }
    }}, {visit: function(tree, errorReporter) {
      new $StrictParams(errorReporter).visitAny(tree);
    }}, ParseTreeVisitor);
  return {get StrictParams() {
      return StrictParams;
    }};
});
System.registerModule("traceur@0.0.80/src/util/SourceRange.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/util/SourceRange.js";
  var SourceRange = function SourceRange(start, end) {
    this.start = start;
    this.end = end;
  };
  ($traceurRuntime.createClass)(SourceRange, {toString: function() {
      var str = this.start.source.contents;
      return str.slice(this.start.offset, this.end.offset);
    }}, {});
  return {get SourceRange() {
      return SourceRange;
    }};
});
System.registerModule("traceur@0.0.80/src/util/ErrorReporter.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/util/ErrorReporter.js";
  var ErrorReporter = function ErrorReporter() {
    this.hadError_ = false;
  };
  ($traceurRuntime.createClass)(ErrorReporter, {
    reportError: function(location, message) {
      this.hadError_ = true;
      this.reportMessageInternal(location, message);
    },
    reportMessageInternal: function(location, message) {
      if (location)
        message = (location + ": " + message);
      console.error(message);
    },
    hadError: function() {
      return this.hadError_;
    },
    clearError: function() {
      this.hadError_ = false;
    }
  }, {});
  function format(location, text) {
    var args = arguments[2];
    var i = 0;
    text = text.replace(/%./g, function(s) {
      switch (s) {
        case '%s':
          return args && args[i++];
        case '%%':
          return '%';
      }
      return s;
    });
    if (location)
      text = (location + ": " + text);
    return text;
  }
  ;
  ErrorReporter.format = format;
  return {
    get ErrorReporter() {
      return ErrorReporter;
    },
    get format() {
      return format;
    }
  };
});
System.registerModule("traceur@0.0.80/src/util/SyntaxErrorReporter.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/util/SyntaxErrorReporter.js";
  var $__0 = System.get("traceur@0.0.80/src/util/ErrorReporter.js"),
      ErrorReporter = $__0.ErrorReporter,
      format = $__0.format;
  var SyntaxErrorReporter = function SyntaxErrorReporter() {
    $traceurRuntime.superConstructor($SyntaxErrorReporter).apply(this, arguments);
  };
  var $SyntaxErrorReporter = SyntaxErrorReporter;
  ($traceurRuntime.createClass)(SyntaxErrorReporter, {reportMessageInternal: function(location, message) {
      var s = format(location, message);
      throw new SyntaxError(s);
    }}, {}, ErrorReporter);
  return {get SyntaxErrorReporter() {
      return SyntaxErrorReporter;
    }};
});
System.registerModule("traceur@0.0.80/src/syntax/KeywordToken.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/KeywordToken.js";
  var STRICT_KEYWORD = System.get("traceur@0.0.80/src/syntax/Keywords.js").STRICT_KEYWORD;
  var Token = System.get("traceur@0.0.80/src/syntax/Token.js").Token;
  var KeywordToken = function KeywordToken(type, keywordType, location) {
    this.type = type;
    this.location = location;
    this.isStrictKeyword_ = keywordType === STRICT_KEYWORD;
  };
  ($traceurRuntime.createClass)(KeywordToken, {
    isKeyword: function() {
      return true;
    },
    isStrictKeyword: function() {
      return this.isStrictKeyword_;
    }
  }, {}, Token);
  return {get KeywordToken() {
      return KeywordToken;
    }};
});
System.registerModule("traceur@0.0.80/src/syntax/unicode-tables.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/unicode-tables.js";
  var idStartTable = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 442, 443, 443, 444, 447, 448, 451, 452, 659, 660, 660, 661, 687, 688, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 883, 884, 884, 886, 887, 890, 890, 891, 893, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1319, 1329, 1366, 1369, 1369, 1377, 1415, 1488, 1514, 1520, 1522, 1568, 1599, 1600, 1600, 1601, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2208, 2208, 2210, 2220, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2417, 2418, 2423, 2425, 2431, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3133, 3133, 3160, 3161, 3168, 3169, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3294, 3294, 3296, 3297, 3313, 3314, 3333, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3424, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3653, 3654, 3654, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4348, 4349, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5108, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5872, 5888, 5900, 5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6108, 6108, 6176, 6210, 6211, 6211, 6212, 6263, 6272, 6312, 6314, 6314, 6320, 6389, 6400, 6428, 6480, 6509, 6512, 6516, 6528, 6571, 6593, 6599, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7287, 7288, 7293, 7401, 7404, 7406, 7409, 7413, 7414, 7424, 7467, 7468, 7530, 7531, 7543, 7544, 7544, 7545, 7578, 7579, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8472, 8472, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8494, 8494, 8495, 8500, 8501, 8504, 8505, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8578, 8579, 8580, 8581, 8584, 11264, 11310, 11312, 11358, 11360, 11387, 11388, 11389, 11390, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 12293, 12293, 12294, 12294, 12295, 12295, 12321, 12329, 12337, 12341, 12344, 12346, 12347, 12347, 12348, 12348, 12353, 12438, 12443, 12444, 12445, 12446, 12447, 12447, 12449, 12538, 12540, 12542, 12543, 12543, 12549, 12589, 12593, 12686, 12704, 12730, 12784, 12799, 13312, 19893, 19968, 40908, 40960, 40980, 40981, 40981, 40982, 42124, 42192, 42231, 42232, 42237, 42240, 42507, 42508, 42508, 42512, 42527, 42538, 42539, 42560, 42605, 42606, 42606, 42623, 42623, 42624, 42647, 42656, 42725, 42726, 42735, 42775, 42783, 42786, 42863, 42864, 42864, 42865, 42887, 42888, 42888, 42891, 42894, 42896, 42899, 42912, 42922, 43000, 43001, 43002, 43002, 43003, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43631, 43632, 43632, 43633, 43638, 43642, 43642, 43648, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43740, 43741, 43741, 43744, 43754, 43762, 43762, 43763, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43968, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65391, 65392, 65392, 65393, 65437, 65438, 65439, 65440, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66334, 66352, 66368, 66369, 66369, 66370, 66377, 66378, 66378, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66639, 66640, 66717, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68147, 68192, 68220, 68352, 68405, 68416, 68437, 68448, 68466, 68608, 68680, 69635, 69687, 69763, 69807, 69840, 69864, 69891, 69926, 70019, 70066, 70081, 70084, 71296, 71338, 73728, 74606, 74752, 74850, 77824, 78894, 92160, 92728, 93952, 94020, 94032, 94032, 94099, 94111, 110592, 110593, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173782, 173824, 177972, 177984, 178205, 194560, 195101];
  var idContinueTable = [183, 183, 768, 879, 903, 903, 1155, 1159, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1552, 1562, 1611, 1631, 1632, 1641, 1648, 1648, 1750, 1756, 1759, 1764, 1767, 1768, 1770, 1773, 1776, 1785, 1809, 1809, 1840, 1866, 1958, 1968, 1984, 1993, 2027, 2035, 2070, 2073, 2075, 2083, 2085, 2087, 2089, 2093, 2137, 2139, 2276, 2302, 2304, 2306, 2307, 2307, 2362, 2362, 2363, 2363, 2364, 2364, 2366, 2368, 2369, 2376, 2377, 2380, 2381, 2381, 2382, 2383, 2385, 2391, 2402, 2403, 2406, 2415, 2433, 2433, 2434, 2435, 2492, 2492, 2494, 2496, 2497, 2500, 2503, 2504, 2507, 2508, 2509, 2509, 2519, 2519, 2530, 2531, 2534, 2543, 2561, 2562, 2563, 2563, 2620, 2620, 2622, 2624, 2625, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2662, 2671, 2672, 2673, 2677, 2677, 2689, 2690, 2691, 2691, 2748, 2748, 2750, 2752, 2753, 2757, 2759, 2760, 2761, 2761, 2763, 2764, 2765, 2765, 2786, 2787, 2790, 2799, 2817, 2817, 2818, 2819, 2876, 2876, 2878, 2878, 2879, 2879, 2880, 2880, 2881, 2884, 2887, 2888, 2891, 2892, 2893, 2893, 2902, 2902, 2903, 2903, 2914, 2915, 2918, 2927, 2946, 2946, 3006, 3007, 3008, 3008, 3009, 3010, 3014, 3016, 3018, 3020, 3021, 3021, 3031, 3031, 3046, 3055, 3073, 3075, 3134, 3136, 3137, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3170, 3171, 3174, 3183, 3202, 3203, 3260, 3260, 3262, 3262, 3263, 3263, 3264, 3268, 3270, 3270, 3271, 3272, 3274, 3275, 3276, 3277, 3285, 3286, 3298, 3299, 3302, 3311, 3330, 3331, 3390, 3392, 3393, 3396, 3398, 3400, 3402, 3404, 3405, 3405, 3415, 3415, 3426, 3427, 3430, 3439, 3458, 3459, 3530, 3530, 3535, 3537, 3538, 3540, 3542, 3542, 3544, 3551, 3570, 3571, 3633, 3633, 3636, 3642, 3655, 3662, 3664, 3673, 3761, 3761, 3764, 3769, 3771, 3772, 3784, 3789, 3792, 3801, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3903, 3953, 3966, 3967, 3967, 3968, 3972, 3974, 3975, 3981, 3991, 3993, 4028, 4038, 4038, 4139, 4140, 4141, 4144, 4145, 4145, 4146, 4151, 4152, 4152, 4153, 4154, 4155, 4156, 4157, 4158, 4160, 4169, 4182, 4183, 4184, 4185, 4190, 4192, 4194, 4196, 4199, 4205, 4209, 4212, 4226, 4226, 4227, 4228, 4229, 4230, 4231, 4236, 4237, 4237, 4239, 4239, 4240, 4249, 4250, 4252, 4253, 4253, 4957, 4959, 4969, 4977, 5906, 5908, 5938, 5940, 5970, 5971, 6002, 6003, 6068, 6069, 6070, 6070, 6071, 6077, 6078, 6085, 6086, 6086, 6087, 6088, 6089, 6099, 6109, 6109, 6112, 6121, 6155, 6157, 6160, 6169, 6313, 6313, 6432, 6434, 6435, 6438, 6439, 6440, 6441, 6443, 6448, 6449, 6450, 6450, 6451, 6456, 6457, 6459, 6470, 6479, 6576, 6592, 6600, 6601, 6608, 6617, 6618, 6618, 6679, 6680, 6681, 6683, 6741, 6741, 6742, 6742, 6743, 6743, 6744, 6750, 6752, 6752, 6753, 6753, 6754, 6754, 6755, 6756, 6757, 6764, 6765, 6770, 6771, 6780, 6783, 6783, 6784, 6793, 6800, 6809, 6912, 6915, 6916, 6916, 6964, 6964, 6965, 6965, 6966, 6970, 6971, 6971, 6972, 6972, 6973, 6977, 6978, 6978, 6979, 6980, 6992, 7001, 7019, 7027, 7040, 7041, 7042, 7042, 7073, 7073, 7074, 7077, 7078, 7079, 7080, 7081, 7082, 7082, 7083, 7083, 7084, 7085, 7088, 7097, 7142, 7142, 7143, 7143, 7144, 7145, 7146, 7148, 7149, 7149, 7150, 7150, 7151, 7153, 7154, 7155, 7204, 7211, 7212, 7219, 7220, 7221, 7222, 7223, 7232, 7241, 7248, 7257, 7376, 7378, 7380, 7392, 7393, 7393, 7394, 7400, 7405, 7405, 7410, 7411, 7412, 7412, 7616, 7654, 7676, 7679, 8255, 8256, 8276, 8276, 8400, 8412, 8417, 8417, 8421, 8432, 11503, 11505, 11647, 11647, 11744, 11775, 12330, 12333, 12334, 12335, 12441, 12442, 42528, 42537, 42607, 42607, 42612, 42621, 42655, 42655, 42736, 42737, 43010, 43010, 43014, 43014, 43019, 43019, 43043, 43044, 43045, 43046, 43047, 43047, 43136, 43137, 43188, 43203, 43204, 43204, 43216, 43225, 43232, 43249, 43264, 43273, 43302, 43309, 43335, 43345, 43346, 43347, 43392, 43394, 43395, 43395, 43443, 43443, 43444, 43445, 43446, 43449, 43450, 43451, 43452, 43452, 43453, 43456, 43472, 43481, 43561, 43566, 43567, 43568, 43569, 43570, 43571, 43572, 43573, 43574, 43587, 43587, 43596, 43596, 43597, 43597, 43600, 43609, 43643, 43643, 43696, 43696, 43698, 43700, 43703, 43704, 43710, 43711, 43713, 43713, 43755, 43755, 43756, 43757, 43758, 43759, 43765, 43765, 43766, 43766, 44003, 44004, 44005, 44005, 44006, 44007, 44008, 44008, 44009, 44010, 44012, 44012, 44013, 44013, 44016, 44025, 64286, 64286, 65024, 65039, 65056, 65062, 65075, 65076, 65101, 65103, 65296, 65305, 65343, 65343, 66045, 66045, 66720, 66729, 68097, 68099, 68101, 68102, 68108, 68111, 68152, 68154, 68159, 68159, 69632, 69632, 69633, 69633, 69634, 69634, 69688, 69702, 69734, 69743, 69760, 69761, 69762, 69762, 69808, 69810, 69811, 69814, 69815, 69816, 69817, 69818, 69872, 69881, 69888, 69890, 69927, 69931, 69932, 69932, 69933, 69940, 69942, 69951, 70016, 70017, 70018, 70018, 70067, 70069, 70070, 70078, 70079, 70080, 70096, 70105, 71339, 71339, 71340, 71340, 71341, 71341, 71342, 71343, 71344, 71349, 71350, 71350, 71351, 71351, 71360, 71369, 94033, 94078, 94095, 94098, 119141, 119142, 119143, 119145, 119149, 119154, 119163, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 120782, 120831, 917760, 917999];
  return {
    get idStartTable() {
      return idStartTable;
    },
    get idContinueTable() {
      return idContinueTable;
    }
  };
});
System.registerModule("traceur@0.0.80/src/syntax/Scanner.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/Scanner.js";
  var IdentifierToken = System.get("traceur@0.0.80/src/syntax/IdentifierToken.js").IdentifierToken;
  var KeywordToken = System.get("traceur@0.0.80/src/syntax/KeywordToken.js").KeywordToken;
  var LiteralToken = System.get("traceur@0.0.80/src/syntax/LiteralToken.js").LiteralToken;
  var Token = System.get("traceur@0.0.80/src/syntax/Token.js").Token;
  var getKeywordType = System.get("traceur@0.0.80/src/syntax/Keywords.js").getKeywordType;
  var $__5 = System.get("traceur@0.0.80/src/syntax/unicode-tables.js"),
      idContinueTable = $__5.idContinueTable,
      idStartTable = $__5.idStartTable;
  var $__6 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      AMPERSAND = $__6.AMPERSAND,
      AMPERSAND_EQUAL = $__6.AMPERSAND_EQUAL,
      AND = $__6.AND,
      ARROW = $__6.ARROW,
      AT = $__6.AT,
      BANG = $__6.BANG,
      BAR = $__6.BAR,
      BAR_EQUAL = $__6.BAR_EQUAL,
      CARET = $__6.CARET,
      CARET_EQUAL = $__6.CARET_EQUAL,
      CLOSE_ANGLE = $__6.CLOSE_ANGLE,
      CLOSE_CURLY = $__6.CLOSE_CURLY,
      CLOSE_PAREN = $__6.CLOSE_PAREN,
      CLOSE_SQUARE = $__6.CLOSE_SQUARE,
      COLON = $__6.COLON,
      COMMA = $__6.COMMA,
      DOT_DOT_DOT = $__6.DOT_DOT_DOT,
      END_OF_FILE = $__6.END_OF_FILE,
      EQUAL = $__6.EQUAL,
      EQUAL_EQUAL = $__6.EQUAL_EQUAL,
      EQUAL_EQUAL_EQUAL = $__6.EQUAL_EQUAL_EQUAL,
      ERROR = $__6.ERROR,
      GREATER_EQUAL = $__6.GREATER_EQUAL,
      LEFT_SHIFT = $__6.LEFT_SHIFT,
      LEFT_SHIFT_EQUAL = $__6.LEFT_SHIFT_EQUAL,
      LESS_EQUAL = $__6.LESS_EQUAL,
      MINUS = $__6.MINUS,
      MINUS_EQUAL = $__6.MINUS_EQUAL,
      MINUS_MINUS = $__6.MINUS_MINUS,
      NO_SUBSTITUTION_TEMPLATE = $__6.NO_SUBSTITUTION_TEMPLATE,
      NOT_EQUAL = $__6.NOT_EQUAL,
      NOT_EQUAL_EQUAL = $__6.NOT_EQUAL_EQUAL,
      NUMBER = $__6.NUMBER,
      OPEN_ANGLE = $__6.OPEN_ANGLE,
      OPEN_CURLY = $__6.OPEN_CURLY,
      OPEN_PAREN = $__6.OPEN_PAREN,
      OPEN_SQUARE = $__6.OPEN_SQUARE,
      OR = $__6.OR,
      PERCENT = $__6.PERCENT,
      PERCENT_EQUAL = $__6.PERCENT_EQUAL,
      PERIOD = $__6.PERIOD,
      PLUS = $__6.PLUS,
      PLUS_EQUAL = $__6.PLUS_EQUAL,
      PLUS_PLUS = $__6.PLUS_PLUS,
      QUESTION = $__6.QUESTION,
      REGULAR_EXPRESSION = $__6.REGULAR_EXPRESSION,
      RIGHT_SHIFT = $__6.RIGHT_SHIFT,
      RIGHT_SHIFT_EQUAL = $__6.RIGHT_SHIFT_EQUAL,
      SEMI_COLON = $__6.SEMI_COLON,
      SLASH = $__6.SLASH,
      SLASH_EQUAL = $__6.SLASH_EQUAL,
      STAR = $__6.STAR,
      STAR_EQUAL = $__6.STAR_EQUAL,
      STAR_STAR = $__6.STAR_STAR,
      STAR_STAR_EQUAL = $__6.STAR_STAR_EQUAL,
      STRING = $__6.STRING,
      TEMPLATE_HEAD = $__6.TEMPLATE_HEAD,
      TEMPLATE_MIDDLE = $__6.TEMPLATE_MIDDLE,
      TEMPLATE_TAIL = $__6.TEMPLATE_TAIL,
      TILDE = $__6.TILDE,
      UNSIGNED_RIGHT_SHIFT = $__6.UNSIGNED_RIGHT_SHIFT,
      UNSIGNED_RIGHT_SHIFT_EQUAL = $__6.UNSIGNED_RIGHT_SHIFT_EQUAL;
  var isWhitespaceArray = [];
  for (var i = 0; i < 128; i++) {
    isWhitespaceArray[i] = i >= 9 && i <= 13 || i === 0x20;
  }
  var isWhitespaceArray = [];
  for (var i = 0; i < 128; i++) {
    isWhitespaceArray[i] = i >= 9 && i <= 13 || i === 0x20;
  }
  function isWhitespace(code) {
    if (code < 128)
      return isWhitespaceArray[code];
    switch (code) {
      case 0xA0:
      case 0xFEFF:
      case 0x2028:
      case 0x2029:
        return true;
    }
    return false;
  }
  function isLineTerminator(code) {
    switch (code) {
      case 10:
      case 13:
      case 0x2028:
      case 0x2029:
        return true;
    }
    return false;
  }
  function isDecimalDigit(code) {
    return code >= 48 && code <= 57;
  }
  var isHexDigitArray = [];
  for (var i = 0; i < 128; i++) {
    isHexDigitArray[i] = i >= 48 && i <= 57 || i >= 65 && i <= 70 || i >= 97 && i <= 102;
  }
  function isHexDigit(code) {
    return code < 128 && isHexDigitArray[code];
  }
  function isBinaryDigit(code) {
    return code === 48 || code === 49;
  }
  function isOctalDigit(code) {
    return code >= 48 && code <= 55;
  }
  var isIdentifierStartArray = [];
  for (var i = 0; i < 128; i++) {
    isIdentifierStartArray[i] = i === 36 || i >= 65 && i <= 90 || i === 95 || i >= 97 && i <= 122;
  }
  function isIdentifierStart(code) {
    return code < 128 ? isIdentifierStartArray[code] : inTable(idStartTable, code);
  }
  var isIdentifierPartArray = [];
  for (var i = 0; i < 128; i++) {
    isIdentifierPartArray[i] = isIdentifierStart(i) || isDecimalDigit(i);
  }
  function isIdentifierPart(code) {
    return code < 128 ? isIdentifierPartArray[code] : inTable(idStartTable, code) || inTable(idContinueTable, code) || code === 8204 || code === 8205;
  }
  function inTable(table, code) {
    for (var i = 0; i < table.length; ) {
      if (code < table[i++])
        return false;
      if (code <= table[i++])
        return true;
    }
    return false;
  }
  function isRegularExpressionChar(code) {
    switch (code) {
      case 47:
        return false;
      case 91:
      case 92:
        return true;
    }
    return !isLineTerminator(code);
  }
  function isRegularExpressionFirstChar(code) {
    return isRegularExpressionChar(code) && code !== 42;
  }
  var index,
      input,
      length,
      token,
      lastToken,
      lookaheadToken,
      currentCharCode,
      lineNumberTable,
      errorReporter,
      currentParser,
      options;
  var Scanner = function Scanner(reporter, file, parser, traceurOptions) {
    errorReporter = reporter;
    lineNumberTable = file.lineNumberTable;
    input = file.contents;
    length = file.contents.length;
    this.index = 0;
    currentParser = parser;
    options = traceurOptions;
  };
  ($traceurRuntime.createClass)(Scanner, {
    get lastToken() {
      return lastToken;
    },
    getPosition: function() {
      return getPosition(getOffset());
    },
    nextRegularExpressionLiteralToken: function() {
      lastToken = nextRegularExpressionLiteralToken();
      token = scanToken();
      return lastToken;
    },
    nextTemplateLiteralToken: function() {
      var t = nextTemplateLiteralToken();
      token = scanToken();
      return t;
    },
    nextCloseAngle: function() {
      switch (token.type) {
        case GREATER_EQUAL:
        case RIGHT_SHIFT:
        case RIGHT_SHIFT_EQUAL:
        case UNSIGNED_RIGHT_SHIFT:
        case UNSIGNED_RIGHT_SHIFT_EQUAL:
          this.index -= token.type.length - 1;
          lastToken = createToken(CLOSE_ANGLE, index);
          token = scanToken();
          return lastToken;
      }
      return nextToken();
    },
    nextToken: function() {
      return nextToken();
    },
    peekToken: function(opt_index) {
      return opt_index ? peekTokenLookahead() : peekToken();
    },
    peekTokenNoLineTerminator: function() {
      return peekTokenNoLineTerminator();
    },
    isAtEnd: function() {
      return isAtEnd();
    },
    set index(i) {
      index = i;
      lastToken = null;
      token = null;
      lookaheadToken = null;
      updateCurrentCharCode();
    },
    get index() {
      return index;
    }
  }, {});
  function getPosition(offset) {
    return lineNumberTable.getSourcePosition(offset);
  }
  function getTokenRange(startOffset) {
    return lineNumberTable.getSourceRange(startOffset, index);
  }
  function getOffset() {
    return token ? token.location.start.offset : index;
  }
  function nextRegularExpressionLiteralToken() {
    var beginIndex = index - token.toString().length;
    if (!(token.type == SLASH_EQUAL && currentCharCode === 47) && !skipRegularExpressionBody()) {
      return new LiteralToken(REGULAR_EXPRESSION, getTokenString(beginIndex), getTokenRange(beginIndex));
    }
    if (currentCharCode !== 47) {
      reportError('Expected \'/\' in regular expression literal');
      return new LiteralToken(REGULAR_EXPRESSION, getTokenString(beginIndex), getTokenRange(beginIndex));
    }
    next();
    while (isIdentifierPart(currentCharCode)) {
      next();
    }
    return new LiteralToken(REGULAR_EXPRESSION, getTokenString(beginIndex), getTokenRange(beginIndex));
  }
  function skipRegularExpressionBody() {
    if (!isRegularExpressionFirstChar(currentCharCode)) {
      reportError('Expected regular expression first char');
      return false;
    }
    while (!isAtEnd() && isRegularExpressionChar(currentCharCode)) {
      if (!skipRegularExpressionChar())
        return false;
    }
    return true;
  }
  function skipRegularExpressionChar() {
    switch (currentCharCode) {
      case 92:
        return skipRegularExpressionBackslashSequence();
      case 91:
        return skipRegularExpressionClass();
      default:
        next();
        return true;
    }
  }
  function skipRegularExpressionBackslashSequence() {
    next();
    if (isLineTerminator(currentCharCode) || isAtEnd()) {
      reportError('New line not allowed in regular expression literal');
      return false;
    }
    next();
    return true;
  }
  function skipRegularExpressionClass() {
    next();
    while (!isAtEnd() && peekRegularExpressionClassChar()) {
      if (!skipRegularExpressionClassChar()) {
        return false;
      }
    }
    if (currentCharCode !== 93) {
      reportError('\']\' expected');
      return false;
    }
    next();
    return true;
  }
  function peekRegularExpressionClassChar() {
    return currentCharCode !== 93 && !isLineTerminator(currentCharCode);
  }
  function skipRegularExpressionClassChar() {
    if (currentCharCode === 92) {
      return skipRegularExpressionBackslashSequence();
    }
    next();
    return true;
  }
  function skipTemplateCharacter() {
    while (!isAtEnd()) {
      switch (currentCharCode) {
        case 96:
          return;
        case 92:
          skipStringLiteralEscapeSequence();
          break;
        case 36:
          var code = input.charCodeAt(index + 1);
          if (code === 123)
            return;
        default:
          next();
      }
    }
  }
  function scanTemplateStart(beginIndex) {
    if (isAtEnd()) {
      reportError('Unterminated template literal');
      return lastToken = createToken(END_OF_FILE, beginIndex);
    }
    return nextTemplateLiteralTokenShared(NO_SUBSTITUTION_TEMPLATE, TEMPLATE_HEAD);
  }
  function nextTemplateLiteralToken() {
    if (isAtEnd()) {
      reportError('Expected \'}\' after expression in template literal');
      return createToken(END_OF_FILE, index);
    }
    if (token.type !== CLOSE_CURLY) {
      reportError('Expected \'}\' after expression in template literal');
      return createToken(ERROR, index);
    }
    return nextTemplateLiteralTokenShared(TEMPLATE_TAIL, TEMPLATE_MIDDLE);
  }
  function nextTemplateLiteralTokenShared(endType, middleType) {
    var beginIndex = index;
    skipTemplateCharacter();
    if (isAtEnd()) {
      reportError('Unterminated template literal');
      return createToken(ERROR, beginIndex);
    }
    var value = getTokenString(beginIndex);
    switch (currentCharCode) {
      case 96:
        next();
        return lastToken = new LiteralToken(endType, value, getTokenRange(beginIndex - 1));
      case 36:
        next();
        next();
        return lastToken = new LiteralToken(middleType, value, getTokenRange(beginIndex - 1));
    }
  }
  function nextToken() {
    var t = peekToken();
    token = lookaheadToken || scanToken();
    lookaheadToken = null;
    lastToken = t;
    return t;
  }
  function peekTokenNoLineTerminator() {
    var t = peekToken();
    var start = lastToken.location.end.offset;
    var end = t.location.start.offset;
    for (var i = start; i < end; i++) {
      var code = input.charCodeAt(i);
      if (isLineTerminator(code))
        return null;
      if (code === 47) {
        code = input.charCodeAt(++i);
        if (code === 47)
          return null;
        i = input.indexOf('*/', i) + 2;
      }
    }
    return t;
  }
  function peekToken() {
    return token || (token = scanToken());
  }
  function peekTokenLookahead() {
    if (!token)
      token = scanToken();
    if (!lookaheadToken)
      lookaheadToken = scanToken();
    return lookaheadToken;
  }
  function skipWhitespace() {
    while (!isAtEnd() && peekWhitespace()) {
      next();
    }
  }
  function peekWhitespace() {
    return isWhitespace(currentCharCode);
  }
  function skipComments() {
    while (skipComment()) {}
  }
  function skipComment() {
    skipWhitespace();
    var code = currentCharCode;
    if (code === 47) {
      code = input.charCodeAt(index + 1);
      switch (code) {
        case 47:
          skipSingleLineComment();
          return true;
        case 42:
          skipMultiLineComment();
          return true;
      }
    }
    return false;
  }
  function commentCallback(start, index) {
    if (options.commentCallback)
      currentParser.handleComment(lineNumberTable.getSourceRange(start, index));
  }
  function skipSingleLineComment() {
    var start = index;
    index += 2;
    while (!isAtEnd() && !isLineTerminator(input.charCodeAt(index++))) {}
    updateCurrentCharCode();
    commentCallback(start, index);
  }
  function skipMultiLineComment() {
    var start = index;
    var i = input.indexOf('*/', index + 2);
    if (i !== -1)
      index = i + 2;
    else
      index = length;
    updateCurrentCharCode();
    commentCallback(start, index);
  }
  function scanToken() {
    skipComments();
    var beginIndex = index;
    if (isAtEnd())
      return createToken(END_OF_FILE, beginIndex);
    var code = currentCharCode;
    next();
    switch (code) {
      case 123:
        return createToken(OPEN_CURLY, beginIndex);
      case 125:
        return createToken(CLOSE_CURLY, beginIndex);
      case 40:
        return createToken(OPEN_PAREN, beginIndex);
      case 41:
        return createToken(CLOSE_PAREN, beginIndex);
      case 91:
        return createToken(OPEN_SQUARE, beginIndex);
      case 93:
        return createToken(CLOSE_SQUARE, beginIndex);
      case 46:
        switch (currentCharCode) {
          case 46:
            if (input.charCodeAt(index + 1) === 46) {
              next();
              next();
              return createToken(DOT_DOT_DOT, beginIndex);
            }
            break;
          default:
            if (isDecimalDigit(currentCharCode))
              return scanNumberPostPeriod(beginIndex);
        }
        return createToken(PERIOD, beginIndex);
      case 59:
        return createToken(SEMI_COLON, beginIndex);
      case 44:
        return createToken(COMMA, beginIndex);
      case 126:
        return createToken(TILDE, beginIndex);
      case 63:
        return createToken(QUESTION, beginIndex);
      case 58:
        return createToken(COLON, beginIndex);
      case 60:
        switch (currentCharCode) {
          case 60:
            next();
            if (currentCharCode === 61) {
              next();
              return createToken(LEFT_SHIFT_EQUAL, beginIndex);
            }
            return createToken(LEFT_SHIFT, beginIndex);
          case 61:
            next();
            return createToken(LESS_EQUAL, beginIndex);
          default:
            return createToken(OPEN_ANGLE, beginIndex);
        }
      case 62:
        switch (currentCharCode) {
          case 62:
            next();
            switch (currentCharCode) {
              case 61:
                next();
                return createToken(RIGHT_SHIFT_EQUAL, beginIndex);
              case 62:
                next();
                if (currentCharCode === 61) {
                  next();
                  return createToken(UNSIGNED_RIGHT_SHIFT_EQUAL, beginIndex);
                }
                return createToken(UNSIGNED_RIGHT_SHIFT, beginIndex);
              default:
                return createToken(RIGHT_SHIFT, beginIndex);
            }
          case 61:
            next();
            return createToken(GREATER_EQUAL, beginIndex);
          default:
            return createToken(CLOSE_ANGLE, beginIndex);
        }
      case 61:
        if (currentCharCode === 61) {
          next();
          if (currentCharCode === 61) {
            next();
            return createToken(EQUAL_EQUAL_EQUAL, beginIndex);
          }
          return createToken(EQUAL_EQUAL, beginIndex);
        }
        if (currentCharCode === 62 && options.arrowFunctions) {
          next();
          return createToken(ARROW, beginIndex);
        }
        return createToken(EQUAL, beginIndex);
      case 33:
        if (currentCharCode === 61) {
          next();
          if (currentCharCode === 61) {
            next();
            return createToken(NOT_EQUAL_EQUAL, beginIndex);
          }
          return createToken(NOT_EQUAL, beginIndex);
        }
        return createToken(BANG, beginIndex);
      case 42:
        if (currentCharCode === 61) {
          next();
          return createToken(STAR_EQUAL, beginIndex);
        }
        if (currentCharCode === 42 && options.exponentiation) {
          next();
          if (currentCharCode === 61) {
            next();
            return createToken(STAR_STAR_EQUAL, beginIndex);
          }
          return createToken(STAR_STAR, beginIndex);
        }
        return createToken(STAR, beginIndex);
      case 37:
        if (currentCharCode === 61) {
          next();
          return createToken(PERCENT_EQUAL, beginIndex);
        }
        return createToken(PERCENT, beginIndex);
      case 94:
        if (currentCharCode === 61) {
          next();
          return createToken(CARET_EQUAL, beginIndex);
        }
        return createToken(CARET, beginIndex);
      case 47:
        if (currentCharCode === 61) {
          next();
          return createToken(SLASH_EQUAL, beginIndex);
        }
        return createToken(SLASH, beginIndex);
      case 43:
        switch (currentCharCode) {
          case 43:
            next();
            return createToken(PLUS_PLUS, beginIndex);
          case 61:
            next();
            return createToken(PLUS_EQUAL, beginIndex);
          default:
            return createToken(PLUS, beginIndex);
        }
      case 45:
        switch (currentCharCode) {
          case 45:
            next();
            return createToken(MINUS_MINUS, beginIndex);
          case 61:
            next();
            return createToken(MINUS_EQUAL, beginIndex);
          default:
            return createToken(MINUS, beginIndex);
        }
      case 38:
        switch (currentCharCode) {
          case 38:
            next();
            return createToken(AND, beginIndex);
          case 61:
            next();
            return createToken(AMPERSAND_EQUAL, beginIndex);
          default:
            return createToken(AMPERSAND, beginIndex);
        }
      case 124:
        switch (currentCharCode) {
          case 124:
            next();
            return createToken(OR, beginIndex);
          case 61:
            next();
            return createToken(BAR_EQUAL, beginIndex);
          default:
            return createToken(BAR, beginIndex);
        }
      case 96:
        return scanTemplateStart(beginIndex);
      case 64:
        return createToken(AT, beginIndex);
      case 48:
        return scanPostZero(beginIndex);
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
        return scanPostDigit(beginIndex);
      case 34:
      case 39:
        return scanStringLiteral(beginIndex, code);
      default:
        return scanIdentifierOrKeyword(beginIndex, code);
    }
  }
  function scanNumberPostPeriod(beginIndex) {
    skipDecimalDigits();
    return scanExponentOfNumericLiteral(beginIndex);
  }
  function scanPostDigit(beginIndex) {
    skipDecimalDigits();
    return scanFractionalNumericLiteral(beginIndex);
  }
  function scanPostZero(beginIndex) {
    switch (currentCharCode) {
      case 46:
        return scanFractionalNumericLiteral(beginIndex);
      case 88:
      case 120:
        next();
        if (!isHexDigit(currentCharCode)) {
          reportError('Hex Integer Literal must contain at least one digit');
        }
        skipHexDigits();
        return new LiteralToken(NUMBER, getTokenString(beginIndex), getTokenRange(beginIndex));
      case 66:
      case 98:
        if (!options.numericLiterals)
          break;
        next();
        if (!isBinaryDigit(currentCharCode)) {
          reportError('Binary Integer Literal must contain at least one digit');
        }
        skipBinaryDigits();
        return new LiteralToken(NUMBER, getTokenString(beginIndex), getTokenRange(beginIndex));
      case 79:
      case 111:
        if (!options.numericLiterals)
          break;
        next();
        if (!isOctalDigit(currentCharCode)) {
          reportError('Octal Integer Literal must contain at least one digit');
        }
        skipOctalDigits();
        return new LiteralToken(NUMBER, getTokenString(beginIndex), getTokenRange(beginIndex));
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
        return scanPostDigit(beginIndex);
    }
    return new LiteralToken(NUMBER, getTokenString(beginIndex), getTokenRange(beginIndex));
  }
  function createToken(type, beginIndex) {
    return new Token(type, getTokenRange(beginIndex));
  }
  function readUnicodeEscapeSequence() {
    var beginIndex = index;
    if (currentCharCode === 117) {
      next();
      if (skipHexDigit() && skipHexDigit() && skipHexDigit() && skipHexDigit()) {
        return parseInt(getTokenString(beginIndex + 1), 16);
      }
    }
    reportError('Invalid unicode escape sequence in identifier', beginIndex - 1);
    return 0;
  }
  function scanIdentifierOrKeyword(beginIndex, code) {
    var escapedCharCodes;
    if (code === 92) {
      code = readUnicodeEscapeSequence();
      escapedCharCodes = [code];
    }
    if (!isIdentifierStart(code)) {
      reportError(("Character code '" + code + "' is not a valid identifier start char"), beginIndex);
      return createToken(ERROR, beginIndex);
    }
    for (; ; ) {
      code = currentCharCode;
      if (isIdentifierPart(code)) {
        next();
      } else if (code === 92) {
        next();
        code = readUnicodeEscapeSequence();
        if (!escapedCharCodes)
          escapedCharCodes = [];
        escapedCharCodes.push(code);
        if (!isIdentifierPart(code))
          return createToken(ERROR, beginIndex);
      } else {
        break;
      }
    }
    var value = input.slice(beginIndex, index);
    var keywordType = getKeywordType(value);
    if (keywordType)
      return new KeywordToken(value, keywordType, getTokenRange(beginIndex));
    if (escapedCharCodes) {
      var i = 0;
      value = value.replace(/\\u..../g, function(s) {
        return String.fromCharCode(escapedCharCodes[i++]);
      });
    }
    return new IdentifierToken(getTokenRange(beginIndex), value);
  }
  function scanStringLiteral(beginIndex, terminator) {
    while (peekStringLiteralChar(terminator)) {
      if (!skipStringLiteralChar()) {
        return new LiteralToken(STRING, getTokenString(beginIndex), getTokenRange(beginIndex));
      }
    }
    if (currentCharCode !== terminator) {
      reportError('Unterminated String Literal', beginIndex);
    } else {
      next();
    }
    return new LiteralToken(STRING, getTokenString(beginIndex), getTokenRange(beginIndex));
  }
  function getTokenString(beginIndex) {
    return input.substring(beginIndex, index);
  }
  function peekStringLiteralChar(terminator) {
    return !isAtEnd() && currentCharCode !== terminator && !isLineTerminator(currentCharCode);
  }
  function skipStringLiteralChar() {
    if (currentCharCode === 92) {
      return skipStringLiteralEscapeSequence();
    }
    next();
    return true;
  }
  function skipStringLiteralEscapeSequence() {
    next();
    if (isAtEnd()) {
      reportError('Unterminated string literal escape sequence');
      return false;
    }
    if (isLineTerminator(currentCharCode)) {
      skipLineTerminator();
      return true;
    }
    var code = currentCharCode;
    next();
    switch (code) {
      case 39:
      case 34:
      case 92:
      case 98:
      case 102:
      case 110:
      case 114:
      case 116:
      case 118:
      case 48:
        return true;
      case 120:
        return skipHexDigit() && skipHexDigit();
      case 117:
        return skipUnicodeEscapeSequence();
      default:
        return true;
    }
  }
  function skipUnicodeEscapeSequence() {
    if (currentCharCode === 123 && options.unicodeEscapeSequences) {
      next();
      var beginIndex = index;
      if (!isHexDigit(currentCharCode)) {
        reportError('Hex digit expected');
        return false;
      }
      skipHexDigits();
      if (currentCharCode !== 125) {
        reportError('Hex digit expected');
        return false;
      }
      var codePoint = getTokenString(beginIndex, index);
      if (parseInt(codePoint, 16) > 0x10FFFF) {
        reportError('The code point in a Unicode escape sequence cannot exceed 10FFFF');
        return false;
      }
      next();
      return true;
    }
    return skipHexDigit() && skipHexDigit() && skipHexDigit() && skipHexDigit();
  }
  function skipHexDigit() {
    if (!isHexDigit(currentCharCode)) {
      reportError('Hex digit expected');
      return false;
    }
    next();
    return true;
  }
  function skipLineTerminator() {
    var first = currentCharCode;
    next();
    if (first === 13 && currentCharCode === 10) {
      next();
    }
  }
  function scanFractionalNumericLiteral(beginIndex) {
    if (currentCharCode === 46) {
      next();
      skipDecimalDigits();
    }
    return scanExponentOfNumericLiteral(beginIndex);
  }
  function scanExponentOfNumericLiteral(beginIndex) {
    switch (currentCharCode) {
      case 101:
      case 69:
        next();
        switch (currentCharCode) {
          case 43:
          case 45:
            next();
            break;
        }
        if (!isDecimalDigit(currentCharCode)) {
          reportError('Exponent part must contain at least one digit');
        }
        skipDecimalDigits();
        break;
      default:
        break;
    }
    return new LiteralToken(NUMBER, getTokenString(beginIndex), getTokenRange(beginIndex));
  }
  function skipDecimalDigits() {
    while (isDecimalDigit(currentCharCode)) {
      next();
    }
  }
  function skipHexDigits() {
    while (isHexDigit(currentCharCode)) {
      next();
    }
  }
  function skipBinaryDigits() {
    while (isBinaryDigit(currentCharCode)) {
      next();
    }
  }
  function skipOctalDigits() {
    while (isOctalDigit(currentCharCode)) {
      next();
    }
  }
  function isAtEnd() {
    return index === length;
  }
  function next() {
    index++;
    updateCurrentCharCode();
  }
  function updateCurrentCharCode() {
    currentCharCode = input.charCodeAt(index);
  }
  function reportError(message) {
    var indexArg = arguments[1] !== (void 0) ? arguments[1] : index;
    var position = getPosition(indexArg);
    errorReporter.reportError(position, message);
  }
  return {
    get isWhitespace() {
      return isWhitespace;
    },
    get isLineTerminator() {
      return isLineTerminator;
    },
    get isIdentifierPart() {
      return isIdentifierPart;
    },
    get Scanner() {
      return Scanner;
    }
  };
});
System.registerModule("traceur@0.0.80/src/syntax/Parser.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/Parser.js";
  var FindVisitor = System.get("traceur@0.0.80/src/codegeneration/FindVisitor.js").FindVisitor;
  var IdentifierToken = System.get("traceur@0.0.80/src/syntax/IdentifierToken.js").IdentifierToken;
  var $__2 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      ARRAY_LITERAL_EXPRESSION = $__2.ARRAY_LITERAL_EXPRESSION,
      BINDING_IDENTIFIER = $__2.BINDING_IDENTIFIER,
      CALL_EXPRESSION = $__2.CALL_EXPRESSION,
      COMPUTED_PROPERTY_NAME = $__2.COMPUTED_PROPERTY_NAME,
      COVER_FORMALS = $__2.COVER_FORMALS,
      FORMAL_PARAMETER_LIST = $__2.FORMAL_PARAMETER_LIST,
      IDENTIFIER_EXPRESSION = $__2.IDENTIFIER_EXPRESSION,
      LITERAL_PROPERTY_NAME = $__2.LITERAL_PROPERTY_NAME,
      OBJECT_LITERAL_EXPRESSION = $__2.OBJECT_LITERAL_EXPRESSION,
      REST_PARAMETER = $__2.REST_PARAMETER,
      SYNTAX_ERROR_TREE = $__2.SYNTAX_ERROR_TREE;
  var $__3 = System.get("traceur@0.0.80/src/syntax/PredefinedName.js"),
      AS = $__3.AS,
      ASYNC = $__3.ASYNC,
      AWAIT = $__3.AWAIT,
      FROM = $__3.FROM,
      GET = $__3.GET,
      OF = $__3.OF,
      SET = $__3.SET;
  var SyntaxErrorReporter = System.get("traceur@0.0.80/src/util/SyntaxErrorReporter.js").SyntaxErrorReporter;
  var Scanner = System.get("traceur@0.0.80/src/syntax/Scanner.js").Scanner;
  var SourceRange = System.get("traceur@0.0.80/src/util/SourceRange.js").SourceRange;
  var StrictParams = System.get("traceur@0.0.80/src/staticsemantics/StrictParams.js").StrictParams;
  var $__8 = System.get("traceur@0.0.80/src/syntax/Token.js"),
      Token = $__8.Token,
      isAssignmentOperator = $__8.isAssignmentOperator;
  var getKeywordType = System.get("traceur@0.0.80/src/syntax/Keywords.js").getKeywordType;
  var traceurOptions = System.get("traceur@0.0.80/src/Options.js").options;
  var $__11 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      AMPERSAND = $__11.AMPERSAND,
      AND = $__11.AND,
      ARROW = $__11.ARROW,
      AT = $__11.AT,
      BANG = $__11.BANG,
      BAR = $__11.BAR,
      BREAK = $__11.BREAK,
      CARET = $__11.CARET,
      CASE = $__11.CASE,
      CATCH = $__11.CATCH,
      CLASS = $__11.CLASS,
      CLOSE_ANGLE = $__11.CLOSE_ANGLE,
      CLOSE_CURLY = $__11.CLOSE_CURLY,
      CLOSE_PAREN = $__11.CLOSE_PAREN,
      CLOSE_SQUARE = $__11.CLOSE_SQUARE,
      COLON = $__11.COLON,
      COMMA = $__11.COMMA,
      CONST = $__11.CONST,
      CONTINUE = $__11.CONTINUE,
      DEBUGGER = $__11.DEBUGGER,
      DEFAULT = $__11.DEFAULT,
      DELETE = $__11.DELETE,
      DO = $__11.DO,
      DOT_DOT_DOT = $__11.DOT_DOT_DOT,
      ELSE = $__11.ELSE,
      END_OF_FILE = $__11.END_OF_FILE,
      EQUAL = $__11.EQUAL,
      EQUAL_EQUAL = $__11.EQUAL_EQUAL,
      EQUAL_EQUAL_EQUAL = $__11.EQUAL_EQUAL_EQUAL,
      ERROR = $__11.ERROR,
      EXPORT = $__11.EXPORT,
      EXTENDS = $__11.EXTENDS,
      FALSE = $__11.FALSE,
      FINALLY = $__11.FINALLY,
      FOR = $__11.FOR,
      FUNCTION = $__11.FUNCTION,
      GREATER_EQUAL = $__11.GREATER_EQUAL,
      IDENTIFIER = $__11.IDENTIFIER,
      IF = $__11.IF,
      IMPLEMENTS = $__11.IMPLEMENTS,
      IMPORT = $__11.IMPORT,
      IN = $__11.IN,
      INSTANCEOF = $__11.INSTANCEOF,
      INTERFACE = $__11.INTERFACE,
      LEFT_SHIFT = $__11.LEFT_SHIFT,
      LESS_EQUAL = $__11.LESS_EQUAL,
      LET = $__11.LET,
      MINUS = $__11.MINUS,
      MINUS_MINUS = $__11.MINUS_MINUS,
      NEW = $__11.NEW,
      NO_SUBSTITUTION_TEMPLATE = $__11.NO_SUBSTITUTION_TEMPLATE,
      NOT_EQUAL = $__11.NOT_EQUAL,
      NOT_EQUAL_EQUAL = $__11.NOT_EQUAL_EQUAL,
      NULL = $__11.NULL,
      NUMBER = $__11.NUMBER,
      OPEN_ANGLE = $__11.OPEN_ANGLE,
      OPEN_CURLY = $__11.OPEN_CURLY,
      OPEN_PAREN = $__11.OPEN_PAREN,
      OPEN_SQUARE = $__11.OPEN_SQUARE,
      OR = $__11.OR,
      PACKAGE = $__11.PACKAGE,
      PERCENT = $__11.PERCENT,
      PERIOD = $__11.PERIOD,
      PLUS = $__11.PLUS,
      PLUS_PLUS = $__11.PLUS_PLUS,
      PRIVATE = $__11.PRIVATE,
      PROTECTED = $__11.PROTECTED,
      PUBLIC = $__11.PUBLIC,
      QUESTION = $__11.QUESTION,
      RETURN = $__11.RETURN,
      RIGHT_SHIFT = $__11.RIGHT_SHIFT,
      SEMI_COLON = $__11.SEMI_COLON,
      SLASH = $__11.SLASH,
      SLASH_EQUAL = $__11.SLASH_EQUAL,
      STAR = $__11.STAR,
      STAR_STAR = $__11.STAR_STAR,
      STATIC = $__11.STATIC,
      STRING = $__11.STRING,
      SUPER = $__11.SUPER,
      SWITCH = $__11.SWITCH,
      TEMPLATE_HEAD = $__11.TEMPLATE_HEAD,
      TEMPLATE_TAIL = $__11.TEMPLATE_TAIL,
      THIS = $__11.THIS,
      THROW = $__11.THROW,
      TILDE = $__11.TILDE,
      TRUE = $__11.TRUE,
      TRY = $__11.TRY,
      TYPEOF = $__11.TYPEOF,
      UNSIGNED_RIGHT_SHIFT = $__11.UNSIGNED_RIGHT_SHIFT,
      VAR = $__11.VAR,
      VOID = $__11.VOID,
      WHILE = $__11.WHILE,
      WITH = $__11.WITH,
      YIELD = $__11.YIELD;
  var $__12 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      ArgumentList = $__12.ArgumentList,
      ArrayComprehension = $__12.ArrayComprehension,
      ArrayLiteralExpression = $__12.ArrayLiteralExpression,
      ArrayPattern = $__12.ArrayPattern,
      ArrayType = $__12.ArrayType,
      ArrowFunctionExpression = $__12.ArrowFunctionExpression,
      AssignmentElement = $__12.AssignmentElement,
      AwaitExpression = $__12.AwaitExpression,
      BinaryExpression = $__12.BinaryExpression,
      BindingElement = $__12.BindingElement,
      BindingIdentifier = $__12.BindingIdentifier,
      Block = $__12.Block,
      BreakStatement = $__12.BreakStatement,
      CallExpression = $__12.CallExpression,
      CallSignature = $__12.CallSignature,
      CaseClause = $__12.CaseClause,
      Catch = $__12.Catch,
      ClassDeclaration = $__12.ClassDeclaration,
      ClassExpression = $__12.ClassExpression,
      CommaExpression = $__12.CommaExpression,
      ComprehensionFor = $__12.ComprehensionFor,
      ComprehensionIf = $__12.ComprehensionIf,
      ComputedPropertyName = $__12.ComputedPropertyName,
      ConditionalExpression = $__12.ConditionalExpression,
      ConstructSignature = $__12.ConstructSignature,
      ConstructorType = $__12.ConstructorType,
      ContinueStatement = $__12.ContinueStatement,
      CoverFormals = $__12.CoverFormals,
      CoverInitializedName = $__12.CoverInitializedName,
      DebuggerStatement = $__12.DebuggerStatement,
      Annotation = $__12.Annotation,
      DefaultClause = $__12.DefaultClause,
      DoWhileStatement = $__12.DoWhileStatement,
      EmptyStatement = $__12.EmptyStatement,
      ExportDeclaration = $__12.ExportDeclaration,
      ExportDefault = $__12.ExportDefault,
      ExportSpecifier = $__12.ExportSpecifier,
      ExportSpecifierSet = $__12.ExportSpecifierSet,
      ExportStar = $__12.ExportStar,
      ExpressionStatement = $__12.ExpressionStatement,
      Finally = $__12.Finally,
      ForInStatement = $__12.ForInStatement,
      ForOfStatement = $__12.ForOfStatement,
      ForStatement = $__12.ForStatement,
      FormalParameter = $__12.FormalParameter,
      FormalParameterList = $__12.FormalParameterList,
      FunctionBody = $__12.FunctionBody,
      FunctionDeclaration = $__12.FunctionDeclaration,
      FunctionExpression = $__12.FunctionExpression,
      FunctionType = $__12.FunctionType,
      GeneratorComprehension = $__12.GeneratorComprehension,
      GetAccessor = $__12.GetAccessor,
      IdentifierExpression = $__12.IdentifierExpression,
      IfStatement = $__12.IfStatement,
      ImportDeclaration = $__12.ImportDeclaration,
      ImportSpecifier = $__12.ImportSpecifier,
      ImportSpecifierSet = $__12.ImportSpecifierSet,
      ImportedBinding = $__12.ImportedBinding,
      IndexSignature = $__12.IndexSignature,
      InterfaceDeclaration = $__12.InterfaceDeclaration,
      LabelledStatement = $__12.LabelledStatement,
      LiteralExpression = $__12.LiteralExpression,
      LiteralPropertyName = $__12.LiteralPropertyName,
      MemberExpression = $__12.MemberExpression,
      MemberLookupExpression = $__12.MemberLookupExpression,
      MethodSignature = $__12.MethodSignature,
      Module = $__12.Module,
      ModuleDeclaration = $__12.ModuleDeclaration,
      ModuleSpecifier = $__12.ModuleSpecifier,
      NamedExport = $__12.NamedExport,
      NewExpression = $__12.NewExpression,
      ObjectLiteralExpression = $__12.ObjectLiteralExpression,
      ObjectPattern = $__12.ObjectPattern,
      ObjectPatternField = $__12.ObjectPatternField,
      ObjectType = $__12.ObjectType,
      ParenExpression = $__12.ParenExpression,
      PostfixExpression = $__12.PostfixExpression,
      PredefinedType = $__12.PredefinedType,
      PropertyMethodAssignment = $__12.PropertyMethodAssignment,
      PropertyNameAssignment = $__12.PropertyNameAssignment,
      PropertyNameShorthand = $__12.PropertyNameShorthand,
      PropertySignature = $__12.PropertySignature,
      PropertyVariableDeclaration = $__12.PropertyVariableDeclaration,
      RestParameter = $__12.RestParameter,
      ReturnStatement = $__12.ReturnStatement,
      Script = $__12.Script,
      SetAccessor = $__12.SetAccessor,
      SpreadExpression = $__12.SpreadExpression,
      SpreadPatternElement = $__12.SpreadPatternElement,
      SuperExpression = $__12.SuperExpression,
      SwitchStatement = $__12.SwitchStatement,
      SyntaxErrorTree = $__12.SyntaxErrorTree,
      TemplateLiteralExpression = $__12.TemplateLiteralExpression,
      TemplateLiteralPortion = $__12.TemplateLiteralPortion,
      TemplateSubstitution = $__12.TemplateSubstitution,
      ThisExpression = $__12.ThisExpression,
      ThrowStatement = $__12.ThrowStatement,
      TryStatement = $__12.TryStatement,
      TypeArguments = $__12.TypeArguments,
      TypeName = $__12.TypeName,
      TypeParameter = $__12.TypeParameter,
      TypeParameters = $__12.TypeParameters,
      TypeReference = $__12.TypeReference,
      UnaryExpression = $__12.UnaryExpression,
      UnionType = $__12.UnionType,
      VariableDeclaration = $__12.VariableDeclaration,
      VariableDeclarationList = $__12.VariableDeclarationList,
      VariableStatement = $__12.VariableStatement,
      WhileStatement = $__12.WhileStatement,
      WithStatement = $__12.WithStatement,
      YieldExpression = $__12.YieldExpression;
  var Expression = {
    NO_IN: 'NO_IN',
    NORMAL: 'NORMAL'
  };
  var DestructuringInitializer = {
    REQUIRED: 'REQUIRED',
    OPTIONAL: 'OPTIONAL'
  };
  var Initializer = {
    ALLOWED: 'ALLOWED',
    REQUIRED: 'REQUIRED'
  };
  var ValidateObjectLiteral = function ValidateObjectLiteral() {
    $traceurRuntime.superConstructor($ValidateObjectLiteral).call(this);
    this.errorToken = null;
  };
  var $ValidateObjectLiteral = ValidateObjectLiteral;
  ($traceurRuntime.createClass)(ValidateObjectLiteral, {visitCoverInitializedName: function(tree) {
      this.errorToken = tree.equalToken;
      this.found = true;
    }}, {}, FindVisitor);
  function containsInitializer(declarations) {
    return declarations.some((function(v) {
      return v.initializer;
    }));
  }
  var Parser = function Parser(file) {
    var errorReporter = arguments[1] !== (void 0) ? arguments[1] : new SyntaxErrorReporter();
    var options = arguments[2] !== (void 0) ? arguments[2] : traceurOptions;
    this.errorReporter_ = errorReporter;
    this.scanner_ = new Scanner(errorReporter, file, this, options);
    this.options_ = options;
    this.allowYield = false;
    this.allowAwait = false;
    this.coverInitializedNameCount_ = 0;
    this.strictMode_ = false;
    this.annotations_ = [];
  };
  ($traceurRuntime.createClass)(Parser, {
    parseScript: function() {
      this.strictMode_ = false;
      var start = this.getTreeStartLocation_();
      var scriptItemList = this.parseStatementList_(true);
      this.eat_(END_OF_FILE);
      return new Script(this.getTreeLocation_(start), scriptItemList);
    },
    parseStatementList_: function(checkUseStrictDirective) {
      var result = [];
      var type;
      while ((type = this.peekType_()) !== CLOSE_CURLY && type !== END_OF_FILE) {
        var statement = this.parseStatementListItem_(type);
        if (checkUseStrictDirective) {
          if (!statement.isDirectivePrologue()) {
            checkUseStrictDirective = false;
          } else if (statement.isUseStrictDirective()) {
            this.strictMode_ = true;
            checkUseStrictDirective = false;
          }
        }
        result.push(statement);
      }
      return result;
    },
    parseStatementListItem_: function(type) {
      return this.parseStatementWithType_(type);
    },
    parseModule: function() {
      var start = this.getTreeStartLocation_();
      var scriptItemList = this.parseModuleItemList_();
      this.eat_(END_OF_FILE);
      return new Module(this.getTreeLocation_(start), scriptItemList, null);
    },
    parseModuleItemList_: function() {
      this.strictMode_ = true;
      var result = [];
      var type;
      while ((type = this.peekType_()) !== END_OF_FILE) {
        var statement = this.parseModuleItem_(type);
        result.push(statement);
      }
      return result;
    },
    parseModuleItem_: function(type) {
      switch (type) {
        case IMPORT:
          return this.parseImportDeclaration_();
        case EXPORT:
          return this.parseExportDeclaration_();
        case AT:
          if (this.options_.annotations)
            return this.parseAnnotatedDeclarations_(true);
          break;
      }
      return this.parseStatementListItem_(type);
    },
    parseModuleSpecifier_: function() {
      var start = this.getTreeStartLocation_();
      var token = this.eat_(STRING);
      return new ModuleSpecifier(this.getTreeLocation_(start), token);
    },
    parseImportDeclaration_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(IMPORT);
      if (this.peek_(STAR)) {
        this.eat_(STAR);
        this.eatId_(AS);
        var binding = this.parseImportedBinding_();
        this.eatId_(FROM);
        var moduleSpecifier = this.parseModuleSpecifier_();
        this.eatPossibleImplicitSemiColon_();
        return new ModuleDeclaration(this.getTreeLocation_(start), binding, moduleSpecifier);
      }
      var importClause = null;
      if (this.peekImportClause_(this.peekType_())) {
        importClause = this.parseImportClause_();
        this.eatId_(FROM);
      }
      var moduleSpecifier = this.parseModuleSpecifier_();
      this.eatPossibleImplicitSemiColon_();
      return new ImportDeclaration(this.getTreeLocation_(start), importClause, moduleSpecifier);
    },
    peekImportClause_: function(type) {
      return type === OPEN_CURLY || this.peekBindingIdentifier_(type);
    },
    parseImportClause_: function() {
      var start = this.getTreeStartLocation_();
      if (this.eatIf_(OPEN_CURLY)) {
        var specifiers = [];
        while (!this.peek_(CLOSE_CURLY) && !this.isAtEnd()) {
          specifiers.push(this.parseImportSpecifier_());
          if (!this.eatIf_(COMMA))
            break;
        }
        this.eat_(CLOSE_CURLY);
        return new ImportSpecifierSet(this.getTreeLocation_(start), specifiers);
      }
      return this.parseImportedBinding_();
    },
    parseImportedBinding_: function() {
      var start = this.getTreeStartLocation_();
      var binding = this.parseBindingIdentifier_();
      return new ImportedBinding(this.getTreeLocation_(start), binding);
    },
    parseImportSpecifier_: function() {
      var start = this.getTreeStartLocation_();
      var token = this.peekToken_();
      var isKeyword = token.isKeyword();
      var binding;
      var name = this.eatIdName_();
      if (isKeyword || this.peekPredefinedString_(AS)) {
        this.eatId_(AS);
        binding = this.parseImportedBinding_();
      } else {
        binding = new ImportedBinding(name.location, new BindingIdentifier(name.location, name));
        name = null;
      }
      return new ImportSpecifier(this.getTreeLocation_(start), binding, name);
    },
    parseExportDeclaration_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(EXPORT);
      var exportTree;
      var annotations = this.popAnnotations_();
      var type = this.peekType_();
      switch (type) {
        case CONST:
        case LET:
        case VAR:
          exportTree = this.parseVariableStatement_();
          break;
        case FUNCTION:
          exportTree = this.parseFunctionDeclaration_();
          break;
        case CLASS:
          exportTree = this.parseClassDeclaration_();
          break;
        case DEFAULT:
          exportTree = this.parseExportDefault_();
          break;
        case OPEN_CURLY:
        case STAR:
          exportTree = this.parseNamedExport_();
          break;
        case IDENTIFIER:
          if (this.options_.asyncFunctions && this.peekPredefinedString_(ASYNC)) {
            var asyncToken = this.eatId_();
            exportTree = this.parseAsyncFunctionDeclaration_(asyncToken);
            break;
          }
        default:
          return this.parseUnexpectedToken_(type);
      }
      return new ExportDeclaration(this.getTreeLocation_(start), exportTree, annotations);
    },
    parseExportDefault_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(DEFAULT);
      var exportValue;
      switch (this.peekType_()) {
        case FUNCTION:
          var tree = this.parseFunctionExpression_();
          if (tree.name) {
            tree = new FunctionDeclaration(tree.location, tree.name, tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
          }
          exportValue = tree;
          break;
        case CLASS:
          if (this.options_.classes) {
            var tree = this.parseClassExpression_();
            if (tree.name) {
              tree = new ClassDeclaration(tree.location, tree.name, tree.superClass, tree.elements, tree.annotations);
            }
            exportValue = tree;
            break;
          }
        default:
          exportValue = this.parseAssignmentExpression();
          this.eatPossibleImplicitSemiColon_();
      }
      return new ExportDefault(this.getTreeLocation_(start), exportValue);
    },
    parseNamedExport_: function() {
      var start = this.getTreeStartLocation_();
      var specifierSet,
          expression = null;
      if (this.peek_(OPEN_CURLY)) {
        specifierSet = this.parseExportSpecifierSet_();
        if (this.peekPredefinedString_(FROM)) {
          this.eatId_(FROM);
          expression = this.parseModuleSpecifier_();
        } else {
          this.validateExportSpecifierSet_(specifierSet);
        }
      } else {
        this.eat_(STAR);
        specifierSet = new ExportStar(this.getTreeLocation_(start));
        this.eatId_(FROM);
        expression = this.parseModuleSpecifier_();
      }
      this.eatPossibleImplicitSemiColon_();
      return new NamedExport(this.getTreeLocation_(start), expression, specifierSet);
    },
    parseExportSpecifierSet_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(OPEN_CURLY);
      var specifiers = [this.parseExportSpecifier_()];
      while (this.eatIf_(COMMA)) {
        if (this.peek_(CLOSE_CURLY))
          break;
        specifiers.push(this.parseExportSpecifier_());
      }
      this.eat_(CLOSE_CURLY);
      return new ExportSpecifierSet(this.getTreeLocation_(start), specifiers);
    },
    parseExportSpecifier_: function() {
      var start = this.getTreeStartLocation_();
      var lhs = this.eatIdName_();
      var rhs = null;
      if (this.peekPredefinedString_(AS)) {
        this.eatId_();
        rhs = this.eatIdName_();
      }
      return new ExportSpecifier(this.getTreeLocation_(start), lhs, rhs);
    },
    validateExportSpecifierSet_: function(tree) {
      for (var i = 0; i < tree.specifiers.length; i++) {
        var specifier = tree.specifiers[i];
        if (getKeywordType(specifier.lhs.value)) {
          this.reportError_(specifier.lhs.location, ("Unexpected token " + specifier.lhs.value));
        }
      }
    },
    peekId_: function(type) {
      if (type === IDENTIFIER)
        return true;
      if (this.strictMode_)
        return false;
      return this.peekToken_().isStrictKeyword();
    },
    peekIdName_: function(token) {
      return token.type === IDENTIFIER || token.isKeyword();
    },
    parseClassShared_: function(constr) {
      var start = this.getTreeStartLocation_();
      var strictMode = this.strictMode_;
      this.strictMode_ = true;
      this.eat_(CLASS);
      var name = null;
      var typeParameters = null;
      var annotations = [];
      if (constr == ClassDeclaration || !this.peek_(EXTENDS) && !this.peek_(OPEN_CURLY)) {
        name = this.parseBindingIdentifier_();
        if (this.options_.types) {
          typeParameters = this.parseTypeParametersOpt_();
        }
        annotations = this.popAnnotations_();
      }
      var superClass = null;
      if (this.eatIf_(EXTENDS)) {
        superClass = this.parseLeftHandSideExpression_();
      }
      this.eat_(OPEN_CURLY);
      var elements = this.parseClassElements_();
      this.eat_(CLOSE_CURLY);
      this.strictMode_ = strictMode;
      return new constr(this.getTreeLocation_(start), name, superClass, elements, annotations, typeParameters);
    },
    parseClassDeclaration_: function() {
      return this.parseClassShared_(ClassDeclaration);
    },
    parseClassExpression_: function() {
      return this.parseClassShared_(ClassExpression);
    },
    parseClassElements_: function() {
      var result = [];
      while (true) {
        var type = this.peekType_();
        if (type === SEMI_COLON) {
          this.nextToken_();
        } else if (this.peekClassElement_(this.peekType_())) {
          result.push(this.parseClassElement_());
        } else {
          break;
        }
      }
      return result;
    },
    peekClassElement_: function(type) {
      return this.peekPropertyName_(type) || type === STAR && this.options_.generators || type === AT && this.options_.annotations;
    },
    parsePropertyName_: function() {
      if (this.peek_(OPEN_SQUARE))
        return this.parseComputedPropertyName_();
      return this.parseLiteralPropertyName_();
    },
    parseLiteralPropertyName_: function() {
      var start = this.getTreeStartLocation_();
      var token = this.nextToken_();
      return new LiteralPropertyName(this.getTreeLocation_(start), token);
    },
    parseComputedPropertyName_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(OPEN_SQUARE);
      var expression = this.parseAssignmentExpression();
      this.eat_(CLOSE_SQUARE);
      return new ComputedPropertyName(this.getTreeLocation_(start), expression);
    },
    parseStatement: function() {
      return this.parseModuleItem_(this.peekType_());
    },
    parseStatements: function() {
      return this.parseModuleItemList_();
    },
    parseStatement_: function() {
      return this.parseStatementWithType_(this.peekType_());
    },
    parseStatementWithType_: function(type) {
      switch (type) {
        case RETURN:
          return this.parseReturnStatement_();
        case CONST:
        case LET:
          if (!this.options_.blockBinding)
            break;
        case VAR:
          return this.parseVariableStatement_();
        case IF:
          return this.parseIfStatement_();
        case FOR:
          return this.parseForStatement_();
        case BREAK:
          return this.parseBreakStatement_();
        case SWITCH:
          return this.parseSwitchStatement_();
        case THROW:
          return this.parseThrowStatement_();
        case WHILE:
          return this.parseWhileStatement_();
        case FUNCTION:
          return this.parseFunctionDeclaration_();
        case AT:
          if (this.options_.annotations)
            return this.parseAnnotatedDeclarations_(false);
          break;
        case CLASS:
          if (this.options_.classes)
            return this.parseClassDeclaration_();
          break;
        case CONTINUE:
          return this.parseContinueStatement_();
        case DEBUGGER:
          return this.parseDebuggerStatement_();
        case DO:
          return this.parseDoWhileStatement_();
        case OPEN_CURLY:
          return this.parseBlock_();
        case SEMI_COLON:
          return this.parseEmptyStatement_();
        case TRY:
          return this.parseTryStatement_();
        case WITH:
          return this.parseWithStatement_();
        case INTERFACE:
          if (this.options_.types) {
            return this.parseInterfaceDeclaration_();
          }
      }
      return this.parseFallThroughStatement_();
    },
    parseFunctionDeclaration_: function() {
      return this.parseFunction_(FunctionDeclaration);
    },
    parseFunctionExpression_: function() {
      return this.parseFunction_(FunctionExpression);
    },
    parseAsyncFunctionDeclaration_: function(asyncToken) {
      return this.parseAsyncFunction_(asyncToken, FunctionDeclaration);
    },
    parseAsyncFunctionExpression_: function(asyncToken) {
      return this.parseAsyncFunction_(asyncToken, FunctionExpression);
    },
    parseAsyncFunction_: function(asyncToken, ctor) {
      var start = asyncToken.location.start;
      this.eat_(FUNCTION);
      return this.parseFunction2_(start, asyncToken, ctor);
    },
    parseFunction_: function(ctor) {
      var start = this.getTreeStartLocation_();
      this.eat_(FUNCTION);
      var functionKind = null;
      if (this.options_.generators && this.peek_(STAR))
        functionKind = this.eat_(STAR);
      return this.parseFunction2_(start, functionKind, ctor);
    },
    parseFunction2_: function(start, functionKind, ctor) {
      var name = null;
      var annotations = [];
      if (ctor === FunctionDeclaration || this.peekBindingIdentifier_(this.peekType_())) {
        name = this.parseBindingIdentifier_();
        annotations = this.popAnnotations_();
      }
      this.eat_(OPEN_PAREN);
      var parameters = this.parseFormalParameters_();
      this.eat_(CLOSE_PAREN);
      var typeAnnotation = this.parseTypeAnnotationOpt_();
      var body = this.parseFunctionBody_(functionKind, parameters);
      return new ctor(this.getTreeLocation_(start), name, functionKind, parameters, typeAnnotation, annotations, body);
    },
    peekRest_: function(type) {
      return type === DOT_DOT_DOT && this.options_.restParameters;
    },
    parseFormalParameters_: function() {
      var start = this.getTreeStartLocation_();
      var formals = [];
      this.pushAnnotations_();
      var type = this.peekType_();
      if (this.peekRest_(type)) {
        formals.push(this.parseFormalRestParameter_());
      } else {
        if (this.peekFormalParameter_(this.peekType_()))
          formals.push(this.parseFormalParameter_());
        while (this.eatIf_(COMMA)) {
          this.pushAnnotations_();
          if (this.peekRest_(this.peekType_())) {
            formals.push(this.parseFormalRestParameter_());
            break;
          }
          formals.push(this.parseFormalParameter_());
        }
      }
      return new FormalParameterList(this.getTreeLocation_(start), formals);
    },
    peekFormalParameter_: function(type) {
      return this.peekBindingElement_(type);
    },
    parseFormalParameter_: function() {
      var initializerAllowed = arguments[0];
      var start = this.getTreeStartLocation_();
      var binding = this.parseBindingElementBinding_();
      var typeAnnotation = this.parseTypeAnnotationOpt_();
      var initializer = this.parseBindingElementInitializer_(initializerAllowed);
      return new FormalParameter(this.getTreeLocation_(start), new BindingElement(this.getTreeLocation_(start), binding, initializer), typeAnnotation, this.popAnnotations_());
    },
    parseFormalRestParameter_: function() {
      var start = this.getTreeStartLocation_();
      var restParameter = this.parseRestParameter_();
      var typeAnnotation = this.parseTypeAnnotationOpt_();
      return new FormalParameter(this.getTreeLocation_(start), restParameter, typeAnnotation, this.popAnnotations_());
    },
    parseRestParameter_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(DOT_DOT_DOT);
      var id = this.parseBindingIdentifier_();
      var typeAnnotation = this.parseTypeAnnotationOpt_();
      return new RestParameter(this.getTreeLocation_(start), id, typeAnnotation);
    },
    parseFunctionBody_: function(functionKind, params) {
      var start = this.getTreeStartLocation_();
      this.eat_(OPEN_CURLY);
      var allowYield = this.allowYield;
      var allowAwait = this.allowAwait;
      var strictMode = this.strictMode_;
      this.allowYield = functionKind && functionKind.type === STAR;
      this.allowAwait = functionKind && functionKind.type === IDENTIFIER && functionKind.value === ASYNC;
      var result = this.parseStatementList_(!strictMode);
      if (!strictMode && this.strictMode_ && params)
        StrictParams.visit(params, this.errorReporter_);
      this.strictMode_ = strictMode;
      this.allowYield = allowYield;
      this.allowAwait = allowAwait;
      this.eat_(CLOSE_CURLY);
      return new FunctionBody(this.getTreeLocation_(start), result);
    },
    parseSpreadExpression_: function() {
      if (!this.options_.spread)
        return this.parseUnexpectedToken_(DOT_DOT_DOT);
      var start = this.getTreeStartLocation_();
      this.eat_(DOT_DOT_DOT);
      var operand = this.parseAssignmentExpression();
      return new SpreadExpression(this.getTreeLocation_(start), operand);
    },
    parseBlock_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(OPEN_CURLY);
      var result = this.parseStatementList_(false);
      this.eat_(CLOSE_CURLY);
      return new Block(this.getTreeLocation_(start), result);
    },
    parseVariableStatement_: function() {
      var start = this.getTreeStartLocation_();
      var declarations = this.parseVariableDeclarationList_();
      this.checkInitializers_(declarations);
      this.eatPossibleImplicitSemiColon_();
      return new VariableStatement(this.getTreeLocation_(start), declarations);
    },
    parseVariableDeclarationList_: function() {
      var expressionIn = arguments[0] !== (void 0) ? arguments[0] : Expression.NORMAL;
      var initializer = arguments[1] !== (void 0) ? arguments[1] : DestructuringInitializer.REQUIRED;
      var type = this.peekType_();
      switch (type) {
        case CONST:
        case LET:
          if (!this.options_.blockBinding)
            debugger;
        case VAR:
          this.nextToken_();
          break;
        default:
          throw Error('unreachable');
      }
      var start = this.getTreeStartLocation_();
      var declarations = [];
      declarations.push(this.parseVariableDeclaration_(type, expressionIn, initializer));
      while (this.eatIf_(COMMA)) {
        declarations.push(this.parseVariableDeclaration_(type, expressionIn, initializer));
      }
      return new VariableDeclarationList(this.getTreeLocation_(start), type, declarations);
    },
    parseVariableDeclaration_: function(binding, expressionIn) {
      var initializer = arguments[2] !== (void 0) ? arguments[2] : DestructuringInitializer.REQUIRED;
      var initRequired = initializer !== DestructuringInitializer.OPTIONAL;
      var start = this.getTreeStartLocation_();
      var lvalue;
      var typeAnnotation;
      if (this.peekPattern_(this.peekType_())) {
        lvalue = this.parseBindingPattern_();
        typeAnnotation = null;
      } else {
        lvalue = this.parseBindingIdentifier_();
        typeAnnotation = this.parseTypeAnnotationOpt_();
      }
      var initializer = null;
      if (this.peek_(EQUAL))
        initializer = this.parseInitializer_(expressionIn);
      else if (lvalue.isPattern() && initRequired)
        this.reportError_('destructuring must have an initializer');
      return new VariableDeclaration(this.getTreeLocation_(start), lvalue, typeAnnotation, initializer);
    },
    parseInitializer_: function(expressionIn) {
      this.eat_(EQUAL);
      return this.parseAssignmentExpression(expressionIn);
    },
    parseInitializerOpt_: function(expressionIn) {
      if (this.eatIf_(EQUAL))
        return this.parseAssignmentExpression(expressionIn);
      return null;
    },
    parseEmptyStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(SEMI_COLON);
      return new EmptyStatement(this.getTreeLocation_(start));
    },
    parseFallThroughStatement_: function() {
      var start = this.getTreeStartLocation_();
      var expression;
      if (this.options_.asyncFunctions && this.peekPredefinedString_(ASYNC) && this.peek_(FUNCTION, 1)) {
        var asyncToken = this.eatId_();
        var functionToken = this.peekTokenNoLineTerminator_();
        if (functionToken !== null)
          return this.parseAsyncFunctionDeclaration_(asyncToken);
        expression = new IdentifierExpression(this.getTreeLocation_(start), asyncToken);
      } else {
        expression = this.parseExpression();
      }
      if (expression.type === IDENTIFIER_EXPRESSION) {
        if (this.eatIf_(COLON)) {
          var nameToken = expression.identifierToken;
          var statement = this.parseStatement_();
          return new LabelledStatement(this.getTreeLocation_(start), nameToken, statement);
        }
      }
      this.eatPossibleImplicitSemiColon_();
      return new ExpressionStatement(this.getTreeLocation_(start), expression);
    },
    parseIfStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(IF);
      this.eat_(OPEN_PAREN);
      var condition = this.parseExpression();
      this.eat_(CLOSE_PAREN);
      var ifClause = this.parseStatement_();
      var elseClause = null;
      if (this.eatIf_(ELSE)) {
        elseClause = this.parseStatement_();
      }
      return new IfStatement(this.getTreeLocation_(start), condition, ifClause, elseClause);
    },
    parseDoWhileStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(DO);
      var body = this.parseStatement_();
      this.eat_(WHILE);
      this.eat_(OPEN_PAREN);
      var condition = this.parseExpression();
      this.eat_(CLOSE_PAREN);
      this.eatPossibleImplicitSemiColon_();
      return new DoWhileStatement(this.getTreeLocation_(start), body, condition);
    },
    parseWhileStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(WHILE);
      this.eat_(OPEN_PAREN);
      var condition = this.parseExpression();
      this.eat_(CLOSE_PAREN);
      var body = this.parseStatement_();
      return new WhileStatement(this.getTreeLocation_(start), condition, body);
    },
    parseForStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(FOR);
      this.eat_(OPEN_PAREN);
      var type = this.peekType_();
      if (this.peekVariableDeclarationList_(type)) {
        var variables = this.parseVariableDeclarationList_(Expression.NO_IN, DestructuringInitializer.OPTIONAL);
        var declarations = variables.declarations;
        if (declarations.length > 1 || containsInitializer(declarations)) {
          return this.parseForStatement2_(start, variables);
        }
        type = this.peekType_();
        if (type === IN) {
          return this.parseForInStatement_(start, variables);
        } else if (this.peekOf_(type)) {
          return this.parseForOfStatement_(start, variables);
        } else {
          this.checkInitializers_(variables);
          return this.parseForStatement2_(start, variables);
        }
      }
      if (type === SEMI_COLON) {
        return this.parseForStatement2_(start, null);
      }
      var coverInitializedNameCount = this.coverInitializedNameCount_;
      var initializer = this.parseExpressionAllowPattern_(Expression.NO_IN);
      type = this.peekType_();
      if (initializer.isLeftHandSideExpression() && (type === IN || this.peekOf_(type))) {
        initializer = this.transformLeftHandSideExpression_(initializer);
        if (this.peekOf_(type))
          return this.parseForOfStatement_(start, initializer);
        return this.parseForInStatement_(start, initializer);
      }
      this.ensureNoCoverInitializedNames_(initializer, coverInitializedNameCount);
      return this.parseForStatement2_(start, initializer);
    },
    peekOf_: function(type) {
      return type === IDENTIFIER && this.options_.forOf && this.peekToken_().value === OF;
    },
    parseForOfStatement_: function(start, initializer) {
      this.eatId_();
      var collection = this.parseExpression();
      this.eat_(CLOSE_PAREN);
      var body = this.parseStatement_();
      return new ForOfStatement(this.getTreeLocation_(start), initializer, collection, body);
    },
    checkInitializers_: function(variables) {
      if (this.options_.blockBinding && variables.declarationType == CONST) {
        var type = variables.declarationType;
        for (var i = 0; i < variables.declarations.length; i++) {
          if (!this.checkInitializer_(type, variables.declarations[i])) {
            break;
          }
        }
      }
    },
    checkInitializer_: function(type, declaration) {
      if (this.options_.blockBinding && type == CONST && declaration.initializer == null) {
        this.reportError_('const variables must have an initializer');
        return false;
      }
      return true;
    },
    peekVariableDeclarationList_: function(type) {
      switch (type) {
        case VAR:
          return true;
        case CONST:
        case LET:
          return this.options_.blockBinding;
        default:
          return false;
      }
    },
    parseForStatement2_: function(start, initializer) {
      this.eat_(SEMI_COLON);
      var condition = null;
      if (!this.peek_(SEMI_COLON)) {
        condition = this.parseExpression();
      }
      this.eat_(SEMI_COLON);
      var increment = null;
      if (!this.peek_(CLOSE_PAREN)) {
        increment = this.parseExpression();
      }
      this.eat_(CLOSE_PAREN);
      var body = this.parseStatement_();
      return new ForStatement(this.getTreeLocation_(start), initializer, condition, increment, body);
    },
    parseForInStatement_: function(start, initializer) {
      this.eat_(IN);
      var collection = this.parseExpression();
      this.eat_(CLOSE_PAREN);
      var body = this.parseStatement_();
      return new ForInStatement(this.getTreeLocation_(start), initializer, collection, body);
    },
    parseContinueStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(CONTINUE);
      var name = null;
      if (!this.peekImplicitSemiColon_(this.peekType_())) {
        name = this.eatIdOpt_();
      }
      this.eatPossibleImplicitSemiColon_();
      return new ContinueStatement(this.getTreeLocation_(start), name);
    },
    parseBreakStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(BREAK);
      var name = null;
      if (!this.peekImplicitSemiColon_(this.peekType_())) {
        name = this.eatIdOpt_();
      }
      this.eatPossibleImplicitSemiColon_();
      return new BreakStatement(this.getTreeLocation_(start), name);
    },
    parseReturnStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(RETURN);
      var expression = null;
      if (!this.peekImplicitSemiColon_(this.peekType_())) {
        expression = this.parseExpression();
      }
      this.eatPossibleImplicitSemiColon_();
      return new ReturnStatement(this.getTreeLocation_(start), expression);
    },
    parseYieldExpression_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(YIELD);
      var expression = null;
      var isYieldFor = false;
      if (!this.peekImplicitSemiColon_(this.peekType_())) {
        isYieldFor = this.eatIf_(STAR);
        expression = this.parseAssignmentExpression();
      }
      return new YieldExpression(this.getTreeLocation_(start), expression, isYieldFor);
    },
    parseWithStatement_: function() {
      if (this.strictMode_)
        this.reportError_('Strict mode code may not include a with statement');
      var start = this.getTreeStartLocation_();
      this.eat_(WITH);
      this.eat_(OPEN_PAREN);
      var expression = this.parseExpression();
      this.eat_(CLOSE_PAREN);
      var body = this.parseStatement_();
      return new WithStatement(this.getTreeLocation_(start), expression, body);
    },
    parseSwitchStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(SWITCH);
      this.eat_(OPEN_PAREN);
      var expression = this.parseExpression();
      this.eat_(CLOSE_PAREN);
      this.eat_(OPEN_CURLY);
      var caseClauses = this.parseCaseClauses_();
      this.eat_(CLOSE_CURLY);
      return new SwitchStatement(this.getTreeLocation_(start), expression, caseClauses);
    },
    parseCaseClauses_: function() {
      var foundDefaultClause = false;
      var result = [];
      while (true) {
        var start = this.getTreeStartLocation_();
        switch (this.peekType_()) {
          case CASE:
            this.nextToken_();
            var expression = this.parseExpression();
            this.eat_(COLON);
            var statements = this.parseCaseStatementsOpt_();
            result.push(new CaseClause(this.getTreeLocation_(start), expression, statements));
            break;
          case DEFAULT:
            if (foundDefaultClause) {
              this.reportError_('Switch statements may have at most one default clause');
            } else {
              foundDefaultClause = true;
            }
            this.nextToken_();
            this.eat_(COLON);
            result.push(new DefaultClause(this.getTreeLocation_(start), this.parseCaseStatementsOpt_()));
            break;
          default:
            return result;
        }
      }
    },
    parseCaseStatementsOpt_: function() {
      var result = [];
      var type;
      while (true) {
        switch (type = this.peekType_()) {
          case CASE:
          case DEFAULT:
          case CLOSE_CURLY:
          case END_OF_FILE:
            return result;
        }
        result.push(this.parseStatementWithType_(type));
      }
    },
    parseThrowStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(THROW);
      var value = null;
      if (!this.peekImplicitSemiColon_(this.peekType_())) {
        value = this.parseExpression();
      }
      this.eatPossibleImplicitSemiColon_();
      return new ThrowStatement(this.getTreeLocation_(start), value);
    },
    parseTryStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(TRY);
      var body = this.parseBlock_();
      var catchBlock = null;
      if (this.peek_(CATCH)) {
        catchBlock = this.parseCatch_();
      }
      var finallyBlock = null;
      if (this.peek_(FINALLY)) {
        finallyBlock = this.parseFinallyBlock_();
      }
      if (catchBlock == null && finallyBlock == null) {
        this.reportError_("'catch' or 'finally' expected.");
      }
      return new TryStatement(this.getTreeLocation_(start), body, catchBlock, finallyBlock);
    },
    parseCatch_: function() {
      var start = this.getTreeStartLocation_();
      var catchBlock;
      this.eat_(CATCH);
      this.eat_(OPEN_PAREN);
      var binding;
      if (this.peekPattern_(this.peekType_()))
        binding = this.parseBindingPattern_();
      else
        binding = this.parseBindingIdentifier_();
      this.eat_(CLOSE_PAREN);
      var catchBody = this.parseBlock_();
      catchBlock = new Catch(this.getTreeLocation_(start), binding, catchBody);
      return catchBlock;
    },
    parseFinallyBlock_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(FINALLY);
      var finallyBlock = this.parseBlock_();
      return new Finally(this.getTreeLocation_(start), finallyBlock);
    },
    parseDebuggerStatement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(DEBUGGER);
      this.eatPossibleImplicitSemiColon_();
      return new DebuggerStatement(this.getTreeLocation_(start));
    },
    parsePrimaryExpression_: function() {
      switch (this.peekType_()) {
        case CLASS:
          return this.options_.classes ? this.parseClassExpression_() : this.parseSyntaxError_('Unexpected reserved word');
        case THIS:
          return this.parseThisExpression_();
        case IDENTIFIER:
          var identifier = this.parseIdentifierExpression_();
          if (this.options_.asyncFunctions && identifier.identifierToken.value === ASYNC) {
            var token = this.peekTokenNoLineTerminator_();
            if (token && token.type === FUNCTION) {
              var asyncToken = identifier.identifierToken;
              return this.parseAsyncFunctionExpression_(asyncToken);
            }
          }
          return identifier;
        case NUMBER:
        case STRING:
        case TRUE:
        case FALSE:
        case NULL:
          return this.parseLiteralExpression_();
        case OPEN_SQUARE:
          return this.parseArrayLiteral_();
        case OPEN_CURLY:
          return this.parseObjectLiteral_();
        case OPEN_PAREN:
          return this.parsePrimaryExpressionStartingWithParen_();
        case SLASH:
        case SLASH_EQUAL:
          return this.parseRegularExpressionLiteral_();
        case NO_SUBSTITUTION_TEMPLATE:
        case TEMPLATE_HEAD:
          return this.parseTemplateLiteral_(null);
        case IMPLEMENTS:
        case INTERFACE:
        case PACKAGE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case STATIC:
        case YIELD:
          if (!this.strictMode_)
            return this.parseIdentifierExpression_();
          this.reportReservedIdentifier_(this.nextToken_());
        case END_OF_FILE:
          return this.parseSyntaxError_('Unexpected end of input');
        default:
          return this.parseUnexpectedToken_(this.peekToken_());
      }
    },
    parseSuperExpression_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(SUPER);
      return new SuperExpression(this.getTreeLocation_(start));
    },
    parseThisExpression_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(THIS);
      return new ThisExpression(this.getTreeLocation_(start));
    },
    peekBindingIdentifier_: function(type) {
      return this.peekId_(type);
    },
    parseBindingIdentifier_: function() {
      var start = this.getTreeStartLocation_();
      var identifier = this.eatId_();
      return new BindingIdentifier(this.getTreeLocation_(start), identifier);
    },
    parseIdentifierExpression_: function() {
      var start = this.getTreeStartLocation_();
      var identifier = this.eatId_();
      return new IdentifierExpression(this.getTreeLocation_(start), identifier);
    },
    parseIdentifierNameExpression_: function() {
      var start = this.getTreeStartLocation_();
      var identifier = this.eatIdName_();
      return new IdentifierExpression(this.getTreeLocation_(start), identifier);
    },
    parseLiteralExpression_: function() {
      var start = this.getTreeStartLocation_();
      var literal = this.nextLiteralToken_();
      return new LiteralExpression(this.getTreeLocation_(start), literal);
    },
    nextLiteralToken_: function() {
      return this.nextToken_();
    },
    parseRegularExpressionLiteral_: function() {
      var start = this.getTreeStartLocation_();
      var literal = this.nextRegularExpressionLiteralToken_();
      return new LiteralExpression(this.getTreeLocation_(start), literal);
    },
    peekSpread_: function(type) {
      return type === DOT_DOT_DOT && this.options_.spread;
    },
    parseArrayLiteral_: function() {
      var start = this.getTreeStartLocation_();
      var expression;
      var elements = [];
      this.eat_(OPEN_SQUARE);
      var type = this.peekType_();
      if (type === FOR && this.options_.arrayComprehension)
        return this.parseArrayComprehension_(start);
      while (true) {
        type = this.peekType_();
        if (type === COMMA) {
          expression = null;
        } else if (this.peekSpread_(type)) {
          expression = this.parseSpreadExpression_();
        } else if (this.peekAssignmentExpression_(type)) {
          expression = this.parseAssignmentExpression();
        } else {
          break;
        }
        elements.push(expression);
        type = this.peekType_();
        if (type !== CLOSE_SQUARE)
          this.eat_(COMMA);
      }
      this.eat_(CLOSE_SQUARE);
      return new ArrayLiteralExpression(this.getTreeLocation_(start), elements);
    },
    parseArrayComprehension_: function(start) {
      var list = this.parseComprehensionList_();
      var expression = this.parseAssignmentExpression();
      this.eat_(CLOSE_SQUARE);
      return new ArrayComprehension(this.getTreeLocation_(start), list, expression);
    },
    parseComprehensionList_: function() {
      var list = [this.parseComprehensionFor_()];
      while (true) {
        var type = this.peekType_();
        switch (type) {
          case FOR:
            list.push(this.parseComprehensionFor_());
            break;
          case IF:
            list.push(this.parseComprehensionIf_());
            break;
          default:
            return list;
        }
      }
    },
    parseComprehensionFor_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(FOR);
      this.eat_(OPEN_PAREN);
      var left = this.parseForBinding_();
      this.eatId_(OF);
      var iterator = this.parseExpression();
      this.eat_(CLOSE_PAREN);
      return new ComprehensionFor(this.getTreeLocation_(start), left, iterator);
    },
    parseComprehensionIf_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(IF);
      this.eat_(OPEN_PAREN);
      var expression = this.parseExpression();
      this.eat_(CLOSE_PAREN);
      return new ComprehensionIf(this.getTreeLocation_(start), expression);
    },
    parseObjectLiteral_: function() {
      var start = this.getTreeStartLocation_();
      var result = [];
      this.eat_(OPEN_CURLY);
      while (this.peekPropertyDefinition_(this.peekType_())) {
        var propertyDefinition = this.parsePropertyDefinition();
        result.push(propertyDefinition);
        if (!this.eatIf_(COMMA))
          break;
      }
      this.eat_(CLOSE_CURLY);
      return new ObjectLiteralExpression(this.getTreeLocation_(start), result);
    },
    parsePropertyDefinition: function() {
      var start = this.getTreeStartLocation_();
      var functionKind = null;
      var isStatic = false;
      if (this.options_.generators && this.options_.propertyMethods && this.peek_(STAR)) {
        return this.parseGeneratorMethod_(start, isStatic, []);
      }
      var token = this.peekToken_();
      var name = this.parsePropertyName_();
      if (this.options_.propertyMethods && this.peek_(OPEN_PAREN))
        return this.parseMethod_(start, isStatic, functionKind, name, []);
      if (this.eatIf_(COLON)) {
        var value = this.parseAssignmentExpression();
        return new PropertyNameAssignment(this.getTreeLocation_(start), name, value);
      }
      var type = this.peekType_();
      if (name.type === LITERAL_PROPERTY_NAME) {
        var nameLiteral = name.literalToken;
        if (nameLiteral.value === GET && this.peekPropertyName_(type)) {
          return this.parseGetAccessor_(start, isStatic, []);
        }
        if (nameLiteral.value === SET && this.peekPropertyName_(type)) {
          return this.parseSetAccessor_(start, isStatic, []);
        }
        if (this.options_.asyncFunctions && nameLiteral.value === ASYNC && this.peekPropertyName_(type)) {
          var async = nameLiteral;
          var name = this.parsePropertyName_();
          return this.parseMethod_(start, isStatic, async, name, []);
        }
        if (this.options_.propertyNameShorthand && nameLiteral.type === IDENTIFIER || !this.strictMode_ && nameLiteral.type === YIELD) {
          if (this.peek_(EQUAL)) {
            token = this.nextToken_();
            var coverInitializedNameCount = this.coverInitializedNameCount_;
            var expr = this.parseAssignmentExpression();
            this.ensureNoCoverInitializedNames_(expr, coverInitializedNameCount);
            this.coverInitializedNameCount_++;
            return new CoverInitializedName(this.getTreeLocation_(start), nameLiteral, token, expr);
          }
          if (nameLiteral.type === YIELD)
            nameLiteral = new IdentifierToken(nameLiteral.location, YIELD);
          return new PropertyNameShorthand(this.getTreeLocation_(start), nameLiteral);
        }
        if (this.strictMode_ && nameLiteral.isStrictKeyword())
          this.reportReservedIdentifier_(nameLiteral);
      }
      if (name.type === COMPUTED_PROPERTY_NAME)
        token = this.peekToken_();
      return this.parseUnexpectedToken_(token);
    },
    parseClassElement_: function() {
      var start = this.getTreeStartLocation_();
      var annotations = this.parseAnnotations_();
      var type = this.peekType_();
      var isStatic = false,
          functionKind = null;
      switch (type) {
        case STATIC:
          var staticToken = this.nextToken_();
          type = this.peekType_();
          switch (type) {
            case OPEN_PAREN:
              var name = new LiteralPropertyName(start, staticToken);
              return this.parseMethod_(start, isStatic, functionKind, name, annotations);
            default:
              isStatic = true;
              if (type === STAR && this.options_.generators)
                return this.parseGeneratorMethod_(start, true, annotations);
              return this.parseClassElement2_(start, isStatic, annotations);
          }
          break;
        case STAR:
          return this.parseGeneratorMethod_(start, isStatic, annotations);
        default:
          return this.parseClassElement2_(start, isStatic, annotations);
      }
    },
    parseGeneratorMethod_: function(start, isStatic, annotations) {
      var functionKind = this.eat_(STAR);
      var name = this.parsePropertyName_();
      return this.parseMethod_(start, isStatic, functionKind, name, annotations);
    },
    parseMethod_: function(start, isStatic, functionKind, name, annotations) {
      this.eat_(OPEN_PAREN);
      var parameterList = this.parseFormalParameters_();
      this.eat_(CLOSE_PAREN);
      var typeAnnotation = this.parseTypeAnnotationOpt_();
      var body = this.parseFunctionBody_(functionKind, parameterList);
      return new PropertyMethodAssignment(this.getTreeLocation_(start), isStatic, functionKind, name, parameterList, typeAnnotation, annotations, body);
    },
    parsePropertyVariableDeclaration_: function(start, isStatic, name, annotations) {
      var typeAnnotation = this.parseTypeAnnotationOpt_();
      this.eat_(SEMI_COLON);
      return new PropertyVariableDeclaration(this.getTreeLocation_(start), isStatic, name, typeAnnotation, annotations);
    },
    parseClassElement2_: function(start, isStatic, annotations) {
      var functionKind = null;
      var name = this.parsePropertyName_();
      var type = this.peekType_();
      if (name.type === LITERAL_PROPERTY_NAME && name.literalToken.value === GET && this.peekPropertyName_(type)) {
        return this.parseGetAccessor_(start, isStatic, annotations);
      }
      if (name.type === LITERAL_PROPERTY_NAME && name.literalToken.value === SET && this.peekPropertyName_(type)) {
        return this.parseSetAccessor_(start, isStatic, annotations);
      }
      if (this.options_.asyncFunctions && name.type === LITERAL_PROPERTY_NAME && name.literalToken.value === ASYNC && this.peekPropertyName_(type)) {
        var async = name.literalToken;
        var name = this.parsePropertyName_();
        return this.parseMethod_(start, isStatic, async, name, annotations);
      }
      if (!this.options_.memberVariables || type === OPEN_PAREN) {
        return this.parseMethod_(start, isStatic, functionKind, name, annotations);
      }
      return this.parsePropertyVariableDeclaration_(start, isStatic, name, annotations);
    },
    parseGetAccessor_: function(start, isStatic, annotations) {
      var functionKind = null;
      var name = this.parsePropertyName_();
      this.eat_(OPEN_PAREN);
      this.eat_(CLOSE_PAREN);
      var typeAnnotation = this.parseTypeAnnotationOpt_();
      var body = this.parseFunctionBody_(functionKind, null);
      return new GetAccessor(this.getTreeLocation_(start), isStatic, name, typeAnnotation, annotations, body);
    },
    parseSetAccessor_: function(start, isStatic, annotations) {
      var functionKind = null;
      var name = this.parsePropertyName_();
      this.eat_(OPEN_PAREN);
      var parameterList = this.parsePropertySetParameterList_();
      this.eat_(CLOSE_PAREN);
      var body = this.parseFunctionBody_(functionKind, parameterList);
      return new SetAccessor(this.getTreeLocation_(start), isStatic, name, parameterList, annotations, body);
    },
    peekPropertyDefinition_: function(type) {
      return this.peekPropertyName_(type) || type == STAR && this.options_.propertyMethods && this.options_.generators;
    },
    peekPropertyName_: function(type) {
      switch (type) {
        case IDENTIFIER:
        case STRING:
        case NUMBER:
          return true;
        case OPEN_SQUARE:
          return this.options_.computedPropertyNames;
        default:
          return this.peekToken_().isKeyword();
      }
    },
    peekPredefinedString_: function(string) {
      var token = this.peekToken_();
      return token.type === IDENTIFIER && token.value === string;
    },
    parsePropertySetParameterList_: function() {
      var start = this.getTreeStartLocation_();
      var binding;
      this.pushAnnotations_();
      if (this.peekPattern_(this.peekType_()))
        binding = this.parseBindingPattern_();
      else
        binding = this.parseBindingIdentifier_();
      var typeAnnotation = this.parseTypeAnnotationOpt_();
      var parameter = new FormalParameter(this.getTreeLocation_(start), new BindingElement(this.getTreeLocation_(start), binding, null), typeAnnotation, this.popAnnotations_());
      return new FormalParameterList(parameter.location, [parameter]);
    },
    parsePrimaryExpressionStartingWithParen_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(OPEN_PAREN);
      if (this.peek_(FOR) && this.options_.generatorComprehension)
        return this.parseGeneratorComprehension_(start);
      return this.parseCoverFormals_(start);
    },
    parseSyntaxError_: function(message) {
      var start = this.getTreeStartLocation_();
      this.reportError_(message);
      var token = this.nextToken_();
      return new SyntaxErrorTree(this.getTreeLocation_(start), token, message);
    },
    parseUnexpectedToken_: function(name) {
      return this.parseSyntaxError_(("Unexpected token " + name));
    },
    peekExpression_: function(type) {
      switch (type) {
        case NO_SUBSTITUTION_TEMPLATE:
        case TEMPLATE_HEAD:
          return this.options_.templateLiterals;
        case BANG:
        case CLASS:
        case DELETE:
        case FALSE:
        case FUNCTION:
        case IDENTIFIER:
        case MINUS:
        case MINUS_MINUS:
        case NEW:
        case NULL:
        case NUMBER:
        case OPEN_CURLY:
        case OPEN_PAREN:
        case OPEN_SQUARE:
        case PLUS:
        case PLUS_PLUS:
        case SLASH:
        case SLASH_EQUAL:
        case STRING:
        case SUPER:
        case THIS:
        case TILDE:
        case TRUE:
        case TYPEOF:
        case VOID:
        case YIELD:
          return true;
        default:
          return false;
      }
    },
    parseExpression: function() {
      var expressionIn = arguments[0] !== (void 0) ? arguments[0] : Expression.IN;
      var coverInitializedNameCount = this.coverInitializedNameCount_;
      var expression = this.parseExpressionAllowPattern_(expressionIn);
      this.ensureNoCoverInitializedNames_(expression, coverInitializedNameCount);
      return expression;
    },
    parseExpressionAllowPattern_: function(expressionIn) {
      var start = this.getTreeStartLocation_();
      var expression = this.parseAssignmentExpression(expressionIn);
      if (this.peek_(COMMA)) {
        var expressions = [expression];
        while (this.eatIf_(COMMA)) {
          expressions.push(this.parseAssignmentExpression(expressionIn));
        }
        return new CommaExpression(this.getTreeLocation_(start), expressions);
      }
      return expression;
    },
    peekAssignmentExpression_: function(type) {
      return this.peekExpression_(type);
    },
    parseAssignmentExpression: function() {
      var expressionIn = arguments[0] !== (void 0) ? arguments[0] : Expression.NORMAL;
      if (this.allowYield && this.peek_(YIELD))
        return this.parseYieldExpression_();
      var start = this.getTreeStartLocation_();
      var validAsyncParen = false;
      if (this.options_.asyncFunctions && this.peekPredefinedString_(ASYNC)) {
        var asyncToken = this.peekToken_();
        var maybeOpenParenToken = this.peekToken_(1);
        validAsyncParen = maybeOpenParenToken.type === OPEN_PAREN && asyncToken.location.end.line === maybeOpenParenToken.location.start.line;
      }
      var left = this.parseConditional_(expressionIn);
      var type = this.peekType_();
      if (this.options_.asyncFunctions && left.type === IDENTIFIER_EXPRESSION && left.identifierToken.value === ASYNC && type === IDENTIFIER) {
        if (this.peekTokenNoLineTerminator_() !== null) {
          var bindingIdentifier = this.parseBindingIdentifier_();
          var asyncToken = left.IdentifierToken;
          return this.parseArrowFunction_(start, bindingIdentifier, asyncToken);
        }
      }
      if (type === ARROW) {
        if (left.type === COVER_FORMALS || left.type === IDENTIFIER_EXPRESSION)
          return this.parseArrowFunction_(start, left, null);
        if (validAsyncParen && left.type === CALL_EXPRESSION) {
          var arrowToken = this.peekTokenNoLineTerminator_();
          if (arrowToken !== null) {
            var asyncToken = left.operand.identifierToken;
            return this.parseArrowFunction_(start, left.args, asyncToken);
          }
        }
      }
      left = this.coverFormalsToParenExpression_(left);
      if (this.peekAssignmentOperator_(type)) {
        if (type === EQUAL)
          left = this.transformLeftHandSideExpression_(left);
        if (!left.isLeftHandSideExpression() && !left.isPattern()) {
          this.reportError_('Left hand side of assignment must be new, call, member, function, primary expressions or destructuring pattern');
        }
        var operator = this.nextToken_();
        var right = this.parseAssignmentExpression(expressionIn);
        return new BinaryExpression(this.getTreeLocation_(start), left, operator, right);
      }
      return left;
    },
    transformLeftHandSideExpression_: function(tree) {
      switch (tree.type) {
        case ARRAY_LITERAL_EXPRESSION:
        case OBJECT_LITERAL_EXPRESSION:
          this.scanner_.index = tree.location.start.offset;
          return this.parseAssignmentPattern_();
      }
      return tree;
    },
    peekAssignmentOperator_: function(type) {
      return isAssignmentOperator(type);
    },
    parseConditional_: function(expressionIn) {
      var start = this.getTreeStartLocation_();
      var condition = this.parseLogicalOR_(expressionIn);
      if (this.eatIf_(QUESTION)) {
        condition = this.toPrimaryExpression_(condition);
        var left = this.parseAssignmentExpression();
        this.eat_(COLON);
        var right = this.parseAssignmentExpression(expressionIn);
        return new ConditionalExpression(this.getTreeLocation_(start), condition, left, right);
      }
      return condition;
    },
    newBinaryExpression_: function(start, left, operator, right) {
      left = this.toPrimaryExpression_(left);
      right = this.toPrimaryExpression_(right);
      return new BinaryExpression(this.getTreeLocation_(start), left, operator, right);
    },
    parseLogicalOR_: function(expressionIn) {
      var start = this.getTreeStartLocation_();
      var left = this.parseLogicalAND_(expressionIn);
      var operator;
      while (operator = this.eatOpt_(OR)) {
        var right = this.parseLogicalAND_(expressionIn);
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    parseLogicalAND_: function(expressionIn) {
      var start = this.getTreeStartLocation_();
      var left = this.parseBitwiseOR_(expressionIn);
      var operator;
      while (operator = this.eatOpt_(AND)) {
        var right = this.parseBitwiseOR_(expressionIn);
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    parseBitwiseOR_: function(expressionIn) {
      var start = this.getTreeStartLocation_();
      var left = this.parseBitwiseXOR_(expressionIn);
      var operator;
      while (operator = this.eatOpt_(BAR)) {
        var right = this.parseBitwiseXOR_(expressionIn);
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    parseBitwiseXOR_: function(expressionIn) {
      var start = this.getTreeStartLocation_();
      var left = this.parseBitwiseAND_(expressionIn);
      var operator;
      while (operator = this.eatOpt_(CARET)) {
        var right = this.parseBitwiseAND_(expressionIn);
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    parseBitwiseAND_: function(expressionIn) {
      var start = this.getTreeStartLocation_();
      var left = this.parseEquality_(expressionIn);
      var operator;
      while (operator = this.eatOpt_(AMPERSAND)) {
        var right = this.parseEquality_(expressionIn);
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    parseEquality_: function(expressionIn) {
      var start = this.getTreeStartLocation_();
      var left = this.parseRelational_(expressionIn);
      while (this.peekEqualityOperator_(this.peekType_())) {
        var operator = this.nextToken_();
        var right = this.parseRelational_(expressionIn);
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    peekEqualityOperator_: function(type) {
      switch (type) {
        case EQUAL_EQUAL:
        case NOT_EQUAL:
        case EQUAL_EQUAL_EQUAL:
        case NOT_EQUAL_EQUAL:
          return true;
      }
      return false;
    },
    parseRelational_: function(expressionIn) {
      var start = this.getTreeStartLocation_();
      var left = this.parseShiftExpression_();
      while (this.peekRelationalOperator_(expressionIn)) {
        var operator = this.nextToken_();
        var right = this.parseShiftExpression_();
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    peekRelationalOperator_: function(expressionIn) {
      switch (this.peekType_()) {
        case OPEN_ANGLE:
        case CLOSE_ANGLE:
        case GREATER_EQUAL:
        case LESS_EQUAL:
        case INSTANCEOF:
          return true;
        case IN:
          return expressionIn == Expression.NORMAL;
        default:
          return false;
      }
    },
    parseShiftExpression_: function() {
      var start = this.getTreeStartLocation_();
      var left = this.parseAdditiveExpression_();
      while (this.peekShiftOperator_(this.peekType_())) {
        var operator = this.nextToken_();
        var right = this.parseAdditiveExpression_();
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    peekShiftOperator_: function(type) {
      switch (type) {
        case LEFT_SHIFT:
        case RIGHT_SHIFT:
        case UNSIGNED_RIGHT_SHIFT:
          return true;
        default:
          return false;
      }
    },
    parseAdditiveExpression_: function() {
      var start = this.getTreeStartLocation_();
      var left = this.parseMultiplicativeExpression_();
      while (this.peekAdditiveOperator_(this.peekType_())) {
        var operator = this.nextToken_();
        var right = this.parseMultiplicativeExpression_();
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    peekAdditiveOperator_: function(type) {
      switch (type) {
        case PLUS:
        case MINUS:
          return true;
        default:
          return false;
      }
    },
    parseMultiplicativeExpression_: function() {
      var start = this.getTreeStartLocation_();
      var left = this.parseExponentiationExpression_();
      while (this.peekMultiplicativeOperator_(this.peekType_())) {
        var operator = this.nextToken_();
        var right = this.parseExponentiationExpression_();
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    parseExponentiationExpression_: function() {
      var start = this.getTreeStartLocation_();
      var left = this.parseUnaryExpression_();
      while (this.peekExponentiationExpression_(this.peekType_())) {
        var operator = this.nextToken_();
        var right = this.parseExponentiationExpression_();
        left = this.newBinaryExpression_(start, left, operator, right);
      }
      return left;
    },
    peekMultiplicativeOperator_: function(type) {
      switch (type) {
        case STAR:
        case SLASH:
        case PERCENT:
          return true;
        default:
          return false;
      }
    },
    peekExponentiationExpression_: function(type) {
      return type === STAR_STAR;
    },
    parseUnaryExpression_: function() {
      var start = this.getTreeStartLocation_();
      if (this.allowAwait && this.peekPredefinedString_(AWAIT)) {
        this.eatId_();
        var operand = this.parseUnaryExpression_();
        operand = this.toPrimaryExpression_(operand);
        return new AwaitExpression(this.getTreeLocation_(start), operand);
      }
      if (this.peekUnaryOperator_(this.peekType_())) {
        var operator = this.nextToken_();
        var operand = this.parseUnaryExpression_();
        operand = this.toPrimaryExpression_(operand);
        return new UnaryExpression(this.getTreeLocation_(start), operator, operand);
      }
      return this.parsePostfixExpression_();
    },
    peekUnaryOperator_: function(type) {
      switch (type) {
        case DELETE:
        case VOID:
        case TYPEOF:
        case PLUS_PLUS:
        case MINUS_MINUS:
        case PLUS:
        case MINUS:
        case TILDE:
        case BANG:
          return true;
        default:
          return false;
      }
    },
    parsePostfixExpression_: function() {
      var start = this.getTreeStartLocation_();
      var operand = this.parseLeftHandSideExpression_();
      while (this.peekPostfixOperator_(this.peekType_())) {
        operand = this.toPrimaryExpression_(operand);
        var operator = this.nextToken_();
        operand = new PostfixExpression(this.getTreeLocation_(start), operand, operator);
      }
      return operand;
    },
    peekPostfixOperator_: function(type) {
      switch (type) {
        case PLUS_PLUS:
        case MINUS_MINUS:
          var token = this.peekTokenNoLineTerminator_();
          return token !== null;
      }
      return false;
    },
    parseLeftHandSideExpression_: function() {
      var start = this.getTreeStartLocation_();
      var operand = this.parseNewExpression_();
      if (!(operand instanceof NewExpression) || operand.args != null) {
        loop: while (true) {
          switch (this.peekType_()) {
            case OPEN_PAREN:
              operand = this.toPrimaryExpression_(operand);
              operand = this.parseCallExpression_(start, operand);
              break;
            case OPEN_SQUARE:
              operand = this.toPrimaryExpression_(operand);
              operand = this.parseMemberLookupExpression_(start, operand);
              break;
            case PERIOD:
              operand = this.toPrimaryExpression_(operand);
              operand = this.parseMemberExpression_(start, operand);
              break;
            case NO_SUBSTITUTION_TEMPLATE:
            case TEMPLATE_HEAD:
              if (!this.options_.templateLiterals)
                break loop;
              operand = this.toPrimaryExpression_(operand);
              operand = this.parseTemplateLiteral_(operand);
              break;
            default:
              break loop;
          }
        }
      }
      return operand;
    },
    parseMemberExpressionNoNew_: function() {
      var start = this.getTreeStartLocation_();
      var operand;
      if (this.peekType_() === FUNCTION) {
        operand = this.parseFunctionExpression_();
      } else {
        operand = this.parsePrimaryExpression_();
      }
      loop: while (true) {
        switch (this.peekType_()) {
          case OPEN_SQUARE:
            operand = this.toPrimaryExpression_(operand);
            operand = this.parseMemberLookupExpression_(start, operand);
            break;
          case PERIOD:
            operand = this.toPrimaryExpression_(operand);
            operand = this.parseMemberExpression_(start, operand);
            break;
          case NO_SUBSTITUTION_TEMPLATE:
          case TEMPLATE_HEAD:
            if (!this.options_.templateLiterals)
              break loop;
            operand = this.toPrimaryExpression_(operand);
            operand = this.parseTemplateLiteral_(operand);
            break;
          default:
            break loop;
        }
      }
      return operand;
    },
    parseMemberExpression_: function(start, operand) {
      this.nextToken_();
      var name = this.eatIdName_();
      return new MemberExpression(this.getTreeLocation_(start), operand, name);
    },
    parseMemberLookupExpression_: function(start, operand) {
      this.nextToken_();
      var member = this.parseExpression();
      this.eat_(CLOSE_SQUARE);
      return new MemberLookupExpression(this.getTreeLocation_(start), operand, member);
    },
    parseCallExpression_: function(start, operand) {
      var args = this.parseArguments_();
      return new CallExpression(this.getTreeLocation_(start), operand, args);
    },
    parseNewExpression_: function() {
      var operand;
      switch (this.peekType_()) {
        case NEW:
          var start = this.getTreeStartLocation_();
          this.eat_(NEW);
          if (this.peek_(SUPER))
            operand = this.parseSuperExpression_();
          else
            operand = this.toPrimaryExpression_(this.parseNewExpression_());
          var args = null;
          if (this.peek_(OPEN_PAREN)) {
            args = this.parseArguments_();
          }
          return new NewExpression(this.getTreeLocation_(start), operand, args);
        case SUPER:
          operand = this.parseSuperExpression_();
          var type = this.peekType_();
          switch (type) {
            case OPEN_SQUARE:
              return this.parseMemberLookupExpression_(start, operand);
            case PERIOD:
              return this.parseMemberExpression_(start, operand);
            case OPEN_PAREN:
              return this.parseCallExpression_(start, operand);
            default:
              return this.parseUnexpectedToken_(type);
          }
          break;
        default:
          return this.parseMemberExpressionNoNew_();
      }
    },
    parseArguments_: function() {
      var start = this.getTreeStartLocation_();
      var args = [];
      this.eat_(OPEN_PAREN);
      if (!this.peek_(CLOSE_PAREN)) {
        args.push(this.parseArgument_());
        while (this.eatIf_(COMMA)) {
          args.push(this.parseArgument_());
        }
      }
      this.eat_(CLOSE_PAREN);
      return new ArgumentList(this.getTreeLocation_(start), args);
    },
    parseArgument_: function() {
      if (this.peekSpread_(this.peekType_()))
        return this.parseSpreadExpression_();
      return this.parseAssignmentExpression();
    },
    parseArrowFunction_: function(start, tree, asyncToken) {
      var formals;
      switch (tree.type) {
        case IDENTIFIER_EXPRESSION:
          tree = new BindingIdentifier(tree.location, tree.identifierToken);
        case BINDING_IDENTIFIER:
          formals = new FormalParameterList(this.getTreeLocation_(start), [new FormalParameter(tree.location, new BindingElement(tree.location, tree, null), null, [])]);
          break;
        case FORMAL_PARAMETER_LIST:
          formals = tree;
          break;
        default:
          formals = this.toFormalParameters_(start, tree, asyncToken);
      }
      this.eat_(ARROW);
      var body = this.parseConciseBody_(asyncToken);
      return new ArrowFunctionExpression(this.getTreeLocation_(start), asyncToken, formals, body);
    },
    parseCoverFormals_: function(start) {
      var expressions = [];
      if (!this.peek_(CLOSE_PAREN)) {
        do {
          var type = this.peekType_();
          if (this.peekRest_(type)) {
            expressions.push(this.parseRestParameter_());
            break;
          } else {
            expressions.push(this.parseAssignmentExpression());
          }
          if (this.eatIf_(COMMA))
            continue;
        } while (!this.peek_(CLOSE_PAREN) && !this.isAtEnd());
      }
      this.eat_(CLOSE_PAREN);
      return new CoverFormals(this.getTreeLocation_(start), expressions);
    },
    ensureNoCoverInitializedNames_: function(tree, coverInitializedNameCount) {
      if (coverInitializedNameCount === this.coverInitializedNameCount_)
        return;
      var finder = new ValidateObjectLiteral();
      finder.visitAny(tree);
      if (finder.found) {
        var token = finder.errorToken;
        this.reportError_(token.location, ("Unexpected token " + token));
      }
    },
    toPrimaryExpression_: function(tree) {
      if (tree.type === COVER_FORMALS)
        return this.coverFormalsToParenExpression_(tree);
      return tree;
    },
    validateCoverFormalsAsParenExpression_: function(tree) {
      for (var i = 0; i < tree.expressions.length; i++) {
        if (tree.expressions[i].type === REST_PARAMETER) {
          var token = new Token(DOT_DOT_DOT, tree.expressions[i].location);
          this.reportError_(token.location, ("Unexpected token " + token));
          return;
        }
      }
    },
    coverFormalsToParenExpression_: function(tree) {
      if (tree.type === COVER_FORMALS) {
        var expressions = tree.expressions;
        if (expressions.length === 0) {
          var message = 'Unexpected token )';
          this.reportError_(tree.location, message);
        } else {
          this.validateCoverFormalsAsParenExpression_(tree);
          var expression;
          if (expressions.length > 1)
            expression = new CommaExpression(expressions[0].location, expressions);
          else
            expression = expressions[0];
          return new ParenExpression(tree.location, expression);
        }
      }
      return tree;
    },
    toFormalParameters_: function(start, tree, asyncToken) {
      this.scanner_.index = start.offset;
      return this.parseArrowFormalParameters_(asyncToken);
    },
    parseArrowFormalParameters_: function(asyncToken) {
      if (asyncToken)
        this.eat_(IDENTIFIER);
      this.eat_(OPEN_PAREN);
      var parameters = this.parseFormalParameters_();
      this.eat_(CLOSE_PAREN);
      return parameters;
    },
    peekArrow_: function(type) {
      return type === ARROW && this.options_.arrowFunctions;
    },
    parseConciseBody_: function(asyncToken) {
      if (this.peek_(OPEN_CURLY))
        return this.parseFunctionBody_(asyncToken);
      var allowAwait = this.allowAwait;
      this.allowAwait = asyncToken !== null;
      var expression = this.parseAssignmentExpression();
      this.allowAwait = allowAwait;
      return expression;
    },
    parseGeneratorComprehension_: function(start) {
      var comprehensionList = this.parseComprehensionList_();
      var expression = this.parseAssignmentExpression();
      this.eat_(CLOSE_PAREN);
      return new GeneratorComprehension(this.getTreeLocation_(start), comprehensionList, expression);
    },
    parseForBinding_: function() {
      if (this.peekPattern_(this.peekType_()))
        return this.parseBindingPattern_();
      return this.parseBindingIdentifier_();
    },
    peekPattern_: function(type) {
      return this.options_.destructuring && (this.peekObjectPattern_(type) || this.peekArrayPattern_(type));
    },
    peekArrayPattern_: function(type) {
      return type === OPEN_SQUARE;
    },
    peekObjectPattern_: function(type) {
      return type === OPEN_CURLY;
    },
    parseBindingPattern_: function() {
      return this.parsePattern_(true);
    },
    parsePattern_: function(useBinding) {
      if (this.peekArrayPattern_(this.peekType_()))
        return this.parseArrayPattern_(useBinding);
      return this.parseObjectPattern_(useBinding);
    },
    parseArrayBindingPattern_: function() {
      return this.parseArrayPattern_(true);
    },
    parsePatternElement_: function(useBinding) {
      return useBinding ? this.parseBindingElement_() : this.parseAssignmentElement_();
    },
    parsePatternRestElement_: function(useBinding) {
      return useBinding ? this.parseBindingRestElement_() : this.parseAssignmentRestElement_();
    },
    parseArrayPattern_: function(useBinding) {
      var start = this.getTreeStartLocation_();
      var elements = [];
      this.eat_(OPEN_SQUARE);
      var type;
      while ((type = this.peekType_()) !== CLOSE_SQUARE && type !== END_OF_FILE) {
        this.parseElisionOpt_(elements);
        if (this.peekRest_(this.peekType_())) {
          elements.push(this.parsePatternRestElement_(useBinding));
          break;
        } else {
          elements.push(this.parsePatternElement_(useBinding));
          if (this.peek_(COMMA) && !this.peek_(CLOSE_SQUARE, 1)) {
            this.nextToken_();
          }
        }
      }
      this.eat_(CLOSE_SQUARE);
      return new ArrayPattern(this.getTreeLocation_(start), elements);
    },
    parseBindingElementList_: function(elements) {
      this.parseElisionOpt_(elements);
      elements.push(this.parseBindingElement_());
      while (this.eatIf_(COMMA)) {
        this.parseElisionOpt_(elements);
        elements.push(this.parseBindingElement_());
      }
    },
    parseElisionOpt_: function(elements) {
      while (this.eatIf_(COMMA)) {
        elements.push(null);
      }
    },
    peekBindingElement_: function(type) {
      return this.peekBindingIdentifier_(type) || this.peekPattern_(type);
    },
    parseBindingElement_: function() {
      var initializer = arguments[0] !== (void 0) ? arguments[0] : Initializer.OPTIONAL;
      var start = this.getTreeStartLocation_();
      var binding = this.parseBindingElementBinding_();
      var initializer = this.parseBindingElementInitializer_(initializer);
      return new BindingElement(this.getTreeLocation_(start), binding, initializer);
    },
    parseBindingElementBinding_: function() {
      if (this.peekPattern_(this.peekType_()))
        return this.parseBindingPattern_();
      return this.parseBindingIdentifier_();
    },
    parseBindingElementInitializer_: function() {
      var initializer = arguments[0] !== (void 0) ? arguments[0] : Initializer.OPTIONAL;
      if (this.peek_(EQUAL) || initializer === Initializer.REQUIRED) {
        return this.parseInitializer_();
      }
      return null;
    },
    parseBindingRestElement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(DOT_DOT_DOT);
      var identifier = this.parseBindingIdentifier_();
      return new SpreadPatternElement(this.getTreeLocation_(start), identifier);
    },
    parseObjectPattern_: function(useBinding) {
      var start = this.getTreeStartLocation_();
      var elements = [];
      this.eat_(OPEN_CURLY);
      var type;
      while ((type = this.peekType_()) !== CLOSE_CURLY && type !== END_OF_FILE) {
        elements.push(this.parsePatternProperty_(useBinding));
        if (!this.eatIf_(COMMA))
          break;
      }
      this.eat_(CLOSE_CURLY);
      return new ObjectPattern(this.getTreeLocation_(start), elements);
    },
    parsePatternProperty_: function(useBinding) {
      var start = this.getTreeStartLocation_();
      var name = this.parsePropertyName_();
      var requireColon = name.type !== LITERAL_PROPERTY_NAME || !name.literalToken.isStrictKeyword() && name.literalToken.type !== IDENTIFIER;
      if (requireColon || this.peek_(COLON)) {
        this.eat_(COLON);
        var element = this.parsePatternElement_(useBinding);
        return new ObjectPatternField(this.getTreeLocation_(start), name, element);
      }
      var token = name.literalToken;
      if (this.strictMode_ && token.isStrictKeyword())
        this.reportReservedIdentifier_(token);
      if (useBinding) {
        var binding = new BindingIdentifier(name.location, token);
        var initializer = this.parseInitializerOpt_(Expression.NORMAL);
        return new BindingElement(this.getTreeLocation_(start), binding, initializer);
      }
      var assignment = new IdentifierExpression(name.location, token);
      var initializer = this.parseInitializerOpt_(Expression.NORMAL);
      return new AssignmentElement(this.getTreeLocation_(start), assignment, initializer);
    },
    parseAssignmentPattern_: function() {
      return this.parsePattern_(false);
    },
    parseArrayAssignmentPattern_: function() {
      return this.parseArrayPattern_(false);
    },
    parseAssignmentElement_: function() {
      var start = this.getTreeStartLocation_();
      var assignment = this.parseDestructuringAssignmentTarget_();
      var initializer = this.parseInitializerOpt_(Expression.NORMAL);
      return new AssignmentElement(this.getTreeLocation_(start), assignment, initializer);
    },
    parseDestructuringAssignmentTarget_: function() {
      switch (this.peekType_()) {
        case OPEN_SQUARE:
          return this.parseArrayAssignmentPattern_();
        case OPEN_CURLY:
          return this.parseObjectAssignmentPattern_();
      }
      var expression = this.parseLeftHandSideExpression_();
      return this.coverFormalsToParenExpression_(expression);
    },
    parseAssignmentRestElement_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(DOT_DOT_DOT);
      var id = this.parseDestructuringAssignmentTarget_();
      return new SpreadPatternElement(this.getTreeLocation_(start), id);
    },
    parseObjectAssignmentPattern_: function() {
      return this.parseObjectPattern_(false);
    },
    parseAssignmentProperty_: function() {
      return this.parsePatternProperty_(false);
    },
    parseTemplateLiteral_: function(operand) {
      if (!this.options_.templateLiterals)
        return this.parseUnexpectedToken_('`');
      var start = operand ? operand.location.start : this.getTreeStartLocation_();
      var token = this.nextToken_();
      var elements = [new TemplateLiteralPortion(token.location, token)];
      if (token.type === NO_SUBSTITUTION_TEMPLATE) {
        return new TemplateLiteralExpression(this.getTreeLocation_(start), operand, elements);
      }
      var expression = this.parseExpression();
      elements.push(new TemplateSubstitution(expression.location, expression));
      while (expression.type !== SYNTAX_ERROR_TREE) {
        token = this.nextTemplateLiteralToken_();
        if (token.type === ERROR || token.type === END_OF_FILE)
          break;
        elements.push(new TemplateLiteralPortion(token.location, token));
        if (token.type === TEMPLATE_TAIL)
          break;
        expression = this.parseExpression();
        elements.push(new TemplateSubstitution(expression.location, expression));
      }
      return new TemplateLiteralExpression(this.getTreeLocation_(start), operand, elements);
    },
    parseTypeAnnotationOpt_: function() {
      if (this.options_.types && this.eatOpt_(COLON)) {
        return this.parseType_();
      }
      return null;
    },
    parseType_: function() {
      switch (this.peekType_()) {
        case NEW:
          return this.parseConstructorType_();
        case OPEN_PAREN:
        case OPEN_ANGLE:
          return this.parseFunctionType_();
      }
      var start = this.getTreeStartLocation_();
      var elementType = this.parsePrimaryType_();
      return this.parseUnionTypeSuffix_(start, elementType);
    },
    parsePrimaryType_: function() {
      var start = this.getTreeStartLocation_();
      var elementType;
      switch (this.peekType_()) {
        case VOID:
          var token = this.nextToken_();
          elementType = new PredefinedType(this.getTreeLocation_(start), token);
          break;
        case IDENTIFIER:
          switch (this.peekToken_().value) {
            case 'any':
            case 'boolean':
            case 'number':
            case 'string':
            case 'symbol':
              var token = this.nextToken_();
              elementType = new PredefinedType(this.getTreeLocation_(start), token);
              break;
            default:
              elementType = this.parseTypeReference_();
          }
          break;
        case TYPEOF:
          elementType = this.parseTypeQuery_(start);
          break;
        case OPEN_CURLY:
          elementType = this.parseObjectType_();
          break;
        default:
          return this.parseUnexpectedToken_(this.peekToken_());
      }
      return this.parseArrayTypeSuffix_(start, elementType);
    },
    parseTypeReference_: function() {
      var start = this.getTreeStartLocation_();
      var typeName = this.parseTypeName_();
      var args = null;
      if (this.peek_(OPEN_ANGLE)) {
        var args = this.parseTypeArguments_();
        return new TypeReference(this.getTreeLocation_(start), typeName, args);
      }
      return typeName;
    },
    parseUnionTypeSuffix_: function(start, elementType) {
      if (this.peek_(BAR)) {
        var types = [elementType];
        this.eat_(BAR);
        while (true) {
          types.push(this.parsePrimaryType_());
          if (!this.eatIf_(BAR)) {
            break;
          }
        }
        return new UnionType(this.getTreeLocation_(start), types);
      }
      return elementType;
    },
    parseArrayTypeSuffix_: function(start, elementType) {
      var token = this.peekTokenNoLineTerminator_();
      if (token && token.type === OPEN_SQUARE) {
        this.eat_(OPEN_SQUARE);
        this.eat_(CLOSE_SQUARE);
        elementType = new ArrayType(this.getTreeLocation_(start), elementType);
        return this.parseArrayTypeSuffix_(start, elementType);
      }
      return elementType;
    },
    parseTypeArguments_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(OPEN_ANGLE);
      var args = [this.parseType_()];
      while (this.peek_(COMMA)) {
        this.eat_(COMMA);
        args.push(this.parseType_());
      }
      var token = this.nextCloseAngle_();
      if (token.type !== CLOSE_ANGLE) {
        return this.parseUnexpectedToken_(token.type);
      }
      return new TypeArguments(this.getTreeLocation_(start), args);
    },
    parseConstructorType_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(NEW);
      var typeParameters = this.parseTypeParametersOpt_();
      this.eat_(OPEN_PAREN);
      var parameterList = this.parseFormalParameters_();
      this.eat_(CLOSE_PAREN);
      this.eat_(ARROW);
      var returnType = this.parseType_();
      return new ConstructorType(this.getTreeLocation_(start), typeParameters, parameterList, returnType);
    },
    parseObjectType_: function() {
      var start = this.getTreeStartLocation_();
      var typeMembers = [];
      this.eat_(OPEN_CURLY);
      var type;
      while (this.peekTypeMember_(type = this.peekType_())) {
        typeMembers.push(this.parseTypeMember_(type));
        if (!this.eatIf_(SEMI_COLON)) {
          break;
        }
      }
      this.eat_(CLOSE_CURLY);
      return new ObjectType(this.getTreeLocation_(start), typeMembers);
    },
    peekTypeMember_: function(type) {
      switch (type) {
        case NEW:
        case OPEN_PAREN:
        case OPEN_ANGLE:
        case OPEN_SQUARE:
        case IDENTIFIER:
        case STRING:
        case NUMBER:
          return true;
        default:
          return this.peekToken_().isKeyword();
      }
    },
    parseTypeMember_: function(type) {
      switch (type) {
        case NEW:
          return this.parseConstructSignature_();
        case OPEN_PAREN:
        case OPEN_ANGLE:
          return this.parseCallSignature_();
        case OPEN_SQUARE:
          return this.parseIndexSignature_();
      }
      var start = this.getTreeStartLocation_();
      var propertyName = this.parseLiteralPropertyName_();
      var isOpt = this.eatIf_(QUESTION);
      type = this.peekType_();
      if (type === OPEN_ANGLE || type === OPEN_PAREN) {
        var callSignature = this.parseCallSignature_();
        return new MethodSignature(this.getTreeLocation_(start), propertyName, isOpt, callSignature);
      }
      var typeAnnotation = this.parseTypeAnnotationOpt_();
      return new PropertySignature(this.getTreeLocation_(start), propertyName, isOpt, typeAnnotation);
    },
    parseCallSignature_: function() {
      var start = this.getTreeStartLocation_();
      var typeParameters = this.parseTypeParametersOpt_();
      this.eat_(OPEN_PAREN);
      var parameterList = this.parseFormalParameters_();
      this.eat_(CLOSE_PAREN);
      var returnType = this.parseTypeAnnotationOpt_();
      return new CallSignature(this.getTreeLocation_(start), typeParameters, parameterList, returnType);
    },
    parseConstructSignature_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(NEW);
      var typeParameters = this.parseTypeParametersOpt_();
      this.eat_(OPEN_PAREN);
      var parameterList = this.parseFormalParameters_();
      this.eat_(CLOSE_PAREN);
      var returnType = this.parseTypeAnnotationOpt_();
      return new ConstructSignature(this.getTreeLocation_(start), typeParameters, parameterList, returnType);
    },
    parseIndexSignature_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(OPEN_SQUARE);
      var id = this.eatId_();
      this.eat_(COLON);
      var typeName;
      var typeStart = this.getTreeStartLocation_();
      if (this.peekPredefinedString_('string')) {
        typeName = this.eatId_('string');
      } else {
        typeName = this.eatId_('number');
      }
      var indexType = new PredefinedType(this.getTreeLocation_(typeStart), typeName);
      this.eat_(CLOSE_SQUARE);
      this.eat_(COLON);
      var typeAnnotation = this.parseType_();
      return new IndexSignature(this.getTreeLocation_(start), id, indexType, typeAnnotation);
    },
    parseFunctionType_: function() {
      var start = this.getTreeStartLocation_();
      var typeParameters = this.parseTypeParametersOpt_();
      this.eat_(OPEN_PAREN);
      var parameterList = this.parseFormalParameters_();
      this.eat_(CLOSE_PAREN);
      this.eat_(ARROW);
      var returnType = this.parseType_();
      return new FunctionType(this.getTreeLocation_(start), typeParameters, parameterList, returnType);
    },
    parseTypeQuery_: function(start) {
      throw 'NYI';
    },
    peekTypeParameters_: function() {
      return this.peek_(OPEN_ANGLE);
    },
    parseTypeParametersOpt_: function() {
      if (this.peek_(OPEN_ANGLE)) {
        return this.parseTypeParameters_();
      }
      return null;
    },
    parseTypeParameters_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(OPEN_ANGLE);
      var parameters = [this.parseTypeParameter_()];
      while (this.peek_(COMMA)) {
        this.eat_(COMMA);
        parameters.push(this.parseTypeParameter_());
      }
      this.eat_(CLOSE_ANGLE);
      return new TypeParameters(this.getTreeLocation_(start), parameters);
    },
    parseTypeParameter_: function() {
      var start = this.getTreeStartLocation_();
      var id = this.eatId_();
      var extendsType = null;
      if (this.eatIf_(EXTENDS)) {
        extendsType = this.parseType_();
      }
      return new TypeParameter(this.getTreeLocation_(start), id, extendsType);
    },
    parseNamedOrPredefinedType_: function() {
      var start = this.getTreeStartLocation_();
      switch (this.peekToken_().value) {
        case 'any':
        case 'number':
        case 'boolean':
        case 'string':
          var token = this.nextToken_();
          return new PredefinedType(this.getTreeLocation_(start), token);
        default:
          return this.parseTypeName_();
      }
    },
    parseTypeName_: function() {
      var start = this.getTreeStartLocation_();
      var id = this.eatId_();
      var typeName = new TypeName(this.getTreeLocation_(start), null, id);
      while (this.eatIf_(PERIOD)) {
        var memberName = this.eatIdName_();
        typeName = new TypeName(this.getTreeLocation_(start), typeName, memberName);
      }
      return typeName;
    },
    parseInterfaceDeclaration_: function() {
      var start = this.getTreeStartLocation_();
      this.eat_(INTERFACE);
      var name = this.eatId_();
      var typeParameters = this.parseTypeParametersOpt_();
      var extendsClause;
      if (this.eatIf_(EXTENDS)) {
        extendsClause = this.parseInterfaceExtendsClause_();
      } else {
        extendsClause = [];
      }
      var objectType = this.parseObjectType_();
      return new InterfaceDeclaration(this.getTreeLocation_(start), name, typeParameters, extendsClause, objectType);
    },
    parseInterfaceExtendsClause_: function() {
      var result = [this.parseTypeReference_()];
      while (this.eatIf_(COMMA)) {
        result.push(this.parseTypeReference_());
      }
      return result;
    },
    parseAnnotatedDeclarations_: function(parsingModuleItem) {
      this.pushAnnotations_();
      var declaration;
      var type = this.peekType_();
      if (parsingModuleItem) {
        declaration = this.parseModuleItem_(type);
      } else {
        declaration = this.parseStatementListItem_(type);
      }
      if (this.annotations_.length > 0) {
        return this.parseSyntaxError_('Unsupported annotated expression');
      }
      return declaration;
    },
    parseAnnotations_: function() {
      var annotations = [];
      while (this.eatIf_(AT)) {
        annotations.push(this.parseAnnotation_());
      }
      return annotations;
    },
    pushAnnotations_: function() {
      this.annotations_ = this.parseAnnotations_();
    },
    popAnnotations_: function() {
      var annotations = this.annotations_;
      this.annotations_ = [];
      return annotations;
    },
    parseAnnotation_: function() {
      var start = this.getTreeStartLocation_();
      var expression = this.parseMemberExpressionNoNew_();
      var args = null;
      if (this.peek_(OPEN_PAREN))
        args = this.parseArguments_();
      return new Annotation(this.getTreeLocation_(start), expression, args);
    },
    eatPossibleImplicitSemiColon_: function() {
      var token = this.peekTokenNoLineTerminator_();
      if (!token)
        return;
      switch (token.type) {
        case SEMI_COLON:
          this.nextToken_();
          return;
        case END_OF_FILE:
        case CLOSE_CURLY:
          return;
      }
      this.reportError_('Semi-colon expected');
    },
    peekImplicitSemiColon_: function() {
      switch (this.peekType_()) {
        case SEMI_COLON:
        case CLOSE_CURLY:
        case END_OF_FILE:
          return true;
      }
      var token = this.peekTokenNoLineTerminator_();
      return token === null;
    },
    eatOpt_: function(expectedTokenType) {
      if (this.peek_(expectedTokenType))
        return this.nextToken_();
      return null;
    },
    eatIdOpt_: function() {
      return this.peek_(IDENTIFIER) ? this.eatId_() : null;
    },
    eatId_: function() {
      var expected = arguments[0];
      var token = this.nextToken_();
      if (!token) {
        if (expected)
          this.reportError_(this.peekToken_(), ("expected '" + expected + "'"));
        return null;
      }
      if (token.type === IDENTIFIER) {
        if (expected && token.value !== expected)
          this.reportExpectedError_(token, expected);
        return token;
      }
      if (token.isStrictKeyword()) {
        if (this.strictMode_) {
          this.reportReservedIdentifier_(token);
        } else {
          return new IdentifierToken(token.location, token.type);
        }
      } else {
        this.reportExpectedError_(token, expected || 'identifier');
      }
      return token;
    },
    eatIdName_: function() {
      var t = this.nextToken_();
      if (t.type != IDENTIFIER) {
        if (!t.isKeyword()) {
          this.reportExpectedError_(t, 'identifier');
          return null;
        }
        return new IdentifierToken(t.location, t.type);
      }
      return t;
    },
    eat_: function(expectedTokenType) {
      var token = this.nextToken_();
      if (token.type != expectedTokenType) {
        this.reportExpectedError_(token, expectedTokenType);
        return null;
      }
      return token;
    },
    eatIf_: function(expectedTokenType) {
      if (this.peek_(expectedTokenType)) {
        this.nextToken_();
        return true;
      }
      return false;
    },
    reportExpectedError_: function(token, expected) {
      this.reportError_(token, ("Unexpected token " + token));
    },
    getTreeStartLocation_: function() {
      return this.peekToken_().location.start;
    },
    getTreeEndLocation_: function() {
      return this.scanner_.lastToken.location.end;
    },
    getTreeLocation_: function(start) {
      return new SourceRange(start, this.getTreeEndLocation_());
    },
    handleComment: function(range) {},
    nextToken_: function() {
      return this.scanner_.nextToken();
    },
    nextRegularExpressionLiteralToken_: function() {
      return this.scanner_.nextRegularExpressionLiteralToken();
    },
    nextTemplateLiteralToken_: function() {
      return this.scanner_.nextTemplateLiteralToken();
    },
    nextCloseAngle_: function() {
      return this.scanner_.nextCloseAngle();
    },
    isAtEnd: function() {
      return this.scanner_.isAtEnd();
    },
    peek_: function(expectedType, opt_index) {
      return this.peekToken_(opt_index).type === expectedType;
    },
    peekType_: function() {
      return this.peekToken_().type;
    },
    peekToken_: function(opt_index) {
      return this.scanner_.peekToken(opt_index);
    },
    peekTokenNoLineTerminator_: function() {
      return this.scanner_.peekTokenNoLineTerminator();
    },
    reportError_: function() {
      for (var args = [],
          $__14 = 0; $__14 < arguments.length; $__14++)
        args[$__14] = arguments[$__14];
      if (args.length == 1) {
        this.errorReporter_.reportError(this.scanner_.getPosition(), args[0]);
      } else {
        var location = args[0];
        if (location instanceof Token) {
          location = location.location;
        }
        this.errorReporter_.reportError(location.start, args[1]);
      }
    },
    reportReservedIdentifier_: function(token) {
      this.reportError_(token, (token.type + " is a reserved identifier"));
    }
  }, {});
  return {get Parser() {
      return Parser;
    }};
});
System.registerModule("traceur@0.0.80/src/util/SourcePosition.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/util/SourcePosition.js";
  var SourcePosition = function SourcePosition(source, offset) {
    this.source = source;
    this.offset = offset;
    this.line_ = -1;
    this.column_ = -1;
  };
  ($traceurRuntime.createClass)(SourcePosition, {
    get line() {
      if (this.line_ === -1)
        this.line_ = this.source.lineNumberTable.getLine(this.offset);
      return this.line_;
    },
    get column() {
      if (this.column_ === -1)
        this.column_ = this.source.lineNumberTable.getColumn(this.offset);
      return this.column_;
    },
    toString: function() {
      var name = this.source ? this.source.name : '';
      return (name + ":" + (this.line + 1) + ":" + (this.column + 1));
    }
  }, {});
  return {get SourcePosition() {
      return SourcePosition;
    }};
});
System.registerModule("traceur@0.0.80/src/syntax/LineNumberTable.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/LineNumberTable.js";
  var SourcePosition = System.get("traceur@0.0.80/src/util/SourcePosition.js").SourcePosition;
  var SourceRange = System.get("traceur@0.0.80/src/util/SourceRange.js").SourceRange;
  var isLineTerminator = System.get("traceur@0.0.80/src/syntax/Scanner.js").isLineTerminator;
  var MAX_INT_REPRESENTATION = 9007199254740992;
  function computeLineStartOffsets(source) {
    var lineStartOffsets = [0];
    var k = 1;
    for (var index = 0; index < source.length; index++) {
      var code = source.charCodeAt(index);
      if (isLineTerminator(code)) {
        if (code === 13 && source.charCodeAt(index + 1) === 10) {
          index++;
        }
        lineStartOffsets[k++] = index + 1;
      }
    }
    lineStartOffsets[k++] = MAX_INT_REPRESENTATION;
    return lineStartOffsets;
  }
  var LineNumberTable = function LineNumberTable(sourceFile) {
    this.sourceFile_ = sourceFile;
    this.lineStartOffsets_ = null;
    this.lastLine_ = 0;
    this.lastOffset_ = -1;
  };
  ($traceurRuntime.createClass)(LineNumberTable, {
    ensureLineStartOffsets_: function() {
      if (!this.lineStartOffsets_) {
        this.lineStartOffsets_ = computeLineStartOffsets(this.sourceFile_.contents);
      }
    },
    getSourcePosition: function(offset) {
      return new SourcePosition(this.sourceFile_, offset);
    },
    getLine: function(offset) {
      if (offset === this.lastOffset_)
        return this.lastLine_;
      this.ensureLineStartOffsets_();
      if (offset < 0)
        return 0;
      var line;
      if (offset < this.lastOffset_) {
        for (var i = this.lastLine_; i >= 0; i--) {
          if (this.lineStartOffsets_[i] <= offset) {
            line = i;
            break;
          }
        }
      } else {
        for (var i = this.lastLine_; true; i++) {
          if (this.lineStartOffsets_[i] > offset) {
            line = i - 1;
            break;
          }
        }
      }
      this.lastLine_ = line;
      this.lastOffset_ = offset;
      return line;
    },
    offsetOfLine: function(line) {
      this.ensureLineStartOffsets_();
      return this.lineStartOffsets_[line];
    },
    getColumn: function(offset) {
      var line = this.getLine(offset);
      return offset - this.lineStartOffsets_[line];
    },
    getSourceRange: function(startOffset, endOffset) {
      return new SourceRange(this.getSourcePosition(startOffset), this.getSourcePosition(endOffset));
    }
  }, {});
  return {get LineNumberTable() {
      return LineNumberTable;
    }};
});
System.registerModule("traceur@0.0.80/src/syntax/SourceFile.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/SourceFile.js";
  var LineNumberTable = System.get("traceur@0.0.80/src/syntax/LineNumberTable.js").LineNumberTable;
  var SourceFile = function SourceFile(name, contents) {
    this.name = name;
    this.contents = contents;
    this.lineNumberTable = new LineNumberTable(this);
  };
  ($traceurRuntime.createClass)(SourceFile, {}, {});
  return {get SourceFile() {
      return SourceFile;
    }};
});
System.registerModule("traceur@0.0.80/src/util/CollectingErrorReporter.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/util/CollectingErrorReporter.js";
  var ErrorReporter = System.get("traceur@0.0.80/src/util/ErrorReporter.js").ErrorReporter;
  var MultipleErrors = function MultipleErrors(errors) {
    this.message = errors ? errors.join('\n') + '' : '';
    this.name = errors && (errors.length > 1) ? 'MultipleErrors' : '';
    this.errors = errors;
  };
  ($traceurRuntime.createClass)(MultipleErrors, {}, {}, Error);
  var CollectingErrorReporter = function CollectingErrorReporter() {
    $traceurRuntime.superConstructor($CollectingErrorReporter).call(this);
    this.errors = [];
  };
  var $CollectingErrorReporter = CollectingErrorReporter;
  ($traceurRuntime.createClass)(CollectingErrorReporter, {
    reportMessageInternal: function(location, message) {
      if (location)
        message = (location + ": " + message);
      this.errors.push(message);
    },
    errorsAsString: function() {
      return this.toError().message;
    },
    toError: function() {
      return new MultipleErrors(this.errors);
    }
  }, {}, ErrorReporter);
  return {
    get MultipleErrors() {
      return MultipleErrors;
    },
    get CollectingErrorReporter() {
      return CollectingErrorReporter;
    }
  };
});
System.registerModule("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      Annotation = $__0.Annotation,
      AnonBlock = $__0.AnonBlock,
      ArgumentList = $__0.ArgumentList,
      ArrayComprehension = $__0.ArrayComprehension,
      ArrayLiteralExpression = $__0.ArrayLiteralExpression,
      ArrayPattern = $__0.ArrayPattern,
      ArrayType = $__0.ArrayType,
      ArrowFunctionExpression = $__0.ArrowFunctionExpression,
      AssignmentElement = $__0.AssignmentElement,
      AwaitExpression = $__0.AwaitExpression,
      BinaryExpression = $__0.BinaryExpression,
      BindingElement = $__0.BindingElement,
      BindingIdentifier = $__0.BindingIdentifier,
      Block = $__0.Block,
      BreakStatement = $__0.BreakStatement,
      CallExpression = $__0.CallExpression,
      CallSignature = $__0.CallSignature,
      CaseClause = $__0.CaseClause,
      Catch = $__0.Catch,
      ClassDeclaration = $__0.ClassDeclaration,
      ClassExpression = $__0.ClassExpression,
      CommaExpression = $__0.CommaExpression,
      ComprehensionFor = $__0.ComprehensionFor,
      ComprehensionIf = $__0.ComprehensionIf,
      ComputedPropertyName = $__0.ComputedPropertyName,
      ConditionalExpression = $__0.ConditionalExpression,
      ConstructSignature = $__0.ConstructSignature,
      ConstructorType = $__0.ConstructorType,
      ContinueStatement = $__0.ContinueStatement,
      CoverFormals = $__0.CoverFormals,
      CoverInitializedName = $__0.CoverInitializedName,
      DebuggerStatement = $__0.DebuggerStatement,
      DefaultClause = $__0.DefaultClause,
      DoWhileStatement = $__0.DoWhileStatement,
      EmptyStatement = $__0.EmptyStatement,
      ExportDeclaration = $__0.ExportDeclaration,
      ExportDefault = $__0.ExportDefault,
      ExportSpecifier = $__0.ExportSpecifier,
      ExportSpecifierSet = $__0.ExportSpecifierSet,
      ExportStar = $__0.ExportStar,
      ExpressionStatement = $__0.ExpressionStatement,
      Finally = $__0.Finally,
      ForInStatement = $__0.ForInStatement,
      ForOfStatement = $__0.ForOfStatement,
      ForStatement = $__0.ForStatement,
      FormalParameter = $__0.FormalParameter,
      FormalParameterList = $__0.FormalParameterList,
      FunctionBody = $__0.FunctionBody,
      FunctionDeclaration = $__0.FunctionDeclaration,
      FunctionExpression = $__0.FunctionExpression,
      FunctionType = $__0.FunctionType,
      GeneratorComprehension = $__0.GeneratorComprehension,
      GetAccessor = $__0.GetAccessor,
      IdentifierExpression = $__0.IdentifierExpression,
      IfStatement = $__0.IfStatement,
      ImportedBinding = $__0.ImportedBinding,
      ImportDeclaration = $__0.ImportDeclaration,
      ImportSpecifier = $__0.ImportSpecifier,
      ImportSpecifierSet = $__0.ImportSpecifierSet,
      IndexSignature = $__0.IndexSignature,
      InterfaceDeclaration = $__0.InterfaceDeclaration,
      LabelledStatement = $__0.LabelledStatement,
      LiteralExpression = $__0.LiteralExpression,
      LiteralPropertyName = $__0.LiteralPropertyName,
      MemberExpression = $__0.MemberExpression,
      MemberLookupExpression = $__0.MemberLookupExpression,
      MethodSignature = $__0.MethodSignature,
      Module = $__0.Module,
      ModuleDeclaration = $__0.ModuleDeclaration,
      ModuleSpecifier = $__0.ModuleSpecifier,
      NamedExport = $__0.NamedExport,
      NewExpression = $__0.NewExpression,
      ObjectLiteralExpression = $__0.ObjectLiteralExpression,
      ObjectPattern = $__0.ObjectPattern,
      ObjectPatternField = $__0.ObjectPatternField,
      ObjectType = $__0.ObjectType,
      ParenExpression = $__0.ParenExpression,
      PostfixExpression = $__0.PostfixExpression,
      PredefinedType = $__0.PredefinedType,
      Script = $__0.Script,
      PropertyMethodAssignment = $__0.PropertyMethodAssignment,
      PropertyNameAssignment = $__0.PropertyNameAssignment,
      PropertyNameShorthand = $__0.PropertyNameShorthand,
      PropertyVariableDeclaration = $__0.PropertyVariableDeclaration,
      PropertySignature = $__0.PropertySignature,
      RestParameter = $__0.RestParameter,
      ReturnStatement = $__0.ReturnStatement,
      SetAccessor = $__0.SetAccessor,
      SpreadExpression = $__0.SpreadExpression,
      SpreadPatternElement = $__0.SpreadPatternElement,
      SuperExpression = $__0.SuperExpression,
      SwitchStatement = $__0.SwitchStatement,
      SyntaxErrorTree = $__0.SyntaxErrorTree,
      TemplateLiteralExpression = $__0.TemplateLiteralExpression,
      TemplateLiteralPortion = $__0.TemplateLiteralPortion,
      TemplateSubstitution = $__0.TemplateSubstitution,
      ThisExpression = $__0.ThisExpression,
      ThrowStatement = $__0.ThrowStatement,
      TryStatement = $__0.TryStatement,
      TypeArguments = $__0.TypeArguments,
      TypeName = $__0.TypeName,
      TypeParameter = $__0.TypeParameter,
      TypeParameters = $__0.TypeParameters,
      TypeReference = $__0.TypeReference,
      UnaryExpression = $__0.UnaryExpression,
      UnionType = $__0.UnionType,
      VariableDeclaration = $__0.VariableDeclaration,
      VariableDeclarationList = $__0.VariableDeclarationList,
      VariableStatement = $__0.VariableStatement,
      WhileStatement = $__0.WhileStatement,
      WithStatement = $__0.WithStatement,
      YieldExpression = $__0.YieldExpression;
  var ParseTreeTransformer = function ParseTreeTransformer() {};
  ($traceurRuntime.createClass)(ParseTreeTransformer, {
    transformAny: function(tree) {
      return tree && tree.transform(this);
    },
    transformList: function(list) {
      var $__2;
      var builder = null;
      for (var index = 0; index < list.length; index++) {
        var element = list[index];
        var transformed = this.transformAny(element);
        if (builder != null || element != transformed) {
          if (builder == null) {
            builder = list.slice(0, index);
          }
          if (transformed instanceof AnonBlock)
            ($__2 = builder).push.apply($__2, $traceurRuntime.spread(transformed.statements));
          else
            builder.push(transformed);
        }
      }
      return builder || list;
    },
    transformStateMachine: function(tree) {
      throw Error('State machines should not live outside of the GeneratorTransformer.');
    },
    transformToBlockOrStatement: function(tree) {
      var transformed = this.transformAny(tree);
      if (transformed instanceof AnonBlock) {
        return new Block(transformed.location, transformed.statements);
      }
      return transformed;
    },
    transformAnnotation: function(tree) {
      var name = this.transformAny(tree.name);
      var args = this.transformAny(tree.args);
      if (name === tree.name && args === tree.args) {
        return tree;
      }
      return new Annotation(tree.location, name, args);
    },
    transformAnonBlock: function(tree) {
      var statements = this.transformList(tree.statements);
      if (statements === tree.statements) {
        return tree;
      }
      return new AnonBlock(tree.location, statements);
    },
    transformArgumentList: function(tree) {
      var args = this.transformList(tree.args);
      if (args === tree.args) {
        return tree;
      }
      return new ArgumentList(tree.location, args);
    },
    transformArrayComprehension: function(tree) {
      var comprehensionList = this.transformList(tree.comprehensionList);
      var expression = this.transformAny(tree.expression);
      if (comprehensionList === tree.comprehensionList && expression === tree.expression) {
        return tree;
      }
      return new ArrayComprehension(tree.location, comprehensionList, expression);
    },
    transformArrayLiteralExpression: function(tree) {
      var elements = this.transformList(tree.elements);
      if (elements === tree.elements) {
        return tree;
      }
      return new ArrayLiteralExpression(tree.location, elements);
    },
    transformArrayPattern: function(tree) {
      var elements = this.transformList(tree.elements);
      if (elements === tree.elements) {
        return tree;
      }
      return new ArrayPattern(tree.location, elements);
    },
    transformArrayType: function(tree) {
      var elementType = this.transformAny(tree.elementType);
      if (elementType === tree.elementType) {
        return tree;
      }
      return new ArrayType(tree.location, elementType);
    },
    transformArrowFunctionExpression: function(tree) {
      var parameterList = this.transformAny(tree.parameterList);
      var body = this.transformAny(tree.body);
      if (parameterList === tree.parameterList && body === tree.body) {
        return tree;
      }
      return new ArrowFunctionExpression(tree.location, tree.functionKind, parameterList, body);
    },
    transformAssignmentElement: function(tree) {
      var assignment = this.transformAny(tree.assignment);
      var initializer = this.transformAny(tree.initializer);
      if (assignment === tree.assignment && initializer === tree.initializer) {
        return tree;
      }
      return new AssignmentElement(tree.location, assignment, initializer);
    },
    transformAwaitExpression: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression) {
        return tree;
      }
      return new AwaitExpression(tree.location, expression);
    },
    transformBinaryExpression: function(tree) {
      var left = this.transformAny(tree.left);
      var right = this.transformAny(tree.right);
      if (left === tree.left && right === tree.right) {
        return tree;
      }
      return new BinaryExpression(tree.location, left, tree.operator, right);
    },
    transformBindingElement: function(tree) {
      var binding = this.transformAny(tree.binding);
      var initializer = this.transformAny(tree.initializer);
      if (binding === tree.binding && initializer === tree.initializer) {
        return tree;
      }
      return new BindingElement(tree.location, binding, initializer);
    },
    transformBindingIdentifier: function(tree) {
      return tree;
    },
    transformBlock: function(tree) {
      var statements = this.transformList(tree.statements);
      if (statements === tree.statements) {
        return tree;
      }
      return new Block(tree.location, statements);
    },
    transformBreakStatement: function(tree) {
      return tree;
    },
    transformCallExpression: function(tree) {
      var operand = this.transformAny(tree.operand);
      var args = this.transformAny(tree.args);
      if (operand === tree.operand && args === tree.args) {
        return tree;
      }
      return new CallExpression(tree.location, operand, args);
    },
    transformCallSignature: function(tree) {
      var typeParameters = this.transformAny(tree.typeParameters);
      var parameterList = this.transformAny(tree.parameterList);
      var returnType = this.transformAny(tree.returnType);
      if (typeParameters === tree.typeParameters && parameterList === tree.parameterList && returnType === tree.returnType) {
        return tree;
      }
      return new CallSignature(tree.location, typeParameters, parameterList, returnType);
    },
    transformCaseClause: function(tree) {
      var expression = this.transformAny(tree.expression);
      var statements = this.transformList(tree.statements);
      if (expression === tree.expression && statements === tree.statements) {
        return tree;
      }
      return new CaseClause(tree.location, expression, statements);
    },
    transformCatch: function(tree) {
      var binding = this.transformAny(tree.binding);
      var catchBody = this.transformAny(tree.catchBody);
      if (binding === tree.binding && catchBody === tree.catchBody) {
        return tree;
      }
      return new Catch(tree.location, binding, catchBody);
    },
    transformClassDeclaration: function(tree) {
      var name = this.transformAny(tree.name);
      var superClass = this.transformAny(tree.superClass);
      var elements = this.transformList(tree.elements);
      var annotations = this.transformList(tree.annotations);
      var typeParameters = this.transformAny(tree.typeParameters);
      if (name === tree.name && superClass === tree.superClass && elements === tree.elements && annotations === tree.annotations && typeParameters === tree.typeParameters) {
        return tree;
      }
      return new ClassDeclaration(tree.location, name, superClass, elements, annotations, typeParameters);
    },
    transformClassExpression: function(tree) {
      var name = this.transformAny(tree.name);
      var superClass = this.transformAny(tree.superClass);
      var elements = this.transformList(tree.elements);
      var annotations = this.transformList(tree.annotations);
      var typeParameters = this.transformAny(tree.typeParameters);
      if (name === tree.name && superClass === tree.superClass && elements === tree.elements && annotations === tree.annotations && typeParameters === tree.typeParameters) {
        return tree;
      }
      return new ClassExpression(tree.location, name, superClass, elements, annotations, typeParameters);
    },
    transformCommaExpression: function(tree) {
      var expressions = this.transformList(tree.expressions);
      if (expressions === tree.expressions) {
        return tree;
      }
      return new CommaExpression(tree.location, expressions);
    },
    transformComprehensionFor: function(tree) {
      var left = this.transformAny(tree.left);
      var iterator = this.transformAny(tree.iterator);
      if (left === tree.left && iterator === tree.iterator) {
        return tree;
      }
      return new ComprehensionFor(tree.location, left, iterator);
    },
    transformComprehensionIf: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression) {
        return tree;
      }
      return new ComprehensionIf(tree.location, expression);
    },
    transformComputedPropertyName: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression) {
        return tree;
      }
      return new ComputedPropertyName(tree.location, expression);
    },
    transformConditionalExpression: function(tree) {
      var condition = this.transformAny(tree.condition);
      var left = this.transformAny(tree.left);
      var right = this.transformAny(tree.right);
      if (condition === tree.condition && left === tree.left && right === tree.right) {
        return tree;
      }
      return new ConditionalExpression(tree.location, condition, left, right);
    },
    transformConstructSignature: function(tree) {
      var typeParameters = this.transformAny(tree.typeParameters);
      var parameterList = this.transformAny(tree.parameterList);
      var returnType = this.transformAny(tree.returnType);
      if (typeParameters === tree.typeParameters && parameterList === tree.parameterList && returnType === tree.returnType) {
        return tree;
      }
      return new ConstructSignature(tree.location, typeParameters, parameterList, returnType);
    },
    transformConstructorType: function(tree) {
      var typeParameters = this.transformAny(tree.typeParameters);
      var parameterList = this.transformAny(tree.parameterList);
      var returnType = this.transformAny(tree.returnType);
      if (typeParameters === tree.typeParameters && parameterList === tree.parameterList && returnType === tree.returnType) {
        return tree;
      }
      return new ConstructorType(tree.location, typeParameters, parameterList, returnType);
    },
    transformContinueStatement: function(tree) {
      return tree;
    },
    transformCoverFormals: function(tree) {
      var expressions = this.transformList(tree.expressions);
      if (expressions === tree.expressions) {
        return tree;
      }
      return new CoverFormals(tree.location, expressions);
    },
    transformCoverInitializedName: function(tree) {
      var initializer = this.transformAny(tree.initializer);
      if (initializer === tree.initializer) {
        return tree;
      }
      return new CoverInitializedName(tree.location, tree.name, tree.equalToken, initializer);
    },
    transformDebuggerStatement: function(tree) {
      return tree;
    },
    transformDefaultClause: function(tree) {
      var statements = this.transformList(tree.statements);
      if (statements === tree.statements) {
        return tree;
      }
      return new DefaultClause(tree.location, statements);
    },
    transformDoWhileStatement: function(tree) {
      var body = this.transformToBlockOrStatement(tree.body);
      var condition = this.transformAny(tree.condition);
      if (body === tree.body && condition === tree.condition) {
        return tree;
      }
      return new DoWhileStatement(tree.location, body, condition);
    },
    transformEmptyStatement: function(tree) {
      return tree;
    },
    transformExportDeclaration: function(tree) {
      var declaration = this.transformAny(tree.declaration);
      var annotations = this.transformList(tree.annotations);
      if (declaration === tree.declaration && annotations === tree.annotations) {
        return tree;
      }
      return new ExportDeclaration(tree.location, declaration, annotations);
    },
    transformExportDefault: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression) {
        return tree;
      }
      return new ExportDefault(tree.location, expression);
    },
    transformExportSpecifier: function(tree) {
      return tree;
    },
    transformExportSpecifierSet: function(tree) {
      var specifiers = this.transformList(tree.specifiers);
      if (specifiers === tree.specifiers) {
        return tree;
      }
      return new ExportSpecifierSet(tree.location, specifiers);
    },
    transformExportStar: function(tree) {
      return tree;
    },
    transformExpressionStatement: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression) {
        return tree;
      }
      return new ExpressionStatement(tree.location, expression);
    },
    transformFinally: function(tree) {
      var block = this.transformAny(tree.block);
      if (block === tree.block) {
        return tree;
      }
      return new Finally(tree.location, block);
    },
    transformForInStatement: function(tree) {
      var initializer = this.transformAny(tree.initializer);
      var collection = this.transformAny(tree.collection);
      var body = this.transformToBlockOrStatement(tree.body);
      if (initializer === tree.initializer && collection === tree.collection && body === tree.body) {
        return tree;
      }
      return new ForInStatement(tree.location, initializer, collection, body);
    },
    transformForOfStatement: function(tree) {
      var initializer = this.transformAny(tree.initializer);
      var collection = this.transformAny(tree.collection);
      var body = this.transformToBlockOrStatement(tree.body);
      if (initializer === tree.initializer && collection === tree.collection && body === tree.body) {
        return tree;
      }
      return new ForOfStatement(tree.location, initializer, collection, body);
    },
    transformForStatement: function(tree) {
      var initializer = this.transformAny(tree.initializer);
      var condition = this.transformAny(tree.condition);
      var increment = this.transformAny(tree.increment);
      var body = this.transformToBlockOrStatement(tree.body);
      if (initializer === tree.initializer && condition === tree.condition && increment === tree.increment && body === tree.body) {
        return tree;
      }
      return new ForStatement(tree.location, initializer, condition, increment, body);
    },
    transformFormalParameter: function(tree) {
      var parameter = this.transformAny(tree.parameter);
      var typeAnnotation = this.transformAny(tree.typeAnnotation);
      var annotations = this.transformList(tree.annotations);
      if (parameter === tree.parameter && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations) {
        return tree;
      }
      return new FormalParameter(tree.location, parameter, typeAnnotation, annotations);
    },
    transformFormalParameterList: function(tree) {
      var parameters = this.transformList(tree.parameters);
      if (parameters === tree.parameters) {
        return tree;
      }
      return new FormalParameterList(tree.location, parameters);
    },
    transformFunctionBody: function(tree) {
      var statements = this.transformList(tree.statements);
      if (statements === tree.statements) {
        return tree;
      }
      return new FunctionBody(tree.location, statements);
    },
    transformFunctionDeclaration: function(tree) {
      var name = this.transformAny(tree.name);
      var parameterList = this.transformAny(tree.parameterList);
      var typeAnnotation = this.transformAny(tree.typeAnnotation);
      var annotations = this.transformList(tree.annotations);
      var body = this.transformAny(tree.body);
      if (name === tree.name && parameterList === tree.parameterList && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body) {
        return tree;
      }
      return new FunctionDeclaration(tree.location, name, tree.functionKind, parameterList, typeAnnotation, annotations, body);
    },
    transformFunctionExpression: function(tree) {
      var name = this.transformAny(tree.name);
      var parameterList = this.transformAny(tree.parameterList);
      var typeAnnotation = this.transformAny(tree.typeAnnotation);
      var annotations = this.transformList(tree.annotations);
      var body = this.transformAny(tree.body);
      if (name === tree.name && parameterList === tree.parameterList && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body) {
        return tree;
      }
      return new FunctionExpression(tree.location, name, tree.functionKind, parameterList, typeAnnotation, annotations, body);
    },
    transformFunctionType: function(tree) {
      var typeParameters = this.transformAny(tree.typeParameters);
      var parameterList = this.transformAny(tree.parameterList);
      var returnType = this.transformAny(tree.returnType);
      if (typeParameters === tree.typeParameters && parameterList === tree.parameterList && returnType === tree.returnType) {
        return tree;
      }
      return new FunctionType(tree.location, typeParameters, parameterList, returnType);
    },
    transformGeneratorComprehension: function(tree) {
      var comprehensionList = this.transformList(tree.comprehensionList);
      var expression = this.transformAny(tree.expression);
      if (comprehensionList === tree.comprehensionList && expression === tree.expression) {
        return tree;
      }
      return new GeneratorComprehension(tree.location, comprehensionList, expression);
    },
    transformGetAccessor: function(tree) {
      var name = this.transformAny(tree.name);
      var typeAnnotation = this.transformAny(tree.typeAnnotation);
      var annotations = this.transformList(tree.annotations);
      var body = this.transformAny(tree.body);
      if (name === tree.name && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body) {
        return tree;
      }
      return new GetAccessor(tree.location, tree.isStatic, name, typeAnnotation, annotations, body);
    },
    transformIdentifierExpression: function(tree) {
      return tree;
    },
    transformIfStatement: function(tree) {
      var condition = this.transformAny(tree.condition);
      var ifClause = this.transformToBlockOrStatement(tree.ifClause);
      var elseClause = this.transformToBlockOrStatement(tree.elseClause);
      if (condition === tree.condition && ifClause === tree.ifClause && elseClause === tree.elseClause) {
        return tree;
      }
      return new IfStatement(tree.location, condition, ifClause, elseClause);
    },
    transformImportedBinding: function(tree) {
      var binding = this.transformAny(tree.binding);
      if (binding === tree.binding) {
        return tree;
      }
      return new ImportedBinding(tree.location, binding);
    },
    transformImportDeclaration: function(tree) {
      var importClause = this.transformAny(tree.importClause);
      var moduleSpecifier = this.transformAny(tree.moduleSpecifier);
      if (importClause === tree.importClause && moduleSpecifier === tree.moduleSpecifier) {
        return tree;
      }
      return new ImportDeclaration(tree.location, importClause, moduleSpecifier);
    },
    transformImportSpecifier: function(tree) {
      var binding = this.transformAny(tree.binding);
      if (binding === tree.binding) {
        return tree;
      }
      return new ImportSpecifier(tree.location, binding, tree.name);
    },
    transformImportSpecifierSet: function(tree) {
      var specifiers = this.transformList(tree.specifiers);
      if (specifiers === tree.specifiers) {
        return tree;
      }
      return new ImportSpecifierSet(tree.location, specifiers);
    },
    transformIndexSignature: function(tree) {
      var indexType = this.transformAny(tree.indexType);
      var typeAnnotation = this.transformAny(tree.typeAnnotation);
      if (indexType === tree.indexType && typeAnnotation === tree.typeAnnotation) {
        return tree;
      }
      return new IndexSignature(tree.location, tree.name, indexType, typeAnnotation);
    },
    transformInterfaceDeclaration: function(tree) {
      var typeParameters = this.transformAny(tree.typeParameters);
      var objectType = this.transformAny(tree.objectType);
      if (typeParameters === tree.typeParameters && objectType === tree.objectType) {
        return tree;
      }
      return new InterfaceDeclaration(tree.location, tree.name, typeParameters, tree.extendsClause, objectType);
    },
    transformLabelledStatement: function(tree) {
      var statement = this.transformAny(tree.statement);
      if (statement === tree.statement) {
        return tree;
      }
      return new LabelledStatement(tree.location, tree.name, statement);
    },
    transformLiteralExpression: function(tree) {
      return tree;
    },
    transformLiteralPropertyName: function(tree) {
      return tree;
    },
    transformMemberExpression: function(tree) {
      var operand = this.transformAny(tree.operand);
      if (operand === tree.operand) {
        return tree;
      }
      return new MemberExpression(tree.location, operand, tree.memberName);
    },
    transformMemberLookupExpression: function(tree) {
      var operand = this.transformAny(tree.operand);
      var memberExpression = this.transformAny(tree.memberExpression);
      if (operand === tree.operand && memberExpression === tree.memberExpression) {
        return tree;
      }
      return new MemberLookupExpression(tree.location, operand, memberExpression);
    },
    transformMethodSignature: function(tree) {
      var name = this.transformAny(tree.name);
      var callSignature = this.transformAny(tree.callSignature);
      if (name === tree.name && callSignature === tree.callSignature) {
        return tree;
      }
      return new MethodSignature(tree.location, name, tree.optional, callSignature);
    },
    transformModule: function(tree) {
      var scriptItemList = this.transformList(tree.scriptItemList);
      if (scriptItemList === tree.scriptItemList) {
        return tree;
      }
      return new Module(tree.location, scriptItemList, tree.moduleName);
    },
    transformModuleDeclaration: function(tree) {
      var binding = this.transformAny(tree.binding);
      var expression = this.transformAny(tree.expression);
      if (binding === tree.binding && expression === tree.expression) {
        return tree;
      }
      return new ModuleDeclaration(tree.location, binding, expression);
    },
    transformModuleSpecifier: function(tree) {
      return tree;
    },
    transformNamedExport: function(tree) {
      var moduleSpecifier = this.transformAny(tree.moduleSpecifier);
      var specifierSet = this.transformAny(tree.specifierSet);
      if (moduleSpecifier === tree.moduleSpecifier && specifierSet === tree.specifierSet) {
        return tree;
      }
      return new NamedExport(tree.location, moduleSpecifier, specifierSet);
    },
    transformNewExpression: function(tree) {
      var operand = this.transformAny(tree.operand);
      var args = this.transformAny(tree.args);
      if (operand === tree.operand && args === tree.args) {
        return tree;
      }
      return new NewExpression(tree.location, operand, args);
    },
    transformObjectLiteralExpression: function(tree) {
      var propertyNameAndValues = this.transformList(tree.propertyNameAndValues);
      if (propertyNameAndValues === tree.propertyNameAndValues) {
        return tree;
      }
      return new ObjectLiteralExpression(tree.location, propertyNameAndValues);
    },
    transformObjectPattern: function(tree) {
      var fields = this.transformList(tree.fields);
      if (fields === tree.fields) {
        return tree;
      }
      return new ObjectPattern(tree.location, fields);
    },
    transformObjectPatternField: function(tree) {
      var name = this.transformAny(tree.name);
      var element = this.transformAny(tree.element);
      if (name === tree.name && element === tree.element) {
        return tree;
      }
      return new ObjectPatternField(tree.location, name, element);
    },
    transformObjectType: function(tree) {
      var typeMembers = this.transformList(tree.typeMembers);
      if (typeMembers === tree.typeMembers) {
        return tree;
      }
      return new ObjectType(tree.location, typeMembers);
    },
    transformParenExpression: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression) {
        return tree;
      }
      return new ParenExpression(tree.location, expression);
    },
    transformPostfixExpression: function(tree) {
      var operand = this.transformAny(tree.operand);
      if (operand === tree.operand) {
        return tree;
      }
      return new PostfixExpression(tree.location, operand, tree.operator);
    },
    transformPredefinedType: function(tree) {
      return tree;
    },
    transformScript: function(tree) {
      var scriptItemList = this.transformList(tree.scriptItemList);
      if (scriptItemList === tree.scriptItemList) {
        return tree;
      }
      return new Script(tree.location, scriptItemList, tree.moduleName);
    },
    transformPropertyMethodAssignment: function(tree) {
      var name = this.transformAny(tree.name);
      var parameterList = this.transformAny(tree.parameterList);
      var typeAnnotation = this.transformAny(tree.typeAnnotation);
      var annotations = this.transformList(tree.annotations);
      var body = this.transformAny(tree.body);
      if (name === tree.name && parameterList === tree.parameterList && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body) {
        return tree;
      }
      return new PropertyMethodAssignment(tree.location, tree.isStatic, tree.functionKind, name, parameterList, typeAnnotation, annotations, body);
    },
    transformPropertyNameAssignment: function(tree) {
      var name = this.transformAny(tree.name);
      var value = this.transformAny(tree.value);
      if (name === tree.name && value === tree.value) {
        return tree;
      }
      return new PropertyNameAssignment(tree.location, name, value);
    },
    transformPropertyNameShorthand: function(tree) {
      return tree;
    },
    transformPropertyVariableDeclaration: function(tree) {
      var name = this.transformAny(tree.name);
      var typeAnnotation = this.transformAny(tree.typeAnnotation);
      var annotations = this.transformList(tree.annotations);
      if (name === tree.name && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations) {
        return tree;
      }
      return new PropertyVariableDeclaration(tree.location, tree.isStatic, name, typeAnnotation, annotations);
    },
    transformPropertySignature: function(tree) {
      var name = this.transformAny(tree.name);
      var typeAnnotation = this.transformAny(tree.typeAnnotation);
      if (name === tree.name && typeAnnotation === tree.typeAnnotation) {
        return tree;
      }
      return new PropertySignature(tree.location, name, tree.optional, typeAnnotation);
    },
    transformRestParameter: function(tree) {
      var identifier = this.transformAny(tree.identifier);
      var typeAnnotation = this.transformAny(tree.typeAnnotation);
      if (identifier === tree.identifier && typeAnnotation === tree.typeAnnotation) {
        return tree;
      }
      return new RestParameter(tree.location, identifier, typeAnnotation);
    },
    transformReturnStatement: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression) {
        return tree;
      }
      return new ReturnStatement(tree.location, expression);
    },
    transformSetAccessor: function(tree) {
      var name = this.transformAny(tree.name);
      var parameterList = this.transformAny(tree.parameterList);
      var annotations = this.transformList(tree.annotations);
      var body = this.transformAny(tree.body);
      if (name === tree.name && parameterList === tree.parameterList && annotations === tree.annotations && body === tree.body) {
        return tree;
      }
      return new SetAccessor(tree.location, tree.isStatic, name, parameterList, annotations, body);
    },
    transformSpreadExpression: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression) {
        return tree;
      }
      return new SpreadExpression(tree.location, expression);
    },
    transformSpreadPatternElement: function(tree) {
      var lvalue = this.transformAny(tree.lvalue);
      if (lvalue === tree.lvalue) {
        return tree;
      }
      return new SpreadPatternElement(tree.location, lvalue);
    },
    transformSuperExpression: function(tree) {
      return tree;
    },
    transformSwitchStatement: function(tree) {
      var expression = this.transformAny(tree.expression);
      var caseClauses = this.transformList(tree.caseClauses);
      if (expression === tree.expression && caseClauses === tree.caseClauses) {
        return tree;
      }
      return new SwitchStatement(tree.location, expression, caseClauses);
    },
    transformSyntaxErrorTree: function(tree) {
      return tree;
    },
    transformTemplateLiteralExpression: function(tree) {
      var operand = this.transformAny(tree.operand);
      var elements = this.transformList(tree.elements);
      if (operand === tree.operand && elements === tree.elements) {
        return tree;
      }
      return new TemplateLiteralExpression(tree.location, operand, elements);
    },
    transformTemplateLiteralPortion: function(tree) {
      return tree;
    },
    transformTemplateSubstitution: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression) {
        return tree;
      }
      return new TemplateSubstitution(tree.location, expression);
    },
    transformThisExpression: function(tree) {
      return tree;
    },
    transformThrowStatement: function(tree) {
      var value = this.transformAny(tree.value);
      if (value === tree.value) {
        return tree;
      }
      return new ThrowStatement(tree.location, value);
    },
    transformTryStatement: function(tree) {
      var body = this.transformAny(tree.body);
      var catchBlock = this.transformAny(tree.catchBlock);
      var finallyBlock = this.transformAny(tree.finallyBlock);
      if (body === tree.body && catchBlock === tree.catchBlock && finallyBlock === tree.finallyBlock) {
        return tree;
      }
      return new TryStatement(tree.location, body, catchBlock, finallyBlock);
    },
    transformTypeArguments: function(tree) {
      var args = this.transformList(tree.args);
      if (args === tree.args) {
        return tree;
      }
      return new TypeArguments(tree.location, args);
    },
    transformTypeName: function(tree) {
      var moduleName = this.transformAny(tree.moduleName);
      if (moduleName === tree.moduleName) {
        return tree;
      }
      return new TypeName(tree.location, moduleName, tree.name);
    },
    transformTypeParameter: function(tree) {
      var extendsType = this.transformAny(tree.extendsType);
      if (extendsType === tree.extendsType) {
        return tree;
      }
      return new TypeParameter(tree.location, tree.identifierToken, extendsType);
    },
    transformTypeParameters: function(tree) {
      var parameters = this.transformList(tree.parameters);
      if (parameters === tree.parameters) {
        return tree;
      }
      return new TypeParameters(tree.location, parameters);
    },
    transformTypeReference: function(tree) {
      var typeName = this.transformAny(tree.typeName);
      var args = this.transformAny(tree.args);
      if (typeName === tree.typeName && args === tree.args) {
        return tree;
      }
      return new TypeReference(tree.location, typeName, args);
    },
    transformUnaryExpression: function(tree) {
      var operand = this.transformAny(tree.operand);
      if (operand === tree.operand) {
        return tree;
      }
      return new UnaryExpression(tree.location, tree.operator, operand);
    },
    transformUnionType: function(tree) {
      var types = this.transformList(tree.types);
      if (types === tree.types) {
        return tree;
      }
      return new UnionType(tree.location, types);
    },
    transformVariableDeclaration: function(tree) {
      var lvalue = this.transformAny(tree.lvalue);
      var typeAnnotation = this.transformAny(tree.typeAnnotation);
      var initializer = this.transformAny(tree.initializer);
      if (lvalue === tree.lvalue && typeAnnotation === tree.typeAnnotation && initializer === tree.initializer) {
        return tree;
      }
      return new VariableDeclaration(tree.location, lvalue, typeAnnotation, initializer);
    },
    transformVariableDeclarationList: function(tree) {
      var declarations = this.transformList(tree.declarations);
      if (declarations === tree.declarations) {
        return tree;
      }
      return new VariableDeclarationList(tree.location, tree.declarationType, declarations);
    },
    transformVariableStatement: function(tree) {
      var declarations = this.transformAny(tree.declarations);
      if (declarations === tree.declarations) {
        return tree;
      }
      return new VariableStatement(tree.location, declarations);
    },
    transformWhileStatement: function(tree) {
      var condition = this.transformAny(tree.condition);
      var body = this.transformToBlockOrStatement(tree.body);
      if (condition === tree.condition && body === tree.body) {
        return tree;
      }
      return new WhileStatement(tree.location, condition, body);
    },
    transformWithStatement: function(tree) {
      var expression = this.transformAny(tree.expression);
      var body = this.transformToBlockOrStatement(tree.body);
      if (expression === tree.expression && body === tree.body) {
        return tree;
      }
      return new WithStatement(tree.location, expression, body);
    },
    transformYieldExpression: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression) {
        return tree;
      }
      return new YieldExpression(tree.location, expression, tree.isYieldFor);
    }
  }, {});
  return {get ParseTreeTransformer() {
      return ParseTreeTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/PlaceholderParser.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/PlaceholderParser.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      ARGUMENT_LIST = $__0.ARGUMENT_LIST,
      BLOCK = $__0.BLOCK,
      EXPRESSION_STATEMENT = $__0.EXPRESSION_STATEMENT,
      IDENTIFIER_EXPRESSION = $__0.IDENTIFIER_EXPRESSION;
  var IdentifierToken = System.get("traceur@0.0.80/src/syntax/IdentifierToken.js").IdentifierToken;
  var LiteralToken = System.get("traceur@0.0.80/src/syntax/LiteralToken.js").LiteralToken;
  var Map = System.get("traceur@0.0.80/src/runtime/polyfills/Map.js").Map;
  var CollectingErrorReporter = System.get("traceur@0.0.80/src/util/CollectingErrorReporter.js").CollectingErrorReporter;
  var Options = System.get("traceur@0.0.80/src/Options.js").Options;
  var ParseTree = System.get("traceur@0.0.80/src/syntax/trees/ParseTree.js").ParseTree;
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var Parser = System.get("traceur@0.0.80/src/syntax/Parser.js").Parser;
  var $__9 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      LiteralExpression = $__9.LiteralExpression,
      LiteralPropertyName = $__9.LiteralPropertyName,
      TypeName = $__9.TypeName;
  var SourceFile = System.get("traceur@0.0.80/src/syntax/SourceFile.js").SourceFile;
  var IDENTIFIER = System.get("traceur@0.0.80/src/syntax/TokenType.js").IDENTIFIER;
  var $__12 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createArrayLiteralExpression = $__12.createArrayLiteralExpression,
      createBindingIdentifier = $__12.createBindingIdentifier,
      createBlock = $__12.createBlock,
      createBooleanLiteral = $__12.createBooleanLiteral,
      createCommaExpression = $__12.createCommaExpression,
      createExpressionStatement = $__12.createExpressionStatement,
      createFunctionBody = $__12.createFunctionBody,
      createIdentifierExpression = $__12.createIdentifierExpression,
      createIdentifierToken = $__12.createIdentifierToken,
      createMemberExpression = $__12.createMemberExpression,
      createNullLiteral = $__12.createNullLiteral,
      createNumberLiteral = $__12.createNumberLiteral,
      createParenExpression = $__12.createParenExpression,
      createStringLiteral = $__12.createStringLiteral,
      createVoid0 = $__12.createVoid0;
  var NOT_FOUND = {};
  var cache = new Map();
  function makeParseFunction(doParse) {
    return (function(sourceLiterals) {
      for (var values = [],
          $__14 = 1; $__14 < arguments.length; $__14++)
        values[$__14 - 1] = arguments[$__14];
      return parse(sourceLiterals, values, doParse);
    });
  }
  var parseExpression = makeParseFunction((function(p) {
    return p.parseExpression();
  }));
  var parseStatement = makeParseFunction((function(p) {
    return p.parseStatement();
  }));
  var parseModule = makeParseFunction((function(p) {
    return p.parseModule();
  }));
  var parseScript = makeParseFunction((function(p) {
    return p.parseScript();
  }));
  var parseStatements = makeParseFunction((function(p) {
    return p.parseStatements();
  }));
  var parsePropertyDefinition = makeParseFunction((function(p) {
    return p.parsePropertyDefinition();
  }));
  function parse(sourceLiterals, values, doParse) {
    var tree = cache.get(sourceLiterals);
    if (!tree) {
      var source = insertPlaceholderIdentifiers(sourceLiterals);
      var errorReporter = new CollectingErrorReporter();
      var parser = getParser(source, errorReporter);
      tree = doParse(parser);
      if (errorReporter.hadError() || !tree || !parser.isAtEnd()) {
        throw new Error(("Internal error trying to parse:\n\n" + source + "\n\n" + errorReporter.errorsAsString()));
      }
      cache.set(sourceLiterals, tree);
    }
    if (!values.length)
      return tree;
    if (tree instanceof ParseTree)
      return new PlaceholderTransformer(values).transformAny(tree);
    return new PlaceholderTransformer(values).transformList(tree);
  }
  var PREFIX = '$__placeholder__';
  function insertPlaceholderIdentifiers(sourceLiterals) {
    var source = sourceLiterals[0];
    for (var i = 1; i < sourceLiterals.length; i++) {
      source += PREFIX + (i - 1) + sourceLiterals[i];
    }
    return source;
  }
  var counter = 0;
  function getParser(source, errorReporter) {
    var file = new SourceFile('@traceur/generated/TemplateParser/' + counter++, source);
    var options = new Options();
    options.experimental = true;
    var parser = new Parser(file, errorReporter, options);
    parser.allowYield = true;
    parser.allowAwait = true;
    return parser;
  }
  function convertValueToExpression(value) {
    if (value instanceof ParseTree)
      return value;
    if (value instanceof IdentifierToken)
      return createIdentifierExpression(value);
    if (value instanceof LiteralToken)
      return new LiteralExpression(value.location, value);
    if (Array.isArray(value)) {
      if (value[0] instanceof ParseTree) {
        if (value.length === 1)
          return value[0];
        if (value[0].isStatement())
          return createBlock(value);
        else
          return createParenExpression(createCommaExpression(value));
      }
      return createArrayLiteralExpression(value.map(convertValueToExpression));
    }
    if (value === null)
      return createNullLiteral();
    if (value === undefined)
      return createVoid0();
    switch (typeof value) {
      case 'string':
        return createStringLiteral(value);
      case 'boolean':
        return createBooleanLiteral(value);
      case 'number':
        return createNumberLiteral(value);
    }
    throw new Error('Not implemented');
  }
  function convertValueToIdentifierToken(value) {
    if (value instanceof IdentifierToken)
      return value;
    return createIdentifierToken(value);
  }
  function convertValueToType(value) {
    if (value === null)
      return null;
    if (value instanceof ParseTree)
      return value;
    if (typeof value === 'string') {
      return new TypeName(null, null, convertValueToIdentifierToken(value));
    }
    if (value instanceof IdentifierToken) {
      return new TypeName(null, null, value);
    }
    throw new Error('Not implemented');
  }
  var PlaceholderTransformer = function PlaceholderTransformer(values) {
    $traceurRuntime.superConstructor($PlaceholderTransformer).call(this);
    this.values = values;
  };
  var $PlaceholderTransformer = PlaceholderTransformer;
  ($traceurRuntime.createClass)(PlaceholderTransformer, {
    getValueAt: function(index) {
      return this.values[index];
    },
    getValue_: function(str) {
      if (str.indexOf(PREFIX) !== 0)
        return NOT_FOUND;
      return this.getValueAt(Number(str.slice(PREFIX.length)));
    },
    transformIdentifierExpression: function(tree) {
      var value = this.getValue_(tree.identifierToken.value);
      if (value === NOT_FOUND)
        return tree;
      return convertValueToExpression(value);
    },
    transformBindingIdentifier: function(tree) {
      var value = this.getValue_(tree.identifierToken.value);
      if (value === NOT_FOUND)
        return tree;
      return createBindingIdentifier(value);
    },
    transformExpressionStatement: function(tree) {
      if (tree.expression.type === IDENTIFIER_EXPRESSION) {
        var transformedExpression = this.transformIdentifierExpression(tree.expression);
        if (transformedExpression === tree.expression)
          return tree;
        if (transformedExpression.isStatement())
          return transformedExpression;
        return createExpressionStatement(transformedExpression);
      }
      return $traceurRuntime.superGet(this, $PlaceholderTransformer.prototype, "transformExpressionStatement").call(this, tree);
    },
    transformBlock: function(tree) {
      if (tree.statements.length === 1 && tree.statements[0].type === EXPRESSION_STATEMENT) {
        var transformedStatement = this.transformExpressionStatement(tree.statements[0]);
        if (transformedStatement === tree.statements[0])
          return tree;
        if (transformedStatement.type === BLOCK)
          return transformedStatement;
      }
      return $traceurRuntime.superGet(this, $PlaceholderTransformer.prototype, "transformBlock").call(this, tree);
    },
    transformFunctionBody: function(tree) {
      if (tree.statements.length === 1 && tree.statements[0].type === EXPRESSION_STATEMENT) {
        var transformedStatement = this.transformExpressionStatement(tree.statements[0]);
        if (transformedStatement === tree.statements[0])
          return tree;
        if (transformedStatement.type === BLOCK)
          return createFunctionBody(transformedStatement.statements);
      }
      return $traceurRuntime.superGet(this, $PlaceholderTransformer.prototype, "transformFunctionBody").call(this, tree);
    },
    transformMemberExpression: function(tree) {
      var value = this.getValue_(tree.memberName.value);
      if (value === NOT_FOUND)
        return $traceurRuntime.superGet(this, $PlaceholderTransformer.prototype, "transformMemberExpression").call(this, tree);
      var operand = this.transformAny(tree.operand);
      return createMemberExpression(operand, value);
    },
    transformLiteralPropertyName: function(tree) {
      if (tree.literalToken.type === IDENTIFIER) {
        var value = this.getValue_(tree.literalToken.value);
        if (value !== NOT_FOUND) {
          return new LiteralPropertyName(null, convertValueToIdentifierToken(value));
        }
      }
      return $traceurRuntime.superGet(this, $PlaceholderTransformer.prototype, "transformLiteralPropertyName").call(this, tree);
    },
    transformArgumentList: function(tree) {
      if (tree.args.length === 1 && tree.args[0].type === IDENTIFIER_EXPRESSION) {
        var arg0 = this.transformAny(tree.args[0]);
        if (arg0 === tree.args[0])
          return tree;
        if (arg0.type === ARGUMENT_LIST)
          return arg0;
      }
      return $traceurRuntime.superGet(this, $PlaceholderTransformer.prototype, "transformArgumentList").call(this, tree);
    },
    transformTypeName: function(tree) {
      var value = this.getValue_(tree.name.value);
      if (value === NOT_FOUND)
        return $traceurRuntime.superGet(this, $PlaceholderTransformer.prototype, "transformTypeName").call(this, tree);
      var moduleName = this.transformAny(tree.moduleName);
      if (moduleName !== null) {
        return new TypeName(null, moduleName, convertValueToIdentifierToken(value));
      }
      return convertValueToType(value);
    }
  }, {}, ParseTreeTransformer);
  return {
    get parseExpression() {
      return parseExpression;
    },
    get parseStatement() {
      return parseStatement;
    },
    get parseModule() {
      return parseModule;
    },
    get parseScript() {
      return parseScript;
    },
    get parseStatements() {
      return parseStatements;
    },
    get parsePropertyDefinition() {
      return parsePropertyDefinition;
    },
    get PlaceholderTransformer() {
      return PlaceholderTransformer;
    }
  };
});
System.registerModule("traceur@0.0.80/src/codegeneration/PrependStatements.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/PrependStatements.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      EXPRESSION_STATEMENT = $__0.EXPRESSION_STATEMENT,
      LITERAL_EXPRESSION = $__0.LITERAL_EXPRESSION;
  var STRING = System.get("traceur@0.0.80/src/syntax/TokenType.js").STRING;
  function isStringExpressionStatement(tree) {
    return tree.type === EXPRESSION_STATEMENT && tree.expression.type === LITERAL_EXPRESSION && tree.expression.literalToken.type === STRING;
  }
  function prependStatements(statements) {
    for (var statementsToPrepend = [],
        $__2 = 1; $__2 < arguments.length; $__2++)
      statementsToPrepend[$__2 - 1] = arguments[$__2];
    if (!statements.length)
      return statementsToPrepend;
    if (!statementsToPrepend.length)
      return statements;
    var transformed = [];
    var inProlog = true;
    statements.forEach((function(statement) {
      var $__3;
      if (inProlog && !isStringExpressionStatement(statement)) {
        ($__3 = transformed).push.apply($__3, $traceurRuntime.spread(statementsToPrepend));
        inProlog = false;
      }
      transformed.push(statement);
    }));
    return transformed;
  }
  return {get prependStatements() {
      return prependStatements;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/TempVarTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/TempVarTransformer.js";
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var $__1 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      Module = $__1.Module,
      Script = $__1.Script;
  var ARGUMENTS = System.get("traceur@0.0.80/src/syntax/PredefinedName.js").ARGUMENTS;
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var $__4 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createFunctionBody = $__4.createFunctionBody,
      createThisExpression = $__4.createThisExpression,
      createIdentifierExpression = $__4.createIdentifierExpression,
      createVariableDeclaration = $__4.createVariableDeclaration,
      createVariableDeclarationList = $__4.createVariableDeclarationList,
      createVariableStatement = $__4.createVariableStatement;
  var prependStatements = System.get("traceur@0.0.80/src/codegeneration/PrependStatements.js").prependStatements;
  var TempVarStatement = function TempVarStatement(name, initializer) {
    this.name = name;
    this.initializer = initializer;
  };
  ($traceurRuntime.createClass)(TempVarStatement, {}, {});
  var TempScope = function TempScope() {
    this.identifiers = [];
  };
  ($traceurRuntime.createClass)(TempScope, {
    push: function(identifier) {
      this.identifiers.push(identifier);
    },
    pop: function() {
      return this.identifiers.pop();
    },
    release: function(obj) {
      for (var i = this.identifiers.length - 1; i >= 0; i--) {
        obj.release_(this.identifiers[i]);
      }
    }
  }, {});
  var VarScope = function VarScope() {
    this.thisName = null;
    this.argumentName = null;
    this.tempVarStatements = [];
  };
  ($traceurRuntime.createClass)(VarScope, {
    push: function(tempVarStatement) {
      this.tempVarStatements.push(tempVarStatement);
    },
    pop: function() {
      return this.tempVarStatements.pop();
    },
    release: function(obj) {
      for (var i = this.tempVarStatements.length - 1; i >= 0; i--) {
        obj.release_(this.tempVarStatements[i].name);
      }
    },
    isEmpty: function() {
      return !this.tempVarStatements.length;
    },
    createVariableStatement: function() {
      var declarations = [];
      var seenNames = Object.create(null);
      for (var i = 0; i < this.tempVarStatements.length; i++) {
        var $__7 = this.tempVarStatements[i],
            name = $__7.name,
            initializer = $__7.initializer;
        if (name in seenNames) {
          if (seenNames[name].initializer || initializer)
            throw new Error('Invalid use of TempVarTransformer');
          continue;
        }
        seenNames[name] = true;
        declarations.push(createVariableDeclaration(name, initializer));
      }
      return createVariableStatement(createVariableDeclarationList(VAR, declarations));
    }
  }, {});
  var TempVarTransformer = function TempVarTransformer(identifierGenerator) {
    $traceurRuntime.superConstructor($TempVarTransformer).call(this);
    this.identifierGenerator = identifierGenerator;
    this.tempVarStack_ = [new VarScope()];
    this.tempScopeStack_ = [new TempScope()];
    this.namePool_ = [];
  };
  var $TempVarTransformer = TempVarTransformer;
  ($traceurRuntime.createClass)(TempVarTransformer, {
    transformStatements_: function(statements) {
      this.tempVarStack_.push(new VarScope());
      var transformedStatements = this.transformList(statements);
      var vars = this.tempVarStack_.pop();
      if (vars.isEmpty())
        return transformedStatements;
      var variableStatement = vars.createVariableStatement();
      vars.release(this);
      return prependStatements(transformedStatements, variableStatement);
    },
    transformScript: function(tree) {
      var scriptItemList = this.transformStatements_(tree.scriptItemList);
      if (scriptItemList == tree.scriptItemList) {
        return tree;
      }
      return new Script(tree.location, scriptItemList, tree.moduleName);
    },
    transformModule: function(tree) {
      var scriptItemList = this.transformStatements_(tree.scriptItemList);
      if (scriptItemList == tree.scriptItemList) {
        return tree;
      }
      return new Module(tree.location, scriptItemList, tree.moduleName);
    },
    transformFunctionBody: function(tree) {
      this.pushTempScope();
      var statements = this.transformStatements_(tree.statements);
      this.popTempScope();
      if (statements == tree.statements)
        return tree;
      return createFunctionBody(statements);
    },
    getTempIdentifier: function() {
      var name = this.getName_();
      this.tempScopeStack_[this.tempScopeStack_.length - 1].push(name);
      return name;
    },
    getName_: function() {
      return this.namePool_.length ? this.namePool_.pop() : this.identifierGenerator.generateUniqueIdentifier();
    },
    addTempVar: function() {
      var initializer = arguments[0] !== (void 0) ? arguments[0] : null;
      var vars = this.tempVarStack_[this.tempVarStack_.length - 1];
      var name = this.getName_();
      vars.push(new TempVarStatement(name, initializer));
      return name;
    },
    addTempVarForThis: function() {
      var varScope = this.tempVarStack_[this.tempVarStack_.length - 1];
      return varScope.thisName || (varScope.thisName = this.addTempVar(createThisExpression()));
    },
    addTempVarForArguments: function() {
      var varScope = this.tempVarStack_[this.tempVarStack_.length - 1];
      return varScope.argumentName || (varScope.argumentName = this.addTempVar(createIdentifierExpression(ARGUMENTS)));
    },
    pushTempScope: function() {
      this.tempScopeStack_.push(new TempScope());
    },
    popTempScope: function() {
      this.tempScopeStack_.pop().release(this);
    },
    release_: function(name) {
      this.namePool_.push(name);
    }
  }, {}, ParseTreeTransformer);
  return {get TempVarTransformer() {
      return TempVarTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/DestructuringTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/DestructuringTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["Array.prototype.slice.call(", ", ", ")"], {raw: {value: Object.freeze(["Array.prototype.slice.call(", ", ", ")"])}})),
      $__1 = Object.freeze(Object.defineProperties(["(", " = ", ".", ") === void 0 ?\n        ", " : ", ""], {raw: {value: Object.freeze(["(", " = ", ".", ") === void 0 ?\n        ", " : ", ""])}})),
      $__2 = Object.freeze(Object.defineProperties(["(", " = ", "[", "]) === void 0 ?\n        ", " : ", ""], {raw: {value: Object.freeze(["(", " = ", "[", "]) === void 0 ?\n        ", " : ", ""])}}));
  var $__3 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      ARRAY_LITERAL_EXPRESSION = $__3.ARRAY_LITERAL_EXPRESSION,
      ARRAY_PATTERN = $__3.ARRAY_PATTERN,
      ASSIGNMENT_ELEMENT = $__3.ASSIGNMENT_ELEMENT,
      BINDING_ELEMENT = $__3.BINDING_ELEMENT,
      BINDING_IDENTIFIER = $__3.BINDING_IDENTIFIER,
      BLOCK = $__3.BLOCK,
      CALL_EXPRESSION = $__3.CALL_EXPRESSION,
      COMPUTED_PROPERTY_NAME = $__3.COMPUTED_PROPERTY_NAME,
      IDENTIFIER_EXPRESSION = $__3.IDENTIFIER_EXPRESSION,
      LITERAL_EXPRESSION = $__3.LITERAL_EXPRESSION,
      MEMBER_EXPRESSION = $__3.MEMBER_EXPRESSION,
      MEMBER_LOOKUP_EXPRESSION = $__3.MEMBER_LOOKUP_EXPRESSION,
      OBJECT_LITERAL_EXPRESSION = $__3.OBJECT_LITERAL_EXPRESSION,
      OBJECT_PATTERN = $__3.OBJECT_PATTERN,
      OBJECT_PATTERN_FIELD = $__3.OBJECT_PATTERN_FIELD,
      PAREN_EXPRESSION = $__3.PAREN_EXPRESSION,
      VARIABLE_DECLARATION_LIST = $__3.VARIABLE_DECLARATION_LIST;
  var $__4 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AssignmentElement = $__4.AssignmentElement,
      BindingElement = $__4.BindingElement,
      Catch = $__4.Catch,
      ForInStatement = $__4.ForInStatement,
      ForOfStatement = $__4.ForOfStatement;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var $__6 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      EQUAL = $__6.EQUAL,
      LET = $__6.LET,
      VAR = $__6.VAR;
  var $__7 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createAssignmentExpression = $__7.createAssignmentExpression,
      createBindingIdentifier = $__7.createBindingIdentifier,
      createBlock = $__7.createBlock,
      createCommaExpression = $__7.createCommaExpression,
      createExpressionStatement = $__7.createExpressionStatement,
      createFunctionBody = $__7.createFunctionBody,
      createIdentifierExpression = $__7.createIdentifierExpression,
      createMemberExpression = $__7.createMemberExpression,
      createMemberLookupExpression = $__7.createMemberLookupExpression,
      createNumberLiteral = $__7.createNumberLiteral,
      createParenExpression = $__7.createParenExpression,
      createVariableDeclaration = $__7.createVariableDeclaration,
      createVariableDeclarationList = $__7.createVariableDeclarationList,
      createVariableStatement = $__7.createVariableStatement;
  var options = System.get("traceur@0.0.80/src/Options.js").options;
  var parseExpression = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseExpression;
  var prependStatements = System.get("traceur@0.0.80/src/codegeneration/PrependStatements.js").prependStatements;
  var Desugaring = function Desugaring(rvalue) {
    this.rvalue = rvalue;
  };
  ($traceurRuntime.createClass)(Desugaring, {}, {});
  var AssignmentExpressionDesugaring = function AssignmentExpressionDesugaring(rvalue) {
    $traceurRuntime.superConstructor($AssignmentExpressionDesugaring).call(this, rvalue);
    this.expressions = [];
  };
  var $AssignmentExpressionDesugaring = AssignmentExpressionDesugaring;
  ($traceurRuntime.createClass)(AssignmentExpressionDesugaring, {assign: function(lvalue, rvalue) {
      lvalue = lvalue instanceof AssignmentElement ? lvalue.assignment : lvalue;
      this.expressions.push(createAssignmentExpression(lvalue, rvalue));
    }}, {}, Desugaring);
  var VariableDeclarationDesugaring = function VariableDeclarationDesugaring(rvalue) {
    $traceurRuntime.superConstructor($VariableDeclarationDesugaring).call(this, rvalue);
    this.declarations = [];
  };
  var $VariableDeclarationDesugaring = VariableDeclarationDesugaring;
  ($traceurRuntime.createClass)(VariableDeclarationDesugaring, {assign: function(lvalue, rvalue) {
      var binding = lvalue instanceof BindingElement ? lvalue.binding : createBindingIdentifier(lvalue);
      this.declarations.push(createVariableDeclaration(binding, rvalue));
    }}, {}, Desugaring);
  var DestructuringTransformer = function DestructuringTransformer(identifierGenerator) {
    $traceurRuntime.superConstructor($DestructuringTransformer).call(this, identifierGenerator);
    this.parameterDeclarations = null;
  };
  var $DestructuringTransformer = DestructuringTransformer;
  ($traceurRuntime.createClass)(DestructuringTransformer, {
    transformArrayPattern: function(tree) {
      throw new Error('unreachable');
    },
    transformObjectPattern: function(tree) {
      throw new Error('unreachable');
    },
    transformBinaryExpression: function(tree) {
      this.pushTempScope();
      var rv;
      if (tree.operator.type == EQUAL && tree.left.isPattern()) {
        rv = this.transformAny(this.desugarAssignment_(tree.left, tree.right));
      } else {
        rv = $traceurRuntime.superGet(this, $DestructuringTransformer.prototype, "transformBinaryExpression").call(this, tree);
      }
      this.popTempScope();
      return rv;
    },
    desugarAssignment_: function(lvalue, rvalue) {
      var tempIdent = createIdentifierExpression(this.addTempVar());
      var desugaring = new AssignmentExpressionDesugaring(tempIdent);
      this.desugarPattern_(desugaring, lvalue);
      desugaring.expressions.unshift(createAssignmentExpression(tempIdent, rvalue));
      desugaring.expressions.push(tempIdent);
      return createParenExpression(createCommaExpression(desugaring.expressions));
    },
    transformVariableDeclarationList: function(tree) {
      var $__11 = this;
      if (!this.destructuringInDeclaration_(tree)) {
        return $traceurRuntime.superGet(this, $DestructuringTransformer.prototype, "transformVariableDeclarationList").call(this, tree);
      }
      var desugaredDeclarations = [];
      tree.declarations.forEach((function(declaration) {
        var $__13;
        if (declaration.lvalue.isPattern()) {
          ($__13 = desugaredDeclarations).push.apply($__13, $traceurRuntime.spread($__11.desugarVariableDeclaration_(declaration)));
        } else {
          desugaredDeclarations.push(declaration);
        }
      }));
      var transformedTree = this.transformVariableDeclarationList(createVariableDeclarationList(tree.declarationType, desugaredDeclarations));
      return transformedTree;
    },
    transformForInStatement: function(tree) {
      return this.transformForInOrOf_(tree, $traceurRuntime.superGet(this, $DestructuringTransformer.prototype, "transformForInStatement"), ForInStatement);
    },
    transformForOfStatement: function(tree) {
      return this.transformForInOrOf_(tree, $traceurRuntime.superGet(this, $DestructuringTransformer.prototype, "transformForOfStatement"), ForOfStatement);
    },
    transformForInOrOf_: function(tree, superMethod, constr) {
      var $__13;
      if (!tree.initializer.isPattern() && (tree.initializer.type !== VARIABLE_DECLARATION_LIST || !this.destructuringInDeclaration_(tree.initializer))) {
        return superMethod.call(this, tree);
      }
      this.pushTempScope();
      var declarationType,
          lvalue;
      if (tree.initializer.isPattern()) {
        declarationType = null;
        lvalue = tree.initializer;
      } else {
        declarationType = tree.initializer.declarationType;
        lvalue = tree.initializer.declarations[0].lvalue;
      }
      var statements = [];
      var binding = this.desugarBinding_(lvalue, statements, declarationType);
      var initializer = createVariableDeclarationList(VAR, binding, null);
      var collection = this.transformAny(tree.collection);
      var body = this.transformAny(tree.body);
      if (body.type === BLOCK)
        ($__13 = statements).push.apply($__13, $traceurRuntime.spread(body.statements));
      else
        statements.push(body);
      body = createBlock(statements);
      this.popTempScope();
      return new constr(tree.location, initializer, collection, body);
    },
    transformAssignmentElement: function(tree) {
      throw new Error('unreachable');
    },
    transformBindingElement: function(tree) {
      if (!tree.binding.isPattern() || tree.initializer)
        return tree;
      if (this.parameterDeclarations === null) {
        this.parameterDeclarations = [];
        this.pushTempScope();
      }
      var varName = this.getTempIdentifier();
      var binding = createBindingIdentifier(varName);
      var initializer = createIdentifierExpression(varName);
      var decl = createVariableDeclaration(tree.binding, initializer);
      this.parameterDeclarations.push(decl);
      return new BindingElement(null, binding, null);
    },
    transformFunctionBody: function(tree) {
      if (this.parameterDeclarations === null)
        return $traceurRuntime.superGet(this, $DestructuringTransformer.prototype, "transformFunctionBody").call(this, tree);
      var list = createVariableDeclarationList(VAR, this.parameterDeclarations);
      var statement = createVariableStatement(list);
      var statements = prependStatements(tree.statements, statement);
      var newBody = createFunctionBody(statements);
      this.parameterDeclarations = null;
      var result = $traceurRuntime.superGet(this, $DestructuringTransformer.prototype, "transformFunctionBody").call(this, newBody);
      this.popTempScope();
      return result;
    },
    transformCatch: function(tree) {
      var $__13;
      if (!tree.binding.isPattern())
        return $traceurRuntime.superGet(this, $DestructuringTransformer.prototype, "transformCatch").call(this, tree);
      var body = this.transformAny(tree.catchBody);
      var statements = [];
      var kind = options.blockBinding ? LET : VAR;
      var binding = this.desugarBinding_(tree.binding, statements, kind);
      ($__13 = statements).push.apply($__13, $traceurRuntime.spread(body.statements));
      return new Catch(tree.location, binding, createBlock(statements));
    },
    desugarBinding_: function(bindingTree, statements, declarationType) {
      var varName = this.getTempIdentifier();
      var binding = createBindingIdentifier(varName);
      var idExpr = createIdentifierExpression(varName);
      var desugaring;
      if (declarationType === null)
        desugaring = new AssignmentExpressionDesugaring(idExpr);
      else
        desugaring = new VariableDeclarationDesugaring(idExpr);
      this.desugarPattern_(desugaring, bindingTree);
      if (declarationType === null) {
        statements.push(createExpressionStatement(createCommaExpression(desugaring.expressions)));
      } else {
        statements.push(createVariableStatement(this.transformVariableDeclarationList(createVariableDeclarationList(declarationType, desugaring.declarations))));
      }
      return binding;
    },
    destructuringInDeclaration_: function(tree) {
      return tree.declarations.some((function(declaration) {
        return declaration.lvalue.isPattern();
      }));
    },
    desugarVariableDeclaration_: function(tree) {
      var tempRValueName = this.getTempIdentifier();
      var tempRValueIdent = createIdentifierExpression(tempRValueName);
      var desugaring;
      var initializer;
      switch (tree.initializer.type) {
        case ARRAY_LITERAL_EXPRESSION:
        case CALL_EXPRESSION:
        case IDENTIFIER_EXPRESSION:
        case LITERAL_EXPRESSION:
        case MEMBER_EXPRESSION:
        case MEMBER_LOOKUP_EXPRESSION:
        case OBJECT_LITERAL_EXPRESSION:
        case PAREN_EXPRESSION:
          initializer = tree.initializer;
        default:
          desugaring = new VariableDeclarationDesugaring(tempRValueIdent);
          desugaring.assign(desugaring.rvalue, tree.initializer);
          var initializerFound = this.desugarPattern_(desugaring, tree.lvalue);
          if (initializerFound || desugaring.declarations.length > 2) {
            return desugaring.declarations;
          }
          if (!initializer) {
            initializer = createParenExpression(tree.initializer);
          }
          desugaring = new VariableDeclarationDesugaring(initializer);
          this.desugarPattern_(desugaring, tree.lvalue);
          return desugaring.declarations;
      }
    },
    desugarPattern_: function(desugaring, tree) {
      var $__11 = this;
      var initializerFound = false;
      switch (tree.type) {
        case ARRAY_PATTERN:
          var pattern = tree;
          for (var i = 0; i < pattern.elements.length; i++) {
            var lvalue = pattern.elements[i];
            if (lvalue === null) {
              continue;
            } else if (lvalue.isSpreadPatternElement()) {
              desugaring.assign(lvalue.lvalue, parseExpression($__0, desugaring.rvalue, i));
            } else {
              if (lvalue.initializer)
                initializerFound = true;
              desugaring.assign(lvalue, this.createConditionalMemberLookupExpression(desugaring.rvalue, createNumberLiteral(i), lvalue.initializer));
            }
          }
          break;
        case OBJECT_PATTERN:
          var pattern = tree;
          var elementHelper = (function(lvalue, initializer) {
            if (initializer)
              initializerFound = true;
            var lookup = $__11.createConditionalMemberExpression(desugaring.rvalue, lvalue, initializer);
            desugaring.assign(lvalue, lookup);
          });
          pattern.fields.forEach((function(field) {
            var lookup;
            switch (field.type) {
              case ASSIGNMENT_ELEMENT:
                elementHelper(field.assignment, field.initializer);
                break;
              case BINDING_ELEMENT:
                elementHelper(field.binding, field.initializer);
                break;
              case OBJECT_PATTERN_FIELD:
                if (field.element.initializer)
                  initializerFound = true;
                var name = field.name;
                lookup = $__11.createConditionalMemberExpression(desugaring.rvalue, name, field.element.initializer);
                desugaring.assign(field.element, lookup);
                break;
              default:
                throw Error('unreachable');
            }
          }));
          break;
        case PAREN_EXPRESSION:
          return this.desugarPattern_(desugaring, tree.expression);
        default:
          throw new Error('unreachable');
      }
      if (desugaring instanceof VariableDeclarationDesugaring && desugaring.declarations.length === 0) {
        desugaring.assign(createBindingIdentifier(this.getTempIdentifier()), desugaring.rvalue);
      }
      return initializerFound;
    },
    createConditionalMemberExpression: function(rvalue, name, initializer) {
      if (name.type === COMPUTED_PROPERTY_NAME) {
        return this.createConditionalMemberLookupExpression(rvalue, name.expression, initializer);
      }
      var token;
      switch (name.type) {
        case BINDING_IDENTIFIER:
        case IDENTIFIER_EXPRESSION:
          token = name.identifierToken;
          break;
        default:
          token = name.literalToken;
      }
      if (!initializer)
        return createMemberExpression(rvalue, token);
      var tempIdent = createIdentifierExpression(this.addTempVar());
      return parseExpression($__1, tempIdent, rvalue, token, initializer, tempIdent);
    },
    createConditionalMemberLookupExpression: function(rvalue, index, initializer) {
      if (!initializer)
        return createMemberLookupExpression(rvalue, index);
      var tempIdent = createIdentifierExpression(this.addTempVar());
      return parseExpression($__2, tempIdent, rvalue, index, initializer, tempIdent);
    }
  }, {}, TempVarTransformer);
  return {get DestructuringTransformer() {
      return DestructuringTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/module/ModuleSymbol.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/module/ModuleSymbol.js";
  var assert = System.get("traceur@0.0.80/src/util/assert.js").assert;
  var ExportsList = function ExportsList(normalizedName) {
    this.exports_ = Object.create(null);
    if (normalizedName !== null)
      this.normalizedName = normalizedName.replace(/\\/g, '/');
    else
      this.normalizedName = null;
  };
  ($traceurRuntime.createClass)(ExportsList, {
    addExport: function(name, tree) {
      assert(!this.exports_[name]);
      this.exports_[name] = tree;
    },
    getExport: function(name) {
      return this.exports_[name];
    },
    getExports: function() {
      return Object.keys(this.exports_);
    },
    addExportsFromModule: function(module) {
      var $__1 = this;
      Object.getOwnPropertyNames(module).forEach((function(name) {
        $__1.addExport(name, true);
      }));
    }
  }, {});
  var ModuleSymbol = function ModuleSymbol(tree, normalizedName) {
    $traceurRuntime.superConstructor($ModuleSymbol).call(this, normalizedName);
    this.tree = tree;
    this.imports_ = Object.create(null);
  };
  var $ModuleSymbol = ModuleSymbol;
  ($traceurRuntime.createClass)(ModuleSymbol, {
    addImport: function(name, tree) {
      assert(!this.imports_[name]);
      this.imports_[name] = tree;
    },
    getImport: function(name) {
      return this.imports_[name];
    }
  }, {}, ExportsList);
  return {
    get ExportsList() {
      return ExportsList;
    },
    get ModuleSymbol() {
      return ModuleSymbol;
    }
  };
});
System.registerModule("traceur@0.0.80/src/codegeneration/module/ModuleVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/module/ModuleVisitor.js";
  var ExportsList = System.get("traceur@0.0.80/src/codegeneration/module/ModuleSymbol.js").ExportsList;
  var ParseTreeVisitor = System.get("traceur@0.0.80/src/syntax/ParseTreeVisitor.js").ParseTreeVisitor;
  var $__2 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      MODULE_DECLARATION = $__2.MODULE_DECLARATION,
      EXPORT_DECLARATION = $__2.EXPORT_DECLARATION,
      IMPORT_DECLARATION = $__2.IMPORT_DECLARATION;
  var ModuleVisitor = function ModuleVisitor(reporter, loader, moduleSymbol) {
    this.reporter = reporter;
    this.loader_ = loader;
    this.moduleSymbol = moduleSymbol;
  };
  ($traceurRuntime.createClass)(ModuleVisitor, {
    getExportsListForModuleSpecifier: function(name) {
      var referrer = this.moduleSymbol.normalizedName;
      return this.loader_.getExportsListForModuleSpecifier(name, referrer);
    },
    visitFunctionDeclaration: function(tree) {},
    visitFunctionExpression: function(tree) {},
    visitFunctionBody: function(tree) {},
    visitBlock: function(tree) {},
    visitClassDeclaration: function(tree) {},
    visitClassExpression: function(tree) {},
    visitModuleElement_: function(element) {
      switch (element.type) {
        case MODULE_DECLARATION:
        case EXPORT_DECLARATION:
        case IMPORT_DECLARATION:
          this.visitAny(element);
      }
    },
    visitScript: function(tree) {
      tree.scriptItemList.forEach(this.visitModuleElement_, this);
    },
    visitModule: function(tree) {
      tree.scriptItemList.forEach(this.visitModuleElement_, this);
    },
    reportError: function(tree, message) {
      this.reporter.reportError(tree.location.start, message);
    }
  }, {}, ParseTreeVisitor);
  return {get ModuleVisitor() {
      return ModuleVisitor;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/module/ExportVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/module/ExportVisitor.js";
  var ModuleVisitor = System.get("traceur@0.0.80/src/codegeneration/module/ModuleVisitor.js").ModuleVisitor;
  var assert = System.get("traceur@0.0.80/src/util/assert.js").assert;
  var ExportVisitor = function ExportVisitor(reporter, loader, moduleSymbol) {
    $traceurRuntime.superConstructor($ExportVisitor).call(this, reporter, loader, moduleSymbol);
    this.inExport_ = false;
    this.moduleSpecifier = null;
  };
  var $ExportVisitor = ExportVisitor;
  ($traceurRuntime.createClass)(ExportVisitor, {
    addExport_: function(name, tree) {
      assert(typeof name == 'string');
      if (this.inExport_)
        this.addExport(name, tree);
    },
    addExport: function(name, tree) {
      var moduleSymbol = this.moduleSymbol;
      var existingExport = moduleSymbol.getExport(name);
      if (existingExport) {
        this.reportError(tree, ("Duplicate export. '" + name + "' was previously ") + ("exported at " + existingExport.location.start));
      } else {
        moduleSymbol.addExport(name, tree);
      }
    },
    visitClassDeclaration: function(tree) {
      this.addExport_(tree.name.identifierToken.value, tree);
    },
    visitExportDeclaration: function(tree) {
      this.inExport_ = true;
      this.visitAny(tree.declaration);
      this.inExport_ = false;
    },
    visitNamedExport: function(tree) {
      this.moduleSpecifier = tree.moduleSpecifier;
      this.visitAny(tree.specifierSet);
      this.moduleSpecifier = null;
    },
    visitExportDefault: function(tree) {
      this.addExport_('default', tree);
    },
    visitExportSpecifier: function(tree) {
      this.addExport_((tree.rhs || tree.lhs).value, tree);
    },
    visitExportStar: function(tree) {
      var $__2 = this;
      var name = this.moduleSpecifier.token.processedValue;
      var exportList = this.getExportsListForModuleSpecifier(name);
      if (exportList) {
        exportList.getExports().forEach((function(name) {
          return $__2.addExport(name, tree);
        }));
      }
    },
    visitFunctionDeclaration: function(tree) {
      this.addExport_(tree.name.getStringValue(), tree);
    },
    visitModuleDeclaration: function(tree) {
      var name = tree.binding.getStringValue();
      this.addExport_(name, tree);
    },
    visitVariableDeclaration: function(tree) {
      this.addExport_(tree.lvalue.getStringValue(), tree);
    }
  }, {}, ModuleVisitor);
  return {get ExportVisitor() {
      return ExportVisitor;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/module/DirectExportVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/module/DirectExportVisitor.js";
  var ExportVisitor = System.get("traceur@0.0.80/src/codegeneration/module/ExportVisitor.js").ExportVisitor;
  var DirectExportVisitor = function DirectExportVisitor() {
    $traceurRuntime.superConstructor($DirectExportVisitor).call(this, null, null, null);
    this.namedExports = [];
    this.starExports = [];
  };
  var $DirectExportVisitor = DirectExportVisitor;
  ($traceurRuntime.createClass)(DirectExportVisitor, {
    addExport: function(name, tree) {
      this.namedExports.push({
        name: name,
        tree: tree,
        moduleSpecifier: this.moduleSpecifier
      });
    },
    visitExportStar: function(tree) {
      this.starExports.push(this.moduleSpecifier);
    },
    hasExports: function() {
      return this.namedExports.length != 0 || this.starExports.length != 0;
    }
  }, {}, ExportVisitor);
  return {get DirectExportVisitor() {
      return DirectExportVisitor;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ModuleTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ModuleTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["var __moduleName = ", ";"], {raw: {value: Object.freeze(["var __moduleName = ", ";"])}})),
      $__1 = Object.freeze(Object.defineProperties(["function(require) {\n        ", "\n      }"], {raw: {value: Object.freeze(["function(require) {\n        ", "\n      }"])}})),
      $__2 = Object.freeze(Object.defineProperties(["function() {\n        ", "\n      }"], {raw: {value: Object.freeze(["function() {\n        ", "\n      }"])}})),
      $__3 = Object.freeze(Object.defineProperties(["$traceurRuntime.ModuleStore.getAnonymousModule(\n              ", ");"], {raw: {value: Object.freeze(["$traceurRuntime.ModuleStore.getAnonymousModule(\n              ", ");"])}})),
      $__4 = Object.freeze(Object.defineProperties(["System.registerModule(", ", [], ", ");"], {raw: {value: Object.freeze(["System.registerModule(", ", [], ", ");"])}})),
      $__5 = Object.freeze(Object.defineProperties(["get ", "() { return ", "; }"], {raw: {value: Object.freeze(["get ", "() { return ", "; }"])}})),
      $__6 = Object.freeze(Object.defineProperties(["$traceurRuntime.exportStar(", ")"], {raw: {value: Object.freeze(["$traceurRuntime.exportStar(", ")"])}})),
      $__7 = Object.freeze(Object.defineProperties(["return ", ""], {raw: {value: Object.freeze(["return ", ""])}})),
      $__8 = Object.freeze(Object.defineProperties(["var $__default = ", ""], {raw: {value: Object.freeze(["var $__default = ", ""])}})),
      $__9 = Object.freeze(Object.defineProperties(["var $__default = ", ""], {raw: {value: Object.freeze(["var $__default = ", ""])}})),
      $__10 = Object.freeze(Object.defineProperties(["System.get(", ")"], {raw: {value: Object.freeze(["System.get(", ")"])}}));
  var $__11 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AnonBlock = $__11.AnonBlock,
      BindingElement = $__11.BindingElement,
      EmptyStatement = $__11.EmptyStatement,
      LiteralPropertyName = $__11.LiteralPropertyName,
      ObjectPattern = $__11.ObjectPattern,
      ObjectPatternField = $__11.ObjectPatternField,
      Script = $__11.Script;
  var DestructuringTransformer = System.get("traceur@0.0.80/src/codegeneration/DestructuringTransformer.js").DestructuringTransformer;
  var DirectExportVisitor = System.get("traceur@0.0.80/src/codegeneration/module/DirectExportVisitor.js").DirectExportVisitor;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var $__15 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      CLASS_DECLARATION = $__15.CLASS_DECLARATION,
      EXPORT_DEFAULT = $__15.EXPORT_DEFAULT,
      EXPORT_SPECIFIER = $__15.EXPORT_SPECIFIER,
      FUNCTION_DECLARATION = $__15.FUNCTION_DECLARATION,
      IMPORT_SPECIFIER_SET = $__15.IMPORT_SPECIFIER_SET;
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var assert = System.get("traceur@0.0.80/src/util/assert.js").assert;
  var $__18 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createArgumentList = $__18.createArgumentList,
      createExpressionStatement = $__18.createExpressionStatement,
      createIdentifierExpression = $__18.createIdentifierExpression,
      createIdentifierToken = $__18.createIdentifierToken,
      createMemberExpression = $__18.createMemberExpression,
      createObjectLiteralExpression = $__18.createObjectLiteralExpression,
      createUseStrictDirective = $__18.createUseStrictDirective,
      createVariableStatement = $__18.createVariableStatement;
  var $__19 = System.get("traceur@0.0.80/src/Options.js"),
      parseOptions = $__19.parseOptions,
      transformOptions = $__19.transformOptions;
  var $__20 = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js"),
      parseExpression = $__20.parseExpression,
      parsePropertyDefinition = $__20.parsePropertyDefinition,
      parseStatement = $__20.parseStatement,
      parseStatements = $__20.parseStatements;
  var DestructImportVarStatement = function DestructImportVarStatement() {
    $traceurRuntime.superConstructor($DestructImportVarStatement).apply(this, arguments);
  };
  var $DestructImportVarStatement = DestructImportVarStatement;
  ($traceurRuntime.createClass)(DestructImportVarStatement, {createGuardedExpression: function(tree) {
      return tree;
    }}, {}, DestructuringTransformer);
  var ModuleTransformer = function ModuleTransformer(identifierGenerator) {
    $traceurRuntime.superConstructor($ModuleTransformer).call(this, identifierGenerator);
    this.exportVisitor_ = new DirectExportVisitor();
    this.moduleSpecifierKind_ = null;
    this.moduleName = null;
  };
  var $ModuleTransformer = ModuleTransformer;
  ($traceurRuntime.createClass)(ModuleTransformer, {
    getTempVarNameForModuleName: function(moduleName) {
      return '$__' + moduleName.replace(/[^a-zA-Z0-9$]/g, function(c) {
        return '_' + c.charCodeAt(0) + '_';
      }) + '__';
    },
    getTempVarNameForModuleSpecifier: function(moduleSpecifier) {
      var normalizedName = System.normalize(moduleSpecifier.token.processedValue, this.moduleName);
      return this.getTempVarNameForModuleName(normalizedName);
    },
    transformScript: function(tree) {
      this.moduleName = tree.moduleName;
      return $traceurRuntime.superGet(this, $ModuleTransformer.prototype, "transformScript").call(this, tree);
    },
    transformModule: function(tree) {
      this.moduleName = tree.moduleName;
      this.pushTempScope();
      var statements = this.transformList(tree.scriptItemList);
      statements = this.appendExportStatement(statements);
      this.popTempScope();
      statements = this.wrapModule(this.moduleProlog().concat(statements));
      return new Script(tree.location, statements);
    },
    moduleProlog: function() {
      var statements = [createUseStrictDirective()];
      if (this.moduleName) {
        statements.push(parseStatement($__0, this.moduleName));
      }
      return statements;
    },
    wrapModule: function(statements) {
      var functionExpression;
      if (transformOptions.require) {
        functionExpression = parseExpression($__1, statements);
      } else {
        functionExpression = parseExpression($__2, statements);
      }
      if (this.moduleName === null) {
        return parseStatements($__3, functionExpression);
      }
      return parseStatements($__4, this.moduleName, functionExpression);
    },
    getGetterExport: function($__23) {
      var $__24 = $__23,
          name = $__24.name,
          tree = $__24.tree,
          moduleSpecifier = $__24.moduleSpecifier;
      var returnExpression;
      switch (tree.type) {
        case EXPORT_DEFAULT:
          returnExpression = createIdentifierExpression('$__default');
          break;
        case EXPORT_SPECIFIER:
          if (moduleSpecifier) {
            var idName = this.getTempVarNameForModuleSpecifier(moduleSpecifier);
            returnExpression = createMemberExpression(idName, tree.lhs);
          } else {
            returnExpression = createIdentifierExpression(tree.lhs);
          }
          break;
        default:
          returnExpression = createIdentifierExpression(name);
          break;
      }
      return parsePropertyDefinition($__5, name, returnExpression);
    },
    getExportProperties: function() {
      var $__21 = this;
      return this.exportVisitor_.namedExports.map((function(exp) {
        return $__21.getGetterExport(exp);
      })).concat(this.exportVisitor_.namedExports.map((function(exp) {
        return $__21.getSetterExport(exp);
      }))).filter((function(e) {
        return e;
      }));
    },
    getSetterExport: function($__23) {
      var $__24 = $__23,
          name = $__24.name,
          tree = $__24.tree,
          moduleSpecifier = $__24.moduleSpecifier;
      return null;
    },
    getExportObject: function() {
      var $__21 = this;
      var exportObject = createObjectLiteralExpression(this.getExportProperties());
      if (this.exportVisitor_.starExports.length) {
        var starExports = this.exportVisitor_.starExports;
        var starIdents = starExports.map((function(moduleSpecifier) {
          return createIdentifierExpression($__21.getTempVarNameForModuleSpecifier(moduleSpecifier));
        }));
        var args = createArgumentList($traceurRuntime.spread([exportObject], starIdents));
        return parseExpression($__6, args);
      }
      return exportObject;
    },
    appendExportStatement: function(statements) {
      var exportObject = this.getExportObject();
      statements.push(parseStatement($__7, exportObject));
      return statements;
    },
    hasExports: function() {
      return this.exportVisitor_.hasExports();
    },
    transformExportDeclaration: function(tree) {
      this.exportVisitor_.visitAny(tree);
      return this.transformAny(tree.declaration);
    },
    transformExportDefault: function(tree) {
      switch (tree.expression.type) {
        case CLASS_DECLARATION:
        case FUNCTION_DECLARATION:
          var nameBinding = tree.expression.name;
          var name = createIdentifierExpression(nameBinding.identifierToken);
          return new AnonBlock(null, [tree.expression, parseStatement($__8, name)]);
      }
      return parseStatement($__9, tree.expression);
    },
    transformNamedExport: function(tree) {
      var moduleSpecifier = tree.moduleSpecifier;
      if (moduleSpecifier) {
        var expression = this.transformAny(moduleSpecifier);
        var idName = this.getTempVarNameForModuleSpecifier(moduleSpecifier);
        return createVariableStatement(VAR, idName, expression);
      }
      return new EmptyStatement(null);
    },
    transformModuleSpecifier: function(tree) {
      assert(this.moduleName);
      var name = tree.token.processedValue;
      var normalizedName = System.normalize(name, this.moduleName);
      return parseExpression($__10, normalizedName);
    },
    transformModuleDeclaration: function(tree) {
      this.moduleSpecifierKind_ = 'module';
      var initializer = this.transformAny(tree.expression);
      var bindingIdentifier = tree.binding.binding;
      return createVariableStatement(VAR, bindingIdentifier, initializer);
    },
    transformImportedBinding: function(tree) {
      var bindingElement = new BindingElement(tree.location, tree.binding, null);
      var name = new LiteralPropertyName(null, createIdentifierToken('default'));
      return new ObjectPattern(null, [new ObjectPatternField(null, name, bindingElement)]);
    },
    transformImportDeclaration: function(tree) {
      this.moduleSpecifierKind_ = 'import';
      if (!tree.importClause || (tree.importClause.type === IMPORT_SPECIFIER_SET && tree.importClause.specifiers.length === 0)) {
        return createExpressionStatement(this.transformAny(tree.moduleSpecifier));
      }
      var binding = this.transformAny(tree.importClause);
      var initializer = this.transformAny(tree.moduleSpecifier);
      var varStatement = createVariableStatement(VAR, binding, initializer);
      if (transformOptions.destructuring || !parseOptions.destructuring) {
        var destructuringTransformer = new DestructImportVarStatement(this.identifierGenerator);
        varStatement = varStatement.transform(destructuringTransformer);
      }
      return varStatement;
    },
    transformImportSpecifierSet: function(tree) {
      var fields = this.transformList(tree.specifiers);
      return new ObjectPattern(null, fields);
    },
    transformImportSpecifier: function(tree) {
      var binding = tree.binding.binding;
      var bindingElement = new BindingElement(binding.location, binding, null);
      if (tree.name) {
        var name = new LiteralPropertyName(tree.name.location, tree.name);
        return new ObjectPatternField(tree.location, name, bindingElement);
      }
      return bindingElement;
    }
  }, {}, TempVarTransformer);
  return {get ModuleTransformer() {
      return ModuleTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/globalThis.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/globalThis.js";
  var $__0 = Object.freeze(Object.defineProperties(["Reflect.global"], {raw: {value: Object.freeze(["Reflect.global"])}}));
  var parseExpression = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseExpression;
  var expr;
  function globalThis() {
    if (!expr)
      expr = parseExpression($__0);
    return expr;
  }
  var $__default = globalThis;
  return {get default() {
      return $__default;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/FindInFunctionScope.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/FindInFunctionScope.js";
  var FindVisitor = System.get("traceur@0.0.80/src/codegeneration/FindVisitor.js").FindVisitor;
  var FindInFunctionScope = function FindInFunctionScope() {
    $traceurRuntime.superConstructor($FindInFunctionScope).apply(this, arguments);
  };
  var $FindInFunctionScope = FindInFunctionScope;
  ($traceurRuntime.createClass)(FindInFunctionScope, {
    visitFunctionDeclaration: function(tree) {},
    visitFunctionExpression: function(tree) {},
    visitSetAccessor: function(tree) {},
    visitGetAccessor: function(tree) {},
    visitPropertyMethodAssignment: function(tree) {}
  }, {}, FindVisitor);
  return {get FindInFunctionScope() {
      return FindInFunctionScope;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/scopeContainsThis.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/scopeContainsThis.js";
  var FindInFunctionScope = System.get("traceur@0.0.80/src/codegeneration/FindInFunctionScope.js").FindInFunctionScope;
  var FindThis = function FindThis() {
    $traceurRuntime.superConstructor($FindThis).apply(this, arguments);
  };
  var $FindThis = FindThis;
  ($traceurRuntime.createClass)(FindThis, {visitThisExpression: function(tree) {
      this.found = true;
    }}, {}, FindInFunctionScope);
  function scopeContainsThis(tree) {
    var visitor = new FindThis();
    visitor.visitAny(tree);
    return visitor.found;
  }
  var $__default = scopeContainsThis;
  return {get default() {
      return $__default;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/AmdTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/AmdTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["__esModule: true"], {raw: {value: Object.freeze(["__esModule: true"])}})),
      $__1 = Object.freeze(Object.defineProperties(["if (!", " || !", ".__esModule)\n            ", " = {default: ", "}"], {raw: {value: Object.freeze(["if (!", " || !", ".__esModule)\n            ", " = {default: ", "}"])}})),
      $__2 = Object.freeze(Object.defineProperties(["function(", ") {\n      ", "\n    }"], {raw: {value: Object.freeze(["function(", ") {\n      ", "\n    }"])}})),
      $__3 = Object.freeze(Object.defineProperties(["", ".bind(", ")"], {raw: {value: Object.freeze(["", ".bind(", ")"])}})),
      $__4 = Object.freeze(Object.defineProperties(["define(", ", ", ", ", ");"], {raw: {value: Object.freeze(["define(", ", ", ", ", ");"])}})),
      $__5 = Object.freeze(Object.defineProperties(["define(", ", ", ");"], {raw: {value: Object.freeze(["define(", ", ", ");"])}}));
  var ModuleTransformer = System.get("traceur@0.0.80/src/codegeneration/ModuleTransformer.js").ModuleTransformer;
  var $__7 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createIdentifierExpression = $__7.createIdentifierExpression,
      createStringLiteralToken = $__7.createStringLiteralToken;
  var globalThis = System.get("traceur@0.0.80/src/codegeneration/globalThis.js").default;
  var $__9 = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js"),
      parseExpression = $__9.parseExpression,
      parseStatement = $__9.parseStatement,
      parseStatements = $__9.parseStatements,
      parsePropertyDefinition = $__9.parsePropertyDefinition;
  var scopeContainsThis = System.get("traceur@0.0.80/src/codegeneration/scopeContainsThis.js").default;
  var AmdTransformer = function AmdTransformer(identifierGenerator) {
    $traceurRuntime.superConstructor($AmdTransformer).call(this, identifierGenerator);
    this.dependencies = [];
  };
  var $AmdTransformer = AmdTransformer;
  ($traceurRuntime.createClass)(AmdTransformer, {
    getExportProperties: function() {
      var properties = $traceurRuntime.superGet(this, $AmdTransformer.prototype, "getExportProperties").call(this);
      if (this.exportVisitor_.hasExports())
        properties.push(parsePropertyDefinition($__0));
      return properties;
    },
    moduleProlog: function() {
      var locals = this.dependencies.map((function(dep) {
        var local = createIdentifierExpression(dep.local);
        return parseStatement($__1, local, local, local, local);
      }));
      return $traceurRuntime.superGet(this, $AmdTransformer.prototype, "moduleProlog").call(this).concat(locals);
    },
    wrapModule: function(statements) {
      var depPaths = this.dependencies.map((function(dep) {
        return dep.path;
      }));
      var depLocals = this.dependencies.map((function(dep) {
        return dep.local;
      }));
      var hasTopLevelThis = statements.some(scopeContainsThis);
      var func = parseExpression($__2, depLocals, statements);
      if (hasTopLevelThis)
        func = parseExpression($__3, func, globalThis());
      if (this.moduleName) {
        return parseStatements($__4, this.moduleName, depPaths, func);
      } else {
        return parseStatements($__5, depPaths, func);
      }
    },
    transformModuleSpecifier: function(tree) {
      var localName = this.getTempIdentifier();
      var value = tree.token.processedValue;
      var stringLiteral = createStringLiteralToken(value.replace(/\.js$/, ''));
      this.dependencies.push({
        path: stringLiteral,
        local: localName
      });
      return createIdentifierExpression(localName);
    }
  }, {}, ModuleTransformer);
  return {get AmdTransformer() {
      return AmdTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/staticsemantics/PropName.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/staticsemantics/PropName.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      COMPUTED_PROPERTY_NAME = $__0.COMPUTED_PROPERTY_NAME,
      GET_ACCESSOR = $__0.GET_ACCESSOR,
      LITERAL_PROPERTY_NAME = $__0.LITERAL_PROPERTY_NAME,
      PROPERTY_METHOD_ASSIGNMENT = $__0.PROPERTY_METHOD_ASSIGNMENT,
      PROPERTY_NAME_ASSIGNMENT = $__0.PROPERTY_NAME_ASSIGNMENT,
      PROPERTY_NAME_SHORTHAND = $__0.PROPERTY_NAME_SHORTHAND,
      SET_ACCESSOR = $__0.SET_ACCESSOR;
  var IDENTIFIER = System.get("traceur@0.0.80/src/syntax/TokenType.js").IDENTIFIER;
  function propName(tree) {
    switch (tree.type) {
      case LITERAL_PROPERTY_NAME:
        var token = tree.literalToken;
        if (token.isKeyword() || token.type === IDENTIFIER)
          return token.toString();
        return String(tree.literalToken.processedValue);
      case COMPUTED_PROPERTY_NAME:
        return '';
      case PROPERTY_NAME_SHORTHAND:
        return tree.name.toString();
      case PROPERTY_METHOD_ASSIGNMENT:
      case PROPERTY_NAME_ASSIGNMENT:
      case GET_ACCESSOR:
      case SET_ACCESSOR:
        return propName(tree.name);
    }
  }
  return {get propName() {
      return propName;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/AnnotationsTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/AnnotationsTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["Object.getOwnPropertyDescriptor(", ")"], {raw: {value: Object.freeze(["Object.getOwnPropertyDescriptor(", ")"])}})),
      $__1 = Object.freeze(Object.defineProperties(["Object.defineProperty(", ", ", ",\n        {get: function() {return ", "}});"], {raw: {value: Object.freeze(["Object.defineProperty(", ", ", ",\n        {get: function() {return ", "}});"])}}));
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var CONSTRUCTOR = System.get("traceur@0.0.80/src/syntax/PredefinedName.js").CONSTRUCTOR;
  var STRING = System.get("traceur@0.0.80/src/syntax/TokenType.js").STRING;
  var $__5 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AnonBlock = $__5.AnonBlock,
      ClassDeclaration = $__5.ClassDeclaration,
      ExportDeclaration = $__5.ExportDeclaration,
      FormalParameter = $__5.FormalParameter,
      FunctionDeclaration = $__5.FunctionDeclaration,
      GetAccessor = $__5.GetAccessor,
      LiteralExpression = $__5.LiteralExpression,
      PropertyMethodAssignment = $__5.PropertyMethodAssignment,
      SetAccessor = $__5.SetAccessor;
  var propName = System.get("traceur@0.0.80/src/staticsemantics/PropName.js").propName;
  var $__7 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createArgumentList = $__7.createArgumentList,
      createArrayLiteralExpression = $__7.createArrayLiteralExpression,
      createAssignmentStatement = $__7.createAssignmentStatement,
      createIdentifierExpression = $__7.createIdentifierExpression,
      createMemberExpression = $__7.createMemberExpression,
      createNewExpression = $__7.createNewExpression,
      createStringLiteralToken = $__7.createStringLiteralToken;
  var $__8 = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js"),
      parseExpression = $__8.parseExpression,
      parseStatement = $__8.parseStatement;
  var AnnotationsScope = function AnnotationsScope() {
    this.className = null;
    this.isExport = false;
    this.constructorParameters = [];
    this.annotations = [];
    this.metadata = [];
  };
  ($traceurRuntime.createClass)(AnnotationsScope, {get inClassScope() {
      return this.className !== null;
    }}, {});
  var AnnotationsTransformer = function AnnotationsTransformer() {
    this.stack_ = [new AnnotationsScope()];
  };
  var $AnnotationsTransformer = AnnotationsTransformer;
  ($traceurRuntime.createClass)(AnnotationsTransformer, {
    transformExportDeclaration: function(tree) {
      var $__11;
      var scope = this.pushAnnotationScope_();
      scope.isExport = true;
      ($__11 = scope.annotations).push.apply($__11, $traceurRuntime.spread(tree.annotations));
      var declaration = this.transformAny(tree.declaration);
      if (declaration !== tree.declaration || tree.annotations.length > 0)
        tree = new ExportDeclaration(tree.location, declaration, []);
      return this.appendMetadata_(tree);
    },
    transformClassDeclaration: function(tree) {
      var $__11,
          $__12;
      var elementsChanged = false;
      var exportAnnotations = this.scope.isExport ? this.scope.annotations : [];
      var scope = this.pushAnnotationScope_();
      scope.className = tree.name;
      ($__11 = scope.annotations).push.apply($__11, $traceurRuntime.spread(exportAnnotations, tree.annotations));
      tree = $traceurRuntime.superGet(this, $AnnotationsTransformer.prototype, "transformClassDeclaration").call(this, tree);
      ($__12 = scope.metadata).unshift.apply($__12, $traceurRuntime.spread(this.transformMetadata_(createIdentifierExpression(tree.name), scope.annotations, scope.constructorParameters)));
      if (tree.annotations.length > 0) {
        tree = new ClassDeclaration(tree.location, tree.name, tree.superClass, tree.elements, [], null);
      }
      return this.appendMetadata_(tree);
    },
    transformFunctionDeclaration: function(tree) {
      var $__11,
          $__12;
      var exportAnnotations = this.scope.isExport ? this.scope.annotations : [];
      var scope = this.pushAnnotationScope_();
      ($__11 = scope.annotations).push.apply($__11, $traceurRuntime.spread(exportAnnotations, tree.annotations));
      ($__12 = scope.metadata).push.apply($__12, $traceurRuntime.spread(this.transformMetadata_(createIdentifierExpression(tree.name), scope.annotations, tree.parameterList.parameters)));
      tree = $traceurRuntime.superGet(this, $AnnotationsTransformer.prototype, "transformFunctionDeclaration").call(this, tree);
      if (tree.annotations.length > 0) {
        tree = new FunctionDeclaration(tree.location, tree.name, tree.functionKind, tree.parameterList, tree.typeAnnotation, [], tree.body);
      }
      return this.appendMetadata_(tree);
    },
    transformFormalParameter: function(tree) {
      if (tree.annotations.length > 0) {
        tree = new FormalParameter(tree.location, tree.parameter, tree.typeAnnotation, []);
      }
      return $traceurRuntime.superGet(this, $AnnotationsTransformer.prototype, "transformFormalParameter").call(this, tree);
    },
    transformGetAccessor: function(tree) {
      var $__11;
      if (!this.scope.inClassScope)
        return $traceurRuntime.superGet(this, $AnnotationsTransformer.prototype, "transformGetAccessor").call(this, tree);
      ($__11 = this.scope.metadata).push.apply($__11, $traceurRuntime.spread(this.transformMetadata_(this.transformAccessor_(tree, this.scope.className, 'get'), tree.annotations, [])));
      if (tree.annotations.length > 0) {
        tree = new GetAccessor(tree.location, tree.isStatic, tree.name, tree.typeAnnotation, [], tree.body);
      }
      return $traceurRuntime.superGet(this, $AnnotationsTransformer.prototype, "transformGetAccessor").call(this, tree);
    },
    transformSetAccessor: function(tree) {
      var $__11;
      if (!this.scope.inClassScope)
        return $traceurRuntime.superGet(this, $AnnotationsTransformer.prototype, "transformSetAccessor").call(this, tree);
      ($__11 = this.scope.metadata).push.apply($__11, $traceurRuntime.spread(this.transformMetadata_(this.transformAccessor_(tree, this.scope.className, 'set'), tree.annotations, tree.parameterList.parameters)));
      var parameterList = this.transformAny(tree.parameterList);
      if (parameterList !== tree.parameterList || tree.annotations.length > 0) {
        tree = new SetAccessor(tree.location, tree.isStatic, tree.name, parameterList, [], tree.body);
      }
      return $traceurRuntime.superGet(this, $AnnotationsTransformer.prototype, "transformSetAccessor").call(this, tree);
    },
    transformPropertyMethodAssignment: function(tree) {
      var $__11,
          $__12;
      if (!this.scope.inClassScope)
        return $traceurRuntime.superGet(this, $AnnotationsTransformer.prototype, "transformPropertyMethodAssignment").call(this, tree);
      if (!tree.isStatic && propName(tree) === CONSTRUCTOR) {
        ($__11 = this.scope.annotations).push.apply($__11, $traceurRuntime.spread(tree.annotations));
        this.scope.constructorParameters = tree.parameterList.parameters;
      } else {
        ($__12 = this.scope.metadata).push.apply($__12, $traceurRuntime.spread(this.transformMetadata_(this.transformPropertyMethod_(tree, this.scope.className), tree.annotations, tree.parameterList.parameters)));
      }
      var parameterList = this.transformAny(tree.parameterList);
      if (parameterList !== tree.parameterList || tree.annotations.length > 0) {
        tree = new PropertyMethodAssignment(tree.location, tree.isStatic, tree.functionKind, tree.name, parameterList, tree.typeAnnotation, [], tree.body);
      }
      return $traceurRuntime.superGet(this, $AnnotationsTransformer.prototype, "transformPropertyMethodAssignment").call(this, tree);
    },
    appendMetadata_: function(tree) {
      var $__11;
      var metadata = this.stack_.pop().metadata;
      if (metadata.length > 0) {
        if (this.scope.isExport) {
          ($__11 = this.scope.metadata).push.apply($__11, $traceurRuntime.spread(metadata));
        } else {
          tree = new AnonBlock(null, $traceurRuntime.spread([tree], metadata));
        }
      }
      return tree;
    },
    transformClassReference_: function(tree, className) {
      var parent = createIdentifierExpression(className);
      if (!tree.isStatic)
        parent = createMemberExpression(parent, 'prototype');
      return parent;
    },
    transformPropertyMethod_: function(tree, className) {
      return createMemberExpression(this.transformClassReference_(tree, className), tree.name.literalToken);
    },
    transformAccessor_: function(tree, className, accessor) {
      var args = createArgumentList([this.transformClassReference_(tree, className), this.createLiteralStringExpression_(tree.name)]);
      var descriptor = parseExpression($__0, args);
      return createMemberExpression(descriptor, accessor);
    },
    transformParameters_: function(parameters) {
      var $__9 = this;
      var hasParameterMetadata = false;
      parameters = parameters.map((function(param) {
        var $__11;
        var metadata = [];
        if (param.typeAnnotation)
          metadata.push($__9.transformAny(param.typeAnnotation));
        if (param.annotations && param.annotations.length > 0)
          ($__11 = metadata).push.apply($__11, $traceurRuntime.spread($__9.transformAnnotations_(param.annotations)));
        if (metadata.length > 0) {
          hasParameterMetadata = true;
          return createArrayLiteralExpression(metadata);
        }
        return createArrayLiteralExpression([]);
      }));
      return hasParameterMetadata ? parameters : [];
    },
    transformAnnotations_: function(annotations) {
      return annotations.map((function(annotation) {
        return createNewExpression(annotation.name, annotation.args);
      }));
    },
    transformMetadata_: function(target, annotations, parameters) {
      var metadataStatements = [];
      if (annotations !== null) {
        annotations = this.transformAnnotations_(annotations);
        if (annotations.length > 0) {
          metadataStatements.push(this.createDefinePropertyStatement_(target, 'annotations', createArrayLiteralExpression(annotations)));
        }
      }
      if (parameters !== null) {
        parameters = this.transformParameters_(parameters);
        if (parameters.length > 0) {
          metadataStatements.push(this.createDefinePropertyStatement_(target, 'parameters', createArrayLiteralExpression(parameters)));
        }
      }
      return metadataStatements;
    },
    createDefinePropertyStatement_: function(target, property, value) {
      return parseStatement($__1, target, property, value);
    },
    createLiteralStringExpression_: function(tree) {
      var token = tree.literalToken;
      if (tree.literalToken.type !== STRING)
        token = createStringLiteralToken(tree.literalToken.value);
      return new LiteralExpression(null, token);
    },
    get scope() {
      return this.stack_[this.stack_.length - 1];
    },
    pushAnnotationScope_: function() {
      var scope = new AnnotationsScope();
      this.stack_.push(scope);
      return scope;
    }
  }, {}, ParseTreeTransformer);
  return {get AnnotationsTransformer() {
      return AnnotationsTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/semantics/VariableBinder.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/semantics/VariableBinder.js";
  var ScopeChainBuilder = System.get("traceur@0.0.80/src/semantics/ScopeChainBuilder.js").ScopeChainBuilder;
  function variablesInBlock(tree) {
    var includeFunctionScope = arguments[1];
    var builder = new ScopeChainBuilder(null);
    builder.visitAny(tree);
    var scope = builder.getScopeForTree(tree);
    var names = scope.getLexicalBindingNames();
    if (!includeFunctionScope) {
      return names;
    }
    var variableBindingNames = scope.getVariableBindingNames();
    for (var name in variableBindingNames) {
      names[name] = true;
    }
    return names;
  }
  function variablesInFunction(tree) {
    var builder = new ScopeChainBuilder(null);
    builder.visitAny(tree);
    var scope = builder.getScopeForTree(tree);
    return scope.getAllBindingNames();
  }
  return {
    get variablesInBlock() {
      return variablesInBlock;
    },
    get variablesInFunction() {
      return variablesInFunction;
    }
  };
});
System.registerModule("traceur@0.0.80/src/codegeneration/ScopeTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ScopeTransformer.js";
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var $__1 = System.get("traceur@0.0.80/src/syntax/PredefinedName.js"),
      ARGUMENTS = $__1.ARGUMENTS,
      THIS = $__1.THIS;
  var $__2 = System.get("traceur@0.0.80/src/semantics/VariableBinder.js"),
      variablesInBlock = $__2.variablesInBlock,
      variablesInFunction = $__2.variablesInFunction;
  var ScopeTransformer = function ScopeTransformer(varName) {
    $traceurRuntime.superConstructor($ScopeTransformer).call(this);
    this.varName_ = varName;
  };
  var $ScopeTransformer = ScopeTransformer;
  ($traceurRuntime.createClass)(ScopeTransformer, {
    transformBlock: function(tree) {
      if (this.varName_ in variablesInBlock(tree)) {
        return tree;
      } else {
        return $traceurRuntime.superGet(this, $ScopeTransformer.prototype, "transformBlock").call(this, tree);
      }
    },
    transformThisExpression: function(tree) {
      if (this.varName_ !== THIS)
        return tree;
      return $traceurRuntime.superGet(this, $ScopeTransformer.prototype, "transformThisExpression").call(this, tree);
    },
    transformFunctionDeclaration: function(tree) {
      if (this.getDoNotRecurse(tree))
        return tree;
      return $traceurRuntime.superGet(this, $ScopeTransformer.prototype, "transformFunctionDeclaration").call(this, tree);
    },
    transformFunctionExpression: function(tree) {
      if (this.getDoNotRecurse(tree))
        return tree;
      return $traceurRuntime.superGet(this, $ScopeTransformer.prototype, "transformFunctionExpression").call(this, tree);
    },
    getDoNotRecurse: function(tree) {
      return this.varName_ === ARGUMENTS || this.varName_ === THIS || this.varName_ in variablesInFunction(tree);
    },
    transformCatch: function(tree) {
      if (!tree.binding.isPattern() && this.varName_ === tree.binding.identifierToken.value) {
        return tree;
      }
      return $traceurRuntime.superGet(this, $ScopeTransformer.prototype, "transformCatch").call(this, tree);
    }
  }, {}, ParseTreeTransformer);
  return {get ScopeTransformer() {
      return ScopeTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/AlphaRenamer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/AlphaRenamer.js";
  var ScopeTransformer = System.get("traceur@0.0.80/src/codegeneration/ScopeTransformer.js").ScopeTransformer;
  var $__1 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      FunctionDeclaration = $__1.FunctionDeclaration,
      FunctionExpression = $__1.FunctionExpression;
  var THIS = System.get("traceur@0.0.80/src/syntax/PredefinedName.js").THIS;
  var createIdentifierExpression = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js").createIdentifierExpression;
  var AlphaRenamer = function AlphaRenamer(varName, newName) {
    $traceurRuntime.superConstructor($AlphaRenamer).call(this, varName);
    this.newName_ = newName;
  };
  var $AlphaRenamer = AlphaRenamer;
  ($traceurRuntime.createClass)(AlphaRenamer, {
    transformIdentifierExpression: function(tree) {
      if (this.varName_ == tree.identifierToken.value) {
        return createIdentifierExpression(this.newName_);
      } else {
        return tree;
      }
    },
    transformThisExpression: function(tree) {
      if (this.varName_ !== THIS)
        return tree;
      return createIdentifierExpression(this.newName_);
    },
    transformFunctionDeclaration: function(tree) {
      if (this.varName_ === tree.name) {
        tree = new FunctionDeclaration(tree.location, this.newName_, tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
      }
      return $traceurRuntime.superGet(this, $AlphaRenamer.prototype, "transformFunctionDeclaration").call(this, tree);
    },
    transformFunctionExpression: function(tree) {
      if (this.varName_ === tree.name) {
        tree = new FunctionExpression(tree.location, this.newName_, tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
      }
      return $traceurRuntime.superGet(this, $AlphaRenamer.prototype, "transformFunctionExpression").call(this, tree);
    }
  }, {rename: function(tree, varName, newName) {
      return new $AlphaRenamer(varName, newName).transformAny(tree);
    }}, ScopeTransformer);
  return {get AlphaRenamer() {
      return AlphaRenamer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/alphaRenameThisAndArguments.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/alphaRenameThisAndArguments.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/PredefinedName.js"),
      ARGUMENTS = $__0.ARGUMENTS,
      THIS = $__0.THIS;
  var AlphaRenamer = System.get("traceur@0.0.80/src/codegeneration/AlphaRenamer.js").AlphaRenamer;
  var FindInFunctionScope = System.get("traceur@0.0.80/src/codegeneration/FindInFunctionScope.js").FindInFunctionScope;
  var FindThisOrArguments = function FindThisOrArguments() {
    $traceurRuntime.superConstructor($FindThisOrArguments).call(this);
    this.foundThis = false;
    this.foundArguments = false;
  };
  var $FindThisOrArguments = FindThisOrArguments;
  ($traceurRuntime.createClass)(FindThisOrArguments, {
    visitThisExpression: function(tree) {
      this.foundThis = true;
      this.found = this.foundArguments;
    },
    visitIdentifierExpression: function(tree) {
      if (tree.identifierToken.value === ARGUMENTS) {
        this.foundArguments = true;
        this.found = this.foundThis;
      }
    }
  }, {}, FindInFunctionScope);
  function alphaRenameThisAndArguments(tempVarTransformer, tree) {
    var finder = new FindThisOrArguments();
    finder.visitAny(tree);
    if (finder.foundArguments) {
      var argumentsTempName = tempVarTransformer.addTempVarForArguments();
      tree = AlphaRenamer.rename(tree, ARGUMENTS, argumentsTempName);
    }
    if (finder.foundThis) {
      var thisTempName = tempVarTransformer.addTempVarForThis();
      tree = AlphaRenamer.rename(tree, THIS, thisTempName);
    }
    return tree;
  }
  var $__default = alphaRenameThisAndArguments;
  return {get default() {
      return $__default;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ComprehensionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ComprehensionTransformer.js";
  var alphaRenameThisAndArguments = System.get("traceur@0.0.80/src/codegeneration/alphaRenameThisAndArguments.js").default;
  var FunctionExpression = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js").FunctionExpression;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var $__3 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      LET = $__3.LET,
      STAR = $__3.STAR,
      VAR = $__3.VAR;
  var $__4 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      COMPREHENSION_FOR = $__4.COMPREHENSION_FOR,
      COMPREHENSION_IF = $__4.COMPREHENSION_IF;
  var Token = System.get("traceur@0.0.80/src/syntax/Token.js").Token;
  var $__6 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createCallExpression = $__6.createCallExpression,
      createEmptyParameterList = $__6.createEmptyParameterList,
      createForOfStatement = $__6.createForOfStatement,
      createFunctionBody = $__6.createFunctionBody,
      createIfStatement = $__6.createIfStatement,
      createParenExpression = $__6.createParenExpression,
      createVariableDeclarationList = $__6.createVariableDeclarationList;
  var options = System.get("traceur@0.0.80/src/Options.js").options;
  var ComprehensionTransformer = function ComprehensionTransformer() {
    $traceurRuntime.superConstructor($ComprehensionTransformer).apply(this, arguments);
  };
  var $ComprehensionTransformer = ComprehensionTransformer;
  ($traceurRuntime.createClass)(ComprehensionTransformer, {transformComprehension: function(tree, statement, isGenerator) {
      var prefix = arguments[3];
      var suffix = arguments[4];
      var bindingKind = isGenerator || !options.blockBinding ? VAR : LET;
      var statements = prefix ? [prefix] : [];
      for (var i = tree.comprehensionList.length - 1; i >= 0; i--) {
        var item = tree.comprehensionList[i];
        switch (item.type) {
          case COMPREHENSION_IF:
            var expression = this.transformAny(item.expression);
            statement = createIfStatement(expression, statement);
            break;
          case COMPREHENSION_FOR:
            var left = this.transformAny(item.left);
            var iterator = this.transformAny(item.iterator);
            var initializer = createVariableDeclarationList(bindingKind, left, null);
            statement = createForOfStatement(initializer, iterator, statement);
            break;
          default:
            throw new Error('Unreachable.');
        }
      }
      statement = alphaRenameThisAndArguments(this, statement);
      statements.push(statement);
      if (suffix)
        statements.push(suffix);
      var functionKind = isGenerator ? new Token(STAR, null) : null;
      var func = new FunctionExpression(null, null, functionKind, createEmptyParameterList(), null, [], createFunctionBody(statements));
      return createParenExpression(createCallExpression(func));
    }}, {}, TempVarTransformer);
  return {get ComprehensionTransformer() {
      return ComprehensionTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ArrayComprehensionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ArrayComprehensionTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["var ", " = 0, ", " = [];"], {raw: {value: Object.freeze(["var ", " = 0, ", " = [];"])}})),
      $__1 = Object.freeze(Object.defineProperties(["", "[", "++] = ", ";"], {raw: {value: Object.freeze(["", "[", "++] = ", ";"])}})),
      $__2 = Object.freeze(Object.defineProperties(["return ", ";"], {raw: {value: Object.freeze(["return ", ";"])}}));
  var ComprehensionTransformer = System.get("traceur@0.0.80/src/codegeneration/ComprehensionTransformer.js").ComprehensionTransformer;
  var createIdentifierExpression = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js").createIdentifierExpression;
  var parseStatement = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseStatement;
  var ArrayComprehensionTransformer = function ArrayComprehensionTransformer() {
    $traceurRuntime.superConstructor($ArrayComprehensionTransformer).apply(this, arguments);
  };
  var $ArrayComprehensionTransformer = ArrayComprehensionTransformer;
  ($traceurRuntime.createClass)(ArrayComprehensionTransformer, {transformArrayComprehension: function(tree) {
      this.pushTempScope();
      var expression = this.transformAny(tree.expression);
      var index = createIdentifierExpression(this.getTempIdentifier());
      var result = createIdentifierExpression(this.getTempIdentifier());
      var tempVarsStatatement = parseStatement($__0, index, result);
      var statement = parseStatement($__1, result, index, expression);
      var returnStatement = parseStatement($__2, result);
      var functionKind = null;
      var result = this.transformComprehension(tree, statement, functionKind, tempVarsStatatement, returnStatement);
      this.popTempScope();
      return result;
    }}, {}, ComprehensionTransformer);
  return {get ArrayComprehensionTransformer() {
      return ArrayComprehensionTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ArrowFunctionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ArrowFunctionTransformer.js";
  var FunctionExpression = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js").FunctionExpression;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var FUNCTION_BODY = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js").FUNCTION_BODY;
  var alphaRenameThisAndArguments = System.get("traceur@0.0.80/src/codegeneration/alphaRenameThisAndArguments.js").default;
  var $__4 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createFunctionBody = $__4.createFunctionBody,
      createParenExpression = $__4.createParenExpression,
      createReturnStatement = $__4.createReturnStatement;
  function convertConciseBody(tree) {
    if (tree.type !== FUNCTION_BODY)
      return createFunctionBody([createReturnStatement(tree)]);
    return tree;
  }
  var ArrowFunctionTransformer = function ArrowFunctionTransformer() {
    $traceurRuntime.superConstructor($ArrowFunctionTransformer).apply(this, arguments);
  };
  var $ArrowFunctionTransformer = ArrowFunctionTransformer;
  ($traceurRuntime.createClass)(ArrowFunctionTransformer, {transformArrowFunctionExpression: function(tree) {
      var alphaRenamed = alphaRenameThisAndArguments(this, tree);
      var parameterList = this.transformAny(alphaRenamed.parameterList);
      var body = this.transformAny(alphaRenamed.body);
      body = convertConciseBody(body);
      var functionExpression = new FunctionExpression(tree.location, null, tree.functionKind, parameterList, null, [], body);
      return createParenExpression(functionExpression);
    }}, {transform: function(tempVarTransformer, tree) {
      tree = alphaRenameThisAndArguments(tempVarTransformer, tree);
      var body = convertConciseBody(tree.body);
      return new FunctionExpression(tree.location, null, tree.functionKind, tree.parameterList, null, [], body);
    }}, TempVarTransformer);
  return {get ArrowFunctionTransformer() {
      return ArrowFunctionTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/FindIdentifiers.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/FindIdentifiers.js";
  var ScopeVisitor = System.get("traceur@0.0.80/src/semantics/ScopeVisitor.js").ScopeVisitor;
  var FindIdentifiers = function FindIdentifiers(tree, filterFunction) {
    $traceurRuntime.superConstructor($FindIdentifiers).call(this);
    this.filterFunction_ = filterFunction;
    this.found_ = false;
    this.visitAny(tree);
  };
  var $FindIdentifiers = FindIdentifiers;
  ($traceurRuntime.createClass)(FindIdentifiers, {
    visitIdentifierExpression: function(tree) {
      if (this.filterFunction_(tree.identifierToken.value, this.scope.tree)) {
        this.found = true;
      }
    },
    get found() {
      return this.found_;
    },
    set found(v) {
      if (v) {
        this.found_ = true;
      }
    },
    visitAny: function(tree) {
      !this.found_ && tree && tree.visit(this);
    },
    visitList: function(list) {
      if (list) {
        for (var i = 0; !this.found_ && i < list.length; i++) {
          this.visitAny(list[i]);
        }
      }
    }
  }, {}, ScopeVisitor);
  return {get FindIdentifiers() {
      return FindIdentifiers;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/FnExtractAbruptCompletions.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/FnExtractAbruptCompletions.js";
  var $__0 = Object.freeze(Object.defineProperties(["if (typeof ", " === \"object\")\n            return ", ".v;"], {raw: {value: Object.freeze(["if (typeof ", " === \"object\")\n            return ", ".v;"])}})),
      $__1 = Object.freeze(Object.defineProperties(["return ", ";"], {raw: {value: Object.freeze(["return ", ";"])}}));
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var alphaRenameThisAndArguments = System.get("traceur@0.0.80/src/codegeneration/alphaRenameThisAndArguments.js").default;
  var parseStatement = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseStatement;
  var $__5 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AnonBlock = $__5.AnonBlock,
      BreakStatement = $__5.BreakStatement,
      ContinueStatement = $__5.ContinueStatement,
      FormalParameterList = $__5.FormalParameterList,
      ReturnStatement = $__5.ReturnStatement;
  var $__6 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createArgumentList = $__6.createArgumentList,
      createAssignmentStatement = $__6.createAssignmentStatement,
      createAssignmentExpression = $__6.createAssignmentExpression,
      createBlock = $__6.createBlock,
      createCallExpression = $__6.createCallExpression,
      createCaseClause = $__6.createCaseClause,
      createDefaultClause = $__6.createDefaultClause,
      createExpressionStatement = $__6.createExpressionStatement,
      createFunctionBody = $__6.createFunctionBody,
      createFunctionExpression = $__6.createFunctionExpression,
      createIdentifierExpression = $__6.createIdentifierExpression,
      createNumberLiteral = $__6.createNumberLiteral,
      createObjectLiteral = $__6.createObjectLiteral,
      createSwitchStatement = $__6.createSwitchStatement,
      createThisExpression = $__6.createThisExpression,
      createVariableDeclaration = $__6.createVariableDeclaration,
      createVariableDeclarationList = $__6.createVariableDeclarationList,
      createVariableStatement = $__6.createVariableStatement,
      createVoid0 = $__6.createVoid0;
  var ARGUMENTS = System.get("traceur@0.0.80/src/syntax/PredefinedName.js").ARGUMENTS;
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var FnExtractAbruptCompletions = function FnExtractAbruptCompletions(idGenerator, requestParentLabel) {
    this.idGenerator_ = idGenerator;
    this.inLoop_ = 0;
    this.inBreakble_ = 0;
    this.variableDeclarations_ = [];
    this.extractedStatements_ = [];
    this.requestParentLabel_ = requestParentLabel;
    this.labelledStatements_ = {};
  };
  var $FnExtractAbruptCompletions = FnExtractAbruptCompletions;
  ($traceurRuntime.createClass)(FnExtractAbruptCompletions, {
    createIIFE: function(body, paramList, argsList) {
      body = this.transformAny(body);
      body = alphaRenameThisAndArguments(this, body);
      var tmpFnName = this.idGenerator_.generateUniqueIdentifier();
      var functionExpression = createFunctionExpression(new FormalParameterList(null, paramList), createFunctionBody(body.statements || [body]));
      this.variableDeclarations_.push(createVariableDeclaration(tmpFnName, functionExpression));
      var functionCall = createCallExpression(createIdentifierExpression(tmpFnName), createArgumentList(argsList));
      var loopBody = null;
      if (this.extractedStatements_.length || this.hasReturns) {
        var tmpVarName = createIdentifierExpression(this.idGenerator_.generateUniqueIdentifier());
        this.variableDeclarations_.push(createVariableDeclaration(tmpVarName, null));
        var maybeReturn;
        if (this.hasReturns) {
          maybeReturn = parseStatement($__0, tmpVarName, tmpVarName);
        }
        if (this.extractedStatements_.length) {
          var caseClauses = this.extractedStatements_.map((function(statement, index) {
            return createCaseClause(createNumberLiteral(index), [statement]);
          }));
          if (maybeReturn) {
            caseClauses.push(createDefaultClause([maybeReturn]));
          }
          loopBody = createBlock([createExpressionStatement(createAssignmentExpression(tmpVarName, functionCall)), createSwitchStatement(tmpVarName, caseClauses)]);
        } else {
          loopBody = createBlock([createExpressionStatement(createAssignmentExpression(tmpVarName, functionCall)), maybeReturn]);
        }
      } else {
        loopBody = createBlock([createExpressionStatement(functionCall)]);
      }
      return {
        variableStatements: createVariableStatement(createVariableDeclarationList(VAR, this.variableDeclarations_)),
        loopBody: loopBody
      };
    },
    addTempVarForArguments: function() {
      var tmpVarName = this.idGenerator_.generateUniqueIdentifier();
      this.variableDeclarations_.push(createVariableDeclaration(tmpVarName, createIdentifierExpression(ARGUMENTS)));
      return tmpVarName;
    },
    addTempVarForThis: function() {
      var tmpVarName = this.idGenerator_.generateUniqueIdentifier();
      this.variableDeclarations_.push(createVariableDeclaration(tmpVarName, createThisExpression()));
      return tmpVarName;
    },
    transformAny: function(tree) {
      if (tree) {
        if (tree.isBreakableStatement())
          this.inBreakble_++;
        if (tree.isIterationStatement())
          this.inLoop_++;
        tree = $traceurRuntime.superGet(this, $FnExtractAbruptCompletions.prototype, "transformAny").call(this, tree);
        if (tree.isBreakableStatement())
          this.inBreakble_--;
        if (tree.isIterationStatement())
          this.inLoop_--;
      }
      return tree;
    },
    transformReturnStatement: function(tree) {
      this.hasReturns = true;
      return new ReturnStatement(tree.location, createObjectLiteral({v: tree.expression || createVoid0()}));
    },
    transformAbruptCompletion_: function(tree) {
      this.extractedStatements_.push(tree);
      var index = this.extractedStatements_.length - 1;
      return parseStatement($__1, index);
    },
    transformBreakStatement: function(tree) {
      if (!tree.name) {
        if (this.inBreakble_) {
          return $traceurRuntime.superGet(this, $FnExtractAbruptCompletions.prototype, "transformBreakStatement").call(this, tree);
        } else {
          tree = new BreakStatement(tree.location, this.requestParentLabel_());
        }
      } else if (this.labelledStatements_[tree.name]) {
        return $traceurRuntime.superGet(this, $FnExtractAbruptCompletions.prototype, "transformBreakStatement").call(this, tree);
      }
      return this.transformAbruptCompletion_(tree);
    },
    transformContinueStatement: function(tree) {
      if (!tree.name) {
        if (this.inLoop_) {
          return $traceurRuntime.superGet(this, $FnExtractAbruptCompletions.prototype, "transformContinueStatement").call(this, tree);
        } else {
          tree = new ContinueStatement(tree.location, this.requestParentLabel_());
        }
      } else if (this.labelledStatements_[tree.name]) {
        return $traceurRuntime.superGet(this, $FnExtractAbruptCompletions.prototype, "transformContinueStatement").call(this, tree);
      }
      return this.transformAbruptCompletion_(tree);
    },
    transformLabelledStatement: function(tree) {
      this.labelledStatements_[tree.name] = true;
      return $traceurRuntime.superGet(this, $FnExtractAbruptCompletions.prototype, "transformLabelledStatement").call(this, tree);
    },
    transformVariableStatement: function(tree) {
      var $__10 = this;
      var $__9 = this;
      if (tree.declarations.declarationType === VAR) {
        var assignments = [];
        tree.declarations.declarations.forEach((function(variableDeclaration) {
          var variableName = variableDeclaration.lvalue.getStringValue();
          var initializer = $traceurRuntime.superGet($__10, $FnExtractAbruptCompletions.prototype, "transformAny").call($__10, variableDeclaration.initializer);
          $__9.variableDeclarations_.push(createVariableDeclaration(variableName, null));
          assignments.push(createAssignmentStatement(createIdentifierExpression(variableName), initializer));
        }));
        return new AnonBlock(null, assignments);
      }
      return $traceurRuntime.superGet(this, $FnExtractAbruptCompletions.prototype, "transformVariableStatement").call(this, tree);
    },
    transformFunctionDeclaration: function(tree) {
      return tree;
    },
    transformFunctionExpression: function(tree) {
      return tree;
    },
    transformSetAccessor: function(tree) {
      return tree;
    },
    transformGetAccessor: function(tree) {
      return tree;
    },
    transformPropertyMethodAssignment: function(tree) {
      return tree;
    },
    transformArrowFunctionExpression: function(tree) {
      return tree;
    }
  }, {createIIFE: function(idGenerator, body, paramList, argsList, requestParentLabel) {
      return new $FnExtractAbruptCompletions(idGenerator, requestParentLabel).createIIFE(body, paramList, argsList);
    }}, ParseTreeTransformer);
  return {get FnExtractAbruptCompletions() {
      return FnExtractAbruptCompletions;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/BlockBindingTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/BlockBindingTransformer.js";
  var AlphaRenamer = System.get("traceur@0.0.80/src/codegeneration/AlphaRenamer.js").AlphaRenamer;
  var $__1 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      ANON_BLOCK = $__1.ANON_BLOCK,
      BINDING_IDENTIFIER = $__1.BINDING_IDENTIFIER,
      VARIABLE_DECLARATION_LIST = $__1.VARIABLE_DECLARATION_LIST;
  var $__2 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AnonBlock = $__2.AnonBlock,
      BindingElement = $__2.BindingElement,
      BindingIdentifier = $__2.BindingIdentifier,
      Block = $__2.Block,
      Catch = $__2.Catch,
      DoWhileStatement = $__2.DoWhileStatement,
      ForInStatement = $__2.ForInStatement,
      ForStatement = $__2.ForStatement,
      FormalParameter = $__2.FormalParameter,
      FunctionBody = $__2.FunctionBody,
      FunctionExpression = $__2.FunctionExpression,
      LabelledStatement = $__2.LabelledStatement,
      LiteralPropertyName = $__2.LiteralPropertyName,
      Module = $__2.Module,
      ObjectPatternField = $__2.ObjectPatternField,
      Script = $__2.Script,
      VariableDeclaration = $__2.VariableDeclaration,
      VariableDeclarationList = $__2.VariableDeclarationList,
      VariableStatement = $__2.VariableStatement,
      WhileStatement = $__2.WhileStatement;
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var $__5 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createBindingIdentifier = $__5.createBindingIdentifier,
      createIdentifierExpression = $__5.createIdentifierExpression,
      createIdentifierToken = $__5.createIdentifierToken;
  var FindIdentifiers = System.get("traceur@0.0.80/src/codegeneration/FindIdentifiers.js").FindIdentifiers;
  var FindVisitor = System.get("traceur@0.0.80/src/codegeneration/FindVisitor.js").FindVisitor;
  var FnExtractAbruptCompletions = System.get("traceur@0.0.80/src/codegeneration/FnExtractAbruptCompletions.js").FnExtractAbruptCompletions;
  var ScopeChainBuilderWithReferences = System.get("traceur@0.0.80/src/semantics/ScopeChainBuilderWithReferences.js").ScopeChainBuilderWithReferences;
  var prependStatements = System.get("traceur@0.0.80/src/codegeneration/PrependStatements.js").prependStatements;
  var BlockBindingTransformer = function BlockBindingTransformer(idGenerator, reporter, tree) {
    var scopeBuilder = arguments[3];
    var latestScope = arguments[4];
    $traceurRuntime.superConstructor($BlockBindingTransformer).call(this);
    this.idGenerator_ = idGenerator;
    this.reporter_ = reporter;
    if (!scopeBuilder) {
      scopeBuilder = new ScopeChainBuilderWithReferences(reporter);
      scopeBuilder.visitAny(tree);
    }
    this.scopeBuilder_ = scopeBuilder;
    this.labelledLoops_ = new Map();
    this.prependStatement_ = [];
    this.prependBlockStatement_ = [];
    this.blockRenames_ = [];
    this.rootTree_ = tree;
    if (latestScope) {
      this.scope_ = latestScope;
    } else {
      this.pushScope(tree);
    }
    this.usedVars_ = this.scope_.getAllBindingNames();
    this.maybeRename_ = false;
    this.inObjectPattern_ = false;
  };
  var $BlockBindingTransformer = BlockBindingTransformer;
  ($traceurRuntime.createClass)(BlockBindingTransformer, {
    getVariableName_: function(variable) {
      var lvalue = variable.lvalue;
      if (lvalue.type == BINDING_IDENTIFIER) {
        return lvalue.getStringValue();
      }
      throw new Error('Unexpected destructuring declaration found.');
    },
    flushRenames: function(tree) {
      tree = renameAll(this.blockRenames_, tree);
      this.blockRenames_.length = 0;
      return tree;
    },
    pushScope: function(tree) {
      var scope = this.scopeBuilder_.getScopeForTree(tree);
      if (!scope)
        throw new Error('BlockBindingTransformer tree with no scope');
      if (this.scope_)
        this.scope_.blockBindingRenames = this.blockRenames_;
      this.scope_ = scope;
      this.blockRenames_ = [];
      return scope;
    },
    popScope: function(scope) {
      if (this.scope_ != scope) {
        throw new Error('BlockBindingTransformer scope mismatch');
      }
      this.scope_ = scope.parent;
      this.blockRenames_ = this.scope_ && this.scope_.blockBindingRenames || [];
    },
    revisitTreeForScopes: function(tree) {
      this.scopeBuilder_.scope = this.scope_;
      this.scopeBuilder_.visitAny(tree);
      this.scopeBuilder_.scope = null;
    },
    needsRename_: function(name) {
      if (this.usedVars_[name])
        return true;
      var scope = this.scope_;
      var parent = scope.parent;
      if (!parent || scope.isVarScope)
        return false;
      var varScope = scope.getVarScope();
      if (varScope && varScope.hasFreeVariable(name)) {
        return true;
      }
      var parentBinding = parent.getBindingByName(name);
      if (!parentBinding)
        return false;
      var currentBinding = scope.getBindingByName(name);
      if (currentBinding.tree === parentBinding.tree)
        return false;
      return true;
    },
    newNameFromOrig: function(origName, renames) {
      var newName;
      if (this.needsRename_(origName)) {
        newName = origName + this.idGenerator_.generateUniqueIdentifier();
        renames.push(new Rename(origName, newName));
      } else {
        this.usedVars_[origName] = true;
        newName = origName;
      }
      return newName;
    },
    transformFunctionBody: function(tree) {
      if (tree === this.rootTree_ || !this.rootTree_) {
        tree = $traceurRuntime.superGet(this, $BlockBindingTransformer.prototype, "transformFunctionBody").call(this, tree);
        if (this.prependStatement_.length || this.blockRenames_.length) {
          var statements = prependStatements.apply(null, $traceurRuntime.spread([tree.statements], this.prependStatement_));
          tree = new FunctionBody(tree.location, statements);
          tree = this.flushRenames(tree);
        }
      } else {
        var functionTransform = new $BlockBindingTransformer(this.idGenerator_, this.reporter_, tree, this.scopeBuilder_, this.scope_);
        var functionBodyTree = functionTransform.transformAny(tree);
        if (functionBodyTree === tree) {
          return tree;
        }
        tree = new FunctionBody(tree.location, functionBodyTree.statements);
      }
      return tree;
    },
    transformScript: function(tree) {
      if (tree === this.rootTree_ || !this.rootTree_) {
        tree = $traceurRuntime.superGet(this, $BlockBindingTransformer.prototype, "transformScript").call(this, tree);
        if (this.prependStatement_.length || this.blockRenames_.length) {
          var scriptItemList = prependStatements.apply(null, $traceurRuntime.spread([tree.scriptItemList], this.prependStatement_));
          tree = new Script(tree.location, scriptItemList, tree.moduleName);
          tree = this.flushRenames(tree);
        }
      } else {
        var functionTransform = new $BlockBindingTransformer(this.idGenerator_, this.reporter_, tree, this.scopeBuilder_);
        var newTree = functionTransform.transformAny(tree);
        if (newTree === tree) {
          return tree;
        }
        tree = new Script(tree.location, newTree.scriptItemList, tree.moduleName);
      }
      return tree;
    },
    transformModule: function(tree) {
      if (tree === this.rootTree_ || !this.rootTree_) {
        tree = $traceurRuntime.superGet(this, $BlockBindingTransformer.prototype, "transformModule").call(this, tree);
        if (this.prependStatement_.length || this.blockRenames_.length) {
          var scriptItemList = prependStatements.apply(null, $traceurRuntime.spread([tree.scriptItemList], this.prependStatement_));
          tree = new Module(tree.location, scriptItemList, tree.moduleName);
          tree = this.flushRenames(tree);
        }
      } else {
        var functionTransform = new $BlockBindingTransformer(this.idGenerator_, this.reporter_, tree, this.scopeBuilder_);
        var newTree = functionTransform.transformAny(tree);
        if (newTree === tree) {
          return tree;
        }
        tree = new Module(tree.location, newTree.scriptItemList, tree.moduleName);
      }
      return tree;
    },
    transformVariableStatement: function(tree) {
      var declarations = this.transformAny(tree.declarations);
      if (declarations.type === ANON_BLOCK) {
        return declarations;
      }
      if (declarations === tree.declarations) {
        return tree;
      }
      return new VariableStatement(tree.location, declarations);
    },
    transformVariableDeclarationList: function(tree) {
      if (tree.declarationType === VAR) {
        return $traceurRuntime.superGet(this, $BlockBindingTransformer.prototype, "transformVariableDeclarationList").call(this, tree);
      }
      this.maybeRename_ = !this.scope_.isVarScope;
      var declarations = this.transformList(tree.declarations);
      this.maybeRename_ = false;
      return new VariableDeclarationList(tree.location, VAR, declarations);
    },
    transformVariableDeclaration: function(tree) {
      var maybeRename = this.maybeRename_;
      var lvalue = this.transformAny(tree.lvalue);
      this.maybeRename_ = false;
      var initializer = this.transformAny(tree.initializer);
      this.maybeRename_ = maybeRename;
      if (tree.lvalue === lvalue && tree.initializer === initializer) {
        return tree;
      }
      return new VariableDeclaration(tree.location, lvalue, tree.typeAnnotation, initializer);
    },
    transformBindingIdentifier: function(tree) {
      if (this.maybeRename_) {
        var origName = tree.getStringValue();
        var newName = this.newNameFromOrig(origName, this.blockRenames_);
        if (origName === newName) {
          return tree;
        }
        var bindingIdentifier = new BindingIdentifier(tree.location, newName);
        this.scope_.renameBinding(origName, bindingIdentifier, VAR, this.reporter_);
        return bindingIdentifier;
      }
      return $traceurRuntime.superGet(this, $BlockBindingTransformer.prototype, "transformBindingIdentifier").call(this, tree);
    },
    transformBindingElement: function(tree) {
      var maybeRename = this.maybeRename_;
      var inObjectPattern = this.inObjectPattern_;
      var binding = this.transformAny(tree.binding);
      this.maybeRename_ = false;
      this.inObjectPattern_ = false;
      var initializer = this.transformAny(tree.initializer);
      this.maybeRename_ = maybeRename;
      this.inObjectPattern_ = inObjectPattern;
      if (tree.binding === binding && tree.initializer === initializer) {
        return tree;
      }
      var bindingElement = new BindingElement(tree.location, binding, initializer);
      if (this.inObjectPattern_ && tree.binding !== binding && tree.binding.type === BINDING_IDENTIFIER) {
        return new ObjectPatternField(tree.location, new LiteralPropertyName(tree.location, tree.binding.identifierToken), bindingElement);
      }
      return bindingElement;
    },
    transformObjectPattern: function(tree) {
      var inObjectPattern = this.inObjectPattern_;
      this.inObjectPattern_ = true;
      var transformed = $traceurRuntime.superGet(this, $BlockBindingTransformer.prototype, "transformObjectPattern").call(this, tree);
      this.inObjectPattern_ = inObjectPattern;
      return transformed;
    },
    transformObjectPatternField: function(tree) {
      var name = this.transformAny(tree.name);
      this.inObjectPattern_ = false;
      var element = this.transformAny(tree.element);
      this.inObjectPattern_ = true;
      if (tree.name === name && tree.element === element) {
        return tree;
      }
      return new ObjectPatternField(tree.location, name, element);
    },
    transformBlock: function(tree) {
      var scope = this.pushScope(tree);
      tree = $traceurRuntime.superGet(this, $BlockBindingTransformer.prototype, "transformBlock").call(this, tree);
      if (this.prependBlockStatement_.length) {
        tree = new Block(tree.location, prependStatements.apply(null, $traceurRuntime.spread([tree.statements], this.prependBlockStatement_)));
        this.prependBlockStatement_ = [];
      }
      tree = this.flushRenames(tree);
      this.popScope(scope);
      return tree;
    },
    transformCatch: function(tree) {
      var scope = this.pushScope(tree);
      var binding = this.transformAny(tree.binding);
      var statements = this.transformList(tree.catchBody.statements);
      if (binding !== tree.binding || statements !== tree.catchBody.statements) {
        tree = new Catch(tree.location, binding, new Block(tree.catchBody.location, statements));
      }
      tree = this.flushRenames(tree);
      this.popScope(scope);
      return tree;
    },
    transformFunctionForScope_: function(func, tree) {
      var scope = this.pushScope(tree);
      tree = func();
      tree = this.flushRenames(tree);
      this.popScope(scope);
      return tree;
    },
    transformGetAccessor: function(tree) {
      var $__12 = this;
      return this.transformFunctionForScope_((function() {
        return $traceurRuntime.superGet($__12, $BlockBindingTransformer.prototype, "transformGetAccessor").call($__12, tree);
      }), tree);
    },
    transformSetAccessor: function(tree) {
      var $__12 = this;
      return this.transformFunctionForScope_((function() {
        return $traceurRuntime.superGet($__12, $BlockBindingTransformer.prototype, "transformSetAccessor").call($__12, tree);
      }), tree);
    },
    transformFunctionExpression: function(tree) {
      var $__12 = this;
      return this.transformFunctionForScope_((function() {
        return $traceurRuntime.superGet($__12, $BlockBindingTransformer.prototype, "transformFunctionExpression").call($__12, tree);
      }), tree);
    },
    transformFunctionDeclaration: function(tree) {
      var $__12 = this;
      if (!this.scope_.isVarScope) {
        var origName = tree.name.getStringValue();
        var newName = this.newNameFromOrig(origName, this.blockRenames_);
        var functionExpression = new FunctionExpression(tree.location, null, tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
        this.revisitTreeForScopes(functionExpression);
        functionExpression = this.transformAny(functionExpression);
        var bindingIdentifier = createBindingIdentifier(newName);
        var statement = new VariableStatement(tree.location, new VariableDeclarationList(tree.location, VAR, [new VariableDeclaration(tree.location, bindingIdentifier, null, functionExpression)]));
        this.scope_.renameBinding(origName, bindingIdentifier, VAR, this.reporter_);
        this.prependBlockStatement_.push(statement);
        return new AnonBlock(null, []);
      }
      return this.transformFunctionForScope_((function() {
        return $traceurRuntime.superGet($__12, $BlockBindingTransformer.prototype, "transformFunctionDeclaration").call($__12, tree);
      }), tree);
    },
    transformLoop_: function(func, tree, loopFactory) {
      var $__11 = this;
      var scope,
          initializerIsBlockBinding;
      if (tree.initializer && tree.initializer.type === VARIABLE_DECLARATION_LIST && tree.initializer.declarationType !== VAR) {
        initializerIsBlockBinding = true;
      }
      if (initializerIsBlockBinding) {
        scope = this.pushScope(tree);
      }
      var finder = new FindBlockBindingInLoop(tree, this.scopeBuilder_);
      finder.visitAny(tree);
      if (!finder.found) {
        if (initializerIsBlockBinding) {
          var renames = [];
          var initializer = new VariableDeclarationList(null, VAR, tree.initializer.declarations.map((function(declaration) {
            var origName = $__11.getVariableName_(declaration);
            var newName = $__11.newNameFromOrig(origName, renames);
            var bindingIdentifier = createBindingIdentifier(newName);
            $__11.scope_.renameBinding(origName, bindingIdentifier, VAR, $__11.reporter_);
            return new VariableDeclaration(null, bindingIdentifier, null, declaration.initializer);
          })));
          initializer = renameAll(renames, initializer);
          tree = loopFactory(initializer, renames, renameAll(renames, tree.body));
          this.revisitTreeForScopes(tree);
          tree = func(tree);
        } else {
          return func(tree);
        }
      } else {
        var iifeParameterList = [];
        var iifeArgumentList = [];
        var renames = [];
        var initializer = null;
        if (tree.initializer && tree.initializer.type === VARIABLE_DECLARATION_LIST && tree.initializer.declarationType !== VAR) {
          initializer = new VariableDeclarationList(null, VAR, tree.initializer.declarations.map((function(declaration) {
            var origName = $__11.getVariableName_(declaration);
            var newName = $__11.newNameFromOrig(origName, renames);
            iifeArgumentList.push(createIdentifierExpression(newName));
            iifeParameterList.push(new FormalParameter(null, new BindingElement(null, createBindingIdentifier(origName), null), null, []));
            var bindingIdentifier = createBindingIdentifier(newName);
            $__11.scope_.renameBinding(origName, bindingIdentifier, VAR, $__11.reporter_);
            return new VariableDeclaration(null, bindingIdentifier, null, declaration.initializer);
          })));
          initializer = renameAll(renames, initializer);
        } else {
          initializer = this.transformAny(tree.initializer);
        }
        var loopLabel = this.labelledLoops_.get(tree);
        var iifeInfo = FnExtractAbruptCompletions.createIIFE(this.idGenerator_, tree.body, iifeParameterList, iifeArgumentList, (function() {
          return loopLabel = loopLabel || $__11.idGenerator_.generateUniqueIdentifier();
        }));
        tree = loopFactory(initializer, renames, iifeInfo.loopBody);
        if (loopLabel) {
          tree = new LabelledStatement(tree.location, createIdentifierToken(loopLabel), tree);
        }
        tree = new AnonBlock(tree.location, [iifeInfo.variableStatements, tree]);
        this.revisitTreeForScopes(tree);
        tree = this.transformAny(tree);
      }
      if (initializerIsBlockBinding) {
        tree = this.flushRenames(tree);
        this.popScope(scope);
      }
      return tree;
    },
    transformForInStatement: function(tree) {
      var $__12 = this;
      return this.transformLoop_((function(t) {
        return $traceurRuntime.superGet($__12, $BlockBindingTransformer.prototype, "transformForInStatement").call($__12, t);
      }), tree, (function(initializer, renames, body) {
        return new ForInStatement(tree.location, initializer, renameAll(renames, tree.collection), body);
      }));
    },
    transformForStatement: function(tree) {
      var $__12 = this;
      return this.transformLoop_((function(t) {
        return $traceurRuntime.superGet($__12, $BlockBindingTransformer.prototype, "transformForStatement").call($__12, t);
      }), tree, (function(initializer, renames, body) {
        return new ForStatement(tree.location, initializer, renameAll(renames, tree.condition), renameAll(renames, tree.increment), body);
      }));
    },
    transformWhileStatement: function(tree) {
      var $__12 = this;
      return this.transformLoop_((function(t) {
        return $traceurRuntime.superGet($__12, $BlockBindingTransformer.prototype, "transformWhileStatement").call($__12, t);
      }), tree, (function(initializer, renames, body) {
        return new WhileStatement(tree.location, renameAll(renames, tree.condition), body);
      }));
    },
    transformDoWhileStatement: function(tree) {
      var $__12 = this;
      return this.transformLoop_((function(t) {
        return $traceurRuntime.superGet($__12, $BlockBindingTransformer.prototype, "transformDoWhileStatement").call($__12, t);
      }), tree, (function(initializer, renames, body) {
        return new DoWhileStatement(tree.location, body, renameAll(renames, tree.condition));
      }));
    },
    transformLabelledStatement: function(tree) {
      if (tree.statement.isIterationStatement()) {
        this.labelledLoops_.set(tree.statement, tree.name.value);
        var statement = this.transformAny(tree.statement);
        if (!statement.isStatement()) {
          return statement;
        }
        if (statement === tree.statement) {
          return tree;
        }
        return new LabelledStatement(tree.location, tree.name, statement);
      }
      return $traceurRuntime.superGet(this, $BlockBindingTransformer.prototype, "transformLabelledStatement").call(this, tree);
    }
  }, {}, ParseTreeTransformer);
  var Rename = function Rename(oldName, newName) {
    this.oldName = oldName;
    this.newName = newName;
  };
  ($traceurRuntime.createClass)(Rename, {}, {});
  function renameAll(renames, tree) {
    renames.forEach((function(rename) {
      tree = AlphaRenamer.rename(tree, rename.oldName, rename.newName);
    }));
    return tree;
  }
  var FindBlockBindingInLoop = function FindBlockBindingInLoop(tree, scopeBuilder) {
    $traceurRuntime.superConstructor($FindBlockBindingInLoop).call(this);
    this.scopeBuilder_ = scopeBuilder;
    this.topScope_ = scopeBuilder.getScopeForTree(tree) || scopeBuilder.getScopeForTree(tree.body);
    this.outOfScope_ = null;
    this.acceptLoop_ = tree.isIterationStatement();
  };
  var $FindBlockBindingInLoop = FindBlockBindingInLoop;
  ($traceurRuntime.createClass)(FindBlockBindingInLoop, {
    visitForInStatement: function(tree) {
      var $__12 = this;
      this.visitLoop_(tree, (function() {
        return $traceurRuntime.superGet($__12, $FindBlockBindingInLoop.prototype, "visitForInStatement").call($__12, tree);
      }));
    },
    visitForStatement: function(tree) {
      var $__12 = this;
      this.visitLoop_(tree, (function() {
        return $traceurRuntime.superGet($__12, $FindBlockBindingInLoop.prototype, "visitForStatement").call($__12, tree);
      }));
    },
    visitWhileStatement: function(tree) {
      var $__12 = this;
      this.visitLoop_(tree, (function() {
        return $traceurRuntime.superGet($__12, $FindBlockBindingInLoop.prototype, "visitWhileStatement").call($__12, tree);
      }));
    },
    visitDoWhileStatement: function(tree) {
      var $__12 = this;
      this.visitLoop_(tree, (function() {
        return $traceurRuntime.superGet($__12, $FindBlockBindingInLoop.prototype, "visitDoWhileStatement").call($__12, tree);
      }));
    },
    visitLoop_: function(tree, func) {
      if (this.acceptLoop_) {
        this.acceptLoop_ = false;
      } else if (!this.outOfScope_) {
        this.outOfScope_ = this.scopeBuilder_.getScopeForTree(tree) || this.scopeBuilder_.getScopeForTree(tree.body);
      }
      func();
    },
    visitFunctionDeclaration: function(tree) {
      this.visitFunction_(tree);
    },
    visitFunctionExpression: function(tree) {
      this.visitFunction_(tree);
    },
    visitSetAccessor: function(tree) {
      this.visitFunction_(tree);
    },
    visitGetAccessor: function(tree) {
      this.visitFunction_(tree);
    },
    visitPropertyMethodAssignment: function(tree) {
      this.visitFunction_(tree);
    },
    visitArrowFunctionExpression: function(tree) {
      this.visitFunction_(tree);
    },
    visitFunction_: function(tree) {
      var $__11 = this;
      this.found = new FindIdentifiers(tree, (function(identifierToken, identScope) {
        identScope = $__11.scopeBuilder_.getScopeForTree(identScope);
        var fnScope = $__11.outOfScope_ || $__11.scopeBuilder_.getScopeForTree(tree);
        if (identScope.hasLexicalBindingName(identifierToken)) {
          return false;
        }
        while (identScope !== fnScope && (identScope = identScope.parent)) {
          if (identScope.hasLexicalBindingName(identifierToken)) {
            return false;
          }
        }
        while (fnScope = fnScope.parent) {
          if (fnScope.hasLexicalBindingName(identifierToken)) {
            return true;
          }
          if (fnScope === $__11.topScope_)
            break;
        }
        return false;
      })).found;
    }
  }, {}, FindVisitor);
  return {get BlockBindingTransformer() {
      return BlockBindingTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/MakeStrictTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/MakeStrictTransformer.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      FunctionBody = $__0.FunctionBody,
      Script = $__0.Script;
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var createUseStrictDirective = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js").createUseStrictDirective;
  var hasUseStrict = System.get("traceur@0.0.80/src/semantics/util.js").hasUseStrict;
  function prepend(statements) {
    return $traceurRuntime.spread([createUseStrictDirective()], statements);
  }
  var MakeStrictTransformer = function MakeStrictTransformer() {
    $traceurRuntime.superConstructor($MakeStrictTransformer).apply(this, arguments);
  };
  var $MakeStrictTransformer = MakeStrictTransformer;
  ($traceurRuntime.createClass)(MakeStrictTransformer, {
    transformScript: function(tree) {
      if (hasUseStrict(tree.scriptItemList))
        return tree;
      return new Script(tree.location, prepend(tree.scriptItemList));
    },
    transformFunctionBody: function(tree) {
      if (hasUseStrict(tree.statements))
        return tree;
      return new FunctionBody(tree.location, prepend(tree.statements));
    }
  }, {transformTree: function(tree) {
      return new $MakeStrictTransformer().transformAny(tree);
    }}, ParseTreeTransformer);
  return {get MakeStrictTransformer() {
      return MakeStrictTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/assignmentOperatorToBinaryOperator.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/assignmentOperatorToBinaryOperator.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      AMPERSAND = $__0.AMPERSAND,
      AMPERSAND_EQUAL = $__0.AMPERSAND_EQUAL,
      BAR = $__0.BAR,
      BAR_EQUAL = $__0.BAR_EQUAL,
      CARET = $__0.CARET,
      CARET_EQUAL = $__0.CARET_EQUAL,
      LEFT_SHIFT = $__0.LEFT_SHIFT,
      LEFT_SHIFT_EQUAL = $__0.LEFT_SHIFT_EQUAL,
      MINUS = $__0.MINUS,
      MINUS_EQUAL = $__0.MINUS_EQUAL,
      PERCENT = $__0.PERCENT,
      PERCENT_EQUAL = $__0.PERCENT_EQUAL,
      PLUS = $__0.PLUS,
      PLUS_EQUAL = $__0.PLUS_EQUAL,
      RIGHT_SHIFT = $__0.RIGHT_SHIFT,
      RIGHT_SHIFT_EQUAL = $__0.RIGHT_SHIFT_EQUAL,
      SLASH = $__0.SLASH,
      SLASH_EQUAL = $__0.SLASH_EQUAL,
      STAR = $__0.STAR,
      STAR_EQUAL = $__0.STAR_EQUAL,
      STAR_STAR = $__0.STAR_STAR,
      STAR_STAR_EQUAL = $__0.STAR_STAR_EQUAL,
      UNSIGNED_RIGHT_SHIFT = $__0.UNSIGNED_RIGHT_SHIFT,
      UNSIGNED_RIGHT_SHIFT_EQUAL = $__0.UNSIGNED_RIGHT_SHIFT_EQUAL;
  function assignmentOperatorToBinaryOperator(type) {
    switch (type) {
      case STAR_EQUAL:
        return STAR;
      case STAR_STAR_EQUAL:
        return STAR_STAR;
      case SLASH_EQUAL:
        return SLASH;
      case PERCENT_EQUAL:
        return PERCENT;
      case PLUS_EQUAL:
        return PLUS;
      case MINUS_EQUAL:
        return MINUS;
      case LEFT_SHIFT_EQUAL:
        return LEFT_SHIFT;
      case RIGHT_SHIFT_EQUAL:
        return RIGHT_SHIFT;
      case UNSIGNED_RIGHT_SHIFT_EQUAL:
        return UNSIGNED_RIGHT_SHIFT;
      case AMPERSAND_EQUAL:
        return AMPERSAND;
      case CARET_EQUAL:
        return CARET;
      case BAR_EQUAL:
        return BAR;
      default:
        throw Error('unreachable');
    }
  }
  var $__default = assignmentOperatorToBinaryOperator;
  return {get default() {
      return $__default;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ExplodeExpressionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ExplodeExpressionTransformer.js";
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var $__1 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createAssignmentExpression = $__1.createAssignmentExpression,
      createCommaExpression = $__1.createCommaExpression,
      id = $__1.createIdentifierExpression,
      createMemberExpression = $__1.createMemberExpression,
      createNumberLiteral = $__1.createNumberLiteral,
      createOperatorToken = $__1.createOperatorToken,
      createParenExpression = $__1.createParenExpression;
  var $__2 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      AND = $__2.AND,
      EQUAL = $__2.EQUAL,
      MINUS = $__2.MINUS,
      MINUS_EQUAL = $__2.MINUS_EQUAL,
      MINUS_MINUS = $__2.MINUS_MINUS,
      OR = $__2.OR,
      PLUS = $__2.PLUS,
      PLUS_EQUAL = $__2.PLUS_EQUAL,
      PLUS_PLUS = $__2.PLUS_PLUS;
  var $__3 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      COMMA_EXPRESSION = $__3.COMMA_EXPRESSION,
      IDENTIFIER_EXPRESSION = $__3.IDENTIFIER_EXPRESSION,
      MEMBER_EXPRESSION = $__3.MEMBER_EXPRESSION,
      MEMBER_LOOKUP_EXPRESSION = $__3.MEMBER_LOOKUP_EXPRESSION,
      PROPERTY_NAME_ASSIGNMENT = $__3.PROPERTY_NAME_ASSIGNMENT,
      SPREAD_EXPRESSION = $__3.SPREAD_EXPRESSION,
      TEMPLATE_LITERAL_PORTION = $__3.TEMPLATE_LITERAL_PORTION;
  var $__4 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      ArgumentList = $__4.ArgumentList,
      ArrayLiteralExpression = $__4.ArrayLiteralExpression,
      AwaitExpression = $__4.AwaitExpression,
      BinaryExpression = $__4.BinaryExpression,
      CallExpression = $__4.CallExpression,
      ConditionalExpression = $__4.ConditionalExpression,
      MemberExpression = $__4.MemberExpression,
      MemberLookupExpression = $__4.MemberLookupExpression,
      NewExpression = $__4.NewExpression,
      ObjectLiteralExpression = $__4.ObjectLiteralExpression,
      PropertyNameAssignment = $__4.PropertyNameAssignment,
      SpreadExpression = $__4.SpreadExpression,
      TemplateLiteralExpression = $__4.TemplateLiteralExpression,
      TemplateSubstitution = $__4.TemplateSubstitution,
      UnaryExpression = $__4.UnaryExpression,
      YieldExpression = $__4.YieldExpression;
  var assert = System.get("traceur@0.0.80/src/util/assert.js").assert;
  var assignmentOperatorToBinaryOperator = System.get("traceur@0.0.80/src/codegeneration/assignmentOperatorToBinaryOperator.js").default;
  var CommaExpressionBuilder = function CommaExpressionBuilder(tempVar) {
    this.tempVar = tempVar;
    this.expressions = [];
  };
  ($traceurRuntime.createClass)(CommaExpressionBuilder, {
    add: function(tree) {
      var $__8;
      if (tree.type === COMMA_EXPRESSION)
        ($__8 = this.expressions).push.apply($__8, $traceurRuntime.spread(getExpressions(tree)));
      return this;
    },
    build: function(tree) {
      var tempVar = this.tempVar;
      this.expressions.push(createAssignmentExpression(tempVar, tree), tempVar);
      return createCommaExpression(this.expressions);
    }
  }, {});
  function getResult(tree) {
    if (tree.type === COMMA_EXPRESSION)
      return tree.expressions[tree.expressions.length - 1];
    return tree;
  }
  function getExpressions(tree) {
    if (tree.type === COMMA_EXPRESSION)
      return tree.expressions.slice(0, -1);
    return [];
  }
  var ExplodeExpressionTransformer = function ExplodeExpressionTransformer(tempVarTransformer) {
    $traceurRuntime.superConstructor($ExplodeExpressionTransformer).call(this);
    this.tempVarTransformer_ = tempVarTransformer;
  };
  var $ExplodeExpressionTransformer = ExplodeExpressionTransformer;
  ($traceurRuntime.createClass)(ExplodeExpressionTransformer, {
    addTempVar: function() {
      var tmpId = this.tempVarTransformer_.addTempVar();
      return id(tmpId);
    },
    transformUnaryExpression: function(tree) {
      if (tree.operator.type == PLUS_PLUS)
        return this.transformUnaryNumeric(tree, PLUS_EQUAL);
      if (tree.operator.type == MINUS_MINUS)
        return this.transformUnaryNumeric(tree, MINUS_EQUAL);
      var operand = this.transformAny(tree.operand);
      if (operand === tree.operand)
        return tree;
      var expressions = $traceurRuntime.spread(getExpressions(operand), [new UnaryExpression(tree.location, tree.operator, getResult(operand))]);
      return createCommaExpression(expressions);
    },
    transformUnaryNumeric: function(tree, operator) {
      return this.transformAny(new BinaryExpression(tree.location, tree.operand, createOperatorToken(operator), createNumberLiteral(1)));
    },
    transformPostfixExpression: function(tree) {
      if (tree.operand.type === MEMBER_EXPRESSION)
        return this.transformPostfixMemberExpression(tree);
      if (tree.operand.type === MEMBER_LOOKUP_EXPRESSION)
        return this.transformPostfixMemberLookupExpression(tree);
      assert(tree.operand.type === IDENTIFIER_EXPRESSION);
      var operand = tree.operand;
      var tmp = this.addTempVar();
      var operator = tree.operator.type === PLUS_PLUS ? PLUS : MINUS;
      var expressions = [createAssignmentExpression(tmp, operand), createAssignmentExpression(operand, new BinaryExpression(tree.location, tmp, createOperatorToken(operator), createNumberLiteral(1))), tmp];
      return createCommaExpression(expressions);
    },
    transformPostfixMemberExpression: function(tree) {
      var memberName = tree.operand.memberName;
      var operand = this.transformAny(tree.operand.operand);
      var tmp = this.addTempVar();
      var memberExpression = new MemberExpression(tree.operand.location, getResult(operand), memberName);
      var operator = tree.operator.type === PLUS_PLUS ? PLUS : MINUS;
      var expressions = $traceurRuntime.spread(getExpressions(operand), [createAssignmentExpression(tmp, memberExpression), createAssignmentExpression(memberExpression, new BinaryExpression(tree.location, tmp, createOperatorToken(operator), createNumberLiteral(1))), tmp]);
      return createCommaExpression(expressions);
    },
    transformPostfixMemberLookupExpression: function(tree) {
      var memberExpression = this.transformAny(tree.operand.memberExpression);
      var operand = this.transformAny(tree.operand.operand);
      var tmp = this.addTempVar();
      var memberLookupExpression = new MemberLookupExpression(null, getResult(operand), getResult(memberExpression));
      var operator = tree.operator.type === PLUS_PLUS ? PLUS : MINUS;
      var expressions = $traceurRuntime.spread(getExpressions(operand), getExpressions(memberExpression), [createAssignmentExpression(tmp, memberLookupExpression), createAssignmentExpression(memberLookupExpression, new BinaryExpression(tree.location, tmp, createOperatorToken(operator), createNumberLiteral(1))), tmp]);
      return createCommaExpression(expressions);
    },
    transformYieldExpression: function(tree) {
      var expression = this.transformAny(tree.expression);
      return this.createCommaExpressionBuilder().add(expression).build(new YieldExpression(tree.location, getResult(expression), tree.isYieldFor));
    },
    transformAwaitExpression: function(tree) {
      var expression = this.transformAny(tree.expression);
      return this.createCommaExpressionBuilder().add(expression).build(new AwaitExpression(tree.location, getResult(expression)));
    },
    transformParenExpression: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression)
        return tree;
      var result = getResult(expression);
      if (result.type === IDENTIFIER_EXPRESSION)
        return expression;
      return this.createCommaExpressionBuilder().add(expression).build(result);
    },
    transformCommaExpression: function(tree) {
      var expressions = this.transformList(tree.expressions);
      if (expressions === tree.expressions)
        return tree;
      var builder = new CommaExpressionBuilder(null);
      for (var i = 0; i < expressions.length; i++) {
        builder.add(expressions[i]);
      }
      return createCommaExpression($traceurRuntime.spread(builder.expressions, [getResult(expressions[expressions.length - 1])]));
    },
    transformMemberExpression: function(tree) {
      var operand = this.transformAny(tree.operand);
      return this.createCommaExpressionBuilder().add(operand).build(new MemberExpression(tree.location, getResult(operand), tree.memberName));
    },
    transformMemberLookupExpression: function(tree) {
      var operand = this.transformAny(tree.operand);
      var memberExpression = this.transformAny(tree.memberExpression);
      return this.createCommaExpressionBuilder().add(operand).add(memberExpression).build(new MemberLookupExpression(tree.location, getResult(operand), getResult(memberExpression)));
    },
    transformBinaryExpression: function(tree) {
      if (tree.operator.isAssignmentOperator())
        return this.transformAssignmentExpression(tree);
      var left = this.transformAny(tree.left);
      var right = this.transformAny(tree.right);
      if (left === tree.left && right === tree.right)
        return tree;
      if (tree.operator.type === OR)
        return this.transformOr(left, right);
      if (tree.operator.type === AND)
        return this.transformAnd(left, right);
      var expressions = $traceurRuntime.spread(getExpressions(left), getExpressions(right), [new BinaryExpression(tree.location, getResult(left), tree.operator, getResult(right))]);
      return createCommaExpression(expressions);
    },
    transformAssignmentExpression: function(tree) {
      var left = tree.left;
      if (left.type === MEMBER_EXPRESSION)
        return this.transformAssignMemberExpression(tree);
      if (left.type === MEMBER_LOOKUP_EXPRESSION)
        return this.transformAssignMemberLookupExpression(tree);
      assert(tree.left.type === IDENTIFIER_EXPRESSION);
      if (tree.operator.type === EQUAL) {
        var left = this.transformAny(left);
        var right = this.transformAny(tree.right);
        var expressions = $traceurRuntime.spread(getExpressions(right), [createAssignmentExpression(left, getResult(right)), getResult(right)]);
        return createCommaExpression(expressions);
      }
      var right = this.transformAny(tree.right);
      var tmp = this.addTempVar();
      var binop = createOperatorToken(assignmentOperatorToBinaryOperator(tree.operator.type));
      var expressions = $traceurRuntime.spread(getExpressions(right), [createAssignmentExpression(tmp, new BinaryExpression(tree.location, left, binop, getResult(right))), createAssignmentExpression(left, tmp), tmp]);
      return createCommaExpression(expressions);
    },
    transformAssignMemberExpression: function(tree) {
      var left = tree.left;
      if (tree.operator.type === EQUAL) {
        var operand = this.transformAny(left.operand);
        var right = this.transformAny(tree.right);
        var expressions = $traceurRuntime.spread(getExpressions(operand), getExpressions(right), [new BinaryExpression(tree.location, new MemberExpression(left.location, getResult(operand), left.memberName), tree.operator, getResult(right)), getResult(right)]);
        return createCommaExpression(expressions);
      }
      var operand = this.transformAny(left.operand);
      var right = this.transformAny(tree.right);
      var tmp = this.addTempVar();
      var memberExpression = new MemberExpression(left.location, getResult(operand), left.memberName);
      var tmp2 = this.addTempVar();
      var binop = createOperatorToken(assignmentOperatorToBinaryOperator(tree.operator.type));
      var expressions = $traceurRuntime.spread(getExpressions(operand), getExpressions(right), [createAssignmentExpression(tmp, memberExpression), createAssignmentExpression(tmp2, new BinaryExpression(tree.location, tmp, binop, getResult(right))), createAssignmentExpression(memberExpression, tmp2), tmp2]);
      return createCommaExpression(expressions);
    },
    transformAssignMemberLookupExpression: function(tree) {
      var left = tree.left;
      if (tree.operator.type === EQUAL) {
        var operand = this.transformAny(left.operand);
        var memberExpression = this.transformAny(left.memberExpression);
        var right = this.transformAny(tree.right);
        var expressions = $traceurRuntime.spread(getExpressions(operand), getExpressions(memberExpression), getExpressions(right), [new BinaryExpression(tree.location, new MemberLookupExpression(left.location, getResult(operand), getResult(memberExpression)), tree.operator, getResult(right)), getResult(right)]);
        return createCommaExpression(expressions);
      }
      var operand = this.transformAny(left.operand);
      var memberExpression = this.transformAny(left.memberExpression);
      var right = this.transformAny(tree.right);
      var tmp = this.addTempVar();
      var memberLookupExpression = new MemberLookupExpression(left.location, getResult(operand), getResult(memberExpression));
      var tmp2 = this.addTempVar();
      var binop = createOperatorToken(assignmentOperatorToBinaryOperator(tree.operator.type));
      var expressions = $traceurRuntime.spread(getExpressions(operand), getExpressions(memberExpression), getExpressions(right), [createAssignmentExpression(tmp, memberLookupExpression), createAssignmentExpression(tmp2, new BinaryExpression(tree.location, tmp, binop, getResult(right))), createAssignmentExpression(memberLookupExpression, tmp2), tmp2]);
      return createCommaExpression(expressions);
    },
    transformArrayLiteralExpression: function(tree) {
      var elements = this.transformList(tree.elements);
      if (elements === tree.elements)
        return tree;
      var builder = this.createCommaExpressionBuilder();
      var results = [];
      for (var i = 0; i < elements.length; i++) {
        builder.add(elements[i]);
        results.push(getResult(elements[i]));
      }
      return builder.build(new ArrayLiteralExpression(tree.location, results));
    },
    transformObjectLiteralExpression: function(tree) {
      var propertyNameAndValues = this.transformList(tree.propertyNameAndValues);
      if (propertyNameAndValues === tree.propertyNameAndValues)
        return tree;
      var builder = this.createCommaExpressionBuilder();
      var results = [];
      for (var i = 0; i < propertyNameAndValues.length; i++) {
        if (propertyNameAndValues[i].type === PROPERTY_NAME_ASSIGNMENT) {
          builder.add(propertyNameAndValues[i].value);
          results.push(new PropertyNameAssignment(propertyNameAndValues[i].location, propertyNameAndValues[i].name, getResult(propertyNameAndValues[i].value)));
        } else {
          results.push(propertyNameAndValues[i]);
        }
      }
      return builder.build(new ObjectLiteralExpression(tree.location, results));
    },
    transformTemplateLiteralExpression: function(tree) {
      var operand = this.transformAny(tree.operand);
      var elements = this.transformList(tree.elements);
      if (!operand && operand === tree.operand && elements === tree.elements)
        return tree;
      var builder = this.createCommaExpressionBuilder();
      if (operand)
        builder.add(operand);
      var results = [];
      for (var i = 0; i < elements.length; i++) {
        if (elements[i].type === TEMPLATE_LITERAL_PORTION) {
          results.push(elements[i]);
        } else {
          var expression = elements[i].expression;
          builder.add(expression);
          var result = getResult(expression);
          results.push(new TemplateSubstitution(expression.location, result));
        }
      }
      return builder.build(new TemplateLiteralExpression(tree.location, operand && getResult(operand), results));
    },
    transformCallExpression: function(tree) {
      if (tree.operand.type === MEMBER_EXPRESSION)
        return this.transformCallMemberExpression(tree);
      if (tree.operand.type === MEMBER_LOOKUP_EXPRESSION)
        return this.transformCallMemberLookupExpression(tree);
      return this.transformCallAndNew_(tree, CallExpression);
    },
    transformNewExpression: function(tree) {
      return this.transformCallAndNew_(tree, NewExpression);
    },
    transformCallAndNew_: function(tree, ctor) {
      var operand = this.transformAny(tree.operand);
      var args = this.transformAny(tree.args);
      var builder = this.createCommaExpressionBuilder().add(operand);
      var argResults = [];
      args.args.forEach((function(arg) {
        builder.add(arg);
        argResults.push(getResult(arg));
      }));
      return builder.build(new ctor(tree.location, getResult(operand), new ArgumentList(args.location, argResults)));
    },
    transformCallMemberExpression: function(tree) {
      var memberName = tree.operand.memberName;
      var operand = this.transformAny(tree.operand.operand);
      var tmp = this.addTempVar();
      var memberExpresssion = new MemberExpression(tree.operand.location, getResult(operand), memberName);
      var args = this.transformAny(tree.args);
      var expressions = $traceurRuntime.spread(getExpressions(operand), [createAssignmentExpression(tmp, memberExpresssion)]);
      var argResults = [getResult(operand)];
      args.args.forEach((function(arg) {
        var $__8;
        ($__8 = expressions).push.apply($__8, $traceurRuntime.spread(getExpressions(arg)));
        argResults.push(getResult(arg));
      }));
      var callExpression = new CallExpression(tree.location, createMemberExpression(tmp, 'call'), new ArgumentList(args.location, argResults));
      var tmp2 = this.addTempVar();
      expressions.push(createAssignmentExpression(tmp2, callExpression), tmp2);
      return createCommaExpression(expressions);
    },
    transformCallMemberLookupExpression: function(tree) {
      var operand = this.transformAny(tree.operand.operand);
      var memberExpression = this.transformAny(tree.operand.memberExpression);
      var tmp = this.addTempVar();
      var lookupExpresssion = new MemberLookupExpression(tree.operand.location, getResult(operand), getResult(memberExpression));
      var args = this.transformAny(tree.args);
      var expressions = $traceurRuntime.spread(getExpressions(operand), getExpressions(memberExpression), [createAssignmentExpression(tmp, lookupExpresssion)]);
      var argResults = [getResult(operand)];
      args.args.forEach((function(arg, i) {
        var $__8;
        ($__8 = expressions).push.apply($__8, $traceurRuntime.spread(getExpressions(arg)));
        var result = getResult(arg);
        if (tree.args.args[i].type === SPREAD_EXPRESSION)
          result = new SpreadExpression(arg.location, result);
        argResults.push(result);
      }));
      var callExpression = new CallExpression(tree.location, createMemberExpression(tmp, 'call'), new ArgumentList(args.location, argResults));
      var tmp2 = this.addTempVar();
      expressions.push(createAssignmentExpression(tmp2, callExpression), tmp2);
      return createCommaExpression(expressions);
    },
    transformConditionalExpression: function(tree) {
      var condition = this.transformAny(tree.condition);
      var left = this.transformAny(tree.left);
      var right = this.transformAny(tree.right);
      if (condition === tree.condition && left === tree.left && right === tree.right)
        return tree;
      var res = this.addTempVar();
      var leftTree = createCommaExpression($traceurRuntime.spread(getExpressions(left), [createAssignmentExpression(res, getResult(left))]));
      var rightTree = createCommaExpression($traceurRuntime.spread(getExpressions(right), [createAssignmentExpression(res, getResult(right))]));
      var expressions = $traceurRuntime.spread(getExpressions(condition), [new ConditionalExpression(tree.location, getResult(condition), createParenExpression(leftTree), createParenExpression(rightTree)), res]);
      return createCommaExpression(expressions);
    },
    transformOr: function(left, right) {
      var res = this.addTempVar();
      var leftTree = createCommaExpression([createAssignmentExpression(res, getResult(left))]);
      var rightTree = createCommaExpression($traceurRuntime.spread(getExpressions(right), [createAssignmentExpression(res, getResult(right))]));
      var expressions = $traceurRuntime.spread(getExpressions(left), [new ConditionalExpression(left.location, getResult(left), createParenExpression(leftTree), createParenExpression(rightTree)), res]);
      return createCommaExpression(expressions);
    },
    transformAnd: function(left, right) {
      var res = this.addTempVar();
      var leftTree = createCommaExpression($traceurRuntime.spread(getExpressions(right), [createAssignmentExpression(res, getResult(right))]));
      var rightTree = createCommaExpression([createAssignmentExpression(res, getResult(left))]);
      var expressions = $traceurRuntime.spread(getExpressions(left), [new ConditionalExpression(left.location, getResult(left), createParenExpression(leftTree), createParenExpression(rightTree)), res]);
      return createCommaExpression(expressions);
    },
    transformSpreadExpression: function(tree) {
      var expression = this.transformAny(tree.expression);
      if (expression === tree.expression)
        return tree;
      var result = getResult(expression);
      if (result.type !== SPREAD_EXPRESSION)
        result = new SpreadExpression(result.location, result);
      var expressions = $traceurRuntime.spread(getExpressions(expression), [result]);
      return createCommaExpression(expressions);
    },
    createCommaExpressionBuilder: function() {
      return new CommaExpressionBuilder(this.addTempVar());
    }
  }, {}, ParseTreeTransformer);
  return {get ExplodeExpressionTransformer() {
      return ExplodeExpressionTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/SuperTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/SuperTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["$traceurRuntime.superConstructor(", ").call(", ")"], {raw: {value: Object.freeze(["$traceurRuntime.superConstructor(", ").call(", ")"])}})),
      $__1 = Object.freeze(Object.defineProperties(["", ".call(", ")"], {raw: {value: Object.freeze(["", ".call(", ")"])}})),
      $__2 = Object.freeze(Object.defineProperties(["$traceurRuntime.superGet(", ", ", ", ", ")"], {raw: {value: Object.freeze(["$traceurRuntime.superGet(", ", ", ", ", ")"])}})),
      $__3 = Object.freeze(Object.defineProperties(["$traceurRuntime.superSet(", ", ", ", ", ",\n                                    ", ")"], {raw: {value: Object.freeze(["$traceurRuntime.superSet(", ", ", ", ", ",\n                                    ", ")"])}}));
  var ExplodeExpressionTransformer = System.get("traceur@0.0.80/src/codegeneration/ExplodeExpressionTransformer.js").ExplodeExpressionTransformer;
  var $__5 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      FunctionDeclaration = $__5.FunctionDeclaration,
      FunctionExpression = $__5.FunctionExpression;
  var $__6 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      MEMBER_EXPRESSION = $__6.MEMBER_EXPRESSION,
      MEMBER_LOOKUP_EXPRESSION = $__6.MEMBER_LOOKUP_EXPRESSION,
      SUPER_EXPRESSION = $__6.SUPER_EXPRESSION;
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var $__8 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      EQUAL = $__8.EQUAL,
      MINUS_MINUS = $__8.MINUS_MINUS,
      PLUS_PLUS = $__8.PLUS_PLUS;
  var $__9 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createArgumentList = $__9.createArgumentList,
      createIdentifierExpression = $__9.createIdentifierExpression,
      createParenExpression = $__9.createParenExpression,
      createStringLiteral = $__9.createStringLiteral,
      createThisExpression = $__9.createThisExpression;
  var parseExpression = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseExpression;
  var ExplodeSuperExpression = function ExplodeSuperExpression() {
    $traceurRuntime.superConstructor($ExplodeSuperExpression).apply(this, arguments);
  };
  var $ExplodeSuperExpression = ExplodeSuperExpression;
  ($traceurRuntime.createClass)(ExplodeSuperExpression, {
    transformArrowFunctionExpression: function(tree) {
      return tree;
    },
    transformClassExpression: function(tree) {
      return tree;
    },
    transformFunctionBody: function(tree) {
      return tree;
    }
  }, {}, ExplodeExpressionTransformer);
  var SuperTransformer = function SuperTransformer(tempVarTransformer, protoName, thisName, internalName) {
    this.tempVarTransformer_ = tempVarTransformer;
    this.protoName_ = protoName;
    this.internalName_ = internalName;
    this.superCount_ = 0;
    this.thisVar_ = createIdentifierExpression(thisName);
    this.inNestedFunc_ = 0;
    this.nestedSuperCount_ = 0;
  };
  var $SuperTransformer = SuperTransformer;
  ($traceurRuntime.createClass)(SuperTransformer, {
    get hasSuper() {
      return this.superCount_ > 0;
    },
    get nestedSuper() {
      return this.nestedSuperCount_ > 0;
    },
    transformFunctionDeclaration: function(tree) {
      return this.transformFunction_(tree, FunctionDeclaration);
    },
    transformFunctionExpression: function(tree) {
      return this.transformFunction_(tree, FunctionExpression);
    },
    transformFunction_: function(tree, constructor) {
      var oldSuperCount = this.superCount_;
      this.inNestedFunc_++;
      var transformedTree = constructor === FunctionExpression ? $traceurRuntime.superGet(this, $SuperTransformer.prototype, "transformFunctionExpression").call(this, tree) : $traceurRuntime.superGet(this, $SuperTransformer.prototype, "transformFunctionDeclaration").call(this, tree);
      this.inNestedFunc_--;
      if (oldSuperCount !== this.superCount_)
        this.nestedSuperCount_ += this.superCount_ - oldSuperCount;
      return transformedTree;
    },
    transformGetAccessor: function(tree) {
      return tree;
    },
    transformSetAccessor: function(tree) {
      return tree;
    },
    transformPropertyMethodAssignMent: function(tree) {
      return tree;
    },
    transformCallExpression: function(tree) {
      if (tree.operand.type == SUPER_EXPRESSION) {
        this.superCount_++;
        return this.createSuperCall_(tree);
      }
      if (hasSuperMemberExpression(tree.operand)) {
        this.superCount_++;
        var name;
        if (tree.operand.type == MEMBER_EXPRESSION)
          name = tree.operand.memberName.value;
        else
          name = tree.operand.memberExpression;
        return this.createSuperCallMethod_(name, tree);
      }
      return $traceurRuntime.superGet(this, $SuperTransformer.prototype, "transformCallExpression").call(this, tree);
    },
    createSuperCall_: function(tree) {
      var thisExpr = this.inNestedFunc_ ? this.thisVar_ : createThisExpression();
      var args = createArgumentList($traceurRuntime.spread([thisExpr], tree.args.args));
      return parseExpression($__0, this.internalName_, args);
    },
    createSuperCallMethod_: function(methodName, tree) {
      var thisExpr = this.inNestedFunc_ ? this.thisVar_ : createThisExpression();
      var operand = this.transformMemberShared_(methodName);
      var args = createArgumentList($traceurRuntime.spread([thisExpr], tree.args.args));
      return parseExpression($__1, operand, args);
    },
    transformMemberShared_: function(name) {
      var thisExpr = this.inNestedFunc_ ? this.thisVar_ : createThisExpression();
      return parseExpression($__2, thisExpr, this.protoName_, name);
    },
    transformMemberExpression: function(tree) {
      if (tree.operand.type === SUPER_EXPRESSION) {
        this.superCount_++;
        return this.transformMemberShared_(tree.memberName.value);
      }
      return $traceurRuntime.superGet(this, $SuperTransformer.prototype, "transformMemberExpression").call(this, tree);
    },
    transformMemberLookupExpression: function(tree) {
      if (tree.operand.type === SUPER_EXPRESSION)
        return this.transformMemberShared_(tree.memberExpression);
      return $traceurRuntime.superGet(this, $SuperTransformer.prototype, "transformMemberLookupExpression").call(this, tree);
    },
    transformBinaryExpression: function(tree) {
      if (tree.operator.isAssignmentOperator() && hasSuperMemberExpression(tree.left)) {
        if (tree.operator.type !== EQUAL) {
          var exploded = new ExplodeSuperExpression(this.tempVarTransformer_).transformAny(tree);
          return this.transformAny(createParenExpression(exploded));
        }
        this.superCount_++;
        var name = tree.left.type === MEMBER_LOOKUP_EXPRESSION ? tree.left.memberExpression : createStringLiteral(tree.left.memberName.value);
        var thisExpr = this.inNestedFunc_ ? this.thisVar_ : createThisExpression();
        var right = this.transformAny(tree.right);
        return parseExpression($__3, thisExpr, this.protoName_, name, right);
      }
      return $traceurRuntime.superGet(this, $SuperTransformer.prototype, "transformBinaryExpression").call(this, tree);
    },
    transformUnaryExpression: function(tree) {
      var transformed = this.transformIncrementDecrement_(tree);
      if (transformed)
        return transformed;
      return $traceurRuntime.superGet(this, $SuperTransformer.prototype, "transformUnaryExpression").call(this, tree);
    },
    transformPostfixExpression: function(tree) {
      var transformed = this.transformIncrementDecrement_(tree);
      if (transformed)
        return transformed;
      return $traceurRuntime.superGet(this, $SuperTransformer.prototype, "transformPostfixExpression").call(this, tree);
    },
    transformIncrementDecrement_: function(tree) {
      var operator = tree.operator;
      var operand = tree.operand;
      if ((operator.type === PLUS_PLUS || operator.type === MINUS_MINUS) && hasSuperMemberExpression(operand)) {
        var exploded = new ExplodeSuperExpression(this.tempVarTransformer_).transformAny(tree);
        if (exploded !== tree)
          exploded = createParenExpression(exploded);
        return this.transformAny(exploded);
      }
      return null;
    }
  }, {}, ParseTreeTransformer);
  function hasSuperMemberExpression(tree) {
    if (tree.type !== MEMBER_EXPRESSION && tree.type !== MEMBER_LOOKUP_EXPRESSION)
      return false;
    return tree.operand.type === SUPER_EXPRESSION;
  }
  return {get SuperTransformer() {
      return SuperTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ClassTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ClassTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["($traceurRuntime.createClass)(", ", ", ", ", ",\n                                       ", ")"], {raw: {value: Object.freeze(["($traceurRuntime.createClass)(", ", ", ", ", ",\n                                       ", ")"])}})),
      $__1 = Object.freeze(Object.defineProperties(["($traceurRuntime.createClass)(", ", ", ", ", ")"], {raw: {value: Object.freeze(["($traceurRuntime.createClass)(", ", ", ", ", ")"])}})),
      $__2 = Object.freeze(Object.defineProperties(["var ", " = ", ""], {raw: {value: Object.freeze(["var ", " = ", ""])}})),
      $__3 = Object.freeze(Object.defineProperties(["var ", " = ", ""], {raw: {value: Object.freeze(["var ", " = ", ""])}})),
      $__4 = Object.freeze(Object.defineProperties(["function($__super) {\n          var ", " = ", ";\n          return ($traceurRuntime.createClass)(", ", ", ",\n                                               ", ", $__super);\n        }(", ")"], {raw: {value: Object.freeze(["function($__super) {\n          var ", " = ", ";\n          return ($traceurRuntime.createClass)(", ", ", ",\n                                               ", ", $__super);\n        }(", ")"])}})),
      $__5 = Object.freeze(Object.defineProperties(["function() {\n          var ", " = ", ";\n          return ($traceurRuntime.createClass)(", ", ", ",\n                                               ", ");\n        }()"], {raw: {value: Object.freeze(["function() {\n          var ", " = ", ";\n          return ($traceurRuntime.createClass)(", ", ", ",\n                                               ", ");\n        }()"])}})),
      $__6 = Object.freeze(Object.defineProperties(["$traceurRuntime.superConstructor(\n          ", ").apply(this, arguments)"], {raw: {value: Object.freeze(["$traceurRuntime.superConstructor(\n          ", ").apply(this, arguments)"])}}));
  var AlphaRenamer = System.get("traceur@0.0.80/src/codegeneration/AlphaRenamer.js").AlphaRenamer;
  var CONSTRUCTOR = System.get("traceur@0.0.80/src/syntax/PredefinedName.js").CONSTRUCTOR;
  var $__9 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AnonBlock = $__9.AnonBlock,
      ExportDeclaration = $__9.ExportDeclaration,
      FunctionExpression = $__9.FunctionExpression,
      GetAccessor = $__9.GetAccessor,
      PropertyMethodAssignment = $__9.PropertyMethodAssignment,
      SetAccessor = $__9.SetAccessor;
  var $__10 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      GET_ACCESSOR = $__10.GET_ACCESSOR,
      PROPERTY_METHOD_ASSIGNMENT = $__10.PROPERTY_METHOD_ASSIGNMENT,
      PROPERTY_VARIABLE_DECLARATION = $__10.PROPERTY_VARIABLE_DECLARATION,
      SET_ACCESSOR = $__10.SET_ACCESSOR;
  var SuperTransformer = System.get("traceur@0.0.80/src/codegeneration/SuperTransformer.js").SuperTransformer;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var MakeStrictTransformer = System.get("traceur@0.0.80/src/codegeneration/MakeStrictTransformer.js").MakeStrictTransformer;
  var $__15 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createEmptyParameterList = $__15.createEmptyParameterList,
      createExpressionStatement = $__15.createExpressionStatement,
      createFunctionBody = $__15.createFunctionBody,
      id = $__15.createIdentifierExpression,
      createMemberExpression = $__15.createMemberExpression,
      createObjectLiteralExpression = $__15.createObjectLiteralExpression,
      createParenExpression = $__15.createParenExpression,
      createThisExpression = $__15.createThisExpression,
      createVariableStatement = $__15.createVariableStatement;
  var hasUseStrict = System.get("traceur@0.0.80/src/semantics/util.js").hasUseStrict;
  var $__17 = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js"),
      parseExpression = $__17.parseExpression,
      parseStatement = $__17.parseStatement,
      parseStatements = $__17.parseStatements;
  var propName = System.get("traceur@0.0.80/src/staticsemantics/PropName.js").propName;
  function classCall(func, object, staticObject, superClass) {
    if (superClass) {
      return parseExpression($__0, func, object, staticObject, superClass);
    }
    return parseExpression($__1, func, object, staticObject);
  }
  var ClassTransformer = function ClassTransformer(identifierGenerator) {
    $traceurRuntime.superConstructor($ClassTransformer).call(this, identifierGenerator);
    this.strictCount_ = 0;
    this.state_ = null;
  };
  var $ClassTransformer = ClassTransformer;
  ($traceurRuntime.createClass)(ClassTransformer, {
    transformExportDeclaration: function(tree) {
      var transformed = $traceurRuntime.superGet(this, $ClassTransformer.prototype, "transformExportDeclaration").call(this, tree);
      if (transformed === tree)
        return tree;
      var declaration = transformed.declaration;
      if (declaration instanceof AnonBlock) {
        var statements = $traceurRuntime.spread([new ExportDeclaration(null, declaration.statements[0], [])], declaration.statements.slice(1));
        return new AnonBlock(null, statements);
      }
      return transformed;
    },
    transformModule: function(tree) {
      this.strictCount_ = 1;
      return $traceurRuntime.superGet(this, $ClassTransformer.prototype, "transformModule").call(this, tree);
    },
    transformScript: function(tree) {
      this.strictCount_ = +hasUseStrict(tree.scriptItemList);
      return $traceurRuntime.superGet(this, $ClassTransformer.prototype, "transformScript").call(this, tree);
    },
    transformFunctionBody: function(tree) {
      var useStrict = +hasUseStrict(tree.statements);
      this.strictCount_ += useStrict;
      var result = $traceurRuntime.superGet(this, $ClassTransformer.prototype, "transformFunctionBody").call(this, tree);
      this.strictCount_ -= useStrict;
      return result;
    },
    makeStrict_: function(tree) {
      if (this.strictCount_)
        return tree;
      return MakeStrictTransformer.transformTree(tree);
    },
    transformClassElements_: function(tree, internalName) {
      var $__19 = this;
      var oldState = this.state_;
      this.state_ = {hasSuper: false};
      var superClass = this.transformAny(tree.superClass);
      var hasConstructor = false;
      var protoElements = [],
          staticElements = [];
      var constructorBody,
          constructorParams;
      tree.elements.forEach((function(tree) {
        var elements,
            homeObject;
        if (tree.isStatic) {
          elements = staticElements;
          homeObject = internalName;
        } else {
          elements = protoElements;
          homeObject = createMemberExpression(internalName, 'prototype');
        }
        switch (tree.type) {
          case GET_ACCESSOR:
            elements.push($__19.transformGetAccessor_(tree, homeObject));
            break;
          case SET_ACCESSOR:
            elements.push($__19.transformSetAccessor_(tree, homeObject));
            break;
          case PROPERTY_METHOD_ASSIGNMENT:
            var transformed = $__19.transformPropertyMethodAssignment_(tree, homeObject, internalName);
            if (!tree.isStatic && propName(tree) === CONSTRUCTOR) {
              hasConstructor = true;
              constructorParams = transformed.parameterList;
              constructorBody = transformed.body;
            } else {
              elements.push(transformed);
            }
            break;
          case PROPERTY_VARIABLE_DECLARATION:
            break;
          default:
            throw new Error(("Unexpected class element: " + tree.type));
        }
      }));
      var object = createObjectLiteralExpression(protoElements);
      var staticObject = createObjectLiteralExpression(staticElements);
      var func;
      if (!hasConstructor) {
        func = this.getDefaultConstructor_(tree, internalName);
      } else {
        func = new FunctionExpression(tree.location, tree.name, false, constructorParams, null, [], constructorBody);
      }
      var state = this.state_;
      this.state_ = oldState;
      return {
        func: func,
        superClass: superClass,
        object: object,
        staticObject: staticObject,
        hasSuper: state.hasSuper
      };
    },
    transformClassDeclaration: function(tree) {
      var name = tree.name.identifierToken;
      var internalName = id(("$" + name));
      var renamed = AlphaRenamer.rename(tree, name.value, internalName.identifierToken.value);
      var referencesClassName = renamed !== tree;
      var tree = renamed;
      var $__21 = this.transformClassElements_(tree, internalName),
          func = $__21.func,
          hasSuper = $__21.hasSuper,
          object = $__21.object,
          staticObject = $__21.staticObject,
          superClass = $__21.superClass;
      var statements = parseStatements($__2, name, func);
      var expr = classCall(name, object, staticObject, superClass);
      if (hasSuper || referencesClassName) {
        statements.push(parseStatement($__3, internalName, name));
      }
      statements.push(createExpressionStatement(expr));
      var anonBlock = new AnonBlock(null, statements);
      return this.makeStrict_(anonBlock);
    },
    transformClassExpression: function(tree) {
      this.pushTempScope();
      var name;
      if (tree.name)
        name = tree.name.identifierToken;
      else
        name = id(this.getTempIdentifier());
      var $__21 = this.transformClassElements_(tree, name),
          func = $__21.func,
          hasSuper = $__21.hasSuper,
          object = $__21.object,
          staticObject = $__21.staticObject,
          superClass = $__21.superClass;
      var expression;
      if (hasSuper || tree.name) {
        if (superClass) {
          expression = parseExpression($__4, name, func, name, object, staticObject, superClass);
        } else {
          expression = parseExpression($__5, name, func, name, object, staticObject);
        }
      } else {
        expression = classCall(func, object, staticObject, superClass);
      }
      this.popTempScope();
      return createParenExpression(this.makeStrict_(expression));
    },
    transformPropertyMethodAssignment_: function(tree, homeObject, internalName) {
      var parameterList = this.transformAny(tree.parameterList);
      var body = this.transformSuperInFunctionBody_(tree.body, homeObject, internalName);
      if (!tree.isStatic && parameterList === tree.parameterList && body === tree.body) {
        return tree;
      }
      var isStatic = false;
      return new PropertyMethodAssignment(tree.location, isStatic, tree.functionKind, tree.name, parameterList, tree.typeAnnotation, tree.annotations, body);
    },
    transformGetAccessor_: function(tree, homeObject) {
      var body = this.transformSuperInFunctionBody_(tree.body, homeObject);
      if (!tree.isStatic && body === tree.body)
        return tree;
      return new GetAccessor(tree.location, false, tree.name, tree.typeAnnotation, tree.annotations, body);
    },
    transformSetAccessor_: function(tree, homeObject) {
      var parameterList = this.transformAny(tree.parameterList);
      var body = this.transformSuperInFunctionBody_(tree.body, homeObject);
      if (!tree.isStatic && body === tree.body)
        return tree;
      return new SetAccessor(tree.location, false, tree.name, parameterList, tree.annotations, body);
    },
    transformSuperInFunctionBody_: function(tree, homeObject, internalName) {
      this.pushTempScope();
      var thisName = this.getTempIdentifier();
      var thisDecl = createVariableStatement(VAR, thisName, createThisExpression());
      var superTransformer = new SuperTransformer(this, homeObject, thisName, internalName);
      var transformedTree = superTransformer.transformFunctionBody(this.transformFunctionBody(tree));
      if (superTransformer.hasSuper)
        this.state_.hasSuper = true;
      this.popTempScope();
      if (superTransformer.nestedSuper)
        return createFunctionBody([thisDecl].concat(transformedTree.statements));
      return transformedTree;
    },
    getDefaultConstructor_: function(tree, internalName) {
      var constructorParams = createEmptyParameterList();
      var constructorBody;
      if (tree.superClass) {
        var statement = parseStatement($__6, internalName);
        constructorBody = createFunctionBody([statement]);
        this.state_.hasSuper = true;
      } else {
        constructorBody = createFunctionBody([]);
      }
      return new FunctionExpression(tree.location, tree.name, false, constructorParams, null, [], constructorBody);
    }
  }, {}, TempVarTransformer);
  return {get ClassTransformer() {
      return ClassTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/CommonJsModuleTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/CommonJsModuleTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["module.exports = function() {\n            ", "\n          }.call(", ");"], {raw: {value: Object.freeze(["module.exports = function() {\n            ", "\n          }.call(", ");"])}})),
      $__1 = Object.freeze(Object.defineProperties(["Object.defineProperties(exports, ", ");"], {raw: {value: Object.freeze(["Object.defineProperties(exports, ", ");"])}})),
      $__2 = Object.freeze(Object.defineProperties(["{get: ", "}"], {raw: {value: Object.freeze(["{get: ", "}"])}})),
      $__3 = Object.freeze(Object.defineProperties(["{value: ", "}"], {raw: {value: Object.freeze(["{value: ", "}"])}})),
      $__4 = Object.freeze(Object.defineProperties(["(", " = require(", "),\n        ", " && ", ".__esModule && ", " || {default: ", "})"], {raw: {value: Object.freeze(["(", " = require(", "),\n        ", " && ", ".__esModule && ", " || {default: ", "})"])}})),
      $__5 = Object.freeze(Object.defineProperties(["__esModule: true"], {raw: {value: Object.freeze(["__esModule: true"])}}));
  var ModuleTransformer = System.get("traceur@0.0.80/src/codegeneration/ModuleTransformer.js").ModuleTransformer;
  var $__7 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      GET_ACCESSOR = $__7.GET_ACCESSOR,
      OBJECT_LITERAL_EXPRESSION = $__7.OBJECT_LITERAL_EXPRESSION,
      PROPERTY_NAME_ASSIGNMENT = $__7.PROPERTY_NAME_ASSIGNMENT,
      RETURN_STATEMENT = $__7.RETURN_STATEMENT;
  var assert = System.get("traceur@0.0.80/src/util/assert.js").assert;
  var globalThis = System.get("traceur@0.0.80/src/codegeneration/globalThis.js").default;
  var $__10 = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js"),
      parseExpression = $__10.parseExpression,
      parsePropertyDefinition = $__10.parsePropertyDefinition,
      parseStatement = $__10.parseStatement,
      parseStatements = $__10.parseStatements;
  var scopeContainsThis = System.get("traceur@0.0.80/src/codegeneration/scopeContainsThis.js").default;
  var $__12 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createEmptyParameterList = $__12.createEmptyParameterList,
      createFunctionExpression = $__12.createFunctionExpression,
      createIdentifierExpression = $__12.createIdentifierExpression,
      createObjectLiteralExpression = $__12.createObjectLiteralExpression,
      createPropertyNameAssignment = $__12.createPropertyNameAssignment,
      createVariableStatement = $__12.createVariableStatement,
      createVariableDeclaration = $__12.createVariableDeclaration,
      createVariableDeclarationList = $__12.createVariableDeclarationList;
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var prependStatements = System.get("traceur@0.0.80/src/codegeneration/PrependStatements.js").prependStatements;
  var CommonJsModuleTransformer = function CommonJsModuleTransformer(identifierGenerator) {
    $traceurRuntime.superConstructor($CommonJsModuleTransformer).call(this, identifierGenerator);
    this.moduleVars_ = [];
  };
  var $CommonJsModuleTransformer = CommonJsModuleTransformer;
  ($traceurRuntime.createClass)(CommonJsModuleTransformer, {
    moduleProlog: function() {
      var statements = $traceurRuntime.superGet(this, $CommonJsModuleTransformer.prototype, "moduleProlog").call(this);
      if (this.moduleVars_.length) {
        var tmpVarDeclarations = createVariableStatement(createVariableDeclarationList(VAR, this.moduleVars_.map((function(varName) {
          return createVariableDeclaration(varName, null);
        }))));
        statements.push(tmpVarDeclarations);
      }
      return statements;
    },
    wrapModule: function(statements) {
      var needsIife = statements.some(scopeContainsThis);
      if (needsIife) {
        return parseStatements($__0, statements, globalThis());
      }
      var last = statements[statements.length - 1];
      statements = statements.slice(0, -1);
      assert(last.type === RETURN_STATEMENT);
      var exportObject = last.expression;
      if (this.hasExports()) {
        var descriptors = this.transformObjectLiteralToDescriptors(exportObject);
        var exportStatement = parseStatement($__1, descriptors);
        statements = prependStatements(statements, exportStatement);
      }
      return statements;
    },
    transformObjectLiteralToDescriptors: function(literalTree) {
      assert(literalTree.type === OBJECT_LITERAL_EXPRESSION);
      var props = literalTree.propertyNameAndValues.map((function(exp) {
        var descriptor;
        switch (exp.type) {
          case GET_ACCESSOR:
            var getterFunction = createFunctionExpression(createEmptyParameterList(), exp.body);
            descriptor = parseExpression($__2, getterFunction);
            break;
          case PROPERTY_NAME_ASSIGNMENT:
            descriptor = parseExpression($__3, exp.value);
            break;
          default:
            throw new Error(("Unexpected property type " + exp.type));
        }
        return createPropertyNameAssignment(exp.name, descriptor);
      }));
      return createObjectLiteralExpression(props);
    },
    transformModuleSpecifier: function(tree) {
      var moduleName = tree.token.processedValue;
      var tmpVar = this.getTempVarNameForModuleSpecifier(tree);
      this.moduleVars_.push(tmpVar);
      var tvId = createIdentifierExpression(tmpVar);
      return parseExpression($__4, tvId, moduleName, tvId, tvId, tvId, tvId);
    },
    getExportProperties: function() {
      var properties = $traceurRuntime.superGet(this, $CommonJsModuleTransformer.prototype, "getExportProperties").call(this);
      if (this.exportVisitor_.hasExports())
        properties.push(parsePropertyDefinition($__5));
      return properties;
    }
  }, {}, ModuleTransformer);
  return {get CommonJsModuleTransformer() {
      return CommonJsModuleTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ParameterTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ParameterTransformer.js";
  var FunctionBody = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js").FunctionBody;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var prependStatements = System.get("traceur@0.0.80/src/codegeneration/PrependStatements.js").prependStatements;
  var stack = [];
  var ParameterTransformer = function ParameterTransformer() {
    $traceurRuntime.superConstructor($ParameterTransformer).apply(this, arguments);
  };
  var $ParameterTransformer = ParameterTransformer;
  ($traceurRuntime.createClass)(ParameterTransformer, {
    transformArrowFunctionExpression: function(tree) {
      stack.push([]);
      return $traceurRuntime.superGet(this, $ParameterTransformer.prototype, "transformArrowFunctionExpression").call(this, tree);
    },
    transformFunctionDeclaration: function(tree) {
      stack.push([]);
      return $traceurRuntime.superGet(this, $ParameterTransformer.prototype, "transformFunctionDeclaration").call(this, tree);
    },
    transformFunctionExpression: function(tree) {
      stack.push([]);
      return $traceurRuntime.superGet(this, $ParameterTransformer.prototype, "transformFunctionExpression").call(this, tree);
    },
    transformGetAccessor: function(tree) {
      stack.push([]);
      return $traceurRuntime.superGet(this, $ParameterTransformer.prototype, "transformGetAccessor").call(this, tree);
    },
    transformSetAccessor: function(tree) {
      stack.push([]);
      return $traceurRuntime.superGet(this, $ParameterTransformer.prototype, "transformSetAccessor").call(this, tree);
    },
    transformPropertyMethodAssignment: function(tree) {
      stack.push([]);
      return $traceurRuntime.superGet(this, $ParameterTransformer.prototype, "transformPropertyMethodAssignment").call(this, tree);
    },
    transformFunctionBody: function(tree) {
      var transformedTree = $traceurRuntime.superGet(this, $ParameterTransformer.prototype, "transformFunctionBody").call(this, tree);
      var statements = stack.pop();
      if (!statements.length)
        return transformedTree;
      statements = prependStatements.apply(null, $traceurRuntime.spread([transformedTree.statements], statements));
      return new FunctionBody(transformedTree.location, statements);
    },
    get parameterStatements() {
      return stack[stack.length - 1];
    }
  }, {}, TempVarTransformer);
  return {get ParameterTransformer() {
      return ParameterTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/DefaultParametersTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/DefaultParametersTransformer.js";
  var $__0 = System.get("traceur@0.0.80/src/semantics/util.js"),
      isUndefined = $__0.isUndefined,
      isVoidExpression = $__0.isVoidExpression;
  var FormalParameterList = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js").FormalParameterList;
  var ParameterTransformer = System.get("traceur@0.0.80/src/codegeneration/ParameterTransformer.js").ParameterTransformer;
  var ARGUMENTS = System.get("traceur@0.0.80/src/syntax/PredefinedName.js").ARGUMENTS;
  var $__4 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      NOT_EQUAL_EQUAL = $__4.NOT_EQUAL_EQUAL,
      VAR = $__4.VAR;
  var $__5 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createBinaryExpression = $__5.createBinaryExpression,
      createConditionalExpression = $__5.createConditionalExpression,
      createIdentifierExpression = $__5.createIdentifierExpression,
      createMemberLookupExpression = $__5.createMemberLookupExpression,
      createNumberLiteral = $__5.createNumberLiteral,
      createOperatorToken = $__5.createOperatorToken,
      createVariableStatement = $__5.createVariableStatement,
      createVoid0 = $__5.createVoid0;
  function createDefaultAssignment(index, binding, initializer) {
    var argumentsExpression = createMemberLookupExpression(createIdentifierExpression(ARGUMENTS), createNumberLiteral(index));
    var assignmentExpression;
    if (initializer === null || isUndefined(initializer) || isVoidExpression(initializer)) {
      assignmentExpression = argumentsExpression;
    } else {
      assignmentExpression = createConditionalExpression(createBinaryExpression(argumentsExpression, createOperatorToken(NOT_EQUAL_EQUAL), createVoid0()), argumentsExpression, initializer);
    }
    return createVariableStatement(VAR, binding, assignmentExpression);
  }
  var DefaultParametersTransformer = function DefaultParametersTransformer() {
    $traceurRuntime.superConstructor($DefaultParametersTransformer).apply(this, arguments);
  };
  var $DefaultParametersTransformer = DefaultParametersTransformer;
  ($traceurRuntime.createClass)(DefaultParametersTransformer, {
    transformFormalParameterList: function(tree) {
      var parameters = [];
      var changed = false;
      var defaultToUndefined = false;
      for (var i = 0; i < tree.parameters.length; i++) {
        var param = this.transformAny(tree.parameters[i]);
        if (param !== tree.parameters[i])
          changed = true;
        if (param.isRestParameter() || !param.parameter.initializer && !defaultToUndefined) {
          parameters.push(param);
        } else {
          defaultToUndefined = true;
          changed = true;
          this.parameterStatements.push(createDefaultAssignment(i, param.parameter.binding, param.parameter.initializer));
        }
      }
      if (!changed)
        return tree;
      return new FormalParameterList(tree.location, parameters);
    },
    transformConstructorType: function(tree) {
      return tree;
    },
    transformFunctionType: function(tree) {
      return tree;
    }
  }, {}, ParameterTransformer);
  return {get DefaultParametersTransformer() {
      return DefaultParametersTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ExponentiationTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ExponentiationTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["Math.pow(", ", ", ")"], {raw: {value: Object.freeze(["Math.pow(", ", ", ")"])}}));
  var ExplodeExpressionTransformer = System.get("traceur@0.0.80/src/codegeneration/ExplodeExpressionTransformer.js").ExplodeExpressionTransformer;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var $__3 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      STAR_STAR = $__3.STAR_STAR,
      STAR_STAR_EQUAL = $__3.STAR_STAR_EQUAL;
  var parseExpression = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseExpression;
  var ExponentiationTransformer = function ExponentiationTransformer() {
    $traceurRuntime.superConstructor($ExponentiationTransformer).apply(this, arguments);
  };
  var $ExponentiationTransformer = ExponentiationTransformer;
  ($traceurRuntime.createClass)(ExponentiationTransformer, {transformBinaryExpression: function(tree) {
      switch (tree.operator.type) {
        case STAR_STAR:
          var left = this.transformAny(tree.left);
          var right = this.transformAny(tree.right);
          return parseExpression($__0, left, right);
        case STAR_STAR_EQUAL:
          var exploded = new ExplodeExpressionTransformer(this).transformAny(tree);
          return this.transformAny(exploded);
      }
      return $traceurRuntime.superGet(this, $ExponentiationTransformer.prototype, "transformBinaryExpression").call(this, tree);
    }}, {}, TempVarTransformer);
  return {get ExponentiationTransformer() {
      return ExponentiationTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ForOfTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ForOfTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["", " = ", ".value;"], {raw: {value: Object.freeze(["", " = ", ".value;"])}})),
      $__1 = Object.freeze(Object.defineProperties(["\n        for (var ", " =\n                 ", "[\n                     $traceurRuntime.toProperty(Symbol.iterator)](),\n                 ", ";\n             !(", " = ", ".next()).done; ) {\n          ", ";\n          ", ";\n        }"], {raw: {value: Object.freeze(["\n        for (var ", " =\n                 ", "[\n                     $traceurRuntime.toProperty(Symbol.iterator)](),\n                 ", ";\n             !(", " = ", ".next()).done; ) {\n          ", ";\n          ", ";\n        }"])}}));
  var VARIABLE_DECLARATION_LIST = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js").VARIABLE_DECLARATION_LIST;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var $__4 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      id = $__4.createIdentifierExpression,
      createMemberExpression = $__4.createMemberExpression,
      createVariableStatement = $__4.createVariableStatement;
  var parseStatement = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseStatement;
  var ForOfTransformer = function ForOfTransformer() {
    $traceurRuntime.superConstructor($ForOfTransformer).apply(this, arguments);
  };
  var $ForOfTransformer = ForOfTransformer;
  ($traceurRuntime.createClass)(ForOfTransformer, {transformForOfStatement: function(original) {
      var tree = $traceurRuntime.superGet(this, $ForOfTransformer.prototype, "transformForOfStatement").call(this, original);
      var iter = id(this.getTempIdentifier());
      var result = id(this.getTempIdentifier());
      var assignment;
      if (tree.initializer.type === VARIABLE_DECLARATION_LIST) {
        assignment = createVariableStatement(tree.initializer.declarationType, tree.initializer.declarations[0].lvalue, createMemberExpression(result, 'value'));
      } else {
        assignment = parseStatement($__0, tree.initializer, result);
      }
      return parseStatement($__1, iter, tree.collection, result, result, iter, assignment, tree.body);
    }}, {}, TempVarTransformer);
  return {get ForOfTransformer() {
      return ForOfTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/GeneratorComprehensionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/GeneratorComprehensionTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["yield ", ""], {raw: {value: Object.freeze(["yield ", ""])}}));
  var ComprehensionTransformer = System.get("traceur@0.0.80/src/codegeneration/ComprehensionTransformer.js").ComprehensionTransformer;
  var parseStatement = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseStatement;
  var GeneratorComprehensionTransformer = function GeneratorComprehensionTransformer() {
    $traceurRuntime.superConstructor($GeneratorComprehensionTransformer).apply(this, arguments);
  };
  var $GeneratorComprehensionTransformer = GeneratorComprehensionTransformer;
  ($traceurRuntime.createClass)(GeneratorComprehensionTransformer, {transformGeneratorComprehension: function(tree) {
      var expression = this.transformAny(tree.expression);
      var statement = parseStatement($__0, expression);
      var isGenerator = true;
      return this.transformComprehension(tree, statement, isGenerator);
    }}, {}, ComprehensionTransformer);
  return {get GeneratorComprehensionTransformer() {
      return GeneratorComprehensionTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/State.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/State.js";
  var $__0 = Object.freeze(Object.defineProperties(["$ctx.finallyFallThrough = ", ""], {raw: {value: Object.freeze(["$ctx.finallyFallThrough = ", ""])}}));
  var $__1 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createAssignStateStatement = $__1.createAssignStateStatement,
      createBreakStatement = $__1.createBreakStatement,
      createCaseClause = $__1.createCaseClause,
      createNumberLiteral = $__1.createNumberLiteral;
  var parseStatement = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseStatement;
  var State = function State(id) {
    this.id = id;
  };
  ($traceurRuntime.createClass)(State, {
    transformMachineState: function(enclosingFinally, machineEndState, reporter) {
      return createCaseClause(createNumberLiteral(this.id), this.transform(enclosingFinally, machineEndState, reporter));
    },
    transformBreak: function(labelSet, breakState) {
      return this;
    },
    transformBreakOrContinue: function(labelSet) {
      var breakState = arguments[1];
      var continueState = arguments[2];
      return this;
    }
  }, {});
  State.START_STATE = 0;
  State.INVALID_STATE = -1;
  State.END_STATE = -2;
  State.RETHROW_STATE = -3;
  State.generateJump = function(enclosingFinally, fallThroughState) {
    return $traceurRuntime.spread(State.generateAssignState(enclosingFinally, fallThroughState), [createBreakStatement()]);
  };
  State.generateAssignState = function(enclosingFinally, fallThroughState) {
    var assignState;
    if (State.isFinallyExit(enclosingFinally, fallThroughState)) {
      assignState = generateAssignStateOutOfFinally(enclosingFinally, fallThroughState);
    } else {
      assignState = [createAssignStateStatement(fallThroughState)];
    }
    return assignState;
  };
  State.isFinallyExit = function(enclosingFinally, destination) {
    return enclosingFinally != null && enclosingFinally.tryStates.indexOf(destination) < 0;
  };
  function generateAssignStateOutOfFinally(enclosingFinally, destination) {
    var finallyState = enclosingFinally.finallyState;
    return [createAssignStateStatement(finallyState), parseStatement($__0, destination)];
  }
  State.replaceStateList = function(oldStates, oldState, newState) {
    var states = [];
    for (var i = 0; i < oldStates.length; i++) {
      states.push(State.replaceStateId(oldStates[i], oldState, newState));
    }
    return states;
  };
  State.replaceStateId = function(current, oldState, newState) {
    return current == oldState ? newState : current;
  };
  State.replaceAllStates = function(exceptionBlocks, oldState, newState) {
    var result = [];
    for (var i = 0; i < exceptionBlocks.length; i++) {
      result.push(exceptionBlocks[i].replaceState(oldState, newState));
    }
    return result;
  };
  return {get State() {
      return State;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/TryState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/TryState.js";
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var Kind = {
    CATCH: 'catch',
    FINALLY: 'finally'
  };
  var TryState = function TryState(kind, tryStates, nestedTrys) {
    this.kind = kind;
    this.tryStates = tryStates;
    this.nestedTrys = nestedTrys;
  };
  ($traceurRuntime.createClass)(TryState, {
    replaceAllStates: function(oldState, newState) {
      return State.replaceStateList(this.tryStates, oldState, newState);
    },
    replaceNestedTrys: function(oldState, newState) {
      var states = [];
      for (var i = 0; i < this.nestedTrys.length; i++) {
        states.push(this.nestedTrys[i].replaceState(oldState, newState));
      }
      return states;
    }
  }, {});
  TryState.Kind = Kind;
  return {get TryState() {
      return TryState;
    }};
});
System.registerModule("traceur@0.0.80/src/syntax/trees/StateMachine.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/trees/StateMachine.js";
  var ParseTree = System.get("traceur@0.0.80/src/syntax/trees/ParseTree.js").ParseTree;
  var STATE_MACHINE = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js").STATE_MACHINE;
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var TryState = System.get("traceur@0.0.80/src/codegeneration/generator/TryState.js").TryState;
  function addCatchOrFinallyStates(kind, enclosingMap, tryStates) {
    for (var i = 0; i < tryStates.length; i++) {
      var tryState = tryStates[i];
      if (tryState.kind == kind) {
        for (var j = 0; j < tryState.tryStates.length; j++) {
          var id = tryState.tryStates[j];
          enclosingMap[id] = tryState;
        }
      }
      addCatchOrFinallyStates(kind, enclosingMap, tryState.nestedTrys);
    }
  }
  function addAllCatchStates(tryStates, catches) {
    for (var i = 0; i < tryStates.length; i++) {
      var tryState = tryStates[i];
      if (tryState.kind == TryState.Kind.CATCH) {
        catches.push(tryState);
      }
      addAllCatchStates(tryState.nestedTrys, catches);
    }
  }
  var StateMachine = function StateMachine(startState, fallThroughState, states, exceptionBlocks) {
    this.location = null;
    this.startState = startState;
    this.fallThroughState = fallThroughState;
    this.states = states;
    this.exceptionBlocks = exceptionBlocks;
  };
  var $StateMachine = StateMachine;
  ($traceurRuntime.createClass)(StateMachine, {
    get type() {
      return STATE_MACHINE;
    },
    transform: function(transformer) {
      return transformer.transformStateMachine(this);
    },
    visit: function(visitor) {
      visitor.visitStateMachine(this);
    },
    getAllStateIDs: function() {
      var result = [];
      for (var i = 0; i < this.states.length; i++) {
        result.push(this.states[i].id);
      }
      return result;
    },
    getEnclosingFinallyMap: function() {
      var enclosingMap = Object.create(null);
      addCatchOrFinallyStates(TryState.Kind.FINALLY, enclosingMap, this.exceptionBlocks);
      return enclosingMap;
    },
    allCatchStates: function() {
      var catches = [];
      addAllCatchStates(this.exceptionBlocks, catches);
      return catches;
    },
    replaceStateId: function(oldState, newState) {
      return new $StateMachine(State.replaceStateId(this.startState, oldState, newState), State.replaceStateId(this.fallThroughState, oldState, newState), State.replaceAllStates(this.states, oldState, newState), State.replaceAllStates(this.exceptionBlocks, oldState, newState));
    },
    replaceStartState: function(newState) {
      return this.replaceStateId(this.startState, newState);
    },
    replaceFallThroughState: function(newState) {
      return this.replaceStateId(this.fallThroughState, newState);
    },
    append: function(nextMachine) {
      var states = $traceurRuntime.spread(this.states);
      for (var i = 0; i < nextMachine.states.length; i++) {
        var otherState = nextMachine.states[i];
        states.push(otherState.replaceState(nextMachine.startState, this.fallThroughState));
      }
      var exceptionBlocks = $traceurRuntime.spread(this.exceptionBlocks);
      for (var i = 0; i < nextMachine.exceptionBlocks.length; i++) {
        var tryState = nextMachine.exceptionBlocks[i];
        exceptionBlocks.push(tryState.replaceState(nextMachine.startState, this.fallThroughState));
      }
      return new $StateMachine(this.startState, nextMachine.fallThroughState, states, exceptionBlocks);
    }
  }, {}, ParseTree);
  return {get StateMachine() {
      return StateMachine;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/AwaitState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/AwaitState.js";
  var $__0 = Object.freeze(Object.defineProperties(["$ctx.finallyFallThrough = ", ""], {raw: {value: Object.freeze(["$ctx.finallyFallThrough = ", ""])}})),
      $__1 = Object.freeze(Object.defineProperties(["Promise.resolve(", ").then(\n          $ctx.createCallback(", "), $ctx.errback);\n          return;"], {raw: {value: Object.freeze(["Promise.resolve(", ").then(\n          $ctx.createCallback(", "), $ctx.errback);\n          return;"])}}));
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var parseStatements = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseStatements;
  var AwaitState = function AwaitState(id, callbackState, expression) {
    $traceurRuntime.superConstructor($AwaitState).call(this, id), this.callbackState = callbackState;
    this.expression = expression;
  };
  var $AwaitState = AwaitState;
  ($traceurRuntime.createClass)(AwaitState, {
    replaceState: function(oldState, newState) {
      return new $AwaitState(State.replaceStateId(this.id, oldState, newState), State.replaceStateId(this.callbackState, oldState, newState), this.expression);
    },
    transform: function(enclosingFinally, machineEndState, reporter) {
      var $__5;
      var stateId,
          statements;
      if (State.isFinallyExit(enclosingFinally, this.callbackState)) {
        stateId = enclosingFinally.finallyState;
        statements = parseStatements($__0, this.callbackState);
      } else {
        stateId = this.callbackState;
        statements = [];
      }
      ($__5 = statements).push.apply($__5, $traceurRuntime.spread(parseStatements($__1, this.expression, stateId)));
      return statements;
    }
  }, {}, State);
  return {get AwaitState() {
      return AwaitState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/HoistVariablesTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/HoistVariablesTransformer.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AnonBlock = $__0.AnonBlock,
      Catch = $__0.Catch,
      FunctionBody = $__0.FunctionBody,
      ForInStatement = $__0.ForInStatement,
      ForOfStatement = $__0.ForOfStatement,
      ForStatement = $__0.ForStatement,
      VariableDeclarationList = $__0.VariableDeclarationList,
      VariableStatement = $__0.VariableStatement;
  var $__1 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      OBJECT_PATTERN = $__1.OBJECT_PATTERN,
      VARIABLE_DECLARATION_LIST = $__1.VARIABLE_DECLARATION_LIST;
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var $__4 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createAssignmentExpression = $__4.createAssignmentExpression,
      createCommaExpression = $__4.createCommaExpression,
      createExpressionStatement = $__4.createExpressionStatement,
      id = $__4.createIdentifierExpression,
      createParenExpression = $__4.createParenExpression,
      createVariableDeclaration = $__4.createVariableDeclaration;
  var prependStatements = System.get("traceur@0.0.80/src/codegeneration/PrependStatements.js").prependStatements;
  var HoistVariablesTransformer = function HoistVariablesTransformer() {
    var shouldHoistFunctions = arguments[0] !== (void 0) ? arguments[0] : false;
    $traceurRuntime.superConstructor($HoistVariablesTransformer).call(this);
    this.hoistedFunctions_ = [];
    this.hoistedVariables_ = Object.create(null);
    this.keepBindingIdentifiers_ = false;
    this.inBlockOrFor_ = false;
    this.shouldHoistFunctions_ = shouldHoistFunctions;
  };
  var $HoistVariablesTransformer = HoistVariablesTransformer;
  ($traceurRuntime.createClass)(HoistVariablesTransformer, {
    transformFunctionBody: function(tree) {
      var statements = this.transformList(tree.statements);
      if (statements === tree.statements)
        return tree;
      statements = this.prependVariables(statements);
      statements = this.prependFunctions(statements);
      return new FunctionBody(tree.location, statements);
    },
    addVariable: function(name) {
      this.hoistedVariables_[name] = true;
    },
    addFunctionDeclaration: function(tree) {
      this.hoistedFunctions_.push(tree);
    },
    hasVariables: function() {
      for (var key in this.hoistedVariables_) {
        return true;
      }
      return false;
    },
    hasFunctions: function() {
      return this.hoistedFunctions_.length > 0;
    },
    getVariableNames: function() {
      return Object.keys(this.hoistedVariables_);
    },
    getVariableStatement: function() {
      if (!this.hasVariables())
        return new AnonBlock(null, []);
      var declarations = this.getVariableNames().map((function(name) {
        return createVariableDeclaration(name, null);
      }));
      return new VariableStatement(null, new VariableDeclarationList(null, VAR, declarations));
    },
    getFunctions: function() {
      return this.hoistedFunctions_;
    },
    prependVariables: function(statements) {
      if (!this.hasVariables())
        return statements;
      return prependStatements(statements, this.getVariableStatement());
    },
    prependFunctions: function(statements) {
      if (!this.hasFunctions())
        return statements;
      return prependStatements(statements, this.getFunctionDeclarations());
    },
    transformVariableStatement: function(tree) {
      var declarations = this.transformAny(tree.declarations);
      if (declarations == tree.declarations)
        return tree;
      if (declarations === null)
        return new AnonBlock(null, []);
      if (declarations.type === VARIABLE_DECLARATION_LIST)
        return new VariableStatement(tree.location, declarations);
      return createExpressionStatement(declarations);
    },
    transformVariableDeclaration: function(tree) {
      var lvalue = this.transformAny(tree.lvalue);
      var initializer = this.transformAny(tree.initializer);
      if (initializer) {
        var expression = createAssignmentExpression(lvalue, initializer);
        if (lvalue.type === OBJECT_PATTERN)
          expression = createParenExpression(expression);
        return expression;
      }
      return null;
    },
    transformObjectPattern: function(tree) {
      var keepBindingIdentifiers = this.keepBindingIdentifiers_;
      this.keepBindingIdentifiers_ = true;
      var transformed = $traceurRuntime.superGet(this, $HoistVariablesTransformer.prototype, "transformObjectPattern").call(this, tree);
      this.keepBindingIdentifiers_ = keepBindingIdentifiers;
      return transformed;
    },
    transformArrayPattern: function(tree) {
      var keepBindingIdentifiers = this.keepBindingIdentifiers_;
      this.keepBindingIdentifiers_ = true;
      var transformed = $traceurRuntime.superGet(this, $HoistVariablesTransformer.prototype, "transformArrayPattern").call(this, tree);
      this.keepBindingIdentifiers_ = keepBindingIdentifiers;
      return transformed;
    },
    transformBindingIdentifier: function(tree) {
      var idToken = tree.identifierToken;
      this.addVariable(idToken.value);
      if (this.keepBindingIdentifiers_)
        return tree;
      return id(idToken);
    },
    transformVariableDeclarationList: function(tree) {
      if (tree.declarationType === VAR || !this.inBlockOrFor_) {
        var expressions = this.transformList(tree.declarations);
        expressions = expressions.filter((function(tree) {
          return tree;
        }));
        if (expressions.length === 0)
          return null;
        if (expressions.length == 1)
          return expressions[0];
        return createCommaExpression(expressions);
      }
      return tree;
    },
    transformCatch: function(tree) {
      var catchBody = this.transformAny(tree.catchBody);
      if (catchBody === tree.catchBody)
        return tree;
      return new Catch(tree.location, tree.binding, catchBody);
    },
    transformForInStatement: function(tree) {
      return this.transformLoop_(tree, ForInStatement);
    },
    transformForOfStatement: function(tree) {
      return this.transformLoop_(tree, ForOfStatement);
    },
    transformLoop_: function(tree, ctor) {
      var initializer = this.transformLoopIninitaliser_(tree.initializer);
      var collection = this.transformAny(tree.collection);
      var body = this.transformAny(tree.body);
      if (initializer === tree.initializer && collection === tree.collection && body === tree.body) {
        return tree;
      }
      return new ctor(tree.location, initializer, collection, body);
    },
    transformLoopIninitaliser_: function(tree) {
      if (tree.type !== VARIABLE_DECLARATION_LIST || tree.declarationType !== VAR)
        return tree;
      return this.transformAny(tree.declarations[0].lvalue);
    },
    transformForStatement: function(tree) {
      var inBlockOrFor = this.inBlockOrFor_;
      this.inBlockOrFor_ = true;
      var initializer = this.transformAny(tree.initializer);
      this.inBlockOrFor_ = inBlockOrFor;
      var condition = this.transformAny(tree.condition);
      var increment = this.transformAny(tree.increment);
      var body = this.transformAny(tree.body);
      if (initializer === tree.initializer && condition === tree.condition && increment === tree.increment && body === tree.body) {
        return tree;
      }
      return new ForStatement(tree.location, initializer, condition, increment, body);
    },
    transformBlock: function(tree) {
      var inBlockOrFor = this.inBlockOrFor_;
      this.inBlockOrFor_ = true;
      tree = $traceurRuntime.superGet(this, $HoistVariablesTransformer.prototype, "transformBlock").call(this, tree);
      this.inBlockOrFor_ = inBlockOrFor;
      return tree;
    },
    addMachineVariable: function(name) {
      this.machineVariables_[name] = true;
    },
    transformClassDeclaration: function(tree) {
      return tree;
    },
    transformClassExpression: function(tree) {
      return tree;
    },
    transformFunctionDeclaration: function(tree) {
      if (this.shouldHoistFunctions_) {
        this.addFunctionDeclaration(tree);
        return new AnonBlock(null, []);
      }
      return tree;
    },
    transformFunctionExpression: function(tree) {
      return tree;
    },
    transformGetAccessor: function(tree) {
      return tree;
    },
    transformSetAccessor: function(tree) {
      return tree;
    },
    transformPropertyMethodAssignment: function(tree) {
      return tree;
    },
    transformArrowFunctionExpression: function(tree) {
      return tree;
    },
    transformComprehensionFor: function(tree) {
      return tree;
    }
  }, {}, ParseTreeTransformer);
  var $__default = HoistVariablesTransformer;
  return {get default() {
      return $__default;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/FallThroughState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/FallThroughState.js";
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var FallThroughState = function FallThroughState(id, fallThroughState, statements) {
    $traceurRuntime.superConstructor($FallThroughState).call(this, id);
    this.fallThroughState = fallThroughState;
    this.statements = statements;
  };
  var $FallThroughState = FallThroughState;
  ($traceurRuntime.createClass)(FallThroughState, {
    replaceState: function(oldState, newState) {
      return new $FallThroughState(State.replaceStateId(this.id, oldState, newState), State.replaceStateId(this.fallThroughState, oldState, newState), this.statements);
    },
    transform: function(enclosingFinally, machineEndState, reporter) {
      return $traceurRuntime.spread(this.statements, State.generateJump(enclosingFinally, this.fallThroughState));
    }
  }, {}, State);
  return {get FallThroughState() {
      return FallThroughState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/BreakState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/BreakState.js";
  var FallThroughState = System.get("traceur@0.0.80/src/codegeneration/generator/FallThroughState.js").FallThroughState;
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var BreakState = function BreakState(id, label) {
    $traceurRuntime.superConstructor($BreakState).call(this, id);
    this.label = label;
  };
  var $BreakState = BreakState;
  ($traceurRuntime.createClass)(BreakState, {
    replaceState: function(oldState, newState) {
      return new $BreakState(State.replaceStateId(this.id, oldState, newState), this.label);
    },
    transform: function(enclosingFinally, machineEndState, reporter) {
      throw new Error('These should be removed before the transform step');
    },
    transformBreak: function(labelSet) {
      var breakState = arguments[1];
      if (this.label == null)
        return new FallThroughState(this.id, breakState, []);
      if (this.label in labelSet) {
        return new FallThroughState(this.id, labelSet[this.label].fallThroughState, []);
      }
      return this;
    },
    transformBreakOrContinue: function(labelSet) {
      var breakState = arguments[1];
      var continueState = arguments[2];
      return this.transformBreak(labelSet, breakState);
    }
  }, {}, State);
  return {get BreakState() {
      return BreakState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/ContinueState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/ContinueState.js";
  var FallThroughState = System.get("traceur@0.0.80/src/codegeneration/generator/FallThroughState.js").FallThroughState;
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var ContinueState = function ContinueState(id, label) {
    $traceurRuntime.superConstructor($ContinueState).call(this, id);
    this.label = label;
  };
  var $ContinueState = ContinueState;
  ($traceurRuntime.createClass)(ContinueState, {
    replaceState: function(oldState, newState) {
      return new $ContinueState(State.replaceStateId(this.id, oldState, newState), this.label);
    },
    transform: function(enclosingFinally, machineEndState, reporter) {
      throw new Error('These should be removed before the transform step');
    },
    transformBreakOrContinue: function(labelSet) {
      var breakState = arguments[1];
      var continueState = arguments[2];
      if (this.label == null)
        return new FallThroughState(this.id, continueState, []);
      if (this.label in labelSet) {
        return new FallThroughState(this.id, labelSet[this.label].continueState, []);
      }
      return this;
    }
  }, {}, State);
  return {get ContinueState() {
      return ContinueState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/BreakContinueTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/BreakContinueTransformer.js";
  var BreakState = System.get("traceur@0.0.80/src/codegeneration/generator/BreakState.js").BreakState;
  var ContinueState = System.get("traceur@0.0.80/src/codegeneration/generator/ContinueState.js").ContinueState;
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var StateMachine = System.get("traceur@0.0.80/src/syntax/trees/StateMachine.js").StateMachine;
  function safeGetLabel(tree) {
    return tree.name ? tree.name.value : null;
  }
  var BreakContinueTransformer = function BreakContinueTransformer(stateAllocator) {
    $traceurRuntime.superConstructor($BreakContinueTransformer).call(this);
    this.transformBreaks_ = true;
    this.stateAllocator_ = stateAllocator;
  };
  var $BreakContinueTransformer = BreakContinueTransformer;
  ($traceurRuntime.createClass)(BreakContinueTransformer, {
    allocateState_: function() {
      return this.stateAllocator_.allocateState();
    },
    stateToStateMachine_: function(newState) {
      var fallThroughState = this.allocateState_();
      return new StateMachine(newState.id, fallThroughState, [newState], []);
    },
    transformBreakStatement: function(tree) {
      return this.transformBreaks_ || tree.name ? this.stateToStateMachine_(new BreakState(this.allocateState_(), safeGetLabel(tree))) : tree;
    },
    transformContinueStatement: function(tree) {
      return this.stateToStateMachine_(new ContinueState(this.allocateState_(), safeGetLabel(tree)));
    },
    transformDoWhileStatement: function(tree) {
      return tree;
    },
    transformForOfStatement: function(tree) {
      return tree;
    },
    transformForStatement: function(tree) {
      return tree;
    },
    transformFunctionDeclaration: function(tree) {
      return tree;
    },
    transformFunctionExpression: function(tree) {
      return tree;
    },
    transformStateMachine: function(tree) {
      return tree;
    },
    transformSwitchStatement: function(tree) {
      var oldState = this.transformBreaks_;
      this.transformBreaks_ = false;
      var result = $traceurRuntime.superGet(this, $BreakContinueTransformer.prototype, "transformSwitchStatement").call(this, tree);
      this.transformBreaks_ = oldState;
      return result;
    },
    transformWhileStatement: function(tree) {
      return tree;
    }
  }, {}, ParseTreeTransformer);
  return {get BreakContinueTransformer() {
      return BreakContinueTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/CatchState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/CatchState.js";
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var TryState = System.get("traceur@0.0.80/src/codegeneration/generator/TryState.js").TryState;
  var CatchState = function CatchState(identifier, catchState, fallThroughState, allStates, nestedTrys) {
    $traceurRuntime.superConstructor($CatchState).call(this, TryState.Kind.CATCH, allStates, nestedTrys);
    this.identifier = identifier;
    this.catchState = catchState;
    this.fallThroughState = fallThroughState;
  };
  var $CatchState = CatchState;
  ($traceurRuntime.createClass)(CatchState, {replaceState: function(oldState, newState) {
      return new $CatchState(this.identifier, State.replaceStateId(this.catchState, oldState, newState), State.replaceStateId(this.fallThroughState, oldState, newState), this.replaceAllStates(oldState, newState), this.replaceNestedTrys(oldState, newState));
    }}, {}, TryState);
  return {get CatchState() {
      return CatchState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/ConditionalState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/ConditionalState.js";
  var $__0 = Object.freeze(Object.defineProperties(["$ctx.state = (", ") ? ", " : ", ";\n        break"], {raw: {value: Object.freeze(["$ctx.state = (", ") ? ", " : ", ";\n        break"])}}));
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var $__2 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createBlock = $__2.createBlock,
      createIfStatement = $__2.createIfStatement;
  var parseStatements = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseStatements;
  var ConditionalState = function ConditionalState(id, ifState, elseState, condition) {
    $traceurRuntime.superConstructor($ConditionalState).call(this, id);
    this.ifState = ifState;
    this.elseState = elseState;
    this.condition = condition;
  };
  var $ConditionalState = ConditionalState;
  ($traceurRuntime.createClass)(ConditionalState, {
    replaceState: function(oldState, newState) {
      return new $ConditionalState(State.replaceStateId(this.id, oldState, newState), State.replaceStateId(this.ifState, oldState, newState), State.replaceStateId(this.elseState, oldState, newState), this.condition);
    },
    transform: function(enclosingFinally, machineEndState, reporter) {
      if (State.isFinallyExit(enclosingFinally, this.ifState) || State.isFinallyExit(enclosingFinally, this.elseState)) {
        return [createIfStatement(this.condition, createBlock(State.generateJump(enclosingFinally, this.ifState)), createBlock(State.generateJump(enclosingFinally, this.elseState)))];
      }
      return parseStatements($__0, this.condition, this.ifState, this.elseState);
    }
  }, {}, State);
  return {get ConditionalState() {
      return ConditionalState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/FinallyFallThroughState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/FinallyFallThroughState.js";
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var FinallyFallThroughState = function FinallyFallThroughState() {
    $traceurRuntime.superConstructor($FinallyFallThroughState).apply(this, arguments);
  };
  var $FinallyFallThroughState = FinallyFallThroughState;
  ($traceurRuntime.createClass)(FinallyFallThroughState, {
    replaceState: function(oldState, newState) {
      return new $FinallyFallThroughState(State.replaceStateId(this.id, oldState, newState));
    },
    transformMachineState: function(enclosingFinally, machineEndState, reporter) {
      return null;
    },
    transform: function(enclosingFinally, machineEndState, reporter) {
      throw new Error('these are generated in addFinallyFallThroughDispatches');
    }
  }, {}, State);
  return {get FinallyFallThroughState() {
      return FinallyFallThroughState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/FinallyState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/FinallyState.js";
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var TryState = System.get("traceur@0.0.80/src/codegeneration/generator/TryState.js").TryState;
  var FinallyState = function FinallyState(finallyState, fallThroughState, allStates, nestedTrys) {
    $traceurRuntime.superConstructor($FinallyState).call(this, TryState.Kind.FINALLY, allStates, nestedTrys);
    this.finallyState = finallyState;
    this.fallThroughState = fallThroughState;
  };
  var $FinallyState = FinallyState;
  ($traceurRuntime.createClass)(FinallyState, {replaceState: function(oldState, newState) {
      return new $FinallyState(State.replaceStateId(this.finallyState, oldState, newState), State.replaceStateId(this.fallThroughState, oldState, newState), this.replaceAllStates(oldState, newState), this.replaceNestedTrys(oldState, newState));
    }}, {}, TryState);
  return {get FinallyState() {
      return FinallyState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/StateAllocator.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/StateAllocator.js";
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var StateAllocator = function StateAllocator() {
    this.nextState_ = State.START_STATE + 1;
  };
  ($traceurRuntime.createClass)(StateAllocator, {allocateState: function() {
      return this.nextState_++;
    }}, {});
  return {get StateAllocator() {
      return StateAllocator;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/SwitchState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/SwitchState.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      CaseClause = $__0.CaseClause,
      DefaultClause = $__0.DefaultClause,
      SwitchStatement = $__0.SwitchStatement;
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var createBreakStatement = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js").createBreakStatement;
  var SwitchClause = function SwitchClause(first, second) {
    this.first = first;
    this.second = second;
  };
  ($traceurRuntime.createClass)(SwitchClause, {}, {});
  var SwitchState = function SwitchState(id, expression, clauses) {
    $traceurRuntime.superConstructor($SwitchState).call(this, id);
    this.expression = expression;
    this.clauses = clauses;
  };
  var $SwitchState = SwitchState;
  ($traceurRuntime.createClass)(SwitchState, {
    replaceState: function(oldState, newState) {
      var clauses = this.clauses.map((function(clause) {
        return new SwitchClause(clause.first, State.replaceStateId(clause.second, oldState, newState));
      }));
      return new $SwitchState(State.replaceStateId(this.id, oldState, newState), this.expression, clauses);
    },
    transform: function(enclosingFinally, machineEndState, reporter) {
      var clauses = [];
      for (var i = 0; i < this.clauses.length; i++) {
        var clause = this.clauses[i];
        if (clause.first == null) {
          clauses.push(new DefaultClause(null, State.generateJump(enclosingFinally, clause.second)));
        } else {
          clauses.push(new CaseClause(null, clause.first, State.generateJump(enclosingFinally, clause.second)));
        }
      }
      return [new SwitchStatement(null, this.expression, clauses), createBreakStatement()];
    }
  }, {}, State);
  return {
    get SwitchClause() {
      return SwitchClause;
    },
    get SwitchState() {
      return SwitchState;
    }
  };
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/CPSTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/CPSTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["$ctx.pushTry(\n            ", ",\n            ", ");"], {raw: {value: Object.freeze(["$ctx.pushTry(\n            ", ",\n            ", ");"])}})),
      $__1 = Object.freeze(Object.defineProperties(["$ctx.popTry();"], {raw: {value: Object.freeze(["$ctx.popTry();"])}})),
      $__2 = Object.freeze(Object.defineProperties(["\n              $ctx.popTry();\n              ", " = $ctx.storedException;"], {raw: {value: Object.freeze(["\n              $ctx.popTry();\n              ", " = $ctx.storedException;"])}})),
      $__3 = Object.freeze(Object.defineProperties(["$ctx.popTry();"], {raw: {value: Object.freeze(["$ctx.popTry();"])}})),
      $__4 = Object.freeze(Object.defineProperties(["function($ctx) {\n      while (true) ", "\n    }"], {raw: {value: Object.freeze(["function($ctx) {\n      while (true) ", "\n    }"])}})),
      $__5 = Object.freeze(Object.defineProperties(["var $arguments = arguments;"], {raw: {value: Object.freeze(["var $arguments = arguments;"])}})),
      $__6 = Object.freeze(Object.defineProperties(["return ", "(\n              ", ",\n              ", ", this);"], {raw: {value: Object.freeze(["return ", "(\n              ", ",\n              ", ", this);"])}})),
      $__7 = Object.freeze(Object.defineProperties(["return ", "(\n              ", ", this);"], {raw: {value: Object.freeze(["return ", "(\n              ", ", this);"])}})),
      $__8 = Object.freeze(Object.defineProperties(["return $ctx.end()"], {raw: {value: Object.freeze(["return $ctx.end()"])}})),
      $__9 = Object.freeze(Object.defineProperties(["\n                  $ctx.state = $ctx.finallyFallThrough;\n                  $ctx.finallyFallThrough = ", ";\n                  break;"], {raw: {value: Object.freeze(["\n                  $ctx.state = $ctx.finallyFallThrough;\n                  $ctx.finallyFallThrough = ", ";\n                  break;"])}})),
      $__10 = Object.freeze(Object.defineProperties(["\n                      $ctx.state = $ctx.finallyFallThrough;\n                      break;"], {raw: {value: Object.freeze(["\n                      $ctx.state = $ctx.finallyFallThrough;\n                      break;"])}}));
  var AlphaRenamer = System.get("traceur@0.0.80/src/codegeneration/AlphaRenamer.js").AlphaRenamer;
  var BreakContinueTransformer = System.get("traceur@0.0.80/src/codegeneration/generator/BreakContinueTransformer.js").BreakContinueTransformer;
  var $__13 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      BLOCK = $__13.BLOCK,
      CASE_CLAUSE = $__13.CASE_CLAUSE,
      CONDITIONAL_EXPRESSION = $__13.CONDITIONAL_EXPRESSION,
      EXPRESSION_STATEMENT = $__13.EXPRESSION_STATEMENT,
      PAREN_EXPRESSION = $__13.PAREN_EXPRESSION,
      STATE_MACHINE = $__13.STATE_MACHINE;
  var $__14 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AnonBlock = $__14.AnonBlock,
      Block = $__14.Block,
      CaseClause = $__14.CaseClause,
      IfStatement = $__14.IfStatement,
      SwitchStatement = $__14.SwitchStatement;
  var CatchState = System.get("traceur@0.0.80/src/codegeneration/generator/CatchState.js").CatchState;
  var ConditionalState = System.get("traceur@0.0.80/src/codegeneration/generator/ConditionalState.js").ConditionalState;
  var ExplodeExpressionTransformer = System.get("traceur@0.0.80/src/codegeneration/ExplodeExpressionTransformer.js").ExplodeExpressionTransformer;
  var FallThroughState = System.get("traceur@0.0.80/src/codegeneration/generator/FallThroughState.js").FallThroughState;
  var FinallyFallThroughState = System.get("traceur@0.0.80/src/codegeneration/generator/FinallyFallThroughState.js").FinallyFallThroughState;
  var FinallyState = System.get("traceur@0.0.80/src/codegeneration/generator/FinallyState.js").FinallyState;
  var FindInFunctionScope = System.get("traceur@0.0.80/src/codegeneration/FindInFunctionScope.js").FindInFunctionScope;
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var assert = System.get("traceur@0.0.80/src/util/assert.js").assert;
  var $__25 = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js"),
      parseExpression = $__25.parseExpression,
      parseStatement = $__25.parseStatement,
      parseStatements = $__25.parseStatements;
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var StateAllocator = System.get("traceur@0.0.80/src/codegeneration/generator/StateAllocator.js").StateAllocator;
  var StateMachine = System.get("traceur@0.0.80/src/syntax/trees/StateMachine.js").StateMachine;
  var $__29 = System.get("traceur@0.0.80/src/codegeneration/generator/SwitchState.js"),
      SwitchClause = $__29.SwitchClause,
      SwitchState = $__29.SwitchState;
  var TryState = System.get("traceur@0.0.80/src/codegeneration/generator/TryState.js").TryState;
  var $__31 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createAssignStateStatement = $__31.createAssignStateStatement,
      createBreakStatement = $__31.createBreakStatement,
      createCaseClause = $__31.createCaseClause,
      createDefaultClause = $__31.createDefaultClause,
      createExpressionStatement = $__31.createExpressionStatement,
      createFunctionBody = $__31.createFunctionBody,
      id = $__31.createIdentifierExpression,
      createMemberExpression = $__31.createMemberExpression,
      createNumberLiteral = $__31.createNumberLiteral,
      createSwitchStatement = $__31.createSwitchStatement;
  var HoistVariablesTransformer = System.get("traceur@0.0.80/src/codegeneration/HoistVariablesTransformer.js").default;
  var LabelState = function LabelState(name, continueState, fallThroughState) {
    this.name = name;
    this.continueState = continueState;
    this.fallThroughState = fallThroughState;
  };
  ($traceurRuntime.createClass)(LabelState, {}, {});
  var NeedsStateMachine = function NeedsStateMachine() {
    $traceurRuntime.superConstructor($NeedsStateMachine).apply(this, arguments);
  };
  var $NeedsStateMachine = NeedsStateMachine;
  ($traceurRuntime.createClass)(NeedsStateMachine, {
    visitBreakStatement: function(tree) {
      this.found = true;
    },
    visitContinueStatement: function(tree) {
      this.found = true;
    },
    visitStateMachine: function(tree) {
      this.found = true;
    },
    visitYieldExpression: function(tee) {
      this.found = true;
    }
  }, {}, FindInFunctionScope);
  function needsStateMachine(tree) {
    var visitor = new NeedsStateMachine();
    visitor.visitAny(tree);
    return visitor.found;
  }
  var HoistVariables = function HoistVariables() {
    $traceurRuntime.superConstructor($HoistVariables).call(this, true);
  };
  var $HoistVariables = HoistVariables;
  ($traceurRuntime.createClass)(HoistVariables, {
    prependVariables: function(statements) {
      return statements;
    },
    prependFunctions: function(statements) {
      return statements;
    }
  }, {}, HoistVariablesTransformer);
  var CPSTransformer = function CPSTransformer(identifierGenerator, reporter) {
    $traceurRuntime.superConstructor($CPSTransformer).call(this, identifierGenerator);
    this.reporter = reporter;
    this.stateAllocator_ = new StateAllocator();
    this.labelSet_ = Object.create(null);
    this.currentLabel_ = null;
    this.hoistVariablesTransformer_ = new HoistVariables();
  };
  var $CPSTransformer = CPSTransformer;
  ($traceurRuntime.createClass)(CPSTransformer, {
    expressionNeedsStateMachine: function(tree) {
      return false;
    },
    allocateState: function() {
      return this.stateAllocator_.allocateState();
    },
    transformBlock: function(tree) {
      var labels = this.getLabels_();
      var label = this.clearCurrentLabel_();
      var transformedTree = $traceurRuntime.superGet(this, $CPSTransformer.prototype, "transformBlock").call(this, tree);
      var machine = this.transformStatementList_(transformedTree.statements);
      if (machine === null)
        return transformedTree;
      if (label) {
        var states = [];
        for (var i = 0; i < machine.states.length; i++) {
          var state = machine.states[i];
          states.push(state.transformBreakOrContinue(labels));
        }
        machine = new StateMachine(machine.startState, machine.fallThroughState, states, machine.exceptionBlocks);
      }
      return machine;
    },
    transformFunctionBody: function(tree) {
      this.pushTempScope();
      var oldLabels = this.clearLabels_();
      var transformedTree = $traceurRuntime.superGet(this, $CPSTransformer.prototype, "transformFunctionBody").call(this, tree);
      var machine = this.transformStatementList_(transformedTree.statements);
      this.restoreLabels_(oldLabels);
      this.popTempScope();
      return machine == null ? transformedTree : machine;
    },
    transformStatementList_: function(trees) {
      var groups = [];
      var newMachine;
      for (var i = 0; i < trees.length; i++) {
        if (trees[i].type === STATE_MACHINE) {
          groups.push(trees[i]);
        } else if (needsStateMachine(trees[i])) {
          newMachine = this.ensureTransformed_(trees[i]);
          groups.push(newMachine);
        } else {
          var last = groups[groups.length - 1];
          if (!(last instanceof Array))
            groups.push(last = []);
          last.push(trees[i]);
        }
      }
      if (groups.length === 1 && groups[0] instanceof Array)
        return null;
      var machine = null;
      for (var i = 0; i < groups.length; i++) {
        if (groups[i] instanceof Array) {
          newMachine = this.statementsToStateMachine_(groups[i]);
        } else {
          newMachine = groups[i];
        }
        if (i === 0)
          machine = newMachine;
        else
          machine = machine.append(newMachine);
      }
      return machine;
    },
    needsStateMachine_: function(statements) {
      if (statements instanceof Array) {
        for (var i = 0; i < statements.length; i++) {
          if (needsStateMachine(statements[i]))
            return true;
        }
        return false;
      }
      assert(statements instanceof SwitchStatement);
      return needsStateMachine(statements);
    },
    transformCaseClause: function(tree) {
      var result = $traceurRuntime.superGet(this, $CPSTransformer.prototype, "transformCaseClause").call(this, tree);
      var machine = this.transformStatementList_(result.statements);
      return machine == null ? result : new CaseClause(null, result.expression, [machine]);
    },
    transformDoWhileStatement: function(tree) {
      var $__37;
      var $__35,
          $__36;
      var labels = this.getLabels_();
      var label = this.clearCurrentLabel_();
      var machine,
          condition,
          body;
      if (this.expressionNeedsStateMachine(tree.condition)) {
        (($__35 = this.expressionToStateMachine(tree.condition), machine = $__35.machine, condition = $__35.expression, $__35));
        body = this.transformAny(tree.body);
      } else {
        var result = $traceurRuntime.superGet(this, $CPSTransformer.prototype, "transformDoWhileStatement").call(this, tree);
        (($__36 = result, condition = $__36.condition, body = $__36.body, $__36));
        if (body.type != STATE_MACHINE)
          return result;
      }
      var loopBodyMachine = this.ensureTransformed_(body);
      var startState = loopBodyMachine.startState;
      var conditionState = loopBodyMachine.fallThroughState;
      var fallThroughState = this.allocateState();
      var states = [];
      this.addLoopBodyStates_(loopBodyMachine, conditionState, fallThroughState, labels, states);
      if (machine) {
        machine = machine.replaceStartState(conditionState);
        conditionState = machine.fallThroughState;
        ($__37 = states).push.apply($__37, $traceurRuntime.spread(machine.states));
      }
      states.push(new ConditionalState(conditionState, startState, fallThroughState, condition));
      var machine = new StateMachine(startState, fallThroughState, states, loopBodyMachine.exceptionBlocks);
      if (label)
        machine = machine.replaceStateId(conditionState, label.continueState);
      return machine;
    },
    addLoopBodyStates_: function(loopBodyMachine, continueState, breakState, labels, states) {
      for (var i = 0; i < loopBodyMachine.states.length; i++) {
        var state = loopBodyMachine.states[i];
        states.push(state.transformBreakOrContinue(labels, breakState, continueState));
      }
    },
    transformForStatement: function(tree) {
      var $__37,
          $__38,
          $__39;
      var labels = this.getLabels_();
      var label = this.clearCurrentLabel_();
      var tmp;
      var initializer = null,
          initializerMachine;
      if (tree.initializer) {
        if (this.expressionNeedsStateMachine(tree.initializer)) {
          tmp = this.expressionToStateMachine(tree.initializer);
          initializer = tmp.expression;
          initializerMachine = tmp.machine;
        } else {
          initializer = this.transformAny(tree.initializer);
        }
      }
      var condition = null,
          conditionMachine;
      if (tree.condition) {
        if (this.expressionNeedsStateMachine(tree.condition)) {
          tmp = this.expressionToStateMachine(tree.condition);
          condition = tmp.expression;
          conditionMachine = tmp.machine;
        } else {
          condition = this.transformAny(tree.condition);
        }
      }
      var increment = null,
          incrementMachine;
      if (tree.increment) {
        if (this.expressionNeedsStateMachine(tree.increment)) {
          tmp = this.expressionToStateMachine(tree.increment);
          increment = tmp.expression;
          incrementMachine = tmp.machine;
        } else {
          increment = this.transformAny(tree.increment);
        }
      }
      var body = this.transformAny(tree.body);
      if (initializer === tree.initializer && condition === tree.condition && increment === tree.increment && body === tree.body) {
        return tree;
      }
      if (!initializerMachine && !conditionMachine && !incrementMachine && body.type !== STATE_MACHINE) {
        return new ForStatement(tree.location, initializer, condition, increment, body);
      }
      var loopBodyMachine = this.ensureTransformed_(body);
      var bodyFallThroughId = loopBodyMachine.fallThroughState;
      var fallThroughId = this.allocateState();
      var startId;
      var initializerStartId = initializer ? this.allocateState() : State.INVALID_STATE;
      var conditionStartId = increment ? this.allocateState() : bodyFallThroughId;
      var loopStartId = loopBodyMachine.startState;
      var incrementStartId = bodyFallThroughId;
      var states = [];
      if (initializer) {
        startId = initializerStartId;
        var initialiserFallThroughId;
        if (condition)
          initialiserFallThroughId = conditionStartId;
        else
          initialiserFallThroughId = loopStartId;
        var tmpId = initializerStartId;
        if (initializerMachine) {
          initializerMachine = initializerMachine.replaceStartState(initializerStartId);
          tmpId = initializerMachine.fallThroughState;
          ($__37 = states).push.apply($__37, $traceurRuntime.spread(initializerMachine.states));
        }
        states.push(new FallThroughState(tmpId, initialiserFallThroughId, [createExpressionStatement(initializer)]));
      }
      if (condition) {
        if (!initializer)
          startId = conditionStartId;
        var tmpId = conditionStartId;
        if (conditionMachine) {
          conditionMachine = conditionMachine.replaceStartState(conditionStartId);
          tmpId = conditionMachine.fallThroughState;
          ($__38 = states).push.apply($__38, $traceurRuntime.spread(conditionMachine.states));
        }
        states.push(new ConditionalState(tmpId, loopStartId, fallThroughId, condition));
      }
      if (increment) {
        var incrementFallThroughId;
        if (condition)
          incrementFallThroughId = conditionStartId;
        else
          incrementFallThroughId = loopStartId;
        var tmpId = incrementStartId;
        if (incrementMachine) {
          incrementMachine = incrementMachine.replaceStartState(incrementStartId);
          tmpId = incrementMachine.fallThroughState;
          ($__39 = states).push.apply($__39, $traceurRuntime.spread(incrementMachine.states));
        }
        states.push(new FallThroughState(tmpId, incrementFallThroughId, [createExpressionStatement(increment)]));
      }
      if (!initializer && !condition)
        startId = loopStartId;
      var continueId;
      if (increment)
        continueId = incrementStartId;
      else if (condition)
        continueId = conditionStartId;
      else
        continueId = loopStartId;
      if (!increment && !condition) {
        loopBodyMachine = loopBodyMachine.replaceFallThroughState(loopBodyMachine.startState);
      }
      this.addLoopBodyStates_(loopBodyMachine, continueId, fallThroughId, labels, states);
      var machine = new StateMachine(startId, fallThroughId, states, loopBodyMachine.exceptionBlocks);
      if (label)
        machine = machine.replaceStateId(continueId, label.continueState);
      return machine;
    },
    transformForInStatement: function(tree) {
      return tree;
    },
    transformForOfStatement: function(tree) {
      throw new Error('for of statements should be transformed before this pass');
    },
    transformIfStatement: function(tree) {
      var $__37,
          $__38,
          $__39;
      var $__35,
          $__36;
      var machine,
          condition,
          ifClause,
          elseClause;
      if (this.expressionNeedsStateMachine(tree.condition)) {
        (($__35 = this.expressionToStateMachine(tree.condition), machine = $__35.machine, condition = $__35.expression, $__35));
        ifClause = this.transformAny(tree.ifClause);
        elseClause = this.transformAny(tree.elseClause);
      } else {
        var result = $traceurRuntime.superGet(this, $CPSTransformer.prototype, "transformIfStatement").call(this, tree);
        (($__36 = result, condition = $__36.condition, ifClause = $__36.ifClause, elseClause = $__36.elseClause, $__36));
        if (ifClause.type !== STATE_MACHINE && (elseClause === null || elseClause.type !== STATE_MACHINE)) {
          return result;
        }
      }
      ifClause = this.ensureTransformed_(ifClause);
      elseClause = this.ensureTransformed_(elseClause);
      var startState = this.allocateState();
      var fallThroughState = ifClause.fallThroughState;
      var ifState = ifClause.startState;
      var elseState = elseClause == null ? fallThroughState : elseClause.startState;
      var states = [];
      var exceptionBlocks = [];
      states.push(new ConditionalState(startState, ifState, elseState, condition));
      ($__37 = states).push.apply($__37, $traceurRuntime.spread(ifClause.states));
      ($__38 = exceptionBlocks).push.apply($__38, $traceurRuntime.spread(ifClause.exceptionBlocks));
      if (elseClause != null) {
        this.replaceAndAddStates_(elseClause.states, elseClause.fallThroughState, fallThroughState, states);
        ($__39 = exceptionBlocks).push.apply($__39, $traceurRuntime.spread(State.replaceAllStates(elseClause.exceptionBlocks, elseClause.fallThroughState, fallThroughState)));
      }
      var ifMachine = new StateMachine(startState, fallThroughState, states, exceptionBlocks);
      if (machine)
        ifMachine = machine.append(ifMachine);
      return ifMachine;
    },
    removeEmptyStates: function(oldStates) {
      var emptyStates = [],
          newStates = [];
      for (var i = 0; i < oldStates.length; i++) {
        if (oldStates[i] instanceof FallThroughState && oldStates[i].statements.length === 0) {
          emptyStates.push(oldStates[i]);
        } else {
          newStates.push(oldStates[i]);
        }
      }
      for (i = 0; i < newStates.length; i++) {
        newStates[i] = emptyStates.reduce((function(state, $__35) {
          var $__36 = $__35,
              id = $__36.id,
              fallThroughState = $__36.fallThroughState;
          return state.replaceState(id, fallThroughState);
        }), newStates[i]);
      }
      return newStates;
    },
    replaceAndAddStates_: function(oldStates, oldState, newState, newStates) {
      for (var i = 0; i < oldStates.length; i++) {
        newStates.push(oldStates[i].replaceState(oldState, newState));
      }
    },
    transformLabelledStatement: function(tree) {
      var startState = this.allocateState();
      var continueState = this.allocateState();
      var fallThroughState = this.allocateState();
      var label = new LabelState(tree.name.value, continueState, fallThroughState);
      var oldLabels = this.addLabel_(label);
      this.currentLabel_ = label;
      var result = this.transformAny(tree.statement);
      if (result === tree.statement) {
        result = tree;
      } else if (result.type === STATE_MACHINE) {
        result = result.replaceStartState(startState);
        result = result.replaceFallThroughState(fallThroughState);
      }
      this.restoreLabels_(oldLabels);
      return result;
    },
    getLabels_: function() {
      return this.labelSet_;
    },
    restoreLabels_: function(oldLabels) {
      this.labelSet_ = oldLabels;
    },
    addLabel_: function(label) {
      var oldLabels = this.labelSet_;
      var labelSet = Object.create(null);
      for (var k in this.labelSet_) {
        labelSet[k] = this.labelSet_[k];
      }
      labelSet[label.name] = label;
      this.labelSet_ = labelSet;
      return oldLabels;
    },
    clearLabels_: function() {
      var result = this.labelSet_;
      this.labelSet_ = Object.create(null);
      return result;
    },
    clearCurrentLabel_: function() {
      var result = this.currentLabel_;
      this.currentLabel_ = null;
      return result;
    },
    transformSwitchStatement: function(tree) {
      var $__35,
          $__36;
      var labels = this.getLabels_();
      var expression,
          machine,
          caseClauses;
      if (this.expressionNeedsStateMachine(tree.expression)) {
        (($__35 = this.expressionToStateMachine(tree.expression), expression = $__35.expression, machine = $__35.machine, $__35));
        caseClauses = this.transformList(tree.caseClauses);
      } else {
        var result = $traceurRuntime.superGet(this, $CPSTransformer.prototype, "transformSwitchStatement").call(this, tree);
        if (!needsStateMachine(result))
          return result;
        (($__36 = result, expression = $__36.expression, caseClauses = $__36.caseClauses, $__36));
      }
      var startState = this.allocateState();
      var fallThroughState = this.allocateState();
      var nextState = fallThroughState;
      var states = [];
      var clauses = [];
      var tryStates = [];
      var hasDefault = false;
      for (var index = caseClauses.length - 1; index >= 0; index--) {
        var clause = caseClauses[index];
        if (clause.type == CASE_CLAUSE) {
          var caseClause = clause;
          nextState = this.addSwitchClauseStates_(nextState, fallThroughState, labels, caseClause.statements, states, tryStates);
          clauses.push(new SwitchClause(caseClause.expression, nextState));
        } else {
          hasDefault = true;
          var defaultClause = clause;
          nextState = this.addSwitchClauseStates_(nextState, fallThroughState, labels, defaultClause.statements, states, tryStates);
          clauses.push(new SwitchClause(null, nextState));
        }
      }
      if (!hasDefault) {
        clauses.push(new SwitchClause(null, fallThroughState));
      }
      states.push(new SwitchState(startState, expression, clauses.reverse()));
      var switchMachine = new StateMachine(startState, fallThroughState, states.reverse(), tryStates);
      if (machine)
        switchMachine = machine.append(switchMachine);
      return switchMachine;
    },
    addSwitchClauseStates_: function(nextState, fallThroughState, labels, statements, states, tryStates) {
      var $__37;
      var machine = this.ensureTransformedList_(statements);
      for (var i = 0; i < machine.states.length; i++) {
        var state = machine.states[i];
        var transformedState = state.transformBreak(labels, fallThroughState);
        states.push(transformedState.replaceState(machine.fallThroughState, nextState));
      }
      ($__37 = tryStates).push.apply($__37, $traceurRuntime.spread(machine.exceptionBlocks));
      return machine.startState;
    },
    transformTryStatement: function(tree) {
      var result = $traceurRuntime.superGet(this, $CPSTransformer.prototype, "transformTryStatement").call(this, tree);
      var $__35 = result,
          body = $__35.body,
          catchBlock = $__35.catchBlock,
          finallyBlock = $__35.finallyBlock;
      if (body.type != STATE_MACHINE && (catchBlock == null || catchBlock.catchBody.type != STATE_MACHINE) && (finallyBlock == null || finallyBlock.block.type != STATE_MACHINE)) {
        return result;
      }
      var outerCatchState = this.allocateState();
      var outerFinallyState = this.allocateState();
      var pushTryState = this.statementToStateMachine_(parseStatement($__0, (catchBlock && outerCatchState), (finallyBlock && outerFinallyState)));
      var tryMachine = this.ensureTransformed_(body);
      tryMachine = pushTryState.append(tryMachine);
      if (catchBlock !== null) {
        var popTry = this.statementToStateMachine_(parseStatement($__1));
        tryMachine = tryMachine.append(popTry);
        var exceptionName = catchBlock.binding.identifierToken.value;
        var catchMachine = this.ensureTransformed_(catchBlock.catchBody);
        var catchStart = this.allocateState();
        this.addMachineVariable(exceptionName);
        var states = $traceurRuntime.spread(tryMachine.states, [new FallThroughState(catchStart, catchMachine.startState, parseStatements($__2, id(exceptionName)))]);
        this.replaceAndAddStates_(catchMachine.states, catchMachine.fallThroughState, tryMachine.fallThroughState, states);
        tryMachine = new StateMachine(tryMachine.startState, tryMachine.fallThroughState, states, [new CatchState(exceptionName, catchStart, tryMachine.fallThroughState, tryMachine.getAllStateIDs(), tryMachine.exceptionBlocks)]);
        tryMachine = tryMachine.replaceStateId(catchStart, outerCatchState);
      }
      if (finallyBlock != null) {
        var finallyMachine = this.ensureTransformed_(finallyBlock.block);
        var popTry = this.statementToStateMachine_(parseStatement($__3));
        finallyMachine = popTry.append(finallyMachine);
        var states = $traceurRuntime.spread(tryMachine.states, finallyMachine.states, [new FinallyFallThroughState(finallyMachine.fallThroughState)]);
        tryMachine = new StateMachine(tryMachine.startState, tryMachine.fallThroughState, states, [new FinallyState(finallyMachine.startState, finallyMachine.fallThroughState, tryMachine.getAllStateIDs(), tryMachine.exceptionBlocks)]);
        tryMachine = tryMachine.replaceStateId(finallyMachine.startState, outerFinallyState);
      }
      return tryMachine;
    },
    transformWhileStatement: function(tree) {
      var $__37;
      var $__35,
          $__36;
      var labels = this.getLabels_();
      var label = this.clearCurrentLabel_();
      var condition,
          machine,
          body;
      if (this.expressionNeedsStateMachine(tree.condition)) {
        (($__35 = this.expressionToStateMachine(tree.condition), machine = $__35.machine, condition = $__35.expression, $__35));
        body = this.transformAny(tree.body);
      } else {
        var result = $traceurRuntime.superGet(this, $CPSTransformer.prototype, "transformWhileStatement").call(this, tree);
        (($__36 = result, condition = $__36.condition, body = $__36.body, $__36));
        if (body.type !== STATE_MACHINE)
          return result;
      }
      var loopBodyMachine = this.ensureTransformed_(body);
      var startState = loopBodyMachine.fallThroughState;
      var fallThroughState = this.allocateState();
      var states = [];
      var conditionStart = startState;
      if (machine) {
        machine = machine.replaceStartState(startState);
        conditionStart = machine.fallThroughState;
        ($__37 = states).push.apply($__37, $traceurRuntime.spread(machine.states));
      }
      states.push(new ConditionalState(conditionStart, loopBodyMachine.startState, fallThroughState, condition));
      this.addLoopBodyStates_(loopBodyMachine, startState, fallThroughState, labels, states);
      var machine = new StateMachine(startState, fallThroughState, states, loopBodyMachine.exceptionBlocks);
      if (label)
        machine = machine.replaceStateId(startState, label.continueState);
      return machine;
    },
    transformWithStatement: function(tree) {
      var result = $traceurRuntime.superGet(this, $CPSTransformer.prototype, "transformWithStatement").call(this, tree);
      if (result.body.type != STATE_MACHINE) {
        return result;
      }
      throw new Error('Unreachable - with statement not allowed in strict mode/harmony');
    },
    generateMachineInnerFunction: function(machine) {
      var enclosingFinallyState = machine.getEnclosingFinallyMap();
      var SwitchStatement = createSwitchStatement(createMemberExpression('$ctx', 'state'), this.transformMachineStates(machine, State.END_STATE, State.RETHROW_STATE, enclosingFinallyState));
      return parseExpression($__4, SwitchStatement);
    },
    addTempVar: function() {
      var name = this.getTempIdentifier();
      this.addMachineVariable(name);
      return name;
    },
    addMachineVariable: function(name) {
      this.hoistVariablesTransformer_.addVariable(name);
    },
    transformCpsFunctionBody: function(tree, runtimeMethod) {
      var $__37;
      var functionRef = arguments[2];
      var alphaRenamedTree = AlphaRenamer.rename(tree, 'arguments', '$arguments');
      var hasArguments = alphaRenamedTree !== tree;
      var hoistedTree = this.hoistVariablesTransformer_.transformAny(alphaRenamedTree);
      var maybeMachine = this.transformAny(hoistedTree);
      if (this.reporter.hadError())
        return tree;
      var machine;
      if (maybeMachine.type !== STATE_MACHINE) {
        machine = this.statementsToStateMachine_(maybeMachine.statements);
      } else {
        machine = new StateMachine(maybeMachine.startState, maybeMachine.fallThroughState, this.removeEmptyStates(maybeMachine.states), maybeMachine.exceptionBlocks);
      }
      machine = machine.replaceFallThroughState(State.END_STATE).replaceStartState(State.START_STATE);
      var statements = [];
      if (this.hoistVariablesTransformer_.hasFunctions())
        ($__37 = statements).push.apply($__37, $traceurRuntime.spread(this.hoistVariablesTransformer_.getFunctions()));
      if (this.hoistVariablesTransformer_.hasVariables())
        statements.push(this.hoistVariablesTransformer_.getVariableStatement());
      if (hasArguments)
        statements.push(parseStatement($__5));
      if (functionRef) {
        statements.push(parseStatement($__6, runtimeMethod, this.generateMachineInnerFunction(machine), functionRef));
      } else {
        statements.push(parseStatement($__7, runtimeMethod, this.generateMachineInnerFunction(machine)));
      }
      return createFunctionBody(statements);
    },
    transformFunctionDeclaration: function(tree) {
      return tree;
    },
    transformFunctionExpression: function(tree) {
      return tree;
    },
    transformGetAccessor: function(tree) {
      return tree;
    },
    transformSetAccessor: function(tree) {
      return tree;
    },
    transformArrowFunctionExpression: function(tree) {
      return tree;
    },
    transformStateMachine: function(tree) {
      return tree;
    },
    statementToStateMachine_: function(statement) {
      var statements;
      if (statement.type === BLOCK)
        statements = statement.statements;
      else
        statements = [statement];
      return this.statementsToStateMachine_(statements);
    },
    statementsToStateMachine_: function(statements) {
      var startState = this.allocateState();
      var fallThroughState = this.allocateState();
      return this.stateToStateMachine_(new FallThroughState(startState, fallThroughState, statements), fallThroughState);
    },
    stateToStateMachine_: function(newState, fallThroughState) {
      return new StateMachine(newState.id, fallThroughState, [newState], []);
    },
    transformMachineStates: function(machine, machineEndState, rethrowState, enclosingFinallyState) {
      var cases = [];
      for (var i = 0; i < machine.states.length; i++) {
        var state = machine.states[i];
        var stateCase = state.transformMachineState(enclosingFinallyState[state.id], machineEndState, this.reporter);
        if (stateCase != null) {
          cases.push(stateCase);
        }
      }
      this.addFinallyFallThroughDispatches(null, machine.exceptionBlocks, cases);
      cases.push(createDefaultClause(parseStatements($__8)));
      return cases;
    },
    addFinallyFallThroughDispatches: function(enclosingFinallyState, tryStates, cases) {
      for (var i = 0; i < tryStates.length; i++) {
        var tryState = tryStates[i];
        if (tryState.kind == TryState.Kind.FINALLY) {
          var finallyState = tryState;
          if (enclosingFinallyState != null) {
            var caseClauses = [];
            var index = 0;
            for (var j = 0; j < enclosingFinallyState.tryStates.length; j++) {
              var destination = enclosingFinallyState.tryStates[j];
              index++;
              var statements;
              if (index < enclosingFinallyState.tryStates.length) {
                statements = [];
              } else {
                statements = parseStatements($__9, State.INVALID_STATE);
              }
              caseClauses.push(createCaseClause(createNumberLiteral(destination), statements));
            }
            caseClauses.push(createDefaultClause([createAssignStateStatement(enclosingFinallyState.finallyState), createBreakStatement()]));
            cases.push(createCaseClause(createNumberLiteral(finallyState.fallThroughState), [createSwitchStatement(createMemberExpression('$ctx', 'finallyFallThrough'), caseClauses), createBreakStatement()]));
          } else {
            cases.push(createCaseClause(createNumberLiteral(finallyState.fallThroughState), parseStatements($__10)));
          }
          this.addFinallyFallThroughDispatches(finallyState, finallyState.nestedTrys, cases);
        } else {
          this.addFinallyFallThroughDispatches(enclosingFinallyState, tryState.nestedTrys, cases);
        }
      }
    },
    transformVariableDeclarationList: function(tree) {
      this.reporter.reportError(tree.location && tree.location.start, 'Traceur: const/let declarations in a block containing a yield are ' + 'not yet implemented');
      return tree;
    },
    maybeTransformStatement_: function(maybeTransformedStatement) {
      var breakContinueTransformed = new BreakContinueTransformer(this.stateAllocator_).transformAny(maybeTransformedStatement);
      if (breakContinueTransformed != maybeTransformedStatement) {
        breakContinueTransformed = this.transformAny(breakContinueTransformed);
      }
      return breakContinueTransformed;
    },
    ensureTransformed_: function(statement) {
      if (statement == null) {
        return null;
      }
      var maybeTransformed = this.maybeTransformStatement_(statement);
      return maybeTransformed.type == STATE_MACHINE ? maybeTransformed : this.statementToStateMachine_(maybeTransformed);
    },
    ensureTransformedList_: function(statements) {
      var maybeTransformedStatements = [];
      var foundMachine = false;
      for (var i = 0; i < statements.length; i++) {
        var statement = statements[i];
        var maybeTransformedStatement = this.maybeTransformStatement_(statement);
        maybeTransformedStatements.push(maybeTransformedStatement);
        if (maybeTransformedStatement.type == STATE_MACHINE) {
          foundMachine = true;
        }
      }
      if (!foundMachine) {
        return this.statementsToStateMachine_(statements);
      }
      return this.transformStatementList_(maybeTransformedStatements);
    },
    expressionToStateMachine: function(tree) {
      var commaExpression = new ExplodeExpressionTransformer(this).transformAny(tree);
      var statements = new NormalizeCommaExpressionToStatementTransformer().transformAny(commaExpression).statements;
      var lastStatement = statements.pop();
      assert(lastStatement.type === EXPRESSION_STATEMENT);
      var expression = lastStatement.expression;
      statements = $traceurRuntime.superGet(this, $CPSTransformer.prototype, "transformList").call(this, statements);
      var machine = this.transformStatementList_(statements);
      return {
        expression: expression,
        machine: machine
      };
    }
  }, {}, TempVarTransformer);
  var NormalizeCommaExpressionToStatementTransformer = function NormalizeCommaExpressionToStatementTransformer() {
    $traceurRuntime.superConstructor($NormalizeCommaExpressionToStatementTransformer).apply(this, arguments);
  };
  var $NormalizeCommaExpressionToStatementTransformer = NormalizeCommaExpressionToStatementTransformer;
  ($traceurRuntime.createClass)(NormalizeCommaExpressionToStatementTransformer, {
    transformCommaExpression: function(tree) {
      var $__33 = this;
      var statements = tree.expressions.map((function(expr) {
        if (expr.type === CONDITIONAL_EXPRESSION)
          return $__33.transformAny(expr);
        return createExpressionStatement(expr);
      }));
      return new AnonBlock(tree.location, statements);
    },
    transformConditionalExpression: function(tree) {
      var ifBlock = this.transformAny(tree.left);
      var elseBlock = this.transformAny(tree.right);
      return new IfStatement(tree.location, tree.condition, anonBlockToBlock(ifBlock), anonBlockToBlock(elseBlock));
    }
  }, {}, ParseTreeTransformer);
  function anonBlockToBlock(tree) {
    if (tree.type === PAREN_EXPRESSION)
      return anonBlockToBlock(tree.expression);
    return new Block(tree.location, tree.statements);
  }
  return {get CPSTransformer() {
      return CPSTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/EndState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/EndState.js";
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var EndState = function EndState() {
    $traceurRuntime.superConstructor($EndState).apply(this, arguments);
  };
  var $EndState = EndState;
  ($traceurRuntime.createClass)(EndState, {
    replaceState: function(oldState, newState) {
      return new $EndState(State.replaceStateId(this.id, oldState, newState));
    },
    transform: function(enclosingFinally, machineEndState, reporter) {
      return State.generateJump(enclosingFinally, machineEndState);
    }
  }, {}, State);
  return {get EndState() {
      return EndState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/AsyncTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/AsyncTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["$ctx.value"], {raw: {value: Object.freeze(["$ctx.value"])}})),
      $__1 = Object.freeze(Object.defineProperties(["$ctx.returnValue = ", ""], {raw: {value: Object.freeze(["$ctx.returnValue = ", ""])}})),
      $__2 = Object.freeze(Object.defineProperties(["$ctx.resolve(", ")"], {raw: {value: Object.freeze(["$ctx.resolve(", ")"])}})),
      $__3 = Object.freeze(Object.defineProperties(["$traceurRuntime.asyncWrap"], {raw: {value: Object.freeze(["$traceurRuntime.asyncWrap"])}}));
  var AwaitState = System.get("traceur@0.0.80/src/codegeneration/generator/AwaitState.js").AwaitState;
  var $__5 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      BinaryExpression = $__5.BinaryExpression,
      ExpressionStatement = $__5.ExpressionStatement;
  var CPSTransformer = System.get("traceur@0.0.80/src/codegeneration/generator/CPSTransformer.js").CPSTransformer;
  var EndState = System.get("traceur@0.0.80/src/codegeneration/generator/EndState.js").EndState;
  var FallThroughState = System.get("traceur@0.0.80/src/codegeneration/generator/FallThroughState.js").FallThroughState;
  var $__9 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      AWAIT_EXPRESSION = $__9.AWAIT_EXPRESSION,
      BINARY_EXPRESSION = $__9.BINARY_EXPRESSION,
      STATE_MACHINE = $__9.STATE_MACHINE;
  var $__10 = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js"),
      parseExpression = $__10.parseExpression,
      parseStatement = $__10.parseStatement,
      parseStatements = $__10.parseStatements;
  var StateMachine = System.get("traceur@0.0.80/src/syntax/trees/StateMachine.js").StateMachine;
  var FindInFunctionScope = System.get("traceur@0.0.80/src/codegeneration/FindInFunctionScope.js").FindInFunctionScope;
  var createUndefinedExpression = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js").createUndefinedExpression;
  function isAwaitAssign(tree) {
    return tree.type === BINARY_EXPRESSION && tree.operator.isAssignmentOperator() && tree.right.type === AWAIT_EXPRESSION && tree.left.isLeftHandSideExpression();
  }
  var AwaitFinder = function AwaitFinder() {
    $traceurRuntime.superConstructor($AwaitFinder).apply(this, arguments);
  };
  var $AwaitFinder = AwaitFinder;
  ($traceurRuntime.createClass)(AwaitFinder, {visitAwaitExpression: function(tree) {
      this.found = true;
    }}, {}, FindInFunctionScope);
  function scopeContainsAwait(tree) {
    var visitor = new AwaitFinder();
    visitor.visitAny(tree);
    return visitor.found;
  }
  var AsyncTransformer = function AsyncTransformer() {
    $traceurRuntime.superConstructor($AsyncTransformer).apply(this, arguments);
  };
  var $AsyncTransformer = AsyncTransformer;
  ($traceurRuntime.createClass)(AsyncTransformer, {
    expressionNeedsStateMachine: function(tree) {
      if (tree === null)
        return false;
      return scopeContainsAwait(tree);
    },
    transformExpressionStatement: function(tree) {
      var expression = tree.expression;
      if (expression.type === AWAIT_EXPRESSION)
        return this.transformAwaitExpression_(expression);
      if (isAwaitAssign(expression))
        return this.transformAwaitAssign_(expression);
      if (this.expressionNeedsStateMachine(expression)) {
        return this.expressionToStateMachine(expression).machine;
      }
      return $traceurRuntime.superGet(this, $AsyncTransformer.prototype, "transformExpressionStatement").call(this, tree);
    },
    transformAwaitExpression: function(tree) {
      throw new Error('Internal error');
    },
    transformAwaitExpression_: function(tree) {
      return this.transformAwait_(tree, tree.expression, null, null);
    },
    transformAwaitAssign_: function(tree) {
      return this.transformAwait_(tree, tree.right.expression, tree.left, tree.operator);
    },
    transformAwait_: function(tree, inExpression, left, operator) {
      var $__15;
      var expression,
          machine;
      if (this.expressionNeedsStateMachine(inExpression)) {
        (($__15 = this.expressionToStateMachine(inExpression), expression = $__15.expression, machine = $__15.machine, $__15));
      } else {
        expression = this.transformAny(inExpression);
      }
      var createTaskState = this.allocateState();
      var fallThroughState = this.allocateState();
      var callbackState = left ? this.allocateState() : fallThroughState;
      var states = [];
      states.push(new AwaitState(createTaskState, callbackState, expression));
      if (left) {
        var statement = new ExpressionStatement(tree.location, new BinaryExpression(tree.location, left, operator, parseExpression($__0)));
        states.push(new FallThroughState(callbackState, fallThroughState, [statement]));
      }
      var awaitMachine = new StateMachine(createTaskState, fallThroughState, states, []);
      if (machine) {
        awaitMachine = machine.append(awaitMachine);
      }
      return awaitMachine;
    },
    transformFinally: function(tree) {
      var result = $traceurRuntime.superGet(this, $AsyncTransformer.prototype, "transformFinally").call(this, tree);
      if (result.block.type != STATE_MACHINE) {
        return result;
      }
      this.reporter.reportError(tree.location.start, 'await not permitted within a finally block.');
      return result;
    },
    transformReturnStatement: function(tree) {
      var $__15;
      var expression,
          machine;
      if (this.expressionNeedsStateMachine(tree.expression)) {
        (($__15 = this.expressionToStateMachine(tree.expression), expression = $__15.expression, machine = $__15.machine, $__15));
      } else {
        expression = tree.expression || createUndefinedExpression();
      }
      var startState = this.allocateState();
      var endState = this.allocateState();
      var completeState = new FallThroughState(startState, endState, parseStatements($__1, expression));
      var end = new EndState(endState);
      var returnMachine = new StateMachine(startState, this.allocateState(), [completeState, end], []);
      if (machine)
        returnMachine = machine.append(returnMachine);
      return returnMachine;
    },
    createCompleteTask_: function(result) {
      return parseStatement($__2, result);
    },
    transformAsyncBody: function(tree) {
      var runtimeFunction = parseExpression($__3);
      return this.transformCpsFunctionBody(tree, runtimeFunction);
    }
  }, {transformAsyncBody: function(identifierGenerator, reporter, body) {
      return new $AsyncTransformer(identifierGenerator, reporter).transformAsyncBody(body);
    }}, CPSTransformer);
  ;
  return {get AsyncTransformer() {
      return AsyncTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/ForInTransformPass.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/ForInTransformPass.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      BLOCK = $__0.BLOCK,
      VARIABLE_DECLARATION_LIST = $__0.VARIABLE_DECLARATION_LIST,
      IDENTIFIER_EXPRESSION = $__0.IDENTIFIER_EXPRESSION;
  var $__1 = System.get("traceur@0.0.80/src/syntax/PredefinedName.js"),
      LENGTH = $__1.LENGTH,
      PUSH = $__1.PUSH;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var $__3 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      BANG = $__3.BANG,
      IN = $__3.IN,
      OPEN_ANGLE = $__3.OPEN_ANGLE,
      PLUS_PLUS = $__3.PLUS_PLUS,
      VAR = $__3.VAR;
  var $__4 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createArgumentList = $__4.createArgumentList,
      createAssignmentStatement = $__4.createAssignmentStatement,
      createBinaryExpression = $__4.createBinaryExpression,
      createBlock = $__4.createBlock,
      createCallStatement = $__4.createCallStatement,
      createContinueStatement = $__4.createContinueStatement,
      createEmptyArrayLiteralExpression = $__4.createEmptyArrayLiteralExpression,
      createForInStatement = $__4.createForInStatement,
      createForStatement = $__4.createForStatement,
      createIdentifierExpression = $__4.createIdentifierExpression,
      createIfStatement = $__4.createIfStatement,
      createMemberExpression = $__4.createMemberExpression,
      createMemberLookupExpression = $__4.createMemberLookupExpression,
      createNumberLiteral = $__4.createNumberLiteral,
      createOperatorToken = $__4.createOperatorToken,
      createParenExpression = $__4.createParenExpression,
      createPostfixExpression = $__4.createPostfixExpression,
      createUnaryExpression = $__4.createUnaryExpression,
      createVariableDeclarationList = $__4.createVariableDeclarationList,
      createVariableStatement = $__4.createVariableStatement;
  var ForInTransformPass = function ForInTransformPass() {
    $traceurRuntime.superConstructor($ForInTransformPass).apply(this, arguments);
  };
  var $ForInTransformPass = ForInTransformPass;
  ($traceurRuntime.createClass)(ForInTransformPass, {transformForInStatement: function(tree) {
      var $__6,
          $__7;
      var bodyStatements = [];
      var body = this.transformAny(tree.body);
      if (body.type == BLOCK) {
        ($__6 = bodyStatements).push.apply($__6, $traceurRuntime.spread(body.statements));
      } else {
        bodyStatements.push(body);
      }
      var elements = [];
      var keys = this.getTempIdentifier();
      elements.push(createVariableStatement(VAR, keys, createEmptyArrayLiteralExpression()));
      var collection = this.getTempIdentifier();
      elements.push(createVariableStatement(VAR, collection, tree.collection));
      var p = this.getTempIdentifier();
      elements.push(createForInStatement(createVariableDeclarationList(VAR, p, null), createIdentifierExpression(collection), createCallStatement(createMemberExpression(keys, PUSH), createArgumentList([createIdentifierExpression(p)]))));
      var i = this.getTempIdentifier();
      var lookup = createMemberLookupExpression(createIdentifierExpression(keys), createIdentifierExpression(i));
      var originalKey,
          assignOriginalKey;
      if (tree.initializer.type == VARIABLE_DECLARATION_LIST) {
        var decList = tree.initializer;
        originalKey = createIdentifierExpression(decList.declarations[0].lvalue);
        assignOriginalKey = createVariableStatement(decList.declarationType, originalKey.identifierToken, lookup);
      } else if (tree.initializer.type == IDENTIFIER_EXPRESSION) {
        originalKey = tree.initializer;
        assignOriginalKey = createAssignmentStatement(tree.initializer, lookup);
      } else {
        throw new Error('Invalid left hand side of for in loop');
      }
      var innerBlock = [];
      innerBlock.push(assignOriginalKey);
      innerBlock.push(createIfStatement(createUnaryExpression(createOperatorToken(BANG), createParenExpression(createBinaryExpression(originalKey, createOperatorToken(IN), createIdentifierExpression(collection)))), createContinueStatement(), null));
      ($__7 = innerBlock).push.apply($__7, $traceurRuntime.spread(bodyStatements));
      elements.push(createForStatement(createVariableDeclarationList(VAR, i, createNumberLiteral(0)), createBinaryExpression(createIdentifierExpression(i), createOperatorToken(OPEN_ANGLE), createMemberExpression(keys, LENGTH)), createPostfixExpression(createIdentifierExpression(i), createOperatorToken(PLUS_PLUS)), createBlock(innerBlock)));
      return createBlock(elements);
    }}, {}, TempVarTransformer);
  return {get ForInTransformPass() {
      return ForInTransformPass;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/YieldState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/YieldState.js";
  var $__0 = Object.freeze(Object.defineProperties(["return ", ""], {raw: {value: Object.freeze(["return ", ""])}}));
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var parseStatement = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseStatement;
  var YieldState = function YieldState(id, fallThroughState, expression) {
    $traceurRuntime.superConstructor($YieldState).call(this, id);
    this.fallThroughState = fallThroughState;
    this.expression = expression;
  };
  var $YieldState = YieldState;
  ($traceurRuntime.createClass)(YieldState, {
    replaceState: function(oldState, newState) {
      return new this.constructor(State.replaceStateId(this.id, oldState, newState), State.replaceStateId(this.fallThroughState, oldState, newState), this.expression);
    },
    transform: function(enclosingFinally, machineEndState, reporter) {
      return $traceurRuntime.spread(State.generateAssignState(enclosingFinally, this.fallThroughState), [parseStatement($__0, this.expression)]);
    }
  }, {}, State);
  return {get YieldState() {
      return YieldState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/ReturnState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/ReturnState.js";
  var $__0 = Object.freeze(Object.defineProperties(["$ctx.returnValue = ", ""], {raw: {value: Object.freeze(["$ctx.returnValue = ", ""])}}));
  var $__1 = System.get("traceur@0.0.80/src/semantics/util.js"),
      isUndefined = $__1.isUndefined,
      isVoidExpression = $__1.isVoidExpression;
  var YieldState = System.get("traceur@0.0.80/src/codegeneration/generator/YieldState.js").YieldState;
  var State = System.get("traceur@0.0.80/src/codegeneration/generator/State.js").State;
  var parseStatement = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseStatement;
  var ReturnState = function ReturnState() {
    $traceurRuntime.superConstructor($ReturnState).apply(this, arguments);
  };
  var $ReturnState = ReturnState;
  ($traceurRuntime.createClass)(ReturnState, {transform: function(enclosingFinally, machineEndState, reporter) {
      var $__6;
      var e = this.expression;
      var statements = [];
      if (e && !isUndefined(e) && !isVoidExpression(e))
        statements.push(parseStatement($__0, this.expression));
      ($__6 = statements).push.apply($__6, $traceurRuntime.spread(State.generateJump(enclosingFinally, machineEndState)));
      return statements;
    }}, {}, YieldState);
  return {get ReturnState() {
      return ReturnState;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/generator/GeneratorTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/generator/GeneratorTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["\n        ", " = ", "[Symbol.iterator]();\n        // received = void 0;\n        $ctx.sent = void 0;\n        // send = true; // roughly equivalent\n        $ctx.action = 'next';\n\n        for (;;) {\n          ", " = ", "[$ctx.action]($ctx.sentIgnoreThrow);\n          if (", ".done) {\n            $ctx.sent = ", ".value;\n            break;\n          }\n          yield ", ".value;\n        }"], {raw: {value: Object.freeze(["\n        ", " = ", "[Symbol.iterator]();\n        // received = void 0;\n        $ctx.sent = void 0;\n        // send = true; // roughly equivalent\n        $ctx.action = 'next';\n\n        for (;;) {\n          ", " = ", "[$ctx.action]($ctx.sentIgnoreThrow);\n          if (", ".done) {\n            $ctx.sent = ", ".value;\n            break;\n          }\n          yield ", ".value;\n        }"])}})),
      $__1 = Object.freeze(Object.defineProperties(["$ctx.sentIgnoreThrow"], {raw: {value: Object.freeze(["$ctx.sentIgnoreThrow"])}})),
      $__2 = Object.freeze(Object.defineProperties(["$ctx.sent"], {raw: {value: Object.freeze(["$ctx.sent"])}})),
      $__3 = Object.freeze(Object.defineProperties(["$ctx.maybeThrow()"], {raw: {value: Object.freeze(["$ctx.maybeThrow()"])}})),
      $__4 = Object.freeze(Object.defineProperties(["$traceurRuntime.createGeneratorInstance"], {raw: {value: Object.freeze(["$traceurRuntime.createGeneratorInstance"])}}));
  var CPSTransformer = System.get("traceur@0.0.80/src/codegeneration/generator/CPSTransformer.js").CPSTransformer;
  var $__6 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      BINARY_EXPRESSION = $__6.BINARY_EXPRESSION,
      YIELD_EXPRESSION = $__6.YIELD_EXPRESSION;
  var $__7 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      BinaryExpression = $__7.BinaryExpression,
      ExpressionStatement = $__7.ExpressionStatement;
  var FindInFunctionScope = System.get("traceur@0.0.80/src/codegeneration/FindInFunctionScope.js").FindInFunctionScope;
  var ReturnState = System.get("traceur@0.0.80/src/codegeneration/generator/ReturnState.js").ReturnState;
  var YieldState = System.get("traceur@0.0.80/src/codegeneration/generator/YieldState.js").YieldState;
  var $__11 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      id = $__11.createIdentifierExpression,
      createMemberExpression = $__11.createMemberExpression,
      createUndefinedExpression = $__11.createUndefinedExpression;
  var $__12 = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js"),
      parseExpression = $__12.parseExpression,
      parseStatement = $__12.parseStatement,
      parseStatements = $__12.parseStatements;
  function isYieldAssign(tree) {
    return tree.type === BINARY_EXPRESSION && tree.operator.isAssignmentOperator() && tree.right.type === YIELD_EXPRESSION && tree.left.isLeftHandSideExpression();
  }
  var YieldFinder = function YieldFinder() {
    $traceurRuntime.superConstructor($YieldFinder).apply(this, arguments);
  };
  var $YieldFinder = YieldFinder;
  ($traceurRuntime.createClass)(YieldFinder, {visitYieldExpression: function(tree) {
      this.found = true;
    }}, {}, FindInFunctionScope);
  function scopeContainsYield(tree) {
    var finder = new YieldFinder();
    finder.visitAny(tree);
    return finder.found;
  }
  var GeneratorTransformer = function GeneratorTransformer(identifierGenerator, reporter) {
    $traceurRuntime.superConstructor($GeneratorTransformer).call(this, identifierGenerator, reporter);
    this.shouldAppendThrowCloseState_ = true;
  };
  var $GeneratorTransformer = GeneratorTransformer;
  ($traceurRuntime.createClass)(GeneratorTransformer, {
    expressionNeedsStateMachine: function(tree) {
      if (tree === null)
        return false;
      return scopeContainsYield(tree);
    },
    transformYieldExpression_: function(tree) {
      var $__14;
      var expression,
          machine;
      if (this.expressionNeedsStateMachine(tree.expression)) {
        (($__14 = this.expressionToStateMachine(tree.expression), expression = $__14.expression, machine = $__14.machine, $__14));
      } else {
        expression = this.transformAny(tree.expression);
        if (!expression)
          expression = createUndefinedExpression();
      }
      if (tree.isYieldFor)
        return this.transformYieldForExpression_(expression, machine);
      var startState = this.allocateState();
      var fallThroughState = this.allocateState();
      var yieldMachine = this.stateToStateMachine_(new YieldState(startState, fallThroughState, expression), fallThroughState);
      if (machine)
        yieldMachine = machine.append(yieldMachine);
      if (this.shouldAppendThrowCloseState_)
        yieldMachine = yieldMachine.append(this.createThrowCloseState_());
      return yieldMachine;
    },
    transformYieldForExpression_: function(expression) {
      var machine = arguments[1];
      var gName = this.getTempIdentifier();
      this.addMachineVariable(gName);
      var g = id(gName);
      var nextName = this.getTempIdentifier();
      this.addMachineVariable(nextName);
      var next = id(nextName);
      var statements = parseStatements($__0, g, expression, next, g, next, next, next);
      var shouldAppendThrowCloseState = this.shouldAppendThrowCloseState_;
      this.shouldAppendThrowCloseState_ = false;
      statements = this.transformList(statements);
      var yieldMachine = this.transformStatementList_(statements);
      this.shouldAppendThrowCloseState_ = shouldAppendThrowCloseState;
      if (machine)
        yieldMachine = machine.append(yieldMachine);
      return yieldMachine;
    },
    transformYieldExpression: function(tree) {
      this.reporter.reportError(tree.location.start, 'Only \'a = yield b\' and \'var a = yield b\' currently supported.');
      return tree;
    },
    transformYieldAssign_: function(tree) {
      var shouldAppendThrowCloseState = this.shouldAppendThrowCloseState_;
      this.shouldAppendThrowCloseState_ = false;
      var machine = this.transformYieldExpression_(tree.right);
      var left = this.transformAny(tree.left);
      var sentExpression = tree.right.isYieldFor ? parseExpression($__1) : parseExpression($__2);
      var statement = new ExpressionStatement(tree.location, new BinaryExpression(tree.location, left, tree.operator, sentExpression));
      var assignMachine = this.statementToStateMachine_(statement);
      this.shouldAppendThrowCloseState_ = shouldAppendThrowCloseState;
      return machine.append(assignMachine);
    },
    createThrowCloseState_: function() {
      return this.statementToStateMachine_(parseStatement($__3));
    },
    transformExpressionStatement: function(tree) {
      var expression = tree.expression;
      if (expression.type === YIELD_EXPRESSION)
        return this.transformYieldExpression_(expression);
      if (isYieldAssign(expression))
        return this.transformYieldAssign_(expression);
      if (this.expressionNeedsStateMachine(expression)) {
        return this.expressionToStateMachine(expression).machine;
      }
      return $traceurRuntime.superGet(this, $GeneratorTransformer.prototype, "transformExpressionStatement").call(this, tree);
    },
    transformAwaitStatement: function(tree) {
      this.reporter.reportError(tree.location.start, 'Generator function may not have an await statement.');
      return tree;
    },
    transformReturnStatement: function(tree) {
      var $__14;
      var expression,
          machine;
      if (this.expressionNeedsStateMachine(tree.expression))
        (($__14 = this.expressionToStateMachine(tree.expression), expression = $__14.expression, machine = $__14.machine, $__14));
      else
        expression = tree.expression;
      var startState = this.allocateState();
      var fallThroughState = this.allocateState();
      var returnMachine = this.stateToStateMachine_(new ReturnState(startState, fallThroughState, this.transformAny(expression)), fallThroughState);
      if (machine)
        return machine.append(returnMachine);
      return returnMachine;
    },
    transformGeneratorBody: function(tree, name) {
      var runtimeFunction = parseExpression($__4);
      return this.transformCpsFunctionBody(tree, runtimeFunction, name);
    }
  }, {transformGeneratorBody: function(identifierGenerator, reporter, body, name) {
      return new $GeneratorTransformer(identifierGenerator, reporter).transformGeneratorBody(body, name);
    }}, CPSTransformer);
  ;
  return {get GeneratorTransformer() {
      return GeneratorTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/GeneratorTransformPass.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/GeneratorTransformPass.js";
  var $__0 = Object.freeze(Object.defineProperties(["$traceurRuntime.initGeneratorFunction(", ")"], {raw: {value: Object.freeze(["$traceurRuntime.initGeneratorFunction(", ")"])}})),
      $__1 = Object.freeze(Object.defineProperties(["var ", " = ", ""], {raw: {value: Object.freeze(["var ", " = ", ""])}})),
      $__2 = Object.freeze(Object.defineProperties(["$traceurRuntime.initGeneratorFunction(", ")"], {raw: {value: Object.freeze(["$traceurRuntime.initGeneratorFunction(", ")"])}}));
  var ArrowFunctionTransformer = System.get("traceur@0.0.80/src/codegeneration/ArrowFunctionTransformer.js").ArrowFunctionTransformer;
  var AsyncTransformer = System.get("traceur@0.0.80/src/codegeneration/generator/AsyncTransformer.js").AsyncTransformer;
  var ForInTransformPass = System.get("traceur@0.0.80/src/codegeneration/generator/ForInTransformPass.js").ForInTransformPass;
  var GeneratorTransformer = System.get("traceur@0.0.80/src/codegeneration/generator/GeneratorTransformer.js").GeneratorTransformer;
  var $__7 = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js"),
      parseExpression = $__7.parseExpression,
      parseStatement = $__7.parseStatement;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var FindInFunctionScope = System.get("traceur@0.0.80/src/codegeneration/FindInFunctionScope.js").FindInFunctionScope;
  var $__10 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AnonBlock = $__10.AnonBlock,
      FunctionDeclaration = $__10.FunctionDeclaration,
      FunctionExpression = $__10.FunctionExpression;
  var $__11 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createBindingIdentifier = $__11.createBindingIdentifier,
      id = $__11.createIdentifierExpression,
      createIdentifierToken = $__11.createIdentifierToken;
  var transformOptions = System.get("traceur@0.0.80/src/Options.js").transformOptions;
  var ForInFinder = function ForInFinder() {
    $traceurRuntime.superConstructor($ForInFinder).apply(this, arguments);
  };
  var $ForInFinder = ForInFinder;
  ($traceurRuntime.createClass)(ForInFinder, {visitForInStatement: function(tree) {
      this.found = true;
    }}, {}, FindInFunctionScope);
  function needsTransform(tree) {
    return transformOptions.generators && tree.isGenerator() || transformOptions.asyncFunctions && tree.isAsyncFunction();
  }
  var GeneratorTransformPass = function GeneratorTransformPass(identifierGenerator, reporter) {
    $traceurRuntime.superConstructor($GeneratorTransformPass).call(this, identifierGenerator);
    this.reporter_ = reporter;
    this.inBlock_ = false;
  };
  var $GeneratorTransformPass = GeneratorTransformPass;
  ($traceurRuntime.createClass)(GeneratorTransformPass, {
    transformFunctionDeclaration: function(tree) {
      if (!needsTransform(tree))
        return $traceurRuntime.superGet(this, $GeneratorTransformPass.prototype, "transformFunctionDeclaration").call(this, tree);
      if (tree.isGenerator())
        return this.transformGeneratorDeclaration_(tree);
      return this.transformFunction_(tree, FunctionDeclaration, null);
    },
    transformGeneratorDeclaration_: function(tree) {
      var nameIdExpression = id(tree.name.identifierToken);
      var setupPrototypeExpression = parseExpression($__0, nameIdExpression);
      var tmpVar = id(this.inBlock_ ? this.getTempIdentifier() : this.addTempVar(setupPrototypeExpression));
      var funcDecl = this.transformFunction_(tree, FunctionDeclaration, tmpVar);
      if (!this.inBlock_)
        return funcDecl;
      return new AnonBlock(null, [funcDecl, parseStatement($__1, tmpVar, setupPrototypeExpression)]);
    },
    transformFunctionExpression: function(tree) {
      if (!needsTransform(tree))
        return $traceurRuntime.superGet(this, $GeneratorTransformPass.prototype, "transformFunctionExpression").call(this, tree);
      if (tree.isGenerator())
        return this.transformGeneratorExpression_(tree);
      return this.transformFunction_(tree, FunctionExpression, null);
    },
    transformGeneratorExpression_: function(tree) {
      var name;
      if (!tree.name) {
        name = createIdentifierToken(this.getTempIdentifier());
        tree = new FunctionExpression(tree.location, createBindingIdentifier(name), tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
      } else {
        name = tree.name.identifierToken;
      }
      var functionExpression = this.transformFunction_(tree, FunctionExpression, id(name));
      return parseExpression($__2, functionExpression);
    },
    transformFunction_: function(tree, constructor, nameExpression) {
      var body = $traceurRuntime.superGet(this, $GeneratorTransformPass.prototype, "transformAny").call(this, tree.body);
      var finder = new ForInFinder();
      finder.visitAny(body);
      if (finder.found) {
        body = new ForInTransformPass(this.identifierGenerator).transformAny(body);
      }
      if (transformOptions.generators && tree.isGenerator()) {
        body = GeneratorTransformer.transformGeneratorBody(this.identifierGenerator, this.reporter_, body, nameExpression);
      } else if (transformOptions.asyncFunctions && tree.isAsyncFunction()) {
        body = AsyncTransformer.transformAsyncBody(this.identifierGenerator, this.reporter_, body);
      }
      var functionKind = null;
      return new constructor(tree.location, tree.name, functionKind, tree.parameterList, tree.typeAnnotation || null, tree.annotations || null, body);
    },
    transformArrowFunctionExpression: function(tree) {
      if (!tree.isAsyncFunction())
        return $traceurRuntime.superGet(this, $GeneratorTransformPass.prototype, "transformArrowFunctionExpression").call(this, tree);
      return this.transformAny(ArrowFunctionTransformer.transform(this, tree));
    },
    transformBlock: function(tree) {
      var inBlock = this.inBlock_;
      this.inBlock_ = true;
      var rv = $traceurRuntime.superGet(this, $GeneratorTransformPass.prototype, "transformBlock").call(this, tree);
      this.inBlock_ = inBlock;
      return rv;
    }
  }, {}, TempVarTransformer);
  return {get GeneratorTransformPass() {
      return GeneratorTransformPass;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/InlineModuleTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/InlineModuleTransformer.js";
  var VAR = System.get("traceur@0.0.80/src/syntax/TokenType.js").VAR;
  var ModuleTransformer = System.get("traceur@0.0.80/src/codegeneration/ModuleTransformer.js").ModuleTransformer;
  var $__2 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createBindingIdentifier = $__2.createBindingIdentifier,
      createEmptyStatement = $__2.createEmptyStatement,
      createFunctionBody = $__2.createFunctionBody,
      createImmediatelyInvokedFunctionExpression = $__2.createImmediatelyInvokedFunctionExpression,
      createScopedExpression = $__2.createScopedExpression,
      createVariableStatement = $__2.createVariableStatement;
  var globalThis = System.get("traceur@0.0.80/src/codegeneration/globalThis.js").default;
  var scopeContainsThis = System.get("traceur@0.0.80/src/codegeneration/scopeContainsThis.js").default;
  var anonInlineModules = 0;
  var InlineModuleTransformer = function InlineModuleTransformer() {
    $traceurRuntime.superConstructor($InlineModuleTransformer).apply(this, arguments);
  };
  var $InlineModuleTransformer = InlineModuleTransformer;
  ($traceurRuntime.createClass)(InlineModuleTransformer, {
    wrapModule: function(statements) {
      var seed = this.moduleName || 'anon_' + ++anonInlineModules;
      var idName = this.getTempVarNameForModuleName(seed);
      var body = createFunctionBody(statements);
      var moduleExpression;
      if (statements.some(scopeContainsThis)) {
        moduleExpression = createScopedExpression(body, globalThis());
      } else {
        moduleExpression = createImmediatelyInvokedFunctionExpression(body);
      }
      return [createVariableStatement(VAR, idName, moduleExpression)];
    },
    transformNamedExport: function(tree) {
      return createEmptyStatement();
    },
    transformModuleSpecifier: function(tree) {
      return createBindingIdentifier(this.getTempVarNameForModuleSpecifier(tree));
    }
  }, {}, ModuleTransformer);
  return {get InlineModuleTransformer() {
      return InlineModuleTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/InstantiateModuleTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/InstantiateModuleTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["", " = ", ""], {raw: {value: Object.freeze(["", " = ", ""])}})),
      $__1 = Object.freeze(Object.defineProperties(["$__export(", ", ", ")"], {raw: {value: Object.freeze(["$__export(", ", ", ")"])}})),
      $__2 = Object.freeze(Object.defineProperties(["($__export(", ", ", " + 1), ", ")"], {raw: {value: Object.freeze(["($__export(", ", ", " + 1), ", ")"])}})),
      $__3 = Object.freeze(Object.defineProperties(["($__export(", ", ", " - 1), ", ")"], {raw: {value: Object.freeze(["($__export(", ", ", " - 1), ", ")"])}})),
      $__4 = Object.freeze(Object.defineProperties(["$__export(", ", ", ")}"], {raw: {value: Object.freeze(["$__export(", ", ", ")}"])}})),
      $__5 = Object.freeze(Object.defineProperties(["System.register(", ", ", ", function($__export) {\n          ", "\n        });"], {raw: {value: Object.freeze(["System.register(", ", ", ", function($__export) {\n          ", "\n        });"])}})),
      $__6 = Object.freeze(Object.defineProperties(["System.register(", ", function($__export) {\n          ", "\n        });"], {raw: {value: Object.freeze(["System.register(", ", function($__export) {\n          ", "\n        });"])}})),
      $__7 = Object.freeze(Object.defineProperties(["", " = m.", ";"], {raw: {value: Object.freeze(["", " = m.", ";"])}})),
      $__8 = Object.freeze(Object.defineProperties(["$__export(", ", m.", ");"], {raw: {value: Object.freeze(["$__export(", ", m.", ");"])}})),
      $__9 = Object.freeze(Object.defineProperties(["", " = m;"], {raw: {value: Object.freeze(["", " = m;"])}})),
      $__10 = Object.freeze(Object.defineProperties(["\n          Object.keys(m).forEach(function(p) {\n            if (!$__exportNames[p])\n              $__export(p, m[p]);\n          });\n        "], {raw: {value: Object.freeze(["\n          Object.keys(m).forEach(function(p) {\n            if (!$__exportNames[p])\n              $__export(p, m[p]);\n          });\n        "])}})),
      $__11 = Object.freeze(Object.defineProperties(["\n          var $__exportNames = ", ";\n        "], {raw: {value: Object.freeze(["\n          var $__exportNames = ", ";\n        "])}})),
      $__12 = Object.freeze(Object.defineProperties(["function(m) {\n          ", "\n        }"], {raw: {value: Object.freeze(["function(m) {\n          ", "\n        }"])}})),
      $__13 = Object.freeze(Object.defineProperties(["function(m) {}"], {raw: {value: Object.freeze(["function(m) {}"])}})),
      $__14 = Object.freeze(Object.defineProperties(["\n        $__export(", ", ", ")\n      "], {raw: {value: Object.freeze(["\n        $__export(", ", ", ")\n      "])}})),
      $__15 = Object.freeze(Object.defineProperties(["return {\n      setters: ", ",\n      execute: ", "\n    }"], {raw: {value: Object.freeze(["return {\n      setters: ", ",\n      execute: ", "\n    }"])}})),
      $__16 = Object.freeze(Object.defineProperties(["$__export(", ", ", ")"], {raw: {value: Object.freeze(["$__export(", ", ", ")"])}})),
      $__17 = Object.freeze(Object.defineProperties(["$__export(", ", ", ")"], {raw: {value: Object.freeze(["$__export(", ", ", ")"])}})),
      $__18 = Object.freeze(Object.defineProperties(["var ", " = $__export(", ", ", ");"], {raw: {value: Object.freeze(["var ", " = $__export(", ", ", ");"])}})),
      $__19 = Object.freeze(Object.defineProperties(["var ", ";"], {raw: {value: Object.freeze(["var ", ";"])}})),
      $__20 = Object.freeze(Object.defineProperties(["$__export('default', ", ");"], {raw: {value: Object.freeze(["$__export('default', ", ");"])}})),
      $__21 = Object.freeze(Object.defineProperties(["$__export(", ", ", ");"], {raw: {value: Object.freeze(["$__export(", ", ", ");"])}})),
      $__22 = Object.freeze(Object.defineProperties(["var ", ";"], {raw: {value: Object.freeze(["var ", ";"])}}));
  var $__23 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AnonBlock = $__23.AnonBlock,
      ArrayLiteralExpression = $__23.ArrayLiteralExpression,
      ClassExpression = $__23.ClassExpression,
      CommaExpression = $__23.CommaExpression,
      ExpressionStatement = $__23.ExpressionStatement;
  var $__24 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      CLASS_DECLARATION = $__24.CLASS_DECLARATION,
      FUNCTION_DECLARATION = $__24.FUNCTION_DECLARATION,
      IDENTIFIER_EXPRESSION = $__24.IDENTIFIER_EXPRESSION,
      IMPORT_SPECIFIER_SET = $__24.IMPORT_SPECIFIER_SET;
  var ScopeTransformer = System.get("traceur@0.0.80/src/codegeneration/ScopeTransformer.js").ScopeTransformer;
  var $__26 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      id = $__26.createIdentifierExpression,
      createIdentifierToken = $__26.createIdentifierToken,
      createVariableStatement = $__26.createVariableStatement,
      createVariableDeclaration = $__26.createVariableDeclaration,
      createVariableDeclarationList = $__26.createVariableDeclarationList;
  var ModuleTransformer = System.get("traceur@0.0.80/src/codegeneration/ModuleTransformer.js").ModuleTransformer;
  var $__28 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      MINUS_MINUS = $__28.MINUS_MINUS,
      PLUS_PLUS = $__28.PLUS_PLUS,
      VAR = $__28.VAR;
  var $__29 = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js"),
      parseExpression = $__29.parseExpression,
      parseStatement = $__29.parseStatement,
      parseStatements = $__29.parseStatements;
  var HoistVariablesTransformer = System.get("traceur@0.0.80/src/codegeneration/HoistVariablesTransformer.js").default;
  var $__31 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createFunctionExpression = $__31.createFunctionExpression,
      createEmptyParameterList = $__31.createEmptyParameterList,
      createFunctionBody = $__31.createFunctionBody,
      createObjectLiteral = $__31.createObjectLiteral;
  var DeclarationExtractionTransformer = function DeclarationExtractionTransformer() {
    $traceurRuntime.superConstructor($DeclarationExtractionTransformer).call(this);
    this.declarations_ = [];
  };
  var $DeclarationExtractionTransformer = DeclarationExtractionTransformer;
  ($traceurRuntime.createClass)(DeclarationExtractionTransformer, {
    getDeclarationStatements: function() {
      return $traceurRuntime.spread([this.getVariableStatement()], this.declarations_);
    },
    addDeclaration: function(tree) {
      this.declarations_.push(tree);
    },
    transformFunctionDeclaration: function(tree) {
      this.addDeclaration(tree);
      return new AnonBlock(null, []);
    },
    transformClassDeclaration: function(tree) {
      this.addVariable(tree.name.identifierToken.value);
      tree = new ClassExpression(tree.location, tree.name, tree.superClass, tree.elements, tree.annotations, tree.typeParameters);
      return parseStatement($__0, tree.name.identifierToken, tree);
    }
  }, {}, HoistVariablesTransformer);
  var InsertBindingAssignmentTransformer = function InsertBindingAssignmentTransformer(exportName, bindingName) {
    $traceurRuntime.superConstructor($InsertBindingAssignmentTransformer).call(this, bindingName);
    this.bindingName_ = bindingName;
    this.exportName_ = exportName;
  };
  var $InsertBindingAssignmentTransformer = InsertBindingAssignmentTransformer;
  ($traceurRuntime.createClass)(InsertBindingAssignmentTransformer, {
    matchesBindingName_: function(binding) {
      return binding.type === IDENTIFIER_EXPRESSION && binding.identifierToken.value == this.bindingName_;
    },
    transformUnaryExpression: function(tree) {
      if (!this.matchesBindingName_(tree.operand))
        return $traceurRuntime.superGet(this, $InsertBindingAssignmentTransformer.prototype, "transformUnaryExpression").call(this, tree);
      var operatorType = tree.operator.type;
      if (operatorType !== PLUS_PLUS && operatorType !== MINUS_MINUS)
        return $traceurRuntime.superGet(this, $InsertBindingAssignmentTransformer.prototype, "transformUnaryExpression").call(this, tree);
      var operand = this.transformAny(tree.operand);
      if (operand !== tree.operand)
        tree = new UnaryExpression(tree.location, tree.operator, operand);
      return parseExpression($__1, this.exportName_, tree);
    },
    transformPostfixExpression: function(tree) {
      tree = $traceurRuntime.superGet(this, $InsertBindingAssignmentTransformer.prototype, "transformPostfixExpression").call(this, tree);
      if (!this.matchesBindingName_(tree.operand))
        return tree;
      switch (tree.operator.type) {
        case PLUS_PLUS:
          return parseExpression($__2, this.exportName_, tree.operand, tree);
        case MINUS_MINUS:
          return parseExpression($__3, this.exportName_, tree.operand, tree);
      }
      return tree;
    },
    transformBinaryExpression: function(tree) {
      tree = $traceurRuntime.superGet(this, $InsertBindingAssignmentTransformer.prototype, "transformBinaryExpression").call(this, tree);
      if (!tree.operator.isAssignmentOperator())
        return tree;
      if (!this.matchesBindingName_(tree.left))
        return tree;
      return parseExpression($__4, this.exportName_, tree);
    }
  }, {}, ScopeTransformer);
  var InstantiateModuleTransformer = function InstantiateModuleTransformer(identifierGenerator) {
    $traceurRuntime.superConstructor($InstantiateModuleTransformer).call(this, identifierGenerator);
    this.inExport_ = false;
    this.curDepIndex_ = null;
    this.dependencies = [];
    this.externalExportBindings = [];
    this.importBindings = [];
    this.localExportBindings = [];
    this.functionDeclarations = [];
    this.moduleBindings = [];
    this.exportStarBindings = [];
  };
  var $InstantiateModuleTransformer = InstantiateModuleTransformer;
  ($traceurRuntime.createClass)(InstantiateModuleTransformer, {
    wrapModule: function(statements) {
      if (this.moduleName) {
        return parseStatements($__5, this.moduleName, this.dependencies, statements);
      } else {
        return parseStatements($__6, this.dependencies, statements);
      }
    },
    appendExportStatement: function(statements) {
      var $__32 = this;
      var declarationExtractionTransformer = new DeclarationExtractionTransformer();
      this.localExportBindings.forEach((function(binding) {
        statements = new InsertBindingAssignmentTransformer(binding.exportName, binding.localName).transformList(statements);
      }));
      var executionStatements = statements.map((function(statement) {
        return declarationExtractionTransformer.transformAny(statement);
      }));
      var executionFunction = createFunctionExpression(createEmptyParameterList(), createFunctionBody(executionStatements));
      var declarationStatements = declarationExtractionTransformer.getDeclarationStatements();
      var setterFunctions = this.dependencies.map((function(dep, index) {
        var importBindings = $__32.importBindings[index];
        var externalExportBindings = $__32.externalExportBindings[index];
        var exportStarBinding = $__32.exportStarBindings[index];
        var moduleBinding = $__32.moduleBindings[index];
        var setterStatements = [];
        if (importBindings) {
          importBindings.forEach((function(binding) {
            setterStatements.push(parseStatement($__7, createIdentifierToken(binding.variableName), binding.exportName));
          }));
        }
        if (externalExportBindings) {
          externalExportBindings.forEach((function(binding) {
            setterStatements.push(parseStatement($__8, binding.exportName, binding.importName));
          }));
        }
        if (moduleBinding) {
          setterStatements.push(parseStatement($__9, id(moduleBinding)));
        }
        if (exportStarBinding) {
          setterStatements = setterStatements.concat(parseStatements($__10));
          var exportNames = {};
          $__32.localExportBindings.concat($__32.externalExportBindings).forEach(function(binding) {
            exportNames[binding.exportName] = true;
          });
          declarationStatements.push(parseStatement($__11, createObjectLiteral(exportNames)));
        }
        if (setterStatements.length) {
          return parseExpression($__12, setterStatements);
        } else {
          return parseExpression($__13);
        }
      }));
      declarationStatements = declarationStatements.concat(this.functionDeclarations.map((function(binding) {
        return parseStatement($__14, binding.exportName, createIdentifierToken(binding.functionName));
      })));
      declarationStatements.push(parseStatement($__15, new ArrayLiteralExpression(null, setterFunctions), executionFunction));
      return declarationStatements;
    },
    addLocalExportBinding: function(exportName) {
      var localName = arguments[1] !== (void 0) ? arguments[1] : exportName;
      this.localExportBindings.push({
        exportName: exportName,
        localName: localName
      });
    },
    addImportBinding: function(depIndex, variableName, exportName) {
      this.importBindings[depIndex] = this.importBindings[depIndex] || [];
      this.importBindings[depIndex].push({
        variableName: variableName,
        exportName: exportName
      });
    },
    addExternalExportBinding: function(depIndex, exportName, importName) {
      this.externalExportBindings[depIndex] = this.externalExportBindings[depIndex] || [];
      this.externalExportBindings[depIndex].push({
        exportName: exportName,
        importName: importName
      });
    },
    addExportStarBinding: function(depIndex) {
      this.exportStarBindings[depIndex] = true;
    },
    addModuleBinding: function(depIndex, variableName) {
      this.moduleBindings[depIndex] = variableName;
    },
    addExportFunction: function(exportName) {
      var functionName = arguments[1] !== (void 0) ? arguments[1] : exportName;
      this.functionDeclarations.push({
        exportName: exportName,
        functionName: functionName
      });
    },
    getOrCreateDependencyIndex: function(moduleSpecifier) {
      var name = moduleSpecifier.token.processedValue;
      var depIndex = this.dependencies.indexOf(name);
      if (depIndex == -1) {
        depIndex = this.dependencies.length;
        this.dependencies.push(name);
      }
      return depIndex;
    },
    transformExportDeclaration: function(tree) {
      this.inExport_ = true;
      if (tree.declaration.moduleSpecifier) {
        this.curDepIndex_ = this.getOrCreateDependencyIndex(tree.declaration.moduleSpecifier);
      } else {
        this.curDepIndex_ = null;
      }
      var transformed = this.transformAny(tree.declaration);
      this.inExport_ = false;
      return transformed;
    },
    transformVariableStatement: function(tree) {
      var $__32 = this;
      if (!this.inExport_)
        return $traceurRuntime.superGet(this, $InstantiateModuleTransformer.prototype, "transformVariableStatement").call(this, tree);
      this.inExport_ = false;
      return createVariableStatement(createVariableDeclarationList(VAR, tree.declarations.declarations.map((function(declaration) {
        var varName = declaration.lvalue.identifierToken.value;
        var initializer;
        $__32.addLocalExportBinding(varName);
        if (declaration.initializer)
          initializer = parseExpression($__16, varName, $__32.transformAny(declaration.initializer));
        else
          initializer = parseExpression($__17, varName, id(varName));
        return createVariableDeclaration(varName, initializer);
      }))));
    },
    transformExportStar: function(tree) {
      this.inExport_ = false;
      this.addExportStarBinding(this.curDepIndex_);
      return new AnonBlock(null, []);
    },
    transformClassDeclaration: function(tree) {
      if (!this.inExport_)
        return $traceurRuntime.superGet(this, $InstantiateModuleTransformer.prototype, "transformClassDeclaration").call(this, tree);
      this.inExport_ = false;
      var name = this.transformAny(tree.name);
      var superClass = this.transformAny(tree.superClass);
      var elements = this.transformList(tree.elements);
      var annotations = this.transformList(tree.annotations);
      var typeParameters = this.transformAny(tree.typeParameters);
      var varName = name.identifierToken.value;
      var classExpression = new ClassExpression(tree.location, name, superClass, elements, annotations, typeParameters);
      this.addLocalExportBinding(varName);
      return parseStatement($__18, varName, varName, classExpression);
    },
    transformFunctionDeclaration: function(tree) {
      if (this.inExport_) {
        var name = tree.name.getStringValue();
        this.addLocalExportBinding(name);
        this.addExportFunction(name);
        this.inExport_ = false;
      }
      return $traceurRuntime.superGet(this, $InstantiateModuleTransformer.prototype, "transformFunctionDeclaration").call(this, tree);
    },
    transformNamedExport: function(tree) {
      this.transformAny(tree.moduleSpecifier);
      var specifierSet = this.transformAny(tree.specifierSet);
      if (this.curDepIndex_ === null) {
        return specifierSet;
      } else {
        return new AnonBlock(null, []);
      }
    },
    transformImportDeclaration: function(tree) {
      this.curDepIndex_ = this.getOrCreateDependencyIndex(tree.moduleSpecifier);
      var initializer = this.transformAny(tree.moduleSpecifier);
      if (!tree.importClause)
        return new AnonBlock(null, []);
      var importClause = this.transformAny(tree.importClause);
      if (tree.importClause.type === IMPORT_SPECIFIER_SET) {
        return importClause;
      } else {
        var bindingName = tree.importClause.binding.getStringValue();
        this.addImportBinding(this.curDepIndex_, bindingName, 'default');
        return parseStatement($__19, bindingName);
      }
      return new AnonBlock(null, []);
    },
    transformImportSpecifierSet: function(tree) {
      return createVariableStatement(createVariableDeclarationList(VAR, this.transformList(tree.specifiers)));
    },
    transformExportDefault: function(tree) {
      this.inExport_ = false;
      var expression = this.transformAny(tree.expression);
      this.addLocalExportBinding('default');
      if (expression.type === CLASS_DECLARATION) {
        expression = new ClassExpression(expression.location, expression.name, expression.superClass, expression.elements, expression.annotations, expression.typeParameters);
      }
      if (expression.type === FUNCTION_DECLARATION) {
        this.addExportFunction('default', expression.name.identifierToken.value);
        return expression;
      } else {
        return parseStatement($__20, expression);
      }
    },
    transformExportSpecifier: function(tree) {
      var exportName;
      var bindingName;
      if (tree.rhs) {
        exportName = tree.rhs.value;
        bindingName = tree.lhs.value;
      } else {
        exportName = tree.lhs.value;
        bindingName = exportName;
      }
      if (this.curDepIndex_ !== null) {
        this.addExternalExportBinding(this.curDepIndex_, exportName, bindingName);
      } else {
        this.addLocalExportBinding(exportName, bindingName);
        return parseExpression($__21, exportName, id(bindingName));
      }
    },
    transformExportSpecifierSet: function(tree) {
      var specifiers = this.transformList(tree.specifiers);
      return new ExpressionStatement(tree.location, new CommaExpression(tree.location, specifiers.filter((function(specifier) {
        return specifier;
      }))));
    },
    transformImportSpecifier: function(tree) {
      var localBinding = tree.binding.binding;
      var localBindingToken = localBinding.identifierToken;
      var importName = (tree.name || localBindingToken).value;
      this.addImportBinding(this.curDepIndex_, localBindingToken.value, importName);
      return createVariableDeclaration(localBinding);
    },
    transformModuleDeclaration: function(tree) {
      this.transformAny(tree.expression);
      var bindingIdentifier = tree.binding.binding;
      var name = bindingIdentifier.getStringValue();
      this.addModuleBinding(this.curDepIndex_, name);
      return parseStatement($__22, bindingIdentifier);
    },
    transformModuleSpecifier: function(tree) {
      this.curDepIndex_ = this.getOrCreateDependencyIndex(tree);
      return tree;
    }
  }, {}, ModuleTransformer);
  return {get InstantiateModuleTransformer() {
      return InstantiateModuleTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/MemberVariableTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/MemberVariableTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["get ", "():", "\n      { return this.", "; }"], {raw: {value: Object.freeze(["get ", "():", "\n      { return this.", "; }"])}})),
      $__1 = Object.freeze(Object.defineProperties(["set ", "(value:", ")\n      { this.", " = value; }"], {raw: {value: Object.freeze(["set ", "(value:", ")\n      { this.", " = value; }"])}}));
  var $__2 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      AnonBlock = $__2.AnonBlock,
      ClassDeclaration = $__2.ClassDeclaration,
      ClassExpression = $__2.ClassExpression;
  var PROPERTY_VARIABLE_DECLARATION = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js").PROPERTY_VARIABLE_DECLARATION;
  var parsePropertyDefinition = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parsePropertyDefinition;
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var MemberVariableTransformer = function MemberVariableTransformer(identifierGenerator) {
    $traceurRuntime.superConstructor($MemberVariableTransformer).call(this);
    this.identifierGenerator_ = identifierGenerator;
  };
  var $MemberVariableTransformer = MemberVariableTransformer;
  ($traceurRuntime.createClass)(MemberVariableTransformer, {
    transformPropertyVariableDeclaration: function(tree) {
      var identifier = this.identifierGenerator_.generateUniqueIdentifier();
      var getter = this.createGetAccessor_(identifier, tree);
      var setter = this.createSetAccessor_(identifier, tree);
      return new AnonBlock(tree.location, [getter, setter]);
    },
    createGetAccessor_: function(identifier, tree) {
      var name = tree.name.literalToken;
      var type = tree.typeAnnotation;
      var def = parsePropertyDefinition($__0, name, type, identifier);
      def.isStatic = tree.isStatic;
      return def;
    },
    createSetAccessor_: function(identifier, tree) {
      var name = tree.name.literalToken;
      var type = tree.typeAnnotation;
      var def = parsePropertyDefinition($__1, name, type, identifier);
      def.isStatic = tree.isStatic;
      return def;
    }
  }, {}, ParseTreeTransformer);
  return {get MemberVariableTransformer() {
      return MemberVariableTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/outputgeneration/ParseTreeWriter.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/outputgeneration/ParseTreeWriter.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      BLOCK = $__0.BLOCK,
      CLASS_DECLARATION = $__0.CLASS_DECLARATION,
      FUNCTION_DECLARATION = $__0.FUNCTION_DECLARATION,
      IF_STATEMENT = $__0.IF_STATEMENT,
      LITERAL_EXPRESSION = $__0.LITERAL_EXPRESSION,
      POSTFIX_EXPRESSION = $__0.POSTFIX_EXPRESSION,
      UNARY_EXPRESSION = $__0.UNARY_EXPRESSION;
  var ParseTreeVisitor = System.get("traceur@0.0.80/src/syntax/ParseTreeVisitor.js").ParseTreeVisitor;
  var $__2 = System.get("traceur@0.0.80/src/syntax/PredefinedName.js"),
      AS = $__2.AS,
      ASYNC = $__2.ASYNC,
      AWAIT = $__2.AWAIT,
      FROM = $__2.FROM,
      GET = $__2.GET,
      OF = $__2.OF,
      SET = $__2.SET;
  var $__3 = System.get("traceur@0.0.80/src/syntax/Scanner.js"),
      isIdentifierPart = $__3.isIdentifierPart,
      isWhitespace = $__3.isWhitespace;
  var $__4 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      ARROW = $__4.ARROW,
      AT = $__4.AT,
      BACK_QUOTE = $__4.BACK_QUOTE,
      BAR = $__4.BAR,
      BREAK = $__4.BREAK,
      CASE = $__4.CASE,
      CATCH = $__4.CATCH,
      CLASS = $__4.CLASS,
      CLOSE_ANGLE = $__4.CLOSE_ANGLE,
      CLOSE_CURLY = $__4.CLOSE_CURLY,
      CLOSE_PAREN = $__4.CLOSE_PAREN,
      CLOSE_SQUARE = $__4.CLOSE_SQUARE,
      COLON = $__4.COLON,
      COMMA = $__4.COMMA,
      CONTINUE = $__4.CONTINUE,
      DEBUGGER = $__4.DEBUGGER,
      DEFAULT = $__4.DEFAULT,
      DO = $__4.DO,
      DOT_DOT_DOT = $__4.DOT_DOT_DOT,
      ELSE = $__4.ELSE,
      EQUAL = $__4.EQUAL,
      EXPORT = $__4.EXPORT,
      EXTENDS = $__4.EXTENDS,
      FINALLY = $__4.FINALLY,
      FOR = $__4.FOR,
      FUNCTION = $__4.FUNCTION,
      IF = $__4.IF,
      IMPORT = $__4.IMPORT,
      IN = $__4.IN,
      INTERFACE = $__4.INTERFACE,
      MINUS = $__4.MINUS,
      MINUS_MINUS = $__4.MINUS_MINUS,
      NEW = $__4.NEW,
      NUMBER = $__4.NUMBER,
      OPEN_ANGLE = $__4.OPEN_ANGLE,
      OPEN_CURLY = $__4.OPEN_CURLY,
      OPEN_PAREN = $__4.OPEN_PAREN,
      OPEN_SQUARE = $__4.OPEN_SQUARE,
      PERIOD = $__4.PERIOD,
      PLUS = $__4.PLUS,
      PLUS_PLUS = $__4.PLUS_PLUS,
      QUESTION = $__4.QUESTION,
      RETURN = $__4.RETURN,
      SEMI_COLON = $__4.SEMI_COLON,
      STAR = $__4.STAR,
      STATIC = $__4.STATIC,
      SUPER = $__4.SUPER,
      SWITCH = $__4.SWITCH,
      THIS = $__4.THIS,
      THROW = $__4.THROW,
      TRY = $__4.TRY,
      WHILE = $__4.WHILE,
      WITH = $__4.WITH,
      YIELD = $__4.YIELD;
  var NEW_LINE = '\n';
  var LINE_LENGTH = 80;
  var ParseTreeWriter = function ParseTreeWriter() {
    var $__7,
        $__8,
        $__9;
    var $__6 = arguments[0] !== (void 0) ? arguments[0] : {},
        highlighted = ($__7 = $__6.highlighted) === void 0 ? false : $__7,
        showLineNumbers = ($__8 = $__6.showLineNumbers) === void 0 ? false : $__8,
        prettyPrint = ($__9 = $__6.prettyPrint) === void 0 ? true : $__9;
    $traceurRuntime.superConstructor($ParseTreeWriter).call(this);
    this.highlighted_ = highlighted;
    this.showLineNumbers_ = showLineNumbers;
    this.prettyPrint_ = prettyPrint;
    this.result_ = '';
    this.currentLine_ = '';
    this.currentLineComment_ = null;
    this.indentDepth_ = 0;
    this.currentParameterTypeAnnotation_ = null;
  };
  var $ParseTreeWriter = ParseTreeWriter;
  ($traceurRuntime.createClass)(ParseTreeWriter, {
    toString: function() {
      if (this.currentLine_.length > 0) {
        this.result_ += this.currentLine_;
        this.currentLine_ = '';
      }
      return this.result_;
    },
    visitAny: function(tree) {
      if (!tree) {
        return;
      }
      if (tree === this.highlighted_) {
        this.write_('\x1B[41m');
      }
      if (tree.location !== null && tree.location.start !== null && this.showLineNumbers_) {
        var line = tree.location.start.line + 1;
        var column = tree.location.start.column;
        this.currentLineComment_ = ("Line: " + line + "." + column);
      }
      $traceurRuntime.superGet(this, $ParseTreeWriter.prototype, "visitAny").call(this, tree);
      if (tree === this.highlighted_) {
        this.write_('\x1B[0m');
      }
    },
    visitAnnotation: function(tree) {
      this.write_(AT);
      this.visitAny(tree.name);
      if (tree.args !== null) {
        this.write_(OPEN_PAREN);
        this.writeList_(tree.args, COMMA, false);
        this.write_(CLOSE_PAREN);
      }
    },
    visitArgumentList: function(tree) {
      this.write_(OPEN_PAREN);
      this.writeList_(tree.args, COMMA, false);
      this.write_(CLOSE_PAREN);
    },
    visitArrayComprehension: function(tree) {
      this.write_(OPEN_SQUARE);
      this.visitList(tree.comprehensionList);
      this.visitAny(tree.expression);
      this.write_(CLOSE_SQUARE);
    },
    visitArrayLiteralExpression: function(tree) {
      this.write_(OPEN_SQUARE);
      this.writeList_(tree.elements, COMMA, false);
      this.write_(CLOSE_SQUARE);
    },
    visitArrayPattern: function(tree) {
      this.write_(OPEN_SQUARE);
      this.writeList_(tree.elements, COMMA, false);
      this.write_(CLOSE_SQUARE);
    },
    visitArrayType: function(tree) {
      this.visitAny(tree.elementType);
      this.write_(OPEN_SQUARE);
      this.write_(CLOSE_SQUARE);
    },
    visitArrowFunctionExpression: function(tree) {
      if (tree.functionKind) {
        this.write_(tree.functionKind);
        this.writeSpace_();
      }
      this.write_(OPEN_PAREN);
      this.visitAny(tree.parameterList);
      this.write_(CLOSE_PAREN);
      this.writeSpace_();
      this.write_(ARROW);
      this.writeSpace_();
      this.visitAny(tree.body);
    },
    visitAssignmentElement: function(tree) {
      this.visitAny(tree.assignment);
      if (tree.initializer) {
        this.writeSpace_();
        this.write_(EQUAL);
        this.writeSpace_();
        this.visitAny(tree.initializer);
      }
    },
    visitAwaitExpression: function(tree) {
      this.write_(AWAIT);
      this.writeSpace_();
      this.visitAny(tree.expression);
    },
    visitBinaryExpression: function(tree) {
      var left = tree.left;
      this.visitAny(left);
      var operator = tree.operator;
      if (left.type === POSTFIX_EXPRESSION && requiresSpaceBetween(left.operator.type, operator.type)) {
        this.writeRequiredSpace_();
      } else {
        this.writeSpace_();
      }
      this.write_(operator);
      var right = tree.right;
      if (right.type === UNARY_EXPRESSION && requiresSpaceBetween(operator.type, right.operator.type)) {
        this.writeRequiredSpace_();
      } else {
        this.writeSpace_();
      }
      this.visitAny(right);
    },
    visitBindingElement: function(tree) {
      var typeAnnotation = this.currentParameterTypeAnnotation_;
      this.currentParameterTypeAnnotation_ = null;
      this.visitAny(tree.binding);
      this.writeTypeAnnotation_(typeAnnotation);
      if (tree.initializer) {
        this.writeSpace_();
        this.write_(EQUAL);
        this.writeSpace_();
        this.visitAny(tree.initializer);
      }
    },
    visitBindingIdentifier: function(tree) {
      this.write_(tree.identifierToken);
    },
    visitBlock: function(tree) {
      this.write_(OPEN_CURLY);
      this.writelnList_(tree.statements);
      this.write_(CLOSE_CURLY);
    },
    visitBreakStatement: function(tree) {
      this.write_(BREAK);
      if (tree.name !== null) {
        this.writeSpace_();
        this.write_(tree.name);
      }
      this.write_(SEMI_COLON);
    },
    visitCallExpression: function(tree) {
      this.visitAny(tree.operand);
      this.visitAny(tree.args);
    },
    visitCallSignature: function(tree) {
      if (tree.typeParameters) {
        this.visitAny(tree.typeParameters);
      }
      this.write_(OPEN_PAREN);
      this.visitAny(tree.parameterList);
      this.write_(CLOSE_PAREN);
      this.writeTypeAnnotation_(tree.returnType);
    },
    visitCaseClause: function(tree) {
      this.write_(CASE);
      this.writeSpace_();
      this.visitAny(tree.expression);
      this.write_(COLON);
      this.indentDepth_++;
      this.writelnList_(tree.statements);
      this.indentDepth_--;
    },
    visitCatch: function(tree) {
      this.write_(CATCH);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.binding);
      this.write_(CLOSE_PAREN);
      this.writeSpace_();
      this.visitAny(tree.catchBody);
    },
    visitClassShared_: function(tree) {
      this.writeAnnotations_(tree.annotations);
      this.write_(CLASS);
      this.writeSpace_();
      this.visitAny(tree.name);
      if (tree.typeParameters !== null) {
        this.visitAny(tree.typeParameters);
      }
      if (tree.superClass !== null) {
        this.writeSpace_();
        this.write_(EXTENDS);
        this.writeSpace_();
        this.visitAny(tree.superClass);
      }
      this.writeSpace_();
      this.write_(OPEN_CURLY);
      this.writelnList_(tree.elements);
      this.write_(CLOSE_CURLY);
    },
    visitClassDeclaration: function(tree) {
      this.visitClassShared_(tree);
    },
    visitClassExpression: function(tree) {
      this.visitClassShared_(tree);
    },
    visitCommaExpression: function(tree) {
      this.writeList_(tree.expressions, COMMA, false);
    },
    visitComprehensionFor: function(tree) {
      this.write_(FOR);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.left);
      this.writeSpace_();
      this.write_(OF);
      this.writeSpace_();
      this.visitAny(tree.iterator);
      this.write_(CLOSE_PAREN);
      this.writeSpace_();
    },
    visitComprehensionIf: function(tree) {
      this.write_(IF);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.expression);
      this.write_(CLOSE_PAREN);
      this.writeSpace_();
    },
    visitComputedPropertyName: function(tree) {
      this.write_(OPEN_SQUARE);
      this.visitAny(tree.expression);
      this.write_(CLOSE_SQUARE);
    },
    visitConstructSignature: function(tree) {
      this.write_(NEW);
      this.writeSpace_();
      this.visitCallSignature(tree);
    },
    visitConstructorType: function(tree) {
      this.write_(NEW);
      this.writeSpace_();
      this.visitFunctionType(tree);
    },
    visitConditionalExpression: function(tree) {
      this.visitAny(tree.condition);
      this.writeSpace_();
      this.write_(QUESTION);
      this.writeSpace_();
      this.visitAny(tree.left);
      this.writeSpace_();
      this.write_(COLON);
      this.writeSpace_();
      this.visitAny(tree.right);
    },
    visitContinueStatement: function(tree) {
      this.write_(CONTINUE);
      if (tree.name !== null) {
        this.writeSpace_();
        this.write_(tree.name);
      }
      this.write_(SEMI_COLON);
    },
    visitCoverInitializedName: function(tree) {
      this.write_(tree.name);
      this.writeSpace_();
      this.write_(tree.equalToken);
      this.writeSpace_();
      this.visitAny(tree.initializer);
    },
    visitDebuggerStatement: function(tree) {
      this.write_(DEBUGGER);
      this.write_(SEMI_COLON);
    },
    visitDefaultClause: function(tree) {
      this.write_(DEFAULT);
      this.write_(COLON);
      this.indentDepth_++;
      this.writelnList_(tree.statements);
      this.indentDepth_--;
    },
    visitDoWhileStatement: function(tree) {
      this.write_(DO);
      this.visitAnyBlockOrIndent_(tree.body);
      this.writeSpace_();
      this.write_(WHILE);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.condition);
      this.write_(CLOSE_PAREN);
      this.write_(SEMI_COLON);
    },
    visitEmptyStatement: function(tree) {
      this.write_(SEMI_COLON);
    },
    visitExportDeclaration: function(tree) {
      this.writeAnnotations_(tree.annotations);
      this.write_(EXPORT);
      this.writeSpace_();
      this.visitAny(tree.declaration);
    },
    visitExportDefault: function(tree) {
      this.write_(DEFAULT);
      this.writeSpace_();
      this.visitAny(tree.expression);
      switch (tree.expression.type) {
        case CLASS_DECLARATION:
        case FUNCTION_DECLARATION:
          break;
        default:
          this.write_(SEMI_COLON);
      }
    },
    visitNamedExport: function(tree) {
      this.visitAny(tree.specifierSet);
      if (tree.moduleSpecifier) {
        this.writeSpace_();
        this.write_(FROM);
        this.writeSpace_();
        this.visitAny(tree.moduleSpecifier);
      }
      this.write_(SEMI_COLON);
    },
    visitExportSpecifier: function(tree) {
      this.write_(tree.lhs);
      if (tree.rhs) {
        this.writeSpace_();
        this.write_(AS);
        this.writeSpace_();
        this.write_(tree.rhs);
      }
    },
    visitExportSpecifierSet: function(tree) {
      this.write_(OPEN_CURLY);
      this.writeList_(tree.specifiers, COMMA, false);
      this.write_(CLOSE_CURLY);
    },
    visitExportStar: function(tree) {
      this.write_(STAR);
    },
    visitExpressionStatement: function(tree) {
      this.visitAny(tree.expression);
      this.write_(SEMI_COLON);
    },
    visitFinally: function(tree) {
      this.write_(FINALLY);
      this.writeSpace_();
      this.visitAny(tree.block);
    },
    visitForOfStatement: function(tree) {
      this.write_(FOR);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.initializer);
      this.writeSpace_();
      this.write_(OF);
      this.writeSpace_();
      this.visitAny(tree.collection);
      this.write_(CLOSE_PAREN);
      this.visitAnyBlockOrIndent_(tree.body);
    },
    visitForInStatement: function(tree) {
      this.write_(FOR);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.initializer);
      this.writeSpace_();
      this.write_(IN);
      this.writeSpace_();
      this.visitAny(tree.collection);
      this.write_(CLOSE_PAREN);
      this.visitAnyBlockOrIndent_(tree.body);
    },
    visitForStatement: function(tree) {
      this.write_(FOR);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.initializer);
      this.write_(SEMI_COLON);
      this.writeSpace_();
      this.visitAny(tree.condition);
      this.write_(SEMI_COLON);
      this.writeSpace_();
      this.visitAny(tree.increment);
      this.write_(CLOSE_PAREN);
      this.visitAnyBlockOrIndent_(tree.body);
    },
    visitFormalParameterList: function(tree) {
      var first = true;
      for (var i = 0; i < tree.parameters.length; i++) {
        var parameter = tree.parameters[i];
        if (first) {
          first = false;
        } else {
          this.write_(COMMA);
          this.writeSpace_();
        }
        this.visitAny(parameter);
      }
    },
    visitFormalParameter: function(tree) {
      this.writeAnnotations_(tree.annotations, false);
      this.currentParameterTypeAnnotation_ = tree.typeAnnotation;
      this.visitAny(tree.parameter);
      this.currentParameterTypeAnnotation_ = null;
    },
    visitFunctionBody: function(tree) {
      this.write_(OPEN_CURLY);
      this.writelnList_(tree.statements);
      this.write_(CLOSE_CURLY);
    },
    visitFunctionDeclaration: function(tree) {
      this.visitFunction_(tree);
    },
    visitFunctionExpression: function(tree) {
      this.visitFunction_(tree);
    },
    visitFunction_: function(tree) {
      this.writeAnnotations_(tree.annotations);
      if (tree.isAsyncFunction())
        this.write_(tree.functionKind);
      this.write_(FUNCTION);
      if (tree.isGenerator())
        this.write_(tree.functionKind);
      if (tree.name) {
        this.writeSpace_();
        this.visitAny(tree.name);
      }
      this.write_(OPEN_PAREN);
      this.visitAny(tree.parameterList);
      this.write_(CLOSE_PAREN);
      this.writeTypeAnnotation_(tree.typeAnnotation);
      this.writeSpace_();
      this.visitAny(tree.body);
    },
    visitFunctionType: function(tree) {
      if (tree.typeParameters !== null) {
        this.visitAny(tree.typeParameters);
      }
      this.write_(OPEN_PAREN);
      this.visitAny(tree.parameterList);
      this.write_(CLOSE_PAREN);
      this.writeSpace_();
      this.write_(ARROW);
      this.writeSpace_();
      this.visitAny(tree.returnType);
    },
    visitGeneratorComprehension: function(tree) {
      this.write_(OPEN_PAREN);
      this.visitList(tree.comprehensionList);
      this.visitAny(tree.expression);
      this.write_(CLOSE_PAREN);
    },
    visitGetAccessor: function(tree) {
      this.writeAnnotations_(tree.annotations);
      if (tree.isStatic) {
        this.write_(STATIC);
        this.writeSpace_();
      }
      this.write_(GET);
      this.writeSpace_();
      this.visitAny(tree.name);
      this.write_(OPEN_PAREN);
      this.write_(CLOSE_PAREN);
      this.writeSpace_();
      this.writeTypeAnnotation_(tree.typeAnnotation);
      this.visitAny(tree.body);
    },
    visitIdentifierExpression: function(tree) {
      this.write_(tree.identifierToken);
    },
    visitIfStatement: function(tree) {
      this.write_(IF);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.condition);
      this.write_(CLOSE_PAREN);
      this.visitAnyBlockOrIndent_(tree.ifClause);
      if (tree.elseClause) {
        if (tree.ifClause.type === BLOCK)
          this.writeSpace_();
        this.write_(ELSE);
        if (tree.elseClause.type === IF_STATEMENT) {
          this.writeSpace_();
          this.visitAny(tree.elseClause);
        } else {
          this.visitAnyBlockOrIndent_(tree.elseClause);
        }
      }
    },
    visitIndexSignature: function(tree) {
      this.write_(OPEN_SQUARE);
      this.write_(tree.name);
      this.write_(COLON);
      this.writeSpace_();
      this.visitAny(tree.indexType);
      this.write_(CLOSE_SQUARE);
      this.writeTypeAnnotation_(tree.typeAnnotation);
      this.write_(SEMI_COLON);
    },
    visitInterfaceDeclaration: function(tree) {
      this.write_(INTERFACE);
      this.writeSpace_();
      this.write_(tree.name);
      if (tree.typeParameters) {
        this.visitAny(tree.typeParameters);
      }
      if (tree.extendsClause.length > 0) {
        this.writeSpace_();
        this.write_(EXTENDS);
        this.writeSpace_();
        this.writeList_(tree.extendsClause, COMMA, false);
      }
      this.writeSpace_();
      this.visitAny(tree.objectType);
    },
    visitAnyBlockOrIndent_: function(tree) {
      if (tree.type === BLOCK) {
        this.writeSpace_();
        this.visitAny(tree);
      } else {
        this.visitAnyIndented_(tree);
      }
    },
    visitAnyIndented_: function(tree) {
      var indent = arguments[1] !== (void 0) ? arguments[1] : 1;
      if (this.prettyPrint_) {
        this.indentDepth_ += indent;
        this.writeln_();
      }
      this.visitAny(tree);
      if (this.prettyPrint_) {
        this.indentDepth_ -= indent;
        this.writeln_();
      }
    },
    visitImportDeclaration: function(tree) {
      this.write_(IMPORT);
      this.writeSpace_();
      if (tree.importClause) {
        this.visitAny(tree.importClause);
        this.writeSpace_();
        this.write_(FROM);
        this.writeSpace_();
      }
      this.visitAny(tree.moduleSpecifier);
      this.write_(SEMI_COLON);
    },
    visitImportSpecifier: function(tree) {
      if (tree.name) {
        this.write_(tree.name);
        this.writeSpace_();
        this.write_(AS);
        this.writeSpace_();
      }
      this.visitAny(tree.binding);
    },
    visitImportSpecifierSet: function(tree) {
      if (tree.specifiers.type == STAR) {
        this.write_(STAR);
      } else {
        this.write_(OPEN_CURLY);
        this.writelnList_(tree.specifiers, COMMA);
        this.write_(CLOSE_CURLY);
      }
    },
    visitLabelledStatement: function(tree) {
      this.write_(tree.name);
      this.write_(COLON);
      this.writeSpace_();
      this.visitAny(tree.statement);
    },
    visitLiteralExpression: function(tree) {
      this.write_(tree.literalToken);
    },
    visitLiteralPropertyName: function(tree) {
      this.write_(tree.literalToken);
    },
    visitMemberExpression: function(tree) {
      this.visitAny(tree.operand);
      if (tree.operand.type === LITERAL_EXPRESSION && tree.operand.literalToken.type === NUMBER) {
        if (!/\.|e|E/.test(tree.operand.literalToken.value))
          this.writeRequiredSpace_();
      }
      this.write_(PERIOD);
      this.write_(tree.memberName);
    },
    visitMemberLookupExpression: function(tree) {
      this.visitAny(tree.operand);
      this.write_(OPEN_SQUARE);
      this.visitAny(tree.memberExpression);
      this.write_(CLOSE_SQUARE);
    },
    visitMethodSignature: function(tree) {
      this.visitAny(tree.name);
      if (tree.optional) {
        this.write_(QUESTION);
      }
      this.visitAny(tree.callSignature);
      this.write_(SEMI_COLON);
    },
    visitSyntaxErrorTree: function(tree) {
      this.write_('(function() {' + ("throw SyntaxError(" + JSON.stringify(tree.message) + ");") + '})()');
    },
    visitModule: function(tree) {
      this.writelnList_(tree.scriptItemList, null);
    },
    visitModuleSpecifier: function(tree) {
      this.write_(tree.token);
    },
    visitModuleDeclaration: function(tree) {
      this.write_(IMPORT);
      this.writeSpace_();
      this.write_(STAR);
      this.writeSpace_();
      this.write_(AS);
      this.visitAny(tree.binding);
      this.writeSpace_();
      this.write_(FROM);
      this.writeSpace_();
      this.visitAny(tree.expression);
      this.write_(SEMI_COLON);
    },
    visitNewExpression: function(tree) {
      this.write_(NEW);
      this.writeSpace_();
      this.visitAny(tree.operand);
      this.visitAny(tree.args);
    },
    visitObjectLiteralExpression: function(tree) {
      this.write_(OPEN_CURLY);
      if (tree.propertyNameAndValues.length > 1)
        this.writeln_();
      this.writelnList_(tree.propertyNameAndValues, COMMA);
      if (tree.propertyNameAndValues.length > 1)
        this.writeln_();
      this.write_(CLOSE_CURLY);
    },
    visitObjectPattern: function(tree) {
      this.write_(OPEN_CURLY);
      this.writelnList_(tree.fields, COMMA);
      this.write_(CLOSE_CURLY);
    },
    visitObjectPatternField: function(tree) {
      this.visitAny(tree.name);
      if (tree.element !== null) {
        this.write_(COLON);
        this.writeSpace_();
        this.visitAny(tree.element);
      }
    },
    visitObjectType: function(tree) {
      this.write_(OPEN_CURLY);
      this.writelnList_(tree.typeMembers);
      this.write_(CLOSE_CURLY);
    },
    visitParenExpression: function(tree) {
      this.write_(OPEN_PAREN);
      $traceurRuntime.superGet(this, $ParseTreeWriter.prototype, "visitParenExpression").call(this, tree);
      this.write_(CLOSE_PAREN);
    },
    visitPostfixExpression: function(tree) {
      this.visitAny(tree.operand);
      if (tree.operand.type === POSTFIX_EXPRESSION && tree.operand.operator.type === tree.operator.type) {
        this.writeRequiredSpace_();
      }
      this.write_(tree.operator);
    },
    visitPredefinedType: function(tree) {
      this.write_(tree.typeToken);
    },
    visitScript: function(tree) {
      this.writelnList_(tree.scriptItemList, null);
    },
    visitPropertyMethodAssignment: function(tree) {
      this.writeAnnotations_(tree.annotations);
      if (tree.isStatic) {
        this.write_(STATIC);
        this.writeSpace_();
      }
      if (tree.isGenerator())
        this.write_(STAR);
      if (tree.isAsyncFunction())
        this.write_(ASYNC);
      this.visitAny(tree.name);
      this.write_(OPEN_PAREN);
      this.visitAny(tree.parameterList);
      this.write_(CLOSE_PAREN);
      this.writeSpace_();
      this.writeTypeAnnotation_(tree.typeAnnotation);
      this.visitAny(tree.body);
    },
    visitPropertyNameAssignment: function(tree) {
      this.visitAny(tree.name);
      this.write_(COLON);
      this.writeSpace_();
      this.visitAny(tree.value);
    },
    visitPropertyNameShorthand: function(tree) {
      this.write_(tree.name);
    },
    visitPropertyVariableDeclaration: function(tree) {
      this.writeAnnotations_(tree.annotations);
      if (tree.isStatic) {
        this.write_(STATIC);
        this.writeSpace_();
      }
      this.visitAny(tree.name);
      this.writeTypeAnnotation_(tree.typeAnnotation);
      this.write_(SEMI_COLON);
    },
    visitPropertySignature: function(tree) {
      this.visitAny(tree.name);
      if (tree.optional) {
        this.write_(QUESTION);
      }
      this.writeTypeAnnotation_(tree.typeAnnotation);
      this.write_(SEMI_COLON);
    },
    visitTemplateLiteralExpression: function(tree) {
      if (tree.operand) {
        this.visitAny(tree.operand);
        this.writeSpace_();
      }
      this.writeRaw_(BACK_QUOTE);
      this.visitList(tree.elements);
      this.writeRaw_(BACK_QUOTE);
    },
    visitTemplateLiteralPortion: function(tree) {
      this.writeRaw_(tree.value);
    },
    visitTemplateSubstitution: function(tree) {
      this.writeRaw_('$');
      this.writeRaw_(OPEN_CURLY);
      this.visitAny(tree.expression);
      this.writeRaw_(CLOSE_CURLY);
    },
    visitReturnStatement: function(tree) {
      this.write_(RETURN);
      this.writeSpace_(tree.expression);
      this.visitAny(tree.expression);
      this.write_(SEMI_COLON);
    },
    visitRestParameter: function(tree) {
      this.write_(DOT_DOT_DOT);
      this.write_(tree.identifier.identifierToken);
      this.writeTypeAnnotation_(tree.typeAnnotation);
    },
    visitSetAccessor: function(tree) {
      this.writeAnnotations_(tree.annotations);
      if (tree.isStatic) {
        this.write_(STATIC);
        this.writeSpace_();
      }
      this.write_(SET);
      this.writeSpace_();
      this.visitAny(tree.name);
      this.write_(OPEN_PAREN);
      this.visitAny(tree.parameterList);
      this.write_(CLOSE_PAREN);
      this.writeSpace_();
      this.visitAny(tree.body);
    },
    visitSpreadExpression: function(tree) {
      this.write_(DOT_DOT_DOT);
      this.visitAny(tree.expression);
    },
    visitSpreadPatternElement: function(tree) {
      this.write_(DOT_DOT_DOT);
      this.visitAny(tree.lvalue);
    },
    visitStateMachine: function(tree) {
      throw new Error('State machines cannot be converted to source');
    },
    visitSuperExpression: function(tree) {
      this.write_(SUPER);
    },
    visitSwitchStatement: function(tree) {
      this.write_(SWITCH);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.expression);
      this.write_(CLOSE_PAREN);
      this.writeSpace_();
      this.write_(OPEN_CURLY);
      this.writelnList_(tree.caseClauses);
      this.write_(CLOSE_CURLY);
    },
    visitThisExpression: function(tree) {
      this.write_(THIS);
    },
    visitThrowStatement: function(tree) {
      this.write_(THROW);
      this.writeSpace_();
      this.visitAny(tree.value);
      this.write_(SEMI_COLON);
    },
    visitTryStatement: function(tree) {
      this.write_(TRY);
      this.writeSpace_();
      this.visitAny(tree.body);
      if (tree.catchBlock) {
        this.writeSpace_();
        this.visitAny(tree.catchBlock);
      }
      if (tree.finallyBlock) {
        this.writeSpace_();
        this.visitAny(tree.finallyBlock);
      }
    },
    visitTypeArguments: function(tree) {
      this.write_(OPEN_ANGLE);
      var args = tree.args;
      this.visitAny(args[0]);
      for (var i = 1; i < args.length; i++) {
        this.write_(COMMA);
        this.writeSpace_();
        this.visitAny(args[i]);
      }
      this.write_(CLOSE_ANGLE);
    },
    visitTypeName: function(tree) {
      if (tree.moduleName) {
        this.visitAny(tree.moduleName);
        this.write_(PERIOD);
      }
      this.write_(tree.name);
    },
    visitTypeParameter: function(tree) {
      this.write_(tree.identifierToken);
      if (tree.extendsType) {
        this.writeSpace_();
        this.write_(EXTENDS);
        this.writeSpace_();
        this.visitAny(tree.extendsType);
      }
    },
    visitTypeParameters: function(tree) {
      this.write_(OPEN_ANGLE);
      this.writeList_(tree.parameters, COMMA, false);
      this.write_(CLOSE_ANGLE);
    },
    visitUnaryExpression: function(tree) {
      var op = tree.operator;
      this.write_(op);
      var operand = tree.operand;
      if (operand.type === UNARY_EXPRESSION && requiresSpaceBetween(op.type, operand.operator.type)) {
        this.writeRequiredSpace_();
      }
      this.visitAny(operand);
    },
    visitUnionType: function(tree) {
      this.visitAny(tree.types[0]);
      for (var i = 1; i < tree.types.length; i++) {
        this.writeSpace_();
        this.write_(BAR);
        this.writeSpace_();
        this.visitAny(tree.types[i]);
      }
    },
    visitVariableDeclarationList: function(tree) {
      this.write_(tree.declarationType);
      this.writeSpace_();
      this.writeList_(tree.declarations, COMMA, true, 2);
    },
    visitVariableDeclaration: function(tree) {
      this.visitAny(tree.lvalue);
      this.writeTypeAnnotation_(tree.typeAnnotation);
      if (tree.initializer !== null) {
        this.writeSpace_();
        this.write_(EQUAL);
        this.writeSpace_();
        this.visitAny(tree.initializer);
      }
    },
    visitVariableStatement: function(tree) {
      $traceurRuntime.superGet(this, $ParseTreeWriter.prototype, "visitVariableStatement").call(this, tree);
      this.write_(SEMI_COLON);
    },
    visitWhileStatement: function(tree) {
      this.write_(WHILE);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.condition);
      this.write_(CLOSE_PAREN);
      this.visitAnyBlockOrIndent_(tree.body);
    },
    visitWithStatement: function(tree) {
      this.write_(WITH);
      this.writeSpace_();
      this.write_(OPEN_PAREN);
      this.visitAny(tree.expression);
      this.write_(CLOSE_PAREN);
      this.writeSpace_();
      this.visitAny(tree.body);
    },
    visitYieldExpression: function(tree) {
      this.write_(YIELD);
      if (tree.isYieldFor)
        this.write_(STAR);
      if (tree.expression) {
        this.writeSpace_();
        this.visitAny(tree.expression);
      }
    },
    writeCurrentln_: function() {
      this.result_ += this.currentLine_ + NEW_LINE;
    },
    writeln_: function() {
      if (this.currentLineComment_) {
        while (this.currentLine_.length < LINE_LENGTH) {
          this.currentLine_ += ' ';
        }
        this.currentLine_ += ' // ' + this.currentLineComment_;
        this.currentLineComment_ = null;
      }
      if (this.currentLine_)
        this.writeCurrentln_();
      this.currentLine_ = '';
    },
    writelnList_: function(list, delimiter) {
      if (delimiter) {
        this.writeList_(list, delimiter, true);
      } else {
        if (list.length > 0)
          this.writeln_();
        this.writeList_(list, null, true);
        if (list.length > 0)
          this.writeln_();
      }
    },
    writeList_: function(list, delimiter, writeNewLine) {
      var indent = arguments[3] !== (void 0) ? arguments[3] : 0;
      var first = true;
      for (var i = 0; i < list.length; i++) {
        var element = list[i];
        if (first) {
          first = false;
        } else {
          if (delimiter !== null) {
            this.write_(delimiter);
            if (!writeNewLine)
              this.writeSpace_();
          }
          if (writeNewLine) {
            if (i === 1)
              this.indentDepth_ += indent;
            this.writeln_();
          }
        }
        this.visitAny(element);
      }
      if (writeNewLine && list.length > 1)
        this.indentDepth_ -= indent;
    },
    writeRaw_: function(value) {
      this.currentLine_ += value;
    },
    write_: function(value) {
      if (value === CLOSE_CURLY)
        this.indentDepth_--;
      if (value !== null) {
        if (this.prettyPrint_) {
          if (!this.currentLine_) {
            for (var i = 0,
                indent = this.indentDepth_; i < indent; i++) {
              this.currentLine_ += '  ';
            }
          }
        }
        if (this.needsSpace_(value))
          this.currentLine_ += ' ';
        this.currentLine_ += value;
      }
      if (value === OPEN_CURLY)
        this.indentDepth_++;
    },
    writeSpace_: function() {
      var useSpace = arguments[0] !== (void 0) ? arguments[0] : this.prettyPrint_;
      if (useSpace && !endsWithSpace(this.currentLine_))
        this.currentLine_ += ' ';
    },
    writeRequiredSpace_: function() {
      this.writeSpace_(true);
    },
    writeTypeAnnotation_: function(typeAnnotation) {
      if (typeAnnotation !== null) {
        this.write_(COLON);
        this.writeSpace_();
        this.visitAny(typeAnnotation);
      }
    },
    writeAnnotations_: function(annotations) {
      var writeNewLine = arguments[1] !== (void 0) ? arguments[1] : this.prettyPrint_;
      if (annotations.length > 0) {
        this.writeList_(annotations, null, writeNewLine);
        if (writeNewLine)
          this.writeln_();
      }
    },
    needsSpace_: function(token) {
      var line = this.currentLine_;
      if (!line)
        return false;
      var lastCode = line.charCodeAt(line.length - 1);
      if (isWhitespace(lastCode))
        return false;
      var firstCode = token.toString().charCodeAt(0);
      return isIdentifierPart(firstCode) && (isIdentifierPart(lastCode) || lastCode === 47);
    }
  }, {}, ParseTreeVisitor);
  function requiresSpaceBetween(first, second) {
    return (first === MINUS || first === MINUS_MINUS) && (second === MINUS || second === MINUS_MINUS) || (first === PLUS || first === PLUS_PLUS) && (second === PLUS || second === PLUS_PLUS);
  }
  function endsWithSpace(s) {
    return isWhitespace(s.charCodeAt(s.length - 1));
  }
  return {get ParseTreeWriter() {
      return ParseTreeWriter;
    }};
});
System.registerModule("traceur@0.0.80/src/outputgeneration/ParseTreeMapWriter.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/outputgeneration/ParseTreeMapWriter.js";
  var ParseTreeWriter = System.get("traceur@0.0.80/src/outputgeneration/ParseTreeWriter.js").ParseTreeWriter;
  var ParseTreeMapWriter = function ParseTreeMapWriter(sourceMapGenerator, sourceRoot) {
    var options = arguments[2];
    $traceurRuntime.superConstructor($ParseTreeMapWriter).call(this, options);
    this.sourceMapGenerator_ = sourceMapGenerator;
    this.sourceRoot_ = sourceRoot;
    this.outputLineCount_ = 1;
    this.isFirstMapping_ = true;
  };
  var $ParseTreeMapWriter = ParseTreeMapWriter;
  ($traceurRuntime.createClass)(ParseTreeMapWriter, {
    visitAny: function(tree) {
      if (!tree) {
        return;
      }
      if (tree.location)
        this.enterBranch(tree.location);
      $traceurRuntime.superGet(this, $ParseTreeMapWriter.prototype, "visitAny").call(this, tree);
      if (tree.location)
        this.exitBranch(tree.location);
    },
    writeCurrentln_: function() {
      $traceurRuntime.superGet(this, $ParseTreeMapWriter.prototype, "writeCurrentln_").call(this);
      this.flushMappings();
      this.outputLineCount_++;
      this.generated_ = {
        line: this.outputLineCount_,
        column: 0
      };
      this.flushMappings();
    },
    write_: function(value) {
      if (this.entered_) {
        this.generate();
        $traceurRuntime.superGet(this, $ParseTreeMapWriter.prototype, "write_").call(this, value);
        this.generate();
      } else {
        this.generate();
        $traceurRuntime.superGet(this, $ParseTreeMapWriter.prototype, "write_").call(this, value);
        this.generate();
      }
    },
    generate: function() {
      var column = this.currentLine_.length ? this.currentLine_.length - 1 : 0;
      this.generated_ = {
        line: this.outputLineCount_,
        column: column
      };
      this.flushMappings();
    },
    enterBranch: function(location) {
      this.originate(location.start);
      this.entered_ = true;
    },
    exitBranch: function(location) {
      var position = location.end;
      var endOfPreviousToken = {
        line: position.line,
        column: position.column ? position.column - 1 : 0,
        source: {
          name: position.source.name,
          contents: position.source.contents
        }
      };
      this.originate(endOfPreviousToken);
      this.entered_ = false;
    },
    originate: function(position) {
      var line = position.line + 1;
      if (this.original_ && this.original_.line !== line)
        this.flushMappings();
      this.original_ = {
        line: line,
        column: position.column || 0
      };
      if (position.source.name !== this.sourceName_) {
        this.sourceName_ = relativeToSourceRoot(position.source.name, this.sourceRoot_);
        this.sourceMapGenerator_.setSourceContent(position.source.name, position.source.contents);
      }
      this.flushMappings();
    },
    flushMappings: function() {
      if (this.original_ && this.generated_) {
        this.addMapping();
        this.original_ = null;
        this.generated_ = null;
      }
    },
    isSame: function(lhs, rhs) {
      return lhs.line === rhs.line && lhs.column === rhs.column;
    },
    isSameMapping: function() {
      if (!this.previousMapping_)
        return false;
      if (this.isSame(this.previousMapping_.generated, this.generated_) && this.isSame(this.previousMapping_.original, this.original_))
        return true;
      ;
    },
    addMapping: function() {
      if (this.isSameMapping())
        return;
      var mapping = {
        generated: this.generated_,
        original: this.original_,
        source: this.sourceName_
      };
      this.sourceMapGenerator_.addMapping(mapping);
      this.previousMapping_ = mapping;
    }
  }, {}, ParseTreeWriter);
  function relativeToSourceRoot(name, sourceRoot) {
    var $__2;
    if (!name || name[0] === '@')
      return name;
    if (!sourceRoot)
      return name;
    var nameSegments = name.split('/');
    var rootSegments = sourceRoot.split('/');
    if (rootSegments[rootSegments.length - 1]) {
      rootSegments.push('');
    }
    var commonSegmentsLength = 0;
    var uniqueSegments = [];
    nameSegments.forEach((function(segment, index) {
      if (segment === rootSegments[index]) {
        commonSegmentsLength++;
        return false;
      }
      uniqueSegments.push(segment);
    }));
    if (commonSegmentsLength < 1 || commonSegmentsLength === rootSegments.length)
      return name;
    var dotDotSegments = rootSegments.length - commonSegmentsLength - 1;
    var segments = [];
    while (dotDotSegments--) {
      segments.push('..');
    }
    ($__2 = segments).push.apply($__2, $traceurRuntime.spread(uniqueSegments));
    return segments.join('/');
  }
  return {
    get ParseTreeMapWriter() {
      return ParseTreeMapWriter;
    },
    get relativeToSourceRoot() {
      return relativeToSourceRoot;
    }
  };
});
System.registerModule("traceur@0.0.80/src/outputgeneration/SourceMapIntegration.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/outputgeneration/SourceMapIntegration.js";
  function makeDefine(mapping, id) {
    var require = function(id) {
      return mapping[id];
    };
    var exports = mapping[id] = {};
    var module = null;
    return function(factory) {
      factory(require, exports, module);
    };
  }
  var define,
      m = {};
  define = makeDefine(m, './util');
  if (typeof define !== 'function') {
    var define = require('amdefine')(module, require);
  }
  define(function(require, exports, module) {
    function getArg(aArgs, aName, aDefaultValue) {
      if (aName in aArgs) {
        return aArgs[aName];
      } else if (arguments.length === 3) {
        return aDefaultValue;
      } else {
        throw new Error('"' + aName + '" is a required argument.');
      }
    }
    exports.getArg = getArg;
    var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.]*)(?::(\d+))?(\S*)$/;
    var dataUrlRegexp = /^data:.+\,.+$/;
    function urlParse(aUrl) {
      var match = aUrl.match(urlRegexp);
      if (!match) {
        return null;
      }
      return {
        scheme: match[1],
        auth: match[2],
        host: match[3],
        port: match[4],
        path: match[5]
      };
    }
    exports.urlParse = urlParse;
    function urlGenerate(aParsedUrl) {
      var url = '';
      if (aParsedUrl.scheme) {
        url += aParsedUrl.scheme + ':';
      }
      url += '//';
      if (aParsedUrl.auth) {
        url += aParsedUrl.auth + '@';
      }
      if (aParsedUrl.host) {
        url += aParsedUrl.host;
      }
      if (aParsedUrl.port) {
        url += ":" + aParsedUrl.port;
      }
      if (aParsedUrl.path) {
        url += aParsedUrl.path;
      }
      return url;
    }
    exports.urlGenerate = urlGenerate;
    function normalize(aPath) {
      var path = aPath;
      var url = urlParse(aPath);
      if (url) {
        if (!url.path) {
          return aPath;
        }
        path = url.path;
      }
      var isAbsolute = (path.charAt(0) === '/');
      var parts = path.split(/\/+/);
      for (var part,
          up = 0,
          i = parts.length - 1; i >= 0; i--) {
        part = parts[i];
        if (part === '.') {
          parts.splice(i, 1);
        } else if (part === '..') {
          up++;
        } else if (up > 0) {
          if (part === '') {
            parts.splice(i + 1, up);
            up = 0;
          } else {
            parts.splice(i, 2);
            up--;
          }
        }
      }
      path = parts.join('/');
      if (path === '') {
        path = isAbsolute ? '/' : '.';
      }
      if (url) {
        url.path = path;
        return urlGenerate(url);
      }
      return path;
    }
    exports.normalize = normalize;
    function join(aRoot, aPath) {
      var aPathUrl = urlParse(aPath);
      var aRootUrl = urlParse(aRoot);
      if (aRootUrl) {
        aRoot = aRootUrl.path || '/';
      }
      if (aPathUrl && !aPathUrl.scheme) {
        if (aRootUrl) {
          aPathUrl.scheme = aRootUrl.scheme;
        }
        return urlGenerate(aPathUrl);
      }
      if (aPathUrl || aPath.match(dataUrlRegexp)) {
        return aPath;
      }
      if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
        aRootUrl.host = aPath;
        return urlGenerate(aRootUrl);
      }
      var joined = aPath.charAt(0) === '/' ? aPath : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);
      if (aRootUrl) {
        aRootUrl.path = joined;
        return urlGenerate(aRootUrl);
      }
      return joined;
    }
    exports.join = join;
    function toSetString(aStr) {
      return '$' + aStr;
    }
    exports.toSetString = toSetString;
    function fromSetString(aStr) {
      return aStr.substr(1);
    }
    exports.fromSetString = fromSetString;
    function relative(aRoot, aPath) {
      aRoot = aRoot.replace(/\/$/, '');
      var url = urlParse(aRoot);
      if (aPath.charAt(0) == "/" && url && url.path == "/") {
        return aPath.slice(1);
      }
      return aPath.indexOf(aRoot + '/') === 0 ? aPath.substr(aRoot.length + 1) : aPath;
    }
    exports.relative = relative;
    function strcmp(aStr1, aStr2) {
      var s1 = aStr1 || "";
      var s2 = aStr2 || "";
      return (s1 > s2) - (s1 < s2);
    }
    function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
      var cmp;
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp || onlyCompareOriginal) {
        return cmp;
      }
      cmp = strcmp(mappingA.name, mappingB.name);
      if (cmp) {
        return cmp;
      }
      cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp) {
        return cmp;
      }
      return mappingA.generatedColumn - mappingB.generatedColumn;
    }
    ;
    exports.compareByOriginalPositions = compareByOriginalPositions;
    function compareByGeneratedPositions(mappingA, mappingB, onlyCompareGenerated) {
      var cmp;
      cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp || onlyCompareGenerated) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    ;
    exports.compareByGeneratedPositions = compareByGeneratedPositions;
  });
  define = makeDefine(m, './array-set');
  if (typeof define !== 'function') {
    var define = require('amdefine')(module, require);
  }
  define(function(require, exports, module) {
    var util = require('./util');
    function ArraySet() {
      this._array = [];
      this._set = {};
    }
    ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
      var set = new ArraySet();
      for (var i = 0,
          len = aArray.length; i < len; i++) {
        set.add(aArray[i], aAllowDuplicates);
      }
      return set;
    };
    ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
      var isDuplicate = this.has(aStr);
      var idx = this._array.length;
      if (!isDuplicate || aAllowDuplicates) {
        this._array.push(aStr);
      }
      if (!isDuplicate) {
        this._set[util.toSetString(aStr)] = idx;
      }
    };
    ArraySet.prototype.has = function ArraySet_has(aStr) {
      return Object.prototype.hasOwnProperty.call(this._set, util.toSetString(aStr));
    };
    ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
      if (this.has(aStr)) {
        return this._set[util.toSetString(aStr)];
      }
      throw new Error('"' + aStr + '" is not in the set.');
    };
    ArraySet.prototype.at = function ArraySet_at(aIdx) {
      if (aIdx >= 0 && aIdx < this._array.length) {
        return this._array[aIdx];
      }
      throw new Error('No element indexed by ' + aIdx);
    };
    ArraySet.prototype.toArray = function ArraySet_toArray() {
      return this._array.slice();
    };
    exports.ArraySet = ArraySet;
  });
  define = makeDefine(m, './base64');
  if (typeof define !== 'function') {
    var define = require('amdefine')(module, require);
  }
  define(function(require, exports, module) {
    var charToIntMap = {};
    var intToCharMap = {};
    'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('').forEach(function(ch, index) {
      charToIntMap[ch] = index;
      intToCharMap[index] = ch;
    });
    exports.encode = function base64_encode(aNumber) {
      if (aNumber in intToCharMap) {
        return intToCharMap[aNumber];
      }
      throw new TypeError("Must be between 0 and 63: " + aNumber);
    };
    exports.decode = function base64_decode(aChar) {
      if (aChar in charToIntMap) {
        return charToIntMap[aChar];
      }
      throw new TypeError("Not a valid base 64 digit: " + aChar);
    };
  });
  define = makeDefine(m, './base64-vlq');
  if (typeof define !== 'function') {
    var define = require('amdefine')(module, require);
  }
  define(function(require, exports, module) {
    var base64 = require('./base64');
    var VLQ_BASE_SHIFT = 5;
    var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
    var VLQ_BASE_MASK = VLQ_BASE - 1;
    var VLQ_CONTINUATION_BIT = VLQ_BASE;
    function toVLQSigned(aValue) {
      return aValue < 0 ? ((-aValue) << 1) + 1 : (aValue << 1) + 0;
    }
    function fromVLQSigned(aValue) {
      var isNegative = (aValue & 1) === 1;
      var shifted = aValue >> 1;
      return isNegative ? -shifted : shifted;
    }
    exports.encode = function base64VLQ_encode(aValue) {
      var encoded = "";
      var digit;
      var vlq = toVLQSigned(aValue);
      do {
        digit = vlq & VLQ_BASE_MASK;
        vlq >>>= VLQ_BASE_SHIFT;
        if (vlq > 0) {
          digit |= VLQ_CONTINUATION_BIT;
        }
        encoded += base64.encode(digit);
      } while (vlq > 0);
      return encoded;
    };
    exports.decode = function base64VLQ_decode(aStr) {
      var i = 0;
      var strLen = aStr.length;
      var result = 0;
      var shift = 0;
      var continuation,
          digit;
      do {
        if (i >= strLen) {
          throw new Error("Expected more digits in base 64 VLQ value.");
        }
        digit = base64.decode(aStr.charAt(i++));
        continuation = !!(digit & VLQ_CONTINUATION_BIT);
        digit &= VLQ_BASE_MASK;
        result = result + (digit << shift);
        shift += VLQ_BASE_SHIFT;
      } while (continuation);
      return {
        value: fromVLQSigned(result),
        rest: aStr.slice(i)
      };
    };
  });
  define = makeDefine(m, './binary-search');
  if (typeof define !== 'function') {
    var define = require('amdefine')(module, require);
  }
  define(function(require, exports, module) {
    function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare) {
      var mid = Math.floor((aHigh - aLow) / 2) + aLow;
      var cmp = aCompare(aNeedle, aHaystack[mid], true);
      if (cmp === 0) {
        return aHaystack[mid];
      } else if (cmp > 0) {
        if (aHigh - mid > 1) {
          return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare);
        }
        return aHaystack[mid];
      } else {
        if (mid - aLow > 1) {
          return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare);
        }
        return aLow < 0 ? null : aHaystack[aLow];
      }
    }
    exports.search = function search(aNeedle, aHaystack, aCompare) {
      return aHaystack.length > 0 ? recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack, aCompare) : null;
    };
  });
  define = makeDefine(m, './source-map-generator');
  if (typeof define !== 'function') {
    var define = require('amdefine')(module, require);
  }
  define(function(require, exports, module) {
    var base64VLQ = require('./base64-vlq');
    var util = require('./util');
    var ArraySet = require('./array-set').ArraySet;
    function SourceMapGenerator(aArgs) {
      if (!aArgs) {
        aArgs = {};
      }
      this._file = util.getArg(aArgs, 'file', null);
      this._sourceRoot = util.getArg(aArgs, 'sourceRoot', null);
      this._sources = new ArraySet();
      this._names = new ArraySet();
      this._mappings = [];
      this._sourcesContents = null;
    }
    SourceMapGenerator.prototype._version = 3;
    SourceMapGenerator.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
      var sourceRoot = aSourceMapConsumer.sourceRoot;
      var generator = new SourceMapGenerator({
        file: aSourceMapConsumer.file,
        sourceRoot: sourceRoot
      });
      aSourceMapConsumer.eachMapping(function(mapping) {
        var newMapping = {generated: {
            line: mapping.generatedLine,
            column: mapping.generatedColumn
          }};
        if (mapping.source) {
          newMapping.source = mapping.source;
          if (sourceRoot) {
            newMapping.source = util.relative(sourceRoot, newMapping.source);
          }
          newMapping.original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };
          if (mapping.name) {
            newMapping.name = mapping.name;
          }
        }
        generator.addMapping(newMapping);
      });
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content) {
          generator.setSourceContent(sourceFile, content);
        }
      });
      return generator;
    };
    SourceMapGenerator.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
      var generated = util.getArg(aArgs, 'generated');
      var original = util.getArg(aArgs, 'original', null);
      var source = util.getArg(aArgs, 'source', null);
      var name = util.getArg(aArgs, 'name', null);
      this._validateMapping(generated, original, source, name);
      if (source && !this._sources.has(source)) {
        this._sources.add(source);
      }
      if (name && !this._names.has(name)) {
        this._names.add(name);
      }
      this._mappings.push({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source: source,
        name: name
      });
    };
    SourceMapGenerator.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
      var source = aSourceFile;
      if (this._sourceRoot) {
        source = util.relative(this._sourceRoot, source);
      }
      if (aSourceContent !== null) {
        if (!this._sourcesContents) {
          this._sourcesContents = {};
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
      } else {
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
          this._sourcesContents = null;
        }
      }
    };
    SourceMapGenerator.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
      if (!aSourceFile) {
        if (!aSourceMapConsumer.file) {
          throw new Error('SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' + 'or the source map\'s "file" property. Both were omitted.');
        }
        aSourceFile = aSourceMapConsumer.file;
      }
      var sourceRoot = this._sourceRoot;
      if (sourceRoot) {
        aSourceFile = util.relative(sourceRoot, aSourceFile);
      }
      var newSources = new ArraySet();
      var newNames = new ArraySet();
      this._mappings.forEach(function(mapping) {
        if (mapping.source === aSourceFile && mapping.originalLine) {
          var original = aSourceMapConsumer.originalPositionFor({
            line: mapping.originalLine,
            column: mapping.originalColumn
          });
          if (original.source !== null) {
            mapping.source = original.source;
            if (aSourceMapPath) {
              mapping.source = util.join(aSourceMapPath, mapping.source);
            }
            if (sourceRoot) {
              mapping.source = util.relative(sourceRoot, mapping.source);
            }
            mapping.originalLine = original.line;
            mapping.originalColumn = original.column;
            if (original.name !== null && mapping.name !== null) {
              mapping.name = original.name;
            }
          }
        }
        var source = mapping.source;
        if (source && !newSources.has(source)) {
          newSources.add(source);
        }
        var name = mapping.name;
        if (name && !newNames.has(name)) {
          newNames.add(name);
        }
      }, this);
      this._sources = newSources;
      this._names = newNames;
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content) {
          if (aSourceMapPath) {
            sourceFile = util.join(aSourceMapPath, sourceFile);
          }
          if (sourceRoot) {
            sourceFile = util.relative(sourceRoot, sourceFile);
          }
          this.setSourceContent(sourceFile, content);
        }
      }, this);
    };
    SourceMapGenerator.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
      if (aGenerated && 'line' in aGenerated && 'column' in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) {
        return;
      } else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated && aOriginal && 'line' in aOriginal && 'column' in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) {
        return;
      } else {
        throw new Error('Invalid mapping: ' + JSON.stringify({
          generated: aGenerated,
          source: aSource,
          original: aOriginal,
          name: aName
        }));
      }
    };
    SourceMapGenerator.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
      var previousGeneratedColumn = 0;
      var previousGeneratedLine = 1;
      var previousOriginalColumn = 0;
      var previousOriginalLine = 0;
      var previousName = 0;
      var previousSource = 0;
      var result = '';
      var mapping;
      this._mappings.sort(util.compareByGeneratedPositions);
      for (var i = 0,
          len = this._mappings.length; i < len; i++) {
        mapping = this._mappings[i];
        if (mapping.generatedLine !== previousGeneratedLine) {
          previousGeneratedColumn = 0;
          while (mapping.generatedLine !== previousGeneratedLine) {
            result += ';';
            previousGeneratedLine++;
          }
        } else {
          if (i > 0) {
            if (!util.compareByGeneratedPositions(mapping, this._mappings[i - 1])) {
              continue;
            }
            result += ',';
          }
        }
        result += base64VLQ.encode(mapping.generatedColumn - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;
        if (mapping.source) {
          result += base64VLQ.encode(this._sources.indexOf(mapping.source) - previousSource);
          previousSource = this._sources.indexOf(mapping.source);
          result += base64VLQ.encode(mapping.originalLine - 1 - previousOriginalLine);
          previousOriginalLine = mapping.originalLine - 1;
          result += base64VLQ.encode(mapping.originalColumn - previousOriginalColumn);
          previousOriginalColumn = mapping.originalColumn;
          if (mapping.name) {
            result += base64VLQ.encode(this._names.indexOf(mapping.name) - previousName);
            previousName = this._names.indexOf(mapping.name);
          }
        }
      }
      return result;
    };
    SourceMapGenerator.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
      return aSources.map(function(source) {
        if (!this._sourcesContents) {
          return null;
        }
        if (aSourceRoot) {
          source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
      }, this);
    };
    SourceMapGenerator.prototype.toJSON = function SourceMapGenerator_toJSON() {
      var map = {
        version: this._version,
        file: this._file,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
      };
      if (this._sourceRoot) {
        map.sourceRoot = this._sourceRoot;
      }
      if (this._sourcesContents) {
        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
      }
      return map;
    };
    SourceMapGenerator.prototype.toString = function SourceMapGenerator_toString() {
      return JSON.stringify(this);
    };
    exports.SourceMapGenerator = SourceMapGenerator;
  });
  define = makeDefine(m, './source-map-consumer');
  if (typeof define !== 'function') {
    var define = require('amdefine')(module, require);
  }
  define(function(require, exports, module) {
    var util = require('./util');
    var binarySearch = require('./binary-search');
    var ArraySet = require('./array-set').ArraySet;
    var base64VLQ = require('./base64-vlq');
    function SourceMapConsumer(aSourceMap) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === 'string') {
        sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
      }
      var version = util.getArg(sourceMap, 'version');
      var sources = util.getArg(sourceMap, 'sources');
      var names = util.getArg(sourceMap, 'names', []);
      var sourceRoot = util.getArg(sourceMap, 'sourceRoot', null);
      var sourcesContent = util.getArg(sourceMap, 'sourcesContent', null);
      var mappings = util.getArg(sourceMap, 'mappings');
      var file = util.getArg(sourceMap, 'file', null);
      if (version != this._version) {
        throw new Error('Unsupported version: ' + version);
      }
      this._names = ArraySet.fromArray(names, true);
      this._sources = ArraySet.fromArray(sources, true);
      this.sourceRoot = sourceRoot;
      this.sourcesContent = sourcesContent;
      this._mappings = mappings;
      this.file = file;
    }
    SourceMapConsumer.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap) {
      var smc = Object.create(SourceMapConsumer.prototype);
      smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
      smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
      smc.sourceRoot = aSourceMap._sourceRoot;
      smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(), smc.sourceRoot);
      smc.file = aSourceMap._file;
      smc.__generatedMappings = aSourceMap._mappings.slice().sort(util.compareByGeneratedPositions);
      smc.__originalMappings = aSourceMap._mappings.slice().sort(util.compareByOriginalPositions);
      return smc;
    };
    SourceMapConsumer.prototype._version = 3;
    Object.defineProperty(SourceMapConsumer.prototype, 'sources', {get: function() {
        return this._sources.toArray().map(function(s) {
          return this.sourceRoot ? util.join(this.sourceRoot, s) : s;
        }, this);
      }});
    SourceMapConsumer.prototype.__generatedMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, '_generatedMappings', {get: function() {
        if (!this.__generatedMappings) {
          this.__generatedMappings = [];
          this.__originalMappings = [];
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__generatedMappings;
      }});
    SourceMapConsumer.prototype.__originalMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, '_originalMappings', {get: function() {
        if (!this.__originalMappings) {
          this.__generatedMappings = [];
          this.__originalMappings = [];
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__originalMappings;
      }});
    SourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      var generatedLine = 1;
      var previousGeneratedColumn = 0;
      var previousOriginalLine = 0;
      var previousOriginalColumn = 0;
      var previousSource = 0;
      var previousName = 0;
      var mappingSeparator = /^[,;]/;
      var str = aStr;
      var mapping;
      var temp;
      while (str.length > 0) {
        if (str.charAt(0) === ';') {
          generatedLine++;
          str = str.slice(1);
          previousGeneratedColumn = 0;
        } else if (str.charAt(0) === ',') {
          str = str.slice(1);
        } else {
          mapping = {};
          mapping.generatedLine = generatedLine;
          temp = base64VLQ.decode(str);
          mapping.generatedColumn = previousGeneratedColumn + temp.value;
          previousGeneratedColumn = mapping.generatedColumn;
          str = temp.rest;
          if (str.length > 0 && !mappingSeparator.test(str.charAt(0))) {
            temp = base64VLQ.decode(str);
            mapping.source = this._sources.at(previousSource + temp.value);
            previousSource += temp.value;
            str = temp.rest;
            if (str.length === 0 || mappingSeparator.test(str.charAt(0))) {
              throw new Error('Found a source, but no line and column');
            }
            temp = base64VLQ.decode(str);
            mapping.originalLine = previousOriginalLine + temp.value;
            previousOriginalLine = mapping.originalLine;
            mapping.originalLine += 1;
            str = temp.rest;
            if (str.length === 0 || mappingSeparator.test(str.charAt(0))) {
              throw new Error('Found a source and line, but no column');
            }
            temp = base64VLQ.decode(str);
            mapping.originalColumn = previousOriginalColumn + temp.value;
            previousOriginalColumn = mapping.originalColumn;
            str = temp.rest;
            if (str.length > 0 && !mappingSeparator.test(str.charAt(0))) {
              temp = base64VLQ.decode(str);
              mapping.name = this._names.at(previousName + temp.value);
              previousName += temp.value;
              str = temp.rest;
            }
          }
          this.__generatedMappings.push(mapping);
          if (typeof mapping.originalLine === 'number') {
            this.__originalMappings.push(mapping);
          }
        }
      }
      this.__generatedMappings.sort(util.compareByGeneratedPositions);
      this.__originalMappings.sort(util.compareByOriginalPositions);
    };
    SourceMapConsumer.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator) {
      if (aNeedle[aLineName] <= 0) {
        throw new TypeError('Line must be greater than or equal to 1, got ' + aNeedle[aLineName]);
      }
      if (aNeedle[aColumnName] < 0) {
        throw new TypeError('Column must be greater than or equal to 0, got ' + aNeedle[aColumnName]);
      }
      return binarySearch.search(aNeedle, aMappings, aComparator);
    };
    SourceMapConsumer.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, 'line'),
        generatedColumn: util.getArg(aArgs, 'column')
      };
      var mapping = this._findMapping(needle, this._generatedMappings, "generatedLine", "generatedColumn", util.compareByGeneratedPositions);
      if (mapping && mapping.generatedLine === needle.generatedLine) {
        var source = util.getArg(mapping, 'source', null);
        if (source && this.sourceRoot) {
          source = util.join(this.sourceRoot, source);
        }
        return {
          source: source,
          line: util.getArg(mapping, 'originalLine', null),
          column: util.getArg(mapping, 'originalColumn', null),
          name: util.getArg(mapping, 'name', null)
        };
      }
      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    };
    SourceMapConsumer.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource) {
      if (!this.sourcesContent) {
        return null;
      }
      if (this.sourceRoot) {
        aSource = util.relative(this.sourceRoot, aSource);
      }
      if (this._sources.has(aSource)) {
        return this.sourcesContent[this._sources.indexOf(aSource)];
      }
      var url;
      if (this.sourceRoot && (url = util.urlParse(this.sourceRoot))) {
        var fileUriAbsPath = aSource.replace(/^file:\/\//, "");
        if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
        }
        if ((!url.path || url.path == "/") && this._sources.has("/" + aSource)) {
          return this.sourcesContent[this._sources.indexOf("/" + aSource)];
        }
      }
      throw new Error('"' + aSource + '" is not in the SourceMap.');
    };
    SourceMapConsumer.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
      var needle = {
        source: util.getArg(aArgs, 'source'),
        originalLine: util.getArg(aArgs, 'line'),
        originalColumn: util.getArg(aArgs, 'column')
      };
      if (this.sourceRoot) {
        needle.source = util.relative(this.sourceRoot, needle.source);
      }
      var mapping = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util.compareByOriginalPositions);
      if (mapping) {
        return {
          line: util.getArg(mapping, 'generatedLine', null),
          column: util.getArg(mapping, 'generatedColumn', null)
        };
      }
      return {
        line: null,
        column: null
      };
    };
    SourceMapConsumer.GENERATED_ORDER = 1;
    SourceMapConsumer.ORIGINAL_ORDER = 2;
    SourceMapConsumer.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
      var context = aContext || null;
      var order = aOrder || SourceMapConsumer.GENERATED_ORDER;
      var mappings;
      switch (order) {
        case SourceMapConsumer.GENERATED_ORDER:
          mappings = this._generatedMappings;
          break;
        case SourceMapConsumer.ORIGINAL_ORDER:
          mappings = this._originalMappings;
          break;
        default:
          throw new Error("Unknown order of iteration.");
      }
      var sourceRoot = this.sourceRoot;
      mappings.map(function(mapping) {
        var source = mapping.source;
        if (source && sourceRoot) {
          source = util.join(sourceRoot, source);
        }
        return {
          source: source,
          generatedLine: mapping.generatedLine,
          generatedColumn: mapping.generatedColumn,
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: mapping.name
        };
      }).forEach(aCallback, context);
    };
    exports.SourceMapConsumer = SourceMapConsumer;
  });
  define = makeDefine(m, './source-node');
  if (typeof define !== 'function') {
    var define = require('amdefine')(module, require);
  }
  define(function(require, exports, module) {
    var SourceMapGenerator = require('./source-map-generator').SourceMapGenerator;
    var util = require('./util');
    var REGEX_NEWLINE = /(\r?\n)/g;
    var REGEX_CHARACTER = /\r\n|[\s\S]/g;
    function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
      this.children = [];
      this.sourceContents = {};
      this.line = aLine === undefined ? null : aLine;
      this.column = aColumn === undefined ? null : aColumn;
      this.source = aSource === undefined ? null : aSource;
      this.name = aName === undefined ? null : aName;
      if (aChunks != null)
        this.add(aChunks);
    }
    SourceNode.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer) {
      var node = new SourceNode();
      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
      var shiftNextLine = function() {
        var lineContents = remainingLines.shift();
        var newLine = remainingLines.shift() || "";
        return lineContents + newLine;
      };
      var lastGeneratedLine = 1,
          lastGeneratedColumn = 0;
      var lastMapping = null;
      aSourceMapConsumer.eachMapping(function(mapping) {
        if (lastMapping !== null) {
          if (lastGeneratedLine < mapping.generatedLine) {
            var code = "";
            addMappingWithCode(lastMapping, shiftNextLine());
            lastGeneratedLine++;
            lastGeneratedColumn = 0;
          } else {
            var nextLine = remainingLines[0];
            var code = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
            remainingLines[0] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
            addMappingWithCode(lastMapping, code);
            lastMapping = mapping;
            return;
          }
        }
        while (lastGeneratedLine < mapping.generatedLine) {
          node.add(shiftNextLine());
          lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
          var nextLine = remainingLines[0];
          node.add(nextLine.substr(0, mapping.generatedColumn));
          remainingLines[0] = nextLine.substr(mapping.generatedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
      }, this);
      if (remainingLines.length > 0) {
        if (lastMapping) {
          addMappingWithCode(lastMapping, shiftNextLine());
        }
        node.add(remainingLines.join(""));
      }
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content) {
          node.setSourceContent(sourceFile, content);
        }
      });
      return node;
      function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === undefined) {
          node.add(code);
        } else {
          node.add(new SourceNode(mapping.originalLine, mapping.originalColumn, mapping.source, code, mapping.name));
        }
      }
    };
    SourceNode.prototype.add = function SourceNode_add(aChunk) {
      if (Array.isArray(aChunk)) {
        aChunk.forEach(function(chunk) {
          this.add(chunk);
        }, this);
      } else if (aChunk instanceof SourceNode || typeof aChunk === "string") {
        if (aChunk) {
          this.children.push(aChunk);
        }
      } else {
        throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
      }
      return this;
    };
    SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
      if (Array.isArray(aChunk)) {
        for (var i = aChunk.length - 1; i >= 0; i--) {
          this.prepend(aChunk[i]);
        }
      } else if (aChunk instanceof SourceNode || typeof aChunk === "string") {
        this.children.unshift(aChunk);
      } else {
        throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
      }
      return this;
    };
    SourceNode.prototype.walk = function SourceNode_walk(aFn) {
      var chunk;
      for (var i = 0,
          len = this.children.length; i < len; i++) {
        chunk = this.children[i];
        if (chunk instanceof SourceNode) {
          chunk.walk(aFn);
        } else {
          if (chunk !== '') {
            aFn(chunk, {
              source: this.source,
              line: this.line,
              column: this.column,
              name: this.name
            });
          }
        }
      }
    };
    SourceNode.prototype.join = function SourceNode_join(aSep) {
      var newChildren;
      var i;
      var len = this.children.length;
      if (len > 0) {
        newChildren = [];
        for (i = 0; i < len - 1; i++) {
          newChildren.push(this.children[i]);
          newChildren.push(aSep);
        }
        newChildren.push(this.children[i]);
        this.children = newChildren;
      }
      return this;
    };
    SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
      var lastChild = this.children[this.children.length - 1];
      if (lastChild instanceof SourceNode) {
        lastChild.replaceRight(aPattern, aReplacement);
      } else if (typeof lastChild === 'string') {
        this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
      } else {
        this.children.push(''.replace(aPattern, aReplacement));
      }
      return this;
    };
    SourceNode.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
    };
    SourceNode.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
      for (var i = 0,
          len = this.children.length; i < len; i++) {
        if (this.children[i] instanceof SourceNode) {
          this.children[i].walkSourceContents(aFn);
        }
      }
      var sources = Object.keys(this.sourceContents);
      for (var i = 0,
          len = sources.length; i < len; i++) {
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
      }
    };
    SourceNode.prototype.toString = function SourceNode_toString() {
      var str = "";
      this.walk(function(chunk) {
        str += chunk;
      });
      return str;
    };
    SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
      var generated = {
        code: "",
        line: 1,
        column: 0
      };
      var map = new SourceMapGenerator(aArgs);
      var sourceMappingActive = false;
      var lastOriginalSource = null;
      var lastOriginalLine = null;
      var lastOriginalColumn = null;
      var lastOriginalName = null;
      this.walk(function(chunk, original) {
        generated.code += chunk;
        if (original.source !== null && original.line !== null && original.column !== null) {
          if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) {
            map.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
          lastOriginalSource = original.source;
          lastOriginalLine = original.line;
          lastOriginalColumn = original.column;
          lastOriginalName = original.name;
          sourceMappingActive = true;
        } else if (sourceMappingActive) {
          map.addMapping({generated: {
              line: generated.line,
              column: generated.column
            }});
          lastOriginalSource = null;
          sourceMappingActive = false;
        }
        chunk.match(REGEX_CHARACTER).forEach(function(ch, idx, array) {
          if (REGEX_NEWLINE.test(ch)) {
            generated.line++;
            generated.column = 0;
            if (idx + 1 === array.length) {
              lastOriginalSource = null;
              sourceMappingActive = false;
            } else if (sourceMappingActive) {
              map.addMapping({
                source: original.source,
                original: {
                  line: original.line,
                  column: original.column
                },
                generated: {
                  line: generated.line,
                  column: generated.column
                },
                name: original.name
              });
            }
          } else {
            generated.column += ch.length;
          }
        });
      });
      this.walkSourceContents(function(sourceFile, sourceContent) {
        map.setSourceContent(sourceFile, sourceContent);
      });
      return {
        code: generated.code,
        map: map
      };
    };
    exports.SourceNode = SourceNode;
  });
  var SourceMapGenerator = m['./source-map-generator'].SourceMapGenerator;
  var SourceMapConsumer = m['./source-map-consumer'].SourceMapConsumer;
  var SourceNode = m['./source-node'].SourceNode;
  var join = m['./util'].join;
  return {
    get SourceMapGenerator() {
      return SourceMapGenerator;
    },
    get SourceMapConsumer() {
      return SourceMapConsumer;
    },
    get SourceNode() {
      return SourceNode;
    },
    get join() {
      return join;
    }
  };
});
System.registerModule("traceur@0.0.80/src/outputgeneration/toSource.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/outputgeneration/toSource.js";
  var ParseTreeMapWriter = System.get("traceur@0.0.80/src/outputgeneration/ParseTreeMapWriter.js").ParseTreeMapWriter;
  var ParseTreeWriter = System.get("traceur@0.0.80/src/outputgeneration/ParseTreeWriter.js").ParseTreeWriter;
  var SourceMapGenerator = System.get("traceur@0.0.80/src/outputgeneration/SourceMapIntegration.js").SourceMapGenerator;
  function toSource(tree) {
    var options = arguments[1];
    var outputName = arguments[2] !== (void 0) ? arguments[2] : '<toSourceOutput>';
    var sourceRoot = arguments[3];
    var sourceMapGenerator = options && options.sourceMapGenerator;
    var sourcemaps = options && options.sourceMaps;
    if (!sourceMapGenerator && sourcemaps) {
      sourceMapGenerator = new SourceMapGenerator({
        file: outputName,
        sourceRoot: sourceRoot
      });
    }
    var writer;
    if (sourceMapGenerator)
      writer = new ParseTreeMapWriter(sourceMapGenerator, sourceRoot, options);
    else
      writer = new ParseTreeWriter(options);
    writer.visitAny(tree);
    return [writer.toString(), sourceMapGenerator && sourceMapGenerator.toString()];
  }
  return {get toSource() {
      return toSource;
    }};
});
System.registerModule("traceur@0.0.80/src/outputgeneration/TreeWriter.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/outputgeneration/TreeWriter.js";
  var toSource = System.get("traceur@0.0.80/src/outputgeneration/toSource.js").toSource;
  function write(tree) {
    var options = arguments[1];
    var outputName = arguments[2] !== (void 0) ? arguments[2] : '<TreeWriter-output>';
    var sourceRoot = arguments[3];
    var $__1 = toSource(tree, options, outputName, sourceRoot),
        result = $__1[0],
        sourceMap = $__1[1];
    if (sourceMap)
      options.generatedSourceMap = sourceMap;
    return result;
  }
  var TreeWriter = function TreeWriter() {};
  ($traceurRuntime.createClass)(TreeWriter, {}, {});
  TreeWriter.write = write;
  return {
    get write() {
      return write;
    },
    get TreeWriter() {
      return TreeWriter;
    }
  };
});
System.registerModule("traceur@0.0.80/src/syntax/ParseTreeValidator.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/syntax/ParseTreeValidator.js";
  var NewExpression = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js").NewExpression;
  var ParseTreeVisitor = System.get("traceur@0.0.80/src/syntax/ParseTreeVisitor.js").ParseTreeVisitor;
  var TreeWriter = System.get("traceur@0.0.80/src/outputgeneration/TreeWriter.js").TreeWriter;
  var $__3 = System.get("traceur@0.0.80/src/syntax/TokenType.js"),
      AMPERSAND = $__3.AMPERSAND,
      AMPERSAND_EQUAL = $__3.AMPERSAND_EQUAL,
      AND = $__3.AND,
      BAR = $__3.BAR,
      BAR_EQUAL = $__3.BAR_EQUAL,
      CARET = $__3.CARET,
      CARET_EQUAL = $__3.CARET_EQUAL,
      CLOSE_ANGLE = $__3.CLOSE_ANGLE,
      EQUAL = $__3.EQUAL,
      EQUAL_EQUAL = $__3.EQUAL_EQUAL,
      EQUAL_EQUAL_EQUAL = $__3.EQUAL_EQUAL_EQUAL,
      GREATER_EQUAL = $__3.GREATER_EQUAL,
      IDENTIFIER = $__3.IDENTIFIER,
      IN = $__3.IN,
      INSTANCEOF = $__3.INSTANCEOF,
      LEFT_SHIFT = $__3.LEFT_SHIFT,
      LEFT_SHIFT_EQUAL = $__3.LEFT_SHIFT_EQUAL,
      LESS_EQUAL = $__3.LESS_EQUAL,
      MINUS = $__3.MINUS,
      MINUS_EQUAL = $__3.MINUS_EQUAL,
      NOT_EQUAL = $__3.NOT_EQUAL,
      NOT_EQUAL_EQUAL = $__3.NOT_EQUAL_EQUAL,
      NUMBER = $__3.NUMBER,
      OPEN_ANGLE = $__3.OPEN_ANGLE,
      OR = $__3.OR,
      PERCENT = $__3.PERCENT,
      PERCENT_EQUAL = $__3.PERCENT_EQUAL,
      PLUS = $__3.PLUS,
      PLUS_EQUAL = $__3.PLUS_EQUAL,
      RIGHT_SHIFT = $__3.RIGHT_SHIFT,
      RIGHT_SHIFT_EQUAL = $__3.RIGHT_SHIFT_EQUAL,
      SLASH = $__3.SLASH,
      SLASH_EQUAL = $__3.SLASH_EQUAL,
      STAR = $__3.STAR,
      STAR_EQUAL = $__3.STAR_EQUAL,
      STAR_STAR = $__3.STAR_STAR,
      STAR_STAR_EQUAL = $__3.STAR_STAR_EQUAL,
      STRING = $__3.STRING,
      UNSIGNED_RIGHT_SHIFT = $__3.UNSIGNED_RIGHT_SHIFT,
      UNSIGNED_RIGHT_SHIFT_EQUAL = $__3.UNSIGNED_RIGHT_SHIFT_EQUAL;
  var $__4 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      ARRAY_PATTERN = $__4.ARRAY_PATTERN,
      ASSIGNMENT_ELEMENT = $__4.ASSIGNMENT_ELEMENT,
      BINDING_ELEMENT = $__4.BINDING_ELEMENT,
      BINDING_IDENTIFIER = $__4.BINDING_IDENTIFIER,
      BLOCK = $__4.BLOCK,
      CASE_CLAUSE = $__4.CASE_CLAUSE,
      CATCH = $__4.CATCH,
      CLASS_DECLARATION = $__4.CLASS_DECLARATION,
      COMPUTED_PROPERTY_NAME = $__4.COMPUTED_PROPERTY_NAME,
      DEFAULT_CLAUSE = $__4.DEFAULT_CLAUSE,
      EXPORT_DEFAULT = $__4.EXPORT_DEFAULT,
      EXPORT_SPECIFIER = $__4.EXPORT_SPECIFIER,
      EXPORT_SPECIFIER_SET = $__4.EXPORT_SPECIFIER_SET,
      EXPORT_STAR = $__4.EXPORT_STAR,
      FINALLY = $__4.FINALLY,
      FORMAL_PARAMETER = $__4.FORMAL_PARAMETER,
      FORMAL_PARAMETER_LIST = $__4.FORMAL_PARAMETER_LIST,
      FUNCTION_BODY = $__4.FUNCTION_BODY,
      FUNCTION_DECLARATION = $__4.FUNCTION_DECLARATION,
      GET_ACCESSOR = $__4.GET_ACCESSOR,
      IDENTIFIER_EXPRESSION = $__4.IDENTIFIER_EXPRESSION,
      IMPORTED_BINDING = $__4.IMPORTED_BINDING,
      LITERAL_PROPERTY_NAME = $__4.LITERAL_PROPERTY_NAME,
      MODULE_DECLARATION = $__4.MODULE_DECLARATION,
      MODULE_SPECIFIER = $__4.MODULE_SPECIFIER,
      NAMED_EXPORT = $__4.NAMED_EXPORT,
      OBJECT_PATTERN = $__4.OBJECT_PATTERN,
      OBJECT_PATTERN_FIELD = $__4.OBJECT_PATTERN_FIELD,
      PROPERTY_METHOD_ASSIGNMENT = $__4.PROPERTY_METHOD_ASSIGNMENT,
      PROPERTY_NAME_ASSIGNMENT = $__4.PROPERTY_NAME_ASSIGNMENT,
      PROPERTY_NAME_SHORTHAND = $__4.PROPERTY_NAME_SHORTHAND,
      PROPERTY_VARIABLE_DECLARATION = $__4.PROPERTY_VARIABLE_DECLARATION,
      REST_PARAMETER = $__4.REST_PARAMETER,
      SET_ACCESSOR = $__4.SET_ACCESSOR,
      TEMPLATE_LITERAL_PORTION = $__4.TEMPLATE_LITERAL_PORTION,
      TEMPLATE_SUBSTITUTION = $__4.TEMPLATE_SUBSTITUTION,
      TYPE_ARGUMENTS = $__4.TYPE_ARGUMENTS,
      TYPE_NAME = $__4.TYPE_NAME,
      TYPE_PARAMETER = $__4.TYPE_PARAMETER,
      TYPE_PARAMETERS = $__4.TYPE_PARAMETERS,
      VARIABLE_DECLARATION_LIST = $__4.VARIABLE_DECLARATION_LIST,
      VARIABLE_STATEMENT = $__4.VARIABLE_STATEMENT;
  var assert = System.get("traceur@0.0.80/src/util/assert.js").assert;
  var ValidationError = function ValidationError(tree, message) {
    this.tree = tree;
    this.message = message;
  };
  ($traceurRuntime.createClass)(ValidationError, {}, {}, Error);
  var ParseTreeValidator = function ParseTreeValidator() {
    $traceurRuntime.superConstructor($ParseTreeValidator).apply(this, arguments);
  };
  var $ParseTreeValidator = ParseTreeValidator;
  ($traceurRuntime.createClass)(ParseTreeValidator, {
    fail_: function(tree, message) {
      throw new ValidationError(tree, message);
    },
    check_: function(condition, tree, message) {
      if (!condition) {
        this.fail_(tree, message);
      }
    },
    checkVisit_: function(condition, tree, message) {
      this.check_(condition, tree, message);
      this.visitAny(tree);
    },
    checkType_: function(type, tree, message) {
      this.checkVisit_(tree.type === type, tree, message);
    },
    visitArgumentList: function(tree) {
      for (var i = 0; i < tree.args.length; i++) {
        var argument = tree.args[i];
        this.checkVisit_(argument.isAssignmentOrSpread(), argument, 'assignment or spread expected');
      }
    },
    visitArrayLiteralExpression: function(tree) {
      for (var i = 0; i < tree.elements.length; i++) {
        var element = tree.elements[i];
        this.checkVisit_(element === null || element.isAssignmentOrSpread(), element, 'assignment or spread expected');
      }
    },
    visitArrayPattern: function(tree) {
      for (var i = 0; i < tree.elements.length; i++) {
        var element = tree.elements[i];
        this.checkVisit_(element === null || element.type === BINDING_ELEMENT || element.type == ASSIGNMENT_ELEMENT || element.isLeftHandSideExpression() || element.isPattern() || element.isSpreadPatternElement(), element, 'null, sub pattern, left hand side expression or spread expected');
        if (element && element.isSpreadPatternElement()) {
          this.check_(i === (tree.elements.length - 1), element, 'spread in array patterns must be the last element');
        }
      }
    },
    visitBinaryExpression: function(tree) {
      switch (tree.operator.type) {
        case EQUAL:
        case STAR_EQUAL:
        case STAR_STAR_EQUAL:
        case SLASH_EQUAL:
        case PERCENT_EQUAL:
        case PLUS_EQUAL:
        case MINUS_EQUAL:
        case LEFT_SHIFT_EQUAL:
        case RIGHT_SHIFT_EQUAL:
        case UNSIGNED_RIGHT_SHIFT_EQUAL:
        case AMPERSAND_EQUAL:
        case CARET_EQUAL:
        case BAR_EQUAL:
          this.check_(tree.left.isLeftHandSideExpression() || tree.left.isPattern(), tree.left, 'left hand side expression or pattern expected');
          this.check_(tree.right.isAssignmentExpression(), tree.right, 'assignment expression expected');
          break;
        case AND:
        case OR:
        case BAR:
        case CARET:
        case AMPERSAND:
        case EQUAL_EQUAL:
        case NOT_EQUAL:
        case EQUAL_EQUAL_EQUAL:
        case NOT_EQUAL_EQUAL:
        case OPEN_ANGLE:
        case CLOSE_ANGLE:
        case GREATER_EQUAL:
        case LESS_EQUAL:
        case INSTANCEOF:
        case IN:
        case LEFT_SHIFT:
        case RIGHT_SHIFT:
        case UNSIGNED_RIGHT_SHIFT:
        case PLUS:
        case MINUS:
        case STAR:
        case SLASH:
        case PERCENT:
        case STAR_STAR:
          this.check_(tree.left.isAssignmentExpression(), tree.left, 'assignment expression expected');
          this.check_(tree.right.isAssignmentExpression(), tree.right, 'assignment expression expected');
          break;
        default:
          this.fail_(tree, 'unexpected binary operator');
      }
      this.visitAny(tree.left);
      this.visitAny(tree.right);
    },
    visitBindingElement: function(tree) {
      var binding = tree.binding;
      this.checkVisit_(binding.type == BINDING_IDENTIFIER || binding.type == OBJECT_PATTERN || binding.type == ARRAY_PATTERN, binding, 'expected valid binding element');
      this.visitAny(tree.initializer);
    },
    visitAssignmentElement: function(tree) {
      var assignment = tree.assignment;
      this.checkVisit_(assignment.type == OBJECT_PATTERN || assignment.type == ARRAY_PATTERN || assignment.isLeftHandSideExpression(), assignment, 'expected valid assignment element');
      this.visitAny(tree.initializer);
    },
    visitBlock: function(tree) {
      for (var i = 0; i < tree.statements.length; i++) {
        var statement = tree.statements[i];
        this.checkVisit_(statement.isStatementListItem(), statement, 'statement or function declaration expected');
      }
    },
    visitCallExpression: function(tree) {
      this.check_(tree.operand.isMemberExpression(), tree.operand, 'member expression expected');
      if (tree.operand instanceof NewExpression) {
        this.check_(tree.operand.args !== null, tree.operand, 'new args expected');
      }
      this.visitAny(tree.operand);
      this.visitAny(tree.args);
    },
    visitCaseClause: function(tree) {
      this.checkVisit_(tree.expression.isExpression(), tree.expression, 'expression expected');
      for (var i = 0; i < tree.statements.length; i++) {
        var statement = tree.statements[i];
        this.checkVisit_(statement.isStatement(), statement, 'statement expected');
      }
    },
    visitCatch: function(tree) {
      this.checkVisit_(tree.binding.isPattern() || tree.binding.type == BINDING_IDENTIFIER, tree.binding, 'binding identifier expected');
      this.checkVisit_(tree.catchBody.type === BLOCK, tree.catchBody, 'block expected');
    },
    visitClassDeclaration: function(tree) {
      this.visitClassShared_(tree);
    },
    visitClassExpression: function(tree) {
      this.visitClassShared_(tree);
    },
    visitClassShared_: function(tree) {
      if (tree.typeParameters) {
        this.checkVisit_(tree.typeParameters.type == TYPE_PARAMETERS, tree.typeParameters, 'type parameters expected');
      }
      for (var i = 0; i < tree.elements.length; i++) {
        var element = tree.elements[i];
        switch (element.type) {
          case GET_ACCESSOR:
          case SET_ACCESSOR:
          case PROPERTY_METHOD_ASSIGNMENT:
          case PROPERTY_VARIABLE_DECLARATION:
            break;
          default:
            this.fail_(element, 'class element expected');
        }
        this.visitAny(element);
      }
    },
    visitCommaExpression: function(tree) {
      for (var i = 0; i < tree.expressions.length; i++) {
        var expression = tree.expressions[i];
        this.checkVisit_(expression.isAssignmentExpression(), expression, 'expression expected');
      }
    },
    visitConditionalExpression: function(tree) {
      this.checkVisit_(tree.condition.isAssignmentExpression(), tree.condition, 'expression expected');
      this.checkVisit_(tree.left.isAssignmentExpression(), tree.left, 'expression expected');
      this.checkVisit_(tree.right.isAssignmentExpression(), tree.right, 'expression expected');
    },
    visitCoverFormals: function(tree) {
      this.fail_(tree, 'CoverFormals should have been removed');
    },
    visitCoverInitializedName: function(tree) {
      this.fail_(tree, 'CoverInitializedName should have been removed');
    },
    visitDefaultClause: function(tree) {
      for (var i = 0; i < tree.statements.length; i++) {
        var statement = tree.statements[i];
        this.checkVisit_(statement.isStatement(), statement, 'statement expected');
      }
    },
    visitDoWhileStatement: function(tree) {
      this.checkVisit_(tree.body.isStatement(), tree.body, 'statement expected');
      this.checkVisit_(tree.condition.isExpression(), tree.condition, 'expression expected');
    },
    visitExportDeclaration: function(tree) {
      var declType = tree.declaration.type;
      this.checkVisit_(declType == VARIABLE_STATEMENT || declType == FUNCTION_DECLARATION || declType == MODULE_DECLARATION || declType == CLASS_DECLARATION || declType == NAMED_EXPORT || declType == EXPORT_DEFAULT, tree.declaration, 'expected valid export tree');
    },
    visitNamedExport: function(tree) {
      if (tree.moduleSpecifier) {
        this.checkVisit_(tree.moduleSpecifier.type == MODULE_SPECIFIER, tree.moduleSpecifier, 'module expression expected');
      }
      var specifierType = tree.specifierSet.type;
      this.checkVisit_(specifierType == EXPORT_SPECIFIER_SET || specifierType == EXPORT_STAR, tree.specifierSet, 'specifier set or identifier expected');
    },
    visitExportSpecifierSet: function(tree) {
      this.check_(tree.specifiers.length > 0, tree, 'expected at least one identifier');
      for (var i = 0; i < tree.specifiers.length; i++) {
        var specifier = tree.specifiers[i];
        this.checkVisit_(specifier.type == EXPORT_SPECIFIER || specifier.type == IDENTIFIER_EXPRESSION, specifier, 'expected valid export specifier');
      }
    },
    visitExpressionStatement: function(tree) {
      this.checkVisit_(tree.expression.isExpression(), tree.expression, 'expression expected');
    },
    visitFinally: function(tree) {
      this.checkVisit_(tree.block.type === BLOCK, tree.block, 'block expected');
    },
    visitForOfStatement: function(tree) {
      this.checkVisit_(tree.initializer.isPattern() || tree.initializer.type === IDENTIFIER_EXPRESSION || tree.initializer.type === VARIABLE_DECLARATION_LIST && tree.initializer.declarations.length === 1, tree.initializer, 'for-each statement may not have more than one variable declaration');
      this.checkVisit_(tree.collection.isExpression(), tree.collection, 'expression expected');
      this.checkVisit_(tree.body.isStatement(), tree.body, 'statement expected');
    },
    visitForInStatement: function(tree) {
      if (tree.initializer.type === VARIABLE_DECLARATION_LIST) {
        this.checkVisit_(tree.initializer.declarations.length <= 1, tree.initializer, 'for-in statement may not have more than one variable declaration');
      } else {
        this.checkVisit_(tree.initializer.isPattern() || tree.initializer.isExpression(), tree.initializer, 'variable declaration, expression or ' + 'pattern expected');
      }
      this.checkVisit_(tree.collection.isExpression(), tree.collection, 'expression expected');
      this.checkVisit_(tree.body.isStatement(), tree.body, 'statement expected');
    },
    visitFormalParameterList: function(tree) {
      for (var i = 0; i < tree.parameters.length; i++) {
        var parameter = tree.parameters[i];
        assert(parameter.type === FORMAL_PARAMETER);
        parameter = parameter.parameter;
        switch (parameter.type) {
          case BINDING_ELEMENT:
            break;
          case REST_PARAMETER:
            this.checkVisit_(i === tree.parameters.length - 1, parameter, 'rest parameters must be the last parameter in a parameter list');
            this.checkType_(BINDING_IDENTIFIER, parameter.identifier, 'binding identifier expected');
            break;
          default:
            this.fail_(parameter, 'parameters must be identifiers or rest' + (" parameters. Found: " + parameter.type));
            break;
        }
        this.visitAny(parameter);
      }
    },
    visitForStatement: function(tree) {
      if (tree.initializer !== null) {
        this.checkVisit_(tree.initializer.isExpression() || tree.initializer.type === VARIABLE_DECLARATION_LIST, tree.initializer, 'variable declaration list or expression expected');
      }
      if (tree.condition !== null) {
        this.checkVisit_(tree.condition.isExpression(), tree.condition, 'expression expected');
      }
      if (tree.increment !== null) {
        this.checkVisit_(tree.increment.isExpression(), tree.increment, 'expression expected');
      }
      this.checkVisit_(tree.body.isStatement(), tree.body, 'statement expected');
    },
    visitFunctionBody: function(tree) {
      for (var i = 0; i < tree.statements.length; i++) {
        var statement = tree.statements[i];
        this.checkVisit_(statement.isStatementListItem(), statement, 'statement expected');
      }
    },
    visitFunctionDeclaration: function(tree) {
      this.checkType_(BINDING_IDENTIFIER, tree.name, 'binding identifier expected');
      this.visitFunction_(tree);
    },
    visitFunctionExpression: function(tree) {
      if (tree.name !== null) {
        this.checkType_(BINDING_IDENTIFIER, tree.name, 'binding identifier expected');
      }
      this.visitFunction_(tree);
    },
    visitFunction_: function(tree) {
      this.checkType_(FORMAL_PARAMETER_LIST, tree.parameterList, 'formal parameters expected');
      this.checkType_(FUNCTION_BODY, tree.body, 'function body expected');
    },
    visitGetAccessor: function(tree) {
      this.checkPropertyName_(tree.name);
      this.checkType_(FUNCTION_BODY, tree.body, 'function body expected');
    },
    visitIfStatement: function(tree) {
      this.checkVisit_(tree.condition.isExpression(), tree.condition, 'expression expected');
      this.checkVisit_(tree.ifClause.isStatement(), tree.ifClause, 'statement expected');
      if (tree.elseClause !== null) {
        this.checkVisit_(tree.elseClause.isStatement(), tree.elseClause, 'statement expected');
      }
    },
    visitImportSpecifier: function(tree) {
      this.checkType_(IMPORTED_BINDING, tree.binding, 'ImportedBinding expected');
    },
    visitImportedBinding: function(tree) {
      this.checkType_(BINDING_IDENTIFIER, tree.binding, 'binding identifier expected');
    },
    visitLabelledStatement: function(tree) {
      this.checkVisit_(tree.statement.isStatement(), tree.statement, 'statement expected');
    },
    visitMemberExpression: function(tree) {
      this.check_(tree.operand.isMemberExpression(), tree.operand, 'member expression expected');
      if (tree.operand instanceof NewExpression) {
        this.check_(tree.operand.args !== null, tree.operand, 'new args expected');
      }
      this.visitAny(tree.operand);
    },
    visitMemberLookupExpression: function(tree) {
      this.check_(tree.operand.isMemberExpression(), tree.operand, 'member expression expected');
      if (tree.operand instanceof NewExpression) {
        this.check_(tree.operand.args !== null, tree.operand, 'new args expected');
      }
      this.visitAny(tree.operand);
    },
    visitSyntaxErrorTree: function(tree) {
      this.fail_(tree, ("parse tree contains SyntaxError: " + tree.message));
    },
    visitModuleSpecifier: function(tree) {
      this.check_(tree.token.type == STRING || tree.moduleName, 'string or identifier expected');
    },
    visitModuleDeclaration: function(tree) {
      this.checkType_(IMPORTED_BINDING, tree.binding, 'ImportedBinding expected');
      this.checkType_(MODULE_SPECIFIER, tree.expression, 'module expression expected');
    },
    visitNewExpression: function(tree) {
      this.checkVisit_(tree.operand.isMemberExpression(), tree.operand, 'member expression expected');
      this.visitAny(tree.args);
    },
    visitObjectLiteralExpression: function(tree) {
      for (var i = 0; i < tree.propertyNameAndValues.length; i++) {
        var propertyNameAndValue = tree.propertyNameAndValues[i];
        switch (propertyNameAndValue.type) {
          case GET_ACCESSOR:
          case SET_ACCESSOR:
          case PROPERTY_METHOD_ASSIGNMENT:
            this.check_(!propertyNameAndValue.isStatic, propertyNameAndValue, 'static is not allowed in object literal expression');
          case PROPERTY_NAME_ASSIGNMENT:
          case PROPERTY_NAME_SHORTHAND:
            break;
          default:
            this.fail_(propertyNameAndValue, 'accessor, property name ' + 'assignment or property method assigment expected');
        }
        this.visitAny(propertyNameAndValue);
      }
    },
    visitObjectPattern: function(tree) {
      for (var i = 0; i < tree.fields.length; i++) {
        var field = tree.fields[i];
        this.checkVisit_(field.type === OBJECT_PATTERN_FIELD || field.type === ASSIGNMENT_ELEMENT || field.type === BINDING_ELEMENT, field, 'object pattern field expected');
      }
    },
    visitObjectPatternField: function(tree) {
      this.checkPropertyName_(tree.name);
      this.checkVisit_(tree.element.type === ASSIGNMENT_ELEMENT || tree.element.type === BINDING_ELEMENT || tree.element.isPattern() || tree.element.isLeftHandSideExpression(), tree.element, 'binding element expected');
    },
    visitParenExpression: function(tree) {
      if (tree.expression.isPattern()) {
        this.visitAny(tree.expression);
      } else {
        this.checkVisit_(tree.expression.isExpression(), tree.expression, 'expression expected');
      }
    },
    visitPostfixExpression: function(tree) {
      this.checkVisit_(tree.operand.isAssignmentExpression(), tree.operand, 'assignment expression expected');
    },
    visitPredefinedType: function(tree) {},
    visitScript: function(tree) {
      for (var i = 0; i < tree.scriptItemList.length; i++) {
        var scriptItemList = tree.scriptItemList[i];
        this.checkVisit_(scriptItemList.isScriptElement(), scriptItemList, 'global script item expected');
      }
    },
    checkPropertyName_: function(tree) {
      this.checkVisit_(tree.type === LITERAL_PROPERTY_NAME || tree.type === COMPUTED_PROPERTY_NAME, tree, 'property name expected');
    },
    visitPropertyNameAssignment: function(tree) {
      this.checkPropertyName_(tree.name);
      this.checkVisit_(tree.value.isAssignmentExpression(), tree.value, 'assignment expression expected');
    },
    visitPropertyNameShorthand: function(tree) {
      this.check_(tree.name.type === IDENTIFIER, tree, 'identifier token expected');
    },
    visitLiteralPropertyName: function(tree) {
      var type = tree.literalToken.type;
      this.check_(tree.literalToken.isKeyword() || type === IDENTIFIER || type === NUMBER || type === STRING, tree, 'Unexpected token in literal property name');
    },
    visitTemplateLiteralExpression: function(tree) {
      if (tree.operand) {
        this.checkVisit_(tree.operand.isMemberExpression(), tree.operand, 'member or call expression expected');
      }
      for (var i = 0; i < tree.elements.length; i++) {
        var element = tree.elements[i];
        if (i % 2) {
          this.checkType_(TEMPLATE_SUBSTITUTION, element, 'Template literal substitution expected');
        } else {
          this.checkType_(TEMPLATE_LITERAL_PORTION, element, 'Template literal portion expected');
        }
      }
    },
    visitReturnStatement: function(tree) {
      if (tree.expression !== null) {
        this.checkVisit_(tree.expression.isExpression(), tree.expression, 'expression expected');
      }
    },
    visitSetAccessor: function(tree) {
      this.checkPropertyName_(tree.name);
      this.checkType_(FUNCTION_BODY, tree.body, 'function body expected');
    },
    visitSpreadExpression: function(tree) {
      this.checkVisit_(tree.expression.isAssignmentExpression(), tree.expression, 'assignment expression expected');
    },
    visitStateMachine: function(tree) {
      this.fail_(tree, 'State machines are never valid outside of the ' + 'GeneratorTransformer pass.');
    },
    visitSwitchStatement: function(tree) {
      this.checkVisit_(tree.expression.isExpression(), tree.expression, 'expression expected');
      var defaultCount = 0;
      for (var i = 0; i < tree.caseClauses.length; i++) {
        var caseClause = tree.caseClauses[i];
        if (caseClause.type === DEFAULT_CLAUSE) {
          ++defaultCount;
          this.checkVisit_(defaultCount <= 1, caseClause, 'no more than one default clause allowed');
        } else {
          this.checkType_(CASE_CLAUSE, caseClause, 'case or default clause expected');
        }
      }
    },
    visitThrowStatement: function(tree) {
      if (tree.value === null) {
        return;
      }
      this.checkVisit_(tree.value.isExpression(), tree.value, 'expression expected');
    },
    visitTryStatement: function(tree) {
      this.checkType_(BLOCK, tree.body, 'block expected');
      if (tree.catchBlock !== null) {
        this.checkType_(CATCH, tree.catchBlock, 'catch block expected');
      }
      if (tree.finallyBlock !== null) {
        this.checkType_(FINALLY, tree.finallyBlock, 'finally block expected');
      }
      if (tree.catchBlock === null && tree.finallyBlock === null) {
        this.fail_(tree, 'either catch or finally must be present');
      }
    },
    visitTypeArguments: function(tree) {
      var args = tree.args;
      for (var i = 0; i < args.length; i++) {
        this.checkVisit_(args[i].isType(), args[i], 'Type arguments must be type expressions');
      }
    },
    visitTypeName: function(tree) {
      this.checkVisit_(tree.moduleName === null || tree.moduleName.type === TYPE_NAME, tree.moduleName, 'moduleName must be null or a TypeName');
      this.check_(tree.name.type === IDENTIFIER, tree, 'name must be an identifier');
    },
    visitTypeReference: function(tree) {
      this.checkType_(TYPE_NAME, tree.typeName, 'typeName must be a TypeName');
      this.checkType_(TYPE_ARGUMENTS, tree.args, 'args must be a TypeArguments');
    },
    visitTypeParameters: function(tree) {
      var parameters = tree.parameters;
      for (var i = 0; i < parameters.length; i++) {
        this.checkType_(TYPE_PARAMETER, parameters[i], 'Type parameters must all be type parameters');
      }
    },
    visitTypeParameter: function(tree) {
      this.check_(tree.identifierToken.type === IDENTIFIER, tree, 'Type parameter must be an identifier token');
      if (tree.extendsType) {
        this.checkVisit_(tree.extendsType.isType(), tree.extendsType, 'extends type must be a type expression');
      }
    },
    visitUnaryExpression: function(tree) {
      this.checkVisit_(tree.operand.isAssignmentExpression(), tree.operand, 'assignment expression expected');
    },
    visitVariableDeclaration: function(tree) {
      this.checkVisit_(tree.lvalue.isPattern() || tree.lvalue.type == BINDING_IDENTIFIER, tree.lvalue, 'binding identifier expected, found: ' + tree.lvalue.type);
      if (tree.initializer !== null) {
        this.checkVisit_(tree.initializer.isAssignmentExpression(), tree.initializer, 'assignment expression expected');
      }
    },
    visitWhileStatement: function(tree) {
      this.checkVisit_(tree.condition.isExpression(), tree.condition, 'expression expected');
      this.checkVisit_(tree.body.isStatement(), tree.body, 'statement expected');
    },
    visitWithStatement: function(tree) {
      this.checkVisit_(tree.expression.isExpression(), tree.expression, 'expression expected');
      this.checkVisit_(tree.body.isStatement(), tree.body, 'statement expected');
    },
    visitYieldExpression: function(tree) {
      if (tree.expression !== null) {
        this.checkVisit_(tree.expression.isExpression(), tree.expression, 'expression expected');
      }
    }
  }, {}, ParseTreeVisitor);
  ParseTreeValidator.validate = function(tree) {
    var validator = new ParseTreeValidator();
    try {
      validator.visitAny(tree);
    } catch (e) {
      if (!(e instanceof ValidationError)) {
        throw e;
      }
      var location = null;
      if (e.tree !== null) {
        location = e.tree.location;
      }
      if (location === null) {
        location = tree.location;
      }
      var locationString = location !== null ? location.start.toString() : '(unknown)';
      throw new Error(("Parse tree validation failure '" + e.message + "' at " + locationString + ":") + '\n\n' + TreeWriter.write(tree, {
        highlighted: e.tree,
        showLineNumbers: true
      }) + '\n');
    }
  };
  return {get ParseTreeValidator() {
      return ParseTreeValidator;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/MultiTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/MultiTransformer.js";
  var ParseTreeValidator = System.get("traceur@0.0.80/src/syntax/ParseTreeValidator.js").ParseTreeValidator;
  var MultiTransformer = function MultiTransformer(reporter, validate) {
    this.reporter_ = reporter;
    this.validate_ = validate;
    this.treeTransformers_ = [];
  };
  ($traceurRuntime.createClass)(MultiTransformer, {
    append: function(treeTransformer) {
      this.treeTransformers_.push(treeTransformer);
    },
    transform: function(tree) {
      var reporter = this.reporter_;
      var validate = this.validate_;
      this.treeTransformers_.every((function(transformTree) {
        tree = transformTree(tree);
        if (reporter.hadError())
          return false;
        if (validate)
          ParseTreeValidator.validate(tree);
        return true;
      }));
      return tree;
    }
  }, {});
  return {get MultiTransformer() {
      return MultiTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/NumericLiteralTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/NumericLiteralTransformer.js";
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var $__1 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      LiteralExpression = $__1.LiteralExpression,
      LiteralPropertyName = $__1.LiteralPropertyName;
  var LiteralToken = System.get("traceur@0.0.80/src/syntax/LiteralToken.js").LiteralToken;
  var NUMBER = System.get("traceur@0.0.80/src/syntax/TokenType.js").NUMBER;
  function needsTransform(token) {
    return token.type === NUMBER && /^0[bBoO]/.test(token.value);
  }
  function transformToken(token) {
    return new LiteralToken(NUMBER, String(token.processedValue), token.location);
  }
  var NumericLiteralTransformer = function NumericLiteralTransformer() {
    $traceurRuntime.superConstructor($NumericLiteralTransformer).apply(this, arguments);
  };
  var $NumericLiteralTransformer = NumericLiteralTransformer;
  ($traceurRuntime.createClass)(NumericLiteralTransformer, {
    transformLiteralExpression: function(tree) {
      var token = tree.literalToken;
      if (needsTransform(token))
        return new LiteralExpression(tree.location, transformToken(token));
      return tree;
    },
    transformLiteralPropertyName: function(tree) {
      var token = tree.literalToken;
      if (needsTransform(token))
        return new LiteralPropertyName(tree.location, transformToken(token));
      return tree;
    }
  }, {}, ParseTreeTransformer);
  return {get NumericLiteralTransformer() {
      return NumericLiteralTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/ObjectLiteralTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/ObjectLiteralTransformer.js";
  var FindVisitor = System.get("traceur@0.0.80/src/codegeneration/FindVisitor.js").FindVisitor;
  var $__1 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      FunctionExpression = $__1.FunctionExpression,
      IdentifierExpression = $__1.IdentifierExpression,
      LiteralExpression = $__1.LiteralExpression;
  var TempVarTransformer = System.get("traceur@0.0.80/src/codegeneration/TempVarTransformer.js").TempVarTransformer;
  var IDENTIFIER = System.get("traceur@0.0.80/src/syntax/TokenType.js").IDENTIFIER;
  var $__4 = System.get("traceur@0.0.80/src/syntax/trees/ParseTreeType.js"),
      COMPUTED_PROPERTY_NAME = $__4.COMPUTED_PROPERTY_NAME,
      LITERAL_PROPERTY_NAME = $__4.LITERAL_PROPERTY_NAME;
  var $__5 = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js"),
      createAssignmentExpression = $__5.createAssignmentExpression,
      createCommaExpression = $__5.createCommaExpression,
      createDefineProperty = $__5.createDefineProperty,
      createEmptyParameterList = $__5.createEmptyParameterList,
      createFunctionExpression = $__5.createFunctionExpression,
      createIdentifierExpression = $__5.createIdentifierExpression,
      createObjectCreate = $__5.createObjectCreate,
      createObjectLiteralExpression = $__5.createObjectLiteralExpression,
      createParenExpression = $__5.createParenExpression,
      createPropertyNameAssignment = $__5.createPropertyNameAssignment,
      createStringLiteral = $__5.createStringLiteral;
  var propName = System.get("traceur@0.0.80/src/staticsemantics/PropName.js").propName;
  var transformOptions = System.get("traceur@0.0.80/src/Options.js").transformOptions;
  var FindAdvancedProperty = function FindAdvancedProperty() {
    $traceurRuntime.superConstructor($FindAdvancedProperty).call(this, true);
    this.protoExpression = null;
  };
  var $FindAdvancedProperty = FindAdvancedProperty;
  ($traceurRuntime.createClass)(FindAdvancedProperty, {
    visitPropertyNameAssignment: function(tree) {
      if (isProtoName(tree.name))
        this.protoExpression = tree.value;
      else
        $traceurRuntime.superGet(this, $FindAdvancedProperty.prototype, "visitPropertyNameAssignment").call(this, tree);
    },
    visitComputedPropertyName: function(tree) {
      if (transformOptions.computedPropertyNames)
        this.found = true;
    }
  }, {}, FindVisitor);
  function isProtoName(tree) {
    return propName(tree) === '__proto__';
  }
  var ObjectLiteralTransformer = function ObjectLiteralTransformer(identifierGenerator) {
    $traceurRuntime.superConstructor($ObjectLiteralTransformer).call(this, identifierGenerator);
    this.protoExpression = null;
    this.needsAdvancedTransform = false;
    this.seenAccessors = null;
  };
  var $ObjectLiteralTransformer = ObjectLiteralTransformer;
  ($traceurRuntime.createClass)(ObjectLiteralTransformer, {
    findSeenAccessor_: function(name) {
      if (name.type === COMPUTED_PROPERTY_NAME)
        return null;
      var s = propName(name);
      return this.seenAccessors[s];
    },
    removeSeenAccessor_: function(name) {
      if (name.type === COMPUTED_PROPERTY_NAME)
        return;
      var s = propName(name);
      delete this.seenAccessors[s];
    },
    addSeenAccessor_: function(name, descr) {
      if (name.type === COMPUTED_PROPERTY_NAME)
        return;
      var s = propName(name);
      this.seenAccessors[s] = descr;
    },
    createProperty_: function(name, descr) {
      var expression;
      if (name.type === LITERAL_PROPERTY_NAME) {
        if (this.needsAdvancedTransform)
          expression = this.getPropertyName_(name);
        else
          expression = name;
      } else {
        expression = name.expression;
      }
      if (descr.get || descr.set) {
        var oldAccessor = this.findSeenAccessor_(name);
        if (oldAccessor) {
          oldAccessor.get = descr.get || oldAccessor.get;
          oldAccessor.set = descr.set || oldAccessor.set;
          this.removeSeenAccessor_(name);
          return null;
        } else {
          this.addSeenAccessor_(name, descr);
        }
      }
      return [expression, descr];
    },
    getPropertyName_: function(nameTree) {
      var token = nameTree.literalToken;
      switch (token.type) {
        case IDENTIFIER:
          return createStringLiteral(token.value);
        default:
          if (token.isKeyword())
            return createStringLiteral(token.type);
          return new LiteralExpression(token.location, token);
      }
    },
    transformClassDeclaration: function(tree) {
      return tree;
    },
    transformClassExpression: function(tree) {
      return tree;
    },
    transformObjectLiteralExpression: function(tree) {
      var oldNeedsTransform = this.needsAdvancedTransform;
      var oldSeenAccessors = this.seenAccessors;
      try {
        var finder = new FindAdvancedProperty();
        finder.visitAny(tree);
        if (!finder.found) {
          this.needsAdvancedTransform = false;
          return $traceurRuntime.superGet(this, $ObjectLiteralTransformer.prototype, "transformObjectLiteralExpression").call(this, tree);
        }
        this.needsAdvancedTransform = true;
        this.seenAccessors = Object.create(null);
        var properties = this.transformList(tree.propertyNameAndValues);
        properties = properties.filter((function(tree) {
          return tree;
        }));
        var tempVar = this.addTempVar();
        var tempVarIdentifierExpression = createIdentifierExpression(tempVar);
        var expressions = properties.map((function(property) {
          var expression = property[0];
          var descr = property[1];
          return createDefineProperty(tempVarIdentifierExpression, expression, descr);
        }));
        var protoExpression = this.transformAny(finder.protoExpression);
        var objectExpression;
        if (protoExpression)
          objectExpression = createObjectCreate(protoExpression);
        else
          objectExpression = createObjectLiteralExpression([]);
        expressions.unshift(createAssignmentExpression(tempVarIdentifierExpression, objectExpression));
        expressions.push(tempVarIdentifierExpression);
        return createParenExpression(createCommaExpression(expressions));
      } finally {
        this.needsAdvancedTransform = oldNeedsTransform;
        this.seenAccessors = oldSeenAccessors;
      }
    },
    transformPropertyNameAssignment: function(tree) {
      if (!this.needsAdvancedTransform)
        return $traceurRuntime.superGet(this, $ObjectLiteralTransformer.prototype, "transformPropertyNameAssignment").call(this, tree);
      if (isProtoName(tree.name))
        return null;
      return this.createProperty_(tree.name, {
        value: this.transformAny(tree.value),
        configurable: true,
        enumerable: true,
        writable: true
      });
    },
    transformGetAccessor: function(tree) {
      if (!this.needsAdvancedTransform)
        return $traceurRuntime.superGet(this, $ObjectLiteralTransformer.prototype, "transformGetAccessor").call(this, tree);
      var body = this.transformAny(tree.body);
      var func = createFunctionExpression(createEmptyParameterList(), body);
      return this.createProperty_(tree.name, {
        get: func,
        configurable: true,
        enumerable: true
      });
    },
    transformSetAccessor: function(tree) {
      if (!this.needsAdvancedTransform)
        return $traceurRuntime.superGet(this, $ObjectLiteralTransformer.prototype, "transformSetAccessor").call(this, tree);
      var body = this.transformAny(tree.body);
      var parameterList = this.transformAny(tree.parameterList);
      var func = createFunctionExpression(parameterList, body);
      return this.createProperty_(tree.name, {
        set: func,
        configurable: true,
        enumerable: true
      });
    },
    transformPropertyMethodAssignment: function(tree) {
      var func = new FunctionExpression(tree.location, null, tree.functionKind, this.transformAny(tree.parameterList), tree.typeAnnotation, [], this.transformAny(tree.body));
      if (!this.needsAdvancedTransform) {
        return createPropertyNameAssignment(tree.name, func);
      }
      var expression = this.transformAny(tree.name);
      return this.createProperty_(tree.name, {
        value: func,
        configurable: true,
        enumerable: true,
        writable: true
      });
    },
    transformPropertyNameShorthand: function(tree) {
      if (!this.needsAdvancedTransform)
        return $traceurRuntime.superGet(this, $ObjectLiteralTransformer.prototype, "transformPropertyNameShorthand").call(this, tree);
      var expression = this.transformAny(tree.name);
      return this.createProperty_(tree.name, {
        value: new IdentifierExpression(tree.location, tree.name.identifierToken),
        configurable: true,
        enumerable: false,
        writable: true
      });
    }
  }, {}, TempVarTransformer);
  return {get ObjectLiteralTransformer() {
      return ObjectLiteralTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/PropertyNameShorthandTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/PropertyNameShorthandTransformer.js";
  var $__0 = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js"),
      IdentifierExpression = $__0.IdentifierExpression,
      LiteralPropertyName = $__0.LiteralPropertyName,
      PropertyNameAssignment = $__0.PropertyNameAssignment;
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var PropertyNameShorthandTransformer = function PropertyNameShorthandTransformer() {
    $traceurRuntime.superConstructor($PropertyNameShorthandTransformer).apply(this, arguments);
  };
  var $PropertyNameShorthandTransformer = PropertyNameShorthandTransformer;
  ($traceurRuntime.createClass)(PropertyNameShorthandTransformer, {transformPropertyNameShorthand: function(tree) {
      return new PropertyNameAssignment(tree.location, new LiteralPropertyName(tree.location, tree.name), new IdentifierExpression(tree.location, tree.name));
    }}, {}, ParseTreeTransformer);
  return {get PropertyNameShorthandTransformer() {
      return PropertyNameShorthandTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/outputgeneration/regexpuRewritePattern.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/outputgeneration/regexpuRewritePattern.js";
  var modules = {};
  var module = {};
  var exports = module.exports = {};
  var require = function(id) {
    return modules[id];
  };
  ;
  (function(root) {
    var freeExports = typeof exports == 'object' && exports;
    var freeModule = typeof module == 'object' && module && module.exports == freeExports && module;
    var freeGlobal = typeof global == 'object' && global;
    if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal) {
      root = freeGlobal;
    }
    var ERRORS = {
      'rangeOrder': 'A range\u2019s `stop` value must be greater than or equal ' + 'to the `start` value.',
      'codePointRange': 'Invalid code point value. Code points range from ' + 'U+000000 to U+10FFFF.'
    };
    var HIGH_SURROGATE_MIN = 0xD800;
    var HIGH_SURROGATE_MAX = 0xDBFF;
    var LOW_SURROGATE_MIN = 0xDC00;
    var LOW_SURROGATE_MAX = 0xDFFF;
    var regexNull = /\\x00([^0123456789]|$)/g;
    var object = {};
    var hasOwnProperty = object.hasOwnProperty;
    var extend = function(destination, source) {
      var key;
      for (key in source) {
        if (hasOwnProperty.call(source, key)) {
          destination[key] = source[key];
        }
      }
      return destination;
    };
    var forEach = function(array, callback) {
      var index = -1;
      var length = array.length;
      while (++index < length) {
        callback(array[index], index);
      }
    };
    var toString = object.toString;
    var isArray = function(value) {
      return toString.call(value) == '[object Array]';
    };
    var isNumber = function(value) {
      return typeof value == 'number' || toString.call(value) == '[object Number]';
    };
    var zeroes = '0000';
    var pad = function(number, totalCharacters) {
      var string = String(number);
      return string.length < totalCharacters ? (zeroes + string).slice(-totalCharacters) : string;
    };
    var hex = function(number) {
      return Number(number).toString(16).toUpperCase();
    };
    var slice = [].slice;
    var dataFromCodePoints = function(codePoints) {
      var index = -1;
      var length = codePoints.length;
      var max = length - 1;
      var result = [];
      var isStart = true;
      var tmp;
      var previous = 0;
      while (++index < length) {
        tmp = codePoints[index];
        if (isStart) {
          result.push(tmp);
          previous = tmp;
          isStart = false;
        } else {
          if (tmp == previous + 1) {
            if (index != max) {
              previous = tmp;
              continue;
            } else {
              isStart = true;
              result.push(tmp + 1);
            }
          } else {
            result.push(previous + 1, tmp);
            previous = tmp;
          }
        }
      }
      if (!isStart) {
        result.push(tmp + 1);
      }
      return result;
    };
    var dataRemove = function(data, codePoint) {
      var index = 0;
      var start;
      var end;
      var length = data.length;
      while (index < length) {
        start = data[index];
        end = data[index + 1];
        if (codePoint >= start && codePoint < end) {
          if (codePoint == start) {
            if (end == start + 1) {
              data.splice(index, 2);
              return data;
            } else {
              data[index] = codePoint + 1;
              return data;
            }
          } else if (codePoint == end - 1) {
            data[index + 1] = codePoint;
            return data;
          } else {
            data.splice(index, 2, start, codePoint, codePoint + 1, end);
            return data;
          }
        }
        index += 2;
      }
      return data;
    };
    var dataRemoveRange = function(data, rangeStart, rangeEnd) {
      if (rangeEnd < rangeStart) {
        throw Error(ERRORS.rangeOrder);
      }
      var index = 0;
      var start;
      var end;
      while (index < data.length) {
        start = data[index];
        end = data[index + 1] - 1;
        if (start > rangeEnd) {
          return data;
        }
        if (rangeStart <= start && rangeEnd >= end) {
          data.splice(index, 2);
          continue;
        }
        if (rangeStart >= start && rangeEnd < end) {
          if (rangeStart == start) {
            data[index] = rangeEnd + 1;
            data[index + 1] = end + 1;
            return data;
          }
          data.splice(index, 2, start, rangeStart, rangeEnd + 1, end + 1);
          return data;
        }
        if (rangeStart >= start && rangeStart <= end) {
          data[index + 1] = rangeStart;
        } else if (rangeEnd >= start && rangeEnd <= end) {
          data[index] = rangeEnd + 1;
          return data;
        }
        index += 2;
      }
      return data;
    };
    var dataAdd = function(data, codePoint) {
      var index = 0;
      var start;
      var end;
      var lastIndex = null;
      var length = data.length;
      if (codePoint < 0x0 || codePoint > 0x10FFFF) {
        throw RangeError(ERRORS.codePointRange);
      }
      while (index < length) {
        start = data[index];
        end = data[index + 1];
        if (codePoint >= start && codePoint < end) {
          return data;
        }
        if (codePoint == start - 1) {
          data[index] = codePoint;
          return data;
        }
        if (start > codePoint) {
          data.splice(lastIndex != null ? lastIndex + 2 : 0, 0, codePoint, codePoint + 1);
          return data;
        }
        if (codePoint == end) {
          if (codePoint + 1 == data[index + 2]) {
            data.splice(index, 4, start, data[index + 3]);
            return data;
          }
          data[index + 1] = codePoint + 1;
          return data;
        }
        lastIndex = index;
        index += 2;
      }
      data.push(codePoint, codePoint + 1);
      return data;
    };
    var dataAddData = function(dataA, dataB) {
      var index = 0;
      var start;
      var end;
      var data = dataA.slice();
      var length = dataB.length;
      while (index < length) {
        start = dataB[index];
        end = dataB[index + 1] - 1;
        if (start == end) {
          data = dataAdd(data, start);
        } else {
          data = dataAddRange(data, start, end);
        }
        index += 2;
      }
      return data;
    };
    var dataRemoveData = function(dataA, dataB) {
      var index = 0;
      var start;
      var end;
      var data = dataA.slice();
      var length = dataB.length;
      while (index < length) {
        start = dataB[index];
        end = dataB[index + 1] - 1;
        if (start == end) {
          data = dataRemove(data, start);
        } else {
          data = dataRemoveRange(data, start, end);
        }
        index += 2;
      }
      return data;
    };
    var dataAddRange = function(data, rangeStart, rangeEnd) {
      if (rangeEnd < rangeStart) {
        throw Error(ERRORS.rangeOrder);
      }
      if (rangeStart < 0x0 || rangeStart > 0x10FFFF || rangeEnd < 0x0 || rangeEnd > 0x10FFFF) {
        throw RangeError(ERRORS.codePointRange);
      }
      var index = 0;
      var start;
      var end;
      var added = false;
      var length = data.length;
      while (index < length) {
        start = data[index];
        end = data[index + 1];
        if (added) {
          if (start == rangeEnd + 1) {
            data.splice(index - 1, 2);
            return data;
          }
          if (start > rangeEnd) {
            return data;
          }
          if (start >= rangeStart && start <= rangeEnd) {
            if (end > rangeStart && end - 1 <= rangeEnd) {
              data.splice(index, 2);
              index -= 2;
            } else {
              data.splice(index - 1, 2);
              index -= 2;
            }
          }
        } else if (start == rangeEnd + 1) {
          data[index] = rangeStart;
          return data;
        } else if (start > rangeEnd) {
          data.splice(index, 0, rangeStart, rangeEnd + 1);
          return data;
        } else if (rangeStart >= start && rangeStart < end && rangeEnd + 1 <= end) {
          return data;
        } else if ((rangeStart >= start && rangeStart < end) || end == rangeStart) {
          data[index + 1] = rangeEnd + 1;
          added = true;
        } else if (rangeStart <= start && rangeEnd + 1 >= end) {
          data[index] = rangeStart;
          data[index + 1] = rangeEnd + 1;
          added = true;
        }
        index += 2;
      }
      if (!added) {
        data.push(rangeStart, rangeEnd + 1);
      }
      return data;
    };
    var dataContains = function(data, codePoint) {
      var index = 0;
      var start;
      var end;
      var length = data.length;
      while (index < length) {
        start = data[index];
        end = data[index + 1];
        if (codePoint >= start && codePoint < end) {
          return true;
        }
        index += 2;
      }
      return false;
    };
    var dataIntersection = function(data, codePoints) {
      var index = 0;
      var length = codePoints.length;
      var codePoint;
      var result = [];
      while (index < length) {
        codePoint = codePoints[index];
        if (dataContains(data, codePoint)) {
          result.push(codePoint);
        }
        ++index;
      }
      return dataFromCodePoints(result);
    };
    var dataIsEmpty = function(data) {
      return !data.length;
    };
    var dataIsSingleton = function(data) {
      return data.length == 2 && data[0] + 1 == data[1];
    };
    var dataToArray = function(data) {
      var index = 0;
      var start;
      var end;
      var result = [];
      var length = data.length;
      while (index < length) {
        start = data[index];
        end = data[index + 1];
        while (start < end) {
          result.push(start);
          ++start;
        }
        index += 2;
      }
      return result;
    };
    var floor = Math.floor;
    var highSurrogate = function(codePoint) {
      return parseInt(floor((codePoint - 0x10000) / 0x400) + HIGH_SURROGATE_MIN, 10);
    };
    var lowSurrogate = function(codePoint) {
      return parseInt((codePoint - 0x10000) % 0x400 + LOW_SURROGATE_MIN, 10);
    };
    var stringFromCharCode = String.fromCharCode;
    var codePointToString = function(codePoint) {
      var string;
      if (codePoint == 0x09) {
        string = '\\t';
      } else if (codePoint == 0x0A) {
        string = '\\n';
      } else if (codePoint == 0x0C) {
        string = '\\f';
      } else if (codePoint == 0x0D) {
        string = '\\r';
      } else if (codePoint == 0x5C) {
        string = '\\\\';
      } else if (codePoint == 0x24 || (codePoint >= 0x28 && codePoint <= 0x2B) || codePoint == 0x2D || codePoint == 0x2E || codePoint == 0x3F || (codePoint >= 0x5B && codePoint <= 0x5E) || (codePoint >= 0x7B && codePoint <= 0x7D)) {
        string = '\\' + stringFromCharCode(codePoint);
      } else if (codePoint >= 0x20 && codePoint <= 0x7E) {
        string = stringFromCharCode(codePoint);
      } else if (codePoint <= 0xFF) {
        string = '\\x' + pad(hex(codePoint), 2);
      } else {
        string = '\\u' + pad(hex(codePoint), 4);
      }
      return string;
    };
    var symbolToCodePoint = function(symbol) {
      var length = symbol.length;
      var first = symbol.charCodeAt(0);
      var second;
      if (first >= HIGH_SURROGATE_MIN && first <= HIGH_SURROGATE_MAX && length > 1) {
        second = symbol.charCodeAt(1);
        return (first - HIGH_SURROGATE_MIN) * 0x400 + second - LOW_SURROGATE_MIN + 0x10000;
      }
      return first;
    };
    var createBMPCharacterClasses = function(data) {
      var result = '';
      var index = 0;
      var start;
      var end;
      var length = data.length;
      if (dataIsSingleton(data)) {
        return codePointToString(data[0]);
      }
      while (index < length) {
        start = data[index];
        end = data[index + 1] - 1;
        if (start == end) {
          result += codePointToString(start);
        } else if (start + 1 == end) {
          result += codePointToString(start) + codePointToString(end);
        } else {
          result += codePointToString(start) + '-' + codePointToString(end);
        }
        index += 2;
      }
      return '[' + result + ']';
    };
    var splitAtBMP = function(data) {
      var loneHighSurrogates = [];
      var bmp = [];
      var astral = [];
      var index = 0;
      var start;
      var end;
      var length = data.length;
      while (index < length) {
        start = data[index];
        end = data[index + 1] - 1;
        if (start <= 0xFFFF && end <= 0xFFFF) {
          if (start >= HIGH_SURROGATE_MIN && start <= HIGH_SURROGATE_MAX) {
            if (end <= HIGH_SURROGATE_MAX) {
              loneHighSurrogates.push(start, end + 1);
            } else {
              loneHighSurrogates.push(start, HIGH_SURROGATE_MAX + 1);
              bmp.push(HIGH_SURROGATE_MAX + 1, end + 1);
            }
          } else if (end >= HIGH_SURROGATE_MIN && end <= HIGH_SURROGATE_MAX) {
            bmp.push(start, HIGH_SURROGATE_MIN);
            loneHighSurrogates.push(HIGH_SURROGATE_MIN, end + 1);
          } else if (start < HIGH_SURROGATE_MIN && end > HIGH_SURROGATE_MAX) {
            bmp.push(start, HIGH_SURROGATE_MIN, HIGH_SURROGATE_MAX + 1, end + 1);
            loneHighSurrogates.push(HIGH_SURROGATE_MIN, HIGH_SURROGATE_MAX + 1);
          } else {
            bmp.push(start, end + 1);
          }
        } else if (start <= 0xFFFF && end > 0xFFFF) {
          if (start >= HIGH_SURROGATE_MIN && start <= HIGH_SURROGATE_MAX) {
            loneHighSurrogates.push(start, HIGH_SURROGATE_MAX + 1);
            bmp.push(HIGH_SURROGATE_MAX + 1, 0xFFFF + 1);
          } else if (start < HIGH_SURROGATE_MIN) {
            bmp.push(start, HIGH_SURROGATE_MIN, HIGH_SURROGATE_MAX + 1, 0xFFFF + 1);
            loneHighSurrogates.push(HIGH_SURROGATE_MIN, HIGH_SURROGATE_MAX + 1);
          } else {
            bmp.push(start, 0xFFFF + 1);
          }
          astral.push(0xFFFF + 1, end + 1);
        } else {
          astral.push(start, end + 1);
        }
        index += 2;
      }
      return {
        'loneHighSurrogates': loneHighSurrogates,
        'bmp': bmp,
        'astral': astral
      };
    };
    var optimizeSurrogateMappings = function(surrogateMappings) {
      var result = [];
      var tmpLow = [];
      var addLow = false;
      var mapping;
      var nextMapping;
      var highSurrogates;
      var lowSurrogates;
      var nextHighSurrogates;
      var nextLowSurrogates;
      var index = -1;
      var length = surrogateMappings.length;
      while (++index < length) {
        mapping = surrogateMappings[index];
        nextMapping = surrogateMappings[index + 1];
        if (!nextMapping) {
          result.push(mapping);
          continue;
        }
        highSurrogates = mapping[0];
        lowSurrogates = mapping[1];
        nextHighSurrogates = nextMapping[0];
        nextLowSurrogates = nextMapping[1];
        tmpLow = lowSurrogates;
        while (nextHighSurrogates && highSurrogates[0] == nextHighSurrogates[0] && highSurrogates[1] == nextHighSurrogates[1]) {
          if (dataIsSingleton(nextLowSurrogates)) {
            tmpLow = dataAdd(tmpLow, nextLowSurrogates[0]);
          } else {
            tmpLow = dataAddRange(tmpLow, nextLowSurrogates[0], nextLowSurrogates[1] - 1);
          }
          ++index;
          mapping = surrogateMappings[index];
          highSurrogates = mapping[0];
          lowSurrogates = mapping[1];
          nextMapping = surrogateMappings[index + 1];
          nextHighSurrogates = nextMapping && nextMapping[0];
          nextLowSurrogates = nextMapping && nextMapping[1];
          addLow = true;
        }
        result.push([highSurrogates, addLow ? tmpLow : lowSurrogates]);
        addLow = false;
      }
      return optimizeByLowSurrogates(result);
    };
    var optimizeByLowSurrogates = function(surrogateMappings) {
      if (surrogateMappings.length == 1) {
        return surrogateMappings;
      }
      var index = -1;
      var innerIndex = -1;
      while (++index < surrogateMappings.length) {
        var mapping = surrogateMappings[index];
        var lowSurrogates = mapping[1];
        var lowSurrogateStart = lowSurrogates[0];
        var lowSurrogateEnd = lowSurrogates[1];
        innerIndex = index;
        while (++innerIndex < surrogateMappings.length) {
          var otherMapping = surrogateMappings[innerIndex];
          var otherLowSurrogates = otherMapping[1];
          var otherLowSurrogateStart = otherLowSurrogates[0];
          var otherLowSurrogateEnd = otherLowSurrogates[1];
          if (lowSurrogateStart == otherLowSurrogateStart && lowSurrogateEnd == otherLowSurrogateEnd) {
            if (dataIsSingleton(otherMapping[0])) {
              mapping[0] = dataAdd(mapping[0], otherMapping[0][0]);
            } else {
              mapping[0] = dataAddRange(mapping[0], otherMapping[0][0], otherMapping[0][1] - 1);
            }
            surrogateMappings.splice(innerIndex, 1);
            --innerIndex;
          }
        }
      }
      return surrogateMappings;
    };
    var surrogateSet = function(data) {
      if (!data.length) {
        return [];
      }
      var index = 0;
      var start;
      var end;
      var startHigh;
      var startLow;
      var prevStartHigh = 0;
      var prevEndHigh = 0;
      var tmpLow = [];
      var endHigh;
      var endLow;
      var surrogateMappings = [];
      var length = data.length;
      var dataHigh = [];
      while (index < length) {
        start = data[index];
        end = data[index + 1] - 1;
        startHigh = highSurrogate(start);
        startLow = lowSurrogate(start);
        endHigh = highSurrogate(end);
        endLow = lowSurrogate(end);
        var startsWithLowestLowSurrogate = startLow == LOW_SURROGATE_MIN;
        var endsWithHighestLowSurrogate = endLow == LOW_SURROGATE_MAX;
        var complete = false;
        if (startHigh == endHigh || startsWithLowestLowSurrogate && endsWithHighestLowSurrogate) {
          surrogateMappings.push([[startHigh, endHigh + 1], [startLow, endLow + 1]]);
          complete = true;
        } else {
          surrogateMappings.push([[startHigh, startHigh + 1], [startLow, LOW_SURROGATE_MAX + 1]]);
        }
        if (!complete && startHigh + 1 < endHigh) {
          if (endsWithHighestLowSurrogate) {
            surrogateMappings.push([[startHigh + 1, endHigh + 1], [LOW_SURROGATE_MIN, endLow + 1]]);
            complete = true;
          } else {
            surrogateMappings.push([[startHigh + 1, endHigh], [LOW_SURROGATE_MIN, LOW_SURROGATE_MAX + 1]]);
          }
        }
        if (!complete) {
          surrogateMappings.push([[endHigh, endHigh + 1], [LOW_SURROGATE_MIN, endLow + 1]]);
        }
        prevStartHigh = startHigh;
        prevEndHigh = endHigh;
        index += 2;
      }
      return optimizeSurrogateMappings(surrogateMappings);
    };
    var createSurrogateCharacterClasses = function(surrogateMappings) {
      var result = [];
      forEach(surrogateMappings, function(surrogateMapping) {
        var highSurrogates = surrogateMapping[0];
        var lowSurrogates = surrogateMapping[1];
        result.push(createBMPCharacterClasses(highSurrogates) + createBMPCharacterClasses(lowSurrogates));
      });
      return result.join('|');
    };
    var createCharacterClassesFromData = function(data) {
      var result = [];
      var parts = splitAtBMP(data);
      var loneHighSurrogates = parts.loneHighSurrogates;
      var bmp = parts.bmp;
      var astral = parts.astral;
      var hasAstral = !dataIsEmpty(parts.astral);
      var hasLoneSurrogates = !dataIsEmpty(loneHighSurrogates);
      var surrogateMappings = surrogateSet(astral);
      if (!hasAstral && hasLoneSurrogates) {
        bmp = dataAddData(bmp, loneHighSurrogates);
      }
      if (!dataIsEmpty(bmp)) {
        result.push(createBMPCharacterClasses(bmp));
      }
      if (surrogateMappings.length) {
        result.push(createSurrogateCharacterClasses(surrogateMappings));
      }
      if (hasAstral && hasLoneSurrogates) {
        result.push(createBMPCharacterClasses(loneHighSurrogates));
      }
      return result.join('|');
    };
    var regenerate = function(value) {
      if (arguments.length > 1) {
        value = slice.call(arguments);
      }
      if (this instanceof regenerate) {
        this.data = [];
        return value ? this.add(value) : this;
      }
      return (new regenerate).add(value);
    };
    regenerate.version = '1.0.1';
    var proto = regenerate.prototype;
    extend(proto, {
      'add': function(value) {
        var $this = this;
        if (value == null) {
          return $this;
        }
        if (value instanceof regenerate) {
          $this.data = dataAddData($this.data, value.data);
          return $this;
        }
        if (arguments.length > 1) {
          value = slice.call(arguments);
        }
        if (isArray(value)) {
          forEach(value, function(item) {
            $this.add(item);
          });
          return $this;
        }
        $this.data = dataAdd($this.data, isNumber(value) ? value : symbolToCodePoint(value));
        return $this;
      },
      'remove': function(value) {
        var $this = this;
        if (value == null) {
          return $this;
        }
        if (value instanceof regenerate) {
          $this.data = dataRemoveData($this.data, value.data);
          return $this;
        }
        if (arguments.length > 1) {
          value = slice.call(arguments);
        }
        if (isArray(value)) {
          forEach(value, function(item) {
            $this.remove(item);
          });
          return $this;
        }
        $this.data = dataRemove($this.data, isNumber(value) ? value : symbolToCodePoint(value));
        return $this;
      },
      'addRange': function(start, end) {
        var $this = this;
        $this.data = dataAddRange($this.data, isNumber(start) ? start : symbolToCodePoint(start), isNumber(end) ? end : symbolToCodePoint(end));
        return $this;
      },
      'removeRange': function(start, end) {
        var $this = this;
        var startCodePoint = isNumber(start) ? start : symbolToCodePoint(start);
        var endCodePoint = isNumber(end) ? end : symbolToCodePoint(end);
        $this.data = dataRemoveRange($this.data, startCodePoint, endCodePoint);
        return $this;
      },
      'intersection': function(argument) {
        var $this = this;
        var array = argument instanceof regenerate ? dataToArray(argument.data) : argument;
        $this.data = dataIntersection($this.data, array);
        return $this;
      },
      'contains': function(codePoint) {
        return dataContains(this.data, isNumber(codePoint) ? codePoint : symbolToCodePoint(codePoint));
      },
      'clone': function() {
        var set = new regenerate;
        set.data = this.data.slice(0);
        return set;
      },
      'toString': function() {
        var result = createCharacterClassesFromData(this.data);
        return result.replace(regexNull, '\\0$1');
      },
      'toRegExp': function(flags) {
        return RegExp(this.toString(), flags || '');
      },
      'valueOf': function() {
        return dataToArray(this.data);
      }
    });
    proto.toArray = proto.valueOf;
    if (typeof define == 'function' && typeof define.amd == 'object' && define.amd) {
      define(function() {
        return regenerate;
      });
    } else if (freeExports && !freeExports.nodeType) {
      if (freeModule) {
        freeModule.exports = regenerate;
      } else {
        freeExports.regenerate = regenerate;
      }
    } else {
      root.regenerate = regenerate;
    }
  }(this));
  modules['regenerate'] = module.exports || window.regenerate;
  ;
  (function() {
    'use strict';
    var objectTypes = {
      'function': true,
      'object': true
    };
    var root = (objectTypes[typeof window] && window) || this;
    var oldRoot = root;
    var freeExports = objectTypes[typeof exports] && exports;
    var freeModule = objectTypes[typeof module] && module && !module.nodeType && module;
    var freeGlobal = freeExports && freeModule && typeof global == 'object' && global;
    if (freeGlobal && (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal)) {
      root = freeGlobal;
    }
    var stringFromCharCode = String.fromCharCode;
    var floor = Math.floor;
    function fromCodePoint() {
      var MAX_SIZE = 0x4000;
      var codeUnits = [];
      var highSurrogate;
      var lowSurrogate;
      var index = -1;
      var length = arguments.length;
      if (!length) {
        return '';
      }
      var result = '';
      while (++index < length) {
        var codePoint = Number(arguments[index]);
        if (!isFinite(codePoint) || codePoint < 0 || codePoint > 0x10FFFF || floor(codePoint) != codePoint) {
          throw RangeError('Invalid code point: ' + codePoint);
        }
        if (codePoint <= 0xFFFF) {
          codeUnits.push(codePoint);
        } else {
          codePoint -= 0x10000;
          highSurrogate = (codePoint >> 10) + 0xD800;
          lowSurrogate = (codePoint % 0x400) + 0xDC00;
          codeUnits.push(highSurrogate, lowSurrogate);
        }
        if (index + 1 == length || codeUnits.length > MAX_SIZE) {
          result += stringFromCharCode.apply(null, codeUnits);
          codeUnits.length = 0;
        }
      }
      return result;
    }
    function assertType(type, expected) {
      if (expected.indexOf('|') == -1) {
        if (type == expected) {
          return;
        }
        throw Error('Invalid node type: ' + type);
      }
      expected = assertType.hasOwnProperty(expected) ? assertType[expected] : (assertType[expected] = RegExp('^(?:' + expected + ')$'));
      if (expected.test(type)) {
        return;
      }
      throw Error('Invalid node type: ' + type);
    }
    function generate(node) {
      var type = node.type;
      if (generate.hasOwnProperty(type) && typeof generate[type] == 'function') {
        return generate[type](node);
      }
      throw Error('Invalid node type: ' + type);
    }
    function generateAlternative(node) {
      assertType(node.type, 'alternative');
      var terms = node.body,
          length = terms ? terms.length : 0;
      if (length == 1) {
        return generateTerm(terms[0]);
      } else {
        var i = -1,
            result = '';
        while (++i < length) {
          result += generateTerm(terms[i]);
        }
        return result;
      }
    }
    function generateAnchor(node) {
      assertType(node.type, 'anchor');
      switch (node.kind) {
        case 'start':
          return '^';
        case 'end':
          return '$';
        case 'boundary':
          return '\\b';
        case 'not-boundary':
          return '\\B';
        default:
          throw Error('Invalid assertion');
      }
    }
    function generateAtom(node) {
      assertType(node.type, 'anchor|characterClass|characterClassEscape|dot|group|reference|value');
      return generate(node);
    }
    function generateCharacterClass(node) {
      assertType(node.type, 'characterClass');
      var classRanges = node.body,
          length = classRanges ? classRanges.length : 0;
      var i = -1,
          result = '[';
      if (node.negative) {
        result += '^';
      }
      while (++i < length) {
        result += generateClassAtom(classRanges[i]);
      }
      result += ']';
      return result;
    }
    function generateCharacterClassEscape(node) {
      assertType(node.type, 'characterClassEscape');
      return '\\' + node.value;
    }
    function generateCharacterClassRange(node) {
      assertType(node.type, 'characterClassRange');
      var min = node.min,
          max = node.max;
      if (min.type == 'characterClassRange' || max.type == 'characterClassRange') {
        throw Error('Invalid character class range');
      }
      return generateClassAtom(min) + '-' + generateClassAtom(max);
    }
    function generateClassAtom(node) {
      assertType(node.type, 'anchor|characterClassEscape|characterClassRange|dot|value');
      return generate(node);
    }
    function generateDisjunction(node) {
      assertType(node.type, 'disjunction');
      var body = node.body,
          length = body ? body.length : 0;
      if (length == 0) {
        throw Error('No body');
      } else if (length == 1) {
        return generate(body[0]);
      } else {
        var i = -1,
            result = '';
        while (++i < length) {
          if (i != 0) {
            result += '|';
          }
          result += generate(body[i]);
        }
        return result;
      }
    }
    function generateDot(node) {
      assertType(node.type, 'dot');
      return '.';
    }
    function generateGroup(node) {
      assertType(node.type, 'group');
      var result = '(';
      switch (node.behavior) {
        case 'normal':
          break;
        case 'ignore':
          result += '?:';
          break;
        case 'lookahead':
          result += '?=';
          break;
        case 'negativeLookahead':
          result += '?!';
          break;
        default:
          throw Error('Invalid behaviour: ' + node.behaviour);
      }
      var body = node.body,
          length = body ? body.length : 0;
      if (length == 1) {
        result += generate(body[0]);
      } else {
        var i = -1;
        while (++i < length) {
          result += generate(body[i]);
        }
      }
      result += ')';
      return result;
    }
    function generateQuantifier(node) {
      assertType(node.type, 'quantifier');
      var quantifier = '',
          min = node.min,
          max = node.max;
      switch (max) {
        case undefined:
        case null:
          switch (min) {
            case 0:
              quantifier = '*';
              break;
            case 1:
              quantifier = '+';
              break;
            default:
              quantifier = '{' + min + ',}';
              break;
          }
          break;
        default:
          if (min == max) {
            quantifier = '{' + min + '}';
          } else if (min == 0 && max == 1) {
            quantifier = '?';
          } else {
            quantifier = '{' + min + ',' + max + '}';
          }
          break;
      }
      if (!node.greedy) {
        quantifier += '?';
      }
      return generateAtom(node.body[0]) + quantifier;
    }
    function generateReference(node) {
      assertType(node.type, 'reference');
      return '\\' + node.matchIndex;
    }
    function generateTerm(node) {
      assertType(node.type, 'anchor|characterClass|characterClassEscape|empty|group|quantifier|reference|value');
      return generate(node);
    }
    function generateValue(node) {
      assertType(node.type, 'value');
      var kind = node.kind,
          codePoint = node.codePoint;
      switch (kind) {
        case 'controlLetter':
          return '\\c' + fromCodePoint(codePoint + 64);
        case 'hexadecimalEscape':
          return '\\x' + ('00' + codePoint.toString(16).toUpperCase()).slice(-2);
        case 'identifier':
          return '\\' + fromCodePoint(codePoint);
        case 'null':
          return '\\' + codePoint;
        case 'octal':
          return '\\' + codePoint.toString(8);
        case 'singleEscape':
          switch (codePoint) {
            case 0x0008:
              return '\\b';
            case 0x009:
              return '\\t';
            case 0x00A:
              return '\\n';
            case 0x00B:
              return '\\v';
            case 0x00C:
              return '\\f';
            case 0x00D:
              return '\\r';
            default:
              throw Error('Invalid codepoint: ' + codePoint);
          }
        case 'symbol':
          return fromCodePoint(codePoint);
        case 'unicodeEscape':
          return '\\u' + ('0000' + codePoint.toString(16).toUpperCase()).slice(-4);
        case 'unicodeCodePointEscape':
          return '\\u{' + codePoint.toString(16).toUpperCase() + '}';
        default:
          throw Error('Unsupported node kind: ' + kind);
      }
    }
    generate.alternative = generateAlternative;
    generate.anchor = generateAnchor;
    generate.characterClass = generateCharacterClass;
    generate.characterClassEscape = generateCharacterClassEscape;
    generate.characterClassRange = generateCharacterClassRange;
    generate.disjunction = generateDisjunction;
    generate.dot = generateDot;
    generate.group = generateGroup;
    generate.quantifier = generateQuantifier;
    generate.reference = generateReference;
    generate.value = generateValue;
    if (typeof define == 'function' && typeof define.amd == 'object' && define.amd) {
      define(function() {
        return {'generate': generate};
      });
    } else if (freeExports && freeModule) {
      freeExports.generate = generate;
    } else {
      root.regjsgen = {'generate': generate};
    }
  }.call(this));
  modules['regjsgen'] = {generate: exports.generate || window.regjsgen};
  (function() {
    function parse(str, flags) {
      var hasUnicodeFlag = (flags || "").indexOf("u") !== -1;
      var pos = 0;
      var closedCaptureCounter = 0;
      function addRaw(node) {
        node.raw = str.substring(node.range[0], node.range[1]);
        return node;
      }
      function updateRawStart(node, start) {
        node.range[0] = start;
        return addRaw(node);
      }
      function createAnchor(kind, rawLength) {
        return addRaw({
          type: 'anchor',
          kind: kind,
          range: [pos - rawLength, pos]
        });
      }
      function createValue(kind, codePoint, from, to) {
        return addRaw({
          type: 'value',
          kind: kind,
          codePoint: codePoint,
          range: [from, to]
        });
      }
      function createEscaped(kind, codePoint, value, fromOffset) {
        fromOffset = fromOffset || 0;
        return createValue(kind, codePoint, pos - (value.length + fromOffset), pos);
      }
      function createCharacter(matches) {
        var _char = matches[0];
        var first = _char.charCodeAt(0);
        if (hasUnicodeFlag) {
          var second;
          if (_char.length === 1 && first >= 0xD800 && first <= 0xDBFF) {
            second = lookahead().charCodeAt(0);
            if (second >= 0xDC00 && second <= 0xDFFF) {
              pos++;
              return createValue('symbol', (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000, pos - 2, pos);
            }
          }
        }
        return createValue('symbol', first, pos - 1, pos);
      }
      function createDisjunction(alternatives, from, to) {
        return addRaw({
          type: 'disjunction',
          body: alternatives,
          range: [from, to]
        });
      }
      function createDot() {
        return addRaw({
          type: 'dot',
          range: [pos - 1, pos]
        });
      }
      function createCharacterClassEscape(value) {
        return addRaw({
          type: 'characterClassEscape',
          value: value,
          range: [pos - 2, pos]
        });
      }
      function createReference(matchIndex) {
        return addRaw({
          type: 'reference',
          matchIndex: parseInt(matchIndex, 10),
          range: [pos - 1 - matchIndex.length, pos]
        });
      }
      function createGroup(behavior, disjunction, from, to) {
        return addRaw({
          type: 'group',
          behavior: behavior,
          body: disjunction,
          range: [from, to]
        });
      }
      function createQuantifier(min, max, from, to) {
        if (to == null) {
          from = pos - 1;
          to = pos;
        }
        return addRaw({
          type: 'quantifier',
          min: min,
          max: max,
          greedy: true,
          body: null,
          range: [from, to]
        });
      }
      function createAlternative(terms, from, to) {
        return addRaw({
          type: 'alternative',
          body: terms,
          range: [from, to]
        });
      }
      function createCharacterClass(classRanges, negative, from, to) {
        return addRaw({
          type: 'characterClass',
          body: classRanges,
          negative: negative,
          range: [from, to]
        });
      }
      function createClassRange(min, max, from, to) {
        if (min.codePoint > max.codePoint) {
          throw SyntaxError('invalid range in character class');
        }
        return addRaw({
          type: 'characterClassRange',
          min: min,
          max: max,
          range: [from, to]
        });
      }
      function flattenBody(body) {
        if (body.type === 'alternative') {
          return body.body;
        } else {
          return [body];
        }
      }
      function isEmpty(obj) {
        return obj.type === 'empty';
      }
      function incr(amount) {
        amount = (amount || 1);
        var res = str.substring(pos, pos + amount);
        pos += (amount || 1);
        return res;
      }
      function skip(value) {
        if (!match(value)) {
          throw SyntaxError('character: ' + value);
        }
      }
      function match(value) {
        if (str.indexOf(value, pos) === pos) {
          return incr(value.length);
        }
      }
      function lookahead() {
        return str[pos];
      }
      function current(value) {
        return str.indexOf(value, pos) === pos;
      }
      function next(value) {
        return str[pos + 1] === value;
      }
      function matchReg(regExp) {
        var subStr = str.substring(pos);
        var res = subStr.match(regExp);
        if (res) {
          res.range = [];
          res.range[0] = pos;
          incr(res[0].length);
          res.range[1] = pos;
        }
        return res;
      }
      function parseDisjunction() {
        var res = [],
            from = pos;
        res.push(parseAlternative());
        while (match('|')) {
          res.push(parseAlternative());
        }
        if (res.length === 1) {
          return res[0];
        }
        return createDisjunction(res, from, pos);
      }
      function parseAlternative() {
        var res = [],
            from = pos;
        var term;
        while (term = parseTerm()) {
          res.push(term);
        }
        if (res.length === 1) {
          return res[0];
        }
        return createAlternative(res, from, pos);
      }
      function parseTerm() {
        if (pos >= str.length || current('|') || current(')')) {
          return null;
        }
        var anchor = parseAnchor();
        if (anchor) {
          return anchor;
        }
        var atom = parseAtom();
        if (!atom) {
          throw SyntaxError('Expected atom');
        }
        var quantifier = parseQuantifier() || false;
        if (quantifier) {
          quantifier.body = flattenBody(atom);
          updateRawStart(quantifier, atom.range[0]);
          return quantifier;
        }
        return atom;
      }
      function parseGroup(matchA, typeA, matchB, typeB) {
        var type = null,
            from = pos;
        if (match(matchA)) {
          type = typeA;
        } else if (match(matchB)) {
          type = typeB;
        } else {
          return false;
        }
        var body = parseDisjunction();
        if (!body) {
          throw SyntaxError('Expected disjunction');
        }
        skip(')');
        var group = createGroup(type, flattenBody(body), from, pos);
        if (type == 'normal') {
          closedCaptureCounter++;
        }
        return group;
      }
      function parseAnchor() {
        var res,
            from = pos;
        if (match('^')) {
          return createAnchor('start', 1);
        } else if (match('$')) {
          return createAnchor('end', 1);
        } else if (match('\\b')) {
          return createAnchor('boundary', 2);
        } else if (match('\\B')) {
          return createAnchor('not-boundary', 2);
        } else {
          return parseGroup('(?=', 'lookahead', '(?!', 'negativeLookahead');
        }
      }
      function parseQuantifier() {
        var res;
        var quantifier;
        var min,
            max;
        if (match('*')) {
          quantifier = createQuantifier(0);
        } else if (match('+')) {
          quantifier = createQuantifier(1);
        } else if (match('?')) {
          quantifier = createQuantifier(0, 1);
        } else if (res = matchReg(/^\{([0-9]+)\}/)) {
          min = parseInt(res[1], 10);
          quantifier = createQuantifier(min, min, res.range[0], res.range[1]);
        } else if (res = matchReg(/^\{([0-9]+),\}/)) {
          min = parseInt(res[1], 10);
          quantifier = createQuantifier(min, undefined, res.range[0], res.range[1]);
        } else if (res = matchReg(/^\{([0-9]+),([0-9]+)\}/)) {
          min = parseInt(res[1], 10);
          max = parseInt(res[2], 10);
          if (min > max) {
            throw SyntaxError('numbers out of order in {} quantifier');
          }
          quantifier = createQuantifier(min, max, res.range[0], res.range[1]);
        }
        if (quantifier) {
          if (match('?')) {
            quantifier.greedy = false;
            quantifier.range[1] += 1;
          }
        }
        return quantifier;
      }
      function parseAtom() {
        var res;
        if (res = matchReg(/^[^^$\\.*+?(){[|]/)) {
          return createCharacter(res);
        } else if (match('.')) {
          return createDot();
        } else if (match('\\')) {
          res = parseAtomEscape();
          if (!res) {
            throw SyntaxError('atomEscape');
          }
          return res;
        } else if (res = parseCharacterClass()) {
          return res;
        } else {
          return parseGroup('(?:', 'ignore', '(', 'normal');
        }
      }
      function parseUnicodeSurrogatePairEscape(firstEscape) {
        if (hasUnicodeFlag) {
          var first,
              second;
          if (firstEscape.kind == 'unicodeEscape' && (first = firstEscape.codePoint) >= 0xD800 && first <= 0xDBFF && current('\\') && next('u')) {
            var prevPos = pos;
            pos++;
            var secondEscape = parseClassEscape();
            if (secondEscape.kind == 'unicodeEscape' && (second = secondEscape.codePoint) >= 0xDC00 && second <= 0xDFFF) {
              firstEscape.range[1] = secondEscape.range[1];
              firstEscape.codePoint = (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;
              firstEscape.type = 'value';
              firstEscape.kind = 'unicodeCodePointEscape';
              addRaw(firstEscape);
            } else {
              pos = prevPos;
            }
          }
        }
        return firstEscape;
      }
      function parseClassEscape() {
        return parseAtomEscape(true);
      }
      function parseAtomEscape(insideCharacterClass) {
        var res;
        res = parseDecimalEscape();
        if (res) {
          return res;
        }
        if (insideCharacterClass) {
          if (match('b')) {
            return createEscaped('singleEscape', 0x0008, '\\b');
          } else if (match('B')) {
            throw SyntaxError('\\B not possible inside of CharacterClass');
          }
        }
        res = parseCharacterEscape();
        return res;
      }
      function parseDecimalEscape() {
        var res,
            match;
        if (res = matchReg(/^(?!0)\d+/)) {
          match = res[0];
          var refIdx = parseInt(res[0], 10);
          if (refIdx <= closedCaptureCounter) {
            return createReference(res[0]);
          } else {
            incr(-res[0].length);
            if (res = matchReg(/^[0-7]{1,3}/)) {
              return createEscaped('octal', parseInt(res[0], 8), res[0], 1);
            } else {
              res = createCharacter(matchReg(/^[89]/));
              return updateRawStart(res, res.range[0] - 1);
            }
          }
        } else if (res = matchReg(/^[0-7]{1,3}/)) {
          match = res[0];
          if (/^0{1,3}$/.test(match)) {
            return createEscaped('null', 0x0000, '0', match.length + 1);
          } else {
            return createEscaped('octal', parseInt(match, 8), match, 1);
          }
        } else if (res = matchReg(/^[dDsSwW]/)) {
          return createCharacterClassEscape(res[0]);
        }
        return false;
      }
      function parseCharacterEscape() {
        var res;
        if (res = matchReg(/^[fnrtv]/)) {
          var codePoint = 0;
          switch (res[0]) {
            case 't':
              codePoint = 0x009;
              break;
            case 'n':
              codePoint = 0x00A;
              break;
            case 'v':
              codePoint = 0x00B;
              break;
            case 'f':
              codePoint = 0x00C;
              break;
            case 'r':
              codePoint = 0x00D;
              break;
          }
          return createEscaped('singleEscape', codePoint, '\\' + res[0]);
        } else if (res = matchReg(/^c([a-zA-Z])/)) {
          return createEscaped('controlLetter', res[1].charCodeAt(0) % 32, res[1], 2);
        } else if (res = matchReg(/^x([0-9a-fA-F]{2})/)) {
          return createEscaped('hexadecimalEscape', parseInt(res[1], 16), res[1], 2);
        } else if (res = matchReg(/^u([0-9a-fA-F]{4})/)) {
          return parseUnicodeSurrogatePairEscape(createEscaped('unicodeEscape', parseInt(res[1], 16), res[1], 2));
        } else if (hasUnicodeFlag && (res = matchReg(/^u\{([0-9a-fA-F]{1,})\}/))) {
          return createEscaped('unicodeCodePointEscape', parseInt(res[1], 16), res[1], 4);
        } else {
          return parseIdentityEscape();
        }
      }
      function isIdentifierPart(ch) {
        var NonAsciiIdentifierPart = new RegExp('[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u08A0-\u08B2\u08E4-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58\u0C59\u0C60-\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D57\u0D60-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19D9\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1CD0-\u1CD2\u1CD4-\u1CF6\u1CF8\u1CF9\u1D00-\u1DF5\u1DFC-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200C\u200D\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u2E2F\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099\u309A\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA69D\uA69F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C4\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2D\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]');
        return (ch === 36) || (ch === 95) || (ch >= 65 && ch <= 90) || (ch >= 97 && ch <= 122) || (ch >= 48 && ch <= 57) || (ch === 92) || ((ch >= 0x80) && NonAsciiIdentifierPart.test(String.fromCharCode(ch)));
      }
      function parseIdentityEscape() {
        var ZWJ = '\u200C';
        var ZWNJ = '\u200D';
        var res;
        var tmp;
        if (!isIdentifierPart(lookahead())) {
          tmp = incr();
          return createEscaped('identifier', tmp.charCodeAt(0), tmp, 1);
        }
        if (match(ZWJ)) {
          return createEscaped('identifier', 0x200C, ZWJ);
        } else if (match(ZWNJ)) {
          return createEscaped('identifier', 0x200D, ZWNJ);
        }
        return null;
      }
      function parseCharacterClass() {
        var res,
            from = pos;
        if (res = matchReg(/^\[\^/)) {
          res = parseClassRanges();
          skip(']');
          return createCharacterClass(res, true, from, pos);
        } else if (match('[')) {
          res = parseClassRanges();
          skip(']');
          return createCharacterClass(res, false, from, pos);
        }
        return null;
      }
      function parseClassRanges() {
        var res;
        if (current(']')) {
          return [];
        } else {
          res = parseNonemptyClassRanges();
          if (!res) {
            throw SyntaxError('nonEmptyClassRanges');
          }
          return res;
        }
      }
      function parseHelperClassRanges(atom) {
        var from,
            to,
            res;
        if (current('-') && !next(']')) {
          skip('-');
          res = parseClassAtom();
          if (!res) {
            throw SyntaxError('classAtom');
          }
          to = pos;
          var classRanges = parseClassRanges();
          if (!classRanges) {
            throw SyntaxError('classRanges');
          }
          from = atom.range[0];
          if (classRanges.type === 'empty') {
            return [createClassRange(atom, res, from, to)];
          }
          return [createClassRange(atom, res, from, to)].concat(classRanges);
        }
        res = parseNonemptyClassRangesNoDash();
        if (!res) {
          throw SyntaxError('nonEmptyClassRangesNoDash');
        }
        return [atom].concat(res);
      }
      function parseNonemptyClassRanges() {
        var atom = parseClassAtom();
        if (!atom) {
          throw SyntaxError('classAtom');
        }
        if (current(']')) {
          return [atom];
        }
        return parseHelperClassRanges(atom);
      }
      function parseNonemptyClassRangesNoDash() {
        var res = parseClassAtom();
        if (!res) {
          throw SyntaxError('classAtom');
        }
        if (current(']')) {
          return res;
        }
        return parseHelperClassRanges(res);
      }
      function parseClassAtom() {
        if (match('-')) {
          return createCharacter('-');
        } else {
          return parseClassAtomNoDash();
        }
      }
      function parseClassAtomNoDash() {
        var res;
        if (res = matchReg(/^[^\\\]-]/)) {
          return createCharacter(res[0]);
        } else if (match('\\')) {
          res = parseClassEscape();
          if (!res) {
            throw SyntaxError('classEscape');
          }
          return parseUnicodeSurrogatePairEscape(res);
        }
      }
      str = String(str);
      if (str === '') {
        str = '(?:)';
      }
      var result = parseDisjunction();
      if (result.range[1] !== str.length) {
        throw SyntaxError('Could not parse entire input - got stuck: ' + str);
      }
      return result;
    }
    ;
    var regjsparser = {parse: parse};
    if (typeof module !== 'undefined' && module.exports) {
      module.exports = regjsparser;
    } else {
      window.regjsparser = regjsparser;
    }
  }());
  modules['regjsparser'] = module.exports || window.regjsparser;
  modules['./data/iu-mappings.json'] = ({
    "75": 8490,
    "83": 383,
    "107": 8490,
    "115": 383,
    "181": 924,
    "197": 8491,
    "383": 83,
    "452": 453,
    "453": 452,
    "455": 456,
    "456": 455,
    "458": 459,
    "459": 458,
    "497": 498,
    "498": 497,
    "837": 8126,
    "914": 976,
    "917": 1013,
    "920": 1012,
    "921": 8126,
    "922": 1008,
    "924": 181,
    "928": 982,
    "929": 1009,
    "931": 962,
    "934": 981,
    "937": 8486,
    "962": 931,
    "976": 914,
    "977": 1012,
    "981": 934,
    "982": 928,
    "1008": 922,
    "1009": 929,
    "1012": [920, 977],
    "1013": 917,
    "7776": 7835,
    "7835": 7776,
    "8126": [837, 921],
    "8486": 937,
    "8490": 75,
    "8491": 197,
    "66560": 66600,
    "66561": 66601,
    "66562": 66602,
    "66563": 66603,
    "66564": 66604,
    "66565": 66605,
    "66566": 66606,
    "66567": 66607,
    "66568": 66608,
    "66569": 66609,
    "66570": 66610,
    "66571": 66611,
    "66572": 66612,
    "66573": 66613,
    "66574": 66614,
    "66575": 66615,
    "66576": 66616,
    "66577": 66617,
    "66578": 66618,
    "66579": 66619,
    "66580": 66620,
    "66581": 66621,
    "66582": 66622,
    "66583": 66623,
    "66584": 66624,
    "66585": 66625,
    "66586": 66626,
    "66587": 66627,
    "66588": 66628,
    "66589": 66629,
    "66590": 66630,
    "66591": 66631,
    "66592": 66632,
    "66593": 66633,
    "66594": 66634,
    "66595": 66635,
    "66596": 66636,
    "66597": 66637,
    "66598": 66638,
    "66599": 66639,
    "66600": 66560,
    "66601": 66561,
    "66602": 66562,
    "66603": 66563,
    "66604": 66564,
    "66605": 66565,
    "66606": 66566,
    "66607": 66567,
    "66608": 66568,
    "66609": 66569,
    "66610": 66570,
    "66611": 66571,
    "66612": 66572,
    "66613": 66573,
    "66614": 66574,
    "66615": 66575,
    "66616": 66576,
    "66617": 66577,
    "66618": 66578,
    "66619": 66579,
    "66620": 66580,
    "66621": 66581,
    "66622": 66582,
    "66623": 66583,
    "66624": 66584,
    "66625": 66585,
    "66626": 66586,
    "66627": 66587,
    "66628": 66588,
    "66629": 66589,
    "66630": 66590,
    "66631": 66591,
    "66632": 66592,
    "66633": 66593,
    "66634": 66594,
    "66635": 66595,
    "66636": 66596,
    "66637": 66597,
    "66638": 66598,
    "66639": 66599,
    "71840": 71872,
    "71841": 71873,
    "71842": 71874,
    "71843": 71875,
    "71844": 71876,
    "71845": 71877,
    "71846": 71878,
    "71847": 71879,
    "71848": 71880,
    "71849": 71881,
    "71850": 71882,
    "71851": 71883,
    "71852": 71884,
    "71853": 71885,
    "71854": 71886,
    "71855": 71887,
    "71856": 71888,
    "71857": 71889,
    "71858": 71890,
    "71859": 71891,
    "71860": 71892,
    "71861": 71893,
    "71862": 71894,
    "71863": 71895,
    "71864": 71896,
    "71865": 71897,
    "71866": 71898,
    "71867": 71899,
    "71868": 71900,
    "71869": 71901,
    "71870": 71902,
    "71871": 71903,
    "71872": 71840,
    "71873": 71841,
    "71874": 71842,
    "71875": 71843,
    "71876": 71844,
    "71877": 71845,
    "71878": 71846,
    "71879": 71847,
    "71880": 71848,
    "71881": 71849,
    "71882": 71850,
    "71883": 71851,
    "71884": 71852,
    "71885": 71853,
    "71886": 71854,
    "71887": 71855,
    "71888": 71856,
    "71889": 71857,
    "71890": 71858,
    "71891": 71859,
    "71892": 71860,
    "71893": 71861,
    "71894": 71862,
    "71895": 71863,
    "71896": 71864,
    "71897": 71865,
    "71898": 71866,
    "71899": 71867,
    "71900": 71868,
    "71901": 71869,
    "71902": 71870,
    "71903": 71871
  });
  var regenerate = require('regenerate');
  exports.REGULAR = {
    'd': regenerate().addRange(0x30, 0x39),
    'D': regenerate().addRange(0x0, 0x2F).addRange(0x3A, 0xFFFF),
    's': regenerate(0x20, 0xA0, 0x1680, 0x180E, 0x202F, 0x205F, 0x3000, 0xFEFF).addRange(0x9, 0xD).addRange(0x2000, 0x200A).addRange(0x2028, 0x2029),
    'S': regenerate().addRange(0x0, 0x8).addRange(0xE, 0x1F).addRange(0x21, 0x9F).addRange(0xA1, 0x167F).addRange(0x1681, 0x180D).addRange(0x180F, 0x1FFF).addRange(0x200B, 0x2027).addRange(0x202A, 0x202E).addRange(0x2030, 0x205E).addRange(0x2060, 0x2FFF).addRange(0x3001, 0xFEFE).addRange(0xFF00, 0xFFFF),
    'w': regenerate(0x5F).addRange(0x30, 0x39).addRange(0x41, 0x5A).addRange(0x61, 0x7A),
    'W': regenerate(0x60).addRange(0x0, 0x2F).addRange(0x3A, 0x40).addRange(0x5B, 0x5E).addRange(0x7B, 0xFFFF)
  };
  exports.UNICODE = {
    'd': regenerate().addRange(0x30, 0x39),
    'D': regenerate().addRange(0x0, 0x2F).addRange(0x3A, 0x10FFFF),
    's': regenerate(0x20, 0xA0, 0x1680, 0x180E, 0x202F, 0x205F, 0x3000, 0xFEFF).addRange(0x9, 0xD).addRange(0x2000, 0x200A).addRange(0x2028, 0x2029),
    'S': regenerate().addRange(0x0, 0x8).addRange(0xE, 0x1F).addRange(0x21, 0x9F).addRange(0xA1, 0x167F).addRange(0x1681, 0x180D).addRange(0x180F, 0x1FFF).addRange(0x200B, 0x2027).addRange(0x202A, 0x202E).addRange(0x2030, 0x205E).addRange(0x2060, 0x2FFF).addRange(0x3001, 0xFEFE).addRange(0xFF00, 0x10FFFF),
    'w': regenerate(0x5F).addRange(0x30, 0x39).addRange(0x41, 0x5A).addRange(0x61, 0x7A),
    'W': regenerate(0x60).addRange(0x0, 0x2F).addRange(0x3A, 0x40).addRange(0x5B, 0x5E).addRange(0x7B, 0x10FFFF)
  };
  exports.UNICODE_IGNORE_CASE = {
    'd': regenerate().addRange(0x30, 0x39),
    'D': regenerate().addRange(0x0, 0x2F).addRange(0x3A, 0x10FFFF),
    's': regenerate(0x20, 0xA0, 0x1680, 0x180E, 0x202F, 0x205F, 0x3000, 0xFEFF).addRange(0x9, 0xD).addRange(0x2000, 0x200A).addRange(0x2028, 0x2029),
    'S': regenerate().addRange(0x0, 0x8).addRange(0xE, 0x1F).addRange(0x21, 0x9F).addRange(0xA1, 0x167F).addRange(0x1681, 0x180D).addRange(0x180F, 0x1FFF).addRange(0x200B, 0x2027).addRange(0x202A, 0x202E).addRange(0x2030, 0x205E).addRange(0x2060, 0x2FFF).addRange(0x3001, 0xFEFE).addRange(0xFF00, 0x10FFFF),
    'w': regenerate(0x5F, 0x17F, 0x212A).addRange(0x30, 0x39).addRange(0x41, 0x5A).addRange(0x61, 0x7A),
    'W': regenerate(0x4B, 0x53, 0x60).addRange(0x0, 0x2F).addRange(0x3A, 0x40).addRange(0x5B, 0x5E).addRange(0x7B, 0x10FFFF)
  };
  modules['./data/character-class-escape-sets.js'] = {
    REGULAR: exports.REGULAR,
    UNICODE: exports.UNICODE,
    UNICODE_IGNORE_CASE: exports.UNICODE_IGNORE_CASE
  };
  var generate = require('regjsgen').generate;
  var parse = require('regjsparser').parse;
  var regenerate = require('regenerate');
  var iuMappings = require('./data/iu-mappings.json');
  var ESCAPE_SETS = require('./data/character-class-escape-sets.js');
  function getCharacterClassEscapeSet(character) {
    if (unicode) {
      if (ignoreCase) {
        return ESCAPE_SETS.UNICODE_IGNORE_CASE[character];
      }
      return ESCAPE_SETS.UNICODE[character];
    }
    return ESCAPE_SETS.REGULAR[character];
  }
  var object = {};
  var hasOwnProperty = object.hasOwnProperty;
  function has(object, property) {
    return hasOwnProperty.call(object, property);
  }
  var UNICODE_SET = regenerate().addRange(0x0, 0x10FFFF);
  var BMP_SET = regenerate().addRange(0x0, 0xFFFF);
  var DOT_SET_UNICODE = UNICODE_SET.clone().remove(0x000A, 0x000D, 0x2028, 0x2029);
  var DOT_SET = DOT_SET_UNICODE.clone().intersection(BMP_SET);
  regenerate.prototype.iuAddRange = function(min, max) {
    var $this = this;
    do {
      var folded = caseFold(min);
      if (folded) {
        $this.add(folded);
      }
    } while (++min <= max);
    return $this;
  };
  function assign(target, source) {
    for (var key in source) {
      target[key] = source[key];
    }
  }
  function update(item, pattern) {
    var tree = parse(pattern, '');
    switch (tree.type) {
      case 'characterClass':
      case 'group':
      case 'value':
        break;
      default:
        tree = wrap(tree, pattern);
    }
    assign(item, tree);
  }
  function wrap(tree, pattern) {
    return {
      'type': 'group',
      'behavior': 'ignore',
      'body': [tree],
      'raw': '(?:' + pattern + ')'
    };
  }
  function caseFold(codePoint) {
    return has(iuMappings, codePoint) ? iuMappings[codePoint] : false;
  }
  var ignoreCase = false;
  var unicode = false;
  function processCharacterClass(characterClassItem) {
    var set = regenerate();
    var body = characterClassItem.body.forEach(function(item) {
      switch (item.type) {
        case 'value':
          set.add(item.codePoint);
          if (ignoreCase && unicode) {
            var folded = caseFold(item.codePoint);
            if (folded) {
              set.add(folded);
            }
          }
          break;
        case 'characterClassRange':
          var min = item.min.codePoint;
          var max = item.max.codePoint;
          set.addRange(min, max);
          if (ignoreCase && unicode) {
            set.iuAddRange(min, max);
          }
          break;
        case 'characterClassEscape':
          set.add(getCharacterClassEscapeSet(item.value));
          break;
        default:
          throw Error('Unknown term type: ' + item.type);
      }
    });
    if (characterClassItem.negative) {
      set = (unicode ? UNICODE_SET : BMP_SET).clone().remove(set);
    }
    update(characterClassItem, set.toString());
    return characterClassItem;
  }
  function processTerm(item) {
    switch (item.type) {
      case 'dot':
        update(item, (unicode ? DOT_SET_UNICODE : DOT_SET).toString());
        break;
      case 'characterClass':
        item = processCharacterClass(item);
        break;
      case 'characterClassEscape':
        update(item, getCharacterClassEscapeSet(item.value).toString());
        break;
      case 'alternative':
      case 'disjunction':
      case 'group':
      case 'quantifier':
        item.body = item.body.map(processTerm);
        break;
      case 'value':
        var codePoint = item.codePoint;
        var set = regenerate(codePoint);
        if (ignoreCase && unicode) {
          var folded = caseFold(codePoint);
          if (folded) {
            set.add(folded);
          }
        }
        update(item, set.toString());
        break;
      case 'anchor':
      case 'empty':
      case 'group':
      case 'reference':
        break;
      default:
        throw Error('Unknown term type: ' + item.type);
    }
    return item;
  }
  ;
  module.exports = function(pattern, flags) {
    var tree = parse(pattern, flags);
    ignoreCase = flags ? flags.indexOf('i') > -1 : false;
    unicode = flags ? flags.indexOf('u') > -1 : false;
    assign(tree, processTerm(tree));
    return generate(tree);
  };
  var regexpuRewritePattern = module.exports;
  return {get regexpuRewritePattern() {
      return regexpuRewritePattern;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/RegularExpressionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/RegularExpressionTransformer.js";
  var ParseTreeTransformer = System.get("traceur@0.0.80/src/codegeneration/ParseTreeTransformer.js").ParseTreeTransformer;
  var LiteralExpression = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js").LiteralExpression;
  var LiteralToken = System.get("traceur@0.0.80/src/syntax/LiteralToken.js").LiteralToken;
  var REGULAR_EXPRESSION = System.get("traceur@0.0.80/src/syntax/TokenType.js").REGULAR_EXPRESSION;
  var regexpuRewritePattern = System.get("traceur@0.0.80/src/outputgeneration/regexpuRewritePattern.js").regexpuRewritePattern;
  var RegularExpressionTransformer = function RegularExpressionTransformer() {
    $traceurRuntime.superConstructor($RegularExpressionTransformer).apply(this, arguments);
  };
  var $RegularExpressionTransformer = RegularExpressionTransformer;
  ($traceurRuntime.createClass)(RegularExpressionTransformer, {transformLiteralExpression: function(tree) {
      var token = tree.literalToken;
      if (token.type === REGULAR_EXPRESSION) {
        var value = token.value;
        var lastIndex = value.lastIndexOf('/');
        var pattern = value.slice(1, lastIndex);
        var flags = value.slice(lastIndex + 1);
        if (flags.indexOf('u') !== -1) {
          var result = '/' + regexpuRewritePattern(pattern, flags) + '/' + flags.replace('u', '');
          return new LiteralExpression(tree.location, new LiteralToken(REGULAR_EXPRESSION, result, token.location));
        }
      }
      return tree;
    }}, {}, ParseTreeTransformer);
  return {get RegularExpressionTransformer() {
      return RegularExpressionTransformer;
    }};
});
System.registerModule("traceur@0.0.80/src/codegeneration/RestParameterTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.80/src/codegeneration/RestParameterTransformer.js";
  var $__0 = Object.freeze(Object.defineProperties(["\n            for (var ", " = [], ", " = ", ";\n                 ", " < arguments.length; ", "++)\n              ", "[", " - ", "] = arguments[", "];"], {raw: {value: Object.freeze(["\n            for (var ", " = [], ", " = ", ";\n                 ", " < arguments.length; ", "++)\n              ", "[", " - ", "] = arguments[", "];"])}})),
      $__1 = Object.freeze(Object.defineProperties(["\n            for (var ", " = [], ", " = 0;\n                 ", " < arguments.length; ", "++)\n              ", "[", "] = arguments[", "];"], {raw: {value: Object.freeze(["\n            for (var ", " = [], ", " = 0;\n                 ", " < arguments.length; ", "++)\n              ", "[", "] = arguments[", "];"])}}));
  var FormalParameterList = System.get("traceur@0.0.80/src/syntax/trees/ParseTrees.js").FormalParameterList;
  var ParameterTransformer = System.get("traceur@0.0.80/src/codegeneration/ParameterTransformer.js").ParameterTransformer;
  var createIdentifierToken = System.get("traceur@0.0.80/src/codegeneration/ParseTreeFactory.js").createIdentifierToken;
  var parseStatement = System.get("traceur@0.0.80/src/codegeneration/PlaceholderParser.js").parseStatement;
  function hasRestParameter(parameterList) {
    var parameters = parameterList.pa