[![Build Status](https://travis-ci.org/google/traceur-compiler.svg)](https://travis-ci.org/google/traceur-compiler)

<img src="https://google.github.com/traceur-compiler/logo/tc.svg" alt="Traceur logo" width="200px">
## What is Traceur?

Traceur is a JavaScript.next-to-JavaScript-of-today compiler that allows you to
use features from the future **today**. Traceur's goal is to inform the design
of new JavaScript features which are only valuable if they allow you to write
better code. Traceur allows you to try out new and proposed
[language features](https://github.com/google/traceur-compiler/wiki/LanguageFeatures)
today, helping you say what you mean in your code while informing the standards process.

JavaScript's evolution needs your input.
[Try](https://github.com/google/traceur-compiler/wiki/Getting-Started) out the
new language features.
[Tell us](http://groups.google.com/group/traceur-compiler-discuss)
how they work for you and what's still causing you to use more boilerplate and
"design patterns" than you prefer.

## What now? What can Traceur do for me?

Read the
[Getting Started](https://github.com/google/traceur-compiler/wiki/Getting-Started)
page to get up and running. You can use some language features right now and
even try it out in your browser
[here](https://google.github.io/traceur-compiler/demo/repl.html).
Just type in some code and see what Traceur produces. For an idea of what is
available and what we have in the pipeline, see the
[Language Features](https://github.com/google/traceur-compiler/wiki/LanguageFeatures)
page.

The JSConf 2011 presentation of Traceur describes the goals of the project and
what it can do today. Some documentation is on the wiki on this site.
Extra demos are in the source repository.

We also presented Traceur at NodeConf 2011. The video is
available on [YouTube](http://www.youtube.com/watch?feature=player_detailpage&v=ntDZa7ekFEA).

Questions, suggestions, and comments can be directed to the
[discussion group](http://groups.google.com/group/traceur-compiler-discuss).
