// Copyright 2013 Traceur Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file was auto generated by build-parse-trees.js
// from trees.json
// Do not edit!

import {ParseTree} from './ParseTree.js';
import * as ParseTreeType from './ParseTreeType.js';

var ANNOTATION = ParseTreeType.ANNOTATION;
export class Annotation extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} name
   * @param {ArgumentList} args
   */
  constructor(location, name, args) {
    this.location = location;
    this.name = name;
    this.args = args;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformAnnotation(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitAnnotation(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return ANNOTATION;
  }
}

var ANON_BLOCK = ParseTreeType.ANON_BLOCK;
export class AnonBlock extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} statements
   */
  constructor(location, statements) {
    this.location = location;
    this.statements = statements;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformAnonBlock(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitAnonBlock(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return ANON_BLOCK;
  }
}

var ARGUMENT_LIST = ParseTreeType.ARGUMENT_LIST;
export class ArgumentList extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} args
   */
  constructor(location, args) {
    this.location = location;
    this.args = args;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformArgumentList(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitArgumentList(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return ARGUMENT_LIST;
  }
}

var ARRAY_COMPREHENSION = ParseTreeType.ARRAY_COMPREHENSION;
export class ArrayComprehension extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} comprehensionList
   * @param {ParseTree} expression
   */
  constructor(location, comprehensionList, expression) {
    this.location = location;
    this.comprehensionList = comprehensionList;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformArrayComprehension(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitArrayComprehension(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return ARRAY_COMPREHENSION;
  }
}

var ARRAY_LITERAL_EXPRESSION = ParseTreeType.ARRAY_LITERAL_EXPRESSION;
export class ArrayLiteralExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} elements
   */
  constructor(location, elements) {
    this.location = location;
    this.elements = elements;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformArrayLiteralExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitArrayLiteralExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return ARRAY_LITERAL_EXPRESSION;
  }
}

var ARRAY_PATTERN = ParseTreeType.ARRAY_PATTERN;
export class ArrayPattern extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} elements
   */
  constructor(location, elements) {
    this.location = location;
    this.elements = elements;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformArrayPattern(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitArrayPattern(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return ARRAY_PATTERN;
  }
}

var ARRAY_TYPE = ParseTreeType.ARRAY_TYPE;
export class ArrayType extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} elementType
   */
  constructor(location, elementType) {
    this.location = location;
    this.elementType = elementType;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformArrayType(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitArrayType(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return ARRAY_TYPE;
  }
}

var ARROW_FUNCTION_EXPRESSION = ParseTreeType.ARROW_FUNCTION_EXPRESSION;
export class ArrowFunctionExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Token} functionKind
   * @param {FormalParameterList} parameterList
   * @param {ParseTree} body
   */
  constructor(location, functionKind, parameterList, body) {
    this.location = location;
    this.functionKind = functionKind;
    this.parameterList = parameterList;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformArrowFunctionExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitArrowFunctionExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return ARROW_FUNCTION_EXPRESSION;
  }
}

var ASSIGNMENT_ELEMENT = ParseTreeType.ASSIGNMENT_ELEMENT;
export class AssignmentElement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} assignment
   * @param {ParseTree} initializer
   */
  constructor(location, assignment, initializer) {
    this.location = location;
    this.assignment = assignment;
    this.initializer = initializer;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformAssignmentElement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitAssignmentElement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return ASSIGNMENT_ELEMENT;
  }
}

var AWAIT_EXPRESSION = ParseTreeType.AWAIT_EXPRESSION;
export class AwaitExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   */
  constructor(location, expression) {
    this.location = location;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformAwaitExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitAwaitExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return AWAIT_EXPRESSION;
  }
}

var BINARY_EXPRESSION = ParseTreeType.BINARY_EXPRESSION;
export class BinaryExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} left
   * @param {Token} operator
   * @param {ParseTree} right
   */
  constructor(location, left, operator, right) {
    this.location = location;
    this.left = left;
    this.operator = operator;
    this.right = right;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformBinaryExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitBinaryExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return BINARY_EXPRESSION;
  }
}

var BINDING_ELEMENT = ParseTreeType.BINDING_ELEMENT;
export class BindingElement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {BindingIdentifier|ObjectPattern|ArrayPattern} binding
   * @param {ParseTree} initializer
   */
  constructor(location, binding, initializer) {
    this.location = location;
    this.binding = binding;
    this.initializer = initializer;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformBindingElement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitBindingElement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return BINDING_ELEMENT;
  }
}

var BINDING_IDENTIFIER = ParseTreeType.BINDING_IDENTIFIER;
export class BindingIdentifier extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {IdentifierToken} identifierToken
   */
  constructor(location, identifierToken) {
    this.location = location;
    this.identifierToken = identifierToken;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformBindingIdentifier(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitBindingIdentifier(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return BINDING_IDENTIFIER;
  }
}

var BLOCK = ParseTreeType.BLOCK;
export class Block extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} statements
   */
  constructor(location, statements) {
    this.location = location;
    this.statements = statements;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformBlock(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitBlock(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return BLOCK;
  }
}

var BREAK_STATEMENT = ParseTreeType.BREAK_STATEMENT;
export class BreakStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {IdentifierToken} name
   */
  constructor(location, name) {
    this.location = location;
    this.name = name;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformBreakStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitBreakStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return BREAK_STATEMENT;
  }
}

var CALL_EXPRESSION = ParseTreeType.CALL_EXPRESSION;
export class CallExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} operand
   * @param {ArgumentList} args
   */
  constructor(location, operand, args) {
    this.location = location;
    this.operand = operand;
    this.args = args;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformCallExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitCallExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return CALL_EXPRESSION;
  }
}

var CALL_SIGNATURE = ParseTreeType.CALL_SIGNATURE;
export class CallSignature extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {TypeParameters} typeParameters
   * @param {FormalParameterList} parameterList
   * @param {ParseTree} returnType
   */
  constructor(location, typeParameters, parameterList, returnType) {
    this.location = location;
    this.typeParameters = typeParameters;
    this.parameterList = parameterList;
    this.returnType = returnType;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformCallSignature(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitCallSignature(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return CALL_SIGNATURE;
  }
}

var CASE_CLAUSE = ParseTreeType.CASE_CLAUSE;
export class CaseClause extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   * @param {Array<ParseTree>} statements
   */
  constructor(location, expression, statements) {
    this.location = location;
    this.expression = expression;
    this.statements = statements;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformCaseClause(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitCaseClause(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return CASE_CLAUSE;
  }
}

var CATCH = ParseTreeType.CATCH;
export class Catch extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} binding
   * @param {ParseTree} catchBody
   */
  constructor(location, binding, catchBody) {
    this.location = location;
    this.binding = binding;
    this.catchBody = catchBody;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformCatch(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitCatch(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return CATCH;
  }
}

var CLASS_DECLARATION = ParseTreeType.CLASS_DECLARATION;
export class ClassDeclaration extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {BindingIdentifier} name
   * @param {ParseTree} superClass
   * @param {Array<ParseTree>} elements
   * @param {Array<ParseTree>} annotations
   * @param {TypeParameters} typeParameters
   */
  constructor(location, name, superClass, elements, annotations, typeParameters) {
    this.location = location;
    this.name = name;
    this.superClass = superClass;
    this.elements = elements;
    this.annotations = annotations;
    this.typeParameters = typeParameters;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformClassDeclaration(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitClassDeclaration(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return CLASS_DECLARATION;
  }
}

var CLASS_EXPRESSION = ParseTreeType.CLASS_EXPRESSION;
export class ClassExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {BindingIdentifier} name
   * @param {ParseTree} superClass
   * @param {Array<ParseTree>} elements
   * @param {Array<ParseTree>} annotations
   * @param {TypeParameters} typeParameters
   */
  constructor(location, name, superClass, elements, annotations, typeParameters) {
    this.location = location;
    this.name = name;
    this.superClass = superClass;
    this.elements = elements;
    this.annotations = annotations;
    this.typeParameters = typeParameters;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformClassExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitClassExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return CLASS_EXPRESSION;
  }
}

var COMMA_EXPRESSION = ParseTreeType.COMMA_EXPRESSION;
export class CommaExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} expressions
   */
  constructor(location, expressions) {
    this.location = location;
    this.expressions = expressions;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformCommaExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitCommaExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return COMMA_EXPRESSION;
  }
}

var COMPREHENSION_FOR = ParseTreeType.COMPREHENSION_FOR;
export class ComprehensionFor extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} left
   * @param {ParseTree} iterator
   */
  constructor(location, left, iterator) {
    this.location = location;
    this.left = left;
    this.iterator = iterator;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformComprehensionFor(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitComprehensionFor(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return COMPREHENSION_FOR;
  }
}

var COMPREHENSION_IF = ParseTreeType.COMPREHENSION_IF;
export class ComprehensionIf extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   */
  constructor(location, expression) {
    this.location = location;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformComprehensionIf(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitComprehensionIf(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return COMPREHENSION_IF;
  }
}

var COMPUTED_PROPERTY_NAME = ParseTreeType.COMPUTED_PROPERTY_NAME;
export class ComputedPropertyName extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   */
  constructor(location, expression) {
    this.location = location;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformComputedPropertyName(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitComputedPropertyName(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return COMPUTED_PROPERTY_NAME;
  }
}

var CONDITIONAL_EXPRESSION = ParseTreeType.CONDITIONAL_EXPRESSION;
export class ConditionalExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} condition
   * @param {ParseTree} left
   * @param {ParseTree} right
   */
  constructor(location, condition, left, right) {
    this.location = location;
    this.condition = condition;
    this.left = left;
    this.right = right;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformConditionalExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitConditionalExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return CONDITIONAL_EXPRESSION;
  }
}

var CONSTRUCT_SIGNATURE = ParseTreeType.CONSTRUCT_SIGNATURE;
export class ConstructSignature extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {TypeParameters} typeParameters
   * @param {FormalParameterList} parameterList
   * @param {ParseTree} returnType
   */
  constructor(location, typeParameters, parameterList, returnType) {
    this.location = location;
    this.typeParameters = typeParameters;
    this.parameterList = parameterList;
    this.returnType = returnType;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformConstructSignature(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitConstructSignature(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return CONSTRUCT_SIGNATURE;
  }
}

var CONSTRUCTOR_TYPE = ParseTreeType.CONSTRUCTOR_TYPE;
export class ConstructorType extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {TypeParameters} typeParameters
   * @param {FormalParameterList} parameterList
   * @param {ParseTree} returnType
   */
  constructor(location, typeParameters, parameterList, returnType) {
    this.location = location;
    this.typeParameters = typeParameters;
    this.parameterList = parameterList;
    this.returnType = returnType;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformConstructorType(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitConstructorType(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return CONSTRUCTOR_TYPE;
  }
}

var CONTINUE_STATEMENT = ParseTreeType.CONTINUE_STATEMENT;
export class ContinueStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {IdentifierToken} name
   */
  constructor(location, name) {
    this.location = location;
    this.name = name;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformContinueStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitContinueStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return CONTINUE_STATEMENT;
  }
}

var COVER_FORMALS = ParseTreeType.COVER_FORMALS;
export class CoverFormals extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} expressions
   */
  constructor(location, expressions) {
    this.location = location;
    this.expressions = expressions;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformCoverFormals(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitCoverFormals(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return COVER_FORMALS;
  }
}

var COVER_INITIALIZED_NAME = ParseTreeType.COVER_INITIALIZED_NAME;
export class CoverInitializedName extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Token} name
   * @param {Token} equalToken
   * @param {ParseTree} initializer
   */
  constructor(location, name, equalToken, initializer) {
    this.location = location;
    this.name = name;
    this.equalToken = equalToken;
    this.initializer = initializer;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformCoverInitializedName(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitCoverInitializedName(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return COVER_INITIALIZED_NAME;
  }
}

var DEBUGGER_STATEMENT = ParseTreeType.DEBUGGER_STATEMENT;
export class DebuggerStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   */
  constructor(location) {
    this.location = location;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformDebuggerStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitDebuggerStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return DEBUGGER_STATEMENT;
  }
}

var DEFAULT_CLAUSE = ParseTreeType.DEFAULT_CLAUSE;
export class DefaultClause extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} statements
   */
  constructor(location, statements) {
    this.location = location;
    this.statements = statements;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformDefaultClause(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitDefaultClause(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return DEFAULT_CLAUSE;
  }
}

var DO_WHILE_STATEMENT = ParseTreeType.DO_WHILE_STATEMENT;
export class DoWhileStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Block|ParseTree} body
   * @param {ParseTree} condition
   */
  constructor(location, body, condition) {
    this.location = location;
    this.body = body;
    this.condition = condition;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformDoWhileStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitDoWhileStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return DO_WHILE_STATEMENT;
  }
}

var EMPTY_STATEMENT = ParseTreeType.EMPTY_STATEMENT;
export class EmptyStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   */
  constructor(location) {
    this.location = location;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformEmptyStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitEmptyStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return EMPTY_STATEMENT;
  }
}

var EXPORT_DECLARATION = ParseTreeType.EXPORT_DECLARATION;
export class ExportDeclaration extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} declaration
   * @param {Array<ParseTree>} annotations
   */
  constructor(location, declaration, annotations) {
    this.location = location;
    this.declaration = declaration;
    this.annotations = annotations;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformExportDeclaration(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitExportDeclaration(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return EXPORT_DECLARATION;
  }
}

var EXPORT_DEFAULT = ParseTreeType.EXPORT_DEFAULT;
export class ExportDefault extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   */
  constructor(location, expression) {
    this.location = location;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformExportDefault(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitExportDefault(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return EXPORT_DEFAULT;
  }
}

var EXPORT_SPECIFIER = ParseTreeType.EXPORT_SPECIFIER;
export class ExportSpecifier extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {IdentifierToken} lhs
   * @param {IdentifierToken} rhs
   */
  constructor(location, lhs, rhs) {
    this.location = location;
    this.lhs = lhs;
    this.rhs = rhs;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformExportSpecifier(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitExportSpecifier(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return EXPORT_SPECIFIER;
  }
}

var EXPORT_SPECIFIER_SET = ParseTreeType.EXPORT_SPECIFIER_SET;
export class ExportSpecifierSet extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ExportSpecifier>} specifiers
   */
  constructor(location, specifiers) {
    this.location = location;
    this.specifiers = specifiers;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformExportSpecifierSet(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitExportSpecifierSet(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return EXPORT_SPECIFIER_SET;
  }
}

var EXPORT_STAR = ParseTreeType.EXPORT_STAR;
export class ExportStar extends ParseTree {
  /**
   * @param {SourceRange} location
   */
  constructor(location) {
    this.location = location;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformExportStar(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitExportStar(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return EXPORT_STAR;
  }
}

var EXPRESSION_STATEMENT = ParseTreeType.EXPRESSION_STATEMENT;
export class ExpressionStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   */
  constructor(location, expression) {
    this.location = location;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformExpressionStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitExpressionStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return EXPRESSION_STATEMENT;
  }
}

var FINALLY = ParseTreeType.FINALLY;
export class Finally extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Block} block
   */
  constructor(location, block) {
    this.location = location;
    this.block = block;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformFinally(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitFinally(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return FINALLY;
  }
}

var FOR_IN_STATEMENT = ParseTreeType.FOR_IN_STATEMENT;
export class ForInStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} initializer
   * @param {ParseTree} collection
   * @param {Block|ParseTree} body
   */
  constructor(location, initializer, collection, body) {
    this.location = location;
    this.initializer = initializer;
    this.collection = collection;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformForInStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitForInStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return FOR_IN_STATEMENT;
  }
}

var FOR_OF_STATEMENT = ParseTreeType.FOR_OF_STATEMENT;
export class ForOfStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} initializer
   * @param {ParseTree} collection
   * @param {Block|ParseTree} body
   */
  constructor(location, initializer, collection, body) {
    this.location = location;
    this.initializer = initializer;
    this.collection = collection;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformForOfStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitForOfStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return FOR_OF_STATEMENT;
  }
}

var FOR_STATEMENT = ParseTreeType.FOR_STATEMENT;
export class ForStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} initializer
   * @param {ParseTree} condition
   * @param {ParseTree} increment
   * @param {Block|ParseTree} body
   */
  constructor(location, initializer, condition, increment, body) {
    this.location = location;
    this.initializer = initializer;
    this.condition = condition;
    this.increment = increment;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformForStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitForStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return FOR_STATEMENT;
  }
}

var FORMAL_PARAMETER = ParseTreeType.FORMAL_PARAMETER;
export class FormalParameter extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {BindingElement|RestParameter} parameter
   * @param {ParseTree} typeAnnotation
   * @param {Array<Annotation>} annotations
   */
  constructor(location, parameter, typeAnnotation, annotations) {
    this.location = location;
    this.parameter = parameter;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformFormalParameter(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitFormalParameter(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return FORMAL_PARAMETER;
  }
}

var FORMAL_PARAMETER_LIST = ParseTreeType.FORMAL_PARAMETER_LIST;
export class FormalParameterList extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<FormalParameter>} parameters
   */
  constructor(location, parameters) {
    this.location = location;
    this.parameters = parameters;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformFormalParameterList(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitFormalParameterList(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return FORMAL_PARAMETER_LIST;
  }
}

var FUNCTION_BODY = ParseTreeType.FUNCTION_BODY;
export class FunctionBody extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} statements
   */
  constructor(location, statements) {
    this.location = location;
    this.statements = statements;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformFunctionBody(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitFunctionBody(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return FUNCTION_BODY;
  }
}

var FUNCTION_DECLARATION = ParseTreeType.FUNCTION_DECLARATION;
export class FunctionDeclaration extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {BindingIdentifier} name
   * @param {Token} functionKind
   * @param {FormalParameterList} parameterList
   * @param {ParseTree} typeAnnotation
   * @param {Array<ParseTree>} annotations
   * @param {FunctionBody} body
   */
  constructor(location, name, functionKind, parameterList, typeAnnotation, annotations, body) {
    this.location = location;
    this.name = name;
    this.functionKind = functionKind;
    this.parameterList = parameterList;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformFunctionDeclaration(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitFunctionDeclaration(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return FUNCTION_DECLARATION;
  }
}

var FUNCTION_EXPRESSION = ParseTreeType.FUNCTION_EXPRESSION;
export class FunctionExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {BindingIdentifier} name
   * @param {Token} functionKind
   * @param {FormalParameterList} parameterList
   * @param {ParseTree} typeAnnotation
   * @param {Array<ParseTree>} annotations
   * @param {FunctionBody} body
   */
  constructor(location, name, functionKind, parameterList, typeAnnotation, annotations, body) {
    this.location = location;
    this.name = name;
    this.functionKind = functionKind;
    this.parameterList = parameterList;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformFunctionExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitFunctionExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return FUNCTION_EXPRESSION;
  }
}

var FUNCTION_TYPE = ParseTreeType.FUNCTION_TYPE;
export class FunctionType extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {TypeParameters} typeParameters
   * @param {FormalParameterList} parameterList
   * @param {ParseTree} returnType
   */
  constructor(location, typeParameters, parameterList, returnType) {
    this.location = location;
    this.typeParameters = typeParameters;
    this.parameterList = parameterList;
    this.returnType = returnType;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformFunctionType(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitFunctionType(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return FUNCTION_TYPE;
  }
}

var GENERATOR_COMPREHENSION = ParseTreeType.GENERATOR_COMPREHENSION;
export class GeneratorComprehension extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} comprehensionList
   * @param {ParseTree} expression
   */
  constructor(location, comprehensionList, expression) {
    this.location = location;
    this.comprehensionList = comprehensionList;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformGeneratorComprehension(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitGeneratorComprehension(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return GENERATOR_COMPREHENSION;
  }
}

var GET_ACCESSOR = ParseTreeType.GET_ACCESSOR;
export class GetAccessor extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {boolean} isStatic
   * @param {ParseTree} name
   * @param {ParseTree} typeAnnotation
   * @param {Array<ParseTree>} annotations
   * @param {FunctionBody} body
   */
  constructor(location, isStatic, name, typeAnnotation, annotations, body) {
    this.location = location;
    this.isStatic = isStatic;
    this.name = name;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformGetAccessor(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitGetAccessor(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return GET_ACCESSOR;
  }
}

var IDENTIFIER_EXPRESSION = ParseTreeType.IDENTIFIER_EXPRESSION;
export class IdentifierExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {IdentifierToken} identifierToken
   */
  constructor(location, identifierToken) {
    this.location = location;
    this.identifierToken = identifierToken;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformIdentifierExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitIdentifierExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return IDENTIFIER_EXPRESSION;
  }
}

var IF_STATEMENT = ParseTreeType.IF_STATEMENT;
export class IfStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} condition
   * @param {Block|ParseTree} ifClause
   * @param {Block|ParseTree} elseClause
   */
  constructor(location, condition, ifClause, elseClause) {
    this.location = location;
    this.condition = condition;
    this.ifClause = ifClause;
    this.elseClause = elseClause;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformIfStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitIfStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return IF_STATEMENT;
  }
}

var IMPORTED_BINDING = ParseTreeType.IMPORTED_BINDING;
export class ImportedBinding extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} binding
   */
  constructor(location, binding) {
    this.location = location;
    this.binding = binding;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformImportedBinding(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitImportedBinding(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return IMPORTED_BINDING;
  }
}

var IMPORT_DECLARATION = ParseTreeType.IMPORT_DECLARATION;
export class ImportDeclaration extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} importClause
   * @param {ParseTree} moduleSpecifier
   */
  constructor(location, importClause, moduleSpecifier) {
    this.location = location;
    this.importClause = importClause;
    this.moduleSpecifier = moduleSpecifier;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformImportDeclaration(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitImportDeclaration(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return IMPORT_DECLARATION;
  }
}

var IMPORT_SPECIFIER = ParseTreeType.IMPORT_SPECIFIER;
export class ImportSpecifier extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ImportedBinding} binding
   * @param {IdentifierToken} name
   */
  constructor(location, binding, name) {
    this.location = location;
    this.binding = binding;
    this.name = name;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformImportSpecifier(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitImportSpecifier(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return IMPORT_SPECIFIER;
  }
}

var IMPORT_SPECIFIER_SET = ParseTreeType.IMPORT_SPECIFIER_SET;
export class ImportSpecifierSet extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ImportSpecifier>} specifiers
   */
  constructor(location, specifiers) {
    this.location = location;
    this.specifiers = specifiers;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformImportSpecifierSet(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitImportSpecifierSet(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return IMPORT_SPECIFIER_SET;
  }
}

var INDEX_SIGNATURE = ParseTreeType.INDEX_SIGNATURE;
export class IndexSignature extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {IdentifierToken} name
   * @param {ParseTree} indexType
   * @param {ParseTree} typeAnnotation
   */
  constructor(location, name, indexType, typeAnnotation) {
    this.location = location;
    this.name = name;
    this.indexType = indexType;
    this.typeAnnotation = typeAnnotation;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformIndexSignature(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitIndexSignature(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return INDEX_SIGNATURE;
  }
}

var INTERFACE_DECLARATION = ParseTreeType.INTERFACE_DECLARATION;
export class InterfaceDeclaration extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {IdentifierToken} name
   * @param {TypeParameters} typeParameters
   * @param {Array.<ParseTree>} extendsClause
   * @param {ObjectType} objectType
   */
  constructor(location, name, typeParameters, extendsClause, objectType) {
    this.location = location;
    this.name = name;
    this.typeParameters = typeParameters;
    this.extendsClause = extendsClause;
    this.objectType = objectType;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformInterfaceDeclaration(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitInterfaceDeclaration(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return INTERFACE_DECLARATION;
  }
}

var LABELLED_STATEMENT = ParseTreeType.LABELLED_STATEMENT;
export class LabelledStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {IdentifierToken} name
   * @param {ParseTree} statement
   */
  constructor(location, name, statement) {
    this.location = location;
    this.name = name;
    this.statement = statement;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformLabelledStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitLabelledStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return LABELLED_STATEMENT;
  }
}

var LITERAL_EXPRESSION = ParseTreeType.LITERAL_EXPRESSION;
export class LiteralExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Token} literalToken
   */
  constructor(location, literalToken) {
    this.location = location;
    this.literalToken = literalToken;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformLiteralExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitLiteralExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return LITERAL_EXPRESSION;
  }
}

var LITERAL_PROPERTY_NAME = ParseTreeType.LITERAL_PROPERTY_NAME;
export class LiteralPropertyName extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Token} literalToken
   */
  constructor(location, literalToken) {
    this.location = location;
    this.literalToken = literalToken;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformLiteralPropertyName(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitLiteralPropertyName(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return LITERAL_PROPERTY_NAME;
  }
}

var MEMBER_EXPRESSION = ParseTreeType.MEMBER_EXPRESSION;
export class MemberExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} operand
   * @param {IdentifierToken} memberName
   */
  constructor(location, operand, memberName) {
    this.location = location;
    this.operand = operand;
    this.memberName = memberName;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformMemberExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitMemberExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return MEMBER_EXPRESSION;
  }
}

var MEMBER_LOOKUP_EXPRESSION = ParseTreeType.MEMBER_LOOKUP_EXPRESSION;
export class MemberLookupExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} operand
   * @param {ParseTree} memberExpression
   */
  constructor(location, operand, memberExpression) {
    this.location = location;
    this.operand = operand;
    this.memberExpression = memberExpression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformMemberLookupExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitMemberLookupExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return MEMBER_LOOKUP_EXPRESSION;
  }
}

var METHOD_SIGNATURE = ParseTreeType.METHOD_SIGNATURE;
export class MethodSignature extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} name
   * @param {boolean} optional
   * @param {CallSignature} callSignature
   */
  constructor(location, name, optional, callSignature) {
    this.location = location;
    this.name = name;
    this.optional = optional;
    this.callSignature = callSignature;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformMethodSignature(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitMethodSignature(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return METHOD_SIGNATURE;
  }
}

var MODULE = ParseTreeType.MODULE;
export class Module extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} scriptItemList
   * @param {string} moduleName
   */
  constructor(location, scriptItemList, moduleName) {
    this.location = location;
    this.scriptItemList = scriptItemList;
    this.moduleName = moduleName;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformModule(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitModule(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return MODULE;
  }
}

var MODULE_DECLARATION = ParseTreeType.MODULE_DECLARATION;
export class ModuleDeclaration extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ImportedBinding} binding
   * @param {ParseTree} expression
   */
  constructor(location, binding, expression) {
    this.location = location;
    this.binding = binding;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformModuleDeclaration(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitModuleDeclaration(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return MODULE_DECLARATION;
  }
}

var MODULE_SPECIFIER = ParseTreeType.MODULE_SPECIFIER;
export class ModuleSpecifier extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Token} token
   */
  constructor(location, token) {
    this.location = location;
    this.token = token;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformModuleSpecifier(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitModuleSpecifier(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return MODULE_SPECIFIER;
  }
}

var NAMED_EXPORT = ParseTreeType.NAMED_EXPORT;
export class NamedExport extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} moduleSpecifier
   * @param {ParseTree} specifierSet
   */
  constructor(location, moduleSpecifier, specifierSet) {
    this.location = location;
    this.moduleSpecifier = moduleSpecifier;
    this.specifierSet = specifierSet;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformNamedExport(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitNamedExport(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return NAMED_EXPORT;
  }
}

var NEW_EXPRESSION = ParseTreeType.NEW_EXPRESSION;
export class NewExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} operand
   * @param {ArgumentList} args
   */
  constructor(location, operand, args) {
    this.location = location;
    this.operand = operand;
    this.args = args;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformNewExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitNewExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return NEW_EXPRESSION;
  }
}

var OBJECT_LITERAL_EXPRESSION = ParseTreeType.OBJECT_LITERAL_EXPRESSION;
export class ObjectLiteralExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} propertyNameAndValues
   */
  constructor(location, propertyNameAndValues) {
    this.location = location;
    this.propertyNameAndValues = propertyNameAndValues;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformObjectLiteralExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitObjectLiteralExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return OBJECT_LITERAL_EXPRESSION;
  }
}

var OBJECT_PATTERN = ParseTreeType.OBJECT_PATTERN;
export class ObjectPattern extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} fields
   */
  constructor(location, fields) {
    this.location = location;
    this.fields = fields;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformObjectPattern(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitObjectPattern(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return OBJECT_PATTERN;
  }
}

var OBJECT_PATTERN_FIELD = ParseTreeType.OBJECT_PATTERN_FIELD;
export class ObjectPatternField extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} name
   * @param {ParseTree} element
   */
  constructor(location, name, element) {
    this.location = location;
    this.name = name;
    this.element = element;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformObjectPatternField(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitObjectPatternField(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return OBJECT_PATTERN_FIELD;
  }
}

var OBJECT_TYPE = ParseTreeType.OBJECT_TYPE;
export class ObjectType extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} typeMembers
   */
  constructor(location, typeMembers) {
    this.location = location;
    this.typeMembers = typeMembers;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformObjectType(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitObjectType(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return OBJECT_TYPE;
  }
}

var PAREN_EXPRESSION = ParseTreeType.PAREN_EXPRESSION;
export class ParenExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   */
  constructor(location, expression) {
    this.location = location;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformParenExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitParenExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return PAREN_EXPRESSION;
  }
}

var POSTFIX_EXPRESSION = ParseTreeType.POSTFIX_EXPRESSION;
export class PostfixExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} operand
   * @param {Token} operator
   */
  constructor(location, operand, operator) {
    this.location = location;
    this.operand = operand;
    this.operator = operator;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformPostfixExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitPostfixExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return POSTFIX_EXPRESSION;
  }
}

var PREDEFINED_TYPE = ParseTreeType.PREDEFINED_TYPE;
export class PredefinedType extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Token} typeToken
   */
  constructor(location, typeToken) {
    this.location = location;
    this.typeToken = typeToken;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformPredefinedType(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitPredefinedType(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return PREDEFINED_TYPE;
  }
}

var SCRIPT = ParseTreeType.SCRIPT;
export class Script extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} scriptItemList
   * @param {string} moduleName
   */
  constructor(location, scriptItemList, moduleName) {
    this.location = location;
    this.scriptItemList = scriptItemList;
    this.moduleName = moduleName;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformScript(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitScript(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return SCRIPT;
  }
}

var PROPERTY_METHOD_ASSIGNMENT = ParseTreeType.PROPERTY_METHOD_ASSIGNMENT;
export class PropertyMethodAssignment extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {boolean} isStatic
   * @param {Token} functionKind
   * @param {ParseTree} name
   * @param {FormalParameterList} parameterList
   * @param {ParseTree} typeAnnotation
   * @param {Array<ParseTree>} annotations
   * @param {FunctionBody} body
   */
  constructor(location, isStatic, functionKind, name, parameterList, typeAnnotation, annotations, body) {
    this.location = location;
    this.isStatic = isStatic;
    this.functionKind = functionKind;
    this.name = name;
    this.parameterList = parameterList;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformPropertyMethodAssignment(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitPropertyMethodAssignment(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return PROPERTY_METHOD_ASSIGNMENT;
  }
}

var PROPERTY_NAME_ASSIGNMENT = ParseTreeType.PROPERTY_NAME_ASSIGNMENT;
export class PropertyNameAssignment extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} name
   * @param {ParseTree} value
   */
  constructor(location, name, value) {
    this.location = location;
    this.name = name;
    this.value = value;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformPropertyNameAssignment(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitPropertyNameAssignment(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return PROPERTY_NAME_ASSIGNMENT;
  }
}

var PROPERTY_NAME_SHORTHAND = ParseTreeType.PROPERTY_NAME_SHORTHAND;
export class PropertyNameShorthand extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {IdentifierToken} name
   */
  constructor(location, name) {
    this.location = location;
    this.name = name;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformPropertyNameShorthand(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitPropertyNameShorthand(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return PROPERTY_NAME_SHORTHAND;
  }
}

var PROPERTY_VARIABLE_DECLARATION = ParseTreeType.PROPERTY_VARIABLE_DECLARATION;
export class PropertyVariableDeclaration extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {boolean} isStatic
   * @param {ParseTree} name
   * @param {ParseTree} typeAnnotation
   * @param {Array<ParseTree>} annotations
   */
  constructor(location, isStatic, name, typeAnnotation, annotations) {
    this.location = location;
    this.isStatic = isStatic;
    this.name = name;
    this.typeAnnotation = typeAnnotation;
    this.annotations = annotations;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformPropertyVariableDeclaration(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitPropertyVariableDeclaration(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return PROPERTY_VARIABLE_DECLARATION;
  }
}

var PROPERTY_SIGNATURE = ParseTreeType.PROPERTY_SIGNATURE;
export class PropertySignature extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} name
   * @param {boolean} optional
   * @param {ParseTree} typeAnnotation
   */
  constructor(location, name, optional, typeAnnotation) {
    this.location = location;
    this.name = name;
    this.optional = optional;
    this.typeAnnotation = typeAnnotation;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformPropertySignature(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitPropertySignature(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return PROPERTY_SIGNATURE;
  }
}

var REST_PARAMETER = ParseTreeType.REST_PARAMETER;
export class RestParameter extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {BindingIdentifier} identifier
   * @param {ParseTree} typeAnnotation
   */
  constructor(location, identifier, typeAnnotation) {
    this.location = location;
    this.identifier = identifier;
    this.typeAnnotation = typeAnnotation;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformRestParameter(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitRestParameter(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return REST_PARAMETER;
  }
}

var RETURN_STATEMENT = ParseTreeType.RETURN_STATEMENT;
export class ReturnStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   */
  constructor(location, expression) {
    this.location = location;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformReturnStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitReturnStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return RETURN_STATEMENT;
  }
}

var SET_ACCESSOR = ParseTreeType.SET_ACCESSOR;
export class SetAccessor extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {boolean} isStatic
   * @param {ParseTree} name
   * @param {FormalParameterList} parameterList
   * @param {Array<ParseTree>} annotations
   * @param {FunctionBody} body
   */
  constructor(location, isStatic, name, parameterList, annotations, body) {
    this.location = location;
    this.isStatic = isStatic;
    this.name = name;
    this.parameterList = parameterList;
    this.annotations = annotations;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformSetAccessor(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitSetAccessor(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return SET_ACCESSOR;
  }
}

var SPREAD_EXPRESSION = ParseTreeType.SPREAD_EXPRESSION;
export class SpreadExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   */
  constructor(location, expression) {
    this.location = location;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformSpreadExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitSpreadExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return SPREAD_EXPRESSION;
  }
}

var SPREAD_PATTERN_ELEMENT = ParseTreeType.SPREAD_PATTERN_ELEMENT;
export class SpreadPatternElement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} lvalue
   */
  constructor(location, lvalue) {
    this.location = location;
    this.lvalue = lvalue;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformSpreadPatternElement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitSpreadPatternElement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return SPREAD_PATTERN_ELEMENT;
  }
}

var SUPER_EXPRESSION = ParseTreeType.SUPER_EXPRESSION;
export class SuperExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   */
  constructor(location) {
    this.location = location;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformSuperExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitSuperExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return SUPER_EXPRESSION;
  }
}

var SWITCH_STATEMENT = ParseTreeType.SWITCH_STATEMENT;
export class SwitchStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   * @param {Array<ParseTree>} caseClauses
   */
  constructor(location, expression, caseClauses) {
    this.location = location;
    this.expression = expression;
    this.caseClauses = caseClauses;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformSwitchStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitSwitchStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return SWITCH_STATEMENT;
  }
}

var SYNTAX_ERROR_TREE = ParseTreeType.SYNTAX_ERROR_TREE;
export class SyntaxErrorTree extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Token} nextToken
   * @param {string} message
   */
  constructor(location, nextToken, message) {
    this.location = location;
    this.nextToken = nextToken;
    this.message = message;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformSyntaxErrorTree(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitSyntaxErrorTree(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return SYNTAX_ERROR_TREE;
  }
}

var TEMPLATE_LITERAL_EXPRESSION = ParseTreeType.TEMPLATE_LITERAL_EXPRESSION;
export class TemplateLiteralExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} operand
   * @param {Array<ParseTree>} elements
   */
  constructor(location, operand, elements) {
    this.location = location;
    this.operand = operand;
    this.elements = elements;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformTemplateLiteralExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitTemplateLiteralExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return TEMPLATE_LITERAL_EXPRESSION;
  }
}

var TEMPLATE_LITERAL_PORTION = ParseTreeType.TEMPLATE_LITERAL_PORTION;
export class TemplateLiteralPortion extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Token} value
   */
  constructor(location, value) {
    this.location = location;
    this.value = value;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformTemplateLiteralPortion(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitTemplateLiteralPortion(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return TEMPLATE_LITERAL_PORTION;
  }
}

var TEMPLATE_SUBSTITUTION = ParseTreeType.TEMPLATE_SUBSTITUTION;
export class TemplateSubstitution extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   */
  constructor(location, expression) {
    this.location = location;
    this.expression = expression;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformTemplateSubstitution(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitTemplateSubstitution(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return TEMPLATE_SUBSTITUTION;
  }
}

var THIS_EXPRESSION = ParseTreeType.THIS_EXPRESSION;
export class ThisExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   */
  constructor(location) {
    this.location = location;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformThisExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitThisExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return THIS_EXPRESSION;
  }
}

var THROW_STATEMENT = ParseTreeType.THROW_STATEMENT;
export class ThrowStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} value
   */
  constructor(location, value) {
    this.location = location;
    this.value = value;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformThrowStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitThrowStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return THROW_STATEMENT;
  }
}

var TRY_STATEMENT = ParseTreeType.TRY_STATEMENT;
export class TryStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Block} body
   * @param {Catch} catchBlock
   * @param {Finally} finallyBlock
   */
  constructor(location, body, catchBlock, finallyBlock) {
    this.location = location;
    this.body = body;
    this.catchBlock = catchBlock;
    this.finallyBlock = finallyBlock;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformTryStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitTryStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return TRY_STATEMENT;
  }
}

var TYPE_ARGUMENTS = ParseTreeType.TYPE_ARGUMENTS;
export class TypeArguments extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} args
   */
  constructor(location, args) {
    this.location = location;
    this.args = args;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformTypeArguments(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitTypeArguments(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return TYPE_ARGUMENTS;
  }
}

var TYPE_NAME = ParseTreeType.TYPE_NAME;
export class TypeName extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {TypeName} moduleName
   * @param {IdentifierToken} name
   */
  constructor(location, moduleName, name) {
    this.location = location;
    this.moduleName = moduleName;
    this.name = name;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformTypeName(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitTypeName(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return TYPE_NAME;
  }
}

var TYPE_PARAMETER = ParseTreeType.TYPE_PARAMETER;
export class TypeParameter extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {IdentifierToken} identifierToken
   * @param {ParseTree} extendsType
   */
  constructor(location, identifierToken, extendsType) {
    this.location = location;
    this.identifierToken = identifierToken;
    this.extendsType = extendsType;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformTypeParameter(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitTypeParameter(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return TYPE_PARAMETER;
  }
}

var TYPE_PARAMETERS = ParseTreeType.TYPE_PARAMETERS;
export class TypeParameters extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<TypeParameter>} parameters
   */
  constructor(location, parameters) {
    this.location = location;
    this.parameters = parameters;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformTypeParameters(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitTypeParameters(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return TYPE_PARAMETERS;
  }
}

var TYPE_REFERENCE = ParseTreeType.TYPE_REFERENCE;
export class TypeReference extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {TypeName} typeName
   * @param {TypeArguments} args
   */
  constructor(location, typeName, args) {
    this.location = location;
    this.typeName = typeName;
    this.args = args;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformTypeReference(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitTypeReference(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return TYPE_REFERENCE;
  }
}

var UNARY_EXPRESSION = ParseTreeType.UNARY_EXPRESSION;
export class UnaryExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Token} operator
   * @param {ParseTree} operand
   */
  constructor(location, operator, operand) {
    this.location = location;
    this.operator = operator;
    this.operand = operand;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformUnaryExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitUnaryExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return UNARY_EXPRESSION;
  }
}

var UNION_TYPE = ParseTreeType.UNION_TYPE;
export class UnionType extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {Array<ParseTree>} types
   */
  constructor(location, types) {
    this.location = location;
    this.types = types;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformUnionType(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitUnionType(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return UNION_TYPE;
  }
}

var VARIABLE_DECLARATION = ParseTreeType.VARIABLE_DECLARATION;
export class VariableDeclaration extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} lvalue
   * @param {ParseTree} typeAnnotation
   * @param {ParseTree} initializer
   */
  constructor(location, lvalue, typeAnnotation, initializer) {
    this.location = location;
    this.lvalue = lvalue;
    this.typeAnnotation = typeAnnotation;
    this.initializer = initializer;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformVariableDeclaration(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitVariableDeclaration(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return VARIABLE_DECLARATION;
  }
}

var VARIABLE_DECLARATION_LIST = ParseTreeType.VARIABLE_DECLARATION_LIST;
export class VariableDeclarationList extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {TokenType} declarationType
   * @param {Array<VariableDeclaration>} declarations
   */
  constructor(location, declarationType, declarations) {
    this.location = location;
    this.declarationType = declarationType;
    this.declarations = declarations;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformVariableDeclarationList(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitVariableDeclarationList(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return VARIABLE_DECLARATION_LIST;
  }
}

var VARIABLE_STATEMENT = ParseTreeType.VARIABLE_STATEMENT;
export class VariableStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {VariableDeclarationList} declarations
   */
  constructor(location, declarations) {
    this.location = location;
    this.declarations = declarations;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformVariableStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitVariableStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return VARIABLE_STATEMENT;
  }
}

var WHILE_STATEMENT = ParseTreeType.WHILE_STATEMENT;
export class WhileStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} condition
   * @param {Block|ParseTree} body
   */
  constructor(location, condition, body) {
    this.location = location;
    this.condition = condition;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformWhileStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitWhileStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return WHILE_STATEMENT;
  }
}

var WITH_STATEMENT = ParseTreeType.WITH_STATEMENT;
export class WithStatement extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   * @param {Block|ParseTree} body
   */
  constructor(location, expression, body) {
    this.location = location;
    this.expression = expression;
    this.body = body;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformWithStatement(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitWithStatement(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return WITH_STATEMENT;
  }
}

var YIELD_EXPRESSION = ParseTreeType.YIELD_EXPRESSION;
export class YieldExpression extends ParseTree {
  /**
   * @param {SourceRange} location
   * @param {ParseTree} expression
   * @param {boolean} isYieldFor
   */
  constructor(location, expression, isYieldFor) {
    this.location = location;
    this.expression = expression;
    this.isYieldFor = isYieldFor;
  }

  /**
   * @param {ParseTreeTransformer} transformer
   */
  transform(transformer) {
    return transformer.transformYieldExpression(this);
  }

  /**
   * @param {ParseTreeVisitor} visitor
   */
  visit(visitor) {
    visitor.visitYieldExpression(this);
  }

  /**
   * @type {ParseTreeType}
   */
  get type() {
    return YIELD_EXPRESSION;
  }
}
