/**
 * @license
 * Copyright (c) 2014 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
 */

suite('Range', function() {

  var wrap = ShadowDOMPolyfill.wrap;

  var div;

  teardown(function() {
    if (div && div.parentNode)
      div.parentNode.removeChild(div);
    div = undefined;
  });

  test('instanceof', function() {
    var range = document.createRange();
    assert.instanceOf(range, Range);

    var range2 = wrap(document).createRange();
    assert.instanceOf(range2, Range);
  });

  test('constructor', function() {
    var range = document.createRange();
    assert.equal(Range, range.constructor);
  });

  test('createContextualFragment', function() {
    // IE9 does not support createContextualFragment.
    if (!Range.prototype.createContextualFragment)
      return;

    var range = document.createRange();
    var container = document.body || document.head;

    range.selectNode(container);

    var fragment = range.createContextualFragment('<b></b>');

    assert.instanceOf(fragment, DocumentFragment);
    assert.equal(fragment.firstChild.localName, 'b');
    assert.equal(fragment.childNodes.length, 1);
  });

  test('WebIDL attributes', function() {
    var range = document.createRange();

    assert.isTrue('collapsed' in range);
    assert.isFalse(range.hasOwnProperty('collapsed'));

    assert.isTrue('commonAncestorContainer' in range);
    assert.isFalse(range.hasOwnProperty('commonAncestorContainer'));

    assert.isTrue('endContainer' in range);
    assert.isFalse(range.hasOwnProperty('endContainer'));

    assert.isTrue('endOffset' in range);
    assert.isFalse(range.hasOwnProperty('endOffset'));

    assert.isTrue('startContainer' in range);
    assert.isFalse(range.hasOwnProperty('startContainer'));

    assert.isTrue('startOffset' in range);
    assert.isFalse(range.hasOwnProperty('startOffset'));
  });

  test('toString', function() {
    var range = document.createRange();
    div = document.createElement('div');
    document.body.appendChild(div);
    div.innerHTML = '<a>a</a><b>b</b><c>c</c>';
    var a = div.firstChild;
    var b = a.nextSibling;
    range.selectNode(b);
    assert.equal(range.toString(), 'b');
  });

});
