
(function(global, $, UI){


    UI.component('toggle', {

        defaults: {
            target: false,
            cls: 'uk-hidden'
        },

        init: function() {

            var $this = this;

            this.totoggle = this.options.target ? $(this.options.target):[];

            this.on("click", function(e) {
                if ($this.element.is('a[href="#"]')) e.preventDefault();
                $this.toggle();
            });
        },

        toggle: function() {

            if(!this.totoggle.length) return;

            this.totoggle.toggleClass(this.options.cls);

            if(this.options.cls == 'uk-hidden') {
                $(document).trigger("uk-check-display");
            }
        }
    });

    $(document).on("uk-domready", function(e) {

        $("[data-uk-toggle]").each(function() {
            var ele = $(this);

            if (!ele.data("toggle")) {
               var obj = UI.toggle(ele, UI.Utils.options(ele.attr("data-uk-toggle")));
            }
        });
    });

})(this, jQuery, jQuery.UIkit);