/*! UIkit 2.9.0 | http://www.getuikit.com | (c) 2014 YOOtheme | MIT License */

(function(addon) {

    var component;

    if (jQuery && jQuery.UIkit) {
        component = addon(jQuery, jQuery.UIkit);
    }

    if (typeof define == "function" && define.amd) {
        define("uikit-search", ["uikit"], function(){
            return component || addon(jQuery, jQuery.UIkit);
        });
    }

})(function($, UI){

    "use strict";

    var times = {'12h':[], '24h':[]};

    for(var i = 0, h=''; i<24; i++) {

        h = ''+i;

        if(i<10)  h = '0'+h;

        times['24h'].push({value: (h+':00')});
        times['24h'].push({value: (h+':30')});

        if (i<13) {
            times['12h'].push({value: (h+':00 AM')});
            times['12h'].push({value: (h+':30 AM')});
        }

        if (i > 12) {

            h = h-12;

            if (h < 10) h = '0'+String(h);

            times['12h'].push({value: (h+':00 PM')});
            times['12h'].push({value: (h+':30 PM')});
        }
    }


    UI.component('timepicker', {

        defaults: {
            format : '24h',
            delay  : 0
        },

        init: function() {

            var $this  = this;

            this.options.minLength = 0;
            this.options.template  = '<ul class="uk-nav uk-nav-autocomplete uk-autocomplete-results">{{~items}}<li data-value="{{$item.value}}"><a>{{$item.value}}</a></li>{{/items}}</ul>';

            this.options.source = function(release) {
                release(times[$this.options.format] || times['12h']);
            };

            this.element.wrap('<div class="uk-autocomplete"></div>');

            this.autocomplete = UI.autocomplete(this.element.parent(), this.options);
            this.autocomplete.dropdown.addClass('uk-dropdown-small uk-dropdown-scrollable');

            this.autocomplete.on('autocomplete-show', function() {

                var selected = $this.autocomplete.dropdown.find('[data-value="'+$this.autocomplete.input.val()+'"]');

                setTimeout(function(){
                    $this.autocomplete.pick(selected, true);
                }, 10);
            });

            this.autocomplete.input.on('focus', function(){

                $this.autocomplete.value = Math.random();
                $this.autocomplete.triggercomplete();

            }).on('blur', function() {
                $this.checkTime();
            });

            this.element.data("timepicker", this);
        },

        checkTime: function() {

            var arr, timeArray, meridian = 'AM', hour, minute, time = this.autocomplete.input.val();

            if (this.options.format == '12h') {
                arr = time.split(' ');
                timeArray = arr[0].split(':');
                meridian = arr[1];
            } else {
                timeArray = time.split(':');
            }

            hour   = parseInt(timeArray[0], 10);
            minute = parseInt(timeArray[1], 10);

            if (isNaN(hour))   hour = 0;
            if (isNaN(minute)) minute = 0;

            if (this.options.format == '12h') {
                if (hour > 12) {
                    hour = 12;
                } else if (hour < 0) {
                    hour = 12;
                }

                if (meridian === 'am' || meridian === 'a') {
                    meridian = 'AM';
                } else if (meridian === 'pm' || meridian === 'p') {
                    meridian = 'PM';
                }

                if (meridian !== 'AM' && meridian !== 'PM') {
                    meridian = 'AM';
                }

            } else {

                if (hour >= 24) {
                    hour = 23;
                } else if (hour < 0) {
                    hour = 0;
                }
            }

            if (minute < 0) {
                minute = 0;
            } else if (minute >= 60) {
                minute = 0;
            }

            this.autocomplete.input.val(this.formatTime(hour, minute, meridian));
        },

        formatTime: function(hour, minute, meridian) {
            hour = hour < 10 ? '0' + hour : hour;
            minute = minute < 10 ? '0' + minute : minute;
            return hour + ':' + minute + (this.options.format == '12h' ? ' ' + meridian : '');
        }
    });

    // init code
    UI.$doc.on("focus.timepicker.uikit", "[data-uk-timepicker]", function(e) {
        var ele = $(this);

        if (!ele.data("timepicker")) {
            var obj = UI.timepicker(ele, UI.Utils.options(ele.attr("data-uk-timepicker")));

            setTimeout(function(){
                obj.autocomplete.input.focus();
            }, 20);
        }
    });
});
