/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class WebJarVersionLocator {
    public static final String WEBJARS_PATH_PREFIX = "META-INF/resources/webjars";
    private static final String PROPERTIES_ROOT = "META-INF/maven/";
    private static final String NPM = "org.webjars.npm/";
    private static final String PLAIN = "org.webjars/";
    private static final String POM_PROPERTIES = "/pom.properties";
    private static final ClassLoader LOADER = WebJarVersionLocator.class.getClassLoader();

    public static @Nullable String fullPath(String webJarName, String exactPath) {
        String version = WebJarVersionLocator.webJarVersion(webJarName);
        String fullPath = String.format("%s/%s/%s", WEBJARS_PATH_PREFIX, webJarName, exactPath);
        if (!WebJarVersionLocator.isEmpty(version) && !exactPath.startsWith(version)) {
            fullPath = String.format("%s/%s/%s/%s", WEBJARS_PATH_PREFIX, webJarName, version, exactPath);
        }
        if (LOADER.getResource(fullPath) != null) {
            return fullPath;
        }
        return null;
    }

    public static @Nullable String webJarVersion(String webJarName) {
        InputStream resource = LOADER.getResourceAsStream("META-INF/maven/org.webjars.npm/" + webJarName + POM_PROPERTIES);
        if (resource == null) {
            resource = LOADER.getResourceAsStream("META-INF/maven/org.webjars/" + webJarName + POM_PROPERTIES);
        }
        if (resource != null) {
            Properties properties = new Properties();
            try {
                properties.load(resource);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String version = properties.getProperty("version");
            if (version != null) {
                if (WebJarVersionLocator.hasResourcePath(webJarName, version)) {
                    return version;
                }
                if (version.contains("-") && WebJarVersionLocator.hasResourcePath(webJarName, version = version.substring(0, version.indexOf("-")))) {
                    return version;
                }
            }
        }
        return null;
    }

    private static boolean hasResourcePath(String webJarName, String path) {
        return LOADER.getResource("META-INF/resources/webjars/" + webJarName + "/" + path) != null;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

