/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.WebJarAssetLocator;

public final class RequireJS {
    private static final Logger log = LoggerFactory.getLogger(RequireJS.class);
    protected static String setupJavaScript = null;

    public static synchronized String getSetupJavaScript(String webjarUrlPrefix) {
        if (setupJavaScript == null) {
            Map<String, String> webjars = new WebJarAssetLocator().getWebJars();
            StringBuilder webjarsVersionsString = new StringBuilder();
            StringBuilder webjarConfigsString = new StringBuilder();
            for (Map.Entry<String, String> webjar : webjars.entrySet()) {
                webjarsVersionsString.append("'").append(webjar.getKey()).append("': '").append(webjar.getValue()).append("', ");
                webjarConfigsString.append(RequireJS.getWebJarConfig(webjar));
            }
            webjarsVersionsString.delete(webjarsVersionsString.length() - 2, webjarsVersionsString.length());
            setupJavaScript = "var webjars = {\n    versions: { " + webjarsVersionsString + " },\n" + "    path: function(webjarid, path) {\n" + "        return '" + webjarUrlPrefix + "' + webjarid + '/' + webjars.versions[webjarid] + '/' + path;\n" + "    }\n" + "};\n" + "\n" + "var require = {\n" + "    callback: function() {\n" + "        // no-op webjars requirejs plugin loader for backwards compatibility\n" + "        define('webjars', function () {\n" + "            return { load: function (name, req, onload, config) { onload(); } }\n" + "        });\n" + "\n" + "        // all of the webjar configs from their webjars-requirejs.js files\n" + webjarConfigsString + "    }\n" + "}";
        }
        return setupJavaScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getWebJarConfig(Map.Entry<String, String> webjar) {
        String webjarConfig = "";
        String filename = "META-INF/resources/webjars/" + webjar.getKey() + "/" + webjar.getValue() + "/" + "webjars-requirejs.js";
        InputStream inputStream = RequireJS.class.getClassLoader().getResourceAsStream(filename);
        if (inputStream != null) {
            StringBuilder webjarConfigBuilder = new StringBuilder("// webjar config for " + webjar.getKey() + "\n");
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    webjarConfigBuilder.append(line);
                }
                webjarConfig = webjarConfigBuilder.toString();
            }
            catch (IOException e) {
                log.warn(filename + " could not be read.");
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return webjarConfig;
    }
}

