/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.webjars.WebJarAssetLocator;
import org.xml.sax.SAXException;

public final class RequireJS {
    public static final String WEBJARS_MAVEN_PREFIX = "META-INF/maven/org.webjars";
    private static final Logger log = LoggerFactory.getLogger(RequireJS.class);
    private static String requireConfigJavaScript;
    private static String requireConfigJavaScriptCdn;
    private static Map<String, ObjectNode> requireConfigJson;
    private static Map<String, ObjectNode> requireConfigJsonCdn;

    public static synchronized String getSetupJavaScript(String urlPrefix) {
        if (requireConfigJavaScript == null) {
            ArrayList<String> prefixes = new ArrayList<String>();
            prefixes.add(urlPrefix);
            requireConfigJavaScript = RequireJS.generateSetupJavaScript(prefixes);
        }
        return requireConfigJavaScript;
    }

    public static synchronized String getSetupJavaScript(String cdnPrefix, String urlPrefix) {
        if (requireConfigJavaScriptCdn == null) {
            ArrayList<String> prefixes = new ArrayList<String>();
            prefixes.add(cdnPrefix);
            prefixes.add(urlPrefix);
            requireConfigJavaScriptCdn = RequireJS.generateSetupJavaScript(prefixes);
        }
        return requireConfigJavaScriptCdn;
    }

    public static String generateSetupJavaScript(List<String> prefixes) {
        Map<String, String> webJars = new WebJarAssetLocator().getWebJars();
        return RequireJS.generateSetupJavaScript(prefixes, webJars);
    }

    @Deprecated
    public static String generateSetupJavaScript(List<String> prefixes, Map<String, String> webJars) {
        ArrayList<Map.Entry<String, Boolean>> prefixesWithVersion = new ArrayList<Map.Entry<String, Boolean>>();
        for (String prefix : prefixes) {
            prefixesWithVersion.add(new AbstractMap.SimpleEntry<String, Boolean>(prefix, true));
        }
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode webJarsVersions = mapper.createObjectNode();
        StringBuilder webJarConfigsString = new StringBuilder();
        if (webJars.isEmpty()) {
            log.warn("Can't find any WebJars in the classpath, RequireJS configuration will be empty.");
        } else {
            for (Map.Entry<String, String> webJar : webJars.entrySet()) {
                webJarsVersions.put(webJar.getKey(), webJar.getValue());
                ObjectNode webJarObjectNode = RequireJS.getWebJarRequireJsConfig(webJar, prefixesWithVersion);
                if (webJarObjectNode.size() != 0) {
                    webJarConfigsString.append("\n").append("requirejs.config(").append(webJarObjectNode.toString()).append(")");
                    continue;
                }
                webJarConfigsString.append("\n").append(RequireJS.getWebJarConfig(webJar));
            }
        }
        String webJarBasePath = "webJarId + '/' + webjars.versions[webJarId] + '/' + path";
        StringBuilder webJarPath = new StringBuilder("[");
        for (String prefix : prefixes) {
            webJarPath.append("'").append(prefix).append("' + ").append(webJarBasePath).append(",\n");
        }
        webJarPath.delete(webJarPath.lastIndexOf(",\n"), webJarPath.lastIndexOf(",\n") + 2);
        webJarPath.append("]");
        return "var webjars = {\n    versions: " + webJarsVersions.toString() + ",\n" + "    path: function(webJarId, path) {\n" + "        console.error('The webjars.path() method of getting a WebJar path has been deprecated.  The RequireJS config in the ' + webJarId + ' WebJar may need to be updated.  Please file an issue: http://github.com/webjars/' + webJarId + '/issues/new');\n" + "        return " + webJarPath.toString() + ";\n" + "    }\n" + "};\n" + "\n" + "var require = {\n" + "    callback: function() {\n" + "        // Deprecated WebJars RequireJS plugin loader\n" + "        define('webjars', function() {\n" + "            return {\n" + "                load: function(name, req, onload, config) {\n" + "                    if (name.indexOf('.js') >= 0) {\n" + "                        console.warn('Detected a legacy file name (' + name + ') as the thing to load.  Loading via file name is no longer supported so the .js will be dropped in an effort to resolve the module name instead.');\n" + "                        name = name.replace('.js', '');\n" + "                    }\n" + "                    console.error('The webjars plugin loader (e.g. webjars!' + name + ') has been deprecated.  The RequireJS config in the ' + name + ' WebJar may need to be updated.  Please file an issue: http://github.com/webjars/webjars/issues/new');\n" + "                    req([name], function() {;\n" + "                        onload();\n" + "                    });\n" + "                }\n" + "            }\n" + "        });\n" + "\n" + "        // All of the WebJar configs\n\n" + webJarConfigsString + "    }\n" + "}";
    }

    public static synchronized Map<String, ObjectNode> getSetupJson(String urlPrefix) {
        if (requireConfigJson == null) {
            ArrayList<Map.Entry<String, Boolean>> prefixes = new ArrayList<Map.Entry<String, Boolean>>();
            prefixes.add(new AbstractMap.SimpleEntry<String, Boolean>(urlPrefix, true));
            requireConfigJson = RequireJS.generateSetupJson(prefixes);
        }
        return requireConfigJson;
    }

    public static synchronized Map<String, ObjectNode> getSetupJson(String cdnPrefix, String urlPrefix) {
        if (requireConfigJsonCdn == null) {
            ArrayList<Map.Entry<String, Boolean>> prefixes = new ArrayList<Map.Entry<String, Boolean>>();
            prefixes.add(new AbstractMap.SimpleEntry<String, Boolean>(cdnPrefix, true));
            prefixes.add(new AbstractMap.SimpleEntry<String, Boolean>(urlPrefix, true));
            requireConfigJsonCdn = RequireJS.generateSetupJson(prefixes);
        }
        return requireConfigJsonCdn;
    }

    public static Map<String, ObjectNode> generateSetupJson(List<Map.Entry<String, Boolean>> prefixes) {
        Map<String, String> webJars = new WebJarAssetLocator().getWebJars();
        HashMap<String, ObjectNode> jsonConfigs = new HashMap<String, ObjectNode>();
        for (Map.Entry<String, String> webJar : webJars.entrySet()) {
            jsonConfigs.put(webJar.getKey(), RequireJS.getWebJarRequireJsConfig(webJar, prefixes));
        }
        return jsonConfigs;
    }

    public static ObjectNode getWebJarRequireJsConfig(Map.Entry<String, String> webJar, List<Map.Entry<String, Boolean>> prefixes) {
        ObjectNode webJarRequireJsNode;
        block12: {
            String rawRequireJsConfig = RequireJS.getRawWebJarRequireJsConfig(webJar);
            ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            webJarRequireJsNode = mapper.createObjectNode();
            try {
                JsonNode maybeRequireJsConfig = mapper.readTree(rawRequireJsConfig);
                if (maybeRequireJsConfig.isObject()) {
                    webJarRequireJsNode = (ObjectNode)maybeRequireJsConfig;
                    if (webJarRequireJsNode.isObject()) {
                        ObjectNode pathsNode = (ObjectNode)webJarRequireJsNode.get("paths");
                        ObjectNode newPaths = mapper.createObjectNode();
                        Iterator paths = pathsNode.fields();
                        while (paths.hasNext()) {
                            Map.Entry pathNode = (Map.Entry)paths.next();
                            String originalPath = null;
                            if (((JsonNode)pathNode.getValue()).isArray()) {
                                ArrayNode nodePaths = (ArrayNode)pathNode.getValue();
                                originalPath = nodePaths.get(0).asText();
                            } else if (((JsonNode)pathNode.getValue()).isTextual()) {
                                TextNode nodePath = (TextNode)pathNode.getValue();
                                originalPath = nodePath.textValue();
                            }
                            if (originalPath != null) {
                                ArrayNode newPathsNode = newPaths.putArray((String)pathNode.getKey());
                                for (Map.Entry<String, Boolean> prefix : prefixes) {
                                    String newPath = prefix.getKey() + webJar.getKey();
                                    if (prefix.getValue().booleanValue()) {
                                        newPath = newPath + "/" + webJar.getValue();
                                    }
                                    newPath = newPath + "/" + originalPath;
                                    newPathsNode.add(newPath);
                                }
                                newPathsNode.add(originalPath);
                                continue;
                            }
                            log.error("Strange... The path could not be parsed.  Here is what was provided: " + ((JsonNode)pathNode.getValue()).toString());
                        }
                        webJarRequireJsNode.replace("paths", (JsonNode)newPaths);
                    }
                } else {
                    log.error(RequireJS.requireJsConfigErrorMessage(webJar));
                }
            }
            catch (IOException e) {
                log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
                if (rawRequireJsConfig.length() <= 0) break block12;
                log.error(e.getMessage());
            }
        }
        return webJarRequireJsNode;
    }

    private static String requireJsConfigErrorMessage(Map.Entry<String, String> webJar) {
        return "Could not read WebJar RequireJS config for: " + webJar.getKey() + " " + webJar.getValue() + "\n" + "Please file a bug at: http://github.com/webjars/" + webJar.getKey() + "/issues/new";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRawWebJarRequireJsConfig(Map.Entry<String, String> webJar) {
        String filename = "META-INF/maven/org.webjars/" + webJar.getKey() + "/pom.xml";
        InputStream inputStream = RequireJS.class.getClassLoader().getResourceAsStream(filename);
        if (inputStream != null) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(inputStream);
                doc.getDocumentElement().normalize();
                NodeList propertiesNodes = doc.getElementsByTagName("properties");
                for (int i = 0; i < propertiesNodes.getLength(); ++i) {
                    NodeList propertyNodes = propertiesNodes.item(i).getChildNodes();
                    for (int j = 0; j < propertyNodes.getLength(); ++j) {
                        Node node = propertyNodes.item(j);
                        if (!node.getNodeName().equals("requirejs")) continue;
                        String string = node.getTextContent();
                        return string;
                    }
                }
            }
            catch (ParserConfigurationException e) {
                log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
            }
            catch (IOException e) {
                log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
            }
            catch (SAXException e) {
                log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        } else {
            log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getWebJarConfig(Map.Entry<String, String> webJar) {
        String webJarConfig = "";
        String filename = "META-INF/resources/webjars/" + webJar.getKey() + "/" + webJar.getValue() + "/" + "webjars-requirejs.js";
        InputStream inputStream = RequireJS.class.getClassLoader().getResourceAsStream(filename);
        if (inputStream != null) {
            log.warn("The " + webJar.getKey() + " " + webJar.getValue() + " WebJar is using the legacy RequireJS config.\n" + "Please try a new version of the WebJar or file or file an issue at:\n" + "http://github.com/webjars/" + webJar.getKey() + "/issues/new");
            StringBuilder webJarConfigBuilder = new StringBuilder("// WebJar config for " + webJar.getKey() + "\n");
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    webJarConfigBuilder.append(line).append("\n");
                }
                webJarConfig = webJarConfigBuilder.toString();
            }
            catch (IOException e) {
                log.warn(filename + " could not be read.");
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return webJarConfig;
    }
}

