/*
 * Decompiled with CFR 0.152.
 */
package org.webjars.urlprotocols;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.webjars.CloseQuietly;
import org.webjars.urlprotocols.UrlProtocolHandler;

public class JarUrlProtocolHandler
implements UrlProtocolHandler {
    @Override
    public boolean accepts(String protocol) {
        return "jar".equals(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAssetPaths(URL url, Pattern filterExpr, ClassLoader ... classLoaders) {
        JarFile jarFile;
        HashSet<String> assetPaths = new HashSet<String>();
        try {
            String path = url.getPath();
            File file = new File(URI.create(path.substring(0, path.indexOf("!"))));
            jarFile = new JarFile(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String assetPathCandidate = entry.getName();
                if (entry.isDirectory() || !filterExpr.matcher(assetPathCandidate).matches()) continue;
                assetPaths.add(assetPathCandidate);
            }
        }
        finally {
            CloseQuietly.closeQuietly(jarFile);
        }
        return assetPaths;
    }
}

