/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetLocator {
    public static final String[] WEBJARS_PATH_PREFIX = new String[]{"META-INF", "resources", "webjars"};

    public static String getFullPath(String partialPath) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().addUrls((Collection)ClasspathHelper.forPackage((String)StringUtils.join((Object[])WEBJARS_PATH_PREFIX, (String)"."), (ClassLoader[])new ClassLoader[]{AssetLocator.class.getClassLoader()})).setScanners(new Scanner[]{new ResourcesScanner()});
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        if (partialPath.contains("/")) {
            String foundPath = null;
            for (Multimap paths : reflections.getStore().getStoreMap().values()) {
                for (String path : paths.values()) {
                    if (!path.endsWith(partialPath)) continue;
                    if (foundPath != null) {
                        throw new IllegalArgumentException("Multiple matches found for " + partialPath + ". Please provide a more specific path, for example by including a version number.");
                    }
                    foundPath = path;
                }
            }
            if (foundPath != null) {
                return foundPath;
            }
        } else {
            Set paths = reflections.getStore().getResources(partialPath);
            if (paths.size() > 1) {
                throw new IllegalArgumentException("Multiple matches found for " + partialPath + ". Please provide a more specific path, for example by including a version number.");
            }
            if (paths.size() > 0) {
                return (String)paths.iterator().next();
            }
        }
        throw new IllegalArgumentException(partialPath + " could not be found. Make sure you've added the corresponding WebJar and please check for typos.");
    }

    public static String getWebJarPath(String partialPath) {
        String fullPath = AssetLocator.getFullPath(partialPath);
        if (fullPath != null) {
            String prefix = WEBJARS_PATH_PREFIX[0] + "/" + WEBJARS_PATH_PREFIX[1] + "/";
            return fullPath.substring(prefix.length());
        }
        return null;
    }

    public static Set<String> listAssets(String folderPath) {
        if (!folderPath.startsWith("/")) {
            folderPath = "/" + folderPath;
        }
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().addUrls((Collection)ClasspathHelper.forPackage((String)StringUtils.join((Object[])WEBJARS_PATH_PREFIX, (String)"."), (ClassLoader[])new ClassLoader[]{AssetLocator.class.getClassLoader()})).setScanners(new Scanner[]{new ResourcesScanner()});
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Map allResources = reflections.getStore().getStoreMap();
        HashSet<String> resources = new HashSet<String>();
        for (Multimap multimap : allResources.values()) {
            for (String resource : multimap.values()) {
                if (!resource.startsWith(StringUtils.join((Object[])WEBJARS_PATH_PREFIX, (String)"/") + folderPath)) continue;
                resources.add(resource);
            }
        }
        return resources;
    }
}

