/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebJarAssetLocator {
    public static final String WEBJARS_PACKAGE = "META-INF.resources.webjars";
    public static final String WEBJARS_PATH_PREFIX = "META-INF/resources/webjars";
    final SortedMap<String, String> fullPathIndex;

    private static Set<String> getAssetPaths(Pattern filterExpr, ClassLoader ... classLoaders) {
        ConfigurationBuilder config = new ConfigurationBuilder().addUrls((Collection)ClasspathHelper.forPackage((String)WEBJARS_PACKAGE, (ClassLoader[])classLoaders)).setScanners(new Scanner[]{new ResourcesScanner()});
        Reflections reflections = new Reflections((Configuration)config);
        return reflections.getStore().getResources(filterExpr);
    }

    public static SortedMap<String, String> getFullPathIndex(Pattern filterExpr, ClassLoader ... classLoaders) {
        Set<String> assetPaths = WebJarAssetLocator.getAssetPaths(filterExpr, classLoaders);
        TreeMap<String, String> assetPathIndex = new TreeMap<String, String>();
        for (String assetPath : assetPaths) {
            assetPathIndex.put(WebJarAssetLocator.reversePath(assetPath), assetPath);
        }
        return assetPathIndex;
    }

    private static String reversePath(String assetPath) {
        String[] assetPathComponents = assetPath.split("/");
        StringBuilder reversedAssetPath = new StringBuilder();
        for (int i = assetPathComponents.length - 1; i >= 0; --i) {
            if (reversedAssetPath.length() > 0) {
                reversedAssetPath.append('/');
            }
            reversedAssetPath.append(assetPathComponents[i]);
        }
        return reversedAssetPath.toString();
    }

    public WebJarAssetLocator() {
        this(WebJarAssetLocator.getFullPathIndex(Pattern.compile(".*"), WebJarAssetLocator.class.getClassLoader()));
    }

    public WebJarAssetLocator(SortedMap<String, String> fullPathIndex) {
        this.fullPathIndex = fullPathIndex;
    }

    public String getFullPath(String partialPath) {
        String reversePartialPath = WebJarAssetLocator.reversePath(partialPath);
        SortedMap<String, String> fullPathTail = this.fullPathIndex.tailMap(reversePartialPath);
        if (fullPathTail.size() == 0) {
            throw new IllegalArgumentException(partialPath + " could not be found. Make sure you've added the corresponding WebJar and please check for typos.");
        }
        Iterator<Map.Entry<String, String>> fullPathTailIter = fullPathTail.entrySet().iterator();
        String fullPath = fullPathTailIter.next().getValue();
        if (fullPathTailIter.hasNext() && fullPathTailIter.next().getKey().startsWith(reversePartialPath)) {
            throw new IllegalArgumentException("Multiple matches found for " + partialPath + ". Please provide a more specific path, for example by including a version number.");
        }
        return fullPath;
    }

    public SortedMap<String, String> getFullPathIndex() {
        return this.fullPathIndex;
    }

    public Set<String> listAssets(String folderPath) {
        Collection<String> allAssets = this.fullPathIndex.values();
        HashSet<String> assets = new HashSet<String>();
        for (String asset : allAssets) {
            if (!asset.startsWith(WEBJARS_PATH_PREFIX + folderPath)) continue;
            assets.add(asset);
        }
        return assets;
    }
}

