/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.webjars.LevenshteinDistanceComparator;
import org.webjars.WebJarAssetLocator;
import org.webjars.WebJarPath;
import org.webjars.WebJarVersion;
import org.xml.sax.SAXException;

public final class RequireJS {
    public static final String WEBJARS_MAVEN_PREFIX = "META-INF/maven/org.webjars";
    private static final Logger log = LoggerFactory.getLogger(RequireJS.class);
    private static final Pattern DOT = Pattern.compile("\\.");
    private static String requireConfigJavaScript;
    private static String requireConfigJavaScriptCdn;
    private static Map<String, ObjectNode> requireConfigJson;
    private static Map<String, ObjectNode> requireConfigJsonCdn;

    private RequireJS() {
    }

    @Nonnull
    public static synchronized String getSetupJavaScript(@Nullable String urlPrefix) {
        if (requireConfigJavaScript == null) {
            requireConfigJavaScript = RequireJS.generateSetupJavaScript(Collections.singletonList(urlPrefix));
        }
        return requireConfigJavaScript;
    }

    @Nonnull
    public static synchronized String getSetupJavaScript(@Nullable String cdnPrefix, @Nullable String urlPrefix) {
        if (requireConfigJavaScriptCdn == null) {
            ArrayList<String> prefixes = new ArrayList<String>(2);
            prefixes.add(cdnPrefix);
            prefixes.add(urlPrefix);
            requireConfigJavaScriptCdn = RequireJS.generateSetupJavaScript(prefixes);
        }
        return requireConfigJavaScriptCdn;
    }

    @Nonnull
    public static String generateSetupJavaScript(@Nonnull Collection<String> prefixes) {
        Map webJars = new WebJarAssetLocator().getWebJars();
        return RequireJS.generateSetupJavaScript(prefixes, webJars);
    }

    @Nonnull
    public static String generateSetupJavaScript(@Nonnull Collection<String> prefixes, @Nonnull Map<String, String> webJars) {
        List<Map.Entry<String, Boolean>> prefixesWithVersion = prefixes.stream().map(prefix -> new AbstractMap.SimpleEntry<String, Boolean>((String)prefix, true)).collect(Collectors.toList());
        ArrayList<WebJarVersion> versions = new ArrayList<WebJarVersion>(webJars.size());
        StringBuilder webJarConfigsString = new StringBuilder();
        ArrayList<String> requireJsConfigs = new ArrayList<String>(webJars.size());
        if (webJars.isEmpty()) {
            log.warn("Can't find any WebJars in the classpath, RequireJS configuration will be empty.");
        } else {
            for (Map.Entry<String, String> webJar : webJars.entrySet()) {
                versions.add(new WebJarVersion(webJar.getKey(), webJar.getValue()));
                ObjectNode webJarObjectNode = RequireJS.getWebJarSetupJson(webJar, prefixesWithVersion);
                if ((webJarObjectNode != null ? webJarObjectNode.size() : 0) == 0) {
                    webJarConfigsString.append('\n').append(RequireJS.getWebJarConfig(webJar));
                    continue;
                }
                requireJsConfigs.add(webJarObjectNode.toString());
            }
        }
        ArrayList<WebJarPath> webJarPaths = new ArrayList<WebJarPath>(prefixes.size());
        Iterator<String> iterator = prefixes.iterator();
        while (iterator.hasNext()) {
            String prefix2 = iterator.next();
            webJarPaths.add(new WebJarPath(prefix2, iterator.hasNext()));
        }
        HashMap<String, Serializable> context = new HashMap<String, Serializable>(5);
        context.put("versions", versions);
        context.put("webJarPaths", webJarPaths);
        context.put("requireJsConfigs", requireJsConfigs);
        context.put("webJarConfigsString", webJarConfigsString);
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile("setup-template.mustache");
        StringWriter writer = new StringWriter();
        mustache.execute((Writer)writer, context);
        return writer.toString();
    }

    @Nonnull
    public static synchronized Map<String, ObjectNode> getSetupJson(@Nullable String urlPrefix) {
        if (requireConfigJson == null) {
            requireConfigJson = RequireJS.generateSetupJson(Collections.singletonList(new AbstractMap.SimpleEntry<String, Boolean>(urlPrefix, true)));
        }
        return requireConfigJson;
    }

    @Nonnull
    public static synchronized Map<String, ObjectNode> getSetupJson(@Nullable String cdnPrefix, @Nullable String urlPrefix) {
        if (requireConfigJsonCdn == null) {
            ArrayList<Map.Entry<String, Boolean>> prefixes = new ArrayList<Map.Entry<String, Boolean>>(2);
            prefixes.add(new AbstractMap.SimpleEntry<String, Boolean>(cdnPrefix, true));
            prefixes.add(new AbstractMap.SimpleEntry<String, Boolean>(urlPrefix, true));
            requireConfigJsonCdn = RequireJS.generateSetupJson(prefixes);
        }
        return requireConfigJsonCdn;
    }

    @Nonnull
    public static Map<String, ObjectNode> generateSetupJson(@Nonnull List<Map.Entry<String, Boolean>> prefixes) {
        Map webJars = new WebJarAssetLocator().getWebJars();
        HashMap<String, ObjectNode> jsonConfigs = new HashMap<String, ObjectNode>(webJars.size());
        for (Map.Entry<String, String> entry : webJars.entrySet()) {
            jsonConfigs.put((String)entry.getKey(), RequireJS.getWebJarSetupJson(entry, prefixes));
        }
        return jsonConfigs;
    }

    @Nullable
    private static ObjectNode getWebJarSetupJson(@Nonnull Map.Entry<String, String> webJar, @Nonnull List<Map.Entry<String, Boolean>> prefixes) {
        if (RequireJS.class.getClassLoader().getResource("META-INF/maven/org.webjars.npm/" + webJar.getKey() + "/pom.xml") != null) {
            return RequireJS.getNpmWebJarRequireJsConfig(webJar, prefixes);
        }
        if (RequireJS.class.getClassLoader().getResource("META-INF/maven/org.webjars.bower/" + webJar.getKey() + "/pom.xml") != null) {
            return RequireJS.getBowerWebJarRequireJsConfig(webJar, prefixes);
        }
        if (RequireJS.class.getClassLoader().getResource("META-INF/maven/org.webjars/" + webJar.getKey() + "/pom.xml") != null) {
            return RequireJS.getWebJarRequireJsConfig(webJar, prefixes);
        }
        return null;
    }

    public static ObjectNode getWebJarRequireJsConfig(Map.Entry<String, String> webJar, List<Map.Entry<String, Boolean>> prefixes) {
        ObjectNode webJarRequireJsNode;
        block19: {
            String rawRequireJsConfig = RequireJS.getRawWebJarRequireJsConfig(webJar);
            ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            webJarRequireJsNode = mapper.createObjectNode();
            try {
                JsonNode maybeRequireJsConfig = mapper.readTree(rawRequireJsConfig);
                if (maybeRequireJsConfig != null && maybeRequireJsConfig.isObject()) {
                    webJarRequireJsNode = (ObjectNode)maybeRequireJsConfig;
                    if (webJarRequireJsNode.isObject()) {
                        ObjectNode pathsNode = (ObjectNode)webJarRequireJsNode.get("paths");
                        ObjectNode newPaths = mapper.createObjectNode();
                        if (pathsNode != null) {
                            Iterator paths = pathsNode.fields();
                            while (paths.hasNext()) {
                                Map.Entry pathNode = (Map.Entry)paths.next();
                                String originalPath = null;
                                if (((JsonNode)pathNode.getValue()).isArray()) {
                                    ArrayNode nodePaths = (ArrayNode)pathNode.getValue();
                                    originalPath = nodePaths.get(0).asText();
                                } else if (((JsonNode)pathNode.getValue()).isTextual()) {
                                    TextNode nodePath = (TextNode)pathNode.getValue();
                                    originalPath = nodePath.textValue();
                                }
                                if (originalPath != null) {
                                    ArrayNode newPathsNode = newPaths.putArray((String)pathNode.getKey());
                                    for (Map.Entry<String, Boolean> prefix : prefixes) {
                                        StringBuilder newPath = new StringBuilder(prefix.getKey()).append(webJar.getKey());
                                        if (prefix.getValue().booleanValue()) {
                                            newPath.append('/').append(webJar.getValue());
                                        }
                                        newPathsNode.add(newPath.append('/').append(originalPath).toString());
                                    }
                                    newPathsNode.add(originalPath);
                                    continue;
                                }
                                log.error("Strange... The path could not be parsed.  Here is what was provided: {}", (Object)((JsonNode)pathNode.getValue()).toString());
                            }
                        }
                        webJarRequireJsNode.replace("paths", (JsonNode)newPaths);
                        ArrayNode packagesNode = webJarRequireJsNode.withArray("packages");
                        ArrayNode newPackages = mapper.createArrayNode();
                        if (packagesNode != null) {
                            for (JsonNode packageJson : packagesNode) {
                                String originalLocation = packageJson.get("location").textValue();
                                if (!prefixes.isEmpty()) {
                                    Map.Entry<String, Boolean> prefix;
                                    prefix = prefixes.get(prefixes.size() - 1);
                                    StringBuilder newLocation = new StringBuilder(prefix.getKey()).append(webJar.getKey());
                                    if (prefix.getValue().booleanValue()) {
                                        newLocation.append('/').append(webJar.getValue());
                                    }
                                    ((ObjectNode)packageJson).put("location", newLocation.append('/').append(originalLocation).toString());
                                }
                                newPackages.add(packageJson);
                            }
                        }
                        webJarRequireJsNode.replace("packages", (JsonNode)newPackages);
                    }
                } else if (rawRequireJsConfig.isEmpty()) {
                    log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
                } else {
                    log.error(RequireJS.requireJsConfigErrorMessage(webJar));
                }
            }
            catch (IOException e) {
                log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
                if (rawRequireJsConfig.isEmpty()) break block19;
                log.error(e.getMessage());
            }
        }
        return webJarRequireJsNode;
    }

    public static ObjectNode getBowerWebJarRequireJsConfig(Map.Entry<String, String> webJar, List<Map.Entry<String, Boolean>> prefixes) {
        String bowerJsonPath = String.format("%s/%s/%s/bower.json", "META-INF/resources/webjars", webJar.getKey(), webJar.getValue());
        return RequireJS.getWebJarRequireJsConfigFromMainConfig(webJar, prefixes, bowerJsonPath);
    }

    public static ObjectNode getNpmWebJarRequireJsConfig(Map.Entry<String, String> webJar, List<Map.Entry<String, Boolean>> prefixes) {
        String packageJsonPath = String.format("%s/%s/%s/package.json", "META-INF/resources/webjars", webJar.getKey(), webJar.getValue());
        return RequireJS.getWebJarRequireJsConfigFromMainConfig(webJar, prefixes, packageJsonPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ObjectNode getWebJarRequireJsConfigFromMainConfig(Map.Entry<String, String> webJar, List<Map.Entry<String, Boolean>> prefixes, String path) {
        InputStream inputStream = RequireJS.class.getClassLoader().getResourceAsStream(path);
        if (inputStream != null) {
            try {
                ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
                ObjectNode requireConfig = mapper.createObjectNode();
                ObjectNode requireConfigPaths = requireConfig.putObject("paths");
                JsonNode jsonNode = mapper.readTree(inputStream);
                String name = jsonNode.get("name").asText();
                String requireFriendlyName = DOT.matcher(name).replaceAll("-");
                JsonNode mainJs = jsonNode.get("main");
                if (mainJs != null) {
                    if (mainJs.getNodeType() == JsonNodeType.STRING) {
                        String main = mainJs.asText();
                        requireConfigPaths.set(requireFriendlyName, RequireJS.mainJsToPathJson(webJar, main, prefixes));
                    } else if (mainJs.getNodeType() == JsonNodeType.ARRAY) {
                        ArrayList<String> mainList = new ArrayList<String>(mainJs.size());
                        for (JsonNode mainJsonNode : mainJs) {
                            mainList.add(mainJsonNode.asText());
                        }
                        String main = RequireJS.getBowerBestMatchFromMainArray(mainList, name);
                        requireConfigPaths.set(requireFriendlyName, RequireJS.mainJsToPathJson(webJar, main, prefixes));
                    }
                } else if (RequireJS.hasIndexFile(String.format("%s/%s/%s/index.js", "META-INF/resources/webjars", webJar.getKey(), webJar.getValue()))) {
                    requireConfigPaths.set(requireFriendlyName, RequireJS.mainJsToPathJson(webJar, "index.js", prefixes));
                } else {
                    throw new IllegalArgumentException("no 'main' nor 'index.js' file; cannot generate a config");
                }
                ObjectNode objectNode = requireConfig;
                return objectNode;
            }
            catch (IOException e) {
                log.warn("Could not create the RequireJS config for the {} {} WebJar from {}\nError: {}\nPlease file a bug at: http://github.com/webjars/webjars-locator/issues/new", new Object[]{webJar.getKey(), webJar.getValue(), path, e.getMessage()});
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not create the RequireJS config for the {} {} WebJar from {}\nThere was not enough information in the package metadata to do so.\nError: {}\nIf you think you have received this message in error, please file a bug at: http://github.com/webjars/webjars-locator/issues/new", new Object[]{webJar.getKey(), webJar.getValue(), path, e.getMessage()});
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private static boolean hasIndexFile(String path) {
        return RequireJS.class.getClassLoader().getResource(path) != null;
    }

    private static String getBowerBestMatchFromMainArray(ArrayList<String> items, String name) {
        if (items.size() == 1) {
            return items.get(0);
        }
        ArrayList<Object> filteredList = new ArrayList<String>(items.size());
        for (String item : items) {
            if (!item.toLowerCase(Locale.ENGLISH).endsWith(".js")) continue;
            filteredList.add(item);
        }
        if (filteredList.isEmpty()) {
            filteredList = items;
        }
        filteredList.sort(new LevenshteinDistanceComparator(name.toLowerCase(Locale.ENGLISH)));
        return (String)filteredList.get(0);
    }

    private static JsonNode mainJsToPathJson(Map.Entry<String, String> webJar, String main, Iterable<Map.Entry<String, Boolean>> prefixes) {
        String requireJsStyleMain = main;
        if (main.endsWith(".js")) {
            requireJsStyleMain = main.substring(0, main.lastIndexOf(".js"));
        }
        if (requireJsStyleMain.startsWith("./")) {
            requireJsStyleMain = requireJsStyleMain.substring(2);
        }
        String unprefixedMain = String.format("%s/%s/%s", webJar.getKey(), webJar.getValue(), requireJsStyleMain);
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        for (Map.Entry<String, Boolean> prefix : prefixes) {
            arrayNode.add(String.format("%s%s", prefix.getKey(), unprefixedMain));
        }
        return arrayNode;
    }

    private static String requireJsConfigErrorMessage(Map.Entry<String, String> webJar) {
        return String.format("Could not read WebJar RequireJS config for: %s %s\nPlease file a bug at: http://github.com/webjars/%s/issues/new", webJar.getKey(), webJar.getValue(), webJar.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String getRawWebJarRequireJsConfig(@Nonnull Map.Entry<String, String> webJar) {
        String filename = String.format("%s/%s/pom.xml", WEBJARS_MAVEN_PREFIX, webJar.getKey());
        InputStream inputStream = RequireJS.class.getClassLoader().getResourceAsStream(filename);
        if (inputStream != null) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(inputStream);
                doc.getDocumentElement().normalize();
                NodeList propertiesNodes = doc.getElementsByTagName("properties");
                for (int i = 0; i < propertiesNodes.getLength(); ++i) {
                    NodeList propertyNodes = propertiesNodes.item(i).getChildNodes();
                    for (int j = 0; j < propertyNodes.getLength(); ++j) {
                        Node node = propertyNodes.item(j);
                        if (!"requirejs".equals(node.getNodeName())) continue;
                        String string = node.getTextContent();
                        return string;
                    }
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
        }
        return "";
    }

    @Deprecated
    @Nullable
    public static String getWebJarConfig(@Nonnull Map.Entry<String, String> webJar) {
        String filename = String.format("%s/%s/%s/webjars-requirejs.js", "META-INF/resources/webjars", webJar.getKey(), webJar.getValue());
        InputStream inputStream = RequireJS.class.getClassLoader().getResourceAsStream(filename);
        if (inputStream != null) {
            log.warn("The {} {} WebJar is using the legacy RequireJS config.\nPlease try a new version of the WebJar or file or file an issue at:\nhttp://github.com/webjars/{}/issues/new", new Object[]{webJar.getKey(), webJar.getValue(), webJar.getKey()});
            String fileContent = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            if (StringUtils.isBlank((CharSequence)fileContent)) {
                return null;
            }
            return "// WebJar config for " + webJar.getKey() + '\n' + fileContent.trim();
        }
        return null;
    }
}

