/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.webjars.MavenCentral;

@Mojo(name="install", requiresProject=true, requiresDirectInvocation=true)
public class InstallMojo
extends AbstractMojo {
    @Parameter(property="webjar", required=true)
    private String webjar;
    @Component
    private MavenProject project;
    @Component
    private ModelWriter modelWriter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] split = this.webjar.split(":");
        String artifact = split[0];
        DefaultArtifactVersion requestedVersion = split.length >= 2 ? new DefaultArtifactVersion(split[1]) : null;
        Collection versions = MavenCentral.getArtifacts(artifact, (ArtifactVersion)requestedVersion, this.getLog()).get((Object)artifact);
        ArtifactVersion resolvedVersion = null;
        if (requestedVersion == null) {
            resolvedVersion = (ArtifactVersion)versions.iterator().next();
        } else {
            for (ArtifactVersion artifactVersion : versions) {
                if (!artifactVersion.equals(requestedVersion)) continue;
                resolvedVersion = artifactVersion;
                break;
            }
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId("org.webjars");
        dependency.setArtifactId(artifact);
        dependency.setVersion(resolvedVersion.toString());
        Dependency updatedDependency = null;
        Iterator existingDependencies = this.project.getOriginalModel().getDependencies().iterator();
        while (existingDependencies.hasNext()) {
            Dependency existingDependency = (Dependency)existingDependencies.next();
            if (!existingDependency.getGroupId().equals(dependency.getGroupId()) || !existingDependency.getArtifactId().equals(dependency.getArtifactId())) continue;
            if (existingDependency.getVersion().equals(dependency.getVersion())) {
                this.getLog().warn((CharSequence)(artifact + ":" + dependency.getVersion() + " is already a dependency. Aborting."));
                return;
            }
            updatedDependency = existingDependency;
            existingDependencies.remove();
            break;
        }
        this.project.getOriginalModel().addDependency(dependency);
        try {
            this.modelWriter.write(this.project.getFile(), null, this.project.getOriginalModel());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not add dependency", (Exception)e);
        }
        if (updatedDependency != null) {
            this.getLog().info((CharSequence)("Updated " + artifact + " from " + updatedDependency.getVersion() + " to " + resolvedVersion));
        } else {
            this.getLog().info((CharSequence)("Added dependency: " + artifact + ":" + resolvedVersion));
        }
    }
}

