/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Comparator;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenCentral {
    public static Multimap<String, ArtifactVersion> getArtifacts(String artifact, ArtifactVersion version, Log log) {
        String query = "g:\"org.webjars\"";
        if (artifact != null) {
            query = query + " AND a:\"" + artifact + "\"";
        }
        if (version != null) {
            query = query + " AND v:\"" + version + "\"";
        }
        HttpRequest req = HttpRequest.get((CharSequence)"http://search.maven.org/solrsearch/select", (boolean)true, (Object[])new Object[]{"q", query, "core", "gav", "rows", 500, "wt", "json"});
        JsonObject json = (JsonObject)new Gson().fromJson(req.body(), JsonObject.class);
        JsonArray docs = json.getAsJsonObject("response").getAsJsonArray("docs");
        TreeMultimap artifacts = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)new Comparator<ArtifactVersion>(){

            @Override
            public int compare(ArtifactVersion version1, ArtifactVersion version2) {
                return version2.compareTo((Object)version1);
            }
        });
        for (JsonElement doc : docs) {
            JsonObject gav = doc.getAsJsonObject();
            String artifactId = gav.get("a").getAsString();
            if (artifactId.startsWith("webjars-")) continue;
            artifacts.put((Object)artifactId, (Object)new DefaultArtifactVersion(gav.get("v").getAsString()));
        }
        if (artifacts.isEmpty()) {
            MavenCentral.reportNoWebJarsFound(artifact, version, log);
        }
        return artifacts;
    }

    public static void reportNoWebJarsFound(String artifact, ArtifactVersion version, Log log) {
        String errorMessage = "No WebJar found matching " + artifact + (version != null ? ":" + version : "");
        log.error((CharSequence)errorMessage);
    }
}

