/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugin.logging.Log;
import org.webjars.MavenCentral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebJars {
    private final Log log;

    public WebJars(Log log) {
        this.log = log;
    }

    public Multimap<String, ArtifactVersion> list(final String webjar) {
        Multimap artifacts = MavenCentral.getArtifacts(null, null, this.log);
        if ((artifacts = Multimaps.filterEntries(artifacts, (Predicate)new Predicate<Map.Entry<String, ArtifactVersion>>(){

            public boolean apply(Map.Entry<String, ArtifactVersion> entry) {
                return webjar == null || entry.getKey().contains(webjar);
            }
        })).isEmpty()) {
            MavenCentral.reportNoWebJarsFound(webjar, null, this.log);
            return artifacts;
        }
        StringBuilder sb = new StringBuilder("Found the following artifacts in Maven Central:\n");
        TreeSet artifactNames = artifacts.keySet();
        if (webjar != null && artifacts.containsKey((Object)webjar)) {
            artifactNames = new TreeSet(artifacts.keySet());
            artifactNames.remove(webjar);
            sb.append(webjar).append(" [");
            for (ArtifactVersion version : artifacts.get((Object)webjar)) {
                sb.append(" ").append(version).append(" ");
            }
            sb.append("]\n");
        }
        for (String artifact : artifactNames) {
            sb.append(artifact).append(" [");
            for (ArtifactVersion version : artifacts.get((Object)artifact)) {
                sb.append(" ").append(version).append(" ");
            }
            sb.append("]\n");
        }
        this.log.info((CharSequence)sb);
        return artifacts;
    }

    public void install(String webJar) {
        CommandLine commandLine = CommandLine.parse((String)("mvn org.webjars:webjars-maven-plugin:install -Dwebjar=" + webJar));
        try {
            new DefaultExecutor().execute(commandLine);
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Could not install " + webJar), (Throwable)e);
        }
    }

    public void help() {
        this.log.info((CharSequence)"Available commands:");
        this.log.info((CharSequence)"list <webJar>\n\tLists all available WebJars.");
        this.log.info((CharSequence)"\tCan be used from any directory.");
        this.log.info((CharSequence)"\tThe optional parameter filters the results.");
        this.log.info((CharSequence)"install <webJar>\n\tAdds the given WebJar to the project's dependencies or updates an existing dependency.");
        this.log.info((CharSequence)"\tMust be used from a Maven project directory.");
        this.log.info((CharSequence)"\tThe required parameter specifies which WebJar to install.");
        this.log.info((CharSequence)"\tThe format is: <name>[:<version>]. If there is no version, the latest version is used.");
    }
}

