/*
 * Decompiled with CFR 0.152.
 */
package org.webjars.play;

import java.io.Serializable;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.webjars.WebJarAssetLocator;
import org.webjars.play.routes;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.mvc.Call;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001%\u00111bV3c\u0015\u0006\u00148/\u0016;jY*\u00111\u0001B\u0001\u0005a2\f\u0017P\u0003\u0002\u0006\r\u00059q/\u001a2kCJ\u001c(\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0003\u0005\u0012\u0001\t\u0005\t\u0015!\u0003\u0013\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u00111cF\u0007\u0002))\u0011QCF\u0001\u0004CBL'\"A\u0002\n\u0005a!\"!D\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0003-)gN^5s_:lWM\u001c;\u0011\u0005Ma\u0012BA\u000f\u0015\u0005-)eN^5s_:lWM\u001c;\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\r\t3\u0005\n\t\u0003E\u0001i\u0011A\u0001\u0005\u0006#y\u0001\rA\u0005\u0005\u00065y\u0001\ra\u0007\u0015\u0003=\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\r%t'.Z2u\u0015\u0005Y\u0013!\u00026bm\u0006D\u0018BA\u0017)\u0005\u0019IeN[3di\"Aq\u0006\u0001EC\u0002\u0013\u0005\u0001'\u0001\txK\nT\u0015M\u001d$jYR,'/\u0012=qeV\t\u0011\u0007\u0005\u00023s9\u00111g\u000e\t\u0003i1i\u0011!\u000e\u0006\u0003m!\ta\u0001\u0010:p_Rt\u0014B\u0001\u001d\r\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ab\u0001\u0002C\u001f\u0001\u0011\u000b\u0007I\u0011\u0001\u0019\u0002\r\r$g.\u0016:m\u0011!y\u0004\u0001#b\u0001\n\u0003\u0001\u0015AB;tK\u000e#g.F\u0001B!\tY!)\u0003\u0002D\u0019\t9!i\\8mK\u0006t\u0007\u0002C#\u0001\u0011\u000b\u0007I\u0011\u0002$\u0002%],'MS1s\u0003N\u001cX\r\u001e'pG\u0006$xN]\u000b\u0002\u000fB\u0011\u0001*S\u0007\u0002\t%\u0011!\n\u0002\u0002\u0013/\u0016\u0014'*\u0019:BgN,G\u000fT8dCR|'\u000fC\u0003M\u0001\u0011\u0005Q*\u0001\u0004m_\u000e\fG/\u001a\u000b\u0003\u001dR\u00032a\u0014*2\u001b\u0005\u0001&BA)\r\u0003\u0011)H/\u001b7\n\u0005M\u0003&a\u0001+ss\")Qk\u0013a\u0001c\u0005!a-\u001b7f\u0011\u0015a\u0005\u0001\"\u0001X)\rq\u0005L\u0017\u0005\u00063Z\u0003\r!M\u0001\u0007o\u0016\u0014'*\u0019:\t\u000bm3\u0006\u0019A\u0019\u0002\tA\fG\u000f\u001b\u0005\u0006;\u0002!\tAX\u0001\tMVdG\u000eU1uQR\u0019ajX1\t\u000b\u0001d\u0006\u0019A\u0019\u0002\r],'M[1s\u0011\u0015YF\f1\u00012\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0003\u001d9'o\\;q\u0013\u0012$\"AT3\t\u000bm\u0013\u0007\u0019A\u0019\t\u000b\u001d\u0004A\u0011\u00015\u0002\u001b1|7-\u00197Pe\u000e#g.\u0016:m)\tq\u0015\u000eC\u0003kM\u0002\u0007a*A\u0004qCRDGK]=\t\u000b1\u0004A\u0011A7\u0002\u0007U\u0014H\u000e\u0006\u0002O]\")1l\u001ba\u0001c!)A\u000e\u0001C\u0001aR\u0019a*\u001d:\t\u000be{\u0007\u0019A\u0019\t\u000bm{\u0007\u0019A\u0019\t\u000bQ\u0004A\u0011A;\u0002\u0007Q\fw\r\u0006\u0002wyR\u0011\u0011g\u001e\u0005\u0006qN\u0004\r!_\u0001\u0002MB!1B_\u00192\u0013\tYHBA\u0005Gk:\u001cG/[8oc!)Qp\u001da\u0001\u001d\u00061QO\u001d7UefDaa \u0001\u0005\u0002\u0005\u0005\u0011AB:de&\u0004H\u000fF\u00032\u0003\u0007\t)\u0001C\u0003~}\u0002\u0007a\nC\u0005\u0002\by\u0004\n\u00111\u0001\u0002\n\u0005Yq\u000e\u001e5feB\u000b'/Y7t!\u0015\u0011\u00141B\u00192\u0013\r\tia\u000f\u0002\u0004\u001b\u0006\u0004\bBB@\u0001\t\u0003\t\t\u0002F\u00022\u0003'A\u0001\"!\u0006\u0002\u0010\u0001\u0007\u0011qC\u0001\u0005G\u0006dG\u000e\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\u0002F\u0001\u0004[Z\u001c\u0017\u0002BA\u0011\u00037\u0011AaQ1mY\"1q\u0010\u0001C\u0001\u0003K!2!MA\u0014\u0011\u0019Y\u00161\u0005a\u0001c!1q\u0010\u0001C\u0001\u0003W!R!MA\u0017\u0003_Aa!WA\u0015\u0001\u0004\t\u0004BB.\u0002*\u0001\u0007\u0011\u0007C\u0004\u00024\u0001!\t!!\u000e\u0002!M\u001c'/\u001b9u/&$\b\u000eU1sC6\u001cHcB\u0019\u00028\u0005e\u00121\b\u0005\u00073\u0006E\u0002\u0019A\u0019\t\rm\u000b\t\u00041\u00012\u0011!\t9!!\rA\u0002\u0005%\u0001bBA \u0001\u0011\u0005\u0011\u0011I\u0001\u0004GN\u001cHcA\u0019\u0002D!1Q0!\u0010A\u00029Cq!a\u0010\u0001\t\u0003\t9\u0005F\u00022\u0003\u0013B\u0001\"!\u0006\u0002F\u0001\u0007\u0011q\u0003\u0005\b\u0003\u007f\u0001A\u0011AA')\r\t\u0014q\n\u0005\u00077\u0006-\u0003\u0019A\u0019\t\u000f\u0005}\u0002\u0001\"\u0001\u0002TQ)\u0011'!\u0016\u0002X!1\u0011,!\u0015A\u0002EBaaWA)\u0001\u0004\t\u0004bBA.\u0001\u0011\u0005\u0011QL\u0001\ne\u0016\fX/\u001b:f\u0015N$2!MA0\u0011!\t\t'!\u0017A\u0002\u0005]\u0011aB7bS:,&\u000f\u001c\u0005\n\u0003K\u0002\u0011\u0013!C\u0001\u0003O\n\u0001c]2sSB$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%$\u0006BA\u0005\u0003WZ#!!\u001c\u0011\t\u0005=\u0014\u0011P\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003ob\u0011AC1o]>$\u0018\r^5p]&!\u00111PA9\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0004\u0001\u0005}\u0004cA\u0014\u0002\u0002&\u0019\u00111\u0011\u0015\u0003\u0013MKgn\u001a7fi>t\u0007")
public class WebJarsUtil {
    private String webJarFilterExpr;
    private String cdnUrl;
    private boolean useCdn;
    private WebJarAssetLocator webJarAssetLocator;
    private final Configuration configuration;
    private final Environment environment;
    private volatile byte bitmap$0;

    private String webJarFilterExpr$lzycompute() {
        WebJarsUtil webJarsUtil = this;
        synchronized (webJarsUtil) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.webJarFilterExpr = (String)this.configuration.getOptional("webjars.filter-expression", ConfigLoader$.MODULE$.stringLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".*");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.webJarFilterExpr;
    }

    public String webJarFilterExpr() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.webJarFilterExpr$lzycompute() : this.webJarFilterExpr;
    }

    private String cdnUrl$lzycompute() {
        WebJarsUtil webJarsUtil = this;
        synchronized (webJarsUtil) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cdnUrl = (String)this.configuration.getOptional("webjars.cdn-url", ConfigLoader$.MODULE$.stringLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "https://cdn.jsdelivr.net/webjars");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.cdnUrl;
    }

    public String cdnUrl() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.cdnUrl$lzycompute() : this.cdnUrl;
    }

    private boolean useCdn$lzycompute() {
        WebJarsUtil webJarsUtil = this;
        synchronized (webJarsUtil) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.useCdn = BoxesRunTime.unboxToBoolean((Object)this.configuration.getOptional("webjars.use-cdn", ConfigLoader$.MODULE$.booleanLoader()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.useCdn;
    }

    public boolean useCdn() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.useCdn$lzycompute() : this.useCdn;
    }

    private WebJarAssetLocator webJarAssetLocator$lzycompute() {
        WebJarsUtil webJarsUtil = this;
        synchronized (webJarsUtil) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.webJarAssetLocator = new WebJarAssetLocator(WebJarAssetLocator.getFullPathIndex((Pattern)new Regex(this.webJarFilterExpr(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).pattern(), (ClassLoader[])new ClassLoader[]{this.environment.classLoader()}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.webJarAssetLocator;
    }

    private WebJarAssetLocator webJarAssetLocator() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.webJarAssetLocator$lzycompute() : this.webJarAssetLocator;
    }

    public Try<String> locate(String file) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(this.webJarAssetLocator().getFullPath(file))).stripPrefix("META-INF/resources/webjars/"));
    }

    public Try<String> locate(String webJar, String path) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(this.webJarAssetLocator().getFullPath(webJar, path))).stripPrefix("META-INF/resources/webjars/"));
    }

    public Try<String> fullPath(String webjar, String path) {
        Try versionTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)this.webJarAssetLocator().getWebJars().get(webjar));
        return versionTry.map((Function1 & Serializable & scala.Serializable)version -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{webjar, version, path})));
    }

    public Try<String> groupId(String path) {
        String webJar = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).head();
        String suffix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/pom.xml"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{webJar}));
        String prefix = "META-INF/maven/";
        Try fullPathTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.webJarAssetLocator().getFullPath(suffix));
        return fullPathTry.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(x$1)).stripSuffix(suffix))).stripPrefix(prefix));
    }

    public Try<String> localOrCdnUrl(Try<String> pathTry) {
        return pathTry.flatMap((Function1 & Serializable & scala.Serializable)path -> {
            Success success;
            if (this.useCdn()) {
                Try<String> groupIdTry = this.groupId((String)path);
                success = groupIdTry.map((Function1 & Serializable & scala.Serializable)groupId -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cdnUrl(), groupId, path})));
            } else {
                success = new Success((Object)routes.WebJarAssets.at((String)path).url());
            }
            return success;
        });
    }

    public Try<String> url(String path) {
        return this.localOrCdnUrl(this.locate(path));
    }

    public Try<String> url(String webJar, String path) {
        return this.localOrCdnUrl(this.locate(webJar, path));
    }

    public String tag(Try<String> urlTry, Function1<String, String> f) {
        String string;
        Try<String> try_ = urlTry;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String url = (String)success.value();
            string = (String)f.apply((Object)url);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            Logger$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> "Could not get URL", (Function0 & Serializable & scala.Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
            Mode mode = this.environment.mode();
            String string2 = Mode.Prod$.MODULE$.equals(mode) ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<!-- Could not get URL: ", " -->"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()}));
            string = string2;
        } else {
            throw new MatchError(try_);
        }
        return string;
    }

    public String script(Try<String> urlTry, Map<String, String> otherParams) {
        return this.tag(urlTry, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)url -> {
            String params = ((TraversableOnce)otherParams.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, value}));
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).mkString(" ");
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<script src=\"", "\" ", "></script>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, params}));
        });
    }

    public String script(Call call) {
        return this.script((Try<String>)new Success((Object)call.url()), this.script$default$2());
    }

    public String script(String path) {
        return this.script(this.url(path), this.script$default$2());
    }

    public String script(String webJar, String path) {
        return this.script(this.url(webJar, path), this.script$default$2());
    }

    public Map<String, String> script$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public String scriptWithParams(String webJar, String path, Map<String, String> otherParams) {
        return this.script(this.url(webJar, path), otherParams);
    }

    public String css(Try<String> urlTry) {
        return this.tag(urlTry, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)url -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<link rel=\"stylesheet\" type=\"text/css\" href=\"", "\">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
    }

    public String css(Call call) {
        return this.css((Try<String>)new Success((Object)call.url()));
    }

    public String css(String path) {
        return this.css(this.url(path));
    }

    public String css(String webJar, String path) {
        return this.css(this.url(webJar, path));
    }

    public String requireJs(Call mainUrl) {
        String setup = this.script(routes.RequireJS.setup());
        String main = this.scriptWithParams("requirejs", "require.min.js", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"data-main"), (Object)mainUrl.url())}))));
        return setup + main;
    }

    @Inject
    public WebJarsUtil(Configuration configuration, Environment environment) {
        this.configuration = configuration;
        this.environment = environment;
    }
}

