/*
 * Decompiled with CFR 0.152.
 */
package org.webjars.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebjarsServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(WebjarsServlet.class.getName());
    private static final long DEFAULT_EXPIRE_TIME_MS = 86400000L;
    private static final long DEFAULT_EXPIRE_TIME_S = 86400L;
    private boolean disableCache = false;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        if (config == null) {
            throw new NullPointerException("Expected servlet container to provide a non-null ServletConfig.");
        }
        try {
            String disableCache = config.getInitParameter("disableCache");
            if (disableCache != null) {
                this.disableCache = Boolean.parseBoolean(disableCache);
                logger.log(Level.INFO, "WebjarsServlet cache enabled: " + !this.disableCache);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "The WebjarsServlet configuration parameter \"disableCache\" is invalid");
        }
        logger.log(Level.INFO, "WebjarsServlet initialization completed");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String webjarsResourceURI = "/META-INF/resources" + request.getRequestURI().replaceFirst(request.getContextPath(), "");
        logger.log(Level.INFO, "Webjars resource requested: " + webjarsResourceURI);
        String eTagName = this.getETagName(webjarsResourceURI);
        if (!this.disableCache && (this.checkETagMatch(request, eTagName) || this.checkLastModify(request))) {
            response.setStatus(304);
            return;
        }
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(webjarsResourceURI);
        if (inputStream != null) {
            if (!this.disableCache) {
                this.prepareCacheHeaders(response, eTagName);
            }
            String filename = this.getFileName(webjarsResourceURI);
            String mimeType = request.getSession().getServletContext().getMimeType(filename);
            response.setContentType(mimeType != null ? mimeType : "application/octet-stream");
            WebjarsServlet.copy(inputStream, (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404);
        }
    }

    private String getFileName(String webjarsResourceURI) {
        String[] tokens = webjarsResourceURI.split("/");
        return tokens[tokens.length - 1];
    }

    private String getETagName(String webjarsResourceURI) {
        String[] tokens = webjarsResourceURI.split("/");
        String version = tokens[5];
        String fileName = tokens[tokens.length - 1];
        String eTag = fileName + "_" + version;
        return eTag;
    }

    private boolean checkETagMatch(HttpServletRequest request, String eTagName) {
        String token = request.getHeader("If-None-Match");
        return token == null ? false : token.equals(eTagName);
    }

    private boolean checkLastModify(HttpServletRequest request) {
        long last = request.getDateHeader("If-Modified-Since");
        return last == -1L ? false : last - System.currentTimeMillis() > 0L;
    }

    private void prepareCacheHeaders(HttpServletResponse response, String eTag) {
        response.setHeader("ETag", eTag);
        response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
        response.addDateHeader("Last-Modified", System.currentTimeMillis() + 86400000L);
        response.addHeader("Cache-Control", "private, max-age=86400");
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        int n = 0;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }
}

