/*
 * Decompiled with CFR 0.152.
 */
package org.webjars.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebjarsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(WebjarsServlet.class.getName());
    private static final long DEFAULT_EXPIRE_TIME_MS = 86400000L;
    private static final long DEFAULT_EXPIRE_TIME_S = 86400L;
    private boolean disableCache = false;
    private Object webJarAssetLocator;
    private Method getFullPathExact;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        if (config == null) {
            throw new NullPointerException("Expected servlet container to provide a non-null ServletConfig.");
        }
        try {
            String disableCache = config.getInitParameter("disableCache");
            if (disableCache != null) {
                this.disableCache = Boolean.parseBoolean(disableCache);
                logger.log(Level.INFO, "WebjarsServlet cache enabled: {0}", !this.disableCache);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "The WebjarsServlet configuration parameter \"disableCache\" is invalid");
        }
        try {
            Class<?> webJarAssetLocatorClass = Class.forName("org.webjars.WebJarAssetLocator");
            this.webJarAssetLocator = webJarAssetLocatorClass.newInstance();
            this.getFullPathExact = webJarAssetLocatorClass.getMethod("getFullPathExact", String.class, String.class);
            logger.log(Level.INFO, "The webjars-locator-core library is present, WebjarsServlet will try to resolve the version of requested WebJar assets (for the version agnostic way of working)");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "The webjars-locator-core library is not present, WebjarsServlet will not try to resolve the version of requested WebJar assets (for the version agnostic way of working)");
        }
        logger.log(Level.INFO, "WebjarsServlet initialization completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String eTagName;
        String webjarsURI = request.getRequestURI().replaceFirst(request.getContextPath(), "");
        String webjarsResourceURI = "/META-INF/resources" + webjarsURI;
        logger.log(Level.FINE, "Webjars resource requested: {0}", webjarsResourceURI);
        if (WebjarsServlet.isDirectoryRequest(webjarsResourceURI)) {
            response.sendError(403);
            return;
        }
        if (this.webJarAssetLocator != null) {
            String path = webjarsURI.substring(request.getServletPath().length());
            logger.log(Level.FINE, "Try to resolve version for path: {0}", path);
            int startOffset = path.startsWith("/") ? 1 : 0;
            int endOffset = path.indexOf(47, 1);
            if (endOffset != -1) {
                String webjar = path.substring(startOffset, endOffset);
                String partialPath = path.substring(endOffset + 1);
                String webJarPath = null;
                try {
                    webJarPath = (String)this.getFullPathExact.invoke(this.webJarAssetLocator, webjar, partialPath);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "This should not happen", e);
                }
                if (webJarPath != null) {
                    webjarsResourceURI = "/" + webJarPath;
                }
            }
        }
        try {
            eTagName = this.getETagName(webjarsResourceURI);
        }
        catch (IllegalArgumentException e) {
            response.sendError(404);
            return;
        }
        if (!this.disableCache && (this.checkETagMatch(request, eTagName) || this.checkLastModify(request))) {
            response.setStatus(304);
            return;
        }
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(webjarsResourceURI);
        if (inputStream != null) {
            try {
                if (!this.disableCache) {
                    this.prepareCacheHeaders(response, eTagName);
                }
                String filename = this.getFileName(webjarsResourceURI);
                String mimeType = this.getServletContext().getMimeType(filename);
                response.setContentType(mimeType != null ? mimeType : "application/octet-stream");
                WebjarsServlet.copy(inputStream, (OutputStream)response.getOutputStream());
            }
            finally {
                inputStream.close();
            }
        } else {
            response.sendError(404);
        }
    }

    private static boolean isDirectoryRequest(String uri) {
        return uri.endsWith("/");
    }

    private String getFileName(String webjarsResourceURI) {
        String[] tokens = webjarsResourceURI.split("/");
        return tokens[tokens.length - 1];
    }

    private String getETagName(String webjarsResourceURI) {
        String[] tokens = webjarsResourceURI.split("/");
        if (tokens.length < 7) {
            throw new IllegalArgumentException("insufficient URL has given: " + webjarsResourceURI);
        }
        String version = tokens[5];
        String fileName = tokens[tokens.length - 1];
        String eTag = fileName + "_" + version;
        return eTag;
    }

    private boolean checkETagMatch(HttpServletRequest request, String eTagName) {
        String token = request.getHeader("If-None-Match");
        return token == null ? false : token.equals(eTagName);
    }

    private boolean checkLastModify(HttpServletRequest request) {
        long last = request.getDateHeader("If-Modified-Since");
        return last == -1L ? false : last - System.currentTimeMillis() > 0L;
    }

    private void prepareCacheHeaders(HttpServletResponse response, String eTag) {
        response.setHeader("ETag", eTag);
        response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
        response.addDateHeader("Last-Modified", System.currentTimeMillis() + 86400000L);
        response.addHeader("Cache-Control", "private, max-age=86400");
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        int n = 0;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }
}

