# example.js

``` javascript
function getTemplate(templateName) {
	return require("./templates/"+templateName);
}
console.log(getTemplate("a"));
console.log(getTemplate("b"));
```

# templates/

* a.js
* b.js
* c.js

All templates are of this pattern:

``` javascript
module.exports = function() {
	return "This text was generated by template X";
}
```

# js/output.js

``` javascript
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "js/";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/*!********************!*\
  !*** ./example.js ***!
  \********************/
/***/ function(module, exports, __webpack_require__) {

	function getTemplate(templateName) {
		return __webpack_require__(/*! ./templates */ 1)("./"+templateName);
	}
	console.log(getTemplate("a"));
	console.log(getTemplate("b"));

/***/ },
/* 1 */
/*!****************************!*\
  !*** ./templates ^\.\/.*$ ***!
  \****************************/
/***/ function(module, exports, __webpack_require__) {

	var map = {
		"./a": 2,
		"./a.js": 2,
		"./b": 3,
		"./b.js": 3,
		"./c": 4,
		"./c.js": 4
	};
	function webpackContext(req) {
		return __webpack_require__(webpackContextResolve(req));
	};
	function webpackContextResolve(req) {
		return map[req] || (function() { throw new Error("Cannot find module '" + req + "'.") }());
	};
	webpackContext.keys = function webpackContextKeys() {
		return Object.keys(map);
	};
	webpackContext.resolve = webpackContextResolve;
	module.exports = webpackContext;
	webpackContext.id = 1;


/***/ },
/* 2 */
/*!************************!*\
  !*** ./templates/a.js ***!
  \************************/
/***/ function(module, exports) {

	module.exports = function() {
		return "This text was generated by template A";
	}

/***/ },
/* 3 */
/*!************************!*\
  !*** ./templates/b.js ***!
  \************************/
/***/ function(module, exports) {

	module.exports = function() {
		return "This text was generated by template B";
	}

/***/ },
/* 4 */
/*!************************!*\
  !*** ./templates/c.js ***!
  \************************/
/***/ function(module, exports) {

	module.exports = function() {
		return "This text was generated by template C";
	}

/***/ }
/******/ ]);
```

# Info

## Uncompressed

```
Hash: 41fd788e0ab4ea24848c
Version: webpack 1.9.10
Time: 77ms
    Asset     Size  Chunks             Chunk Names
output.js  3.05 kB       0  [emitted]  main
chunk    {0} output.js (main) 613 bytes [rendered]
    > main [0] ./example.js 
    [0] ./example.js 150 bytes {0} [built]
    [1] ./templates ^\.\/.*$ 217 bytes {0} [built]
        cjs require context ./templates [0] ./example.js 2:8-44
    [2] ./templates/a.js 82 bytes {0} [optional] [built]
        context element ./a.js [1] ./templates ^\.\/.*$
        context element ./a [1] ./templates ^\.\/.*$
    [3] ./templates/b.js 82 bytes {0} [optional] [built]
        context element ./b.js [1] ./templates ^\.\/.*$
        context element ./b [1] ./templates ^\.\/.*$
    [4] ./templates/c.js 82 bytes {0} [optional] [built]
        context element ./c.js [1] ./templates ^\.\/.*$
        context element ./c [1] ./templates ^\.\/.*$
```

## Minimized (uglify-js, no zip)

```
Hash: 532ec4ba9a9dceec08e2
Version: webpack 1.9.10
Time: 193ms
    Asset       Size  Chunks             Chunk Names
output.js  816 bytes       0  [emitted]  main
chunk    {0} output.js (main) 613 bytes [rendered]
    > main [0] ./example.js 
    [0] ./example.js 150 bytes {0} [built]
    [1] ./templates/a.js 82 bytes {0} [optional] [built]
        context element ./a.js [4] ./templates ^\.\/.*$
        context element ./a [4] ./templates ^\.\/.*$
    [2] ./templates/b.js 82 bytes {0} [optional] [built]
        context element ./b.js [4] ./templates ^\.\/.*$
        context element ./b [4] ./templates ^\.\/.*$
    [3] ./templates/c.js 82 bytes {0} [optional] [built]
        context element ./c.js [4] ./templates ^\.\/.*$
        context element ./c [4] ./templates ^\.\/.*$
    [4] ./templates ^\.\/.*$ 217 bytes {0} [built]
        cjs require context ./templates [0] ./example.js 2:8-44
```

# Code Splitting

See [this example combined with code splitting](../code-splitted-require.context)
