(function($){
	var webshims = window.webshims;

	setTimeout(function(){
		webshims.isReady('geolocation', true);
	});
	var domWrite = function(){
			setTimeout(function(){
				throw('document.write is overwritten by geolocation shim. This method is incompatible with this plugin');
			}, 1);
		},
		id = 0
	;
	var geoOpts = webshims.cfg.geolocation || {};
	if(!navigator.geolocation){
		navigator.geolocation = {};
	}
	$.extend(navigator.geolocation, (function(){
		var pos;
		var api = {
			getCurrentPosition: function(success, error, opts){
				var locationAPIs = 2,
					errorTimer,
					googleTimer,
					calledEnd,
					createAjax,
					endCallback = function(){
						if(calledEnd){return;}
						if(pos){
							calledEnd = true;
							success($.extend({timestamp: new Date().getTime()}, pos));
							resetCallback();
							if(window.JSON && window.sessionStorage){
								try{
									sessionStorage.setItem('storedGeolocationData654321', JSON.stringify(pos));
								} catch(e){}
							}
						} else if(error && !locationAPIs) {
							calledEnd = true;
							resetCallback();
							error({ code: 2, message: "POSITION_UNAVAILABLE"});
						}
					},
					googleCallback = function(){
						locationAPIs--;
						getGoogleCoords();
						endCallback();
					},
					resetCallback = function(){
						$(document).off('google-loader', resetCallback);
						clearTimeout(googleTimer);
						clearTimeout(errorTimer);
					},
					getGoogleCoords = function(){
						if(pos || !window.google || !google.loader || !google.loader.ClientLocation){return false;}
						var cl = google.loader.ClientLocation;
						pos = {
							coords: {
								latitude: cl.latitude,
							longitude: cl.longitude,
								altitude: null,
								accuracy: 43000,
								altitudeAccuracy: null,
								heading: parseInt('NaN', 10),
								velocity: null
							},
							//extension similiar to FF implementation
							address: $.extend({streetNumber: '', street: '', premises: '', county: '', postalCode: ''}, cl.address)
						};
						return true;
					},
					getInitCoords = function(){
						if(pos){return;}
						getGoogleCoords();
						if(pos || !window.JSON || !window.sessionStorage){return;}
						try{
							pos = sessionStorage.getItem('storedGeolocationData654321');
							pos = (pos) ? JSON.parse(pos) : false;
							if(!pos.coords){pos = false;} 
						} catch(e){
							pos = false;
						}
					}
				;
				
				getInitCoords();
				
				if(!pos){
					if(geoOpts.confirmText && !confirm(geoOpts.confirmText.replace('{location}', location.hostname))){
						if(error){
							error({ code: 1, message: "PERMISSION_DENIED"});
						}
						return;
					}
					createAjax = function(){
						$.ajax({
							url: 'http://freegeoip.net/json/',
							dataType: 'jsonp',
							cache: true,
							jsonp: 'callback',
							success: function(data){
								locationAPIs--;
								if(!data){return;}
								pos = pos || {
									coords: {
										latitude: data.latitude,
										longitude: data.longitude,
										altitude: null,
										accuracy: 43000,
										altitudeAccuracy: null,
										heading: parseInt('NaN', 10),
										velocity: null
									},
									//extension similiar to FF implementation
									address: {
										city: data.city,
										country: data.country_name,
										countryCode: data.country_code,
										county: "",
										postalCode: data.zipcode,
										premises: "",
										region: data.region_name,
										street: "",
										streetNumber: ""
									}
								};
								endCallback();
							},
							error: function(){
								locationAPIs--;
								endCallback();
							}
						});
					};
					if($.ajax){
						createAjax();
					} else {
						webshims.ready('jajax', createAjax);
						webshims.loader.loadList(['jajax']);
					}
					clearTimeout(googleTimer);
					if (!window.google || !window.google.loader) {
						googleTimer = setTimeout(function(){
							//destroys document.write!!!
							if (geoOpts.destroyWrite) {
								document.write = domWrite;
								document.writeln = domWrite;
							}
							$(document).one('google-loader', googleCallback);
							webshims.loader.loadScript('http://www.google.com/jsapi', false, 'google-loader');
						}, 800);
					} else {
						locationAPIs--;
					}
				} else {
					setTimeout(endCallback, 1);
					return;
				}
				if(opts && opts.timeout){
					errorTimer = setTimeout(function(){
						resetCallback();
						if(error) {
							error({ code: 3, message: "TIMEOUT"});
						}
					}, opts.timeout);
				} else {
					errorTimer = setTimeout(function(){
						locationAPIs = 0;
						endCallback();
					}, 10000);
				}
			},
			clearWatch: $.noop
		};
		api.watchPosition = function(a, b, c){
			api.getCurrentPosition(a, b, c);
			id++;
			return id;
		};
		return api;
	})());
	
	webshims.ready('WINDOWLOAD', function(){
		webshims.loader.loadList(['jajax']);
	});
	webshims.isReady('geolocation', true);
})(webshims.$);
