/*
YUI 3.11.0 (build d549e5c)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/datatype-date-math/datatype-date-math.js']) {
   __coverage__['build/datatype-date-math/datatype-date-math.js'] = {"path":"build/datatype-date-math/datatype-date-math.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0},"b":{"1":[0,0],"2":[0,0,0,0,0],"3":[0,0,0],"4":[0,0,0],"5":[0,0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":30},"end":{"line":1,"column":49}}},"2":{"name":"(anonymous_2)","line":21,"loc":{"start":{"line":21,"column":16},"end":{"line":21,"column":33}}},"3":{"name":"(anonymous_3)","line":39,"loc":{"start":{"line":39,"column":12},"end":{"line":39,"column":36}}},"4":{"name":"(anonymous_4)","line":51,"loc":{"start":{"line":51,"column":16},"end":{"line":51,"column":40}}},"5":{"name":"(anonymous_5)","line":65,"loc":{"start":{"line":65,"column":23},"end":{"line":65,"column":47}}},"6":{"name":"(anonymous_6)","line":79,"loc":{"start":{"line":79,"column":16},"end":{"line":79,"column":47}}},"7":{"name":"(anonymous_7)","line":92,"loc":{"start":{"line":92,"column":11},"end":{"line":92,"column":37}}},"8":{"name":"(anonymous_8)","line":106,"loc":{"start":{"line":106,"column":13},"end":{"line":106,"column":41}}},"9":{"name":"(anonymous_9)","line":129,"loc":{"start":{"line":129,"column":12},"end":{"line":129,"column":39}}},"10":{"name":"(anonymous_10)","line":145,"loc":{"start":{"line":145,"column":25},"end":{"line":145,"column":42}}},"11":{"name":"(anonymous_11)","line":172,"loc":{"start":{"line":172,"column":16},"end":{"line":172,"column":33}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":207,"column":41}},"2":{"start":{"line":10,"column":0},"end":{"line":10,"column":18}},"3":{"start":{"line":12,"column":0},"end":{"line":201,"column":3}},"4":{"start":{"line":22,"column":2},"end":{"line":27,"column":9}},"5":{"start":{"line":23,"column":12},"end":{"line":23,"column":24}},"6":{"start":{"line":26,"column":12},"end":{"line":26,"column":25}},"7":{"start":{"line":40,"column":2},"end":{"line":40,"column":102}},"8":{"start":{"line":52,"column":5},"end":{"line":52,"column":104}},"9":{"start":{"line":66,"column":5},"end":{"line":66,"column":105}},"10":{"start":{"line":80,"column":5},"end":{"line":80,"column":89}},"11":{"start":{"line":93,"column":2},"end":{"line":93,"column":54}},"12":{"start":{"line":107,"column":2},"end":{"line":107,"column":36}},"13":{"start":{"line":108,"column":2},"end":{"line":108,"column":46}},"14":{"start":{"line":110,"column":2},"end":{"line":110,"column":49}},"15":{"start":{"line":111,"column":2},"end":{"line":111,"column":39}},"16":{"start":{"line":113,"column":2},"end":{"line":113,"column":43}},"17":{"start":{"line":114,"column":2},"end":{"line":114,"column":31}},"18":{"start":{"line":115,"column":2},"end":{"line":115,"column":29}},"19":{"start":{"line":117,"column":2},"end":{"line":117,"column":17}},"20":{"start":{"line":130,"column":2},"end":{"line":130,"column":47}},"21":{"start":{"line":131,"column":2},"end":{"line":131,"column":42}},"22":{"start":{"line":133,"column":2},"end":{"line":133,"column":31}},"23":{"start":{"line":134,"column":2},"end":{"line":134,"column":17}},"24":{"start":{"line":146,"column":7},"end":{"line":148,"column":8}},"25":{"start":{"line":147,"column":9},"end":{"line":147,"column":19}},"26":{"start":{"line":150,"column":7},"end":{"line":153,"column":28}},"27":{"start":{"line":155,"column":7},"end":{"line":157,"column":8}},"28":{"start":{"line":156,"column":11},"end":{"line":156,"column":61}},"29":{"start":{"line":159,"column":7},"end":{"line":159,"column":21}},"30":{"start":{"line":173,"column":2},"end":{"line":175,"column":3}},"31":{"start":{"line":174,"column":3},"end":{"line":174,"column":12}},"32":{"start":{"line":177,"column":2},"end":{"line":177,"column":29}},"33":{"start":{"line":178,"column":2},"end":{"line":178,"column":65}},"34":{"start":{"line":180,"column":2},"end":{"line":198,"column":5}},"35":{"start":{"line":181,"column":3},"end":{"line":181,"column":23}},"36":{"start":{"line":185,"column":3},"end":{"line":185,"column":34}},"37":{"start":{"line":186,"column":3},"end":{"line":197,"column":7}},"38":{"start":{"line":187,"column":10},"end":{"line":187,"column":20}},"39":{"start":{"line":189,"column":8},"end":{"line":197,"column":7}},"40":{"start":{"line":190,"column":7},"end":{"line":190,"column":17}},"41":{"start":{"line":192,"column":8},"end":{"line":197,"column":7}},"42":{"start":{"line":193,"column":10},"end":{"line":193,"column":20}},"43":{"start":{"line":196,"column":10},"end":{"line":196,"column":20}},"44":{"start":{"line":203,"column":0},"end":{"line":203,"column":24}},"45":{"start":{"line":204,"column":0},"end":{"line":204,"column":25}}},"branchMap":{"1":{"line":22,"type":"if","locations":[{"start":{"line":22,"column":2},"end":{"line":22,"column":2}},{"start":{"line":22,"column":2},"end":{"line":22,"column":2}}]},"2":{"line":22,"type":"binary-expr","locations":[{"start":{"line":22,"column":5},"end":{"line":22,"column":23}},{"start":{"line":22,"column":28},"end":{"line":22,"column":43}},{"start":{"line":22,"column":49},"end":{"line":22,"column":72}},{"start":{"line":22,"column":77},"end":{"line":22,"column":90}},{"start":{"line":22,"column":95},"end":{"line":22,"column":108}}]},"3":{"line":40,"type":"binary-expr","locations":[{"start":{"line":40,"column":10},"end":{"line":40,"column":33}},{"start":{"line":40,"column":37},"end":{"line":40,"column":60}},{"start":{"line":40,"column":65},"end":{"line":40,"column":99}}]},"4":{"line":52,"type":"binary-expr","locations":[{"start":{"line":52,"column":13},"end":{"line":52,"column":36}},{"start":{"line":52,"column":40},"end":{"line":52,"column":63}},{"start":{"line":52,"column":68},"end":{"line":52,"column":101}}]},"5":{"line":66,"type":"binary-expr","locations":[{"start":{"line":66,"column":13},"end":{"line":66,"column":36}},{"start":{"line":66,"column":40},"end":{"line":66,"column":63}},{"start":{"line":66,"column":68},"end":{"line":66,"column":102}}]},"6":{"line":80,"type":"binary-expr","locations":[{"start":{"line":80,"column":13},"end":{"line":80,"column":48}},{"start":{"line":80,"column":52},"end":{"line":80,"column":87}}]},"7":{"line":146,"type":"if","locations":[{"start":{"line":146,"column":7},"end":{"line":146,"column":7}},{"start":{"line":146,"column":7},"end":{"line":146,"column":7}}]},"8":{"line":173,"type":"if","locations":[{"start":{"line":173,"column":2},"end":{"line":173,"column":2}},{"start":{"line":173,"column":2},"end":{"line":173,"column":2}}]},"9":{"line":180,"type":"if","locations":[{"start":{"line":180,"column":2},"end":{"line":180,"column":2}},{"start":{"line":180,"column":2},"end":{"line":180,"column":2}}]},"10":{"line":186,"type":"if","locations":[{"start":{"line":186,"column":3},"end":{"line":186,"column":3}},{"start":{"line":186,"column":3},"end":{"line":186,"column":3}}]},"11":{"line":189,"type":"if","locations":[{"start":{"line":189,"column":8},"end":{"line":189,"column":8}},{"start":{"line":189,"column":8},"end":{"line":189,"column":8}}]},"12":{"line":192,"type":"if","locations":[{"start":{"line":192,"column":8},"end":{"line":192,"column":8}},{"start":{"line":192,"column":8},"end":{"line":192,"column":8}}]}},"code":["(function () { YUI.add('datatype-date-math', function (Y, NAME) {","","/**"," * Date Math submodule."," *"," * @module datatype-date"," * @submodule datatype-date-math"," * @for Date"," */","var LANG = Y.Lang;","","Y.mix(Y.namespace(\"Date\"), {","","\t/**","\t * Checks whether a native JavaScript Date contains a valid value.","\t * @for Date","\t * @method isValidDate","\t * @param oDate {Date} Date in the month for which the number of days is desired.","\t * @return {Boolean} True if the date argument contains a valid value.","\t */","\t isValidDate : function (oDate) {","\t\tif(LANG.isDate(oDate) && (isFinite(oDate)) && (oDate != \"Invalid Date\") && !isNaN(oDate) && (oDate != null)) {","            return true;","        }","        else {","            return false;","        }","\t},","","\t/**","\t * Checks whether two dates correspond to the same date and time.","\t * @for Date","\t * @method areEqual","\t * @param aDate {Date} The first date to compare.","\t * @param bDate {Date} The second date to compare.","\t * @return {Boolean} True if the two dates correspond to the same","\t * date and time.","\t */\t","\tareEqual : function (aDate, bDate) {","\t\treturn (this.isValidDate(aDate) && this.isValidDate(bDate) && (aDate.getTime() == bDate.getTime()));\t","\t},","","\t/**","\t * Checks whether the first date comes later than the second.","\t * @for Date","\t * @method isGreater","\t * @param aDate {Date} The first date to compare.","\t * @param bDate {Date} The second date to compare.","\t * @return {Boolean} True if the first date is later than the second.","\t */\t","    isGreater : function (aDate, bDate) {","    \treturn (this.isValidDate(aDate) && this.isValidDate(bDate) && (aDate.getTime() > bDate.getTime()));","    },","","\t/**","\t * Checks whether the first date comes later than or is the same as","\t * the second.","\t * @for Date","\t * @method isGreaterOrEqual","\t * @param aDate {Date} The first date to compare.","\t * @param bDate {Date} The second date to compare.","\t * @return {Boolean} True if the first date is later than or ","\t * the same as the second.","\t */\t","    isGreaterOrEqual : function (aDate, bDate) {","    \treturn (this.isValidDate(aDate) && this.isValidDate(bDate) && (aDate.getTime() >= bDate.getTime()));","    },","","","    /**","\t * Checks whether the date is between two other given dates.","\t * @for Date","\t * @method isInRange","\t * @param aDate {Date} The date to check","\t * @param bDate {Date} Lower bound of the range.","\t * @param cDate {Date} Higher bound of the range.","\t * @return {Boolean} True if the date is between the two other given dates.","\t */\t","    isInRange : function (aDate, bDate, cDate) {","    \treturn (this.isGreaterOrEqual(aDate, bDate) && this.isGreaterOrEqual(cDate, aDate));","    },","","\t/**","\t * Adds a specified number of days to the given date.","\t * @for Date","\t * @method addDays","\t * @param oDate {Date} The date to add days to.","\t * @param numDays {Number} The number of days to add (can be negative)","\t * @return {Date} A new Date with the specified number of days","\t * added to the original date.","\t */\t","\taddDays : function (oDate, numDays) {","\t\treturn new Date(oDate.getTime() + 86400000*numDays);","\t},","","","\t/**","\t * Adds a specified number of months to the given date.","\t * @for Date","\t * @method addMonths","\t * @param oDate {Date} The date to add months to.","\t * @param numMonths {Number} The number of months to add (can be negative)","\t * @return {Date} A new Date with the specified number of months","\t * added to the original date.","\t */\t","\taddMonths : function (oDate, numMonths) {","\t\tvar newYear = oDate.getFullYear();","\t\tvar newMonth = oDate.getMonth() + numMonths;\t\t","\t\t","\t\tnewYear  = Math.floor(newYear + newMonth / 12);","\t\tnewMonth = (newMonth % 12 + 12) % 12;","\t\t","\t\tvar newDate = new Date (oDate.getTime());","\t\tnewDate.setFullYear(newYear);","\t\tnewDate.setMonth(newMonth);","\t\t","\t\treturn newDate;","\t},","","\t/**","\t * Adds a specified number of years to the given date.","\t * @for Date","\t * @method addYears","\t * @param oDate {Date} The date to add years to.","\t * @param numYears {Number} The number of years to add (can be negative)","\t * @return {Date} A new Date with the specified number of years","\t * added to the original date.","\t */\t","\taddYears : function (oDate, numYears) {","\t\tvar newYear = oDate.getFullYear() + numYears;","\t\tvar newDate = new Date(oDate.getTime());","\t\t","\t\tnewDate.setFullYear(newYear);","\t\treturn newDate;","\t},","","\t/**","\t * Lists all dates in a given month.","\t * @for Date","\t * @method listOfDatesInMonth","\t * @param oDate {Date} The date corresponding to the month for","\t * which a list of dates is required.","\t * @return {Array} An `Array` of `Date`s from a given month.","\t */\t","    listOfDatesInMonth : function (oDate) {","       if (!this.isValidDate(oDate)) {","       \t return [];","       }","","       var daysInMonth = this.daysInMonth(oDate),","           year        = oDate.getFullYear(),","           month       = oDate.getMonth(),","           output      = [];","","       for (var day = 1; day <= daysInMonth; day++) {","       \t   output.push(new Date(year, month, day, 12, 0, 0));","       }","","       return output;","    },","","\t/**","\t * Takes a native JavaScript Date and returns the number of days","\t * in the month that the given date belongs to.","\t * @for Date","\t * @method daysInMonth","\t * @param oDate {Date} Date in the month for which the number ","\t * of days is desired.","\t * @return {Number} A number (either 28, 29, 30 or 31) of days ","\t * in the given month.","\t */","\t daysInMonth : function (oDate) {","\t\tif (!this.isValidDate(oDate)) {","\t\t\treturn 0;","\t\t}","\t\t","\t\tvar mon = oDate.getMonth();","\t\tvar lengths = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];","","\t\tif (mon != 1) {","\t\t\treturn lengths[mon];","\t\t}","\t\telse {","","\t\t\tvar year = oDate.getFullYear();","\t\t\tif (year%400 === 0) {","\t\t\t       return 29;","\t\t\t}\t","\t\t\telse if (year%100 === 0) {","\t\t\t\t   return 28;","\t\t\t}","\t\t\telse if (year%4 === 0) {","\t\t\t       return 29;","\t\t\t}","\t\t\telse {","\t\t\t       return 28;","\t\t    }","\t   } ","\t}","","});","","Y.namespace(\"DataType\");","Y.DataType.Date = Y.Date;","","","}, '3.11.0', {\"requires\": [\"yui-base\"]});","","}());"]};
}
var __cov_msloGZ_EyNhKYRQbqr47nQ = __coverage__['build/datatype-date-math/datatype-date-math.js'];
__cov_msloGZ_EyNhKYRQbqr47nQ.s['1']++;YUI.add('datatype-date-math',function(Y,NAME){__cov_msloGZ_EyNhKYRQbqr47nQ.f['1']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['2']++;var LANG=Y.Lang;__cov_msloGZ_EyNhKYRQbqr47nQ.s['3']++;Y.mix(Y.namespace('Date'),{isValidDate:function(oDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['2']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['4']++;if((__cov_msloGZ_EyNhKYRQbqr47nQ.b['2'][0]++,LANG.isDate(oDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['2'][1]++,isFinite(oDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['2'][2]++,oDate!='Invalid Date')&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['2'][3]++,!isNaN(oDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['2'][4]++,oDate!=null)){__cov_msloGZ_EyNhKYRQbqr47nQ.b['1'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['5']++;return true;}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['1'][1]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['6']++;return false;}},areEqual:function(aDate,bDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['3']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['7']++;return(__cov_msloGZ_EyNhKYRQbqr47nQ.b['3'][0]++,this.isValidDate(aDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['3'][1]++,this.isValidDate(bDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['3'][2]++,aDate.getTime()==bDate.getTime());},isGreater:function(aDate,bDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['4']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['8']++;return(__cov_msloGZ_EyNhKYRQbqr47nQ.b['4'][0]++,this.isValidDate(aDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['4'][1]++,this.isValidDate(bDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['4'][2]++,aDate.getTime()>bDate.getTime());},isGreaterOrEqual:function(aDate,bDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['5']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['9']++;return(__cov_msloGZ_EyNhKYRQbqr47nQ.b['5'][0]++,this.isValidDate(aDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['5'][1]++,this.isValidDate(bDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['5'][2]++,aDate.getTime()>=bDate.getTime());},isInRange:function(aDate,bDate,cDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['6']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['10']++;return(__cov_msloGZ_EyNhKYRQbqr47nQ.b['6'][0]++,this.isGreaterOrEqual(aDate,bDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['6'][1]++,this.isGreaterOrEqual(cDate,aDate));},addDays:function(oDate,numDays){__cov_msloGZ_EyNhKYRQbqr47nQ.f['7']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['11']++;return new Date(oDate.getTime()+86400000*numDays);},addMonths:function(oDate,numMonths){__cov_msloGZ_EyNhKYRQbqr47nQ.f['8']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['12']++;var newYear=oDate.getFullYear();__cov_msloGZ_EyNhKYRQbqr47nQ.s['13']++;var newMonth=oDate.getMonth()+numMonths;__cov_msloGZ_EyNhKYRQbqr47nQ.s['14']++;newYear=Math.floor(newYear+newMonth/12);__cov_msloGZ_EyNhKYRQbqr47nQ.s['15']++;newMonth=(newMonth%12+12)%12;__cov_msloGZ_EyNhKYRQbqr47nQ.s['16']++;var newDate=new Date(oDate.getTime());__cov_msloGZ_EyNhKYRQbqr47nQ.s['17']++;newDate.setFullYear(newYear);__cov_msloGZ_EyNhKYRQbqr47nQ.s['18']++;newDate.setMonth(newMonth);__cov_msloGZ_EyNhKYRQbqr47nQ.s['19']++;return newDate;},addYears:function(oDate,numYears){__cov_msloGZ_EyNhKYRQbqr47nQ.f['9']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['20']++;var newYear=oDate.getFullYear()+numYears;__cov_msloGZ_EyNhKYRQbqr47nQ.s['21']++;var newDate=new Date(oDate.getTime());__cov_msloGZ_EyNhKYRQbqr47nQ.s['22']++;newDate.setFullYear(newYear);__cov_msloGZ_EyNhKYRQbqr47nQ.s['23']++;return newDate;},listOfDatesInMonth:function(oDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['10']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['24']++;if(!this.isValidDate(oDate)){__cov_msloGZ_EyNhKYRQbqr47nQ.b['7'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['25']++;return[];}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['7'][1]++;}__cov_msloGZ_EyNhKYRQbqr47nQ.s['26']++;var daysInMonth=this.daysInMonth(oDate),year=oDate.getFullYear(),month=oDate.getMonth(),output=[];__cov_msloGZ_EyNhKYRQbqr47nQ.s['27']++;for(var day=1;day<=daysInMonth;day++){__cov_msloGZ_EyNhKYRQbqr47nQ.s['28']++;output.push(new Date(year,month,day,12,0,0));}__cov_msloGZ_EyNhKYRQbqr47nQ.s['29']++;return output;},daysInMonth:function(oDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['11']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['30']++;if(!this.isValidDate(oDate)){__cov_msloGZ_EyNhKYRQbqr47nQ.b['8'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['31']++;return 0;}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['8'][1]++;}__cov_msloGZ_EyNhKYRQbqr47nQ.s['32']++;var mon=oDate.getMonth();__cov_msloGZ_EyNhKYRQbqr47nQ.s['33']++;var lengths=[31,28,31,30,31,30,31,31,30,31,30,31];__cov_msloGZ_EyNhKYRQbqr47nQ.s['34']++;if(mon!=1){__cov_msloGZ_EyNhKYRQbqr47nQ.b['9'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['35']++;return lengths[mon];}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['9'][1]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['36']++;var year=oDate.getFullYear();__cov_msloGZ_EyNhKYRQbqr47nQ.s['37']++;if(year%400===0){__cov_msloGZ_EyNhKYRQbqr47nQ.b['10'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['38']++;return 29;}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['10'][1]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['39']++;if(year%100===0){__cov_msloGZ_EyNhKYRQbqr47nQ.b['11'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['40']++;return 28;}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['11'][1]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['41']++;if(year%4===0){__cov_msloGZ_EyNhKYRQbqr47nQ.b['12'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['42']++;return 29;}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['12'][1]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['43']++;return 28;}}}}}});__cov_msloGZ_EyNhKYRQbqr47nQ.s['44']++;Y.namespace('DataType');__cov_msloGZ_EyNhKYRQbqr47nQ.s['45']++;Y.DataType.Date=Y.Date;},'3.11.0',{'requires':['yui-base']});
