/*
YUI 3.11.0 (build d549e5c)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/event-tap/event-tap.js']) {
   __coverage__['build/event-tap/event-tap.js'] = {"path":"build/event-tap/event-tap.js","s":{"1":0,"2":0,"3":1,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":21},"end":{"line":1,"column":40}}},"2":{"name":"detachHelper","line":41,"loc":{"start":{"line":41,"column":0},"end":{"line":41,"column":62}}},"3":{"name":"(anonymous_3)","line":45,"loc":{"start":{"line":45,"column":26},"end":{"line":45,"column":56}}},"4":{"name":"(anonymous_4)","line":84,"loc":{"start":{"line":84,"column":8},"end":{"line":84,"column":48}}},"5":{"name":"(anonymous_5)","line":98,"loc":{"start":{"line":98,"column":12},"end":{"line":98,"column":52}}},"6":{"name":"(anonymous_6)","line":120,"loc":{"start":{"line":120,"column":14},"end":{"line":120,"column":62}}},"7":{"name":"(anonymous_7)","line":121,"loc":{"start":{"line":121,"column":63},"end":{"line":121,"column":76}}},"8":{"name":"(anonymous_8)","line":137,"loc":{"start":{"line":137,"column":20},"end":{"line":137,"column":60}}},"9":{"name":"(anonymous_9)","line":154,"loc":{"start":{"line":154,"column":16},"end":{"line":154,"column":73}}},"10":{"name":"(anonymous_10)","line":202,"loc":{"start":{"line":202,"column":15},"end":{"line":202,"column":81}}},"11":{"name":"(anonymous_11)","line":222,"loc":{"start":{"line":222,"column":14},"end":{"line":222,"column":80}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":256,"column":90}},"2":{"start":{"line":25,"column":0},"end":{"line":39,"column":6}},"3":{"start":{"line":41,"column":0},"end":{"line":53,"column":1}},"4":{"start":{"line":43,"column":4},"end":{"line":43,"column":94}},"5":{"start":{"line":45,"column":4},"end":{"line":51,"column":7}},"6":{"start":{"line":46,"column":8},"end":{"line":46,"column":40}},"7":{"start":{"line":47,"column":8},"end":{"line":50,"column":9}},"8":{"start":{"line":48,"column":12},"end":{"line":48,"column":28}},"9":{"start":{"line":49,"column":12},"end":{"line":49,"column":38}},"10":{"start":{"line":67,"column":0},"end":{"line":253,"column":3}},"11":{"start":{"line":85,"column":8},"end":{"line":85,"column":110}},"12":{"start":{"line":99,"column":8},"end":{"line":99,"column":44}},"13":{"start":{"line":121,"column":8},"end":{"line":123,"column":25}},"14":{"start":{"line":122,"column":12},"end":{"line":122,"column":67}},"15":{"start":{"line":138,"column":8},"end":{"line":138,"column":44}},"16":{"start":{"line":156,"column":8},"end":{"line":158,"column":14}},"17":{"start":{"line":162,"column":8},"end":{"line":164,"column":9}},"18":{"start":{"line":163,"column":12},"end":{"line":163,"column":19}},"19":{"start":{"line":167,"column":8},"end":{"line":169,"column":9}},"20":{"start":{"line":168,"column":12},"end":{"line":168,"column":19}},"21":{"start":{"line":171,"column":8},"end":{"line":171,"column":61}},"22":{"start":{"line":175,"column":8},"end":{"line":180,"column":9}},"23":{"start":{"line":176,"column":10},"end":{"line":176,"column":79}},"24":{"start":{"line":179,"column":10},"end":{"line":179,"column":57}},"25":{"start":{"line":183,"column":8},"end":{"line":183,"column":128}},"26":{"start":{"line":184,"column":8},"end":{"line":184,"column":125}},"27":{"start":{"line":185,"column":8},"end":{"line":185,"column":132}},"28":{"start":{"line":203,"column":8},"end":{"line":203,"column":97}},"29":{"start":{"line":204,"column":8},"end":{"line":204,"column":33}},"30":{"start":{"line":223,"column":8},"end":{"line":225,"column":21}},"31":{"start":{"line":229,"column":8},"end":{"line":236,"column":9}},"32":{"start":{"line":230,"column":10},"end":{"line":230,"column":83}},"33":{"start":{"line":231,"column":10},"end":{"line":231,"column":88}},"34":{"start":{"line":234,"column":10},"end":{"line":234,"column":47}},"35":{"start":{"line":235,"column":10},"end":{"line":235,"column":52}},"36":{"start":{"line":238,"column":8},"end":{"line":238,"column":97}},"37":{"start":{"line":241,"column":8},"end":{"line":251,"column":9}},"38":{"start":{"line":243,"column":12},"end":{"line":243,"column":33}},"39":{"start":{"line":244,"column":12},"end":{"line":244,"column":35}},"40":{"start":{"line":245,"column":12},"end":{"line":245,"column":35}},"41":{"start":{"line":246,"column":12},"end":{"line":246,"column":40}},"42":{"start":{"line":247,"column":12},"end":{"line":247,"column":40}},"43":{"start":{"line":248,"column":12},"end":{"line":248,"column":47}},"44":{"start":{"line":250,"column":12},"end":{"line":250,"column":33}}},"branchMap":{"1":{"line":27,"type":"binary-expr","locations":[{"start":{"line":27,"column":26},"end":{"line":27,"column":29}},{"start":{"line":27,"column":33},"end":{"line":27,"column":48}}]},"2":{"line":43,"type":"cond-expr","locations":[{"start":{"line":43,"column":23},"end":{"line":43,"column":30}},{"start":{"line":43,"column":33},"end":{"line":43,"column":93}}]},"3":{"line":47,"type":"if","locations":[{"start":{"line":47,"column":8},"end":{"line":47,"column":8}},{"start":{"line":47,"column":8},"end":{"line":47,"column":8}}]},"4":{"line":162,"type":"if","locations":[{"start":{"line":162,"column":8},"end":{"line":162,"column":8}},{"start":{"line":162,"column":8},"end":{"line":162,"column":8}}]},"5":{"line":162,"type":"binary-expr","locations":[{"start":{"line":162,"column":12},"end":{"line":162,"column":24}},{"start":{"line":162,"column":28},"end":{"line":162,"column":46}}]},"6":{"line":167,"type":"if","locations":[{"start":{"line":167,"column":8},"end":{"line":167,"column":8}},{"start":{"line":167,"column":8},"end":{"line":167,"column":8}}]},"7":{"line":167,"type":"binary-expr","locations":[{"start":{"line":167,"column":12},"end":{"line":167,"column":25}},{"start":{"line":167,"column":29},"end":{"line":167,"column":55}}]},"8":{"line":171,"type":"cond-expr","locations":[{"start":{"line":171,"column":34},"end":{"line":171,"column":53}},{"start":{"line":171,"column":56},"end":{"line":171,"column":60}}]},"9":{"line":175,"type":"if","locations":[{"start":{"line":175,"column":8},"end":{"line":175,"column":8}},{"start":{"line":175,"column":8},"end":{"line":175,"column":8}}]},"10":{"line":175,"type":"binary-expr","locations":[{"start":{"line":175,"column":12},"end":{"line":175,"column":28}},{"start":{"line":175,"column":32},"end":{"line":175,"column":45}}]},"11":{"line":229,"type":"if","locations":[{"start":{"line":229,"column":8},"end":{"line":229,"column":8}},{"start":{"line":229,"column":8},"end":{"line":229,"column":8}}]},"12":{"line":229,"type":"binary-expr","locations":[{"start":{"line":229,"column":12},"end":{"line":229,"column":28}},{"start":{"line":229,"column":32},"end":{"line":229,"column":52}}]},"13":{"line":241,"type":"if","locations":[{"start":{"line":241,"column":8},"end":{"line":241,"column":8}},{"start":{"line":241,"column":8},"end":{"line":241,"column":8}}]},"14":{"line":241,"type":"binary-expr","locations":[{"start":{"line":241,"column":12},"end":{"line":241,"column":49}},{"start":{"line":241,"column":53},"end":{"line":241,"column":90}}]}},"code":["(function () { YUI.add('event-tap', function (Y, NAME) {","","/**","The tap module provides a gesture events, \"tap\", which normalizes user interactions","across touch and mouse or pointer based input devices.  This can be used by application developers","to build input device agnostic components which behave the same in response to either touch or mouse based","interaction.","","'tap' is like a touchscreen 'click', only it requires much less finger-down time since it listens to touch events,","but reverts to mouse events if touch is not supported.","","@example","","    YUI().use('event-tap', function (Y) {","        Y.one('#my-button').on('tap', function (e) {","        });","    });","","@module event","@submodule event-tap","@author Andres Garza, matuzak and tilo mitra","@since 3.7.0","","*/","var doc = Y.config.doc,","    GESTURE_MAP = Y.Event._GESTURE_MAP,","    SUPPORTS_TOUCHES = !!(doc && doc.createTouch),","    EVT_START = GESTURE_MAP.start,","    EVT_MOVE = GESTURE_MAP.move,","    EVT_END = GESTURE_MAP.end,","    EVT_CANCEL = GESTURE_MAP.cancel,","    EVT_TAP = 'tap',","","    HANDLES = {","        START: 'Y_TAP_ON_START_HANDLE',","        MOVE: 'Y_TAP_ON_MOVE_HANDLE',","        END: 'Y_TAP_ON_END_HANDLE',","        CANCEL: 'Y_TAP_ON_CANCEL_HANDLE'","    };","","function detachHelper(subscription, handles, subset, context) {","","    handles = subset ? handles : [ handles.START, handles.MOVE, handles.END, handles.CANCEL ];","","    Y.Array.each(handles, function (item, index, array) {","        var handle = subscription[item];","        if (handle) {","            handle.detach();","            subscription[item] = null;","        }","    });","","}","","","/**","Sets up a \"tap\" event, that is fired on touch devices in response to a tap event (finger down, finder up).","This event can be used instead of listening for click events which have a 500ms delay on most touch devices.","This event can also be listened for using node.delegate().","","@event tap","@param type {string} \"tap\"","@param fn {function} The method the event invokes. It receives the event facade of the underlying DOM event.","@for Event","@return {EventHandle} the detach handle","*/","Y.Event.define(EVT_TAP, {","","    /**","    This function should set up the node that will eventually fire the event.","","    Usage:","","        node.on('tap', function (e) {","        });","","    @method on","    @param {Y.Node} node","    @param {Array} subscription","    @param {Boolean} notifier","    @public","    @static","    **/","    on: function (node, subscription, notifier) {","        subscription[HANDLES.START] = node.on(EVT_START, this.touchStart, this, node, subscription, notifier);","    },","","    /**","    Detaches all event subscriptions set up by the event-tap module","","    @method detach","    @param {Y.Node} node","    @param {Array} subscription","    @param {Boolean} notifier","    @public","    @static","    **/","    detach: function (node, subscription, notifier) {","        detachHelper(subscription, HANDLES);","    },","","    /**","    Event delegation for the 'tap' event. The delegated event will use a","    supplied selector or filtering function to test if the event references at least one","    node that should trigger the subscription callback.","","    Usage:","","        node.delegate('tap', function (e) {","        }, 'li a');","","    @method delegate","    @param {Y.Node} node","    @param {Array} subscription","    @param {Boolean} notifier","    @param {String | Function} filter","    @public","    @static","    **/","    delegate: function (node, subscription, notifier, filter) {","        subscription[HANDLES.START] = node.delegate(EVT_START, function (e) {","            this.touchStart(e, node, subscription, notifier, true);","        }, filter, this);","    },","","    /**","    Detaches the delegated event subscriptions set up by the event-tap module.","    Only used if you use node.delegate(...) instead of node.on(...);","","    @method detachDelegate","    @param {Y.Node} node","    @param {Array} subscription","    @param {Boolean} notifier","    @public","    @static","    **/","    detachDelegate: function (node, subscription, notifier) {","        detachHelper(subscription, HANDLES);","    },","","","    /**","    Called when the monitor(s) are tapped on, either through touchstart or mousedown.","","    @method touchStart","    @param {DOMEventFacade} event","    @param {Y.Node} node","    @param {Array} subscription","    @param {Boolean} notifier","    @param {Boolean} delegate","    @protected","    @static","    **/","    touchStart: function (event, node, subscription, notifier, delegate) {","","        var context = {","                canceled: false","            };","        //move ways to quit early to the top.","","        // no right clicks","        if (event.button && event.button === 3) {","            return;","        }","","        // for now just support a 1 finger count (later enhance via config)","        if (event.touches && event.touches.length !== 1) {","            return;","        }","","        context.node = delegate ? event.currentTarget : node;","","        //There is a double check in here to support event simulation tests, in which","        //event.touches can be undefined when simulating 'touchstart' on touch devices.","        if (SUPPORTS_TOUCHES && event.touches) {","          context.startXY = [ event.touches[0].pageX, event.touches[0].pageY ];","        }","        else {","          context.startXY = [ event.pageX, event.pageY ];","        }","","        //Possibly outdated issue: something is off with the move that it attaches it but never triggers the handler","        subscription[HANDLES.MOVE] = node.once(EVT_MOVE, this.touchMove, this, node, subscription, notifier, delegate, context);","        subscription[HANDLES.END] = node.once(EVT_END, this.touchEnd, this, node, subscription, notifier, delegate, context);","        subscription[HANDLES.CANCEL] = node.once(EVT_CANCEL, this.touchMove, this, node, subscription, notifier, delegate, context);","    },","","    /**","    Called when the monitor(s) fires a touchmove or touchcancel event (or the mouse equivalent).","    This method detaches event handlers so that 'tap' is not fired.","","    @method touchMove","    @param {DOMEventFacade} event","    @param {Y.Node} node","    @param {Array} subscription","    @param {Boolean} notifier","    @param {Boolean} delegate","    @param {Object} context","    @protected","    @static","    **/","    touchMove: function (event, node, subscription, notifier, delegate, context) {","        detachHelper(subscription, [ HANDLES.MOVE, HANDLES.END, HANDLES.CANCEL ], true, context);","        context.cancelled = true;","","    },","","    /**","    Called when the monitor(s) fires a touchend event (or the mouse equivalent).","    This method fires the 'tap' event if certain requirements are met.","","    @method touchEnd","    @param {DOMEventFacade} event","    @param {Y.Node} node","    @param {Array} subscription","    @param {Boolean} notifier","    @param {Boolean} delegate","    @param {Object} context","    @protected","    @static","    **/","    touchEnd: function (event, node, subscription, notifier, delegate, context) {","        var startXY = context.startXY,","            endXY,","            clientXY;","","        //There is a double check in here to support event simulation tests, in which","        //event.touches can be undefined when simulating 'touchstart' on touch devices.","        if (SUPPORTS_TOUCHES && event.changedTouches) {","          endXY = [ event.changedTouches[0].pageX, event.changedTouches[0].pageY ];","          clientXY = [event.changedTouches[0].clientX, event.changedTouches[0].clientY];","        }","        else {","          endXY = [ event.pageX, event.pageY ];","          clientXY = [event.clientX, event.clientY];","        }","","        detachHelper(subscription, [ HANDLES.MOVE, HANDLES.END, HANDLES.CANCEL ], true, context);","","        // make sure mouse didn't move","        if (Math.abs(endXY[0] - startXY[0]) === 0 && Math.abs(endXY[1] - startXY[1]) === 0) {","","            event.type = EVT_TAP;","            event.pageX = endXY[0];","            event.pageY = endXY[1];","            event.clientX = clientXY[0];","            event.clientY = clientXY[1];","            event.currentTarget = context.node;","","            notifier.fire(event);","        }","    }","});","","","}, '3.11.0', {\"requires\": [\"node-base\", \"event-base\", \"event-touch\", \"event-synthetic\"]});","","}());"]};
}
var __cov_jJ5snwfFMe7Fr06BIg4NfQ = __coverage__['build/event-tap/event-tap.js'];
__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['1']++;YUI.add('event-tap',function(Y,NAME){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['1']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['2']++;var doc=Y.config.doc,GESTURE_MAP=Y.Event._GESTURE_MAP,SUPPORTS_TOUCHES=!!((__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['1'][0]++,doc)&&(__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['1'][1]++,doc.createTouch)),EVT_START=GESTURE_MAP.start,EVT_MOVE=GESTURE_MAP.move,EVT_END=GESTURE_MAP.end,EVT_CANCEL=GESTURE_MAP.cancel,EVT_TAP='tap',HANDLES={START:'Y_TAP_ON_START_HANDLE',MOVE:'Y_TAP_ON_MOVE_HANDLE',END:'Y_TAP_ON_END_HANDLE',CANCEL:'Y_TAP_ON_CANCEL_HANDLE'};function detachHelper(subscription,handles,subset,context){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['2']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['4']++;handles=subset?(__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['2'][0]++,handles):(__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['2'][1]++,[handles.START,handles.MOVE,handles.END,handles.CANCEL]);__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['5']++;Y.Array.each(handles,function(item,index,array){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['3']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['6']++;var handle=subscription[item];__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['7']++;if(handle){__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['3'][0]++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['8']++;handle.detach();__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['9']++;subscription[item]=null;}else{__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['3'][1]++;}});}__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['10']++;Y.Event.define(EVT_TAP,{on:function(node,subscription,notifier){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['4']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['11']++;subscription[HANDLES.START]=node.on(EVT_START,this.touchStart,this,node,subscription,notifier);},detach:function(node,subscription,notifier){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['5']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['12']++;detachHelper(subscription,HANDLES);},delegate:function(node,subscription,notifier,filter){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['6']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['13']++;subscription[HANDLES.START]=node.delegate(EVT_START,function(e){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['7']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['14']++;this.touchStart(e,node,subscription,notifier,true);},filter,this);},detachDelegate:function(node,subscription,notifier){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['8']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['15']++;detachHelper(subscription,HANDLES);},touchStart:function(event,node,subscription,notifier,delegate){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['9']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['16']++;var context={canceled:false};__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['17']++;if((__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['5'][0]++,event.button)&&(__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['5'][1]++,event.button===3)){__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['4'][0]++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['18']++;return;}else{__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['4'][1]++;}__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['19']++;if((__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['7'][0]++,event.touches)&&(__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['7'][1]++,event.touches.length!==1)){__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['6'][0]++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['20']++;return;}else{__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['6'][1]++;}__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['21']++;context.node=delegate?(__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['8'][0]++,event.currentTarget):(__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['8'][1]++,node);__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['22']++;if((__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['10'][0]++,SUPPORTS_TOUCHES)&&(__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['10'][1]++,event.touches)){__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['9'][0]++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['23']++;context.startXY=[event.touches[0].pageX,event.touches[0].pageY];}else{__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['9'][1]++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['24']++;context.startXY=[event.pageX,event.pageY];}__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['25']++;subscription[HANDLES.MOVE]=node.once(EVT_MOVE,this.touchMove,this,node,subscription,notifier,delegate,context);__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['26']++;subscription[HANDLES.END]=node.once(EVT_END,this.touchEnd,this,node,subscription,notifier,delegate,context);__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['27']++;subscription[HANDLES.CANCEL]=node.once(EVT_CANCEL,this.touchMove,this,node,subscription,notifier,delegate,context);},touchMove:function(event,node,subscription,notifier,delegate,context){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['10']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['28']++;detachHelper(subscription,[HANDLES.MOVE,HANDLES.END,HANDLES.CANCEL],true,context);__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['29']++;context.cancelled=true;},touchEnd:function(event,node,subscription,notifier,delegate,context){__cov_jJ5snwfFMe7Fr06BIg4NfQ.f['11']++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['30']++;var startXY=context.startXY,endXY,clientXY;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['31']++;if((__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['12'][0]++,SUPPORTS_TOUCHES)&&(__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['12'][1]++,event.changedTouches)){__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['11'][0]++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['32']++;endXY=[event.changedTouches[0].pageX,event.changedTouches[0].pageY];__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['33']++;clientXY=[event.changedTouches[0].clientX,event.changedTouches[0].clientY];}else{__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['11'][1]++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['34']++;endXY=[event.pageX,event.pageY];__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['35']++;clientXY=[event.clientX,event.clientY];}__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['36']++;detachHelper(subscription,[HANDLES.MOVE,HANDLES.END,HANDLES.CANCEL],true,context);__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['37']++;if((__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['14'][0]++,Math.abs(endXY[0]-startXY[0])===0)&&(__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['14'][1]++,Math.abs(endXY[1]-startXY[1])===0)){__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['13'][0]++;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['38']++;event.type=EVT_TAP;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['39']++;event.pageX=endXY[0];__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['40']++;event.pageY=endXY[1];__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['41']++;event.clientX=clientXY[0];__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['42']++;event.clientY=clientXY[1];__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['43']++;event.currentTarget=context.node;__cov_jJ5snwfFMe7Fr06BIg4NfQ.s['44']++;notifier.fire(event);}else{__cov_jJ5snwfFMe7Fr06BIg4NfQ.b['13'][1]++;}}});},'3.11.0',{'requires':['node-base','event-base','event-touch','event-synthetic']});
